// Yoshi

// 0x0501C458
static const Lights1 yoshi_seg5_lights_0501C458 = gdSPDefLights1(
    0x00, 0x7c, 0x00,
    0x00, 0xf9, 0x00, 0x28, 0x28, 0x28
);

// 0x0501C470
static const Lights1 yoshi_seg5_lights_0501C470 = gdSPDefLights1(
    0x7f, 0x7f, 0x7f,
    0xff, 0xff, 0xff, 0x28, 0x28, 0x28
);

// 0x0501C488
static const Lights1 yoshi_seg5_lights_0501C488 = gdSPDefLights1(
    0x7f, 0x00, 0x00,
    0xff, 0x00, 0x00, 0x28, 0x28, 0x28
);

// 0x0501C4A0
ALIGNED8 static const u8 yoshi_seg5_texture_0501C4A0[] = {
#include "actors/yoshi/yoshi_eye.rgba16.inc.c"
};

// 0x0501C6A0
ALIGNED8 static const u8 yoshi_seg5_texture_0501C6A0[] = {
#include "actors/yoshi/yoshi_eye_blink.rgba16.inc.c"
};

// 0x0501C8A0
ALIGNED8 static const u8 yoshi_seg5_texture_0501C8A0[] = {
#include "actors/yoshi/yoshi_nostril.rgba16.inc.c"
};

// 0x0501CAA0
static const Vtx yoshi_seg5_vertex_0501CAA0[] = {
    {{{   174,    273,   -134}, 0, {  1177,    698}, {0x29, 0x20, 0x8d, 0xff}}},
    {{{   204,    356,    -45}, 0, {  -114,    749}, {0x30, 0x70, 0xe0, 0xff}}},
    {{{   279,    299,    -29}, 0, {  -189,   -676}, {0x71, 0x27, 0xd8, 0xff}}},
    {{{   279,    299,     29}, 0, {     7,   -694}, {0x65, 0x3e, 0x2b, 0xff}}},
    {{{   204,    356,     46}, 0, {  -133,    728}, {0x31, 0x68, 0x34, 0xff}}},
    {{{   174,    273,    124}, 0, {  1134,    645}, {0x2c, 0x23, 0x71, 0xff}}},
};

// 0x0501CB00
static const Vtx yoshi_seg5_vertex_0501CB00[] = {
    {{{   370,     89,     29}, 0, {   273,   -403}, {0x60, 0x52, 0x01, 0xff}}},
    {{{   332,     90,     -4}, 0, {   -10,   -163}, {0x32, 0x74, 0x02, 0xff}}},
    {{{   260,    123,     -7}, 0, {     0,    287}, {0x69, 0x45, 0x02, 0xff}}},
    {{{   199,    115,     54}, 0, {   480,    667}, {0x46, 0x2e, 0x5e, 0xff}}},
    {{{   209,     86,     84}, 0, {   734,    602}, {0x13, 0x3a, 0x6f, 0xff}}},
    {{{   349,     69,     76}, 0, {   669,   -268}, {0x34, 0x23, 0x6e, 0xff}}},
    {{{   199,    115,    -77}, 0, {   577,    687}, {0x41, 0x29, 0x9c, 0xff}}},
    {{{   260,    123,     -7}, 0, {     5,    301}, {0x69, 0x45, 0x02, 0xff}}},
    {{{   370,     89,    -29}, 0, {   208,   -415}, {0x5f, 0x53, 0x05, 0xff}}},
    {{{   349,     69,    -92}, 0, {   728,   -281}, {0x35, 0x14, 0x8f, 0xff}}},
    {{{   332,     90,     -4}, 0, {    -2,   -165}, {0x32, 0x74, 0x02, 0xff}}},
};

// 0x0501CBB0
static const Vtx yoshi_seg5_vertex_0501CBB0[] = {
    {{{   233,    -73,      0}, 0, {     0,      0}, {0x44, 0x96, 0x00, 0xff}}},
    {{{   136,   -196,      0}, 0, {     0,      0}, {0xe9, 0x84, 0x00, 0xff}}},
    {{{   121,   -105,    -49}, 0, {     0,      0}, {0xf6, 0xac, 0xa3, 0xff}}},
    {{{   121,   -105,     49}, 0, {     0,      0}, {0xf6, 0xac, 0x5d, 0xff}}},
    {{{     8,    -22,      0}, 0, {     0,      0}, {0x9a, 0xb5, 0x00, 0xff}}},
};

// 0x0501CC00
static const Vtx yoshi_seg5_vertex_0501CC00[] = {
    {{{   171,    -23,    108}, 0, {     0,      0}, {0x1b, 0xb6, 0x62, 0xff}}},
    {{{   155,     50,    149}, 0, {     0,      0}, {0x3a, 0x14, 0x6f, 0xff}}},
    {{{    87,     54,    163}, 0, {     0,      0}, {0xcf, 0x0a, 0x74, 0xff}}},
    {{{     8,    -22,      0}, 0, {     0,      0}, {0x9a, 0xb5, 0x00, 0xff}}},
    {{{    66,    -38,     98}, 0, {     0,      0}, {0xc5, 0xac, 0x49, 0xff}}},
    {{{    -1,     22,     51}, 0, {     0,      0}, {0x89, 0x0a, 0x2b, 0xff}}},
    {{{    -1,     22,    -51}, 0, {     0,      0}, {0x8b, 0x02, 0xcf, 0xff}}},
    {{{    66,    -38,    -98}, 0, {     0,      0}, {0xc5, 0xac, 0xb7, 0xff}}},
    {{{   121,   -105,     49}, 0, {     0,      0}, {0xf6, 0xac, 0x5d, 0xff}}},
    {{{   121,   -105,    -49}, 0, {     0,      0}, {0xf6, 0xac, 0xa3, 0xff}}},
    {{{    57,      6,   -134}, 0, {     0,      0}, {0xc9, 0xc7, 0x9e, 0xff}}},
    {{{   171,    -23,   -108}, 0, {     0,      0}, {0x1b, 0xb6, 0x9e, 0xff}}},
    {{{   233,    -73,      0}, 0, {     0,      0}, {0x44, 0x96, 0x00, 0xff}}},
    {{{    57,      6,    134}, 0, {     0,      0}, {0xc9, 0xc7, 0x62, 0xff}}},
    {{{   264,     10,     80}, 0, {     0,      0}, {0x27, 0xc6, 0x69, 0xff}}},
};

// 0x0501CCF0
static const Vtx yoshi_seg5_vertex_0501CCF0[] = {
    {{{   339,    -10,    -24}, 0, {     0,      0}, {0x4f, 0xa2, 0xe1, 0xff}}},
    {{{   339,    -10,     24}, 0, {     0,      0}, {0x4f, 0xa2, 0x1f, 0xff}}},
    {{{   233,    -73,      0}, 0, {     0,      0}, {0x44, 0x96, 0x00, 0xff}}},
    {{{   264,     10,     80}, 0, {     0,      0}, {0x27, 0xc6, 0x69, 0xff}}},
    {{{   264,     10,    -80}, 0, {     0,      0}, {0x24, 0xbc, 0x9c, 0xff}}},
    {{{   171,    -23,   -108}, 0, {     0,      0}, {0x1b, 0xb6, 0x9e, 0xff}}},
    {{{   372,     28,     45}, 0, {     0,      0}, {0x6a, 0xcf, 0x30, 0xff}}},
    {{{   349,     69,     76}, 0, {     0,      0}, {0x34, 0x23, 0x6e, 0xff}}},
    {{{   265,     47,     97}, 0, {     0,      0}, {0x00, 0xf1, 0x7e, 0xff}}},
    {{{   209,     86,     84}, 0, {     0,      0}, {0x13, 0x3a, 0x6f, 0xff}}},
    {{{   155,     50,    149}, 0, {     0,      0}, {0x3a, 0x14, 0x6f, 0xff}}},
    {{{   199,    115,     54}, 0, {     0,      0}, {0x46, 0x2e, 0x5e, 0xff}}},
    {{{   133,    143,    130}, 0, {     0,      0}, {0x16, 0x0a, 0x7c, 0xff}}},
    {{{    87,     54,    163}, 0, {     0,      0}, {0xcf, 0x0a, 0x74, 0xff}}},
    {{{    75,     93,    107}, 0, {     0,      0}, {0x9d, 0x05, 0x4f, 0xff}}},
};

// 0x0501CDE0
static const Vtx yoshi_seg5_vertex_0501CDE0[] = {
    {{{   209,     86,    -92}, 0, {     0,      0}, {0x11, 0x25, 0x88, 0xff}}},
    {{{   263,     47,   -107}, 0, {     0,      0}, {0xf5, 0xdf, 0x86, 0xff}}},
    {{{   264,     10,    -80}, 0, {     0,      0}, {0x24, 0xbc, 0x9c, 0xff}}},
    {{{   372,     28,    -45}, 0, {     0,      0}, {0x6a, 0xc8, 0xd8, 0xff}}},
    {{{   339,    -10,    -24}, 0, {     0,      0}, {0x4f, 0xa2, 0xe1, 0xff}}},
    {{{   171,    -23,   -108}, 0, {     0,      0}, {0x1b, 0xb6, 0x9e, 0xff}}},
    {{{   155,     50,   -149}, 0, {     0,      0}, {0x38, 0x0f, 0x90, 0xff}}},
    {{{   349,     69,    -92}, 0, {     0,      0}, {0x35, 0x14, 0x8f, 0xff}}},
    {{{   145,    142,   -117}, 0, {     0,      0}, {0x18, 0x15, 0x86, 0xff}}},
    {{{    87,     54,   -163}, 0, {     0,      0}, {0xd2, 0x0f, 0x8b, 0xff}}},
    {{{   199,    115,    -77}, 0, {     0,      0}, {0x41, 0x29, 0x9c, 0xff}}},
    {{{   361,     29,      0}, 0, {     0,      0}, {0x79, 0xdc, 0x00, 0xff}}},
    {{{    57,      6,   -134}, 0, {     0,      0}, {0xc9, 0xc7, 0x9e, 0xff}}},
    {{{    75,     93,   -107}, 0, {     0,      0}, {0xb3, 0x13, 0x9e, 0xff}}},
    {{{   370,     89,     29}, 0, {     0,      0}, {0x60, 0x52, 0x01, 0xff}}},
    {{{   372,     28,     45}, 0, {     0,      0}, {0x6a, 0xcf, 0x30, 0xff}}},
};

// 0x0501CEE0
static const Vtx yoshi_seg5_vertex_0501CEE0[] = {
    {{{   372,     28,     45}, 0, {     0,      0}, {0x6a, 0xcf, 0x30, 0xff}}},
    {{{   339,    -10,     24}, 0, {     0,      0}, {0x4f, 0xa2, 0x1f, 0xff}}},
    {{{   361,     29,      0}, 0, {     0,      0}, {0x79, 0xdc, 0x00, 0xff}}},
    {{{   370,     89,     29}, 0, {     0,      0}, {0x60, 0x52, 0x01, 0xff}}},
    {{{   349,     69,     76}, 0, {     0,      0}, {0x34, 0x23, 0x6e, 0xff}}},
    {{{   366,     76,      0}, 0, {     0,      0}, {0x6f, 0x3d, 0x00, 0xff}}},
    {{{   332,     90,     -4}, 0, {     0,      0}, {0x32, 0x74, 0x02, 0xff}}},
    {{{   339,    -10,    -24}, 0, {     0,      0}, {0x4f, 0xa2, 0xe1, 0xff}}},
    {{{    82,    366,     65}, 0, {     0,      0}, {0xda, 0x70, 0x2c, 0xff}}},
    {{{    82,    366,    -65}, 0, {     0,      0}, {0xde, 0x6b, 0xc5, 0xff}}},
    {{{    13,    282,    -74}, 0, {     0,      0}, {0x92, 0x31, 0xda, 0xff}}},
    {{{   370,     89,    -29}, 0, {     0,      0}, {0x5f, 0x53, 0x05, 0xff}}},
    {{{   372,     28,    -45}, 0, {     0,      0}, {0x6a, 0xc8, 0xd8, 0xff}}},
    {{{   349,     69,    -92}, 0, {     0,      0}, {0x35, 0x14, 0x8f, 0xff}}},
    {{{    55,    280,    135}, 0, {     0,      0}, {0xc2, 0x2a, 0x66, 0xff}}},
    {{{    13,    282,     74}, 0, {     0,      0}, {0x8d, 0x2c, 0x1c, 0xff}}},
};

// 0x0501CFE0
static const Vtx yoshi_seg5_vertex_0501CFE0[] = {
    {{{    82,    366,    -65}, 0, {     0,      0}, {0xde, 0x6b, 0xc5, 0xff}}},
    {{{    82,    366,     65}, 0, {     0,      0}, {0xda, 0x70, 0x2c, 0xff}}},
    {{{   204,    356,    -45}, 0, {     0,      0}, {0x30, 0x70, 0xe0, 0xff}}},
    {{{   174,    273,    124}, 0, {     0,      0}, {0x2c, 0x23, 0x71, 0xff}}},
    {{{    55,    280,    135}, 0, {     0,      0}, {0xc2, 0x2a, 0x66, 0xff}}},
    {{{    13,    282,     74}, 0, {     0,      0}, {0x8d, 0x2c, 0x1c, 0xff}}},
    {{{    13,    282,    -74}, 0, {     0,      0}, {0x92, 0x31, 0xda, 0xff}}},
    {{{   204,    356,     46}, 0, {     0,      0}, {0x31, 0x68, 0x34, 0xff}}},
    {{{    45,    205,    135}, 0, {     0,      0}, {0xdb, 0xf5, 0x78, 0xff}}},
    {{{   166,    198,    130}, 0, {     0,      0}, {0x34, 0xec, 0x71, 0xff}}},
    {{{   279,    299,     29}, 0, {     0,      0}, {0x65, 0x3e, 0x2b, 0xff}}},
    {{{   174,    273,   -134}, 0, {     0,      0}, {0x29, 0x20, 0x8d, 0xff}}},
    {{{   279,    299,    -29}, 0, {     0,      0}, {0x71, 0x27, 0xd8, 0xff}}},
    {{{   277,    191,    -37}, 0, {     0,      0}, {0x6a, 0xea, 0xc0, 0xff}}},
    {{{   277,    191,     36}, 0, {     0,      0}, {0x6f, 0xe8, 0x38, 0xff}}},
    {{{   199,    115,     54}, 0, {     0,      0}, {0x46, 0x2e, 0x5e, 0xff}}},
};

// 0x0501D0E0
static const Vtx yoshi_seg5_vertex_0501D0E0[] = {
    {{{   277,    191,     36}, 0, {     0,      0}, {0x6f, 0xe8, 0x38, 0xff}}},
    {{{   199,    115,     54}, 0, {     0,      0}, {0x46, 0x2e, 0x5e, 0xff}}},
    {{{   260,    123,     -7}, 0, {     0,      0}, {0x69, 0x45, 0x02, 0xff}}},
    {{{   277,    191,    -37}, 0, {     0,      0}, {0x6a, 0xea, 0xc0, 0xff}}},
    {{{   174,    273,    124}, 0, {     0,      0}, {0x2c, 0x23, 0x71, 0xff}}},
    {{{   166,    198,    130}, 0, {     0,      0}, {0x34, 0xec, 0x71, 0xff}}},
    {{{     2,    207,     74}, 0, {     0,      0}, {0x8b, 0xea, 0x29, 0xff}}},
    {{{    75,     93,    107}, 0, {     0,      0}, {0x9d, 0x05, 0x4f, 0xff}}},
    {{{    45,    205,    135}, 0, {     0,      0}, {0xdb, 0xf5, 0x78, 0xff}}},
    {{{   199,    115,    -77}, 0, {     0,      0}, {0x41, 0x29, 0x9c, 0xff}}},
    {{{   145,    142,   -117}, 0, {     0,      0}, {0x18, 0x15, 0x86, 0xff}}},
    {{{   166,    198,   -130}, 0, {     0,      0}, {0x24, 0xe7, 0x8a, 0xff}}},
    {{{   133,    143,    130}, 0, {     0,      0}, {0x16, 0x0a, 0x7c, 0xff}}},
    {{{    55,    280,    135}, 0, {     0,      0}, {0xc2, 0x2a, 0x66, 0xff}}},
};

// 0x0501D1C0
static const Vtx yoshi_seg5_vertex_0501D1C0[] = {
    {{{    45,    205,   -125}, 0, {     0,      0}, {0xbc, 0xeb, 0x98, 0xff}}},
    {{{    55,    280,   -135}, 0, {     0,      0}, {0xca, 0x2a, 0x96, 0xff}}},
    {{{   174,    273,   -134}, 0, {     0,      0}, {0x29, 0x20, 0x8d, 0xff}}},
    {{{   277,    191,    -37}, 0, {     0,      0}, {0x6a, 0xea, 0xc0, 0xff}}},
    {{{   166,    198,   -130}, 0, {     0,      0}, {0x24, 0xe7, 0x8a, 0xff}}},
    {{{    82,    366,    -65}, 0, {     0,      0}, {0xde, 0x6b, 0xc5, 0xff}}},
    {{{    75,     93,   -107}, 0, {     0,      0}, {0xb3, 0x13, 0x9e, 0xff}}},
    {{{   199,    115,    -77}, 0, {     0,      0}, {0x41, 0x29, 0x9c, 0xff}}},
    {{{   145,    142,   -117}, 0, {     0,      0}, {0x18, 0x15, 0x86, 0xff}}},
    {{{    48,    124,    -49}, 0, {     0,      0}, {0x86, 0xff, 0xdf, 0xff}}},
    {{{     2,    207,    -74}, 0, {     0,      0}, {0x87, 0xe7, 0xe5, 0xff}}},
    {{{    13,    282,    -74}, 0, {     0,      0}, {0x92, 0x31, 0xda, 0xff}}},
    {{{   260,    123,     -7}, 0, {     0,      0}, {0x69, 0x45, 0x02, 0xff}}},
    {{{    13,    282,     74}, 0, {     0,      0}, {0x8d, 0x2c, 0x1c, 0xff}}},
    {{{    48,    124,     49}, 0, {     0,      0}, {0x85, 0xed, 0x13, 0xff}}},
    {{{     2,    207,     74}, 0, {     0,      0}, {0x8b, 0xea, 0x29, 0xff}}},
};

// 0x0501D2C0
static const Vtx yoshi_seg5_vertex_0501D2C0[] = {
    {{{    55,    280,    135}, 0, {     0,      0}, {0xc2, 0x2a, 0x66, 0xff}}},
    {{{    13,    282,     74}, 0, {     0,      0}, {0x8d, 0x2c, 0x1c, 0xff}}},
    {{{     2,    207,     74}, 0, {     0,      0}, {0x8b, 0xea, 0x29, 0xff}}},
    {{{    45,    205,    135}, 0, {     0,      0}, {0xdb, 0xf5, 0x78, 0xff}}},
    {{{    48,    124,     49}, 0, {     0,      0}, {0x85, 0xed, 0x13, 0xff}}},
    {{{    75,     93,    107}, 0, {     0,      0}, {0x9d, 0x05, 0x4f, 0xff}}},
    {{{   133,    143,    130}, 0, {     0,      0}, {0x16, 0x0a, 0x7c, 0xff}}},
};

// 0x0501D330
static const Vtx yoshi_seg5_vertex_0501D330[] = {
    {{{   349,     69,    -92}, 0, {     0,      0}, {0x35, 0x14, 0x8f, 0xff}}},
    {{{   209,     86,    -92}, 0, {     0,      0}, {0x11, 0x25, 0x88, 0xff}}},
    {{{   199,    115,    -77}, 0, {     0,      0}, {0x41, 0x29, 0x9c, 0xff}}},
    {{{   263,     47,   -107}, 0, {     0,      0}, {0xf5, 0xdf, 0x86, 0xff}}},
    {{{    48,    124,    -49}, 0, {     0,      0}, {0x86, 0xff, 0xdf, 0xff}}},
    {{{    -1,     22,     51}, 0, {     0,      0}, {0x89, 0x0a, 0x2b, 0xff}}},
    {{{    48,    124,     49}, 0, {     0,      0}, {0x85, 0xed, 0x13, 0xff}}},
    {{{    -1,     22,    -51}, 0, {     0,      0}, {0x8b, 0x02, 0xcf, 0xff}}},
    {{{    75,     93,   -107}, 0, {     0,      0}, {0xb3, 0x13, 0x9e, 0xff}}},
    {{{    87,     54,   -163}, 0, {     0,      0}, {0xd2, 0x0f, 0x8b, 0xff}}},
    {{{    57,      6,   -134}, 0, {     0,      0}, {0xc9, 0xc7, 0x9e, 0xff}}},
    {{{    75,     93,    107}, 0, {     0,      0}, {0x9d, 0x05, 0x4f, 0xff}}},
    {{{    57,      6,    134}, 0, {     0,      0}, {0xc9, 0xc7, 0x62, 0xff}}},
    {{{    87,     54,    163}, 0, {     0,      0}, {0xcf, 0x0a, 0x74, 0xff}}},
};

// 0x0501D410
static const Vtx yoshi_seg5_vertex_0501D410[] = {
    {{{   209,     86,     84}, 0, {     0,      0}, {0x13, 0x3a, 0x6f, 0xff}}},
    {{{   265,     47,     97}, 0, {     0,      0}, {0x00, 0xf1, 0x7e, 0xff}}},
    {{{   349,     69,     76}, 0, {     0,      0}, {0x34, 0x23, 0x6e, 0xff}}},
};

// 0x0501D440 - 0x0501D488
const Gfx yoshi_seg5_dl_0501D440[] = {
    gsDPSetTextureImage(G_IM_FMT_RGBA, G_IM_SIZ_16b, 1, yoshi_seg5_texture_0501C8A0),
    gsDPLoadSync(),
    gsDPLoadBlock(G_TX_LOADTILE, 0, 0, 16 * 16 - 1, CALC_DXT(16, G_IM_SIZ_16b_BYTES)),
    gsSPLight(&yoshi_seg5_lights_0501C458.l, 1),
    gsSPLight(&yoshi_seg5_lights_0501C458.a, 2),
    gsSPVertex(yoshi_seg5_vertex_0501CAA0, 6, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSPEndDisplayList(),
};

// 0x0501D488 - 0x0501D4E0
const Gfx yoshi_seg5_dl_0501D488[] = {
    gsSPLight(&yoshi_seg5_lights_0501C470.l, 1),
    gsSPLight(&yoshi_seg5_lights_0501C470.a, 2),
    gsSPVertex(yoshi_seg5_vertex_0501CB00, 11, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  0,  2,  3, 0x0),
    gsSP2Triangles( 3,  4,  5, 0x0,  5,  0,  3, 0x0),
    gsSP2Triangles( 6,  7,  8, 0x0,  6,  8,  9, 0x0),
    gsSP1Triangle( 7, 10,  8, 0x0),
    gsSPEndDisplayList(),
};

// 0x0501D4E0 - 0x0501D8F8
const Gfx yoshi_seg5_dl_0501D4E0[] = {
    gsSPLight(&yoshi_seg5_lights_0501C488.l, 1),
    gsSPLight(&yoshi_seg5_lights_0501C488.a, 2),
    gsSPVertex(yoshi_seg5_vertex_0501CBB0, 5, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  1,  0, 0x0),
    gsSP2Triangles( 4,  1,  3, 0x0,  2,  1,  4, 0x0),
    gsSPLight(&yoshi_seg5_lights_0501C458.l, 1),
    gsSPLight(&yoshi_seg5_lights_0501C458.a, 2),
    gsSPVertex(yoshi_seg5_vertex_0501CC00, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  7,  3, 0x0,  3,  5,  6, 0x0),
    gsSP2Triangles( 8,  4,  3, 0x0,  3,  7,  9, 0x0),
    gsSP2Triangles(10,  7,  6, 0x0,  7, 10, 11, 0x0),
    gsSP2Triangles( 9,  7, 11, 0x0, 12,  9, 11, 0x0),
    gsSP2Triangles( 4,  8,  0, 0x0,  0,  8, 12, 0x0),
    gsSP2Triangles(13,  4,  0, 0x0,  5,  4, 13, 0x0),
    gsSP2Triangles(12, 14,  0, 0x0,  1,  0, 14, 0x0),
    gsSP1Triangle( 2, 13,  0, 0x0),
    gsSPVertex(yoshi_seg5_vertex_0501CCF0, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  2,  1,  3, 0x0),
    gsSP2Triangles( 4,  0,  2, 0x0,  2,  5,  4, 0x0),
    gsSP2Triangles( 3,  1,  6, 0x0,  7,  3,  6, 0x0),
    gsSP2Triangles( 8,  3,  7, 0x0,  3,  8,  9, 0x0),
    gsSP2Triangles( 9, 10,  3, 0x0,  9, 11, 10, 0x0),
    gsSP2Triangles(12, 10, 11, 0x0, 13, 10, 12, 0x0),
    gsSP1Triangle(14, 13, 12, 0x0),
    gsSPVertex(yoshi_seg5_vertex_0501CDE0, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  2, 0x0),
    gsSP2Triangles( 2,  5,  6, 0x0,  2,  1,  7, 0x0),
    gsSP2Triangles( 3,  2,  7, 0x0,  2,  6,  0, 0x0),
    gsSP2Triangles( 8,  6,  9, 0x0, 10,  6,  8, 0x0),
    gsSP2Triangles(10,  0,  6, 0x0,  9,  6,  5, 0x0),
    gsSP2Triangles( 4,  3, 11, 0x0,  5, 12,  9, 0x0),
    gsSP2Triangles( 9, 13,  8, 0x0, 11, 14, 15, 0x0),
    gsSPVertex(yoshi_seg5_vertex_0501CEE0, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  0,  3,  4, 0x0),
    gsSP2Triangles( 3,  5,  6, 0x0,  2,  5,  3, 0x0),
    gsSP2Triangles( 1,  7,  2, 0x0,  8,  9, 10, 0x0),
    gsSP2Triangles( 6,  5, 11, 0x0, 11,  5,  2, 0x0),
    gsSP2Triangles( 2, 12, 11, 0x0, 13, 11, 12, 0x0),
    gsSP1Triangle(14,  8, 15, 0x0),
    gsSPVertex(yoshi_seg5_vertex_0501CFE0, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  1,  4, 0x0),
    gsSP2Triangles( 5,  1,  6, 0x0,  1,  7,  2, 0x0),
    gsSP2Triangles( 3,  7,  1, 0x0,  8,  9,  3, 0x0),
    gsSP2Triangles( 2,  7, 10, 0x0,  0,  2, 11, 0x0),
    gsSP2Triangles(10, 12,  2, 0x0, 13, 12, 14, 0x0),
    gsSP2Triangles(11, 12, 13, 0x0, 12, 10, 14, 0x0),
    gsSP2Triangles(14, 10,  3, 0x0,  9, 15, 14, 0x0),
    gsSPVertex(yoshi_seg5_vertex_0501D0E0, 14, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  0,  2, 0x0),
    gsSP2Triangles( 4,  5,  0, 0x0,  6,  7,  8, 0x0),
    gsSP2Triangles( 9, 10, 11, 0x0,  8, 12,  5, 0x0),
    gsSP2Triangles(13,  8,  4, 0x0,  5, 12,  1, 0x0),
    gsSPVertex(yoshi_seg5_vertex_0501D1C0, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  2, 0x0),
    gsSP2Triangles( 2,  4,  0, 0x0,  2,  1,  5, 0x0),
    gsSP2Triangles( 4,  6,  0, 0x0,  3,  7,  4, 0x0),
    gsSP2Triangles( 4,  8,  6, 0x0,  0,  9, 10, 0x0),
    gsSP2Triangles(11,  1,  0, 0x0,  0,  6,  9, 0x0),
    gsSP2Triangles( 0, 10, 11, 0x0, 12,  7,  3, 0x0),
    gsSP2Triangles( 5,  1, 11, 0x0, 13, 11, 10, 0x0),
    gsSP2Triangles(10, 14, 15, 0x0, 15, 13, 10, 0x0),
    gsSP1Triangle(10,  9, 14, 0x0),
    gsSPVertex(yoshi_seg5_vertex_0501D2C0, 7, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  0,  2, 0x0),
    gsSP2Triangles( 2,  4,  5, 0x0,  3,  5,  6, 0x0),
    gsSPLight(&yoshi_seg5_lights_0501C470.l, 1),
    gsSPLight(&yoshi_seg5_lights_0501C470.a, 2),
    gsSPVertex(yoshi_seg5_vertex_0501D330, 14, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  0,  3,  1, 0x0),
    gsSP2Triangles( 4,  5,  6, 0x0,  7,  4,  8, 0x0),
    gsSP2Triangles( 4,  7,  5, 0x0,  7,  9, 10, 0x0),
    gsSP2Triangles( 8,  9,  7, 0x0,  6,  5, 11, 0x0),
    gsSP2Triangles(12, 13,  5, 0x0,  5, 13, 11, 0x0),
    gsSPVertex(yoshi_seg5_vertex_0501D410, 3, 0),
    gsSP1Triangle( 0,  1,  2, 0x0),
    gsSPEndDisplayList(),
};

// 0x0501D8F8 - 0x0501D940
const Gfx yoshi_seg5_dl_0501D8F8[] = {
    gsDPPipeSync(),
    gsDPSetCombineMode(G_CC_MODULATERGB, G_CC_MODULATERGB),
    gsDPSetTile(G_IM_FMT_RGBA, G_IM_SIZ_16b, 0, 0, G_TX_LOADTILE, 0, G_TX_WRAP | G_TX_NOMIRROR, G_TX_NOMASK, G_TX_NOLOD, G_TX_WRAP | G_TX_NOMIRROR, G_TX_NOMASK, G_TX_NOLOD),
    gsSPTexture(0xFFFF, 0xFFFF, 0, G_TX_RENDERTILE, G_ON),
    gsDPTileSync(),
    gsDPSetTile(G_IM_FMT_RGBA, G_IM_SIZ_16b, 4, 0, G_TX_RENDERTILE, 0, G_TX_CLAMP, 4, G_TX_NOLOD, G_TX_CLAMP, 4, G_TX_NOLOD),
    gsDPSetTileSize(0, 0, 0, (16 - 1) << G_TEXTURE_IMAGE_FRAC, (16 - 1) << G_TEXTURE_IMAGE_FRAC),
    gsSPDisplayList(yoshi_seg5_dl_0501D440),
    gsSPEndDisplayList(),
};

// 0x0501D940 - 0x0501D970
const Gfx yoshi_seg5_dl_0501D940[] = {
    gsSPDisplayList(yoshi_seg5_dl_0501D488),
    gsSPTexture(0xFFFF, 0xFFFF, 0, G_TX_RENDERTILE, G_OFF),
    gsDPPipeSync(),
    gsDPSetCombineMode(G_CC_SHADE, G_CC_SHADE),
    gsSPDisplayList(yoshi_seg5_dl_0501D4E0),
    gsSPEndDisplayList(),
};

// 0x0501D970 - 0x0501D998
const Gfx yoshi_seg5_dl_0501D970[] = {
    gsSPDisplayList(yoshi_seg5_dl_0501D8F8),
    gsDPSetTextureImage(G_IM_FMT_RGBA, G_IM_SIZ_16b, 1, yoshi_seg5_texture_0501C4A0),
    gsDPLoadSync(),
    gsDPLoadBlock(G_TX_LOADTILE, 0, 0, 16 * 16 - 1, CALC_DXT(16, G_IM_SIZ_16b_BYTES)),
    gsSPBranchList(yoshi_seg5_dl_0501D940),
};

// 0x0501D998 - 0x0501D9C0
const Gfx yoshi_seg5_dl_0501D998[] = {
    gsSPDisplayList(yoshi_seg5_dl_0501D8F8),
    gsDPSetTextureImage(G_IM_FMT_RGBA, G_IM_SIZ_16b, 1, yoshi_seg5_texture_0501C6A0),
    gsDPLoadSync(),
    gsDPLoadBlock(G_TX_LOADTILE, 0, 0, 16 * 16 - 1, CALC_DXT(16, G_IM_SIZ_16b_BYTES)),
    gsSPBranchList(yoshi_seg5_dl_0501D940),
};

// 0x0501D9C0
static const Lights1 yoshi_seg5_lights_0501D9C0 = gdSPDefLights1(
    0x7f, 0x7f, 0x7f,
    0xff, 0xff, 0xff, 0x28, 0x28, 0x28
);

// 0x0501D9D8
static const Lights1 yoshi_seg5_lights_0501D9D8 = gdSPDefLights1(
    0x00, 0x7b, 0x00,
    0x00, 0xf7, 0x00, 0x28, 0x28, 0x28
);

// 0x0501D9F0
static const Lights1 yoshi_seg5_lights_0501D9F0 = gdSPDefLights1(
    0x7f, 0x00, 0x00,
    0xff, 0x00, 0x00, 0x28, 0x28, 0x28
);

// Unreferenced light group
UNUSED static const Lights1 yoshi_lights_unused1 = gdSPDefLights1(
    0x59, 0x59, 0x59,
    0xb2, 0xb2, 0xb2, 0x28, 0x28, 0x28
);

// Unreferenced light group
UNUSED static const Lights1 yoshi_lights_unused2 = gdSPDefLights1(
    0x7f, 0x00, 0x00,
    0xff, 0x00, 0x00, 0x28, 0x28, 0x28
);

// 0x0501DA38
static const Lights1 yoshi_seg5_lights_0501DA38 = gdSPDefLights1(
    0x45, 0x00, 0x00,
    0x8b, 0x00, 0x00, 0x28, 0x28, 0x28
);

// 0x0501DA50
static const Vtx yoshi_seg5_vertex_0501DA50[] = {
    {{{   156,    -27,    -20}, 0, {     0,      0}, {0x68, 0xd2, 0xca, 0x00}}},
    {{{   156,    -27,     20}, 0, {     0,      0}, {0x6f, 0xcf, 0x24, 0x00}}},
    {{{   128,    -49,    -24}, 0, {     0,      0}, {0x1f, 0x8b, 0xdc, 0x00}}},
    {{{    24,     72,     58}, 0, {     0,      0}, {0xde, 0x74, 0x24, 0xff}}},
    {{{   -13,     27,   -121}, 0, {     0,      0}, {0x87, 0x25, 0x02, 0xff}}},
    {{{   -13,     27,    121}, 0, {     0,      0}, {0x82, 0x0b, 0xfe, 0xff}}},
    {{{   102,    -41,    -31}, 0, {     0,      0}, {0xee, 0x84, 0xf2, 0xff}}},
    {{{    -7,    -27,     87}, 0, {     0,      0}, {0xfc, 0x84, 0x18, 0xff}}},
    {{{    -7,    -27,    -87}, 0, {     0,      0}, {0x00, 0x86, 0xdf, 0xff}}},
    {{{    84,     73,    -25}, 0, {     0,      0}, {0x3c, 0x62, 0xcb, 0xff}}},
    {{{    84,     73,     25}, 0, {     0,      0}, {0x38, 0x6b, 0x26, 0xff}}},
    {{{   152,     14,    -24}, 0, {     0,      0}, {0x69, 0x32, 0xd0, 0xff}}},
    {{{    84,      3,     72}, 0, {     0,      0}, {0x46, 0x09, 0x68, 0xff}}},
    {{{   -12,      0,    135}, 0, {     0,      0}, {0x33, 0xe5, 0x70, 0xff}}},
    {{{   109,    -37,     48}, 0, {     0,      0}, {0x21, 0xa7, 0x53, 0xff}}},
};

// 0x0501DB40
static const Vtx yoshi_seg5_vertex_0501DB40[] = {
    {{{    84,      3,    -72}, 0, {     0,      0}, {0x46, 0x09, 0x98, 0xff}}},
    {{{   127,    -15,    -48}, 0, {     0,      0}, {0x46, 0xe3, 0x9b, 0x00}}},
    {{{   109,    -37,    -48}, 0, {     0,      0}, {0x21, 0xa7, 0xad, 0x00}}},
    {{{    44,     31,   -104}, 0, {     0,      0}, {0x35, 0x3d, 0x9f, 0xff}}},
    {{{    24,     72,    -58}, 0, {     0,      0}, {0xf5, 0x79, 0xde, 0xff}}},
    {{{    84,     73,    -25}, 0, {     0,      0}, {0x3c, 0x62, 0xcb, 0xff}}},
    {{{    -7,    -27,    -87}, 0, {     0,      0}, {0x82, 0xf4, 0x02, 0xff}}},
    {{{   -13,     27,   -121}, 0, {     0,      0}, {0x87, 0x25, 0x02, 0xff}}},
    {{{   -12,      0,   -135}, 0, {     0,      0}, {0x82, 0xf7, 0x07, 0xff}}},
    {{{   -12,      0,    135}, 0, {     0,      0}, {0x82, 0xf7, 0xf9, 0xff}}},
    {{{   -13,     27,    121}, 0, {     0,      0}, {0x82, 0x0b, 0xfe, 0xff}}},
    {{{    -7,    -27,     87}, 0, {     0,      0}, {0x82, 0xf5, 0xfd, 0xff}}},
    {{{    24,     72,     58}, 0, {     0,      0}, {0xde, 0x74, 0x24, 0xff}}},
    {{{    44,     31,    104}, 0, {     0,      0}, {0x35, 0x3d, 0x61, 0xff}}},
    {{{    84,     73,     25}, 0, {     0,      0}, {0x38, 0x6b, 0x26, 0xff}}},
};

// 0x0501DC30
static const Vtx yoshi_seg5_vertex_0501DC30[] = {
    {{{   127,    -15,     48}, 0, {     0,      0}, {0x46, 0xe3, 0x65, 0xff}}},
    {{{   156,    -27,     20}, 0, {     0,      0}, {0x6f, 0xcf, 0x24, 0x00}}},
    {{{   152,     14,     24}, 0, {     0,      0}, {0x61, 0x2d, 0x42, 0x00}}},
    {{{   102,    -41,     31}, 0, {     0,      0}, {0xea, 0x84, 0x0e, 0xff}}},
    {{{   128,    -49,     24}, 0, {     0,      0}, {0x23, 0x92, 0x33, 0xff}}},
    {{{   109,    -37,     48}, 0, {     0,      0}, {0x21, 0xa7, 0x53, 0xff}}},
    {{{   109,    -37,    -48}, 0, {     0,      0}, {0x21, 0xa7, 0xad, 0xff}}},
    {{{   128,    -49,    -24}, 0, {     0,      0}, {0x1f, 0x8b, 0xdc, 0xff}}},
    {{{   102,    -41,    -31}, 0, {     0,      0}, {0xee, 0x84, 0xf2, 0xff}}},
    {{{   156,    -27,    -20}, 0, {     0,      0}, {0x68, 0xd2, 0xca, 0xff}}},
    {{{   127,    -15,    -48}, 0, {     0,      0}, {0x46, 0xe3, 0x9b, 0xff}}},
    {{{   152,     14,    -24}, 0, {     0,      0}, {0x69, 0x32, 0xd0, 0xff}}},
    {{{    84,     73,     25}, 0, {     0,      0}, {0x38, 0x6b, 0x26, 0xff}}},
    {{{    84,      3,     72}, 0, {     0,      0}, {0x46, 0x09, 0x68, 0xff}}},
};

// 0x0501DD10
static const Vtx yoshi_seg5_vertex_0501DD10[] = {
    {{{    44,     31,   -104}, 0, {     0,      0}, {0x35, 0x3d, 0x9f, 0xff}}},
    {{{    84,     73,    -25}, 0, {     0,      0}, {0x3c, 0x62, 0xcb, 0x00}}},
    {{{    84,      3,    -72}, 0, {     0,      0}, {0x46, 0x09, 0x98, 0x00}}},
    {{{   -12,      0,    135}, 0, {     0,      0}, {0x33, 0xe5, 0x70, 0xff}}},
    {{{    -7,    -27,     87}, 0, {     0,      0}, {0xfc, 0x84, 0x18, 0xff}}},
    {{{   109,    -37,     48}, 0, {     0,      0}, {0x21, 0xa7, 0x53, 0xff}}},
    {{{   109,    -37,    -48}, 0, {     0,      0}, {0x21, 0xa7, 0xad, 0xff}}},
    {{{    -7,    -27,    -87}, 0, {     0,      0}, {0x00, 0x86, 0xdf, 0xff}}},
    {{{   -12,      0,   -135}, 0, {     0,      0}, {0x33, 0xe5, 0x90, 0xff}}},
    {{{    24,     72,    -58}, 0, {     0,      0}, {0xf5, 0x79, 0xde, 0xff}}},
    {{{    24,     72,     58}, 0, {     0,      0}, {0xde, 0x74, 0x24, 0xff}}},
    {{{    84,     73,     25}, 0, {     0,      0}, {0x38, 0x6b, 0x26, 0xff}}},
    {{{   -13,     27,   -121}, 0, {     0,      0}, {0x16, 0x4e, 0x9f, 0xff}}},
    {{{    -7,    -27,     87}, 0, {     0,      0}, {0x82, 0xf5, 0xfd, 0xff}}},
    {{{   -13,     27,    121}, 0, {     0,      0}, {0x82, 0x0b, 0xfe, 0xff}}},
    {{{    -7,    -27,    -87}, 0, {     0,      0}, {0x82, 0xf4, 0x02, 0xff}}},
};

// 0x0501DE10
static const Vtx yoshi_seg5_vertex_0501DE10[] = {
    {{{    44,     31,    104}, 0, {     0,      0}, {0x35, 0x3d, 0x61, 0xff}}},
    {{{   -13,     27,    121}, 0, {     0,      0}, {0x16, 0x4e, 0x61, 0x00}}},
    {{{   -12,      0,    135}, 0, {     0,      0}, {0x33, 0xe5, 0x70, 0x00}}},
    {{{   152,     14,     24}, 0, {     0,      0}, {0x61, 0x2d, 0x42, 0xff}}},
    {{{   156,    -27,     20}, 0, {     0,      0}, {0x6f, 0xcf, 0x24, 0xff}}},
    {{{   152,     14,    -24}, 0, {     0,      0}, {0x69, 0x32, 0xd0, 0xff}}},
    {{{   128,    -49,     24}, 0, {     0,      0}, {0x23, 0x92, 0x33, 0xff}}},
    {{{   127,    -15,     48}, 0, {     0,      0}, {0x46, 0xe3, 0x65, 0xff}}},
    {{{   102,    -41,    -31}, 0, {     0,      0}, {0xee, 0x84, 0xf2, 0xff}}},
    {{{   128,    -49,    -24}, 0, {     0,      0}, {0x1f, 0x8b, 0xdc, 0xff}}},
    {{{   102,    -41,     31}, 0, {     0,      0}, {0xea, 0x84, 0x0e, 0xff}}},
    {{{   127,    -15,    -48}, 0, {     0,      0}, {0x46, 0xe3, 0x9b, 0xff}}},
    {{{   156,    -27,    -20}, 0, {     0,      0}, {0x68, 0xd2, 0xca, 0xff}}},
    {{{    84,     73,     25}, 0, {     0,      0}, {0x38, 0x6b, 0x26, 0xff}}},
    {{{    84,      3,     72}, 0, {     0,      0}, {0x46, 0x09, 0x68, 0xff}}},
};

// 0x0501DF00
static const Vtx yoshi_seg5_vertex_0501DF00[] = {
    {{{    84,     73,    -25}, 0, {     0,      0}, {0x3c, 0x62, 0xcb, 0xff}}},
    {{{   152,     14,    -24}, 0, {     0,      0}, {0x69, 0x32, 0xd0, 0x00}}},
    {{{    84,      3,    -72}, 0, {     0,      0}, {0x46, 0x09, 0x98, 0x00}}},
    {{{   -12,      0,   -135}, 0, {     0,      0}, {0x33, 0xe5, 0x90, 0xff}}},
    {{{    44,     31,   -104}, 0, {     0,      0}, {0x35, 0x3d, 0x9f, 0xff}}},
    {{{    84,      3,     72}, 0, {     0,      0}, {0x46, 0x09, 0x68, 0xff}}},
    {{{    44,     31,    104}, 0, {     0,      0}, {0x35, 0x3d, 0x61, 0xff}}},
    {{{   -12,      0,    135}, 0, {     0,      0}, {0x33, 0xe5, 0x70, 0xff}}},
    {{{   109,    -37,     48}, 0, {     0,      0}, {0x21, 0xa7, 0x53, 0xff}}},
    {{{   127,    -15,     48}, 0, {     0,      0}, {0x46, 0xe3, 0x65, 0xff}}},
    {{{   109,    -37,    -48}, 0, {     0,      0}, {0x21, 0xa7, 0xad, 0xff}}},
    {{{   127,    -15,    -48}, 0, {     0,      0}, {0x46, 0xe3, 0x9b, 0xff}}},
    {{{   128,    -49,    -24}, 0, {     0,      0}, {0x1f, 0x8b, 0xdc, 0xff}}},
    {{{   128,    -49,     24}, 0, {     0,      0}, {0x23, 0x92, 0x33, 0xff}}},
    {{{   102,    -41,     31}, 0, {     0,      0}, {0xea, 0x84, 0x0e, 0xff}}},
};

// 0x0501DFF0
static const Vtx yoshi_seg5_vertex_0501DFF0[] = {
    {{{   156,    -27,     20}, 0, {     0,      0}, {0x6f, 0xcf, 0x24, 0xff}}},
    {{{   156,    -27,    -20}, 0, {     0,      0}, {0x68, 0xd2, 0xca, 0x00}}},
    {{{   152,     14,    -24}, 0, {     0,      0}, {0x69, 0x32, 0xd0, 0x00}}},
    {{{    44,     31,    104}, 0, {     0,      0}, {0x35, 0x3d, 0x61, 0xff}}},
    {{{    24,     72,     58}, 0, {     0,      0}, {0xde, 0x74, 0x24, 0xff}}},
    {{{   -13,     27,    121}, 0, {     0,      0}, {0x16, 0x4e, 0x61, 0xff}}},
    {{{   -13,     27,    121}, 0, {     0,      0}, {0x82, 0x0b, 0xfe, 0xff}}},
    {{{   -13,     27,   -121}, 0, {     0,      0}, {0x87, 0x25, 0x02, 0xff}}},
    {{{    -7,    -27,    -87}, 0, {     0,      0}, {0x82, 0xf4, 0x02, 0xff}}},
    {{{   -13,     27,   -121}, 0, {     0,      0}, {0x16, 0x4e, 0x9f, 0xff}}},
    {{{    24,     72,    -58}, 0, {     0,      0}, {0xf5, 0x79, 0xde, 0xff}}},
    {{{    44,     31,   -104}, 0, {     0,      0}, {0x35, 0x3d, 0x9f, 0xff}}},
    {{{    84,     73,     25}, 0, {     0,      0}, {0x38, 0x6b, 0x26, 0xff}}},
    {{{    84,     73,    -25}, 0, {     0,      0}, {0x3c, 0x62, 0xcb, 0xff}}},
};

// 0x0501E0D0
static const Vtx yoshi_seg5_vertex_0501E0D0[] = {
    {{{   109,    -37,    -48}, 0, {     0,      0}, {0x21, 0xa7, 0xad, 0xff}}},
    {{{   102,    -41,    -31}, 0, {     0,      0}, {0xee, 0x84, 0xf2, 0x00}}},
    {{{    -7,    -27,    -87}, 0, {     0,      0}, {0x00, 0x86, 0xdf, 0x00}}},
    {{{    -7,    -27,     87}, 0, {     0,      0}, {0xfc, 0x84, 0x18, 0xff}}},
    {{{   102,    -41,     31}, 0, {     0,      0}, {0xea, 0x84, 0x0e, 0xff}}},
    {{{   109,    -37,     48}, 0, {     0,      0}, {0x21, 0xa7, 0x53, 0xff}}},
    {{{    84,      3,     72}, 0, {     0,      0}, {0x46, 0x09, 0x68, 0xff}}},
    {{{   127,    -15,     48}, 0, {     0,      0}, {0x46, 0xe3, 0x65, 0xff}}},
    {{{   152,     14,     24}, 0, {     0,      0}, {0x61, 0x2d, 0x42, 0xff}}},
    {{{    84,     73,     25}, 0, {     0,      0}, {0x38, 0x6b, 0x26, 0xff}}},
    {{{   152,     14,    -24}, 0, {     0,      0}, {0x69, 0x32, 0xd0, 0xff}}},
    {{{    24,     72,     58}, 0, {     0,      0}, {0xde, 0x74, 0x24, 0xff}}},
    {{{    24,     72,    -58}, 0, {     0,      0}, {0xf5, 0x79, 0xde, 0xff}}},
    {{{   -13,     27,   -121}, 0, {     0,      0}, {0x87, 0x25, 0x02, 0xff}}},
};

// 0x0501E1B0
static const Vtx yoshi_seg5_vertex_0501E1B0[] = {
    {{{   156,    -27,     20}, 0, {     0,      0}, {0x6f, 0xcf, 0x24, 0xff}}},
    {{{   128,    -49,     24}, 0, {     0,      0}, {0x23, 0x92, 0x33, 0x00}}},
    {{{   128,    -49,    -24}, 0, {     0,      0}, {0x1f, 0x8b, 0xdc, 0x00}}},
};

// 0x0501E1E0
static const Vtx yoshi_seg5_vertex_0501E1E0[] = {
    {{{    10,      8,    -33}, 0, {     0,      0}, {0xbe, 0x0c, 0x95, 0x00}}},
    {{{    75,     11,    -43}, 0, {     0,      0}, {0x1b, 0x25, 0x8a, 0x00}}},
    {{{    73,    -16,    -34}, 0, {     0,      0}, {0x12, 0xab, 0xa4, 0x00}}},
    {{{    15,     -2,    -25}, 0, {     0,      0}, {0xcd, 0xae, 0xaf, 0xff}}},
    {{{   105,     11,    -19}, 0, {     0,      0}, {0x65, 0x33, 0xc9, 0xff}}},
    {{{   104,     13,     25}, 0, {     0,      0}, {0x60, 0x38, 0x3b, 0xff}}},
    {{{    94,    -15,     20}, 0, {     0,      0}, {0x5b, 0xbf, 0x3a, 0xff}}},
    {{{    96,    -17,    -13}, 0, {     0,      0}, {0x60, 0xba, 0xd4, 0xff}}},
    {{{    71,     15,     46}, 0, {     0,      0}, {0x11, 0x2f, 0x74, 0xff}}},
    {{{     7,     11,     31}, 0, {     0,      0}, {0xb9, 0x17, 0x66, 0xff}}},
    {{{    12,      0,     25}, 0, {     0,      0}, {0xc9, 0xb4, 0x55, 0xff}}},
    {{{    70,    -13,     40}, 0, {     0,      0}, {0xdd, 0xb8, 0x61, 0xff}}},
    {{{    70,    -13,     40}, 0, {     0,      0}, {0x42, 0xcc, 0x5e, 0xff}}},
    {{{    71,    -38,      3}, 0, {     0,      0}, {0x30, 0x8c, 0xf2, 0xff}}},
};

// 0x0501E2C0
static const Vtx yoshi_seg5_vertex_0501E2C0[] = {
    {{{     8,     23,     14}, 0, {     0,      0}, {0xc8, 0x6e, 0x1b, 0xff}}},
    {{{    72,     32,     22}, 0, {     0,      0}, {0x11, 0x78, 0x23, 0x00}}},
    {{{    74,     30,    -21}, 0, {     0,      0}, {0x15, 0x75, 0xd4, 0x00}}},
    {{{    10,     21,    -18}, 0, {     0,      0}, {0xca, 0x6b, 0xd8, 0xff}}},
    {{{    17,    -23,      0}, 0, {     0,      0}, {0xc4, 0x91, 0x03, 0xff}}},
    {{{    71,    -38,      3}, 0, {     0,      0}, {0xdc, 0x9f, 0x48, 0xff}}},
    {{{    70,    -13,     40}, 0, {     0,      0}, {0xdd, 0xb8, 0x61, 0xff}}},
    {{{    12,      0,     25}, 0, {     0,      0}, {0xc9, 0xb4, 0x55, 0xff}}},
    {{{   -11,      1,      0}, 0, {     0,      0}, {0x85, 0xe4, 0x00, 0xff}}},
    {{{    10,      8,    -33}, 0, {     0,      0}, {0xbe, 0x0c, 0x95, 0xff}}},
    {{{    15,     -2,    -25}, 0, {     0,      0}, {0xcd, 0xae, 0xaf, 0xff}}},
    {{{    75,     11,    -43}, 0, {     0,      0}, {0x1b, 0x25, 0x8a, 0xff}}},
    {{{   105,     11,    -19}, 0, {     0,      0}, {0x65, 0x33, 0xc9, 0xff}}},
    {{{    96,    -17,    -13}, 0, {     0,      0}, {0x60, 0xba, 0xd4, 0xff}}},
    {{{    73,    -16,    -34}, 0, {     0,      0}, {0x12, 0xab, 0xa4, 0xff}}},
    {{{   104,     13,     25}, 0, {     0,      0}, {0x60, 0x38, 0x3b, 0xff}}},
};

// 0x0501E3C0
static const Vtx yoshi_seg5_vertex_0501E3C0[] = {
    {{{    71,     15,     46}, 0, {     0,      0}, {0x11, 0x2f, 0x74, 0xff}}},
    {{{    70,    -13,     40}, 0, {     0,      0}, {0x42, 0xcc, 0x5e, 0x00}}},
    {{{    94,    -15,     20}, 0, {     0,      0}, {0x5b, 0xbf, 0x3a, 0x00}}},
    {{{   104,     13,     25}, 0, {     0,      0}, {0x60, 0x38, 0x3b, 0xff}}},
    {{{    72,     32,     22}, 0, {     0,      0}, {0x11, 0x78, 0x23, 0xff}}},
    {{{     8,     23,     14}, 0, {     0,      0}, {0xc8, 0x6e, 0x1b, 0xff}}},
    {{{     7,     11,     31}, 0, {     0,      0}, {0xb9, 0x17, 0x66, 0xff}}},
    {{{   -11,      1,      0}, 0, {     0,      0}, {0x85, 0xe4, 0x00, 0xff}}},
    {{{    12,      0,     25}, 0, {     0,      0}, {0xc9, 0xb4, 0x55, 0xff}}},
    {{{    17,    -23,      0}, 0, {     0,      0}, {0xc4, 0x91, 0x03, 0xff}}},
    {{{    10,     21,    -18}, 0, {     0,      0}, {0xca, 0x6b, 0xd8, 0xff}}},
    {{{    10,      8,    -33}, 0, {     0,      0}, {0xbe, 0x0c, 0x95, 0xff}}},
    {{{   105,     11,    -19}, 0, {     0,      0}, {0x65, 0x33, 0xc9, 0xff}}},
    {{{    75,     11,    -43}, 0, {     0,      0}, {0x1b, 0x25, 0x8a, 0xff}}},
    {{{    74,     30,    -21}, 0, {     0,      0}, {0x15, 0x75, 0xd4, 0xff}}},
};

// 0x0501E4B0
static const Vtx yoshi_seg5_vertex_0501E4B0[] = {
    {{{    71,    -38,      3}, 0, {     0,      0}, {0x30, 0x8c, 0xf2, 0xff}}},
    {{{    96,    -17,    -13}, 0, {     0,      0}, {0x60, 0xba, 0xd4, 0x00}}},
    {{{    94,    -15,     20}, 0, {     0,      0}, {0x5b, 0xbf, 0x3a, 0x00}}},
    {{{    73,    -16,    -34}, 0, {     0,      0}, {0x12, 0xab, 0xa4, 0xff}}},
    {{{    96,    -17,    -13}, 0, {     0,      0}, {0x5b, 0xb2, 0xd8, 0xff}}},
    {{{    17,    -23,      0}, 0, {     0,      0}, {0xc4, 0x91, 0x03, 0xff}}},
    {{{    15,     -2,    -25}, 0, {     0,      0}, {0xcd, 0xae, 0xaf, 0xff}}},
    {{{   -11,      1,      0}, 0, {     0,      0}, {0x85, 0xe4, 0x00, 0xff}}},
};

// 0x0501E530
static const Vtx yoshi_seg5_vertex_0501E530[] = {
    {{{    87,      6,      0}, 0, {     0,      0}, {0x7e, 0x06, 0x00, 0x00}}},
    {{{    78,    -10,    -13}, 0, {     0,      0}, {0x4a, 0xa8, 0xcb, 0x00}}},
    {{{    76,     22,    -13}, 0, {     0,      0}, {0x32, 0x4d, 0xa9, 0x00}}},
    {{{    78,    -10,     13}, 0, {     0,      0}, {0x53, 0xc0, 0x47, 0xff}}},
    {{{     3,    -21,     17}, 0, {     0,      0}, {0xdb, 0xb9, 0x61, 0xff}}},
    {{{    -2,    -27,    -12}, 0, {     0,      0}, {0xb2, 0xc1, 0xb3, 0xff}}},
    {{{    -9,     20,    -11}, 0, {     0,      0}, {0x9e, 0x36, 0xc6, 0xff}}},
    {{{     1,     30,     16}, 0, {     0,      0}, {0xc2, 0x58, 0x41, 0xff}}},
    {{{    -9,      4,      5}, 0, {     0,      0}, {0x87, 0xf9, 0x24, 0xff}}},
    {{{    76,     22,     13}, 0, {     0,      0}, {0x40, 0x3a, 0x5c, 0xff}}},
};

// 0x0501E5D0
static const Vtx yoshi_seg5_vertex_0501E5D0[] = {
    {{{    -5,    -33,    -19}, 0, {     0,      0}, {0xdc, 0xa0, 0xb6, 0x00}}},
    {{{    87,    -12,    -13}, 0, {     0,      0}, {0x4b, 0xa6, 0xd1, 0x00}}},
    {{{    87,    -12,     16}, 0, {     0,      0}, {0x35, 0xbc, 0x5c, 0x00}}},
    {{{    87,     19,     16}, 0, {     0,      0}, {0x3d, 0x50, 0x4c, 0xff}}},
    {{{    87,     19,    -13}, 0, {     0,      0}, {0x41, 0x4f, 0xb7, 0xff}}},
    {{{    -5,     38,    -19}, 0, {     0,      0}, {0xe5, 0x6f, 0x36, 0xff}}},
    {{{   -24,      2,     -9}, 0, {     0,      0}, {0x85, 0xff, 0x1e, 0xff}}},
    {{{    -5,     38,    -19}, 0, {     0,      0}, {0xe5, 0x00, 0x85, 0xff}}},
    {{{    97,      3,      1}, 0, {     0,      0}, {0x7f, 0x01, 0x00, 0xff}}},
    {{{     0,     20,     13}, 0, {     0,      0}, {0xd3, 0x2a, 0x6e, 0xff}}},
    {{{     1,    -18,     13}, 0, {     0,      0}, {0xc9, 0xc8, 0x63, 0xff}}},
};

// 0x0501E680
static const Vtx yoshi_seg5_vertex_0501E680[] = {
    {{{    15,     -2,     25}, 0, {     0,      0}, {0xcd, 0xae, 0x51, 0x00}}},
    {{{    73,    -16,     34}, 0, {     0,      0}, {0x12, 0xab, 0x5c, 0x00}}},
    {{{    75,     11,     43}, 0, {     0,      0}, {0x1b, 0x25, 0x76, 0x00}}},
    {{{    10,      8,     33}, 0, {     0,      0}, {0xbe, 0x0c, 0x6b, 0xff}}},
    {{{    96,    -17,     13}, 0, {     0,      0}, {0x60, 0xba, 0x2c, 0xff}}},
    {{{    94,    -15,    -20}, 0, {     0,      0}, {0x5b, 0xbf, 0xc6, 0xff}}},
    {{{   104,     13,    -25}, 0, {     0,      0}, {0x60, 0x38, 0xc5, 0xff}}},
    {{{   105,     11,     19}, 0, {     0,      0}, {0x65, 0x33, 0x37, 0xff}}},
    {{{    70,    -13,    -40}, 0, {     0,      0}, {0xdd, 0xb8, 0x9f, 0xff}}},
    {{{    12,      0,    -25}, 0, {     0,      0}, {0xc9, 0xb4, 0xab, 0xff}}},
    {{{     7,     11,    -31}, 0, {     0,      0}, {0xb9, 0x17, 0x9a, 0xff}}},
    {{{    71,     15,    -46}, 0, {     0,      0}, {0x11, 0x2f, 0x8c, 0xff}}},
    {{{    71,    -38,     -3}, 0, {     0,      0}, {0x30, 0x8c, 0x0e, 0xff}}},
    {{{    70,    -13,    -40}, 0, {     0,      0}, {0x42, 0xcc, 0xa2, 0xff}}},
};

// 0x0501E760
static const Vtx yoshi_seg5_vertex_0501E760[] = {
    {{{    10,     21,     18}, 0, {     0,      0}, {0xca, 0x6b, 0x28, 0xff}}},
    {{{    74,     30,     21}, 0, {     0,      0}, {0x15, 0x75, 0x2c, 0x00}}},
    {{{    72,     32,    -22}, 0, {     0,      0}, {0x11, 0x78, 0xdd, 0x00}}},
    {{{     8,     23,    -14}, 0, {     0,      0}, {0xc8, 0x6e, 0xe5, 0xff}}},
    {{{    12,      0,    -25}, 0, {     0,      0}, {0xc9, 0xb4, 0xab, 0xff}}},
    {{{    70,    -13,    -40}, 0, {     0,      0}, {0xdd, 0xb8, 0x9f, 0xff}}},
    {{{    71,    -38,     -3}, 0, {     0,      0}, {0xdc, 0x9f, 0xb8, 0xff}}},
    {{{    17,    -23,      0}, 0, {     0,      0}, {0xc4, 0x91, 0xfd, 0xff}}},
    {{{    15,     -2,     25}, 0, {     0,      0}, {0xcd, 0xae, 0x51, 0xff}}},
    {{{    10,      8,     33}, 0, {     0,      0}, {0xbe, 0x0c, 0x6b, 0xff}}},
    {{{   -11,      1,      0}, 0, {     0,      0}, {0x85, 0xe4, 0x00, 0xff}}},
    {{{    75,     11,     43}, 0, {     0,      0}, {0x1b, 0x25, 0x76, 0xff}}},
    {{{    73,    -16,     34}, 0, {     0,      0}, {0x12, 0xab, 0x5c, 0xff}}},
    {{{    96,    -17,     13}, 0, {     0,      0}, {0x60, 0xba, 0x2c, 0xff}}},
    {{{   105,     11,     19}, 0, {     0,      0}, {0x65, 0x33, 0x37, 0xff}}},
    {{{   104,     13,    -25}, 0, {     0,      0}, {0x60, 0x38, 0xc5, 0xff}}},
};

// 0x0501E860
static const Vtx yoshi_seg5_vertex_0501E860[] = {
    {{{   104,     13,    -25}, 0, {     0,      0}, {0x60, 0x38, 0xc5, 0xff}}},
    {{{    94,    -15,    -20}, 0, {     0,      0}, {0x5b, 0xbf, 0xc6, 0x00}}},
    {{{    70,    -13,    -40}, 0, {     0,      0}, {0x42, 0xcc, 0xa2, 0x00}}},
    {{{    71,     15,    -46}, 0, {     0,      0}, {0x11, 0x2f, 0x8c, 0xff}}},
    {{{     7,     11,    -31}, 0, {     0,      0}, {0xb9, 0x17, 0x9a, 0xff}}},
    {{{     8,     23,    -14}, 0, {     0,      0}, {0xc8, 0x6e, 0xe5, 0xff}}},
    {{{    72,     32,    -22}, 0, {     0,      0}, {0x11, 0x78, 0xdd, 0xff}}},
    {{{    12,      0,    -25}, 0, {     0,      0}, {0xc9, 0xb4, 0xab, 0xff}}},
    {{{   -11,      1,      0}, 0, {     0,      0}, {0x85, 0xe4, 0x00, 0xff}}},
    {{{    17,    -23,      0}, 0, {     0,      0}, {0xc4, 0x91, 0xfd, 0xff}}},
    {{{    10,     21,     18}, 0, {     0,      0}, {0xca, 0x6b, 0x28, 0xff}}},
    {{{    10,      8,     33}, 0, {     0,      0}, {0xbe, 0x0c, 0x6b, 0xff}}},
    {{{    74,     30,     21}, 0, {     0,      0}, {0x15, 0x75, 0x2c, 0xff}}},
    {{{    75,     11,     43}, 0, {     0,      0}, {0x1b, 0x25, 0x76, 0xff}}},
    {{{   105,     11,     19}, 0, {     0,      0}, {0x65, 0x33, 0x37, 0xff}}},
};

// 0x0501E950
static const Vtx yoshi_seg5_vertex_0501E950[] = {
    {{{    94,    -15,    -20}, 0, {     0,      0}, {0x5b, 0xbf, 0xc6, 0xff}}},
    {{{    96,    -17,     13}, 0, {     0,      0}, {0x60, 0xba, 0x2c, 0x00}}},
    {{{    71,    -38,     -3}, 0, {     0,      0}, {0x30, 0x8c, 0x0e, 0x00}}},
    {{{    96,    -17,     13}, 0, {     0,      0}, {0x5b, 0xb2, 0x28, 0xff}}},
    {{{    73,    -16,     34}, 0, {     0,      0}, {0x12, 0xab, 0x5c, 0xff}}},
    {{{    15,     -2,     25}, 0, {     0,      0}, {0xcd, 0xae, 0x51, 0xff}}},
    {{{    17,    -23,      0}, 0, {     0,      0}, {0xc4, 0x91, 0xfd, 0xff}}},
    {{{   -11,      1,      0}, 0, {     0,      0}, {0x85, 0xe4, 0x00, 0xff}}},
};

// 0x0501E9D0
static const Vtx yoshi_seg5_vertex_0501E9D0[] = {
    {{{    76,     22,     13}, 0, {     0,      0}, {0x32, 0x4d, 0x57, 0x00}}},
    {{{    78,    -10,     13}, 0, {     0,      0}, {0x4a, 0xa8, 0x35, 0x00}}},
    {{{    87,      6,      0}, 0, {     0,      0}, {0x7e, 0x06, 0x00, 0x00}}},
    {{{    78,    -10,    -13}, 0, {     0,      0}, {0x53, 0xc0, 0xb9, 0xff}}},
    {{{    -2,    -27,     12}, 0, {     0,      0}, {0xb2, 0xc1, 0x4d, 0xff}}},
    {{{     3,    -21,    -17}, 0, {     0,      0}, {0xdb, 0xb9, 0x9f, 0xff}}},
    {{{     1,     30,    -16}, 0, {     0,      0}, {0xc2, 0x58, 0xbf, 0xff}}},
    {{{    -9,     20,     11}, 0, {     0,      0}, {0x9e, 0x36, 0x3a, 0xff}}},
    {{{    -9,      4,     -5}, 0, {     0,      0}, {0x87, 0xf9, 0xdc, 0xff}}},
    {{{    76,     22,    -13}, 0, {     0,      0}, {0x40, 0x3a, 0xa4, 0xff}}},
};

// 0x0501EA70
static const Vtx yoshi_seg5_vertex_0501EA70[] = {
    {{{    87,    -12,    -16}, 0, {     0,      0}, {0x35, 0xbc, 0xa4, 0x00}}},
    {{{    87,    -12,     13}, 0, {     0,      0}, {0x4b, 0xa6, 0x2f, 0x00}}},
    {{{    -5,    -33,     19}, 0, {     0,      0}, {0xdc, 0xa0, 0x4a, 0x00}}},
    {{{    -5,     38,     19}, 0, {     0,      0}, {0xe5, 0x6f, 0xca, 0xff}}},
    {{{    87,     19,     13}, 0, {     0,      0}, {0x41, 0x4f, 0x49, 0xff}}},
    {{{    87,     19,    -16}, 0, {     0,      0}, {0x3d, 0x50, 0xb4, 0xff}}},
    {{{    -5,     38,     19}, 0, {     0,      0}, {0xe5, 0x00, 0x7b, 0xff}}},
    {{{   -24,      2,      9}, 0, {     0,      0}, {0x85, 0xff, 0xe2, 0xff}}},
    {{{    97,      3,     -1}, 0, {     0,      0}, {0x7f, 0x01, 0x00, 0xff}}},
    {{{     1,    -18,    -13}, 0, {     0,      0}, {0xc9, 0xc8, 0x9d, 0xff}}},
    {{{     0,     20,    -13}, 0, {     0,      0}, {0xd3, 0x2a, 0x92, 0xff}}},
};

// 0x0501EB20
static const Vtx yoshi_seg5_vertex_0501EB20[] = {
    {{{   212,      0,    -34}, 0, {     0,      0}, {0x54, 0xba, 0xc1, 0x00}}},
    {{{   212,      0,     39}, 0, {     0,      0}, {0x5c, 0xb4, 0x29, 0x00}}},
    {{{   169,    -51,    -34}, 0, {     0,      0}, {0x3a, 0x9c, 0xcd, 0x00}}},
    {{{   169,    -51,     39}, 0, {     0,      0}, {0x34, 0xa5, 0x46, 0xff}}},
    {{{   119,    -59,    -26}, 0, {     0,      0}, {0xe1, 0x8e, 0xd4, 0xff}}},
    {{{   119,    -59,     29}, 0, {     0,      0}, {0xe0, 0x89, 0x1c, 0xff}}},
    {{{    71,    -20,    -33}, 0, {     0,      0}, {0xb8, 0xa1, 0xd7, 0xff}}},
    {{{    71,    -20,     36}, 0, {     0,      0}, {0xbd, 0xa3, 0x34, 0xff}}},
    {{{    63,     80,     66}, 0, {     0,      0}, {0xdf, 0xfc, 0x7a, 0xff}}},
    {{{    38,     19,     55}, 0, {     0,      0}, {0xe7, 0xfa, 0x7c, 0xff}}},
    {{{   124,    -26,     70}, 0, {     0,      0}, {0xed, 0xc4, 0x6d, 0xff}}},
    {{{    63,     80,    -58}, 0, {     0,      0}, {0xdf, 0xfe, 0x86, 0xff}}},
    {{{   124,    -26,    -65}, 0, {     0,      0}, {0xed, 0xc6, 0x91, 0xff}}},
    {{{    38,     19,    -49}, 0, {     0,      0}, {0xe8, 0xfc, 0x84, 0xff}}},
    {{{   155,     31,     76}, 0, {     0,      0}, {0x1d, 0xe3, 0x77, 0xff}}},
};

// 0x0501EC10
static const Vtx yoshi_seg5_vertex_0501EC10[] = {
    {{{   -13,     33,    -25}, 0, {     0,      0}, {0xd6, 0x24, 0x8f, 0xff}}},
    {{{   -11,     53,    -25}, 0, {     0,      0}, {0xcc, 0x02, 0x8d, 0x00}}},
    {{{    38,     19,    -49}, 0, {     0,      0}, {0xe8, 0xfc, 0x84, 0x00}}},
    {{{    38,     19,     55}, 0, {     0,      0}, {0xe7, 0xfa, 0x7c, 0xff}}},
    {{{   -13,     33,     29}, 0, {     0,      0}, {0xd4, 0x24, 0x70, 0xff}}},
    {{{    11,    -20,     65}, 0, {     0,      0}, {0xf8, 0x23, 0x79, 0xff}}},
    {{{    63,     80,    -58}, 0, {     0,      0}, {0xdf, 0xfe, 0x86, 0xff}}},
    {{{   155,     31,    -71}, 0, {     0,      0}, {0x1c, 0xe3, 0x88, 0xff}}},
    {{{   124,    -26,    -65}, 0, {     0,      0}, {0xed, 0xc6, 0x91, 0xff}}},
    {{{   -35,      4,     37}, 0, {     0,      0}, {0xdc, 0x36, 0x6c, 0xff}}},
    {{{   119,    -59,     29}, 0, {     0,      0}, {0xe0, 0x89, 0x1c, 0xff}}},
    {{{   169,    -51,     39}, 0, {     0,      0}, {0x34, 0xa5, 0x46, 0xff}}},
    {{{   124,    -26,     70}, 0, {     0,      0}, {0xed, 0xc4, 0x6d, 0xff}}},
    {{{   169,    -51,    -34}, 0, {     0,      0}, {0x3a, 0x9c, 0xcd, 0xff}}},
    {{{   119,    -59,    -26}, 0, {     0,      0}, {0xe1, 0x8e, 0xd4, 0xff}}},
    {{{    71,    -20,     36}, 0, {     0,      0}, {0xbd, 0xa3, 0x34, 0xff}}},
};

// 0x0501ED10
static const Vtx yoshi_seg5_vertex_0501ED10[] = {
    {{{   124,    -26,    -65}, 0, {     0,      0}, {0xed, 0xc6, 0x91, 0xff}}},
    {{{   119,    -59,    -26}, 0, {     0,      0}, {0xe1, 0x8e, 0xd4, 0x00}}},
    {{{    71,    -20,    -33}, 0, {     0,      0}, {0xb8, 0xa1, 0xd7, 0x00}}},
    {{{   -35,      4,    -31}, 0, {     0,      0}, {0xc5, 0x90, 0x00, 0xff}}},
    {{{    11,    -20,    -60}, 0, {     0,      0}, {0xc5, 0x90, 0x00, 0xff}}},
    {{{    70,    -52,    -32}, 0, {     0,      0}, {0xc5, 0x90, 0x00, 0xff}}},
    {{{    38,     19,     55}, 0, {     0,      0}, {0xe7, 0xfa, 0x7c, 0xff}}},
    {{{    71,    -20,     36}, 0, {     0,      0}, {0xbd, 0xa3, 0x34, 0xff}}},
    {{{   124,    -26,     70}, 0, {     0,      0}, {0xed, 0xc4, 0x6d, 0xff}}},
    {{{    38,     19,    -49}, 0, {     0,      0}, {0xe8, 0xfc, 0x84, 0xff}}},
    {{{   -35,      4,     37}, 0, {     0,      0}, {0xc5, 0x90, 0x00, 0xff}}},
    {{{    11,    -20,     65}, 0, {     0,      0}, {0xc5, 0x90, 0x00, 0xff}}},
    {{{    70,    -52,     35}, 0, {     0,      0}, {0xc5, 0x90, 0x00, 0xff}}},
    {{{    63,     80,     66}, 0, {     0,      0}, {0xdf, 0xfc, 0x7a, 0xff}}},
    {{{    11,    108,     40}, 0, {     0,      0}, {0xc9, 0x03, 0x72, 0xff}}},
    {{{   -11,     53,     30}, 0, {     0,      0}, {0xc9, 0x02, 0x72, 0xff}}},
};

// 0x0501EE10
static const Vtx yoshi_seg5_vertex_0501EE10[] = {
    {{{   169,    -51,     39}, 0, {     0,      0}, {0x34, 0xa5, 0x46, 0xff}}},
    {{{   212,      0,     39}, 0, {     0,      0}, {0x5c, 0xb4, 0x29, 0x00}}},
    {{{   155,     31,     76}, 0, {     0,      0}, {0x1d, 0xe3, 0x77, 0x00}}},
    {{{   119,    -59,    -26}, 0, {     0,      0}, {0xe1, 0x8e, 0xd4, 0xff}}},
    {{{   169,    -51,    -34}, 0, {     0,      0}, {0x3a, 0x9c, 0xcd, 0xff}}},
    {{{   119,    -59,     29}, 0, {     0,      0}, {0xe0, 0x89, 0x1c, 0xff}}},
    {{{   155,     31,    -71}, 0, {     0,      0}, {0x1c, 0xe3, 0x88, 0xff}}},
    {{{   212,      0,    -34}, 0, {     0,      0}, {0x54, 0xba, 0xc1, 0xff}}},
    {{{   124,    -26,     70}, 0, {     0,      0}, {0xed, 0xc4, 0x6d, 0xff}}},
    {{{   124,    -26,    -65}, 0, {     0,      0}, {0xed, 0xc6, 0x91, 0xff}}},
    {{{   -11,     53,    -25}, 0, {     0,      0}, {0x87, 0x25, 0x00, 0xff}}},
    {{{   -11,     53,     30}, 0, {     0,      0}, {0x84, 0x19, 0x00, 0xff}}},
    {{{    11,    108,     40}, 0, {     0,      0}, {0x8b, 0x31, 0x00, 0xff}}},
    {{{    38,     19,    -49}, 0, {     0,      0}, {0xe8, 0xfc, 0x84, 0xff}}},
    {{{   -11,     53,    -25}, 0, {     0,      0}, {0xcc, 0x02, 0x8d, 0xff}}},
    {{{    11,    108,    -34}, 0, {     0,      0}, {0xcd, 0x03, 0x8d, 0xff}}},
};

// 0x0501EF10
static const Vtx yoshi_seg5_vertex_0501EF10[] = {
    {{{   -13,     33,    -25}, 0, {     0,      0}, {0x86, 0x22, 0x00, 0xff}}},
    {{{   -13,     33,     29}, 0, {     0,      0}, {0x8f, 0x38, 0x00, 0x00}}},
    {{{   -11,     53,     30}, 0, {     0,      0}, {0x84, 0x19, 0x00, 0x00}}},
    {{{    11,    -20,    -60}, 0, {     0,      0}, {0xf9, 0x25, 0x87, 0xff}}},
    {{{   -35,      4,    -31}, 0, {     0,      0}, {0xdb, 0x35, 0x93, 0xff}}},
    {{{   -13,     33,    -25}, 0, {     0,      0}, {0xd6, 0x24, 0x8f, 0xff}}},
    {{{    11,    108,    -34}, 0, {     0,      0}, {0x8b, 0x31, 0x00, 0xff}}},
    {{{   -11,     53,    -25}, 0, {     0,      0}, {0x87, 0x25, 0x00, 0xff}}},
    {{{    11,    108,     40}, 0, {     0,      0}, {0x8b, 0x31, 0x00, 0xff}}},
    {{{    63,     80,    -58}, 0, {     0,      0}, {0xdf, 0xfe, 0x86, 0xff}}},
    {{{    38,     19,    -49}, 0, {     0,      0}, {0xe8, 0xfc, 0x84, 0xff}}},
    {{{    11,    108,    -34}, 0, {     0,      0}, {0xcd, 0x03, 0x8d, 0xff}}},
    {{{    38,     19,     55}, 0, {     0,      0}, {0xe7, 0xfa, 0x7c, 0xff}}},
    {{{   -11,     53,     30}, 0, {     0,      0}, {0xc9, 0x02, 0x72, 0xff}}},
    {{{   -13,     33,     29}, 0, {     0,      0}, {0xd4, 0x24, 0x70, 0xff}}},
};

// 0x0501F000
static const Vtx yoshi_seg5_vertex_0501F000[] = {
    {{{   -35,      4,    -31}, 0, {     0,      0}, {0x9b, 0x4b, 0x00, 0xff}}},
    {{{   -35,      4,     37}, 0, {     0,      0}, {0x9b, 0x4b, 0x00, 0x00}}},
    {{{   -13,     33,     29}, 0, {     0,      0}, {0x8f, 0x38, 0x00, 0x00}}},
    {{{    70,    -52,     35}, 0, {     0,      0}, {0x7e, 0xfc, 0x00, 0xff}}},
    {{{    70,    -52,    -32}, 0, {     0,      0}, {0x7e, 0xfc, 0x00, 0xff}}},
    {{{    71,    -20,    -33}, 0, {     0,      0}, {0x7e, 0xfc, 0x00, 0xff}}},
    {{{    11,    -20,     65}, 0, {     0,      0}, {0xf8, 0x23, 0x79, 0xff}}},
    {{{    70,    -52,     35}, 0, {     0,      0}, {0x36, 0xf9, 0x72, 0xff}}},
    {{{    38,     19,     55}, 0, {     0,      0}, {0xe7, 0xfa, 0x7c, 0xff}}},
    {{{    38,     19,    -49}, 0, {     0,      0}, {0xe8, 0xfc, 0x84, 0xff}}},
    {{{    70,    -52,    -32}, 0, {     0,      0}, {0x32, 0xfc, 0x8c, 0xff}}},
    {{{    11,    -20,    -60}, 0, {     0,      0}, {0xf9, 0x25, 0x87, 0xff}}},
    {{{    71,    -20,    -33}, 0, {     0,      0}, {0x30, 0xfb, 0x8b, 0xff}}},
    {{{    71,    -20,     36}, 0, {     0,      0}, {0x39, 0xfa, 0x71, 0xff}}},
    {{{    71,    -20,     36}, 0, {     0,      0}, {0x7e, 0xfc, 0x00, 0xff}}},
    {{{   -13,     33,    -25}, 0, {     0,      0}, {0x86, 0x22, 0x00, 0xff}}},
};

// 0x0501F100
static const Vtx yoshi_seg5_vertex_0501F100[] = {
    {{{   212,      0,    -34}, 0, {     0,      0}, {0x3b, 0x70, 0x00, 0xff}}},
    {{{   155,     31,    -71}, 0, {     0,      0}, {0x3b, 0x70, 0x01, 0x00}}},
    {{{    63,     80,    -58}, 0, {     0,      0}, {0x3b, 0x70, 0x00, 0x00}}},
    {{{    11,    108,    -34}, 0, {     0,      0}, {0x3c, 0x6f, 0xff, 0xff}}},
    {{{    11,    108,     40}, 0, {     0,      0}, {0x3c, 0x6f, 0x00, 0xff}}},
    {{{    63,     80,     66}, 0, {     0,      0}, {0x3b, 0x70, 0x00, 0xff}}},
    {{{   155,     31,     76}, 0, {     0,      0}, {0x3b, 0x70, 0x00, 0xff}}},
    {{{   212,      0,     39}, 0, {     0,      0}, {0x3c, 0x6f, 0x00, 0xff}}},
};

// 0x0501F180
static const Vtx yoshi_seg5_vertex_0501F180[] = {
    {{{    77,    -40,    -10}, 0, {     0,      0}, {0x26, 0x90, 0xd5, 0x00}}},
    {{{     4,    -48,     28}, 0, {     0,      0}, {0xda, 0x91, 0x2e, 0x00}}},
    {{{     2,    -48,    -17}, 0, {     0,      0}, {0xba, 0xa0, 0xd6, 0x00}}},
    {{{    81,     36,      4}, 0, {     0,      0}, {0x2f, 0x75, 0xfe, 0xff}}},
    {{{    10,     38,    -23}, 0, {     0,      0}, {0xe3, 0x46, 0x9b, 0xff}}},
    {{{     7,     53,      4}, 0, {     0,      0}, {0xde, 0x7a, 0xfd, 0xff}}},
    {{{    76,    -40,     20}, 0, {     0,      0}, {0x24, 0x99, 0x3f, 0xff}}},
    {{{    76,     25,    -19}, 0, {     0,      0}, {0x33, 0x44, 0xa3, 0xff}}},
    {{{    77,    -21,     38}, 0, {     0,      0}, {0x24, 0xf7, 0x79, 0xff}}},
    {{{     7,     37,     35}, 0, {     0,      0}, {0xe0, 0x45, 0x64, 0xff}}},
    {{{     3,    -26,     42}, 0, {     0,      0}, {0xe2, 0xd8, 0x74, 0xff}}},
    {{{    78,    -21,    -28}, 0, {     0,      0}, {0x24, 0xfb, 0x87, 0xff}}},
    {{{     3,    -26,    -33}, 0, {     0,      0}, {0xe1, 0xd9, 0x8c, 0xff}}},
    {{{   117,      6,      5}, 0, {     0,      0}, {0x68, 0x48, 0x00, 0xff}}},
    {{{   -16,     30,      5}, 0, {     0,      0}, {0x99, 0x49, 0xfc, 0xff}}},
    {{{    80,     24,     30}, 0, {     0,      0}, {0x35, 0x44, 0x5d, 0xff}}},
};

// 0x0501F280
static const Vtx yoshi_seg5_vertex_0501F280[] = {
    {{{    77,    -21,     38}, 0, {     0,      0}, {0x24, 0xf7, 0x79, 0xff}}},
    {{{    76,    -40,     20}, 0, {     0,      0}, {0x24, 0x99, 0x3f, 0x00}}},
    {{{   114,    -16,     21}, 0, {     0,      0}, {0x5f, 0xbf, 0x34, 0x00}}},
    {{{   -20,    -10,     21}, 0, {     0,      0}, {0x93, 0xe3, 0x38, 0xff}}},
    {{{     4,    -48,     28}, 0, {     0,      0}, {0xda, 0x91, 0x2e, 0xff}}},
    {{{     3,    -26,     42}, 0, {     0,      0}, {0xe2, 0xd8, 0x74, 0xff}}},
    {{{     3,    -26,    -33}, 0, {     0,      0}, {0xe1, 0xd9, 0x8c, 0xff}}},
    {{{     2,    -48,    -17}, 0, {     0,      0}, {0xba, 0xa0, 0xd6, 0xff}}},
    {{{   -21,    -10,    -11}, 0, {     0,      0}, {0x98, 0xf4, 0xba, 0xff}}},
    {{{    77,    -40,    -10}, 0, {     0,      0}, {0x26, 0x90, 0xd5, 0xff}}},
    {{{    78,    -21,    -28}, 0, {     0,      0}, {0x24, 0xfb, 0x87, 0xff}}},
    {{{   115,    -16,    -12}, 0, {     0,      0}, {0x63, 0xd2, 0xc1, 0xff}}},
    {{{   117,      6,      5}, 0, {     0,      0}, {0x68, 0x48, 0x00, 0xff}}},
    {{{    80,     24,     30}, 0, {     0,      0}, {0x35, 0x44, 0x5d, 0xff}}},
    {{{    76,     25,    -19}, 0, {     0,      0}, {0x33, 0x44, 0xa3, 0xff}}},
    {{{     7,     37,     35}, 0, {     0,      0}, {0xe0, 0x45, 0x64, 0xff}}},
};

// 0x0501F380
static const Vtx yoshi_seg5_vertex_0501F380[] = {
    {{{     3,    -26,    -33}, 0, {     0,      0}, {0xe1, 0xd9, 0x8c, 0xff}}},
    {{{   -21,    -10,    -11}, 0, {     0,      0}, {0x98, 0xf4, 0xba, 0x00}}},
    {{{    10,     38,    -23}, 0, {     0,      0}, {0xe3, 0x46, 0x9b, 0x00}}},
    {{{    81,     36,      4}, 0, {     0,      0}, {0x2f, 0x75, 0xfe, 0xff}}},
    {{{     7,     53,      4}, 0, {     0,      0}, {0xde, 0x7a, 0xfd, 0xff}}},
    {{{     7,     37,     35}, 0, {     0,      0}, {0xe0, 0x45, 0x64, 0xff}}},
    {{{   114,    -16,     21}, 0, {     0,      0}, {0x5f, 0xbf, 0x34, 0xff}}},
    {{{    77,    -40,    -10}, 0, {     0,      0}, {0x26, 0x90, 0xd5, 0xff}}},
    {{{   115,    -16,    -12}, 0, {     0,      0}, {0x63, 0xd2, 0xc1, 0xff}}},
    {{{     3,    -26,     42}, 0, {     0,      0}, {0xe2, 0xd8, 0x74, 0xff}}},
    {{{    76,    -40,     20}, 0, {     0,      0}, {0x24, 0x99, 0x3f, 0xff}}},
    {{{    77,    -21,     38}, 0, {     0,      0}, {0x24, 0xf7, 0x79, 0xff}}},
    {{{     2,    -48,    -17}, 0, {     0,      0}, {0xba, 0xa0, 0xd6, 0xff}}},
    {{{     4,    -48,     28}, 0, {     0,      0}, {0xda, 0x91, 0x2e, 0xff}}},
    {{{   -20,    -10,     21}, 0, {     0,      0}, {0x93, 0xe3, 0x38, 0xff}}},
    {{{    78,    -21,    -28}, 0, {     0,      0}, {0x24, 0xfb, 0x87, 0xff}}},
};

// 0x0501F480
static const Vtx yoshi_seg5_vertex_0501F480[] = {
    {{{     7,     37,     35}, 0, {     0,      0}, {0xe0, 0x45, 0x64, 0xff}}},
    {{{    80,     24,     30}, 0, {     0,      0}, {0x35, 0x44, 0x5d, 0x00}}},
    {{{    81,     36,      4}, 0, {     0,      0}, {0x2f, 0x75, 0xfe, 0x00}}},
    {{{   -21,    -10,    -11}, 0, {     0,      0}, {0x98, 0xf4, 0xba, 0xff}}},
    {{{   -16,     30,      5}, 0, {     0,      0}, {0x99, 0x49, 0xfc, 0xff}}},
    {{{    10,     38,    -23}, 0, {     0,      0}, {0xe3, 0x46, 0x9b, 0xff}}},
    {{{   -20,    -10,     21}, 0, {     0,      0}, {0x93, 0xe3, 0x38, 0xff}}},
    {{{    76,     25,    -19}, 0, {     0,      0}, {0x33, 0x44, 0xa3, 0xff}}},
    {{{    78,    -21,    -28}, 0, {     0,      0}, {0x24, 0xfb, 0x87, 0xff}}},
    {{{    77,    -21,     38}, 0, {     0,      0}, {0x24, 0xf7, 0x79, 0xff}}},
    {{{   115,    -16,    -12}, 0, {     0,      0}, {0x63, 0xd2, 0xc1, 0xff}}},
    {{{   114,    -16,     21}, 0, {     0,      0}, {0x5f, 0xbf, 0x34, 0xff}}},
};

// 0x0501F540
static const Vtx yoshi_seg5_vertex_0501F540[] = {
    {{{    94,    -67,    -16}, 0, {     0,      0}, {0x2c, 0x8d, 0xe5, 0x00}}},
    {{{    22,    -63,     23}, 0, {     0,      0}, {0xdc, 0xa3, 0x4d, 0x00}}},
    {{{    18,    -83,    -16}, 0, {     0,      0}, {0xd9, 0x96, 0xc9, 0x00}}},
    {{{   105,     35,    -31}, 0, {     0,      0}, {0x1f, 0x1d, 0x89, 0xff}}},
    {{{    21,     52,    -37}, 0, {     0,      0}, {0xf2, 0x2c, 0x8a, 0xff}}},
    {{{    27,     83,    -12}, 0, {     0,      0}, {0xf9, 0x78, 0xd9, 0xff}}},
    {{{   -27,    -31,    -16}, 0, {     0,      0}, {0x91, 0xce, 0xde, 0xff}}},
    {{{   -24,    -13,     23}, 0, {     0,      0}, {0x9d, 0xe9, 0x4b, 0xff}}},
    {{{   -21,     60,    -16}, 0, {     0,      0}, {0xa0, 0x30, 0xbe, 0xff}}},
    {{{   148,     27,    -12}, 0, {     0,      0}, {0x79, 0x22, 0xf2, 0xff}}},
    {{{   127,    -25,     23}, 0, {     0,      0}, {0x5b, 0xd0, 0x49, 0xff}}},
    {{{   135,    -34,    -16}, 0, {     0,      0}, {0x5c, 0xd1, 0xb8, 0xff}}},
    {{{    82,    -36,     45}, 0, {     0,      0}, {0x18, 0xcd, 0x71, 0xff}}},
    {{{    21,     52,     44}, 0, {     0,      0}, {0xf7, 0x38, 0x71, 0xff}}},
    {{{    20,    -24,     44}, 0, {     0,      0}, {0xdf, 0xe3, 0x76, 0xff}}},
    {{{     8,     -9,    -37}, 0, {     0,      0}, {0xea, 0xf1, 0x85, 0xff}}},
};

// 0x0501F640
static const Vtx yoshi_seg5_vertex_0501F640[] = {
    {{{   105,     35,    -31}, 0, {     0,      0}, {0x1f, 0x1d, 0x89, 0xff}}},
    {{{   111,     66,    -12}, 0, {     0,      0}, {0x37, 0x71, 0xf9, 0x00}}},
    {{{   148,     27,    -12}, 0, {     0,      0}, {0x79, 0x22, 0xf2, 0x00}}},
    {{{   -21,     60,    -16}, 0, {     0,      0}, {0xa0, 0x30, 0xbe, 0xff}}},
    {{{    27,     83,    -12}, 0, {     0,      0}, {0xf9, 0x78, 0xd9, 0xff}}},
    {{{    21,     52,    -37}, 0, {     0,      0}, {0xf2, 0x2c, 0x8a, 0xff}}},
    {{{    21,     52,     44}, 0, {     0,      0}, {0xf7, 0x38, 0x71, 0xff}}},
    {{{   -21,     60,     23}, 0, {     0,      0}, {0xaf, 0x4e, 0x3a, 0xff}}},
    {{{   105,     35,     38}, 0, {     0,      0}, {0x3e, 0x2c, 0x65, 0xff}}},
    {{{   127,    -25,     23}, 0, {     0,      0}, {0x5b, 0xd0, 0x49, 0xff}}},
    {{{    82,    -36,     45}, 0, {     0,      0}, {0x18, 0xcd, 0x71, 0xff}}},
    {{{    94,    -67,    -16}, 0, {     0,      0}, {0x2c, 0x8d, 0xe5, 0xff}}},
    {{{   -24,    -13,     23}, 0, {     0,      0}, {0x9d, 0xe9, 0x4b, 0xff}}},
    {{{    22,    -63,     23}, 0, {     0,      0}, {0xdc, 0xa3, 0x4d, 0xff}}},
    {{{    20,    -24,     44}, 0, {     0,      0}, {0xdf, 0xe3, 0x76, 0xff}}},
};

// 0x0501F730
static const Vtx yoshi_seg5_vertex_0501F730[] = {
    {{{     8,     -9,    -37}, 0, {     0,      0}, {0xea, 0xf1, 0x85, 0xff}}},
    {{{    18,    -83,    -16}, 0, {     0,      0}, {0xd9, 0x96, 0xc9, 0x00}}},
    {{{   -27,    -31,    -16}, 0, {     0,      0}, {0x91, 0xce, 0xde, 0x00}}},
    {{{    94,    -67,    -16}, 0, {     0,      0}, {0x2c, 0x8d, 0xe5, 0xff}}},
    {{{    93,    -26,    -37}, 0, {     0,      0}, {0x16, 0xe6, 0x86, 0xff}}},
    {{{   135,    -34,    -16}, 0, {     0,      0}, {0x5c, 0xd1, 0xb8, 0xff}}},
    {{{   127,    -25,     23}, 0, {     0,      0}, {0x5b, 0xd0, 0x49, 0xff}}},
    {{{   148,     27,    -12}, 0, {     0,      0}, {0x79, 0x22, 0xf2, 0xff}}},
    {{{   105,     35,     38}, 0, {     0,      0}, {0x3e, 0x2c, 0x65, 0xff}}},
    {{{   105,     35,    -31}, 0, {     0,      0}, {0x1f, 0x1d, 0x89, 0xff}}},
    {{{    21,     52,     44}, 0, {     0,      0}, {0xf7, 0x38, 0x71, 0xff}}},
    {{{   -21,     60,     23}, 0, {     0,      0}, {0xaf, 0x4e, 0x3a, 0xff}}},
    {{{   -24,    -13,     23}, 0, {     0,      0}, {0x9d, 0xe9, 0x4b, 0xff}}},
    {{{   -21,     60,    -16}, 0, {     0,      0}, {0xa0, 0x30, 0xbe, 0xff}}},
    {{{   111,     66,    -12}, 0, {     0,      0}, {0x37, 0x71, 0xf9, 0xff}}},
};

// 0x0501F820
static const Vtx yoshi_seg5_vertex_0501F820[] = {
    {{{    82,    -36,     45}, 0, {     0,      0}, {0x18, 0xcd, 0x71, 0xff}}},
    {{{    20,    -24,     44}, 0, {     0,      0}, {0xdf, 0xe3, 0x76, 0x00}}},
    {{{    22,    -63,     23}, 0, {     0,      0}, {0xdc, 0xa3, 0x4d, 0x00}}},
    {{{   -27,    -31,    -16}, 0, {     0,      0}, {0x91, 0xce, 0xde, 0xff}}},
    {{{    18,    -83,    -16}, 0, {     0,      0}, {0xd9, 0x96, 0xc9, 0xff}}},
    {{{    94,    -67,    -16}, 0, {     0,      0}, {0x2c, 0x8d, 0xe5, 0xff}}},
    {{{     8,     -9,    -37}, 0, {     0,      0}, {0xea, 0xf1, 0x85, 0xff}}},
    {{{    27,     83,    -12}, 0, {     0,      0}, {0xf9, 0x78, 0xd9, 0xff}}},
    {{{   -21,     60,    -16}, 0, {     0,      0}, {0xa0, 0x30, 0xbe, 0xff}}},
    {{{   -21,     60,     23}, 0, {     0,      0}, {0xaf, 0x4e, 0x3a, 0xff}}},
    {{{    93,    -26,    -37}, 0, {     0,      0}, {0x16, 0xe6, 0x86, 0xff}}},
    {{{   -24,    -13,     23}, 0, {     0,      0}, {0x9d, 0xe9, 0x4b, 0xff}}},
    {{{   111,     66,    -12}, 0, {     0,      0}, {0x37, 0x71, 0xf9, 0xff}}},
    {{{    21,     52,     44}, 0, {     0,      0}, {0xf7, 0x38, 0x71, 0xff}}},
    {{{    21,     52,    -37}, 0, {     0,      0}, {0xf2, 0x2c, 0x8a, 0xff}}},
};

// 0x0501F910
static const Vtx yoshi_seg5_vertex_0501F910[] = {
    {{{   135,    -34,    -16}, 0, {     0,      0}, {0x5c, 0xd1, 0xb8, 0xff}}},
    {{{    93,    -26,    -37}, 0, {     0,      0}, {0x16, 0xe6, 0x86, 0x00}}},
    {{{   105,     35,    -31}, 0, {     0,      0}, {0x1f, 0x1d, 0x89, 0x00}}},
    {{{   105,     35,     38}, 0, {     0,      0}, {0x3e, 0x2c, 0x65, 0xff}}},
    {{{    82,    -36,     45}, 0, {     0,      0}, {0x18, 0xcd, 0x71, 0xff}}},
    {{{   127,    -25,     23}, 0, {     0,      0}, {0x5b, 0xd0, 0x49, 0xff}}},
    {{{     8,     -9,    -37}, 0, {     0,      0}, {0xea, 0xf1, 0x85, 0xff}}},
    {{{    21,     52,     44}, 0, {     0,      0}, {0xf7, 0x38, 0x71, 0xff}}},
    {{{   -24,    -13,     23}, 0, {     0,      0}, {0x9d, 0xe9, 0x4b, 0xff}}},
    {{{   -21,     60,     23}, 0, {     0,      0}, {0xaf, 0x4e, 0x3a, 0xff}}},
    {{{   -21,     60,    -16}, 0, {     0,      0}, {0xa0, 0x30, 0xbe, 0xff}}},
    {{{    27,     83,    -12}, 0, {     0,      0}, {0xf9, 0x78, 0xd9, 0xff}}},
    {{{   111,     66,    -12}, 0, {     0,      0}, {0x37, 0x71, 0xf9, 0xff}}},
    {{{    22,    -63,     23}, 0, {     0,      0}, {0xdc, 0xa3, 0x4d, 0xff}}},
    {{{    94,    -67,    -16}, 0, {     0,      0}, {0x2c, 0x8d, 0xe5, 0xff}}},
};

// 0x0501FA00
static const Vtx yoshi_seg5_vertex_0501FA00[] = {
    {{{   153,     13,     26}, 0, {     0,      0}, {0x26, 0x45, 0x62, 0x00}}},
    {{{   163,     33,      0}, 0, {     0,      0}, {0x2c, 0x76, 0x06, 0x00}}},
    {{{    36,     83,      0}, 0, {     0,      0}, {0x11, 0x7d, 0x02, 0x00}}},
    {{{    28,     40,     63}, 0, {     0,      0}, {0x04, 0x38, 0x71, 0xff}}},
    {{{     8,    -59,     89}, 0, {     0,      0}, {0xf4, 0xcb, 0x72, 0xff}}},
    {{{   109,    -42,     53}, 0, {     0,      0}, {0x30, 0xe6, 0x72, 0xff}}},
    {{{   111,    -42,    -54}, 0, {     0,      0}, {0x30, 0xdf, 0x90, 0xff}}},
    {{{     8,    -59,    -89}, 0, {     0,      0}, {0xea, 0xd7, 0x8b, 0xff}}},
    {{{    28,     40,    -64}, 0, {     0,      0}, {0x10, 0x3e, 0x93, 0xff}}},
    {{{   -21,     53,     45}, 0, {     0,      0}, {0xda, 0x5c, 0x4d, 0xff}}},
    {{{   -21,     53,    -45}, 0, {     0,      0}, {0xcf, 0x51, 0xac, 0xff}}},
    {{{   153,     13,    -32}, 0, {     0,      0}, {0x28, 0x47, 0x9f, 0xff}}},
    {{{   -41,    -20,     45}, 0, {     0,      0}, {0x9a, 0xe5, 0x46, 0xff}}},
    {{{   -41,    -20,    -45}, 0, {     0,      0}, {0x96, 0xe0, 0xc3, 0xff}}},
    {{{   254,      1,      0}, 0, {     0,      0}, {0x7a, 0xe0, 0x06, 0xff}}},
};

// 0x0501FAF0
static const Vtx yoshi_seg5_vertex_0501FAF0[] = {
    {{{   -41,    -20,     45}, 0, {     0,      0}, {0x9a, 0xe5, 0x46, 0x00}}},
    {{{   -41,    -20,    -45}, 0, {     0,      0}, {0x96, 0xe0, 0xc3, 0x00}}},
    {{{    -7,    -89,    -41}, 0, {     0,      0}, {0xbc, 0x9a, 0xe2, 0x00}}},
    {{{     8,    -59,     89}, 0, {     0,      0}, {0xf4, 0xcb, 0x72, 0xff}}},
    {{{    -7,    -89,     42}, 0, {     0,      0}, {0xe1, 0x8a, 0x1f, 0xff}}},
    {{{   111,    -42,    -54}, 0, {     0,      0}, {0x30, 0xdf, 0x90, 0xff}}},
    {{{   254,      1,      0}, 0, {     0,      0}, {0x7a, 0xe0, 0x06, 0xff}}},
    {{{    95,    -65,    -30}, 0, {     0,      0}, {0x27, 0x8c, 0xe2, 0xff}}},
    {{{    95,    -65,     30}, 0, {     0,      0}, {0x2a, 0x90, 0x27, 0xff}}},
    {{{     8,    -59,    -89}, 0, {     0,      0}, {0xea, 0xd7, 0x8b, 0xff}}},
    {{{   109,    -42,     53}, 0, {     0,      0}, {0x30, 0xe6, 0x72, 0xff}}},
};

// 0x0501FBA0
static const Vtx yoshi_seg5_vertex_0501FBA0[] = {
    {{{   169,    -51,     34}, 0, {     0,      0}, {0x3a, 0x9c, 0x33, 0x00}}},
    {{{   212,      0,    -39}, 0, {     0,      0}, {0x5c, 0xb4, 0xd7, 0x00}}},
    {{{   212,      0,     34}, 0, {     0,      0}, {0x54, 0xba, 0x3f, 0x00}}},
    {{{   169,    -51,    -39}, 0, {     0,      0}, {0x34, 0xa5, 0xba, 0xff}}},
    {{{    71,    -20,     33}, 0, {     0,      0}, {0xb8, 0xa1, 0x29, 0xff}}},
    {{{   119,    -59,    -29}, 0, {     0,      0}, {0xe0, 0x89, 0xe4, 0xff}}},
    {{{   119,    -59,     26}, 0, {     0,      0}, {0xe1, 0x8e, 0x2c, 0xff}}},
    {{{    71,    -20,    -36}, 0, {     0,      0}, {0xbd, 0xa3, 0xcc, 0xff}}},
    {{{   124,    -26,    -70}, 0, {     0,      0}, {0xed, 0xc4, 0x93, 0xff}}},
    {{{    38,     19,    -55}, 0, {     0,      0}, {0xe7, 0xfa, 0x84, 0xff}}},
    {{{    63,     80,    -66}, 0, {     0,      0}, {0xdf, 0xfc, 0x86, 0xff}}},
    {{{    38,     19,     49}, 0, {     0,      0}, {0xe8, 0xfc, 0x7c, 0xff}}},
    {{{   124,    -26,     65}, 0, {     0,      0}, {0xed, 0xc6, 0x6f, 0xff}}},
    {{{    63,     80,     58}, 0, {     0,      0}, {0xdf, 0xfe, 0x7a, 0xff}}},
    {{{   155,     31,    -76}, 0, {     0,      0}, {0x1d, 0xe3, 0x89, 0xff}}},
};

// 0x0501FC90
static const Vtx yoshi_seg5_vertex_0501FC90[] = {
    {{{    38,     19,     49}, 0, {     0,      0}, {0xe8, 0xfc, 0x7c, 0xff}}},
    {{{   -11,     53,     25}, 0, {     0,      0}, {0xcc, 0x02, 0x73, 0x00}}},
    {{{   -13,     33,     25}, 0, {     0,      0}, {0xd6, 0x24, 0x71, 0x00}}},
    {{{    11,    -20,    -65}, 0, {     0,      0}, {0xf8, 0x23, 0x87, 0xff}}},
    {{{   -13,     33,    -29}, 0, {     0,      0}, {0xd4, 0x24, 0x90, 0xff}}},
    {{{    38,     19,    -55}, 0, {     0,      0}, {0xe7, 0xfa, 0x84, 0xff}}},
    {{{   124,    -26,     65}, 0, {     0,      0}, {0xed, 0xc6, 0x6f, 0xff}}},
    {{{   155,     31,     71}, 0, {     0,      0}, {0x1c, 0xe3, 0x78, 0xff}}},
    {{{    63,     80,     58}, 0, {     0,      0}, {0xdf, 0xfe, 0x7a, 0xff}}},
    {{{   -35,      4,    -37}, 0, {     0,      0}, {0xdc, 0x36, 0x94, 0xff}}},
    {{{   124,    -26,    -70}, 0, {     0,      0}, {0xed, 0xc4, 0x93, 0xff}}},
    {{{   169,    -51,    -39}, 0, {     0,      0}, {0x34, 0xa5, 0xba, 0xff}}},
    {{{   119,    -59,    -29}, 0, {     0,      0}, {0xe0, 0x89, 0xe4, 0xff}}},
    {{{   119,    -59,     26}, 0, {     0,      0}, {0xe1, 0x8e, 0x2c, 0xff}}},
    {{{   169,    -51,     34}, 0, {     0,      0}, {0x3a, 0x9c, 0x33, 0xff}}},
    {{{    71,    -20,    -36}, 0, {     0,      0}, {0xbd, 0xa3, 0xcc, 0xff}}},
};

// 0x0501FD90
static const Vtx yoshi_seg5_vertex_0501FD90[] = {
    {{{    71,    -20,     33}, 0, {     0,      0}, {0xb8, 0xa1, 0x29, 0xff}}},
    {{{   119,    -59,     26}, 0, {     0,      0}, {0xe1, 0x8e, 0x2c, 0x00}}},
    {{{   124,    -26,     65}, 0, {     0,      0}, {0xed, 0xc6, 0x6f, 0x00}}},
    {{{    70,    -52,     32}, 0, {     0,      0}, {0xc5, 0x90, 0x00, 0xff}}},
    {{{    11,    -20,     60}, 0, {     0,      0}, {0xc5, 0x90, 0x00, 0xff}}},
    {{{   -35,      4,     31}, 0, {     0,      0}, {0xc5, 0x90, 0x00, 0xff}}},
    {{{   124,    -26,    -70}, 0, {     0,      0}, {0xed, 0xc4, 0x93, 0xff}}},
    {{{    71,    -20,    -36}, 0, {     0,      0}, {0xbd, 0xa3, 0xcc, 0xff}}},
    {{{    38,     19,    -55}, 0, {     0,      0}, {0xe7, 0xfa, 0x84, 0xff}}},
    {{{    38,     19,     49}, 0, {     0,      0}, {0xe8, 0xfc, 0x7c, 0xff}}},
    {{{   -35,      4,    -37}, 0, {     0,      0}, {0xc5, 0x90, 0x00, 0xff}}},
    {{{    11,    -20,    -65}, 0, {     0,      0}, {0xc5, 0x90, 0x00, 0xff}}},
    {{{    70,    -52,    -35}, 0, {     0,      0}, {0xc5, 0x90, 0x00, 0xff}}},
    {{{    11,    108,    -40}, 0, {     0,      0}, {0xc9, 0x03, 0x8e, 0xff}}},
    {{{    63,     80,    -66}, 0, {     0,      0}, {0xdf, 0xfc, 0x86, 0xff}}},
    {{{   -11,     53,    -30}, 0, {     0,      0}, {0xc9, 0x02, 0x8e, 0xff}}},
};

// 0x0501FE90
static const Vtx yoshi_seg5_vertex_0501FE90[] = {
    {{{   155,     31,    -76}, 0, {     0,      0}, {0x1d, 0xe3, 0x89, 0xff}}},
    {{{   212,      0,    -39}, 0, {     0,      0}, {0x5c, 0xb4, 0xd7, 0x00}}},
    {{{   169,    -51,    -39}, 0, {     0,      0}, {0x34, 0xa5, 0xba, 0x00}}},
    {{{   119,    -59,    -29}, 0, {     0,      0}, {0xe0, 0x89, 0xe4, 0xff}}},
    {{{   169,    -51,     34}, 0, {     0,      0}, {0x3a, 0x9c, 0x33, 0xff}}},
    {{{   119,    -59,     26}, 0, {     0,      0}, {0xe1, 0x8e, 0x2c, 0xff}}},
    {{{   212,      0,     34}, 0, {     0,      0}, {0x54, 0xba, 0x3f, 0xff}}},
    {{{   155,     31,     71}, 0, {     0,      0}, {0x1c, 0xe3, 0x78, 0xff}}},
    {{{   124,    -26,    -70}, 0, {     0,      0}, {0xed, 0xc4, 0x93, 0xff}}},
    {{{   124,    -26,     65}, 0, {     0,      0}, {0xed, 0xc6, 0x6f, 0xff}}},
    {{{    11,    108,    -40}, 0, {     0,      0}, {0x8b, 0x31, 0x00, 0xff}}},
    {{{   -11,     53,    -30}, 0, {     0,      0}, {0x84, 0x19, 0x00, 0xff}}},
    {{{   -11,     53,     25}, 0, {     0,      0}, {0x87, 0x25, 0x00, 0xff}}},
    {{{    11,    108,     33}, 0, {     0,      0}, {0xcd, 0x04, 0x73, 0xff}}},
    {{{   -11,     53,     25}, 0, {     0,      0}, {0xcc, 0x02, 0x73, 0xff}}},
    {{{    38,     19,     49}, 0, {     0,      0}, {0xe8, 0xfc, 0x7c, 0xff}}},
};

// 0x0501FF90
static const Vtx yoshi_seg5_vertex_0501FF90[] = {
    {{{   -11,     53,    -30}, 0, {     0,      0}, {0x84, 0x19, 0x00, 0xff}}},
    {{{   -13,     33,    -29}, 0, {     0,      0}, {0x8f, 0x38, 0x00, 0x00}}},
    {{{   -13,     33,     25}, 0, {     0,      0}, {0x86, 0x22, 0x00, 0x00}}},
    {{{   -13,     33,     25}, 0, {     0,      0}, {0xd6, 0x24, 0x71, 0xff}}},
    {{{   -35,      4,     31}, 0, {     0,      0}, {0xdb, 0x35, 0x6d, 0xff}}},
    {{{    11,    -20,     60}, 0, {     0,      0}, {0xf9, 0x25, 0x79, 0xff}}},
    {{{    11,    108,    -40}, 0, {     0,      0}, {0x8b, 0x31, 0x00, 0xff}}},
    {{{   -11,     53,     25}, 0, {     0,      0}, {0x87, 0x25, 0x00, 0xff}}},
    {{{    11,    108,     33}, 0, {     0,      0}, {0x8b, 0x31, 0x00, 0xff}}},
    {{{    11,    108,     33}, 0, {     0,      0}, {0xcd, 0x04, 0x73, 0xff}}},
    {{{    38,     19,     49}, 0, {     0,      0}, {0xe8, 0xfc, 0x7c, 0xff}}},
    {{{    63,     80,     58}, 0, {     0,      0}, {0xdf, 0xfe, 0x7a, 0xff}}},
    {{{   -13,     33,    -29}, 0, {     0,      0}, {0xd4, 0x24, 0x90, 0xff}}},
    {{{   -11,     53,    -30}, 0, {     0,      0}, {0xc9, 0x02, 0x8e, 0xff}}},
    {{{    38,     19,    -55}, 0, {     0,      0}, {0xe7, 0xfa, 0x84, 0xff}}},
};

// 0x05020080
static const Vtx yoshi_seg5_vertex_05020080[] = {
    {{{   -13,     33,    -29}, 0, {     0,      0}, {0x8f, 0x38, 0x00, 0xff}}},
    {{{   -35,      4,    -37}, 0, {     0,      0}, {0x9b, 0x4b, 0x00, 0x00}}},
    {{{   -35,      4,     31}, 0, {     0,      0}, {0x9b, 0x4b, 0x00, 0x00}}},
    {{{    71,    -20,     33}, 0, {     0,      0}, {0x7e, 0xfc, 0x00, 0xff}}},
    {{{    70,    -52,     32}, 0, {     0,      0}, {0x7e, 0xfc, 0x00, 0xff}}},
    {{{    70,    -52,    -35}, 0, {     0,      0}, {0x7e, 0xfc, 0x00, 0xff}}},
    {{{    38,     19,    -55}, 0, {     0,      0}, {0xe7, 0xfa, 0x84, 0xff}}},
    {{{    70,    -52,    -35}, 0, {     0,      0}, {0x36, 0xf9, 0x8e, 0xff}}},
    {{{    11,    -20,    -65}, 0, {     0,      0}, {0xf8, 0x23, 0x87, 0xff}}},
    {{{    11,    -20,     60}, 0, {     0,      0}, {0xf9, 0x25, 0x79, 0xff}}},
    {{{    70,    -52,     32}, 0, {     0,      0}, {0x32, 0xfc, 0x74, 0xff}}},
    {{{    38,     19,     49}, 0, {     0,      0}, {0xe8, 0xfc, 0x7c, 0xff}}},
    {{{    71,    -20,     33}, 0, {     0,      0}, {0x30, 0xfb, 0x75, 0xff}}},
    {{{    71,    -20,    -36}, 0, {     0,      0}, {0x39, 0xfa, 0x8f, 0xff}}},
    {{{    71,    -20,    -36}, 0, {     0,      0}, {0x7e, 0xfc, 0x00, 0xff}}},
    {{{   -13,     33,     25}, 0, {     0,      0}, {0x86, 0x22, 0x00, 0xff}}},
};

// 0x05020180
static const Vtx yoshi_seg5_vertex_05020180[] = {
    {{{    63,     80,     58}, 0, {     0,      0}, {0x3b, 0x70, 0x00, 0xff}}},
    {{{   155,     31,     71}, 0, {     0,      0}, {0x3b, 0x70, 0xff, 0x00}}},
    {{{   212,      0,     34}, 0, {     0,      0}, {0x3b, 0x70, 0x00, 0x00}}},
    {{{    11,    108,     33}, 0, {     0,      0}, {0x3c, 0x6f, 0x01, 0xff}}},
    {{{    11,    108,    -40}, 0, {     0,      0}, {0x3c, 0x6f, 0x00, 0xff}}},
    {{{    63,     80,    -66}, 0, {     0,      0}, {0x3b, 0x70, 0x00, 0xff}}},
    {{{   155,     31,    -76}, 0, {     0,      0}, {0x3b, 0x70, 0x00, 0xff}}},
    {{{   212,      0,    -39}, 0, {     0,      0}, {0x3c, 0x6f, 0x00, 0xff}}},
};

// 0x05020200
static const Vtx yoshi_seg5_vertex_05020200[] = {
    {{{     2,    -48,     17}, 0, {     0,      0}, {0xba, 0xa0, 0x2a, 0x00}}},
    {{{     4,    -48,    -28}, 0, {     0,      0}, {0xda, 0x91, 0xd2, 0x00}}},
    {{{    77,    -40,     10}, 0, {     0,      0}, {0x26, 0x90, 0x2b, 0x00}}},
    {{{     7,     53,     -4}, 0, {     0,      0}, {0xde, 0x7a, 0x03, 0xff}}},
    {{{    10,     38,     23}, 0, {     0,      0}, {0xe3, 0x46, 0x65, 0xff}}},
    {{{    81,     36,     -4}, 0, {     0,      0}, {0x2f, 0x75, 0x02, 0xff}}},
    {{{    76,    -40,    -20}, 0, {     0,      0}, {0x24, 0x99, 0xc1, 0xff}}},
    {{{    76,     25,     19}, 0, {     0,      0}, {0x33, 0x44, 0x5d, 0xff}}},
    {{{     3,    -26,    -42}, 0, {     0,      0}, {0xe2, 0xd8, 0x8c, 0xff}}},
    {{{     7,     37,    -35}, 0, {     0,      0}, {0xe0, 0x45, 0x9c, 0xff}}},
    {{{    77,    -21,    -38}, 0, {     0,      0}, {0x24, 0xf7, 0x87, 0xff}}},
    {{{     3,    -26,     33}, 0, {     0,      0}, {0xe1, 0xd9, 0x74, 0xff}}},
    {{{    78,    -21,     28}, 0, {     0,      0}, {0x24, 0xfb, 0x79, 0xff}}},
    {{{   117,      6,     -5}, 0, {     0,      0}, {0x68, 0x48, 0x00, 0xff}}},
    {{{   -16,     30,     -5}, 0, {     0,      0}, {0x99, 0x49, 0x04, 0xff}}},
    {{{    80,     24,    -30}, 0, {     0,      0}, {0x35, 0x44, 0xa3, 0xff}}},
};

// 0x05020300
static const Vtx yoshi_seg5_vertex_05020300[] = {
    {{{   114,    -16,    -21}, 0, {     0,      0}, {0x5f, 0xbf, 0xcc, 0xff}}},
    {{{    76,    -40,    -20}, 0, {     0,      0}, {0x24, 0x99, 0xc1, 0x00}}},
    {{{    77,    -21,    -38}, 0, {     0,      0}, {0x24, 0xf7, 0x87, 0x00}}},
    {{{     3,    -26,    -42}, 0, {     0,      0}, {0xe2, 0xd8, 0x8c, 0xff}}},
    {{{     4,    -48,    -28}, 0, {     0,      0}, {0xda, 0x91, 0xd2, 0xff}}},
    {{{   -20,    -10,    -21}, 0, {     0,      0}, {0x93, 0xe3, 0xc8, 0xff}}},
    {{{   -21,    -10,     11}, 0, {     0,      0}, {0x98, 0xf4, 0x46, 0xff}}},
    {{{     2,    -48,     17}, 0, {     0,      0}, {0xba, 0xa0, 0x2a, 0xff}}},
    {{{     3,    -26,     33}, 0, {     0,      0}, {0xe1, 0xd9, 0x74, 0xff}}},
    {{{   115,    -16,     12}, 0, {     0,      0}, {0x63, 0xd2, 0x3f, 0xff}}},
    {{{    78,    -21,     28}, 0, {     0,      0}, {0x24, 0xfb, 0x79, 0xff}}},
    {{{    77,    -40,     10}, 0, {     0,      0}, {0x26, 0x90, 0x2b, 0xff}}},
    {{{    80,     24,    -30}, 0, {     0,      0}, {0x35, 0x44, 0xa3, 0xff}}},
    {{{   117,      6,     -5}, 0, {     0,      0}, {0x68, 0x48, 0x00, 0xff}}},
    {{{    76,     25,     19}, 0, {     0,      0}, {0x33, 0x44, 0x5d, 0xff}}},
    {{{     7,     37,    -35}, 0, {     0,      0}, {0xe0, 0x45, 0x9c, 0xff}}},
};

// 0x05020400
static const Vtx yoshi_seg5_vertex_05020400[] = {
    {{{    10,     38,     23}, 0, {     0,      0}, {0xe3, 0x46, 0x65, 0xff}}},
    {{{   -21,    -10,     11}, 0, {     0,      0}, {0x98, 0xf4, 0x46, 0x00}}},
    {{{     3,    -26,     33}, 0, {     0,      0}, {0xe1, 0xd9, 0x74, 0x00}}},
    {{{     7,     37,    -35}, 0, {     0,      0}, {0xe0, 0x45, 0x9c, 0xff}}},
    {{{     7,     53,     -4}, 0, {     0,      0}, {0xde, 0x7a, 0x03, 0xff}}},
    {{{    81,     36,     -4}, 0, {     0,      0}, {0x2f, 0x75, 0x02, 0xff}}},
    {{{   115,    -16,     12}, 0, {     0,      0}, {0x63, 0xd2, 0x3f, 0xff}}},
    {{{    77,    -40,     10}, 0, {     0,      0}, {0x26, 0x90, 0x2b, 0xff}}},
    {{{   114,    -16,    -21}, 0, {     0,      0}, {0x5f, 0xbf, 0xcc, 0xff}}},
    {{{    77,    -21,    -38}, 0, {     0,      0}, {0x24, 0xf7, 0x87, 0xff}}},
    {{{    76,    -40,    -20}, 0, {     0,      0}, {0x24, 0x99, 0xc1, 0xff}}},
    {{{     3,    -26,    -42}, 0, {     0,      0}, {0xe2, 0xd8, 0x8c, 0xff}}},
    {{{   -20,    -10,    -21}, 0, {     0,      0}, {0x93, 0xe3, 0xc8, 0xff}}},
    {{{     4,    -48,    -28}, 0, {     0,      0}, {0xda, 0x91, 0xd2, 0xff}}},
    {{{     2,    -48,     17}, 0, {     0,      0}, {0xba, 0xa0, 0x2a, 0xff}}},
    {{{    78,    -21,     28}, 0, {     0,      0}, {0x24, 0xfb, 0x79, 0xff}}},
};

// 0x05020500
static const Vtx yoshi_seg5_vertex_05020500[] = {
    {{{    81,     36,     -4}, 0, {     0,      0}, {0x2f, 0x75, 0x02, 0xff}}},
    {{{    80,     24,    -30}, 0, {     0,      0}, {0x35, 0x44, 0xa3, 0x00}}},
    {{{     7,     37,    -35}, 0, {     0,      0}, {0xe0, 0x45, 0x9c, 0x00}}},
    {{{    10,     38,     23}, 0, {     0,      0}, {0xe3, 0x46, 0x65, 0xff}}},
    {{{   -16,     30,     -5}, 0, {     0,      0}, {0x99, 0x49, 0x04, 0xff}}},
    {{{   -21,    -10,     11}, 0, {     0,      0}, {0x98, 0xf4, 0x46, 0xff}}},
    {{{   -20,    -10,    -21}, 0, {     0,      0}, {0x93, 0xe3, 0xc8, 0xff}}},
    {{{    78,    -21,     28}, 0, {     0,      0}, {0x24, 0xfb, 0x79, 0xff}}},
    {{{    76,     25,     19}, 0, {     0,      0}, {0x33, 0x44, 0x5d, 0xff}}},
    {{{    77,    -21,    -38}, 0, {     0,      0}, {0x24, 0xf7, 0x87, 0xff}}},
    {{{   115,    -16,     12}, 0, {     0,      0}, {0x63, 0xd2, 0x3f, 0xff}}},
    {{{   114,    -16,    -21}, 0, {     0,      0}, {0x5f, 0xbf, 0xcc, 0xff}}},
};

// 0x050205C0
static const Vtx yoshi_seg5_vertex_050205C0[] = {
    {{{    18,    -83,     16}, 0, {     0,      0}, {0xd9, 0x96, 0x37, 0x00}}},
    {{{    22,    -63,    -23}, 0, {     0,      0}, {0xdc, 0xa3, 0xb3, 0x00}}},
    {{{    94,    -67,     16}, 0, {     0,      0}, {0x2c, 0x8d, 0x1b, 0x00}}},
    {{{    27,     83,     12}, 0, {     0,      0}, {0xf9, 0x78, 0x27, 0xff}}},
    {{{    21,     52,     37}, 0, {     0,      0}, {0xf2, 0x2c, 0x76, 0xff}}},
    {{{   105,     35,     31}, 0, {     0,      0}, {0x1f, 0x1d, 0x77, 0xff}}},
    {{{   -21,     60,     16}, 0, {     0,      0}, {0xa0, 0x30, 0x42, 0xff}}},
    {{{   -24,    -13,    -23}, 0, {     0,      0}, {0x9d, 0xe9, 0xb5, 0xff}}},
    {{{   -27,    -31,     16}, 0, {     0,      0}, {0x91, 0xce, 0x22, 0xff}}},
    {{{   135,    -34,     16}, 0, {     0,      0}, {0x5c, 0xd1, 0x48, 0xff}}},
    {{{   127,    -25,    -23}, 0, {     0,      0}, {0x5b, 0xd0, 0xb7, 0xff}}},
    {{{   148,     27,     12}, 0, {     0,      0}, {0x79, 0x22, 0x0e, 0xff}}},
    {{{    20,    -24,    -44}, 0, {     0,      0}, {0xdf, 0xe3, 0x8a, 0xff}}},
    {{{    21,     52,    -44}, 0, {     0,      0}, {0xf7, 0x38, 0x8f, 0xff}}},
    {{{    82,    -36,    -45}, 0, {     0,      0}, {0x18, 0xcd, 0x8f, 0xff}}},
    {{{     8,     -9,     37}, 0, {     0,      0}, {0xea, 0xf1, 0x7b, 0xff}}},
};

// 0x050206C0
static const Vtx yoshi_seg5_vertex_050206C0[] = {
    {{{   148,     27,     12}, 0, {     0,      0}, {0x79, 0x22, 0x0e, 0xff}}},
    {{{   111,     66,     12}, 0, {     0,      0}, {0x37, 0x71, 0x07, 0x00}}},
    {{{   105,     35,     31}, 0, {     0,      0}, {0x1f, 0x1d, 0x77, 0x00}}},
    {{{    21,     52,     37}, 0, {     0,      0}, {0xf2, 0x2c, 0x76, 0xff}}},
    {{{    27,     83,     12}, 0, {     0,      0}, {0xf9, 0x78, 0x27, 0xff}}},
    {{{   -21,     60,     16}, 0, {     0,      0}, {0xa0, 0x30, 0x42, 0xff}}},
    {{{   -21,     60,    -23}, 0, {     0,      0}, {0xaf, 0x4e, 0xc6, 0xff}}},
    {{{    21,     52,    -44}, 0, {     0,      0}, {0xf7, 0x38, 0x8f, 0xff}}},
    {{{   105,     35,    -38}, 0, {     0,      0}, {0x3e, 0x2c, 0x9b, 0xff}}},
    {{{    94,    -67,     16}, 0, {     0,      0}, {0x2c, 0x8d, 0x1b, 0xff}}},
    {{{    82,    -36,    -45}, 0, {     0,      0}, {0x18, 0xcd, 0x8f, 0xff}}},
    {{{   127,    -25,    -23}, 0, {     0,      0}, {0x5b, 0xd0, 0xb7, 0xff}}},
    {{{    20,    -24,    -44}, 0, {     0,      0}, {0xdf, 0xe3, 0x8a, 0xff}}},
    {{{    22,    -63,    -23}, 0, {     0,      0}, {0xdc, 0xa3, 0xb3, 0xff}}},
    {{{   -24,    -13,    -23}, 0, {     0,      0}, {0x9d, 0xe9, 0xb5, 0xff}}},
};

// 0x050207B0
static const Vtx yoshi_seg5_vertex_050207B0[] = {
    {{{   -27,    -31,     16}, 0, {     0,      0}, {0x91, 0xce, 0x22, 0xff}}},
    {{{    18,    -83,     16}, 0, {     0,      0}, {0xd9, 0x96, 0x37, 0x00}}},
    {{{     8,     -9,     37}, 0, {     0,      0}, {0xea, 0xf1, 0x7b, 0x00}}},
    {{{   135,    -34,     16}, 0, {     0,      0}, {0x5c, 0xd1, 0x48, 0xff}}},
    {{{    93,    -26,     37}, 0, {     0,      0}, {0x16, 0xe6, 0x7a, 0xff}}},
    {{{    94,    -67,     16}, 0, {     0,      0}, {0x2c, 0x8d, 0x1b, 0xff}}},
    {{{   105,     35,    -38}, 0, {     0,      0}, {0x3e, 0x2c, 0x9b, 0xff}}},
    {{{   148,     27,     12}, 0, {     0,      0}, {0x79, 0x22, 0x0e, 0xff}}},
    {{{   127,    -25,    -23}, 0, {     0,      0}, {0x5b, 0xd0, 0xb7, 0xff}}},
    {{{   105,     35,     31}, 0, {     0,      0}, {0x1f, 0x1d, 0x77, 0xff}}},
    {{{   -24,    -13,    -23}, 0, {     0,      0}, {0x9d, 0xe9, 0xb5, 0xff}}},
    {{{   -21,     60,    -23}, 0, {     0,      0}, {0xaf, 0x4e, 0xc6, 0xff}}},
    {{{    21,     52,    -44}, 0, {     0,      0}, {0xf7, 0x38, 0x8f, 0xff}}},
    {{{   -21,     60,     16}, 0, {     0,      0}, {0xa0, 0x30, 0x42, 0xff}}},
    {{{   111,     66,     12}, 0, {     0,      0}, {0x37, 0x71, 0x07, 0xff}}},
};

// 0x050208A0
static const Vtx yoshi_seg5_vertex_050208A0[] = {
    {{{    22,    -63,    -23}, 0, {     0,      0}, {0xdc, 0xa3, 0xb3, 0xff}}},
    {{{    20,    -24,    -44}, 0, {     0,      0}, {0xdf, 0xe3, 0x8a, 0x00}}},
    {{{    82,    -36,    -45}, 0, {     0,      0}, {0x18, 0xcd, 0x8f, 0x00}}},
    {{{    18,    -83,     16}, 0, {     0,      0}, {0xd9, 0x96, 0x37, 0xff}}},
    {{{   -27,    -31,     16}, 0, {     0,      0}, {0x91, 0xce, 0x22, 0xff}}},
    {{{     8,     -9,     37}, 0, {     0,      0}, {0xea, 0xf1, 0x7b, 0xff}}},
    {{{    94,    -67,     16}, 0, {     0,      0}, {0x2c, 0x8d, 0x1b, 0xff}}},
    {{{   -21,     60,    -23}, 0, {     0,      0}, {0xaf, 0x4e, 0xc6, 0xff}}},
    {{{   -21,     60,     16}, 0, {     0,      0}, {0xa0, 0x30, 0x42, 0xff}}},
    {{{    27,     83,     12}, 0, {     0,      0}, {0xf9, 0x78, 0x27, 0xff}}},
    {{{    93,    -26,     37}, 0, {     0,      0}, {0x16, 0xe6, 0x7a, 0xff}}},
    {{{   -24,    -13,    -23}, 0, {     0,      0}, {0x9d, 0xe9, 0xb5, 0xff}}},
    {{{    21,     52,    -44}, 0, {     0,      0}, {0xf7, 0x38, 0x8f, 0xff}}},
    {{{   111,     66,     12}, 0, {     0,      0}, {0x37, 0x71, 0x07, 0xff}}},
    {{{    21,     52,     37}, 0, {     0,      0}, {0xf2, 0x2c, 0x76, 0xff}}},
};

// 0x05020990
static const Vtx yoshi_seg5_vertex_05020990[] = {
    {{{   105,     35,     31}, 0, {     0,      0}, {0x1f, 0x1d, 0x77, 0xff}}},
    {{{    93,    -26,     37}, 0, {     0,      0}, {0x16, 0xe6, 0x7a, 0x00}}},
    {{{   135,    -34,     16}, 0, {     0,      0}, {0x5c, 0xd1, 0x48, 0x00}}},
    {{{   127,    -25,    -23}, 0, {     0,      0}, {0x5b, 0xd0, 0xb7, 0xff}}},
    {{{    82,    -36,    -45}, 0, {     0,      0}, {0x18, 0xcd, 0x8f, 0xff}}},
    {{{   105,     35,    -38}, 0, {     0,      0}, {0x3e, 0x2c, 0x9b, 0xff}}},
    {{{     8,     -9,     37}, 0, {     0,      0}, {0xea, 0xf1, 0x7b, 0xff}}},
    {{{    21,     52,    -44}, 0, {     0,      0}, {0xf7, 0x38, 0x8f, 0xff}}},
    {{{   -21,     60,     16}, 0, {     0,      0}, {0xa0, 0x30, 0x42, 0xff}}},
    {{{   -21,     60,    -23}, 0, {     0,      0}, {0xaf, 0x4e, 0xc6, 0xff}}},
    {{{   -24,    -13,    -23}, 0, {     0,      0}, {0x9d, 0xe9, 0xb5, 0xff}}},
    {{{   111,     66,     12}, 0, {     0,      0}, {0x37, 0x71, 0x07, 0xff}}},
    {{{    27,     83,     12}, 0, {     0,      0}, {0xf9, 0x78, 0x27, 0xff}}},
    {{{    94,    -67,     16}, 0, {     0,      0}, {0x2c, 0x8d, 0x1b, 0xff}}},
    {{{    22,    -63,    -23}, 0, {     0,      0}, {0xdc, 0xa3, 0xb3, 0xff}}},
};

// 0x05020A80
static const Vtx yoshi_seg5_vertex_05020A80[] = {
    {{{   255,     29,     39}, 0, {     0,      0}, {0x6c, 0x29, 0x33, 0x00}}},
    {{{   223,    -25,     39}, 0, {     0,      0}, {0x3a, 0xc1, 0x5d, 0x00}}},
    {{{   223,    -25,    -39}, 0, {     0,      0}, {0x46, 0xbe, 0xaf, 0x00}}},
    {{{   -75,     32,   -102}, 0, {     0,      0}, {0xb1, 0xab, 0xce, 0xff}}},
    {{{    37,    -69,    -49}, 0, {     0,      0}, {0x07, 0x86, 0xde, 0xff}}},
    {{{    37,    -69,     49}, 0, {     0,      0}, {0xe3, 0x8a, 0x22, 0xff}}},
    {{{   169,     50,     65}, 0, {     0,      0}, {0x2a, 0x20, 0x73, 0xff}}},
    {{{    43,     66,    101}, 0, {     0,      0}, {0x0a, 0x38, 0x71, 0xff}}},
    {{{   149,     11,     70}, 0, {     0,      0}, {0x23, 0xd1, 0x70, 0xff}}},
    {{{    43,     66,   -101}, 0, {     0,      0}, {0x0a, 0x37, 0x8f, 0xff}}},
    {{{   169,     50,    -65}, 0, {     0,      0}, {0x29, 0x1d, 0x8c, 0xff}}},
    {{{   147,      7,    -67}, 0, {     0,      0}, {0x21, 0xd1, 0x90, 0xff}}},
    {{{    68,    -51,    -49}, 0, {     0,      0}, {0x31, 0x95, 0xd2, 0xff}}},
    {{{    25,    -36,    -90}, 0, {     0,      0}, {0x10, 0xbc, 0x97, 0xff}}},
    {{{    25,    -36,     90}, 0, {     0,      0}, {0x0f, 0xbc, 0x69, 0xff}}},
    {{{    68,    -51,     49}, 0, {     0,      0}, {0x35, 0x96, 0x2c, 0xff}}},
};

// 0x05020B80
static const Vtx yoshi_seg5_vertex_05020B80[] = {
    {{{   126,    -32,     41}, 0, {     0,      0}, {0x1d, 0x9a, 0x44, 0xff}}},
    {{{   223,    -25,     39}, 0, {     0,      0}, {0x3a, 0xc1, 0x5d, 0x00}}},
    {{{   149,     11,     70}, 0, {     0,      0}, {0x23, 0xd1, 0x70, 0x00}}},
    {{{   147,      7,    -67}, 0, {     0,      0}, {0x21, 0xd1, 0x90, 0xff}}},
    {{{   223,    -25,    -39}, 0, {     0,      0}, {0x46, 0xbe, 0xaf, 0xff}}},
    {{{   128,    -30,    -44}, 0, {     0,      0}, {0x19, 0xa8, 0xa9, 0xff}}},
    {{{    25,    -36,     90}, 0, {     0,      0}, {0x0f, 0xbc, 0x69, 0xff}}},
    {{{    68,    -51,     49}, 0, {     0,      0}, {0x35, 0x96, 0x2c, 0xff}}},
    {{{    68,    -51,    -49}, 0, {     0,      0}, {0x31, 0x95, 0xd2, 0xff}}},
    {{{    25,    -36,    -90}, 0, {     0,      0}, {0x10, 0xbc, 0x97, 0xff}}},
    {{{    37,    -69,    -49}, 0, {     0,      0}, {0x07, 0x86, 0xde, 0xff}}},
    {{{   -75,     32,   -102}, 0, {     0,      0}, {0xb1, 0xab, 0xce, 0xff}}},
    {{{    43,     66,    101}, 0, {     0,      0}, {0x0a, 0x38, 0x71, 0xff}}},
    {{{   -75,     32,    102}, 0, {     0,      0}, {0xb5, 0xbe, 0x4d, 0xff}}},
    {{{   255,     29,     39}, 0, {     0,      0}, {0x6c, 0x29, 0x33, 0xff}}},
    {{{   169,     50,     65}, 0, {     0,      0}, {0x2a, 0x20, 0x73, 0xff}}},
};

// 0x05020C80
static const Vtx yoshi_seg5_vertex_05020C80[] = {
    {{{   169,     50,    -65}, 0, {     0,      0}, {0x29, 0x1d, 0x8c, 0xff}}},
    {{{   255,     29,    -39}, 0, {     0,      0}, {0x5d, 0x2b, 0xb6, 0x00}}},
    {{{   223,    -25,    -39}, 0, {     0,      0}, {0x46, 0xbe, 0xaf, 0x00}}},
    {{{   -75,     32,    102}, 0, {     0,      0}, {0xb5, 0xbe, 0x4d, 0xff}}},
    {{{    37,    -69,     49}, 0, {     0,      0}, {0xe3, 0x8a, 0x22, 0xff}}},
    {{{    25,    -36,     90}, 0, {     0,      0}, {0x0f, 0xbc, 0x69, 0xff}}},
    {{{   -75,     32,   -102}, 0, {     0,      0}, {0xb1, 0xab, 0xce, 0xff}}},
    {{{    43,     66,   -101}, 0, {     0,      0}, {0x0a, 0x37, 0x8f, 0xff}}},
    {{{    25,    -36,    -90}, 0, {     0,      0}, {0x10, 0xbc, 0x97, 0xff}}},
    {{{   126,    -32,     41}, 0, {     0,      0}, {0x1d, 0x9a, 0x44, 0xff}}},
    {{{    68,    -51,     49}, 0, {     0,      0}, {0x35, 0x96, 0x2c, 0xff}}},
    {{{    68,    -51,    -49}, 0, {     0,      0}, {0x31, 0x95, 0xd2, 0xff}}},
    {{{   128,    -30,    -44}, 0, {     0,      0}, {0x19, 0xa8, 0xa9, 0xff}}},
    {{{   147,      7,    -67}, 0, {     0,      0}, {0x21, 0xd1, 0x90, 0xff}}},
};

// 0x05020D60
static const Vtx yoshi_seg5_vertex_05020D60[] = {
    {{{   169,     50,     65}, 0, {     0,      0}, {0x2a, 0x20, 0x73, 0xff}}},
    {{{   149,     11,     70}, 0, {     0,      0}, {0x23, 0xd1, 0x70, 0x00}}},
    {{{   223,    -25,     39}, 0, {     0,      0}, {0x3a, 0xc1, 0x5d, 0x00}}},
    {{{    68,    -51,     49}, 0, {     0,      0}, {0x35, 0x96, 0x2c, 0xff}}},
    {{{    37,    -69,     49}, 0, {     0,      0}, {0xe3, 0x8a, 0x22, 0xff}}},
    {{{    37,    -69,    -49}, 0, {     0,      0}, {0x07, 0x86, 0xde, 0xff}}},
    {{{   147,      7,    -67}, 0, {     0,      0}, {0x21, 0xd1, 0x90, 0xff}}},
    {{{   128,    -30,    -44}, 0, {     0,      0}, {0x19, 0xa8, 0xa9, 0xff}}},
    {{{    68,    -51,    -49}, 0, {     0,      0}, {0x31, 0x95, 0xd2, 0xff}}},
    {{{   126,    -32,     41}, 0, {     0,      0}, {0x1d, 0x9a, 0x44, 0xff}}},
    {{{    25,    -36,    -90}, 0, {     0,      0}, {0x10, 0xbc, 0x97, 0xff}}},
    {{{    43,     66,   -101}, 0, {     0,      0}, {0x0a, 0x37, 0x8f, 0xff}}},
    {{{    43,     66,    101}, 0, {     0,      0}, {0x0a, 0x38, 0x71, 0xff}}},
    {{{    25,    -36,     90}, 0, {     0,      0}, {0x0f, 0xbc, 0x69, 0xff}}},
    {{{   -75,     32,    102}, 0, {     0,      0}, {0xb5, 0xbe, 0x4d, 0xff}}},
    {{{   -75,     32,   -102}, 0, {     0,      0}, {0xb1, 0xab, 0xce, 0xff}}},
};

// 0x05020E60
static const Vtx yoshi_seg5_vertex_05020E60[] = {
    {{{   223,    -25,    -39}, 0, {     0,      0}, {0x46, 0xbe, 0xaf, 0xff}}},
    {{{   255,     29,    -39}, 0, {     0,      0}, {0x5d, 0x2b, 0xb6, 0x00}}},
    {{{   255,     29,     39}, 0, {     0,      0}, {0x6c, 0x29, 0x33, 0x00}}},
};

// 0x05020E90
static const Vtx yoshi_seg5_vertex_05020E90[] = {
    {{{  -107,     51,    -49}, 0, {     0,      0}, {0xc0, 0x93, 0x00, 0x00}}},
    {{{   -75,     32,   -102}, 0, {     0,      0}, {0xb1, 0xab, 0xce, 0x00}}},
    {{{  -107,     51,     49}, 0, {     0,      0}, {0xc0, 0x93, 0x00, 0x00}}},
    {{{    43,     66,    101}, 0, {     0,      0}, {0x0a, 0x38, 0x71, 0xff}}},
    {{{    15,    113,     49}, 0, {     0,      0}, {0xea, 0x77, 0x25, 0xff}}},
    {{{  -107,     51,     49}, 0, {     0,      0}, {0xd4, 0x6a, 0x34, 0xff}}},
    {{{  -107,     51,    -49}, 0, {     0,      0}, {0xd0, 0x6e, 0xd9, 0xff}}},
    {{{    15,    113,    -49}, 0, {     0,      0}, {0xfc, 0x79, 0xdb, 0xff}}},
    {{{    43,     66,   -101}, 0, {     0,      0}, {0x0a, 0x37, 0x8f, 0xff}}},
    {{{   -75,     32,    102}, 0, {     0,      0}, {0xb5, 0xbe, 0x4d, 0xff}}},
    {{{   169,     50,     65}, 0, {     0,      0}, {0x2a, 0x20, 0x73, 0xff}}},
    {{{   255,     29,     39}, 0, {     0,      0}, {0x6c, 0x29, 0x33, 0xff}}},
    {{{   154,     87,     32}, 0, {     0,      0}, {0x27, 0x71, 0x2a, 0xff}}},
    {{{   255,     29,    -39}, 0, {     0,      0}, {0x5d, 0x2b, 0xb6, 0xff}}},
    {{{   154,     87,    -32}, 0, {     0,      0}, {0x2e, 0x6e, 0xd6, 0xff}}},
    {{{   169,     50,    -65}, 0, {     0,      0}, {0x29, 0x1d, 0x8c, 0xff}}},
};

// 0x05020F90
static const Vtx yoshi_seg5_vertex_05020F90[] = {
    {{{   128,    -30,    -44}, 0, {     0,      0}, {0x82, 0xfb, 0xfe, 0x00}}},
    {{{   131,   -114,     -1}, 0, {     0,      0}, {0x82, 0xfb, 0xfe, 0x00}}},
    {{{   126,    -32,     41}, 0, {     0,      0}, {0x82, 0xfb, 0xfe, 0x00}}},
    {{{   223,    -25,     39}, 0, {     0,      0}, {0x3a, 0xc1, 0x5d, 0xff}}},
    {{{   126,    -32,     41}, 0, {     0,      0}, {0x1d, 0x9a, 0x44, 0xff}}},
    {{{   131,   -114,     -1}, 0, {     0,      0}, {0x38, 0x8e, 0x00, 0xff}}},
    {{{   223,    -25,    -39}, 0, {     0,      0}, {0x46, 0xbe, 0xaf, 0xff}}},
    {{{   128,    -30,    -44}, 0, {     0,      0}, {0x19, 0xa8, 0xa9, 0xff}}},
};

// 0x05021010
static const Vtx yoshi_seg5_vertex_05021010[] = {
    {{{   197,     17,    -49}, 0, {     0,      0}, {0x62, 0x29, 0xbd, 0x00}}},
    {{{   197,     17,     49}, 0, {     0,      0}, {0x6b, 0x0a, 0x43, 0x00}}},
    {{{   166,    -61,    -58}, 0, {     0,      0}, {0x62, 0xc5, 0xca, 0x00}}},
    {{{  -138,    -27,     82}, 0, {     0,      0}, {0x97, 0xee, 0x44, 0xff}}},
    {{{   -84,   -138,    -55}, 0, {     0,      0}, {0xb8, 0xa9, 0xc8, 0xff}}},
    {{{   -84,   -138,     55}, 0, {     0,      0}, {0xcf, 0x9a, 0x37, 0xff}}},
    {{{    70,     74,    117}, 0, {     0,      0}, {0x15, 0x2a, 0x75, 0xff}}},
    {{{   -52,     39,    117}, 0, {     0,      0}, {0xe7, 0x0c, 0x7b, 0xff}}},
    {{{    69,    -35,     99}, 0, {     0,      0}, {0x1b, 0xe1, 0x77, 0xff}}},
    {{{   -52,     39,   -117}, 0, {     0,      0}, {0xe7, 0x0b, 0x85, 0xff}}},
    {{{    70,     73,   -117}, 0, {     0,      0}, {0x15, 0x2a, 0x8b, 0xff}}},
    {{{    69,    -35,    -99}, 0, {     0,      0}, {0x1b, 0xe1, 0x89, 0xff}}},
    {{{   -33,    -59,    -99}, 0, {     0,      0}, {0xfc, 0xd1, 0x8b, 0xff}}},
    {{{  -138,    -27,    -82}, 0, {     0,      0}, {0x96, 0xf3, 0xbc, 0xff}}},
    {{{   -33,    -59,     99}, 0, {     0,      0}, {0xfc, 0xd1, 0x75, 0xff}}},
    {{{   166,    -61,     58}, 0, {     0,      0}, {0x5b, 0xbb, 0x36, 0xff}}},
};

// 0x05021110
static const Vtx yoshi_seg5_vertex_05021110[] = {
    {{{   -33,    -59,     99}, 0, {     0,      0}, {0xfc, 0xd1, 0x75, 0x00}}},
    {{{   -10,   -155,     43}, 0, {     0,      0}, {0x0a, 0x8d, 0x33, 0x00}}},
    {{{    99,   -129,     43}, 0, {     0,      0}, {0x2a, 0xa5, 0x4d, 0x00}}},
    {{{    99,   -129,    -43}, 0, {     0,      0}, {0x32, 0x9a, 0xc9, 0xff}}},
    {{{   -10,   -154,    -43}, 0, {     0,      0}, {0xfe, 0x8c, 0xcd, 0xff}}},
    {{{   -33,    -59,    -99}, 0, {     0,      0}, {0xfc, 0xd1, 0x8b, 0xff}}},
    {{{   -84,   -138,     55}, 0, {     0,      0}, {0xcf, 0x9a, 0x37, 0xff}}},
    {{{   -84,   -138,    -55}, 0, {     0,      0}, {0xb8, 0xa9, 0xc8, 0xff}}},
    {{{   166,    -61,    -58}, 0, {     0,      0}, {0x62, 0xc5, 0xca, 0xff}}},
    {{{   166,    -61,     58}, 0, {     0,      0}, {0x5b, 0xbb, 0x36, 0xff}}},
    {{{    69,    -35,     99}, 0, {     0,      0}, {0x1b, 0xe1, 0x77, 0xff}}},
    {{{    69,    -35,    -99}, 0, {     0,      0}, {0x1b, 0xe1, 0x89, 0xff}}},
};

// 0x050211D0
static const Vtx yoshi_seg5_vertex_050211D0[] = {
    {{{   -52,     39,   -117}, 0, {     0,      0}, {0xe7, 0x0b, 0x85, 0x00}}},
    {{{  -138,    -27,    -82}, 0, {     0,      0}, {0x96, 0xf3, 0xbc, 0x00}}},
    {{{   -65,     92,    -76}, 0, {     0,      0}, {0xc3, 0x5a, 0xc0, 0x00}}},
    {{{  -138,    -27,     82}, 0, {     0,      0}, {0x97, 0xee, 0x44, 0xff}}},
    {{{   -52,     39,    117}, 0, {     0,      0}, {0xe7, 0x0c, 0x7b, 0xff}}},
    {{{   -65,     92,     76}, 0, {     0,      0}, {0xc1, 0x62, 0x30, 0xff}}},
    {{{    71,    120,     76}, 0, {     0,      0}, {0x2d, 0x6f, 0x28, 0xff}}},
    {{{   197,     17,     49}, 0, {     0,      0}, {0x6b, 0x0a, 0x43, 0xff}}},
    {{{   197,     17,    -49}, 0, {     0,      0}, {0x62, 0x29, 0xbd, 0xff}}},
    {{{    70,     74,    117}, 0, {     0,      0}, {0x15, 0x2a, 0x75, 0xff}}},
    {{{  -146,      6,     33}, 0, {     0,      0}, {0x85, 0x19, 0x10, 0xff}}},
    {{{    71,    120,    -76}, 0, {     0,      0}, {0x14, 0x76, 0xd8, 0xff}}},
    {{{  -146,      6,    -33}, 0, {     0,      0}, {0x90, 0x39, 0xf0, 0xff}}},
    {{{    70,     73,   -117}, 0, {     0,      0}, {0x15, 0x2a, 0x8b, 0xff}}},
};

// 0x050212B0 - 0x05021490
const Gfx yoshi_seg5_dl_050212B0[] = {
    gsSPLight(&yoshi_seg5_lights_0501D9C0.l, 1),
    gsSPLight(&yoshi_seg5_lights_0501D9C0.a, 2),
    gsSPVertex(yoshi_seg5_vertex_0501DA50, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  7,  8, 0x0,  9, 10, 11, 0x0),
    gsSP1Triangle(12, 13, 14, 0x0),
    gsSPVertex(yoshi_seg5_vertex_0501DB40, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  7,  8, 0x0,  9, 10, 11, 0x0),
    gsSP1Triangle(12, 13, 14, 0x0),
    gsSPVertex(yoshi_seg5_vertex_0501DC30, 14, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  7,  8, 0x0,  9, 10, 11, 0x0),
    gsSP1Triangle( 2, 12, 13, 0x0),
    gsSPVertex(yoshi_seg5_vertex_0501DD10, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  7,  8, 0x0,  9, 10, 11, 0x0),
    gsSP2Triangles( 8, 12,  0, 0x0, 13, 14, 15, 0x0),
    gsSPVertex(yoshi_seg5_vertex_0501DE10, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  4,  7, 0x0,  8,  9, 10, 0x0),
    gsSP2Triangles(11, 12,  9, 0x0, 13,  0, 14, 0x0),
    gsSPVertex(yoshi_seg5_vertex_0501DF00, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  2, 0x0),
    gsSP2Triangles( 5,  6,  7, 0x0,  8,  9,  5, 0x0),
    gsSP2Triangles(10,  3,  2, 0x0,  1, 11,  2, 0x0),
    gsSP2Triangles(12, 10, 11, 0x0, 12, 13, 14, 0x0),
    gsSP1Triangle( 9,  8, 13, 0x0),
    gsSPVertex(yoshi_seg5_vertex_0501DFF0, 14, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  7,  8, 0x0,  9, 10, 11, 0x0),
    gsSP1Triangle(12, 13, 10, 0x0),
    gsSPVertex(yoshi_seg5_vertex_0501E0D0, 14, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  7,  8, 0x0,  9,  8, 10, 0x0),
    gsSP2Triangles( 1,  4,  3, 0x0, 11, 12, 13, 0x0),
    gsSPVertex(yoshi_seg5_vertex_0501E1B0, 3, 0),
    gsSP1Triangle( 0,  1,  2, 0x0),
    gsSPEndDisplayList(),
};

// 0x05021490 - 0x050215D8
const Gfx yoshi_seg5_dl_05021490[] = {
    gsSPLight(&yoshi_seg5_lights_0501D9D8.l, 1),
    gsSPLight(&yoshi_seg5_lights_0501D9D8.a, 2),
    gsSPVertex(yoshi_seg5_vertex_0501E1E0, 14, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  0,  2,  3, 0x0),
    gsSP2Triangles( 4,  5,  6, 0x0,  4,  6,  7, 0x0),
    gsSP2Triangles( 8,  9, 10, 0x0,  8, 10, 11, 0x0),
    gsSP1Triangle( 6, 12, 13, 0x0),
    gsSPVertex(yoshi_seg5_vertex_0501E2C0, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  0,  2,  3, 0x0),
    gsSP2Triangles( 4,  5,  6, 0x0,  4,  6,  7, 0x0),
    gsSP2Triangles( 8,  9, 10, 0x0,  3,  2, 11, 0x0),
    gsSP2Triangles( 3, 11,  9, 0x0, 12, 13, 14, 0x0),
    gsSP2Triangles(12, 14, 11, 0x0,  2,  1, 15, 0x0),
    gsSP1Triangle( 2, 15, 12, 0x0),
    gsSPVertex(yoshi_seg5_vertex_0501E3C0, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  0,  2,  3, 0x0),
    gsSP2Triangles( 4,  5,  6, 0x0,  4,  6,  0, 0x0),
    gsSP2Triangles( 7,  8,  6, 0x0,  9,  8,  7, 0x0),
    gsSP2Triangles( 5, 10,  7, 0x0, 11,  7, 10, 0x0),
    gsSP2Triangles(12, 13, 14, 0x0,  7,  6,  5, 0x0),
    gsSP1Triangle( 0,  3,  4, 0x0),
    gsSPVertex(yoshi_seg5_vertex_0501E4B0, 8, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  0,  3,  4, 0x0),
    gsSP2Triangles( 5,  6,  3, 0x0,  5,  3,  0, 0x0),
    gsSP1Triangle( 7,  6,  5, 0x0),
    gsSPEndDisplayList(),
};

// 0x050215D8 - 0x05021678
const Gfx yoshi_seg5_dl_050215D8[] = {
    gsSPLight(&yoshi_seg5_lights_0501D9D8.l, 1),
    gsSPLight(&yoshi_seg5_lights_0501D9D8.a, 2),
    gsSPVertex(yoshi_seg5_vertex_0501E530, 10, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  1,  0, 0x0),
    gsSP2Triangles( 1,  4,  5, 0x0,  2,  6,  7, 0x0),
    gsSP2Triangles( 5,  8,  6, 0x0,  2,  9,  0, 0x0),
    gsSP2Triangles( 9,  7,  4, 0x0,  2,  5,  6, 0x0),
    gsSP2Triangles( 6,  8,  7, 0x0,  7,  8,  4, 0x0),
    gsSP2Triangles( 4,  8,  5, 0x0,  2,  1,  5, 0x0),
    gsSP2Triangles( 4,  3,  9, 0x0,  9,  3,  0, 0x0),
    gsSP2Triangles( 7,  9,  2, 0x0,  1,  3,  4, 0x0),
    gsSPEndDisplayList(),
};

// 0x05021678 - 0x05021718
const Gfx yoshi_seg5_dl_05021678[] = {
    gsSPLight(&yoshi_seg5_lights_0501D9D8.l, 1),
    gsSPLight(&yoshi_seg5_lights_0501D9D8.a, 2),
    gsSPVertex(yoshi_seg5_vertex_0501E5D0, 11, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 0,  6,  7, 0x0,  4,  8,  1, 0x0),
    gsSP2Triangles( 2,  9, 10, 0x0,  4,  0,  7, 0x0),
    gsSP2Triangles( 1,  8,  2, 0x0,  2,  8,  3, 0x0),
    gsSP2Triangles( 3,  8,  4, 0x0,  5,  6,  9, 0x0),
    gsSP2Triangles( 9,  6, 10, 0x0, 10,  6,  0, 0x0),
    gsSP2Triangles( 4,  1,  0, 0x0,  2,  3,  9, 0x0),
    gsSP2Triangles( 5,  9,  3, 0x0,  2, 10,  0, 0x0),
    gsSPEndDisplayList(),
};

// 0x05021718 - 0x05021860
const Gfx yoshi_seg5_dl_05021718[] = {
    gsSPLight(&yoshi_seg5_lights_0501D9D8.l, 1),
    gsSPLight(&yoshi_seg5_lights_0501D9D8.a, 2),
    gsSPVertex(yoshi_seg5_vertex_0501E680, 14, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  0,  2,  3, 0x0),
    gsSP2Triangles( 4,  5,  6, 0x0,  4,  6,  7, 0x0),
    gsSP2Triangles( 8,  9, 10, 0x0,  8, 10, 11, 0x0),
    gsSP1Triangle(12, 13,  5, 0x0),
    gsSPVertex(yoshi_seg5_vertex_0501E760, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  0,  2,  3, 0x0),
    gsSP2Triangles( 4,  5,  6, 0x0,  4,  6,  7, 0x0),
    gsSP2Triangles( 8,  9, 10, 0x0,  9, 11,  1, 0x0),
    gsSP2Triangles( 9,  1,  0, 0x0, 11, 12, 13, 0x0),
    gsSP2Triangles(11, 13, 14, 0x0, 14, 15,  2, 0x0),
    gsSP1Triangle(14,  2,  1, 0x0),
    gsSPVertex(yoshi_seg5_vertex_0501E860, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  0,  2,  3, 0x0),
    gsSP2Triangles( 3,  4,  5, 0x0,  3,  5,  6, 0x0),
    gsSP2Triangles( 4,  7,  8, 0x0,  8,  7,  9, 0x0),
    gsSP2Triangles( 8, 10,  5, 0x0, 10,  8, 11, 0x0),
    gsSP2Triangles(12, 13, 14, 0x0,  5,  4,  8, 0x0),
    gsSP1Triangle( 6,  0,  3, 0x0),
    gsSPVertex(yoshi_seg5_vertex_0501E950, 8, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  2, 0x0),
    gsSP2Triangles( 2,  4,  5, 0x0,  2,  5,  6, 0x0),
    gsSP1Triangle( 6,  5,  7, 0x0),
    gsSPEndDisplayList(),
};

// 0x05021860 - 0x05021900
const Gfx yoshi_seg5_dl_05021860[] = {
    gsSPLight(&yoshi_seg5_lights_0501D9D8.l, 1),
    gsSPLight(&yoshi_seg5_lights_0501D9D8.a, 2),
    gsSPVertex(yoshi_seg5_vertex_0501E9D0, 10, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  2,  1,  3, 0x0),
    gsSP2Triangles( 4,  5,  1, 0x0,  6,  7,  0, 0x0),
    gsSP2Triangles( 7,  8,  4, 0x0,  2,  9,  0, 0x0),
    gsSP2Triangles( 5,  6,  9, 0x0,  7,  4,  0, 0x0),
    gsSP2Triangles( 6,  8,  7, 0x0,  5,  8,  6, 0x0),
    gsSP2Triangles( 4,  8,  5, 0x0,  4,  1,  0, 0x0),
    gsSP2Triangles( 9,  3,  5, 0x0,  2,  3,  9, 0x0),
    gsSP2Triangles( 0,  9,  6, 0x0,  5,  3,  1, 0x0),
    gsSPEndDisplayList(),
};

// 0x05021900 - 0x050219A0
const Gfx yoshi_seg5_dl_05021900[] = {
    gsSPLight(&yoshi_seg5_lights_0501D9D8.l, 1),
    gsSPLight(&yoshi_seg5_lights_0501D9D8.a, 2),
    gsSPVertex(yoshi_seg5_vertex_0501EA70, 11, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  7,  2, 0x0,  1,  8,  4, 0x0),
    gsSP2Triangles( 9, 10,  0, 0x0,  6,  2,  4, 0x0),
    gsSP2Triangles( 0,  8,  1, 0x0,  5,  8,  0, 0x0),
    gsSP2Triangles( 4,  8,  5, 0x0, 10,  7,  3, 0x0),
    gsSP2Triangles( 9,  7, 10, 0x0,  2,  7,  9, 0x0),
    gsSP2Triangles( 2,  1,  4, 0x0, 10,  5,  0, 0x0),
    gsSP2Triangles( 5, 10,  3, 0x0,  2,  9,  0, 0x0),
    gsSPEndDisplayList(),
};

// 0x050219A0 - 0x05021B90
const Gfx yoshi_seg5_dl_050219A0[] = {
    gsSPLight(&yoshi_seg5_lights_0501D9F0.l, 1),
    gsSPLight(&yoshi_seg5_lights_0501D9F0.a, 2),
    gsSPVertex(yoshi_seg5_vertex_0501EB20, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  1,  3,  2, 0x0),
    gsSP2Triangles( 4,  5,  6, 0x0,  5,  7,  6, 0x0),
    gsSP2Triangles( 8,  9, 10, 0x0, 11, 12, 13, 0x0),
    gsSP1Triangle(10, 14,  8, 0x0),
    gsSPVertex(yoshi_seg5_vertex_0501EC10, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  7,  8, 0x0,  4,  9,  5, 0x0),
    gsSP2Triangles(10, 11, 12, 0x0,  8, 13, 14, 0x0),
    gsSP1Triangle(15, 10, 12, 0x0),
    gsSPVertex(yoshi_seg5_vertex_0501ED10, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  7,  8, 0x0,  0,  2,  9, 0x0),
    gsSP2Triangles(10,  3,  5, 0x0, 11, 10,  5, 0x0),
    gsSP2Triangles( 5, 12, 11, 0x0, 13, 14,  6, 0x0),
    gsSP1Triangle(14, 15,  6, 0x0),
    gsSPVertex(yoshi_seg5_vertex_0501EE10, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  7,  4, 0x0,  2,  8,  0, 0x0),
    gsSP2Triangles( 4,  0,  5, 0x0,  4,  9,  6, 0x0),
    gsSP2Triangles(10, 11, 12, 0x0, 13, 14, 15, 0x0),
    gsSPVertex(yoshi_seg5_vertex_0501EF10, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  7,  8, 0x0,  9, 10, 11, 0x0),
    gsSP2Triangles( 2,  7,  0, 0x0, 12, 13, 14, 0x0),
    gsSP1Triangle(10,  3,  5, 0x0),
    gsSPVertex(yoshi_seg5_vertex_0501F000, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  7,  8, 0x0,  9, 10, 11, 0x0),
    gsSP2Triangles( 9, 12, 10, 0x0,  7, 13,  8, 0x0),
    gsSP2Triangles( 5, 14,  3, 0x0,  2, 15,  0, 0x0),
    gsSPVertex(yoshi_seg5_vertex_0501F100, 8, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  0,  2,  3, 0x0),
    gsSP2Triangles( 0,  3,  4, 0x0,  0,  4,  5, 0x0),
    gsSP2Triangles( 0,  5,  6, 0x0,  0,  6,  7, 0x0),
    gsSPEndDisplayList(),
};

// 0x05021B90 - 0x05021CD8
const Gfx yoshi_seg5_dl_05021B90[] = {
    gsSPLight(&yoshi_seg5_lights_0501D9D8.l, 1),
    gsSPLight(&yoshi_seg5_lights_0501D9D8.a, 2),
    gsSPVertex(yoshi_seg5_vertex_0501F180, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 0,  6,  1, 0x0,  3,  7,  4, 0x0),
    gsSP2Triangles( 8,  9, 10, 0x0, 11, 12,  4, 0x0),
    gsSP2Triangles( 7,  3, 13, 0x0, 14,  5,  4, 0x0),
    gsSP2Triangles( 9,  5, 14, 0x0, 13,  3, 15, 0x0),
    gsSPVertex(yoshi_seg5_vertex_0501F280, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  7,  8, 0x0,  9, 10, 11, 0x0),
    gsSP2Triangles( 2, 12, 13, 0x0, 14, 12, 11, 0x0),
    gsSP1Triangle(15,  3,  5, 0x0),
    gsSPVertex(yoshi_seg5_vertex_0501F380, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  7,  8, 0x0,  9, 10, 11, 0x0),
    gsSP2Triangles(12, 13, 14, 0x0,  7, 12,  0, 0x0),
    gsSP2Triangles( 0, 15,  7, 0x0, 14,  1, 12, 0x0),
    gsSP2Triangles( 9, 13, 10, 0x0,  6, 10,  7, 0x0),
    gsSPVertex(yoshi_seg5_vertex_0501F480, 12, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 0,  4,  6, 0x0,  5,  7,  8, 0x0),
    gsSP2Triangles( 9,  1,  0, 0x0, 10,  8,  7, 0x0),
    gsSP1Triangle( 1,  9, 11, 0x0),
    gsSPEndDisplayList(),
};

// 0x05021CD8 - 0x05021E38
const Gfx yoshi_seg5_dl_05021CD8[] = {
    gsSPLight(&yoshi_seg5_lights_0501D9D8.l, 1),
    gsSPLight(&yoshi_seg5_lights_0501D9D8.a, 2),
    gsSPVertex(yoshi_seg5_vertex_0501F540, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  7,  8, 0x0,  9, 10, 11, 0x0),
    gsSP2Triangles(12, 13, 14, 0x0,  3, 15,  4, 0x0),
    gsSPVertex(yoshi_seg5_vertex_0501F640, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  4,  7, 0x0,  2,  1,  8, 0x0),
    gsSP2Triangles( 9, 10, 11, 0x0, 12, 13, 14, 0x0),
    gsSPVertex(yoshi_seg5_vertex_0501F730, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  7,  8, 0x0,  9,  7,  5, 0x0),
    gsSP2Triangles(10, 11, 12, 0x0,  0,  2, 13, 0x0),
    gsSP2Triangles( 8, 14, 10, 0x0,  6,  3,  5, 0x0),
    gsSPVertex(yoshi_seg5_vertex_0501F820, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  2, 0x0),
    gsSP2Triangles( 5,  4,  6, 0x0,  7,  8,  9, 0x0),
    gsSP2Triangles( 6, 10,  5, 0x0,  2, 11,  3, 0x0),
    gsSP2Triangles(12,  7, 13, 0x0,  8, 14,  6, 0x0),
    gsSP1Triangle(11,  1, 13, 0x0),
    gsSPVertex(yoshi_seg5_vertex_0501F910, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 2,  1,  6, 0x0,  4,  3,  7, 0x0),
    gsSP2Triangles( 8,  9, 10, 0x0, 11, 12,  2, 0x0),
    gsSP1Triangle(13, 14,  4, 0x0),
    gsSPEndDisplayList(),
};

// 0x05021E38 - 0x05021F70
const Gfx yoshi_seg5_dl_05021E38[] = {
    gsSPLight(&yoshi_seg5_lights_0501D9D8.l, 1),
    gsSPLight(&yoshi_seg5_lights_0501D9D8.a, 2),
    gsSPVertex(yoshi_seg5_vertex_0501FA00, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  2,  3,  0, 0x0),
    gsSP2Triangles( 4,  5,  3, 0x0,  6,  7,  8, 0x0),
    gsSP2Triangles( 2,  9,  3, 0x0,  8, 10,  2, 0x0),
    gsSP2Triangles( 8,  2, 11, 0x0,  3, 12,  4, 0x0),
    gsSP2Triangles( 2, 10,  9, 0x0,  7, 13, 10, 0x0),
    gsSP2Triangles( 5, 14,  0, 0x0,  0, 14,  1, 0x0),
    gsSP2Triangles( 1, 14, 11, 0x0, 11, 14,  6, 0x0),
    gsSP2Triangles(10,  8,  7, 0x0,  3,  9, 12, 0x0),
    gsSP2Triangles( 2,  1, 11, 0x0,  8, 11,  6, 0x0),
    gsSP1Triangle( 5,  0,  3, 0x0),
    gsSPLight(&yoshi_seg5_lights_0501D9C0.l, 1),
    gsSPLight(&yoshi_seg5_lights_0501D9C0.a, 2),
    gsSPVertex(yoshi_seg5_vertex_0501FAF0, 11, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  0,  4, 0x0),
    gsSP2Triangles( 5,  6,  7, 0x0,  7,  6,  8, 0x0),
    gsSP2Triangles( 1,  9,  2, 0x0,  3,  4,  8, 0x0),
    gsSP2Triangles( 2,  4,  0, 0x0,  8,  6, 10, 0x0),
    gsSP2Triangles( 9,  5,  7, 0x0,  8, 10,  3, 0x0),
    gsSP2Triangles( 7,  2,  9, 0x0,  7,  4,  2, 0x0),
    gsSP1Triangle( 7,  8,  4, 0x0),
    gsSPEndDisplayList(),
};

// 0x05021F70 - 0x05022160
const Gfx yoshi_seg5_dl_05021F70[] = {
    gsSPLight(&yoshi_seg5_lights_0501D9F0.l, 1),
    gsSPLight(&yoshi_seg5_lights_0501D9F0.a, 2),
    gsSPVertex(yoshi_seg5_vertex_0501FBA0, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  0,  3,  1, 0x0),
    gsSP2Triangles( 4,  5,  6, 0x0,  4,  7,  5, 0x0),
    gsSP2Triangles( 8,  9, 10, 0x0, 11, 12, 13, 0x0),
    gsSP1Triangle(10, 14,  8, 0x0),
    gsSPVertex(yoshi_seg5_vertex_0501FC90, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  7,  8, 0x0,  3,  9,  4, 0x0),
    gsSP2Triangles(10, 11, 12, 0x0, 13, 14,  6, 0x0),
    gsSP1Triangle(10, 12, 15, 0x0),
    gsSPVertex(yoshi_seg5_vertex_0501FD90, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  7,  8, 0x0,  9,  0,  2, 0x0),
    gsSP2Triangles( 3,  5, 10, 0x0,  3, 10, 11, 0x0),
    gsSP2Triangles(11, 12,  3, 0x0,  8, 13, 14, 0x0),
    gsSP1Triangle( 8, 15, 13, 0x0),
    gsSPVertex(yoshi_seg5_vertex_0501FE90, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 4,  6,  7, 0x0,  2,  8,  0, 0x0),
    gsSP2Triangles( 3,  2,  4, 0x0,  7,  9,  4, 0x0),
    gsSP2Triangles(10, 11, 12, 0x0, 13, 14, 15, 0x0),
    gsSPVertex(yoshi_seg5_vertex_0501FF90, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  7,  8, 0x0,  9, 10, 11, 0x0),
    gsSP2Triangles( 2,  7,  0, 0x0, 12, 13, 14, 0x0),
    gsSP1Triangle( 3,  5, 10, 0x0),
    gsSPVertex(yoshi_seg5_vertex_05020080, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  7,  8, 0x0,  9, 10, 11, 0x0),
    gsSP2Triangles(10, 12, 11, 0x0,  6, 13,  7, 0x0),
    gsSP2Triangles( 5, 14,  3, 0x0,  2, 15,  0, 0x0),
    gsSPVertex(yoshi_seg5_vertex_05020180, 8, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  0,  2, 0x0),
    gsSP2Triangles( 4,  3,  2, 0x0,  5,  4,  2, 0x0),
    gsSP2Triangles( 6,  5,  2, 0x0,  7,  6,  2, 0x0),
    gsSPEndDisplayList(),
};

// 0x05022160 - 0x050222A8
const Gfx yoshi_seg5_dl_05022160[] = {
    gsSPLight(&yoshi_seg5_lights_0501D9D8.l, 1),
    gsSPLight(&yoshi_seg5_lights_0501D9D8.a, 2),
    gsSPVertex(yoshi_seg5_vertex_05020200, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 1,  6,  2, 0x0,  4,  7,  5, 0x0),
    gsSP2Triangles( 8,  9, 10, 0x0,  4, 11, 12, 0x0),
    gsSP2Triangles(13,  5,  7, 0x0,  4,  3, 14, 0x0),
    gsSP2Triangles(14,  3,  9, 0x0, 15,  5, 13, 0x0),
    gsSPVertex(yoshi_seg5_vertex_05020300, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  7,  8, 0x0,  9, 10, 11, 0x0),
    gsSP2Triangles(12, 13,  0, 0x0,  9, 13, 14, 0x0),
    gsSP1Triangle( 3,  5, 15, 0x0),
    gsSPVertex(yoshi_seg5_vertex_05020400, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  7,  8, 0x0,  9, 10, 11, 0x0),
    gsSP2Triangles(12, 13, 14, 0x0,  2, 14,  7, 0x0),
    gsSP2Triangles( 7, 15,  2, 0x0, 14,  1, 12, 0x0),
    gsSP2Triangles(10, 13, 11, 0x0,  7, 10,  8, 0x0),
    gsSPVertex(yoshi_seg5_vertex_05020500, 12, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  4,  2, 0x0,  7,  8,  3, 0x0),
    gsSP2Triangles( 2,  1,  9, 0x0,  8,  7, 10, 0x0),
    gsSP1Triangle(11,  9,  1, 0x0),
    gsSPEndDisplayList(),
};

// 0x050222A8 - 0x05022408
const Gfx yoshi_seg5_dl_050222A8[] = {
    gsSPLight(&yoshi_seg5_lights_0501D9D8.l, 1),
    gsSPLight(&yoshi_seg5_lights_0501D9D8.a, 2),
    gsSPVertex(yoshi_seg5_vertex_050205C0, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  7,  8, 0x0,  9, 10, 11, 0x0),
    gsSP2Triangles(12, 13, 14, 0x0,  4, 15,  5, 0x0),
    gsSPVertex(yoshi_seg5_vertex_050206C0, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  4,  7, 0x0,  8,  1,  0, 0x0),
    gsSP2Triangles( 9, 10, 11, 0x0, 12, 13, 14, 0x0),
    gsSPVertex(yoshi_seg5_vertex_050207B0, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  7,  8, 0x0,  3,  7,  9, 0x0),
    gsSP2Triangles(10, 11, 12, 0x0, 13,  0,  2, 0x0),
    gsSP2Triangles(12, 14,  6, 0x0,  3,  5,  8, 0x0),
    gsSPVertex(yoshi_seg5_vertex_050208A0, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  0,  3,  4, 0x0),
    gsSP2Triangles( 5,  3,  6, 0x0,  7,  8,  9, 0x0),
    gsSP2Triangles( 6, 10,  5, 0x0,  4, 11,  0, 0x0),
    gsSP2Triangles(12,  9, 13, 0x0,  5, 14,  8, 0x0),
    gsSP1Triangle(12,  1, 11, 0x0),
    gsSPVertex(yoshi_seg5_vertex_05020990, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  1,  0, 0x0,  7,  5,  4, 0x0),
    gsSP2Triangles( 8,  9, 10, 0x0,  0, 11, 12, 0x0),
    gsSP1Triangle( 4, 13, 14, 0x0),
    gsSPEndDisplayList(),
};

// 0x05022408 - 0x05022608
const Gfx yoshi_seg5_dl_05022408[] = {
    gsSPLight(&yoshi_seg5_lights_0501D9D8.l, 1),
    gsSPLight(&yoshi_seg5_lights_0501D9D8.a, 2),
    gsSPVertex(yoshi_seg5_vertex_05020A80, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  7,  8, 0x0,  9, 10, 11, 0x0),
    gsSP2Triangles(12,  4, 13, 0x0, 14,  5, 15, 0x0),
    gsSPVertex(yoshi_seg5_vertex_05020B80, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  7,  2, 0x0,  3,  8,  9, 0x0),
    gsSP2Triangles( 9, 10, 11, 0x0,  7, 10,  8, 0x0),
    gsSP2Triangles(12, 13,  6, 0x0,  1, 14, 15, 0x0),
    gsSPVertex(yoshi_seg5_vertex_05020C80, 14, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  7,  8, 0x0,  9, 10, 11, 0x0),
    gsSP2Triangles(11, 12,  9, 0x0,  2, 13,  0, 0x0),
    gsSPVertex(yoshi_seg5_vertex_05020D60, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  7,  8, 0x0,  3,  9,  1, 0x0),
    gsSP2Triangles( 6, 10, 11, 0x0, 12, 13,  1, 0x0),
    gsSP1Triangle( 4, 14, 15, 0x0),
    gsSPVertex(yoshi_seg5_vertex_05020E60, 3, 0),
    gsSP1Triangle( 0,  1,  2, 0x0),
    gsSPLight(&yoshi_seg5_lights_0501D9C0.l, 1),
    gsSPLight(&yoshi_seg5_lights_0501D9C0.a, 2),
    gsSPVertex(yoshi_seg5_vertex_05020E90, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  7,  8, 0x0,  5,  9,  3, 0x0),
    gsSP2Triangles( 7,  6,  4, 0x0,  1,  9,  2, 0x0),
    gsSP2Triangles(10, 11, 12, 0x0,  8,  1,  6, 0x0),
    gsSP2Triangles(11, 13, 14, 0x0,  6,  5,  4, 0x0),
    gsSP2Triangles(12, 11, 14, 0x0, 13, 15, 14, 0x0),
    gsSP2Triangles(14, 15,  8, 0x0,  3, 10, 12, 0x0),
    gsSP2Triangles(12,  4,  3, 0x0, 12, 14,  7, 0x0),
    gsSP2Triangles( 8,  7, 14, 0x0,  7,  4, 12, 0x0),
    gsSPLight(&yoshi_seg5_lights_0501D9F0.l, 1),
    gsSPLight(&yoshi_seg5_lights_0501D9F0.a, 2),
    gsSPVertex(yoshi_seg5_vertex_05020F90, 8, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  3,  5, 0x0,  7,  6,  5, 0x0),
    gsSPEndDisplayList(),
};

// 0x05022608 - 0x050227D8
const Gfx yoshi_seg5_dl_05022608[] = {
    gsSPLight(&yoshi_seg5_lights_0501D9D8.l, 1),
    gsSPLight(&yoshi_seg5_lights_0501D9D8.a, 2),
    gsSPVertex(yoshi_seg5_vertex_05021010, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  7,  8, 0x0,  9, 10, 11, 0x0),
    gsSP2Triangles(12,  4, 13, 0x0,  3,  5, 14, 0x0),
    gsSP2Triangles( 8,  1,  6, 0x0, 10,  0, 11, 0x0),
    gsSP2Triangles( 0,  2, 11, 0x0,  8, 15,  1, 0x0),
    gsSP2Triangles(14,  7,  3, 0x0, 13,  9, 12, 0x0),
    gsSP2Triangles(11, 12,  9, 0x0,  7, 14,  8, 0x0),
    gsSP2Triangles( 3, 13,  4, 0x0,  1, 15,  2, 0x0),
    gsSPLight(&yoshi_seg5_lights_0501DA38.l, 1),
    gsSPLight(&yoshi_seg5_lights_0501DA38.a, 2),
    gsSPVertex(yoshi_seg5_vertex_05021110, 12, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 3,  2,  1, 0x0,  6,  7,  4, 0x0),
    gsSP2Triangles( 3,  8,  9, 0x0,  4,  7,  5, 0x0),
    gsSP2Triangles( 0,  6,  1, 0x0,  9,  2,  3, 0x0),
    gsSP2Triangles( 4,  1,  6, 0x0,  2,  9, 10, 0x0),
    gsSP2Triangles( 5, 11,  3, 0x0,  2, 10,  0, 0x0),
    gsSP2Triangles(11,  8,  3, 0x0,  1,  4,  3, 0x0),
    gsSPLight(&yoshi_seg5_lights_0501D9C0.l, 1),
    gsSPLight(&yoshi_seg5_lights_0501D9C0.a, 2),
    gsSPVertex(yoshi_seg5_vertex_050211D0, 14, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  7,  8, 0x0,  9,  7,  6, 0x0),
    gsSP2Triangles(10,  3,  5, 0x0,  5,  6, 11, 0x0),
    gsSP2Triangles( 5,  2, 12, 0x0,  2,  1, 12, 0x0),
    gsSP2Triangles( 2, 11, 13, 0x0,  9,  6,  5, 0x0),
    gsSP2Triangles(12, 10,  5, 0x0,  8, 13, 11, 0x0),
    gsSP2Triangles(11,  2,  5, 0x0,  6,  8, 11, 0x0),
    gsSP2Triangles( 9,  5,  4, 0x0,  3, 10,  1, 0x0),
    gsSP2Triangles(10, 12,  1, 0x0,  0,  2, 13, 0x0),
    gsSPEndDisplayList(),
};
