#!/bin/bash
read -p "Are you sure to install devkitPro, the wii-dev package and GRRLIB? (y/n) " confirmreq
if [ "$confirmreq" != "${confirmreq#[Yy]}" ] ;then
  sudo apt-get install gdebi-core
  # Download devkitPro 1.0.2 from GitHub and install it
  sudo wget "https://github.com/devkitPro/pacman/releases/download/v1.0.2/devkitpro-pacman.amd64.deb"
  sudo gdebi devkitpro-pacman.amd64.deb
  sudo rm -f devkitpro-pacman.amd64.deb
  export DEVKITPRO=/opt/devkitpro
  export DEVKITARM=/opt/devkitpro/devkitARM
  export DEVKITPPC=/opt/devkitpro/devkitPPC
  sudo dkp-pacman -Syu
  # Install the wii-dev package
  sudo dkp-pacman -S wii-dev
  # GRRLIB requisites
  sudo dkp-pacman --sync --needed ppc-libpng ppc-freetype ppc-libjpeg-turbo
  # Download and install GRRLIB from GitHub
  sudo wget "https://github.com/GRRLIB/GRRLIB/archive/master.zip"
  sudo apt-get install unzip
  sudo unzip master.zip
  sudo rm -f master.zip
  cd GRRLIB-master/GRRLIB
  sudo -E make clean all install
  cd ../..
  sudo rm -f -r GRRLIB-master
fi
# Ask if you want to run make
read -p "Do you want to compile the game now? (y/n) " confirmcompile
if [ "$confirmcompile" != "${confirmcompile#[Yy]}" ] ;then
  export DEVKITPRO=/opt/devkitpro
  export DEVKITARM=/opt/devkitpro/devkitARM
  export DEVKITPPC=/opt/devkitpro/devkitPPC
  sudo -E make TARGET_WII=1 -j
fi