#include <ultra64.h>
#include "sm64.h"
#include "surface_terrains.h"
#include "moving_texture_macros.h"
#include "level_misc_macros.h"
#include "macro_preset_names.h"
#include "special_preset_names.h"
#include "textures.h"

#include "make_const_nonconst.h"

// 0x07000000 - 0x07000100
static const Vtx intro_seg7_vertex_07000000[] = {
    {{{   498,    -74,     90}, 0, {   760,    796}, {0x00, 0xf1, 0x00, 0xff}}},
    {{{   617,   -184,    153}, 0, {   816,    876}, {0x00, 0xf1, 0x00, 0xff}}},
    {{{   660,    -62,     83}, 0, {   830,    778}, {0x00, 0xf1, 0x00, 0xff}}},
    {{{   918,   -126,    120}, 0, {   946,    818}, {0x00, 0xf1, 0x00, 0xff}}},
    {{{   811,     23,     33}, 0, {   894,    706}, {0x00, 0xf1, 0x00, 0xff}}},
    {{{   765,    -44,     73}, 0, {   876,    760}, {0x00, 0xf1, 0x00, 0xff}}},
    {{{   969,     83,      0}, 0, {   962,    654}, {0x00, 0xf1, 0x00, 0xff}}},
    {{{   790,    200,    -68}, 0, {   878,    570}, {0x00, 0xf1, 0x00, 0xff}}},
    {{{   699,    102,    -12}, 0, {   842,    650}, {0x00, 0xf1, 0x00, 0xff}}},
    {{{   765,    -44,     73}, 0, {   876,    760}, {0x1f, 0xc0, 0x00, 0xff}}},
    {{{   811,      2,     -1}, 0, {   894,    706}, {0x1f, 0xc0, 0x00, 0xff}}},
    {{{   811,     23,     33}, 0, {   894,    706}, {0x1f, 0xc0, 0x00, 0xff}}},
    {{{   765,    -65,     37}, 0, {   876,    760}, {0x1f, 0xc0, 0x00, 0xff}}},
    {{{   615,    199,    -68}, 0, {   802,    578}, {0x00, 0xf1, 0x00, 0xff}}},
    {{{   495,    137,    -32}, 0, {   750,    630}, {0x00, 0xf1, 0x00, 0xff}}},
    {{{   611,     31,     29}, 0, {   806,    708}, {0x00, 0xf1, 0x00, 0xff}}},
};

// 0x07000100 - 0x070001F0
static const Vtx intro_seg7_vertex_07000100[] = {
    {{{   611,     31,     29}, 0, {   806,    708}, {0x00, 0xf1, 0x00, 0xff}}},
    {{{   699,    103,    -12}, 0, {   842,    650}, {0x00, 0xf1, 0x00, 0xff}}},
    {{{   790,    200,    -68}, 0, {   878,    570}, {0x00, 0xf1, 0x00, 0xff}}},
    {{{   615,    199,    -68}, 0, {   802,    578}, {0x00, 0xf1, 0x00, 0xff}}},
    {{{  -378,    -82,    144}, 0, {   384,    856}, {0x00, 0xf1, 0x00, 0xff}}},
    {{{  -164,   -154,    185}, 0, {   480,    902}, {0x00, 0xf1, 0x00, 0xff}}},
    {{{  -354,    312,    -83}, 0, {   380,    550}, {0x00, 0xf1, 0x00, 0xff}}},
    {{{  -391,     31,     78}, 0, {   374,    768}, {0x00, 0xf1, 0x00, 0xff}}},
    {{{  -570,     87,     46}, 0, {   292,    734}, {0x00, 0xf1, 0x00, 0xff}}},
    {{{  -579,    -19,    108}, 0, {   292,    816}, {0x00, 0xf1, 0x00, 0xff}}},
    {{{  -370,   -153,    185}, 0, {   390,    912}, {0x00, 0xf1, 0x00, 0xff}}},
    {{{  -828,    -32,    115}, 0, {   184,    836}, {0x00, 0xf1, 0x00, 0xff}}},
    {{{  -527,    344,   -102}, 0, {   304,    532}, {0x00, 0xf1, 0x00, 0xff}}},
    {{{  -656,    -91,    149}, 0, {   262,    876}, {0x00, 0xf1, 0x00, 0xff}}},
    {{{  -448,    249,    -47}, 0, {   342,    602}, {0x00, 0xf1, 0x00, 0xff}}},
};

// 0x070001F0 - 0x070002F0
static const Vtx intro_seg7_vertex_070001F0[] = {
    {{{  -944,    243,    -14}, 0, {   124,    638}, {0x65, 0x7f, 0xff, 0xff}}},
    {{{  -992,    378,    -91}, 0, {    98,    536}, {0x65, 0x7f, 0xff, 0xff}}},
    {{{ -1127,    377,    -91}, 0, {    38,    542}, {0x65, 0x7f, 0xff, 0xff}}},
    {{{  -742,     15,    117}, 0, {   220,    806}, {0x65, 0x7f, 0xff, 0xff}}},
    {{{  -717,    337,    -68}, 0, {   220,    556}, {0x65, 0x7f, 0xff, 0xff}}},
    {{{  -877,    378,    -91}, 0, {   148,    530}, {0x65, 0x7f, 0xff, 0xff}}},
    {{{  -853,    141,     44}, 0, {   166,    714}, {0x65, 0x7f, 0xff, 0xff}}},
    {{{  -565,    -59,    160}, 0, {   300,    856}, {0x65, 0x7f, 0xff, 0xff}}},
    {{{  -737,   -126,    199}, 0, {   228,    916}, {0x65, 0x7f, 0xff, 0xff}}},
    {{{  -939,    -22,    139}, 0, {   134,    844}, {0x65, 0x7f, 0xff, 0xff}}},
    {{{ -1037,   -143,    209}, 0, {    96,    942}, {0x65, 0x7f, 0xff, 0xff}}},
    {{{ -1060,    134,     48}, 0, {    76,    728}, {0x65, 0x7f, 0xff, 0xff}}},
    {{{ -1234,   -144,    209}, 0, {     8,    950}, {0x65, 0x7f, 0xff, 0xff}}},
    {{{  -633,    570,   -238}, 0, {   248,    360}, {0x65, 0x7f, 0xff, 0xff}}},
    {{{  -639,    816,   -380}, 0, {   238,    168}, {0x65, 0x7f, 0xff, 0xff}}},
    {{{  -687,    451,   -169}, 0, {   230,    454}, {0x65, 0x7f, 0xff, 0xff}}},
};

// 0x070002F0 - 0x070003E0
static const Vtx intro_seg7_vertex_070002F0[] = {
    {{{   -12,    706,   -349}, 0, {   518,    216}, {0x65, 0x7f, 0xff, 0xff}}},
    {{{   108,    783,   -394}, 0, {   568,    152}, {0x65, 0x7f, 0xff, 0xff}}},
    {{{  -177,    752,   -376}, 0, {   442,    188}, {0x65, 0x7f, 0xff, 0xff}}},
    {{{   -92,    441,   -196}, 0, {   490,    426}, {0x65, 0x7f, 0xff, 0xff}}},
    {{{   -24,    627,   -304}, 0, {   514,    278}, {0x65, 0x7f, 0xff, 0xff}}},
    {{{    82,    705,   -349}, 0, {   560,    212}, {0x65, 0x7f, 0xff, 0xff}}},
    {{{     8,    500,   -230}, 0, {   534,    376}, {0x65, 0x7f, 0xff, 0xff}}},
    {{{   -23,    588,   -282}, 0, {   516,    308}, {0x65, 0x7f, 0xff, 0xff}}},
    {{{   147,    541,   -254}, 0, {   594,    338}, {0x65, 0x7f, 0xff, 0xff}}},
    {{{   183,    482,   -220}, 0, {   612,    382}, {0x65, 0x7f, 0xff, 0xff}}},
    {{{    88,    595,   -285}, 0, {   566,    298}, {0x65, 0x7f, 0xff, 0xff}}},
    {{{    88,    635,   -308}, 0, {   564,    268}, {0x65, 0x7f, 0xff, 0xff}}},
    {{{  -455,    560,   -232}, 0, {   328,    360}, {0x65, 0x7f, 0xff, 0xff}}},
    {{{  -568,    747,   -340}, 0, {   272,    220}, {0x65, 0x7f, 0xff, 0xff}}},
    {{{  -559,    610,   -261}, 0, {   280,    326}, {0x65, 0x7f, 0xff, 0xff}}},
};

// 0x070003E0 - 0x070004E0
static const Vtx intro_seg7_vertex_070003E0[] = {
    {{{  -639,    816,   -380}, 0, {   238,    168}, {0x65, 0x7f, 0xff, 0xff}}},
    {{{  -758,    540,   -221}, 0, {   194,    388}, {0x65, 0x7f, 0xff, 0xff}}},
    {{{  -687,    451,   -169}, 0, {   230,    454}, {0x65, 0x7f, 0xff, 0xff}}},
    {{{  -763,    816,   -380}, 0, {   184,    174}, {0x65, 0x7f, 0xff, 0xff}}},
    {{{  -633,    570,   -238}, 0, {   248,    360}, {0x65, 0x7f, 0xff, 0xff}}},
    {{{  -455,    560,   -232}, 0, {   328,    360}, {0x65, 0x7f, 0xff, 0xff}}},
    {{{  -510,    485,   -189}, 0, {   306,    420}, {0x65, 0x7f, 0xff, 0xff}}},
    {{{  -559,    610,   -261}, 0, {   280,    326}, {0x65, 0x7f, 0xff, 0xff}}},
    {{{  -480,    764,   -350}, 0, {   310,    202}, {0x65, 0x7f, 0xff, 0xff}}},
    {{{  -568,    747,   -340}, 0, {   272,    220}, {0x65, 0x7f, 0xff, 0xff}}},
    {{{  -717,    337,    -68}, 0, {   220,    556}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{  -565,    -59,    160}, 0, {   300,    856}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{  -540,    -80,    149}, 0, {   312,    864}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{  -701,    343,    -95}, 0, {   226,    542}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{  -737,   -126,    199}, 0, {   228,    916}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{  -757,   -165,    198}, 0, {   220,    940}, {0x20, 0x39, 0xe5, 0xff}}},
};

// 0x070004E0 - 0x070005D0
static const Vtx intro_seg7_vertex_070004E0[] = {
    {{{  -757,   -165,    198}, 0, {   220,    940}, {0x12, 0x20, 0x81, 0xff}}},
    {{{  -737,   -126,    199}, 0, {   228,    916}, {0x12, 0x20, 0x81, 0xff}}},
    {{{  -762,     -2,    104}, 0, {   212,    812}, {0x12, 0x20, 0x81, 0xff}}},
    {{{  -742,     15,    117}, 0, {   220,    806}, {0x12, 0x20, 0x81, 0xff}}},
    {{{  -762,     -2,    104}, 0, {   212,    812}, {0x18, 0x2b, 0xad, 0xff}}},
    {{{  -742,     15,    117}, 0, {   220,    806}, {0x18, 0x2b, 0xad, 0xff}}},
    {{{  -853,    141,     44}, 0, {   166,    714}, {0x18, 0x2b, 0xad, 0xff}}},
    {{{  -849,     95,     47}, 0, {   170,    740}, {0x18, 0x2b, 0xad, 0xff}}},
    {{{  -888,    390,   -122}, 0, {   142,    514}, {0x1a, 0x2e, 0xbb, 0xff}}},
    {{{  -717,    337,    -68}, 0, {   220,    556}, {0x1a, 0x2e, 0xbb, 0xff}}},
    {{{  -701,    343,    -95}, 0, {   226,    542}, {0x1a, 0x2e, 0xbb, 0xff}}},
    {{{  -877,    378,    -91}, 0, {   148,    530}, {0x1a, 0x2e, 0xbb, 0xff}}},
    {{{ -1033,     57,     69}, 0, {    90,    778}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{ -1060,    134,     48}, 0, {    76,    728}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{ -1037,   -143,    209}, 0, {    96,    942}, {0x20, 0x39, 0xe5, 0xff}}},
};

// 0x070005D0 - 0x070006D0
static const Vtx intro_seg7_vertex_070005D0[] = {
    {{{ -1015,   -173,    202}, 0, {   106,    956}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{ -1037,   -143,    209}, 0, {    96,    942}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{ -1259,   -174,    203}, 0, {    -2,    968}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{ -1234,   -144,    209}, 0, {     8,    950}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{ -1033,     57,     69}, 0, {    90,    778}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{ -1259,   -174,    203}, 0, {    -2,    968}, {0x10, 0x1c, 0x73, 0xff}}},
    {{{ -1127,    377,    -91}, 0, {    38,    542}, {0x10, 0x1c, 0x73, 0xff}}},
    {{{ -1144,    386,   -120}, 0, {    30,    528}, {0x10, 0x1c, 0x73, 0xff}}},
    {{{ -1234,   -144,    209}, 0, {     8,    950}, {0x10, 0x1c, 0x73, 0xff}}},
    {{{  -977,    387,   -120}, 0, {   104,    520}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{  -992,    378,    -91}, 0, {    98,    536}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{  -941,    285,    -61}, 0, {   122,    598}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{  -936,    -69,    142}, 0, {   138,    872}, {0x13, 0x50, 0x8c, 0xff}}},
    {{{  -939,    -22,    139}, 0, {   134,    844}, {0x13, 0x50, 0x8c, 0xff}}},
    {{{ -1060,    134,     48}, 0, {    76,    728}, {0x13, 0x50, 0x8c, 0xff}}},
    {{{ -1033,     57,     69}, 0, {    90,    778}, {0x13, 0x50, 0x8c, 0xff}}},
};

// 0x070006D0 - 0x070007B0
static const Vtx intro_seg7_vertex_070006D0[] = {
    {{{  -849,     95,     47}, 0, {   170,    740}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{  -853,    141,     44}, 0, {   166,    714}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{  -936,    -69,    142}, 0, {   138,    872}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{  -939,    -22,    139}, 0, {   134,    844}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{ -1144,    386,   -120}, 0, {    30,    528}, {0x16, 0x27, 0x9e, 0xff}}},
    {{{ -1127,    377,    -91}, 0, {    38,    542}, {0x16, 0x27, 0x9e, 0xff}}},
    {{{  -992,    378,    -91}, 0, {    98,    536}, {0x16, 0x27, 0x9e, 0xff}}},
    {{{  -977,    387,   -120}, 0, {   104,    520}, {0x16, 0x27, 0x9e, 0xff}}},
    {{{  -203,    759,   -404}, 0, {   430,    176}, {0x14, 0x23, 0x90, 0xff}}},
    {{{  -107,    408,   -201}, 0, {   484,    444}, {0x14, 0x23, 0x90, 0xff}}},
    {{{   -92,    441,   -196}, 0, {   490,    426}, {0x14, 0x23, 0x90, 0xff}}},
    {{{  -992,    378,    -91}, 0, {    98,    536}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{  -944,    243,    -14}, 0, {   124,    638}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{  -941,    285,    -61}, 0, {   122,    598}, {0x20, 0x39, 0xe5, 0xff}}},
};

// 0x070007B0 - 0x070008A0
static const Vtx intro_seg7_vertex_070007B0[] = {
    {{{  -941,    285,    -61}, 0, {   122,    598}, {0x10, 0x1c, 0x73, 0xff}}},
    {{{  -944,    243,    -14}, 0, {   124,    638}, {0x10, 0x1c, 0x73, 0xff}}},
    {{{  -877,    378,    -91}, 0, {   148,    530}, {0x10, 0x1c, 0x73, 0xff}}},
    {{{  -888,    390,   -122}, 0, {   142,    514}, {0x10, 0x1c, 0x73, 0xff}}},
    {{{  -177,    752,   -376}, 0, {   442,    188}, {0x14, 0x23, 0x90, 0xff}}},
    {{{  -203,    759,   -404}, 0, {   430,    176}, {0x14, 0x23, 0x90, 0xff}}},
    {{{   -92,    441,   -196}, 0, {   490,    426}, {0x14, 0x23, 0x90, 0xff}}},
    {{{   108,    783,   -394}, 0, {   568,    152}, {0x14, 0x23, 0x90, 0xff}}},
    {{{   137,    795,   -425}, 0, {   580,    132}, {0x14, 0x23, 0x90, 0xff}}},
    {{{   109,    566,   -292}, 0, {   576,    312}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{   108,    645,   -338}, 0, {   572,    250}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{    88,    635,   -308}, 0, {   564,    268}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{   183,    482,   -220}, 0, {   612,    382}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{   157,    554,   -285}, 0, {   598,    320}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{   147,    541,   -254}, 0, {   594,    338}, {0x20, 0x39, 0xe5, 0xff}}},
};

// 0x070008A0 - 0x07000980
static const Vtx intro_seg7_vertex_070008A0[] = {
    {{{   -92,    441,   -196}, 0, {   490,    426}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{   215,    457,   -229}, 0, {   626,    392}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{   183,    482,   -220}, 0, {   612,    382}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{   157,    554,   -285}, 0, {   598,    320}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{  -107,    408,   -201}, 0, {   484,    444}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{    82,    705,   -349}, 0, {   560,    212}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{   137,    795,   -425}, 0, {   580,    132}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{   108,    783,   -394}, 0, {   568,    152}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{    97,    675,   -355}, 0, {   566,    228}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{   -12,    706,   -349}, 0, {   518,    216}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{     5,    676,   -356}, 0, {   526,    232}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{    88,    635,   -308}, 0, {   564,    268}, {0x16, 0x27, 0x9e, 0xff}}},
    {{{   108,    645,   -338}, 0, {   572,    250}, {0x16, 0x27, 0x9e, 0xff}}},
    {{{     0,    638,   -334}, 0, {   524,    260}, {0x16, 0x27, 0x9e, 0xff}}},
};

// 0x07000980 - 0x07000A70
static const Vtx intro_seg7_vertex_07000980[] = {
    {{{    88,    595,   -285}, 0, {   566,    298}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{   109,    566,   -292}, 0, {   576,    312}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{    88,    635,   -308}, 0, {   564,    268}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{   -23,    588,   -282}, 0, {   516,    308}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{   147,    541,   -254}, 0, {   594,    338}, {0x14, 0x23, 0x90, 0xff}}},
    {{{   157,    554,   -285}, 0, {   598,    320}, {0x14, 0x23, 0x90, 0xff}}},
    {{{     8,    500,   -230}, 0, {   534,    376}, {0x14, 0x23, 0x90, 0xff}}},
    {{{    21,    514,   -262}, 0, {   538,    356}, {0x14, 0x23, 0x90, 0xff}}},
    {{{   -24,    627,   -304}, 0, {   514,    278}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{     5,    676,   -356}, 0, {   526,    232}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{   -12,    706,   -349}, 0, {   518,    216}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{     0,    638,   -334}, 0, {   524,    260}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{  -763,    816,   -380}, 0, {   184,    174}, {0x12, 0x20, 0x81, 0xff}}},
    {{{  -783,    825,   -409}, 0, {   174,    160}, {0x12, 0x20, 0x81, 0xff}}},
    {{{  -779,    523,   -234}, 0, {   186,    394}, {0x12, 0x20, 0x81, 0xff}}},
};

// 0x07000A70 - 0x07000B60
static const Vtx intro_seg7_vertex_07000A70[] = {
    {{{    88,    635,   -308}, 0, {   564,    268}, {0x16, 0x27, 0x9e, 0xff}}},
    {{{     0,    638,   -334}, 0, {   524,    260}, {0x16, 0x27, 0x9e, 0xff}}},
    {{{   -24,    627,   -304}, 0, {   514,    278}, {0x16, 0x27, 0x9e, 0xff}}},
    {{{     8,    500,   -230}, 0, {   534,    376}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{     4,    560,   -289}, 0, {   530,    320}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{   -23,    588,   -282}, 0, {   516,    308}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{   109,    566,   -292}, 0, {   576,    312}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{    21,    514,   -262}, 0, {   538,    356}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{  -619,    825,   -409}, 0, {   246,    152}, {0x16, 0x27, 0x9e, 0xff}}},
    {{{  -783,    825,   -409}, 0, {   174,    160}, {0x16, 0x27, 0x9e, 0xff}}},
    {{{  -763,    816,   -380}, 0, {   184,    174}, {0x16, 0x27, 0x9e, 0xff}}},
    {{{  -639,    816,   -380}, 0, {   238,    168}, {0x16, 0x27, 0x9e, 0xff}}},
    {{{  -633,    570,   -238}, 0, {   248,    360}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{  -619,    825,   -409}, 0, {   246,    152}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{  -639,    816,   -380}, 0, {   238,    168}, {0x20, 0x39, 0xe5, 0xff}}},
};

// 0x07000B60 - 0x07000C40
static const Vtx intro_seg7_vertex_07000B60[] = {
    {{{  -763,    816,   -380}, 0, {   184,    174}, {0x12, 0x20, 0x81, 0xff}}},
    {{{  -779,    523,   -234}, 0, {   186,    394}, {0x12, 0x20, 0x81, 0xff}}},
    {{{  -758,    540,   -221}, 0, {   194,    388}, {0x12, 0x20, 0x81, 0xff}}},
    {{{  -480,    764,   -350}, 0, {   310,    202}, {0x14, 0x23, 0x90, 0xff}}},
    {{{  -462,    777,   -381}, 0, {   316,    184}, {0x14, 0x23, 0x90, 0xff}}},
    {{{  -590,    752,   -367}, 0, {   262,    208}, {0x14, 0x23, 0x90, 0xff}}},
    {{{  -568,    747,   -340}, 0, {   272,    220}, {0x14, 0x23, 0x90, 0xff}}},
    {{{  -758,    540,   -221}, 0, {   194,    388}, {0x13, 0x50, 0x8c, 0xff}}},
    {{{  -779,    523,   -234}, 0, {   186,    394}, {0x13, 0x50, 0x8c, 0xff}}},
    {{{  -695,    420,   -175}, 0, {   226,    470}, {0x13, 0x50, 0x8c, 0xff}}},
    {{{  -687,    451,   -169}, 0, {   230,    454}, {0x13, 0x50, 0x8c, 0xff}}},
    {{{  -633,    570,   -238}, 0, {   248,    360}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{  -613,    593,   -275}, 0, {   256,    332}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{  -619,    825,   -409}, 0, {   246,    152}, {0x20, 0x39, 0xe5, 0xff}}},
};

// 0x07000C40 - 0x07000D20
static const Vtx intro_seg7_vertex_07000C40[] = {
    {{{  -590,    752,   -367}, 0, {   262,    208}, {0x12, 0x20, 0x81, 0xff}}},
    {{{  -580,    611,   -285}, 0, {   270,    318}, {0x12, 0x20, 0x81, 0xff}}},
    {{{  -559,    610,   -261}, 0, {   280,    326}, {0x12, 0x20, 0x81, 0xff}}},
    {{{  -568,    747,   -340}, 0, {   272,    220}, {0x12, 0x20, 0x81, 0xff}}},
    {{{  -613,    593,   -275}, 0, {   256,    332}, {0x12, 0x20, 0x81, 0xff}}},
    {{{  -633,    570,   -238}, 0, {   248,    360}, {0x12, 0x20, 0x81, 0xff}}},
    {{{  -498,    458,   -197}, 0, {   312,    432}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{  -433,    545,   -247}, 0, {   338,    362}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{  -455,    560,   -232}, 0, {   328,    360}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{  -510,    485,   -189}, 0, {   306,    420}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{  -462,    777,   -381}, 0, {   316,    184}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{  -480,    764,   -350}, 0, {   310,    202}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{  -687,    451,   -169}, 0, {   230,    454}, {0x20, 0x39, 0xe5, 0xff}}},
    {{{  -695,    420,   -175}, 0, {   226,    470}, {0x20, 0x39, 0xe5, 0xff}}},
};

// 0x07000D20 - 0x07000E10
static const Vtx intro_seg7_vertex_07000D20[] = {
    {{{   969,     83,      0}, 0, {   962,    654}, {0x00, 0x8b, 0x00, 0xff}}},
    {{{   992,     81,    -23}, 0, {   972,    646}, {0x00, 0x8b, 0x00, 0xff}}},
    {{{   796,    209,    -97}, 0, {   880,    554}, {0x00, 0x8b, 0x00, 0xff}}},
    {{{   495,    137,    -32}, 0, {   750,    630}, {0x00, 0x52, 0x00, 0xff}}},
    {{{   474,    139,    -56}, 0, {   740,    622}, {0x00, 0x52, 0x00, 0xff}}},
    {{{   498,    -74,     90}, 0, {   760,    796}, {0x00, 0x52, 0x00, 0xff}}},
    {{{   478,    -93,     77}, 0, {   750,    802}, {0x00, 0x52, 0x00, 0xff}}},
    {{{   935,   -153,    112}, 0, {   954,    830}, {0x00, 0xba, 0x00, 0xff}}},
    {{{   992,     81,    -23}, 0, {   972,    646}, {0x00, 0xba, 0x00, 0xff}}},
    {{{   969,     83,      0}, 0, {   962,    654}, {0x00, 0xba, 0x00, 0xff}}},
    {{{   918,   -126,    120}, 0, {   946,    818}, {0x00, 0xba, 0x00, 0xff}}},
    {{{   617,   -184,    153}, 0, {   816,    876}, {0x00, 0xac, 0x00, 0xff}}},
    {{{   610,   -215,    148}, 0, {   814,    892}, {0x00, 0xac, 0x00, 0xff}}},
    {{{   935,   -153,    112}, 0, {   954,    830}, {0x00, 0xac, 0x00, 0xff}}},
    {{{   918,   -126,    120}, 0, {   946,    818}, {0x00, 0xac, 0x00, 0xff}}},
};

// 0x07000E10 - 0x07000F00
static const Vtx intro_seg7_vertex_07000E10[] = {
    {{{   699,    103,    -12}, 0, {   842,    650}, {0x00, 0x79, 0x00, 0xff}}},
    {{{   700,     67,    -15}, 0, {   842,    668}, {0x00, 0x79, 0x00, 0xff}}},
    {{{   811,     23,     33}, 0, {   894,    706}, {0x00, 0x79, 0x00, 0xff}}},
    {{{   969,     83,      0}, 0, {   962,    654}, {0x00, 0x8b, 0x00, 0xff}}},
    {{{   796,    209,    -97}, 0, {   880,    554}, {0x00, 0x8b, 0x00, 0xff}}},
    {{{   790,    200,    -68}, 0, {   878,    570}, {0x00, 0x8b, 0x00, 0xff}}},
    {{{   811,     23,     33}, 0, {   894,    706}, {0x00, 0x4b, 0x00, 0xff}}},
    {{{   783,      8,     18}, 0, {   882,    710}, {0x00, 0x4b, 0x00, 0xff}}},
    {{{   752,    -37,     45}, 0, {   870,    748}, {0x00, 0x4b, 0x00, 0xff}}},
    {{{   765,    -44,     73}, 0, {   876,    760}, {0x00, 0x4b, 0x00, 0xff}}},
    {{{   765,    -44,     73}, 0, {   876,    760}, {0x00, 0x62, 0x00, 0xff}}},
    {{{   752,    -37,     45}, 0, {   870,    748}, {0x00, 0x62, 0x00, 0xff}}},
    {{{   671,    -50,     52}, 0, {   834,    762}, {0x00, 0x62, 0x00, 0xff}}},
    {{{   660,    -62,     83}, 0, {   830,    778}, {0x00, 0x62, 0x00, 0xff}}},
    {{{   783,      8,     18}, 0, {   882,    710}, {0x00, 0x79, 0x00, 0xff}}},
};

// 0x07000F00 - 0x07000FF0
static const Vtx intro_seg7_vertex_07000F00[] = {
    {{{   790,    200,    -68}, 0, {   878,    570}, {0x00, 0x6a, 0x00, 0xff}}},
    {{{   796,    209,    -97}, 0, {   880,    554}, {0x00, 0x6a, 0x00, 0xff}}},
    {{{   610,    209,    -97}, 0, {   798,    562}, {0x00, 0x6a, 0x00, 0xff}}},
    {{{   660,    -62,     83}, 0, {   830,    778}, {0x00, 0xa4, 0x00, 0xff}}},
    {{{   671,    -50,     52}, 0, {   834,    762}, {0x00, 0xa4, 0x00, 0xff}}},
    {{{   611,     31,     29}, 0, {   806,    708}, {0x00, 0xa4, 0x00, 0xff}}},
    {{{   636,     16,     14}, 0, {   816,    712}, {0x00, 0xa4, 0x00, 0xff}}},
    {{{   498,    -74,     90}, 0, {   760,    796}, {0x00, 0x75, 0x00, 0xff}}},
    {{{   478,    -93,     77}, 0, {   750,    802}, {0x00, 0x75, 0x00, 0xff}}},
    {{{   610,   -215,    148}, 0, {   814,    892}, {0x00, 0x75, 0x00, 0xff}}},
    {{{   617,   -184,    153}, 0, {   816,    876}, {0x00, 0x75, 0x00, 0xff}}},
    {{{   611,     31,     29}, 0, {   806,    708}, {0x00, 0xbb, 0x00, 0xff}}},
    {{{   700,     67,    -15}, 0, {   842,    668}, {0x00, 0xbb, 0x00, 0xff}}},
    {{{   699,    103,    -12}, 0, {   842,    650}, {0x00, 0xbb, 0x00, 0xff}}},
    {{{   636,     16,     14}, 0, {   816,    712}, {0x00, 0xbb, 0x00, 0xff}}},
};

// 0x07000FF0 - 0x070010E0
static const Vtx intro_seg7_vertex_07000FF0[] = {
    {{{  -397,   -107,    135}, 0, {   376,    868}, {0x00, 0x54, 0x00, 0xff}}},
    {{{  -388,   -183,    179}, 0, {   382,    928}, {0x00, 0x54, 0x00, 0xff}}},
    {{{  -370,   -153,    185}, 0, {   390,    912}, {0x00, 0x54, 0x00, 0xff}}},
    {{{   790,    200,    -68}, 0, {   878,    570}, {0x00, 0x6a, 0x00, 0xff}}},
    {{{   610,    209,    -97}, 0, {   798,    562}, {0x00, 0x6a, 0x00, 0xff}}},
    {{{   615,    199,    -68}, 0, {   802,    578}, {0x00, 0x6a, 0x00, 0xff}}},
    {{{   615,    199,    -68}, 0, {   802,    578}, {0x00, 0x54, 0x00, 0xff}}},
    {{{   610,    209,    -97}, 0, {   798,    562}, {0x00, 0x54, 0x00, 0xff}}},
    {{{   495,    137,    -32}, 0, {   750,    630}, {0x00, 0x54, 0x00, 0xff}}},
    {{{   474,    139,    -56}, 0, {   740,    622}, {0x00, 0x54, 0x00, 0xff}}},
    {{{  -370,   -153,    185}, 0, {   390,    912}, {0x00, 0xa4, 0x00, 0xff}}},
    {{{  -388,   -183,    179}, 0, {   382,    928}, {0x00, 0xa4, 0x00, 0xff}}},
    {{{  -164,   -154,    185}, 0, {   480,    902}, {0x00, 0xa4, 0x00, 0xff}}},
    {{{  -134,   -183,    179}, 0, {   494,    916}, {0x00, 0xa4, 0x00, 0xff}}},
    {{{  -378,    -82,    144}, 0, {   384,    856}, {0x00, 0x54, 0x00, 0xff}}},
};

// 0x070010E0 - 0x070011D0
static const Vtx intro_seg7_vertex_070010E0[] = {
    {{{  -164,   -154,    185}, 0, {   480,    902}, {0x00, 0xa6, 0x00, 0xff}}},
    {{{  -134,   -183,    179}, 0, {   494,    916}, {0x00, 0xa6, 0x00, 0xff}}},
    {{{  -354,    312,    -83}, 0, {   380,    550}, {0x00, 0xa6, 0x00, 0xff}}},
    {{{  -828,    -32,    115}, 0, {   184,    836}, {0x00, 0x8f, 0x00, 0xff}}},
    {{{  -861,    -51,    103}, 0, {   170,    846}, {0x00, 0x8f, 0x00, 0xff}}},
    {{{  -651,   -124,    144}, 0, {   264,    892}, {0x00, 0x8f, 0x00, 0xff}}},
    {{{  -656,    -91,    149}, 0, {   262,    876}, {0x00, 0x8f, 0x00, 0xff}}},
    {{{  -656,    -91,    149}, 0, {   262,    876}, {0x00, 0xbb, 0x00, 0xff}}},
    {{{  -573,    -52,    103}, 0, {   296,    834}, {0x00, 0xbb, 0x00, 0xff}}},
    {{{  -579,    -19,    108}, 0, {   292,    816}, {0x00, 0xbb, 0x00, 0xff}}},
    {{{  -651,   -124,    144}, 0, {   264,    892}, {0x00, 0xbb, 0x00, 0xff}}},
    {{{  -579,    -19,    108}, 0, {   292,    816}, {0x00, 0x90, 0x00, 0xff}}},
    {{{  -573,    -52,    103}, 0, {   296,    834}, {0x00, 0x90, 0x00, 0xff}}},
    {{{  -397,   -107,    135}, 0, {   376,    868}, {0x00, 0x90, 0x00, 0xff}}},
    {{{  -378,    -82,    144}, 0, {   384,    856}, {0x00, 0x90, 0x00, 0xff}}},
};

// 0x070011D0 - 0x070012C0
static const Vtx intro_seg7_vertex_070011D0[] = {
    {{{  -448,    249,    -47}, 0, {   342,    602}, {0x00, 0x5a, 0x00, 0xff}}},
    {{{  -420,     50,     43}, 0, {   360,    748}, {0x00, 0x5a, 0x00, 0xff}}},
    {{{  -391,     31,     78}, 0, {   374,    768}, {0x00, 0x5a, 0x00, 0xff}}},
    {{{  -134,   -183,    179}, 0, {   494,    916}, {0x00, 0xa6, 0x00, 0xff}}},
    {{{  -339,    318,   -110}, 0, {   386,    536}, {0x00, 0xa6, 0x00, 0xff}}},
    {{{  -354,    312,    -83}, 0, {   380,    550}, {0x00, 0xa6, 0x00, 0xff}}},
    {{{  -391,     31,     78}, 0, {   374,    768}, {0x00, 0x79, 0x00, 0xff}}},
    {{{  -537,     87,     22}, 0, {   306,    724}, {0x00, 0x79, 0x00, 0xff}}},
    {{{  -570,     87,     46}, 0, {   292,    734}, {0x00, 0x79, 0x00, 0xff}}},
    {{{  -420,     50,     43}, 0, {   360,    748}, {0x00, 0x79, 0x00, 0xff}}},
    {{{  -527,    344,   -102}, 0, {   304,    532}, {0x00, 0x4b, 0x00, 0xff}}},
    {{{  -536,    356,   -132}, 0, {   298,    516}, {0x00, 0x4b, 0x00, 0xff}}},
    {{{  -861,    -51,    103}, 0, {   170,    846}, {0x00, 0x4b, 0x00, 0xff}}},
    {{{  -828,    -32,    115}, 0, {   184,    836}, {0x00, 0x4b, 0x00, 0xff}}},
    {{{  -457,    194,    -38}, 0, {   338,    638}, {0x00, 0x5a, 0x00, 0xff}}},
};

// 0x070012C0 - 0x070013C0
static const Vtx intro_seg7_vertex_070012C0[] = {
    {{{   334,    706,   -391}, 0, {   670,    188}, {0x00, 0xb1, 0x00, 0xff}}},
    {{{   310,    758,   -397}, 0, {   658,    156}, {0x00, 0xb1, 0x00, 0xff}}},
    {{{   344,    596,   -327}, 0, {   678,    272}, {0x00, 0xb1, 0x00, 0xff}}},
    {{{  -570,     87,     46}, 0, {   292,    734}, {0x00, 0xbc, 0x00, 0xff}}},
    {{{  -457,    194,    -38}, 0, {   338,    638}, {0x00, 0xbc, 0x00, 0xff}}},
    {{{  -448,    249,    -47}, 0, {   342,    602}, {0x00, 0xbc, 0x00, 0xff}}},
    {{{  -537,     87,     22}, 0, {   306,    724}, {0x00, 0xbc, 0x00, 0xff}}},
    {{{  -354,    312,    -83}, 0, {   380,    550}, {0x00, 0x75, 0x00, 0xff}}},
    {{{  -536,    356,   -132}, 0, {   298,    516}, {0x00, 0x75, 0x00, 0xff}}},
    {{{  -527,    344,   -102}, 0, {   304,    532}, {0x00, 0x75, 0x00, 0xff}}},
    {{{  -339,    318,   -110}, 0, {   386,    536}, {0x00, 0x75, 0x00, 0xff}}},
    {{{   210,    423,   -204}, 0, {   626,    420}, {0x00, 0x54, 0x00, 0xff}}},
    {{{   175,    795,   -419}, 0, {   596,    134}, {0x00, 0x54, 0x00, 0xff}}},
    {{{   152,    804,   -447}, 0, {   586,    120}, {0x00, 0x54, 0x00, 0xff}}},
    {{{   192,    393,   -210}, 0, {   618,    436}, {0x00, 0x54, 0x00, 0xff}}},
    {{{   324,    598,   -305}, 0, {   670,    280}, {0x00, 0xb1, 0x00, 0xff}}},
};

// 0x070013C0 - 0x070014A0
static const Vtx intro_seg7_vertex_070013C0[] = {
    {{{   344,    596,   -327}, 0, {   678,    272}, {0x00, 0x98, 0x00, 0xff}}},
    {{{   324,    598,   -305}, 0, {   670,    280}, {0x00, 0x98, 0x00, 0xff}}},
    {{{   342,    578,   -294}, 0, {   678,    294}, {0x00, 0x98, 0x00, 0xff}}},
    {{{   497,    547,   -299}, 0, {   746,    304}, {0x00, 0x8a, 0x00, 0xff}}},
    {{{   462,    556,   -281}, 0, {   732,    306}, {0x00, 0x8a, 0x00, 0xff}}},
    {{{   568,    489,   -242}, 0, {   780,    354}, {0x00, 0x8a, 0x00, 0xff}}},
    {{{   604,    480,   -260}, 0, {   796,    352}, {0x00, 0x8a, 0x00, 0xff}}},
    {{{   529,    744,   -413}, 0, {   754,    150}, {0x00, 0xb1, 0x00, 0xff}}},
    {{{   509,    744,   -389}, 0, {   746,    158}, {0x00, 0xb1, 0x00, 0xff}}},
    {{{   519,    600,   -306}, 0, {   756,    270}, {0x00, 0xb1, 0x00, 0xff}}},
    {{{   541,    581,   -318}, 0, {   764,    276}, {0x00, 0xb1, 0x00, 0xff}}},
    {{{   461,    382,   -203}, 0, {   736,    434}, {0x00, 0x76, 0x00, 0xff}}},
    {{{   462,    417,   -200}, 0, {   736,    414}, {0x00, 0x76, 0x00, 0xff}}},
    {{{   336,    532,   -267}, 0, {   676,    330}, {0x00, 0x76, 0x00, 0xff}}},
};

// 0x070014A0 - 0x07001590
static const Vtx intro_seg7_vertex_070014A0[] = {
    {{{   604,    480,   -260}, 0, {   796,    352}, {0x00, 0xba, 0x00, 0xff}}},
    {{{   462,    417,   -200}, 0, {   736,    414}, {0x00, 0xba, 0x00, 0xff}}},
    {{{   461,    382,   -203}, 0, {   736,    434}, {0x00, 0xba, 0x00, 0xff}}},
    {{{   568,    489,   -242}, 0, {   780,    354}, {0x00, 0xba, 0x00, 0xff}}},
    {{{   541,    581,   -318}, 0, {   764,    276}, {0x00, 0xba, 0x00, 0xff}}},
    {{{   519,    600,   -306}, 0, {   756,    270}, {0x00, 0xba, 0x00, 0xff}}},
    {{{   497,    547,   -299}, 0, {   746,    304}, {0x00, 0xba, 0x00, 0xff}}},
    {{{   462,    556,   -281}, 0, {   732,    306}, {0x00, 0xba, 0x00, 0xff}}},
    {{{   440,    807,   -449}, 0, {   714,    104}, {0x00, 0x8d, 0x00, 0xff}}},
    {{{   509,    744,   -389}, 0, {   746,    158}, {0x00, 0x8d, 0x00, 0xff}}},
    {{{   529,    744,   -413}, 0, {   754,    150}, {0x00, 0x8d, 0x00, 0xff}}},
    {{{   434,    797,   -420}, 0, {   710,    120}, {0x00, 0x8d, 0x00, 0xff}}},
    {{{   336,    532,   -267}, 0, {   676,    330}, {0x00, 0xb1, 0x00, 0xff}}},
    {{{   339,    425,   -205}, 0, {   682,    414}, {0x00, 0xb1, 0x00, 0xff}}},
    {{{   360,    395,   -211}, 0, {   692,    428}, {0x00, 0xb1, 0x00, 0xff}}},
};

// 0x07001590 - 0x07001670
static const Vtx intro_seg7_vertex_07001590[] = {
    {{{   461,    382,   -203}, 0, {   736,    434}, {0x00, 0x76, 0x00, 0xff}}},
    {{{   336,    532,   -267}, 0, {   676,    330}, {0x00, 0x76, 0x00, 0xff}}},
    {{{   357,    475,   -258}, 0, {   688,    366}, {0x00, 0x76, 0x00, 0xff}}},
    {{{   344,    596,   -327}, 0, {   678,    272}, {0x00, 0x4c, 0x00, 0xff}}},
    {{{   444,    663,   -343}, 0, {   720,    224}, {0x00, 0x4c, 0x00, 0xff}}},
    {{{   411,    652,   -360}, 0, {   706,    226}, {0x00, 0x4c, 0x00, 0xff}}},
    {{{   342,    578,   -294}, 0, {   678,    294}, {0x00, 0x4c, 0x00, 0xff}}},
    {{{   411,    652,   -360}, 0, {   706,    226}, {0x00, 0x79, 0x00, 0xff}}},
    {{{   310,    758,   -397}, 0, {   658,    156}, {0x00, 0x79, 0x00, 0xff}}},
    {{{   334,    706,   -391}, 0, {   670,    188}, {0x00, 0x79, 0x00, 0xff}}},
    {{{   444,    663,   -343}, 0, {   720,    224}, {0x00, 0x79, 0x00, 0xff}}},
    {{{   357,    475,   -258}, 0, {   688,    366}, {0x00, 0xb1, 0x00, 0xff}}},
    {{{   336,    532,   -267}, 0, {   676,    330}, {0x00, 0xb1, 0x00, 0xff}}},
    {{{   360,    395,   -211}, 0, {   692,    428}, {0x00, 0xb1, 0x00, 0xff}}},
};

// 0x07001670 - 0x07001770
static const Vtx intro_seg7_vertex_07001670[] = {
    {{{   152,    804,   -447}, 0, {   586,    120}, {0x00, 0x6a, 0x00, 0xff}}},
    {{{   434,    797,   -420}, 0, {   710,    120}, {0x00, 0x6a, 0x00, 0xff}}},
    {{{   440,    807,   -449}, 0, {   714,    104}, {0x00, 0x6a, 0x00, 0xff}}},
    {{{   175,    795,   -419}, 0, {   596,    134}, {0x00, 0x6a, 0x00, 0xff}}},
    {{{   360,    395,   -211}, 0, {   692,    428}, {0x00, 0xa4, 0x00, 0xff}}},
    {{{   339,    425,   -205}, 0, {   682,    414}, {0x00, 0xa4, 0x00, 0xff}}},
    {{{   210,    423,   -204}, 0, {   626,    420}, {0x00, 0xa4, 0x00, 0xff}}},
    {{{   192,    393,   -210}, 0, {   618,    436}, {0x00, 0xa4, 0x00, 0xff}}},
    {{{   324,    598,   -305}, 0, {   670,    280}, {0x2f, 0xff, 0x2f, 0xff}}},
    {{{   339,    425,   -205}, 0, {   682,    414}, {0x2f, 0xff, 0x2f, 0xff}}},
    {{{   336,    532,   -267}, 0, {   676,    330}, {0x2f, 0xff, 0x2f, 0xff}}},
    {{{   342,    578,   -294}, 0, {   678,    294}, {0x2f, 0xff, 0x2f, 0xff}}},
    {{{   310,    758,   -397}, 0, {   658,    156}, {0x2f, 0xff, 0x2f, 0xff}}},
    {{{   210,    423,   -204}, 0, {   626,    420}, {0x2f, 0xff, 0x2f, 0xff}}},
    {{{   175,    795,   -419}, 0, {   596,    134}, {0x2f, 0xff, 0x2f, 0xff}}},
    {{{   434,    797,   -420}, 0, {   710,    120}, {0x2f, 0xff, 0x2f, 0xff}}},
};

// 0x07001770 - 0x07001850
static const Vtx intro_seg7_vertex_07001770[] = {
    {{{   434,    797,   -420}, 0, {   710,    120}, {0x2f, 0xff, 0x2f, 0xff}}},
    {{{   444,    663,   -343}, 0, {   720,    224}, {0x2f, 0xff, 0x2f, 0xff}}},
    {{{   519,    600,   -306}, 0, {   756,    270}, {0x2f, 0xff, 0x2f, 0xff}}},
    {{{   310,    758,   -397}, 0, {   658,    156}, {0x2f, 0xff, 0x2f, 0xff}}},
    {{{   509,    744,   -389}, 0, {   746,    158}, {0x2f, 0xff, 0x2f, 0xff}}},
    {{{   342,    578,   -294}, 0, {   678,    294}, {0x2f, 0xff, 0x2f, 0xff}}},
    {{{   462,    417,   -200}, 0, {   736,    414}, {0x2f, 0xff, 0x2f, 0xff}}},
    {{{   568,    489,   -242}, 0, {   780,    354}, {0x2f, 0xff, 0x2f, 0xff}}},
    {{{   462,    556,   -281}, 0, {   732,    306}, {0x2f, 0xff, 0x2f, 0xff}}},
    {{{   336,    532,   -267}, 0, {   676,    330}, {0x2f, 0xff, 0x2f, 0xff}}},
    {{{   256,   -197,    150}, 0, {   666,    898}, {0x62, 0x00, 0x00, 0xff}}},
    {{{   277,   -168,    157}, 0, {   674,    882}, {0x62, 0x00, 0x00, 0xff}}},
    {{{   284,    326,   -128}, 0, {   660,    498}, {0x62, 0x00, 0x00, 0xff}}},
    {{{   263,    335,   -157}, 0, {   652,    484}, {0x62, 0x00, 0x00, 0xff}}},
};

// 0x07001850 - 0x07001950
static const Vtx intro_seg7_vertex_07001850[] = {
    {{{   496,   -198,    151}, 0, {   772,    888}, {0xc5, 0x00, 0x00, 0xff}}},
    {{{   277,   -168,    157}, 0, {   674,    882}, {0xc5, 0x00, 0x00, 0xff}}},
    {{{   256,   -197,    150}, 0, {   666,    898}, {0xc5, 0x00, 0x00, 0xff}}},
    {{{   476,   -168,    157}, 0, {   762,    874}, {0xc5, 0x00, 0x00, 0xff}}},
    {{{   437,    336,   -157}, 0, {   728,    476}, {0xd4, 0x00, 0x00, 0xff}}},
    {{{   476,   -168,    157}, 0, {   762,    874}, {0xd4, 0x00, 0x00, 0xff}}},
    {{{   496,   -198,    151}, 0, {   772,    888}, {0xd4, 0x00, 0x00, 0xff}}},
    {{{   437,    336,   -157}, 0, {   728,    476}, {0xd7, 0x00, 0x00, 0xff}}},
    {{{   417,    326,   -128}, 0, {   720,    492}, {0xd7, 0x00, 0x00, 0xff}}},
    {{{   476,   -168,    157}, 0, {   762,    874}, {0xd7, 0x00, 0x00, 0xff}}},
    {{{ -1043,    585,   -270}, 0, {    68,    358}, {0x6b, 0x00, 0x00, 0xff}}},
    {{{ -1182,    531,   -239}, 0, {     8,    406}, {0x6b, 0x00, 0x00, 0xff}}},
    {{{ -1140,    536,   -218}, 0, {    26,    408}, {0x6b, 0x00, 0x00, 0xff}}},
    {{{   263,    335,   -157}, 0, {   652,    484}, {0x80, 0x00, 0x00, 0xff}}},
    {{{   284,    326,   -128}, 0, {   660,    498}, {0x80, 0x00, 0x00, 0xff}}},
    {{{   437,    336,   -157}, 0, {   728,    476}, {0x80, 0x00, 0x00, 0xff}}},
};

// 0x07001950 - 0x07001A30
static const Vtx intro_seg7_vertex_07001950[] = {
    {{{   284,    326,   -128}, 0, {   660,    498}, {0x80, 0x00, 0x00, 0xff}}},
    {{{   417,    326,   -128}, 0, {   720,    492}, {0x80, 0x00, 0x00, 0xff}}},
    {{{   437,    336,   -157}, 0, {   728,    476}, {0x80, 0x00, 0x00, 0xff}}},
    {{{ -1027,    832,   -389}, 0, {    66,    174}, {0x5e, 0x00, 0x00, 0xff}}},
    {{{ -1036,    841,   -418}, 0, {    62,    158}, {0x5e, 0x00, 0x00, 0xff}}},
    {{{ -1159,    713,   -320}, 0, {    12,    272}, {0x5e, 0x00, 0x00, 0xff}}},
    {{{ -1190,    702,   -337}, 0, {    -2,    274}, {0x5e, 0x00, 0x00, 0xff}}},
    {{{ -1159,    713,   -320}, 0, {    12,    272}, {0x93, 0x00, 0x00, 0xff}}},
    {{{ -1043,    585,   -270}, 0, {    68,    358}, {0x93, 0x00, 0x00, 0xff}}},
    {{{ -1004,    589,   -249}, 0, {    84,    360}, {0x93, 0x00, 0x00, 0xff}}},
    {{{ -1190,    702,   -337}, 0, {    -2,    274}, {0x93, 0x00, 0x00, 0xff}}},
    {{{ -1030,    702,   -314}, 0, {    70,    274}, {0xe0, 0x00, 0x00, 0xff}}},
    {{{  -946,    728,   -353}, 0, {   104,    242}, {0xe0, 0x00, 0x00, 0xff}}},
    {{{  -948,    761,   -348}, 0, {   104,    224}, {0xe0, 0x00, 0x00, 0xff}}},
};

// 0x07001A30 - 0x07001B10
static const Vtx intro_seg7_vertex_07001A30[] = {
    {{{ -1004,    589,   -249}, 0, {    84,    360}, {0x6b, 0x00, 0x00, 0xff}}},
    {{{ -1043,    585,   -270}, 0, {    68,    358}, {0x6b, 0x00, 0x00, 0xff}}},
    {{{ -1140,    536,   -218}, 0, {    26,    408}, {0x6b, 0x00, 0x00, 0xff}}},
    {{{ -1140,    536,   -218}, 0, {    26,    408}, {0x99, 0x00, 0x00, 0xff}}},
    {{{ -1182,    531,   -239}, 0, {     8,    406}, {0x99, 0x00, 0x00, 0xff}}},
    {{{ -1027,    459,   -173}, 0, {    78,    462}, {0x99, 0x00, 0x00, 0xff}}},
    {{{ -1030,    426,   -179}, 0, {    78,    480}, {0x99, 0x00, 0x00, 0xff}}},
    {{{  -868,    831,   -389}, 0, {   136,    166}, {0x80, 0x00, 0x00, 0xff}}},
    {{{  -861,    841,   -418}, 0, {   138,    152}, {0x80, 0x00, 0x00, 0xff}}},
    {{{ -1036,    841,   -418}, 0, {    62,    158}, {0x80, 0x00, 0x00, 0xff}}},
    {{{ -1027,    832,   -389}, 0, {    66,    174}, {0x80, 0x00, 0x00, 0xff}}},
    {{{ -1030,    702,   -314}, 0, {    70,    274}, {0xe0, 0x00, 0x00, 0xff}}},
    {{{  -989,    697,   -335}, 0, {    88,    268}, {0xe0, 0x00, 0x00, 0xff}}},
    {{{  -946,    728,   -353}, 0, {   104,    242}, {0xe0, 0x00, 0x00, 0xff}}},
};

// 0x07001B10 - 0x07001C00
static const Vtx intro_seg7_vertex_07001B10[] = {
    {{{  -814,    618,   -265}, 0, {   168,    330}, {0x99, 0x00, 0x00, 0xff}}},
    {{{  -786,    618,   -289}, 0, {   180,    322}, {0x99, 0x00, 0x00, 0xff}}},
    {{{ -1030,    702,   -314}, 0, {    70,    274}, {0x99, 0x00, 0x00, 0xff}}},
    {{{  -948,    761,   -348}, 0, {   104,    224}, {0xa1, 0x00, 0x00, 0xff}}},
    {{{  -946,    728,   -353}, 0, {   104,    242}, {0xa1, 0x00, 0x00, 0xff}}},
    {{{  -869,    717,   -323}, 0, {   140,    256}, {0xa1, 0x00, 0x00, 0xff}}},
    {{{  -867,    683,   -327}, 0, {   142,    274}, {0xa1, 0x00, 0x00, 0xff}}},
    {{{ -1027,    459,   -173}, 0, {    78,    462}, {0xd7, 0x00, 0x00, 0xff}}},
    {{{ -1030,    426,   -179}, 0, {    78,    480}, {0xd7, 0x00, 0x00, 0xff}}},
    {{{  -846,    489,   -215}, 0, {   158,    424}, {0xd7, 0x00, 0x00, 0xff}}},
    {{{  -862,    515,   -206}, 0, {   150,    412}, {0xd7, 0x00, 0x00, 0xff}}},
    {{{  -795,    776,   -356}, 0, {   170,    208}, {0xac, 0x00, 0x00, 0xff}}},
    {{{  -762,    766,   -374}, 0, {   184,    206}, {0xac, 0x00, 0x00, 0xff}}},
    {{{  -861,    841,   -418}, 0, {   138,    152}, {0xac, 0x00, 0x00, 0xff}}},
    {{{  -868,    831,   -389}, 0, {   136,    166}, {0xac, 0x00, 0x00, 0xff}}},
};

// 0x07001C00 - 0x07001CE0
static const Vtx intro_seg7_vertex_07001C00[] = {
    {{{  -862,    515,   -206}, 0, {   150,    412}, {0xe3, 0x00, 0x00, 0xff}}},
    {{{  -786,    618,   -289}, 0, {   180,    322}, {0xe3, 0x00, 0x00, 0xff}}},
    {{{  -814,    618,   -265}, 0, {   168,    330}, {0xe3, 0x00, 0x00, 0xff}}},
    {{{  -786,    618,   -289}, 0, {   180,    322}, {0x99, 0x00, 0x00, 0xff}}},
    {{{  -989,    697,   -335}, 0, {    88,    268}, {0x99, 0x00, 0x00, 0xff}}},
    {{{ -1030,    702,   -314}, 0, {    70,    274}, {0x99, 0x00, 0x00, 0xff}}},
    {{{  -869,    717,   -323}, 0, {   140,    256}, {0xe3, 0x00, 0x00, 0xff}}},
    {{{  -762,    766,   -374}, 0, {   184,    206}, {0xe3, 0x00, 0x00, 0xff}}},
    {{{  -795,    776,   -356}, 0, {   170,    208}, {0xe3, 0x00, 0x00, 0xff}}},
    {{{  -867,    683,   -327}, 0, {   142,    274}, {0xe3, 0x00, 0x00, 0xff}}},
    {{{  -846,    489,   -215}, 0, {   158,    424}, {0xe3, 0x00, 0x00, 0xff}}},
    {{{ -1004,    589,   -249}, 0, {    84,    360}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{ -1027,    459,   -173}, 0, {    78,    462}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{  -862,    515,   -206}, 0, {   150,    412}, {0xff, 0x2f, 0x2f, 0xff}}},
};

// 0x07001CE0 - 0x07001DE0
static const Vtx intro_seg7_vertex_07001CE0[] = {
    {{{   476,   -168,    157}, 0, {   762,    874}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{   417,    326,   -128}, 0, {   720,    492}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{   284,    326,   -128}, 0, {   660,    498}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{   277,   -168,    157}, 0, {   674,    882}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{  -948,    761,   -348}, 0, {   104,    224}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{  -869,    717,   -323}, 0, {   140,    256}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{  -795,    776,   -356}, 0, {   170,    208}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{ -1027,    832,   -389}, 0, {    66,    174}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{ -1159,    713,   -320}, 0, {    12,    272}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{ -1030,    702,   -314}, 0, {    70,    274}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{  -868,    831,   -389}, 0, {   136,    166}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{ -1004,    589,   -249}, 0, {    84,    360}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{  -814,    618,   -265}, 0, {   168,    330}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{  -862,    515,   -206}, 0, {   150,    412}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{ -1140,    536,   -218}, 0, {    26,    408}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{ -1027,    459,   -173}, 0, {    78,    462}, {0xff, 0x2f, 0x2f, 0xff}}},
};

// 0x07001DE0 - 0x07001ED0
static const Vtx intro_seg7_vertex_07001DE0[] = {
    {{{   105,     33,     48}, 0, {   592,    736}, {0xba, 0xba, 0x00, 0xff}}},
    {{{   142,     22,     30}, 0, {   608,    736}, {0xba, 0xba, 0x00, 0xff}}},
    {{{   230,     73,      1}, 0, {   646,    692}, {0xba, 0xba, 0x00, 0xff}}},
    {{{   122,   -166,    163}, 0, {   606,    890}, {0xba, 0xba, 0x00, 0xff}}},
    {{{   120,   -201,    160}, 0, {   606,    910}, {0xba, 0xba, 0x00, 0xff}}},
    {{{   260,    -69,    107}, 0, {   664,    808}, {0xba, 0xba, 0x00, 0xff}}},
    {{{   295,    -78,     89}, 0, {   680,    806}, {0xba, 0xba, 0x00, 0xff}}},
    {{{   260,    -69,    107}, 0, {   664,    808}, {0x8b, 0x8b, 0x00, 0xff}}},
    {{{   295,    -78,     89}, 0, {   680,    806}, {0x8b, 0x8b, 0x00, 0xff}}},
    {{{   142,     22,     30}, 0, {   608,    736}, {0x8b, 0x8b, 0x00, 0xff}}},
    {{{   105,     33,     48}, 0, {   592,    736}, {0x8b, 0x8b, 0x00, 0xff}}},
    {{{   -38,    -26,     82}, 0, {   532,    788}, {0x6b, 0x6b, 0x00, 0xff}}},
    {{{   -19,    -79,     89}, 0, {   540,    822}, {0x6b, 0x6b, 0x00, 0xff}}},
    {{{   120,   -201,    160}, 0, {   606,    910}, {0x6b, 0x6b, 0x00, 0xff}}},
    {{{   122,   -166,    163}, 0, {   606,    890}, {0x6b, 0x6b, 0x00, 0xff}}},
};

// 0x07001ED0 - 0x07001FD0
static const Vtx intro_seg7_vertex_07001ED0[] = {
    {{{   101,    165,    -28}, 0, {   586,    634}, {0x43, 0x43, 0x00, 0xff}}},
    {{{   -24,     75,      0}, 0, {   534,    700}, {0x43, 0x43, 0x00, 0xff}}},
    {{{   -22,     62,     31}, 0, {   534,    720}, {0x43, 0x43, 0x00, 0xff}}},
    {{{   -42,   -140,    148}, 0, {   534,    878}, {0xb6, 0xb6, 0x00, 0xff}}},
    {{{   -22,   -169,    141}, 0, {   542,    890}, {0xb6, 0xb6, 0x00, 0xff}}},
    {{{   -19,    -79,     89}, 0, {   540,    822}, {0xb6, 0xb6, 0x00, 0xff}}},
    {{{   -38,    -26,     82}, 0, {   532,    788}, {0xb6, 0xb6, 0x00, 0xff}}},
    {{{  -199,   -145,    151}, 0, {   464,    888}, {0xa4, 0xa4, 0x00, 0xff}}},
    {{{  -220,   -176,    145}, 0, {   456,    904}, {0xa4, 0xa4, 0x00, 0xff}}},
    {{{   -22,   -169,    141}, 0, {   542,    890}, {0xa4, 0xa4, 0x00, 0xff}}},
    {{{   -42,   -140,    148}, 0, {   534,    878}, {0xa4, 0xa4, 0x00, 0xff}}},
    {{{   209,     94,     12}, 0, {   636,    684}, {0xb1, 0xb1, 0x00, 0xff}}},
    {{{   230,     73,      1}, 0, {   646,    692}, {0xb1, 0xb1, 0x00, 0xff}}},
    {{{   206,    268,    -87}, 0, {   628,    550}, {0xb1, 0xb1, 0x00, 0xff}}},
    {{{   226,    271,   -113}, 0, {   638,    538}, {0xb1, 0xb1, 0x00, 0xff}}},
    {{{    68,    154,    -45}, 0, {   572,    636}, {0x43, 0x43, 0x00, 0xff}}},
};

// 0x07001FD0 - 0x070020B0
static const Vtx intro_seg7_vertex_07001FD0[] = {
    {{{   -22,     62,     31}, 0, {   534,    720}, {0x8b, 0x8b, 0x00, 0xff}}},
    {{{   -24,     75,      0}, 0, {   534,    700}, {0x8b, 0x8b, 0x00, 0xff}}},
    {{{   -45,     80,     20}, 0, {   524,    706}, {0x8b, 0x8b, 0x00, 0xff}}},
    {{{   206,    268,    -87}, 0, {   628,    550}, {0x81, 0x81, 0x00, 0xff}}},
    {{{   226,    271,   -113}, 0, {   638,    538}, {0x81, 0x81, 0x00, 0xff}}},
    {{{    12,    362,   -165}, 0, {   540,    476}, {0x81, 0x81, 0x00, 0xff}}},
    {{{     8,    353,   -136}, 0, {   538,    492}, {0x81, 0x81, 0x00, 0xff}}},
    {{{   -43,    272,    -89}, 0, {   518,    558}, {0x78, 0x78, 0x00, 0xff}}},
    {{{   -23,    222,    -84}, 0, {   528,    588}, {0x78, 0x78, 0x00, 0xff}}},
    {{{    68,    154,    -45}, 0, {   572,    636}, {0x78, 0x78, 0x00, 0xff}}},
    {{{   101,    165,    -28}, 0, {   586,    634}, {0x78, 0x78, 0x00, 0xff}}},
    {{{  -399,    424,   -165}, 0, {   356,    458}, {0xa4, 0xa4, 0x00, 0xff}}},
    {{{  -419,    394,   -172}, 0, {   348,    474}, {0xa4, 0xa4, 0x00, 0xff}}},
    {{{  -283,    394,   -171}, 0, {   408,    470}, {0xa4, 0xa4, 0x00, 0xff}}},
};

// 0x070020B0 - 0x070021A0
static const Vtx intro_seg7_vertex_070020B0[] = {
    {{{   -24,     75,      0}, 0, {   534,    700}, {0xb6, 0xb6, 0x00, 0xff}}},
    {{{   -23,    222,    -84}, 0, {   528,    588}, {0xb6, 0xb6, 0x00, 0xff}}},
    {{{   -43,    272,    -89}, 0, {   518,    558}, {0xb6, 0xb6, 0x00, 0xff}}},
    {{{   -45,     80,     20}, 0, {   524,    706}, {0xb6, 0xb6, 0x00, 0xff}}},
    {{{  -198,    352,   -136}, 0, {   448,    502}, {0x51, 0x51, 0x00, 0xff}}},
    {{{  -218,    362,   -165}, 0, {   438,    488}, {0x51, 0x51, 0x00, 0xff}}},
    {{{  -220,   -176,    145}, 0, {   456,    904}, {0x51, 0x51, 0x00, 0xff}}},
    {{{  -199,   -145,    151}, 0, {   464,    888}, {0x51, 0x51, 0x00, 0xff}}},
    {{{     8,    353,   -136}, 0, {   538,    492}, {0x6a, 0x6a, 0x00, 0xff}}},
    {{{    12,    362,   -165}, 0, {   540,    476}, {0x6a, 0x6a, 0x00, 0xff}}},
    {{{  -218,    362,   -165}, 0, {   438,    488}, {0x6a, 0x6a, 0x00, 0xff}}},
    {{{  -198,    352,   -136}, 0, {   448,    502}, {0x6a, 0x6a, 0x00, 0xff}}},
    {{{  -132,    599,   -266}, 0, {   468,    312}, {0xb1, 0xb1, 0x00, 0xff}}},
    {{{  -111,    583,   -281}, 0, {   478,    316}, {0xb1, 0xb1, 0x00, 0xff}}},
    {{{  -126,    768,   -388}, 0, {   466,    172}, {0xb1, 0xb1, 0x00, 0xff}}},
};

// 0x070021A0 - 0x07002280
static const Vtx intro_seg7_vertex_070021A0[] = {
    {{{  -399,    424,   -165}, 0, {   356,    458}, {0xa4, 0xa4, 0x00, 0xff}}},
    {{{  -283,    394,   -171}, 0, {   408,    470}, {0xa4, 0xa4, 0x00, 0xff}}},
    {{{  -303,    423,   -165}, 0, {   398,    454}, {0xa4, 0xa4, 0x00, 0xff}}},
    {{{  -400,    811,   -389}, 0, {   342,    158}, {0x51, 0x51, 0x00, 0xff}}},
    {{{  -419,    394,   -172}, 0, {   348,    474}, {0x51, 0x51, 0x00, 0xff}}},
    {{{  -399,    424,   -165}, 0, {   356,    458}, {0x51, 0x51, 0x00, 0xff}}},
    {{{  -421,    820,   -418}, 0, {   334,    144}, {0x51, 0x51, 0x00, 0xff}}},
    {{{  -145,    766,   -363}, 0, {   456,    182}, {0x83, 0x83, 0x00, 0xff}}},
    {{{  -126,    768,   -388}, 0, {   466,    172}, {0x83, 0x83, 0x00, 0xff}}},
    {{{  -238,    810,   -388}, 0, {   414,    152}, {0x83, 0x83, 0x00, 0xff}}},
    {{{  -233,    819,   -417}, 0, {   416,    138}, {0x83, 0x83, 0x00, 0xff}}},
    {{{  -132,    599,   -266}, 0, {   468,    312}, {0xb1, 0xb1, 0x00, 0xff}}},
    {{{  -126,    768,   -388}, 0, {   466,    172}, {0xb1, 0xb1, 0x00, 0xff}}},
    {{{  -145,    766,   -363}, 0, {   456,    182}, {0xb1, 0xb1, 0x00, 0xff}}},
};

// 0x07002280 - 0x07002370
static const Vtx intro_seg7_vertex_07002280[] = {
    {{{  -310,    724,   -338}, 0, {   386,    222}, {0xa1, 0xa1, 0x00, 0xff}}},
    {{{  -289,    690,   -343}, 0, {   396,    240}, {0xa1, 0xa1, 0x00, 0xff}}},
    {{{  -215,    678,   -336}, 0, {   428,    246}, {0xa1, 0xa1, 0x00, 0xff}}},
    {{{  -206,    503,   -211}, 0, {   438,    388}, {0xbc, 0xbc, 0x00, 0xff}}},
    {{{  -196,    474,   -218}, 0, {   444,    404}, {0xbc, 0xbc, 0x00, 0xff}}},
    {{{  -132,    599,   -266}, 0, {   468,    312}, {0xbc, 0xbc, 0x00, 0xff}}},
    {{{  -111,    583,   -281}, 0, {   478,    316}, {0xbc, 0xbc, 0x00, 0xff}}},
    {{{  -238,    810,   -388}, 0, {   414,    152}, {0x6a, 0x6a, 0x00, 0xff}}},
    {{{  -233,    819,   -417}, 0, {   416,    138}, {0x6a, 0x6a, 0x00, 0xff}}},
    {{{  -400,    811,   -389}, 0, {   342,    158}, {0x6a, 0x6a, 0x00, 0xff}}},
    {{{  -421,    820,   -418}, 0, {   334,    144}, {0x6a, 0x6a, 0x00, 0xff}}},
    {{{  -189,    704,   -327}, 0, {   440,    232}, {0x4c, 0x4c, 0x00, 0xff}}},
    {{{  -215,    678,   -336}, 0, {   428,    246}, {0x4c, 0x4c, 0x00, 0xff}}},
    {{{  -235,    614,   -299}, 0, {   422,    296}, {0x4c, 0x4c, 0x00, 0xff}}},
    {{{  -219,    607,   -271}, 0, {   430,    310}, {0x4c, 0x4c, 0x00, 0xff}}},
};

// 0x07002370 - 0x07002460
static const Vtx intro_seg7_vertex_07002370[] = {
    {{{  -304,    593,   -263}, 0, {   392,    324}, {0xb1, 0xb1, 0x00, 0xff}}},
    {{{  -284,    606,   -294}, 0, {   400,    304}, {0xb1, 0xb1, 0x00, 0xff}}},
    {{{  -289,    690,   -343}, 0, {   396,    240}, {0xb1, 0xb1, 0x00, 0xff}}},
    {{{  -310,    724,   -338}, 0, {   386,    222}, {0xa1, 0xa1, 0x00, 0xff}}},
    {{{  -215,    678,   -336}, 0, {   428,    246}, {0xa1, 0xa1, 0x00, 0xff}}},
    {{{  -189,    704,   -327}, 0, {   440,    232}, {0xa1, 0xa1, 0x00, 0xff}}},
    {{{  -283,    473,   -218}, 0, {   406,    408}, {0xa4, 0xa4, 0x00, 0xff}}},
    {{{  -196,    474,   -218}, 0, {   444,    404}, {0xa4, 0xa4, 0x00, 0xff}}},
    {{{  -206,    503,   -211}, 0, {   438,    388}, {0xa4, 0xa4, 0x00, 0xff}}},
    {{{  -303,    503,   -211}, 0, {   396,    394}, {0xa4, 0xa4, 0x00, 0xff}}},
    {{{  -219,    607,   -271}, 0, {   430,    310}, {0x62, 0x62, 0x00, 0xff}}},
    {{{  -235,    614,   -299}, 0, {   422,    296}, {0x62, 0x62, 0x00, 0xff}}},
    {{{  -304,    593,   -263}, 0, {   392,    324}, {0x62, 0x62, 0x00, 0xff}}},
    {{{  -284,    606,   -294}, 0, {   400,    304}, {0x62, 0x62, 0x00, 0xff}}},
    {{{  -310,    724,   -338}, 0, {   386,    222}, {0xb1, 0xb1, 0x00, 0xff}}},
};

// 0x07002460 - 0x07002560
static const Vtx intro_seg7_vertex_07002460[] = {
    {{{  -303,    423,   -165}, 0, {   398,    454}, {0xb6, 0xb6, 0x00, 0xff}}},
    {{{  -283,    394,   -171}, 0, {   408,    470}, {0xb6, 0xb6, 0x00, 0xff}}},
    {{{  -283,    473,   -218}, 0, {   406,    408}, {0xb6, 0xb6, 0x00, 0xff}}},
    {{{  -303,    503,   -211}, 0, {   396,    394}, {0xb1, 0xb1, 0x00, 0xff}}},
    {{{  -198,    352,   -136}, 0, {   448,    502}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   -43,    272,    -89}, 0, {   518,    558}, {0xff, 0xff, 0x39, 0xff}}},
    {{{     8,    353,   -136}, 0, {   538,    492}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   122,   -166,    163}, 0, {   606,    890}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   105,     33,     48}, 0, {   592,    736}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   -38,    -26,     82}, 0, {   532,    788}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   260,    -69,    107}, 0, {   664,    808}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   101,    165,    -28}, 0, {   586,    634}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   209,     94,     12}, 0, {   636,    684}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   -22,     62,     31}, 0, {   534,    720}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   -45,     80,     20}, 0, {   524,    706}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   -42,   -140,    148}, 0, {   534,    878}, {0xff, 0xff, 0x39, 0xff}}},
};

// 0x07002560 - 0x07002660
static const Vtx intro_seg7_vertex_07002560[] = {
    {{{   101,    165,    -28}, 0, {   586,    634}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   206,    268,    -87}, 0, {   628,    550}, {0xff, 0xff, 0x39, 0xff}}},
    {{{     8,    353,   -136}, 0, {   538,    492}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   -43,    272,    -89}, 0, {   518,    558}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   209,     94,     12}, 0, {   636,    684}, {0xff, 0xff, 0x39, 0xff}}},
    {{{  -198,    352,   -136}, 0, {   448,    502}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   -45,     80,     20}, 0, {   524,    706}, {0xff, 0xff, 0x39, 0xff}}},
    {{{  -199,   -145,    151}, 0, {   464,    888}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   -42,   -140,    148}, 0, {   534,    878}, {0xff, 0xff, 0x39, 0xff}}},
    {{{  -219,    607,   -271}, 0, {   430,    310}, {0xff, 0xff, 0x39, 0xff}}},
    {{{  -145,    766,   -363}, 0, {   456,    182}, {0xff, 0xff, 0x39, 0xff}}},
    {{{  -189,    704,   -327}, 0, {   440,    232}, {0xff, 0xff, 0x39, 0xff}}},
    {{{  -132,    599,   -266}, 0, {   468,    312}, {0xff, 0xff, 0x39, 0xff}}},
    {{{  -206,    503,   -211}, 0, {   438,    388}, {0xff, 0xff, 0x39, 0xff}}},
    {{{  -304,    593,   -263}, 0, {   392,    324}, {0xff, 0xff, 0x39, 0xff}}},
    {{{  -303,    503,   -211}, 0, {   396,    394}, {0xff, 0xff, 0x39, 0xff}}},
};

// 0x07002660 - 0x07002760
static const Vtx intro_seg7_vertex_07002660[] = {
    {{{  -400,    811,   -389}, 0, {   342,    158}, {0xff, 0xff, 0x39, 0xff}}},
    {{{  -189,    704,   -327}, 0, {   440,    232}, {0xff, 0xff, 0x39, 0xff}}},
    {{{  -145,    766,   -363}, 0, {   456,    182}, {0xff, 0xff, 0x39, 0xff}}},
    {{{  -310,    724,   -338}, 0, {   386,    222}, {0xff, 0xff, 0x39, 0xff}}},
    {{{  -238,    810,   -388}, 0, {   414,    152}, {0xff, 0xff, 0x39, 0xff}}},
    {{{  -304,    593,   -263}, 0, {   392,    324}, {0xff, 0xff, 0x39, 0xff}}},
    {{{  -399,    424,   -165}, 0, {   356,    458}, {0xff, 0xff, 0x39, 0xff}}},
    {{{  -303,    423,   -165}, 0, {   398,    454}, {0xff, 0xff, 0x39, 0xff}}},
    {{{  -303,    503,   -211}, 0, {   396,    394}, {0xff, 0xff, 0x39, 0xff}}},
    {{{  1414,    378,   -183}, 0, {  5366,     42}, {0x95, 0x95, 0x61, 0xff}}},
    {{{  1414,    176,   -350}, 0, {  6200,    858}, {0x95, 0x95, 0x61, 0xff}}},
    {{{  1414,    255,   -396}, 0, {  5366,     42}, {0x95, 0x95, 0x61, 0xff}}},
    {{{  1462,    447,   -223}, 0, {  5238,   -508}, {0x95, 0x95, 0x61, 0xff}}},
    {{{  1462,    378,   -183}, 0, {  5806,     34}, {0x95, 0x95, 0x61, 0xff}}},
    {{{  1462,    255,   -396}, 0, {  5806,     34}, {0x95, 0x95, 0x61, 0xff}}},
    {{{  1462,    325,   -436}, 0, {  5238,   -508}, {0x95, 0x95, 0x61, 0xff}}},
};

// 0x07002760 - 0x07002840
static const Vtx intro_seg7_vertex_07002760[] = {
    {{{  1462,    378,   -183}, 0, {  5806,     34}, {0x74, 0x74, 0x55, 0xff}}},
    {{{  1414,    255,   -396}, 0, {  5366,     42}, {0x74, 0x74, 0x55, 0xff}}},
    {{{  1462,    255,   -396}, 0, {  5806,     34}, {0x74, 0x74, 0x55, 0xff}}},
    {{{  1414,    378,   -183}, 0, {  5366,     42}, {0x74, 0x74, 0x55, 0xff}}},
    {{{  1414,    447,   -223}, 0, {  4812,   -502}, {0x36, 0x36, 0x23, 0xff}}},
    {{{  1462,    325,   -436}, 0, {  5238,   -508}, {0x36, 0x36, 0x23, 0xff}}},
    {{{  1414,    325,   -436}, 0, {  4812,   -502}, {0x36, 0x36, 0x23, 0xff}}},
    {{{  1462,    447,   -223}, 0, {  5238,   -508}, {0x36, 0x36, 0x23, 0xff}}},
    {{{  1120,    451,   -225}, 0, {  2146,   -484}, {0x36, 0x36, 0x23, 0xff}}},
    {{{  1333,    563,   -573}, 0, {  1952,  -2664}, {0x36, 0x36, 0x23, 0xff}}},
    {{{  1120,    328,   -438}, 0, {  2146,   -484}, {0x36, 0x36, 0x23, 0xff}}},
    {{{  1414,    378,   -183}, 0, {  5366,     42}, {0x95, 0x95, 0x61, 0xff}}},
    {{{  1414,    299,   -137}, 0, {  6200,    858}, {0x95, 0x95, 0x61, 0xff}}},
    {{{  1414,    176,   -350}, 0, {  6200,    858}, {0x95, 0x95, 0x61, 0xff}}},
};

// 0x07002840 - 0x07002940
static const Vtx intro_seg7_vertex_07002840[] = {
    {{{  1414,    685,   -360}, 0, {  2590,  -2676}, {0x95, 0x95, 0x61, 0xff}}},
    {{{  1414,    325,   -436}, 0, {  4812,   -502}, {0x95, 0x95, 0x61, 0xff}}},
    {{{  1414,    563,   -573}, 0, {  2590,  -2676}, {0x95, 0x95, 0x61, 0xff}}},
    {{{  1414,    447,   -223}, 0, {  4812,   -502}, {0x95, 0x95, 0x61, 0xff}}},
    {{{  1333,    685,   -360}, 0, {  1952,  -2664}, {0x36, 0x36, 0x23, 0xff}}},
    {{{  1414,    685,   -360}, 0, {  2590,  -2676}, {0x36, 0x36, 0x23, 0xff}}},
    {{{  1414,    563,   -573}, 0, {  2590,  -2676}, {0x36, 0x36, 0x23, 0xff}}},
    {{{  1333,    563,   -573}, 0, {  1952,  -2664}, {0x36, 0x36, 0x23, 0xff}}},
    {{{  1120,    451,   -225}, 0, {  2146,   -484}, {0x36, 0x36, 0x23, 0xff}}},
    {{{  1229,    450,   -224}, 0, {  2858,   -486}, {0x36, 0x36, 0x23, 0xff}}},
    {{{  1320,    450,   -224}, 0, {  3950,   -506}, {0x36, 0x36, 0x23, 0xff}}},
    {{{  1320,    327,   -437}, 0, {  3950,   -506}, {0x36, 0x36, 0x23, 0xff}}},
    {{{  1414,    299,   -137}, 0, {  6200,    858}, {0x74, 0x74, 0x55, 0xff}}},
    {{{  1320,    176,   -350}, 0, {  5358,    874}, {0x74, 0x74, 0x55, 0xff}}},
    {{{  1414,    176,   -350}, 0, {  6200,    858}, {0x74, 0x74, 0x55, 0xff}}},
    {{{  1320,    299,   -137}, 0, {  5358,    874}, {0x74, 0x74, 0x55, 0xff}}},
};

// 0x07002940 - 0x07002A40
static const Vtx intro_seg7_vertex_07002940[] = {
    {{{  1320,    299,   -137}, 0, {  5358,    874}, {0x36, 0x36, 0x23, 0xff}}},
    {{{  1320,    255,   -396}, 0, {  4526,     58}, {0x36, 0x36, 0x23, 0xff}}},
    {{{  1320,    176,   -350}, 0, {  5358,    874}, {0x36, 0x36, 0x23, 0xff}}},
    {{{  1320,    378,   -183}, 0, {  4526,     58}, {0x36, 0x36, 0x23, 0xff}}},
    {{{  1320,    450,   -224}, 0, {  3950,   -506}, {0x36, 0x36, 0x23, 0xff}}},
    {{{  1320,    430,   -497}, 0, {  2712,  -1718}, {0x36, 0x36, 0x23, 0xff}}},
    {{{  1320,    327,   -437}, 0, {  3950,   -506}, {0x36, 0x36, 0x23, 0xff}}},
    {{{  1320,    553,   -284}, 0, {  2712,  -1718}, {0x36, 0x36, 0x23, 0xff}}},
    {{{  1320,    378,   -183}, 0, {  4526,     58}, {0x74, 0x74, 0x55, 0xff}}},
    {{{  1123,    378,   -183}, 0, {  2732,     92}, {0x74, 0x74, 0x55, 0xff}}},
    {{{  1123,    255,   -396}, 0, {  2732,     92}, {0x74, 0x74, 0x55, 0xff}}},
    {{{  1229,    450,   -224}, 0, {  2858,   -486}, {0x36, 0x36, 0x23, 0xff}}},
    {{{  1229,    327,   -437}, 0, {  2858,   -486}, {0x36, 0x36, 0x23, 0xff}}},
    {{{  1320,    553,   -284}, 0, {  2712,  -1718}, {0xa7, 0xa7, 0x7b, 0xff}}},
    {{{  1229,    327,   -437}, 0, {  2858,   -486}, {0xa7, 0xa7, 0x7b, 0xff}}},
    {{{  1320,    430,   -497}, 0, {  2712,  -1718}, {0xa7, 0xa7, 0x7b, 0xff}}},
};

// 0x07002A40 - 0x07002B40
static const Vtx intro_seg7_vertex_07002A40[] = {
    {{{  1320,    553,   -284}, 0, {  2712,  -1718}, {0xa7, 0xa7, 0x7b, 0xff}}},
    {{{  1229,    450,   -224}, 0, {  2858,   -486}, {0xa7, 0xa7, 0x7b, 0xff}}},
    {{{  1229,    327,   -437}, 0, {  2858,   -486}, {0xa7, 0xa7, 0x7b, 0xff}}},
    {{{  1123,    378,   -183}, 0, {  2732,     92}, {0x36, 0x36, 0x23, 0xff}}},
    {{{  1120,    451,   -225}, 0, {  2146,   -484}, {0x36, 0x36, 0x23, 0xff}}},
    {{{  1120,    328,   -438}, 0, {  2146,   -484}, {0x36, 0x36, 0x23, 0xff}}},
    {{{  1123,    255,   -396}, 0, {  2732,     92}, {0x36, 0x36, 0x23, 0xff}}},
    {{{  1320,    378,   -183}, 0, {  4526,     58}, {0x74, 0x74, 0x55, 0xff}}},
    {{{  1123,    255,   -396}, 0, {  2732,     92}, {0x74, 0x74, 0x55, 0xff}}},
    {{{  1320,    255,   -396}, 0, {  4526,     58}, {0x74, 0x74, 0x55, 0xff}}},
    {{{  1026,    526,   -269}, 0, {   604,  -1156}, {0x5f, 0x5f, 0x3d, 0xff}}},
    {{{  1060,    366,   -459}, 0, {  1262,   -818}, {0x5f, 0x5f, 0x3d, 0xff}}},
    {{{  1026,    403,   -481}, 0, {   604,  -1156}, {0x5f, 0x5f, 0x3d, 0xff}}},
    {{{  1075,    426,   -211}, 0, {  1974,   -254}, {0xa0, 0x9e, 0x6f, 0xff}}},
    {{{  1068,    376,   -182}, 0, {  2376,    204}, {0xa0, 0x9e, 0x6f, 0xff}}},
    {{{  1068,    254,   -395}, 0, {  2376,    204}, {0xa0, 0x9e, 0x6f, 0xff}}},
};

// 0x07002B40 - 0x07002C20
static const Vtx intro_seg7_vertex_07002B40[] = {
    {{{  1075,    426,   -211}, 0, {  1974,   -254}, {0xa0, 0x9e, 0x6f, 0xff}}},
    {{{  1068,    254,   -395}, 0, {  2376,    204}, {0xa0, 0x9e, 0x6f, 0xff}}},
    {{{  1075,    304,   -423}, 0, {  1974,   -254}, {0xa0, 0x9e, 0x6f, 0xff}}},
    {{{  1060,    488,   -247}, 0, {  1262,   -818}, {0x88, 0x88, 0x58, 0xff}}},
    {{{  1075,    304,   -423}, 0, {  1974,   -254}, {0x88, 0x88, 0x58, 0xff}}},
    {{{  1060,    366,   -459}, 0, {  1262,   -818}, {0x88, 0x88, 0x58, 0xff}}},
    {{{  1075,    426,   -211}, 0, {  1974,   -254}, {0x88, 0x88, 0x58, 0xff}}},
    {{{  1068,    376,   -182}, 0, {  2376,    204}, {0xa7, 0xa7, 0x7b, 0xff}}},
    {{{  1035,    335,   -158}, 0, {  2460,    586}, {0xa7, 0xa7, 0x7b, 0xff}}},
    {{{  1035,    213,   -371}, 0, {  2460,    586}, {0xa7, 0xa7, 0x7b, 0xff}}},
    {{{  1068,    254,   -395}, 0, {  2376,    204}, {0xa7, 0xa7, 0x7b, 0xff}}},
    {{{   956,    696,   -367}, 0, { -1608,  -2696}, {0x36, 0x36, 0x23, 0xff}}},
    {{{  1013,    694,   -366}, 0, { -1084,  -2690}, {0x36, 0x36, 0x23, 0xff}}},
    {{{  1013,    571,   -578}, 0, { -1084,  -2690}, {0x36, 0x36, 0x23, 0xff}}},
};

// 0x07002C20 - 0x07002D20
static const Vtx intro_seg7_vertex_07002C20[] = {
    {{{  1026,    526,   -269}, 0, {   604,  -1156}, {0x5f, 0x5f, 0x3d, 0xff}}},
    {{{  1060,    488,   -247}, 0, {  1262,   -818}, {0x5f, 0x5f, 0x3d, 0xff}}},
    {{{  1060,    366,   -459}, 0, {  1262,   -818}, {0x5f, 0x5f, 0x3d, 0xff}}},
    {{{  1013,    694,   -366}, 0, { -1084,  -2690}, {0x95, 0x95, 0x61, 0xff}}},
    {{{  1012,    494,   -533}, 0, {  -532,  -2150}, {0x95, 0x95, 0x61, 0xff}}},
    {{{  1013,    571,   -578}, 0, { -1084,  -2690}, {0x95, 0x95, 0x61, 0xff}}},
    {{{  1012,    616,   -321}, 0, {  -532,  -2150}, {0x95, 0x95, 0x61, 0xff}}},
    {{{  1035,    335,   -158}, 0, {  2460,    586}, {0x9a, 0x9a, 0x72, 0xff}}},
    {{{   979,    183,   -354}, 0, {  2234,    864}, {0x9a, 0x9a, 0x72, 0xff}}},
    {{{  1035,    213,   -371}, 0, {  2460,    586}, {0x9a, 0x9a, 0x72, 0xff}}},
    {{{   979,    306,   -141}, 0, {  2234,    864}, {0x9a, 0x9a, 0x72, 0xff}}},
    {{{   956,    696,   -367}, 0, { -1608,  -2696}, {0x36, 0x36, 0x23, 0xff}}},
    {{{  1013,    571,   -578}, 0, { -1084,  -2690}, {0x36, 0x36, 0x23, 0xff}}},
    {{{   956,    573,   -579}, 0, { -1608,  -2696}, {0x36, 0x36, 0x23, 0xff}}},
    {{{   884,    687,   -361}, 0, { -2112,  -2600}, {0x36, 0x36, 0x23, 0xff}}},
    {{{   884,    564,   -574}, 0, { -2112,  -2600}, {0x36, 0x36, 0x23, 0xff}}},
};

// 0x07002D20 - 0x07002E20
static const Vtx intro_seg7_vertex_07002D20[] = {
    {{{   978,    546,   -280}, 0, {   -12,  -1328}, {0x36, 0x36, 0x23, 0xff}}},
    {{{  1026,    403,   -481}, 0, {   604,  -1156}, {0x36, 0x36, 0x23, 0xff}}},
    {{{   978,    423,   -492}, 0, {   -12,  -1328}, {0x36, 0x36, 0x23, 0xff}}},
    {{{  1026,    526,   -269}, 0, {   604,  -1156}, {0x36, 0x36, 0x23, 0xff}}},
    {{{   923,    552,   -283}, 0, {  -554,  -1372}, {0x36, 0x36, 0x23, 0xff}}},
    {{{   923,    429,   -496}, 0, {  -554,  -1372}, {0x36, 0x36, 0x23, 0xff}}},
    {{{  1012,    616,   -321}, 0, {  -532,  -2150}, {0x74, 0x74, 0x55, 0xff}}},
    {{{   959,    616,   -321}, 0, { -1018,  -2124}, {0x74, 0x74, 0x55, 0xff}}},
    {{{   959,    494,   -533}, 0, { -1018,  -2124}, {0x74, 0x74, 0x55, 0xff}}},
    {{{  1012,    494,   -533}, 0, {  -532,  -2150}, {0x74, 0x74, 0x55, 0xff}}},
    {{{   939,    375,   -182}, 0, {  1350,    308}, {0x36, 0x36, 0x23, 0xff}}},
    {{{   968,    394,   -192}, 0, {  1348,     98}, {0x36, 0x36, 0x23, 0xff}}},
    {{{   968,    271,   -405}, 0, {  1348,     98}, {0x36, 0x36, 0x23, 0xff}}},
    {{{   972,    429,   -212}, 0, {  1024,   -258}, {0x36, 0x36, 0x23, 0xff}}},
    {{{   972,    306,   -425}, 0, {  1024,   -258}, {0x36, 0x36, 0x23, 0xff}}},
    {{{   960,    339,   -444}, 0, {   608,   -558}, {0x36, 0x36, 0x23, 0xff}}},
};

// 0x07002E20 - 0x07002F10
static const Vtx intro_seg7_vertex_07002E20[] = {
    {{{   939,    375,   -182}, 0, {  1350,    308}, {0x36, 0x36, 0x23, 0xff}}},
    {{{   968,    271,   -405}, 0, {  1348,     98}, {0x36, 0x36, 0x23, 0xff}}},
    {{{   939,    253,   -394}, 0, {  1350,    308}, {0x36, 0x36, 0x23, 0xff}}},
    {{{   972,    429,   -212}, 0, {  1024,   -258}, {0x36, 0x36, 0x23, 0xff}}},
    {{{   960,    462,   -231}, 0, {   608,   -558}, {0x36, 0x36, 0x23, 0xff}}},
    {{{   960,    339,   -444}, 0, {   608,   -558}, {0x36, 0x36, 0x23, 0xff}}},
    {{{   908,    370,   -179}, 0, {  1118,    400}, {0x36, 0x36, 0x23, 0xff}}},
    {{{   908,    248,   -391}, 0, {  1118,    400}, {0x36, 0x36, 0x23, 0xff}}},
    {{{   979,    306,   -141}, 0, {  2234,    864}, {0x88, 0x88, 0x58, 0xff}}},
    {{{   916,    292,   -133}, 0, {  1798,   1000}, {0x88, 0x88, 0x58, 0xff}}},
    {{{   916,    169,   -346}, 0, {  1798,   1000}, {0x88, 0x88, 0x58, 0xff}}},
    {{{   979,    183,   -354}, 0, {  2234,    864}, {0x88, 0x88, 0x58, 0xff}}},
    {{{   959,    616,   -321}, 0, { -1018,  -2124}, {0x81, 0x81, 0x5f, 0xff}}},
    {{{   909,    608,   -316}, 0, { -1386,  -2048}, {0x81, 0x81, 0x5f, 0xff}}},
    {{{   909,    486,   -529}, 0, { -1386,  -2048}, {0x81, 0x81, 0x5f, 0xff}}},
};

// 0x07002F10 - 0x07003000
static const Vtx intro_seg7_vertex_07002F10[] = {
    {{{   868,    547,   -281}, 0, { -1006,  -1320}, {0x36, 0x36, 0x23, 0xff}}},
    {{{   923,    552,   -283}, 0, {  -554,  -1372}, {0x36, 0x36, 0x23, 0xff}}},
    {{{   923,    429,   -496}, 0, {  -554,  -1372}, {0x36, 0x36, 0x23, 0xff}}},
    {{{   868,    424,   -493}, 0, { -1006,  -1320}, {0x36, 0x36, 0x23, 0xff}}},
    {{{   960,    462,   -231}, 0, {   608,   -558}, {0x40, 0x40, 0x2f, 0xff}}},
    {{{   936,    350,   -450}, 0, {   200,   -734}, {0x40, 0x40, 0x2f, 0xff}}},
    {{{   960,    339,   -444}, 0, {   608,   -558}, {0x40, 0x40, 0x2f, 0xff}}},
    {{{   936,    473,   -238}, 0, {   200,   -734}, {0x40, 0x40, 0x2f, 0xff}}},
    {{{   806,    655,   -343}, 0, { -2524,  -2286}, {0x36, 0x36, 0x23, 0xff}}},
    {{{   884,    687,   -361}, 0, { -2112,  -2600}, {0x36, 0x36, 0x23, 0xff}}},
    {{{   884,    564,   -574}, 0, { -2112,  -2600}, {0x36, 0x36, 0x23, 0xff}}},
    {{{   806,    532,   -555}, 0, { -2524,  -2286}, {0x36, 0x36, 0x23, 0xff}}},
    {{{   959,    616,   -321}, 0, { -1018,  -2124}, {0x81, 0x81, 0x5f, 0xff}}},
    {{{   909,    486,   -529}, 0, { -1386,  -2048}, {0x81, 0x81, 0x5f, 0xff}}},
    {{{   959,    494,   -533}, 0, { -1018,  -2124}, {0x81, 0x81, 0x5f, 0xff}}},
};

// 0x07003000 - 0x070030F0
static const Vtx intro_seg7_vertex_07003000[] = {
    {{{   878,    371,   -179}, 0, {   762,    368}, {0x36, 0x36, 0x23, 0xff}}},
    {{{   908,    370,   -179}, 0, {  1118,    400}, {0x36, 0x36, 0x23, 0xff}}},
    {{{   908,    248,   -391}, 0, {  1118,    400}, {0x36, 0x36, 0x23, 0xff}}},
    {{{   878,    249,   -392}, 0, {   762,    368}, {0x36, 0x36, 0x23, 0xff}}},
    {{{   936,    473,   -238}, 0, {   200,   -734}, {0x6c, 0x6c, 0x46, 0xff}}},
    {{{   900,    475,   -239}, 0, {  -178,   -764}, {0x6c, 0x6c, 0x46, 0xff}}},
    {{{   900,    352,   -451}, 0, {  -178,   -764}, {0x6c, 0x6c, 0x46, 0xff}}},
    {{{   936,    350,   -450}, 0, {   200,   -734}, {0x6c, 0x6c, 0x46, 0xff}}},
    {{{   825,    530,   -271}, 0, { -1230,  -1160}, {0x36, 0x36, 0x23, 0xff}}},
    {{{   868,    547,   -281}, 0, { -1006,  -1320}, {0x36, 0x36, 0x23, 0xff}}},
    {{{   868,    424,   -493}, 0, { -1006,  -1320}, {0x36, 0x36, 0x23, 0xff}}},
    {{{   916,    292,   -133}, 0, {  1798,   1000}, {0x6a, 0x74, 0x55, 0xff}}},
    {{{   840,    177,   -350}, 0, {  1048,    946}, {0x6a, 0x74, 0x55, 0xff}}},
    {{{   916,    169,   -346}, 0, {  1798,   1000}, {0x6a, 0x74, 0x55, 0xff}}},
    {{{   825,    407,   -483}, 0, { -1230,  -1160}, {0x36, 0x36, 0x23, 0xff}}},
};

// 0x070030F0 - 0x070031E0
static const Vtx intro_seg7_vertex_070030F0[] = {
    {{{   909,    608,   -316}, 0, { -1386,  -2048}, {0x94, 0x91, 0x66, 0xff}}},
    {{{   872,    471,   -520}, 0, { -1566,  -1856}, {0x94, 0x91, 0x66, 0xff}}},
    {{{   909,    486,   -529}, 0, { -1386,  -2048}, {0x94, 0x91, 0x66, 0xff}}},
    {{{   872,    593,   -307}, 0, { -1566,  -1856}, {0x94, 0x91, 0x66, 0xff}}},
    {{{   852,    382,   -185}, 0, {   364,    220}, {0x36, 0x36, 0x23, 0xff}}},
    {{{   878,    371,   -179}, 0, {   762,    368}, {0x36, 0x36, 0x23, 0xff}}},
    {{{   878,    249,   -392}, 0, {   762,    368}, {0x36, 0x36, 0x23, 0xff}}},
    {{{   852,    259,   -398}, 0, {   364,    220}, {0x36, 0x36, 0x23, 0xff}}},
    {{{   916,    292,   -133}, 0, {  1798,   1000}, {0x6a, 0x74, 0x55, 0xff}}},
    {{{   840,    299,   -138}, 0, {  1048,    946}, {0x6a, 0x74, 0x55, 0xff}}},
    {{{   840,    177,   -350}, 0, {  1048,    946}, {0x6a, 0x74, 0x55, 0xff}}},
    {{{   900,    475,   -239}, 0, {  -178,   -764}, {0x81, 0x81, 0x5f, 0xff}}},
    {{{   863,    346,   -448}, 0, {  -428,   -672}, {0x81, 0x81, 0x5f, 0xff}}},
    {{{   900,    352,   -451}, 0, {  -178,   -764}, {0x81, 0x81, 0x5f, 0xff}}},
    {{{   863,    468,   -235}, 0, {  -428,   -672}, {0x81, 0x81, 0x5f, 0xff}}},
};

// 0x070031E0 - 0x070032E0
static const Vtx intro_seg7_vertex_070031E0[] = {
    {{{   753,    600,   -311}, 0, { -2528,  -1784}, {0x36, 0x36, 0x23, 0xff}}},
    {{{   806,    655,   -343}, 0, { -2524,  -2286}, {0x36, 0x36, 0x23, 0xff}}},
    {{{   806,    532,   -555}, 0, { -2524,  -2286}, {0x36, 0x36, 0x23, 0xff}}},
    {{{   753,    477,   -524}, 0, { -2528,  -1784}, {0x36, 0x36, 0x23, 0xff}}},
    {{{   872,    593,   -307}, 0, { -1566,  -1856}, {0xa3, 0xa3, 0x69, 0xff}}},
    {{{   841,    569,   -293}, 0, { -1530,  -1554}, {0xa3, 0xa3, 0x69, 0xff}}},
    {{{   841,    446,   -506}, 0, { -1530,  -1554}, {0xa3, 0xa3, 0x69, 0xff}}},
    {{{   872,    471,   -520}, 0, { -1566,  -1856}, {0xa3, 0xa3, 0x69, 0xff}}},
    {{{   825,    407,   -483}, 0, { -1230,  -1160}, {0xa3, 0xa3, 0x69, 0xff}}},
    {{{   825,    530,   -271}, 0, { -1230,  -1160}, {0xa3, 0xa3, 0x69, 0xff}}},
    {{{   840,    299,   -138}, 0, {  1048,    946}, {0x44, 0x44, 0x2c, 0xff}}},
    {{{   786,    199,   -363}, 0, {   354,    748}, {0x44, 0x44, 0x2c, 0xff}}},
    {{{   840,    177,   -350}, 0, {  1048,    946}, {0x44, 0x44, 0x2c, 0xff}}},
    {{{   863,    468,   -235}, 0, {  -428,   -672}, {0xa0, 0x9e, 0x6f, 0xff}}},
    {{{   826,    444,   -221}, 0, {  -492,   -456}, {0xa0, 0x9e, 0x6f, 0xff}}},
    {{{   826,    321,   -434}, 0, {  -492,   -456}, {0xa0, 0x9e, 0x6f, 0xff}}},
};

// 0x070032E0 - 0x070033C0
static const Vtx intro_seg7_vertex_070032E0[] = {
    {{{   863,    468,   -235}, 0, {  -428,   -672}, {0xa0, 0x9e, 0x6f, 0xff}}},
    {{{   826,    321,   -434}, 0, {  -492,   -456}, {0xa0, 0x9e, 0x6f, 0xff}}},
    {{{   863,    346,   -448}, 0, {  -428,   -672}, {0xa0, 0x9e, 0x6f, 0xff}}},
    {{{   833,    407,   -200}, 0, {   -16,    -38}, {0x6a, 0x74, 0x55, 0xff}}},
    {{{   852,    382,   -185}, 0, {   364,    220}, {0x6a, 0x74, 0x55, 0xff}}},
    {{{   852,    259,   -398}, 0, {   364,    220}, {0x6a, 0x74, 0x55, 0xff}}},
    {{{   833,    284,   -412}, 0, {   -16,    -38}, {0x6a, 0x74, 0x55, 0xff}}},
    {{{   826,    444,   -221}, 0, {  -492,   -456}, {0x8e, 0x8e, 0x68, 0xff}}},
    {{{   833,    284,   -412}, 0, {   -16,    -38}, {0x8e, 0x8e, 0x68, 0xff}}},
    {{{   826,    321,   -434}, 0, {  -492,   -456}, {0x8e, 0x8e, 0x68, 0xff}}},
    {{{   833,    407,   -200}, 0, {   -16,    -38}, {0x8e, 0x8e, 0x68, 0xff}}},
    {{{   747,    364,   -175}, 0, {  -388,    368}, {0x36, 0x36, 0x23, 0xff}}},
    {{{   729,    405,   -199}, 0, {  -932,     -6}, {0x36, 0x36, 0x23, 0xff}}},
    {{{   729,    283,   -411}, 0, {  -932,     -6}, {0x36, 0x36, 0x23, 0xff}}},
};

// 0x070033C0 - 0x070034A0
static const Vtx intro_seg7_vertex_070033C0[] = {
    {{{   840,    299,   -138}, 0, {  1048,    946}, {0x44, 0x44, 0x2c, 0xff}}},
    {{{   786,    322,   -151}, 0, {   354,    748}, {0x44, 0x44, 0x2c, 0xff}}},
    {{{   786,    199,   -363}, 0, {   354,    748}, {0x44, 0x44, 0x2c, 0xff}}},
    {{{   729,    550,   -283}, 0, { -2284,  -1330}, {0x36, 0x36, 0x23, 0xff}}},
    {{{   753,    600,   -311}, 0, { -2528,  -1784}, {0x36, 0x36, 0x23, 0xff}}},
    {{{   753,    477,   -524}, 0, { -2528,  -1784}, {0x36, 0x36, 0x23, 0xff}}},
    {{{   729,    428,   -495}, 0, { -2284,  -1330}, {0x36, 0x36, 0x23, 0xff}}},
    {{{   786,    322,   -151}, 0, {   354,    748}, {0x36, 0x36, 0x23, 0xff}}},
    {{{   747,    242,   -388}, 0, {  -388,    368}, {0x36, 0x36, 0x23, 0xff}}},
    {{{   786,    199,   -363}, 0, {   354,    748}, {0x36, 0x36, 0x23, 0xff}}},
    {{{   747,    364,   -175}, 0, {  -388,    368}, {0x36, 0x36, 0x23, 0xff}}},
    {{{   729,    283,   -411}, 0, {  -932,     -6}, {0x36, 0x36, 0x23, 0xff}}},
    {{{   720,    506,   -257}, 0, { -1956,   -926}, {0x36, 0x36, 0x23, 0xff}}},
    {{{   720,    384,   -470}, 0, { -1956,   -926}, {0x36, 0x36, 0x23, 0xff}}},
};

// 0x070034A0 - 0x07003500
static const Vtx intro_seg7_vertex_070034A0[] = {
    {{{   729,    405,   -199}, 0, {  -932,     -6}, {0x36, 0x36, 0x23, 0xff}}},
    {{{   720,    455,   -228}, 0, { -1480,   -460}, {0x36, 0x36, 0x23, 0xff}}},
    {{{   720,    333,   -440}, 0, { -1480,   -460}, {0x36, 0x36, 0x23, 0xff}}},
    {{{   729,    283,   -411}, 0, {  -932,     -6}, {0x36, 0x36, 0x23, 0xff}}},
    {{{   720,    506,   -257}, 0, { -1956,   -926}, {0x36, 0x36, 0x23, 0xff}}},
    {{{   720,    384,   -470}, 0, { -1956,   -926}, {0x36, 0x36, 0x23, 0xff}}},
};

// 0x07003500 - 0x070035F0
static const Vtx intro_seg7_vertex_07003500[] = {
    {{{   605,    208,   -143}, 0, {  3156,  -2910}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   453,     27,   -276}, 0, {  2904,  -2404}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   453,    130,    -98}, 0, {  2904,  -2404}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   474,    139,    -56}, 0, {  2968,  -2396}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   610,    209,    -97}, 0, {  3194,  -2850}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   478,    -93,     77}, 0, {  3290,  -1594}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   458,   -121,     46}, 0, {  3254,  -1534}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   458,   -224,   -130}, 0, {  3254,  -1534}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   605,    105,   -321}, 0, {  3156,  -2910}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   604,   -359,    -52}, 0, {  3780,  -1290}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   604,   -257,    124}, 0, {  3780,  -1290}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   952,   -190,     86}, 0, {  4510,  -2064}, {0xd1, 0xd1, 0xd1, 0xff}}},
    {{{  1016,    -32,   -241}, 0, {  4308,  -3068}, {0xd1, 0xd1, 0xd1, 0xff}}},
    {{{  1016,     69,    -63}, 0, {  4308,  -3068}, {0xd1, 0xd1, 0xd1, 0xff}}},
    {{{   952,   -293,    -90}, 0, {  4510,  -2064}, {0xd1, 0xd1, 0xd1, 0xff}}},
};

// 0x070035F0 - 0x070036D0
static const Vtx intro_seg7_vertex_070035F0[] = {
    {{{  1016,     69,    -63}, 0, {  4308,  -3068}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   992,     81,    -23}, 0, {  4266,  -3002}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   935,   -153,    112}, 0, {  4448,  -2096}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   952,   -190,     86}, 0, {  4510,  -2064}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   610,   -215,    148}, 0, {  3766,  -1374}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   604,   -257,    124}, 0, {  3780,  -1290}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   604,   -257,    124}, 0, {  3780,  -1290}, {0xb0, 0xb0, 0xb0, 0xff}}},
    {{{   952,   -293,    -90}, 0, {  4510,  -2064}, {0xb0, 0xb0, 0xb0, 0xff}}},
    {{{   952,   -190,     86}, 0, {  4510,  -2064}, {0xb0, 0xb0, 0xb0, 0xff}}},
    {{{   604,   -359,    -52}, 0, {  3780,  -1290}, {0xb0, 0xb0, 0xb0, 0xff}}},
    {{{  1016,     69,    -63}, 0, {  4308,  -3068}, {0x5e, 0x5e, 0x5e, 0xff}}},
    {{{   802,    106,   -321}, 0, {  3618,  -3222}, {0x5e, 0x5e, 0x5e, 0xff}}},
    {{{   802,    208,   -144}, 0, {  3618,  -3222}, {0x5e, 0x5e, 0x5e, 0xff}}},
    {{{  1016,    -32,   -241}, 0, {  4308,  -3068}, {0x5e, 0x5e, 0x5e, 0xff}}},
};

// 0x070036D0 - 0x070037D0
static const Vtx intro_seg7_vertex_070036D0[] = {
    {{{   740,    -40,      0}, 0, {  3808,  -2258}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   683,   -152,   -172}, 0, {  3686,  -2136}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   683,    -49,      4}, 0, {  3686,  -2136}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   802,    208,   -144}, 0, {  3618,  -3222}, {0xbb, 0xbb, 0xbb, 0xff}}},
    {{{   992,     81,    -23}, 0, {  4266,  -3002}, {0xbb, 0xbb, 0xbb, 0xff}}},
    {{{  1016,     69,    -63}, 0, {  4308,  -3068}, {0xbb, 0xbb, 0xbb, 0xff}}},
    {{{   796,    209,    -97}, 0, {  3630,  -3144}, {0xbb, 0xbb, 0xbb, 0xff}}},
    {{{   756,    -16,    -13}, 0, {  3814,  -2364}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   740,   -142,   -177}, 0, {  3808,  -2258}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   756,   -119,   -191}, 0, {  3814,  -2364}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   752,    -37,     45}, 0, {  3860,  -2216}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   783,      8,     18}, 0, {  3872,  -2424}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   701,     22,    -36}, 0, {  3630,  -2414}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   683,    -49,      4}, 0, {  3686,  -2136}, {0x9a, 0x9a, 0x9a, 0xff}}},
    {{{   662,   -111,   -195}, 0, {  3582,  -2244}, {0x9a, 0x9a, 0x9a, 0xff}}},
    {{{   662,     -9,    -18}, 0, {  3582,  -2244}, {0x9a, 0x9a, 0x9a, 0xff}}},
};

// 0x070037D0 - 0x070038B0
static const Vtx intro_seg7_vertex_070037D0[] = {
    {{{   701,     22,    -36}, 0, {  3630,  -2414}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   701,    -80,   -214}, 0, {  3630,  -2414}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   756,   -119,   -191}, 0, {  3814,  -2364}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   683,    -49,      4}, 0, {  3686,  -2136}, {0x60, 0x60, 0x60, 0xff}}},
    {{{   671,    -50,     52}, 0, {  3688,  -2042}, {0x60, 0x60, 0x60, 0xff}}},
    {{{   740,    -40,      0}, 0, {  3808,  -2258}, {0x60, 0x60, 0x60, 0xff}}},
    {{{   752,    -37,     45}, 0, {  3860,  -2216}, {0x60, 0x60, 0x60, 0xff}}},
    {{{   756,    -16,    -13}, 0, {  3814,  -2364}, {0x9a, 0x9a, 0x9a, 0xff}}},
    {{{   783,      8,     18}, 0, {  3872,  -2424}, {0x9a, 0x9a, 0x9a, 0xff}}},
    {{{   700,     67,    -15}, 0, {  3596,  -2500}, {0x9a, 0x9a, 0x9a, 0xff}}},
    {{{   701,     22,    -36}, 0, {  3630,  -2414}, {0x9a, 0x9a, 0x9a, 0xff}}},
    {{{   683,    -49,      4}, 0, {  3686,  -2136}, {0x9a, 0x9a, 0x9a, 0xff}}},
    {{{   683,   -152,   -172}, 0, {  3686,  -2136}, {0x9a, 0x9a, 0x9a, 0xff}}},
    {{{   662,   -111,   -195}, 0, {  3582,  -2244}, {0x9a, 0x9a, 0x9a, 0xff}}},
};

// 0x070038B0 - 0x070039A0
static const Vtx intro_seg7_vertex_070038B0[] = {
    {{{   802,    208,   -144}, 0, {  3618,  -3222}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   605,    105,   -321}, 0, {  3156,  -2910}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   605,    208,   -143}, 0, {  3156,  -2910}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   662,     -9,    -18}, 0, {  3582,  -2244}, {0xd1, 0xd1, 0xd1, 0xff}}},
    {{{   662,   -111,   -195}, 0, {  3582,  -2244}, {0xd1, 0xd1, 0xd1, 0xff}}},
    {{{   701,    -80,   -214}, 0, {  3630,  -2414}, {0xd1, 0xd1, 0xd1, 0xff}}},
    {{{   701,     22,    -36}, 0, {  3630,  -2414}, {0xd1, 0xd1, 0xd1, 0xff}}},
    {{{   662,     -9,    -18}, 0, {  3582,  -2244}, {0xf0, 0xf0, 0xf0, 0xff}}},
    {{{   671,    -50,     52}, 0, {  3688,  -2042}, {0xf0, 0xf0, 0xf0, 0xff}}},
    {{{   683,    -49,      4}, 0, {  3686,  -2136}, {0xf0, 0xf0, 0xf0, 0xff}}},
    {{{   636,     16,     14}, 0, {  3516,  -2222}, {0xf0, 0xf0, 0xf0, 0xff}}},
    {{{   701,     22,    -36}, 0, {  3630,  -2414}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   700,     67,    -15}, 0, {  3596,  -2500}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   662,     -9,    -18}, 0, {  3582,  -2244}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   636,     16,     14}, 0, {  3516,  -2222}, {0xff, 0xff, 0xfe, 0xff}}},
};

// 0x070039A0 - 0x07003A90
static const Vtx intro_seg7_vertex_070039A0[] = {
    {{{   458,    335,   -204}, 0, {  2700,  -3130}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   243,    232,   -382}, 0, {  2196,  -2796}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   243,    335,   -204}, 0, {  2196,  -2796}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   802,    208,   -144}, 0, {  3618,  -3222}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   802,    106,   -321}, 0, {  3618,  -3222}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   605,    105,   -321}, 0, {  3156,  -2910}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   604,   -257,    124}, 0, {  3780,  -1290}, {0x8d, 0x8d, 0x8d, 0xff}}},
    {{{   610,   -215,    148}, 0, {  3766,  -1374}, {0x8d, 0x8d, 0x8d, 0xff}}},
    {{{   478,    -93,     77}, 0, {  3290,  -1594}, {0x8d, 0x8d, 0x8d, 0xff}}},
    {{{   458,   -121,     46}, 0, {  3254,  -1534}, {0x8d, 0x8d, 0x8d, 0xff}}},
    {{{   610,    209,    -97}, 0, {  3194,  -2850}, {0x73, 0x73, 0x73, 0xff}}},
    {{{   796,    209,    -97}, 0, {  3630,  -3144}, {0x73, 0x73, 0x73, 0xff}}},
    {{{   802,    208,   -144}, 0, {  3618,  -3222}, {0x73, 0x73, 0x73, 0xff}}},
    {{{   605,    208,   -143}, 0, {  3156,  -2910}, {0x73, 0x73, 0x73, 0xff}}},
    {{{   458,    232,   -382}, 0, {  2700,  -3130}, {0x4a, 0x4a, 0x4a, 0xff}}},
};

// 0x07003A90 - 0x07003B90
static const Vtx intro_seg7_vertex_07003A90[] = {
    {{{   496,   -198,    151}, 0, {  3536,  -1264}, {0xf0, 0xf0, 0xf0, 0xff}}},
    {{{   256,   -197,    150}, 0, {  2972,   -892}, {0xf0, 0xf0, 0xf0, 0xff}}},
    {{{   517,   -238,    126}, 0, {  3610,  -1228}, {0xf0, 0xf0, 0xf0, 0xff}}},
    {{{   243,    232,   -382}, 0, {  2196,  -2796}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   236,   -340,    -51}, 0, {  2948,   -792}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   243,    335,   -204}, 0, {  2196,  -2796}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   236,   -237,    126}, 0, {  2948,   -792}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   263,    335,   -157}, 0, {  2270,  -2758}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   256,   -197,    150}, 0, {  2972,   -892}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   517,   -341,    -51}, 0, {  3610,  -1228}, {0x95, 0x95, 0x95, 0xff}}},
    {{{   236,   -237,    126}, 0, {  2948,   -792}, {0x95, 0x95, 0x95, 0xff}}},
    {{{   236,   -340,    -51}, 0, {  2948,   -792}, {0x95, 0x95, 0x95, 0xff}}},
    {{{   517,   -238,    126}, 0, {  3610,  -1228}, {0x95, 0x95, 0x95, 0xff}}},
    {{{   437,    336,   -157}, 0, {  2678,  -3032}, {0x73, 0x73, 0x73, 0xff}}},
    {{{   243,    335,   -204}, 0, {  2196,  -2794}, {0x73, 0x73, 0x73, 0xff}}},
    {{{   263,    335,   -157}, 0, {  2270,  -2758}, {0x73, 0x73, 0x73, 0xff}}},
};

// 0x07003B90 - 0x07003C70
static const Vtx intro_seg7_vertex_07003B90[] = {
    {{{   256,   -197,    150}, 0, {  2972,   -892}, {0xf0, 0xf0, 0xf0, 0xff}}},
    {{{   236,   -237,    126}, 0, {  2948,   -792}, {0xf0, 0xf0, 0xf0, 0xff}}},
    {{{   517,   -238,    126}, 0, {  3610,  -1228}, {0xf0, 0xf0, 0xf0, 0xff}}},
    {{{   517,   -238,    126}, 0, {  3610,  -1228}, {0xc0, 0xc0, 0xc0, 0xff}}},
    {{{   458,    232,   -382}, 0, {  2700,  -3130}, {0xc0, 0xc0, 0xc0, 0xff}}},
    {{{   458,    335,   -204}, 0, {  2700,  -3130}, {0xc0, 0xc0, 0xc0, 0xff}}},
    {{{   517,   -341,    -51}, 0, {  3610,  -1228}, {0xc0, 0xc0, 0xc0, 0xff}}},
    {{{   496,   -198,    151}, 0, {  3536,  -1264}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   517,   -238,    126}, 0, {  3610,  -1228}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   458,    335,   -204}, 0, {  2700,  -3130}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   437,    336,   -157}, 0, {  2678,  -3032}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   437,    336,   -157}, 0, {  2678,  -3032}, {0x73, 0x73, 0x73, 0xff}}},
    {{{   458,    335,   -204}, 0, {  2700,  -3130}, {0x73, 0x73, 0x73, 0xff}}},
    {{{   243,    335,   -204}, 0, {  2196,  -2794}, {0x73, 0x73, 0x73, 0xff}}},
};

// 0x07003C70 - 0x07003D60
static const Vtx intro_seg7_vertex_07003C70[] = {
    {{{     0,   -143,     79}, 0, {  2272,   -742}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   119,   -353,    -44}, 0, {  2692,   -566}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   119,   -247,    139}, 0, {  2692,   -566}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   119,   -247,    139}, 0, {  2692,   -566}, {0xd1, 0xd1, 0xd1, 0xff}}},
    {{{   119,   -353,    -44}, 0, {  2692,   -566}, {0xd1, 0xd1, 0xd1, 0xff}}},
    {{{   331,   -204,   -130}, 0, {  2990,  -1412}, {0xd1, 0xd1, 0xd1, 0xff}}},
    {{{   331,    -98,     53}, 0, {  2990,  -1412}, {0xd1, 0xd1, 0xd1, 0xff}}},
    {{{   331,    -98,     53}, 0, {  2990,  -1412}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   120,   -201,    160}, 0, {  2660,   -656}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   119,   -247,    139}, 0, {  2692,   -566}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   295,    -78,     89}, 0, {  2908,  -1356}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   331,    -98,     53}, 0, {  2990,  -1412}, {0x5e, 0x5e, 0x5e, 0xff}}},
    {{{   180,   -105,   -187}, 0, {  2502,  -1524}, {0x5e, 0x5e, 0x5e, 0xff}}},
    {{{   180,      0,     -4}, 0, {  2502,  -1524}, {0x5e, 0x5e, 0x5e, 0xff}}},
    {{{   331,   -204,   -130}, 0, {  2990,  -1412}, {0x5e, 0x5e, 0x5e, 0xff}}},
};

// 0x07003D60 - 0x07003E50
static const Vtx intro_seg7_vertex_07003D60[] = {
    {{{    -2,   -208,    116}, 0, {  2354,   -510}, {0xcc, 0xcc, 0xcc, 0xff}}},
    {{{     0,   -249,   -104}, 0, {  2272,   -742}, {0xcc, 0xcc, 0xcc, 0xff}}},
    {{{     0,   -143,     79}, 0, {  2272,   -742}, {0xcc, 0xcc, 0xcc, 0xff}}},
    {{{     0,   -143,     79}, 0, {  2272,   -742}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{     0,   -249,   -104}, 0, {  2272,   -742}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   119,   -353,    -44}, 0, {  2692,   -566}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   180,      0,     -4}, 0, {  2502,  -1524}, {0xbb, 0xbb, 0xbb, 0xff}}},
    {{{   142,     22,     30}, 0, {  2412,  -1468}, {0xbb, 0xbb, 0xbb, 0xff}}},
    {{{   295,    -78,     89}, 0, {  2908,  -1356}, {0xbb, 0xbb, 0xbb, 0xff}}},
    {{{   331,    -98,     53}, 0, {  2990,  -1412}, {0xbb, 0xbb, 0xbb, 0xff}}},
    {{{   180,      0,     -4}, 0, {  2502,  -1524}, {0xcc, 0xcc, 0xcc, 0xff}}},
    {{{   250,    -64,   -211}, 0, {  2612,  -1778}, {0xcc, 0xcc, 0xcc, 0xff}}},
    {{{   250,     41,    -27}, 0, {  2612,  -1778}, {0xcc, 0xcc, 0xcc, 0xff}}},
    {{{   180,   -105,   -187}, 0, {  2502,  -1524}, {0xcc, 0xcc, 0xcc, 0xff}}},
    {{{    -2,   -314,    -66}, 0, {  2354,   -510}, {0xcc, 0xcc, 0xcc, 0xff}}},
};

// 0x07003E50 - 0x07003F40
static const Vtx intro_seg7_vertex_07003E50[] = {
    {{{   246,    263,   -155}, 0, {  2304,  -2542}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   230,     73,      1}, 0, {  2548,  -1782}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   250,     41,    -27}, 0, {  2612,  -1778}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   119,   -247,    139}, 0, {  2692,   -566}, {0xa7, 0x91, 0x7b, 0xff}}},
    {{{   120,   -201,    160}, 0, {  2660,   -656}, {0xa7, 0x91, 0x7b, 0xff}}},
    {{{     0,   -143,     79}, 0, {  2272,   -742}, {0xa7, 0x91, 0x7b, 0xff}}},
    {{{   -19,    -79,     89}, 0, {  2168,   -862}, {0xa7, 0x91, 0x7b, 0xff}}},
    {{{  -241,   -216,    121}, 0, {  1804,   -110}, {0x9a, 0x9a, 0x9a, 0xff}}},
    {{{  -241,   -322,    -62}, 0, {  1804,   -110}, {0x9a, 0x9a, 0x9a, 0xff}}},
    {{{    -2,   -314,    -66}, 0, {  2354,   -510}, {0x9a, 0x9a, 0x9a, 0xff}}},
    {{{    -2,   -208,    116}, 0, {  2354,   -510}, {0x9a, 0x9a, 0x9a, 0xff}}},
    {{{   250,     41,    -27}, 0, {  2612,  -1778}, {0xc2, 0xc2, 0xc2, 0xff}}},
    {{{   250,    -64,   -211}, 0, {  2612,  -1778}, {0xc2, 0xc2, 0xc2, 0xff}}},
    {{{   246,    157,   -339}, 0, {  2304,  -2542}, {0xcc, 0xcc, 0xcc, 0xff}}},
    {{{   246,    263,   -155}, 0, {  2304,  -2542}, {0xc2, 0xc2, 0xc2, 0xff}}},
};

// 0x07003F40 - 0x07004020
static const Vtx intro_seg7_vertex_07003F40[] = {
    {{{    -2,   -208,    116}, 0, {  2354,   -510}, {0xf0, 0xf0, 0xf0, 0xff}}},
    {{{   -22,   -169,    141}, 0, {  2282,   -544}, {0xf0, 0xf0, 0xf0, 0xff}}},
    {{{  -220,   -176,    145}, 0, {  1824,   -212}, {0xf0, 0xf0, 0xf0, 0xff}}},
    {{{   246,    263,   -155}, 0, {  2304,  -2542}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   226,    271,   -113}, 0, {  2272,  -2466}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   230,     73,      1}, 0, {  2548,  -1782}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   142,     22,     30}, 0, {  2412,  -1468}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   180,      0,     -4}, 0, {  2502,  -1524}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   250,     41,    -27}, 0, {  2612,  -1778}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{     0,   -143,     79}, 0, {  2272,   -742}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   -19,    -79,     89}, 0, {  2168,   -862}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{    -2,   -208,    116}, 0, {  2354,   -510}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   -22,   -169,    141}, 0, {  2282,   -544}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -241,   -216,    121}, 0, {  1804,   -110}, {0xf0, 0xf0, 0xf0, 0xff}}},
};

// 0x07004020 - 0x07004120
static const Vtx intro_seg7_vertex_07004020[] = {
    {{{    -3,    162,    -97}, 0, {  1852,  -1800}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{    -3,     56,   -281}, 0, {  1852,  -1800}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{    36,     26,   -263}, 0, {  1986,  -1760}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   246,    263,   -155}, 0, {  2304,  -2542}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   246,    157,   -339}, 0, {  2304,  -2542}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{    17,    255,   -396}, 0, {  1632,  -2526}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{    17,    361,   -212}, 0, {  1632,  -2526}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -238,    255,   -395}, 0, {  1032,  -2124}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -238,    361,   -212}, 0, {  1032,  -2124}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{    36,    132,    -80}, 0, {  1986,  -1760}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{    -3,     -7,   -244}, 0, {  1936,  -1578}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{    -3,     98,    -60}, 0, {  1936,  -1578}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{    68,    154,    -45}, 0, {  2060,  -1814}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{    36,    132,    -80}, 0, {  1986,  -1760}, {0x9a, 0x9a, 0x9a, 0xff}}},
    {{{    68,    154,    -45}, 0, {  2060,  -1814}, {0x9a, 0x9a, 0x9a, 0xff}}},
    {{{   -23,    222,    -84}, 0, {  1752,  -1908}, {0x9a, 0x9a, 0x9a, 0xff}}},
};

// 0x07004120 - 0x07004200
static const Vtx intro_seg7_vertex_07004120[] = {
    {{{    -3,     98,    -60}, 0, {  1936,  -1578}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   -24,     75,      0}, 0, {  1946,  -1394}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{    68,    154,    -45}, 0, {  2060,  -1814}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{    -3,     -7,   -244}, 0, {  1936,  -1578}, {0xcc, 0xcc, 0xcc, 0xff}}},
    {{{    -3,     56,   -281}, 0, {  1852,  -1800}, {0xcc, 0xcc, 0xcc, 0xff}}},
    {{{    -3,    162,    -97}, 0, {  1852,  -1800}, {0xcc, 0xcc, 0xcc, 0xff}}},
    {{{    -3,     98,    -60}, 0, {  1936,  -1578}, {0xcc, 0xcc, 0xcc, 0xff}}},
    {{{    17,    361,   -212}, 0, {  1632,  -2526}, {0xa7, 0xa7, 0xa7, 0xff}}},
    {{{   226,    271,   -113}, 0, {  2272,  -2466}, {0xa7, 0xa7, 0xa7, 0xff}}},
    {{{   246,    263,   -155}, 0, {  2304,  -2542}, {0xa7, 0xa7, 0xa7, 0xff}}},
    {{{    12,    362,   -165}, 0, {  1648,  -2452}, {0xa7, 0xa7, 0xa7, 0xff}}},
    {{{    36,    132,    -80}, 0, {  1986,  -1760}, {0x9a, 0x9a, 0x9a, 0xff}}},
    {{{   -23,    222,    -84}, 0, {  1752,  -1908}, {0x9a, 0x9a, 0x9a, 0xff}}},
    {{{    -3,    162,    -97}, 0, {  1852,  -1800}, {0x9a, 0x9a, 0x9a, 0xff}}},
};

// 0x07004200 - 0x070042E0
static const Vtx intro_seg7_vertex_07004200[] = {
    {{{    -3,    162,    -97}, 0, {  1852,  -1800}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   -23,    222,    -84}, 0, {  1752,  -1908}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{    -3,     98,    -60}, 0, {  1936,  -1578}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   -24,     75,      0}, 0, {  1946,  -1394}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -238,    361,   -212}, 0, {  1032,  -2124}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -238,    255,   -395}, 0, {  1032,  -2124}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -241,   -322,    -62}, 0, {  1804,   -110}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -241,   -216,    121}, 0, {  1804,   -110}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -218,    362,   -165}, 0, {  1106,  -2088}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -220,   -176,    145}, 0, {  1824,   -212}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -238,    361,   -212}, 0, {  1032,  -2124}, {0x73, 0x73, 0x73, 0xff}}},
    {{{    12,    362,   -165}, 0, {  1648,  -2452}, {0x73, 0x73, 0x73, 0xff}}},
    {{{    17,    361,   -212}, 0, {  1632,  -2526}, {0x73, 0x73, 0x73, 0xff}}},
    {{{  -218,    362,   -165}, 0, {  1106,  -2088}, {0x73, 0x73, 0x73, 0xff}}},
};

// 0x070042E0 - 0x070043E0
static const Vtx intro_seg7_vertex_070042E0[] = {
    {{{  -416,   -142,    108}, 0, {  1308,    -50}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -407,   -341,    -50}, 0, {  1438,    216}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -407,   -223,    154}, 0, {  1438,    216}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -407,   -223,    154}, 0, {  1438,    216}, {0x95, 0x95, 0x95, 0xff}}},
    {{{  -104,   -342,    -50}, 0, {  2150,   -254}, {0x95, 0x95, 0x95, 0xff}}},
    {{{  -104,   -223,    155}, 0, {  2150,   -254}, {0x95, 0x95, 0x95, 0xff}}},
    {{{  -407,   -341,    -50}, 0, {  1438,    216}, {0x95, 0x95, 0x95, 0xff}}},
    {{{  -104,   -223,    155}, 0, {  2150,   -254}, {0xf0, 0xf0, 0xf0, 0xff}}},
    {{{  -134,   -183,    179}, 0, {  2054,   -274}, {0xf0, 0xf0, 0xf0, 0xff}}},
    {{{  -388,   -183,    179}, 0, {  1456,    120}, {0xf0, 0xf0, 0xf0, 0xff}}},
    {{{  -407,   -223,    154}, 0, {  1438,    216}, {0xf0, 0xf0, 0xf0, 0xff}}},
    {{{  -397,   -107,    135}, 0, {  1332,   -130}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -416,   -261,    -97}, 0, {  1308,    -50}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -568,    -94,     80}, 0, {   888,     20}, {0x68, 0x68, 0x68, 0xff}}},
    {{{  -416,   -261,    -97}, 0, {  1308,    -50}, {0x68, 0x68, 0x68, 0xff}}},
    {{{  -416,   -142,    108}, 0, {  1308,    -50}, {0x68, 0x68, 0x68, 0xff}}},
};

// 0x070043E0 - 0x070044C0
static const Vtx intro_seg7_vertex_070043E0[] = {
    {{{  -407,   -223,    154}, 0, {  1438,    216}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -388,   -183,    179}, 0, {  1456,    120}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -397,   -107,    135}, 0, {  1332,   -130}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -894,    -81,     72}, 0, {   102,    482}, {0x66, 0x66, 0x66, 0xff}}},
    {{{  -646,   -285,    -83}, 0, {   800,    392}, {0x66, 0x66, 0x66, 0xff}}},
    {{{  -646,   -167,    122}, 0, {   800,    392}, {0x66, 0x66, 0x66, 0xff}}},
    {{{  -894,   -200,   -132}, 0, {   102,    482}, {0x66, 0x66, 0x66, 0xff}}},
    {{{  -646,   -167,    122}, 0, {   800,    392}, {0xd1, 0xd1, 0xd1, 0xff}}},
    {{{  -646,   -285,    -83}, 0, {   800,    392}, {0xd1, 0xd1, 0xd1, 0xff}}},
    {{{  -568,   -213,   -124}, 0, {   888,     20}, {0xd1, 0xd1, 0xd1, 0xff}}},
    {{{  -568,    -94,     80}, 0, {   888,     20}, {0xd1, 0xd1, 0xd1, 0xff}}},
    {{{  -568,    -94,     80}, 0, {   888,     20}, {0x68, 0x68, 0x68, 0xff}}},
    {{{  -568,   -213,   -124}, 0, {   888,     20}, {0x68, 0x68, 0x68, 0xff}}},
    {{{  -416,   -261,    -97}, 0, {  1308,    -50}, {0x68, 0x68, 0x68, 0xff}}},
};

// 0x070044C0 - 0x070045B0
static const Vtx intro_seg7_vertex_070044C0[] = {
    {{{  -104,   -223,    155}, 0, {  2150,   -254}, {0xa4, 0xa4, 0xa4, 0xff}}},
    {{{  -104,   -342,    -50}, 0, {  2150,   -254}, {0xa4, 0xa4, 0xa4, 0xff}}},
    {{{  -324,    196,   -361}, 0, {   908,  -1788}, {0xa4, 0xa4, 0xa4, 0xff}}},
    {{{  -646,   -167,    122}, 0, {   800,    392}, {0xcc, 0xcc, 0xcc, 0xff}}},
    {{{  -651,   -124,    144}, 0, {   758,    322}, {0xcc, 0xcc, 0xcc, 0xff}}},
    {{{  -894,    -81,     72}, 0, {   102,    482}, {0xcc, 0xcc, 0xcc, 0xff}}},
    {{{  -861,    -51,    103}, 0, {   166,    398}, {0xcc, 0xcc, 0xcc, 0xff}}},
    {{{  -573,    -52,    103}, 0, {   844,    -48}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -651,   -124,    144}, 0, {   758,    322}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -646,   -167,    122}, 0, {   800,    392}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -568,    -94,     80}, 0, {   888,     20}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -416,   -142,    108}, 0, {  1308,    -50}, {0xcc, 0xcc, 0xcc, 0xff}}},
    {{{  -573,    -52,    103}, 0, {   844,    -48}, {0xcc, 0xcc, 0xcc, 0xff}}},
    {{{  -568,    -94,     80}, 0, {   888,     20}, {0xcc, 0xcc, 0xcc, 0xff}}},
    {{{  -397,   -107,    135}, 0, {  1332,   -130}, {0xcc, 0xcc, 0xcc, 0xff}}},
};

// 0x070045B0 - 0x070046B0
static const Vtx intro_seg7_vertex_070045B0[] = {
    {{{  -466,    127,    -47}, 0, {   826,   -912}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -466,      9,   -253}, 0, {   826,   -912}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -449,    -59,   -214}, 0, {   960,   -704}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -104,   -223,    155}, 0, {  2150,   -254}, {0xa4, 0xa4, 0xa4, 0xff}}},
    {{{  -324,    196,   -361}, 0, {   908,  -1788}, {0xa4, 0xa4, 0xa4, 0xff}}},
    {{{  -324,    315,   -156}, 0, {   908,  -1788}, {0xa4, 0xa4, 0xa4, 0xff}}},
    {{{  -324,    315,   -156}, 0, {   908,  -1788}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -134,   -183,    179}, 0, {  2054,   -274}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -104,   -223,    155}, 0, {  2150,   -254}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -339,    318,   -110}, 0, {   896,  -1704}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -449,     59,     -8}, 0, {   960,   -704}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -505,    -41,   -224}, 0, {   804,   -678}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -505,     77,    -18}, 0, {   804,   -676}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -537,     87,     22}, 0, {   740,   -590}, {0x99, 0x99, 0x99, 0xff}}},
    {{{  -420,     50,     43}, 0, {  1066,   -646}, {0x99, 0x99, 0x99, 0xff}}},
    {{{  -449,     59,     -8}, 0, {   960,   -704}, {0x99, 0x99, 0x99, 0xff}}},
};

// 0x070046B0 - 0x070047A0
static const Vtx intro_seg7_vertex_070046B0[] = {
    {{{  -324,    315,   -156}, 0, {   908,  -1788}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -544,    238,   -386}, 0, {   334,  -1590}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -544,    357,   -180}, 0, {   334,  -1590}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -894,    -81,     72}, 0, {   102,    482}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -536,    356,   -132}, 0, {   384,  -1528}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -894,   -200,   -132}, 0, {   102,    482}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -324,    196,   -361}, 0, {   908,  -1788}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -861,    -51,    103}, 0, {   166,    398}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -505,     77,    -18}, 0, {   804,   -676}, {0xdd, 0xdd, 0xdd, 0xff}}},
    {{{  -466,      9,   -253}, 0, {   826,   -912}, {0xdd, 0xdd, 0xdd, 0xff}}},
    {{{  -466,    127,    -47}, 0, {   826,   -912}, {0xdd, 0xdd, 0xdd, 0xff}}},
    {{{  -505,    -41,   -224}, 0, {   804,   -678}, {0xdd, 0xdd, 0xdd, 0xff}}},
    {{{  -536,    356,   -132}, 0, {   384,  -1528}, {0x8b, 0x8b, 0x8b, 0xff}}},
    {{{  -339,    318,   -110}, 0, {   896,  -1704}, {0x8b, 0x8b, 0x8b, 0xff}}},
    {{{  -324,    315,   -156}, 0, {   908,  -1788}, {0x8b, 0x8b, 0x8b, 0xff}}},
};

// 0x070047A0 - 0x07004880
static const Vtx intro_seg7_vertex_070047A0[] = {
    {{{  -505,     77,    -18}, 0, {   804,   -676}, {0x99, 0x99, 0x99, 0xff}}},
    {{{  -537,     87,     22}, 0, {   740,   -590}, {0x99, 0x99, 0x99, 0xff}}},
    {{{  -449,     59,     -8}, 0, {   960,   -704}, {0x99, 0x99, 0x99, 0xff}}},
    {{{  -449,     59,     -8}, 0, {   960,   -704}, {0x50, 0x50, 0x50, 0xff}}},
    {{{  -457,    194,    -38}, 0, {   786,  -1086}, {0x50, 0x50, 0x50, 0xff}}},
    {{{  -466,    127,    -47}, 0, {   826,   -912}, {0x50, 0x50, 0x50, 0xff}}},
    {{{  -420,     50,     43}, 0, {  1066,   -646}, {0x50, 0x50, 0x50, 0xff}}},
    {{{  -466,    127,    -47}, 0, {   826,   -912}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -537,     87,     22}, 0, {   740,   -590}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -505,     77,    -18}, 0, {   804,   -676}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -457,    194,    -38}, 0, {   786,  -1086}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -544,    357,   -180}, 0, {   334,  -1590}, {0x8b, 0x8b, 0x8b, 0xff}}},
    {{{  -536,    356,   -132}, 0, {   384,  -1528}, {0x8b, 0x8b, 0x8b, 0xff}}},
    {{{  -324,    315,   -156}, 0, {   908,  -1788}, {0x8b, 0x8b, 0x8b, 0xff}}},
};

// 0x07004880 - 0x07004970
static const Vtx intro_seg7_vertex_07004880[] = {
    {{{  -757,   -165,    198}, 0, {   584,    676}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -776,   -214,    179}, 0, {   576,    806}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -540,    -80,    149}, 0, {   980,     42}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -776,   -214,    179}, 0, {   576,    806}, {0xc0, 0xc0, 0xc0, 0xff}}},
    {{{  -776,   -346,    -48}, 0, {   576,    806}, {0xc0, 0xc0, 0xc0, 0xff}}},
    {{{  -514,   -243,   -107}, 0, {  1054,     40}, {0xc0, 0xc0, 0xc0, 0xff}}},
    {{{  -514,   -112,    120}, 0, {  1054,     40}, {0xc0, 0xc0, 0xc0, 0xff}}},
    {{{  -782,    -30,     73}, 0, {   314,    174}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -782,   -161,   -154}, 0, {   314,    174}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -776,   -346,    -48}, 0, {   576,    806}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -776,   -214,    179}, 0, {   576,    806}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -757,   -165,    198}, 0, {   584,    676}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -762,     -2,    104}, 0, {   350,    116}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -844,     40,     32}, 0, {    72,     26}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -844,    -91,   -195}, 0, {    72,     26}, {0x4a, 0x4a, 0x4a, 0xff}}},
};

// 0x07004970 - 0x07004A60
static const Vtx intro_seg7_vertex_07004970[] = {
    {{{  -900,    393,   -171}, 0, {  -530,  -1118}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -900,    261,   -399}, 0, {  -530,  -1118}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -938,    184,   -355}, 0, {  -518,   -790}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -776,   -214,    179}, 0, {   576,    806}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -514,   -112,    120}, 0, {  1054,     40}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -540,    -80,    149}, 0, {   980,     42}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -685,    339,   -140}, 0, {    44,  -1264}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -701,    343,    -95}, 0, {    28,  -1182}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -849,     95,     47}, 0, {    16,    -90}, {0x80, 0x80, 0x80, 0xff}}},
    {{{  -844,     40,     32}, 0, {    72,     26}, {0x80, 0x80, 0x80, 0xff}}},
    {{{  -762,     -2,    104}, 0, {   350,    116}, {0x80, 0x80, 0x80, 0xff}}},
    {{{  -782,    -30,     73}, 0, {   314,    174}, {0x80, 0x80, 0x80, 0xff}}},
    {{{  -685,    339,   -140}, 0, {    44,  -1264}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -888,    390,   -122}, 0, {  -474,  -1056}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -938,    316,   -127}, 0, {  -518,   -790}, {0x4a, 0x4a, 0x4a, 0xff}}},
};

// 0x07004A60 - 0x07004B50
static const Vtx intro_seg7_vertex_07004A60[] = {
    {{{ -1284,   -214,    179}, 0, {  -616,   1592}, {0x95, 0x95, 0x95, 0xff}}},
    {{{ -1284,   -345,    -48}, 0, {  -616,   1592}, {0x95, 0x95, 0x95, 0xff}}},
    {{{  -992,   -344,    -49}, 0, {    66,   1136}, {0x95, 0x95, 0x95, 0xff}}},
    {{{  -685,    339,   -140}, 0, {    44,  -1264}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -685,    207,   -368}, 0, {    44,  -1264}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -900,    261,   -399}, 0, {  -530,  -1118}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -514,   -112,    120}, 0, {  1054,     40}, {0xa7, 0xa7, 0xa7, 0xff}}},
    {{{  -685,    207,   -368}, 0, {    44,  -1264}, {0xa7, 0xa7, 0xa7, 0xff}}},
    {{{  -685,    339,   -140}, 0, {    44,  -1264}, {0xa7, 0xa7, 0xa7, 0xff}}},
    {{{  -514,   -243,   -107}, 0, {  1054,     40}, {0xa7, 0xa7, 0xa7, 0xff}}},
    {{{  -701,    343,    -95}, 0, {    28,  -1182}, {0xa7, 0x91, 0x7b, 0xff}}},
    {{{  -685,    339,   -140}, 0, {    44,  -1264}, {0xa7, 0x91, 0x7b, 0xff}}},
    {{{  -900,    393,   -171}, 0, {  -530,  -1118}, {0xa7, 0x91, 0x7b, 0xff}}},
    {{{  -888,    390,   -122}, 0, {  -474,  -1056}, {0xa7, 0x91, 0x7b, 0xff}}},
    {{{  -992,   -213,    178}, 0, {    66,   1136}, {0x95, 0x95, 0x95, 0xff}}},
};

// 0x07004B50 - 0x07004C40
static const Vtx intro_seg7_vertex_07004B50[] = {
    {{{  -992,   -213,    178}, 0, {    66,   1136}, {0xc0, 0xc0, 0xc0, 0xff}}},
    {{{ -1007,   -161,   -155}, 0, {  -214,    524}, {0xc0, 0xc0, 0xc0, 0xff}}},
    {{{ -1007,    -30,     72}, 0, {  -214,    524}, {0xc0, 0xc0, 0xc0, 0xff}}},
    {{{ -1259,   -174,    203}, 0, {  -584,   1486}, {0xf0, 0xf0, 0xf0, 0xff}}},
    {{{ -1284,   -214,    179}, 0, {  -616,   1592}, {0xf0, 0xf0, 0xf0, 0xff}}},
    {{{ -1015,   -173,    202}, 0, {   -14,   1102}, {0xf0, 0xf0, 0xf0, 0xff}}},
    {{{  -992,   -213,    178}, 0, {    66,   1136}, {0xf0, 0xf0, 0xf0, 0xff}}},
    {{{ -1161,    385,   -167}, 0, { -1134,   -684}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{ -1284,   -345,    -48}, 0, {  -616,   1592}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{ -1284,   -214,    179}, 0, {  -616,   1592}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{ -1161,    254,   -395}, 0, { -1134,   -684}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -963,    386,   -167}, 0, {  -670,   -996}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{ -1259,   -174,    203}, 0, {  -584,   1486}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{ -1144,    386,   -120}, 0, { -1068,   -642}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -963,    254,   -395}, 0, {  -670,   -996}, {0x4a, 0x4a, 0x4a, 0xff}}},
};

// 0x07004C40 - 0x07004D30
static const Vtx intro_seg7_vertex_07004C40[] = {
    {{{  -933,   -127,    128}, 0, {    90,    746}, {0xdd, 0xdd, 0xdd, 0xff}}},
    {{{  -933,   -258,    -98}, 0, {    90,    746}, {0xdd, 0xdd, 0xdd, 0xff}}},
    {{{  -844,    -91,   -195}, 0, {    72,     26}, {0xdd, 0xdd, 0xdd, 0xff}}},
    {{{  -992,   -213,    178}, 0, {    66,   1136}, {0xc0, 0xc0, 0xc0, 0xff}}},
    {{{  -992,   -344,    -49}, 0, {    66,   1136}, {0xc0, 0xc0, 0xc0, 0xff}}},
    {{{ -1007,   -161,   -155}, 0, {  -214,    524}, {0xc0, 0xc0, 0xc0, 0xff}}},
    {{{ -1015,   -173,    202}, 0, {   -14,   1102}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{ -1007,    -30,     72}, 0, {  -214,    524}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{ -1033,     57,     69}, 0, {  -366,    332}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -992,   -213,    178}, 0, {    66,   1136}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{ -1007,    -30,     72}, 0, {  -214,    524}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{ -1007,   -161,   -155}, 0, {  -214,    524}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -933,   -258,    -98}, 0, {    90,    746}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -933,   -127,    128}, 0, {    90,    746}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -844,     40,     32}, 0, {    72,     26}, {0xdd, 0xdd, 0xdd, 0xff}}},
};

// 0x07004D30 - 0x07004E30
static const Vtx intro_seg7_vertex_07004D30[] = {
    {{{  -938,    316,   -127}, 0, {  -518,   -790}, {0xaa, 0xaa, 0xaa, 0xff}}},
    {{{  -963,    254,   -395}, 0, {  -670,   -996}, {0xaa, 0xaa, 0xaa, 0xff}}},
    {{{  -963,    386,   -167}, 0, {  -670,   -996}, {0xaa, 0xaa, 0xaa, 0xff}}},
    {{{ -1033,     57,     69}, 0, {  -366,    332}, {0x88, 0x88, 0x88, 0xff}}},
    {{{  -933,   -127,    128}, 0, {    90,    746}, {0x88, 0x88, 0x88, 0xff}}},
    {{{  -936,    -69,    142}, 0, {    32,    622}, {0x88, 0x88, 0x88, 0xff}}},
    {{{ -1007,    -30,     72}, 0, {  -214,    524}, {0x88, 0x88, 0x88, 0xff}}},
    {{{  -936,    -69,    142}, 0, {    32,    622}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -844,     40,     32}, 0, {    72,     26}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -849,     95,     47}, 0, {    16,    -90}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -933,   -127,    128}, 0, {    90,    746}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -977,    387,   -120}, 0, {  -678,   -904}, {0x73, 0x73, 0x73, 0xff}}},
    {{{ -1161,    385,   -167}, 0, { -1134,   -684}, {0x73, 0x73, 0x73, 0xff}}},
    {{{ -1144,    386,   -120}, 0, { -1068,   -642}, {0x73, 0x73, 0x73, 0xff}}},
    {{{  -963,    386,   -167}, 0, {  -670,   -996}, {0x73, 0x73, 0x73, 0xff}}},
    {{{  -938,    184,   -355}, 0, {  -518,   -790}, {0xaa, 0xaa, 0xaa, 0xff}}},
};

// 0x07004E30 - 0x07004F20
static const Vtx intro_seg7_vertex_07004E30[] = {
    {{{  -888,    390,   -122}, 0, {  -474,  -1056}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -938,    316,   -127}, 0, {  -518,   -790}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -941,    285,    -61}, 0, {  -456,   -604}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -941,    285,    -61}, 0, {  -456,   -604}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -963,    386,   -167}, 0, {  -670,   -996}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -977,    387,   -120}, 0, {  -678,   -904}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -938,    316,   -127}, 0, {  -518,   -790}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   130,    803,   -494}, 0, {  1288,  -4280}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   130,    693,   -684}, 0, {  1288,  -4280}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   173,    243,   -424}, 0, {  1996,  -2780}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   173,    352,   -234}, 0, {  1996,  -2780}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   152,    804,   -447}, 0, {  1368,  -4246}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   192,    393,   -210}, 0, {  2014,  -2878}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   447,    806,   -496}, 0, {  2030,  -4782}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   447,    696,   -685}, 0, {  2030,  -4782}, {0x4a, 0x4a, 0x4a, 0xff}}},
};

// 0x07004F20 - 0x07005010
static const Vtx intro_seg7_vertex_07004F20[] = {
    {{{   344,    596,   -327}, 0, {  2098,  -3820}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   361,    616,   -386}, 0, {  2084,  -3988}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   334,    706,   -391}, 0, {  1926,  -4190}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   358,    644,   -403}, 0, {  2038,  -4084}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   640,    460,   -296}, 0, {  2950,  -3880}, {0x59, 0x59, 0x59, 0xff}}},
    {{{   640,    350,   -486}, 0, {  2950,  -3880}, {0x59, 0x59, 0x59, 0xff}}},
    {{{   532,    419,   -525}, 0, {  2602,  -3950}, {0x59, 0x59, 0x59, 0xff}}},
    {{{   532,    528,   -336}, 0, {  2602,  -3950}, {0x59, 0x59, 0x59, 0xff}}},
    {{{   549,    734,   -454}, 0, {  2366,  -4692}, {0x60, 0x60, 0x60, 0xff}}},
    {{{   447,    696,   -685}, 0, {  2030,  -4782}, {0x60, 0x60, 0x60, 0xff}}},
    {{{   447,    806,   -496}, 0, {  2030,  -4782}, {0x60, 0x60, 0x60, 0xff}}},
    {{{   562,    551,   -349}, 0, {  2642,  -4076}, {0xc0, 0xc0, 0xc0, 0xff}}},
    {{{   549,    625,   -644}, 0, {  2366,  -4692}, {0xc0, 0xc0, 0xc0, 0xff}}},
    {{{   549,    734,   -454}, 0, {  2366,  -4692}, {0xc0, 0xc0, 0xc0, 0xff}}},
    {{{   562,    442,   -539}, 0, {  2642,  -4076}, {0xc0, 0xc0, 0xc0, 0xff}}},
};

// 0x07005010 - 0x07005100
static const Vtx intro_seg7_vertex_07005010[] = {
    {{{   529,    744,   -413}, 0, {  2332,  -4626}, {0xc0, 0xc0, 0xc0, 0xff}}},
    {{{   549,    734,   -454}, 0, {  2366,  -4692}, {0xc0, 0xc0, 0xc0, 0xff}}},
    {{{   447,    806,   -496}, 0, {  2030,  -4782}, {0xc0, 0xc0, 0xc0, 0xff}}},
    {{{   532,    528,   -336}, 0, {  2602,  -3950}, {0xd1, 0xd1, 0xd1, 0xff}}},
    {{{   532,    419,   -525}, 0, {  2602,  -3950}, {0xd1, 0xd1, 0xd1, 0xff}}},
    {{{   562,    442,   -539}, 0, {  2642,  -4076}, {0xd1, 0xd1, 0xd1, 0xff}}},
    {{{   562,    551,   -349}, 0, {  2642,  -4076}, {0xd1, 0xd1, 0xd1, 0xff}}},
    {{{   549,    734,   -454}, 0, {  2366,  -4692}, {0x60, 0x60, 0x60, 0xff}}},
    {{{   549,    625,   -644}, 0, {  2366,  -4692}, {0x60, 0x60, 0x60, 0xff}}},
    {{{   447,    696,   -685}, 0, {  2030,  -4782}, {0x60, 0x60, 0x60, 0xff}}},
    {{{   440,    807,   -449}, 0, {  2042,  -4704}, {0xc0, 0xc0, 0xc0, 0xff}}},
    {{{   604,    480,   -260}, 0, {  2866,  -3822}, {0xbb, 0xbb, 0xbb, 0xff}}},
    {{{   640,    460,   -296}, 0, {  2950,  -3880}, {0xbb, 0xbb, 0xbb, 0xff}}},
    {{{   497,    547,   -299}, 0, {  2522,  -3890}, {0xbb, 0xbb, 0xbb, 0xff}}},
    {{{   532,    528,   -336}, 0, {  2602,  -3950}, {0xbb, 0xbb, 0xbb, 0xff}}},
};

// 0x07005100 - 0x07005200
static const Vtx intro_seg7_vertex_07005100[] = {
    {{{   497,    547,   -299}, 0, {  2522,  -3890}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   562,    551,   -349}, 0, {  2642,  -4076}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   541,    581,   -318}, 0, {  2580,  -4074}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   532,    528,   -336}, 0, {  2602,  -3950}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   549,    734,   -454}, 0, {  2366,  -4692}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   529,    744,   -413}, 0, {  2332,  -4626}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   361,    616,   -386}, 0, {  2084,  -3988}, {0xc0, 0xc0, 0xc0, 0xff}}},
    {{{   361,    506,   -576}, 0, {  2084,  -3988}, {0xc0, 0xc0, 0xc0, 0xff}}},
    {{{   358,    644,   -403}, 0, {  2038,  -4084}, {0xc0, 0xc0, 0xc0, 0xff}}},
    {{{   381,    356,   -236}, 0, {  2480,  -3114}, {0xc2, 0xc2, 0xc2, 0xff}}},
    {{{   379,    298,   -456}, 0, {  2406,  -3294}, {0xcc, 0xcc, 0xcc, 0xff}}},
    {{{   379,    408,   -266}, 0, {  2406,  -3294}, {0xc2, 0xc2, 0xc2, 0xff}}},
    {{{   381,    246,   -426}, 0, {  2480,  -3114}, {0xc2, 0xc2, 0xc2, 0xff}}},
    {{{   358,    644,   -403}, 0, {  2038,  -4084}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   358,    535,   -592}, 0, {  2038,  -4084}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   379,    630,   -394}, 0, {  2106,  -4066}, {0x4a, 0x4a, 0x4a, 0xff}}},
};

// 0x07005200 - 0x07005300
static const Vtx intro_seg7_vertex_07005200[] = {
    {{{   358,    535,   -592}, 0, {  2038,  -4084}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   379,    520,   -584}, 0, {  2106,  -4066}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   379,    630,   -394}, 0, {  2106,  -4066}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   361,    506,   -576}, 0, {  2084,  -3988}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   361,    616,   -386}, 0, {  2084,  -3988}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   344,    596,   -327}, 0, {  2098,  -3820}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   411,    652,   -360}, 0, {  2180,  -4120}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   440,    807,   -449}, 0, {  2042,  -4704}, {0x70, 0x70, 0x70, 0xff}}},
    {{{   130,    803,   -494}, 0, {  1288,  -4280}, {0x70, 0x70, 0x70, 0xff}}},
    {{{   152,    804,   -447}, 0, {  1368,  -4246}, {0x70, 0x70, 0x70, 0xff}}},
    {{{   361,    506,   -576}, 0, {  2084,  -3988}, {0xc0, 0xc0, 0xc0, 0xff}}},
    {{{   358,    535,   -592}, 0, {  2038,  -4084}, {0xc0, 0xc0, 0xc0, 0xff}}},
    {{{   358,    644,   -403}, 0, {  2038,  -4084}, {0xc0, 0xc0, 0xc0, 0xff}}},
    {{{   334,    706,   -391}, 0, {  1926,  -4190}, {0x9a, 0x9a, 0x9a, 0xff}}},
    {{{   358,    644,   -403}, 0, {  2038,  -4084}, {0x9a, 0x9a, 0x9a, 0xff}}},
    {{{   379,    630,   -394}, 0, {  2106,  -4066}, {0x9a, 0x9a, 0x9a, 0xff}}},
};

// 0x07005300 - 0x07005400
static const Vtx intro_seg7_vertex_07005300[] = {
    {{{   334,    706,   -391}, 0, {  1926,  -4190}, {0x9a, 0x9a, 0x9a, 0xff}}},
    {{{   379,    630,   -394}, 0, {  2106,  -4066}, {0x9a, 0x9a, 0x9a, 0xff}}},
    {{{   411,    652,   -360}, 0, {  2180,  -4120}, {0x9a, 0x9a, 0x9a, 0xff}}},
    {{{   360,    395,   -211}, 0, {  2404,  -3148}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   379,    408,   -266}, 0, {  2406,  -3294}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   357,    475,   -258}, 0, {  2292,  -3422}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   381,    356,   -236}, 0, {  2480,  -3114}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   440,    807,   -449}, 0, {  2042,  -4704}, {0x70, 0x70, 0x70, 0xff}}},
    {{{   447,    806,   -496}, 0, {  2030,  -4782}, {0x70, 0x70, 0x70, 0xff}}},
    {{{   130,    803,   -494}, 0, {  1288,  -4280}, {0x70, 0x70, 0x70, 0xff}}},
    {{{   379,    408,   -266}, 0, {  2406,  -3294}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   379,    298,   -456}, 0, {  2406,  -3294}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   459,    226,   -414}, 0, {  2690,  -3166}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   173,    352,   -234}, 0, {  1996,  -2780}, {0x95, 0x95, 0x95, 0xff}}},
    {{{   173,    243,   -424}, 0, {  1996,  -2780}, {0x95, 0x95, 0x95, 0xff}}},
    {{{   381,    246,   -426}, 0, {  2480,  -3114}, {0x99, 0x99, 0x99, 0xff}}},
};

// 0x07005400 - 0x070054E0
static const Vtx intro_seg7_vertex_07005400[] = {
    {{{   173,    352,   -234}, 0, {  1996,  -2780}, {0x95, 0x95, 0x95, 0xff}}},
    {{{   381,    246,   -426}, 0, {  2480,  -3114}, {0x99, 0x99, 0x99, 0xff}}},
    {{{   381,    356,   -236}, 0, {  2480,  -3114}, {0x99, 0x99, 0x99, 0xff}}},
    {{{   173,    352,   -234}, 0, {  1996,  -2780}, {0xf0, 0xf0, 0xf0, 0xff}}},
    {{{   381,    356,   -236}, 0, {  2480,  -3114}, {0xf0, 0xf0, 0xf0, 0xff}}},
    {{{   360,    395,   -211}, 0, {  2404,  -3148}, {0xf0, 0xf0, 0xf0, 0xff}}},
    {{{   192,    393,   -210}, 0, {  2014,  -2878}, {0xf0, 0xf0, 0xf0, 0xff}}},
    {{{   357,    475,   -258}, 0, {  2292,  -3422}, {0x8e, 0x8e, 0x68, 0xff}}},
    {{{   379,    408,   -266}, 0, {  2406,  -3294}, {0x8e, 0x8e, 0x68, 0xff}}},
    {{{   459,    336,   -224}, 0, {  2690,  -3166}, {0x8e, 0x8e, 0x68, 0xff}}},
    {{{   461,    382,   -203}, 0, {  2660,  -3258}, {0x8e, 0x8e, 0x68, 0xff}}},
    {{{  -229,    755,   -449}, 0, {   518,  -3526}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -229,    648,   -634}, 0, {   518,  -3526}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -123,    366,   -224}, 0, {  1290,  -2336}, {0x4a, 0x4a, 0x4a, 0xff}}},
};

// 0x070054E0 - 0x070055C0
static const Vtx intro_seg7_vertex_070054E0[] = {
    {{{   379,    408,   -266}, 0, {  2406,  -3294}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   459,    226,   -414}, 0, {  2690,  -3166}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   459,    336,   -224}, 0, {  2690,  -3166}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   461,    382,   -203}, 0, {  2660,  -3258}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   459,    336,   -224}, 0, {  2690,  -3166}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   604,    480,   -260}, 0, {  2866,  -3822}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   640,    460,   -296}, 0, {  2950,  -3880}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   459,    336,   -224}, 0, {  2690,  -3166}, {0xd0, 0xd0, 0xd0, 0xff}}},
    {{{   640,    350,   -486}, 0, {  2950,  -3880}, {0xd0, 0xd0, 0xd0, 0xff}}},
    {{{   640,    460,   -296}, 0, {  2950,  -3880}, {0xd0, 0xd0, 0xd0, 0xff}}},
    {{{   459,    226,   -414}, 0, {  2690,  -3166}, {0xd0, 0xd0, 0xd0, 0xff}}},
    {{{   165,    798,   -473}, 0, {  1390,  -4290}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -229,    648,   -634}, 0, {   518,  -3526}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -229,    755,   -449}, 0, {   518,  -3526}, {0x4a, 0x4a, 0x4a, 0xff}}},
};

// 0x070055C0 - 0x070056B0
static const Vtx intro_seg7_vertex_070055C0[] = {
    {{{   115,    645,   -385}, 0, {  1476,  -3680}, {0xd1, 0xd1, 0xd1, 0xff}}},
    {{{   165,    691,   -659}, 0, {  1390,  -4290}, {0xd1, 0xd1, 0xd1, 0xff}}},
    {{{   165,    798,   -473}, 0, {  1390,  -4290}, {0xd1, 0xd1, 0xd1, 0xff}}},
    {{{   165,    798,   -473}, 0, {  1390,  -4290}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   165,    691,   -659}, 0, {  1390,  -4290}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -229,    648,   -634}, 0, {   518,  -3526}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -123,    366,   -224}, 0, {  1290,  -2336}, {0x50, 0x50, 0x50, 0xff}}},
    {{{  -203,    759,   -404}, 0, {   600,  -3508}, {0x50, 0x50, 0x50, 0xff}}},
    {{{  -229,    755,   -449}, 0, {   518,  -3526}, {0x50, 0x50, 0x50, 0xff}}},
    {{{  -107,    408,   -201}, 0, {  1296,  -2436}, {0x50, 0x50, 0x50, 0xff}}},
    {{{   248,    421,   -256}, 0, {  2090,  -3108}, {0x95, 0x95, 0x95, 0xff}}},
    {{{   248,    314,   -441}, 0, {  2090,  -3108}, {0x95, 0x95, 0x95, 0xff}}},
    {{{   167,    449,   -519}, 0, {  1716,  -3452}, {0x95, 0x95, 0x95, 0xff}}},
    {{{   167,    556,   -334}, 0, {  1716,  -3452}, {0x95, 0x95, 0x95, 0xff}}},
    {{{   115,    538,   -571}, 0, {  1476,  -3680}, {0xd1, 0xd1, 0xd1, 0xff}}},
};

// 0x070056B0 - 0x070057A0
static const Vtx intro_seg7_vertex_070056B0[] = {
    {{{   130,    545,   -328}, 0, {  1644,  -3356}, {0xcc, 0xcc, 0xcc, 0xff}}},
    {{{   130,    438,   -513}, 0, {  1644,  -3356}, {0xcc, 0xcc, 0xcc, 0xff}}},
    {{{   129,    539,   -571}, 0, {  1508,  -3704}, {0xcc, 0xcc, 0xcc, 0xff}}},
    {{{   167,    556,   -334}, 0, {  1716,  -3452}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   130,    438,   -513}, 0, {  1644,  -3356}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   130,    545,   -328}, 0, {  1644,  -3356}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   167,    449,   -519}, 0, {  1716,  -3452}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   129,    646,   -386}, 0, {  1508,  -3704}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   129,    539,   -571}, 0, {  1508,  -3704}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   115,    538,   -571}, 0, {  1476,  -3680}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   115,    645,   -385}, 0, {  1476,  -3680}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{   167,    556,   -334}, 0, {  1716,  -3452}, {0xee, 0xee, 0xee, 0xff}}},
    {{{   215,    457,   -229}, 0, {  1992,  -3110}, {0xee, 0xee, 0xee, 0xff}}},
    {{{   248,    421,   -256}, 0, {  2090,  -3108}, {0xee, 0xee, 0xee, 0xff}}},
    {{{   157,    554,   -285}, 0, {  1726,  -3356}, {0xee, 0xee, 0xee, 0xff}}},
};

// 0x070057A0 - 0x070058A0
static const Vtx intro_seg7_vertex_070057A0[] = {
    {{{   129,    646,   -386}, 0, {  1508,  -3704}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   108,    645,   -338}, 0, {  1488,  -3600}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   109,    566,   -292}, 0, {  1596,  -3324}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   130,    545,   -328}, 0, {  1644,  -3356}, {0xcc, 0xcc, 0xcc, 0xff}}},
    {{{   129,    539,   -571}, 0, {  1508,  -3704}, {0xcc, 0xcc, 0xcc, 0xff}}},
    {{{   129,    646,   -386}, 0, {  1508,  -3704}, {0xcc, 0xcc, 0xcc, 0xff}}},
    {{{   137,    795,   -425}, 0, {  1352,  -4166}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   115,    645,   -385}, 0, {  1476,  -3680}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   165,    798,   -473}, 0, {  1390,  -4290}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   108,    645,   -374}, 0, {  1468,  -3650}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{    97,    675,   -355}, 0, {  1420,  -3684}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -123,    366,   -224}, 0, {  1290,  -2336}, {0xaa, 0xaa, 0xaa, 0xff}}},
    {{{  -123,    259,   -409}, 0, {  1290,  -2336}, {0xaa, 0xaa, 0xaa, 0xff}}},
    {{{   248,    314,   -441}, 0, {  2090,  -3108}, {0xaa, 0xaa, 0xaa, 0xff}}},
    {{{   248,    421,   -256}, 0, {  2090,  -3108}, {0xaa, 0xaa, 0xaa, 0xff}}},
    {{{   121,    543,   -307}, 0, {  1640,  -3306}, {0xff, 0xff, 0xfe, 0xff}}},
};

// 0x070058A0 - 0x070059A0
static const Vtx intro_seg7_vertex_070058A0[] = {
    {{{   129,    646,   -386}, 0, {  1508,  -3704}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   121,    543,   -307}, 0, {  1640,  -3306}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   130,    545,   -328}, 0, {  1644,  -3356}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   109,    566,   -292}, 0, {  1596,  -3324}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{    53,    523,   -315}, 0, {  1494,  -3158}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{    32,    522,   -314}, 0, {  1448,  -3122}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{     4,    560,   -289}, 0, {  1356,  -3140}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{    34,    517,   -311}, 0, {  1458,  -3110}, {0x53, 0x53, 0x53, 0xff}}},
    {{{   157,    554,   -285}, 0, {  1726,  -3356}, {0x53, 0x53, 0x53, 0xff}}},
    {{{   167,    556,   -334}, 0, {  1716,  -3452}, {0x53, 0x53, 0x53, 0xff}}},
    {{{    21,    514,   -262}, 0, {  1460,  -3006}, {0x53, 0x53, 0x53, 0xff}}},
    {{{   108,    645,   -374}, 0, {  1468,  -3650}, {0xf0, 0xf0, 0xf0, 0xff}}},
    {{{    97,    675,   -355}, 0, {  1420,  -3684}, {0xf0, 0xf0, 0xf0, 0xff}}},
    {{{    21,    639,   -378}, 0, {  1266,  -3506}, {0xf0, 0xf0, 0xf0, 0xff}}},
    {{{    21,    514,   -262}, 0, {  1460,  -3006}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{    34,    517,   -311}, 0, {  1458,  -3110}, {0xff, 0xff, 0xfe, 0xff}}},
};

// 0x070059A0 - 0x07005A80
static const Vtx intro_seg7_vertex_070059A0[] = {
    {{{    97,    675,   -355}, 0, {  1420,  -3684}, {0xf0, 0xf0, 0xf0, 0xff}}},
    {{{     5,    676,   -356}, 0, {  1202,  -3544}, {0xf0, 0xf0, 0xf0, 0xff}}},
    {{{    21,    639,   -378}, 0, {  1266,  -3506}, {0xf0, 0xf0, 0xf0, 0xff}}},
    {{{     0,    638,   -334}, 0, {  1240,  -3404}, {0x6a, 0x6a, 0x6a, 0xff}}},
    {{{   129,    646,   -386}, 0, {  1508,  -3704}, {0x6a, 0x6a, 0x6a, 0xff}}},
    {{{    23,    639,   -382}, 0, {  1268,  -3514}, {0x6a, 0x6a, 0x6a, 0xff}}},
    {{{   108,    645,   -338}, 0, {  1488,  -3600}, {0x6a, 0x6a, 0x6a, 0xff}}},
    {{{   248,    421,   -256}, 0, {  2090,  -3108}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -107,    408,   -201}, 0, {  1296,  -2436}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -123,    366,   -224}, 0, {  1290,  -2336}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   215,    457,   -229}, 0, {  1992,  -3110}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{     4,    560,   -289}, 0, {  1356,  -3140}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{    34,    517,   -311}, 0, {  1458,  -3110}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{    32,    522,   -314}, 0, {  1448,  -3122}, {0xff, 0xff, 0xfe, 0xff}}},
};

// 0x07005A80 - 0x07005B80
static const Vtx intro_seg7_vertex_07005A80[] = {
    {{{  -229,    755,   -449}, 0, {   518,  -3526}, {0x66, 0x66, 0x66, 0xff}}},
    {{{   137,    795,   -425}, 0, {  1352,  -4166}, {0x66, 0x66, 0x66, 0xff}}},
    {{{   165,    798,   -473}, 0, {  1390,  -4290}, {0x66, 0x66, 0x66, 0xff}}},
    {{{  -203,    759,   -404}, 0, {   600,  -3508}, {0x66, 0x66, 0x66, 0xff}}},
    {{{    21,    639,   -378}, 0, {  1266,  -3506}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{     5,    676,   -356}, 0, {  1202,  -3544}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{     0,    638,   -334}, 0, {  1240,  -3404}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -440,    354,   -196}, 0, {   574,  -1770}, {0x95, 0x95, 0x95, 0xff}}},
    {{{  -262,    242,   -388}, 0, {   990,  -2044}, {0x95, 0x95, 0x95, 0xff}}},
    {{{  -262,    354,   -196}, 0, {   990,  -2044}, {0x95, 0x95, 0x95, 0xff}}},
    {{{  -440,    243,   -388}, 0, {   574,  -1770}, {0x95, 0x95, 0x95, 0xff}}},
    {{{  -228,    818,   -464}, 0, {   446,  -3712}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -441,    708,   -657}, 0, {   -54,  -3386}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -441,    820,   -465}, 0, {   -54,  -3386}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -106,    760,   -430}, 0, {   812,  -3702}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -228,    707,   -656}, 0, {   446,  -3712}, {0x4a, 0x4a, 0x4a, 0xff}}},
};

// 0x07005B80 - 0x07005C60
static const Vtx intro_seg7_vertex_07005B80[] = {
    {{{  -421,    820,   -418}, 0, {    18,  -3350}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -441,    820,   -465}, 0, {   -54,  -3386}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -440,    354,   -196}, 0, {   574,  -1770}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -440,    243,   -388}, 0, {   574,  -1770}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -441,    708,   -657}, 0, {   -54,  -3386}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -419,    394,   -172}, 0, {   594,  -1870}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -228,    818,   -464}, 0, {   446,  -3712}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -228,    707,   -656}, 0, {   446,  -3712}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -419,    394,   -172}, 0, {   594,  -1870}, {0xf0, 0xf0, 0xf0, 0xff}}},
    {{{  -440,    354,   -196}, 0, {   574,  -1770}, {0xf0, 0xf0, 0xf0, 0xff}}},
    {{{  -283,    394,   -171}, 0, {   916,  -2080}, {0xf0, 0xf0, 0xf0, 0xff}}},
    {{{  -262,    354,   -196}, 0, {   990,  -2044}, {0xf0, 0xf0, 0xf0, 0xff}}},
    {{{  -106,    760,   -430}, 0, {   812,  -3702}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -106,    649,   -623}, 0, {   812,  -3702}, {0x4a, 0x4a, 0x4a, 0xff}}},
};

// 0x07005C60 - 0x07005D50
static const Vtx intro_seg7_vertex_07005C60[] = {
    {{{  -111,    583,   -281}, 0, {  1066,  -3006}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   -90,    557,   -313}, 0, {  1122,  -3018}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -106,    760,   -430}, 0, {   812,  -3702}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   -90,    557,   -313}, 0, {  1122,  -3018}, {0xc0, 0xc0, 0xc0, 0xff}}},
    {{{   -90,    445,   -505}, 0, {  1122,  -3018}, {0xc0, 0xc0, 0xc0, 0xff}}},
    {{{  -106,    649,   -623}, 0, {   812,  -3702}, {0xc0, 0xc0, 0xc0, 0xff}}},
    {{{  -106,    760,   -430}, 0, {   812,  -3702}, {0xc0, 0xc0, 0xc0, 0xff}}},
    {{{  -185,    434,   -242}, 0, {  1064,  -2444}, {0xdd, 0xdd, 0xdd, 0xff}}},
    {{{  -185,    323,   -434}, 0, {  1064,  -2444}, {0xdd, 0xdd, 0xdd, 0xff}}},
    {{{   -90,    445,   -505}, 0, {  1122,  -3018}, {0xdd, 0xdd, 0xdd, 0xff}}},
    {{{   -90,    557,   -313}, 0, {  1122,  -3018}, {0xdd, 0xdd, 0xdd, 0xff}}},
    {{{  -126,    768,   -388}, 0, {   782,  -3628}, {0xaa, 0xaa, 0xaa, 0xff}}},
    {{{  -228,    818,   -464}, 0, {   446,  -3712}, {0xaa, 0xaa, 0xaa, 0xff}}},
    {{{  -233,    819,   -417}, 0, {   462,  -3638}, {0xaa, 0xaa, 0xaa, 0xff}}},
    {{{  -106,    760,   -430}, 0, {   812,  -3702}, {0xaa, 0xaa, 0xaa, 0xff}}},
};

// 0x07005D50 - 0x07005E30
static const Vtx intro_seg7_vertex_07005D50[] = {
    {{{  -267,    646,   -365}, 0, {   586,  -3056}, {0x7d, 0x7d, 0x7d, 0xff}}},
    {{{  -267,    535,   -557}, 0, {   586,  -3056}, {0x7d, 0x7d, 0x7d, 0xff}}},
    {{{  -241,    531,   -555}, 0, {   652,  -3082}, {0x7d, 0x7d, 0x7d, 0xff}}},
    {{{  -196,    474,   -218}, 0, {  1014,  -2496}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{   -90,    557,   -313}, 0, {  1122,  -3018}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -111,    583,   -281}, 0, {  1066,  -3006}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -185,    434,   -242}, 0, {  1064,  -2444}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -106,    760,   -430}, 0, {   812,  -3702}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -126,    768,   -388}, 0, {   782,  -3628}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -262,    433,   -242}, 0, {   884,  -2322}, {0x95, 0x95, 0x95, 0xff}}},
    {{{  -185,    323,   -434}, 0, {  1064,  -2444}, {0x95, 0x95, 0x95, 0xff}}},
    {{{  -185,    434,   -242}, 0, {  1064,  -2444}, {0x95, 0x95, 0x95, 0xff}}},
    {{{  -262,    322,   -434}, 0, {   884,  -2322}, {0x95, 0x95, 0x95, 0xff}}},
    {{{  -241,    642,   -362}, 0, {   652,  -3082}, {0x7d, 0x7d, 0x7d, 0xff}}},
};

// 0x07005E30 - 0x07005F20
static const Vtx intro_seg7_vertex_07005E30[] = {
    {{{  -265,    608,   -343}, 0, {   642,  -2926}, {0xc0, 0xc0, 0xc0, 0xff}}},
    {{{  -265,    497,   -535}, 0, {   642,  -2926}, {0xc0, 0xc0, 0xc0, 0xff}}},
    {{{  -267,    535,   -557}, 0, {   586,  -3056}, {0xc0, 0xc0, 0xc0, 0xff}}},
    {{{  -215,    678,   -336}, 0, {   692,  -3176}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -241,    642,   -362}, 0, {   652,  -3082}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -251,    610,   -344}, 0, {   672,  -2956}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -241,    531,   -555}, 0, {   652,  -3082}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -251,    499,   -536}, 0, {   672,  -2956}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -265,    497,   -535}, 0, {   642,  -2926}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -235,    614,   -299}, 0, {   732,  -2920}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -265,    608,   -343}, 0, {   642,  -2926}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -262,    354,   -196}, 0, {   990,  -2044}, {0xcc, 0xcc, 0xcc, 0xff}}},
    {{{  -262,    322,   -434}, 0, {   884,  -2322}, {0xcc, 0xcc, 0xcc, 0xff}}},
    {{{  -262,    433,   -242}, 0, {   884,  -2322}, {0xcc, 0xcc, 0xcc, 0xff}}},
    {{{  -262,    242,   -388}, 0, {   990,  -2044}, {0xcc, 0xcc, 0xcc, 0xff}}},
};

// 0x07005F20 - 0x07006010
static const Vtx intro_seg7_vertex_07005F20[] = {
    {{{  -283,    473,   -218}, 0, {   808,  -2358}, {0xf0, 0xf0, 0xf0, 0xff}}},
    {{{  -262,    433,   -242}, 0, {   884,  -2322}, {0xf0, 0xf0, 0xf0, 0xff}}},
    {{{  -185,    434,   -242}, 0, {  1064,  -2444}, {0xf0, 0xf0, 0xf0, 0xff}}},
    {{{  -265,    608,   -343}, 0, {   642,  -2926}, {0xc0, 0xc0, 0xc0, 0xff}}},
    {{{  -267,    535,   -557}, 0, {   586,  -3056}, {0xc0, 0xc0, 0xc0, 0xff}}},
    {{{  -267,    646,   -365}, 0, {   586,  -3056}, {0xc0, 0xc0, 0xc0, 0xff}}},
    {{{  -233,    819,   -417}, 0, {   462,  -3638}, {0x73, 0x73, 0x73, 0xff}}},
    {{{  -441,    820,   -465}, 0, {   -54,  -3386}, {0x73, 0x73, 0x73, 0xff}}},
    {{{  -421,    820,   -418}, 0, {    18,  -3350}, {0x73, 0x73, 0x73, 0xff}}},
    {{{  -228,    818,   -464}, 0, {   446,  -3712}, {0x73, 0x73, 0x73, 0xff}}},
    {{{  -289,    690,   -343}, 0, {   504,  -3104}, {0xdd, 0xdd, 0xdd, 0xff}}},
    {{{  -241,    642,   -362}, 0, {   652,  -3082}, {0xdd, 0xdd, 0xdd, 0xff}}},
    {{{  -215,    678,   -336}, 0, {   692,  -3176}, {0xdd, 0xdd, 0xdd, 0xff}}},
    {{{  -267,    646,   -365}, 0, {   586,  -3056}, {0xdd, 0xdd, 0xdd, 0xff}}},
    {{{  -196,    474,   -218}, 0, {  1014,  -2496}, {0xf0, 0xf0, 0xf0, 0xff}}},
};

// 0x07006010 - 0x07006100
static const Vtx intro_seg7_vertex_07006010[] = {
    {{{  -599,    824,   -456}, 0, {  -424,  -3140}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -804,    708,   -657}, 0, {  -908,  -2820}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -804,    824,   -456}, 0, {  -908,  -2820}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -283,    394,   -171}, 0, {   916,  -2080}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -262,    354,   -196}, 0, {   990,  -2044}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -262,    433,   -242}, 0, {   884,  -2322}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -283,    473,   -218}, 0, {   808,  -2358}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -235,    614,   -299}, 0, {   732,  -2920}, {0x60, 0x60, 0x60, 0xff}}},
    {{{  -251,    610,   -344}, 0, {   672,  -2956}, {0x60, 0x60, 0x60, 0xff}}},
    {{{  -284,    606,   -294}, 0, {   628,  -2816}, {0x60, 0x60, 0x60, 0xff}}},
    {{{  -265,    608,   -343}, 0, {   642,  -2926}, {0x60, 0x60, 0x60, 0xff}}},
    {{{  -284,    606,   -294}, 0, {   628,  -2816}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -267,    646,   -365}, 0, {   586,  -3056}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -289,    690,   -343}, 0, {   504,  -3104}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -265,    608,   -343}, 0, {   642,  -2926}, {0xff, 0xff, 0xfe, 0xff}}},
};

// 0x07006100 - 0x070061E0
static const Vtx intro_seg7_vertex_07006100[] = {
    {{{  -597,    750,   -413}, 0, {  -322,  -2886}, {0xc2, 0xc2, 0xc2, 0xff}}},
    {{{  -599,    708,   -657}, 0, {  -424,  -3140}, {0xc2, 0xc2, 0xc2, 0xff}}},
    {{{  -599,    824,   -456}, 0, {  -424,  -3140}, {0xc2, 0xc2, 0xc2, 0xff}}},
    {{{  -599,    824,   -456}, 0, {  -424,  -3140}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -599,    708,   -657}, 0, {  -424,  -3140}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -804,    708,   -657}, 0, {  -908,  -2820}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -804,    824,   -456}, 0, {  -908,  -2820}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -799,    380,   -467}, 0, {  -454,  -1686}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -783,    825,   -409}, 0, {  -832,  -2784}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -799,    496,   -266}, 0, {  -454,  -1686}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -704,    261,   -399}, 0, {   -70,  -1422}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -779,    523,   -234}, 0, {  -414,  -1742}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -704,    378,   -198}, 0, {   -70,  -1422}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -597,    634,   -614}, 0, {  -322,  -2886}, {0xc2, 0xc2, 0xc2, 0xff}}},
};

// 0x070061E0 - 0x070062D0
static const Vtx intro_seg7_vertex_070061E0[] = {
    {{{  -704,    378,   -198}, 0, {   -70,  -1422}, {0xb0, 0xb0, 0xb0, 0xff}}},
    {{{  -486,    303,   -423}, 0, {   384,  -1908}, {0xb0, 0xb0, 0xb0, 0xff}}},
    {{{  -486,    419,   -222}, 0, {   384,  -1908}, {0xb0, 0xb0, 0xb0, 0xff}}},
    {{{  -445,    780,   -430}, 0, {    -4,  -3226}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -445,    664,   -631}, 0, {    -4,  -3226}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -597,    634,   -614}, 0, {  -322,  -2886}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -597,    750,   -413}, 0, {  -322,  -2886}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -619,    825,   -409}, 0, {  -446,  -3040}, {0x73, 0x73, 0x73, 0xff}}},
    {{{  -599,    824,   -456}, 0, {  -424,  -3140}, {0x73, 0x73, 0x73, 0xff}}},
    {{{  -804,    824,   -456}, 0, {  -908,  -2820}, {0x73, 0x73, 0x73, 0xff}}},
    {{{  -783,    825,   -409}, 0, {  -832,  -2784}, {0x73, 0x73, 0x73, 0xff}}},
    {{{  -412,    519,   -279}, 0, {   424,  -2370}, {0xbb, 0xbb, 0xbb, 0xff}}},
    {{{  -445,    664,   -631}, 0, {    -4,  -3226}, {0xbb, 0xbb, 0xbb, 0xff}}},
    {{{  -445,    780,   -430}, 0, {    -4,  -3226}, {0xbb, 0xbb, 0xbb, 0xff}}},
    {{{  -412,    403,   -481}, 0, {   424,  -2370}, {0xbb, 0xbb, 0xbb, 0xff}}},
};

// 0x070062D0 - 0x070063C0
static const Vtx intro_seg7_vertex_070062D0[] = {
    {{{  -779,    523,   -234}, 0, {  -414,  -1742}, {0x7d, 0x7d, 0x7d, 0xff}}},
    {{{  -799,    496,   -266}, 0, {  -454,  -1686}, {0x7d, 0x7d, 0x7d, 0xff}}},
    {{{  -704,    378,   -198}, 0, {   -70,  -1422}, {0x7d, 0x7d, 0x7d, 0xff}}},
    {{{  -704,    378,   -198}, 0, {   -70,  -1422}, {0xb0, 0xb0, 0xb0, 0xff}}},
    {{{  -704,    261,   -399}, 0, {   -70,  -1422}, {0xb0, 0xb0, 0xb0, 0xff}}},
    {{{  -486,    303,   -423}, 0, {   384,  -1908}, {0xb0, 0xb0, 0xb0, 0xff}}},
    {{{  -486,    419,   -222}, 0, {   384,  -1908}, {0xdd, 0xdd, 0xdd, 0xff}}},
    {{{  -486,    303,   -423}, 0, {   384,  -1908}, {0xdd, 0xdd, 0xdd, 0xff}}},
    {{{  -412,    403,   -481}, 0, {   424,  -2370}, {0xdd, 0xdd, 0xdd, 0xff}}},
    {{{  -412,    519,   -279}, 0, {   424,  -2370}, {0xdd, 0xdd, 0xdd, 0xff}}},
    {{{  -597,    750,   -413}, 0, {  -322,  -2886}, {0x5e, 0x5e, 0x5e, 0xff}}},
    {{{  -462,    777,   -381}, 0, {   -14,  -3116}, {0x5e, 0x5e, 0x5e, 0xff}}},
    {{{  -445,    780,   -430}, 0, {    -4,  -3226}, {0x5e, 0x5e, 0x5e, 0xff}}},
    {{{  -604,    749,   -396}, 0, {  -326,  -2846}, {0x5e, 0x5e, 0x5e, 0xff}}},
    {{{  -590,    752,   -367}, 0, {  -280,  -2832}, {0x5e, 0x5e, 0x5e, 0xff}}},
};

// 0x070063C0 - 0x070064B0
static const Vtx intro_seg7_vertex_070063C0[] = {
    {{{  -433,    545,   -247}, 0, {   366,  -2354}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -445,    780,   -430}, 0, {    -4,  -3226}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -462,    777,   -381}, 0, {   -14,  -3116}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -779,    523,   -234}, 0, {  -414,  -1742}, {0x7d, 0x7d, 0x7d, 0xff}}},
    {{{  -704,    378,   -198}, 0, {   -70,  -1422}, {0x7d, 0x7d, 0x7d, 0xff}}},
    {{{  -695,    420,   -175}, 0, {   -78,  -1510}, {0x7d, 0x7d, 0x7d, 0xff}}},
    {{{  -594,    605,   -329}, 0, {  -118,  -2386}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -599,    824,   -456}, 0, {  -424,  -3140}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -619,    825,   -409}, 0, {  -446,  -3040}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -613,    593,   -275}, 0, {  -120,  -2240}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -590,    752,   -367}, 0, {  -280,  -2832}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -597,    603,   -319}, 0, {  -118,  -2358}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -580,    611,   -285}, 0, {   -66,  -2354}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -604,    749,   -396}, 0, {  -326,  -2846}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -613,    593,   -275}, 0, {  -120,  -2240}, {0x4a, 0x4a, 0x4a, 0xff}}},
};

// 0x070064B0 - 0x070065B0
static const Vtx intro_seg7_vertex_070064B0[] = {
    {{{  -854,    840,   -464}, 0, { -1044,  -2796}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{ -1044,    724,   -666}, 0, { -1492,  -2502}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{ -1044,    840,   -465}, 0, { -1492,  -2502}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -433,    545,   -247}, 0, {   366,  -2354}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -412,    519,   -279}, 0, {   424,  -2370}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -445,    780,   -430}, 0, {    -4,  -3226}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -498,    458,   -197}, 0, {   332,  -1950}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -486,    419,   -222}, 0, {   384,  -1908}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -695,    420,   -175}, 0, {   -78,  -1510}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -704,    378,   -198}, 0, {   -70,  -1422}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{ -1036,    841,   -418}, 0, { -1446,  -2446}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{ -1220,    680,   -372}, 0, { -1692,  -1670}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{ -1220,    564,   -574}, 0, { -1692,  -1670}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{ -1082,    454,   -510}, 0, { -1220,  -1502}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{ -1190,    702,   -337}, 0, { -1622,  -1722}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{ -1082,    570,   -309}, 0, { -1220,  -1502}, {0x4a, 0x4a, 0x4a, 0xff}}},
};

// 0x070065B0 - 0x07006690
static const Vtx intro_seg7_vertex_070065B0[] = {
    {{{  -854,    840,   -464}, 0, { -1044,  -2796}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -854,    723,   -666}, 0, { -1044,  -2796}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{ -1044,    724,   -666}, 0, { -1492,  -2502}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{ -1082,    570,   -309}, 0, { -1220,  -1502}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{ -1082,    454,   -510}, 0, { -1220,  -1502}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{ -1224,    399,   -479}, 0, { -1478,  -1090}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{ -1224,    515,   -277}, 0, { -1478,  -1090}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{ -1182,    531,   -239}, 0, { -1374,  -1140}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{ -1043,    585,   -270}, 0, { -1120,  -1544}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -854,    840,   -464}, 0, { -1044,  -2796}, {0x73, 0x73, 0x73, 0xff}}},
    {{{ -1044,    840,   -465}, 0, { -1492,  -2502}, {0x73, 0x73, 0x73, 0xff}}},
    {{{ -1036,    841,   -418}, 0, { -1446,  -2446}, {0x73, 0x73, 0x73, 0xff}}},
    {{{ -1034,    268,   -403}, 0, {  -854,   -932}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{ -1034,    384,   -201}, 0, {  -854,   -932}, {0x4a, 0x4a, 0x4a, 0xff}}},
};

// 0x07006690 - 0x07006770
static const Vtx intro_seg7_vertex_07006690[] = {
    {{{ -1190,    702,   -337}, 0, { -1622,  -1722}, {0x95, 0x95, 0x95, 0xff}}},
    {{{ -1220,    680,   -372}, 0, { -1692,  -1670}, {0x95, 0x95, 0x95, 0xff}}},
    {{{ -1043,    585,   -270}, 0, { -1120,  -1544}, {0x95, 0x95, 0x95, 0xff}}},
    {{{ -1082,    570,   -309}, 0, { -1220,  -1502}, {0x95, 0x95, 0x95, 0xff}}},
    {{{ -1182,    531,   -239}, 0, { -1374,  -1140}, {0xa0, 0xa0, 0xa0, 0xff}}},
    {{{ -1034,    384,   -201}, 0, {  -854,   -932}, {0xa0, 0xa0, 0xa0, 0xff}}},
    {{{ -1030,    426,   -179}, 0, {  -876,  -1012}, {0xa0, 0xa0, 0xa0, 0xff}}},
    {{{ -1224,    515,   -277}, 0, { -1478,  -1090}, {0xa0, 0xa0, 0xa0, 0xff}}},
    {{{  -989,    697,   -335}, 0, { -1144,  -2018}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -948,    682,   -373}, 0, { -1054,  -2100}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -945,    684,   -374}, 0, { -1050,  -2112}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -861,    841,   -418}, 0, { -1036,  -2718}, {0x73, 0x73, 0x73, 0xff}}},
    {{{  -854,    840,   -464}, 0, { -1044,  -2796}, {0x73, 0x73, 0x73, 0xff}}},
    {{{ -1036,    841,   -418}, 0, { -1446,  -2446}, {0x73, 0x73, 0x73, 0xff}}},
};

// 0x07006770 - 0x07006850
static const Vtx intro_seg7_vertex_07006770[] = {
    {{{ -1034,    384,   -201}, 0, {  -854,   -932}, {0xbb, 0xbb, 0xbb, 0xff}}},
    {{{ -1034,    268,   -403}, 0, {  -854,   -932}, {0xbb, 0xbb, 0xbb, 0xff}}},
    {{{  -831,    337,   -443}, 0, {  -472,  -1486}, {0xbb, 0xbb, 0xbb, 0xff}}},
    {{{  -831,    453,   -241}, 0, {  -472,  -1486}, {0xbb, 0xbb, 0xbb, 0xff}}},
    {{{  -730,    745,   -410}, 0, {  -626,  -2662}, {0x66, 0x66, 0x66, 0xff}}},
    {{{  -730,    629,   -611}, 0, {  -626,  -2662}, {0x66, 0x66, 0x66, 0xff}}},
    {{{  -854,    723,   -666}, 0, { -1044,  -2796}, {0x66, 0x66, 0x66, 0xff}}},
    {{{  -854,    840,   -464}, 0, { -1044,  -2796}, {0x66, 0x66, 0x66, 0xff}}},
    {{{  -989,    697,   -335}, 0, { -1144,  -2018}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -945,    684,   -374}, 0, { -1050,  -2112}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -946,    728,   -353}, 0, { -1084,  -2192}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -846,    489,   -215}, 0, {  -528,  -1516}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -831,    453,   -241}, 0, {  -472,  -1486}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -759,    608,   -330}, 0, {  -510,  -2136}, {0xff, 0xff, 0xfe, 0xff}}},
};

// 0x07006850 - 0x07006940
static const Vtx intro_seg7_vertex_07006850[] = {
    {{{  -856,    646,   -352}, 0, {  -790,  -2118}, {0xd1, 0xd1, 0xd1, 0xff}}},
    {{{  -856,    529,   -554}, 0, {  -790,  -2118}, {0xd1, 0xd1, 0xd1, 0xff}}},
    {{{  -730,    629,   -611}, 0, {  -626,  -2662}, {0xd1, 0xd1, 0xd1, 0xff}}},
    {{{  -730,    745,   -410}, 0, {  -626,  -2662}, {0xd1, 0xd1, 0xd1, 0xff}}},
    {{{  -759,    608,   -330}, 0, {  -510,  -2136}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -759,    491,   -532}, 0, {  -510,  -2136}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -856,    529,   -554}, 0, {  -790,  -2118}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -856,    646,   -352}, 0, {  -790,  -2118}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{ -1030,    426,   -179}, 0, {  -876,  -1012}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{ -1034,    384,   -201}, 0, {  -854,   -932}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -831,    453,   -241}, 0, {  -472,  -1486}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -846,    489,   -215}, 0, {  -528,  -1516}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -730,    745,   -410}, 0, {  -626,  -2662}, {0xcc, 0xcc, 0xcc, 0xff}}},
    {{{  -854,    840,   -464}, 0, { -1044,  -2796}, {0xcc, 0xcc, 0xcc, 0xff}}},
    {{{  -861,    841,   -418}, 0, { -1036,  -2718}, {0xcc, 0xcc, 0xcc, 0xff}}},
};

// 0x07006940 - 0x07006A30
static const Vtx intro_seg7_vertex_07006940[] = {
    {{{  -867,    683,   -327}, 0, {  -838,  -2160}, {0xaa, 0xaa, 0xaa, 0xff}}},
    {{{  -946,    728,   -353}, 0, { -1084,  -2192}, {0xaa, 0xaa, 0xaa, 0xff}}},
    {{{  -945,    684,   -374}, 0, { -1050,  -2112}, {0xaa, 0xaa, 0xaa, 0xff}}},
    {{{  -925,    673,   -368}, 0, {  -988,  -2104}, {0xaa, 0xaa, 0xaa, 0xff}}},
    {{{  -865,    649,   -343}, 0, {  -810,  -2098}, {0xaa, 0xaa, 0xaa, 0xff}}},
    {{{  -846,    489,   -215}, 0, {  -528,  -1516}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -759,    608,   -330}, 0, {  -510,  -2136}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -786,    618,   -289}, 0, {  -560,  -2058}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -831,    453,   -241}, 0, {  -472,  -1486}, {0xdd, 0xdd, 0xdd, 0xff}}},
    {{{  -831,    337,   -443}, 0, {  -472,  -1486}, {0xdd, 0xdd, 0xdd, 0xff}}},
    {{{  -759,    491,   -532}, 0, {  -510,  -2136}, {0xdd, 0xdd, 0xdd, 0xff}}},
    {{{  -759,    608,   -330}, 0, {  -510,  -2136}, {0xdd, 0xdd, 0xdd, 0xff}}},
    {{{  -762,    766,   -374}, 0, {  -702,  -2610}, {0xcc, 0xcc, 0xcc, 0xff}}},
    {{{  -730,    745,   -410}, 0, {  -626,  -2662}, {0xcc, 0xcc, 0xcc, 0xff}}},
    {{{  -861,    841,   -418}, 0, { -1036,  -2718}, {0xcc, 0xcc, 0xcc, 0xff}}},
};

// 0x07006A30 - 0x07006AC0
static const Vtx intro_seg7_vertex_07006A30[] = {
    {{{  -786,    618,   -289}, 0, {  -560,  -2058}, {0xa0, 0xa0, 0xa0, 0xff}}},
    {{{  -759,    608,   -330}, 0, {  -510,  -2136}, {0xa0, 0xa0, 0xa0, 0xff}}},
    {{{  -989,    697,   -335}, 0, { -1144,  -2018}, {0xa0, 0xa0, 0xa0, 0xff}}},
    {{{  -948,    682,   -373}, 0, { -1054,  -2100}, {0xa0, 0xa0, 0xa0, 0xff}}},
    {{{  -762,    766,   -374}, 0, {  -702,  -2610}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -865,    649,   -343}, 0, {  -810,  -2098}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -856,    646,   -352}, 0, {  -790,  -2118}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -867,    683,   -327}, 0, {  -838,  -2160}, {0xff, 0xff, 0xfe, 0xff}}},
    {{{  -730,    745,   -410}, 0, {  -626,  -2662}, {0xff, 0xff, 0xfe, 0xff}}},
};

// 0x07006AC0 - 0x07006BC0
static const Vtx intro_seg7_vertex_07006AC0[] = {
    {{{  2484,   2075,   -818}, 0, {     0,      0}, {0x00, 0x00, 0x00, 0xff}}},
    {{{ -2423,  -1994,   -818}, 0, {     0,      0}, {0x00, 0x00, 0x00, 0xff}}},
    {{{  2484,  -1994,   -818}, 0, {     0,      0}, {0x00, 0x00, 0x00, 0xff}}},
    {{{ -2423,   2075,   -818}, 0, {     0,      0}, {0x00, 0x00, 0x00, 0xff}}},
    {{{  -123,    259,   -409}, 0, {     0,      0}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -123,    366,   -224}, 0, {     0,      0}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  -229,    648,   -634}, 0, {     0,      0}, {0x4a, 0x4a, 0x4a, 0xff}}},
    {{{  1401,    395,   -178}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{  1401,    443,   -206}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{  1334,    445,   -207}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{  1334,    395,   -178}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{  1449,    395,   -178}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{  1449,    443,   -206}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{  1334,    316,   -132}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{  1401,    316,   -132}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{  1401,    681,   -343}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
};

// 0x07006BC0 - 0x07006CC0
static const Vtx intro_seg7_vertex_07006BC0[] = {
    {{{  1202,    445,   -207}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{  1334,    592,   -292}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{  1339,    681,   -343}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{  1334,    445,   -207}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{  1401,    681,   -343}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{  1133,    453,   -212}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{  1334,    395,   -178}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{  1025,    350,   -152}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{   981,    396,   -178}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{   947,    372,   -165}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{  1133,    395,   -178}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{   985,    436,   -202}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{  1062,    434,   -201}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{  1048,    490,   -233}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{   972,    474,   -224}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{  1055,    387,   -173}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
};

// 0x07006CC0 - 0x07006DC0
static const Vtx intro_seg7_vertex_07006CC0[] = {
    {{{  1048,    490,   -233}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{  1018,    524,   -252}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{   972,    474,   -224}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{  1025,    350,   -152}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{  1055,    387,   -173}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{   981,    396,   -178}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{   888,    682,   -344}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{   904,    625,   -311}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{   957,    691,   -349}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{   947,    372,   -165}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{   973,    322,   -136}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{   943,    489,   -232}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{   974,    541,   -263}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{   957,    634,   -316}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{   999,    633,   -316}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{   999,    690,   -348}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
};

// 0x07006DC0 - 0x07006EB0
static const Vtx intro_seg7_vertex_07006DC0[] = {
    {{{   815,    652,   -327}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{   904,    625,   -311}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{   888,    682,   -344}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{   973,    322,   -136}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{   947,    372,   -165}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{   909,    365,   -161}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{   915,    309,   -129}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{   943,    489,   -232}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{   974,    541,   -263}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{   923,    547,   -266}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{   899,    492,   -234}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{   872,    543,   -263}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{   872,    367,   -162}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{   844,    316,   -133}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{   863,    608,   -301}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
};

// 0x07006EB0 - 0x07006FB0
static const Vtx intro_seg7_vertex_07006EB0[] = {
    {{{   765,    601,   -297}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{   829,    580,   -285}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{   863,    608,   -301}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{   856,    484,   -230}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{   899,    492,   -234}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{   872,    543,   -263}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{   807,    517,   -248}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{   812,    455,   -213}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{   872,    367,   -162}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{   841,    382,   -170}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{   844,    316,   -133}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{   795,    337,   -145}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{   815,    652,   -327}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{   820,    411,   -187}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{   759,    376,   -167}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{   733,    462,   -217}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
};

// 0x07006FB0 - 0x070070B0
static const Vtx intro_seg7_vertex_07006FB0[] = {
    {{{   742,    414,   -189}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{   812,    455,   -213}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{   733,    462,   -217}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{   820,    411,   -187}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{   742,    554,   -270}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{   733,    512,   -246}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{   807,    517,   -248}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{   829,    580,   -285}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{   765,    601,   -297}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{   759,    376,   -167}, 0, {     0,      0}, {0xff, 0x2f, 0x2f, 0xff}}},
    {{{   230,     73,      1}, 0, {     0,      0}, {0xba, 0xba, 0x00, 0xff}}},
    {{{   209,     94,     12}, 0, {     0,      0}, {0xba, 0xba, 0x00, 0xff}}},
    {{{   105,     33,     48}, 0, {     0,      0}, {0xba, 0xba, 0x00, 0xff}}},
    {{{  1414,    299,   -137}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{  1401,    316,   -132}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{  1334,    316,   -132}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
};

// 0x070070B0 - 0x070071A0
static const Vtx intro_seg7_vertex_070070B0[] = {
    {{{  1414,    447,   -223}, 0, {     0,      0}, {0xb4, 0xa0, 0x3b, 0xff}}},
    {{{  1401,    443,   -206}, 0, {     0,      0}, {0xb4, 0xa0, 0x3b, 0xff}}},
    {{{  1449,    443,   -206}, 0, {     0,      0}, {0xb4, 0xa0, 0x3b, 0xff}}},
    {{{  1462,    447,   -223}, 0, {     0,      0}, {0xb4, 0xa0, 0x3b, 0xff}}},
    {{{  1462,    447,   -223}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{  1449,    395,   -178}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{  1462,    378,   -183}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{  1401,    395,   -178}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{  1414,    378,   -183}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{  1401,    316,   -132}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{  1414,    299,   -137}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{  1449,    443,   -206}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{  1320,    299,   -137}, 0, {     0,      0}, {0xa8, 0x95, 0x37, 0xff}}},
    {{{  1334,    316,   -132}, 0, {     0,      0}, {0xa8, 0x95, 0x37, 0xff}}},
    {{{  1334,    395,   -178}, 0, {     0,      0}, {0xa8, 0x95, 0x37, 0xff}}},
};

// 0x070071A0 - 0x07007280
static const Vtx intro_seg7_vertex_070071A0[] = {
    {{{  1414,    299,   -137}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{  1334,    316,   -132}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{  1320,    299,   -137}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{  1414,    685,   -360}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{  1401,    681,   -343}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{  1401,    443,   -206}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{  1414,    447,   -223}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{  1333,    685,   -360}, 0, {     0,      0}, {0xb4, 0xa0, 0x3b, 0xff}}},
    {{{  1401,    681,   -343}, 0, {     0,      0}, {0xb4, 0xa0, 0x3b, 0xff}}},
    {{{  1414,    685,   -360}, 0, {     0,      0}, {0xb4, 0xa0, 0x3b, 0xff}}},
    {{{  1339,    681,   -343}, 0, {     0,      0}, {0xb4, 0xa0, 0x3b, 0xff}}},
    {{{  1320,    299,   -137}, 0, {     0,      0}, {0xa8, 0x95, 0x37, 0xff}}},
    {{{  1334,    395,   -178}, 0, {     0,      0}, {0xa8, 0x95, 0x37, 0xff}}},
    {{{  1320,    378,   -183}, 0, {     0,      0}, {0xa8, 0x95, 0x37, 0xff}}},
};

// 0x07007280 - 0x07007370
static const Vtx intro_seg7_vertex_07007280[] = {
    {{{  1120,    451,   -225}, 0, {     0,      0}, {0x84, 0x84, 0x2b, 0xff}}},
    {{{  1133,    453,   -212}, 0, {     0,      0}, {0x84, 0x84, 0x2b, 0xff}}},
    {{{  1333,    685,   -360}, 0, {     0,      0}, {0x84, 0x84, 0x2b, 0xff}}},
    {{{  1334,    592,   -292}, 0, {     0,      0}, {0xa8, 0x95, 0x37, 0xff}}},
    {{{  1320,    450,   -224}, 0, {     0,      0}, {0xa8, 0x95, 0x37, 0xff}}},
    {{{  1334,    445,   -207}, 0, {     0,      0}, {0xa8, 0x95, 0x37, 0xff}}},
    {{{  1320,    553,   -284}, 0, {     0,      0}, {0xa8, 0x95, 0x37, 0xff}}},
    {{{  1202,    445,   -207}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{  1229,    450,   -224}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{  1334,    592,   -292}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{  1320,    553,   -284}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{  1334,    445,   -207}, 0, {     0,      0}, {0xb4, 0xa0, 0x3b, 0xff}}},
    {{{  1229,    450,   -224}, 0, {     0,      0}, {0xb4, 0xa0, 0x3b, 0xff}}},
    {{{  1202,    445,   -207}, 0, {     0,      0}, {0xb4, 0xa0, 0x3b, 0xff}}},
    {{{  1320,    450,   -224}, 0, {     0,      0}, {0xb4, 0xa0, 0x3b, 0xff}}},
};

// 0x07007370 - 0x07007470
static const Vtx intro_seg7_vertex_07007370[] = {
    {{{  1123,    378,   -183}, 0, {     0,      0}, {0xa8, 0x95, 0x37, 0xff}}},
    {{{  1133,    453,   -212}, 0, {     0,      0}, {0xa8, 0x95, 0x37, 0xff}}},
    {{{  1120,    451,   -225}, 0, {     0,      0}, {0xa8, 0x95, 0x37, 0xff}}},
    {{{  1133,    453,   -212}, 0, {     0,      0}, {0x84, 0x84, 0x2b, 0xff}}},
    {{{  1339,    681,   -343}, 0, {     0,      0}, {0x84, 0x84, 0x2b, 0xff}}},
    {{{  1333,    685,   -360}, 0, {     0,      0}, {0x84, 0x84, 0x2b, 0xff}}},
    {{{  1320,    378,   -183}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{  1334,    395,   -178}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{  1133,    395,   -178}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{  1123,    378,   -183}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{  1123,    378,   -183}, 0, {     0,      0}, {0x70, 0x70, 0x19, 0xff}}},
    {{{  1133,    395,   -178}, 0, {     0,      0}, {0x70, 0x70, 0x19, 0xff}}},
    {{{  1133,    453,   -212}, 0, {     0,      0}, {0x70, 0x70, 0x19, 0xff}}},
    {{{  1013,    694,   -366}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   999,    690,   -348}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   999,    633,   -316}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
};

// 0x07007470 - 0x07007560
static const Vtx intro_seg7_vertex_07007470[] = {
    {{{  1060,    488,   -247}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{  1062,    434,   -201}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{  1075,    426,   -211}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{  1068,    376,   -182}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{  1055,    387,   -173}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{  1048,    490,   -233}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{  1025,    350,   -152}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{  1035,    335,   -158}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{  1026,    526,   -269}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{  1018,    524,   -252}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   973,    322,   -136}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   979,    306,   -141}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   956,    696,   -367}, 0, {     0,      0}, {0xb4, 0xb4, 0x3b, 0xff}}},
    {{{   957,    691,   -349}, 0, {     0,      0}, {0xb4, 0xb4, 0x3b, 0xff}}},
    {{{   999,    690,   -348}, 0, {     0,      0}, {0xb4, 0xb4, 0x3b, 0xff}}},
};

// 0x07007560 - 0x07007650
static const Vtx intro_seg7_vertex_07007560[] = {
    {{{  1013,    694,   -366}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   999,    633,   -316}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{  1012,    616,   -321}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   957,    634,   -316}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   959,    616,   -321}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   979,    306,   -141}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   973,    322,   -136}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   915,    309,   -129}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   916,    292,   -133}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   956,    696,   -367}, 0, {     0,      0}, {0xb4, 0xb4, 0x3b, 0xff}}},
    {{{   999,    690,   -348}, 0, {     0,      0}, {0xb4, 0xb4, 0x3b, 0xff}}},
    {{{  1013,    694,   -366}, 0, {     0,      0}, {0xb4, 0xb4, 0x3b, 0xff}}},
    {{{   960,    462,   -231}, 0, {     0,      0}, {0xa8, 0xa8, 0x37, 0xff}}},
    {{{   972,    429,   -212}, 0, {     0,      0}, {0xa8, 0xa8, 0x37, 0xff}}},
    {{{   985,    436,   -202}, 0, {     0,      0}, {0xa8, 0xa8, 0x37, 0xff}}},
};

// 0x07007650 - 0x07007740
static const Vtx intro_seg7_vertex_07007650[] = {
    {{{   978,    546,   -280}, 0, {     0,      0}, {0xdf, 0xdf, 0x1f, 0xff}}},
    {{{   974,    541,   -263}, 0, {     0,      0}, {0xdf, 0xdf, 0x1f, 0xff}}},
    {{{  1026,    526,   -269}, 0, {     0,      0}, {0xdf, 0xdf, 0x1f, 0xff}}},
    {{{  1018,    524,   -252}, 0, {     0,      0}, {0xdf, 0xdf, 0x1f, 0xff}}},
    {{{   959,    616,   -321}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   957,    634,   -316}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   904,    625,   -311}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   909,    608,   -316}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   985,    436,   -202}, 0, {     0,      0}, {0x90, 0x90, 0x39, 0xff}}},
    {{{   968,    394,   -192}, 0, {     0,      0}, {0x90, 0x90, 0x39, 0xff}}},
    {{{   981,    396,   -178}, 0, {     0,      0}, {0x90, 0x90, 0x39, 0xff}}},
    {{{   972,    429,   -212}, 0, {     0,      0}, {0x90, 0x90, 0x39, 0xff}}},
    {{{   943,    489,   -232}, 0, {     0,      0}, {0xdf, 0xdf, 0x1f, 0xff}}},
    {{{   960,    462,   -231}, 0, {     0,      0}, {0xdf, 0xdf, 0x1f, 0xff}}},
    {{{   972,    474,   -224}, 0, {     0,      0}, {0xdf, 0xdf, 0x1f, 0xff}}},
};

// 0x07007740 - 0x07007830
static const Vtx intro_seg7_vertex_07007740[] = {
    {{{   972,    474,   -224}, 0, {     0,      0}, {0xa8, 0xa8, 0x37, 0xff}}},
    {{{   960,    462,   -231}, 0, {     0,      0}, {0xa8, 0xa8, 0x37, 0xff}}},
    {{{   985,    436,   -202}, 0, {     0,      0}, {0xa8, 0xa8, 0x37, 0xff}}},
    {{{   981,    396,   -178}, 0, {     0,      0}, {0x7e, 0x7e, 0x11, 0xff}}},
    {{{   968,    394,   -192}, 0, {     0,      0}, {0x7e, 0x7e, 0x11, 0xff}}},
    {{{   947,    372,   -165}, 0, {     0,      0}, {0x7e, 0x7e, 0x11, 0xff}}},
    {{{   968,    394,   -192}, 0, {     0,      0}, {0x8c, 0x8c, 0x13, 0xff}}},
    {{{   939,    375,   -182}, 0, {     0,      0}, {0x8c, 0x8c, 0x13, 0xff}}},
    {{{   947,    372,   -165}, 0, {     0,      0}, {0x8c, 0x8c, 0x13, 0xff}}},
    {{{   943,    489,   -232}, 0, {     0,      0}, {0xdf, 0xdf, 0x1f, 0xff}}},
    {{{   936,    473,   -238}, 0, {     0,      0}, {0xdf, 0xdf, 0x1f, 0xff}}},
    {{{   960,    462,   -231}, 0, {     0,      0}, {0xdf, 0xdf, 0x1f, 0xff}}},
    {{{   909,    608,   -316}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   904,    625,   -311}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   872,    593,   -307}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
};

// 0x07007830 - 0x07007920
static const Vtx intro_seg7_vertex_07007830[] = {
    {{{   915,    309,   -129}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   844,    316,   -133}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   840,    299,   -138}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   916,    292,   -133}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   923,    552,   -283}, 0, {     0,      0}, {0xc0, 0xc0, 0x2b, 0xff}}},
    {{{   974,    541,   -263}, 0, {     0,      0}, {0xc0, 0xc0, 0x2b, 0xff}}},
    {{{   978,    546,   -280}, 0, {     0,      0}, {0xc0, 0xc0, 0x2b, 0xff}}},
    {{{   923,    547,   -266}, 0, {     0,      0}, {0xc0, 0xc0, 0x2b, 0xff}}},
    {{{   884,    687,   -361}, 0, {     0,      0}, {0xa8, 0xa8, 0x37, 0xff}}},
    {{{   888,    682,   -344}, 0, {     0,      0}, {0xa8, 0xa8, 0x37, 0xff}}},
    {{{   957,    691,   -349}, 0, {     0,      0}, {0xa8, 0xa8, 0x37, 0xff}}},
    {{{   956,    696,   -367}, 0, {     0,      0}, {0xa8, 0xa8, 0x37, 0xff}}},
    {{{   868,    547,   -281}, 0, {     0,      0}, {0xa8, 0xa8, 0x37, 0xff}}},
    {{{   872,    543,   -263}, 0, {     0,      0}, {0xa8, 0xa8, 0x37, 0xff}}},
    {{{   923,    547,   -266}, 0, {     0,      0}, {0xa8, 0xa8, 0x37, 0xff}}},
};

// 0x07007920 - 0x07007A20
static const Vtx intro_seg7_vertex_07007920[] = {
    {{{   947,    372,   -165}, 0, {     0,      0}, {0x9a, 0x9a, 0x15, 0xff}}},
    {{{   939,    375,   -182}, 0, {     0,      0}, {0x9a, 0x9a, 0x15, 0xff}}},
    {{{   909,    365,   -161}, 0, {     0,      0}, {0x9a, 0x9a, 0x15, 0xff}}},
    {{{   939,    375,   -182}, 0, {     0,      0}, {0xa0, 0xa0, 0x23, 0xff}}},
    {{{   908,    370,   -179}, 0, {     0,      0}, {0xa0, 0xa0, 0x23, 0xff}}},
    {{{   909,    365,   -161}, 0, {     0,      0}, {0xa0, 0xa0, 0x23, 0xff}}},
    {{{   863,    468,   -235}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   900,    475,   -239}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   899,    492,   -234}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   943,    489,   -232}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   936,    473,   -238}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   856,    484,   -230}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   812,    455,   -213}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   868,    547,   -281}, 0, {     0,      0}, {0xa8, 0xa8, 0x37, 0xff}}},
    {{{   923,    547,   -266}, 0, {     0,      0}, {0xa8, 0xa8, 0x37, 0xff}}},
    {{{   923,    552,   -283}, 0, {     0,      0}, {0xa8, 0xa8, 0x37, 0xff}}},
};

// 0x07007A20 - 0x07007B20
static const Vtx intro_seg7_vertex_07007A20[] = {
    {{{   872,    593,   -307}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   863,    608,   -301}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   841,    569,   -293}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   904,    625,   -311}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   909,    365,   -161}, 0, {     0,      0}, {0xb4, 0xb4, 0x3b, 0xff}}},
    {{{   908,    370,   -179}, 0, {     0,      0}, {0xb4, 0xb4, 0x3b, 0xff}}},
    {{{   872,    367,   -162}, 0, {     0,      0}, {0xb4, 0xb4, 0x3b, 0xff}}},
    {{{   878,    371,   -179}, 0, {     0,      0}, {0xb4, 0xb4, 0x3b, 0xff}}},
    {{{   829,    580,   -285}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   841,    382,   -170}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   852,    382,   -185}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   833,    407,   -200}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   806,    655,   -343}, 0, {     0,      0}, {0x90, 0x90, 0x20, 0xff}}},
    {{{   815,    652,   -327}, 0, {     0,      0}, {0x90, 0x90, 0x20, 0xff}}},
    {{{   888,    682,   -344}, 0, {     0,      0}, {0x90, 0x90, 0x39, 0xff}}},
    {{{   884,    687,   -361}, 0, {     0,      0}, {0x90, 0x90, 0x39, 0xff}}},
};

// 0x07007B20 - 0x07007C10
static const Vtx intro_seg7_vertex_07007B20[] = {
    {{{   872,    367,   -162}, 0, {     0,      0}, {0xdf, 0xdf, 0x1f, 0xff}}},
    {{{   852,    382,   -185}, 0, {     0,      0}, {0xdf, 0xdf, 0x1f, 0xff}}},
    {{{   841,    382,   -170}, 0, {     0,      0}, {0xdf, 0xdf, 0x1f, 0xff}}},
    {{{   878,    371,   -179}, 0, {     0,      0}, {0xdf, 0xdf, 0x1f, 0xff}}},
    {{{   841,    569,   -293}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   829,    580,   -285}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   807,    517,   -248}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   825,    530,   -271}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   840,    299,   -138}, 0, {     0,      0}, {0xf0, 0xf0, 0x00, 0xff}}},
    {{{   844,    316,   -133}, 0, {     0,      0}, {0xf0, 0xf0, 0x00, 0xff}}},
    {{{   786,    322,   -151}, 0, {     0,      0}, {0xf0, 0xf0, 0x00, 0xff}}},
    {{{   820,    411,   -187}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   833,    407,   -200}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   826,    444,   -221}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   841,    382,   -170}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
};

// 0x07007C10 - 0x07007CF0
static const Vtx intro_seg7_vertex_07007C10[] = {
    {{{   807,    517,   -248}, 0, {     0,      0}, {0x90, 0x90, 0x39, 0xff}}},
    {{{   872,    543,   -263}, 0, {     0,      0}, {0x90, 0x90, 0x39, 0xff}}},
    {{{   868,    547,   -281}, 0, {     0,      0}, {0x90, 0x90, 0x39, 0xff}}},
    {{{   825,    530,   -271}, 0, {     0,      0}, {0x90, 0x90, 0x39, 0xff}}},
    {{{   820,    411,   -187}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   826,    444,   -221}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   812,    455,   -213}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   863,    468,   -235}, 0, {     0,      0}, {0xff, 0xff, 0x39, 0xff}}},
    {{{   786,    322,   -151}, 0, {     0,      0}, {0xc0, 0xc0, 0x2b, 0xff}}},
    {{{   759,    376,   -167}, 0, {     0,      0}, {0xc0, 0xc0, 0x2b, 0xff}}},
    {{{   747,    364,   -175}, 0, {     0,      0}, {0xc0, 0xc0, 0x2b, 0xff}}},
    {{{   844,    316,   -133}, 0, {     0,      0}, {0xf0, 0xf0, 0x00, 0xff}}},
    {{{   795,    337,   -145}, 0, {     0,      0}, {0xf0, 0xf0, 0x00, 0xff}}},
    {{{   786,    322,   -151}, 0, {     0,      0}, {0xf0, 0xf0, 0x00, 0xff}}},
};

// 0x07007CF0 - 0x07007DF0
static const Vtx intro_seg7_vertex_07007CF0[] = {
    {{{   753,    600,   -311}, 0, {     0,      0}, {0x84, 0x84, 0x2b, 0xff}}},
    {{{   765,    601,   -297}, 0, {     0,      0}, {0x84, 0x84, 0x2b, 0xff}}},
    {{{   806,    655,   -343}, 0, {     0,      0}, {0x84, 0x84, 0x2b, 0xff}}},
    {{{   815,    652,   -327}, 0, {     0,      0}, {0x84, 0x84, 0x2b, 0xff}}},
    {{{   729,    550,   -283}, 0, {     0,      0}, {0x84, 0x84, 0x2b, 0xff}}},
    {{{   742,    554,   -270}, 0, {     0,      0}, {0x84, 0x84, 0x2b, 0xff}}},
    {{{   786,    322,   -151}, 0, {     0,      0}, {0xc0, 0xc0, 0x2b, 0xff}}},
    {{{   795,    337,   -145}, 0, {     0,      0}, {0xc0, 0xc0, 0x2b, 0xff}}},
    {{{   759,    376,   -167}, 0, {     0,      0}, {0xc0, 0xc0, 0x2b, 0xff}}},
    {{{   720,    455,   -228}, 0, {     0,      0}, {0xa8, 0x95, 0x37, 0xff}}},
    {{{   733,    512,   -246}, 0, {     0,      0}, {0xa8, 0x95, 0x37, 0xff}}},
    {{{   720,    506,   -257}, 0, {     0,      0}, {0xa8, 0x95, 0x37, 0xff}}},
    {{{   747,    364,   -175}, 0, {     0,      0}, {0xa8, 0xa8, 0x17, 0xff}}},
    {{{   759,    376,   -167}, 0, {     0,      0}, {0xa8, 0xa8, 0x17, 0xff}}},
    {{{   742,    414,   -189}, 0, {     0,      0}, {0xa8, 0xa8, 0x17, 0xff}}},
    {{{   729,    405,   -199}, 0, {     0,      0}, {0xa8, 0xa8, 0x17, 0xff}}},
};

// 0x07007DF0 - 0x07007EA0
static const Vtx intro_seg7_vertex_07007DF0[] = {
    {{{   729,    405,   -199}, 0, {     0,      0}, {0x9a, 0x9a, 0x15, 0xff}}},
    {{{   733,    462,   -217}, 0, {     0,      0}, {0x9a, 0x9a, 0x15, 0xff}}},
    {{{   720,    455,   -228}, 0, {     0,      0}, {0x9a, 0x9a, 0x15, 0xff}}},
    {{{   742,    414,   -189}, 0, {     0,      0}, {0x9a, 0x9a, 0x15, 0xff}}},
    {{{   720,    506,   -257}, 0, {     0,      0}, {0x8b, 0x8b, 0x00, 0xff}}},
    {{{   733,    512,   -246}, 0, {     0,      0}, {0x8b, 0x8b, 0x00, 0xff}}},
    {{{   742,    554,   -270}, 0, {     0,      0}, {0x8b, 0x8b, 0x00, 0xff}}},
    {{{   729,    550,   -283}, 0, {     0,      0}, {0x8b, 0x8b, 0x00, 0xff}}},
    {{{   720,    455,   -228}, 0, {     0,      0}, {0xa8, 0x95, 0x37, 0xff}}},
    {{{   733,    462,   -217}, 0, {     0,      0}, {0xa8, 0x95, 0x37, 0xff}}},
    {{{   733,    512,   -246}, 0, {     0,      0}, {0xa8, 0x95, 0x37, 0xff}}},
};

// 0x07007EA0 - 0x07007EA2
ALIGNED8 static const u8 intro_seg7_texture_07007EA0[] = {
#include "levels/intro/0.rgba16.inc.c"
};

// 0x070086A0 - 0x070086A2
ALIGNED8 static const u8 intro_seg7_texture_070086A0[] = {
#include "levels/intro/1.rgba16.inc.c"
};

// 0x07008EA0 - 0x07009E38
static const Gfx intro_seg7_dl_07008EA0[] = {
    gsDPSetTextureImage(G_IM_FMT_RGBA, G_IM_SIZ_16b, 1, intro_seg7_texture_070086A0),
    gsDPLoadSync(),
    gsDPLoadBlock(G_TX_LOADTILE, 0, 0, 32 * 32 - 1, CALC_DXT(32, G_IM_SIZ_16b_BYTES)),
    gsSPVertex(intro_seg7_vertex_07000000, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 3,  6,  7, 0x0,  5,  2,  3, 0x0),
    gsSP2Triangles( 3,  7,  4, 0x0,  2,  1,  3, 0x0),
    gsSP2Triangles( 7,  8,  4, 0x0,  9, 10, 11, 0x0),
    gsSP2Triangles( 9, 12, 10, 0x0, 13, 14,  0, 0x0),
    gsSP2Triangles(15, 13,  0, 0x0,  0,  2, 15, 0x0),
    gsSPVertex(intro_seg7_vertex_07000100, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  0,  2,  3, 0x0),
    gsSP2Triangles( 4,  5,  6, 0x0,  7,  4,  6, 0x0),
    gsSP2Triangles( 8,  9,  4, 0x0,  4, 10,  5, 0x0),
    gsSP2Triangles( 7,  8,  4, 0x0, 11,  8, 12, 0x0),
    gsSP2Triangles( 8, 11, 13, 0x0,  8, 13,  9, 0x0),
    gsSP2Triangles( 8, 14, 12, 0x0,  6, 14,  7, 0x0),
    gsSP1Triangle( 6, 12, 14, 0x0),
    gsSPVertex(intro_seg7_vertex_070001F0, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  3,  5, 0x0,  3,  7,  4, 0x0),
    gsSP2Triangles( 3,  8,  7, 0x0,  0,  2,  6, 0x0),
    gsSP2Triangles( 2,  9,  6, 0x0,  6,  5,  0, 0x0),
    gsSP2Triangles( 2, 10, 11, 0x0,  2, 12, 10, 0x0),
    gsSP2Triangles( 2, 11,  9, 0x0, 13, 14, 15, 0x0),
    gsSPVertex(intro_seg7_vertex_070002F0, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  0, 0x0),
    gsSP2Triangles( 0,  2,  3, 0x0,  0,  5,  1, 0x0),
    gsSP2Triangles( 3,  6,  7, 0x0,  3,  8,  6, 0x0),
    gsSP2Triangles( 3,  7,  4, 0x0,  3,  9,  8, 0x0),
    gsSP2Triangles( 7, 10, 11, 0x0,  7, 11,  4, 0x0),
    gsSP1Triangle(12, 13, 14, 0x0),
    gsSPVertex(intro_seg7_vertex_070003E0, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  0,  3,  1, 0x0),
    gsSP2Triangles( 4,  2,  5, 0x0,  2,  6,  5, 0x0),
    gsSP2Triangles( 5,  7,  4, 0x0,  5,  8,  9, 0x0),
    gsSP2Triangles(10, 11, 12, 0x0, 13, 10, 12, 0x0),
    gsSP2Triangles(12, 11, 14, 0x0, 12, 14, 15, 0x0),
    gsSPVertex(intro_seg7_vertex_070004E0, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  1,  3,  2, 0x0),
    gsSP2Triangles( 4,  5,  6, 0x0,  4,  6,  7, 0x0),
    gsSP2Triangles( 8,  9, 10, 0x0,  8, 11,  9, 0x0),
    gsSP1Triangle(12, 13, 14, 0x0),
    gsSPVertex(intro_seg7_vertex_070005D0, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  1,  3,  2, 0x0),
    gsSP2Triangles( 4,  1,  0, 0x0,  5,  6,  7, 0x0),
    gsSP2Triangles( 5,  8,  6, 0x0,  9, 10, 11, 0x0),
    gsSP2Triangles(12, 13, 14, 0x0, 12, 14, 15, 0x0),
    gsSPVertex(intro_seg7_vertex_070006D0, 14, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  1,  3,  2, 0x0),
    gsSP2Triangles( 4,  5,  6, 0x0,  4,  6,  7, 0x0),
    gsSP2Triangles( 8,  9, 10, 0x0, 11, 12, 13, 0x0),
    gsSPVertex(intro_seg7_vertex_070007B0, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  0,  2,  3, 0x0),
    gsSP2Triangles( 4,  5,  6, 0x0,  7,  8,  4, 0x0),
    gsSP2Triangles( 8,  5,  4, 0x0,  9, 10, 11, 0x0),
    gsSP1Triangle(12, 13, 14, 0x0),
    gsSPVertex(intro_seg7_vertex_070008A0, 14, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  2,  1,  3, 0x0),
    gsSP2Triangles( 0,  4,  1, 0x0,  5,  6,  7, 0x0),
    gsSP2Triangles( 5,  8,  6, 0x0,  9,  8,  5, 0x0),
    gsSP2Triangles( 9, 10,  8, 0x0, 11, 12, 13, 0x0),
    gsSPVertex(intro_seg7_vertex_07000980, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  1,  0, 0x0),
    gsSP2Triangles( 4,  5,  6, 0x0,  5,  7,  6, 0x0),
    gsSP2Triangles( 8,  9, 10, 0x0,  8, 11,  9, 0x0),
    gsSP1Triangle(12, 13, 14, 0x0),
    gsSPVertex(intro_seg7_vertex_07000A70, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 5,  4,  6, 0x0,  3,  7,  4, 0x0),
    gsSP2Triangles( 8,  9, 10, 0x0, 11,  8, 10, 0x0),
    gsSP1Triangle(12, 13, 14, 0x0),
    gsSPVertex(intro_seg7_vertex_07000B60, 14, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 3,  5,  6, 0x0,  7,  8,  9, 0x0),
    gsSP2Triangles( 7,  9, 10, 0x0, 11, 12, 13, 0x0),
    gsSPVertex(intro_seg7_vertex_07000C40, 14, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  0,  2, 0x0),
    gsSP2Triangles( 2,  1,  4, 0x0,  2,  4,  5, 0x0),
    gsSP2Triangles( 6,  7,  8, 0x0,  9,  6,  8, 0x0),
    gsSP2Triangles( 8, 10, 11, 0x0,  8,  7, 10, 0x0),
    gsSP2Triangles(12, 13,  6, 0x0, 12,  6,  9, 0x0),
    gsSPVertex(intro_seg7_vertex_07000D20, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 4,  6,  5, 0x0,  7,  8,  9, 0x0),
    gsSP2Triangles(10,  7,  9, 0x0, 11, 12, 13, 0x0),
    gsSP1Triangle(11, 13, 14, 0x0),
    gsSPVertex(intro_seg7_vertex_07000E10, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  7,  8, 0x0,  6,  8,  9, 0x0),
    gsSP2Triangles(10, 11, 12, 0x0, 10, 12, 13, 0x0),
    gsSP1Triangle( 1, 14,  2, 0x0),
    gsSPVertex(intro_seg7_vertex_07000F00, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 4,  6,  5, 0x0,  7,  8,  9, 0x0),
    gsSP2Triangles( 7,  9, 10, 0x0, 11, 12, 13, 0x0),
    gsSP1Triangle(11, 14, 12, 0x0),
    gsSPVertex(intro_seg7_vertex_07000FF0, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  7,  8, 0x0,  7,  9,  8, 0x0),
    gsSP2Triangles(10, 11, 12, 0x0, 11, 13, 12, 0x0),
    gsSP1Triangle(14,  0,  2, 0x0),
    gsSPVertex(intro_seg7_vertex_070010E0, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 3,  5,  6, 0x0,  7,  8,  9, 0x0),
    gsSP2Triangles( 7, 10,  8, 0x0, 11, 12, 13, 0x0),
    gsSP1Triangle(11, 13, 14, 0x0),
    gsSPVertex(intro_seg7_vertex_070011D0, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  7,  8, 0x0,  6,  9,  7, 0x0),
    gsSP2Triangles(10, 11, 12, 0x0, 10, 12, 13, 0x0),
    gsSP1Triangle( 0, 14,  1, 0x0),
    gsSPVertex(intro_seg7_vertex_070012C0, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 3,  6,  4, 0x0,  7,  8,  9, 0x0),
    gsSP2Triangles( 7, 10,  8, 0x0, 11, 12, 13, 0x0),
    gsSP2Triangles(14, 11, 13, 0x0,  1, 15,  2, 0x0),
    gsSPVertex(intro_seg7_vertex_070013C0, 14, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 3,  5,  6, 0x0,  7,  8,  9, 0x0),
    gsSP2Triangles( 7,  9, 10, 0x0, 11, 12, 13, 0x0),
    gsSPVertex(intro_seg7_vertex_070014A0, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  0,  3,  1, 0x0),
    gsSP2Triangles( 4,  5,  6, 0x0,  5,  7,  6, 0x0),
    gsSP2Triangles( 8,  9, 10, 0x0,  8, 11,  9, 0x0),
    gsSP1Triangle(12, 13, 14, 0x0),
    gsSPVertex(intro_seg7_vertex_07001590, 14, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 3,  6,  4, 0x0,  7,  8,  9, 0x0),
    gsSP2Triangles( 7, 10,  8, 0x0, 11, 12, 13, 0x0),
    gsSPVertex(intro_seg7_vertex_07001670, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  0,  3,  1, 0x0),
    gsSP2Triangles( 4,  5,  6, 0x0,  4,  6,  7, 0x0),
    gsSP2Triangles( 8,  9, 10, 0x0, 10, 11,  8, 0x0),
    gsSP2Triangles(12, 13,  9, 0x0, 12, 14, 13, 0x0),
    gsSP1Triangle(15, 14, 12, 0x0),
    gsSPVertex(intro_seg7_vertex_07001770, 14, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  0,  3,  1, 0x0),
    gsSP2Triangles( 0,  2,  4, 0x0,  5,  2,  1, 0x0),
    gsSP2Triangles( 5,  6,  7, 0x0,  5,  7,  8, 0x0),
    gsSP2Triangles( 5,  8,  2, 0x0,  5,  9,  6, 0x0),
    gsSP2Triangles(10, 11, 12, 0x0, 10, 12, 13, 0x0),
    gsSPVertex(intro_seg7_vertex_07001850, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  0,  3,  1, 0x0),
    gsSP2Triangles( 4,  5,  6, 0x0,  7,  8,  9, 0x0),
    gsSP2Triangles(10, 11, 12, 0x0, 13, 14, 15, 0x0),
    gsSPVertex(intro_seg7_vertex_07001950, 14, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 4,  6,  5, 0x0,  7,  8,  9, 0x0),
    gsSP2Triangles( 7, 10,  8, 0x0, 11, 12, 13, 0x0),
    gsSPVertex(intro_seg7_vertex_07001A30, 14, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 4,  6,  5, 0x0,  7,  8,  9, 0x0),
    gsSP2Triangles( 7,  9, 10, 0x0, 11, 12, 13, 0x0),
    gsSPVertex(intro_seg7_vertex_07001B10, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 4,  6,  5, 0x0,  7,  8,  9, 0x0),
    gsSP2Triangles( 7,  9, 10, 0x0, 11, 12, 13, 0x0),
    gsSP1Triangle(11, 13, 14, 0x0),
    gsSPVertex(intro_seg7_vertex_07001C00, 14, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  7,  8, 0x0,  6,  9,  7, 0x0),
    gsSP2Triangles( 0, 10,  1, 0x0, 11, 12, 13, 0x0),
    gsSPVertex(intro_seg7_vertex_07001CE0, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  0,  2, 0x0),
    gsSP2Triangles( 4,  5,  6, 0x0,  4,  7,  8, 0x0),
    gsSP2Triangles( 8,  9,  4, 0x0,  4,  6, 10, 0x0),
    gsSP2Triangles( 4, 10,  7, 0x0,  8, 11,  9, 0x0),
    gsSP2Triangles(11, 12,  9, 0x0, 11, 13, 12, 0x0),
    gsSP1Triangle(11, 14, 15, 0x0),
    gsSPVertex(intro_seg7_vertex_07001DE0, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 4,  6,  5, 0x0,  7,  8,  9, 0x0),
    gsSP2Triangles( 7,  9, 10, 0x0, 11, 12, 13, 0x0),
    gsSP1Triangle(11, 13, 14, 0x0),
    gsSPVertex(intro_seg7_vertex_07001ED0, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 3,  5,  6, 0x0,  7,  8,  9, 0x0),
    gsSP2Triangles( 7,  9, 10, 0x0, 11, 12, 13, 0x0),
    gsSP2Triangles(12, 14, 13, 0x0,  0, 15,  1, 0x0),
    gsSPVertex(intro_seg7_vertex_07001FD0, 14, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 3,  5,  6, 0x0,  7,  8,  9, 0x0),
    gsSP2Triangles( 7,  9, 10, 0x0, 11, 12, 13, 0x0),
    gsSPVertex(intro_seg7_vertex_070020B0, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  0,  2,  3, 0x0),
    gsSP2Triangles( 4,  5,  6, 0x0,  4,  6,  7, 0x0),
    gsSP2Triangles( 8,  9, 10, 0x0,  8, 10, 11, 0x0),
    gsSP1Triangle(12, 13, 14, 0x0),
    gsSPVertex(intro_seg7_vertex_070021A0, 14, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 3,  6,  4, 0x0,  7,  8,  9, 0x0),
    gsSP2Triangles( 8, 10,  9, 0x0, 11, 12, 13, 0x0),
    gsSPVertex(intro_seg7_vertex_07002280, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 4,  6,  5, 0x0,  7,  8,  9, 0x0),
    gsSP2Triangles( 8, 10,  9, 0x0, 11, 12, 13, 0x0),
    gsSP1Triangle(11, 13, 14, 0x0),
    gsSPVertex(intro_seg7_vertex_07002370, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  7,  8, 0x0,  9,  6,  8, 0x0),
    gsSP2Triangles(10, 11, 12, 0x0, 11, 13, 12, 0x0),
    gsSP1Triangle( 0,  2, 14, 0x0),
    gsSPVertex(intro_seg7_vertex_07002460, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  0,  2,  3, 0x0),
    gsSP2Triangles( 4,  5,  6, 0x0,  7,  8,  9, 0x0),
    gsSP2Triangles( 7, 10,  8, 0x0, 11,  8, 12, 0x0),
    gsSP2Triangles(11,  9,  8, 0x0,  9, 13, 14, 0x0),
    gsSP2Triangles(11, 13,  9, 0x0,  4,  9, 14, 0x0),
    gsSP1Triangle( 4, 15,  9, 0x0),
    gsSPVertex(intro_seg7_vertex_07002560, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  2,  3,  0, 0x0),
    gsSP2Triangles( 0,  4,  1, 0x0,  5,  6,  3, 0x0),
    gsSP2Triangles( 5,  7,  8, 0x0,  9, 10, 11, 0x0),
    gsSP2Triangles( 9, 12, 10, 0x0,  9, 13, 12, 0x0),
    gsSP2Triangles( 9, 14, 15, 0x0,  9, 15, 13, 0x0),
    gsSPVertex(intro_seg7_vertex_07002660, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  0,  3,  1, 0x0),
    gsSP2Triangles( 0,  2,  4, 0x0,  0,  5,  3, 0x0),
    gsSP2Triangles( 0,  6,  7, 0x0,  0,  8,  5, 0x0),
    gsSP2Triangles( 0,  7,  8, 0x0,  9, 10, 11, 0x0),
    gsSP2Triangles(12, 13, 14, 0x0, 12, 14, 15, 0x0),
    gsSPVertex(intro_seg7_vertex_07002760, 14, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  0,  3,  1, 0x0),
    gsSP2Triangles( 4,  5,  6, 0x0,  4,  7,  5, 0x0),
    gsSP2Triangles( 8,  9, 10, 0x0, 11, 12, 13, 0x0),
    gsSPVertex(intro_seg7_vertex_07002840, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  0,  3,  1, 0x0),
    gsSP2Triangles( 4,  5,  6, 0x0,  4,  6,  7, 0x0),
    gsSP2Triangles( 8,  4,  7, 0x0,  9, 10, 11, 0x0),
    gsSP2Triangles(12, 13, 14, 0x0, 12, 15, 13, 0x0),
    gsSPVertex(intro_seg7_vertex_07002940, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  0,  3,  1, 0x0),
    gsSP2Triangles( 4,  5,  6, 0x0,  4,  7,  5, 0x0),
    gsSP2Triangles( 8,  9, 10, 0x0, 11,  6, 12, 0x0),
    gsSP1Triangle(13, 14, 15, 0x0),
    gsSPVertex(intro_seg7_vertex_07002A40, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 3,  5,  6, 0x0,  7,  8,  9, 0x0),
    gsSP2Triangles(10, 11, 12, 0x0, 13, 14, 15, 0x0),
    gsSPVertex(intro_seg7_vertex_07002B40, 14, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 4,  3,  6, 0x0,  7,  8,  9, 0x0),
    gsSP2Triangles( 7,  9, 10, 0x0, 11, 12, 13, 0x0),
    gsSPVertex(intro_seg7_vertex_07002C20, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 3,  6,  4, 0x0,  7,  8,  9, 0x0),
    gsSP2Triangles( 7, 10,  8, 0x0, 11, 12, 13, 0x0),
    gsSP2Triangles(14, 13, 15, 0x0, 14, 11, 13, 0x0),
    gsSPVertex(intro_seg7_vertex_07002D20, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  0,  3,  1, 0x0),
    gsSP2Triangles( 4,  0,  2, 0x0,  4,  2,  5, 0x0),
    gsSP2Triangles( 6,  7,  8, 0x0,  6,  8,  9, 0x0),
    gsSP2Triangles(10, 11, 12, 0x0, 11, 13, 14, 0x0),
    gsSP2Triangles(11, 14, 12, 0x0, 13, 15, 14, 0x0),
    gsSPVertex(intro_seg7_vertex_07002E20, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  0,  2, 0x0,  6,  2,  7, 0x0),
    gsSP2Triangles( 8,  9, 10, 0x0,  8, 10, 11, 0x0),
    gsSP1Triangle(12, 13, 14, 0x0),
    gsSPVertex(intro_seg7_vertex_07002F10, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  0,  2,  3, 0x0),
    gsSP2Triangles( 4,  5,  6, 0x0,  4,  7,  5, 0x0),
    gsSP2Triangles( 8,  9, 10, 0x0,  8, 10, 11, 0x0),
    gsSP1Triangle(12, 13, 14, 0x0),
    gsSPVertex(intro_seg7_vertex_07003000, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  0,  2,  3, 0x0),
    gsSP2Triangles( 4,  5,  6, 0x0,  4,  6,  7, 0x0),
    gsSP2Triangles( 8,  9, 10, 0x0, 11, 12, 13, 0x0),
    gsSP1Triangle( 8, 10, 14, 0x0),
    gsSPVertex(intro_seg7_vertex_070030F0, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  0,  3,  1, 0x0),
    gsSP2Triangles( 4,  5,  6, 0x0,  4,  6,  7, 0x0),
    gsSP2Triangles( 8,  9, 10, 0x0, 11, 12, 13, 0x0),
    gsSP1Triangle(11, 14, 12, 0x0),
    gsSPVertex(intro_seg7_vertex_070031E0, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  0,  2,  3, 0x0),
    gsSP2Triangles( 4,  5,  6, 0x0,  4,  6,  7, 0x0),
    gsSP2Triangles( 5,  8,  6, 0x0,  5,  9,  8, 0x0),
    gsSP2Triangles(10, 11, 12, 0x0, 13, 14, 15, 0x0),
    gsSPVertex(intro_seg7_vertex_070032E0, 14, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 3,  5,  6, 0x0,  7,  8,  9, 0x0),
    gsSP2Triangles( 7, 10,  8, 0x0, 11, 12, 13, 0x0),
    gsSPVertex(intro_seg7_vertex_070033C0, 14, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 3,  5,  6, 0x0,  7,  8,  9, 0x0),
    gsSP2Triangles( 7, 10,  8, 0x0, 10, 11,  8, 0x0),
    gsSP2Triangles(12,  3,  6, 0x0, 12,  6, 13, 0x0),
    gsSPVertex(intro_seg7_vertex_070034A0, 6, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  0,  2,  3, 0x0),
    gsSP2Triangles( 1,  4,  5, 0x0,  1,  5,  2, 0x0),
    gsSPEndDisplayList(),
};

// 0x07009E38 - 0x0700ADC0
static const Gfx intro_seg7_dl_07009E38[] = {
    gsDPSetTextureImage(G_IM_FMT_RGBA, G_IM_SIZ_16b, 1, intro_seg7_texture_07007EA0),
    gsDPLoadSync(),
    gsDPLoadBlock(G_TX_LOADTILE, 0, 0, 32 * 32 - 1, CALC_DXT(32, G_IM_SIZ_16b_BYTES)),
    gsSPVertex(intro_seg7_vertex_07003500, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  2,  3,  4, 0x0),
    gsSP2Triangles( 2,  4,  0, 0x0,  5,  3,  2, 0x0),
    gsSP2Triangles( 6,  5,  2, 0x0,  2,  1,  7, 0x0),
    gsSP2Triangles( 2,  7,  6, 0x0,  0,  8,  1, 0x0),
    gsSP2Triangles( 7,  9, 10, 0x0,  6,  7, 10, 0x0),
    gsSP2Triangles(11, 12, 13, 0x0, 11, 14, 12, 0x0),
    gsSPVertex(intro_seg7_vertex_070035F0, 14, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  0,  2,  3, 0x0),
    gsSP2Triangles( 2,  4,  5, 0x0,  3,  2,  5, 0x0),
    gsSP2Triangles( 6,  7,  8, 0x0,  6,  9,  7, 0x0),
    gsSP2Triangles(10, 11, 12, 0x0, 10, 13, 11, 0x0),
    gsSPVertex(intro_seg7_vertex_070036D0, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 3,  6,  4, 0x0,  7,  8,  0, 0x0),
    gsSP2Triangles( 7,  9,  8, 0x0, 10, 11,  7, 0x0),
    gsSP2Triangles(12,  9,  7, 0x0,  0, 10,  7, 0x0),
    gsSP2Triangles( 0,  8,  1, 0x0, 13, 14, 15, 0x0),
    gsSPVertex(intro_seg7_vertex_070037D0, 14, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 4,  6,  5, 0x0,  7,  8,  9, 0x0),
    gsSP2Triangles( 7,  9, 10, 0x0, 11, 12, 13, 0x0),
    gsSPVertex(intro_seg7_vertex_070038B0, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 3,  5,  6, 0x0,  7,  8,  9, 0x0),
    gsSP2Triangles( 7, 10,  8, 0x0, 11, 12, 13, 0x0),
    gsSP1Triangle(12, 14, 13, 0x0),
    gsSPVertex(intro_seg7_vertex_070039A0, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  7,  8, 0x0,  6,  8,  9, 0x0),
    gsSP2Triangles(10, 11, 12, 0x0, 13, 10, 12, 0x0),
    gsSP1Triangle( 0, 14,  1, 0x0),
    gsSPVertex(intro_seg7_vertex_07003A90, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 4,  6,  5, 0x0,  6,  7,  5, 0x0),
    gsSP2Triangles( 6,  8,  7, 0x0,  9, 10, 11, 0x0),
    gsSP2Triangles( 9, 12, 10, 0x0, 13, 14, 15, 0x0),
    gsSPVertex(intro_seg7_vertex_07003B90, 14, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 3,  6,  4, 0x0,  7,  8,  9, 0x0),
    gsSP2Triangles( 7,  9, 10, 0x0, 11, 12, 13, 0x0),
    gsSPVertex(intro_seg7_vertex_07003C70, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 3,  5,  6, 0x0,  7,  8,  9, 0x0),
    gsSP2Triangles( 7, 10,  8, 0x0, 11, 12, 13, 0x0),
    gsSP1Triangle(11, 14, 12, 0x0),
    gsSPVertex(intro_seg7_vertex_07003D60, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  7,  8, 0x0,  6,  8,  9, 0x0),
    gsSP2Triangles(10, 11, 12, 0x0, 10, 13, 11, 0x0),
    gsSP1Triangle( 0, 14,  1, 0x0),
    gsSPVertex(intro_seg7_vertex_07003E50, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 4,  6,  5, 0x0,  7,  8,  9, 0x0),
    gsSP2Triangles( 7,  9, 10, 0x0, 11, 12, 13, 0x0),
    gsSP1Triangle(11, 13, 14, 0x0),
    gsSPVertex(intro_seg7_vertex_07003F40, 14, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 5,  6,  7, 0x0,  8,  5,  7, 0x0),
    gsSP2Triangles( 9, 10, 11, 0x0, 10, 12, 11, 0x0),
    gsSP1Triangle( 0,  2, 13, 0x0),
    gsSPVertex(intro_seg7_vertex_07004020, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 3,  5,  6, 0x0,  6,  5,  7, 0x0),
    gsSP2Triangles( 6,  7,  8, 0x0,  9,  2, 10, 0x0),
    gsSP2Triangles( 9, 10, 11, 0x0, 11, 12,  9, 0x0),
    gsSP2Triangles( 0,  2,  9, 0x0, 13, 14, 15, 0x0),
    gsSPVertex(intro_seg7_vertex_07004120, 14, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  3,  5, 0x0,  7,  8,  9, 0x0),
    gsSP2Triangles( 7, 10,  8, 0x0, 11, 12, 13, 0x0),
    gsSPVertex(intro_seg7_vertex_07004200, 14, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  1,  3,  2, 0x0),
    gsSP2Triangles( 4,  5,  6, 0x0,  4,  6,  7, 0x0),
    gsSP2Triangles( 7,  8,  4, 0x0,  7,  9,  8, 0x0),
    gsSP2Triangles(10, 11, 12, 0x0, 10, 13, 11, 0x0),
    gsSPVertex(intro_seg7_vertex_070042E0, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 3,  6,  4, 0x0,  7,  8,  9, 0x0),
    gsSP2Triangles( 7,  9, 10, 0x0,  2, 11,  0, 0x0),
    gsSP2Triangles( 0, 12,  1, 0x0, 13, 14, 15, 0x0),
    gsSPVertex(intro_seg7_vertex_070043E0, 14, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 3,  6,  4, 0x0,  7,  8,  9, 0x0),
    gsSP2Triangles( 7,  9, 10, 0x0, 11, 12, 13, 0x0),
    gsSPVertex(intro_seg7_vertex_070044C0, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 4,  6,  5, 0x0,  7,  8,  9, 0x0),
    gsSP2Triangles(10,  7,  9, 0x0, 11, 12, 13, 0x0),
    gsSP1Triangle(11, 14, 12, 0x0),
    gsSPVertex(intro_seg7_vertex_070045B0, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  7,  8, 0x0,  6,  9,  7, 0x0),
    gsSP2Triangles(10,  2, 11, 0x0,  0,  2, 10, 0x0),
    gsSP2Triangles(10, 11, 12, 0x0, 13, 14, 15, 0x0),
    gsSPVertex(intro_seg7_vertex_070046B0, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  2, 0x0),
    gsSP2Triangles( 2,  1,  5, 0x0,  2,  5,  3, 0x0),
    gsSP2Triangles( 0,  6,  1, 0x0,  3,  7,  4, 0x0),
    gsSP2Triangles( 8,  9, 10, 0x0,  8, 11,  9, 0x0),
    gsSP1Triangle(12, 13, 14, 0x0),
    gsSPVertex(intro_seg7_vertex_070047A0, 14, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 3,  6,  4, 0x0,  7,  8,  9, 0x0),
    gsSP2Triangles( 7, 10,  8, 0x0, 11, 12, 13, 0x0),
    gsSPVertex(intro_seg7_vertex_07004880, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 3,  5,  6, 0x0,  7,  8,  9, 0x0),
    gsSP2Triangles( 7,  9, 10, 0x0,  7, 10, 11, 0x0),
    gsSP2Triangles(12,  7, 11, 0x0, 13,  8,  7, 0x0),
    gsSP1Triangle(13, 14,  8, 0x0),
    gsSPVertex(intro_seg7_vertex_07004970, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 5,  6,  7, 0x0,  5,  4,  6, 0x0),
    gsSP2Triangles( 8,  9, 10, 0x0,  9, 11, 10, 0x0),
    gsSP2Triangles(12,  1,  0, 0x0, 13,  0, 14, 0x0),
    gsSP1Triangle( 0,  2, 14, 0x0),
    gsSPVertex(intro_seg7_vertex_07004A60, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  7,  8, 0x0,  6,  9,  7, 0x0),
    gsSP2Triangles(10, 11, 12, 0x0, 10, 12, 13, 0x0),
    gsSP1Triangle( 0,  2, 14, 0x0),
    gsSPVertex(intro_seg7_vertex_07004B50, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 4,  6,  5, 0x0,  7,  8,  9, 0x0),
    gsSP2Triangles( 7, 10,  8, 0x0, 11, 10,  7, 0x0),
    gsSP2Triangles( 7,  9, 12, 0x0, 13,  7, 12, 0x0),
    gsSP1Triangle(11, 14, 10, 0x0),
    gsSPVertex(intro_seg7_vertex_07004C40, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  7,  8, 0x0,  6,  9,  7, 0x0),
    gsSP2Triangles(10, 11, 12, 0x0, 10, 12, 13, 0x0),
    gsSP1Triangle( 0,  2, 14, 0x0),
    gsSPVertex(intro_seg7_vertex_07004D30, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 3,  6,  4, 0x0,  7,  8,  9, 0x0),
    gsSP2Triangles( 7, 10,  8, 0x0, 11, 12, 13, 0x0),
    gsSP2Triangles(11, 14, 12, 0x0,  0, 15,  1, 0x0),
    gsSPVertex(intro_seg7_vertex_07004E30, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 3,  6,  4, 0x0,  7,  8,  9, 0x0),
    gsSP2Triangles( 7,  9, 10, 0x0, 11,  7, 12, 0x0),
    gsSP2Triangles(13, 14,  8, 0x0, 13,  8,  7, 0x0),
    gsSP1Triangle( 7, 10, 12, 0x0),
    gsSPVertex(intro_seg7_vertex_07004F20, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  1,  3,  2, 0x0),
    gsSP2Triangles( 4,  5,  6, 0x0,  4,  6,  7, 0x0),
    gsSP2Triangles( 8,  9, 10, 0x0, 11, 12, 13, 0x0),
    gsSP1Triangle(11, 14, 12, 0x0),
    gsSPVertex(intro_seg7_vertex_07005010, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 3,  5,  6, 0x0,  7,  8,  9, 0x0),
    gsSP2Triangles( 0,  2, 10, 0x0, 11, 12, 13, 0x0),
    gsSP1Triangle(12, 14, 13, 0x0),
    gsSPVertex(intro_seg7_vertex_07005100, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  0,  3,  1, 0x0),
    gsSP2Triangles( 1,  4,  5, 0x0,  2,  1,  5, 0x0),
    gsSP2Triangles( 6,  7,  8, 0x0,  9, 10, 11, 0x0),
    gsSP2Triangles( 9, 12, 10, 0x0, 13, 14, 15, 0x0),
    gsSPVertex(intro_seg7_vertex_07005200, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  1,  3,  4, 0x0),
    gsSP2Triangles( 2,  1,  4, 0x0,  2,  4,  5, 0x0),
    gsSP2Triangles( 6,  2,  5, 0x0,  7,  8,  9, 0x0),
    gsSP2Triangles(10, 11, 12, 0x0, 13, 14, 15, 0x0),
    gsSPVertex(intro_seg7_vertex_07005300, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 3,  6,  4, 0x0,  7,  8,  9, 0x0),
    gsSP2Triangles(10, 11, 12, 0x0, 13, 14, 15, 0x0),
    gsSPVertex(intro_seg7_vertex_07005400, 14, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  3,  5, 0x0,  7,  8,  9, 0x0),
    gsSP2Triangles( 7,  9, 10, 0x0, 11, 12, 13, 0x0),
    gsSPVertex(intro_seg7_vertex_070054E0, 14, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 4,  6,  5, 0x0,  7,  8,  9, 0x0),
    gsSP2Triangles( 7, 10,  8, 0x0, 11, 12, 13, 0x0),
    gsSPVertex(intro_seg7_vertex_070055C0, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  7,  8, 0x0,  6,  9,  7, 0x0),
    gsSP2Triangles(10, 11, 12, 0x0, 10, 12, 13, 0x0),
    gsSP1Triangle( 0, 14,  1, 0x0),
    gsSPVertex(intro_seg7_vertex_070056B0, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 3,  6,  4, 0x0,  7,  8,  9, 0x0),
    gsSP2Triangles( 7,  9, 10, 0x0, 11, 12, 13, 0x0),
    gsSP1Triangle(11, 14, 12, 0x0),
    gsSPVertex(intro_seg7_vertex_070057A0, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  7,  8, 0x0,  6,  9,  7, 0x0),
    gsSP2Triangles( 6, 10,  9, 0x0, 11, 12, 13, 0x0),
    gsSP2Triangles(11, 13, 14, 0x0,  0,  2, 15, 0x0),
    gsSPVertex(intro_seg7_vertex_070058A0, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  1, 0x0),
    gsSP2Triangles( 3,  5,  4, 0x0,  3,  6,  5, 0x0),
    gsSP2Triangles( 7,  8,  9, 0x0,  7, 10,  8, 0x0),
    gsSP2Triangles(11, 12, 13, 0x0,  6, 14, 15, 0x0),
    gsSPVertex(intro_seg7_vertex_070059A0, 14, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 3,  6,  4, 0x0,  7,  8,  9, 0x0),
    gsSP2Triangles( 7, 10,  8, 0x0, 11, 12, 13, 0x0),
    gsSPVertex(intro_seg7_vertex_07005A80, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  0,  3,  1, 0x0),
    gsSP2Triangles( 4,  5,  6, 0x0,  7,  8,  9, 0x0),
    gsSP2Triangles( 7, 10,  8, 0x0, 11, 12, 13, 0x0),
    gsSP1Triangle(14, 15, 11, 0x0),
    gsSPVertex(intro_seg7_vertex_07005B80, 14, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  1,  3,  2, 0x0),
    gsSP2Triangles( 1,  4,  3, 0x0,  0,  2,  5, 0x0),
    gsSP2Triangles( 6,  7,  4, 0x0,  8,  9, 10, 0x0),
    gsSP2Triangles( 9, 11, 10, 0x0, 12, 13,  7, 0x0),
    gsSPVertex(intro_seg7_vertex_07005C60, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 3,  5,  6, 0x0,  7,  8,  9, 0x0),
    gsSP2Triangles( 7,  9, 10, 0x0, 11, 12, 13, 0x0),
    gsSP1Triangle(11, 14, 12, 0x0),
    gsSPVertex(intro_seg7_vertex_07005D50, 14, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 3,  6,  4, 0x0,  5,  7,  8, 0x0),
    gsSP2Triangles( 9, 10, 11, 0x0,  9, 12, 10, 0x0),
    gsSP1Triangle( 0,  2, 13, 0x0),
    gsSPVertex(intro_seg7_vertex_07005E30, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 4,  6,  7, 0x0,  4,  7,  5, 0x0),
    gsSP2Triangles( 5,  7,  8, 0x0,  3,  5,  9, 0x0),
    gsSP2Triangles( 5,  8, 10, 0x0, 11, 12, 13, 0x0),
    gsSP1Triangle(11, 14, 12, 0x0),
    gsSPVertex(intro_seg7_vertex_07005F20, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  7,  8, 0x0,  6,  9,  7, 0x0),
    gsSP2Triangles(10, 11, 12, 0x0, 10, 13, 11, 0x0),
    gsSP1Triangle( 0,  2, 14, 0x0),
    gsSPVertex(intro_seg7_vertex_07006010, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 3,  5,  6, 0x0,  7,  8,  9, 0x0),
    gsSP2Triangles( 8, 10,  9, 0x0, 11, 12, 13, 0x0),
    gsSP1Triangle(11, 14, 12, 0x0),
    gsSPVertex(intro_seg7_vertex_07006100, 14, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  5,  7, 0x0,  8,  6,  9, 0x0),
    gsSP2Triangles( 6,  7,  9, 0x0,  9,  7, 10, 0x0),
    gsSP2Triangles( 8,  9, 11, 0x0,  9, 10, 12, 0x0),
    gsSP1Triangle( 0, 13,  1, 0x0),
    gsSPVertex(intro_seg7_vertex_070061E0, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 3,  5,  6, 0x0,  7,  8,  9, 0x0),
    gsSP2Triangles( 7,  9, 10, 0x0, 11, 12, 13, 0x0),
    gsSP1Triangle(11, 14, 12, 0x0),
    gsSPVertex(intro_seg7_vertex_070062D0, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  7,  8, 0x0,  6,  8,  9, 0x0),
    gsSP2Triangles(10, 11, 12, 0x0, 10, 13, 14, 0x0),
    gsSP1Triangle(10, 14, 11, 0x0),
    gsSPVertex(intro_seg7_vertex_070063C0, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  7,  8, 0x0,  9,  6,  8, 0x0),
    gsSP2Triangles(10, 11, 12, 0x0, 10, 13, 11, 0x0),
    gsSP1Triangle(12, 11, 14, 0x0),
    gsSPVertex(intro_seg7_vertex_070064B0, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  7,  4, 0x0,  6,  4,  3, 0x0),
    gsSP2Triangles( 8,  9,  7, 0x0,  8,  7,  6, 0x0),
    gsSP2Triangles(10,  2, 11, 0x0,  2, 12, 11, 0x0),
    gsSP2Triangles( 2,  1, 12, 0x0, 11, 12, 13, 0x0),
    gsSP2Triangles(10, 11, 14, 0x0, 11, 13, 15, 0x0),
    gsSPVertex(intro_seg7_vertex_070065B0, 14, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 3,  5,  6, 0x0,  3,  6,  7, 0x0),
    gsSP2Triangles( 8,  3,  7, 0x0,  9, 10, 11, 0x0),
    gsSP2Triangles( 6,  5, 12, 0x0,  6, 12, 13, 0x0),
    gsSPVertex(intro_seg7_vertex_07006690, 14, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  1,  3,  2, 0x0),
    gsSP2Triangles( 4,  5,  6, 0x0,  4,  7,  5, 0x0),
    gsSP2Triangles( 8,  9, 10, 0x0, 11, 12, 13, 0x0),
    gsSPVertex(intro_seg7_vertex_07006770, 14, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  0,  2,  3, 0x0),
    gsSP2Triangles( 4,  5,  6, 0x0,  4,  6,  7, 0x0),
    gsSP2Triangles( 8,  9, 10, 0x0, 11, 12, 13, 0x0),
    gsSPVertex(intro_seg7_vertex_07006850, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  0,  2,  3, 0x0),
    gsSP2Triangles( 4,  5,  6, 0x0,  4,  6,  7, 0x0),
    gsSP2Triangles( 8,  9, 10, 0x0,  8, 10, 11, 0x0),
    gsSP1Triangle(12, 13, 14, 0x0),
    gsSPVertex(intro_seg7_vertex_07006940, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  0,  2,  3, 0x0),
    gsSP2Triangles( 0,  3,  4, 0x0,  5,  6,  7, 0x0),
    gsSP2Triangles( 8,  9, 10, 0x0,  8, 10, 11, 0x0),
    gsSP1Triangle(12, 13, 14, 0x0),
    gsSPVertex(intro_seg7_vertex_07006A30, 9, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  1,  3,  2, 0x0),
    gsSP2Triangles( 4,  5,  6, 0x0,  4,  7,  5, 0x0),
    gsSP1Triangle( 4,  6,  8, 0x0),
    gsSPEndDisplayList(),
};

// 0x0700ADC0 - 0x0700B3A0
static const Gfx intro_seg7_dl_0700ADC0[] = {
    gsSPVertex(intro_seg7_vertex_07006AC0, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  0,  3,  1, 0x0),
    gsSP2Triangles( 4,  5,  6, 0x0,  7,  8,  9, 0x0),
    gsSP2Triangles(10,  7,  9, 0x0,  7, 11, 12, 0x0),
    gsSP2Triangles( 7, 12,  8, 0x0, 13, 14,  7, 0x0),
    gsSP2Triangles(13,  7, 10, 0x0,  9,  8, 15, 0x0),
    gsSPVertex(intro_seg7_vertex_07006BC0, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  1, 0x0),
    gsSP2Triangles( 1,  4,  2, 0x0,  5,  0,  2, 0x0),
    gsSP2Triangles( 6,  3,  0, 0x0,  7,  8,  9, 0x0),
    gsSP2Triangles( 6,  0, 10, 0x0, 10,  0,  5, 0x0),
    gsSP2Triangles(11, 12, 13, 0x0, 11, 13, 14, 0x0),
    gsSP2Triangles(11,  8, 12, 0x0,  8, 15, 12, 0x0),
    gsSPVertex(intro_seg7_vertex_07006CC0, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  7,  8, 0x0,  3,  9, 10, 0x0),
    gsSP2Triangles(11,  2,  1, 0x0, 11,  1, 12, 0x0),
    gsSP2Triangles(13, 14,  8, 0x0, 14, 15,  8, 0x0),
    gsSP1Triangle( 7, 13,  8, 0x0),
    gsSPVertex(intro_seg7_vertex_07006DC0, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 3,  5,  6, 0x0,  7,  8,  9, 0x0),
    gsSP2Triangles(10,  7,  9, 0x0, 10,  9, 11, 0x0),
    gsSP2Triangles(12,  6,  5, 0x0, 12, 13,  6, 0x0),
    gsSP1Triangle( 0, 14,  1, 0x0),
    gsSPVertex(intro_seg7_vertex_07006EB0, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  7,  5, 0x0,  7,  3,  5, 0x0),
    gsSP2Triangles( 8,  9, 10, 0x0,  9, 11, 10, 0x0),
    gsSP2Triangles( 0,  2, 12, 0x0,  9, 13, 14, 0x0),
    gsSP2Triangles( 9, 14, 11, 0x0, 15,  7,  6, 0x0),
    gsSPVertex(intro_seg7_vertex_07006FB0, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  0,  3,  1, 0x0),
    gsSP2Triangles( 4,  5,  6, 0x0,  2,  6,  5, 0x0),
    gsSP2Triangles( 4,  6,  7, 0x0,  7,  8,  4, 0x0),
    gsSP2Triangles( 0,  9,  3, 0x0, 10, 11, 12, 0x0),
    gsSP1Triangle(13, 14, 15, 0x0),
    gsSPVertex(intro_seg7_vertex_070070B0, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  0,  2,  3, 0x0),
    gsSP2Triangles( 4,  5,  6, 0x0,  6,  5,  7, 0x0),
    gsSP2Triangles( 6,  7,  8, 0x0,  8,  7,  9, 0x0),
    gsSP2Triangles( 8,  9, 10, 0x0,  4, 11,  5, 0x0),
    gsSP1Triangle(12, 13, 14, 0x0),
    gsSPVertex(intro_seg7_vertex_070071A0, 14, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 3,  5,  6, 0x0,  7,  8,  9, 0x0),
    gsSP2Triangles( 7, 10,  8, 0x0, 11, 12, 13, 0x0),
    gsSPVertex(intro_seg7_vertex_07007280, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 3,  6,  4, 0x0,  7,  8,  9, 0x0),
    gsSP2Triangles( 8, 10,  9, 0x0, 11, 12, 13, 0x0),
    gsSP1Triangle(11, 14, 12, 0x0),
    gsSPVertex(intro_seg7_vertex_07007370, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  7,  8, 0x0,  6,  8,  9, 0x0),
    gsSP2Triangles(10, 11, 12, 0x0, 13, 14, 15, 0x0),
    gsSPVertex(intro_seg7_vertex_07007470, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  2,  1,  3, 0x0),
    gsSP2Triangles( 1,  4,  3, 0x0,  0,  5,  1, 0x0),
    gsSP2Triangles( 3,  4,  6, 0x0,  3,  6,  7, 0x0),
    gsSP2Triangles( 8,  5,  0, 0x0,  8,  9,  5, 0x0),
    gsSP2Triangles( 7,  6, 10, 0x0,  7, 10, 11, 0x0),
    gsSP1Triangle(12, 13, 14, 0x0),
    gsSPVertex(intro_seg7_vertex_07007560, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  2,  1,  3, 0x0),
    gsSP2Triangles( 2,  3,  4, 0x0,  5,  6,  7, 0x0),
    gsSP2Triangles( 5,  7,  8, 0x0,  9, 10, 11, 0x0),
    gsSP1Triangle(12, 13, 14, 0x0),
    gsSPVertex(intro_seg7_vertex_07007650, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  1,  3,  2, 0x0),
    gsSP2Triangles( 4,  5,  6, 0x0,  4,  6,  7, 0x0),
    gsSP2Triangles( 8,  9, 10, 0x0,  8, 11,  9, 0x0),
    gsSP1Triangle(12, 13, 14, 0x0),
    gsSPVertex(intro_seg7_vertex_07007740, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  7,  8, 0x0,  9, 10, 11, 0x0),
    gsSP1Triangle(12, 13, 14, 0x0),
    gsSPVertex(intro_seg7_vertex_07007830, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  0,  2, 0x0),
    gsSP2Triangles( 4,  5,  6, 0x0,  4,  7,  5, 0x0),
    gsSP2Triangles( 8,  9, 10, 0x0,  8, 10, 11, 0x0),
    gsSP1Triangle(12, 13, 14, 0x0),
    gsSPVertex(intro_seg7_vertex_07007920, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  7,  8, 0x0,  8,  7,  9, 0x0),
    gsSP2Triangles( 7, 10,  9, 0x0, 11,  6,  8, 0x0),
    gsSP2Triangles(12,  6, 11, 0x0, 13, 14, 15, 0x0),
    gsSPVertex(intro_seg7_vertex_07007A20, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  1,  0, 0x0),
    gsSP2Triangles( 4,  5,  6, 0x0,  5,  7,  6, 0x0),
    gsSP2Triangles( 1,  8,  2, 0x0,  9, 10, 11, 0x0),
    gsSP2Triangles(12, 13, 14, 0x0, 12, 14, 15, 0x0),
    gsSPVertex(intro_seg7_vertex_07007B20, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  0,  3,  1, 0x0),
    gsSP2Triangles( 4,  5,  6, 0x0,  4,  6,  7, 0x0),
    gsSP2Triangles( 8,  9, 10, 0x0, 11, 12, 13, 0x0),
    gsSP1Triangle(14, 12, 11, 0x0),
    gsSPVertex(intro_seg7_vertex_07007C10, 14, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  0,  2, 0x0),
    gsSP2Triangles( 4,  5,  6, 0x0,  6,  5,  7, 0x0),
    gsSP2Triangles( 8,  9, 10, 0x0, 11, 12, 13, 0x0),
    gsSPVertex(intro_seg7_vertex_07007CF0, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  1,  3,  2, 0x0),
    gsSP2Triangles( 4,  1,  0, 0x0,  4,  5,  1, 0x0),
    gsSP2Triangles( 6,  7,  8, 0x0,  9, 10, 11, 0x0),
    gsSP2Triangles(12, 13, 14, 0x0, 12, 14, 15, 0x0),
    gsSPVertex(intro_seg7_vertex_07007DF0, 11, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  0,  3,  1, 0x0),
    gsSP2Triangles( 4,  5,  6, 0x0,  4,  6,  7, 0x0),
    gsSP1Triangle( 8,  9, 10, 0x0),
    gsSPEndDisplayList(),
};

// 0x0700B3A0 - 0x0700B420
const Gfx intro_seg7_dl_0700B3A0[] = {
    gsDPPipeSync(),
    gsDPSetCombineMode(G_CC_MODULATERGB, G_CC_MODULATERGB),
    gsSPClearGeometryMode(G_LIGHTING),
    gsDPSetTile(G_IM_FMT_RGBA, G_IM_SIZ_16b, 0, 0, G_TX_LOADTILE, 0, G_TX_WRAP | G_TX_NOMIRROR, G_TX_NOMASK, G_TX_NOLOD, G_TX_WRAP | G_TX_NOMIRROR, G_TX_NOMASK, G_TX_NOLOD),
    gsSPTexture(0xFFFF, 0xFFFF, 0, G_TX_RENDERTILE, G_ON),
    gsDPTileSync(),
    gsDPSetTile(G_IM_FMT_RGBA, G_IM_SIZ_16b, 8, 0, G_TX_RENDERTILE, 0, G_TX_WRAP | G_TX_NOMIRROR, 5, G_TX_NOLOD, G_TX_WRAP | G_TX_NOMIRROR, 5, G_TX_NOLOD),
    gsDPSetTileSize(0, 0, 0, (32 - 1) << G_TEXTURE_IMAGE_FRAC, (32 - 1) << G_TEXTURE_IMAGE_FRAC),
    gsSPDisplayList(intro_seg7_dl_07008EA0),
    gsSPDisplayList(intro_seg7_dl_07009E38),
    gsSPTexture(0xFFFF, 0xFFFF, 0, G_TX_RENDERTILE, G_OFF),
    gsDPPipeSync(),
    gsDPSetCombineMode(G_CC_SHADE, G_CC_SHADE),
    gsSPDisplayList(intro_seg7_dl_0700ADC0),
    gsSPSetGeometryMode(G_LIGHTING),
    gsSPEndDisplayList(),
};

// 0x0700B420 - 0x0700B460
static const Vtx intro_seg7_vertex_0700B420[] = {
    {{{    96,     42,     -1}, 0, {     0,    512}, {0xff, 0xff, 0xff, 0xff}}},
    {{{   224,     42,     -1}, 0, {  4096,    512}, {0xff, 0xff, 0xff, 0xff}}},
    {{{   224,     58,     -1}, 0, {  4096,      0}, {0xff, 0xff, 0xff, 0xff}}},
    {{{    96,     58,     -1}, 0, {     0,      0}, {0xff, 0xff, 0xff, 0xff}}},
};

// 0x0700B460 - 0x0700B4A0
static const Vtx intro_seg7_vertex_0700B460[] = {
    {{{   268,    180,     -1}, 0, {     0,    512}, {0xff, 0xff, 0xff, 0xff}}},
    {{{   284,    180,     -1}, 0, {   544,    512}, {0xff, 0xff, 0xff, 0xff}}},
    {{{   284,    196,     -1}, 0, {   544,      0}, {0xff, 0xff, 0xff, 0xff}}},
    {{{   268,    196,     -1}, 0, {     0,      0}, {0xff, 0xff, 0xff, 0xff}}},
};

#ifdef VERSION_EU
// 0x0700B4A0 - 0x0700B4A2
ALIGNED8 static const u8 intro_seg7_texture_0700B4A0[] = {
#include "levels/intro/2_eu_copyright.rgba16.inc.c"
};

// 0x0700C4A0 - 0x0700D4A0
ALIGNED8 static const u8 intro_seg7_texture_0700C4A0[] = {
#include "levels/intro/3_eu_tm.rgba16.inc.c"
};

#else
// 0x0700B4A0 - 0x0700B4A2
ALIGNED8 static const u8 intro_seg7_texture_0700B4A0[] = {
#include "levels/intro/2_copyright.rgba16.inc.c"
};

// 0x0700C4A0 - 0x0700D4A0
ALIGNED8 static const u8 intro_seg7_texture_0700C4A0[] = {
#include "levels/intro/3_tm.rgba16.inc.c"
};
#endif

// 0x0700C6A0 - 0x0700C790
const Gfx intro_seg7_dl_0700C6A0[] = {
    gsDPPipeSync(),
    gsDPSetCombineMode(G_CC_DECALFADE, G_CC_DECALFADE),
    gsSPTexture(0xFFFF, 0xFFFF, 0, G_TX_RENDERTILE, G_ON),

    gsDPLoadTextureBlock(intro_seg7_texture_0700B4A0, G_IM_FMT_RGBA, G_IM_SIZ_16b, 128, 16, 0, G_TX_CLAMP, G_TX_CLAMP, 7, 4, G_TX_NOLOD, G_TX_NOLOD),
    gsSPVertex(intro_seg7_vertex_0700B420, 4, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  0,  2,  3, 0x0),

    gsDPLoadTextureBlock(intro_seg7_texture_0700C4A0, G_IM_FMT_RGBA, G_IM_SIZ_16b, 16, 16, 0, G_TX_CLAMP, G_TX_CLAMP, 4, 4, G_TX_NOLOD, G_TX_NOLOD),
    gsSPVertex(intro_seg7_vertex_0700B460, 4, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  0,  2,  3, 0x0),

    gsSPTexture(0xFFFF, 0xFFFF, 0, G_TX_RENDERTILE, G_OFF),
    gsDPPipeSync(),
    gsSPSetGeometryMode(G_LIGHTING),
    gsDPSetCombineMode(G_CC_SHADE, G_CC_SHADE),
    gsDPSetEnvColor(255, 255, 255, 255),
    gsDPSetRenderMode(G_RM_AA_ZB_OPA_SURF, G_RM_AA_ZB_OPA_SURF2),
    gsSPEndDisplayList(),
};

// 0x0700C790
const f32 intro_seg7_table_0700C790[] = {
    0.016000f, 0.052000f, 0.002500f, 0.148300f,
    0.189200f, 0.035200f, 0.471600f, 0.525300f,
    0.116600f, 0.875800f, 0.947000f, 0.222100f,
    1.250500f, 1.341300f, 0.327000f, 1.485400f,
    1.594900f, 0.406500f, 1.230500f, 1.563700f,
    0.464300f, 0.913900f, 1.351300f, 0.520200f,
    1.022900f, 1.216100f, 0.574400f, 1.122300f,
    1.097200f, 0.627000f, 1.028300f, 0.955600f,
    0.678100f, 0.934800f, 1.049400f, 0.727700f,
    0.994200f, 1.005200f, 0.775900f, 1.070200f,
    0.961500f, 0.822900f, 0.995600f, 0.995000f,
    0.868700f, 0.991600f, 1.005700f, 0.913500f,
    1.016500f, 0.985200f, 0.957200f, 0.985200f,
    1.007100f, 1.000000f, 0.999900f, 0.999800f,
    1.010600f, 1.000000f, 1.000000f, 1.000000f,
};

// 0x0700C880
const f32 intro_seg7_table_0700C880[] = {
    1.000000f, 1.000000f, 1.000000f, 0.987300f,
    0.987300f, 0.987300f, 0.951400f, 0.951400f,
    0.951400f, 0.896000f, 0.896000f, 0.896000f,
    0.824600f, 0.824600f, 0.824600f, 0.740700f,
    0.740700f, 0.740700f, 0.648000f, 0.648000f,
    0.648000f, 0.549900f, 0.549900f, 0.549900f,
    0.450100f, 0.450100f, 0.450100f, 0.352000f,
    0.352000f, 0.352000f, 0.259300f, 0.259300f,
    0.259300f, 0.175400f, 0.175400f, 0.175400f,
    0.104000f, 0.104000f, 0.104000f, 0.048600f,
    0.048600f, 0.048600f, 0.012800f, 0.012800f,
    0.012800f, 0.000000f, 0.000000f, 0.000000f,
};
