# SM64 Wii Port
This project is in a very early development stage.
At the moment we're using the SM64 3DS Port as template so you'll find lot of '3DS' files in the src directory.

![Controls](https://raw.githubusercontent.com/PGgamer2/sm64_wii/master/wii-controls.jpg)

Don't compile this, because it will not work.
We first need to:
 * Change the audio library. (`./src/pc/audio/`)
 * Change how graphic is rendered. (`./src/pc/gfx/`)

If you want to contribute, pull requests are accepted.

If you know what are you doing and want to test this yourself then you'll need [devkitPro](https://devkitpro.org/wiki/Getting_Started) and the wii-dev package.
I put a bash script that does everything for you (works on WSL but not on MSYS2). You can run it with `./install-req.sh` (in some cases you could need to run `chmod +x install-req.sh`).
After you compile it, take the `./build/us_wii/boot.dol` file and copy it inside the `./WiiAppTemplate` folder. Then rename the Wii App folder to `sm64_wii_port` and copy it inside your SD Card in the `apps` directory.

## Project Structure

```
sm64_wii
├── actors: object behaviors, geo layout, and display lists
├── asm: handwritten assembly code, rom header
│   └── non_matchings: asm for non-matching sections
├── assets: animation and demo data
│   ├── anims: animation data
│   └── demos: demo data
├── bin: asm files for ordering display lists and textures
├── build: output directory
├── data: behavior scripts, misc. data
├── doxygen: documentation infrastructure
├── enhancements: example source modifications
├── include: header files
├── levels: level scripts, geo layout, and display lists
├── lib: SDK library code
├── sound: sequences, sound samples, and sound banks
├── src: C source code for game
│   ├── audio: audio code
│   ├── buffers: stacks, heaps, and task buffers
│   ├── engine: script processing engines and utils
│   ├── game: behaviors and rest of game source
│   ├── goddard: Mario intro screen
│   └── menu: title screen and file, act, and debug level selection menus
├── text: dialog, level names, act names
├── textures: skybox and generic texture data
├── tools: build tools
└── WiiAppTemplate: A template for the Wii app.
```