// 0x0700BC68 - 0x0700BC80
static const Lights1 bbh_seg7_lights_0700BC68 = gdSPDefLights1(
    0x20, 0x20, 0x20,
    0x50, 0x50, 0x50, 0x28, 0x28, 0x28
);

// 0x0700BC80 - 0x0700BC98
static const Lights1 bbh_seg7_lights_0700BC80 = gdSPDefLights1(
    0x66, 0x66, 0x66,
    0xff, 0xff, 0xff, 0x28, 0x28, 0x28
);

// 0x0700BC98 - 0x0700BD18
static const Vtx bbh_seg7_vertex_0700BC98[] = {
    {{{ -2098,      0,   1126}, 0, {   990,    990}, {0x00, 0x7f, 0x00, 0xff}}},
    {{{ -1945,      0,   1075}, 0, {   478,      0}, {0x00, 0x7f, 0x00, 0xff}}},
    {{{ -2098,      0,   1075}, 0, {   478,    990}, {0x00, 0x7f, 0x00, 0xff}}},
    {{{ -1945,      0,   1126}, 0, {   990,      0}, {0x00, 0x7f, 0x00, 0xff}}},
    {{{  -101,      0,   1536}, 0, {     0,    990}, {0x00, 0x7f, 0x00, 0xff}}},
    {{{   -50,      0,   1382}, 0, {   478,      0}, {0x00, 0x7f, 0x00, 0xff}}},
    {{{  -101,      0,   1382}, 0, {     0,      0}, {0x00, 0x7f, 0x00, 0xff}}},
    {{{   -50,      0,   1536}, 0, {   478,    990}, {0x00, 0x7f, 0x00, 0xff}}},
};

// 0x0700BD18 - 0x0700BE18
static const Vtx bbh_seg7_vertex_0700BD18[] = {
    {{{  -101,    717,   2048}, 0, {   334,    990}, {0x00, 0x81, 0x00, 0xff}}},
    {{{  -818,    717,   2048}, 0, {   334,    650}, {0x00, 0x81, 0x00, 0xff}}},
    {{{  -101,    717,   1126}, 0, {   990,    990}, {0x00, 0x81, 0x00, 0xff}}},
    {{{ -1330,    717,   1638}, 0, {   626,    406}, {0x00, 0x81, 0x00, 0xff}}},
    {{{ -1330,    717,   1126}, 0, {   990,    406}, {0x00, 0x81, 0x00, 0xff}}},
    {{{  -818,    717,   2048}, 0, {   332,    650}, {0x00, 0x81, 0x00, 0xff}}},
    {{{ -2252,    819,   2048}, 0, {   334,      0}, {0x00, 0x81, 0x00, 0xff}}},
    {{{ -1842,    819,   2150}, 0, {   260,    162}, {0x00, 0x81, 0x00, 0xff}}},
    {{{ -2047,    819,   2355}, 0, {   114,     66}, {0x00, 0x81, 0x00, 0xff}}},
    {{{ -2252,    819,   1126}, 0, {   990,      0}, {0x00, 0x81, 0x00, 0xff}}},
    {{{ -1842,    819,   1126}, 0, {   990,    162}, {0x00, 0x81, 0x00, 0xff}}},
    {{{ -2252,   1638,   2048}, 0, {   334,      0}, {0x00, 0x81, 0x00, 0xff}}},
    {{{  -818,   1638,   2048}, 0, {   334,    650}, {0x00, 0x81, 0x00, 0xff}}},
    {{{ -1228,   1638,   2560}, 0, {     0,    454}, {0x00, 0x81, 0x00, 0xff}}},
    {{{  -818,   1638,   1126}, 0, {   990,    650}, {0x00, 0x81, 0x00, 0xff}}},
    {{{ -1842,   1638,   2560}, 0, {     0,    162}, {0x00, 0x81, 0x00, 0xff}}},
};

// 0x0700BE18 - 0x0700BEF8
static const Vtx bbh_seg7_vertex_0700BE18[] = {
    {{{ -2252,   1638,   2048}, 0, {   334,      0}, {0x00, 0x81, 0x00, 0xff}}},
    {{{ -2252,   1638,   1126}, 0, {   990,      0}, {0x00, 0x81, 0x00, 0xff}}},
    {{{  -818,   1638,   1126}, 0, {   990,    650}, {0x00, 0x81, 0x00, 0xff}}},
    {{{  -101,    256,   1382}, 0, {     0,    990}, {0x00, 0x81, 0x00, 0xff}}},
    {{{   -50,    256,   1382}, 0, {   480,    990}, {0x00, 0x81, 0x00, 0xff}}},
    {{{   -50,    256,   1536}, 0, {   480,      0}, {0x00, 0x81, 0x00, 0xff}}},
    {{{ -1945,    256,   1075}, 0, {   478,    990}, {0x00, 0x81, 0x00, 0xff}}},
    {{{ -2098,    256,   1126}, 0, {   990,      0}, {0x00, 0x81, 0x00, 0xff}}},
    {{{ -2098,    256,   1075}, 0, {   478,      0}, {0x00, 0x81, 0x00, 0xff}}},
    {{{ -1945,    256,   1126}, 0, {   990,    990}, {0x00, 0x81, 0x00, 0xff}}},
    {{{ -1893,   1280,   1075}, 0, {   480,      0}, {0x00, 0x81, 0x00, 0xff}}},
    {{{ -1893,   1280,   1126}, 0, {     0,      0}, {0x00, 0x81, 0x00, 0xff}}},
    {{{ -2047,   1280,   1126}, 0, {     0,    990}, {0x00, 0x81, 0x00, 0xff}}},
    {{{ -2047,   1280,   1075}, 0, {   480,    990}, {0x00, 0x81, 0x00, 0xff}}},
};

// 0x0700BEF8 - 0x0700BFD8
static const Vtx bbh_seg7_vertex_0700BEF8[] = {
    {{{  -101,    256,   1536}, 0, {   990,      0}, {0x00, 0x00, 0x81, 0xff}}},
    {{{   -50,    256,   1536}, 0, {   480,      0}, {0x00, 0x00, 0x81, 0xff}}},
    {{{   -50,      0,   1536}, 0, {   480,    990}, {0x00, 0x00, 0x81, 0xff}}},
    {{{  -101,      0,   1536}, 0, {   990,    990}, {0x00, 0x00, 0x81, 0xff}}},
    {{{  -818,   1075,   1485}, 0, {   990,      0}, {0x00, 0x00, 0x81, 0xff}}},
    {{{  -767,    819,   1485}, 0, {   478,    990}, {0x00, 0x00, 0x81, 0xff}}},
    {{{  -818,    819,   1485}, 0, {   990,    990}, {0x00, 0x00, 0x81, 0xff}}},
    {{{  -101,    256,   1382}, 0, {     0,    990}, {0x00, 0x81, 0x00, 0xff}}},
    {{{   -50,    256,   1536}, 0, {   480,      0}, {0x00, 0x81, 0x00, 0xff}}},
    {{{  -101,    256,   1536}, 0, {     0,      0}, {0x00, 0x81, 0x00, 0xff}}},
    {{{   -50,    256,   1382}, 0, {   480,      0}, {0x00, 0x00, 0x7f, 0xff}}},
    {{{  -101,      0,   1382}, 0, {     0,    990}, {0x00, 0x00, 0x7f, 0xff}}},
    {{{   -50,      0,   1382}, 0, {   480,    990}, {0x00, 0x00, 0x7f, 0xff}}},
    {{{  -101,    256,   1382}, 0, {     0,      0}, {0x00, 0x00, 0x7f, 0xff}}},
};

// 0x0700BFD8 - 0x0700C088
static const Vtx bbh_seg7_vertex_0700BFD8[] = {
    {{{  -767,   1075,   1331}, 0, {   480,      0}, {0x00, 0x00, 0x7f, 0xff}}},
    {{{  -818,   1075,   1331}, 0, {     0,      0}, {0x00, 0x00, 0x7f, 0xff}}},
    {{{  -818,    819,   1331}, 0, {     0,    990}, {0x00, 0x00, 0x7f, 0xff}}},
    {{{  -767,    819,   1331}, 0, {   480,    990}, {0x00, 0x00, 0x7f, 0xff}}},
    {{{  -818,   1075,   1485}, 0, {   990,      0}, {0x00, 0x00, 0x81, 0xff}}},
    {{{  -767,   1075,   1485}, 0, {   478,      0}, {0x00, 0x00, 0x81, 0xff}}},
    {{{  -767,    819,   1485}, 0, {   478,    990}, {0x00, 0x00, 0x81, 0xff}}},
    {{{  -818,   1075,   1331}, 0, {     0,    990}, {0x00, 0x81, 0x00, 0xff}}},
    {{{  -767,   1075,   1331}, 0, {   480,    990}, {0x00, 0x81, 0x00, 0xff}}},
    {{{  -767,   1075,   1485}, 0, {   480,      0}, {0x00, 0x81, 0x00, 0xff}}},
    {{{  -818,   1075,   1485}, 0, {     0,      0}, {0x00, 0x81, 0x00, 0xff}}},
};

// 0x0700C088 - 0x0700C188
static const Vtx bbh_seg7_vertex_0700C088[] = {
    {{{ -1330,    819,   1638}, 0, {     0,      0}, {0xb1, 0x00, 0x63, 0xff}}},
    {{{ -1330,    717,   1638}, 0, {     0,    990}, {0xb1, 0x00, 0x63, 0xff}}},
    {{{  -818,    717,   2048}, 0, {  4330,    990}, {0xb1, 0x00, 0x63, 0xff}}},
    {{{  -818,    819,   2048}, 0, {  4330,      0}, {0xb1, 0x00, 0x63, 0xff}}},
    {{{ -1330,    819,   1638}, 0, {   990,      0}, {0x81, 0x00, 0x00, 0xff}}},
    {{{ -1330,    717,   1126}, 0, { -2414,    990}, {0x81, 0x00, 0x00, 0xff}}},
    {{{ -1330,    717,   1638}, 0, {   990,    990}, {0x81, 0x00, 0x00, 0xff}}},
    {{{ -1330,    819,   1126}, 0, { -2414,      0}, {0x81, 0x00, 0x00, 0xff}}},
    {{{ -2047,   1024,   2355}, 0, {  -158,      0}, {0x59, 0x00, 0x59, 0xff}}},
    {{{ -2047,    819,   2355}, 0, {  -158,    990}, {0x59, 0x00, 0x59, 0xff}}},
    {{{ -1842,   1024,   2150}, 0, {   990,      0}, {0x59, 0x00, 0x59, 0xff}}},
    {{{ -1842,    819,   2150}, 0, {   990,    990}, {0x59, 0x00, 0x59, 0xff}}},
    {{{ -1842,    819,   1126}, 0, {  5078,    990}, {0x7f, 0x00, 0x00, 0xff}}},
    {{{ -1842,   1024,   1126}, 0, {  5078,      0}, {0x7f, 0x00, 0x00, 0xff}}},
    {{{ -1842,   1024,   2150}, 0, {     0,      0}, {0x7f, 0x00, 0x00, 0xff}}},
    {{{ -1842,    819,   2150}, 0, {     0,    990}, {0x7f, 0x00, 0x00, 0xff}}},
};

// 0x0700C188 - 0x0700C268
static const Vtx bbh_seg7_vertex_0700C188[] = {
    {{{ -1279,   1382,   1126}, 0, {  2268,   1372}, {0x00, 0x00, 0x7f, 0xff}}},
    {{{  -818,   1638,   1126}, 0, {  4566,   2012}, {0x00, 0x00, 0x7f, 0xff}}},
    {{{ -2252,   1638,   1126}, 0, { -2584,   2012}, {0x00, 0x00, 0x7f, 0xff}}},
    {{{  -869,   1382,   1126}, 0, {  4312,   1372}, {0x00, 0x00, 0x7f, 0xff}}},
    {{{  -818,    819,   1126}, 0, {  4566,      0}, {0x00, 0x00, 0x7f, 0xff}}},
    {{{  -869,    922,   1126}, 0, {  4312,    224}, {0x00, 0x00, 0x7f, 0xff}}},
    {{{ -1279,    922,   1126}, 0, {  2268,    224}, {0x00, 0x00, 0x7f, 0xff}}},
    {{{ -1842,    819,   1126}, 0, {  -540,      0}, {0x00, 0x00, 0x7f, 0xff}}},
    {{{ -1228,   1638,   2560}, 0, {     0,   2012}, {0x9d, 0x00, 0xb1, 0xff}}},
    {{{  -818,    819,   2048}, 0, { -2074,      0}, {0x9d, 0x00, 0xb1, 0xff}}},
    {{{ -1228,    819,   2560}, 0, {     0,      0}, {0x9d, 0x00, 0xb1, 0xff}}},
    {{{  -818,   1638,   2048}, 0, { -3606,   2012}, {0x81, 0x00, 0x00, 0xff}}},
    {{{  -818,   1075,   1485}, 0, {  -796,    608}, {0x81, 0x00, 0x00, 0xff}}},
    {{{  -818,    819,   2048}, 0, { -3606,      0}, {0x81, 0x00, 0x00, 0xff}}},
};

// 0x0700C268 - 0x0700C358
static const Vtx bbh_seg7_vertex_0700C268[] = {
    {{{ -2252,   1638,   2048}, 0, { -3606,   2012}, {0x7f, 0x00, 0x00, 0xff}}},
    {{{ -2252,    819,   2048}, 0, { -3606,      0}, {0x7f, 0x00, 0x00, 0xff}}},
    {{{ -2252,    819,   1126}, 0, {   990,      0}, {0x7f, 0x00, 0x00, 0xff}}},
    {{{ -2252,   1638,   1126}, 0, {   990,   2012}, {0x7f, 0x00, 0x00, 0xff}}},
    {{{ -2252,      0,   1126}, 0, {   990,   2012}, {0x7f, 0x00, 0x00, 0xff}}},
    {{{ -2252,      0,   2048}, 0, { -3606,   2012}, {0x7f, 0x00, 0x00, 0xff}}},
    {{{ -1228,   1638,   2560}, 0, {     0,   2012}, {0x9d, 0x00, 0xb1, 0xff}}},
    {{{  -818,   1638,   2048}, 0, { -2074,   2012}, {0x9d, 0x00, 0xb1, 0xff}}},
    {{{  -818,    819,   2048}, 0, { -2074,      0}, {0x9d, 0x00, 0xb1, 0xff}}},
    {{{  -818,      0,   2048}, 0, { -2074,   2012}, {0x9d, 0x00, 0xb1, 0xff}}},
    {{{ -1228,    819,   2560}, 0, {     0,      0}, {0x9d, 0x00, 0xb1, 0xff}}},
    {{{ -1228,      0,   2560}, 0, {     0,   2012}, {0x9d, 0x00, 0xb1, 0xff}}},
    {{{ -1228,    819,   2560}, 0, {     0,      0}, {0x00, 0x00, 0x81, 0xff}}},
    {{{ -1228,      0,   2560}, 0, {     0,   2012}, {0x00, 0x00, 0x81, 0xff}}},
    {{{ -1842,      0,   2560}, 0, {  3034,   2012}, {0x00, 0x00, 0x81, 0xff}}},
};

// 0x0700C358 - 0x0700C458
static const Vtx bbh_seg7_vertex_0700C358[] = {
    {{{ -1842,   1638,   2560}, 0, {  3034,   2012}, {0x00, 0x00, 0x81, 0xff}}},
    {{{ -1228,   1638,   2560}, 0, {     0,   2012}, {0x00, 0x00, 0x81, 0xff}}},
    {{{ -1228,    819,   2560}, 0, {     0,      0}, {0x00, 0x00, 0x81, 0xff}}},
    {{{ -1842,    819,   2560}, 0, {  3034,      0}, {0x00, 0x00, 0x81, 0xff}}},
    {{{ -1842,      0,   2560}, 0, {  3034,   2012}, {0x00, 0x00, 0x81, 0xff}}},
    {{{ -2252,   1638,   2048}, 0, {  5078,   2012}, {0x63, 0x00, 0xb1, 0xff}}},
    {{{ -1842,    819,   2560}, 0, {  3034,      0}, {0x63, 0x00, 0xb1, 0xff}}},
    {{{ -2252,    819,   2048}, 0, {  5078,      0}, {0x63, 0x00, 0xb1, 0xff}}},
    {{{ -1842,   1638,   2560}, 0, {  3034,   2012}, {0x63, 0x00, 0xb1, 0xff}}},
    {{{ -1842,    819,   2560}, 0, {     0,      0}, {0x63, 0x00, 0xb1, 0xff}}},
    {{{ -1842,      0,   2560}, 0, {     0,   2012}, {0x63, 0x00, 0xb1, 0xff}}},
    {{{ -2252,      0,   2048}, 0, {  3240,   2012}, {0x63, 0x00, 0xb1, 0xff}}},
    {{{ -2252,    819,   2048}, 0, {  3240,      0}, {0x63, 0x00, 0xb1, 0xff}}},
    {{{ -2252,   1024,   1126}, 0, { -2584,    480}, {0x00, 0x00, 0x7f, 0xff}}},
    {{{ -2047,   1024,   1126}, 0, { -1562,    480}, {0x00, 0x00, 0x7f, 0xff}}},
    {{{ -2252,   1638,   1126}, 0, { -2584,   2012}, {0x00, 0x00, 0x7f, 0xff}}},
};

// 0x0700C458 - 0x0700C548
static const Vtx bbh_seg7_vertex_0700C458[] = {
    {{{ -2047,   1024,   1126}, 0, { -1562,    480}, {0x00, 0x00, 0x7f, 0xff}}},
    {{{ -2047,   1280,   1126}, 0, { -1562,   1116}, {0x00, 0x00, 0x7f, 0xff}}},
    {{{ -2252,   1638,   1126}, 0, { -2584,   2012}, {0x00, 0x00, 0x7f, 0xff}}},
    {{{ -1893,   1280,   1126}, 0, {  -796,   1116}, {0x00, 0x00, 0x7f, 0xff}}},
    {{{ -1279,   1382,   1126}, 0, {  2268,   1372}, {0x00, 0x00, 0x7f, 0xff}}},
    {{{ -1893,   1024,   1126}, 0, {  -796,    480}, {0x00, 0x00, 0x7f, 0xff}}},
    {{{ -1842,    819,   1126}, 0, {  -540,      0}, {0x00, 0x00, 0x7f, 0xff}}},
    {{{ -1279,    922,   1126}, 0, {  2268,    224}, {0x00, 0x00, 0x7f, 0xff}}},
    {{{  -818,    717,   1126}, 0, {  7122,    224}, {0x00, 0x00, 0x7f, 0xff}}},
    {{{  -818,    819,   1126}, 0, {  7122,      0}, {0x00, 0x00, 0x7f, 0xff}}},
    {{{ -2252,    819,   1126}, 0, {     0,      0}, {0x00, 0x00, 0x7f, 0xff}}},
    {{{ -2098,    256,   1126}, 0, {   734,   1372}, {0x00, 0x00, 0x7f, 0xff}}},
    {{{ -1945,    256,   1126}, 0, {  1502,   1372}, {0x00, 0x00, 0x7f, 0xff}}},
    {{{ -2252,      0,   1126}, 0, {     0,   2012}, {0x00, 0x00, 0x7f, 0xff}}},
    {{{ -2098,      0,   1126}, 0, {   734,   2012}, {0x00, 0x00, 0x7f, 0xff}}},
};

// 0x0700C548 - 0x0700C648
static const Vtx bbh_seg7_vertex_0700C548[] = {
    {{{ -1945,      0,   1126}, 0, {  1502,   2012}, {0x00, 0x00, 0x7f, 0xff}}},
    {{{  -101,    717,   1126}, 0, { 10700,    224}, {0x00, 0x00, 0x7f, 0xff}}},
    {{{ -1945,    256,   1126}, 0, {  1502,   1372}, {0x00, 0x00, 0x7f, 0xff}}},
    {{{ -1893,   1280,   1126}, 0, {  -796,   1116}, {0x00, 0x00, 0x7f, 0xff}}},
    {{{ -1279,    922,   1126}, 0, {  2266,    224}, {0x00, 0x00, 0x7f, 0xff}}},
    {{{ -1279,   1382,   1126}, 0, {  2268,   1372}, {0x00, 0x00, 0x7f, 0xff}}},
    {{{  -818,   1075,   1331}, 0, {     0,    608}, {0x81, 0x00, 0x00, 0xff}}},
    {{{  -818,   1075,   1485}, 0, {  -796,    608}, {0x81, 0x00, 0x00, 0xff}}},
    {{{  -818,   1638,   2048}, 0, { -3606,   2012}, {0x81, 0x00, 0x00, 0xff}}},
    {{{  -818,    717,   2048}, 0, { -2074,    224}, {0x00, 0x00, 0x81, 0xff}}},
    {{{  -101,      0,   2048}, 0, { -5650,   2012}, {0x00, 0x00, 0x81, 0xff}}},
    {{{  -818,      0,   2048}, 0, { -2074,   2012}, {0x00, 0x00, 0x81, 0xff}}},
    {{{  -818,    819,   1485}, 0, {  -796,      0}, {0x81, 0x00, 0x00, 0xff}}},
    {{{  -818,    819,   2048}, 0, { -3606,      0}, {0x81, 0x00, 0x00, 0xff}}},
    {{{  -818,   1638,   1126}, 0, {   990,   2012}, {0x81, 0x00, 0x00, 0xff}}},
    {{{  -818,    819,   1126}, 0, {   990,      0}, {0x81, 0x00, 0x00, 0xff}}},
};

// 0x0700C648 - 0x0700C748
static const Vtx bbh_seg7_vertex_0700C648[] = {
    {{{  -818,    819,   1126}, 0, {   990,      0}, {0x81, 0x00, 0x00, 0xff}}},
    {{{  -818,    819,   1331}, 0, {     0,      0}, {0x81, 0x00, 0x00, 0xff}}},
    {{{  -818,   1075,   1331}, 0, {     0,    608}, {0x81, 0x00, 0x00, 0xff}}},
    {{{ -1945,      0,   1126}, 0, {  1502,   2012}, {0x00, 0x00, 0x7f, 0xff}}},
    {{{  -101,      0,   1126}, 0, { 10700,   2012}, {0x00, 0x00, 0x7f, 0xff}}},
    {{{  -101,    717,   1126}, 0, { 10700,    224}, {0x00, 0x00, 0x7f, 0xff}}},
    {{{  -818,    717,   2048}, 0, { -2074,    224}, {0x00, 0x00, 0x81, 0xff}}},
    {{{  -101,    717,   2048}, 0, { -5650,    224}, {0x00, 0x00, 0x81, 0xff}}},
    {{{  -101,      0,   2048}, 0, { -5650,   2012}, {0x00, 0x00, 0x81, 0xff}}},
    {{{  -818,    717,   1126}, 0, {  7122,    224}, {0x00, 0x00, 0x7f, 0xff}}},
    {{{ -1945,    256,   1126}, 0, {  1502,   1372}, {0x00, 0x00, 0x7f, 0xff}}},
    {{{  -101,    256,   1382}, 0, {  -286,   1372}, {0x81, 0x00, 0x00, 0xff}}},
    {{{  -101,    717,   2048}, 0, { -3606,    224}, {0x81, 0x00, 0x00, 0xff}}},
    {{{  -101,    717,   1126}, 0, {   990,    224}, {0x81, 0x00, 0x00, 0xff}}},
    {{{  -101,    256,   1536}, 0, { -1052,   1372}, {0x81, 0x00, 0x00, 0xff}}},
    {{{  -101,      0,   1382}, 0, {  -286,   2012}, {0x81, 0x00, 0x00, 0xff}}},
};

// 0x0700C748 - 0x0700C838
static const Vtx bbh_seg7_vertex_0700C748[] = {
    {{{  -101,    717,   2048}, 0, { -3606,    224}, {0x81, 0x00, 0x00, 0xff}}},
    {{{  -101,      0,   1536}, 0, { -1052,   2012}, {0x81, 0x00, 0x00, 0xff}}},
    {{{  -101,      0,   2048}, 0, { -3606,   2012}, {0x81, 0x00, 0x00, 0xff}}},
    {{{  -101,    256,   1536}, 0, { -1052,   1372}, {0x81, 0x00, 0x00, 0xff}}},
    {{{  -101,      0,   1382}, 0, {  -286,   2012}, {0x81, 0x00, 0x00, 0xff}}},
    {{{  -101,    717,   1126}, 0, {   990,    224}, {0x81, 0x00, 0x00, 0xff}}},
    {{{  -101,      0,   1126}, 0, {   990,   2012}, {0x81, 0x00, 0x00, 0xff}}},
    {{{ -2252,      0,   2048}, 0, {  3240,   2012}, {0xf5, 0x00, 0x82, 0xff}}},
    {{{ -2068,    256,   2032}, 0, {  2728,   1244}, {0xf5, 0x00, 0x82, 0xff}}},
    {{{ -2068,      0,   2032}, 0, {  2728,   2012}, {0xf5, 0x00, 0x82, 0xff}}},
    {{{ -2252,    256,   2048}, 0, {  3240,   1244}, {0xf5, 0x00, 0x82, 0xff}}},
    {{{ -1786,      0,   2384}, 0, {   478,   2012}, {0x79, 0x00, 0x26, 0xff}}},
    {{{ -1842,    256,   2560}, 0, {     0,   1244}, {0x79, 0x00, 0x26, 0xff}}},
    {{{ -1842,      0,   2560}, 0, {     0,   2012}, {0x79, 0x00, 0x26, 0xff}}},
    {{{ -1786,    256,   2384}, 0, {   478,   1244}, {0x79, 0x00, 0x26, 0xff}}},
};

// 0x0700C838 - 0x0700C878
static const Vtx bbh_seg7_vertex_0700C838[] = {
    {{{ -1842,    256,   2560}, 0, {   990,   2012}, {0x00, 0x7f, 0x00, 0xff}}},
    {{{ -1786,    256,   2384}, 0, {     0,   1696}, {0x00, 0x7f, 0x00, 0xff}}},
    {{{ -2068,    256,   2032}, 0, {     0,    312}, {0x00, 0x7f, 0x00, 0xff}}},
    {{{ -2252,    256,   2048}, 0, {   990,      0}, {0x00, 0x7f, 0x00, 0xff}}},
};

// 0x0700C878 - 0x0700C978
static const Vtx bbh_seg7_vertex_0700C878[] = {
    {{{ -2047,   1280,   1126}, 0, {     0,      0}, {0x7f, 0x00, 0x00, 0xff}}},
    {{{ -2047,   1024,   1126}, 0, {     0,   2012}, {0x7f, 0x00, 0x00, 0xff}}},
    {{{ -2047,   1024,   1075}, 0, {   480,   2012}, {0x7f, 0x00, 0x00, 0xff}}},
    {{{ -2098,    256,   1126}, 0, {   990,      0}, {0x7f, 0x00, 0x00, 0xff}}},
    {{{ -2098,      0,   1126}, 0, {   990,   2012}, {0x7f, 0x00, 0x00, 0xff}}},
    {{{ -2098,      0,   1075}, 0, {   478,   2012}, {0x7f, 0x00, 0x00, 0xff}}},
    {{{ -2098,    256,   1075}, 0, {   478,      0}, {0x7f, 0x00, 0x00, 0xff}}},
    {{{ -1945,      0,   1075}, 0, {   478,   2012}, {0x81, 0x00, 0x00, 0xff}}},
    {{{ -1945,    256,   1126}, 0, {   990,      0}, {0x81, 0x00, 0x00, 0xff}}},
    {{{ -1945,    256,   1075}, 0, {   478,      0}, {0x81, 0x00, 0x00, 0xff}}},
    {{{ -1945,      0,   1126}, 0, {   990,   2012}, {0x81, 0x00, 0x00, 0xff}}},
    {{{ -1893,   1024,   1075}, 0, {   480,   2012}, {0x81, 0x00, 0x00, 0xff}}},
    {{{ -1893,   1024,   1126}, 0, {   990,   2012}, {0x81, 0x00, 0x00, 0xff}}},
    {{{ -1893,   1280,   1126}, 0, {   990,      0}, {0x81, 0x00, 0x00, 0xff}}},
    {{{ -1893,   1280,   1075}, 0, {   480,      0}, {0x81, 0x00, 0x00, 0xff}}},
    {{{ -2047,   1280,   1075}, 0, {   480,      0}, {0x7f, 0x00, 0x00, 0xff}}},
};

// 0x0700C978 - 0x0700C9B8
static const Vtx bbh_seg7_vertex_0700C978[] = {
    {{{ -2068,      0,   2032}, 0, {  3034,   2012}, {0x63, 0x00, 0xb1, 0xff}}},
    {{{ -2068,    256,   2032}, 0, {  3034,      0}, {0x63, 0x00, 0xb1, 0xff}}},
    {{{ -1786,    256,   2384}, 0, {     0,      0}, {0x63, 0x00, 0xb1, 0xff}}},
    {{{ -1786,      0,   2384}, 0, {     0,   2012}, {0x63, 0x00, 0xb1, 0xff}}},
};

// 0x0700C9B8 - 0x0700CAA8
static const Vtx bbh_seg7_vertex_0700C9B8[] = {
    {{{ -2252,      0,   1126}, 0, { -7180,  -5142}, {0x00, 0x7f, 0x00, 0xff}}},
    {{{  -818,      0,   2048}, 0, {  7120,   4054}, {0x00, 0x7f, 0x00, 0xff}}},
    {{{  -101,      0,   1126}, 0, { 14276,  -5142}, {0x00, 0x7f, 0x00, 0xff}}},
    {{{ -2252,      0,   2048}, 0, { -7180,   4054}, {0x00, 0x7f, 0x00, 0xff}}},
    {{{ -1842,      0,   2560}, 0, { -3092,   9164}, {0x00, 0x7f, 0x00, 0xff}}},
    {{{ -1228,      0,   2560}, 0, {  3032,   9164}, {0x00, 0x7f, 0x00, 0xff}}},
    {{{  -101,      0,   2048}, 0, { 14276,   4054}, {0x00, 0x7f, 0x00, 0xff}}},
    {{{ -2047,   1024,   1126}, 0, { -1052,      0}, {0x00, 0x7f, 0x00, 0xff}}},
    {{{ -1893,   1024,   1126}, 0, { -1052,  -1566}, {0x00, 0x7f, 0x00, 0xff}}},
    {{{ -1893,   1024,   1075}, 0, { -1560,  -1566}, {0x00, 0x7f, 0x00, 0xff}}},
    {{{ -1842,   1024,   1126}, 0, { -1052,  -2076}, {0x00, 0x7f, 0x00, 0xff}}},
    {{{ -2252,   1024,   2048}, 0, {  8144,   2010}, {0x00, 0x7f, 0x00, 0xff}}},
    {{{ -2047,   1024,   2355}, 0, { 11212,      0}, {0x00, 0x7f, 0x00, 0xff}}},
    {{{ -1842,   1024,   2150}, 0, {  9168,  -2076}, {0x00, 0x7f, 0x00, 0xff}}},
    {{{ -2252,   1024,   1126}, 0, { -1052,   2010}, {0x00, 0x7f, 0x00, 0xff}}},
};

// 0x0700CAA8 - 0x0700CB58
static const Vtx bbh_seg7_vertex_0700CAA8[] = {
    {{{ -1330,    819,   1126}, 0, { -2072,      0}, {0x00, 0x7f, 0x00, 0xff}}},
    {{{ -1330,    819,   1638}, 0, { -2072,   5076}, {0x00, 0x7f, 0x00, 0xff}}},
    {{{  -818,    819,   2048}, 0, {  3036,   9164}, {0x00, 0x7f, 0x00, 0xff}}},
    {{{  -818,    819,   1126}, 0, {  3032,      0}, {0x00, 0x7f, 0x00, 0xff}}},
    {{{ -2047,   1024,   1126}, 0, { -1052,      0}, {0x00, 0x7f, 0x00, 0xff}}},
    {{{ -1893,   1024,   1075}, 0, { -1560,  -1566}, {0x00, 0x7f, 0x00, 0xff}}},
    {{{ -2047,   1024,   1075}, 0, { -1560,      0}, {0x00, 0x7f, 0x00, 0xff}}},
    {{{  -818,    819,   1485}, 0, {  3032,   3542}, {0x00, 0x7f, 0x00, 0xff}}},
    {{{  -767,    819,   1331}, 0, {  3544,   2010}, {0x00, 0x7f, 0x00, 0xff}}},
    {{{  -818,    819,   1331}, 0, {  3032,   2010}, {0x00, 0x7f, 0x00, 0xff}}},
    {{{  -767,    819,   1485}, 0, {  3544,   3542}, {0x00, 0x7f, 0x00, 0xff}}},
};

// 0x0700CB58 - 0x0700CCB0
static const Gfx bbh_seg7_dl_0700CB58[] = {
    gsDPSetTextureImage(G_IM_FMT_RGBA, G_IM_SIZ_16b, 1, spooky_09008800),
    gsDPLoadSync(),
    gsDPLoadBlock(G_TX_LOADTILE, 0, 0, 32 * 32 - 1, CALC_DXT(32, G_IM_SIZ_16b_BYTES)),
    gsSPLight(&bbh_seg7_lights_0700BC68.l, 1),
    gsSPLight(&bbh_seg7_lights_0700BC68.a, 2),
    gsSPVertex(bbh_seg7_vertex_0700BC98, 8, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  0,  3,  1, 0x0),
    gsSP2Triangles( 4,  5,  6, 0x0,  4,  7,  5, 0x0),
    gsSPLight(&bbh_seg7_lights_0700BC80.l, 1),
    gsSPLight(&bbh_seg7_lights_0700BC80.a, 2),
    gsSPVertex(bbh_seg7_vertex_0700BD18, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  2,  3,  4, 0x0),
    gsSP2Triangles( 2,  5,  3, 0x0,  6,  7,  8, 0x0),
    gsSP2Triangles( 6,  9, 10, 0x0,  6, 10,  7, 0x0),
    gsSP2Triangles(11, 12, 13, 0x0, 11, 14, 12, 0x0),
    gsSP1Triangle(11, 13, 15, 0x0),
    gsSPVertex(bbh_seg7_vertex_0700BE18, 14, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  7,  8, 0x0,  6,  9,  7, 0x0),
    gsSP2Triangles(10, 11, 12, 0x0, 10, 12, 13, 0x0),
    gsSPVertex(bbh_seg7_vertex_0700BEF8, 14, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  0,  2,  3, 0x0),
    gsSP2Triangles( 4,  5,  6, 0x0,  7,  8,  9, 0x0),
    gsSP2Triangles(10, 11, 12, 0x0, 10, 13, 11, 0x0),
    gsSPVertex(bbh_seg7_vertex_0700BFD8, 11, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  0,  2,  3, 0x0),
    gsSP2Triangles( 4,  5,  6, 0x0,  7,  8,  9, 0x0),
    gsSP1Triangle( 7,  9, 10, 0x0),
    gsSPEndDisplayList(),
};

// 0x0700CCB0 - 0x0700CD18
static const Gfx bbh_seg7_dl_0700CCB0[] = {
    gsDPSetTextureImage(G_IM_FMT_RGBA, G_IM_SIZ_16b, 1, spooky_09004800),
    gsDPLoadSync(),
    gsDPLoadBlock(G_TX_LOADTILE, 0, 0, 32 * 32 - 1, CALC_DXT(32, G_IM_SIZ_16b_BYTES)),
    gsSPVertex(bbh_seg7_vertex_0700C088, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  0,  2,  3, 0x0),
    gsSP2Triangles( 4,  5,  6, 0x0,  4,  7,  5, 0x0),
    gsSP2Triangles( 8,  9, 10, 0x0,  9, 11, 10, 0x0),
    gsSP2Triangles(12, 13, 14, 0x0, 12, 14, 15, 0x0),
    gsSPEndDisplayList(),
};

// 0x0700CD18 - 0x0700CF40
static const Gfx bbh_seg7_dl_0700CD18[] = {
    gsDPSetTextureImage(G_IM_FMT_RGBA, G_IM_SIZ_16b, 1, bbh_seg7_texture_07000000),
    gsDPLoadSync(),
    gsDPLoadBlock(G_TX_LOADTILE, 0, 0, 32 * 64 - 1, CALC_DXT(32, G_IM_SIZ_16b_BYTES)),
    gsSPVertex(bbh_seg7_vertex_0700C188, 14, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  0,  3,  1, 0x0),
    gsSP2Triangles( 3,  4,  1, 0x0,  3,  5,  4, 0x0),
    gsSP2Triangles( 5,  6,  4, 0x0,  6,  7,  4, 0x0),
    gsSP2Triangles( 8,  9, 10, 0x0, 11, 12, 13, 0x0),
    gsSPVertex(bbh_seg7_vertex_0700C268, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  0,  2,  3, 0x0),
    gsSP2Triangles( 1,  4,  2, 0x0,  1,  5,  4, 0x0),
    gsSP2Triangles( 6,  7,  8, 0x0,  8,  9, 10, 0x0),
    gsSP2Triangles( 9, 11, 10, 0x0, 12, 13, 14, 0x0),
    gsSPVertex(bbh_seg7_vertex_0700C358, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  0,  2,  3, 0x0),
    gsSP2Triangles( 2,  4,  3, 0x0,  5,  6,  7, 0x0),
    gsSP2Triangles( 5,  8,  6, 0x0,  9, 10, 11, 0x0),
    gsSP2Triangles( 9, 11, 12, 0x0, 13, 14, 15, 0x0),
    gsSPVertex(bbh_seg7_vertex_0700C458, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  1,  3,  2, 0x0),
    gsSP2Triangles( 3,  4,  2, 0x0,  5,  6,  7, 0x0),
    gsSP2Triangles( 3,  5,  7, 0x0,  8,  9, 10, 0x0),
    gsSP2Triangles(11, 12, 10, 0x0, 12,  8, 10, 0x0),
    gsSP2Triangles(10, 13, 14, 0x0, 10, 14, 11, 0x0),
    gsSPVertex(bbh_seg7_vertex_0700C548, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  7,  8, 0x0,  9, 10, 11, 0x0),
    gsSP2Triangles( 7, 12, 13, 0x0,  6,  8, 14, 0x0),
    gsSP1Triangle(15,  6, 14, 0x0),
    gsSPVertex(bbh_seg7_vertex_0700C648, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 6,  7,  8, 0x0,  5,  9, 10, 0x0),
    gsSP2Triangles(11, 12, 13, 0x0, 11, 14, 12, 0x0),
    gsSP1Triangle(15, 11, 13, 0x0),
    gsSPVertex(bbh_seg7_vertex_0700C748, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  0,  3,  1, 0x0),
    gsSP2Triangles( 4,  5,  6, 0x0,  7,  8,  9, 0x0),
    gsSP2Triangles( 7, 10,  8, 0x0, 11, 12, 13, 0x0),
    gsSP1Triangle(11, 14, 12, 0x0),
    gsSPVertex(bbh_seg7_vertex_0700C838, 4, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  0,  2,  3, 0x0),
    gsSPEndDisplayList(),
};

// 0x0700CF40 - 0x0700CFA8
static const Gfx bbh_seg7_dl_0700CF40[] = {
    gsDPSetTextureImage(G_IM_FMT_RGBA, G_IM_SIZ_16b, 1, spooky_09003800),
    gsDPLoadSync(),
    gsDPLoadBlock(G_TX_LOADTILE, 0, 0, 32 * 64 - 1, CALC_DXT(32, G_IM_SIZ_16b_BYTES)),
    gsSPVertex(bbh_seg7_vertex_0700C878, 16, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 3,  5,  6, 0x0,  7,  8,  9, 0x0),
    gsSP2Triangles( 7, 10,  8, 0x0, 11, 12, 13, 0x0),
    gsSP2Triangles(11, 13, 14, 0x0,  0,  2, 15, 0x0),
    gsSPEndDisplayList(),
};

// 0x0700CFA8 - 0x0700CFE0
static const Gfx bbh_seg7_dl_0700CFA8[] = {
    gsDPSetTextureImage(G_IM_FMT_RGBA, G_IM_SIZ_16b, 1, spooky_09002800),
    gsDPLoadSync(),
    gsDPLoadBlock(G_TX_LOADTILE, 0, 0, 32 * 64 - 1, CALC_DXT(32, G_IM_SIZ_16b_BYTES)),
    gsSPVertex(bbh_seg7_vertex_0700C978, 4, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  0,  2,  3, 0x0),
    gsSPEndDisplayList(),
};

// 0x0700CFE0 - 0x0700D080
static const Gfx bbh_seg7_dl_0700CFE0[] = {
    gsDPSetTextureImage(G_IM_FMT_RGBA, G_IM_SIZ_16b, 1, spooky_09009000),
    gsDPLoadSync(),
    gsDPLoadBlock(G_TX_LOADTILE, 0, 0, 64 * 32 - 1, CALC_DXT(64, G_IM_SIZ_16b_BYTES)),
    gsSPVertex(bbh_seg7_vertex_0700C9B8, 15, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  3,  4,  5, 0x0),
    gsSP2Triangles( 0,  3,  1, 0x0,  3,  5,  1, 0x0),
    gsSP2Triangles( 1,  6,  2, 0x0,  7,  8,  9, 0x0),
    gsSP2Triangles(10, 11, 12, 0x0, 10, 12, 13, 0x0),
    gsSP1Triangle(10, 14, 11, 0x0),
    gsSPVertex(bbh_seg7_vertex_0700CAA8, 11, 0),
    gsSP2Triangles( 0,  1,  2, 0x0,  0,  2,  3, 0x0),
    gsSP2Triangles( 4,  5,  6, 0x0,  7,  8,  9, 0x0),
    gsSP1Triangle( 7, 10,  8, 0x0),
    gsSPEndDisplayList(),
};

// 0x0700D080 - 0x0700D178
const Gfx bbh_seg7_dl_0700D080[] = {
    gsDPPipeSync(),
    gsDPSetCombineMode(G_CC_MODULATERGB, G_CC_MODULATERGB),
    gsSPClearGeometryMode(G_SHADING_SMOOTH),
    gsDPSetTile(G_IM_FMT_RGBA, G_IM_SIZ_16b, 0, 0, G_TX_LOADTILE, 0, G_TX_WRAP | G_TX_NOMIRROR, G_TX_NOMASK, G_TX_NOLOD, G_TX_WRAP | G_TX_NOMIRROR, G_TX_NOMASK, G_TX_NOLOD),
    gsSPTexture(0xFFFF, 0xFFFF, 0, G_TX_RENDERTILE, G_ON),
    gsDPTileSync(),
    gsDPSetTile(G_IM_FMT_RGBA, G_IM_SIZ_16b, 8, 0, G_TX_RENDERTILE, 0, G_TX_CLAMP, 5, G_TX_NOLOD, G_TX_CLAMP, 5, G_TX_NOLOD),
    gsDPSetTileSize(0, 0, 0, (32 - 1) << G_TEXTURE_IMAGE_FRAC, (32 - 1) << G_TEXTURE_IMAGE_FRAC),
    gsSPDisplayList(bbh_seg7_dl_0700CB58),
    gsDPTileSync(),
    gsDPSetTile(G_IM_FMT_RGBA, G_IM_SIZ_16b, 8, 0, G_TX_RENDERTILE, 0, G_TX_WRAP | G_TX_NOMIRROR, 5, G_TX_NOLOD, G_TX_WRAP | G_TX_NOMIRROR, 5, G_TX_NOLOD),
    gsDPSetTileSize(0, 0, 0, (32 - 1) << G_TEXTURE_IMAGE_FRAC, (32 - 1) << G_TEXTURE_IMAGE_FRAC),
    gsSPDisplayList(bbh_seg7_dl_0700CCB0),
    gsDPTileSync(),
    gsDPSetTile(G_IM_FMT_RGBA, G_IM_SIZ_16b, 8, 0, G_TX_RENDERTILE, 0, G_TX_CLAMP, 6, G_TX_NOLOD, G_TX_WRAP | G_TX_NOMIRROR, 5, G_TX_NOLOD),
    gsDPSetTileSize(0, 0, 0, (32 - 1) << G_TEXTURE_IMAGE_FRAC, (64 - 1) << G_TEXTURE_IMAGE_FRAC),
    gsSPDisplayList(bbh_seg7_dl_0700CD18),
    gsSPDisplayList(bbh_seg7_dl_0700CF40),
    gsDPTileSync(),
    gsDPSetTile(G_IM_FMT_RGBA, G_IM_SIZ_16b, 8, 0, G_TX_RENDERTILE, 0, G_TX_WRAP | G_TX_NOMIRROR, 6, G_TX_NOLOD, G_TX_WRAP | G_TX_NOMIRROR, 5, G_TX_NOLOD),
    gsDPSetTileSize(0, 0, 0, (32 - 1) << G_TEXTURE_IMAGE_FRAC, (64 - 1) << G_TEXTURE_IMAGE_FRAC),
    gsSPDisplayList(bbh_seg7_dl_0700CFA8),
    gsDPTileSync(),
    gsDPSetTile(G_IM_FMT_RGBA, G_IM_SIZ_16b, 16, 0, G_TX_RENDERTILE, 0, G_TX_WRAP | G_TX_NOMIRROR, 5, G_TX_NOLOD, G_TX_WRAP | G_TX_NOMIRROR, 6, G_TX_NOLOD),
    gsDPSetTileSize(0, 0, 0, (64 - 1) << G_TEXTURE_IMAGE_FRAC, (32 - 1) << G_TEXTURE_IMAGE_FRAC),
    gsSPDisplayList(bbh_seg7_dl_0700CFE0),
    gsSPTexture(0xFFFF, 0xFFFF, 0, G_TX_RENDERTILE, G_OFF),
    gsDPPipeSync(),
    gsDPSetCombineMode(G_CC_SHADE, G_CC_SHADE),
    gsSPSetGeometryMode(G_SHADING_SMOOTH),
    gsSPEndDisplayList(),
};
