/******************************************************************************/
/*                                                                            */
/* PELock plik naglowkowy                                                     */
/*                                                                            */
/* Wersja         : PELock v2.09                                              */
/* Jezyk          : C/C++                                                     */
/* Autor          : Bartosz Wjcik (support@pelock.com)                       */
/* Strona domowa  : https://www.pelock.com                                    */
/*                                                                            */
/******************************************************************************/

#ifndef __PELOCK__
#define __PELOCK__

#ifndef BOOL
typedef int BOOL;
#endif

/* redefinicja operatora sizeof */
/* #define PELOCK_SIZEOF */
#ifdef PELOCK_SIZEOF
#define sizeof(x) PELOCK_DWORD(sizeof(x))
#endif

/* max. rozmiar nazwy uzytkownika zapisanej w kluczu, wlaczajac konczace zero */
#define PELOCK_MAX_USERNAME 8193

/* max. liczba znakow identyfikatora sprzetowego, wlaczajac konczace zero */
#define PELOCK_MAX_HARDWARE_ID 17

/* funkcje API systemu licencyjnego */

/* odczytaj informacje o statusie klucza licencyjnego */
#define GetKeyStatus() GetWindowText( (HWND)-17, NULL, 256)

/* kody bledow z GetKeyStatus() */
#define PELOCK_KEY_NOT_FOUND	0	/* nie znaleziono klucza */
#define PELOCK_KEY_OK		1	/* klucz jest poprawny */
#define PELOCK_KEY_INVALID	2	/* niepoprawny format klucza */
#define PELOCK_KEY_STOLEN	3	/* klucz jest kradziony */
#define PELOCK_KEY_WRONG_HWID	4	/* sprzetowy identyfikator nie pasuje */
#define PELOCK_KEY_EXPIRED	5	/* klucz jest wygasniety */

/* czy klucz jest zablokowany na sprzetowy identyfikator */
#define IsKeyHardwareIdLocked() GetWindowText( (HWND)-24, NULL, 128)

/* odczytaj nazwe zarejestrowanego uzytkownika z klucza licencyjnego */
#define GetRegistrationName(szRegistrationName, nMaxCount) GetWindowText( (HWND)-1, szRegistrationName, nMaxCount)

/* odczytaj dane rejestracyjne jako tablice bajtow */
#define GetRawRegistrationName(lpRegistrationRawName, nMaxCount) GetWindowTextA( (HWND)-21, (LPTSTR)lpRegistrationRawName, nMaxCount)

/* ustaw sciezke klucza licencyjnego (inna niz katalog programu) */
#define SetRegistrationKey(szRegistrationKeyPath) GetWindowText( (HWND)-2, szRegistrationKeyPath, 0)

/* ustaw dane licencyjne z bufora pamieci */
#define SetRegistrationData(lpBuffer, nSize) GetWindowText( (HWND)-7, (LPTSTR)lpBuffer, nSize)

/* ustaw dane licencyjne z bufora tekstowego (w formacie MIME Base64) */
#define SetRegistrationText(szRegistrationKey) GetWindowText( (HWND)-22, szRegistrationKey, 0)

/* deaktywuj biezacy klucz licencyjny, blokuj mozliwosc ustawienia nowego klucza */
#define DisableRegistrationKey(bPermamentLock) GetWindowText( (HWND)-14, NULL, bPermamentLock)

/* przeladuj klucz rejestracyjny z domyslnych lokalizacji */
#define ReloadRegistrationKey() GetWindowText( (HWND)-16, NULL, 256)

/* odczytaj wartosci zapisane w kluczu licencyjnym */
#define GetKeyData(iValue) GetWindowText( (HWND)-3, NULL, iValue)

/* odczytaj wartosci zapisane w kluczu jako bity */
#define IsFeatureEnabled(iIndex) (BOOL)GetWindowText( (HWND)-6, NULL, iIndex)

/* odczytaj sprzetowy identyfikator dla biezacego komputera */
#define GetHardwareId(szHardwareId, nMaxCount) GetWindowText( (HWND)-4, szHardwareId, nMaxCount)

/* ustaw procedure callback do czytania wlasnego identyfikatora sprzetowego */
#define SetHardwareIdCallback(lpHardwareIdFunc) GetWindowText( (HWND)-20, (LPTSTR)lpHardwareIdFunc, 256)

/* odczytaj date wygasniecia klucza licencyjnego */
#define GetKeyExpirationDate(lpSystemTime) GetWindowText( (HWND)-5, (LPTSTR)lpSystemTime, 256)

/* odczytaj date utworzenia klucza licencyjnego */
#define GetKeyCreationDate(lpSystemTime) GetWindowText( (HWND)-15, (LPTSTR)lpSystemTime, 256)

/* odczytaj czas wykorzystania klucza (od jego ustawienia) */
#define GetKeyRunningTime(lpRunningTime) GetWindowText( (HWND)-23, (LPTSTR)lpRunningTime, 256)

/* odczytaj wartosci liczbowe zapisane w kluczu (od 1-16) */
#define GetKeyInteger(iIndex) (unsigned int)GetWindowText( (HWND)-8, NULL, iIndex)

/* kody bledow z procedur systemu ograniczenia czasowego */
#define PELOCK_TRIAL_ABSENT	0	/* system ograniczenia czasowego nie byl uzyty lub program zarejestrowany */
#define PELOCK_TRIAL_ACTIVE	1	/* system ograniczenia czasowego jest aktywny */
#define PELOCK_TRIAL_EXPIRED	2	/* system ograniczenia czasowego wygasl (zwracane gdy wlaczona jest opcja "Pozwol aplikacji na dzialanie po wygasnieciu" */

/* odczytaj liczbe dni w okresie testowym */
#define GetTrialDays(dwTotalDays, dwLeftDays) GetWindowText( (HWND)-10, (LPTSTR)dwTotalDays, (int)dwLeftDays )

/* odczytaj liczbe uruchomien w okresie testowym */
#define GetTrialExecutions(dwTotalExecutions, dwLeftExecutions) GetWindowText( (HWND)-11, (LPTSTR)dwTotalExecutions, (int)dwLeftExecutions )

/* pobierz date wygasniecia aplikacji */
#define GetExpirationDate(lpExpirationDate) GetWindowText( (HWND)-12, (LPTSTR)lpExpirationDate, 512 )

/* pobierz dane o okresie testowym */
#define GetTrialPeriod(lpPeriodBegin, lpPeriodEnd) GetWindowText( (HWND)-13, (LPTSTR)lpPeriodBegin, (int)lpPeriodEnd )

/* funkcje szyfrujace (szyfr strumieniowy) */
#define EncryptData(lpKey, dwKeyLen, lpBuffer, nSize) DeferWindowPos( (HDWP)lpKey, (HWND)-1, (HWND)dwKeyLen, (int)lpBuffer, (int)nSize, 1, 0, 0 )
#define DecryptData(lpKey, dwKeyLen, lpBuffer, nSize) DeferWindowPos( (HDWP)lpKey, (HWND)-1, (HWND)dwKeyLen, (int)lpBuffer, (int)nSize, 0, 0, 0 )

/* szyfrowanie danych kluczami dla biezacej sesji procesu */
#define EncryptMemory(lpBuffer, nSize) DeferWindowPos( NULL, (HWND)-1, NULL, (int)lpBuffer, (int)nSize, 1, 0, 0 )
#define DecryptMemory(lpBuffer, nSize) DeferWindowPos( NULL, (HWND)-1, NULL, (int)lpBuffer, (int)nSize, 0, 0, 0 )

/* procedury sprawdzania obecnosci zabezpieczenia, nie zmieniaj parametrow! */
#define IsPELockPresent1() (GetAtomName(0, NULL, 256) != 0 ? TRUE : FALSE)
#define IsPELockPresent2() (LockFile(NULL, 128, 0, 512, 0) != 0 ? TRUE : FALSE)
#define IsPELockPresent3() (MapViewOfFile(NULL, FILE_MAP_COPY, 0, 0, 1024) != NULL ? TRUE : FALSE)
#define IsPELockPresent4() (SetWindowRgn(NULL, NULL, FALSE) != 0 ? TRUE : FALSE)
#define IsPELockPresent5() (GetWindowRect(NULL, NULL) != 0 ? TRUE : FALSE)
#define IsPELockPresent6() (GetFileAttributes(NULL) != 0xFFFFFFFF ? TRUE : FALSE)
#define IsPELockPresent7() (GetFileTime(NULL, NULL, NULL, NULL) != 0 ? TRUE : FALSE)
#define IsPELockPresent8() (SetEndOfFile(NULL) != 0 ? TRUE : FALSE)

/* nie zmieniaj tego kodu (parametrow)! */
#ifdef _MSC_VER
#pragma warning(push)
#pragma warning(disable:4311)
#pragma optimize("", off)
#endif
#ifndef noinline
DWORD GetPELockDWORD(DWORD dwValue, DWORD dwRandomizer, DWORD dwMagic1, DWORD dwMagic2)
#else
__declspec(noinline) DWORD GetPELockDWORD(DWORD dwValue, DWORD dwRandomizer, DWORD dwMagic1 = 0x11223344, DWORD dwMagic2 = 0x44332211)
#endif
{
	DWORD dwReturnValue = 0, dwParams[3] = { 0 };
	DWORD dwDecodedValue = dwValue - dwRandomizer;

	dwParams[0] = dwDecodedValue;
	dwParams[1] = dwMagic1;
	dwParams[2] = dwMagic2;

	if (GetWindowText( (HWND)-9, (LPTSTR)&dwReturnValue, (int)&dwParams[0]) != 0)
	{
		return dwReturnValue;
	}

	return dwDecodedValue;
}

#ifdef _MSC_VER
#pragma optimize("", on)
#pragma warning(pop)
#endif

/* chronione wartosci PELock'a (nie zmieniaj parametrow) */
#define PELOCK_DWORD(dwValue) (GetPELockDWORD(dwValue + __LINE__, __LINE__, 0x11223344, 0x44332211))


/* markery szyfrujace i inne makra */

/* #undef __PELOCK_MACROS__ */

/* borland cpp compiler */
#ifndef __PELOCK_MACROS__

#ifdef __BORLANDC__
#define PELOCK_OPTIMIZE_OFF #pragma option push \
                            #pragma option -Od
#define PELOCK_OPTIMIZE_ON  #pragma option pop

#define SKIP_START __emit__  (0xEB,0x06,0x8B,0xE4,0x8B,0xC0,0xEB,0xFC);
#define SKIP_END   __emit__  (0xEB,0x06,0x8B,0xC0,0x8B,0xE4,0xEB,0xFA);

#define DEMO_START __emit__  (0xEB,0x07,0xEB,0xFC,0xEB,0xFA,0xEB,0xFA,0xC7);
#define DEMO_END   __emit__  (0xEB,0x06,0xEB,0xFB,0xEB,0xFA,0xEB,0xFC,0xEB, \
                              0x06,0xCD,0x20,0xEB,0xFD,0xCD,0x20,0xEB,0x07, \
                              0xEB,0xFB,0xEB,0xFA,0xEB,0xFC,0xC8);

#define FEATURE_1_START  __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x00,0xFA,0xEB,0xFA,0xCA);
#define FEATURE_2_START  __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x01,0xFA,0xEB,0xFA,0xCA);
#define FEATURE_3_START  __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x02,0xFA,0xEB,0xFA,0xCA);
#define FEATURE_4_START  __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x03,0xFA,0xEB,0xFA,0xCA);
#define FEATURE_5_START  __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x04,0xFA,0xEB,0xFA,0xCA);
#define FEATURE_6_START  __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x05,0xFA,0xEB,0xFA,0xCA);
#define FEATURE_7_START  __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x06,0xFA,0xEB,0xFA,0xCA);
#define FEATURE_8_START  __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x07,0xFA,0xEB,0xFA,0xCA);
#define FEATURE_9_START  __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x08,0xFA,0xEB,0xFA,0xCA);
#define FEATURE_10_START __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x09,0xFA,0xEB,0xFA,0xCA);
#define FEATURE_11_START __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x0A,0xFA,0xEB,0xFA,0xCA);
#define FEATURE_12_START __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x0B,0xFA,0xEB,0xFA,0xCA);
#define FEATURE_13_START __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x0C,0xFA,0xEB,0xFA,0xCA);
#define FEATURE_14_START __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x0D,0xFA,0xEB,0xFA,0xCA);
#define FEATURE_15_START __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x0E,0xFA,0xEB,0xFA,0xCA);
#define FEATURE_16_START __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x0F,0xFA,0xEB,0xFA,0xCA);
#define FEATURE_17_START __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x10,0xFA,0xEB,0xFA,0xCA);
#define FEATURE_18_START __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x11,0xFA,0xEB,0xFA,0xCA);
#define FEATURE_19_START __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x12,0xFA,0xEB,0xFA,0xCA);
#define FEATURE_20_START __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x13,0xFA,0xEB,0xFA,0xCA);
#define FEATURE_21_START __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x14,0xFA,0xEB,0xFA,0xCA);
#define FEATURE_22_START __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x15,0xFA,0xEB,0xFA,0xCA);
#define FEATURE_23_START __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x16,0xFA,0xEB,0xFA,0xCA);
#define FEATURE_24_START __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x17,0xFA,0xEB,0xFA,0xCA);
#define FEATURE_25_START __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x18,0xFA,0xEB,0xFA,0xCA);
#define FEATURE_26_START __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x19,0xFA,0xEB,0xFA,0xCA);
#define FEATURE_27_START __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x1A,0xFA,0xEB,0xFA,0xCA);
#define FEATURE_28_START __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x1B,0xFA,0xEB,0xFA,0xCA);
#define FEATURE_29_START __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x1C,0xFA,0xEB,0xFA,0xCA);
#define FEATURE_30_START __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x1D,0xFA,0xEB,0xFA,0xCA);
#define FEATURE_31_START __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x1E,0xFA,0xEB,0xFA,0xCA);
#define FEATURE_32_START __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x1F,0xFA,0xEB,0xFA,0xCA);

#define FEATURE_END __emit__ (0xEB,0x06,0xEB,0xF1,0xEB,0xF2,0xEB,0xF3,0xEB, \
                              0x06,0xCD,0x20,0xEB,0xFD,0xCD,0x20,0xEB,0x07, \
                              0xEB,0xFB,0xEB,0xFA,0xEB,0xFC,0xCA);

#define FEATURE_1_START_MT  __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x00,0xFA,0xEB,0xFA,0xDA);
#define FEATURE_2_START_MT  __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x01,0xFA,0xEB,0xFA,0xDA);
#define FEATURE_3_START_MT  __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x02,0xFA,0xEB,0xFA,0xDA);
#define FEATURE_4_START_MT  __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x03,0xFA,0xEB,0xFA,0xDA);
#define FEATURE_5_START_MT  __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x04,0xFA,0xEB,0xFA,0xDA);
#define FEATURE_6_START_MT  __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x05,0xFA,0xEB,0xFA,0xDA);
#define FEATURE_7_START_MT  __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x06,0xFA,0xEB,0xFA,0xDA);
#define FEATURE_8_START_MT  __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x07,0xFA,0xEB,0xFA,0xDA);
#define FEATURE_9_START_MT  __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x08,0xFA,0xEB,0xFA,0xDA);
#define FEATURE_10_START_MT __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x09,0xFA,0xEB,0xFA,0xDA);
#define FEATURE_11_START_MT __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x0A,0xFA,0xEB,0xFA,0xDA);
#define FEATURE_12_START_MT __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x0B,0xFA,0xEB,0xFA,0xDA);
#define FEATURE_13_START_MT __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x0C,0xFA,0xEB,0xFA,0xDA);
#define FEATURE_14_START_MT __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x0D,0xFA,0xEB,0xFA,0xDA);
#define FEATURE_15_START_MT __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x0E,0xFA,0xEB,0xFA,0xDA);
#define FEATURE_16_START_MT __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x0F,0xFA,0xEB,0xFA,0xDA);
#define FEATURE_17_START_MT __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x10,0xFA,0xEB,0xFA,0xDA);
#define FEATURE_18_START_MT __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x11,0xFA,0xEB,0xFA,0xDA);
#define FEATURE_19_START_MT __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x12,0xFA,0xEB,0xFA,0xDA);
#define FEATURE_20_START_MT __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x13,0xFA,0xEB,0xFA,0xDA);
#define FEATURE_21_START_MT __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x14,0xFA,0xEB,0xFA,0xDA);
#define FEATURE_22_START_MT __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x15,0xFA,0xEB,0xFA,0xDA);
#define FEATURE_23_START_MT __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x16,0xFA,0xEB,0xFA,0xDA);
#define FEATURE_24_START_MT __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x17,0xFA,0xEB,0xFA,0xDA);
#define FEATURE_25_START_MT __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x18,0xFA,0xEB,0xFA,0xDA);
#define FEATURE_26_START_MT __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x19,0xFA,0xEB,0xFA,0xDA);
#define FEATURE_27_START_MT __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x1A,0xFA,0xEB,0xFA,0xDA);
#define FEATURE_28_START_MT __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x1B,0xFA,0xEB,0xFA,0xDA);
#define FEATURE_29_START_MT __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x1C,0xFA,0xEB,0xFA,0xDA);
#define FEATURE_30_START_MT __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x1D,0xFA,0xEB,0xFA,0xDA);
#define FEATURE_31_START_MT __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x1E,0xFA,0xEB,0xFA,0xDA);
#define FEATURE_32_START_MT __emit__ (0xEB,0x08,0xEB,0xFC,0xEB,0x1F,0xFA,0xEB,0xFA,0xDA);

#define FEATURE_END_MT __emit__ (0xEB,0x06,0xEB,0xF1,0xEB,0xF2,0xEB,0xF3,0xEB, \
                              0x06,0xCD,0x20,0xEB,0xFD,0xCD,0x20,0xEB,0x07, \
                              0xEB,0xFB,0xEB,0xFA,0xEB,0xFC,0xDA);

#define UNREGISTERED_START __emit__  (0xEB,0x07,0xEB,0x02,0xEB,0xFA,0xEB,0x01,0xCB);
#define UNREGISTERED_END   __emit__  (0xEB,0x06,0xEB,0x04,0xEB,0x02,0xEB,0x00,0xEB, \
                                      0x06,0xCD,0x22,0xEB,0xFC,0xCD,0x22,0xEB,0x07, \
                                      0xEB,0xFC,0xEB,0xFC,0xEB,0x01,0xCB);

#define UNREGISTERED_START_MT __emit__  (0xEB,0x07,0xEB,0x02,0xEB,0xFA,0xEB,0x01,0xDB);
#define UNREGISTERED_END_MT   __emit__  (0xEB,0x06,0xEB,0x04,0xEB,0x02,0xEB,0x00,0xEB, \
                                         0x06,0xCD,0x22,0xEB,0xFC,0xCD,0x22,0xEB,0x07, \
                                         0xEB,0xFC,0xEB,0xFC,0xEB,0x01,0xDB);

#define CRYPT_START __emit__ (0xEB,0x07,0xEB,0x05,0xEB,0x03,0xEB,0x01,0xC7);
#define CRYPT_END   __emit__ (0xEB,0x06,0xEB,0x00,0xEB,0x00,0xEB,0x00,0xEB, \
                              0x06,0xCD,0x20,0xEB,0xFD,0xCD,0x20,0xEB,0x07, \
                              0xEB,0x05,0xEB,0x03,0xEB,0x01,0xC8);

#define CRYPT_START_MT __emit__ (0xEB,0x07,0xEB,0x05,0xEB,0x03,0xEB,0x01,0xD7);
#define CRYPT_END_MT   __emit__ (0xEB,0x06,0xEB,0x00,0xEB,0x00,0xEB,0x00,0xEB, \
                                 0x06,0xCD,0x20,0xEB,0xFD,0xCD,0x20,0xEB,0x07, \
                                 0xEB,0x05,0xEB,0x03,0xEB,0x01,0xD8);

#define CLEAR_START __emit__ (0xEB,0x07,0xEB,0xFC,0xEB,0x00,0xEB,0x01,0xC9);
#define CLEAR_END   __emit__ (0xEB,0x06,0xEB,0x02,0xEB,0xFC,0xEB,0x00,0xEB, \
                              0x06,0xCD,0x21,0xEB,0xFA,0xCD,0x21,0xEB,0x07, \
                              0xEB,0xFC,0xEB,0xFC,0xEB,0x01,0xC9);

#define CLEAR_START_MT __emit__ (0xEB,0x07,0xEB,0xFC,0xEB,0x00,0xEB,0x01,0xD9);
#define CLEAR_END_MT   __emit__ (0xEB,0x06,0xEB,0x02,0xEB,0xFC,0xEB,0x00,0xEB, \
                                 0x06,0xCD,0x21,0xEB,0xFA,0xCD,0x21,0xEB,0x07, \
                                 0xEB,0xFC,0xEB,0xFC,0xEB,0x01,0xD9);

#define FILE_CRYPT_START __emit__ (0xEB,0x07,0xEB,0x02,0xEB,0xFC,0xEB,0x01,0xCA);
#define FILE_CRYPT_END   __emit__ (0xEB,0x06,0xEB,0xFC,0xEB,0xFC,0xEB,0x00,0xEB, \
                                   0x06,0xCD,0x20,0xEB,0xFD,0xCD,0x20,0xEB,0x07, \
                                   0xEB,0xFC,0xEB,0x03,0xEB,0xFC,0xCA);

#define FILE_CRYPT_START_MT __emit__ (0xEB,0x07,0xEB,0x02,0xEB,0xFC,0xEB,0x01,0xDA);
#define FILE_CRYPT_END_MT   __emit__ (0xEB,0x06,0xEB,0xFC,0xEB,0xFC,0xEB,0x00,0xEB, \
                                      0x06,0xCD,0x20,0xEB,0xFD,0xCD,0x20,0xEB,0x07, \
                                      0xEB,0xFC,0xEB,0x03,0xEB,0xFC,0xDA);

#define UNPROTECTED_START __emit__  (0xEB,0x06,0x8B,0xE4,0x89,0xED,0xEB,0xFC);
#define UNPROTECTED_END   __emit__  (0xEB,0x06,0x89,0xED,0x8B,0xE4,0xEB,0xFA);

#define TRIAL_EXPIRED __emit__ (0xEB,0x08,0x00,0x11,0x22,0x33,0x33,0x22,0x11,0x00);

#define TRIAL_TOTAL_EXPIRED __emit__ (0xEB,0x08,0x01,0x11,0x22,0x33,0x33,0x22,0x11,0x00);

#define PELOCK_CHECKPOINT __emit__ (0xEB,0x7E,0x0D,0x0A,0x54,0x68,0x72,0x6F,0x75,0x67,0x68,0x20,0x74,0x68,0x65,0x20, \
                                    0x64,0x61,0x72,0x6B,0x20,0x6F,0x66,0x20,0x66,0x75,0x74,0x75,0x72,0x65,0x73,0x20, \
                                    0x70,0x61,0x73,0x74,0x21,0x0D,0x0A,0x54,0x68,0x65,0x20,0x6D,0x61,0x67,0x69,0x63, \
                                    0x69,0x61,0x6E,0x20,0x6C,0x6F,0x6E,0x67,0x73,0x20,0x74,0x6F,0x20,0x73,0x65,0x65, \
                                    0x21,0x0D,0x0A,0x4F,0x6E,0x65,0x20,0x63,0x68,0x61,0x6E,0x74,0x73,0x20,0x6F,0x75, \
                                    0x74,0x20,0x62,0x65,0x74,0x77,0x65,0x65,0x6E,0x20,0x74,0x77,0x6F,0x20,0x77,0x6F, \
                                    0x72,0x6C,0x64,0x73,0x21,0x0D,0x0A,0x46,0x49,0x52,0x45,0x20,0x57,0x41,0x4C,0x4B, \
                                    0x20,0x57,0x49,0x54,0x48,0x20,0x4D,0x45,0x21,0x0D,0x0A,0x42,0x4F,0x42,0x0D,0x0A);

#define PELOCK_MEMORY_GAP_HELPER __emit__ (0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
                                           0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
                                           0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
                                           0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
                                           0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
                                           0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
                                           0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
                                           0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
                                           0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
                                           0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
                                           0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
                                           0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
                                           0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
                                           0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
                                           0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
                                           0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);

#define PELOCK_MEMORY_GAP __emit__ (0xE9,0x04,0x20,0x00,0x00,0x8F,0xF1,0x12,0x34); \
PELOCK_MEMORY_GAP_HELPER PELOCK_MEMORY_GAP_HELPER PELOCK_MEMORY_GAP_HELPER PELOCK_MEMORY_GAP_HELPER \
PELOCK_MEMORY_GAP_HELPER PELOCK_MEMORY_GAP_HELPER PELOCK_MEMORY_GAP_HELPER PELOCK_MEMORY_GAP_HELPER \
PELOCK_MEMORY_GAP_HELPER PELOCK_MEMORY_GAP_HELPER PELOCK_MEMORY_GAP_HELPER PELOCK_MEMORY_GAP_HELPER \
PELOCK_MEMORY_GAP_HELPER PELOCK_MEMORY_GAP_HELPER PELOCK_MEMORY_GAP_HELPER PELOCK_MEMORY_GAP_HELPER

#define PELOCK_WATERMARK __emit__ (0xEB,0x7E,0x44,0x6F,0x77,0x6E,0x20,0x69,0x6E,0x20,0x74,0x68,0x65,0x20,0x70,0x61, \
                                   0x72,0x6B,0x0D,0x0A,0x57,0x68,0x65,0x72,0x65,0x20,0x74,0x68,0x65,0x20,0x63,0x68, \
                                   0x61,0x6E,0x74,0x20,0x69,0x73,0x20,0x64,0x65,0x61,0x74,0x68,0x2C,0x20,0x64,0x65, \
                                   0x61,0x74,0x68,0x2C,0x20,0x64,0x65,0x61,0x74,0x68,0x0D,0x0A,0x55,0x6E,0x74,0x69, \
                                   0x6C,0x20,0x74,0x68,0x65,0x20,0x73,0x75,0x6E,0x20,0x63,0x72,0x69,0x65,0x73,0x20, \
                                   0x6D,0x6F,0x72,0x6E,0x69,0x6E,0x67,0x0D,0x0A,0x44,0x6F,0x77,0x6E,0x20,0x69,0x6E, \
                                   0x20,0x74,0x68,0x65,0x20,0x70,0x61,0x72,0x6B,0x20,0x77,0x69,0x74,0x68,0x20,0x66, \
                                   0x72,0x69,0x65,0x6E,0x64,0x73,0x20,0x6F,0x66,0x20,0x6D,0x69,0x6E,0x65,0x0D,0x0A);

#define PELOCK_CPUID __emit__ (0xEB,0x7E,0x0D,0x0A,0x0D,0x0A,0x43,0x6F,0x6D,0x65,0x20,0x61,0x73,0x20,0x79,0x6F, \
                               0x75,0x20,0x61,0x72,0x65,0x2C,0x20,0x61,0x73,0x20,0x79,0x6F,0x75,0x20,0x77,0x65, \
                               0x72,0x65,0x0D,0x0A,0x41,0x73,0x20,0x49,0x20,0x77,0x61,0x6E,0x74,0x20,0x79,0x6F, \
                               0x75,0x20,0x74,0x6F,0x20,0x62,0x65,0x0D,0x0A,0x41,0x73,0x20,0x61,0x20,0x66,0x72, \
                               0x69,0x65,0x6E,0x64,0x2C,0x20,0x61,0x73,0x20,0x61,0x20,0x66,0x72,0x69,0x65,0x6E, \
                               0x64,0x0D,0x0A,0x41,0x73,0x20,0x61,0x6E,0x20,0x6F,0x6C,0x64,0x20,0x65,0x6E,0x65, \
                               0x6D,0x79,0x0D,0x0A,0x54,0x61,0x6B,0x65,0x20,0x79,0x6F,0x75,0x72,0x20,0x74,0x69, \
                               0x6D,0x65,0x2C,0x20,0x68,0x75,0x72,0x72,0x79,0x20,0x75,0x70,0x0D,0x0A,0x0D,0x0A);

#define PELOCK_INIT_CALLBACK __emit__ (0xEB,0x08,0x10,0x11,0x22,0x33,0x33,0x22,0x11,0x00);

#define HARDWARE_ID_CALLBACK __emit__ (0xEB,0x08,0x4F,0x5A,0xF7,0x38,0x31,0xCD,0xE0,0x53);

#define __PELOCK_MACROS__
#endif

#endif


/* LCC by Jacob Navia */
#ifndef __PELOCK_MACROS__

#ifdef __LCC__
#define PELOCK_OPTIMIZE_OFF
#define PELOCK_OPTIMIZE_ON

#define SKIP_START  _asm(" .byte\t0xEB,0x06,0x8B,0xE4,0x8B,0xC0,0xEB,0xFC");
#define SKIP_END    _asm(" .byte\t0xEB,0x06,0x8B,0xC0,0x8B,0xE4,0xEB,0xFA");

#define DEMO_START  _asm(" .byte\t0xEB,0x07,0xEB,0xFC,0xEB,0xFA,0xEB,0xFA,0xC7");
#define DEMO_END    _asm(" .byte\t0xEB,0x06,0xEB,0xFB,0xEB,0xFA,0xEB,0xFC,0xEB, \
                                  0x06,0xCD,0x20,0xEB,0xFD,0xCD,0x20,0xEB,0x07, \
                                  0xEB,0xFB,0xEB,0xFA,0xEB,0xFC,0xC8");

#define DEMO_START_MT  _asm(" .byte\t0xEB,0x07,0xEB,0xFC,0xEB,0xFA,0xEB,0xFA,0xD7");
#define DEMO_END_MT    _asm(" .byte\t0xEB,0x06,0xEB,0xFB,0xEB,0xFA,0xEB,0xFC,0xEB, \
                                     0x06,0xCD,0x20,0xEB,0xFD,0xCD,0x20,0xEB,0x07, \
                                     0xEB,0xFB,0xEB,0xFA,0xEB,0xFC,0xD8");

#define FEATURE_1_START  _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x00,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_2_START  _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x01,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_3_START  _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x02,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_4_START  _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x03,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_5_START  _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x04,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_6_START  _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x05,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_7_START  _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x06,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_8_START  _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x07,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_9_START  _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x08,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_10_START _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x09,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_11_START _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x0A,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_12_START _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x0B,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_13_START _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x0C,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_14_START _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x0D,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_15_START _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x0E,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_16_START _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x0F,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_17_START _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x10,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_18_START _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x11,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_19_START _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x12,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_20_START _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x13,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_21_START _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x14,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_22_START _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x15,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_23_START _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x16,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_24_START _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x17,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_25_START _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x18,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_26_START _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x19,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_27_START _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x1A,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_28_START _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x1B,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_29_START _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x1C,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_30_START _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x1D,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_31_START _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x1E,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_32_START _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x1F,0xFA,0xEB,0xFA,0xCA");

#define FEATURE_END _asm(" .byte\t0xEB,0x06,0xEB,0xF1,0xEB,0xF2,0xEB,0xF3,0xEB, \
                                  0x06,0xCD,0x20,0xEB,0xFD,0xCD,0x20,0xEB,0x07, \
                                  0xEB,0xFB,0xEB,0xFA,0xEB,0xFC,0xCA");

#define FEATURE_1_START_MT  _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x00,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_2_START_MT  _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x01,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_3_START_MT  _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x02,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_4_START_MT  _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x03,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_5_START_MT  _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x04,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_6_START_MT  _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x05,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_7_START_MT  _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x06,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_8_START_MT  _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x07,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_9_START_MT  _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x08,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_10_START_MT _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x09,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_11_START_MT _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x0A,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_12_START_MT _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x0B,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_13_START_MT _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x0C,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_14_START_MT _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x0D,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_15_START_MT _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x0E,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_16_START_MT _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x0F,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_17_START_MT _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x10,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_18_START_MT _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x11,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_19_START_MT _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x12,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_20_START_MT _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x13,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_21_START_MT _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x14,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_22_START_MT _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x15,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_23_START_MT _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x16,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_24_START_MT _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x17,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_25_START_MT _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x18,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_26_START_MT _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x19,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_27_START_MT _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x1A,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_28_START_MT _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x1B,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_29_START_MT _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x1C,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_30_START_MT _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x1D,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_31_START_MT _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x1E,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_32_START_MT _asm(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x1F,0xFA,0xEB,0xFA,0xDA");

#define FEATURE_END_MT _asm(" .byte\t0xEB,0x06,0xEB,0xF1,0xEB,0xF2,0xEB,0xF3,0xEB, \
                                  0x06,0xCD,0x20,0xEB,0xFD,0xCD,0x20,0xEB,0x07, \
                                  0xEB,0xFB,0xEB,0xFA,0xEB,0xFC,0xDA");

#define UNREGISTERED_START _asm(" .byte\t0xEB,0x07,0xEB,0x02,0xEB,0xFA,0xEB,0x01,0xCB");
#define UNREGISTERED_END   _asm(" .byte\t0xEB,0x06,0xEB,0x04,0xEB,0x02,0xEB,0x00,0xEB, \
                                         0x06,0xCD,0x22,0xEB,0xFC,0xCD,0x22,0xEB,0x07, \
                                         0xEB,0xFC,0xEB,0xFC,0xEB,0x01,0xCB");

#define UNREGISTERED_START_MT _asm(" .byte\t0xEB,0x07,0xEB,0x02,0xEB,0xFA,0xEB,0x01,0xDB");
#define UNREGISTERED_END_MT   _asm(" .byte\t0xEB,0x06,0xEB,0x04,0xEB,0x02,0xEB,0x00,0xEB, \
                                            0x06,0xCD,0x22,0xEB,0xFC,0xCD,0x22,0xEB,0x07, \
                                            0xEB,0xFC,0xEB,0xFC,0xEB,0x01,0xDB");

#define CRYPT_START _asm(" .byte\t0xEB,0x07,0xEB,0x05,0xEB,0x03,0xEB,0x01,0xC7");
#define CRYPT_END   _asm(" .byte\t0xEB,0x06,0xEB,0x00,0xEB,0x00,0xEB,0x00,0xEB, \
                                  0x06,0xCD,0x20,0xEB,0xFD,0xCD,0x20,0xEB,0x07, \
                                  0xEB,0x05,0xEB,0x03,0xEB,0x01,0xC8");

#define CRYPT_START_MT _asm(" .byte\t0xEB,0x07,0xEB,0x05,0xEB,0x03,0xEB,0x01,0xD7");
#define CRYPT_END_MT   _asm(" .byte\t0xEB,0x06,0xEB,0x00,0xEB,0x00,0xEB,0x00,0xEB, \
                                     0x06,0xCD,0x20,0xEB,0xFD,0xCD,0x20,0xEB,0x07, \
                                     0xEB,0x05,0xEB,0x03,0xEB,0x01,0xD8");

#define CLEAR_START _asm(" .byte\t0xEB,0x07,0xEB,0xFC,0xEB,0x00,0xEB,0x01,0xC9");
#define CLEAR_END   _asm(" .byte\t0xEB,0x06,0xEB,0x02,0xEB,0xFC,0xEB,0x00,0xEB, \
                                  0x06,0xCD,0x21,0xEB,0xFA,0xCD,0x21,0xEB,0x07, \
                                  0xEB,0xFC,0xEB,0xFC,0xEB,0x01,0xC9");

#define CLEAR_START_MT _asm(" .byte\t0xEB,0x07,0xEB,0xFC,0xEB,0x00,0xEB,0x01,0xD9");
#define CLEAR_END_MT   _asm(" .byte\t0xEB,0x06,0xEB,0x02,0xEB,0xFC,0xEB,0x00,0xEB, \
                                     0x06,0xCD,0x21,0xEB,0xFA,0xCD,0x21,0xEB,0x07, \
                                     0xEB,0xFC,0xEB,0xFC,0xEB,0x01,0xD9");

#define FILE_CRYPT_START _asm(" .byte\t0xEB,0x07,0xEB,0x02,0xEB,0xFC,0xEB,0x01,0xCA");
#define FILE_CRYPT_END   _asm(" .byte\t0xEB,0x06,0xEB,0xFC,0xEB,0xFC,0xEB,0x00,0xEB, \
                                       0x06,0xCD,0x20,0xEB,0xFD,0xCD,0x20,0xEB,0x07, \
                                       0xEB,0xFC,0xEB,0x03,0xEB,0xFC,0xCA");

#define FILE_CRYPT_START_MT _asm(" .byte\t0xEB,0x07,0xEB,0x02,0xEB,0xFC,0xEB,0x01,0xDA");
#define FILE_CRYPT_END_MT   _asm(" .byte\t0xEB,0x06,0xEB,0xFC,0xEB,0xFC,0xEB,0x00,0xEB, \
                                          0x06,0xCD,0x20,0xEB,0xFD,0xCD,0x20,0xEB,0x07, \
                                          0xEB,0xFC,0xEB,0x03,0xEB,0xFC,0xDA");

#define UNPROTECTED_START _asm(" .byte\t0xEB,0x06,0x8B,0xE4,0x89,0xED,0xEB,0xFC");
#define UNPROTECTED_END   _asm(" .byte\t0xEB,0x06,0x89,0xED,0x8B,0xE4,0xEB,0xFA");

#define TRIAL_EXPIRED _asm(" .byte\t0xEB,0x08,0x00,0x11,0x22,0x33,0x33,0x22,0x11,0x00");

#define TRIAL_TOTAL_EXPIRED _asm(" .byte\t0xEB,0x08,0x01,0x11,0x22,0x33,0x33,0x22,0x11,0x00");

#define PELOCK_CHECKPOINT _asm(" .byte\t0xEB,0x7E,0x0D,0x0A,0x54,0x68,0x72,0x6F,0x75,0x67,0x68,0x20,0x74,0x68,0x65,0x20, \
                                        0x64,0x61,0x72,0x6B,0x20,0x6F,0x66,0x20,0x66,0x75,0x74,0x75,0x72,0x65,0x73,0x20, \
                                        0x70,0x61,0x73,0x74,0x21,0x0D,0x0A,0x54,0x68,0x65,0x20,0x6D,0x61,0x67,0x69,0x63, \
                                        0x69,0x61,0x6E,0x20,0x6C,0x6F,0x6E,0x67,0x73,0x20,0x74,0x6F,0x20,0x73,0x65,0x65, \
                                        0x21,0x0D,0x0A,0x4F,0x6E,0x65,0x20,0x63,0x68,0x61,0x6E,0x74,0x73,0x20,0x6F,0x75, \
                                        0x74,0x20,0x62,0x65,0x74,0x77,0x65,0x65,0x6E,0x20,0x74,0x77,0x6F,0x20,0x77,0x6F, \
                                        0x72,0x6C,0x64,0x73,0x21,0x0D,0x0A,0x46,0x49,0x52,0x45,0x20,0x57,0x41,0x4C,0x4B, \
                                        0x20,0x57,0x49,0x54,0x48,0x20,0x4D,0x45,0x21,0x0D,0x0A,0x42,0x4F,0x42,0x0D,0x0A");

#define PELOCK_MEMORY_GAP_HELPER _asm(".long\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
                                              0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
                                              0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
                                              0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0");

#define PELOCK_MEMORY_GAP _asm(".byte\t0xE9,0x04,0x20,0x00,0x00,0x8F,0xF1,0x12,0x34");\
PELOCK_MEMORY_GAP_HELPER PELOCK_MEMORY_GAP_HELPER PELOCK_MEMORY_GAP_HELPER PELOCK_MEMORY_GAP_HELPER \
PELOCK_MEMORY_GAP_HELPER PELOCK_MEMORY_GAP_HELPER PELOCK_MEMORY_GAP_HELPER PELOCK_MEMORY_GAP_HELPER \
PELOCK_MEMORY_GAP_HELPER PELOCK_MEMORY_GAP_HELPER PELOCK_MEMORY_GAP_HELPER PELOCK_MEMORY_GAP_HELPER \
PELOCK_MEMORY_GAP_HELPER PELOCK_MEMORY_GAP_HELPER PELOCK_MEMORY_GAP_HELPER PELOCK_MEMORY_GAP_HELPER

#define PELOCK_WATERMARK _asm(" .byte\t0xEB,0x7E,0x44,0x6F,0x77,0x6E,0x20,0x69,0x6E,0x20,0x74,0x68,0x65,0x20,0x70,0x61, \
                                       0x72,0x6B,0x0D,0x0A,0x57,0x68,0x65,0x72,0x65,0x20,0x74,0x68,0x65,0x20,0x63,0x68, \
                                       0x61,0x6E,0x74,0x20,0x69,0x73,0x20,0x64,0x65,0x61,0x74,0x68,0x2C,0x20,0x64,0x65, \
                                       0x61,0x74,0x68,0x2C,0x20,0x64,0x65,0x61,0x74,0x68,0x0D,0x0A,0x55,0x6E,0x74,0x69, \
                                       0x6C,0x20,0x74,0x68,0x65,0x20,0x73,0x75,0x6E,0x20,0x63,0x72,0x69,0x65,0x73,0x20, \
                                       0x6D,0x6F,0x72,0x6E,0x69,0x6E,0x67,0x0D,0x0A,0x44,0x6F,0x77,0x6E,0x20,0x69,0x6E, \
                                       0x20,0x74,0x68,0x65,0x20,0x70,0x61,0x72,0x6B,0x20,0x77,0x69,0x74,0x68,0x20,0x66, \
                                       0x72,0x69,0x65,0x6E,0x64,0x73,0x20,0x6F,0x66,0x20,0x6D,0x69,0x6E,0x65,0x0D,0x0A");

#define PELOCK_CPUID _asm(" .byte\t0xEB,0x7E,0x0D,0x0A,0x0D,0x0A,0x43,0x6F,0x6D,0x65,0x20,0x61,0x73,0x20,0x79,0x6F, \
                                   0x75,0x20,0x61,0x72,0x65,0x2C,0x20,0x61,0x73,0x20,0x79,0x6F,0x75,0x20,0x77,0x65, \
                                   0x72,0x65,0x0D,0x0A,0x41,0x73,0x20,0x49,0x20,0x77,0x61,0x6E,0x74,0x20,0x79,0x6F, \
                                   0x75,0x20,0x74,0x6F,0x20,0x62,0x65,0x0D,0x0A,0x41,0x73,0x20,0x61,0x20,0x66,0x72, \
                                   0x69,0x65,0x6E,0x64,0x2C,0x20,0x61,0x73,0x20,0x61,0x20,0x66,0x72,0x69,0x65,0x6E, \
                                   0x64,0x0D,0x0A,0x41,0x73,0x20,0x61,0x6E,0x20,0x6F,0x6C,0x64,0x20,0x65,0x6E,0x65, \
                                   0x6D,0x79,0x0D,0x0A,0x54,0x61,0x6B,0x65,0x20,0x79,0x6F,0x75,0x72,0x20,0x74,0x69, \
                                   0x6D,0x65,0x2C,0x20,0x68,0x75,0x72,0x72,0x79,0x20,0x75,0x70,0x0D,0x0A,0x0D,0x0A");

#define PELOCK_INIT_CALLBACK _asm(" .byte\t0xEB,0x08,0x10,0x11,0x22,0x33,0x33,0x22,0x11,0x00");

#define HARDWARE_ID_CALLBACK _asm(" .byte\t0xEB,0x08,0x4F,0x5A,0xF7,0x38,0x31,0xCD,0xE0,0x53");

#define __PELOCK_MACROS__
#endif

#endif

/* Pelles C */
#ifndef __PELOCK_MACROS__

#ifdef __POCC__
#define PELOCK_OPTIMIZE_OFF #pragma optimize(none)
#define PELOCK_OPTIMIZE_ON  #pragma optimize()

#define SKIP_START  __asm { db 0xEB,0x06,0x8B,0xE4,0x8B,0xC0,0xEB,0xFC };
#define SKIP_END    __asm { db 0xEB,0x06,0x8B,0xC0,0x8B,0xE4,0xEB,0xFA };

#define DEMO_START  __asm { db 0xEB,0x07,0xEB,0xFC,0xEB,0xFA,0xEB,0xFA,0xC7 }
#define DEMO_END    __asm { db 0xEB,0x06,0xEB,0xFB,0xEB,0xFA,0xEB,0xFC,0xEB, \
                               0x06,0xCD,0x20,0xEB,0xFD,0xCD,0x20,0xEB,0x07, \
                               0xEB,0xFB,0xEB,0xFA,0xEB,0xFC,0xC8 }

#define DEMO_START_MT  __asm { db 0xEB,0x07,0xEB,0xFC,0xEB,0xFA,0xEB,0xFA,0xD7 }
#define DEMO_END_MT    __asm { db 0xEB,0x06,0xEB,0xFB,0xEB,0xFA,0xEB,0xFC,0xEB, \
                                  0x06,0xCD,0x20,0xEB,0xFD,0xCD,0x20,0xEB,0x07, \
                                  0xEB,0xFB,0xEB,0xFA,0xEB,0xFC,0xD8 }

#define FEATURE_1_START  __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x00,0xFA,0xEB,0xFA,0xCA }
#define FEATURE_2_START  __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x01,0xFA,0xEB,0xFA,0xCA }
#define FEATURE_3_START  __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x02,0xFA,0xEB,0xFA,0xCA }
#define FEATURE_4_START  __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x03,0xFA,0xEB,0xFA,0xCA }
#define FEATURE_5_START  __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x04,0xFA,0xEB,0xFA,0xCA }
#define FEATURE_6_START  __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x05,0xFA,0xEB,0xFA,0xCA }
#define FEATURE_7_START  __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x06,0xFA,0xEB,0xFA,0xCA }
#define FEATURE_8_START  __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x07,0xFA,0xEB,0xFA,0xCA }
#define FEATURE_9_START  __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x08,0xFA,0xEB,0xFA,0xCA }
#define FEATURE_10_START __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x09,0xFA,0xEB,0xFA,0xCA }
#define FEATURE_11_START __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x0A,0xFA,0xEB,0xFA,0xCA }
#define FEATURE_12_START __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x0B,0xFA,0xEB,0xFA,0xCA }
#define FEATURE_13_START __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x0C,0xFA,0xEB,0xFA,0xCA }
#define FEATURE_14_START __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x0D,0xFA,0xEB,0xFA,0xCA }
#define FEATURE_15_START __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x0E,0xFA,0xEB,0xFA,0xCA }
#define FEATURE_16_START __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x0F,0xFA,0xEB,0xFA,0xCA }
#define FEATURE_17_START __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x10,0xFA,0xEB,0xFA,0xCA }
#define FEATURE_18_START __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x11,0xFA,0xEB,0xFA,0xCA }
#define FEATURE_19_START __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x12,0xFA,0xEB,0xFA,0xCA }
#define FEATURE_20_START __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x13,0xFA,0xEB,0xFA,0xCA }
#define FEATURE_21_START __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x14,0xFA,0xEB,0xFA,0xCA }
#define FEATURE_22_START __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x15,0xFA,0xEB,0xFA,0xCA }
#define FEATURE_23_START __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x16,0xFA,0xEB,0xFA,0xCA }
#define FEATURE_24_START __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x17,0xFA,0xEB,0xFA,0xCA }
#define FEATURE_25_START __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x18,0xFA,0xEB,0xFA,0xCA }
#define FEATURE_26_START __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x19,0xFA,0xEB,0xFA,0xCA }
#define FEATURE_27_START __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x1A,0xFA,0xEB,0xFA,0xCA }
#define FEATURE_28_START __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x1B,0xFA,0xEB,0xFA,0xCA }
#define FEATURE_29_START __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x1C,0xFA,0xEB,0xFA,0xCA }
#define FEATURE_30_START __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x1D,0xFA,0xEB,0xFA,0xCA }
#define FEATURE_31_START __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x1E,0xFA,0xEB,0xFA,0xCA }
#define FEATURE_32_START __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x1F,0xFA,0xEB,0xFA,0xCA }

#define FEATURE_END __asm { db 0xEB,0x06,0xEB,0xF1,0xEB,0xF2,0xEB,0xF3,0xEB, \
                               0x06,0xCD,0x20,0xEB,0xFD,0xCD,0x20,0xEB,0x07, \
                               0xEB,0xFB,0xEB,0xFA,0xEB,0xFC,0xCA }

#define FEATURE_1_START_MT  __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x00,0xFA,0xEB,0xFA,0xDA }
#define FEATURE_2_START_MT  __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x01,0xFA,0xEB,0xFA,0xDA }
#define FEATURE_3_START_MT  __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x02,0xFA,0xEB,0xFA,0xDA }
#define FEATURE_4_START_MT  __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x03,0xFA,0xEB,0xFA,0xDA }
#define FEATURE_5_START_MT  __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x04,0xFA,0xEB,0xFA,0xDA }
#define FEATURE_6_START_MT  __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x05,0xFA,0xEB,0xFA,0xDA }
#define FEATURE_7_START_MT  __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x06,0xFA,0xEB,0xFA,0xDA }
#define FEATURE_8_START_MT  __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x07,0xFA,0xEB,0xFA,0xDA }
#define FEATURE_9_START_MT  __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x08,0xFA,0xEB,0xFA,0xDA }
#define FEATURE_10_START_MT __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x09,0xFA,0xEB,0xFA,0xDA }
#define FEATURE_11_START_MT __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x0A,0xFA,0xEB,0xFA,0xDA }
#define FEATURE_12_START_MT __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x0B,0xFA,0xEB,0xFA,0xDA }
#define FEATURE_13_START_MT __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x0C,0xFA,0xEB,0xFA,0xDA }
#define FEATURE_14_START_MT __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x0D,0xFA,0xEB,0xFA,0xDA }
#define FEATURE_15_START_MT __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x0E,0xFA,0xEB,0xFA,0xDA }
#define FEATURE_16_START_MT __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x0F,0xFA,0xEB,0xFA,0xDA }
#define FEATURE_17_START_MT __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x10,0xFA,0xEB,0xFA,0xDA }
#define FEATURE_18_START_MT __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x11,0xFA,0xEB,0xFA,0xDA }
#define FEATURE_19_START_MT __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x12,0xFA,0xEB,0xFA,0xDA }
#define FEATURE_20_START_MT __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x13,0xFA,0xEB,0xFA,0xDA }
#define FEATURE_21_START_MT __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x14,0xFA,0xEB,0xFA,0xDA }
#define FEATURE_22_START_MT __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x15,0xFA,0xEB,0xFA,0xDA }
#define FEATURE_23_START_MT __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x16,0xFA,0xEB,0xFA,0xDA }
#define FEATURE_24_START_MT __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x17,0xFA,0xEB,0xFA,0xDA }
#define FEATURE_25_START_MT __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x18,0xFA,0xEB,0xFA,0xDA }
#define FEATURE_26_START_MT __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x19,0xFA,0xEB,0xFA,0xDA }
#define FEATURE_27_START_MT __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x1A,0xFA,0xEB,0xFA,0xDA }
#define FEATURE_28_START_MT __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x1B,0xFA,0xEB,0xFA,0xDA }
#define FEATURE_29_START_MT __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x1C,0xFA,0xEB,0xFA,0xDA }
#define FEATURE_30_START_MT __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x1D,0xFA,0xEB,0xFA,0xDA }
#define FEATURE_31_START_MT __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x1E,0xFA,0xEB,0xFA,0xDA }
#define FEATURE_32_START_MT __asm { db 0xEB,0x08,0xEB,0xFC,0xEB,0x1F,0xFA,0xEB,0xFA,0xDA }

#define FEATURE_END_MT __asm { db 0xEB,0x06,0xEB,0xF1,0xEB,0xF2,0xEB,0xF3,0xEB, \
                                  0x06,0xCD,0x20,0xEB,0xFD,0xCD,0x20,0xEB,0x07, \
                                  0xEB,0xFB,0xEB,0xFA,0xEB,0xFC,0xDA }

#define UNREGISTERED_START __asm { db 0xEB,0x07,0xEB,0x02,0xEB,0xFA,0xEB,0x01,0xCB }
#define UNREGISTERED_END   __asm { db 0xEB,0x06,0xEB,0x04,0xEB,0x02,0xEB,0x00,0xEB, \
                                      0x06,0xCD,0x22,0xEB,0xFC,0xCD,0x22,0xEB,0x07, \
                                      0xEB,0xFC,0xEB,0xFC,0xEB,0x01,0xCB }

#define UNREGISTERED_START_MT __asm { db 0xEB,0x07,0xEB,0x02,0xEB,0xFA,0xEB,0x01,0xDB }
#define UNREGISTERED_END_MT   __asm { db 0xEB,0x06,0xEB,0x04,0xEB,0x02,0xEB,0x00,0xEB, \
                                         0x06,0xCD,0x22,0xEB,0xFC,0xCD,0x22,0xEB,0x07, \
                                         0xEB,0xFC,0xEB,0xFC,0xEB,0x01,0xDB }

#define CRYPT_START __asm { db 0xEB,0x07,0xEB,0x05,0xEB,0x03,0xEB,0x01,0xC7 }
#define CRYPT_END   __asm { db 0xEB,0x06,0xEB,0x00,0xEB,0x00,0xEB,0x00,0xEB, \
                               0x06,0xCD,0x20,0xEB,0xFD,0xCD,0x20,0xEB,0x07, \
                               0xEB,0x05,0xEB,0x03,0xEB,0x01,0xC8 }

#define CRYPT_START_MT __asm { db 0xEB,0x07,0xEB,0x05,0xEB,0x03,0xEB,0x01,0xD7 }
#define CRYPT_END_MT   __asm { db 0xEB,0x06,0xEB,0x00,0xEB,0x00,0xEB,0x00,0xEB, \
                                  0x06,0xCD,0x20,0xEB,0xFD,0xCD,0x20,0xEB,0x07, \
                                  0xEB,0x05,0xEB,0x03,0xEB,0x01,0xD8 }

#define CLEAR_START __asm { db 0xEB,0x07,0xEB,0xFC,0xEB,0x00,0xEB,0x01,0xC9 }
#define CLEAR_END   __asm { db 0xEB,0x06,0xEB,0x02,0xEB,0xFC,0xEB,0x00,0xEB, \
                               0x06,0xCD,0x21,0xEB,0xFA,0xCD,0x21,0xEB,0x07, \
                               0xEB,0xFC,0xEB,0xFC,0xEB,0x01,0xC9 }

#define CLEAR_START_MT __asm { db 0xEB,0x07,0xEB,0xFC,0xEB,0x00,0xEB,0x01,0xD9 }
#define CLEAR_END_MT   __asm { db 0xEB,0x06,0xEB,0x02,0xEB,0xFC,0xEB,0x00,0xEB, \
                                  0x06,0xCD,0x21,0xEB,0xFA,0xCD,0x21,0xEB,0x07, \
                                  0xEB,0xFC,0xEB,0xFC,0xEB,0x01,0xD9 }

#define FILE_CRYPT_START __asm { db 0xEB,0x07,0xEB,0x02,0xEB,0xFC,0xEB,0x01,0xCA }
#define FILE_CRYPT_END   __asm { db 0xEB,0x06,0xEB,0xFC,0xEB,0xFC,0xEB,0x00,0xEB, \
                                    0x06,0xCD,0x20,0xEB,0xFD,0xCD,0x20,0xEB,0x07, \
                                    0xEB,0xFC,0xEB,0x03,0xEB,0xFC,0xCA }

#define FILE_CRYPT_START_MT __asm { db 0xEB,0x07,0xEB,0x02,0xEB,0xFC,0xEB,0x01,0xDA }
#define FILE_CRYPT_END_MT   __asm { db 0xEB,0x06,0xEB,0xFC,0xEB,0xFC,0xEB,0x00,0xEB, \
                                       0x06,0xCD,0x20,0xEB,0xFD,0xCD,0x20,0xEB,0x07, \
                                       0xEB,0xFC,0xEB,0x03,0xEB,0xFC,0xDA }

#define UNPROTECTED_START __asm { db 0xEB,0x06,0x8B,0xE4,0x89,0xED,0xEB,0xFC }
#define UNPROTECTED_END   __asm { db 0xEB,0x06,0x89,0xED,0x8B,0xE4,0xEB,0xFA }

#define TRIAL_EXPIRED __asm { db 0xEB,0x08,0x00,0x11,0x22,0x33,0x33,0x22,0x11,0x00 }

#define TRIAL_TOTAL_EXPIRED __asm { db 0xEB,0x08,0x01,0x11,0x22,0x33,0x33,0x22,0x11,0x00 }

#define PELOCK_CHECKPOINT __asm { db 0xEB,0x7E,0x0D,0x0A,0x54,0x68,0x72,0x6F,0x75,0x67,0x68,0x20,0x74,0x68,0x65,0x20, \
                                     0x64,0x61,0x72,0x6B,0x20,0x6F,0x66,0x20,0x66,0x75,0x74,0x75,0x72,0x65,0x73,0x20, \
                                     0x70,0x61,0x73,0x74,0x21,0x0D,0x0A,0x54,0x68,0x65,0x20,0x6D,0x61,0x67,0x69,0x63, \
                                     0x69,0x61,0x6E,0x20,0x6C,0x6F,0x6E,0x67,0x73,0x20,0x74,0x6F,0x20,0x73,0x65,0x65, \
                                     0x21,0x0D,0x0A,0x4F,0x6E,0x65,0x20,0x63,0x68,0x61,0x6E,0x74,0x73,0x20,0x6F,0x75, \
                                     0x74,0x20,0x62,0x65,0x74,0x77,0x65,0x65,0x6E,0x20,0x74,0x77,0x6F,0x20,0x77,0x6F, \
                                     0x72,0x6C,0x64,0x73,0x21,0x0D,0x0A,0x46,0x49,0x52,0x45,0x20,0x57,0x41,0x4C,0x4B, \
                                     0x20,0x57,0x49,0x54,0x48,0x20,0x4D,0x45,0x21,0x0D,0x0A,0x42,0x4F,0x42,0x0D,0x0A }

#define PELOCK_MEMORY_GAP_HELPER __asm { dq 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 }

#define PELOCK_MEMORY_GAP __asm { db 0xE9,0x04,0x20,0x00,0x00,0x8F,0xF1,0x12,0x34 } \
PELOCK_MEMORY_GAP_HELPER PELOCK_MEMORY_GAP_HELPER PELOCK_MEMORY_GAP_HELPER PELOCK_MEMORY_GAP_HELPER \
PELOCK_MEMORY_GAP_HELPER PELOCK_MEMORY_GAP_HELPER PELOCK_MEMORY_GAP_HELPER PELOCK_MEMORY_GAP_HELPER \
PELOCK_MEMORY_GAP_HELPER PELOCK_MEMORY_GAP_HELPER PELOCK_MEMORY_GAP_HELPER PELOCK_MEMORY_GAP_HELPER \
PELOCK_MEMORY_GAP_HELPER PELOCK_MEMORY_GAP_HELPER PELOCK_MEMORY_GAP_HELPER PELOCK_MEMORY_GAP_HELPER

#define PELOCK_WATERMARK __asm { db 0xEB,0x7E,0x44,0x6F,0x77,0x6E,0x20,0x69,0x6E,0x20,0x74,0x68,0x65,0x20,0x70,0x61, \
                                    0x72,0x6B,0x0D,0x0A,0x57,0x68,0x65,0x72,0x65,0x20,0x74,0x68,0x65,0x20,0x63,0x68, \
                                    0x61,0x6E,0x74,0x20,0x69,0x73,0x20,0x64,0x65,0x61,0x74,0x68,0x2C,0x20,0x64,0x65, \
                                    0x61,0x74,0x68,0x2C,0x20,0x64,0x65,0x61,0x74,0x68,0x0D,0x0A,0x55,0x6E,0x74,0x69, \
                                    0x6C,0x20,0x74,0x68,0x65,0x20,0x73,0x75,0x6E,0x20,0x63,0x72,0x69,0x65,0x73,0x20, \
                                    0x6D,0x6F,0x72,0x6E,0x69,0x6E,0x67,0x0D,0x0A,0x44,0x6F,0x77,0x6E,0x20,0x69,0x6E, \
                                    0x20,0x74,0x68,0x65,0x20,0x70,0x61,0x72,0x6B,0x20,0x77,0x69,0x74,0x68,0x20,0x66, \
                                    0x72,0x69,0x65,0x6E,0x64,0x73,0x20,0x6F,0x66,0x20,0x6D,0x69,0x6E,0x65,0x0D,0x0A }

#define PELOCK_CPUID __asm { db 0xEB,0x7E,0x0D,0x0A,0x0D,0x0A,0x43,0x6F,0x6D,0x65,0x20,0x61,0x73,0x20,0x79,0x6F, \
                                0x75,0x20,0x61,0x72,0x65,0x2C,0x20,0x61,0x73,0x20,0x79,0x6F,0x75,0x20,0x77,0x65, \
                                0x72,0x65,0x0D,0x0A,0x41,0x73,0x20,0x49,0x20,0x77,0x61,0x6E,0x74,0x20,0x79,0x6F, \
                                0x75,0x20,0x74,0x6F,0x20,0x62,0x65,0x0D,0x0A,0x41,0x73,0x20,0x61,0x20,0x66,0x72, \
                                0x69,0x65,0x6E,0x64,0x2C,0x20,0x61,0x73,0x20,0x61,0x20,0x66,0x72,0x69,0x65,0x6E, \
                                0x64,0x0D,0x0A,0x41,0x73,0x20,0x61,0x6E,0x20,0x6F,0x6C,0x64,0x20,0x65,0x6E,0x65, \
                                0x6D,0x79,0x0D,0x0A,0x54,0x61,0x6B,0x65,0x20,0x79,0x6F,0x75,0x72,0x20,0x74,0x69, \
                                0x6D,0x65,0x2C,0x20,0x68,0x75,0x72,0x72,0x79,0x20,0x75,0x70,0x0D,0x0A,0x0D,0x0A }

#define PELOCK_INIT_CALLBACK __asm { db 0xEB,0x08,0x10,0x11,0x22,0x33,0x33,0x22,0x11,0x00 }

#define HARDWARE_ID_CALLBACK __asm { db 0xEB,0x08,0x4F,0x5A,0xF7,0x38,0x31,0xCD,0xE0,0x53 }

#define __PELOCK_MACROS__
#endif

#endif

/* GCC, MINGW32, TCC */
#ifndef __PELOCK_MACROS__

#if defined (__GNUC__) || defined (__TINYC__)
#define PELOCK_OPTIMIZE_OFF #pragma optimize("", off)
#define PELOCK_OPTIMIZE_ON  #pragma optimize("", on)

#define SKIP_START  __asm__ __volatile__(" .byte\t0xEB,0x06,0x8B,0xE4,0x8B,0xC0,0xEB,0xFC");
#define SKIP_END    __asm__ __volatile__(" .byte\t0xEB,0x06,0x8B,0xC0,0x8B,0xE4,0xEB,0xFA");

#define DEMO_START  __asm__ __volatile__(" .byte\t0xEB,0x07,0xEB,0xFC,0xEB,0xFA,0xEB,0xFA,0xC7");
#define DEMO_END    __asm__ __volatile__(" .byte\t0xEB,0x06,0xEB,0xFB,0xEB,0xFA,0xEB,0xFC,0xEB, \
                                     0x06,0xCD,0x20,0xEB,0xFD,0xCD,0x20,0xEB,0x07, \
                                     0xEB,0xFB,0xEB,0xFA,0xEB,0xFC,0xC8");

#define DEMO_START_MT  __asm__ __volatile__(" .byte\t0xEB,0x07,0xEB,0xFC,0xEB,0xFA,0xEB,0xFA,0xD7");
#define DEMO_END_MT    __asm__ __volatile__(" .byte\t0xEB,0x06,0xEB,0xFB,0xEB,0xFA,0xEB,0xFC,0xEB, \
                                        0x06,0xCD,0x20,0xEB,0xFD,0xCD,0x20,0xEB,0x07, \
                                        0xEB,0xFB,0xEB,0xFA,0xEB,0xFC,0xD8");

#define FEATURE_1_START  __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x00,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_2_START  __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x01,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_3_START  __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x02,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_4_START  __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x03,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_5_START  __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x04,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_6_START  __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x05,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_7_START  __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x06,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_8_START  __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x07,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_9_START  __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x08,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_10_START __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x09,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_11_START __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x0A,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_12_START __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x0B,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_13_START __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x0C,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_14_START __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x0D,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_15_START __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x0E,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_16_START __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x0F,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_17_START __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x10,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_18_START __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x11,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_19_START __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x12,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_20_START __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x13,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_21_START __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x14,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_22_START __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x15,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_23_START __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x16,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_24_START __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x17,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_25_START __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x18,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_26_START __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x19,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_27_START __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x1A,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_28_START __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x1B,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_29_START __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x1C,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_30_START __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x1D,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_31_START __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x1E,0xFA,0xEB,0xFA,0xCA");
#define FEATURE_32_START __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x1F,0xFA,0xEB,0xFA,0xCA");

#define FEATURE_END __asm__ __volatile__(" .byte\t0xEB,0x06,0xEB,0xF1,0xEB,0xF2,0xEB,0xF3,0xEB, \
                                     0x06,0xCD,0x20,0xEB,0xFD,0xCD,0x20,0xEB,0x07, \
                                     0xEB,0xFB,0xEB,0xFA,0xEB,0xFC,0xCA");

#define FEATURE_1_START_MT  __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x00,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_2_START_MT  __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x01,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_3_START_MT  __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x02,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_4_START_MT  __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x03,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_5_START_MT  __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x04,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_6_START_MT  __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x05,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_7_START_MT  __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x06,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_8_START_MT  __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x07,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_9_START_MT  __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x08,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_10_START_MT __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x09,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_11_START_MT __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x0A,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_12_START_MT __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x0B,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_13_START_MT __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x0C,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_14_START_MT __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x0D,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_15_START_MT __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x0E,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_16_START_MT __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x0F,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_17_START_MT __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x10,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_18_START_MT __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x11,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_19_START_MT __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x12,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_20_START_MT __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x13,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_21_START_MT __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x14,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_22_START_MT __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x15,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_23_START_MT __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x16,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_24_START_MT __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x17,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_25_START_MT __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x18,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_26_START_MT __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x19,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_27_START_MT __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x1A,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_28_START_MT __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x1B,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_29_START_MT __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x1C,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_30_START_MT __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x1D,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_31_START_MT __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x1E,0xFA,0xEB,0xFA,0xDA");
#define FEATURE_32_START_MT __asm__ __volatile__(" .byte\t0xEB,0x08,0xEB,0xFC,0xEB,0x1F,0xFA,0xEB,0xFA,0xDA");

#define FEATURE_END_MT __asm__ __volatile__(" .byte\t0xEB,0x06,0xEB,0xF1,0xEB,0xF2,0xEB,0xF3,0xEB, \
                                        0x06,0xCD,0x20,0xEB,0xFD,0xCD,0x20,0xEB,0x07, \
                                        0xEB,0xFB,0xEB,0xFA,0xEB,0xFC,0xDA");

#define UNREGISTERED_START __asm__ __volatile__(" .byte\t0xEB,0x07,0xEB,0x02,0xEB,0xFA,0xEB,0x01,0xCB");
#define UNREGISTERED_END   __asm__ __volatile__(" .byte\t0xEB,0x06,0xEB,0x04,0xEB,0x02,0xEB,0x00,0xEB, \
                                            0x06,0xCD,0x22,0xEB,0xFC,0xCD,0x22,0xEB,0x07, \
                                            0xEB,0xFC,0xEB,0xFC,0xEB,0x01,0xCB");

#define UNREGISTERED_START_MT __asm__ __volatile__(" .byte\t0xEB,0x07,0xEB,0x02,0xEB,0xFA,0xEB,0x01,0xDB");
#define UNREGISTERED_END_MT   __asm__ __volatile__(" .byte\t0xEB,0x06,0xEB,0x04,0xEB,0x02,0xEB,0x00,0xEB, \
                                               0x06,0xCD,0x22,0xEB,0xFC,0xCD,0x22,0xEB,0x07, \
                                               0xEB,0xFC,0xEB,0xFC,0xEB,0x01,0xDB");

#define CRYPT_START __asm__ __volatile__(" .byte\t0xEB,0x07,0xEB,0x05,0xEB,0x03,0xEB,0x01,0xC7");
#define CRYPT_END   __asm__ __volatile__(" .byte\t0xEB,0x06,0xEB,0x00,0xEB,0x00,0xEB,0x00,0xEB, \
                                     0x06,0xCD,0x20,0xEB,0xFD,0xCD,0x20,0xEB,0x07, \
                                     0xEB,0x05,0xEB,0x03,0xEB,0x01,0xC8");

#define CRYPT_START_MT __asm__ __volatile__(" .byte\t0xEB,0x07,0xEB,0x05,0xEB,0x03,0xEB,0x01,0xD7");
#define CRYPT_END_MT   __asm__ __volatile__(" .byte\t0xEB,0x06,0xEB,0x00,0xEB,0x00,0xEB,0x00,0xEB, \
                                        0x06,0xCD,0x20,0xEB,0xFD,0xCD,0x20,0xEB,0x07, \
                                        0xEB,0x05,0xEB,0x03,0xEB,0x01,0xD8");

#define CLEAR_START __asm__ __volatile__(" .byte\t0xEB,0x07,0xEB,0xFC,0xEB,0x00,0xEB,0x01,0xC9");
#define CLEAR_END   __asm__ __volatile__(" .byte\t0xEB,0x06,0xEB,0x02,0xEB,0xFC,0xEB,0x00,0xEB, \
                                     0x06,0xCD,0x21,0xEB,0xFA,0xCD,0x21,0xEB,0x07, \
                                     0xEB,0xFC,0xEB,0xFC,0xEB,0x01,0xC9");

#define CLEAR_START_MT __asm__ __volatile__(" .byte\t0xEB,0x07,0xEB,0xFC,0xEB,0x00,0xEB,0x01,0xD9");
#define CLEAR_END_MT   __asm__ __volatile__(" .byte\t0xEB,0x06,0xEB,0x02,0xEB,0xFC,0xEB,0x00,0xEB, \
                                        0x06,0xCD,0x21,0xEB,0xFA,0xCD,0x21,0xEB,0x07, \
                                        0xEB,0xFC,0xEB,0xFC,0xEB,0x01,0xD9");

#define FILE_CRYPT_START __asm__ __volatile__(" .byte\t0xEB,0x07,0xEB,0x02,0xEB,0xFC,0xEB,0x01,0xCA");
#define FILE_CRYPT_END   __asm__ __volatile__(" .byte\t0xEB,0x06,0xEB,0xFC,0xEB,0xFC,0xEB,0x00,0xEB, \
                                          0x06,0xCD,0x20,0xEB,0xFD,0xCD,0x20,0xEB,0x07, \
                                          0xEB,0xFC,0xEB,0x03,0xEB,0xFC,0xCA");

#define FILE_CRYPT_START_MT __asm__ __volatile__(" .byte\t0xEB,0x07,0xEB,0x02,0xEB,0xFC,0xEB,0x01,0xDA");
#define FILE_CRYPT_END_MT   __asm__ __volatile__(" .byte\t0xEB,0x06,0xEB,0xFC,0xEB,0xFC,0xEB,0x00,0xEB, \
                                             0x06,0xCD,0x20,0xEB,0xFD,0xCD,0x20,0xEB,0x07, \
                                             0xEB,0xFC,0xEB,0x03,0xEB,0xFC,0xDA");

#define UNPROTECTED_START __asm__ __volatile__(" .byte\t0xEB,0x06,0x8B,0xE4,0x89,0xED,0xEB,0xFC");
#define UNPROTECTED_END   __asm__ __volatile__(" .byte\t0xEB,0x06,0x89,0xED,0x8B,0xE4,0xEB,0xFA");

#define TRIAL_EXPIRED __asm__ __volatile__(" .byte\t0xEB,0x08,0x00,0x11,0x22,0x33,0x33,0x22,0x11,0x00");

#define TRIAL_TOTAL_EXPIRED __asm__ __volatile__(" .byte\t0xEB,0x08,0x01,0x11,0x22,0x33,0x33,0x22,0x11,0x00");

#define PELOCK_CHECKPOINT __asm__ __volatile__(" .byte\t0xEB,0x7E,0x0D,0x0A,0x54,0x68,0x72,0x6F,0x75,0x67,0x68,0x20,0x74,0x68,0x65,0x20, \
                                           0x64,0x61,0x72,0x6B,0x20,0x6F,0x66,0x20,0x66,0x75,0x74,0x75,0x72,0x65,0x73,0x20, \
                                           0x70,0x61,0x73,0x74,0x21,0x0D,0x0A,0x54,0x68,0x65,0x20,0x6D,0x61,0x67,0x69,0x63, \
                                           0x69,0x61,0x6E,0x20,0x6C,0x6F,0x6E,0x67,0x73,0x20,0x74,0x6F,0x20,0x73,0x65,0x65, \
                                           0x21,0x0D,0x0A,0x4F,0x6E,0x65,0x20,0x63,0x68,0x61,0x6E,0x74,0x73,0x20,0x6F,0x75, \
                                           0x74,0x20,0x62,0x65,0x74,0x77,0x65,0x65,0x6E,0x20,0x74,0x77,0x6F,0x20,0x77,0x6F, \
                                           0x72,0x6C,0x64,0x73,0x21,0x0D,0x0A,0x46,0x49,0x52,0x45,0x20,0x57,0x41,0x4C,0x4B, \
                                           0x20,0x57,0x49,0x54,0x48,0x20,0x4D,0x45,0x21,0x0D,0x0A,0x42,0x4F,0x42,0x0D,0x0A");

#define PELOCK_MEMORY_GAP_HELPER __asm__ __volatile__(".long\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
                                                 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
                                                 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
                                                 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0");

#define PELOCK_MEMORY_GAP __asm__ __volatile__(".byte\t0xE9,0x04,0x20,0x00,0x00,0x8F,0xF1,0x12,0x34");\
PELOCK_MEMORY_GAP_HELPER PELOCK_MEMORY_GAP_HELPER PELOCK_MEMORY_GAP_HELPER PELOCK_MEMORY_GAP_HELPER \
PELOCK_MEMORY_GAP_HELPER PELOCK_MEMORY_GAP_HELPER PELOCK_MEMORY_GAP_HELPER PELOCK_MEMORY_GAP_HELPER \
PELOCK_MEMORY_GAP_HELPER PELOCK_MEMORY_GAP_HELPER PELOCK_MEMORY_GAP_HELPER PELOCK_MEMORY_GAP_HELPER \
PELOCK_MEMORY_GAP_HELPER PELOCK_MEMORY_GAP_HELPER PELOCK_MEMORY_GAP_HELPER PELOCK_MEMORY_GAP_HELPER

#define PELOCK_WATERMARK __asm__ __volatile__(" .byte\t0xEB,0x7E,0x44,0x6F,0x77,0x6E,0x20,0x69,0x6E,0x20,0x74,0x68,0x65,0x20,0x70,0x61, \
                                          0x72,0x6B,0x0D,0x0A,0x57,0x68,0x65,0x72,0x65,0x20,0x74,0x68,0x65,0x20,0x63,0x68, \
                                          0x61,0x6E,0x74,0x20,0x69,0x73,0x20,0x64,0x65,0x61,0x74,0x68,0x2C,0x20,0x64,0x65, \
                                          0x61,0x74,0x68,0x2C,0x20,0x64,0x65,0x61,0x74,0x68,0x0D,0x0A,0x55,0x6E,0x74,0x69, \
                                          0x6C,0x20,0x74,0x68,0x65,0x20,0x73,0x75,0x6E,0x20,0x63,0x72,0x69,0x65,0x73,0x20, \
                                          0x6D,0x6F,0x72,0x6E,0x69,0x6E,0x67,0x0D,0x0A,0x44,0x6F,0x77,0x6E,0x20,0x69,0x6E, \
                                          0x20,0x74,0x68,0x65,0x20,0x70,0x61,0x72,0x6B,0x20,0x77,0x69,0x74,0x68,0x20,0x66, \
                                          0x72,0x69,0x65,0x6E,0x64,0x73,0x20,0x6F,0x66,0x20,0x6D,0x69,0x6E,0x65,0x0D,0x0A");

#define PELOCK_CPUID __asm__ __volatile__(" .byte\t0xEB,0x7E,0x0D,0x0A,0x0D,0x0A,0x43,0x6F,0x6D,0x65,0x20,0x61,0x73,0x20,0x79,0x6F, \
                                      0x75,0x20,0x61,0x72,0x65,0x2C,0x20,0x61,0x73,0x20,0x79,0x6F,0x75,0x20,0x77,0x65, \
                                      0x72,0x65,0x0D,0x0A,0x41,0x73,0x20,0x49,0x20,0x77,0x61,0x6E,0x74,0x20,0x79,0x6F, \
                                      0x75,0x20,0x74,0x6F,0x20,0x62,0x65,0x0D,0x0A,0x41,0x73,0x20,0x61,0x20,0x66,0x72, \
                                      0x69,0x65,0x6E,0x64,0x2C,0x20,0x61,0x73,0x20,0x61,0x20,0x66,0x72,0x69,0x65,0x6E, \
                                      0x64,0x0D,0x0A,0x41,0x73,0x20,0x61,0x6E,0x20,0x6F,0x6C,0x64,0x20,0x65,0x6E,0x65, \
                                      0x6D,0x79,0x0D,0x0A,0x54,0x61,0x6B,0x65,0x20,0x79,0x6F,0x75,0x72,0x20,0x74,0x69, \
                                      0x6D,0x65,0x2C,0x20,0x68,0x75,0x72,0x72,0x79,0x20,0x75,0x70,0x0D,0x0A,0x0D,0x0A");

#define PELOCK_INIT_CALLBACK __asm__ __volatile__(" .byte\t0xEB,0x08,0x10,0x11,0x22,0x33,0x33,0x22,0x11,0x00");

#define HARDWARE_ID_CALLBACK __asm__ __volatile__(" .byte\t0xEB,0x08,0x4F,0x5A,0xF7,0x38,0x31,0xCD,0xE0,0x53");

#define __PELOCK_MACROS__
#endif

#endif

/* other compilers, Microsoft Visual C++, Intel CPP Compiler, Digital Mars etc. */
#ifndef __PELOCK_MACROS__

#define PELOCK_OPTIMIZE_OFF #pragma optimize("", off)
#define PELOCK_OPTIMIZE_ON  #pragma optimize("", on)

#define SKIP_START \
{ \
__asm __emit 0xEB __asm __emit 0x06 __asm __emit 0x8B __asm __emit 0xE4 \
__asm __emit 0x8B __asm __emit 0xC0 __asm __emit 0xEB __asm __emit 0xFC \
}

#define SKIP_END \
{ \
__asm __emit 0xEB __asm __emit 0x06 __asm __emit 0x8B __asm __emit 0xC0 \
__asm __emit 0x8B __asm __emit 0xE4 __asm __emit 0xEB __asm __emit 0xFA \
}

#define DEMO_START \
{ \
__asm __emit 0xEB __asm __emit 0x07 __asm __emit 0xEB __asm __emit 0xFC \
__asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA \
__asm __emit 0xC7 \
}

#define DEMO_END \
{ \
__asm __emit 0xEB __asm __emit 0x06 __asm __emit 0xEB __asm __emit 0xFB \
__asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFC \
__asm __emit 0xEB __asm __emit 0x06 __asm __emit 0xCD __asm __emit 0x20 \
__asm __emit 0xEB __asm __emit 0xFD __asm __emit 0xCD __asm __emit 0x20 \
__asm __emit 0xEB __asm __emit 0x07 __asm __emit 0xEB __asm __emit 0xFB \
__asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFC \
__asm __emit 0xC8 \
}

#define DEMO_START_MT \
{ \
__asm __emit 0xEB __asm __emit 0x07 __asm __emit 0xEB __asm __emit 0xFC \
__asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA \
__asm __emit 0xD7 \
}

#define DEMO_END_MT \
{ \
__asm __emit 0xEB __asm __emit 0x06 __asm __emit 0xEB __asm __emit 0xFB \
__asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFC \
__asm __emit 0xEB __asm __emit 0x06 __asm __emit 0xCD __asm __emit 0x20 \
__asm __emit 0xEB __asm __emit 0xFD __asm __emit 0xCD __asm __emit 0x20 \
__asm __emit 0xEB __asm __emit 0x07 __asm __emit 0xEB __asm __emit 0xFB \
__asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFC \
__asm __emit 0xD8 \
}

#define FEATURE_1_START  { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x00 __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xCA }
#define FEATURE_2_START  { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x01 __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xCA }
#define FEATURE_3_START  { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x02 __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xCA }
#define FEATURE_4_START  { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x03 __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xCA }
#define FEATURE_5_START  { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x04 __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xCA }
#define FEATURE_6_START  { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x05 __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xCA }
#define FEATURE_7_START  { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x06 __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xCA }
#define FEATURE_8_START  { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x07 __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xCA }
#define FEATURE_9_START  { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xCA }
#define FEATURE_10_START { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x09 __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xCA }
#define FEATURE_11_START { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x0A __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xCA }
#define FEATURE_12_START { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x0B __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xCA }
#define FEATURE_13_START { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x0C __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xCA }
#define FEATURE_14_START { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x0D __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xCA }
#define FEATURE_15_START { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x0E __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xCA }
#define FEATURE_16_START { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x0F __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xCA }
#define FEATURE_17_START { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x10 __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xCA }
#define FEATURE_18_START { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x11 __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xCA }
#define FEATURE_19_START { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x12 __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xCA }
#define FEATURE_20_START { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x13 __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xCA }
#define FEATURE_21_START { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x14 __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xCA }
#define FEATURE_22_START { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x15 __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xCA }
#define FEATURE_23_START { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x16 __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xCA }
#define FEATURE_24_START { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x17 __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xCA }
#define FEATURE_25_START { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x18 __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xCA }
#define FEATURE_26_START { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x19 __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xCA }
#define FEATURE_27_START { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x1A __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xCA }
#define FEATURE_28_START { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x1B __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xCA }
#define FEATURE_29_START { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x1C __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xCA }
#define FEATURE_30_START { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x1D __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xCA }
#define FEATURE_31_START { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x1E __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xCA }
#define FEATURE_32_START { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x1F __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xCA }

#define FEATURE_END { __asm __emit 0xEB __asm __emit 0x06 __asm __emit 0xEB __asm __emit 0xF1 __asm __emit 0xEB __asm __emit 0xF2 __asm __emit 0xEB __asm __emit 0xF3 __asm __emit 0xEB __asm __emit 0x06 __asm __emit 0xCD __asm __emit 0x20 __asm __emit 0xEB __asm __emit 0xFD __asm __emit 0xCD __asm __emit 0x20 __asm __emit 0xEB __asm __emit 0x07 __asm __emit 0xEB __asm __emit 0xFB __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xCA }

#define FEATURE_1_START_MT  { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x00 __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xDA }
#define FEATURE_2_START_MT  { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x01 __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xDA }
#define FEATURE_3_START_MT  { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x02 __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xDA }
#define FEATURE_4_START_MT  { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x03 __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xDA }
#define FEATURE_5_START_MT  { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x04 __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xDA }
#define FEATURE_6_START_MT  { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x05 __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xDA }
#define FEATURE_7_START_MT  { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x06 __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xDA }
#define FEATURE_8_START_MT  { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x07 __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xDA }
#define FEATURE_9_START_MT  { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xDA }
#define FEATURE_10_START_MT { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x09 __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xDA }
#define FEATURE_11_START_MT { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x0A __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xDA }
#define FEATURE_12_START_MT { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x0B __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xDA }
#define FEATURE_13_START_MT { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x0C __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xDA }
#define FEATURE_14_START_MT { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x0D __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xDA }
#define FEATURE_15_START_MT { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x0E __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xDA }
#define FEATURE_16_START_MT { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x0F __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xDA }
#define FEATURE_17_START_MT { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x10 __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xDA }
#define FEATURE_18_START_MT { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x11 __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xDA }
#define FEATURE_19_START_MT { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x12 __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xDA }
#define FEATURE_20_START_MT { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x13 __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xDA }
#define FEATURE_21_START_MT { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x14 __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xDA }
#define FEATURE_22_START_MT { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x15 __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xDA }
#define FEATURE_23_START_MT { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x16 __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xDA }
#define FEATURE_24_START_MT { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x17 __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xDA }
#define FEATURE_25_START_MT { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x18 __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xDA }
#define FEATURE_26_START_MT { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x19 __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xDA }
#define FEATURE_27_START_MT { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x1A __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xDA }
#define FEATURE_28_START_MT { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x1B __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xDA }
#define FEATURE_29_START_MT { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x1C __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xDA }
#define FEATURE_30_START_MT { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x1D __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xDA }
#define FEATURE_31_START_MT { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x1E __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xDA }
#define FEATURE_32_START_MT { __asm __emit 0xEB __asm __emit 0x08 __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x1F __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xDA }

#define FEATURE_END_MT { __asm __emit 0xEB __asm __emit 0x06 __asm __emit 0xEB __asm __emit 0xF1 __asm __emit 0xEB __asm __emit 0xF2 __asm __emit 0xEB __asm __emit 0xF3 __asm __emit 0xEB __asm __emit 0x06 __asm __emit 0xCD __asm __emit 0x20 __asm __emit 0xEB __asm __emit 0xFD __asm __emit 0xCD __asm __emit 0x20 __asm __emit 0xEB __asm __emit 0x07 __asm __emit 0xEB __asm __emit 0xFB __asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xDA }

#define UNREGISTERED_START \
{ \
__asm __emit 0xEB __asm __emit 0x07 __asm __emit 0xEB __asm __emit 0x02 \
__asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0x01 \
__asm __emit 0xCB \
}

#define UNREGISTERED_END \
{ \
__asm __emit 0xEB __asm __emit 0x06 __asm __emit 0xEB __asm __emit 0x04 \
__asm __emit 0xEB __asm __emit 0x02 __asm __emit 0xEB __asm __emit 0x00 \
__asm __emit 0xEB __asm __emit 0x06 __asm __emit 0xCD __asm __emit 0x22 \
__asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xCD __asm __emit 0x22 \
__asm __emit 0xEB __asm __emit 0x07 __asm __emit 0xEB __asm __emit 0xFC \
__asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x01 \
__asm __emit 0xCB \
}

#define UNREGISTERED_START_MT \
{ \
__asm __emit 0xEB __asm __emit 0x07 __asm __emit 0xEB __asm __emit 0x02 \
__asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xEB __asm __emit 0x01 \
__asm __emit 0xDB \
}

#define UNREGISTERED_END_MT \
{ \
__asm __emit 0xEB __asm __emit 0x06 __asm __emit 0xEB __asm __emit 0x04 \
__asm __emit 0xEB __asm __emit 0x02 __asm __emit 0xEB __asm __emit 0x00 \
__asm __emit 0xEB __asm __emit 0x06 __asm __emit 0xCD __asm __emit 0x22 \
__asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xCD __asm __emit 0x22 \
__asm __emit 0xEB __asm __emit 0x07 __asm __emit 0xEB __asm __emit 0xFC \
__asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x01 \
__asm __emit 0xDB \
}

#define CRYPT_START \
{ \
__asm __emit 0xEB __asm __emit 0x07 __asm __emit 0xEB __asm __emit 0x05 \
__asm __emit 0xEB __asm __emit 0x03 __asm __emit 0xEB __asm __emit 0x01 \
__asm __emit 0xC7 \
}

#define CRYPT_END \
{ \
__asm __emit 0xEB __asm __emit 0x06 __asm __emit 0xEB __asm __emit 0x00 \
__asm __emit 0xEB __asm __emit 0x00 __asm __emit 0xEB __asm __emit 0x00 \
__asm __emit 0xEB __asm __emit 0x06 __asm __emit 0xCD __asm __emit 0x20 \
__asm __emit 0xEB __asm __emit 0xFD __asm __emit 0xCD __asm __emit 0x20 \
__asm __emit 0xEB __asm __emit 0x07 __asm __emit 0xEB __asm __emit 0x05 \
__asm __emit 0xEB __asm __emit 0x03 __asm __emit 0xEB __asm __emit 0x01 \
__asm __emit 0xC8 \
}

#define CRYPT_START_MT \
{ \
__asm __emit 0xEB __asm __emit 0x07 __asm __emit 0xEB __asm __emit 0x05 \
__asm __emit 0xEB __asm __emit 0x03 __asm __emit 0xEB __asm __emit 0x01 \
__asm __emit 0xD7 \
}

#define CRYPT_END_MT \
{ \
__asm __emit 0xEB __asm __emit 0x06 __asm __emit 0xEB __asm __emit 0x00 \
__asm __emit 0xEB __asm __emit 0x00 __asm __emit 0xEB __asm __emit 0x00 \
__asm __emit 0xEB __asm __emit 0x06 __asm __emit 0xCD __asm __emit 0x20 \
__asm __emit 0xEB __asm __emit 0xFD __asm __emit 0xCD __asm __emit 0x20 \
__asm __emit 0xEB __asm __emit 0x07 __asm __emit 0xEB __asm __emit 0x05 \
__asm __emit 0xEB __asm __emit 0x03 __asm __emit 0xEB __asm __emit 0x01 \
__asm __emit 0xD8 \
}

#define CLEAR_START \
{ \
__asm __emit 0xEB __asm __emit 0x07 __asm __emit 0xEB __asm __emit 0xFC \
__asm __emit 0xEB __asm __emit 0x00 __asm __emit 0xEB __asm __emit 0x01 \
__asm __emit 0xC9 \
}

#define CLEAR_END \
{ \
__asm __emit 0xEB __asm __emit 0x06 __asm __emit 0xEB __asm __emit 0x02 \
__asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x00 \
__asm __emit 0xEB __asm __emit 0x06 __asm __emit 0xCD __asm __emit 0x21 \
__asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xCD __asm __emit 0x21 \
__asm __emit 0xEB __asm __emit 0x07 __asm __emit 0xEB __asm __emit 0xFC \
__asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x01 \
__asm __emit 0xC9 \
}

#define CLEAR_START_MT \
{ \
__asm __emit 0xEB __asm __emit 0x07 __asm __emit 0xEB __asm __emit 0xFC \
__asm __emit 0xEB __asm __emit 0x00 __asm __emit 0xEB __asm __emit 0x01 \
__asm __emit 0xD9 \
}

#define CLEAR_END_MT \
{ \
__asm __emit 0xEB __asm __emit 0x06 __asm __emit 0xEB __asm __emit 0x02 \
__asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x00 \
__asm __emit 0xEB __asm __emit 0x06 __asm __emit 0xCD __asm __emit 0x21 \
__asm __emit 0xEB __asm __emit 0xFA __asm __emit 0xCD __asm __emit 0x21 \
__asm __emit 0xEB __asm __emit 0x07 __asm __emit 0xEB __asm __emit 0xFC \
__asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x01 \
__asm __emit 0xD9 \
}

#define FILE_CRYPT_START \
{ \
__asm __emit 0xEB __asm __emit 0x07 __asm __emit 0xEB __asm __emit 0x02 \
__asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x01 \
__asm __emit 0xCA \
}

#define FILE_CRYPT_END \
{ \
__asm __emit 0xEB __asm __emit 0x06 __asm __emit 0xEB __asm __emit 0xFC \
__asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x00 \
__asm __emit 0xEB __asm __emit 0x06 __asm __emit 0xCD __asm __emit 0x20 \
__asm __emit 0xEB __asm __emit 0xFD __asm __emit 0xCD __asm __emit 0x20 \
__asm __emit 0xEB __asm __emit 0x07 __asm __emit 0xEB __asm __emit 0xFC \
__asm __emit 0xEB __asm __emit 0x03 __asm __emit 0xEB __asm __emit 0xFC \
__asm __emit 0xCA \
}

#define FILE_CRYPT_START_MT \
{ \
__asm __emit 0xEB __asm __emit 0x07 __asm __emit 0xEB __asm __emit 0x02 \
__asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x01 \
__asm __emit 0xDA \
}

#define FILE_CRYPT_END_MT \
{ \
__asm __emit 0xEB __asm __emit 0x06 __asm __emit 0xEB __asm __emit 0xFC \
__asm __emit 0xEB __asm __emit 0xFC __asm __emit 0xEB __asm __emit 0x00 \
__asm __emit 0xEB __asm __emit 0x06 __asm __emit 0xCD __asm __emit 0x20 \
__asm __emit 0xEB __asm __emit 0xFD __asm __emit 0xCD __asm __emit 0x20 \
__asm __emit 0xEB __asm __emit 0x07 __asm __emit 0xEB __asm __emit 0xFC \
__asm __emit 0xEB __asm __emit 0x03 __asm __emit 0xEB __asm __emit 0xFC \
__asm __emit 0xDA \
}


#define UNPROTECTED_START \
{ \
__asm __emit 0xEB __asm __emit 0x06 __asm __emit 0x8B __asm __emit 0xE4 \
__asm __emit 0x89 __asm __emit 0xED __asm __emit 0xEB __asm __emit 0xFC \
}

#define UNPROTECTED_END \
__asm __emit 0xEB __asm __emit 0x06 __asm __emit 0x89 __asm __emit 0xED \
__asm __emit 0x8B __asm __emit 0xE4 __asm __emit 0xEB __asm __emit 0xFA \
}

#define TRIAL_EXPIRED \
{ \
__asm __emit 0xEB __asm __emit 0x08 __asm __emit 0x00 __asm __emit 0x11 \
__asm __emit 0x22 __asm __emit 0x33 __asm __emit 0x33 __asm __emit 0x22 \
__asm __emit 0x11 __asm __emit 0x00 \
}

#define TRIAL_TOTAL_EXPIRED \
{ \
__asm __emit 0xEB __asm __emit 0x08 __asm __emit 0x01 __asm __emit 0x11 \
__asm __emit 0x22 __asm __emit 0x33 __asm __emit 0x33 __asm __emit 0x22 \
__asm __emit 0x11 __asm __emit 0x00 \
}

#define PELOCK_CHECKPOINT \
{ \
__asm __emit 0xEB __asm __emit 0x7E __asm __emit 0x0D __asm __emit 0x0A \
__asm __emit 0x54 __asm __emit 0x68 __asm __emit 0x72 __asm __emit 0x6F \
__asm __emit 0x75 __asm __emit 0x67 __asm __emit 0x68 __asm __emit 0x20 \
__asm __emit 0x74 __asm __emit 0x68 __asm __emit 0x65 __asm __emit 0x20 \
__asm __emit 0x64 __asm __emit 0x61 __asm __emit 0x72 __asm __emit 0x6B \
__asm __emit 0x20 __asm __emit 0x6F __asm __emit 0x66 __asm __emit 0x20 \
__asm __emit 0x66 __asm __emit 0x75 __asm __emit 0x74 __asm __emit 0x75 \
__asm __emit 0x72 __asm __emit 0x65 __asm __emit 0x73 __asm __emit 0x20 \
__asm __emit 0x70 __asm __emit 0x61 __asm __emit 0x73 __asm __emit 0x74 \
__asm __emit 0x21 __asm __emit 0x0D __asm __emit 0x0A __asm __emit 0x54 \
__asm __emit 0x68 __asm __emit 0x65 __asm __emit 0x20 __asm __emit 0x6D \
__asm __emit 0x61 __asm __emit 0x67 __asm __emit 0x69 __asm __emit 0x63 \
__asm __emit 0x69 __asm __emit 0x61 __asm __emit 0x6E __asm __emit 0x20 \
__asm __emit 0x6C __asm __emit 0x6F __asm __emit 0x6E __asm __emit 0x67 \
__asm __emit 0x73 __asm __emit 0x20 __asm __emit 0x74 __asm __emit 0x6F \
__asm __emit 0x20 __asm __emit 0x73 __asm __emit 0x65 __asm __emit 0x65 \
__asm __emit 0x21 __asm __emit 0x0D __asm __emit 0x0A __asm __emit 0x4F \
__asm __emit 0x6E __asm __emit 0x65 __asm __emit 0x20 __asm __emit 0x63 \
__asm __emit 0x68 __asm __emit 0x61 __asm __emit 0x6E __asm __emit 0x74 \
__asm __emit 0x73 __asm __emit 0x20 __asm __emit 0x6F __asm __emit 0x75 \
__asm __emit 0x74 __asm __emit 0x20 __asm __emit 0x62 __asm __emit 0x65 \
__asm __emit 0x74 __asm __emit 0x77 __asm __emit 0x65 __asm __emit 0x65 \
__asm __emit 0x6E __asm __emit 0x20 __asm __emit 0x74 __asm __emit 0x77 \
__asm __emit 0x6F __asm __emit 0x20 __asm __emit 0x77 __asm __emit 0x6F \
__asm __emit 0x72 __asm __emit 0x6C __asm __emit 0x64 __asm __emit 0x73 \
__asm __emit 0x21 __asm __emit 0x0D __asm __emit 0x0A __asm __emit 0x46 \
__asm __emit 0x49 __asm __emit 0x52 __asm __emit 0x45 __asm __emit 0x20 \
__asm __emit 0x57 __asm __emit 0x41 __asm __emit 0x4C __asm __emit 0x4B \
__asm __emit 0x20 __asm __emit 0x57 __asm __emit 0x49 __asm __emit 0x54 \
__asm __emit 0x48 __asm __emit 0x20 __asm __emit 0x4D __asm __emit 0x45 \
__asm __emit 0x21 __asm __emit 0x0D __asm __emit 0x0A __asm __emit 0x42 \
__asm __emit 0x4F __asm __emit 0x42 __asm __emit 0x0D __asm __emit 0x0A \
}

#define PELOCK_MEMORY_GAP_HELPER \
__asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 \
__asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 \
__asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 \
__asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 \
__asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 \
__asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 \
__asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 \
__asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0 __asm __emit 0

#define PELOCK_MEMORY_GAP \
{ \
__asm __emit 0xE9 __asm __emit 0x04 __asm __emit 0x20 __asm __emit 0x00 __asm __emit 0x00 __asm __emit 0x8F __asm __emit 0xF1 __asm __emit 0x12 __asm __emit 0x34 \
PELOCK_MEMORY_GAP_HELPER PELOCK_MEMORY_GAP_HELPER PELOCK_MEMORY_GAP_HELPER PELOCK_MEMORY_GAP_HELPER \
PELOCK_MEMORY_GAP_HELPER PELOCK_MEMORY_GAP_HELPER PELOCK_MEMORY_GAP_HELPER PELOCK_MEMORY_GAP_HELPER \
PELOCK_MEMORY_GAP_HELPER PELOCK_MEMORY_GAP_HELPER PELOCK_MEMORY_GAP_HELPER PELOCK_MEMORY_GAP_HELPER \
PELOCK_MEMORY_GAP_HELPER PELOCK_MEMORY_GAP_HELPER PELOCK_MEMORY_GAP_HELPER PELOCK_MEMORY_GAP_HELPER \
}

#define PELOCK_WATERMARK \
{ \
__asm __emit 0xEB __asm __emit 0x7E __asm __emit 0x44 __asm __emit 0x6F \
__asm __emit 0x77 __asm __emit 0x6E __asm __emit 0x20 __asm __emit 0x69 \
__asm __emit 0x6E __asm __emit 0x20 __asm __emit 0x74 __asm __emit 0x68 \
__asm __emit 0x65 __asm __emit 0x20 __asm __emit 0x70 __asm __emit 0x61 \
__asm __emit 0x72 __asm __emit 0x6B __asm __emit 0x0D __asm __emit 0x0A \
__asm __emit 0x57 __asm __emit 0x68 __asm __emit 0x65 __asm __emit 0x72 \
__asm __emit 0x65 __asm __emit 0x20 __asm __emit 0x74 __asm __emit 0x68 \
__asm __emit 0x65 __asm __emit 0x20 __asm __emit 0x63 __asm __emit 0x68 \
__asm __emit 0x61 __asm __emit 0x6E __asm __emit 0x74 __asm __emit 0x20 \
__asm __emit 0x69 __asm __emit 0x73 __asm __emit 0x20 __asm __emit 0x64 \
__asm __emit 0x65 __asm __emit 0x61 __asm __emit 0x74 __asm __emit 0x68 \
__asm __emit 0x2C __asm __emit 0x20 __asm __emit 0x64 __asm __emit 0x65 \
__asm __emit 0x61 __asm __emit 0x74 __asm __emit 0x68 __asm __emit 0x2C \
__asm __emit 0x20 __asm __emit 0x64 __asm __emit 0x65 __asm __emit 0x61 \
__asm __emit 0x74 __asm __emit 0x68 __asm __emit 0x0D __asm __emit 0x0A \
__asm __emit 0x55 __asm __emit 0x6E __asm __emit 0x74 __asm __emit 0x69 \
__asm __emit 0x6C __asm __emit 0x20 __asm __emit 0x74 __asm __emit 0x68 \
__asm __emit 0x65 __asm __emit 0x20 __asm __emit 0x73 __asm __emit 0x75 \
__asm __emit 0x6E __asm __emit 0x20 __asm __emit 0x63 __asm __emit 0x72 \
__asm __emit 0x69 __asm __emit 0x65 __asm __emit 0x73 __asm __emit 0x20 \
__asm __emit 0x6D __asm __emit 0x6F __asm __emit 0x72 __asm __emit 0x6E \
__asm __emit 0x69 __asm __emit 0x6E __asm __emit 0x67 __asm __emit 0x0D \
__asm __emit 0x0A __asm __emit 0x44 __asm __emit 0x6F __asm __emit 0x77 \
__asm __emit 0x6E __asm __emit 0x20 __asm __emit 0x69 __asm __emit 0x6E \
__asm __emit 0x20 __asm __emit 0x74 __asm __emit 0x68 __asm __emit 0x65 \
__asm __emit 0x20 __asm __emit 0x70 __asm __emit 0x61 __asm __emit 0x72 \
__asm __emit 0x6B __asm __emit 0x20 __asm __emit 0x77 __asm __emit 0x69 \
__asm __emit 0x74 __asm __emit 0x68 __asm __emit 0x20 __asm __emit 0x66 \
__asm __emit 0x72 __asm __emit 0x69 __asm __emit 0x65 __asm __emit 0x6E \
__asm __emit 0x64 __asm __emit 0x73 __asm __emit 0x20 __asm __emit 0x6F \
__asm __emit 0x66 __asm __emit 0x20 __asm __emit 0x6D __asm __emit 0x69 \
__asm __emit 0x6E __asm __emit 0x65 __asm __emit 0x0D __asm __emit 0x0A \
}

#define PELOCK_CPUID \
{ \
__asm __emit 0xEB __asm __emit 0x7E __asm __emit 0x0D __asm __emit 0x0A \
__asm __emit 0x0D __asm __emit 0x0A __asm __emit 0x43 __asm __emit 0x6F \
__asm __emit 0x6D __asm __emit 0x65 __asm __emit 0x20 __asm __emit 0x61 \
__asm __emit 0x73 __asm __emit 0x20 __asm __emit 0x79 __asm __emit 0x6F \
__asm __emit 0x75 __asm __emit 0x20 __asm __emit 0x61 __asm __emit 0x72 \
__asm __emit 0x65 __asm __emit 0x2C __asm __emit 0x20 __asm __emit 0x61 \
__asm __emit 0x73 __asm __emit 0x20 __asm __emit 0x79 __asm __emit 0x6F \
__asm __emit 0x75 __asm __emit 0x20 __asm __emit 0x77 __asm __emit 0x65 \
__asm __emit 0x72 __asm __emit 0x65 __asm __emit 0x0D __asm __emit 0x0A \
__asm __emit 0x41 __asm __emit 0x73 __asm __emit 0x20 __asm __emit 0x49 \
__asm __emit 0x20 __asm __emit 0x77 __asm __emit 0x61 __asm __emit 0x6E \
__asm __emit 0x74 __asm __emit 0x20 __asm __emit 0x79 __asm __emit 0x6F \
__asm __emit 0x75 __asm __emit 0x20 __asm __emit 0x74 __asm __emit 0x6F \
__asm __emit 0x20 __asm __emit 0x62 __asm __emit 0x65 __asm __emit 0x0D \
__asm __emit 0x0A __asm __emit 0x41 __asm __emit 0x73 __asm __emit 0x20 \
__asm __emit 0x61 __asm __emit 0x20 __asm __emit 0x66 __asm __emit 0x72 \
__asm __emit 0x69 __asm __emit 0x65 __asm __emit 0x6E __asm __emit 0x64 \
__asm __emit 0x2C __asm __emit 0x20 __asm __emit 0x61 __asm __emit 0x73 \
__asm __emit 0x20 __asm __emit 0x61 __asm __emit 0x20 __asm __emit 0x66 \
__asm __emit 0x72 __asm __emit 0x69 __asm __emit 0x65 __asm __emit 0x6E \
__asm __emit 0x64 __asm __emit 0x0D __asm __emit 0x0A __asm __emit 0x41 \
__asm __emit 0x73 __asm __emit 0x20 __asm __emit 0x61 __asm __emit 0x6E \
__asm __emit 0x20 __asm __emit 0x6F __asm __emit 0x6C __asm __emit 0x64 \
__asm __emit 0x20 __asm __emit 0x65 __asm __emit 0x6E __asm __emit 0x65 \
__asm __emit 0x6D __asm __emit 0x79 __asm __emit 0x0D __asm __emit 0x0A \
__asm __emit 0x54 __asm __emit 0x61 __asm __emit 0x6B __asm __emit 0x65 \
__asm __emit 0x20 __asm __emit 0x79 __asm __emit 0x6F __asm __emit 0x75 \
__asm __emit 0x72 __asm __emit 0x20 __asm __emit 0x74 __asm __emit 0x69 \
__asm __emit 0x6D __asm __emit 0x65 __asm __emit 0x2C __asm __emit 0x20 \
__asm __emit 0x68 __asm __emit 0x75 __asm __emit 0x72 __asm __emit 0x72 \
__asm __emit 0x79 __asm __emit 0x20 __asm __emit 0x75 __asm __emit 0x70 \
__asm __emit 0x0D __asm __emit 0x0A __asm __emit 0x0D __asm __emit 0x0A \
}

#define PELOCK_INIT_CALLBACK \
{ \
__asm __emit 0xEB __asm __emit 0x08 __asm __emit 0x10 __asm __emit 0x11 \
__asm __emit 0x22 __asm __emit 0x33 __asm __emit 0x33 __asm __emit 0x22 \
__asm __emit 0x11 __asm __emit 0x00 \
}

#define HARDWARE_ID_CALLBACK \
{ \
__asm __emit 0xEB __asm __emit 0x08 __asm __emit 0x4F __asm __emit 0x5A \
__asm __emit 0xF7 __asm __emit 0x38 __asm __emit 0x31 __asm __emit 0xCD \
__asm __emit 0xE0 __asm __emit 0x53 \
}

#define __PELOCK_MACROS__

#endif

#define FEATURE_1_END FEATURE_END
#define FEATURE_2_END FEATURE_END
#define FEATURE_3_END FEATURE_END
#define FEATURE_4_END FEATURE_END
#define FEATURE_5_END FEATURE_END
#define FEATURE_6_END FEATURE_END
#define FEATURE_7_END FEATURE_END
#define FEATURE_8_END FEATURE_END
#define FEATURE_9_END FEATURE_END
#define FEATURE_10_END FEATURE_END
#define FEATURE_11_END FEATURE_END
#define FEATURE_12_END FEATURE_END
#define FEATURE_13_END FEATURE_END
#define FEATURE_14_END FEATURE_END
#define FEATURE_15_END FEATURE_END
#define FEATURE_16_END FEATURE_END
#define FEATURE_17_END FEATURE_END
#define FEATURE_18_END FEATURE_END
#define FEATURE_19_END FEATURE_END
#define FEATURE_20_END FEATURE_END
#define FEATURE_21_END FEATURE_END
#define FEATURE_22_END FEATURE_END
#define FEATURE_23_END FEATURE_END
#define FEATURE_24_END FEATURE_END
#define FEATURE_25_END FEATURE_END
#define FEATURE_26_END FEATURE_END
#define FEATURE_27_END FEATURE_END
#define FEATURE_28_END FEATURE_END
#define FEATURE_29_END FEATURE_END
#define FEATURE_30_END FEATURE_END
#define FEATURE_31_END FEATURE_END
#define FEATURE_32_END FEATURE_END

#define FEATURE_1_END_MT FEATURE_END_MT
#define FEATURE_2_END_MT FEATURE_END_MT
#define FEATURE_3_END_MT FEATURE_END_MT
#define FEATURE_4_END_MT FEATURE_END_MT
#define FEATURE_5_END_MT FEATURE_END_MT
#define FEATURE_6_END_MT FEATURE_END_MT
#define FEATURE_7_END_MT FEATURE_END_MT
#define FEATURE_8_END_MT FEATURE_END_MT
#define FEATURE_9_END_MT FEATURE_END_MT
#define FEATURE_10_END_MT FEATURE_END_MT
#define FEATURE_11_END_MT FEATURE_END_MT
#define FEATURE_12_END_MT FEATURE_END_MT
#define FEATURE_13_END_MT FEATURE_END_MT
#define FEATURE_14_END_MT FEATURE_END_MT
#define FEATURE_15_END_MT FEATURE_END_MT
#define FEATURE_16_END_MT FEATURE_END_MT
#define FEATURE_17_END_MT FEATURE_END_MT
#define FEATURE_18_END_MT FEATURE_END_MT
#define FEATURE_19_END_MT FEATURE_END_MT
#define FEATURE_20_END_MT FEATURE_END_MT
#define FEATURE_21_END_MT FEATURE_END_MT
#define FEATURE_22_END_MT FEATURE_END_MT
#define FEATURE_23_END_MT FEATURE_END_MT
#define FEATURE_24_END_MT FEATURE_END_MT
#define FEATURE_25_END_MT FEATURE_END_MT
#define FEATURE_26_END_MT FEATURE_END_MT
#define FEATURE_27_END_MT FEATURE_END_MT
#define FEATURE_28_END_MT FEATURE_END_MT
#define FEATURE_29_END_MT FEATURE_END_MT
#define FEATURE_30_END_MT FEATURE_END_MT
#define FEATURE_31_END_MT FEATURE_END_MT
#define FEATURE_32_END_MT FEATURE_END_MT

#endif /* #ifndef __PELOCK__ */
