unit KeyUser;

{
  Delphi key generator example
  (c) 2004 element 5 AG, Cologne, Germany
  written by Stefan Weber

  SDK 3 File Revision 1

  IMPLEMENT YOUR CODE HERE!
}

interface

uses
  KeyIntf, SysUtils;

type
  TMyKeyGen = class(TAbstractKeyGen)
  protected
    function GetTitle: string; override;
    function GenerateKey: integer; override;
  end;

implementation

{ TMyKeyGen }
function TMyKeyGen.GetTitle: string;
begin
  Result := 'Delphi Key Generator Example 3.0';
end;

// implement your key generator here
function TMyKeyGen.GenerateKey: integer;
var
  REG_NAME, EMAIL: WideString; // input data
  key: WideString;
begin
  // get input values
  REG_NAME := WideValue('REG_NAME');
  EMAIL    := WideValue('EMAIL');
  // get more values as you need them ...

  if (Length(REG_NAME) < 8) then
    raise EKeyException.Create('REG_NAME must have at least 8 characters',
      ERC_BAD_INPUT);

  // generate the key
  key := 'S.E.C.R.E.T'; // use a real key generation algorithm here


{$IFDEF BINARY_GEN}
  KeyMIMEType := 'text/plain';
	KeyDisplayFileName := 'key.txt';
  KeyData := Key;
  Result := ERC_SUCCESS_BIN;  
{$ELSE}
  UserKey := 'Your key is: ' + key;
  CCKey   := REG_NAME + '-' + EMAIL + '-' + key;
  Result  := ERC_SUCCESS;
{$ENDIF}

end;

end.

