/**
 * Title:        KeyGenerator.java
 * Description:  A servlet-based key-generator
 * Copyright:    Copyright (c) 2001
 * Company:      element 5 AG
 * @author       Stefan Matuszynski
 * @version 1.0
 */

import javax.servlet.*;
import javax.servlet.http.*;
import java.io.PrintWriter;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class KeyGenerator extends HttpServlet {
  // the key to be presented inline
  // private static final String CONTENT_TYPE = "text/plain";
  // if your key is a binary use the following header instead
  private static final String CONTENT_TYPE = "application/octet-stream";

  /**Process the HTTP Get request*/
  public void doGet(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
    // if your key-generator should only be accessed by the post-method
    // uncomment the following line
    // response.sendError(response.SC_METHOD_NOT_ALLOWED, "METHOD NOT ALLOWED");
    // otherwise call doPost
    doPost(request, response);
  }

  /**Process the HTTP Post request*/
  public void doPost(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {

    PrintWriter out = response.getWriter();
    String regName = request.getParameter("REG_NAME");
    MessageDigest md = null;
    String result = "";
    byte[] md5;

    // check for errors
    if (regName == null) {
      // an error has occured
      // set the status code other than 200 and present the error
      response.sendError(response.SC_BAD_REQUEST, "BAD INPUT");
      // close the output-stream
      out.close();
      return;
    }
    // calculate the key
    // set the content type
    response.setContentType(CONTENT_TYPE);
    // if your header is a binary replace key.bin
    // with a filename of your choice
    response.setHeader("Content-Disposition", "filename=key.bin");
    // enter your secret key generation code here
    try {
      md = MessageDigest.getInstance("MD5");
    }
    catch (NoSuchAlgorithmException E) {
    }
    md.update(regName.getBytes());
    md5 = md.digest();
    result = "";
    for (int i = 0; i < md5.length; i++)
      result += Integer.toHexString(md5[i]);
    // present the key
    out.print(result);
    // close the output-stream
    out.close();
  }
}