/** 
 JAVA key generator example
 (c) 2004 element 5 AG - a digital river company, Cologne, Germany	
 written by Stefan Weber

 SDK 3 File Revision 1	
 */

import java.io.*;
import java.security.*;

/**
 * This class implemens a unicode binary key generator. Use this as a template
 * to start your own generator. Don't forget to rename this class to your
 * publisher_id, product_id or company name in order to avoid confusion.
 * 
 * @author Stefan Weber, element 5 AG - a digital river company
 * @version SDK 3 File Revision 1
 */
/**
 * @author Stefan
 * 
 * TODO To change the template for this generated type comment go to Window -
 * Preferences - Java - Code Style - Code Templates
 */
public class P100000 {
    // possible key generator exit codes - do not modify

    /**
     * Return <code>ERC_SUCCESS</code> on succesful creation of a textual key.
     * Note that this example creates a binary key and thus this constant is not
     * used here
     */
    public static final int ERC_SUCCESS = 00;

    /**
     * Return <code>ERC_SUCCESS_BIN</code> on succesful creation of a binary
     * key. (Which could contain text as well, if the content type is specified
     * as <code>text/plain</code>)
     */
    public static final int ERC_SUCCESS_BIN = 01;

    /**
     * Return <code>ERC_ERROR</code> for general errors.
     */
    public static final int ERC_ERROR = 10;

    /**
     * Return <code>ERC_MEMORY</code> if memory allocation fails.
     */
    public static final int ERC_MEMORY = 11;

    /**
     * Return <code>ERC_FILE_IO</code> on IOException
     */
    public static final int ERC_FILE_IO = 12;

    /**
     * Return <code>ERC_BAD_ARGS</code> if the command line parameters are
     * bad.
     */
    public static final int ERC_BAD_ARGS = 13;

    /**
     * Return <code>ERC_BAD_INPUT</code> if a particular input value is
     * missing or has a bad value. Don't forget to supply a meaningful error
     * message naming the exact cause of the error.
     */
    public static final int ERC_BAD_INPUT = 14;

    /**
     * Return <code>ERC_EXPIRED</code> if this generator is expired. This can
     * be used to limit the lifetime of this generator.
     */
    public static final int ERC_EXPIRED = 15;

    /**
     * Return <code>ERC_INTERNAL</code> if an unhandled exception occurs.
     * 
     * @see java.lang.Exception
     */
    public static final int ERC_INTERNAL = 16;

    /**
     * The <code>ExitCode</code> returned by this class, please update it to
     * one of the <code>ERC_*</code> constant values before throwing an
     * exception.
     * 
     * @see #KeyMain(String[]) for the procssing of this code.
     */
    public static int ExitCode = ERC_INTERNAL;

    //#if UNICODE_GEN
    /** The encoding expected by this generator - do not modify */
    private static final String expectedEncoding = "UTF8";

    //#else
    // 	private static final String expectedEncoding = "ISO-8859-1";
    //#endif

    /**
     * The encoding specified in the input file, defaults to ISO-8859-1 if not
     * specified.
     */
    public static String fileEncoding = "ISO-8859-1";

    /** The <code>REG_NAME</code> input value. */
    public static String REG_NAME;

    /** The <code>EMAIL</code> input value. */
    public static String EMAIL;

    /** The <code>PRODUCT_ID</code> input value. */
    public static int PRODUCT_ID;

    // generated key data
    //#if BINARY_GEN
    /** The MIME type of the generated binary key file */
    public static String KeyMIMEType;

    /**
     * The filename to be displayed for the generated binary key file when
     * delivered. Note: never use this to write a file, always write to the
     * filename provided by the key server in args[2]
     */
    public static String KeyDisplayFileName; // the displayed filename

    /** The actual key data */
    public static byte[] KeyData;

    //#else
    // 	private static String userkey, cckey;
    //#endif

    /**
     * This method implements simple example algorithm using MD5 message
     * digests. Implement your own algorithm here. If you would like to use this
     * implementation you should at least modify the "S.E.C.R.E.T" string to
     * another value known only to you.
     */
    private static void GenerateKey() throws Exception {
        // compose a string using a secret value (only known to the author of
        // the key generator and the application to be unlocked by the key)
        // and some of the input values
        String digestInputStr = "S.E.C.R.E.T" + REG_NAME;

        byte[] digestInput = digestInputStr.getBytes(fileEncoding);
        MessageDigest md5 = MessageDigest.getInstance("MD5");

        //#if BINARY_GEN
        // create a binary key
        KeyData = md5.digest(digestInput);
        KeyDisplayFileName = "key.bin";
        KeyMIMEType = "application/octet-stream";
        //#else
        //        byte[] digest = md5.digest(input);
        //        cckey = digest.toString();
        //        userkey = "Username: " + reg_name + "\r\nKey: " + cckey;
        //#endif

    }

    /**
     * This method parses a single line of the input file and assigns values to
     * the respective in class variables
     */
    private static void ParseInputLine(String line) {
        int p = line.indexOf('=');
        if (p == 0)
            return;

        String key = line.substring(0, p);
        String value = line.substring(p + 1);

        // accept files with UTF8 byte order mark before "ENCODING" as well
        if (key.indexOf("ENCODING") >= 0)
            fileEncoding = value;
        else if (key.compareTo("REG_NAME") == 0)
            REG_NAME = value;
        else if (key.compareTo("EMAIL") == 0)
            EMAIL = value;
        else if (key.compareTo("PRODUCT_ID") == 0)
            PRODUCT_ID = Integer.valueOf(value).intValue();

        // add more lines as you need them
    }

    /**
     * Read and parse the input file, perform input value checking.
     * 
     * You should add appropriate checking for all input values used by your key
     * generation algorithm.
     */
    private static void ReadInput(String pathname) throws Exception {
        String s;
        BufferedReader fin = new BufferedReader(new InputStreamReader(
                new FileInputStream(pathname), expectedEncoding));

        while ((s = fin.readLine()) != null) {
            ParseInputLine(s);
        }
        fin.close();

        // here, all inputs have been read and assigned to class variables
        // so continue with input validation

        // check for supported encoding
        //#if UNICODE_GEN
        if (!fileEncoding.equals(expectedEncoding)) {
            //#else
            //        if ((!fileEncoding.equals(expectedEncoding)) && (fileEncoding !=
            // null)) {
            //#endif
            ExitCode = ERC_BAD_INPUT;
            throw new Exception("bad input encoding, expected "
                    + expectedEncoding + " but found: " + fileEncoding);
        }

        // check for supported product id - change this to your product id
        if (PRODUCT_ID != 100000) {
            ExitCode = ERC_BAD_INPUT;
            throw new Exception("Bad product ID: " + PRODUCT_ID);
        }

        // check for valid regname
        if (REG_NAME.length() < 8) {
            ExitCode = ERC_BAD_INPUT;
            throw new Exception("REG_NAME must have at least 8 characters "
                    + expectedEncoding + " but found: " + fileEncoding);
        }
    }

    /**
     * Write a string to an output file using the encoding specified in the
     * input file.
     */
    private static void WriteText(String pathname, String value)
            throws IOException {
        BufferedWriter fout;
        fout = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(
                pathname), fileEncoding));
        fout.write(value);
        fout.flush();
    }

    /** Write a binary byte array to an output file. */
    private static void WriteBinary(String pathname, byte[] data)
            throws IOException {
        FileOutputStream fsout;
        fsout = new FileOutputStream(pathname);
        fsout.write(data);
        fsout.flush();
    }

    /**
     * This is the main entry point for JAVA key generators. It processes the
     * command line arguments, loads and parses the input file, calls the key
     * generator and writes output files.
     * 
     * JAVA Exceptions are handled and transformed into key generator error
     * codes. Exception messages will be written to <code>args[1]</code> and
     * display on the error console.
     * 
     * Normally you should not modify this method.
     */
    public static int KeyMain(String args[]) {
        try {
            try {
                if (args.length == 3) {
                    // read input
                    ReadInput(args[0]);

                    // generate key
                    GenerateKey();

                    //#if BINARY_GEN // write MIME type and display filename to
                    // output file #1
                    WriteText(args[1], KeyMIMEType + ":" + KeyDisplayFileName);
                    WriteBinary(args[2], KeyData);
                    ExitCode = ERC_SUCCESS_BIN;

                    //#else // WriteText(args[1], userkey);
                    // WriteText(args[2], cckey);
                    // ExitCode = ERC_SUCCESS;
                    // //#endif
                } else {
                    System.out.println("Usage: <input><output1><output2>");
                    ExitCode = ERC_BAD_ARGS;
                }
            } catch (IOException eio) {
                ExitCode = ERC_FILE_IO;
                throw eio;
            }
        } catch (Exception e) {
            System.err.println("Exception: " + e.getMessage());
            // handle exceptions
            try {
                // write error to output file #1
                WriteText(args[1], "Error #" + ExitCode + ": " + e.getMessage());
            } catch (IOException eio) {
                System.err.println("could not write error file: "
                        + eio.getMessage());
            }
        }

        return ExitCode;
    }

    /**
     * NOTE: This main() method is never called by the actual key server. It is
     * just useful for debugging the key generator.
     * 
     * Normally you won't have to modify this method.
     */
    public static final void main(String args[]) {
        int erc;

        System.out.println("JAVA Example Key Generator");
        erc = KeyMain(args);

        switch (erc) {
        case ERC_SUCCESS:
            System.out.println("ERC_SUCCESS");
            break;
        case ERC_SUCCESS_BIN:
            System.out.println("ERC_SUCCESS_BIN");
            break;
        case ERC_ERROR:
            System.out.println("ERC_ERROR");
            break;
        case ERC_MEMORY:
            System.out.println("ERC_MEMORY");
            break;
        case ERC_FILE_IO:
            System.out.println("ERC_FILE_IO");
            break;
        case ERC_BAD_ARGS:
            System.out.println("ERC_BAD_ARGS");
            break;
        case ERC_BAD_INPUT:
            System.out.println("ERC_BAD_INPUT");
            break;             
        case ERC_EXPIRED:
            System.out.println("ERC_EXPIRED");
            break;
        case ERC_INTERNAL:
            System.out.println("ERC_INTERNAL");
            break;
        }

        System.exit(erc);
    }
}