' This example was contributed by Sailsoft. Thanks!

' The example below shows a VB.Net aspx page for responding to ShareIt with a generated
' license key using Microsofts .Net Framework 2.0.
'
' It is compliant with the CGI keygenerator method ShareIt offers
'
' We use a dataset and a webservice in this example, but of course this is not necessary
' Yet it shows how to use the Request method to read individual fields from the form
' that ShareIt posts, and how to respond to ShareIt with the proper parameters
  
Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        Dim ReturnCode As String
        Dim ProductName As String
        Dim LicenseName As String
        Dim LicenseNumber As String
        Dim LicenseKey As String
        Dim LicenseDataFromLicenseProvider As String
        Dim LicenseArray() As String

	'<Insert code here if you like to check if the posted data originates from ShareIt>

        'fetch and store the data received in a dataset 
        Dim ds As New System.Data.DataSet
        ds = FetchPostedData() 'see further on...

        'Call your webservice to create a new license and receive the result
	'The webserver method "GenerateLicense" in this example generates the actual key
	'based on the data in dataset "ds"
	'Of course you can generate your keys here without using a webservice

        Dim lProviderWebService As New your.host.address.LicenseProvider 'webservice URI
        LicenseDataFromLicenseProvider = lProviderWebService.GenerateLicense(ds) 

        'Call the webservice and process the results we receive back from our service
	'Note: the webserver in this sample uses a pipe character to separate the fields
	'For clarity we split them out in individual variables below
        LicenseArray = Split(LicenseDataFromLicenseProvider, "|")
        ReturnCode = LicenseArray(0)
        ProductName = LicenseArray(1)
        LicenseName = LicenseArray(2)
        LicenseNumber = LicenseArray(3)
        LicenseKey = LicenseArray(4)

        'Compose and return our response message to ShareIt.
	'The information stored in the ResponseMessage will appear as plain text
	'in the ShareIt reply to the customer after purchase.
        Dim ResponseMessage As String
        If ReturnCode = "00" Then
            Response.ContentType = "text/plain"
            Response.StatusCode = 200
            Response.Status = "200 OK"
            ResponseMessage = "License Information " & ProductName & LicenseName & LicenseNumber & LicenseKey
            Response.Write(ResponseMessage)
        Else
	    'you can check ofcourse other error codes here and send appropriate error messages
	    'We keep it simple here...
            Response.StatusCode = 400
            Response.Status = "400 Bad Request"
            ResponseMessage = vbCrLf & _
                    "ERC_BAD_INPUT, Errorcode: " & ReturnCode & " Some error occurred"
            Response.Write(ResponseMessage)
        End If

    End Sub

'----------Function FetchPostedData------------------------------------------------------
'
    'We save the data received from ShareIt in a dataset using the Request.Form(item) method
    Friend Function FetchPostedData() As System.Data.DataSet

        'make a dataset with one (purchase) table
        Dim ds As System.Data.DataSet = CreatePurchaseDataset()
        'create a new row for our table
        Dim r As System.Data.DataRow = ds.Tables(0).NewRow()

        r.Item("PURCHASE_ID") = Request.Form("PURCHASE_ID")
        r.Item("RUNNING_NO") = Request.Form("RUNNING_NO")
        r.Item("PURCHASE_DATE") = Request.Form("PURCHASE_DATE")
        r.Item("PRODUCT_ID") = Request.Form("PRODUCT_ID")
        r.Item("LANGUAGE_ID") = Request.Form("LANGUAGE_ID")
        r.Item("QUANTITY") = Request.Form("QUANTITY")
        r.Item("REG_NAME") = Request.Form("REG_NAME")
        r.Item("ADDITIONAL1") = Request.Form("ADDITIONAL1")
        r.Item("ADDITIONAL2") = Request.Form("ADDITIONAL2")
        r.Item("RESELLER") = Request.Form("RESELLER")
        r.Item("LASTNAME") = Request.Form("LASTNAME")
        r.Item("FIRSTNAME") = Request.Form("FIRSTNAME")
        r.Item("COMPANY") = Request.Form("COMPANY")
        r.Item("EMAIL") = Request.Form("EMAIL")
        r.Item("PHONE") = Request.Form("PHONE")
        r.Item("FAX") = Request.Form("FAX")
        r.Item("STREET") = Request.Form("STREET")
        r.Item("ZIP") = Request.Form("ZIP")
        r.Item("CITY") = Request.Form("CITY")
        r.Item("STATE") = Request.Form("STATE")
        r.Item("COUNTRY") = Request.Form("COUNTRY")

        'add the row to the table
        ds.Tables(0).Rows.Add(r)

        Return ds

    End Function
