/* 
 * Copyright (c) [2010-2019] zhenfei.mzf@gmail.com rights reserved.
 * 
 * AntiSpy is licensed under the Mulan PSL v1.
 * You can use this software according to the terms and conditions of the Mulan PSL v1.
 * You may obtain a copy of Mulan PSL v1 at:
 *
 *     http://license.coscl.org.cn/MulanPSL
 *
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR
 * FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v1 for more details.
*/
#ifndef _INIT_WINDOWS_H_
#define _INIT_WINDOWS_H_

#include <ntifs.h>
#include <windef.h>

/////////////////////////////////////////////////////////

typedef enum WIN_VERSION {
	enumWINDOWS_UNKNOW,
	enumWINDOWS_2K,
	enumWINDOWS_XP,
	enumWINDOWS_2K3,
	enumWINDOWS_2K3_SP1_SP2,
	enumWINDOWS_VISTA,
	enumWINDOWS_VISTA_SP1_SP2,
	enumWINDOWS_7,
	enumWINDOWS_8
} WIN_VERSION;

/////////////////////////////////////////////////////////

typedef enum _VERIABLE_INDEX_
{	
	enumRandomKey,
	enumSameThreadApcFlags_Offset_ETHREAD,
	enumPsGetProcessCreateTimeQuadPart,
	enumAtapiParseDiskDriverObject,
	enumReloadAtapiStartIoDispatch,
	enumNtReadFileIndex,
	enumPsLookupThreadByThreadId,
	enumOriginAtapiStartIoDispatch,
	enumIoBuildDeviceIoControlRequest,
	enumBackupDriverPath,
	enumAntiSpyPid,
	enumAntiSpyEprocess,
	enumRtlInitAnsiString,
	enumRtlAnsiStringToUnicodeString,
	enumRtlFreeUnicodeString,
	enumCsrssEprocess,
	enumPsGetCurrentProcessId,
	enumIoFreeIrp,
	enumMmFlushImageSection,
	enumFastfatBase,
	enumFastfatSize,
	enumNtfsBase,
	enumKeInitializeApc,
	enumKeInsertQueueApc,
	enumActiveExWorkerOffset_ETHREAD,
	enumNtfsSize,
	enumExfatBase,
	enumNtCreateFile,
	enumNtWriteFile,
	enumNtReadFile,
	enumExfatSize,
	enumPsThreadType,
	enumPsProcessType,
	enumThreadListHeadOffset_KPROCESS,
	enumCidOffset_ETHREAD,
	enumStartAddressOffset_ETHREAD,
	enumKdVersionBlock,
	enumVadRootOffset_EPROCESS,
	enumPreviousModeOffset_KTHREAD,
	enumStateOffset_KTHREAD,
	enumWindowsVersion,	
	enumPriorityOffset_KTHREAD,
	enumContextSwitchesOffset_KTHREAD,
	enumTebOffset_KTHREAD,
	enumThreadListEntryOffset_KTHREAD,
	enumThreadListEntryOffset_ETHREAD,
	enumThreadsProcessOffset_ETHREAD,
	enumWin32StartAddressOffset_ETHREAD,
	enumBuildNumber,
	enumMmPfnDatabase,
	enumIdleThreadOffset_KPRCB,
	enumPspCidTable,
	enumNtoskrnlPath,
	enumWaitListHeadOffset_KPRCB,
	enumDispatcherReadyListHeadOffset_KPRCB,
	enumWaitInListHead,
	enumThreadListHeadOffset_EPROCESS,
	enumProcessOffset_KAPC_STATE,
	enumObjectHeaderSize,
	enumObjectTypeOffset_OBJECT_HEADER,
	enumSectionObjectOffset_EPROCESS,
	enumDispatcherReadyListHead,
	enumSpyHunterDriverObject,
	enumObjectTableOffset_EPROCESS,
	enumUniqueProcessIdOffset_HANDLE_TABLE,
	enumUniqueProcessIdOffset_EPROCESS,
	enumPebOffset_EPROCESS,
	enumSystemProcess,
	enumInheritedFromUniqueProcessIdOffset_EPROCESS,
	enumWaitListEntryOffset_KTHREAD,
	enumApcStateOffset_KTHREAD,
	enumOriginKernelBase,
	enumKernelModuleSize,
	enumNewKernelBase,					// ں˵ĻַжʱҪͷ
	enumNewKernelBaseWithoutFix,		// ں˵Ļַ, û޸жʱҪͷ
	enumOriginKiServiceTable,			// ϵͳԭʼSSDT->ServiceTableҲǱȽϸɾģܻᱻinline hookжʱҪͷ
	enumOriginSSDT,						// ϵͳԭʼSSDT, жʱҪͷ
	enumReloadKiServiceTable,			// Reload Ntos֮,ضλSSDT->ServiceTable,Ϊ˷ֹhook,һĺ,жʱҪͷ
	enumReloadSSDT,						// Reload Ntos֮,ضλSSDT,жʱҪͷ
	enumReloadNtosKrnlSuccess,			// Reload NtosǷɹ
	enumNowSSDT,						// ϵͳеSSDT

	enumSsdtFunctionsCnt,
	enumShadowSsdtFunctionsCnt,
	enumSsdtFuncionsNameBuffer,			// ssdtһβɷҳڴ棬жʱҪͷš

	enumOriginWin32kBase,				// ԭʼWin32k.sysַ
	enumNewWin32kBase,					// ReloadWin32k.sysַ
	enumWin32kSize,						// win32k.sysĴС
	enumReloadWin32kSuccess,			// Reload Win32k.sysǷɹ
	enumNowShadowSSDT,					// ǰϵͳеShadow SSDT
	enumOriginShadowKiServiceTable,		// ϵͳԭʼģδSSDT hookShadow SSDT->ServiceTableжʱҪͷ
	enumOriginShadowSSDT,				// ϵͳԭʼģδSSDT hookShadow SSDTжʱҪͷ
	enumReloadShadowKiServiceTable,		// ReloadShadow SSDT->ServiceTableжʱҪͷ
	enumReloadShadowSSDT,				// ReloadShadow SSDTжʱҪͷ
	
	enumMmIsAddressValid,
	enumMmGetVirtualForPhysical,
	enumMmGetPhysicalAddress,
	enumObQueryNameString,
	enumObfDereferenceObject,
	enumIoVolumeDeviceToDosName,
	enumIoQueryFileDosDeviceName,
	enumObOpenObjectByPointer,
	enumObReferenceObjectByPointer,
	enumPsGetThreadId,
	enumPsLookupProcessByProcessId,
	enumIoGetCurrentProcess,
	enumIoThreadToProcess,
	enumExAllocatePoolWithTag,
	enumExFreePoolWithTag,
	enumKeSetEvent,
	enumKeQueryActiveProcessors,
	enumKeInitializeEvent,
	enumKeInitializeDpc,
	enumKeSetTargetProcessorDpc,
	enumKeSetImportanceDpc,
	enumKeInsertQueueDpc,
	enumKeWaitForSingleObject,
	enumKeStackAttachProcess,
	enumKeUnstackDetachProcess,
	enumProbeForRead,
	enumObReferenceObjectByHandle,
	enumObGetObjectType,
	enumPsGetCurrentThread,
	enumPsGetProcessId,
	enumNtQuerySystemInformation,
	enumNtQuerySystemInformationIndex,
	enumNtOpenProcess,
	enumNtQueryVirtualMemory,
	enumNtQueryVirtualMemoryIndex,
	enumNtClose,
	enumNtCloseIndex,
	enumNtOpenDirectoryObject,
	enumNtOpenDirectoryObjectIndex,
	enumNtQueryObject,
	enumNtQueryObjectIndex,
	enumMmIsNonPagedSystemAddressValid,
	enumIoAllocateMdl,
	enumMmBuildMdlForNonPagedPool,
	enumMmMapLockedPagesSpecifyCache,
	enumMmUnmapLockedPages,
	enumIoFreeMdl,
	enumProbeForWrite,
	
// { shadow hook
	enumNtUserGetForegroundWindowIndex,  // ˳
	enumOriginNtUserGetForegroundWindow,
	enumFakeNtUserGetForegroundWindow,

	enumNtUserBuildHwndListIndex,
	enumOriginNtUserBuildHwndList,
	enumFakeNtUserBuildHwndList,

	enumNtUserDestroyWindowIndex,
	enumOriginNtUserDestroyWindow,
	enumFakeNtUserDestroyWindow,

	enumNtUserFindWindowExIndex,
	enumOriginNtUserFindWindowEx,
	enumFakeNtUserFindWindowEx,

	enumNtUserMessageCallIndex,
	enumOriginNtUserMessageCall,
	enumFakeNtUserMessageCall,

	enumNtUserPostThreadMessageIndex,
	enumOriginNtUserPostThreadMessage,
	enumFakeNtUserPostThreadMessage,
	
	enumNtUserQueryWindowIndex,
	enumOriginNtUserQueryWindow,
	enumFakeNtUserQueryWindow,
	
	enumNtUserSetParentIndex,
	enumOriginNtUserSetParent,
	enumFakeNtUserSetParent,

	enumNtUserSetWindowLongIndex,
	enumOriginNtUserSetWindowLong,
	enumFakeNtUserSetWindowLong,

	enumNtUserShowWindowIndex,
	enumOriginNtUserShowWindow,
	enumFakeNtUserShowWindow,

	enumNtUserWindowFromPointIndex,
	enumOriginNtUserWindowFromPoint,
	enumFakeNtUserWindowFromPoint,

	enumNtUserAttachThreadInputIndex,
	enumOriginNtUserAttachThreadInput,
	enumFakeNtUserAttachThreadInput,

	enumNtUserPostMessageIndex,
	enumOriginNtUserPostMessage,
	enumFakeNtUserPostMessage,

// }

// { ֹĻͼ
	enumNtGdiBitBltIndex,
	enumOriginNtGdiBitBlt,
	enumFakeNtGdiBitBlt,

	enumNtGdiStretchBltIndex,
	enumOriginNtGdiStretchBlt,
	enumFakeNtGdiStretchBlt,

	enumNtGdiMaskBltIndex,
	enumOriginNtGdiMaskBlt,
	enumFakeNtGdiMaskBlt,

	enumNtGdiPlgBltIndex,
	enumOriginNtGdiPlgBlt,
	enumFakeNtGdiPlgBlt,

	enumNtGdiAlphaBlendIndex,
	enumOriginNtGdiAlphaBlend,
	enumFakeNtGdiAlphaBlend,

	enumNtGdiTransparentBltIndex,
	enumOriginNtGdiTransparentBlt,
	enumFakeNtGdiTransparentBlt,

	enumNtUserGetClipboardDataIndex,
	enumOriginNtUserGetClipboardData,
	enumFakeNtUserGetClipboardData,

	enumNtGdiGetDCPointIndex,
	enumNtGdiGetDCPoint,

	enumNtGdiGetDCDwordIndex,
	enumNtGdiGetDCDword,
	
	enumNtUserWindowFromPoint,
	enumVMemCache,
// }

	enumNtUserBuildHwndList,
	enumNtUserQueryWindow,
	enumNtUserKillTimer,
	enumNtUserKillTimerIndex,
	enumNtUserValidateTimerCallbackIndex,
	enumNtUserValidateTimerCallback,
	enumNtUserRegisterHotKey,
	enumNtUserRegisterHotKeyIndex,

	enumInterlockedIncrement,
	enumInterlockedDecrement,
	enumAddend,				// ǱݼӺ͵ݼļֵ
	enumFakeWnd,

	enumNtOpenProcessToken,
	enumNtOpenProcessTokenIndex,
	enumNtQueryInformationToken,
	enumNtQueryInformationTokenIndex,
	enumNtUnmapViewOfSection,
	enumNtUnmapViewOfSectionIndex,
	enumNtTerminateThread,

	enumgptmrFirst,                // win32kһȫֱöٽ̵Ķʱ
	enumgphkFirst,				   // win32kһȫֱöϵͳȼ
	enumInitialStackOffset_KTHREAD,
	enumStackLimitOffset_KTHREAD,
	enumKernelStackOffset_KTHREAD,
	enumKernelApcDisableOffset_KTHREAD,
	enumCrossThreadFlagsOffset_ETHREAD,
	enumNtSuspendThread,
	enumNtSuspendThreadIndex,
	enumNtResumeThread,
	enumNtResumeThreadIndex,
	enumSuspendCountOffset_KTHREAD,
	enumFreezeCountOffset_KTHREAD,
	enumNtSetInformationObject,
	enumNtSetInformationObjectIndex,
	enumNtFreeVirtualMemoryIndex,
	enumNtFreeVirtualMemory,
	enumNtProtectVirtualMemory,
	enumFileTypeIndex,
	enumNtProtectVirtualMemoryIndex,
	enumNtAdjustPrivilegesToken,
	enumNtAdjustPrivilegesTokenIndex,
	enumNtTerminateProcess,
// 	enumAntiSpyEprocess,

// { ssdt hook
	enumNtOpenProcessIndex,
	enumOriginNtOpenProcess,
	enumFakeNtOpenProcess,

	enumNtOpenThreadIndex,
	enumOriginNtOpenThread,
	enumFakeNtOpenThread,

	enumNtTerminateProcessIndex,
	enumOriginNtTerminateProcess,
	enumFakeNtTerminateProcess,

	enumNtTerminateThreadIndex,
	enumOriginNtTerminateThread,
	enumFakeNtTerminateThread,

	enumNtDuplicateObjectIndex,
	enumOriginNtDuplicateObject,
	enumFakeNtDuplicateObject,
// }

// { forbid functions

	enumNtCreateProcessIndex,
	enumOriginNtCreateProcess,
	enumFakeNtCreateProcess,

	enumNtCreateProcessExIndex,
	enumOriginNtCreateProcessEx,
	enumFakeNtCreateProcessEx,

	enumNtCreateThreadIndex,
	enumOriginNtCreateThread,
	enumFakeNtCreateThread,

	enumNtCreateFileIndex,
	enumOriginNtCreateFile,
	enumFakeNtCreateFile,

	enumNtUserSwitchDesktopIndex,
	enumOriginNtUserSwitchDesktop,
	enumFakeNtUserSwitchDesktop,

	enumNtCreateKeyIndex,
	enumOriginNtCreateKey,
	enumFakeNtCreateKey,

	enumNtLoadKey2Index,
	enumOriginNtLoadKey2,
	enumFakeNtLoadKey2,

	enumNtReplaceKeyIndex,
	enumOriginNtReplaceKey,
	enumFakeNtReplaceKey,

	enumNtRestoreKeyIndex,
	enumOriginNtRestoreKey,
	enumFakeNtRestoreKey,
	
	enumNtSetValueKeyIndex,
	enumOriginNtSetValueKey,
	enumFakeNtSetValueKey,

	enumCanSetValues,			// ǷԸֵ
	enumIsBackupDriver,			// Ƿ񱸷ļ
	enumBackupDriverEvent,		// ͬ¼

	enumNtCreateSectionIndex,
	enumOriginNtCreateSection,
	enumFakeNtCreateSection,

	enumNtInitiatePowerActionIndex,
	enumOriginNtInitiatePowerAction,
	enumFakeNtInitiatePowerAction,

	enumNtSetSystemPowerStateIndex,
	enumOriginNtSetSystemPowerState,
	enumFakeNtSetSystemPowerState,

	enumNtUserCallOneParamIndex,
	enumOriginNtUserCallOneParam,
	enumFakeNtUserCallOneParam,

	enumNtShutdownSystemIndex,
	enumOriginNtShutdownSystem,
	enumFakeNtShutdownSystem,

	enumNtSetSystemTimeIndex,
	enumOriginNtSetSystemTime,
	enumFakeNtSetSystemTime,

	enumNtUserLockWorkStationIndex,
	enumOriginNtUserLockWorkStation,
	enumFakeNtUserLockWorkStation,

	enumNtLoadDriverIndex,
	enumOriginNtLoadDriver,
	enumFakeNtLoadDriver,

	enumRtlImageDirectoryEntryToData,

	enumKeUserModeCallback,
	enumKeUserModeCallbackIatAddress,

	enumNtCreateUserProcessIndex,
	enumOriginNtCreateUserProcess,
	enumFakeNtCreateUserProcess,

	enumNtCreateThreadExIndex,
	enumOriginNtCreateThreadEx,
	enumFakeNtCreateThreadEx,
// }

	enumNtShutdownSystem,
	enumNtSuspendProcess,
	enumNtSuspendProcessIndex,
	enumNtResumeProcess,
	enumNtResumeProcessIndex,
	enumPspTerminateThreadByPointer,
	enumTypeListOffset_OBJECT_TYPE,
	enumIoDeviceObjectType,
	enumIoDriverObjectType,
	enumDirectoryObjectType,
	enumNtoskrnl_KLDR_DATA_TABLE_ENTRY,
	enumNtOpenSymbolicLinkObject,
	enumNtOpenSymbolicLinkObjectIndex,
	enumNtQuerySymbolicLinkObject,
	enumNtQuerySymbolicLinkObjectIndex,
	enumIoCreateFile,
	enumIoFileObjectType,
	enumObMakeTemporaryObject,
	enumPsTerminateSystemThread,
	enumPsCreateSystemThread,
	enumIoDeleteDevice,
	enumSymbolicLinkObjectType,
	enumObOpenObjectByName,
	enumNtOpenKeyIndex,
	enumNtOpenKey,
	enumNtEnumerateKeyIndex,
	enumNtEnumerateKey,
	enumNtEnumerateValueKey,
	enumNtEnumerateValueKeyIndex,
	enumPsSetCreateProcessNotifyRoutine,
	enumPspCreateProcessNotifyRoutine,
	enumPspLoadImageNotifyRoutine,
	enumPsSetLoadImageNotifyRoutine,
	enumPsSetCreateThreadNotifyRoutine,
	enumPspCreateThreadNotifyRoutine,
	enumPsRemoveCreateThreadNotifyRoutine,
	enumPsRemoveLoadImageNotifyRoutine,
	enumIoRegisterShutdownNotification,
	enumIopNotifyShutdownQueueHead,
	enumCmUnRegisterCallback,
	enumCmpCallBackVector,
	enumIoUnregisterShutdownNotification,
	enumKeUpdateSystemTime,
	enumKiTimerTableListHead,
	enumExTimerObjectType,
	enumTIMER_TABLE_SIZE,
	enumKeCancelTimer,
	enumIoInitializeTimer,
	enumIoStartTimer,
	enumIoStopTimer,
	enumIopTimerQueueHead,
	enumExWorkerQueue,
	enumExQueueWorkItem,
	enumQueueListEntryOffset_KTHREAD,
	enumIoplOffset_KPROCESS,
	enumIopmOffsetOffset_KPROCESS,
	enumKe386IoSetAccessProcess,
	enumIoGetDeviceObjectPointer,
	enumObReferenceObjectByName,
	enumPsInitialSystemProcessAddress,
	enumNtOpenFile,
	enumNtCreateSection,
	enumNtMapViewOfSection,
	enumNtOpenFileIndex,
//	enumNtCreateSectionIndex,
	enumNtMapViewOfSectionIndex,
	
	enumNtfsImpMmFlushImageSection,			// NtfsImpMmFlushImageSectionַ
	enumFastfatImpMmFlushImageSection,
	enumOriginNtfsImpMmFlushImageSection,	// ϵͳԭNtfsImpMmFlushImageSectionַܱhookĵַ
	enumOriginFastfatImpMmFlushImageSection,

	enumpIofCompleteRequest,
	enumIopfCompleteRequest,
	enumOriginIopfCompleteRequest,			// ϵͳԭIopfCompleteRequestַܱhookĵַ

	enumIofCompleteRequest,
	enumNtfsImpIofCompleteRequest,			// NtfsImpIofCompleteRequestַ
	enumFastfatImpIofCompleteRequest,
	enumOriginNtfsImpIofCompleteRequest,	// ϵͳԭNtfsImpIofCompleteRequestַܱhookĵַ
	enumOriginFastfatImpIofCompleteRequest,

	enumNtfsDriverObject,
	enumFastfatDriverObject,
	enumNtfsOriginalDispatchs,	// NtfsԭʼDispatchṣжʱҪͷš
	enumNtfsReloadDispatchs,	// Ntfs ReloadDispatchṣжʱҪͷš
	enumIopInvalidDeviceRequest,
	enumIoCreateDriver,
	enumReloadNtfsBase,			// жʱҪͷ

	enumFastfatOriginalDispatchs,	// FastfatԭʼDispatchṣжʱҪͷš
	enumFastfatReloadDispatchs,		// Fastfat ReloadDispatchṣжʱҪͷš
	enumReloadFastfatBase,			// жʱҪͷ

	enumKbdclassBase,
	enumKbdclassSize,
	enumKbdClassDriverObject,
	enumReloadKbdClassBase,			// жʱҪͷ
	enumKbdClassOriginalDispatchs,	// KbdClassԭʼDispatchṣжʱҪͷš
	enumKbdClassReloadDispatchs,	// KbdClass ReloadDispatchṣжʱҪͷš
	
	enumMouclassBase,
	enumMouclassSize,
	enumMouClassDriverObject,
	enumReloadMouClassBase,			// жʱҪͷ
	enumMouClassOriginalDispatchs,	// MouClassԭʼDispatchṣжʱҪͷš
	enumMouClassReloadDispatchs,	// MouClass ReloadDispatchṣжʱҪͷš

	enumClasspnpBase,
	enumClasspnpSize,
	enumClasspnpDriverObject,
	enumReloadClasspnpBase,			// жʱҪͷ
	enumClasspnpOriginalDispatchs,	// ClasspnpԭʼDispatchṣжʱҪͷš
	enumClasspnpReloadDispatchs,	// Classpnp ReloadDispatchṣжʱҪͷš

	enumAtaPortSize,
	enumAtaPortBase,

	enumAtapiSize,
	enumAtapiBase,
	enumAtapiDriverObject,
	enumReloadAtapiBase,		// жʱҪͷ
	enumAtapiOriginalDispatchs,	// AtapiԭʼDispatchṣжʱҪͷš
	enumAtapiReloadDispatchs,   // Atapi ReloadDispatchṣжʱҪͷš

	enumAcpiSize,
	enumAcpiBase,
	enumAcpiDriverObject,
	enumReloadAcpiBase,			// жʱҪͷ
	enumAcpiOriginalDispatchs,	// AcpiԭʼDispatchṣжʱҪͷš
	enumAcpiReloadDispatchs,	// Acpi ReloadDispatchṣжʱҪͷš

	enumTcpipBase,
	enumTcpipSize,
	enumTcpipDriverObject,
	enumReloadTcpipBase,			// жʱҪͷ
	enumTcpipOriginalDispatchs,		// TcpipԭʼDispatchṣжʱҪͷš
	enumTcpipReloadDispatchs,		// Tcpip ReloadDispatchṣжʱҪͷš

	enumOriginIdtTable,		// ԭʼIdtַжʱҪͷ
	enumReloadIdtTable,		// ReloadIdtַжʱҪͷ

	enumDirectoryType,		 // ϵͳȫ
	enumMutantType,
	enumThreadType,
	enumFilterCommunicationPortType,
	enumControllerType,
	enumProfileType,
	enumEventType,
	enumTypeType,
	enumSectionType,
	enumEventPairType,
	enumSymbolicLinkType,
	enumDesktopType,
	enumTimerType,
	enumFileType,
	enumWindowStationType,
	enumDriverType,
	enumWmiGuidType,
	enumKeyedEventType,
	enumDeviceType,
	enumTokenType,
	enumDebugObjectType,
	enumIoCompletionType,
	enumProcessType,
	enumAdapterType,
	enumKeyType,
	enumJobType,
	enumWaitablePortType,
	enumPortType,
	enumCallbackType,
	enumFilterConnectionPortType,
	enumSemaphoreType,

	enumObGetObjectSecurity,
	enumObCreateObjectType,
	enumSeDefaultObjectMethod,

	enumObpDeleteObjectType, // ObpTypeObjectType

	enumObpDeleteSymbolicLink, // ObpSymbolicLinkObjectType
	enumObpParseSymbolicLink,

	enumIopParseDevice, // IoDeviceObjectType
	enumIopDeleteDevice,
	enumIopGetSetSecurityObject,

	enumIopDeleteDriver, // IoDriverObjectType

	enumIopDeleteIoCompletion, // IoCompletionObjectType
	enumIopCloseIoCompletion,

	enumIopCloseFile,   // IoFileObjectType
	enumIopDeleteFile,
	enumIopParseFile,
	enumIopFileGetSetSecurityObject,
	enumIopQueryName,

	enumLpcpClosePort, // LpcWaitablePortObjectType || LpcPortObjectType
	enumLpcpDeletePort,
	enumEtwpOpenRegistrationObject,

	enumMiSectionDelete, // MmSectionObjectType
	
	enumPspProcessDelete, // PsProcessType
	enumPspProcessOpen,
	enumPspProcessClose,

	enumPspThreadDelete, // PsThreadType
	enumPspThreadOpen,

	enumPspJobDelete, // PsJobType
	enumPspJobClose,

	enumSepTokenDeleteMethod, // SeTokenObjectType

	enumWmipSecurityMethod, // WmipGuidObjectType
	enumWmipDeleteMethod,
	enumWmipCloseMethod,

	enumExpWin32CloseProcedure, // ExWindowStationObjectType || ExDesktopObjectType
	enumExpWin32DeleteProcedure,
	enumExpWin32OkayToCloseProcedure,
	enumExpWin32ParseProcedure, // ExDesktopObjectType ޴˺
	enumExpWin32OpenProcedure,
	
	enumTimerDeleteProcedure, // ExTimerObjectType

	enumExpDeleteMutant, // ExMutantObjectType

	enumExpProfileDelete, // ExProfileObjectType

	enumCmpCloseKeyObject, // CmpKeyObjectType
	enumCmpDeleteKeyObject,
	enumCmpParseKey,
	enumCmpSecurityMethod,
	enumCmpQueryKeyName,

	enumxHalLocateHiberRanges, // DbgkDebugObjectType || ExCallbackObjectType Delete Procedure
	enumDbgkpCloseObject,
	
	enumObpCloseDirectoryObject, // ObpDirectoryObjectType
	enumObpDeleteDirectoryObject,

	enumGetObjectTypeDispatchOk, // ǷѾȡϢ

	enumKiFastCallEntry,

	enumNewHalDllBaseWithoutFix,		// Hal.DllĻַ, û޸жʱҪͷ
	enumOriginHalDllBase,				// ԭʼHal.Dllַ
	enumNewHalDllBase,					// ReloadHal.Dllַ
	enumHalDllSize,						// Hal.DllĴС

	enumObCreateObjectTypeEx,

	enumSectionBaseAddressOffset_EPROCESS,

	enumNtDeleteKeyIndex,
	enumNtDeleteKey,
	enumNtCreateKey,
// 	enumNtCreateKeyIndex,
	enumNtSetValueKey,
//	enumNtSetValueKeyIndex,
	enumNtDeleteValueKey,
	enumNtDeleteValueKeyIndex,

	enumDebugportOffset_EPROCESS,

	enumNtReadVirtualMemory,
	enumNtWriteVirtualMemory,
	enumNtReadVirtualMemoryIndex,
	enumNtWriteVirtualMemoryIndex,
	enumNtRenameKeyIndex,
	enumNtRenameKey,
	
	enumNtWriteFileIndex,
}VERIABLE_INDEX;	

VOID SetGlobalVeriable(VERIABLE_INDEX Index, ULONG Value);
ULONG GetGlobalVeriable(VERIABLE_INDEX Index);
ULONG GetGlobalVeriableAddress(VERIABLE_INDEX Index);
ULONG *GetGlobalVeriable_Address(VERIABLE_INDEX Index);

/////////////////////////////////////////////////////////

BOOL InitWindows(PDRIVER_OBJECT DriverObject);
VOID UnInitProcessVariable();
VOID InitSSDTFunctions();
NTSTATUS CheckUpdate();

/////////////////////////////////////////////////////////

#endif



