/****************************************************************************
**
** Copyright (C) 2019 BlackINT3
** Contact: https://github.com/BlackINT3/OpenArk
**
** GNU Lesser General Public License Usage (LGPL)
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 or version 3 as published by the Free
** Software Foundation and appearing in the file LICENSE.LGPLv21 and
** LICENSE.LGPLv3 included in the packaging of this file. Please review the
** following information to ensure the GNU Lesser General Public License
** requirements will be met: https://www.gnu.org/licenses/lgpl.html and
** http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
****************************************************************************/
#pragma once
#include <unone.h>
#include <QString>
#include <QVector>
#include <QMap>
#include <QMutex>


struct ProcInfo {
	DWORD pid;
	DWORD ppid = -1;
	DWORD parent_existed = -1;
	QString name;
	QString desc;
	QString corp;
	QString ctime;
	QString path;
};
ProcInfo CacheGetProcInfo(unsigned int pid);
ProcInfo CacheGetProcInfo(unsigned int pid, ProcInfo& info);
void CacheGetProcChilds(unsigned int pid, QVector<ProcInfo>& infos);
void CacheRefreshProcInfo();

UNONE::PROCESS_BASE_INFOW CacheGetProcessBaseInfo(DWORD pid);

struct FileBaseInfo {
	QString path;
	QString desc;
	QString ver;
	QString corp;
};
FileBaseInfo CacheGetFileBaseInfo(QString path);