;++
;
; Copyright (c) Microsoft Corporation. All rights reserved. 
;
; You may only use this code if you agree to the terms of the Windows Research Kernel Source Code License agreement (see License.txt).
; If you do not agree to the terms, do not use the code.
;
; Module Name:
;
;   sysstubs.asm
;
; Abstract:
;
;   This module implements the system service dispatch stub procedures.
;
;--

include ksamd64.inc

STUBS_BEGIN1 macro t
        title   t
        endm

STUBS_BEGIN2 macro t
        endm

STUBS_BEGIN3 macro t
        endm

STUBS_BEGIN4 macro t
        endm

STUBS_BEGIN5 macro t
        endm

STUBS_BEGIN6 macro t
        endm

STUBS_BEGIN7 macro t
        endm

STUBS_BEGIN8 macro t
        endm

STUBS_END macro t
        end
        endm

SYSSTUBS_ENTRY1 macro ServiceNumber, Name, NumArgs
        extern  KiServiceInternal:proc
        extern  KiServiceLinkage:proc
        NESTED_ENTRY Zw&Name, _TEXT$00,, NoPad

if DBG

        mov     8[rsp], rcx             ; save argument register
        mov     16[rsp], rdx            ;
        mov     24[rsp], r8             ;
        mov     32[rsp], r9             ;

endif

        mov	rax, rsp		; save stack address
        cli                             ; disable interrupts
        sub     rsp, 16                 ; alignment and dummy SS selector
        push    rax                     ; save previous stack pointer
        pushfq                          ; push EFLAGS on stack
        push    KGDT64_R0_CODE          ; push CS selector
        lea     rax, KiServiceLinkage   ; push service linkage RIP
        push    rax                     ; push return address
        mov     eax, ServiceNumber      ; set service number
        jmp     KiServiceInternal       ; finish in service dispatcher
        push_frame                      ; mark machine frame push
        END_PROLOGUE
        NESTED_END Zw&Name, _TEXT$00
        endm

SYSSTUBS_ENTRY2 macro ServiceNumber, Name, NumArgs
        endm

SYSSTUBS_ENTRY3 macro ServiceNumber, Name, NumArgs
        endm

SYSSTUBS_ENTRY4 macro ServiceNumber, Name, NumArgs
        endm

SYSSTUBS_ENTRY5 macro ServiceNumber, Name, NumArgs
        endm

SYSSTUBS_ENTRY6 macro ServiceNumber, Name, NumArgs
        endm

SYSSTUBS_ENTRY7 macro ServiceNumber, Name, NumArgs
        endm

SYSSTUBS_ENTRY8 macro ServiceNumber, Name, NumArgs
        endm


USRSTUBS_ENTRY1 macro ServiceNumber, Name, NumArgs
        altentry Nt&Name
        endm

USRSTUBS_ENTRY2 macro ServiceNumber, Name, NumArgs

ifidn <Name>, <QuerySystemTime>

        extern RtlQuerySystemTime:proc

endif

        LEAF_ENTRY Zw&Name, _TEXT$00, NoPad
        ALTERNATE_ENTRY Nt&Name

if DBG

        mov     8[rsp], rcx
        mov     16[rsp], rdx
        mov     24[rsp], r8
        mov     32[rsp], r9

endif

ifidn <Name>, <QuerySystemTime>

        jmp     RtlQuerySystemTime

else

        mov     r10, rcx
        mov     eax, ServiceNumber
        syscall
        ret

endif

        LEAF_END Zw&Name, _TEXT$00
        endm

USRSTUBS_ENTRY3 macro ServiceNumber, Name, NumArgs
        endm

USRSTUBS_ENTRY4 macro ServiceNumber, Name, NumArgs
        endm

USRSTUBS_ENTRY5 macro ServiceNumber, Name, NumArgs
        endm

USRSTUBS_ENTRY6 macro ServiceNumber, Name, NumArgs
        endm

USRSTUBS_ENTRY7 macro ServiceNumber, Name, NumArgs
        endm

USRSTUBS_ENTRY8 macro ServiceNumber, Name, NumArgs
        endm

        STUBS_BEGIN1 <"System Service Stub Procedures">
        STUBS_BEGIN2 <"System Service Stub Procedures">
        STUBS_BEGIN3 <"System Service Stub Procedures">
        STUBS_BEGIN4 <"System Service Stub Procedures">
        STUBS_BEGIN5 <"System Service Stub Procedures">
        STUBS_BEGIN6 <"System Service Stub Procedures">
        STUBS_BEGIN7 <"System Service Stub Procedures">
        STUBS_BEGIN8 <"System Service Stub Procedures">
SYSSTUBS_ENTRY1  0, MapUserPhysicalPagesScatter, 0 
SYSSTUBS_ENTRY2  0, MapUserPhysicalPagesScatter, 0 
SYSSTUBS_ENTRY3  0, MapUserPhysicalPagesScatter, 0 
SYSSTUBS_ENTRY4  0, MapUserPhysicalPagesScatter, 0 
SYSSTUBS_ENTRY5  0, MapUserPhysicalPagesScatter, 0 
SYSSTUBS_ENTRY6  0, MapUserPhysicalPagesScatter, 0 
SYSSTUBS_ENTRY7  0, MapUserPhysicalPagesScatter, 0 
SYSSTUBS_ENTRY8  0, MapUserPhysicalPagesScatter, 0 
SYSSTUBS_ENTRY1  1, WaitForSingleObject, 0 
SYSSTUBS_ENTRY2  1, WaitForSingleObject, 0 
SYSSTUBS_ENTRY3  1, WaitForSingleObject, 0 
SYSSTUBS_ENTRY4  1, WaitForSingleObject, 0 
SYSSTUBS_ENTRY5  1, WaitForSingleObject, 0 
SYSSTUBS_ENTRY6  1, WaitForSingleObject, 0 
SYSSTUBS_ENTRY7  1, WaitForSingleObject, 0 
SYSSTUBS_ENTRY8  1, WaitForSingleObject, 0 
SYSSTUBS_ENTRY1  2, CallbackReturn, 0 
SYSSTUBS_ENTRY2  2, CallbackReturn, 0 
SYSSTUBS_ENTRY3  2, CallbackReturn, 0 
SYSSTUBS_ENTRY4  2, CallbackReturn, 0 
SYSSTUBS_ENTRY5  2, CallbackReturn, 0 
SYSSTUBS_ENTRY6  2, CallbackReturn, 0 
SYSSTUBS_ENTRY7  2, CallbackReturn, 0 
SYSSTUBS_ENTRY8  2, CallbackReturn, 0 
SYSSTUBS_ENTRY1  3, ReadFile, 5 
SYSSTUBS_ENTRY2  3, ReadFile, 5 
SYSSTUBS_ENTRY3  3, ReadFile, 5 
SYSSTUBS_ENTRY4  3, ReadFile, 5 
SYSSTUBS_ENTRY5  3, ReadFile, 5 
SYSSTUBS_ENTRY6  3, ReadFile, 5 
SYSSTUBS_ENTRY7  3, ReadFile, 5 
SYSSTUBS_ENTRY8  3, ReadFile, 5 
SYSSTUBS_ENTRY1  4, DeviceIoControlFile, 6 
SYSSTUBS_ENTRY2  4, DeviceIoControlFile, 6 
SYSSTUBS_ENTRY3  4, DeviceIoControlFile, 6 
SYSSTUBS_ENTRY4  4, DeviceIoControlFile, 6 
SYSSTUBS_ENTRY5  4, DeviceIoControlFile, 6 
SYSSTUBS_ENTRY6  4, DeviceIoControlFile, 6 
SYSSTUBS_ENTRY7  4, DeviceIoControlFile, 6 
SYSSTUBS_ENTRY8  4, DeviceIoControlFile, 6 
SYSSTUBS_ENTRY1  5, WriteFile, 5 
SYSSTUBS_ENTRY2  5, WriteFile, 5 
SYSSTUBS_ENTRY3  5, WriteFile, 5 
SYSSTUBS_ENTRY4  5, WriteFile, 5 
SYSSTUBS_ENTRY5  5, WriteFile, 5 
SYSSTUBS_ENTRY6  5, WriteFile, 5 
SYSSTUBS_ENTRY7  5, WriteFile, 5 
SYSSTUBS_ENTRY8  5, WriteFile, 5 
SYSSTUBS_ENTRY1  6, RemoveIoCompletion, 1 
SYSSTUBS_ENTRY2  6, RemoveIoCompletion, 1 
SYSSTUBS_ENTRY3  6, RemoveIoCompletion, 1 
SYSSTUBS_ENTRY4  6, RemoveIoCompletion, 1 
SYSSTUBS_ENTRY5  6, RemoveIoCompletion, 1 
SYSSTUBS_ENTRY6  6, RemoveIoCompletion, 1 
SYSSTUBS_ENTRY7  6, RemoveIoCompletion, 1 
SYSSTUBS_ENTRY8  6, RemoveIoCompletion, 1 
SYSSTUBS_ENTRY1  7, ReleaseSemaphore, 0 
SYSSTUBS_ENTRY2  7, ReleaseSemaphore, 0 
SYSSTUBS_ENTRY3  7, ReleaseSemaphore, 0 
SYSSTUBS_ENTRY4  7, ReleaseSemaphore, 0 
SYSSTUBS_ENTRY5  7, ReleaseSemaphore, 0 
SYSSTUBS_ENTRY6  7, ReleaseSemaphore, 0 
SYSSTUBS_ENTRY7  7, ReleaseSemaphore, 0 
SYSSTUBS_ENTRY8  7, ReleaseSemaphore, 0 
SYSSTUBS_ENTRY1  8, ReplyWaitReceivePort, 0 
SYSSTUBS_ENTRY2  8, ReplyWaitReceivePort, 0 
SYSSTUBS_ENTRY3  8, ReplyWaitReceivePort, 0 
SYSSTUBS_ENTRY4  8, ReplyWaitReceivePort, 0 
SYSSTUBS_ENTRY5  8, ReplyWaitReceivePort, 0 
SYSSTUBS_ENTRY6  8, ReplyWaitReceivePort, 0 
SYSSTUBS_ENTRY7  8, ReplyWaitReceivePort, 0 
SYSSTUBS_ENTRY8  8, ReplyWaitReceivePort, 0 
SYSSTUBS_ENTRY1  9, ReplyPort, 0 
SYSSTUBS_ENTRY2  9, ReplyPort, 0 
SYSSTUBS_ENTRY3  9, ReplyPort, 0 
SYSSTUBS_ENTRY4  9, ReplyPort, 0 
SYSSTUBS_ENTRY5  9, ReplyPort, 0 
SYSSTUBS_ENTRY6  9, ReplyPort, 0 
SYSSTUBS_ENTRY7  9, ReplyPort, 0 
SYSSTUBS_ENTRY8  9, ReplyPort, 0 
SYSSTUBS_ENTRY1  10, SetInformationThread, 0 
SYSSTUBS_ENTRY2  10, SetInformationThread, 0 
SYSSTUBS_ENTRY3  10, SetInformationThread, 0 
SYSSTUBS_ENTRY4  10, SetInformationThread, 0 
SYSSTUBS_ENTRY5  10, SetInformationThread, 0 
SYSSTUBS_ENTRY6  10, SetInformationThread, 0 
SYSSTUBS_ENTRY7  10, SetInformationThread, 0 
SYSSTUBS_ENTRY8  10, SetInformationThread, 0 
SYSSTUBS_ENTRY1  11, SetEvent, 0 
SYSSTUBS_ENTRY2  11, SetEvent, 0 
SYSSTUBS_ENTRY3  11, SetEvent, 0 
SYSSTUBS_ENTRY4  11, SetEvent, 0 
SYSSTUBS_ENTRY5  11, SetEvent, 0 
SYSSTUBS_ENTRY6  11, SetEvent, 0 
SYSSTUBS_ENTRY7  11, SetEvent, 0 
SYSSTUBS_ENTRY8  11, SetEvent, 0 
SYSSTUBS_ENTRY1  12, Close, 0 
SYSSTUBS_ENTRY2  12, Close, 0 
SYSSTUBS_ENTRY3  12, Close, 0 
SYSSTUBS_ENTRY4  12, Close, 0 
SYSSTUBS_ENTRY5  12, Close, 0 
SYSSTUBS_ENTRY6  12, Close, 0 
SYSSTUBS_ENTRY7  12, Close, 0 
SYSSTUBS_ENTRY8  12, Close, 0 
SYSSTUBS_ENTRY1  13, QueryObject, 1 
SYSSTUBS_ENTRY2  13, QueryObject, 1 
SYSSTUBS_ENTRY3  13, QueryObject, 1 
SYSSTUBS_ENTRY4  13, QueryObject, 1 
SYSSTUBS_ENTRY5  13, QueryObject, 1 
SYSSTUBS_ENTRY6  13, QueryObject, 1 
SYSSTUBS_ENTRY7  13, QueryObject, 1 
SYSSTUBS_ENTRY8  13, QueryObject, 1 
SYSSTUBS_ENTRY1  14, QueryInformationFile, 1 
SYSSTUBS_ENTRY2  14, QueryInformationFile, 1 
SYSSTUBS_ENTRY3  14, QueryInformationFile, 1 
SYSSTUBS_ENTRY4  14, QueryInformationFile, 1 
SYSSTUBS_ENTRY5  14, QueryInformationFile, 1 
SYSSTUBS_ENTRY6  14, QueryInformationFile, 1 
SYSSTUBS_ENTRY7  14, QueryInformationFile, 1 
SYSSTUBS_ENTRY8  14, QueryInformationFile, 1 
SYSSTUBS_ENTRY1  15, OpenKey, 0 
SYSSTUBS_ENTRY2  15, OpenKey, 0 
SYSSTUBS_ENTRY3  15, OpenKey, 0 
SYSSTUBS_ENTRY4  15, OpenKey, 0 
SYSSTUBS_ENTRY5  15, OpenKey, 0 
SYSSTUBS_ENTRY6  15, OpenKey, 0 
SYSSTUBS_ENTRY7  15, OpenKey, 0 
SYSSTUBS_ENTRY8  15, OpenKey, 0 
SYSSTUBS_ENTRY1  16, EnumerateValueKey, 2 
SYSSTUBS_ENTRY2  16, EnumerateValueKey, 2 
SYSSTUBS_ENTRY3  16, EnumerateValueKey, 2 
SYSSTUBS_ENTRY4  16, EnumerateValueKey, 2 
SYSSTUBS_ENTRY5  16, EnumerateValueKey, 2 
SYSSTUBS_ENTRY6  16, EnumerateValueKey, 2 
SYSSTUBS_ENTRY7  16, EnumerateValueKey, 2 
SYSSTUBS_ENTRY8  16, EnumerateValueKey, 2 
SYSSTUBS_ENTRY1  17, FindAtom, 0 
SYSSTUBS_ENTRY2  17, FindAtom, 0 
SYSSTUBS_ENTRY3  17, FindAtom, 0 
SYSSTUBS_ENTRY4  17, FindAtom, 0 
SYSSTUBS_ENTRY5  17, FindAtom, 0 
SYSSTUBS_ENTRY6  17, FindAtom, 0 
SYSSTUBS_ENTRY7  17, FindAtom, 0 
SYSSTUBS_ENTRY8  17, FindAtom, 0 
SYSSTUBS_ENTRY1  18, QueryDefaultLocale, 0 
SYSSTUBS_ENTRY2  18, QueryDefaultLocale, 0 
SYSSTUBS_ENTRY3  18, QueryDefaultLocale, 0 
SYSSTUBS_ENTRY4  18, QueryDefaultLocale, 0 
SYSSTUBS_ENTRY5  18, QueryDefaultLocale, 0 
SYSSTUBS_ENTRY6  18, QueryDefaultLocale, 0 
SYSSTUBS_ENTRY7  18, QueryDefaultLocale, 0 
SYSSTUBS_ENTRY8  18, QueryDefaultLocale, 0 
SYSSTUBS_ENTRY1  19, QueryKey, 1 
SYSSTUBS_ENTRY2  19, QueryKey, 1 
SYSSTUBS_ENTRY3  19, QueryKey, 1 
SYSSTUBS_ENTRY4  19, QueryKey, 1 
SYSSTUBS_ENTRY5  19, QueryKey, 1 
SYSSTUBS_ENTRY6  19, QueryKey, 1 
SYSSTUBS_ENTRY7  19, QueryKey, 1 
SYSSTUBS_ENTRY8  19, QueryKey, 1 
SYSSTUBS_ENTRY1  20, QueryValueKey, 2 
SYSSTUBS_ENTRY2  20, QueryValueKey, 2 
SYSSTUBS_ENTRY3  20, QueryValueKey, 2 
SYSSTUBS_ENTRY4  20, QueryValueKey, 2 
SYSSTUBS_ENTRY5  20, QueryValueKey, 2 
SYSSTUBS_ENTRY6  20, QueryValueKey, 2 
SYSSTUBS_ENTRY7  20, QueryValueKey, 2 
SYSSTUBS_ENTRY8  20, QueryValueKey, 2 
SYSSTUBS_ENTRY1  21, AllocateVirtualMemory, 2 
SYSSTUBS_ENTRY2  21, AllocateVirtualMemory, 2 
SYSSTUBS_ENTRY3  21, AllocateVirtualMemory, 2 
SYSSTUBS_ENTRY4  21, AllocateVirtualMemory, 2 
SYSSTUBS_ENTRY5  21, AllocateVirtualMemory, 2 
SYSSTUBS_ENTRY6  21, AllocateVirtualMemory, 2 
SYSSTUBS_ENTRY7  21, AllocateVirtualMemory, 2 
SYSSTUBS_ENTRY8  21, AllocateVirtualMemory, 2 
SYSSTUBS_ENTRY1  22, QueryInformationProcess, 1 
SYSSTUBS_ENTRY2  22, QueryInformationProcess, 1 
SYSSTUBS_ENTRY3  22, QueryInformationProcess, 1 
SYSSTUBS_ENTRY4  22, QueryInformationProcess, 1 
SYSSTUBS_ENTRY5  22, QueryInformationProcess, 1 
SYSSTUBS_ENTRY6  22, QueryInformationProcess, 1 
SYSSTUBS_ENTRY7  22, QueryInformationProcess, 1 
SYSSTUBS_ENTRY8  22, QueryInformationProcess, 1 
SYSSTUBS_ENTRY1  23, WaitForMultipleObjects32, 1 
SYSSTUBS_ENTRY2  23, WaitForMultipleObjects32, 1 
SYSSTUBS_ENTRY3  23, WaitForMultipleObjects32, 1 
SYSSTUBS_ENTRY4  23, WaitForMultipleObjects32, 1 
SYSSTUBS_ENTRY5  23, WaitForMultipleObjects32, 1 
SYSSTUBS_ENTRY6  23, WaitForMultipleObjects32, 1 
SYSSTUBS_ENTRY7  23, WaitForMultipleObjects32, 1 
SYSSTUBS_ENTRY8  23, WaitForMultipleObjects32, 1 
SYSSTUBS_ENTRY1  24, WriteFileGather, 5 
SYSSTUBS_ENTRY2  24, WriteFileGather, 5 
SYSSTUBS_ENTRY3  24, WriteFileGather, 5 
SYSSTUBS_ENTRY4  24, WriteFileGather, 5 
SYSSTUBS_ENTRY5  24, WriteFileGather, 5 
SYSSTUBS_ENTRY6  24, WriteFileGather, 5 
SYSSTUBS_ENTRY7  24, WriteFileGather, 5 
SYSSTUBS_ENTRY8  24, WriteFileGather, 5 
SYSSTUBS_ENTRY1  25, SetInformationProcess, 0 
SYSSTUBS_ENTRY2  25, SetInformationProcess, 0 
SYSSTUBS_ENTRY3  25, SetInformationProcess, 0 
SYSSTUBS_ENTRY4  25, SetInformationProcess, 0 
SYSSTUBS_ENTRY5  25, SetInformationProcess, 0 
SYSSTUBS_ENTRY6  25, SetInformationProcess, 0 
SYSSTUBS_ENTRY7  25, SetInformationProcess, 0 
SYSSTUBS_ENTRY8  25, SetInformationProcess, 0 
SYSSTUBS_ENTRY1  26, CreateKey, 3 
SYSSTUBS_ENTRY2  26, CreateKey, 3 
SYSSTUBS_ENTRY3  26, CreateKey, 3 
SYSSTUBS_ENTRY4  26, CreateKey, 3 
SYSSTUBS_ENTRY5  26, CreateKey, 3 
SYSSTUBS_ENTRY6  26, CreateKey, 3 
SYSSTUBS_ENTRY7  26, CreateKey, 3 
SYSSTUBS_ENTRY8  26, CreateKey, 3 
SYSSTUBS_ENTRY1  27, FreeVirtualMemory, 0 
SYSSTUBS_ENTRY2  27, FreeVirtualMemory, 0 
SYSSTUBS_ENTRY3  27, FreeVirtualMemory, 0 
SYSSTUBS_ENTRY4  27, FreeVirtualMemory, 0 
SYSSTUBS_ENTRY5  27, FreeVirtualMemory, 0 
SYSSTUBS_ENTRY6  27, FreeVirtualMemory, 0 
SYSSTUBS_ENTRY7  27, FreeVirtualMemory, 0 
SYSSTUBS_ENTRY8  27, FreeVirtualMemory, 0 
SYSSTUBS_ENTRY1  28, ImpersonateClientOfPort, 0 
SYSSTUBS_ENTRY2  28, ImpersonateClientOfPort, 0 
SYSSTUBS_ENTRY3  28, ImpersonateClientOfPort, 0 
SYSSTUBS_ENTRY4  28, ImpersonateClientOfPort, 0 
SYSSTUBS_ENTRY5  28, ImpersonateClientOfPort, 0 
SYSSTUBS_ENTRY6  28, ImpersonateClientOfPort, 0 
SYSSTUBS_ENTRY7  28, ImpersonateClientOfPort, 0 
SYSSTUBS_ENTRY8  28, ImpersonateClientOfPort, 0 
SYSSTUBS_ENTRY1  29, ReleaseMutant, 0 
SYSSTUBS_ENTRY2  29, ReleaseMutant, 0 
SYSSTUBS_ENTRY3  29, ReleaseMutant, 0 
SYSSTUBS_ENTRY4  29, ReleaseMutant, 0 
SYSSTUBS_ENTRY5  29, ReleaseMutant, 0 
SYSSTUBS_ENTRY6  29, ReleaseMutant, 0 
SYSSTUBS_ENTRY7  29, ReleaseMutant, 0 
SYSSTUBS_ENTRY8  29, ReleaseMutant, 0 
SYSSTUBS_ENTRY1  30, QueryInformationToken, 1 
SYSSTUBS_ENTRY2  30, QueryInformationToken, 1 
SYSSTUBS_ENTRY3  30, QueryInformationToken, 1 
SYSSTUBS_ENTRY4  30, QueryInformationToken, 1 
SYSSTUBS_ENTRY5  30, QueryInformationToken, 1 
SYSSTUBS_ENTRY6  30, QueryInformationToken, 1 
SYSSTUBS_ENTRY7  30, QueryInformationToken, 1 
SYSSTUBS_ENTRY8  30, QueryInformationToken, 1 
SYSSTUBS_ENTRY1  31, RequestWaitReplyPort, 0 
SYSSTUBS_ENTRY2  31, RequestWaitReplyPort, 0 
SYSSTUBS_ENTRY3  31, RequestWaitReplyPort, 0 
SYSSTUBS_ENTRY4  31, RequestWaitReplyPort, 0 
SYSSTUBS_ENTRY5  31, RequestWaitReplyPort, 0 
SYSSTUBS_ENTRY6  31, RequestWaitReplyPort, 0 
SYSSTUBS_ENTRY7  31, RequestWaitReplyPort, 0 
SYSSTUBS_ENTRY8  31, RequestWaitReplyPort, 0 
SYSSTUBS_ENTRY1  32, QueryVirtualMemory, 2 
SYSSTUBS_ENTRY2  32, QueryVirtualMemory, 2 
SYSSTUBS_ENTRY3  32, QueryVirtualMemory, 2 
SYSSTUBS_ENTRY4  32, QueryVirtualMemory, 2 
SYSSTUBS_ENTRY5  32, QueryVirtualMemory, 2 
SYSSTUBS_ENTRY6  32, QueryVirtualMemory, 2 
SYSSTUBS_ENTRY7  32, QueryVirtualMemory, 2 
SYSSTUBS_ENTRY8  32, QueryVirtualMemory, 2 
SYSSTUBS_ENTRY1  33, OpenThreadToken, 0 
SYSSTUBS_ENTRY2  33, OpenThreadToken, 0 
SYSSTUBS_ENTRY3  33, OpenThreadToken, 0 
SYSSTUBS_ENTRY4  33, OpenThreadToken, 0 
SYSSTUBS_ENTRY5  33, OpenThreadToken, 0 
SYSSTUBS_ENTRY6  33, OpenThreadToken, 0 
SYSSTUBS_ENTRY7  33, OpenThreadToken, 0 
SYSSTUBS_ENTRY8  33, OpenThreadToken, 0 
SYSSTUBS_ENTRY1  34, QueryInformationThread, 1 
SYSSTUBS_ENTRY2  34, QueryInformationThread, 1 
SYSSTUBS_ENTRY3  34, QueryInformationThread, 1 
SYSSTUBS_ENTRY4  34, QueryInformationThread, 1 
SYSSTUBS_ENTRY5  34, QueryInformationThread, 1 
SYSSTUBS_ENTRY6  34, QueryInformationThread, 1 
SYSSTUBS_ENTRY7  34, QueryInformationThread, 1 
SYSSTUBS_ENTRY8  34, QueryInformationThread, 1 
SYSSTUBS_ENTRY1  35, OpenProcess, 0 
SYSSTUBS_ENTRY2  35, OpenProcess, 0 
SYSSTUBS_ENTRY3  35, OpenProcess, 0 
SYSSTUBS_ENTRY4  35, OpenProcess, 0 
SYSSTUBS_ENTRY5  35, OpenProcess, 0 
SYSSTUBS_ENTRY6  35, OpenProcess, 0 
SYSSTUBS_ENTRY7  35, OpenProcess, 0 
SYSSTUBS_ENTRY8  35, OpenProcess, 0 
SYSSTUBS_ENTRY1  36, SetInformationFile, 1 
SYSSTUBS_ENTRY2  36, SetInformationFile, 1 
SYSSTUBS_ENTRY3  36, SetInformationFile, 1 
SYSSTUBS_ENTRY4  36, SetInformationFile, 1 
SYSSTUBS_ENTRY5  36, SetInformationFile, 1 
SYSSTUBS_ENTRY6  36, SetInformationFile, 1 
SYSSTUBS_ENTRY7  36, SetInformationFile, 1 
SYSSTUBS_ENTRY8  36, SetInformationFile, 1 
SYSSTUBS_ENTRY1  37, MapViewOfSection, 6 
SYSSTUBS_ENTRY2  37, MapViewOfSection, 6 
SYSSTUBS_ENTRY3  37, MapViewOfSection, 6 
SYSSTUBS_ENTRY4  37, MapViewOfSection, 6 
SYSSTUBS_ENTRY5  37, MapViewOfSection, 6 
SYSSTUBS_ENTRY6  37, MapViewOfSection, 6 
SYSSTUBS_ENTRY7  37, MapViewOfSection, 6 
SYSSTUBS_ENTRY8  37, MapViewOfSection, 6 
SYSSTUBS_ENTRY1  38, AccessCheckAndAuditAlarm, 7 
SYSSTUBS_ENTRY2  38, AccessCheckAndAuditAlarm, 7 
SYSSTUBS_ENTRY3  38, AccessCheckAndAuditAlarm, 7 
SYSSTUBS_ENTRY4  38, AccessCheckAndAuditAlarm, 7 
SYSSTUBS_ENTRY5  38, AccessCheckAndAuditAlarm, 7 
SYSSTUBS_ENTRY6  38, AccessCheckAndAuditAlarm, 7 
SYSSTUBS_ENTRY7  38, AccessCheckAndAuditAlarm, 7 
SYSSTUBS_ENTRY8  38, AccessCheckAndAuditAlarm, 7 
SYSSTUBS_ENTRY1  39, UnmapViewOfSection, 0 
SYSSTUBS_ENTRY2  39, UnmapViewOfSection, 0 
SYSSTUBS_ENTRY3  39, UnmapViewOfSection, 0 
SYSSTUBS_ENTRY4  39, UnmapViewOfSection, 0 
SYSSTUBS_ENTRY5  39, UnmapViewOfSection, 0 
SYSSTUBS_ENTRY6  39, UnmapViewOfSection, 0 
SYSSTUBS_ENTRY7  39, UnmapViewOfSection, 0 
SYSSTUBS_ENTRY8  39, UnmapViewOfSection, 0 
SYSSTUBS_ENTRY1  40, ReplyWaitReceivePortEx, 1 
SYSSTUBS_ENTRY2  40, ReplyWaitReceivePortEx, 1 
SYSSTUBS_ENTRY3  40, ReplyWaitReceivePortEx, 1 
SYSSTUBS_ENTRY4  40, ReplyWaitReceivePortEx, 1 
SYSSTUBS_ENTRY5  40, ReplyWaitReceivePortEx, 1 
SYSSTUBS_ENTRY6  40, ReplyWaitReceivePortEx, 1 
SYSSTUBS_ENTRY7  40, ReplyWaitReceivePortEx, 1 
SYSSTUBS_ENTRY8  40, ReplyWaitReceivePortEx, 1 
SYSSTUBS_ENTRY1  41, TerminateProcess, 0 
SYSSTUBS_ENTRY2  41, TerminateProcess, 0 
SYSSTUBS_ENTRY3  41, TerminateProcess, 0 
SYSSTUBS_ENTRY4  41, TerminateProcess, 0 
SYSSTUBS_ENTRY5  41, TerminateProcess, 0 
SYSSTUBS_ENTRY6  41, TerminateProcess, 0 
SYSSTUBS_ENTRY7  41, TerminateProcess, 0 
SYSSTUBS_ENTRY8  41, TerminateProcess, 0 
SYSSTUBS_ENTRY1  42, SetEventBoostPriority, 0 
SYSSTUBS_ENTRY2  42, SetEventBoostPriority, 0 
SYSSTUBS_ENTRY3  42, SetEventBoostPriority, 0 
SYSSTUBS_ENTRY4  42, SetEventBoostPriority, 0 
SYSSTUBS_ENTRY5  42, SetEventBoostPriority, 0 
SYSSTUBS_ENTRY6  42, SetEventBoostPriority, 0 
SYSSTUBS_ENTRY7  42, SetEventBoostPriority, 0 
SYSSTUBS_ENTRY8  42, SetEventBoostPriority, 0 
SYSSTUBS_ENTRY1  43, ReadFileScatter, 5 
SYSSTUBS_ENTRY2  43, ReadFileScatter, 5 
SYSSTUBS_ENTRY3  43, ReadFileScatter, 5 
SYSSTUBS_ENTRY4  43, ReadFileScatter, 5 
SYSSTUBS_ENTRY5  43, ReadFileScatter, 5 
SYSSTUBS_ENTRY6  43, ReadFileScatter, 5 
SYSSTUBS_ENTRY7  43, ReadFileScatter, 5 
SYSSTUBS_ENTRY8  43, ReadFileScatter, 5 
SYSSTUBS_ENTRY1  44, OpenThreadTokenEx, 1 
SYSSTUBS_ENTRY2  44, OpenThreadTokenEx, 1 
SYSSTUBS_ENTRY3  44, OpenThreadTokenEx, 1 
SYSSTUBS_ENTRY4  44, OpenThreadTokenEx, 1 
SYSSTUBS_ENTRY5  44, OpenThreadTokenEx, 1 
SYSSTUBS_ENTRY6  44, OpenThreadTokenEx, 1 
SYSSTUBS_ENTRY7  44, OpenThreadTokenEx, 1 
SYSSTUBS_ENTRY8  44, OpenThreadTokenEx, 1 
SYSSTUBS_ENTRY1  45, OpenProcessTokenEx, 0 
SYSSTUBS_ENTRY2  45, OpenProcessTokenEx, 0 
SYSSTUBS_ENTRY3  45, OpenProcessTokenEx, 0 
SYSSTUBS_ENTRY4  45, OpenProcessTokenEx, 0 
SYSSTUBS_ENTRY5  45, OpenProcessTokenEx, 0 
SYSSTUBS_ENTRY6  45, OpenProcessTokenEx, 0 
SYSSTUBS_ENTRY7  45, OpenProcessTokenEx, 0 
SYSSTUBS_ENTRY8  45, OpenProcessTokenEx, 0 
SYSSTUBS_ENTRY1  46, QueryPerformanceCounter, 0 
SYSSTUBS_ENTRY2  46, QueryPerformanceCounter, 0 
SYSSTUBS_ENTRY3  46, QueryPerformanceCounter, 0 
SYSSTUBS_ENTRY4  46, QueryPerformanceCounter, 0 
SYSSTUBS_ENTRY5  46, QueryPerformanceCounter, 0 
SYSSTUBS_ENTRY6  46, QueryPerformanceCounter, 0 
SYSSTUBS_ENTRY7  46, QueryPerformanceCounter, 0 
SYSSTUBS_ENTRY8  46, QueryPerformanceCounter, 0 
SYSSTUBS_ENTRY1  47, EnumerateKey, 2 
SYSSTUBS_ENTRY2  47, EnumerateKey, 2 
SYSSTUBS_ENTRY3  47, EnumerateKey, 2 
SYSSTUBS_ENTRY4  47, EnumerateKey, 2 
SYSSTUBS_ENTRY5  47, EnumerateKey, 2 
SYSSTUBS_ENTRY6  47, EnumerateKey, 2 
SYSSTUBS_ENTRY7  47, EnumerateKey, 2 
SYSSTUBS_ENTRY8  47, EnumerateKey, 2 
SYSSTUBS_ENTRY1  48, OpenFile, 2 
SYSSTUBS_ENTRY2  48, OpenFile, 2 
SYSSTUBS_ENTRY3  48, OpenFile, 2 
SYSSTUBS_ENTRY4  48, OpenFile, 2 
SYSSTUBS_ENTRY5  48, OpenFile, 2 
SYSSTUBS_ENTRY6  48, OpenFile, 2 
SYSSTUBS_ENTRY7  48, OpenFile, 2 
SYSSTUBS_ENTRY8  48, OpenFile, 2 
SYSSTUBS_ENTRY1  49, DelayExecution, 0 
SYSSTUBS_ENTRY2  49, DelayExecution, 0 
SYSSTUBS_ENTRY3  49, DelayExecution, 0 
SYSSTUBS_ENTRY4  49, DelayExecution, 0 
SYSSTUBS_ENTRY5  49, DelayExecution, 0 
SYSSTUBS_ENTRY6  49, DelayExecution, 0 
SYSSTUBS_ENTRY7  49, DelayExecution, 0 
SYSSTUBS_ENTRY8  49, DelayExecution, 0 
SYSSTUBS_ENTRY1  50, QueryDirectoryFile, 7 
SYSSTUBS_ENTRY2  50, QueryDirectoryFile, 7 
SYSSTUBS_ENTRY3  50, QueryDirectoryFile, 7 
SYSSTUBS_ENTRY4  50, QueryDirectoryFile, 7 
SYSSTUBS_ENTRY5  50, QueryDirectoryFile, 7 
SYSSTUBS_ENTRY6  50, QueryDirectoryFile, 7 
SYSSTUBS_ENTRY7  50, QueryDirectoryFile, 7 
SYSSTUBS_ENTRY8  50, QueryDirectoryFile, 7 
SYSSTUBS_ENTRY1  51, QuerySystemInformation, 0 
SYSSTUBS_ENTRY2  51, QuerySystemInformation, 0 
SYSSTUBS_ENTRY3  51, QuerySystemInformation, 0 
SYSSTUBS_ENTRY4  51, QuerySystemInformation, 0 
SYSSTUBS_ENTRY5  51, QuerySystemInformation, 0 
SYSSTUBS_ENTRY6  51, QuerySystemInformation, 0 
SYSSTUBS_ENTRY7  51, QuerySystemInformation, 0 
SYSSTUBS_ENTRY8  51, QuerySystemInformation, 0 
SYSSTUBS_ENTRY1  52, OpenSection, 0 
SYSSTUBS_ENTRY2  52, OpenSection, 0 
SYSSTUBS_ENTRY3  52, OpenSection, 0 
SYSSTUBS_ENTRY4  52, OpenSection, 0 
SYSSTUBS_ENTRY5  52, OpenSection, 0 
SYSSTUBS_ENTRY6  52, OpenSection, 0 
SYSSTUBS_ENTRY7  52, OpenSection, 0 
SYSSTUBS_ENTRY8  52, OpenSection, 0 
SYSSTUBS_ENTRY1  53, QueryTimer, 1 
SYSSTUBS_ENTRY2  53, QueryTimer, 1 
SYSSTUBS_ENTRY3  53, QueryTimer, 1 
SYSSTUBS_ENTRY4  53, QueryTimer, 1 
SYSSTUBS_ENTRY5  53, QueryTimer, 1 
SYSSTUBS_ENTRY6  53, QueryTimer, 1 
SYSSTUBS_ENTRY7  53, QueryTimer, 1 
SYSSTUBS_ENTRY8  53, QueryTimer, 1 
SYSSTUBS_ENTRY1  54, FsControlFile, 6 
SYSSTUBS_ENTRY2  54, FsControlFile, 6 
SYSSTUBS_ENTRY3  54, FsControlFile, 6 
SYSSTUBS_ENTRY4  54, FsControlFile, 6 
SYSSTUBS_ENTRY5  54, FsControlFile, 6 
SYSSTUBS_ENTRY6  54, FsControlFile, 6 
SYSSTUBS_ENTRY7  54, FsControlFile, 6 
SYSSTUBS_ENTRY8  54, FsControlFile, 6 
SYSSTUBS_ENTRY1  55, WriteVirtualMemory, 1 
SYSSTUBS_ENTRY2  55, WriteVirtualMemory, 1 
SYSSTUBS_ENTRY3  55, WriteVirtualMemory, 1 
SYSSTUBS_ENTRY4  55, WriteVirtualMemory, 1 
SYSSTUBS_ENTRY5  55, WriteVirtualMemory, 1 
SYSSTUBS_ENTRY6  55, WriteVirtualMemory, 1 
SYSSTUBS_ENTRY7  55, WriteVirtualMemory, 1 
SYSSTUBS_ENTRY8  55, WriteVirtualMemory, 1 
SYSSTUBS_ENTRY1  56, CloseObjectAuditAlarm, 0 
SYSSTUBS_ENTRY2  56, CloseObjectAuditAlarm, 0 
SYSSTUBS_ENTRY3  56, CloseObjectAuditAlarm, 0 
SYSSTUBS_ENTRY4  56, CloseObjectAuditAlarm, 0 
SYSSTUBS_ENTRY5  56, CloseObjectAuditAlarm, 0 
SYSSTUBS_ENTRY6  56, CloseObjectAuditAlarm, 0 
SYSSTUBS_ENTRY7  56, CloseObjectAuditAlarm, 0 
SYSSTUBS_ENTRY8  56, CloseObjectAuditAlarm, 0 
SYSSTUBS_ENTRY1  57, DuplicateObject, 3 
SYSSTUBS_ENTRY2  57, DuplicateObject, 3 
SYSSTUBS_ENTRY3  57, DuplicateObject, 3 
SYSSTUBS_ENTRY4  57, DuplicateObject, 3 
SYSSTUBS_ENTRY5  57, DuplicateObject, 3 
SYSSTUBS_ENTRY6  57, DuplicateObject, 3 
SYSSTUBS_ENTRY7  57, DuplicateObject, 3 
SYSSTUBS_ENTRY8  57, DuplicateObject, 3 
SYSSTUBS_ENTRY1  58, QueryAttributesFile, 0 
SYSSTUBS_ENTRY2  58, QueryAttributesFile, 0 
SYSSTUBS_ENTRY3  58, QueryAttributesFile, 0 
SYSSTUBS_ENTRY4  58, QueryAttributesFile, 0 
SYSSTUBS_ENTRY5  58, QueryAttributesFile, 0 
SYSSTUBS_ENTRY6  58, QueryAttributesFile, 0 
SYSSTUBS_ENTRY7  58, QueryAttributesFile, 0 
SYSSTUBS_ENTRY8  58, QueryAttributesFile, 0 
SYSSTUBS_ENTRY1  59, ClearEvent, 0 
SYSSTUBS_ENTRY2  59, ClearEvent, 0 
SYSSTUBS_ENTRY3  59, ClearEvent, 0 
SYSSTUBS_ENTRY4  59, ClearEvent, 0 
SYSSTUBS_ENTRY5  59, ClearEvent, 0 
SYSSTUBS_ENTRY6  59, ClearEvent, 0 
SYSSTUBS_ENTRY7  59, ClearEvent, 0 
SYSSTUBS_ENTRY8  59, ClearEvent, 0 
SYSSTUBS_ENTRY1  60, ReadVirtualMemory, 1 
SYSSTUBS_ENTRY2  60, ReadVirtualMemory, 1 
SYSSTUBS_ENTRY3  60, ReadVirtualMemory, 1 
SYSSTUBS_ENTRY4  60, ReadVirtualMemory, 1 
SYSSTUBS_ENTRY5  60, ReadVirtualMemory, 1 
SYSSTUBS_ENTRY6  60, ReadVirtualMemory, 1 
SYSSTUBS_ENTRY7  60, ReadVirtualMemory, 1 
SYSSTUBS_ENTRY8  60, ReadVirtualMemory, 1 
SYSSTUBS_ENTRY1  61, OpenEvent, 0 
SYSSTUBS_ENTRY2  61, OpenEvent, 0 
SYSSTUBS_ENTRY3  61, OpenEvent, 0 
SYSSTUBS_ENTRY4  61, OpenEvent, 0 
SYSSTUBS_ENTRY5  61, OpenEvent, 0 
SYSSTUBS_ENTRY6  61, OpenEvent, 0 
SYSSTUBS_ENTRY7  61, OpenEvent, 0 
SYSSTUBS_ENTRY8  61, OpenEvent, 0 
SYSSTUBS_ENTRY1  62, AdjustPrivilegesToken, 2 
SYSSTUBS_ENTRY2  62, AdjustPrivilegesToken, 2 
SYSSTUBS_ENTRY3  62, AdjustPrivilegesToken, 2 
SYSSTUBS_ENTRY4  62, AdjustPrivilegesToken, 2 
SYSSTUBS_ENTRY5  62, AdjustPrivilegesToken, 2 
SYSSTUBS_ENTRY6  62, AdjustPrivilegesToken, 2 
SYSSTUBS_ENTRY7  62, AdjustPrivilegesToken, 2 
SYSSTUBS_ENTRY8  62, AdjustPrivilegesToken, 2 
SYSSTUBS_ENTRY1  63, DuplicateToken, 2 
SYSSTUBS_ENTRY2  63, DuplicateToken, 2 
SYSSTUBS_ENTRY3  63, DuplicateToken, 2 
SYSSTUBS_ENTRY4  63, DuplicateToken, 2 
SYSSTUBS_ENTRY5  63, DuplicateToken, 2 
SYSSTUBS_ENTRY6  63, DuplicateToken, 2 
SYSSTUBS_ENTRY7  63, DuplicateToken, 2 
SYSSTUBS_ENTRY8  63, DuplicateToken, 2 
SYSSTUBS_ENTRY1  64, Continue, 0 
SYSSTUBS_ENTRY2  64, Continue, 0 
SYSSTUBS_ENTRY3  64, Continue, 0 
SYSSTUBS_ENTRY4  64, Continue, 0 
SYSSTUBS_ENTRY5  64, Continue, 0 
SYSSTUBS_ENTRY6  64, Continue, 0 
SYSSTUBS_ENTRY7  64, Continue, 0 
SYSSTUBS_ENTRY8  64, Continue, 0 
SYSSTUBS_ENTRY1  65, QueryDefaultUILanguage, 0 
SYSSTUBS_ENTRY2  65, QueryDefaultUILanguage, 0 
SYSSTUBS_ENTRY3  65, QueryDefaultUILanguage, 0 
SYSSTUBS_ENTRY4  65, QueryDefaultUILanguage, 0 
SYSSTUBS_ENTRY5  65, QueryDefaultUILanguage, 0 
SYSSTUBS_ENTRY6  65, QueryDefaultUILanguage, 0 
SYSSTUBS_ENTRY7  65, QueryDefaultUILanguage, 0 
SYSSTUBS_ENTRY8  65, QueryDefaultUILanguage, 0 
SYSSTUBS_ENTRY1  66, QueueApcThread, 1 
SYSSTUBS_ENTRY2  66, QueueApcThread, 1 
SYSSTUBS_ENTRY3  66, QueueApcThread, 1 
SYSSTUBS_ENTRY4  66, QueueApcThread, 1 
SYSSTUBS_ENTRY5  66, QueueApcThread, 1 
SYSSTUBS_ENTRY6  66, QueueApcThread, 1 
SYSSTUBS_ENTRY7  66, QueueApcThread, 1 
SYSSTUBS_ENTRY8  66, QueueApcThread, 1 
SYSSTUBS_ENTRY1  67, YieldExecution, 0 
SYSSTUBS_ENTRY2  67, YieldExecution, 0 
SYSSTUBS_ENTRY3  67, YieldExecution, 0 
SYSSTUBS_ENTRY4  67, YieldExecution, 0 
SYSSTUBS_ENTRY5  67, YieldExecution, 0 
SYSSTUBS_ENTRY6  67, YieldExecution, 0 
SYSSTUBS_ENTRY7  67, YieldExecution, 0 
SYSSTUBS_ENTRY8  67, YieldExecution, 0 
SYSSTUBS_ENTRY1  68, AddAtom, 0 
SYSSTUBS_ENTRY2  68, AddAtom, 0 
SYSSTUBS_ENTRY3  68, AddAtom, 0 
SYSSTUBS_ENTRY4  68, AddAtom, 0 
SYSSTUBS_ENTRY5  68, AddAtom, 0 
SYSSTUBS_ENTRY6  68, AddAtom, 0 
SYSSTUBS_ENTRY7  68, AddAtom, 0 
SYSSTUBS_ENTRY8  68, AddAtom, 0 
SYSSTUBS_ENTRY1  69, CreateEvent, 1 
SYSSTUBS_ENTRY2  69, CreateEvent, 1 
SYSSTUBS_ENTRY3  69, CreateEvent, 1 
SYSSTUBS_ENTRY4  69, CreateEvent, 1 
SYSSTUBS_ENTRY5  69, CreateEvent, 1 
SYSSTUBS_ENTRY6  69, CreateEvent, 1 
SYSSTUBS_ENTRY7  69, CreateEvent, 1 
SYSSTUBS_ENTRY8  69, CreateEvent, 1 
SYSSTUBS_ENTRY1  70, QueryVolumeInformationFile, 1 
SYSSTUBS_ENTRY2  70, QueryVolumeInformationFile, 1 
SYSSTUBS_ENTRY3  70, QueryVolumeInformationFile, 1 
SYSSTUBS_ENTRY4  70, QueryVolumeInformationFile, 1 
SYSSTUBS_ENTRY5  70, QueryVolumeInformationFile, 1 
SYSSTUBS_ENTRY6  70, QueryVolumeInformationFile, 1 
SYSSTUBS_ENTRY7  70, QueryVolumeInformationFile, 1 
SYSSTUBS_ENTRY8  70, QueryVolumeInformationFile, 1 
SYSSTUBS_ENTRY1  71, CreateSection, 3 
SYSSTUBS_ENTRY2  71, CreateSection, 3 
SYSSTUBS_ENTRY3  71, CreateSection, 3 
SYSSTUBS_ENTRY4  71, CreateSection, 3 
SYSSTUBS_ENTRY5  71, CreateSection, 3 
SYSSTUBS_ENTRY6  71, CreateSection, 3 
SYSSTUBS_ENTRY7  71, CreateSection, 3 
SYSSTUBS_ENTRY8  71, CreateSection, 3 
SYSSTUBS_ENTRY1  72, FlushBuffersFile, 0 
SYSSTUBS_ENTRY2  72, FlushBuffersFile, 0 
SYSSTUBS_ENTRY3  72, FlushBuffersFile, 0 
SYSSTUBS_ENTRY4  72, FlushBuffersFile, 0 
SYSSTUBS_ENTRY5  72, FlushBuffersFile, 0 
SYSSTUBS_ENTRY6  72, FlushBuffersFile, 0 
SYSSTUBS_ENTRY7  72, FlushBuffersFile, 0 
SYSSTUBS_ENTRY8  72, FlushBuffersFile, 0 
SYSSTUBS_ENTRY1  73, ApphelpCacheControl, 0 
SYSSTUBS_ENTRY2  73, ApphelpCacheControl, 0 
SYSSTUBS_ENTRY3  73, ApphelpCacheControl, 0 
SYSSTUBS_ENTRY4  73, ApphelpCacheControl, 0 
SYSSTUBS_ENTRY5  73, ApphelpCacheControl, 0 
SYSSTUBS_ENTRY6  73, ApphelpCacheControl, 0 
SYSSTUBS_ENTRY7  73, ApphelpCacheControl, 0 
SYSSTUBS_ENTRY8  73, ApphelpCacheControl, 0 
SYSSTUBS_ENTRY1  74, CreateProcessEx, 5 
SYSSTUBS_ENTRY2  74, CreateProcessEx, 5 
SYSSTUBS_ENTRY3  74, CreateProcessEx, 5 
SYSSTUBS_ENTRY4  74, CreateProcessEx, 5 
SYSSTUBS_ENTRY5  74, CreateProcessEx, 5 
SYSSTUBS_ENTRY6  74, CreateProcessEx, 5 
SYSSTUBS_ENTRY7  74, CreateProcessEx, 5 
SYSSTUBS_ENTRY8  74, CreateProcessEx, 5 
SYSSTUBS_ENTRY1  75, CreateThread, 4 
SYSSTUBS_ENTRY2  75, CreateThread, 4 
SYSSTUBS_ENTRY3  75, CreateThread, 4 
SYSSTUBS_ENTRY4  75, CreateThread, 4 
SYSSTUBS_ENTRY5  75, CreateThread, 4 
SYSSTUBS_ENTRY6  75, CreateThread, 4 
SYSSTUBS_ENTRY7  75, CreateThread, 4 
SYSSTUBS_ENTRY8  75, CreateThread, 4 
SYSSTUBS_ENTRY1  76, IsProcessInJob, 0 
SYSSTUBS_ENTRY2  76, IsProcessInJob, 0 
SYSSTUBS_ENTRY3  76, IsProcessInJob, 0 
SYSSTUBS_ENTRY4  76, IsProcessInJob, 0 
SYSSTUBS_ENTRY5  76, IsProcessInJob, 0 
SYSSTUBS_ENTRY6  76, IsProcessInJob, 0 
SYSSTUBS_ENTRY7  76, IsProcessInJob, 0 
SYSSTUBS_ENTRY8  76, IsProcessInJob, 0 
SYSSTUBS_ENTRY1  77, ProtectVirtualMemory, 1 
SYSSTUBS_ENTRY2  77, ProtectVirtualMemory, 1 
SYSSTUBS_ENTRY3  77, ProtectVirtualMemory, 1 
SYSSTUBS_ENTRY4  77, ProtectVirtualMemory, 1 
SYSSTUBS_ENTRY5  77, ProtectVirtualMemory, 1 
SYSSTUBS_ENTRY6  77, ProtectVirtualMemory, 1 
SYSSTUBS_ENTRY7  77, ProtectVirtualMemory, 1 
SYSSTUBS_ENTRY8  77, ProtectVirtualMemory, 1 
SYSSTUBS_ENTRY1  78, QuerySection, 1 
SYSSTUBS_ENTRY2  78, QuerySection, 1 
SYSSTUBS_ENTRY3  78, QuerySection, 1 
SYSSTUBS_ENTRY4  78, QuerySection, 1 
SYSSTUBS_ENTRY5  78, QuerySection, 1 
SYSSTUBS_ENTRY6  78, QuerySection, 1 
SYSSTUBS_ENTRY7  78, QuerySection, 1 
SYSSTUBS_ENTRY8  78, QuerySection, 1 
SYSSTUBS_ENTRY1  79, ResumeThread, 0 
SYSSTUBS_ENTRY2  79, ResumeThread, 0 
SYSSTUBS_ENTRY3  79, ResumeThread, 0 
SYSSTUBS_ENTRY4  79, ResumeThread, 0 
SYSSTUBS_ENTRY5  79, ResumeThread, 0 
SYSSTUBS_ENTRY6  79, ResumeThread, 0 
SYSSTUBS_ENTRY7  79, ResumeThread, 0 
SYSSTUBS_ENTRY8  79, ResumeThread, 0 
SYSSTUBS_ENTRY1  80, TerminateThread, 0 
SYSSTUBS_ENTRY2  80, TerminateThread, 0 
SYSSTUBS_ENTRY3  80, TerminateThread, 0 
SYSSTUBS_ENTRY4  80, TerminateThread, 0 
SYSSTUBS_ENTRY5  80, TerminateThread, 0 
SYSSTUBS_ENTRY6  80, TerminateThread, 0 
SYSSTUBS_ENTRY7  80, TerminateThread, 0 
SYSSTUBS_ENTRY8  80, TerminateThread, 0 
SYSSTUBS_ENTRY1  81, ReadRequestData, 2 
SYSSTUBS_ENTRY2  81, ReadRequestData, 2 
SYSSTUBS_ENTRY3  81, ReadRequestData, 2 
SYSSTUBS_ENTRY4  81, ReadRequestData, 2 
SYSSTUBS_ENTRY5  81, ReadRequestData, 2 
SYSSTUBS_ENTRY6  81, ReadRequestData, 2 
SYSSTUBS_ENTRY7  81, ReadRequestData, 2 
SYSSTUBS_ENTRY8  81, ReadRequestData, 2 
SYSSTUBS_ENTRY1  82, CreateFile, 7 
SYSSTUBS_ENTRY2  82, CreateFile, 7 
SYSSTUBS_ENTRY3  82, CreateFile, 7 
SYSSTUBS_ENTRY4  82, CreateFile, 7 
SYSSTUBS_ENTRY5  82, CreateFile, 7 
SYSSTUBS_ENTRY6  82, CreateFile, 7 
SYSSTUBS_ENTRY7  82, CreateFile, 7 
SYSSTUBS_ENTRY8  82, CreateFile, 7 
SYSSTUBS_ENTRY1  83, QueryEvent, 1 
SYSSTUBS_ENTRY2  83, QueryEvent, 1 
SYSSTUBS_ENTRY3  83, QueryEvent, 1 
SYSSTUBS_ENTRY4  83, QueryEvent, 1 
SYSSTUBS_ENTRY5  83, QueryEvent, 1 
SYSSTUBS_ENTRY6  83, QueryEvent, 1 
SYSSTUBS_ENTRY7  83, QueryEvent, 1 
SYSSTUBS_ENTRY8  83, QueryEvent, 1 
SYSSTUBS_ENTRY1  84, WriteRequestData, 2 
SYSSTUBS_ENTRY2  84, WriteRequestData, 2 
SYSSTUBS_ENTRY3  84, WriteRequestData, 2 
SYSSTUBS_ENTRY4  84, WriteRequestData, 2 
SYSSTUBS_ENTRY5  84, WriteRequestData, 2 
SYSSTUBS_ENTRY6  84, WriteRequestData, 2 
SYSSTUBS_ENTRY7  84, WriteRequestData, 2 
SYSSTUBS_ENTRY8  84, WriteRequestData, 2 
SYSSTUBS_ENTRY1  85, OpenDirectoryObject, 0 
SYSSTUBS_ENTRY2  85, OpenDirectoryObject, 0 
SYSSTUBS_ENTRY3  85, OpenDirectoryObject, 0 
SYSSTUBS_ENTRY4  85, OpenDirectoryObject, 0 
SYSSTUBS_ENTRY5  85, OpenDirectoryObject, 0 
SYSSTUBS_ENTRY6  85, OpenDirectoryObject, 0 
SYSSTUBS_ENTRY7  85, OpenDirectoryObject, 0 
SYSSTUBS_ENTRY8  85, OpenDirectoryObject, 0 
SYSSTUBS_ENTRY1  86, AccessCheckByTypeAndAuditAlarm, 12 
SYSSTUBS_ENTRY2  86, AccessCheckByTypeAndAuditAlarm, 12 
SYSSTUBS_ENTRY3  86, AccessCheckByTypeAndAuditAlarm, 12 
SYSSTUBS_ENTRY4  86, AccessCheckByTypeAndAuditAlarm, 12 
SYSSTUBS_ENTRY5  86, AccessCheckByTypeAndAuditAlarm, 12 
SYSSTUBS_ENTRY6  86, AccessCheckByTypeAndAuditAlarm, 12 
SYSSTUBS_ENTRY7  86, AccessCheckByTypeAndAuditAlarm, 12 
SYSSTUBS_ENTRY8  86, AccessCheckByTypeAndAuditAlarm, 12 
SYSSTUBS_ENTRY1  87, QuerySystemTime, 0 
SYSSTUBS_ENTRY2  87, QuerySystemTime, 0 
SYSSTUBS_ENTRY3  87, QuerySystemTime, 0 
SYSSTUBS_ENTRY4  87, QuerySystemTime, 0 
SYSSTUBS_ENTRY5  87, QuerySystemTime, 0 
SYSSTUBS_ENTRY6  87, QuerySystemTime, 0 
SYSSTUBS_ENTRY7  87, QuerySystemTime, 0 
SYSSTUBS_ENTRY8  87, QuerySystemTime, 0 
SYSSTUBS_ENTRY1  88, WaitForMultipleObjects, 1 
SYSSTUBS_ENTRY2  88, WaitForMultipleObjects, 1 
SYSSTUBS_ENTRY3  88, WaitForMultipleObjects, 1 
SYSSTUBS_ENTRY4  88, WaitForMultipleObjects, 1 
SYSSTUBS_ENTRY5  88, WaitForMultipleObjects, 1 
SYSSTUBS_ENTRY6  88, WaitForMultipleObjects, 1 
SYSSTUBS_ENTRY7  88, WaitForMultipleObjects, 1 
SYSSTUBS_ENTRY8  88, WaitForMultipleObjects, 1 
SYSSTUBS_ENTRY1  89, SetInformationObject, 0 
SYSSTUBS_ENTRY2  89, SetInformationObject, 0 
SYSSTUBS_ENTRY3  89, SetInformationObject, 0 
SYSSTUBS_ENTRY4  89, SetInformationObject, 0 
SYSSTUBS_ENTRY5  89, SetInformationObject, 0 
SYSSTUBS_ENTRY6  89, SetInformationObject, 0 
SYSSTUBS_ENTRY7  89, SetInformationObject, 0 
SYSSTUBS_ENTRY8  89, SetInformationObject, 0 
SYSSTUBS_ENTRY1  90, CancelIoFile, 0 
SYSSTUBS_ENTRY2  90, CancelIoFile, 0 
SYSSTUBS_ENTRY3  90, CancelIoFile, 0 
SYSSTUBS_ENTRY4  90, CancelIoFile, 0 
SYSSTUBS_ENTRY5  90, CancelIoFile, 0 
SYSSTUBS_ENTRY6  90, CancelIoFile, 0 
SYSSTUBS_ENTRY7  90, CancelIoFile, 0 
SYSSTUBS_ENTRY8  90, CancelIoFile, 0 
SYSSTUBS_ENTRY1  91, TraceEvent, 0 
SYSSTUBS_ENTRY2  91, TraceEvent, 0 
SYSSTUBS_ENTRY3  91, TraceEvent, 0 
SYSSTUBS_ENTRY4  91, TraceEvent, 0 
SYSSTUBS_ENTRY5  91, TraceEvent, 0 
SYSSTUBS_ENTRY6  91, TraceEvent, 0 
SYSSTUBS_ENTRY7  91, TraceEvent, 0 
SYSSTUBS_ENTRY8  91, TraceEvent, 0 
SYSSTUBS_ENTRY1  92, PowerInformation, 1 
SYSSTUBS_ENTRY2  92, PowerInformation, 1 
SYSSTUBS_ENTRY3  92, PowerInformation, 1 
SYSSTUBS_ENTRY4  92, PowerInformation, 1 
SYSSTUBS_ENTRY5  92, PowerInformation, 1 
SYSSTUBS_ENTRY6  92, PowerInformation, 1 
SYSSTUBS_ENTRY7  92, PowerInformation, 1 
SYSSTUBS_ENTRY8  92, PowerInformation, 1 
SYSSTUBS_ENTRY1  93, SetValueKey, 2 
SYSSTUBS_ENTRY2  93, SetValueKey, 2 
SYSSTUBS_ENTRY3  93, SetValueKey, 2 
SYSSTUBS_ENTRY4  93, SetValueKey, 2 
SYSSTUBS_ENTRY5  93, SetValueKey, 2 
SYSSTUBS_ENTRY6  93, SetValueKey, 2 
SYSSTUBS_ENTRY7  93, SetValueKey, 2 
SYSSTUBS_ENTRY8  93, SetValueKey, 2 
SYSSTUBS_ENTRY1  94, CancelTimer, 0 
SYSSTUBS_ENTRY2  94, CancelTimer, 0 
SYSSTUBS_ENTRY3  94, CancelTimer, 0 
SYSSTUBS_ENTRY4  94, CancelTimer, 0 
SYSSTUBS_ENTRY5  94, CancelTimer, 0 
SYSSTUBS_ENTRY6  94, CancelTimer, 0 
SYSSTUBS_ENTRY7  94, CancelTimer, 0 
SYSSTUBS_ENTRY8  94, CancelTimer, 0 
SYSSTUBS_ENTRY1  95, SetTimer, 3 
SYSSTUBS_ENTRY2  95, SetTimer, 3 
SYSSTUBS_ENTRY3  95, SetTimer, 3 
SYSSTUBS_ENTRY4  95, SetTimer, 3 
SYSSTUBS_ENTRY5  95, SetTimer, 3 
SYSSTUBS_ENTRY6  95, SetTimer, 3 
SYSSTUBS_ENTRY7  95, SetTimer, 3 
SYSSTUBS_ENTRY8  95, SetTimer, 3 
SYSSTUBS_ENTRY1  96, AcceptConnectPort, 2 
SYSSTUBS_ENTRY2  96, AcceptConnectPort, 2 
SYSSTUBS_ENTRY3  96, AcceptConnectPort, 2 
SYSSTUBS_ENTRY4  96, AcceptConnectPort, 2 
SYSSTUBS_ENTRY5  96, AcceptConnectPort, 2 
SYSSTUBS_ENTRY6  96, AcceptConnectPort, 2 
SYSSTUBS_ENTRY7  96, AcceptConnectPort, 2 
SYSSTUBS_ENTRY8  96, AcceptConnectPort, 2 
SYSSTUBS_ENTRY1  97, AccessCheck, 4 
SYSSTUBS_ENTRY2  97, AccessCheck, 4 
SYSSTUBS_ENTRY3  97, AccessCheck, 4 
SYSSTUBS_ENTRY4  97, AccessCheck, 4 
SYSSTUBS_ENTRY5  97, AccessCheck, 4 
SYSSTUBS_ENTRY6  97, AccessCheck, 4 
SYSSTUBS_ENTRY7  97, AccessCheck, 4 
SYSSTUBS_ENTRY8  97, AccessCheck, 4 
SYSSTUBS_ENTRY1  98, AccessCheckByType, 7 
SYSSTUBS_ENTRY2  98, AccessCheckByType, 7 
SYSSTUBS_ENTRY3  98, AccessCheckByType, 7 
SYSSTUBS_ENTRY4  98, AccessCheckByType, 7 
SYSSTUBS_ENTRY5  98, AccessCheckByType, 7 
SYSSTUBS_ENTRY6  98, AccessCheckByType, 7 
SYSSTUBS_ENTRY7  98, AccessCheckByType, 7 
SYSSTUBS_ENTRY8  98, AccessCheckByType, 7 
SYSSTUBS_ENTRY1  99, AccessCheckByTypeResultList, 7 
SYSSTUBS_ENTRY2  99, AccessCheckByTypeResultList, 7 
SYSSTUBS_ENTRY3  99, AccessCheckByTypeResultList, 7 
SYSSTUBS_ENTRY4  99, AccessCheckByTypeResultList, 7 
SYSSTUBS_ENTRY5  99, AccessCheckByTypeResultList, 7 
SYSSTUBS_ENTRY6  99, AccessCheckByTypeResultList, 7 
SYSSTUBS_ENTRY7  99, AccessCheckByTypeResultList, 7 
SYSSTUBS_ENTRY8  99, AccessCheckByTypeResultList, 7 
SYSSTUBS_ENTRY1  100, AccessCheckByTypeResultListAndAuditAlarm, 12 
SYSSTUBS_ENTRY2  100, AccessCheckByTypeResultListAndAuditAlarm, 12 
SYSSTUBS_ENTRY3  100, AccessCheckByTypeResultListAndAuditAlarm, 12 
SYSSTUBS_ENTRY4  100, AccessCheckByTypeResultListAndAuditAlarm, 12 
SYSSTUBS_ENTRY5  100, AccessCheckByTypeResultListAndAuditAlarm, 12 
SYSSTUBS_ENTRY6  100, AccessCheckByTypeResultListAndAuditAlarm, 12 
SYSSTUBS_ENTRY7  100, AccessCheckByTypeResultListAndAuditAlarm, 12 
SYSSTUBS_ENTRY8  100, AccessCheckByTypeResultListAndAuditAlarm, 12 
SYSSTUBS_ENTRY1  101, AccessCheckByTypeResultListAndAuditAlarmByHandle, 13 
SYSSTUBS_ENTRY2  101, AccessCheckByTypeResultListAndAuditAlarmByHandle, 13 
SYSSTUBS_ENTRY3  101, AccessCheckByTypeResultListAndAuditAlarmByHandle, 13 
SYSSTUBS_ENTRY4  101, AccessCheckByTypeResultListAndAuditAlarmByHandle, 13 
SYSSTUBS_ENTRY5  101, AccessCheckByTypeResultListAndAuditAlarmByHandle, 13 
SYSSTUBS_ENTRY6  101, AccessCheckByTypeResultListAndAuditAlarmByHandle, 13 
SYSSTUBS_ENTRY7  101, AccessCheckByTypeResultListAndAuditAlarmByHandle, 13 
SYSSTUBS_ENTRY8  101, AccessCheckByTypeResultListAndAuditAlarmByHandle, 13 
SYSSTUBS_ENTRY1  102, AddBootEntry, 0 
SYSSTUBS_ENTRY2  102, AddBootEntry, 0 
SYSSTUBS_ENTRY3  102, AddBootEntry, 0 
SYSSTUBS_ENTRY4  102, AddBootEntry, 0 
SYSSTUBS_ENTRY5  102, AddBootEntry, 0 
SYSSTUBS_ENTRY6  102, AddBootEntry, 0 
SYSSTUBS_ENTRY7  102, AddBootEntry, 0 
SYSSTUBS_ENTRY8  102, AddBootEntry, 0 
SYSSTUBS_ENTRY1  103, AddDriverEntry, 0 
SYSSTUBS_ENTRY2  103, AddDriverEntry, 0 
SYSSTUBS_ENTRY3  103, AddDriverEntry, 0 
SYSSTUBS_ENTRY4  103, AddDriverEntry, 0 
SYSSTUBS_ENTRY5  103, AddDriverEntry, 0 
SYSSTUBS_ENTRY6  103, AddDriverEntry, 0 
SYSSTUBS_ENTRY7  103, AddDriverEntry, 0 
SYSSTUBS_ENTRY8  103, AddDriverEntry, 0 
SYSSTUBS_ENTRY1  104, AdjustGroupsToken, 2 
SYSSTUBS_ENTRY2  104, AdjustGroupsToken, 2 
SYSSTUBS_ENTRY3  104, AdjustGroupsToken, 2 
SYSSTUBS_ENTRY4  104, AdjustGroupsToken, 2 
SYSSTUBS_ENTRY5  104, AdjustGroupsToken, 2 
SYSSTUBS_ENTRY6  104, AdjustGroupsToken, 2 
SYSSTUBS_ENTRY7  104, AdjustGroupsToken, 2 
SYSSTUBS_ENTRY8  104, AdjustGroupsToken, 2 
SYSSTUBS_ENTRY1  105, AlertResumeThread, 0 
SYSSTUBS_ENTRY2  105, AlertResumeThread, 0 
SYSSTUBS_ENTRY3  105, AlertResumeThread, 0 
SYSSTUBS_ENTRY4  105, AlertResumeThread, 0 
SYSSTUBS_ENTRY5  105, AlertResumeThread, 0 
SYSSTUBS_ENTRY6  105, AlertResumeThread, 0 
SYSSTUBS_ENTRY7  105, AlertResumeThread, 0 
SYSSTUBS_ENTRY8  105, AlertResumeThread, 0 
SYSSTUBS_ENTRY1  106, AlertThread, 0 
SYSSTUBS_ENTRY2  106, AlertThread, 0 
SYSSTUBS_ENTRY3  106, AlertThread, 0 
SYSSTUBS_ENTRY4  106, AlertThread, 0 
SYSSTUBS_ENTRY5  106, AlertThread, 0 
SYSSTUBS_ENTRY6  106, AlertThread, 0 
SYSSTUBS_ENTRY7  106, AlertThread, 0 
SYSSTUBS_ENTRY8  106, AlertThread, 0 
SYSSTUBS_ENTRY1  107, AllocateLocallyUniqueId, 0 
SYSSTUBS_ENTRY2  107, AllocateLocallyUniqueId, 0 
SYSSTUBS_ENTRY3  107, AllocateLocallyUniqueId, 0 
SYSSTUBS_ENTRY4  107, AllocateLocallyUniqueId, 0 
SYSSTUBS_ENTRY5  107, AllocateLocallyUniqueId, 0 
SYSSTUBS_ENTRY6  107, AllocateLocallyUniqueId, 0 
SYSSTUBS_ENTRY7  107, AllocateLocallyUniqueId, 0 
SYSSTUBS_ENTRY8  107, AllocateLocallyUniqueId, 0 
SYSSTUBS_ENTRY1  108, AllocateUserPhysicalPages, 0 
SYSSTUBS_ENTRY2  108, AllocateUserPhysicalPages, 0 
SYSSTUBS_ENTRY3  108, AllocateUserPhysicalPages, 0 
SYSSTUBS_ENTRY4  108, AllocateUserPhysicalPages, 0 
SYSSTUBS_ENTRY5  108, AllocateUserPhysicalPages, 0 
SYSSTUBS_ENTRY6  108, AllocateUserPhysicalPages, 0 
SYSSTUBS_ENTRY7  108, AllocateUserPhysicalPages, 0 
SYSSTUBS_ENTRY8  108, AllocateUserPhysicalPages, 0 
SYSSTUBS_ENTRY1  109, AllocateUuids, 0 
SYSSTUBS_ENTRY2  109, AllocateUuids, 0 
SYSSTUBS_ENTRY3  109, AllocateUuids, 0 
SYSSTUBS_ENTRY4  109, AllocateUuids, 0 
SYSSTUBS_ENTRY5  109, AllocateUuids, 0 
SYSSTUBS_ENTRY6  109, AllocateUuids, 0 
SYSSTUBS_ENTRY7  109, AllocateUuids, 0 
SYSSTUBS_ENTRY8  109, AllocateUuids, 0 
SYSSTUBS_ENTRY1  110, AreMappedFilesTheSame, 0 
SYSSTUBS_ENTRY2  110, AreMappedFilesTheSame, 0 
SYSSTUBS_ENTRY3  110, AreMappedFilesTheSame, 0 
SYSSTUBS_ENTRY4  110, AreMappedFilesTheSame, 0 
SYSSTUBS_ENTRY5  110, AreMappedFilesTheSame, 0 
SYSSTUBS_ENTRY6  110, AreMappedFilesTheSame, 0 
SYSSTUBS_ENTRY7  110, AreMappedFilesTheSame, 0 
SYSSTUBS_ENTRY8  110, AreMappedFilesTheSame, 0 
SYSSTUBS_ENTRY1  111, AssignProcessToJobObject, 0 
SYSSTUBS_ENTRY2  111, AssignProcessToJobObject, 0 
SYSSTUBS_ENTRY3  111, AssignProcessToJobObject, 0 
SYSSTUBS_ENTRY4  111, AssignProcessToJobObject, 0 
SYSSTUBS_ENTRY5  111, AssignProcessToJobObject, 0 
SYSSTUBS_ENTRY6  111, AssignProcessToJobObject, 0 
SYSSTUBS_ENTRY7  111, AssignProcessToJobObject, 0 
SYSSTUBS_ENTRY8  111, AssignProcessToJobObject, 0 
SYSSTUBS_ENTRY1  112, CancelDeviceWakeupRequest, 0 
SYSSTUBS_ENTRY2  112, CancelDeviceWakeupRequest, 0 
SYSSTUBS_ENTRY3  112, CancelDeviceWakeupRequest, 0 
SYSSTUBS_ENTRY4  112, CancelDeviceWakeupRequest, 0 
SYSSTUBS_ENTRY5  112, CancelDeviceWakeupRequest, 0 
SYSSTUBS_ENTRY6  112, CancelDeviceWakeupRequest, 0 
SYSSTUBS_ENTRY7  112, CancelDeviceWakeupRequest, 0 
SYSSTUBS_ENTRY8  112, CancelDeviceWakeupRequest, 0 
SYSSTUBS_ENTRY1  113, CompactKeys, 0 
SYSSTUBS_ENTRY2  113, CompactKeys, 0 
SYSSTUBS_ENTRY3  113, CompactKeys, 0 
SYSSTUBS_ENTRY4  113, CompactKeys, 0 
SYSSTUBS_ENTRY5  113, CompactKeys, 0 
SYSSTUBS_ENTRY6  113, CompactKeys, 0 
SYSSTUBS_ENTRY7  113, CompactKeys, 0 
SYSSTUBS_ENTRY8  113, CompactKeys, 0 
SYSSTUBS_ENTRY1  114, CompareTokens, 0 
SYSSTUBS_ENTRY2  114, CompareTokens, 0 
SYSSTUBS_ENTRY3  114, CompareTokens, 0 
SYSSTUBS_ENTRY4  114, CompareTokens, 0 
SYSSTUBS_ENTRY5  114, CompareTokens, 0 
SYSSTUBS_ENTRY6  114, CompareTokens, 0 
SYSSTUBS_ENTRY7  114, CompareTokens, 0 
SYSSTUBS_ENTRY8  114, CompareTokens, 0 
SYSSTUBS_ENTRY1  115, CompleteConnectPort, 0 
SYSSTUBS_ENTRY2  115, CompleteConnectPort, 0 
SYSSTUBS_ENTRY3  115, CompleteConnectPort, 0 
SYSSTUBS_ENTRY4  115, CompleteConnectPort, 0 
SYSSTUBS_ENTRY5  115, CompleteConnectPort, 0 
SYSSTUBS_ENTRY6  115, CompleteConnectPort, 0 
SYSSTUBS_ENTRY7  115, CompleteConnectPort, 0 
SYSSTUBS_ENTRY8  115, CompleteConnectPort, 0 
SYSSTUBS_ENTRY1  116, CompressKey, 0 
SYSSTUBS_ENTRY2  116, CompressKey, 0 
SYSSTUBS_ENTRY3  116, CompressKey, 0 
SYSSTUBS_ENTRY4  116, CompressKey, 0 
SYSSTUBS_ENTRY5  116, CompressKey, 0 
SYSSTUBS_ENTRY6  116, CompressKey, 0 
SYSSTUBS_ENTRY7  116, CompressKey, 0 
SYSSTUBS_ENTRY8  116, CompressKey, 0 
SYSSTUBS_ENTRY1  117, ConnectPort, 4 
SYSSTUBS_ENTRY2  117, ConnectPort, 4 
SYSSTUBS_ENTRY3  117, ConnectPort, 4 
SYSSTUBS_ENTRY4  117, ConnectPort, 4 
SYSSTUBS_ENTRY5  117, ConnectPort, 4 
SYSSTUBS_ENTRY6  117, ConnectPort, 4 
SYSSTUBS_ENTRY7  117, ConnectPort, 4 
SYSSTUBS_ENTRY8  117, ConnectPort, 4 
SYSSTUBS_ENTRY1  118, CreateDebugObject, 0 
SYSSTUBS_ENTRY2  118, CreateDebugObject, 0 
SYSSTUBS_ENTRY3  118, CreateDebugObject, 0 
SYSSTUBS_ENTRY4  118, CreateDebugObject, 0 
SYSSTUBS_ENTRY5  118, CreateDebugObject, 0 
SYSSTUBS_ENTRY6  118, CreateDebugObject, 0 
SYSSTUBS_ENTRY7  118, CreateDebugObject, 0 
SYSSTUBS_ENTRY8  118, CreateDebugObject, 0 
SYSSTUBS_ENTRY1  119, CreateDirectoryObject, 0 
SYSSTUBS_ENTRY2  119, CreateDirectoryObject, 0 
SYSSTUBS_ENTRY3  119, CreateDirectoryObject, 0 
SYSSTUBS_ENTRY4  119, CreateDirectoryObject, 0 
SYSSTUBS_ENTRY5  119, CreateDirectoryObject, 0 
SYSSTUBS_ENTRY6  119, CreateDirectoryObject, 0 
SYSSTUBS_ENTRY7  119, CreateDirectoryObject, 0 
SYSSTUBS_ENTRY8  119, CreateDirectoryObject, 0 
SYSSTUBS_ENTRY1  120, CreateEventPair, 0 
SYSSTUBS_ENTRY2  120, CreateEventPair, 0 
SYSSTUBS_ENTRY3  120, CreateEventPair, 0 
SYSSTUBS_ENTRY4  120, CreateEventPair, 0 
SYSSTUBS_ENTRY5  120, CreateEventPair, 0 
SYSSTUBS_ENTRY6  120, CreateEventPair, 0 
SYSSTUBS_ENTRY7  120, CreateEventPair, 0 
SYSSTUBS_ENTRY8  120, CreateEventPair, 0 
SYSSTUBS_ENTRY1  121, CreateIoCompletion, 0 
SYSSTUBS_ENTRY2  121, CreateIoCompletion, 0 
SYSSTUBS_ENTRY3  121, CreateIoCompletion, 0 
SYSSTUBS_ENTRY4  121, CreateIoCompletion, 0 
SYSSTUBS_ENTRY5  121, CreateIoCompletion, 0 
SYSSTUBS_ENTRY6  121, CreateIoCompletion, 0 
SYSSTUBS_ENTRY7  121, CreateIoCompletion, 0 
SYSSTUBS_ENTRY8  121, CreateIoCompletion, 0 
SYSSTUBS_ENTRY1  122, CreateJobObject, 0 
SYSSTUBS_ENTRY2  122, CreateJobObject, 0 
SYSSTUBS_ENTRY3  122, CreateJobObject, 0 
SYSSTUBS_ENTRY4  122, CreateJobObject, 0 
SYSSTUBS_ENTRY5  122, CreateJobObject, 0 
SYSSTUBS_ENTRY6  122, CreateJobObject, 0 
SYSSTUBS_ENTRY7  122, CreateJobObject, 0 
SYSSTUBS_ENTRY8  122, CreateJobObject, 0 
SYSSTUBS_ENTRY1  123, CreateJobSet, 0 
SYSSTUBS_ENTRY2  123, CreateJobSet, 0 
SYSSTUBS_ENTRY3  123, CreateJobSet, 0 
SYSSTUBS_ENTRY4  123, CreateJobSet, 0 
SYSSTUBS_ENTRY5  123, CreateJobSet, 0 
SYSSTUBS_ENTRY6  123, CreateJobSet, 0 
SYSSTUBS_ENTRY7  123, CreateJobSet, 0 
SYSSTUBS_ENTRY8  123, CreateJobSet, 0 
SYSSTUBS_ENTRY1  124, CreateKeyedEvent, 0 
SYSSTUBS_ENTRY2  124, CreateKeyedEvent, 0 
SYSSTUBS_ENTRY3  124, CreateKeyedEvent, 0 
SYSSTUBS_ENTRY4  124, CreateKeyedEvent, 0 
SYSSTUBS_ENTRY5  124, CreateKeyedEvent, 0 
SYSSTUBS_ENTRY6  124, CreateKeyedEvent, 0 
SYSSTUBS_ENTRY7  124, CreateKeyedEvent, 0 
SYSSTUBS_ENTRY8  124, CreateKeyedEvent, 0 
SYSSTUBS_ENTRY1  125, CreateMailslotFile, 4 
SYSSTUBS_ENTRY2  125, CreateMailslotFile, 4 
SYSSTUBS_ENTRY3  125, CreateMailslotFile, 4 
SYSSTUBS_ENTRY4  125, CreateMailslotFile, 4 
SYSSTUBS_ENTRY5  125, CreateMailslotFile, 4 
SYSSTUBS_ENTRY6  125, CreateMailslotFile, 4 
SYSSTUBS_ENTRY7  125, CreateMailslotFile, 4 
SYSSTUBS_ENTRY8  125, CreateMailslotFile, 4 
SYSSTUBS_ENTRY1  126, CreateMutant, 0 
SYSSTUBS_ENTRY2  126, CreateMutant, 0 
SYSSTUBS_ENTRY3  126, CreateMutant, 0 
SYSSTUBS_ENTRY4  126, CreateMutant, 0 
SYSSTUBS_ENTRY5  126, CreateMutant, 0 
SYSSTUBS_ENTRY6  126, CreateMutant, 0 
SYSSTUBS_ENTRY7  126, CreateMutant, 0 
SYSSTUBS_ENTRY8  126, CreateMutant, 0 
SYSSTUBS_ENTRY1  127, CreateNamedPipeFile, 10 
SYSSTUBS_ENTRY2  127, CreateNamedPipeFile, 10 
SYSSTUBS_ENTRY3  127, CreateNamedPipeFile, 10 
SYSSTUBS_ENTRY4  127, CreateNamedPipeFile, 10 
SYSSTUBS_ENTRY5  127, CreateNamedPipeFile, 10 
SYSSTUBS_ENTRY6  127, CreateNamedPipeFile, 10 
SYSSTUBS_ENTRY7  127, CreateNamedPipeFile, 10 
SYSSTUBS_ENTRY8  127, CreateNamedPipeFile, 10 
SYSSTUBS_ENTRY1  128, CreatePagingFile, 0 
SYSSTUBS_ENTRY2  128, CreatePagingFile, 0 
SYSSTUBS_ENTRY3  128, CreatePagingFile, 0 
SYSSTUBS_ENTRY4  128, CreatePagingFile, 0 
SYSSTUBS_ENTRY5  128, CreatePagingFile, 0 
SYSSTUBS_ENTRY6  128, CreatePagingFile, 0 
SYSSTUBS_ENTRY7  128, CreatePagingFile, 0 
SYSSTUBS_ENTRY8  128, CreatePagingFile, 0 
SYSSTUBS_ENTRY1  129, CreatePort, 1 
SYSSTUBS_ENTRY2  129, CreatePort, 1 
SYSSTUBS_ENTRY3  129, CreatePort, 1 
SYSSTUBS_ENTRY4  129, CreatePort, 1 
SYSSTUBS_ENTRY5  129, CreatePort, 1 
SYSSTUBS_ENTRY6  129, CreatePort, 1 
SYSSTUBS_ENTRY7  129, CreatePort, 1 
SYSSTUBS_ENTRY8  129, CreatePort, 1 
SYSSTUBS_ENTRY1  130, CreateProcess, 4 
SYSSTUBS_ENTRY2  130, CreateProcess, 4 
SYSSTUBS_ENTRY3  130, CreateProcess, 4 
SYSSTUBS_ENTRY4  130, CreateProcess, 4 
SYSSTUBS_ENTRY5  130, CreateProcess, 4 
SYSSTUBS_ENTRY6  130, CreateProcess, 4 
SYSSTUBS_ENTRY7  130, CreateProcess, 4 
SYSSTUBS_ENTRY8  130, CreateProcess, 4 
SYSSTUBS_ENTRY1  131, CreateProfile, 5 
SYSSTUBS_ENTRY2  131, CreateProfile, 5 
SYSSTUBS_ENTRY3  131, CreateProfile, 5 
SYSSTUBS_ENTRY4  131, CreateProfile, 5 
SYSSTUBS_ENTRY5  131, CreateProfile, 5 
SYSSTUBS_ENTRY6  131, CreateProfile, 5 
SYSSTUBS_ENTRY7  131, CreateProfile, 5 
SYSSTUBS_ENTRY8  131, CreateProfile, 5 
SYSSTUBS_ENTRY1  132, CreateSemaphore, 1 
SYSSTUBS_ENTRY2  132, CreateSemaphore, 1 
SYSSTUBS_ENTRY3  132, CreateSemaphore, 1 
SYSSTUBS_ENTRY4  132, CreateSemaphore, 1 
SYSSTUBS_ENTRY5  132, CreateSemaphore, 1 
SYSSTUBS_ENTRY6  132, CreateSemaphore, 1 
SYSSTUBS_ENTRY7  132, CreateSemaphore, 1 
SYSSTUBS_ENTRY8  132, CreateSemaphore, 1 
SYSSTUBS_ENTRY1  133, CreateSymbolicLinkObject, 0 
SYSSTUBS_ENTRY2  133, CreateSymbolicLinkObject, 0 
SYSSTUBS_ENTRY3  133, CreateSymbolicLinkObject, 0 
SYSSTUBS_ENTRY4  133, CreateSymbolicLinkObject, 0 
SYSSTUBS_ENTRY5  133, CreateSymbolicLinkObject, 0 
SYSSTUBS_ENTRY6  133, CreateSymbolicLinkObject, 0 
SYSSTUBS_ENTRY7  133, CreateSymbolicLinkObject, 0 
SYSSTUBS_ENTRY8  133, CreateSymbolicLinkObject, 0 
SYSSTUBS_ENTRY1  134, CreateTimer, 0 
SYSSTUBS_ENTRY2  134, CreateTimer, 0 
SYSSTUBS_ENTRY3  134, CreateTimer, 0 
SYSSTUBS_ENTRY4  134, CreateTimer, 0 
SYSSTUBS_ENTRY5  134, CreateTimer, 0 
SYSSTUBS_ENTRY6  134, CreateTimer, 0 
SYSSTUBS_ENTRY7  134, CreateTimer, 0 
SYSSTUBS_ENTRY8  134, CreateTimer, 0 
SYSSTUBS_ENTRY1  135, CreateToken, 9 
SYSSTUBS_ENTRY2  135, CreateToken, 9 
SYSSTUBS_ENTRY3  135, CreateToken, 9 
SYSSTUBS_ENTRY4  135, CreateToken, 9 
SYSSTUBS_ENTRY5  135, CreateToken, 9 
SYSSTUBS_ENTRY6  135, CreateToken, 9 
SYSSTUBS_ENTRY7  135, CreateToken, 9 
SYSSTUBS_ENTRY8  135, CreateToken, 9 
SYSSTUBS_ENTRY1  136, CreateWaitablePort, 1 
SYSSTUBS_ENTRY2  136, CreateWaitablePort, 1 
SYSSTUBS_ENTRY3  136, CreateWaitablePort, 1 
SYSSTUBS_ENTRY4  136, CreateWaitablePort, 1 
SYSSTUBS_ENTRY5  136, CreateWaitablePort, 1 
SYSSTUBS_ENTRY6  136, CreateWaitablePort, 1 
SYSSTUBS_ENTRY7  136, CreateWaitablePort, 1 
SYSSTUBS_ENTRY8  136, CreateWaitablePort, 1 
SYSSTUBS_ENTRY1  137, DebugActiveProcess, 0 
SYSSTUBS_ENTRY2  137, DebugActiveProcess, 0 
SYSSTUBS_ENTRY3  137, DebugActiveProcess, 0 
SYSSTUBS_ENTRY4  137, DebugActiveProcess, 0 
SYSSTUBS_ENTRY5  137, DebugActiveProcess, 0 
SYSSTUBS_ENTRY6  137, DebugActiveProcess, 0 
SYSSTUBS_ENTRY7  137, DebugActiveProcess, 0 
SYSSTUBS_ENTRY8  137, DebugActiveProcess, 0 
SYSSTUBS_ENTRY1  138, DebugContinue, 0 
SYSSTUBS_ENTRY2  138, DebugContinue, 0 
SYSSTUBS_ENTRY3  138, DebugContinue, 0 
SYSSTUBS_ENTRY4  138, DebugContinue, 0 
SYSSTUBS_ENTRY5  138, DebugContinue, 0 
SYSSTUBS_ENTRY6  138, DebugContinue, 0 
SYSSTUBS_ENTRY7  138, DebugContinue, 0 
SYSSTUBS_ENTRY8  138, DebugContinue, 0 
SYSSTUBS_ENTRY1  139, DeleteAtom, 0 
SYSSTUBS_ENTRY2  139, DeleteAtom, 0 
SYSSTUBS_ENTRY3  139, DeleteAtom, 0 
SYSSTUBS_ENTRY4  139, DeleteAtom, 0 
SYSSTUBS_ENTRY5  139, DeleteAtom, 0 
SYSSTUBS_ENTRY6  139, DeleteAtom, 0 
SYSSTUBS_ENTRY7  139, DeleteAtom, 0 
SYSSTUBS_ENTRY8  139, DeleteAtom, 0 
SYSSTUBS_ENTRY1  140, DeleteBootEntry, 0 
SYSSTUBS_ENTRY2  140, DeleteBootEntry, 0 
SYSSTUBS_ENTRY3  140, DeleteBootEntry, 0 
SYSSTUBS_ENTRY4  140, DeleteBootEntry, 0 
SYSSTUBS_ENTRY5  140, DeleteBootEntry, 0 
SYSSTUBS_ENTRY6  140, DeleteBootEntry, 0 
SYSSTUBS_ENTRY7  140, DeleteBootEntry, 0 
SYSSTUBS_ENTRY8  140, DeleteBootEntry, 0 
SYSSTUBS_ENTRY1  141, DeleteDriverEntry, 0 
SYSSTUBS_ENTRY2  141, DeleteDriverEntry, 0 
SYSSTUBS_ENTRY3  141, DeleteDriverEntry, 0 
SYSSTUBS_ENTRY4  141, DeleteDriverEntry, 0 
SYSSTUBS_ENTRY5  141, DeleteDriverEntry, 0 
SYSSTUBS_ENTRY6  141, DeleteDriverEntry, 0 
SYSSTUBS_ENTRY7  141, DeleteDriverEntry, 0 
SYSSTUBS_ENTRY8  141, DeleteDriverEntry, 0 
SYSSTUBS_ENTRY1  142, DeleteFile, 0 
SYSSTUBS_ENTRY2  142, DeleteFile, 0 
SYSSTUBS_ENTRY3  142, DeleteFile, 0 
SYSSTUBS_ENTRY4  142, DeleteFile, 0 
SYSSTUBS_ENTRY5  142, DeleteFile, 0 
SYSSTUBS_ENTRY6  142, DeleteFile, 0 
SYSSTUBS_ENTRY7  142, DeleteFile, 0 
SYSSTUBS_ENTRY8  142, DeleteFile, 0 
SYSSTUBS_ENTRY1  143, DeleteKey, 0 
SYSSTUBS_ENTRY2  143, DeleteKey, 0 
SYSSTUBS_ENTRY3  143, DeleteKey, 0 
SYSSTUBS_ENTRY4  143, DeleteKey, 0 
SYSSTUBS_ENTRY5  143, DeleteKey, 0 
SYSSTUBS_ENTRY6  143, DeleteKey, 0 
SYSSTUBS_ENTRY7  143, DeleteKey, 0 
SYSSTUBS_ENTRY8  143, DeleteKey, 0 
SYSSTUBS_ENTRY1  144, DeleteObjectAuditAlarm, 0 
SYSSTUBS_ENTRY2  144, DeleteObjectAuditAlarm, 0 
SYSSTUBS_ENTRY3  144, DeleteObjectAuditAlarm, 0 
SYSSTUBS_ENTRY4  144, DeleteObjectAuditAlarm, 0 
SYSSTUBS_ENTRY5  144, DeleteObjectAuditAlarm, 0 
SYSSTUBS_ENTRY6  144, DeleteObjectAuditAlarm, 0 
SYSSTUBS_ENTRY7  144, DeleteObjectAuditAlarm, 0 
SYSSTUBS_ENTRY8  144, DeleteObjectAuditAlarm, 0 
SYSSTUBS_ENTRY1  145, DeleteValueKey, 0 
SYSSTUBS_ENTRY2  145, DeleteValueKey, 0 
SYSSTUBS_ENTRY3  145, DeleteValueKey, 0 
SYSSTUBS_ENTRY4  145, DeleteValueKey, 0 
SYSSTUBS_ENTRY5  145, DeleteValueKey, 0 
SYSSTUBS_ENTRY6  145, DeleteValueKey, 0 
SYSSTUBS_ENTRY7  145, DeleteValueKey, 0 
SYSSTUBS_ENTRY8  145, DeleteValueKey, 0 
SYSSTUBS_ENTRY1  146, DisplayString, 0 
SYSSTUBS_ENTRY2  146, DisplayString, 0 
SYSSTUBS_ENTRY3  146, DisplayString, 0 
SYSSTUBS_ENTRY4  146, DisplayString, 0 
SYSSTUBS_ENTRY5  146, DisplayString, 0 
SYSSTUBS_ENTRY6  146, DisplayString, 0 
SYSSTUBS_ENTRY7  146, DisplayString, 0 
SYSSTUBS_ENTRY8  146, DisplayString, 0 
SYSSTUBS_ENTRY1  147, EnumerateBootEntries, 0 
SYSSTUBS_ENTRY2  147, EnumerateBootEntries, 0 
SYSSTUBS_ENTRY3  147, EnumerateBootEntries, 0 
SYSSTUBS_ENTRY4  147, EnumerateBootEntries, 0 
SYSSTUBS_ENTRY5  147, EnumerateBootEntries, 0 
SYSSTUBS_ENTRY6  147, EnumerateBootEntries, 0 
SYSSTUBS_ENTRY7  147, EnumerateBootEntries, 0 
SYSSTUBS_ENTRY8  147, EnumerateBootEntries, 0 
SYSSTUBS_ENTRY1  148, EnumerateDriverEntries, 0 
SYSSTUBS_ENTRY2  148, EnumerateDriverEntries, 0 
SYSSTUBS_ENTRY3  148, EnumerateDriverEntries, 0 
SYSSTUBS_ENTRY4  148, EnumerateDriverEntries, 0 
SYSSTUBS_ENTRY5  148, EnumerateDriverEntries, 0 
SYSSTUBS_ENTRY6  148, EnumerateDriverEntries, 0 
SYSSTUBS_ENTRY7  148, EnumerateDriverEntries, 0 
SYSSTUBS_ENTRY8  148, EnumerateDriverEntries, 0 
SYSSTUBS_ENTRY1  149, EnumerateSystemEnvironmentValuesEx, 0 
SYSSTUBS_ENTRY2  149, EnumerateSystemEnvironmentValuesEx, 0 
SYSSTUBS_ENTRY3  149, EnumerateSystemEnvironmentValuesEx, 0 
SYSSTUBS_ENTRY4  149, EnumerateSystemEnvironmentValuesEx, 0 
SYSSTUBS_ENTRY5  149, EnumerateSystemEnvironmentValuesEx, 0 
SYSSTUBS_ENTRY6  149, EnumerateSystemEnvironmentValuesEx, 0 
SYSSTUBS_ENTRY7  149, EnumerateSystemEnvironmentValuesEx, 0 
SYSSTUBS_ENTRY8  149, EnumerateSystemEnvironmentValuesEx, 0 
SYSSTUBS_ENTRY1  150, ExtendSection, 0 
SYSSTUBS_ENTRY2  150, ExtendSection, 0 
SYSSTUBS_ENTRY3  150, ExtendSection, 0 
SYSSTUBS_ENTRY4  150, ExtendSection, 0 
SYSSTUBS_ENTRY5  150, ExtendSection, 0 
SYSSTUBS_ENTRY6  150, ExtendSection, 0 
SYSSTUBS_ENTRY7  150, ExtendSection, 0 
SYSSTUBS_ENTRY8  150, ExtendSection, 0 
SYSSTUBS_ENTRY1  151, FilterToken, 2 
SYSSTUBS_ENTRY2  151, FilterToken, 2 
SYSSTUBS_ENTRY3  151, FilterToken, 2 
SYSSTUBS_ENTRY4  151, FilterToken, 2 
SYSSTUBS_ENTRY5  151, FilterToken, 2 
SYSSTUBS_ENTRY6  151, FilterToken, 2 
SYSSTUBS_ENTRY7  151, FilterToken, 2 
SYSSTUBS_ENTRY8  151, FilterToken, 2 
SYSSTUBS_ENTRY1  152, FlushInstructionCache, 0 
SYSSTUBS_ENTRY2  152, FlushInstructionCache, 0 
SYSSTUBS_ENTRY3  152, FlushInstructionCache, 0 
SYSSTUBS_ENTRY4  152, FlushInstructionCache, 0 
SYSSTUBS_ENTRY5  152, FlushInstructionCache, 0 
SYSSTUBS_ENTRY6  152, FlushInstructionCache, 0 
SYSSTUBS_ENTRY7  152, FlushInstructionCache, 0 
SYSSTUBS_ENTRY8  152, FlushInstructionCache, 0 
SYSSTUBS_ENTRY1  153, FlushKey, 0 
SYSSTUBS_ENTRY2  153, FlushKey, 0 
SYSSTUBS_ENTRY3  153, FlushKey, 0 
SYSSTUBS_ENTRY4  153, FlushKey, 0 
SYSSTUBS_ENTRY5  153, FlushKey, 0 
SYSSTUBS_ENTRY6  153, FlushKey, 0 
SYSSTUBS_ENTRY7  153, FlushKey, 0 
SYSSTUBS_ENTRY8  153, FlushKey, 0 
SYSSTUBS_ENTRY1  154, FlushVirtualMemory, 0 
SYSSTUBS_ENTRY2  154, FlushVirtualMemory, 0 
SYSSTUBS_ENTRY3  154, FlushVirtualMemory, 0 
SYSSTUBS_ENTRY4  154, FlushVirtualMemory, 0 
SYSSTUBS_ENTRY5  154, FlushVirtualMemory, 0 
SYSSTUBS_ENTRY6  154, FlushVirtualMemory, 0 
SYSSTUBS_ENTRY7  154, FlushVirtualMemory, 0 
SYSSTUBS_ENTRY8  154, FlushVirtualMemory, 0 
SYSSTUBS_ENTRY1  155, FlushWriteBuffer, 0 
SYSSTUBS_ENTRY2  155, FlushWriteBuffer, 0 
SYSSTUBS_ENTRY3  155, FlushWriteBuffer, 0 
SYSSTUBS_ENTRY4  155, FlushWriteBuffer, 0 
SYSSTUBS_ENTRY5  155, FlushWriteBuffer, 0 
SYSSTUBS_ENTRY6  155, FlushWriteBuffer, 0 
SYSSTUBS_ENTRY7  155, FlushWriteBuffer, 0 
SYSSTUBS_ENTRY8  155, FlushWriteBuffer, 0 
SYSSTUBS_ENTRY1  156, FreeUserPhysicalPages, 0 
SYSSTUBS_ENTRY2  156, FreeUserPhysicalPages, 0 
SYSSTUBS_ENTRY3  156, FreeUserPhysicalPages, 0 
SYSSTUBS_ENTRY4  156, FreeUserPhysicalPages, 0 
SYSSTUBS_ENTRY5  156, FreeUserPhysicalPages, 0 
SYSSTUBS_ENTRY6  156, FreeUserPhysicalPages, 0 
SYSSTUBS_ENTRY7  156, FreeUserPhysicalPages, 0 
SYSSTUBS_ENTRY8  156, FreeUserPhysicalPages, 0 
SYSSTUBS_ENTRY1  157, GetContextThread, 0 
SYSSTUBS_ENTRY2  157, GetContextThread, 0 
SYSSTUBS_ENTRY3  157, GetContextThread, 0 
SYSSTUBS_ENTRY4  157, GetContextThread, 0 
SYSSTUBS_ENTRY5  157, GetContextThread, 0 
SYSSTUBS_ENTRY6  157, GetContextThread, 0 
SYSSTUBS_ENTRY7  157, GetContextThread, 0 
SYSSTUBS_ENTRY8  157, GetContextThread, 0 
SYSSTUBS_ENTRY1  158, GetCurrentProcessorNumber, 0 
SYSSTUBS_ENTRY2  158, GetCurrentProcessorNumber, 0 
SYSSTUBS_ENTRY3  158, GetCurrentProcessorNumber, 0 
SYSSTUBS_ENTRY4  158, GetCurrentProcessorNumber, 0 
SYSSTUBS_ENTRY5  158, GetCurrentProcessorNumber, 0 
SYSSTUBS_ENTRY6  158, GetCurrentProcessorNumber, 0 
SYSSTUBS_ENTRY7  158, GetCurrentProcessorNumber, 0 
SYSSTUBS_ENTRY8  158, GetCurrentProcessorNumber, 0 
SYSSTUBS_ENTRY1  159, GetDevicePowerState, 0 
SYSSTUBS_ENTRY2  159, GetDevicePowerState, 0 
SYSSTUBS_ENTRY3  159, GetDevicePowerState, 0 
SYSSTUBS_ENTRY4  159, GetDevicePowerState, 0 
SYSSTUBS_ENTRY5  159, GetDevicePowerState, 0 
SYSSTUBS_ENTRY6  159, GetDevicePowerState, 0 
SYSSTUBS_ENTRY7  159, GetDevicePowerState, 0 
SYSSTUBS_ENTRY8  159, GetDevicePowerState, 0 
SYSSTUBS_ENTRY1  160, GetPlugPlayEvent, 0 
SYSSTUBS_ENTRY2  160, GetPlugPlayEvent, 0 
SYSSTUBS_ENTRY3  160, GetPlugPlayEvent, 0 
SYSSTUBS_ENTRY4  160, GetPlugPlayEvent, 0 
SYSSTUBS_ENTRY5  160, GetPlugPlayEvent, 0 
SYSSTUBS_ENTRY6  160, GetPlugPlayEvent, 0 
SYSSTUBS_ENTRY7  160, GetPlugPlayEvent, 0 
SYSSTUBS_ENTRY8  160, GetPlugPlayEvent, 0 
SYSSTUBS_ENTRY1  161, GetWriteWatch, 3 
SYSSTUBS_ENTRY2  161, GetWriteWatch, 3 
SYSSTUBS_ENTRY3  161, GetWriteWatch, 3 
SYSSTUBS_ENTRY4  161, GetWriteWatch, 3 
SYSSTUBS_ENTRY5  161, GetWriteWatch, 3 
SYSSTUBS_ENTRY6  161, GetWriteWatch, 3 
SYSSTUBS_ENTRY7  161, GetWriteWatch, 3 
SYSSTUBS_ENTRY8  161, GetWriteWatch, 3 
SYSSTUBS_ENTRY1  162, ImpersonateAnonymousToken, 0 
SYSSTUBS_ENTRY2  162, ImpersonateAnonymousToken, 0 
SYSSTUBS_ENTRY3  162, ImpersonateAnonymousToken, 0 
SYSSTUBS_ENTRY4  162, ImpersonateAnonymousToken, 0 
SYSSTUBS_ENTRY5  162, ImpersonateAnonymousToken, 0 
SYSSTUBS_ENTRY6  162, ImpersonateAnonymousToken, 0 
SYSSTUBS_ENTRY7  162, ImpersonateAnonymousToken, 0 
SYSSTUBS_ENTRY8  162, ImpersonateAnonymousToken, 0 
SYSSTUBS_ENTRY1  163, ImpersonateThread, 0 
SYSSTUBS_ENTRY2  163, ImpersonateThread, 0 
SYSSTUBS_ENTRY3  163, ImpersonateThread, 0 
SYSSTUBS_ENTRY4  163, ImpersonateThread, 0 
SYSSTUBS_ENTRY5  163, ImpersonateThread, 0 
SYSSTUBS_ENTRY6  163, ImpersonateThread, 0 
SYSSTUBS_ENTRY7  163, ImpersonateThread, 0 
SYSSTUBS_ENTRY8  163, ImpersonateThread, 0 
SYSSTUBS_ENTRY1  164, InitializeRegistry, 0 
SYSSTUBS_ENTRY2  164, InitializeRegistry, 0 
SYSSTUBS_ENTRY3  164, InitializeRegistry, 0 
SYSSTUBS_ENTRY4  164, InitializeRegistry, 0 
SYSSTUBS_ENTRY5  164, InitializeRegistry, 0 
SYSSTUBS_ENTRY6  164, InitializeRegistry, 0 
SYSSTUBS_ENTRY7  164, InitializeRegistry, 0 
SYSSTUBS_ENTRY8  164, InitializeRegistry, 0 
SYSSTUBS_ENTRY1  165, InitiatePowerAction, 0 
SYSSTUBS_ENTRY2  165, InitiatePowerAction, 0 
SYSSTUBS_ENTRY3  165, InitiatePowerAction, 0 
SYSSTUBS_ENTRY4  165, InitiatePowerAction, 0 
SYSSTUBS_ENTRY5  165, InitiatePowerAction, 0 
SYSSTUBS_ENTRY6  165, InitiatePowerAction, 0 
SYSSTUBS_ENTRY7  165, InitiatePowerAction, 0 
SYSSTUBS_ENTRY8  165, InitiatePowerAction, 0 
SYSSTUBS_ENTRY1  166, IsSystemResumeAutomatic, 0 
SYSSTUBS_ENTRY2  166, IsSystemResumeAutomatic, 0 
SYSSTUBS_ENTRY3  166, IsSystemResumeAutomatic, 0 
SYSSTUBS_ENTRY4  166, IsSystemResumeAutomatic, 0 
SYSSTUBS_ENTRY5  166, IsSystemResumeAutomatic, 0 
SYSSTUBS_ENTRY6  166, IsSystemResumeAutomatic, 0 
SYSSTUBS_ENTRY7  166, IsSystemResumeAutomatic, 0 
SYSSTUBS_ENTRY8  166, IsSystemResumeAutomatic, 0 
SYSSTUBS_ENTRY1  167, ListenPort, 0 
SYSSTUBS_ENTRY2  167, ListenPort, 0 
SYSSTUBS_ENTRY3  167, ListenPort, 0 
SYSSTUBS_ENTRY4  167, ListenPort, 0 
SYSSTUBS_ENTRY5  167, ListenPort, 0 
SYSSTUBS_ENTRY6  167, ListenPort, 0 
SYSSTUBS_ENTRY7  167, ListenPort, 0 
SYSSTUBS_ENTRY8  167, ListenPort, 0 
SYSSTUBS_ENTRY1  168, LoadDriver, 0 
SYSSTUBS_ENTRY2  168, LoadDriver, 0 
SYSSTUBS_ENTRY3  168, LoadDriver, 0 
SYSSTUBS_ENTRY4  168, LoadDriver, 0 
SYSSTUBS_ENTRY5  168, LoadDriver, 0 
SYSSTUBS_ENTRY6  168, LoadDriver, 0 
SYSSTUBS_ENTRY7  168, LoadDriver, 0 
SYSSTUBS_ENTRY8  168, LoadDriver, 0 
SYSSTUBS_ENTRY1  169, LoadKey, 0 
SYSSTUBS_ENTRY2  169, LoadKey, 0 
SYSSTUBS_ENTRY3  169, LoadKey, 0 
SYSSTUBS_ENTRY4  169, LoadKey, 0 
SYSSTUBS_ENTRY5  169, LoadKey, 0 
SYSSTUBS_ENTRY6  169, LoadKey, 0 
SYSSTUBS_ENTRY7  169, LoadKey, 0 
SYSSTUBS_ENTRY8  169, LoadKey, 0 
SYSSTUBS_ENTRY1  170, LoadKey2, 0 
SYSSTUBS_ENTRY2  170, LoadKey2, 0 
SYSSTUBS_ENTRY3  170, LoadKey2, 0 
SYSSTUBS_ENTRY4  170, LoadKey2, 0 
SYSSTUBS_ENTRY5  170, LoadKey2, 0 
SYSSTUBS_ENTRY6  170, LoadKey2, 0 
SYSSTUBS_ENTRY7  170, LoadKey2, 0 
SYSSTUBS_ENTRY8  170, LoadKey2, 0 
SYSSTUBS_ENTRY1  171, LoadKeyEx, 0 
SYSSTUBS_ENTRY2  171, LoadKeyEx, 0 
SYSSTUBS_ENTRY3  171, LoadKeyEx, 0 
SYSSTUBS_ENTRY4  171, LoadKeyEx, 0 
SYSSTUBS_ENTRY5  171, LoadKeyEx, 0 
SYSSTUBS_ENTRY6  171, LoadKeyEx, 0 
SYSSTUBS_ENTRY7  171, LoadKeyEx, 0 
SYSSTUBS_ENTRY8  171, LoadKeyEx, 0 
SYSSTUBS_ENTRY1  172, LockFile, 6 
SYSSTUBS_ENTRY2  172, LockFile, 6 
SYSSTUBS_ENTRY3  172, LockFile, 6 
SYSSTUBS_ENTRY4  172, LockFile, 6 
SYSSTUBS_ENTRY5  172, LockFile, 6 
SYSSTUBS_ENTRY6  172, LockFile, 6 
SYSSTUBS_ENTRY7  172, LockFile, 6 
SYSSTUBS_ENTRY8  172, LockFile, 6 
SYSSTUBS_ENTRY1  173, LockProductActivationKeys, 0 
SYSSTUBS_ENTRY2  173, LockProductActivationKeys, 0 
SYSSTUBS_ENTRY3  173, LockProductActivationKeys, 0 
SYSSTUBS_ENTRY4  173, LockProductActivationKeys, 0 
SYSSTUBS_ENTRY5  173, LockProductActivationKeys, 0 
SYSSTUBS_ENTRY6  173, LockProductActivationKeys, 0 
SYSSTUBS_ENTRY7  173, LockProductActivationKeys, 0 
SYSSTUBS_ENTRY8  173, LockProductActivationKeys, 0 
SYSSTUBS_ENTRY1  174, LockRegistryKey, 0 
SYSSTUBS_ENTRY2  174, LockRegistryKey, 0 
SYSSTUBS_ENTRY3  174, LockRegistryKey, 0 
SYSSTUBS_ENTRY4  174, LockRegistryKey, 0 
SYSSTUBS_ENTRY5  174, LockRegistryKey, 0 
SYSSTUBS_ENTRY6  174, LockRegistryKey, 0 
SYSSTUBS_ENTRY7  174, LockRegistryKey, 0 
SYSSTUBS_ENTRY8  174, LockRegistryKey, 0 
SYSSTUBS_ENTRY1  175, LockVirtualMemory, 0 
SYSSTUBS_ENTRY2  175, LockVirtualMemory, 0 
SYSSTUBS_ENTRY3  175, LockVirtualMemory, 0 
SYSSTUBS_ENTRY4  175, LockVirtualMemory, 0 
SYSSTUBS_ENTRY5  175, LockVirtualMemory, 0 
SYSSTUBS_ENTRY6  175, LockVirtualMemory, 0 
SYSSTUBS_ENTRY7  175, LockVirtualMemory, 0 
SYSSTUBS_ENTRY8  175, LockVirtualMemory, 0 
SYSSTUBS_ENTRY1  176, MakePermanentObject, 0 
SYSSTUBS_ENTRY2  176, MakePermanentObject, 0 
SYSSTUBS_ENTRY3  176, MakePermanentObject, 0 
SYSSTUBS_ENTRY4  176, MakePermanentObject, 0 
SYSSTUBS_ENTRY5  176, MakePermanentObject, 0 
SYSSTUBS_ENTRY6  176, MakePermanentObject, 0 
SYSSTUBS_ENTRY7  176, MakePermanentObject, 0 
SYSSTUBS_ENTRY8  176, MakePermanentObject, 0 
SYSSTUBS_ENTRY1  177, MakeTemporaryObject, 0 
SYSSTUBS_ENTRY2  177, MakeTemporaryObject, 0 
SYSSTUBS_ENTRY3  177, MakeTemporaryObject, 0 
SYSSTUBS_ENTRY4  177, MakeTemporaryObject, 0 
SYSSTUBS_ENTRY5  177, MakeTemporaryObject, 0 
SYSSTUBS_ENTRY6  177, MakeTemporaryObject, 0 
SYSSTUBS_ENTRY7  177, MakeTemporaryObject, 0 
SYSSTUBS_ENTRY8  177, MakeTemporaryObject, 0 
SYSSTUBS_ENTRY1  178, MapUserPhysicalPages, 0 
SYSSTUBS_ENTRY2  178, MapUserPhysicalPages, 0 
SYSSTUBS_ENTRY3  178, MapUserPhysicalPages, 0 
SYSSTUBS_ENTRY4  178, MapUserPhysicalPages, 0 
SYSSTUBS_ENTRY5  178, MapUserPhysicalPages, 0 
SYSSTUBS_ENTRY6  178, MapUserPhysicalPages, 0 
SYSSTUBS_ENTRY7  178, MapUserPhysicalPages, 0 
SYSSTUBS_ENTRY8  178, MapUserPhysicalPages, 0 
SYSSTUBS_ENTRY1  179, ModifyBootEntry, 0 
SYSSTUBS_ENTRY2  179, ModifyBootEntry, 0 
SYSSTUBS_ENTRY3  179, ModifyBootEntry, 0 
SYSSTUBS_ENTRY4  179, ModifyBootEntry, 0 
SYSSTUBS_ENTRY5  179, ModifyBootEntry, 0 
SYSSTUBS_ENTRY6  179, ModifyBootEntry, 0 
SYSSTUBS_ENTRY7  179, ModifyBootEntry, 0 
SYSSTUBS_ENTRY8  179, ModifyBootEntry, 0 
SYSSTUBS_ENTRY1  180, ModifyDriverEntry, 0 
SYSSTUBS_ENTRY2  180, ModifyDriverEntry, 0 
SYSSTUBS_ENTRY3  180, ModifyDriverEntry, 0 
SYSSTUBS_ENTRY4  180, ModifyDriverEntry, 0 
SYSSTUBS_ENTRY5  180, ModifyDriverEntry, 0 
SYSSTUBS_ENTRY6  180, ModifyDriverEntry, 0 
SYSSTUBS_ENTRY7  180, ModifyDriverEntry, 0 
SYSSTUBS_ENTRY8  180, ModifyDriverEntry, 0 
SYSSTUBS_ENTRY1  181, NotifyChangeDirectoryFile, 5 
SYSSTUBS_ENTRY2  181, NotifyChangeDirectoryFile, 5 
SYSSTUBS_ENTRY3  181, NotifyChangeDirectoryFile, 5 
SYSSTUBS_ENTRY4  181, NotifyChangeDirectoryFile, 5 
SYSSTUBS_ENTRY5  181, NotifyChangeDirectoryFile, 5 
SYSSTUBS_ENTRY6  181, NotifyChangeDirectoryFile, 5 
SYSSTUBS_ENTRY7  181, NotifyChangeDirectoryFile, 5 
SYSSTUBS_ENTRY8  181, NotifyChangeDirectoryFile, 5 
SYSSTUBS_ENTRY1  182, NotifyChangeKey, 6 
SYSSTUBS_ENTRY2  182, NotifyChangeKey, 6 
SYSSTUBS_ENTRY3  182, NotifyChangeKey, 6 
SYSSTUBS_ENTRY4  182, NotifyChangeKey, 6 
SYSSTUBS_ENTRY5  182, NotifyChangeKey, 6 
SYSSTUBS_ENTRY6  182, NotifyChangeKey, 6 
SYSSTUBS_ENTRY7  182, NotifyChangeKey, 6 
SYSSTUBS_ENTRY8  182, NotifyChangeKey, 6 
SYSSTUBS_ENTRY1  183, NotifyChangeMultipleKeys, 8 
SYSSTUBS_ENTRY2  183, NotifyChangeMultipleKeys, 8 
SYSSTUBS_ENTRY3  183, NotifyChangeMultipleKeys, 8 
SYSSTUBS_ENTRY4  183, NotifyChangeMultipleKeys, 8 
SYSSTUBS_ENTRY5  183, NotifyChangeMultipleKeys, 8 
SYSSTUBS_ENTRY6  183, NotifyChangeMultipleKeys, 8 
SYSSTUBS_ENTRY7  183, NotifyChangeMultipleKeys, 8 
SYSSTUBS_ENTRY8  183, NotifyChangeMultipleKeys, 8 
SYSSTUBS_ENTRY1  184, OpenEventPair, 0 
SYSSTUBS_ENTRY2  184, OpenEventPair, 0 
SYSSTUBS_ENTRY3  184, OpenEventPair, 0 
SYSSTUBS_ENTRY4  184, OpenEventPair, 0 
SYSSTUBS_ENTRY5  184, OpenEventPair, 0 
SYSSTUBS_ENTRY6  184, OpenEventPair, 0 
SYSSTUBS_ENTRY7  184, OpenEventPair, 0 
SYSSTUBS_ENTRY8  184, OpenEventPair, 0 
SYSSTUBS_ENTRY1  185, OpenIoCompletion, 0 
SYSSTUBS_ENTRY2  185, OpenIoCompletion, 0 
SYSSTUBS_ENTRY3  185, OpenIoCompletion, 0 
SYSSTUBS_ENTRY4  185, OpenIoCompletion, 0 
SYSSTUBS_ENTRY5  185, OpenIoCompletion, 0 
SYSSTUBS_ENTRY6  185, OpenIoCompletion, 0 
SYSSTUBS_ENTRY7  185, OpenIoCompletion, 0 
SYSSTUBS_ENTRY8  185, OpenIoCompletion, 0 
SYSSTUBS_ENTRY1  186, OpenJobObject, 0 
SYSSTUBS_ENTRY2  186, OpenJobObject, 0 
SYSSTUBS_ENTRY3  186, OpenJobObject, 0 
SYSSTUBS_ENTRY4  186, OpenJobObject, 0 
SYSSTUBS_ENTRY5  186, OpenJobObject, 0 
SYSSTUBS_ENTRY6  186, OpenJobObject, 0 
SYSSTUBS_ENTRY7  186, OpenJobObject, 0 
SYSSTUBS_ENTRY8  186, OpenJobObject, 0 
SYSSTUBS_ENTRY1  187, OpenKeyedEvent, 0 
SYSSTUBS_ENTRY2  187, OpenKeyedEvent, 0 
SYSSTUBS_ENTRY3  187, OpenKeyedEvent, 0 
SYSSTUBS_ENTRY4  187, OpenKeyedEvent, 0 
SYSSTUBS_ENTRY5  187, OpenKeyedEvent, 0 
SYSSTUBS_ENTRY6  187, OpenKeyedEvent, 0 
SYSSTUBS_ENTRY7  187, OpenKeyedEvent, 0 
SYSSTUBS_ENTRY8  187, OpenKeyedEvent, 0 
SYSSTUBS_ENTRY1  188, OpenMutant, 0 
SYSSTUBS_ENTRY2  188, OpenMutant, 0 
SYSSTUBS_ENTRY3  188, OpenMutant, 0 
SYSSTUBS_ENTRY4  188, OpenMutant, 0 
SYSSTUBS_ENTRY5  188, OpenMutant, 0 
SYSSTUBS_ENTRY6  188, OpenMutant, 0 
SYSSTUBS_ENTRY7  188, OpenMutant, 0 
SYSSTUBS_ENTRY8  188, OpenMutant, 0 
SYSSTUBS_ENTRY1  189, OpenObjectAuditAlarm, 8 
SYSSTUBS_ENTRY2  189, OpenObjectAuditAlarm, 8 
SYSSTUBS_ENTRY3  189, OpenObjectAuditAlarm, 8 
SYSSTUBS_ENTRY4  189, OpenObjectAuditAlarm, 8 
SYSSTUBS_ENTRY5  189, OpenObjectAuditAlarm, 8 
SYSSTUBS_ENTRY6  189, OpenObjectAuditAlarm, 8 
SYSSTUBS_ENTRY7  189, OpenObjectAuditAlarm, 8 
SYSSTUBS_ENTRY8  189, OpenObjectAuditAlarm, 8 
SYSSTUBS_ENTRY1  190, OpenProcessToken, 0 
SYSSTUBS_ENTRY2  190, OpenProcessToken, 0 
SYSSTUBS_ENTRY3  190, OpenProcessToken, 0 
SYSSTUBS_ENTRY4  190, OpenProcessToken, 0 
SYSSTUBS_ENTRY5  190, OpenProcessToken, 0 
SYSSTUBS_ENTRY6  190, OpenProcessToken, 0 
SYSSTUBS_ENTRY7  190, OpenProcessToken, 0 
SYSSTUBS_ENTRY8  190, OpenProcessToken, 0 
SYSSTUBS_ENTRY1  191, OpenSemaphore, 0 
SYSSTUBS_ENTRY2  191, OpenSemaphore, 0 
SYSSTUBS_ENTRY3  191, OpenSemaphore, 0 
SYSSTUBS_ENTRY4  191, OpenSemaphore, 0 
SYSSTUBS_ENTRY5  191, OpenSemaphore, 0 
SYSSTUBS_ENTRY6  191, OpenSemaphore, 0 
SYSSTUBS_ENTRY7  191, OpenSemaphore, 0 
SYSSTUBS_ENTRY8  191, OpenSemaphore, 0 
SYSSTUBS_ENTRY1  192, OpenSymbolicLinkObject, 0 
SYSSTUBS_ENTRY2  192, OpenSymbolicLinkObject, 0 
SYSSTUBS_ENTRY3  192, OpenSymbolicLinkObject, 0 
SYSSTUBS_ENTRY4  192, OpenSymbolicLinkObject, 0 
SYSSTUBS_ENTRY5  192, OpenSymbolicLinkObject, 0 
SYSSTUBS_ENTRY6  192, OpenSymbolicLinkObject, 0 
SYSSTUBS_ENTRY7  192, OpenSymbolicLinkObject, 0 
SYSSTUBS_ENTRY8  192, OpenSymbolicLinkObject, 0 
SYSSTUBS_ENTRY1  193, OpenThread, 0 
SYSSTUBS_ENTRY2  193, OpenThread, 0 
SYSSTUBS_ENTRY3  193, OpenThread, 0 
SYSSTUBS_ENTRY4  193, OpenThread, 0 
SYSSTUBS_ENTRY5  193, OpenThread, 0 
SYSSTUBS_ENTRY6  193, OpenThread, 0 
SYSSTUBS_ENTRY7  193, OpenThread, 0 
SYSSTUBS_ENTRY8  193, OpenThread, 0 
SYSSTUBS_ENTRY1  194, OpenTimer, 0 
SYSSTUBS_ENTRY2  194, OpenTimer, 0 
SYSSTUBS_ENTRY3  194, OpenTimer, 0 
SYSSTUBS_ENTRY4  194, OpenTimer, 0 
SYSSTUBS_ENTRY5  194, OpenTimer, 0 
SYSSTUBS_ENTRY6  194, OpenTimer, 0 
SYSSTUBS_ENTRY7  194, OpenTimer, 0 
SYSSTUBS_ENTRY8  194, OpenTimer, 0 
SYSSTUBS_ENTRY1  195, PlugPlayControl, 0 
SYSSTUBS_ENTRY2  195, PlugPlayControl, 0 
SYSSTUBS_ENTRY3  195, PlugPlayControl, 0 
SYSSTUBS_ENTRY4  195, PlugPlayControl, 0 
SYSSTUBS_ENTRY5  195, PlugPlayControl, 0 
SYSSTUBS_ENTRY6  195, PlugPlayControl, 0 
SYSSTUBS_ENTRY7  195, PlugPlayControl, 0 
SYSSTUBS_ENTRY8  195, PlugPlayControl, 0 
SYSSTUBS_ENTRY1  196, PrivilegeCheck, 0 
SYSSTUBS_ENTRY2  196, PrivilegeCheck, 0 
SYSSTUBS_ENTRY3  196, PrivilegeCheck, 0 
SYSSTUBS_ENTRY4  196, PrivilegeCheck, 0 
SYSSTUBS_ENTRY5  196, PrivilegeCheck, 0 
SYSSTUBS_ENTRY6  196, PrivilegeCheck, 0 
SYSSTUBS_ENTRY7  196, PrivilegeCheck, 0 
SYSSTUBS_ENTRY8  196, PrivilegeCheck, 0 
SYSSTUBS_ENTRY1  197, PrivilegeObjectAuditAlarm, 2 
SYSSTUBS_ENTRY2  197, PrivilegeObjectAuditAlarm, 2 
SYSSTUBS_ENTRY3  197, PrivilegeObjectAuditAlarm, 2 
SYSSTUBS_ENTRY4  197, PrivilegeObjectAuditAlarm, 2 
SYSSTUBS_ENTRY5  197, PrivilegeObjectAuditAlarm, 2 
SYSSTUBS_ENTRY6  197, PrivilegeObjectAuditAlarm, 2 
SYSSTUBS_ENTRY7  197, PrivilegeObjectAuditAlarm, 2 
SYSSTUBS_ENTRY8  197, PrivilegeObjectAuditAlarm, 2 
SYSSTUBS_ENTRY1  198, PrivilegedServiceAuditAlarm, 1 
SYSSTUBS_ENTRY2  198, PrivilegedServiceAuditAlarm, 1 
SYSSTUBS_ENTRY3  198, PrivilegedServiceAuditAlarm, 1 
SYSSTUBS_ENTRY4  198, PrivilegedServiceAuditAlarm, 1 
SYSSTUBS_ENTRY5  198, PrivilegedServiceAuditAlarm, 1 
SYSSTUBS_ENTRY6  198, PrivilegedServiceAuditAlarm, 1 
SYSSTUBS_ENTRY7  198, PrivilegedServiceAuditAlarm, 1 
SYSSTUBS_ENTRY8  198, PrivilegedServiceAuditAlarm, 1 
SYSSTUBS_ENTRY1  199, PulseEvent, 0 
SYSSTUBS_ENTRY2  199, PulseEvent, 0 
SYSSTUBS_ENTRY3  199, PulseEvent, 0 
SYSSTUBS_ENTRY4  199, PulseEvent, 0 
SYSSTUBS_ENTRY5  199, PulseEvent, 0 
SYSSTUBS_ENTRY6  199, PulseEvent, 0 
SYSSTUBS_ENTRY7  199, PulseEvent, 0 
SYSSTUBS_ENTRY8  199, PulseEvent, 0 
SYSSTUBS_ENTRY1  200, QueryBootEntryOrder, 0 
SYSSTUBS_ENTRY2  200, QueryBootEntryOrder, 0 
SYSSTUBS_ENTRY3  200, QueryBootEntryOrder, 0 
SYSSTUBS_ENTRY4  200, QueryBootEntryOrder, 0 
SYSSTUBS_ENTRY5  200, QueryBootEntryOrder, 0 
SYSSTUBS_ENTRY6  200, QueryBootEntryOrder, 0 
SYSSTUBS_ENTRY7  200, QueryBootEntryOrder, 0 
SYSSTUBS_ENTRY8  200, QueryBootEntryOrder, 0 
SYSSTUBS_ENTRY1  201, QueryBootOptions, 0 
SYSSTUBS_ENTRY2  201, QueryBootOptions, 0 
SYSSTUBS_ENTRY3  201, QueryBootOptions, 0 
SYSSTUBS_ENTRY4  201, QueryBootOptions, 0 
SYSSTUBS_ENTRY5  201, QueryBootOptions, 0 
SYSSTUBS_ENTRY6  201, QueryBootOptions, 0 
SYSSTUBS_ENTRY7  201, QueryBootOptions, 0 
SYSSTUBS_ENTRY8  201, QueryBootOptions, 0 
SYSSTUBS_ENTRY1  202, QueryDebugFilterState, 0 
SYSSTUBS_ENTRY2  202, QueryDebugFilterState, 0 
SYSSTUBS_ENTRY3  202, QueryDebugFilterState, 0 
SYSSTUBS_ENTRY4  202, QueryDebugFilterState, 0 
SYSSTUBS_ENTRY5  202, QueryDebugFilterState, 0 
SYSSTUBS_ENTRY6  202, QueryDebugFilterState, 0 
SYSSTUBS_ENTRY7  202, QueryDebugFilterState, 0 
SYSSTUBS_ENTRY8  202, QueryDebugFilterState, 0 
SYSSTUBS_ENTRY1  203, QueryDirectoryObject, 3 
SYSSTUBS_ENTRY2  203, QueryDirectoryObject, 3 
SYSSTUBS_ENTRY3  203, QueryDirectoryObject, 3 
SYSSTUBS_ENTRY4  203, QueryDirectoryObject, 3 
SYSSTUBS_ENTRY5  203, QueryDirectoryObject, 3 
SYSSTUBS_ENTRY6  203, QueryDirectoryObject, 3 
SYSSTUBS_ENTRY7  203, QueryDirectoryObject, 3 
SYSSTUBS_ENTRY8  203, QueryDirectoryObject, 3 
SYSSTUBS_ENTRY1  204, QueryDriverEntryOrder, 0 
SYSSTUBS_ENTRY2  204, QueryDriverEntryOrder, 0 
SYSSTUBS_ENTRY3  204, QueryDriverEntryOrder, 0 
SYSSTUBS_ENTRY4  204, QueryDriverEntryOrder, 0 
SYSSTUBS_ENTRY5  204, QueryDriverEntryOrder, 0 
SYSSTUBS_ENTRY6  204, QueryDriverEntryOrder, 0 
SYSSTUBS_ENTRY7  204, QueryDriverEntryOrder, 0 
SYSSTUBS_ENTRY8  204, QueryDriverEntryOrder, 0 
SYSSTUBS_ENTRY1  205, QueryEaFile, 5 
SYSSTUBS_ENTRY2  205, QueryEaFile, 5 
SYSSTUBS_ENTRY3  205, QueryEaFile, 5 
SYSSTUBS_ENTRY4  205, QueryEaFile, 5 
SYSSTUBS_ENTRY5  205, QueryEaFile, 5 
SYSSTUBS_ENTRY6  205, QueryEaFile, 5 
SYSSTUBS_ENTRY7  205, QueryEaFile, 5 
SYSSTUBS_ENTRY8  205, QueryEaFile, 5 
SYSSTUBS_ENTRY1  206, QueryFullAttributesFile, 0 
SYSSTUBS_ENTRY2  206, QueryFullAttributesFile, 0 
SYSSTUBS_ENTRY3  206, QueryFullAttributesFile, 0 
SYSSTUBS_ENTRY4  206, QueryFullAttributesFile, 0 
SYSSTUBS_ENTRY5  206, QueryFullAttributesFile, 0 
SYSSTUBS_ENTRY6  206, QueryFullAttributesFile, 0 
SYSSTUBS_ENTRY7  206, QueryFullAttributesFile, 0 
SYSSTUBS_ENTRY8  206, QueryFullAttributesFile, 0 
SYSSTUBS_ENTRY1  207, QueryInformationAtom, 1 
SYSSTUBS_ENTRY2  207, QueryInformationAtom, 1 
SYSSTUBS_ENTRY3  207, QueryInformationAtom, 1 
SYSSTUBS_ENTRY4  207, QueryInformationAtom, 1 
SYSSTUBS_ENTRY5  207, QueryInformationAtom, 1 
SYSSTUBS_ENTRY6  207, QueryInformationAtom, 1 
SYSSTUBS_ENTRY7  207, QueryInformationAtom, 1 
SYSSTUBS_ENTRY8  207, QueryInformationAtom, 1 
SYSSTUBS_ENTRY1  208, QueryInformationJobObject, 1 
SYSSTUBS_ENTRY2  208, QueryInformationJobObject, 1 
SYSSTUBS_ENTRY3  208, QueryInformationJobObject, 1 
SYSSTUBS_ENTRY4  208, QueryInformationJobObject, 1 
SYSSTUBS_ENTRY5  208, QueryInformationJobObject, 1 
SYSSTUBS_ENTRY6  208, QueryInformationJobObject, 1 
SYSSTUBS_ENTRY7  208, QueryInformationJobObject, 1 
SYSSTUBS_ENTRY8  208, QueryInformationJobObject, 1 
SYSSTUBS_ENTRY1  209, QueryInformationPort, 1 
SYSSTUBS_ENTRY2  209, QueryInformationPort, 1 
SYSSTUBS_ENTRY3  209, QueryInformationPort, 1 
SYSSTUBS_ENTRY4  209, QueryInformationPort, 1 
SYSSTUBS_ENTRY5  209, QueryInformationPort, 1 
SYSSTUBS_ENTRY6  209, QueryInformationPort, 1 
SYSSTUBS_ENTRY7  209, QueryInformationPort, 1 
SYSSTUBS_ENTRY8  209, QueryInformationPort, 1 
SYSSTUBS_ENTRY1  210, QueryInstallUILanguage, 0 
SYSSTUBS_ENTRY2  210, QueryInstallUILanguage, 0 
SYSSTUBS_ENTRY3  210, QueryInstallUILanguage, 0 
SYSSTUBS_ENTRY4  210, QueryInstallUILanguage, 0 
SYSSTUBS_ENTRY5  210, QueryInstallUILanguage, 0 
SYSSTUBS_ENTRY6  210, QueryInstallUILanguage, 0 
SYSSTUBS_ENTRY7  210, QueryInstallUILanguage, 0 
SYSSTUBS_ENTRY8  210, QueryInstallUILanguage, 0 
SYSSTUBS_ENTRY1  211, QueryIntervalProfile, 0 
SYSSTUBS_ENTRY2  211, QueryIntervalProfile, 0 
SYSSTUBS_ENTRY3  211, QueryIntervalProfile, 0 
SYSSTUBS_ENTRY4  211, QueryIntervalProfile, 0 
SYSSTUBS_ENTRY5  211, QueryIntervalProfile, 0 
SYSSTUBS_ENTRY6  211, QueryIntervalProfile, 0 
SYSSTUBS_ENTRY7  211, QueryIntervalProfile, 0 
SYSSTUBS_ENTRY8  211, QueryIntervalProfile, 0 
SYSSTUBS_ENTRY1  212, QueryIoCompletion, 1 
SYSSTUBS_ENTRY2  212, QueryIoCompletion, 1 
SYSSTUBS_ENTRY3  212, QueryIoCompletion, 1 
SYSSTUBS_ENTRY4  212, QueryIoCompletion, 1 
SYSSTUBS_ENTRY5  212, QueryIoCompletion, 1 
SYSSTUBS_ENTRY6  212, QueryIoCompletion, 1 
SYSSTUBS_ENTRY7  212, QueryIoCompletion, 1 
SYSSTUBS_ENTRY8  212, QueryIoCompletion, 1 
SYSSTUBS_ENTRY1  213, QueryMultipleValueKey, 2 
SYSSTUBS_ENTRY2  213, QueryMultipleValueKey, 2 
SYSSTUBS_ENTRY3  213, QueryMultipleValueKey, 2 
SYSSTUBS_ENTRY4  213, QueryMultipleValueKey, 2 
SYSSTUBS_ENTRY5  213, QueryMultipleValueKey, 2 
SYSSTUBS_ENTRY6  213, QueryMultipleValueKey, 2 
SYSSTUBS_ENTRY7  213, QueryMultipleValueKey, 2 
SYSSTUBS_ENTRY8  213, QueryMultipleValueKey, 2 
SYSSTUBS_ENTRY1  214, QueryMutant, 1 
SYSSTUBS_ENTRY2  214, QueryMutant, 1 
SYSSTUBS_ENTRY3  214, QueryMutant, 1 
SYSSTUBS_ENTRY4  214, QueryMutant, 1 
SYSSTUBS_ENTRY5  214, QueryMutant, 1 
SYSSTUBS_ENTRY6  214, QueryMutant, 1 
SYSSTUBS_ENTRY7  214, QueryMutant, 1 
SYSSTUBS_ENTRY8  214, QueryMutant, 1 
SYSSTUBS_ENTRY1  215, QueryOpenSubKeys, 0 
SYSSTUBS_ENTRY2  215, QueryOpenSubKeys, 0 
SYSSTUBS_ENTRY3  215, QueryOpenSubKeys, 0 
SYSSTUBS_ENTRY4  215, QueryOpenSubKeys, 0 
SYSSTUBS_ENTRY5  215, QueryOpenSubKeys, 0 
SYSSTUBS_ENTRY6  215, QueryOpenSubKeys, 0 
SYSSTUBS_ENTRY7  215, QueryOpenSubKeys, 0 
SYSSTUBS_ENTRY8  215, QueryOpenSubKeys, 0 
SYSSTUBS_ENTRY1  216, QueryOpenSubKeysEx, 0 
SYSSTUBS_ENTRY2  216, QueryOpenSubKeysEx, 0 
SYSSTUBS_ENTRY3  216, QueryOpenSubKeysEx, 0 
SYSSTUBS_ENTRY4  216, QueryOpenSubKeysEx, 0 
SYSSTUBS_ENTRY5  216, QueryOpenSubKeysEx, 0 
SYSSTUBS_ENTRY6  216, QueryOpenSubKeysEx, 0 
SYSSTUBS_ENTRY7  216, QueryOpenSubKeysEx, 0 
SYSSTUBS_ENTRY8  216, QueryOpenSubKeysEx, 0 
SYSSTUBS_ENTRY1  217, QueryPortInformationProcess, 0 
SYSSTUBS_ENTRY2  217, QueryPortInformationProcess, 0 
SYSSTUBS_ENTRY3  217, QueryPortInformationProcess, 0 
SYSSTUBS_ENTRY4  217, QueryPortInformationProcess, 0 
SYSSTUBS_ENTRY5  217, QueryPortInformationProcess, 0 
SYSSTUBS_ENTRY6  217, QueryPortInformationProcess, 0 
SYSSTUBS_ENTRY7  217, QueryPortInformationProcess, 0 
SYSSTUBS_ENTRY8  217, QueryPortInformationProcess, 0 
SYSSTUBS_ENTRY1  218, QueryQuotaInformationFile, 5 
SYSSTUBS_ENTRY2  218, QueryQuotaInformationFile, 5 
SYSSTUBS_ENTRY3  218, QueryQuotaInformationFile, 5 
SYSSTUBS_ENTRY4  218, QueryQuotaInformationFile, 5 
SYSSTUBS_ENTRY5  218, QueryQuotaInformationFile, 5 
SYSSTUBS_ENTRY6  218, QueryQuotaInformationFile, 5 
SYSSTUBS_ENTRY7  218, QueryQuotaInformationFile, 5 
SYSSTUBS_ENTRY8  218, QueryQuotaInformationFile, 5 
SYSSTUBS_ENTRY1  219, QuerySecurityObject, 1 
SYSSTUBS_ENTRY2  219, QuerySecurityObject, 1 
SYSSTUBS_ENTRY3  219, QuerySecurityObject, 1 
SYSSTUBS_ENTRY4  219, QuerySecurityObject, 1 
SYSSTUBS_ENTRY5  219, QuerySecurityObject, 1 
SYSSTUBS_ENTRY6  219, QuerySecurityObject, 1 
SYSSTUBS_ENTRY7  219, QuerySecurityObject, 1 
SYSSTUBS_ENTRY8  219, QuerySecurityObject, 1 
SYSSTUBS_ENTRY1  220, QuerySemaphore, 1 
SYSSTUBS_ENTRY2  220, QuerySemaphore, 1 
SYSSTUBS_ENTRY3  220, QuerySemaphore, 1 
SYSSTUBS_ENTRY4  220, QuerySemaphore, 1 
SYSSTUBS_ENTRY5  220, QuerySemaphore, 1 
SYSSTUBS_ENTRY6  220, QuerySemaphore, 1 
SYSSTUBS_ENTRY7  220, QuerySemaphore, 1 
SYSSTUBS_ENTRY8  220, QuerySemaphore, 1 
SYSSTUBS_ENTRY1  221, QuerySymbolicLinkObject, 0 
SYSSTUBS_ENTRY2  221, QuerySymbolicLinkObject, 0 
SYSSTUBS_ENTRY3  221, QuerySymbolicLinkObject, 0 
SYSSTUBS_ENTRY4  221, QuerySymbolicLinkObject, 0 
SYSSTUBS_ENTRY5  221, QuerySymbolicLinkObject, 0 
SYSSTUBS_ENTRY6  221, QuerySymbolicLinkObject, 0 
SYSSTUBS_ENTRY7  221, QuerySymbolicLinkObject, 0 
SYSSTUBS_ENTRY8  221, QuerySymbolicLinkObject, 0 
SYSSTUBS_ENTRY1  222, QuerySystemEnvironmentValue, 0 
SYSSTUBS_ENTRY2  222, QuerySystemEnvironmentValue, 0 
SYSSTUBS_ENTRY3  222, QuerySystemEnvironmentValue, 0 
SYSSTUBS_ENTRY4  222, QuerySystemEnvironmentValue, 0 
SYSSTUBS_ENTRY5  222, QuerySystemEnvironmentValue, 0 
SYSSTUBS_ENTRY6  222, QuerySystemEnvironmentValue, 0 
SYSSTUBS_ENTRY7  222, QuerySystemEnvironmentValue, 0 
SYSSTUBS_ENTRY8  222, QuerySystemEnvironmentValue, 0 
SYSSTUBS_ENTRY1  223, QuerySystemEnvironmentValueEx, 1 
SYSSTUBS_ENTRY2  223, QuerySystemEnvironmentValueEx, 1 
SYSSTUBS_ENTRY3  223, QuerySystemEnvironmentValueEx, 1 
SYSSTUBS_ENTRY4  223, QuerySystemEnvironmentValueEx, 1 
SYSSTUBS_ENTRY5  223, QuerySystemEnvironmentValueEx, 1 
SYSSTUBS_ENTRY6  223, QuerySystemEnvironmentValueEx, 1 
SYSSTUBS_ENTRY7  223, QuerySystemEnvironmentValueEx, 1 
SYSSTUBS_ENTRY8  223, QuerySystemEnvironmentValueEx, 1 
SYSSTUBS_ENTRY1  224, QueryTimerResolution, 0 
SYSSTUBS_ENTRY2  224, QueryTimerResolution, 0 
SYSSTUBS_ENTRY3  224, QueryTimerResolution, 0 
SYSSTUBS_ENTRY4  224, QueryTimerResolution, 0 
SYSSTUBS_ENTRY5  224, QueryTimerResolution, 0 
SYSSTUBS_ENTRY6  224, QueryTimerResolution, 0 
SYSSTUBS_ENTRY7  224, QueryTimerResolution, 0 
SYSSTUBS_ENTRY8  224, QueryTimerResolution, 0 
SYSSTUBS_ENTRY1  225, RaiseException, 0 
SYSSTUBS_ENTRY2  225, RaiseException, 0 
SYSSTUBS_ENTRY3  225, RaiseException, 0 
SYSSTUBS_ENTRY4  225, RaiseException, 0 
SYSSTUBS_ENTRY5  225, RaiseException, 0 
SYSSTUBS_ENTRY6  225, RaiseException, 0 
SYSSTUBS_ENTRY7  225, RaiseException, 0 
SYSSTUBS_ENTRY8  225, RaiseException, 0 
SYSSTUBS_ENTRY1  226, RaiseHardError, 2 
SYSSTUBS_ENTRY2  226, RaiseHardError, 2 
SYSSTUBS_ENTRY3  226, RaiseHardError, 2 
SYSSTUBS_ENTRY4  226, RaiseHardError, 2 
SYSSTUBS_ENTRY5  226, RaiseHardError, 2 
SYSSTUBS_ENTRY6  226, RaiseHardError, 2 
SYSSTUBS_ENTRY7  226, RaiseHardError, 2 
SYSSTUBS_ENTRY8  226, RaiseHardError, 2 
SYSSTUBS_ENTRY1  227, RegisterThreadTerminatePort, 0 
SYSSTUBS_ENTRY2  227, RegisterThreadTerminatePort, 0 
SYSSTUBS_ENTRY3  227, RegisterThreadTerminatePort, 0 
SYSSTUBS_ENTRY4  227, RegisterThreadTerminatePort, 0 
SYSSTUBS_ENTRY5  227, RegisterThreadTerminatePort, 0 
SYSSTUBS_ENTRY6  227, RegisterThreadTerminatePort, 0 
SYSSTUBS_ENTRY7  227, RegisterThreadTerminatePort, 0 
SYSSTUBS_ENTRY8  227, RegisterThreadTerminatePort, 0 
SYSSTUBS_ENTRY1  228, ReleaseKeyedEvent, 0 
SYSSTUBS_ENTRY2  228, ReleaseKeyedEvent, 0 
SYSSTUBS_ENTRY3  228, ReleaseKeyedEvent, 0 
SYSSTUBS_ENTRY4  228, ReleaseKeyedEvent, 0 
SYSSTUBS_ENTRY5  228, ReleaseKeyedEvent, 0 
SYSSTUBS_ENTRY6  228, ReleaseKeyedEvent, 0 
SYSSTUBS_ENTRY7  228, ReleaseKeyedEvent, 0 
SYSSTUBS_ENTRY8  228, ReleaseKeyedEvent, 0 
SYSSTUBS_ENTRY1  229, RemoveProcessDebug, 0 
SYSSTUBS_ENTRY2  229, RemoveProcessDebug, 0 
SYSSTUBS_ENTRY3  229, RemoveProcessDebug, 0 
SYSSTUBS_ENTRY4  229, RemoveProcessDebug, 0 
SYSSTUBS_ENTRY5  229, RemoveProcessDebug, 0 
SYSSTUBS_ENTRY6  229, RemoveProcessDebug, 0 
SYSSTUBS_ENTRY7  229, RemoveProcessDebug, 0 
SYSSTUBS_ENTRY8  229, RemoveProcessDebug, 0 
SYSSTUBS_ENTRY1  230, RenameKey, 0 
SYSSTUBS_ENTRY2  230, RenameKey, 0 
SYSSTUBS_ENTRY3  230, RenameKey, 0 
SYSSTUBS_ENTRY4  230, RenameKey, 0 
SYSSTUBS_ENTRY5  230, RenameKey, 0 
SYSSTUBS_ENTRY6  230, RenameKey, 0 
SYSSTUBS_ENTRY7  230, RenameKey, 0 
SYSSTUBS_ENTRY8  230, RenameKey, 0 
SYSSTUBS_ENTRY1  231, ReplaceKey, 0 
SYSSTUBS_ENTRY2  231, ReplaceKey, 0 
SYSSTUBS_ENTRY3  231, ReplaceKey, 0 
SYSSTUBS_ENTRY4  231, ReplaceKey, 0 
SYSSTUBS_ENTRY5  231, ReplaceKey, 0 
SYSSTUBS_ENTRY6  231, ReplaceKey, 0 
SYSSTUBS_ENTRY7  231, ReplaceKey, 0 
SYSSTUBS_ENTRY8  231, ReplaceKey, 0 
SYSSTUBS_ENTRY1  232, ReplyWaitReplyPort, 0 
SYSSTUBS_ENTRY2  232, ReplyWaitReplyPort, 0 
SYSSTUBS_ENTRY3  232, ReplyWaitReplyPort, 0 
SYSSTUBS_ENTRY4  232, ReplyWaitReplyPort, 0 
SYSSTUBS_ENTRY5  232, ReplyWaitReplyPort, 0 
SYSSTUBS_ENTRY6  232, ReplyWaitReplyPort, 0 
SYSSTUBS_ENTRY7  232, ReplyWaitReplyPort, 0 
SYSSTUBS_ENTRY8  232, ReplyWaitReplyPort, 0 
SYSSTUBS_ENTRY1  233, RequestDeviceWakeup, 0 
SYSSTUBS_ENTRY2  233, RequestDeviceWakeup, 0 
SYSSTUBS_ENTRY3  233, RequestDeviceWakeup, 0 
SYSSTUBS_ENTRY4  233, RequestDeviceWakeup, 0 
SYSSTUBS_ENTRY5  233, RequestDeviceWakeup, 0 
SYSSTUBS_ENTRY6  233, RequestDeviceWakeup, 0 
SYSSTUBS_ENTRY7  233, RequestDeviceWakeup, 0 
SYSSTUBS_ENTRY8  233, RequestDeviceWakeup, 0 
SYSSTUBS_ENTRY1  234, RequestPort, 0 
SYSSTUBS_ENTRY2  234, RequestPort, 0 
SYSSTUBS_ENTRY3  234, RequestPort, 0 
SYSSTUBS_ENTRY4  234, RequestPort, 0 
SYSSTUBS_ENTRY5  234, RequestPort, 0 
SYSSTUBS_ENTRY6  234, RequestPort, 0 
SYSSTUBS_ENTRY7  234, RequestPort, 0 
SYSSTUBS_ENTRY8  234, RequestPort, 0 
SYSSTUBS_ENTRY1  235, RequestWakeupLatency, 0 
SYSSTUBS_ENTRY2  235, RequestWakeupLatency, 0 
SYSSTUBS_ENTRY3  235, RequestWakeupLatency, 0 
SYSSTUBS_ENTRY4  235, RequestWakeupLatency, 0 
SYSSTUBS_ENTRY5  235, RequestWakeupLatency, 0 
SYSSTUBS_ENTRY6  235, RequestWakeupLatency, 0 
SYSSTUBS_ENTRY7  235, RequestWakeupLatency, 0 
SYSSTUBS_ENTRY8  235, RequestWakeupLatency, 0 
SYSSTUBS_ENTRY1  236, ResetEvent, 0 
SYSSTUBS_ENTRY2  236, ResetEvent, 0 
SYSSTUBS_ENTRY3  236, ResetEvent, 0 
SYSSTUBS_ENTRY4  236, ResetEvent, 0 
SYSSTUBS_ENTRY5  236, ResetEvent, 0 
SYSSTUBS_ENTRY6  236, ResetEvent, 0 
SYSSTUBS_ENTRY7  236, ResetEvent, 0 
SYSSTUBS_ENTRY8  236, ResetEvent, 0 
SYSSTUBS_ENTRY1  237, ResetWriteWatch, 0 
SYSSTUBS_ENTRY2  237, ResetWriteWatch, 0 
SYSSTUBS_ENTRY3  237, ResetWriteWatch, 0 
SYSSTUBS_ENTRY4  237, ResetWriteWatch, 0 
SYSSTUBS_ENTRY5  237, ResetWriteWatch, 0 
SYSSTUBS_ENTRY6  237, ResetWriteWatch, 0 
SYSSTUBS_ENTRY7  237, ResetWriteWatch, 0 
SYSSTUBS_ENTRY8  237, ResetWriteWatch, 0 
SYSSTUBS_ENTRY1  238, RestoreKey, 0 
SYSSTUBS_ENTRY2  238, RestoreKey, 0 
SYSSTUBS_ENTRY3  238, RestoreKey, 0 
SYSSTUBS_ENTRY4  238, RestoreKey, 0 
SYSSTUBS_ENTRY5  238, RestoreKey, 0 
SYSSTUBS_ENTRY6  238, RestoreKey, 0 
SYSSTUBS_ENTRY7  238, RestoreKey, 0 
SYSSTUBS_ENTRY8  238, RestoreKey, 0 
SYSSTUBS_ENTRY1  239, ResumeProcess, 0 
SYSSTUBS_ENTRY2  239, ResumeProcess, 0 
SYSSTUBS_ENTRY3  239, ResumeProcess, 0 
SYSSTUBS_ENTRY4  239, ResumeProcess, 0 
SYSSTUBS_ENTRY5  239, ResumeProcess, 0 
SYSSTUBS_ENTRY6  239, ResumeProcess, 0 
SYSSTUBS_ENTRY7  239, ResumeProcess, 0 
SYSSTUBS_ENTRY8  239, ResumeProcess, 0 
SYSSTUBS_ENTRY1  240, SaveKey, 0 
SYSSTUBS_ENTRY2  240, SaveKey, 0 
SYSSTUBS_ENTRY3  240, SaveKey, 0 
SYSSTUBS_ENTRY4  240, SaveKey, 0 
SYSSTUBS_ENTRY5  240, SaveKey, 0 
SYSSTUBS_ENTRY6  240, SaveKey, 0 
SYSSTUBS_ENTRY7  240, SaveKey, 0 
SYSSTUBS_ENTRY8  240, SaveKey, 0 
SYSSTUBS_ENTRY1  241, SaveKeyEx, 0 
SYSSTUBS_ENTRY2  241, SaveKeyEx, 0 
SYSSTUBS_ENTRY3  241, SaveKeyEx, 0 
SYSSTUBS_ENTRY4  241, SaveKeyEx, 0 
SYSSTUBS_ENTRY5  241, SaveKeyEx, 0 
SYSSTUBS_ENTRY6  241, SaveKeyEx, 0 
SYSSTUBS_ENTRY7  241, SaveKeyEx, 0 
SYSSTUBS_ENTRY8  241, SaveKeyEx, 0 
SYSSTUBS_ENTRY1  242, SaveMergedKeys, 0 
SYSSTUBS_ENTRY2  242, SaveMergedKeys, 0 
SYSSTUBS_ENTRY3  242, SaveMergedKeys, 0 
SYSSTUBS_ENTRY4  242, SaveMergedKeys, 0 
SYSSTUBS_ENTRY5  242, SaveMergedKeys, 0 
SYSSTUBS_ENTRY6  242, SaveMergedKeys, 0 
SYSSTUBS_ENTRY7  242, SaveMergedKeys, 0 
SYSSTUBS_ENTRY8  242, SaveMergedKeys, 0 
SYSSTUBS_ENTRY1  243, SecureConnectPort, 5 
SYSSTUBS_ENTRY2  243, SecureConnectPort, 5 
SYSSTUBS_ENTRY3  243, SecureConnectPort, 5 
SYSSTUBS_ENTRY4  243, SecureConnectPort, 5 
SYSSTUBS_ENTRY5  243, SecureConnectPort, 5 
SYSSTUBS_ENTRY6  243, SecureConnectPort, 5 
SYSSTUBS_ENTRY7  243, SecureConnectPort, 5 
SYSSTUBS_ENTRY8  243, SecureConnectPort, 5 
SYSSTUBS_ENTRY1  244, SetBootEntryOrder, 0 
SYSSTUBS_ENTRY2  244, SetBootEntryOrder, 0 
SYSSTUBS_ENTRY3  244, SetBootEntryOrder, 0 
SYSSTUBS_ENTRY4  244, SetBootEntryOrder, 0 
SYSSTUBS_ENTRY5  244, SetBootEntryOrder, 0 
SYSSTUBS_ENTRY6  244, SetBootEntryOrder, 0 
SYSSTUBS_ENTRY7  244, SetBootEntryOrder, 0 
SYSSTUBS_ENTRY8  244, SetBootEntryOrder, 0 
SYSSTUBS_ENTRY1  245, SetBootOptions, 0 
SYSSTUBS_ENTRY2  245, SetBootOptions, 0 
SYSSTUBS_ENTRY3  245, SetBootOptions, 0 
SYSSTUBS_ENTRY4  245, SetBootOptions, 0 
SYSSTUBS_ENTRY5  245, SetBootOptions, 0 
SYSSTUBS_ENTRY6  245, SetBootOptions, 0 
SYSSTUBS_ENTRY7  245, SetBootOptions, 0 
SYSSTUBS_ENTRY8  245, SetBootOptions, 0 
SYSSTUBS_ENTRY1  246, SetContextThread, 0 
SYSSTUBS_ENTRY2  246, SetContextThread, 0 
SYSSTUBS_ENTRY3  246, SetContextThread, 0 
SYSSTUBS_ENTRY4  246, SetContextThread, 0 
SYSSTUBS_ENTRY5  246, SetContextThread, 0 
SYSSTUBS_ENTRY6  246, SetContextThread, 0 
SYSSTUBS_ENTRY7  246, SetContextThread, 0 
SYSSTUBS_ENTRY8  246, SetContextThread, 0 
SYSSTUBS_ENTRY1  247, SetDebugFilterState, 0 
SYSSTUBS_ENTRY2  247, SetDebugFilterState, 0 
SYSSTUBS_ENTRY3  247, SetDebugFilterState, 0 
SYSSTUBS_ENTRY4  247, SetDebugFilterState, 0 
SYSSTUBS_ENTRY5  247, SetDebugFilterState, 0 
SYSSTUBS_ENTRY6  247, SetDebugFilterState, 0 
SYSSTUBS_ENTRY7  247, SetDebugFilterState, 0 
SYSSTUBS_ENTRY8  247, SetDebugFilterState, 0 
SYSSTUBS_ENTRY1  248, SetDefaultHardErrorPort, 0 
SYSSTUBS_ENTRY2  248, SetDefaultHardErrorPort, 0 
SYSSTUBS_ENTRY3  248, SetDefaultHardErrorPort, 0 
SYSSTUBS_ENTRY4  248, SetDefaultHardErrorPort, 0 
SYSSTUBS_ENTRY5  248, SetDefaultHardErrorPort, 0 
SYSSTUBS_ENTRY6  248, SetDefaultHardErrorPort, 0 
SYSSTUBS_ENTRY7  248, SetDefaultHardErrorPort, 0 
SYSSTUBS_ENTRY8  248, SetDefaultHardErrorPort, 0 
SYSSTUBS_ENTRY1  249, SetDefaultLocale, 0 
SYSSTUBS_ENTRY2  249, SetDefaultLocale, 0 
SYSSTUBS_ENTRY3  249, SetDefaultLocale, 0 
SYSSTUBS_ENTRY4  249, SetDefaultLocale, 0 
SYSSTUBS_ENTRY5  249, SetDefaultLocale, 0 
SYSSTUBS_ENTRY6  249, SetDefaultLocale, 0 
SYSSTUBS_ENTRY7  249, SetDefaultLocale, 0 
SYSSTUBS_ENTRY8  249, SetDefaultLocale, 0 
SYSSTUBS_ENTRY1  250, SetDefaultUILanguage, 0 
SYSSTUBS_ENTRY2  250, SetDefaultUILanguage, 0 
SYSSTUBS_ENTRY3  250, SetDefaultUILanguage, 0 
SYSSTUBS_ENTRY4  250, SetDefaultUILanguage, 0 
SYSSTUBS_ENTRY5  250, SetDefaultUILanguage, 0 
SYSSTUBS_ENTRY6  250, SetDefaultUILanguage, 0 
SYSSTUBS_ENTRY7  250, SetDefaultUILanguage, 0 
SYSSTUBS_ENTRY8  250, SetDefaultUILanguage, 0 
SYSSTUBS_ENTRY1  251, SetDriverEntryOrder, 0 
SYSSTUBS_ENTRY2  251, SetDriverEntryOrder, 0 
SYSSTUBS_ENTRY3  251, SetDriverEntryOrder, 0 
SYSSTUBS_ENTRY4  251, SetDriverEntryOrder, 0 
SYSSTUBS_ENTRY5  251, SetDriverEntryOrder, 0 
SYSSTUBS_ENTRY6  251, SetDriverEntryOrder, 0 
SYSSTUBS_ENTRY7  251, SetDriverEntryOrder, 0 
SYSSTUBS_ENTRY8  251, SetDriverEntryOrder, 0 
SYSSTUBS_ENTRY1  252, SetEaFile, 0 
SYSSTUBS_ENTRY2  252, SetEaFile, 0 
SYSSTUBS_ENTRY3  252, SetEaFile, 0 
SYSSTUBS_ENTRY4  252, SetEaFile, 0 
SYSSTUBS_ENTRY5  252, SetEaFile, 0 
SYSSTUBS_ENTRY6  252, SetEaFile, 0 
SYSSTUBS_ENTRY7  252, SetEaFile, 0 
SYSSTUBS_ENTRY8  252, SetEaFile, 0 
SYSSTUBS_ENTRY1  253, SetHighEventPair, 0 
SYSSTUBS_ENTRY2  253, SetHighEventPair, 0 
SYSSTUBS_ENTRY3  253, SetHighEventPair, 0 
SYSSTUBS_ENTRY4  253, SetHighEventPair, 0 
SYSSTUBS_ENTRY5  253, SetHighEventPair, 0 
SYSSTUBS_ENTRY6  253, SetHighEventPair, 0 
SYSSTUBS_ENTRY7  253, SetHighEventPair, 0 
SYSSTUBS_ENTRY8  253, SetHighEventPair, 0 
SYSSTUBS_ENTRY1  254, SetHighWaitLowEventPair, 0 
SYSSTUBS_ENTRY2  254, SetHighWaitLowEventPair, 0 
SYSSTUBS_ENTRY3  254, SetHighWaitLowEventPair, 0 
SYSSTUBS_ENTRY4  254, SetHighWaitLowEventPair, 0 
SYSSTUBS_ENTRY5  254, SetHighWaitLowEventPair, 0 
SYSSTUBS_ENTRY6  254, SetHighWaitLowEventPair, 0 
SYSSTUBS_ENTRY7  254, SetHighWaitLowEventPair, 0 
SYSSTUBS_ENTRY8  254, SetHighWaitLowEventPair, 0 
SYSSTUBS_ENTRY1  255, SetInformationDebugObject, 1 
SYSSTUBS_ENTRY2  255, SetInformationDebugObject, 1 
SYSSTUBS_ENTRY3  255, SetInformationDebugObject, 1 
SYSSTUBS_ENTRY4  255, SetInformationDebugObject, 1 
SYSSTUBS_ENTRY5  255, SetInformationDebugObject, 1 
SYSSTUBS_ENTRY6  255, SetInformationDebugObject, 1 
SYSSTUBS_ENTRY7  255, SetInformationDebugObject, 1 
SYSSTUBS_ENTRY8  255, SetInformationDebugObject, 1 
SYSSTUBS_ENTRY1  256, SetInformationJobObject, 0 
SYSSTUBS_ENTRY2  256, SetInformationJobObject, 0 
SYSSTUBS_ENTRY3  256, SetInformationJobObject, 0 
SYSSTUBS_ENTRY4  256, SetInformationJobObject, 0 
SYSSTUBS_ENTRY5  256, SetInformationJobObject, 0 
SYSSTUBS_ENTRY6  256, SetInformationJobObject, 0 
SYSSTUBS_ENTRY7  256, SetInformationJobObject, 0 
SYSSTUBS_ENTRY8  256, SetInformationJobObject, 0 
SYSSTUBS_ENTRY1  257, SetInformationKey, 0 
SYSSTUBS_ENTRY2  257, SetInformationKey, 0 
SYSSTUBS_ENTRY3  257, SetInformationKey, 0 
SYSSTUBS_ENTRY4  257, SetInformationKey, 0 
SYSSTUBS_ENTRY5  257, SetInformationKey, 0 
SYSSTUBS_ENTRY6  257, SetInformationKey, 0 
SYSSTUBS_ENTRY7  257, SetInformationKey, 0 
SYSSTUBS_ENTRY8  257, SetInformationKey, 0 
SYSSTUBS_ENTRY1  258, SetInformationToken, 0 
SYSSTUBS_ENTRY2  258, SetInformationToken, 0 
SYSSTUBS_ENTRY3  258, SetInformationToken, 0 
SYSSTUBS_ENTRY4  258, SetInformationToken, 0 
SYSSTUBS_ENTRY5  258, SetInformationToken, 0 
SYSSTUBS_ENTRY6  258, SetInformationToken, 0 
SYSSTUBS_ENTRY7  258, SetInformationToken, 0 
SYSSTUBS_ENTRY8  258, SetInformationToken, 0 
SYSSTUBS_ENTRY1  259, SetIntervalProfile, 0 
SYSSTUBS_ENTRY2  259, SetIntervalProfile, 0 
SYSSTUBS_ENTRY3  259, SetIntervalProfile, 0 
SYSSTUBS_ENTRY4  259, SetIntervalProfile, 0 
SYSSTUBS_ENTRY5  259, SetIntervalProfile, 0 
SYSSTUBS_ENTRY6  259, SetIntervalProfile, 0 
SYSSTUBS_ENTRY7  259, SetIntervalProfile, 0 
SYSSTUBS_ENTRY8  259, SetIntervalProfile, 0 
SYSSTUBS_ENTRY1  260, SetIoCompletion, 1 
SYSSTUBS_ENTRY2  260, SetIoCompletion, 1 
SYSSTUBS_ENTRY3  260, SetIoCompletion, 1 
SYSSTUBS_ENTRY4  260, SetIoCompletion, 1 
SYSSTUBS_ENTRY5  260, SetIoCompletion, 1 
SYSSTUBS_ENTRY6  260, SetIoCompletion, 1 
SYSSTUBS_ENTRY7  260, SetIoCompletion, 1 
SYSSTUBS_ENTRY8  260, SetIoCompletion, 1 
SYSSTUBS_ENTRY1  261, SetLdtEntries, 2 
SYSSTUBS_ENTRY2  261, SetLdtEntries, 2 
SYSSTUBS_ENTRY3  261, SetLdtEntries, 2 
SYSSTUBS_ENTRY4  261, SetLdtEntries, 2 
SYSSTUBS_ENTRY5  261, SetLdtEntries, 2 
SYSSTUBS_ENTRY6  261, SetLdtEntries, 2 
SYSSTUBS_ENTRY7  261, SetLdtEntries, 2 
SYSSTUBS_ENTRY8  261, SetLdtEntries, 2 
SYSSTUBS_ENTRY1  262, SetLowEventPair, 0 
SYSSTUBS_ENTRY2  262, SetLowEventPair, 0 
SYSSTUBS_ENTRY3  262, SetLowEventPair, 0 
SYSSTUBS_ENTRY4  262, SetLowEventPair, 0 
SYSSTUBS_ENTRY5  262, SetLowEventPair, 0 
SYSSTUBS_ENTRY6  262, SetLowEventPair, 0 
SYSSTUBS_ENTRY7  262, SetLowEventPair, 0 
SYSSTUBS_ENTRY8  262, SetLowEventPair, 0 
SYSSTUBS_ENTRY1  263, SetLowWaitHighEventPair, 0 
SYSSTUBS_ENTRY2  263, SetLowWaitHighEventPair, 0 
SYSSTUBS_ENTRY3  263, SetLowWaitHighEventPair, 0 
SYSSTUBS_ENTRY4  263, SetLowWaitHighEventPair, 0 
SYSSTUBS_ENTRY5  263, SetLowWaitHighEventPair, 0 
SYSSTUBS_ENTRY6  263, SetLowWaitHighEventPair, 0 
SYSSTUBS_ENTRY7  263, SetLowWaitHighEventPair, 0 
SYSSTUBS_ENTRY8  263, SetLowWaitHighEventPair, 0 
SYSSTUBS_ENTRY1  264, SetQuotaInformationFile, 0 
SYSSTUBS_ENTRY2  264, SetQuotaInformationFile, 0 
SYSSTUBS_ENTRY3  264, SetQuotaInformationFile, 0 
SYSSTUBS_ENTRY4  264, SetQuotaInformationFile, 0 
SYSSTUBS_ENTRY5  264, SetQuotaInformationFile, 0 
SYSSTUBS_ENTRY6  264, SetQuotaInformationFile, 0 
SYSSTUBS_ENTRY7  264, SetQuotaInformationFile, 0 
SYSSTUBS_ENTRY8  264, SetQuotaInformationFile, 0 
SYSSTUBS_ENTRY1  265, SetSecurityObject, 0 
SYSSTUBS_ENTRY2  265, SetSecurityObject, 0 
SYSSTUBS_ENTRY3  265, SetSecurityObject, 0 
SYSSTUBS_ENTRY4  265, SetSecurityObject, 0 
SYSSTUBS_ENTRY5  265, SetSecurityObject, 0 
SYSSTUBS_ENTRY6  265, SetSecurityObject, 0 
SYSSTUBS_ENTRY7  265, SetSecurityObject, 0 
SYSSTUBS_ENTRY8  265, SetSecurityObject, 0 
SYSSTUBS_ENTRY1  266, SetSystemEnvironmentValue, 0 
SYSSTUBS_ENTRY2  266, SetSystemEnvironmentValue, 0 
SYSSTUBS_ENTRY3  266, SetSystemEnvironmentValue, 0 
SYSSTUBS_ENTRY4  266, SetSystemEnvironmentValue, 0 
SYSSTUBS_ENTRY5  266, SetSystemEnvironmentValue, 0 
SYSSTUBS_ENTRY6  266, SetSystemEnvironmentValue, 0 
SYSSTUBS_ENTRY7  266, SetSystemEnvironmentValue, 0 
SYSSTUBS_ENTRY8  266, SetSystemEnvironmentValue, 0 
SYSSTUBS_ENTRY1  267, SetSystemEnvironmentValueEx, 1 
SYSSTUBS_ENTRY2  267, SetSystemEnvironmentValueEx, 1 
SYSSTUBS_ENTRY3  267, SetSystemEnvironmentValueEx, 1 
SYSSTUBS_ENTRY4  267, SetSystemEnvironmentValueEx, 1 
SYSSTUBS_ENTRY5  267, SetSystemEnvironmentValueEx, 1 
SYSSTUBS_ENTRY6  267, SetSystemEnvironmentValueEx, 1 
SYSSTUBS_ENTRY7  267, SetSystemEnvironmentValueEx, 1 
SYSSTUBS_ENTRY8  267, SetSystemEnvironmentValueEx, 1 
SYSSTUBS_ENTRY1  268, SetSystemInformation, 0 
SYSSTUBS_ENTRY2  268, SetSystemInformation, 0 
SYSSTUBS_ENTRY3  268, SetSystemInformation, 0 
SYSSTUBS_ENTRY4  268, SetSystemInformation, 0 
SYSSTUBS_ENTRY5  268, SetSystemInformation, 0 
SYSSTUBS_ENTRY6  268, SetSystemInformation, 0 
SYSSTUBS_ENTRY7  268, SetSystemInformation, 0 
SYSSTUBS_ENTRY8  268, SetSystemInformation, 0 
SYSSTUBS_ENTRY1  269, SetSystemPowerState, 0 
SYSSTUBS_ENTRY2  269, SetSystemPowerState, 0 
SYSSTUBS_ENTRY3  269, SetSystemPowerState, 0 
SYSSTUBS_ENTRY4  269, SetSystemPowerState, 0 
SYSSTUBS_ENTRY5  269, SetSystemPowerState, 0 
SYSSTUBS_ENTRY6  269, SetSystemPowerState, 0 
SYSSTUBS_ENTRY7  269, SetSystemPowerState, 0 
SYSSTUBS_ENTRY8  269, SetSystemPowerState, 0 
SYSSTUBS_ENTRY1  270, SetSystemTime, 0 
SYSSTUBS_ENTRY2  270, SetSystemTime, 0 
SYSSTUBS_ENTRY3  270, SetSystemTime, 0 
SYSSTUBS_ENTRY4  270, SetSystemTime, 0 
SYSSTUBS_ENTRY5  270, SetSystemTime, 0 
SYSSTUBS_ENTRY6  270, SetSystemTime, 0 
SYSSTUBS_ENTRY7  270, SetSystemTime, 0 
SYSSTUBS_ENTRY8  270, SetSystemTime, 0 
SYSSTUBS_ENTRY1  271, SetThreadExecutionState, 0 
SYSSTUBS_ENTRY2  271, SetThreadExecutionState, 0 
SYSSTUBS_ENTRY3  271, SetThreadExecutionState, 0 
SYSSTUBS_ENTRY4  271, SetThreadExecutionState, 0 
SYSSTUBS_ENTRY5  271, SetThreadExecutionState, 0 
SYSSTUBS_ENTRY6  271, SetThreadExecutionState, 0 
SYSSTUBS_ENTRY7  271, SetThreadExecutionState, 0 
SYSSTUBS_ENTRY8  271, SetThreadExecutionState, 0 
SYSSTUBS_ENTRY1  272, SetTimerResolution, 0 
SYSSTUBS_ENTRY2  272, SetTimerResolution, 0 
SYSSTUBS_ENTRY3  272, SetTimerResolution, 0 
SYSSTUBS_ENTRY4  272, SetTimerResolution, 0 
SYSSTUBS_ENTRY5  272, SetTimerResolution, 0 
SYSSTUBS_ENTRY6  272, SetTimerResolution, 0 
SYSSTUBS_ENTRY7  272, SetTimerResolution, 0 
SYSSTUBS_ENTRY8  272, SetTimerResolution, 0 
SYSSTUBS_ENTRY1  273, SetUuidSeed, 0 
SYSSTUBS_ENTRY2  273, SetUuidSeed, 0 
SYSSTUBS_ENTRY3  273, SetUuidSeed, 0 
SYSSTUBS_ENTRY4  273, SetUuidSeed, 0 
SYSSTUBS_ENTRY5  273, SetUuidSeed, 0 
SYSSTUBS_ENTRY6  273, SetUuidSeed, 0 
SYSSTUBS_ENTRY7  273, SetUuidSeed, 0 
SYSSTUBS_ENTRY8  273, SetUuidSeed, 0 
SYSSTUBS_ENTRY1  274, SetVolumeInformationFile, 1 
SYSSTUBS_ENTRY2  274, SetVolumeInformationFile, 1 
SYSSTUBS_ENTRY3  274, SetVolumeInformationFile, 1 
SYSSTUBS_ENTRY4  274, SetVolumeInformationFile, 1 
SYSSTUBS_ENTRY5  274, SetVolumeInformationFile, 1 
SYSSTUBS_ENTRY6  274, SetVolumeInformationFile, 1 
SYSSTUBS_ENTRY7  274, SetVolumeInformationFile, 1 
SYSSTUBS_ENTRY8  274, SetVolumeInformationFile, 1 
SYSSTUBS_ENTRY1  275, ShutdownSystem, 0 
SYSSTUBS_ENTRY2  275, ShutdownSystem, 0 
SYSSTUBS_ENTRY3  275, ShutdownSystem, 0 
SYSSTUBS_ENTRY4  275, ShutdownSystem, 0 
SYSSTUBS_ENTRY5  275, ShutdownSystem, 0 
SYSSTUBS_ENTRY6  275, ShutdownSystem, 0 
SYSSTUBS_ENTRY7  275, ShutdownSystem, 0 
SYSSTUBS_ENTRY8  275, ShutdownSystem, 0 
SYSSTUBS_ENTRY1  276, SignalAndWaitForSingleObject, 0 
SYSSTUBS_ENTRY2  276, SignalAndWaitForSingleObject, 0 
SYSSTUBS_ENTRY3  276, SignalAndWaitForSingleObject, 0 
SYSSTUBS_ENTRY4  276, SignalAndWaitForSingleObject, 0 
SYSSTUBS_ENTRY5  276, SignalAndWaitForSingleObject, 0 
SYSSTUBS_ENTRY6  276, SignalAndWaitForSingleObject, 0 
SYSSTUBS_ENTRY7  276, SignalAndWaitForSingleObject, 0 
SYSSTUBS_ENTRY8  276, SignalAndWaitForSingleObject, 0 
SYSSTUBS_ENTRY1  277, StartProfile, 0 
SYSSTUBS_ENTRY2  277, StartProfile, 0 
SYSSTUBS_ENTRY3  277, StartProfile, 0 
SYSSTUBS_ENTRY4  277, StartProfile, 0 
SYSSTUBS_ENTRY5  277, StartProfile, 0 
SYSSTUBS_ENTRY6  277, StartProfile, 0 
SYSSTUBS_ENTRY7  277, StartProfile, 0 
SYSSTUBS_ENTRY8  277, StartProfile, 0 
SYSSTUBS_ENTRY1  278, StopProfile, 0 
SYSSTUBS_ENTRY2  278, StopProfile, 0 
SYSSTUBS_ENTRY3  278, StopProfile, 0 
SYSSTUBS_ENTRY4  278, StopProfile, 0 
SYSSTUBS_ENTRY5  278, StopProfile, 0 
SYSSTUBS_ENTRY6  278, StopProfile, 0 
SYSSTUBS_ENTRY7  278, StopProfile, 0 
SYSSTUBS_ENTRY8  278, StopProfile, 0 
SYSSTUBS_ENTRY1  279, SuspendProcess, 0 
SYSSTUBS_ENTRY2  279, SuspendProcess, 0 
SYSSTUBS_ENTRY3  279, SuspendProcess, 0 
SYSSTUBS_ENTRY4  279, SuspendProcess, 0 
SYSSTUBS_ENTRY5  279, SuspendProcess, 0 
SYSSTUBS_ENTRY6  279, SuspendProcess, 0 
SYSSTUBS_ENTRY7  279, SuspendProcess, 0 
SYSSTUBS_ENTRY8  279, SuspendProcess, 0 
SYSSTUBS_ENTRY1  280, SuspendThread, 0 
SYSSTUBS_ENTRY2  280, SuspendThread, 0 
SYSSTUBS_ENTRY3  280, SuspendThread, 0 
SYSSTUBS_ENTRY4  280, SuspendThread, 0 
SYSSTUBS_ENTRY5  280, SuspendThread, 0 
SYSSTUBS_ENTRY6  280, SuspendThread, 0 
SYSSTUBS_ENTRY7  280, SuspendThread, 0 
SYSSTUBS_ENTRY8  280, SuspendThread, 0 
SYSSTUBS_ENTRY1  281, SystemDebugControl, 2 
SYSSTUBS_ENTRY2  281, SystemDebugControl, 2 
SYSSTUBS_ENTRY3  281, SystemDebugControl, 2 
SYSSTUBS_ENTRY4  281, SystemDebugControl, 2 
SYSSTUBS_ENTRY5  281, SystemDebugControl, 2 
SYSSTUBS_ENTRY6  281, SystemDebugControl, 2 
SYSSTUBS_ENTRY7  281, SystemDebugControl, 2 
SYSSTUBS_ENTRY8  281, SystemDebugControl, 2 
SYSSTUBS_ENTRY1  282, TerminateJobObject, 0 
SYSSTUBS_ENTRY2  282, TerminateJobObject, 0 
SYSSTUBS_ENTRY3  282, TerminateJobObject, 0 
SYSSTUBS_ENTRY4  282, TerminateJobObject, 0 
SYSSTUBS_ENTRY5  282, TerminateJobObject, 0 
SYSSTUBS_ENTRY6  282, TerminateJobObject, 0 
SYSSTUBS_ENTRY7  282, TerminateJobObject, 0 
SYSSTUBS_ENTRY8  282, TerminateJobObject, 0 
SYSSTUBS_ENTRY1  283, TestAlert, 0 
SYSSTUBS_ENTRY2  283, TestAlert, 0 
SYSSTUBS_ENTRY3  283, TestAlert, 0 
SYSSTUBS_ENTRY4  283, TestAlert, 0 
SYSSTUBS_ENTRY5  283, TestAlert, 0 
SYSSTUBS_ENTRY6  283, TestAlert, 0 
SYSSTUBS_ENTRY7  283, TestAlert, 0 
SYSSTUBS_ENTRY8  283, TestAlert, 0 
SYSSTUBS_ENTRY1  284, TranslateFilePath, 0 
SYSSTUBS_ENTRY2  284, TranslateFilePath, 0 
SYSSTUBS_ENTRY3  284, TranslateFilePath, 0 
SYSSTUBS_ENTRY4  284, TranslateFilePath, 0 
SYSSTUBS_ENTRY5  284, TranslateFilePath, 0 
SYSSTUBS_ENTRY6  284, TranslateFilePath, 0 
SYSSTUBS_ENTRY7  284, TranslateFilePath, 0 
SYSSTUBS_ENTRY8  284, TranslateFilePath, 0 
SYSSTUBS_ENTRY1  285, UnloadDriver, 0 
SYSSTUBS_ENTRY2  285, UnloadDriver, 0 
SYSSTUBS_ENTRY3  285, UnloadDriver, 0 
SYSSTUBS_ENTRY4  285, UnloadDriver, 0 
SYSSTUBS_ENTRY5  285, UnloadDriver, 0 
SYSSTUBS_ENTRY6  285, UnloadDriver, 0 
SYSSTUBS_ENTRY7  285, UnloadDriver, 0 
SYSSTUBS_ENTRY8  285, UnloadDriver, 0 
SYSSTUBS_ENTRY1  286, UnloadKey, 0 
SYSSTUBS_ENTRY2  286, UnloadKey, 0 
SYSSTUBS_ENTRY3  286, UnloadKey, 0 
SYSSTUBS_ENTRY4  286, UnloadKey, 0 
SYSSTUBS_ENTRY5  286, UnloadKey, 0 
SYSSTUBS_ENTRY6  286, UnloadKey, 0 
SYSSTUBS_ENTRY7  286, UnloadKey, 0 
SYSSTUBS_ENTRY8  286, UnloadKey, 0 
SYSSTUBS_ENTRY1  287, UnloadKey2, 0 
SYSSTUBS_ENTRY2  287, UnloadKey2, 0 
SYSSTUBS_ENTRY3  287, UnloadKey2, 0 
SYSSTUBS_ENTRY4  287, UnloadKey2, 0 
SYSSTUBS_ENTRY5  287, UnloadKey2, 0 
SYSSTUBS_ENTRY6  287, UnloadKey2, 0 
SYSSTUBS_ENTRY7  287, UnloadKey2, 0 
SYSSTUBS_ENTRY8  287, UnloadKey2, 0 
SYSSTUBS_ENTRY1  288, UnloadKeyEx, 0 
SYSSTUBS_ENTRY2  288, UnloadKeyEx, 0 
SYSSTUBS_ENTRY3  288, UnloadKeyEx, 0 
SYSSTUBS_ENTRY4  288, UnloadKeyEx, 0 
SYSSTUBS_ENTRY5  288, UnloadKeyEx, 0 
SYSSTUBS_ENTRY6  288, UnloadKeyEx, 0 
SYSSTUBS_ENTRY7  288, UnloadKeyEx, 0 
SYSSTUBS_ENTRY8  288, UnloadKeyEx, 0 
SYSSTUBS_ENTRY1  289, UnlockFile, 1 
SYSSTUBS_ENTRY2  289, UnlockFile, 1 
SYSSTUBS_ENTRY3  289, UnlockFile, 1 
SYSSTUBS_ENTRY4  289, UnlockFile, 1 
SYSSTUBS_ENTRY5  289, UnlockFile, 1 
SYSSTUBS_ENTRY6  289, UnlockFile, 1 
SYSSTUBS_ENTRY7  289, UnlockFile, 1 
SYSSTUBS_ENTRY8  289, UnlockFile, 1 
SYSSTUBS_ENTRY1  290, UnlockVirtualMemory, 0 
SYSSTUBS_ENTRY2  290, UnlockVirtualMemory, 0 
SYSSTUBS_ENTRY3  290, UnlockVirtualMemory, 0 
SYSSTUBS_ENTRY4  290, UnlockVirtualMemory, 0 
SYSSTUBS_ENTRY5  290, UnlockVirtualMemory, 0 
SYSSTUBS_ENTRY6  290, UnlockVirtualMemory, 0 
SYSSTUBS_ENTRY7  290, UnlockVirtualMemory, 0 
SYSSTUBS_ENTRY8  290, UnlockVirtualMemory, 0 
SYSSTUBS_ENTRY1  291, VdmControl, 0 
SYSSTUBS_ENTRY2  291, VdmControl, 0 
SYSSTUBS_ENTRY3  291, VdmControl, 0 
SYSSTUBS_ENTRY4  291, VdmControl, 0 
SYSSTUBS_ENTRY5  291, VdmControl, 0 
SYSSTUBS_ENTRY6  291, VdmControl, 0 
SYSSTUBS_ENTRY7  291, VdmControl, 0 
SYSSTUBS_ENTRY8  291, VdmControl, 0 
SYSSTUBS_ENTRY1  292, WaitForDebugEvent, 0 
SYSSTUBS_ENTRY2  292, WaitForDebugEvent, 0 
SYSSTUBS_ENTRY3  292, WaitForDebugEvent, 0 
SYSSTUBS_ENTRY4  292, WaitForDebugEvent, 0 
SYSSTUBS_ENTRY5  292, WaitForDebugEvent, 0 
SYSSTUBS_ENTRY6  292, WaitForDebugEvent, 0 
SYSSTUBS_ENTRY7  292, WaitForDebugEvent, 0 
SYSSTUBS_ENTRY8  292, WaitForDebugEvent, 0 
SYSSTUBS_ENTRY1  293, WaitForKeyedEvent, 0 
SYSSTUBS_ENTRY2  293, WaitForKeyedEvent, 0 
SYSSTUBS_ENTRY3  293, WaitForKeyedEvent, 0 
SYSSTUBS_ENTRY4  293, WaitForKeyedEvent, 0 
SYSSTUBS_ENTRY5  293, WaitForKeyedEvent, 0 
SYSSTUBS_ENTRY6  293, WaitForKeyedEvent, 0 
SYSSTUBS_ENTRY7  293, WaitForKeyedEvent, 0 
SYSSTUBS_ENTRY8  293, WaitForKeyedEvent, 0 
SYSSTUBS_ENTRY1  294, WaitHighEventPair, 0 
SYSSTUBS_ENTRY2  294, WaitHighEventPair, 0 
SYSSTUBS_ENTRY3  294, WaitHighEventPair, 0 
SYSSTUBS_ENTRY4  294, WaitHighEventPair, 0 
SYSSTUBS_ENTRY5  294, WaitHighEventPair, 0 
SYSSTUBS_ENTRY6  294, WaitHighEventPair, 0 
SYSSTUBS_ENTRY7  294, WaitHighEventPair, 0 
SYSSTUBS_ENTRY8  294, WaitHighEventPair, 0 
SYSSTUBS_ENTRY1  295, WaitLowEventPair, 0 
SYSSTUBS_ENTRY2  295, WaitLowEventPair, 0 
SYSSTUBS_ENTRY3  295, WaitLowEventPair, 0 
SYSSTUBS_ENTRY4  295, WaitLowEventPair, 0 
SYSSTUBS_ENTRY5  295, WaitLowEventPair, 0 
SYSSTUBS_ENTRY6  295, WaitLowEventPair, 0 
SYSSTUBS_ENTRY7  295, WaitLowEventPair, 0 
SYSSTUBS_ENTRY8  295, WaitLowEventPair, 0 

STUBS_END
