/*******************************************************************************
*
*  (C) COPYRIGHT AUTHORS, 2017 - 2018
*
*  TITLE:       PATTERNS.H
*
*  VERSION:     1.21
*
*  DATE:        29 Mar 2018
*
*  Search patterns and patches header file.
*
* THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF
* ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED
* TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
* PARTICULAR PURPOSE.
*
*******************************************************************************/

#pragma once

//
// pd - patch data
// pt - patch lookup pattern
//

//********************************************************
//
// Search/Patch patterns for SeValidateImageData
//
//********************************************************

// Patch data for SeValidateImageData STATUS_SUCCESS
unsigned char pdSeValidateImageData[] = { 0x0, 0x0, 0x0, 0x0 };

// Patch data for SeValidateImageData (return STATUS_SUCCESS) 
// xor eax, eax
// retn
unsigned char pdSeValidateImageData_2[] = { 0x33, 0xC0, 0xC3 };

// 
// sub rsp, 28h
// xor eax eax
// cmp
//
unsigned char ptSevalidateImageData_760X[] = { 0x48, 0x83, 0xEC, 0x28, 0x33, 0xC0, 0x38, 0x05 };

//mov eax, STATUS_INVALID_IMAGE_HASH
unsigned char ptSeValidateImageData_9200[] = { 0xCC, 0x90, 0x90, 0xB8, 0x28, 0x04, 0x00, 0xC0 };
unsigned char ptSeValidateImageData_9600_16299[] = { 0xB8, 0x28, 0x04, 0x00, 0xC0 };

unsigned char ptSeValidateImageData_2_9600_14393[] = { 0xB8, 0x28, 0x04, 0x00, 0xC0, 0xC3 };
unsigned char ptSeValidateImageData_2_15063_16299[] = { 0xB8, 0x28, 0x04, 0x00, 0xC0, 0xEB };

#define ptSkipBytesSeValidateImageData_7601             1
#define ptSkipBytesSeValidateImageData_9200             4
#define ptSkipBytesSeValidateImageData_9600_16299       1


//********************************************************
//
// Search/Patch patterns for CcInitializeBcbProfiler
//
//********************************************************

//always in INIT
//Patch data for CcInitializeBcbProfiler
//mov al, 1
//retn
unsigned char pdCcInitializeBcbProfiler[] = { 0xB0, 0x01, 0xC3 };

//Windows 7
unsigned char ptCcInitializeBcbProfiler_7601[] = {
    0x44, 0x89, 0x44, 0x24, 0x18, 0x89, 0x54, 0x24,
    0x10, 0x89, 0x4C, 0x24, 0x08, 0x53, 0x55, 0x56
};

//Windows 8
unsigned char ptCcInitializeBcbProfiler_9200[] = {
    0xFF, 0xF5, 0x53, 0x56, 0x57, 0x41, 0x54, 0x41, 
    0x55, 0x41, 0x56, 0x41, 0x57, 0x48, 0x8B, 0xEC
};

//Windows 8.1
unsigned char ptCcInitializeBcbProfiler_9600[] = {
    0x40, 0x55, 0x53, 0x56, 0x57, 0x41, 0x54, 0x41,
    0x55, 0x41, 0x56, 0x41, 0x57, 0x48, 0x8B, 0xEC,
    0x48, 0x83, 0xEC, 0x58, 0xA0
};

//Windows 10+
unsigned char ptCcInitializeBcbProfiler_10240_16299[] = {
    0x40, 0x55, 0x53, 0x56, 0x57, 0x41, 0x54, 0x41,
    0x55, 0x41, 0x56, 0x41, 0x57, 0x48, 0x8D, 0x6C,
    0x24, 0xE1, 0x48, 0x81, 0xEC, 0xB8, 0x00, 0x00,
    0x00
};

//********************************************************
//
// Search/Patch patterns for KiFilterFiberContext
//
//********************************************************


//Patch data for KiFilterFiberContext
//mov al, 1
//retn
unsigned char pdKiFilterFiberContext[] = { 0xB0, 0x01, 0xC3 };

//Windows 7
unsigned char ptKiFilterFiberContext_7601[] = {
    0x48, 0x89, 0x5C, 0x24, 0x08, 0x48, 0x89, 
    0x6C, 0x24, 0x10, 0x48, 0x89, 0x74, 0x24, 
    0x18, 0x57, 0x41, 0x54, 0x41, 0x55, 0x48, 
    0x83, 0xEC, 0x20, 0xFA
};

//Windows 8
unsigned char ptKiFilterFiberContext_9200[] = {
    0x48, 0x8B, 0xC4, 0x48, 0x89, 0x58, 0x08, 
    0x48, 0x89, 0x68, 0x10, 0x48, 0x89, 0x70, 
    0x18, 0x48, 0x89, 0x78, 0x20, 0x41, 0x54, 
    0x41, 0x55, 0x41, 0x56, 0x48, 0x83, 0xEC, 
    0x30, 0x48, 0x8B, 0xF1, 0xFA
};

//Windows 8.1
unsigned char ptKiFilterFiberContext_9600[] = {
    0x48, 0x8B, 0xC4, 0x48, 0x89, 0x58, 0x08, 
    0x48, 0x89, 0x68, 0x10, 0x48, 0x89, 0x70, 
    0x18, 0x48, 0x89, 0x78, 0x20, 0x41, 0x54, 
    0x41, 0x55, 0x41, 0x56, 0x48, 0x83, 0xEC, 
    0x30, 0x48, 0x8B, 0xF1
};

//Windows 10 TH's
unsigned char ptKiFilterFiberContext_10240_10586[] = {
    0x48, 0x8B, 0xC4, 0x48, 0x89, 0x58, 0x08, 
    0x48, 0x89, 0x68, 0x10, 0x48, 0x89, 0x70, 
    0x18, 0x48, 0x89, 0x78, 0x20, 0x41, 0x55, 
    0x41, 0x56, 0x41, 0x57, 0x48, 0x83, 0xEC, 
    0x30, 0x48, 0x8B, 0xF1
};

//Windows 10 RS1/RS2
unsigned char ptKiFilterFiberContext_14393_15063[] = {
    0x40, 0x53, 0x55, 0x56, 0x57, 0x41, 0x55, 
    0x41, 0x56, 0x41, 0x57, 0x48, 0x83, 0xEC, 
    0x40, 0x48, 0x8B
};

//Windows 10 RS3
unsigned char ptKiFilterFiberContext_16299[] = {
    0x48, 0x89, 0x5C, 0x24, 0x08, 0x55, 0x56, 
    0x57, 0x41, 0x54, 0x41, 0x55, 0x41, 0x56, 
    0x41, 0x57, 0x48, 0x8D, 0x6C, 0x24, 0xD9, 
    0x48, 0x81, 0xEC, 0x90, 0x00, 0x00, 0x00
};

//********************************************************
//
// Search/Patch patterns for KeInitAmd64SpecificState
//
//********************************************************


//Patch data for KeInitAmd64SpecificState
//xor eax, eax
//retn
unsigned char pdKeInitAmd64SpecificState[] = { 0x33, 0xC0, 0xC3 };

//Windows 7
unsigned char ptKeInitAmd64SpecificState_7601[] = { 0x48, 0x83, 0xEC, 0x28, 0x0F, 0xB6 };

//Windows 8/8.1/10 (TH1/TH2/RS1/RS2/RS3)
unsigned char ptKeInitAmd64SpecificState_9200_16299[] = { 0x48, 0x83, 0xEC, 0x28, 0x83, 0x3D };

//********************************************************
//
// Search/Patch patterns for ExpLicenseWatchInitWorker
//
//********************************************************


//Patch data for ExpLicenseWatchInitWorker
//xor eax, eax
//retn
unsigned char pdExpLicenseWatchInitWorker[] = { 0x33, 0xC0, 0xC3 };


//Windows 8, Windows 10 RS2
unsigned char ptExpLicenseWatchInitWorker1[] = { 0x48, 0x83, 0xEC, 0x38, 0x48, 0x8B, 0x05 };

//Windows 8.1/10 TH1/TH2/RS1/RS3
unsigned char ptExpLicenseWatchInitWorker2[] = { 0x40, 0x53, 0x48, 0x83, 0xEC, 0x30, 0x48, 0x8B, 0x05 };


//********************************************************
//
// Search/Patch patterns for SepInitializeCodeIntegrity
//
//********************************************************


//Always in PAGE
//Patch data for SepInitializeCodeIntegrity
unsigned char pdSepInitializeCodeIntegrity[] = { 0x31, 0xC9 };

//
// Signature patterns for function scan.
//

//mov ecx, edi
//call
unsigned char ptSepInitializeCodeIntegrity_7601[] = { 0x8B, 0xCF, 0xE8 };

//mov ecx, edi
//mov rbx,
unsigned char ptSepInitializeCodeIntegrity_9200_14393[] = { 0x8B, 0xCF, 0x48 };

//mov ecx, esi
//mov rbx,
unsigned char ptSepInitializeCodeIntegrity_15063[] = { 0x8B, 0xCE, 0x48 };

//mov ecx, edi
//call
unsigned char ptSepInitializeCodeIntegrity_16299[] = { 0x8B, 0xCF, 0xFF };

//
// Signature patterns for function itself.
//

//Windows 7
unsigned char ptSepInitializeCodeIntegrity2_7601[] = {
    0x48, 0x3B, 0xC3, 0x74, 0x52, 0x48, 0x39, 
    0x98, 0x98, 0x00, 0x00, 0x00, 0x74, 0x40
};

//Windows 8/8.1
unsigned char ptSepInitializeCodeIntegrity2_9200_9600[] = {
    0x48, 0x89, 0x5C, 0x24, 0x08, 0x57,
    0x48, 0x83, 0xEC, 0x20, 0xBF, 0x06,
    0x00, 0x00, 0x00
};

//Windows 10 TH1/TH2
unsigned char ptSepInitializeCodeIntegrity2_10240_10586[] = {
    0x48, 0x89, 0x5C, 0x24, 0x08, 0x57,
    0x48, 0x83, 0xEC, 0x20, 0xBB, 0x98,
    0x00, 0x00, 0x00
};

//Windows 10 RS1
unsigned char ptSepInitializeCodeIntegrity2_14393[] = {
    0x48, 0x89, 0x5C, 0x24, 0x08, 0x57, 
    0x48, 0x83, 0xEC, 0x20, 0xBB, 0xA8,
    0x00, 0x00, 0x00
};

//Windows 10 RS2
unsigned char ptSepInitializeCodeIntegrity2_15063[] = {
    0x48, 0x89, 0x5C, 0x24, 0x08, 0x48, 
    0x89, 0x74, 0x24, 0x10, 0x57, 0x48, 
    0x83, 0xEC, 0x20, 0xBB, 0xC0, 0x00, 
    0x00, 0x00
};

//Windows 10 RS3
unsigned char ptSepInitializeCodeIntegrity2_16299[] = {
    0x48, 0x89, 0x5C, 0x24, 0x08, 0x57, 
    0x48, 0x83, 0xEC, 0x20, 0xBB, 0xC0, 
    0x00, 0x00, 0x00
};

//********************************************************
//
// Search/Patch patterns for ImgpValidateImageHash
//
//********************************************************

//xor eax, eax 
//retn
unsigned char pdImgpValidateImageHash[] = { 0x33, 0xC0, 0xC3 };

//
// Winload.EXE/Winload.EFI
//
unsigned char ptImgpValidateImageHash_7601[] = {
    0x48, 0x89, 0x5C, 0x24, 0x08, 0x48, 0x89, 0x6C, 0x24, 0x10, 0x48, 0x89, 0x74, 0x24, 0x18,
    0x57, 0x41, 0x54, 0x41, 0x55, 0x41, 0x56, 0x41, 0x57, 0x48, 0x81, 0xEC, 0xB0, 0x00, 0x00
};

unsigned char ptImgpValidateImageHash_9200[] = {
    0x48, 0x89, 0x5C, 0x24, 0x08, 0x48, 0x89, 0x74, 0x24, 0x10, 0x48, 0x89, 0x7C, 0x24, 0x18,
    0x55, 0x41, 0x54, 0x41, 0x55, 0x41, 0x56, 0x41, 0x57, 0x48, 0x8D, 0x6C, 0x24, 0x90
};

unsigned char ptImgpValidateImageHash_9600[] = {
    0x48, 0x89, 0x5C, 0x24, 0x10, 0x4C, 0x89, 0x4C, 0x24, 0x20, 0x48, 0x89, 0x4C, 0x24, 0x08, 0x55,
    0x56, 0x57, 0x41, 0x54, 0x41, 0x55, 0x41, 0x56, 0x41, 0x57, 0x48, 0x8D, 0x6C, 0x24, 0x80
};

unsigned char ptImgpValidateImageHash_10240[] = {
    0x48, 0x8B, 0xC4, 0x48, 0x89, 0x58, 0x20, 0x44, 0x89, 0x40, 0x18, 0x48, 0x89, 0x50, 0x10, 0x48,
    0x89, 0x48, 0x08, 0x55, 0x56, 0x57, 0x41, 0x54, 0x41, 0x55, 0x41, 0x56, 0x41, 0x57, 0x48, 0x8D,
    0xA8, 0x08, 0xFF, 0xFF
};

unsigned char ptImgpValidateImageHash_10586[] = {
    0x48, 0x8B, 0xC4, 0x48, 0x89, 0x58, 0x08, 0x44, 0x89, 0x40, 0x18, 0x48, 0x89, 0x50, 0x10, 0x55,
    0x56, 0x57, 0x41, 0x54, 0x41, 0x55, 0x41, 0x56, 0x41, 0x57, 0x48, 0x8D, 0xA8, 0xE8, 0xFE, 0xFF, 0xFF
};

unsigned char ptImgpValidateImageHash_14393[] = {
    0x48, 0x8B, 0xC4, 0x4C, 0x89, 0x48, 0x20, 0x44, 0x89, 0x40, 0x18, 0x48, 0x89, 0x50, 0x10, 0x48,
    0x89, 0x48, 0x08, 0x55, 0x53, 0x56, 0x57, 0x41, 0x54, 0x41, 0x55, 0x41, 0x56, 0x41, 0x57, 0x48,
    0x8D, 0xA8, 0x98, 0xFE, 0xFF, 0xFF
};

unsigned char ptImgpValidateImageHash_15063[] = {
    0x48, 0x8B, 0xC4, 0x4C, 0x89, 0x48, 0x20, 0x44, 0x89, 0x40, 0x18, 0x48, 0x89, 0x50, 0x10, 0x48,
    0x89, 0x48, 0x08, 0x55, 0x53, 0x56, 0x57, 0x41, 0x54, 0x41, 0x55, 0x41, 0x56, 0x41, 0x57, 0x48,
    0x8D, 0xA8, 0x78, 0xFE, 0xFF, 0xFF
};

unsigned char ptImgpValidateImageHash_16299[] = {
    0x48, 0x8B, 0xC4, 0x4C, 0x89, 0x48, 0x20, 0x44, 0x89, 0x40, 0x18, 0x48, 0x89, 0x50, 0x10, 0x48,
    0x89, 0x48, 0x08, 0x55, 0x53, 0x56, 0x57, 0x41, 0x54, 0x41, 0x55, 0x41, 0x56, 0x41, 0x57, 0x48,
    0x8D, 0xA8, 0xA8, 0xFE, 0xFF, 0xFF
};
