
# Question 289


 
 How can we achieve the same result without using `restrict` keyword?


# Answer



By using strict aliasing rules. 

For example, by packing similar types into structures with different tags, we
guarantee that they can not reference the same memory.

```c
struct a {
    int v;
};
struct b {
    int v;
};
void f(struct a* x, struct b* add) {
    x->v += add->v;
    x->v += add->v;
}
```

It is analogous to using `restrict`.

```c
void f(restrict int* x, restrict int* add) {
    x += add;
    x += add;
}
```



[prev](288.md) +++ [next](290.md)
