
# Question 219



What is the difference between 0 in pointer context and 0 as an integer value?


# Answer



There are two contexts in which you might use the 0 expression in C. The first
context expects just a normal integer number. The second one is a pointer
context, when you assign a pointer to 0 or compare it with 0. In the second
context 0 does not always mean an integer value with all bits cleared, but will
always be equal to this "invalid pointer" value. In some architectures it can
be, for example, a value with all bits
set. But this code will work no matter the architecture because of this rule:

```c
int* px = ... ;
if ( px ) /* if `px` is not NULL */
if ( px == 0 ) /* same thing as the following: */
if (!px ) /* if `px` is NULL */
```



[prev](218.md) +++ [next](220.md)
