
# Question 162




Why do these shorts seem reversed? Will it always be the case, or is it architecture dependent? 


# Answer



```c
union dword {
    int integer;
    short shorts[2];
};

int main(void) {
    union dword test;
    test.integer = 0xAABBCCDD;
    printf( "%x and %x\n", test.shorts[0], test.shorts[1] ); 
    return 0;
}
```

Output:

```
ffffccdd and ffffaabb
```

The `ffff` part is a sign extension since both `c` and `a` have most
significant bit set.

It is architecture-dependent because it demonstrates little-endian behavior:

```
integer:  DD CC BB AA
shorts[0] ## ##          = 0xCCDD
shorts[1]       ## ##    = 0xAABB
```



[prev](161.md) +++ [next](163.md)
