
# Question 18



What is `test` equal to after each of these instructions?

```asm
section .data
test: dq -1

section .text

mov byte[test], 1	;1
mov word[test], 1	;2
mov dword[test], 1	;4
mov qword[test], 1	;8
```



# Answer




```asm

section .data
test: dq -1         ; we started with test = 0xFFFFFFFFFFFFFFFF

section .text

; In the following lines we are going to write all 8 bytes separately
mov byte[test], 1	; test: 01 FF FF FF FF FF FF FF
mov word[test], 1	; test: 01 00 FF FF FF FF FF FF
mov dword[test], 1	; test: 01 00 00 00 FF FF FF FF
mov qword[test], 1	; test: 01 00 00 00 00 00 00 00

```

The __little endian__ convention explains, why are we seeing the 8-byte 
format filling with zeros from left to right. The bytes in memory are 
stored in reverse order, the least significant byte being the first.




[prev](017.md) +++ [next](019.md)
