
# Question 149



 What are lvalue and rvalue?


# Answer



They are two types of expressions. 

* __rvalue__ is any expression that you can assign to something. Basically,
everything that is evaluated to a type other than `void` is an rvalue.

* __lvalue__ is an expression that corresponds to a memory cell. _Only lvalues can be placed on the left side of assignment_.

For example:

```c
int x;
int* px;

x   = 0;     //  `x`  is lvalue
px  = &x;    //  `px` is lvalue

*px = 42;    // `*px` is lvalue

&x = 0;      // error: `&x` is _not_ an lvalue
```

From the abstract machine perspective, _lvalue_ is an expression that is evaluated to something that has an address.


[prev](148.md) +++ [next](150.md)
