
# Question 89


What sections can be present in ELF files?


# Answer



* __.text__ stores machine instructions.
* __.rodata__ stores read only data.
* __.data__ stores initialized global variables.
* __.bss__ stores readable and writable global variables, initialized to zero. There is no need to dump their contents into an object file as they are all filled with zeros anyway. Instead, a total section size is stored. An operating system may know faster ways of initializing such memory than zeroing it manually.  In assembly, you can put data here by placing `resb`, `resw`, and similar directives after the section __.bss__.
* __.rel.text__ stores relocation table for the .text section. It is used to memorize places where a linker should modify .text after choosing the loading address for this specific object file.
* __.rel.data__ stores a relocation table for data referenced in module.
* __.debug__ stores a symbol table used to debug program. If the program was written in C or C++, it will store information not only about global variables (as __.symtab__ does) but also about local variables.
* __.line__ defines correspondence with pieces of code and line numbers in source code. We need it because the correspondence between lines of source code in higher-level languages and assembly instructions is not
straightforward. This information allows one to debug a program in a higher-level language line by line.
* __.strtab__ stores character strings. It is like an array of strings. Other sections, such, as __.symtab__ and __.debug__,
 use not immediate strings but their indices in __.strtab__.
* __.symtab__ stores a symbol table. Whenever a programmer defines a label, NASM will create a symbol for it. 
 

[prev](088.md) +++ [next](090.md)
