
# Question 19


Can you spot a bug or two in Listing `strlen_bug1.asm`?
When will they occur?

```asm
global _start

section .data

test_string: db "abcdef", 0

section .text

strlen:                       
.loop:                        
cmp byte [rdi+r13], 0     
je .end                   
inc r13                   
jmp .loop
.end:
mov rax, r13
ret                       

_start:
mov rdi, test_string
call strlen
mov rdi, rax

mov rax, 60
syscall
```



# Answer




* `r13` is not zeroed before usage
* `r13` should be saved before usage and restored before `ret`

```asm
global _start

section .data

test_string: db "abcdef", 0

section .text

strlen:                       
push r13                ;
xor r13, r13            ;
.loop:                        
cmp byte [rdi+r13], 0     
je .end                   
inc r13                   
jmp .loop
.end:
mov rax, r13
pop r13                 ;
ret                       

_start:
mov rdi, test_string
call strlen
mov rdi, rax

mov rax, 60
syscall 
```



[prev](018.md) +++ [next](020.md)
