
# Question 16


How to write numbers in different number systems in a way understandable to
NASM? Check NASM documentation.


# Answer




[http://www.nasm.us/doc/nasmdoc3.html](http://www.nasm.us/doc/nasmdoc3.html)

Quote:


Numeric constants can have underscores (_) interspersed to break up long strings.

Some examples (all producing exactly the same code):

```asm
    mov     ax,200          ; decimal 
    mov     ax,0200         ; still decimal 
    mov     ax,0200d        ; explicitly decimal 
    mov     ax,0d200        ; also decimal 
    mov     ax,0c8h         ; hex 
    mov     ax,$0c8         ; hex again: the 0 is required 
    mov     ax,0xc8         ; hex yet again 
    mov     ax,0hc8         ; still hex 
    mov     ax,310q         ; octal 
    mov     ax,310o         ; octal again 
    mov     ax,0o310        ; octal yet again 
    mov     ax,0q310        ; octal yet again 
    mov     ax,11001000b    ; binary 
    mov     ax,1100_1000b   ; same binary constant 
    mov     ax,1100_1000y   ; same binary constant once more 
    mov     ax,0b1100_1000  ; same binary constant yet again 
    mov     ax,0y1100_1000  ; same binary constant yet again
```




[prev](015.md) +++ [next](017.md)
