
# Question 15


What is the difference between `sar` and `shr`? Check Intel docs.


# Answer





Performing `shr` will perform a _logical shift_. It means that the bits that
slide off the end disappear. The exception is the last bit, which slides into 
the carry flag (CF).
The spaces are filled with zeros.

For example:

```asm
mov rax, 0xFFFFFFFFFFFFFFFF      
shr rax, 4                     ; rax = 0x0FFFFFFFFFFFFFFF
```


Performing `sar` will perform an _arithmetic shift_. It is similar, but the
spaces are filled with the sign bit (the 63-th one).

For example:

```asm
mov rax, 0xFB00000000000000      
shr rax, 4                     ; rax = 0xFFB0000000000000
```

The `FB` part was shifted to the right. However, the sign bit was equal to 
1 as the part of `F` hexadecimal digit. Thus, the empty 4 bits were filled with
its value, becoming `1111` in binary, or  `0xF`.




[prev](014.md) +++ [next](016.md)
