
# Question 1


It is time to make a first research based on the documentation
[Intel 64 and IA-32 Architectures Software Developer's Manual]. Refer to the section 3.4.3 of the first volume to learn
about register `rflags`. What is the meaning of flags `CF`,
`AF`, `ZF`, `OF`, `SF`? What is the difference
between `OF` and `CF`? 


# Answer


    
`rflags` is a register that holds flag values. Flags are bits that are either set or cleared
based on the latest computation executed.

We are going to talk about ZF (Zero Flag) first. It is set when the latest computation resulted in zero value.

Let watch how the ZF (zero flag) is changing when the following instructions are being executed:


```asm
mov rax, 10    ; ZF = 0, the 'result' is 10 in rax
sub rax, 10    ; ZF = 1, the 'result' is 0 in rax

```

SF means that the result is negative.

AF means auxiliary flag, which is set when an arithmetic carry or borrow has been generated out of the four least significant bits, or lower nibble. This flag is rarely used.

CF stands for Carry Flag, when the computation result is too big for the register to hold because it can only hold that many bits.

```asm
mov rax, 0xFFFFFFFFFFFFFFFF  ; The biggest unsigned number that rax can hold
mul 2                        ; Unsigned multiply by 2
; CF = 1 now, the result is to big for rax to hold
```

OF is similar, but it indicates that the sign bit is set, while it should not have been.

```asm
mov rax, 0x7FFFFFFFFFFFFFFF  ; Biggest signed positive number
add rax, 1                   ; rax = 0x80000000000000000, which is _negative_. OF=1
```

The difference is that the CF is a result of an unsigned overflow (not enough bits in the register to hold the value, so CF acts as the 64-th bit after 0..63th bits), while OF is a result of a signed one (the result is too big for 63 bits to hold so the most significant bit overwrites the sign bit).



 +++ [next](002.md)
