
# Question 196




        How to access data defined in other files? 


# Answer


    
    In a similar fashion to functions:

1. Add its declaration before the usage
2. Make sure that the file with that variable definition is compiled as well
3. Make sure the linker accepts the `.o` file with the compiled function body.

For example:

```c
/* lib.c */
int squared = 100;
```

```c
/* main.c */
#include <stdio.h>

    int square;

int main( int x ) {
    printf( "Squared is %d\n", squared );
    return 0;
    } 
```

Then these files should be compiled as follows:

```
> gcc -c -o main.o main.c 
> gcc -c -o lib.o  lib.c
> gcc -o main   main.o lib.o
```
We do recommend putting `extern` specifiers everywhere but at the place where 
the variable is defined. 


[prev](195.md) +++ [next](197.md)
