
# Question 35


What is the difference between `ja`/`jb` and `jg`/`jl`?


# Answer





* ```jl/jg``` are used to perform jumps after signed comparison.


```asm
mov rax, 42
mov rcx, -1
cmp rax, rcx
jl rcx    ; this jump _will not_ be performed
```

* ```ja``` / ```jb``` are used to perform jumps after unsigned comparison:

```asm
mov rax, 42
mov rcx, -1
cmp rax, rcx
jb rcx    ; this jump _will_ be performed
```

The reason why 42 < -1  is that -1 is interpreted as an unsigned integer.
Its hexadecimal representation is 0xFFFFFFFFFFFFFFFF (all 64 bits are set).
If we look at it as if it were an unsigned integer, it will be the greatest
unsigned integer that is representable in 64-bit format (that is, $2^{64}-1$).
Apparently, $42 < 2^{64}-1$

$42 < -1$ is false, so the jump will not beperformed.
* You can also memorize the flags that are tested by these instructions. If these
flags are set, the jump occurs. However, from my experience, it is useless. If you are in need, refer to the Intel software developer manual.





[prev](034.md) +++ [next](036.md)
