
# Question 26


Which ones of these instructions are incorrect and why?
```asm
mov [rax], 0
cmp [rdx], bl
mov bh, bl
mov al, al
add bpl, 9
add [9], spl
mov r8d, r9d
mov r3b, al
mov r9w, r2d
mov rcx, [rax + rbx + rdx]
mov r9, [r9 + 8*rax]
mov [r8+r7+10], 6
mov [r8+r7+10], r6
```


# Answer



The incorrect instructions are listed below:

```asm
mov [rax], 0                ; We don't know whether we should write 8, 4, 2 or 1 byte
                            ; Change to e.g. `mov dword [rax], 0`

mov r3b, al                 ; NASM does not support r0-r7 names, only r8-r15 
mov r9w, r2d                ; NASM does not support r0-r7 names, only r8-r15    

mov rcx, [rax + rbx + rdx]  ; displacement should be an immediate value
                            ; can not use register for it 
mov [r8+r7+10], 6           ; No size specified, NASM does not support r7
mov [r8+r7+10], r6          ; NASM does not support r6 or r7 
```



[prev](025.md) +++ [next](027.md)
