
IDA Signsrch
===============================================================================

IDA Pro plug-in conversion of Luigi Auriemma's signsrch signature matching
tool.

Version 1.4, May 2015
By Sirmabus


----- [Description] -----------------------------------------------------------

Luigi's original signsrch description:
"Tool for searching signatures inside files, extremely useful as help in
reversing jobs like figuring or having an initial idea of what encryption/-
compression algorithm is used for a proprietary protocol or file.
It can recognize tons of compression, multimedia and encryption algorithms and
many other things like known strings and anti-debugging code which can be also
manually added since it's all based on a text signature file read at runtime
and easy to modify."

I've used his tool in the past to help find various bits of crypto sections
and what not. For example the log-in sections of some online game clients.
To use the tool in IDA I would have to run signsrch output piped to a text
file, like this: "signsrch -b Target.exe >Temp.txt".
And then tediously take these address of each match offset and look them up
manually.
Plus facilitated by a plug-in I added an automatic label commenting feature.

Not be confused with IDA  FLIRT "sig" technology, these signatures are direct
binary patterns. Currently there are about 1400 of these signatures from the
source text database "signsrch.sig".


----- [Install] ---------------------------------------------------------------

Copy the plug-in and signsrch.xml file to your IDA Pro "plugins" directory.
The default hot key is "Ctrl-0".
If it conflicts or otherwise wanted to change then you'll need to edit your
"..\plugins\plugins.cfg" to setup it up with your own hotkey combination.

For example add these two lines:
; Sirmabus "Class Informer" plug-in
IDA Signsrch IDA_Signsrch.plw Alt-7 0

See IDA documentation for more on installing and using plug-ins.


----- [How to run it] ---------------------------------------------------------

Invoke like any other plug-in in IDA through the hot key, or through the IDA's
Edit->Plugins menu.

You should be presented with the "IDA Signsrch" plug-in dialog.
If you are running the normal non-QT IDA version ("idag.exe" not "idaq.exe",
with a 'g') you should see my custom UI modifications. Either way it should run
the same.

There are four options:

1) "Alternate endian search.":
What is "endian" you say? http://en.wikipedia.org/wiki/Endianness
By default the plug-in will use the endian based on the IDB (not the current
machine like the exe does).  It is better left unchecked in most circumstances
as otherwise increases the search time about double.
If for some reason the target has opposite endian data then you want it
checked.
FYI the PC and most other mainstream desktops are "little endian".

If you look in "signsrch.xml" you will see things work as runs of bytes.
You might think endian is not relative but actually it is here because these
patterns are often composed of various other data types (like 32bit, etc).

2) "Output to debug channel.":
With this checked match info will be outputted to the debug out channel.
You can view the output in a tool like Mark Russinovich's DebugView available
at: http://goo.gl/D3P0

3) "Include code segments.":
You normally want this option checked so that signatures can be found in mixed
code/data segments plus there are several relevant unique 32bit size code value
signatures in the DB as well.
Unchecked only data segments (".data", ".rdata", etc) will be searched.

4) "Place signature comments.":
With this checked as signatures are located a comment will be placed
automatically made up of a special tag "<$ignsrch> "followed by the signature
label name.
I.E: '<$ignsrch> "CRC-1 poly 0x1 [..256]"'
Is skipped if the special tag already exists so you can run the tool multiple
times with out replicating the comments.
If there is an existing comment at the same place a space will be appended
or a "new line" first if the comment was long.

Click on "Continue" to let it run.
The searching is pretty fast. On my machine it takes about 10 seconds to scan
through a 21mb executable IDB.

On completion if any matches are found it will show them sorted by address in
an IDA list box labeled "[ Signsrch matches ]".
Browse and double click on a line to jump to it's address location.


----- [Design] ----------------------------------------------------------------

I had been wanting to do this project for some time and thought initially it
was going to be a quick easy project since after all there is some source for
it. But after hours of struggling with the parser source I had to just take the
original source (that would compile fine in MS VS2010) and add a quick and
dirty raw XML format exporter.
Now Luigi's original "sig" text format is quite flexible. The patterns can be
stated as C style values, in various forms of arrays in bytes, 32bits, floats,
etc. It appears you can just copy directly from C code and paste it in.
While very convenient it is hard to duplicate as it's mostly hard coded C and
lacks documentation for small details.
Plus I found what appears to be memory leaks that might be okay for a console
app that just of runs then dies, but won't do for a plug-in that could
potentially corrupt the host IDA Pro environment.
Also my raw XML format loads faster sans all the extra parsing anyhow.
However not to detract from Luigi's original tool however. It along with it's
detailed database are brilliant.

On the plug-in side the only only source file actually used is derived from
"hal_search.c" refactored and modified to use a static expanding buffer for
speed et al.
The search algorithm is based on "A Fast Generic Search Algorithm" by David R.
Musser and Gor V. Nishanov:
http://www.cs.rpi.edu/~musser/gp/gensearch/index.html
There could be faster and more optimized these days as this sort of pattern
matching must be the heart of many contemporary anti-virus scanning engines,
but it's plenty fast as it is.


----- [Adding more and editing signatures] ------------------------------------

The XML format is simple and should be mostly self explanatory when viewed in a
text or XML viewer. There is however some tags in the label/title that need
some explanation. In them between two brackets are embedded important details.
The size, endianness, and an optional bit wise stepping value. The format is
'[', optional bits value, '.', endian type "le" or "be" w/optional "rev" for
reverse, '.', the pattern size, then optionally a '&' to indicate the special
bit stepping value, then a ']' to close.
Example: "[32.le.56]" means 32 bits, little endian, with a pattern size of 56
bytes.
Another: "MD5 digest [32.be.272&amp;]" code in there  means 32 bit stepping
(the "&amp;"), big endian, and a pattern size of 272 bytes.
Note in my XML form the bit field ("TYPE" in original format) is only relevant
when the '&' granularity stepping flag is present.

To add more patterns one can either edit "signsrch.xml", or edit the source
"signsrch.sig" in it's original formatting style then run it with the included
"Signsrch2XML.exe" utility to convert it over.
Just put the "signsrch.sig" file in the same folder as Signsrch2XML and run it,
then copy it over in your IDA plugins folder.

See the comments at the top of "signsrch.sig" for more information on it's
formatting.


----- [Change log] ------------------------------------------------------------

1.4 - 1) Updated to IDA SDK 6.8 version.
      2) Added a 64 bit "EA64" version.

1.3 - 1) Fixed bad standard/CRT mixed with custom allocator method bug.
      2) Updated and fixed custom UI elements.

1.2 - Minor clean up of GUI customisations.

----- [License] ------------------------------------------------------------

GNU GENERAL PUBLIC LICENSE version 3
See "license.txt"
