---
layout: default
---


# Main Overall Families (by consensus weight fraction)

Tor network data as of: **2020-08-12 17:00 UTC**

Only entries with a cw fraction >= 0.005% are included

Relays are grouped based on effective MyFamily entries, if your relays are split across multiple lines you
should look into your MyFamily configuration.

|      | Contact or Fingerprint (truncated)                                                                                                                                    |   CW Fraction(%) |   Exit(%) |   Guard(%) |   #Relays | First Seen   |
|-----:|:----------------------------------------------------------------------------------------------------------------------------------------------------------------------|-----------------:|----------:|-----------:|----------:|:-------------|
|    0 | [abuse-contact@to-surf-and-protect.net](https://metrics.torproject.org/rs.html#search/family:01FDC8E92D3280847D856DA1F9BFC2B4CD2C2EE8)                                |            6.548 |     17.42 |       2.29 |       144 | 2016-01-25   |
|    1 | [F3 Netze &lt;abuse@f3netze.de&gt; email:abuse f3netze.d](https://metrics.torproject.org/rs.html#search/family:06EC2C1669E5A811D9640E07CED5786DA50C5737)              |            2.322 |      7.78 |       0    |        32 | 2018-03-21   |
|    2 | [exitrelays@protonmail.com](https://metrics.torproject.org/rs.html#search/family:0828A52E57E4C426742B9264A210394202CD44D4)                                            |            2.27  |      7.6  |       0    |        30 | 2020-07-08   |
|    3 | [cockcockcockcock at cock dot li](https://metrics.torproject.org/rs.html#search/family:0219C961F781986D60EA94C59644AF34C6078B20)                                      |            1.717 |      0.1  |       2.86 |        32 | 2020-08-02   |
|    4 | [kleinendorstwiebe AT gmail DOT com](https://metrics.torproject.org/rs.html#search/family:01C05513D12F63AE9E72588E8EAB459028C44689)                                   |            1.59  |      5.33 |       0    |        27 | 2020-06-20   |
|    5 | [Foundation for Applied Privacy email:tor appliedp](https://metrics.torproject.org/rs.html#search/family:06804E6383EE94E83C9453F39B1E524C272D6D84)                    |            1.098 |      3.45 |       0.11 |        26 | 2017-06-13   |
|    6 | [https://www.torservers.net/donate.html &lt;support .A](https://metrics.torproject.org/rs.html#search/family:0E5522CB4F79E36C0BB263BABC861CFC686929AE)                |            0.993 |      3.33 |       0    |        17 | 2016-12-23   |
|    7 | [Digitalcourage Tor Team &lt;tor-abuse@digitalcourage.](https://metrics.torproject.org/rs.html#search/family:22296CB6AE56609A96F02FB843AB7B4B0A31CAF4)                |            0.865 |      2.9  |       0    |        17 | 2016-05-27   |
|    8 | [&lt;tor AT afo MINUS tm DOT org&gt;](https://metrics.torproject.org/rs.html#search/family:0512FE6BE9CCA0ED133152E64010B2FBA141EB10)                                  |            0.844 |      0    |       1.43 |        14 | 2018-10-05   |
|    9 | [Felix &lt;zwiebel ta quantentunnel tod de&gt;](https://metrics.torproject.org/rs.html#search/family:03C3069E814E296EB18776EB61B1ECB754ED89FE)                        |            0.809 |      0    |       1.37 |        25 | 2015-05-16   |
|   10 | [Nicholas Merrill &lt;nick AT calyx dot com&gt; BTC - 14w](https://metrics.torproject.org/rs.html#search/family:0011BD2485AD45D984EC4159C88FC066E5E3300E)             |            0.567 |      1.79 |       0.05 |        20 | 2013-06-11   |
|   11 | [Kevin Hicks &lt;admin@fissionrelays.net&gt;](https://metrics.torproject.org/rs.html#search/family:0B841CB70F9ED1FD0322C2BA2EB0D80420D87CFA)                          |            0.522 |      0.32 |       0.72 |        22 | 2018-01-07   |
|   12 | [ian@ian.sh](https://metrics.torproject.org/rs.html#search/family:0C9D7DB63BE030E5CA32E25606632AEB85840F4C)                                                           |            0.513 |      1.56 |       0.07 |        38 | 2020-07-04   |
|   13 | [Accessnow.org &lt;abuse .AT. accessnow .DOT. org&gt;](https://metrics.torproject.org/rs.html#search/family:0516085D6CAC40ED4CDCEFDFC5CCF6B00DE61DED)                 |            0.454 |      1.52 |       0    |        11 | 2017-12-05   |
|   14 | [abuse@for-privacy.net](https://metrics.torproject.org/rs.html#search/family:18671DE5092C67883BFB2450C3267B92618BEC66)                                                |            0.451 |      0.47 |       0.52 |        12 | 2019-03-16   |
|   15 | [0ED0EA32](https://metrics.torproject.org/rs.html#search/family:0ED0EA324C931CF41CB5272BFB1D015B3D5772A9)                                                             |            0.447 |      0    |       0.75 |         5 | 2017-10-24   |
|   16 | [Hart voor Internetvrijheid &lt;abuse AT hartvoorinter](https://metrics.torproject.org/rs.html#search/family:0485027A0A349D454D978F6C1CECDD29EA17769A)                |            0.439 |      1.47 |       0    |        15 | 2014-04-09   |
|   17 | [24F97F98](https://metrics.torproject.org/rs.html#search/family:24F97F98C45E4754655BE66799049763DAEE99CE)                                                             |            0.425 |      0    |       0.72 |         5 | 2016-09-06   |
|   18 | [torrelaysaregreat@gmail.com](https://metrics.torproject.org/rs.html#search/family:12B1A5769D38FF47CF68C2235E1BDA315DF400F2)                                          |            0.413 |      0.05 |       0.6  |        33 | 2018-08-28   |
|   19 | [BMTY90VKYRQPUJZOTH @ Safe-mail.net](https://metrics.torproject.org/rs.html#search/family:02648F2F135C7296A27B1F59D2AE4EEC25D9A877)                                   |            0.412 |      0.04 |       0.59 |        39 | 2019-02-23   |
|   20 | [abuse-node49 AT posteo DOT de](https://metrics.torproject.org/rs.html#search/family:01B70C7C497FC8667DB5EB82C40D8F9214D6A484)                                        |            0.407 |      0.62 |       0.36 |        20 | 2017-01-06   |
|   21 | [https://www.digitale-gesellschaft.ch/abuse/](https://metrics.torproject.org/rs.html#search/family:0111BA9B604669E636FFD5B503F382A4B7AD6E80)                          |            0.393 |      1.31 |       0    |        13 | 2015-05-22   |
|   22 | [TNinja &lt;abuse-team at tor dot ninja&gt;](https://metrics.torproject.org/rs.html#search/family:615ABEA2DE76EB3760BC51E7306BAA59F15CD8F2)                           |            0.362 |      1.21 |       0    |         4 | 2014-10-08   |
|   23 | [63540827](https://metrics.torproject.org/rs.html#search/family:63540827C4832D214984EA47B7A68C593F9F862F)                                                             |            0.361 |      0    |       0.61 |         2 | 2018-12-12   |
|   24 | [Gijs Rijnders tor AT ip-eend DOT nl](https://metrics.torproject.org/rs.html#search/family:6DFEB41C04CCE846871338E85DD5ACF5CFB6C1DD)                                  |            0.361 |      0    |       0.61 |         3 | 2015-04-22   |
|   25 | [&lt;zwiebeln at online de&gt; please donate BTC 1K38x9xq](https://metrics.torproject.org/rs.html#search/family:1617A702B30320C37A5C9FA3CFB737A2AFA9198D)             |            0.354 |      1.13 |       0.02 |        21 | 2016-11-12   |
|   26 | [Peter Gerber &lt;tor@arbitrary.ch&gt;](https://metrics.torproject.org/rs.html#search/family:3F43D0584A2613C9DB631382FF486DC6B95EA1C8)                                |            0.292 |      0    |       0.49 |         8 | 2019-01-20   |
|   27 | [tech@emeraldonion.org](https://metrics.torproject.org/rs.html#search/family:09DCA3360179C6C8A5A20DDDE1C54662965EF1BA)                                                |            0.287 |      0.94 |       0    |        37 | 2019-04-05   |
|   28 | [GTor &lt;contact AT gtor DOT org&gt;](https://metrics.torproject.org/rs.html#search/family:0745857B06337B7F343635608975972A9EC14901)                                 |            0.275 |      0    |       0.46 |         8 | 2020-03-04   |
|   29 | [KeFF NOC &lt;noc AT keff dot org&gt;](https://metrics.torproject.org/rs.html#search/family:036EFD2E61DEA3D2FEE59861BA4245E4DE864112)                                 |            0.248 |      0.83 |       0    |        10 | 2020-07-28   |
|   30 | [see https://www.artikel5ev.de/torcontact/](https://metrics.torproject.org/rs.html#search/family:0BC8BA32CC3CB0F598E0C92778F7C0946DFBCE91)                            |            0.248 |      0.6  |       0.1  |        18 | 2014-06-09   |
|   31 | [tor a rofl.cat - 17bD7EWsSXrqrqk2ibbprPxhegMqecsaC](https://metrics.torproject.org/rs.html#search/family:04E3B5925EB5F66C6EC810A3D7702E0CA3F9D5E7)                   |            0.247 |      0    |       0.32 |        11 | 2016-05-31   |
|   32 | [0x02225522 Frenn vun der Enn FVDE &lt;info AT enn D](https://metrics.torproject.org/rs.html#search/family:194ED740056DD75140C82FEEB2CDD9099F60284D)                  |            0.244 |      0.82 |       0    |         5 | 2016-01-22   |
|   33 | [Jimmy McNulty &lt;trusting.mcnulty AT protonmail.com&gt;](https://metrics.torproject.org/rs.html#search/family:0515C09FF6F72644B922C8D99128489FA53BA1FC)             |            0.24  |      0.14 |       0.27 |        15 | 2019-12-01   |
|   34 | [tor terjan net](https://metrics.torproject.org/rs.html#search/family:20462CBA5DA4C2D963567D17D0B7249718114A68)                                                       |            0.223 |      0    |       0.37 |         7 | 2015-03-05   |
|   35 | [mark@markdmurray.com](https://metrics.torproject.org/rs.html#search/family:0F6E56C326DC9719942E8BBA58C22F71332DA891)                                                 |            0.218 |      0    |       0.37 |         5 | 2020-01-11   |
|   36 | [7A3E534C](https://metrics.torproject.org/rs.html#details/7A3E534C033E3836BD5AF223B642853C502AB33A)                                                                   |            0.217 |      0    |       0.36 |         1 | 2019-04-16   |
|   37 | [tor@kyouma.net](https://metrics.torproject.org/rs.html#search/family:6E4B0D429CD87AB6C25D72E298294C583FF8BA4A)                                                       |            0.215 |      0    |       0.14 |         2 | 2020-03-30   |
|   38 | [admin@iriseden.eu](https://metrics.torproject.org/rs.html#search/family:005079A42356183CEA5A3ADD239303F44F12E7EA)                                                    |            0.214 |      0    |       0.36 |         2 | 2020-05-13   |
|   39 | [DFRI &lt;tor AT dfri dot se&gt; - 1Muz37TfXVBiJKRJkAqTNo](https://metrics.torproject.org/rs.html#search/family:185663B7C12777F052B2C2D23D7A239D8DA88A0F)             |            0.214 |      0.36 |       0.17 |         7 | 2010-02-17   |
|   40 | [Tor Admin &lt;tor at cantersecure dot net&gt;](https://metrics.torproject.org/rs.html#search/family:01384A5D9C6D34352701BF86D04E5F406CB256AE)                        |            0.212 |      0    |       0.36 |         4 | 2020-04-22   |
|   41 | [poiuty@protonmail.com](https://metrics.torproject.org/rs.html#details/F6740DEABFD5F62612FA025A5079EA72846B1F67)                                                      |            0.212 |      0    |       0.36 |         1 | 2016-01-26   |
|   42 | [0x9F29C15D42A8B6F3 Nos oignons &lt;adminsys@nos-oigno](https://metrics.torproject.org/rs.html#search/family:2AB6F7D59DF6153F4DB1DB6479C3422F5724C4BA)                |            0.21  |      0.7  |       0    |         8 | 2014-04-08   |
|   43 | [9DA672F4](https://metrics.torproject.org/rs.html#search/family:9DA672F46D0AD9BA59B2FA56A8F343D38C78BF4C)                                                             |            0.208 |      0    |       0.12 |         3 | 2019-12-24   |
|   44 | [8358BDDA](https://metrics.torproject.org/rs.html#details/8358BDDA9C9A680B4E3A2809E5C24F5B3624D5C2)                                                                   |            0.205 |      0    |       0.34 |         1 | 2020-01-07   |
|   45 | [3F65766A](https://metrics.torproject.org/rs.html#search/family:3F65766ADE067D9D08920E3B74DAB9040EDD26B2)                                                             |            0.203 |      0    |       0.34 |         6 | 2014-06-06   |
|   46 | [AE95BDA3](https://metrics.torproject.org/rs.html#details/AE95BDA37A5BB4685FEBB7F06649D6CE949B5316)                                                                   |            0.201 |      0    |       0.34 |         1 | 2018-12-11   |
|   47 | [wafflecluster837 at elude dot in](https://metrics.torproject.org/rs.html#search/family:2AB708BBC2D52C783F9FC821F7CA8E51A2CFBA98)                                     |            0.199 |      0.66 |       0    |         5 | 2020-02-20   |
|   48 | [runtime-error at riseup dot net](https://metrics.torproject.org/rs.html#search/family:4C5B8134341E66CB09246985E4039F9BFC0ADCE3)                                      |            0.199 |      0    |       0.33 |         5 | 2019-07-01   |
|   49 | [0x4F8ACED4 Marcel Menzel &lt;mail@typhoon31.de&gt;](https://metrics.torproject.org/rs.html#search/family:93F4DAF4F0DE5E6867CE20A0F9C7C059834DACAE)                   |            0.199 |      0    |       0.33 |         3 | 2018-02-05   |
|   50 | [Bauruine &lt;torcontact aatt tuxli.ch&gt; - 1CVkdZfRGWXE](https://metrics.torproject.org/rs.html#search/family:322C6E3A973BC10FC36DE3037AD27BC89F14723B)             |            0.195 |      0    |       0.33 |         6 | 2014-04-09   |
|   51 | [tor@niij.dev](https://metrics.torproject.org/rs.html#search/family:0B85617241252517E8ECF2CFC7F4C1A32DCD153F)                                                         |            0.194 |      0    |       0.33 |         3 | 2014-06-06   |
|   52 | [99339F3E](https://metrics.torproject.org/rs.html#details/99339F3E68BCCC1391BF14C821D80766FE0C5956)                                                                   |            0.193 |      0    |       0.32 |         1 | 2018-10-23   |
|   53 | [B0430D21](https://metrics.torproject.org/rs.html#details/B0430D21D6609459D141078C0D7758B5CA753B6F)                                                                   |            0.193 |      0.64 |       0    |         1 | 2020-04-12   |
|   54 | [&lt;tor-contactREMOVEME AT t4cc0.re&gt; GPG: 0x3AFF3AB49](https://metrics.torproject.org/rs.html#search/family:5C8B811887778DCF705F3D39F19E40A21889451F)             |            0.191 |      0    |       0.32 |         5 | 2016-12-13   |
|   55 | [exitno@elude.in](https://metrics.torproject.org/rs.html#search/family:48D934E776B739D38F9EAFDCFD85203C6A68A67B)                                                      |            0.175 |      0.58 |       0    |         9 | 2020-08-06   |
|   56 | [rwf@listes.epfl.ch](https://metrics.torproject.org/rs.html#search/family:015B7DCBD1F7F84342F5E9E6EB3CA8FBEFCB440E)                                                   |            0.171 |      0    |       0.29 |         2 | 2020-06-26   |
|   57 | [tor-relay-operator AT posteo DOT de](https://metrics.torproject.org/rs.html#search/family:A08B3E65331F29C960A8EB6F5D90B66A05D26CB5)                                  |            0.171 |      0    |       0.29 |         2 | 2019-10-03   |
|   58 | [tor@fboehm.de](https://metrics.torproject.org/rs.html#details/F8DE8132E599A194E20DDB738AF64A7200CD5949)                                                              |            0.171 |      0    |       0.29 |         1 | 2018-10-19   |
|   59 | [5DB9AE27](https://metrics.torproject.org/rs.html#details/5DB9AE27A44EB7B476CC04A66C67A71C97A001E6)                                                                   |            0.169 |      0    |       0.28 |         1 | 2017-10-02   |
|   60 | [&lt;tor AT quadhead.de&gt;](https://metrics.torproject.org/rs.html#details/BF0FB582E37F738CD33C3651125F2772705BB8E8)                                                 |            0.169 |      0    |       0.28 |         1 | 2015-01-19   |
|   61 | [tor-abuse&lt;at&gt;mailbox&lt;dot&gt;org](https://metrics.torproject.org/rs.html#search/family:2BB85DC5BD3C6F0D81A4F2B5882176C6BF7ECF5A)                             |            0.165 |      0.33 |       0.11 |         5 | 2019-02-13   |
|   62 | [&lt;TotorBE AT gmail DOT com&gt;](https://metrics.torproject.org/rs.html#search/family:25990FC54D7268C914170A118EE4EE75025451DA)                                     |            0.163 |      0    |       0.27 |         5 | 2016-10-22   |
|   63 | [replace the y with an x at the beginning of the ad](https://metrics.torproject.org/rs.html#search/family:27F606BEF6588E544C6EFD220244F3E938583505)                   |            0.163 |      0    |       0.13 |        10 | 2020-05-27   |
|   64 | [Mighty Wang &lt;wang AT mighty dot wang&gt;](https://metrics.torproject.org/rs.html#details/9B2BC7EFD661072AFADC533BE8DCF1C19D8C2DCC)                                |            0.163 |      0    |       0.27 |         1 | 2019-11-25   |
|   65 | [hfj at ru dot de](https://metrics.torproject.org/rs.html#search/family:223F4E3F6557A83850C80F0C601732632C64CD00)                                                     |            0.159 |      0.53 |       0    |         5 | 2020-08-02   |
|   66 | [727AA0C6](https://metrics.torproject.org/rs.html#details/727AA0C630F5F548BB48F36069F2179496682875)                                                                   |            0.155 |      0.52 |       0    |         1 | 2020-02-09   |
|   67 | [&lt;tor AT nothingtohide DOT nl&gt;](https://metrics.torproject.org/rs.html#search/family:21E54A1CB86144A4CAF60C636227ABB3D23C30D0)                                  |            0.154 |      0    |       0.26 |         4 | 2020-06-17   |
|   68 | [Malekal morte &lt;mailling at malekal.com&gt;](https://metrics.torproject.org/rs.html#search/family:834C91DEEB2FE4FEFCE55A99C378968FB659115C)                        |            0.152 |      0    |       0.25 |         2 | 2019-06-14   |
|   69 | [tor-operator@privateinternetaccess.com](https://metrics.torproject.org/rs.html#search/family:3F62F05E859D7F98B086F702A31F7714D566E49A)                               |            0.151 |      0.5  |       0    |         5 | 2018-12-11   |
|   70 | [Nurtic-Vibe &lt;nurtic-vibe AT grmml DOT eu&gt;](https://metrics.torproject.org/rs.html#search/family:021DDCD687FD505B7EA7E75DA6CEF0D778AA07FB)                      |            0.149 |      0    |       0.25 |         3 | 2016-02-01   |
|   71 | [Emil Pfeffer &lt;user :: bsdtor&gt;](https://metrics.torproject.org/rs.html#search/family:2A8D8F430B2947D1F00CC776A628C972356BAC09)                                  |            0.148 |      0    |       0.25 |         2 | 2020-04-22   |
|   72 | [BM-NC1tprv7dowcPG7swdLR1ZY5YCKZeBjq; 1LAD57ofZsVUJ](https://metrics.torproject.org/rs.html#search/family:547E6E68ADE1B6F492C44443588A939610401DFB)                   |            0.148 |      0.05 |       0.22 |         4 | 2017-06-19   |
|   73 | [enigma aet s0ny d0t net](https://metrics.torproject.org/rs.html#details/42B4F52C5B11E4D39855F654955425B0D5A0598B)                                                    |            0.145 |      0    |       0.24 |         1 | 2017-02-13   |
|   74 | [1Jwjq2AGPua8urdfZXtSbEQCKBQWF34qew ronstorabuse a](https://metrics.torproject.org/rs.html#details/64E257D94E739278D5954CC820C9D7EAC4E7A7B7)                          |            0.145 |      0    |       0.24 |         1 | 2020-01-06   |
|   75 | [7C22E89A](https://metrics.torproject.org/rs.html#details/7C22E89AB620E77DF1B4A33787A5EC3F2AB4A8D1)                                                                   |            0.145 |      0    |       0.24 |         1 | 2019-01-08   |
|   76 | [email: torchat@gmx.net](https://metrics.torproject.org/rs.html#details/F5F4019509109A07E90C45A022CEED9ECA1643C8)                                                     |            0.143 |      0    |       0.24 |         1 | 2020-01-08   |
|   77 | [&lt;KienjochDE2Info&gt; contact at torrelay dot de](https://metrics.torproject.org/rs.html#search/family:165532BF5B1A34DF60D74375409D632D6FBEF83F)                   |            0.141 |      0    |       0.24 |         8 | 2020-03-06   |
|   78 | [contact at SilSte on Twitter tor-relay.co](https://metrics.torproject.org/rs.html#details/1CD48F4ED0F1821FFBF1940802A13EEFD4C27502)                                  |            0.141 |      0    |       0.24 |         1 | 2019-04-13   |
|   79 | [Random Person &lt;gbe@v--o pbz rot13 &gt;](https://metrics.torproject.org/rs.html#details/4FF53BC47097B50DA5B68D72C5B25CC079F4A787)                                  |            0.141 |      0    |       0    |         1 | 2020-01-21   |
|   80 | [Alexander Faeroey &lt;ahf@0x90.dk&gt; 0x61A208E16E7CB43](https://metrics.torproject.org/rs.html#search/family:303509AB910EF207B7438C27435C4A2FD579F1B1)              |            0.14  |      0    |       0.23 |         2 | 2018-11-07   |
|   81 | [matrixrevolution at secmail dot pro tor-relay.co](https://metrics.torproject.org/rs.html#details/0117D6DA66BB4E528DC7B8B9DFED98180FE7BB12)                           |            0.136 |      0.45 |       0    |         1 | 2020-07-13   |
|   82 | [hfj at ru dot de](https://metrics.torproject.org/rs.html#search/family:15FD9187ED210CDE1AD40475D305A9137F0F5959)                                                     |            0.136 |      0.45 |       0    |         5 | 2020-07-20   |
|   83 | [Mara Sophie Grosch &lt;fox AT lf-net dot org&gt;](https://metrics.torproject.org/rs.html#details/708A968F3644F8A547156368FEA3DB664110E631)                           |            0.136 |      0    |       0.23 |         1 | 2019-03-05   |
|   84 | [0xA3FACB7FAADD6149 likcoras &lt;likcoras at riseup.ne](https://metrics.torproject.org/rs.html#details/82ED9AEC94184EC6DD299A5CDB3378B04BB17489)                      |            0.135 |      0    |       0.22 |         1 | 2019-12-14   |
|   85 | [1Q5fZnsG5BSizXmJbrq8FsACnd6kSTBju7](https://metrics.torproject.org/rs.html#details/DA8D76F5F5819693B5C96F499BA19F7404014769)                                         |            0.135 |      0    |       0.22 |         1 | 2017-04-22   |
|   86 | [noemail@email.com](https://metrics.torproject.org/rs.html#details/0C6D3655763B1A3A60FC42135CD60765AFE953BA)                                                          |            0.134 |      0    |       0.22 |         1 | 2020-04-19   |
|   87 | [tor.spam@oya.to uenostation52.tor@oya.to](https://metrics.torproject.org/rs.html#search/family:13EE0E14C6A2751633138277C1443A4C37DD55D4)                             |            0.134 |      0    |       0.22 |         8 | 2018-01-27   |
|   88 | [tontu &lt;at&gt; nisse dot xyz tor-relay.co](https://metrics.torproject.org/rs.html#details/66BD39FE805AED414ADE400CAAD862C9CC3AC34E)                                |            0.132 |      0    |       0.22 |         1 | 2020-04-29   |
|   89 | [donate@ 1Md8y73vhQD2rMSk99XGb6oj4Acwh1sB9U contact](https://metrics.torproject.org/rs.html#details/91517F219F7648E4B8BBF3C162C77DDC55315612)                         |            0.132 |      0    |       0.22 |         1 | 2020-02-04   |
|   90 | [v0lkovbagdan@yandex.ru](https://metrics.torproject.org/rs.html#details/BE9B12FAAB7429842D643E2308390ECD8961E0A1)                                                     |            0.132 |      0    |       0.22 |         1 | 2020-01-03   |
|   91 | [admin &lt;jeefersyeet@protonmail.ch&gt;](https://metrics.torproject.org/rs.html#details/E3D61BAEA0B7CB12CACEDC8821C520557BDFCEA3)                                    |            0.132 |      0    |       0.22 |         1 | 2020-01-05   |
|   92 | [Alexander Kuehrmann &lt;mail att kuehrmann.de&gt;](https://metrics.torproject.org/rs.html#search/family:24B1DF80768332990BA8F1230BA41D95D82D52BD)                    |            0.131 |      0    |       0.22 |         3 | 2016-12-16   |
|   93 | [toomanynodes abuse &lt;ruben at delegao.moe&gt;](https://metrics.torproject.org/rs.html#search/family:7C86C73DB17CE20CD26537C9E3EC0FD7A55E5C6D)                      |            0.131 |      0    |       0.22 |         2 | 2019-02-24   |
|   94 | [pastly](https://metrics.torproject.org/rs.html#search/family:085527CBD6485FD475AC983FA8683A2D9028BAA8)                                                               |            0.13  |      0    |       0.22 |         3 | 2019-06-10   |
|   95 | [34979DBD](https://metrics.torproject.org/rs.html#search/family:34979DBD475FFED9CF6556E349DDEDEE69104345)                                                             |            0.129 |      0    |       0.22 |         2 | 2019-03-07   |
|   96 | [exitno@elude.in](https://metrics.torproject.org/rs.html#search/family:0C78C13071DB97EE3A53421F2B4AA77FE2328E7D)                                                      |            0.128 |      0.43 |       0    |         5 | 2020-05-22   |
|   97 | [Logforme &lt;m7527 AT abc dot se&gt;](https://metrics.torproject.org/rs.html#search/family:855BC2DABE24C861CD887DB9B2E950424B49FC34)                                 |            0.128 |      0    |       0.21 |         2 | 2014-04-08   |
|   98 | [&lt;pierrestorrelay1 AT countermail dot com&gt;](https://metrics.torproject.org/rs.html#details/14D57DEDF0A4554A2D21AD53CCCC43E31158C733)                            |            0.126 |      0    |       0.21 |         1 | 2020-01-09   |
|   99 | [Kenan Sulayman &lt;kenan@sly.mn&gt;](https://metrics.torproject.org/rs.html#search/family:38A42B8D7C0E6346F4A4821617740AEE86EA885B)                                  |            0.125 |      0.41 |       0    |         2 | 2015-02-02   |
|  100 | [23376937](https://metrics.torproject.org/rs.html#details/233769371C3C59E733CF63D5C5939AFE5ECF239C)                                                                   |            0.123 |      0.41 |       0    |         1 | 2020-06-22   |
|  101 | [E81993EA](https://metrics.torproject.org/rs.html#details/E81993EA52B73285CFFD02FEC003569D21483001)                                                                   |            0.123 |      0    |       0.2  |         1 | 2019-08-07   |
|  102 | [03910F28](https://metrics.torproject.org/rs.html#details/03910F285A33F365838EC66EF2C2EF754D046760)                                                                   |            0.122 |      0    |       0.2  |         1 | 2019-09-06   |
|  103 | [tor@homwer.com](https://metrics.torproject.org/rs.html#details/43C83536DACCD110FF11E049A890064F6F87BEB2)                                                             |            0.122 |      0    |       0.2  |         1 | 2019-03-30   |
|  104 | [E46C3F05](https://metrics.torproject.org/rs.html#details/E46C3F0533709EE2112874B13A4FE3868B33E75E)                                                                   |            0.122 |      0    |       0.2  |         1 | 2020-04-21   |
|  105 | [AA91B0A7](https://metrics.torproject.org/rs.html#details/AA91B0A7930A19EF0D305D14CD6378BADE3A781A)                                                                   |            0.12  |      0.4  |       0    |         1 | 2020-07-05   |
|  106 | [B74DABBE](https://metrics.torproject.org/rs.html#details/B74DABBE248B935CDC1038CD5C9280878C8C94E7)                                                                   |            0.12  |      0    |       0.2  |         1 | 2020-01-07   |
|  107 | [jeremy &lt;jeremytorrelay@yandex.com&gt;](https://metrics.torproject.org/rs.html#details/CDAF0B74C45FD5B1955198A8D92C8A518A53D07B)                                   |            0.12  |      0    |       0.2  |         1 | 2019-12-22   |
|  108 | [noc AT ulayer.net](https://metrics.torproject.org/rs.html#search/family:3CFAD0798FF5D3B994F40B8971D4A79D84165A0D)                                                    |            0.118 |      0    |       0.13 |         9 | 2019-11-05   |
|  109 | [tor &lt;hatesmann@tutanota.com&gt;](https://metrics.torproject.org/rs.html#details/9A48EC8AAFB2E8C9E20408596383DB74F1196747)                                         |            0.118 |      0    |       0.2  |         1 | 2020-01-12   |
|  110 | [tor@setsun.org](https://metrics.torproject.org/rs.html#details/2AA5F598F9A1812F01CD99E3B59BB87362ED7438)                                                             |            0.117 |      0    |       0.19 |         1 | 2019-12-27   |
|  111 | [atomcats dot tor dot relay at gmail dot com tor-re](https://metrics.torproject.org/rs.html#details/9AB93B5422149E5DFF4BE6A3814E2F6D9648DB6A)                         |            0.117 |      0    |       0.19 |         1 | 2018-11-02   |
|  112 | [088A6237](https://metrics.torproject.org/rs.html#details/088A6237EED87EDEB0E1E3AD0A4A419F963F0787)                                                                   |            0.116 |      0    |       0.19 |         1 | 2019-08-12   |
|  113 | [hopeforabetterworld &lt;at&gt; tor.rndsh &lt;dot&gt; it](https://metrics.torproject.org/rs.html#search/family:20E0DD3AD266195F4620E8334B4CF7F51A3F210D)              |            0.116 |      0    |       0.15 |         9 | 2018-02-26   |
|  114 | [&lt;nisos-tor a t protonmail d0t com&gt;](https://metrics.torproject.org/rs.html#details/7FA3FA525901A91A1310B817943668BC2C16289E)                                   |            0.116 |      0    |       0.19 |         1 | 2019-12-07   |
|  115 | [CD39C258](https://metrics.torproject.org/rs.html#details/CD39C258265B25EAA4ABA4FDCB2DF98104CAA362)                                                                   |            0.116 |      0    |       0.19 |         1 | 2019-07-08   |
|  116 | [EE010EF8](https://metrics.torproject.org/rs.html#details/EE010EF80A27AC0B02CDC2B8B214A6201BB02D2B)                                                                   |            0.116 |      0    |       0.19 |         1 | 2016-03-28   |
|  117 | [freedomfortor@yandex.com](https://metrics.torproject.org/rs.html#details/FB016E16B8CD7A0E53DEEF31ED8754E4F6B8E837)                                                   |            0.116 |      0    |       0.19 |         1 | 2020-01-15   |
|  118 | [Thomas Steen Rasmussen / Tykling &lt;thomas@gibfest.d](https://metrics.torproject.org/rs.html#search/family:38CC95A8CE92A591D4A5779359BEFFBA13FA1B88)                |            0.115 |      0    |       0.19 |         3 | 2016-01-03   |
|  119 | [orenom@tutanota.com](https://metrics.torproject.org/rs.html#search/family:4A60B05738087419BFF41A41D2059873EE16E1E9)                                                  |            0.114 |      0    |       0    |         3 | 2020-07-12   |
|  120 | [you're assumin' imma human](https://metrics.torproject.org/rs.html#details/4E98AA295B7171996D18DD1F6A19F64AB4036B4A)                                                 |            0.113 |      0    |       0.19 |         1 | 2018-12-31   |
|  121 | [C63110BD](https://metrics.torproject.org/rs.html#details/C63110BDD8736D2C2A733FF962F58D58FDE63A2D)                                                                   |            0.113 |      0    |       0.19 |         1 | 2019-11-26   |
|  122 | [torrelay mirror@gmx.ch](https://metrics.torproject.org/rs.html#details/58F3E2956EABB81F673E2FB90E16E001DB4AC3AE)                                                     |            0.112 |      0    |       0    |         1 | 2018-09-05   |
|  123 | [random@anonymous.name](https://metrics.torproject.org/rs.html#details/0085057C17BD2E1809E284825F06F94E72FB418C)                                                      |            0.111 |      0    |       0.18 |         1 | 2019-12-24   |
|  124 | [Orkan Guendogdu &lt;orkang95@gmail.com&gt;](https://metrics.torproject.org/rs.html#search/family:47175EA5C1B830AD72F2ED14C089B443758376E1)                           |            0.111 |      0    |       0.18 |         2 | 2019-03-16   |
|  125 | [https://schulz.com.de/contact/?addr=buttercup](https://metrics.torproject.org/rs.html#details/A99B0D9E5FD5BC3C8F2D006EC91F8C7F40E09CB8)                              |            0.111 |      0    |       0.18 |         1 | 2018-12-22   |
|  126 | [avaet1iriejai9duv6aj at gmail dot com tor-relay.c](https://metrics.torproject.org/rs.html#search/family:101C18886B30BB23B36CBAAD159261188852E112)                    |            0.11  |      0    |       0.18 |         4 | 2019-08-31   |
|  127 | [0x88888888 Ole Tange &lt;ole@tange.dk&gt;](https://metrics.torproject.org/rs.html#search/family:547C1CDB516798EC66A01F04A5884DCE1A151919)                            |            0.109 |      0    |       0.18 |         2 | 2014-05-04   |
|  128 | [michaeljones7078@gmail](https://metrics.torproject.org/rs.html#search/family:9063C7EC4A3273446DC05E9310A5C5B2F4235696)                                               |            0.108 |      0    |       0.18 |         3 | 2018-01-05   |
|  129 | [AA11E2CD](https://metrics.torproject.org/rs.html#details/AA11E2CD9E3693D47DC2A9D4A8F007F2AE0449FF)                                                                   |            0.108 |      0.36 |       0    |         1 | 2020-06-27   |
|  130 | [645C3F05](https://metrics.torproject.org/rs.html#details/645C3F0545E0975A49F69EC272C0C3EA28586825)                                                                   |            0.106 |      0    |       0.18 |         1 | 2018-12-21   |
|  131 | [TheEpTic &lt;torrelay@eptic.me&gt; - BTC: 18HoXqpoVicNs5](https://metrics.torproject.org/rs.html#details/77A56CB237740E24AEA2D61C8C8936232AFC1BD8)                   |            0.106 |      0    |       0.18 |         1 | 2018-04-23   |
|  132 | [email:replace-k-with-c-in-kontakt@zwiebeltoralf.de](https://metrics.torproject.org/rs.html#search/family:509EAB4C5D10C9A9A24B4EA0CE402C047A2D64E6)                   |            0.105 |      0    |       0.17 |         2 | 2018-10-06   |
|  133 | [Larry - notevil@memeware.net](https://metrics.torproject.org/rs.html#details/5F58E9417DF94A66529864FA1134635614958A44)                                               |            0.105 |      0    |       0.17 |         1 | 2019-12-21   |
|  134 | [&lt;roger fillipo&gt; rodger.fillipo@mail.com](https://metrics.torproject.org/rs.html#details/D8A2D0080B0C73E1DC0EC9F33B497F64E5FB3F52)                              |            0.105 |      0    |       0.17 |         1 | 2016-02-03   |
|  135 | [flowjob at protonmail dot ch](https://metrics.torproject.org/rs.html#search/family:DD0AA66DD9E4E71FFAFAB658DF8300F1CEEA0364)                                         |            0.105 |      0    |       0.17 |         2 | 2019-05-28   |
|  136 | [toreden@delroth.net](https://metrics.torproject.org/rs.html#search/family:207AB36233C684A88C549ACF766A8D268CB4F796)                                                  |            0.104 |      0    |       0.17 |         3 | 2018-10-13   |
|  137 | [2CE9BE1F](https://metrics.torproject.org/rs.html#details/2CE9BE1FC88B9D0FA03F387C9E4F000B5D4B2AE9)                                                                   |            0.104 |      0    |       0.17 |         1 | 2019-05-03   |
|  138 | [BTC: 1JAvmaekY24JnKZ4f3vVCVjfGCTkXz3Y1R freed00m@](https://metrics.torproject.org/rs.html#details/81E18725397D620DA548ABBE24D9CD263DEF2FDC)                          |            0.103 |      0    |       0.17 |         1 | 2020-01-28   |
|  139 | [D5C6F62A](https://metrics.torproject.org/rs.html#details/D5C6F62A5D1B3C711CA5E6F9D3772A432E96F6C2)                                                                   |            0.103 |      0    |       0.17 |         1 | 2019-01-13   |
|  140 | [1C586E3B](https://metrics.torproject.org/rs.html#details/1C586E3B03FE3A9C9A3EE9C1C83F713024B0F94F)                                                                   |            0.102 |      0.34 |       0    |         1 | 2020-06-25   |
|  141 | [twitter @currentlane](https://metrics.torproject.org/rs.html#details/44DC23661E05DEFD94398936D9334987ABCB6E5E)                                                       |            0.102 |      0    |       0    |         1 | 2016-12-09   |
|  142 | [Hans Wurscht &lt;tor.f00.ch&gt;](https://metrics.torproject.org/rs.html#details/A3AFBDEE30238E44899C9F8B7666D12B09C8EE32)                                            |            0.102 |      0    |       0.17 |         1 | 2019-08-06   |
|  143 | [tesstickler@protonmail.ch](https://metrics.torproject.org/rs.html#details/A597AC866E40CAB5A67759ADE4942192E99DE684)                                                  |            0.102 |      0    |       0.17 |         1 | 2020-01-21   |
|  144 | [BDCC8DD6](https://metrics.torproject.org/rs.html#details/BDCC8DD65722953D25AE15B312A900BB1CA3C4DD)                                                                   |            0.102 |      0.34 |       0    |         1 | 2020-06-23   |
|  145 | [Tor4ThePeople3 email:erantor3 sandler.co.il gpg:](https://metrics.torproject.org/rs.html#search/family:CEACA34874EAD103D27CA6A7650B16112F12B209)                     |            0.102 |      0.34 |       0    |         2 | 2016-11-02   |
|  146 | [donate kindly BTC 1AAqa64myANQV3Zv62jrrzSAmhaDUDXj](https://metrics.torproject.org/rs.html#details/FE1AF5E909002134BFF834F4AD5E1DE723779002)                         |            0.102 |      0    |       0.17 |         1 | 2019-12-29   |
|  147 | [London Privacy Foundation &lt;priv4london@protonmail.](https://metrics.torproject.org/rs.html#details/1C8B3C3D8BC705883B7799C915B2FE1E0FEB006F)                      |            0.101 |      0    |       0.17 |         1 | 2020-03-22   |
|  148 | [2FFE5FAF](https://metrics.torproject.org/rs.html#details/2FFE5FAF70D20E76B0474AE9E40C2A0B53F8D9F0)                                                                   |            0.101 |      0    |       0.17 |         1 | 2020-01-09   |
|  149 | [epstor at protonmail dot com](https://metrics.torproject.org/rs.html#details/3BAACE149DB31574B327BF835B594B707D12CD58)                                               |            0.101 |      0    |       0.17 |         1 | 2020-02-08   |
|  150 | [795790C2](https://metrics.torproject.org/rs.html#details/795790C25BDE834B836EA54DD96DB2610829573B)                                                                   |            0.101 |      0    |       0.17 |         1 | 2020-01-08   |
|  151 | [recipe-acl@mit.edu](https://metrics.torproject.org/rs.html#search/family:8370FC4C190D0020FA594D8232DFE34B5B30AF05)                                                   |            0.101 |      0.34 |       0    |         2 | 2017-04-25   |
|  152 | [athenarelay at protonmail dot com](https://metrics.torproject.org/rs.html#search/family:005ED97213F725867E422B8DC0443361BBB24E3C)                                    |            0.1   |      0.12 |       0    |         4 | 2019-07-05   |
|  153 | [toradmin at night-site dot org](https://metrics.torproject.org/rs.html#details/1C0736CF3744A3B87C2D2269B8BD3388C7E60552)                                             |            0.1   |      0    |       0.17 |         1 | 2015-01-11   |
|  154 | [tor-operator@your-emailaddress-domain](https://metrics.torproject.org/rs.html#search/family:400C053623F36C5C3D1CFC73F1AB9DA6E24DEEB7)                                |            0.1   |      0    |       0.08 |         2 | 2020-04-15   |
|  155 | [jorge &lt;spielman2@gmx.de&gt;](https://metrics.torproject.org/rs.html#details/638D91FC9EF661348A6994D04C3499BC03F50BBE)                                             |            0.1   |      0    |       0.17 |         1 | 2020-01-04   |
|  156 | [1CrJgiGnzMtLuSj3WZrt8yQ94gM1nGtfVo finalspace@420](https://metrics.torproject.org/rs.html#details/8BE79CE3261C027CE94F84D6CBE45F03BE9B8B59)                          |            0.1   |      0    |       0.17 |         1 | 2020-02-06   |
|  157 | [0F89912E](https://metrics.torproject.org/rs.html#details/0F89912E6A4C4A8ACE43C58FF8B83CA299BFF74F)                                                                   |            0.099 |      0    |       0    |         1 | 2019-04-07   |
|  158 | [B7D6A184](https://metrics.torproject.org/rs.html#details/B7D6A18472DF6528C91BDC976D3B25274DEA004E)                                                                   |            0.099 |      0.33 |       0    |         1 | 2020-06-24   |
|  159 | [smitherasyl at yendex dot kz](https://metrics.torproject.org/rs.html#details/CA95B3584C44DED8107AF5B3D8C25C562CC64DD4)                                               |            0.099 |      0    |       0.16 |         1 | 2020-02-03   |
|  160 | [Random Person yvqk4i3b1ziu11f](https://metrics.torproject.org/rs.html#details/FD449127D30D8F5D124653D9EF736EDF4A12B4DC)                                              |            0.099 |      0    |       0.16 |         1 | 2019-01-09   |
|  161 | [dhalgren.tor@gmail.com](https://metrics.torproject.org/rs.html#details/A0F06C2FADF88D3A39AA3072B406F09D7095AC9E)                                                     |            0.098 |      0.32 |       0    |         1 | 2015-08-28   |
|  162 | [fredreic at tutanota dot com](https://metrics.torproject.org/rs.html#details/221546DAE86B003139B13BD6F6AE1B4B42B59DF8)                                               |            0.097 |      0    |       0.16 |         1 | 2019-12-28   |
|  163 | [help keep me running 1M2wWAB71wvaKwcGvBAGZin6PKKeY](https://metrics.torproject.org/rs.html#details/40CDE936B04B4573A47223396006443CA5EAC845)                         |            0.097 |      0    |       0.16 |         1 | 2020-01-30   |
|  164 | [512@gmx.ch tor-relay.co](https://metrics.torproject.org/rs.html#details/672A56A583C658372E63ACEB43E7F791C2819548)                                                    |            0.097 |      0    |       0.16 |         1 | 2019-08-21   |
|  165 | [&lt;lemonsmakelemonade@keemail.me&gt;](https://metrics.torproject.org/rs.html#details/22775B953E662151549C114CB8EE5FBDBCBDAD02)                                      |            0.096 |      0    |       0.16 |         1 | 2020-02-01   |
|  166 | [8705C12F](https://metrics.torproject.org/rs.html#details/8705C12F7831AD0A7BAE6D1988B14310550F3C18)                                                                   |            0.096 |      0.32 |       0    |         1 | 2020-06-05   |
|  167 | [B96B5141](https://metrics.torproject.org/rs.html#details/B96B5141004995295FE87DCCE1A54519BD0BB48A)                                                                   |            0.096 |      0    |       0    |         1 | 2019-07-31   |
|  168 | [D56A98D3](https://metrics.torproject.org/rs.html#details/D56A98D38FC3C75E0347EEF3DD9C12749AF7C7C5)                                                                   |            0.096 |      0    |       0.16 |         1 | 2019-03-01   |
|  169 | [0x9FCDEE9E1A381F311EA62A7404D041E8171901CC Julien](https://metrics.torproject.org/rs.html#search/family:39CF2F22E5018C01FD57DEB1AB8FDFA4592633FB)                    |            0.095 |      0    |       0.13 |         2 | 2020-04-07   |
|  170 | [faust &lt;AT&gt; &lt;faust16 &lt;AT&gt; posteo &lt;dot&gt; org&gt;](https://metrics.torproject.org/rs.html#search/family:3E04505D362AA324E6E4E1C8516CCD9EF4D41B9C)   |            0.095 |      0    |       0.16 |         3 | 2020-04-17   |
|  171 | [sallos a tfwno dot gf](https://metrics.torproject.org/rs.html#details/724E86E7F5DA715529DC0ECAA013AE4BDC680E4C)                                                      |            0.095 |      0    |       0.16 |         1 | 2019-12-22   |
|  172 | [retik.eu &lt;retik@systemli.org&gt;](https://metrics.torproject.org/rs.html#details/014E24C0CD21D2B9829E841D5EC1D3C415F866BF)                                        |            0.094 |      0    |       0.16 |         1 | 2019-01-26   |
|  173 | [Random Person &lt;root AT nldo dot nl&gt;](https://metrics.torproject.org/rs.html#details/4B351545DD58473F36B0A20E5500AC6ED51E8CD5)                                  |            0.094 |      0    |       0.16 |         1 | 2018-02-11   |
|  174 | [Random Person](https://metrics.torproject.org/rs.html#details/62A60158A2C302E3DA792D7A4F5339F41321E5D9)                                                              |            0.094 |      0    |       0.16 |         1 | 2019-12-19   |
|  175 | [712165B4](https://metrics.torproject.org/rs.html#details/712165B4B8C5D17103CE21A689B42AC96909C798)                                                                   |            0.094 |      0.31 |       0    |         1 | 2020-06-26   |
|  176 | [Random Person &lt;nobody AT example dot com&gt;](https://metrics.torproject.org/rs.html#details/890480E14E634C8B4467C475E355A6FBF3D99CD5)                            |            0.094 |      0    |       0.16 |         1 | 2020-02-11   |
|  177 | [tor at virtual-machine dot org](https://metrics.torproject.org/rs.html#details/CB92FA4D7D71F134CE1F1FFF2BFF53E88DD4A1DB)                                             |            0.094 |      0    |       0.15 |         1 | 2020-08-03   |
|  178 | [0xFFFFFFFF Random Person &lt;nobody AT example dot co](https://metrics.torproject.org/rs.html#search/family:2119E5A4B5F420165BF5DF19A5A28F4610FFD103)                |            0.093 |      0    |       0.15 |         4 | 2018-12-05   |
|  179 | [2CCEC2AA](https://metrics.torproject.org/rs.html#details/2CCEC2AA233B8D8B28430FBDE90F5492204AB185)                                                                   |            0.093 |      0.31 |       0    |         1 | 2020-06-25   |
|  180 | [B9BF7B08](https://metrics.torproject.org/rs.html#details/B9BF7B080696B02C0330BFE556B47EB5354FC263)                                                                   |            0.093 |      0.31 |       0    |         1 | 2020-06-29   |
|  181 | [josefkarls at protonmail dot com tor-relay.co](https://metrics.torproject.org/rs.html#details/CA4E9DFE87DE87E502F3B503D07EC8EFCAEE2549)                              |            0.093 |      0    |       0.15 |         1 | 2019-12-26   |
|  182 | [m@cowpride.com](https://metrics.torproject.org/rs.html#details/E36536404200A74930DB165858BD5BB554D2BEA2)                                                             |            0.093 |      0    |       0.15 |         1 | 2014-07-04   |
|  183 | [Arlen Yaroslav &lt;arlenyaroslav63@protonmail.com&gt;](https://metrics.torproject.org/rs.html#details/09A70E396DE93F54D4541BBB0EC8E2B23761F34F)                      |            0.092 |      0    |       0.15 |         1 | 2019-11-24   |
|  184 | [@jbrps 0x588F6C31 &lt;jonas@rz-k.de&gt;](https://metrics.torproject.org/rs.html#search/family:11ABDB4D0B944F186A898560CB82C70439957DCA)                              |            0.092 |      0    |       0.15 |         2 | 2015-06-22   |
|  185 | [cultrix@protonmail.com](https://metrics.torproject.org/rs.html#search/family:12B3C5C30C92E649B9CE0D313071D9429A8710A2)                                               |            0.092 |      0.27 |       0.01 |         2 | 2020-05-30   |
|  186 | [Michal Krejci &lt;tor@blep.cz&gt; 0xBCFE6E98](https://metrics.torproject.org/rs.html#search/family:2A66F6F650C8B75719F319E38F07E0A52277CD36)                         |            0.092 |      0    |       0.08 |         2 | 2019-10-09   |
|  187 | [josefkarls at protonmail dot com tor-relay.co](https://metrics.torproject.org/rs.html#details/070229A4CC2CFFB24EB667298A7DB5E8D11EB701)                              |            0.091 |      0    |       0.15 |         1 | 2019-12-26   |
|  188 | [366EF8AC](https://metrics.torproject.org/rs.html#details/366EF8ACBECBA63ED0F5CF62F50D16CCE6E9D567)                                                                   |            0.091 |      0.3  |       0    |         1 | 2020-07-17   |
|  189 | [Vanessaspringwood@yandex.com](https://metrics.torproject.org/rs.html#details/42D47C736518BFA495CA31AEE40AE468F0BDA2A6)                                               |            0.091 |      0    |       0.15 |         1 | 2020-07-03   |
|  190 | [xtrempriv@cock.li](https://metrics.torproject.org/rs.html#details/DC9564AE8BC7BF5F722E3677C897ED1B578C8D81)                                                          |            0.091 |      0    |       0.15 |         1 | 2019-12-26   |
|  191 | [tor@muehlbeyer.net](https://metrics.torproject.org/rs.html#details/431702B3A68A6015F9955DD4FD0129175B43EA0F)                                                         |            0.09  |      0    |       0.15 |         1 | 2020-07-07   |
|  192 | [tor@govanify.com](https://metrics.torproject.org/rs.html#details/43FF3346A3F8E4ED27F631DC956C4CD8D6173D7A)                                                           |            0.09  |      0    |       0.15 |         1 | 2018-02-12   |
|  193 | [461D6EA1](https://metrics.torproject.org/rs.html#details/461D6EA15966C7F99B43D37ADC116B5B8E47D130)                                                                   |            0.09  |      0    |       0.15 |         1 | 2017-07-25   |
|  194 | [torContact101pm.me](https://metrics.torproject.org/rs.html#details/930106E732385FD01810AB243E7022C42639BC06)                                                         |            0.09  |      0    |       0.15 |         1 | 2020-07-21   |
|  195 | [Random Person &lt;d.gugana AT gmx dot de&gt;](https://metrics.torproject.org/rs.html#details/F0C9513539800F762ECAE37F16370D7CBA5E52C2)                               |            0.09  |      0    |       0.15 |         1 | 2017-12-17   |
|  196 | [0xFFFFFFFF &lt;tormaster AT kkb-clan dot de&gt;](https://metrics.torproject.org/rs.html#details/3A8557B067FBE53F168BBEAA7D14D1298AE52A52)                            |            0.089 |      0    |       0.15 |         1 | 2017-02-03   |
|  197 | [&lt;Mr. Cha Cha&gt; DoTheChaCha@protonmail.com](https://metrics.torproject.org/rs.html#details/4856C97DC4F2271BC896DF9CABD217EE2D869D68)                             |            0.089 |      0    |       0.15 |         1 | 2016-09-21   |
|  198 | [CEC92F3B](https://metrics.torproject.org/rs.html#details/CEC92F3BE8A2F3A46D3C042721D6BDBF2F40F4C5)                                                                   |            0.089 |      0    |       0    |         1 | 2018-12-30   |
|  199 | [6FF440DF](https://metrics.torproject.org/rs.html#details/6FF440DFB1D0697B942357D747900CC308DD57CC)                                                                   |            0.088 |      0    |       0.15 |         1 | 2017-10-27   |
|  200 | [0x1E7523CA911AC822 Markus Witt &lt;markus.witt@rwth-a](https://metrics.torproject.org/rs.html#details/76D2EBA82BBCCA3DF9F254A9A8372A10A26F3D14)                      |            0.088 |      0    |       0.14 |         1 | 2019-05-01   |
|  201 | [E56921BE](https://metrics.torproject.org/rs.html#details/E56921BEFEB3B79BCDDD3BD9E4936EA6CCE207AF)                                                                   |            0.088 |      0.29 |       0    |         1 | 2020-07-08   |
|  202 | [maxfiedler1988@gmail.com](https://metrics.torproject.org/rs.html#search/family:0516A1A5836825F58848D47B91F47CB593B58D54)                                             |            0.087 |      0    |       0    |        14 | 2019-11-18   |
|  203 | [1E03D81C](https://metrics.torproject.org/rs.html#details/1E03D81C9744DE0E3C9DE6E6FBDF1DF9DAEA5AFC)                                                                   |            0.087 |      0    |       0.14 |         1 | 2019-01-19   |
|  204 | [yourmum &lt;yourmum@airmail.cc&gt;](https://metrics.torproject.org/rs.html#details/44BD70C13DAA7513D6F47773804178B009F21ED5)                                         |            0.086 |      0    |       0.14 |         1 | 2019-12-26   |
|  205 | [technik-lt@uni-due.de](https://metrics.torproject.org/rs.html#details/8ABC4D5F6182C7E79B087D1ED9E5CF652C83E52C)                                                      |            0.086 |      0    |       0.14 |         1 | 2019-05-06   |
|  206 | [StarApps GmbH](https://metrics.torproject.org/rs.html#details/0B19BBFDC498CCEA23027B1D7BD8E20121B95E60)                                                              |            0.085 |      0    |       0    |         1 | 2019-07-15   |
|  207 | [288C100F](https://metrics.torproject.org/rs.html#details/288C100FFA656938C23F32207CAF0DA932ECD247)                                                                   |            0.085 |      0    |       0.14 |         1 | 2019-06-11   |
|  208 | [AD9190B2](https://metrics.torproject.org/rs.html#details/AD9190B2A984696E35FBA420E307F84C4D1D4A5E)                                                                   |            0.085 |      0.28 |       0    |         1 | 2020-07-10   |
|  209 | [tor-relay-contact &lt;at&gt; digitalsquid &lt;dot&gt; co &lt;dot&gt;](https://metrics.torproject.org/rs.html#search/family:4011E1BB0E5B9A22AF665B553BFFDDE22A517B16) |            0.084 |      0    |       0    |         5 | 2020-03-30   |
|  210 | [88748052](https://metrics.torproject.org/rs.html#details/88748052843CC93A02BE1D9E9B5B358AB3A104AA)                                                                   |            0.084 |      0    |       0.14 |         1 | 2019-02-08   |
|  211 | [D80EA216](https://metrics.torproject.org/rs.html#details/D80EA21626BFAE8044E4037FE765252E157E3586)                                                                   |            0.084 |      0    |       0.14 |         1 | 2017-10-27   |
|  212 | [0x59205995C95D108C Sylvain Rager &lt;sylvain at reg](https://metrics.torproject.org/rs.html#details/BD4C647508162F59CB44E4DFC1C2B2B8A9387CCA)                        |            0.083 |      0    |       0.14 |         1 | 2014-03-15   |
|  213 | [fuckcensorchip@airmail.cc](https://metrics.torproject.org/rs.html#details/C1B79C4CD9B713BBB6B0522155B46A7BFE3BFAAE)                                                  |            0.083 |      0    |       0.14 |         1 | 2019-07-11   |
|  214 | [D14EC169](https://metrics.torproject.org/rs.html#details/D14EC16949648CEE84EA1664445029EA4B597074)                                                                   |            0.083 |      0    |       0.14 |         1 | 2020-07-19   |
|  215 | [06ABFC51](https://metrics.torproject.org/rs.html#search/family:06ABFC513FA71C7EE423DCC6ABF80F6B4A2FC1AC)                                                             |            0.082 |      0    |       0.13 |         6 | 2016-03-29   |
|  216 | [slalix@hotmail.com](https://metrics.torproject.org/rs.html#search/family:0F977B4D6EBEECD578AC838A5FDDC81B636060A7)                                                   |            0.082 |      0    |       0.13 |         2 | 2018-05-13   |
|  217 | [1E1A7C91](https://metrics.torproject.org/rs.html#details/1E1A7C9134637383BE653C41973995A229D81595)                                                                   |            0.082 |      0    |       0.13 |         1 | 2019-04-30   |
|  218 | [4EC87AAB](https://metrics.torproject.org/rs.html#details/4EC87AABE9867796D26CD4B1D2A0682401807280)                                                                   |            0.082 |      0    |       0.13 |         1 | 2018-08-07   |
|  219 | [891FB847](https://metrics.torproject.org/rs.html#details/891FB8477529A6B2894B7A3129402E0FD5DD281F)                                                                   |            0.082 |      0    |       0.13 |         1 | 2020-05-26   |
|  220 | [D079D681](https://metrics.torproject.org/rs.html#details/D079D6818926684C5979C18171FB18862A4A5792)                                                                   |            0.082 |      0    |       0.13 |         1 | 2019-01-18   |
|  221 | [778FB039](https://metrics.torproject.org/rs.html#details/778FB0398F74888A2A5E116403DFC74A931EC84B)                                                                   |            0.081 |      0.27 |       0    |         1 | 2020-07-05   |
|  222 | [freeasinbeer@techie.com](https://metrics.torproject.org/rs.html#details/169535CC4C75FF79C6D548D41720064EE4FE61D2)                                                    |            0.08  |      0    |       0.13 |         1 | 2016-07-14   |
|  223 | [1F78D47D](https://metrics.torproject.org/rs.html#details/1F78D47D20BA3ACF9DCE50F4533A5CEA232CF398)                                                                   |            0.08  |      0    |       0    |         1 | 2020-07-11   |
|  224 | [tor at xtracode dot ws](https://metrics.torproject.org/rs.html#search/family:213F2B4AB09EE6FF8CA21B804B2E1BD8835088D3)                                               |            0.08  |      0    |       0.13 |         2 | 2020-04-09   |
|  225 | [aTorRelay@gmail.com](https://metrics.torproject.org/rs.html#search/family:4623A9EC53BFD83155929E56D6F7B55B5E718C24)                                                  |            0.08  |      0    |       0.13 |         3 | 2016-05-23   |
|  226 | [10A5EFCC](https://metrics.torproject.org/rs.html#details/10A5EFCCD2FB9C1A4AC20FB779A5DB11B58957A7)                                                                   |            0.079 |      0    |       0    |         1 | 2020-04-14   |
|  227 | [Random Person &lt;Neotion AT pm dot me&gt;](https://metrics.torproject.org/rs.html#search/family:07905A0D8AD1C134D3036872140B1DB1EB761772)                           |            0.078 |      0    |       0.13 |         5 | 2016-12-10   |
|  228 | [georger.r.martin@writeme.com](https://metrics.torproject.org/rs.html#search/family:1944F3A473CB77B12BDB4E3D15963A24DF58E4E7)                                         |            0.078 |      0    |       0.13 |         5 | 2015-02-11   |
|  229 | [Fabian Keil &lt;fk@fabiankeil.de&gt; 8BA2371C](https://metrics.torproject.org/rs.html#search/family:3D615DEF97F387631F50201FAFA6E7B67FDF3FEF)                        |            0.078 |      0    |       0.04 |         4 | 2015-01-06   |
|  230 | [summertime20@tutanota.com](https://metrics.torproject.org/rs.html#details/3FE39429CB7077BBB13D2774591A1B80EE493742)                                                  |            0.078 |      0    |       0.13 |         1 | 2020-06-29   |
|  231 | [06BBEAA6](https://metrics.torproject.org/rs.html#details/06BBEAA6F73759A1795EB461D39D2AA168F305D1)                                                                   |            0.077 |      0    |       0.13 |         1 | 2019-01-29   |
|  232 | [tor@xmmswap.com 481D B9B8 C259 8D18 04DE FB31 660](https://metrics.torproject.org/rs.html#search/family:62ABC3D1B0D5DE48DE4B8AF5E76D5AA8F535CCDF)                    |            0.077 |      0    |       0.13 |         2 | 2017-12-04   |
|  233 | [Sophie &lt;tor AT 999eagle DOT moe&gt;](https://metrics.torproject.org/rs.html#details/FC1E441E097BA36930AA2F615EFB325AF76D2595)                                     |            0.077 |      0    |       0.13 |         1 | 2020-06-16   |
|  234 | [0B555940](https://metrics.torproject.org/rs.html#details/0B555940D37DC849728841C0B290074E1A1BDCA8)                                                                   |            0.076 |      0    |       0.12 |         1 | 2018-10-02   |
|  235 | [phoenitydawn tor admin &lt;tor@phoenitydawn.de&gt; - 1KW](https://metrics.torproject.org/rs.html#details/3E53D3979DB07EFD736661C934A1DED14127B684)                   |            0.076 |      0    |       0.13 |         1 | 2015-04-28   |
|  236 | [58FC2AAB](https://metrics.torproject.org/rs.html#search/family:58FC2AAB3792AC37897D34331F4F4E00341DEC0C)                                                             |            0.076 |      0    |       0.02 |         4 | 2018-02-04   |
|  237 | [71A05B57](https://metrics.torproject.org/rs.html#details/71A05B576836F54050348AA0D63185B12DBA51E3)                                                                   |            0.076 |      0    |       0.12 |         1 | 2020-05-22   |
|  238 | [E00DFD54](https://metrics.torproject.org/rs.html#details/E00DFD54DC165D5452FBD3530D30186DAD016A0C)                                                                   |            0.076 |      0    |       0.12 |         1 | 2018-12-26   |
|  239 | [Sebastian &lt;tor@sebastianhahn.net&gt; - 12NbRAjAG5U3LL](https://metrics.torproject.org/rs.html#search/family:EBE718E1A49EE229071702964F8DB1F318075FF8)             |            0.076 |      0    |       0.12 |         2 | 2013-12-20   |
|  240 | [cyberbits.eu](https://metrics.torproject.org/rs.html#details/F836446663F1EB816F13708955F105D0B2F5C8E0)                                                               |            0.076 |      0    |       0.13 |         1 | 2020-07-17   |
|  241 | [Random Person &lt;nobody AT example dot com&gt;](https://metrics.torproject.org/rs.html#details/FCD52578ED1DA778B918D3E6B95068542203D20F)                            |            0.076 |      0    |       0    |         1 | 2020-06-25   |
|  242 | [38F21DEE](https://metrics.torproject.org/rs.html#details/38F21DEE29E40DCDF9460A80662B7723562CA008)                                                                   |            0.075 |      0    |       0.12 |         1 | 2018-12-19   |
|  243 | [6DA4AE1A](https://metrics.torproject.org/rs.html#details/6DA4AE1A5C67B26692EC02414080D0FE3D137627)                                                                   |            0.074 |      0.25 |       0    |         1 | 2020-07-18   |
|  244 | [8D20E0D3](https://metrics.torproject.org/rs.html#details/8D20E0D3C7A9D7235334E1C2CCA6BAA26C3F45C9)                                                                   |            0.074 |      0.25 |       0    |         1 | 2020-04-02   |
|  245 | [8EB722FA](https://metrics.torproject.org/rs.html#details/8EB722FA1AE9DDE1914BC21FEA22819D4DE99DB4)                                                                   |            0.074 |      0    |       0.12 |         1 | 2018-12-22   |
|  246 | [Random Person](https://metrics.torproject.org/rs.html#details/461453F94FA0E3CBB011685E22CDAFD2AF0DFDC3)                                                              |            0.073 |      0    |       0.12 |         1 | 2020-07-04   |
|  247 | [6C333B5B](https://metrics.torproject.org/rs.html#details/6C333B5BDBA3DFE7A782E40CB970C271ABFED119)                                                                   |            0.073 |      0    |       0.12 |         1 | 2019-02-11   |
|  248 | [8C5B316E](https://metrics.torproject.org/rs.html#details/8C5B316ED73018484765C3E0944E4508DCAE0944)                                                                   |            0.073 |      0    |       0.12 |         1 | 2019-08-08   |
|  249 | [myrelay&lt;biguptheoj@tutanota.com&gt; 1JQCuaVbbr1TVLj8](https://metrics.torproject.org/rs.html#details/901CBA6FF3B90618D3FFEFF040353C267F690DF8)                    |            0.073 |      0    |       0.12 |         1 | 2020-01-17   |
|  250 | [torrocks at- mailbox&lt;dot=&gt;org](https://metrics.torproject.org/rs.html#details/A4F11D693FAB6E949B2B7C18153C3F7989896007)                                        |            0.073 |      0    |       0.12 |         1 | 2018-11-12   |
|  251 | [&lt;roger fillipo&gt; rodger.fillipo@mail.com](https://metrics.torproject.org/rs.html#details/C5BF27560E4B007365FBA96D32F9E74614218C8E)                              |            0.073 |      0    |       0.12 |         1 | 2015-10-29   |
|  252 | [London Privacy Foundation &lt;priv4london@protonmail.](https://metrics.torproject.org/rs.html#details/D228AE265C966CA4E9A8C4B746A30A9737060A32)                      |            0.073 |      0    |       0.12 |         1 | 2020-03-16   |
|  253 | [JASON jasonenquiries@airmail.cc](https://metrics.torproject.org/rs.html#details/E8BAE7393740A700D50B010DED9D9EC9A66B390D)                                            |            0.073 |      0    |       0.12 |         1 | 2020-01-27   |
|  254 | [florentin aatt rochet ddoott be; LTC: LhRqJZu6U87B](https://metrics.torproject.org/rs.html#search/family:091BB38D8A641014A652A36A8827A9E30EEEA882)                   |            0.072 |      0.24 |       0    |         4 | 2017-07-25   |
|  255 | [1079E628](https://metrics.torproject.org/rs.html#details/1079E628FC6B0025656AC024F2D9975C441498CD)                                                                   |            0.072 |      0    |       0.12 |         1 | 2019-03-05   |
|  256 | [This relay is named after: https://youtu.be/EWp3OH](https://metrics.torproject.org/rs.html#search/family:CC09DFB016081AD50686DAC96440BB2D6F343251)                   |            0.072 |      0    |       0.12 |         3 | 2018-07-02   |
|  257 | [EAA08844](https://metrics.torproject.org/rs.html#details/EAA088440B100FF8407266B5D4853FFB16A8CB67)                                                                   |            0.072 |      0    |       0.12 |         1 | 2019-08-22   |
|  258 | [0xFED4E03C Jan &lt;jan AT wth dot in&gt;](https://metrics.torproject.org/rs.html#search/family:40C773D9F2B16143CDB2ADB661DDC6BB12EF3E2C)                             |            0.071 |      0    |       0.12 |         2 | 2014-01-02   |
|  259 | [Random Person &lt;inode AT wayreth dot eu dot org&gt;](https://metrics.torproject.org/rs.html#details/61B8BDC91AA7BC9A05EB5A3D652FFF88C98E6911)                      |            0.071 |      0    |       0.12 |         1 | 2016-10-09   |
|  260 | [Anon guvhP9HYP7wHFHU87JNkbC@protonmail.com](https://metrics.torproject.org/rs.html#details/8C86D272A75C4942B65D4E3C3A5A7632793D3A95)                                 |            0.071 |      0    |       0.12 |         1 | 2020-06-14   |
|  261 | [x5sj2 at tutanota dot com tor-relay.co](https://metrics.torproject.org/rs.html#details/EC4AD91674B5AFECCA117A396776F120651E55BF)                                     |            0.071 |      0    |       0    |         1 | 2019-05-07   |
|  262 | [torrelay at kieran dot de](https://metrics.torproject.org/rs.html#search/family:00E1649E69FF91D7F01E74A5E62EF14F7D9915E4)                                            |            0.07  |      0    |       0.08 |         3 | 2018-06-18   |
|  263 | [1AE75D51](https://metrics.torproject.org/rs.html#details/1AE75D51DFD93B447B136E110A65D9D76C4A263E)                                                                   |            0.07  |      0.23 |       0    |         1 | 2020-07-02   |
|  264 | [mandalorian.outpost.222@yandex DOT com](https://metrics.torproject.org/rs.html#details/9EA4649400C7D35E20C734FA737CF615E925F1E4)                                     |            0.07  |      0    |       0.12 |         1 | 2015-10-29   |
|  265 | [Henrik Kramshoej &lt;hlk@zencurity.dk&gt;](https://metrics.torproject.org/rs.html#search/family:ACDD9E85A05B127BA010466C13C8C47212E8A38F)                            |            0.07  |      0.04 |       0.09 |         2 | 2016-01-07   |
|  266 | [London Privacy Fdn &lt;priv4london@protonmail.com&gt;](https://metrics.torproject.org/rs.html#details/05B451C0562FDE23307AFA84FD6A37652E615233)                      |            0.069 |      0    |       0.11 |         1 | 2020-04-01   |
|  267 | [tor nortor no](https://metrics.torproject.org/rs.html#search/family:15D832EEAC678EC7EEB27B0F65E0D50B74A43B5B)                                                        |            0.069 |      0.23 |       0    |         4 | 2020-02-21   |
|  268 | [contact at freedominternetnocensorship@protonmail.](https://metrics.torproject.org/rs.html#details/29A39144AD141242436D07901F7A8B91F7516A66)                         |            0.069 |      0    |       0.11 |         1 | 2020-01-14   |
|  269 | [8F58D8DC](https://metrics.torproject.org/rs.html#search/family:8F58D8DC6A96AFE6262FBEFF8741FD4262EBACB4)                                                             |            0.069 |      0    |       0.11 |         3 | 2016-10-29   |
|  270 | [92BBADCB](https://metrics.torproject.org/rs.html#details/92BBADCB0697F5EB1792C607EE2DC1C291A98ADC)                                                                   |            0.069 |      0    |       0.11 |         1 | 2018-09-24   |
|  271 | [Greetings from BungeeCloud &lt;support ATT bungeeclou](https://metrics.torproject.org/rs.html#search/family:E81AE352A41ECB6C1C67A00816A7B22EDE206F01)                |            0.069 |      0.23 |       0    |         2 | 2020-05-28   |
|  272 | [&lt;georg AT bchgang DOT org&gt;](https://metrics.torproject.org/rs.html#search/family:05C621B44EF6833889AE7B7E2A0B476569C47E37)                                     |            0.068 |      0    |       0.11 |         2 | 2019-07-11   |
|  273 | [raltullou@posteo.org](https://metrics.torproject.org/rs.html#search/family:11DF0017A43AF1F08825CD5D973297F81AB00FF3)                                                 |            0.068 |      0    |       0.11 |         2 | 2017-02-13   |
|  274 | [bla at blub dot de tor-relay.co](https://metrics.torproject.org/rs.html#details/36FA576EE55BE5F1297370FBECBBBEB6125BBE4A)                                            |            0.068 |      0    |       0    |         1 | 2020-03-23   |
|  275 | [kl &lt;kl.forwarder@gmail.com&gt; - 1CM1jy87hL9XPAuTpUhQ](https://metrics.torproject.org/rs.html#details/4CD4DFFEF3971C902A22100D911CAC639BE2EF5C)                   |            0.068 |      0    |       0.11 |         1 | 2014-10-17   |
|  276 | [EEDF0AF1](https://metrics.torproject.org/rs.html#details/EEDF0AF1F892C82F056063827B47283CC9AEAA41)                                                                   |            0.068 |      0    |       0.11 |         1 | 2019-01-01   |
|  277 | [0xFFFFFFFF Random Person &lt;nobody AT example dot co](https://metrics.torproject.org/rs.html#details/3F065BB0B02FB2303E144383D16C47A7DED75AE7)                      |            0.067 |      0    |       0.11 |         1 | 2016-05-04   |
|  278 | [torproxy &lt;torproxy AT protonmail dot com&gt;](https://metrics.torproject.org/rs.html#search/family:7BB70F8585DFC27E75D692970C0EEB0F22983A63)                      |            0.067 |      0.17 |       0.02 |         2 | 2016-02-07   |
|  279 | [8EE28EAF](https://metrics.torproject.org/rs.html#details/8EE28EAF0874AF9B03EBBD79B5EB5059E2547355)                                                                   |            0.067 |      0    |       0.11 |         1 | 2018-11-28   |
|  280 | [CBD00958](https://metrics.torproject.org/rs.html#details/CBD00958A3B897774E333D75C24E6A75F5220DCC)                                                                   |            0.066 |      0    |       0.11 |         1 | 2019-01-27   |
|  281 | [D0273C85](https://metrics.torproject.org/rs.html#details/D0273C8566CC9AECE4C762376C9B066FE0F1DADD)                                                                   |            0.066 |      0    |       0.11 |         1 | 2017-11-23   |
|  282 | [tor at seccom dot ch](https://metrics.torproject.org/rs.html#search/family:22A6BE98D201B101C32661739967BF4DED12EF96)                                                 |            0.065 |      0    |       0.11 |         4 | 2019-09-20   |
|  283 | [&lt;roger fillipo&gt; rodger.fillipo@mail.com](https://metrics.torproject.org/rs.html#details/327F5823438B8EC86EC33355C147D8455AB1C14B)                              |            0.065 |      0    |       0.11 |         1 | 2016-02-03   |
|  284 | [mail at nozel . org](https://metrics.torproject.org/rs.html#search/family:539ABCC9AF0FD80278E89457A1663DABAEBF81DD)                                                  |            0.065 |      0    |       0.11 |         2 | 2019-07-20   |
|  285 | [63B32F7E](https://metrics.torproject.org/rs.html#details/63B32F7E5389E8DBC5E1BCEFE48312DA7CCEF5D6)                                                                   |            0.065 |      0    |       0.11 |         1 | 2018-01-08   |
|  286 | [66F8C32B](https://metrics.torproject.org/rs.html#details/66F8C32B94D73B51A5D2FA079C6A09047C9ABA71)                                                                   |            0.065 |      0    |       0.11 |         1 | 2020-07-11   |
|  287 | [seppowalther at mail dot de tor-relay.co](https://metrics.torproject.org/rs.html#details/6ED3BE22B2261258017B3F0584706265985D7AE9)                                   |            0.065 |      0    |       0.11 |         1 | 2020-03-08   |
|  288 | [F4A Free4ALL TOR &lt;mail@free4all.eu&gt; https://www.fr](https://metrics.torproject.org/rs.html#details/8B64F593CAC2ED05C0FA703AEF50FF71925B569C)                   |            0.065 |      0    |       0.11 |         1 | 2019-12-06   |
|  289 | [tor at nightmare dot life](https://metrics.torproject.org/rs.html#search/family:90D43CF5541ECF57C1833FED33FFDFF239C4817C)                                            |            0.065 |      0.13 |       0    |         2 | 2020-06-01   |
|  290 | [ACE29EC7](https://metrics.torproject.org/rs.html#details/ACE29EC7700BD112DEB42B934E5E443476CD577C)                                                                   |            0.065 |      0    |       0    |         1 | 2019-07-22   |
|  291 | [Random Admin Person &lt;tor AT ecki-netz dot de&gt;](https://metrics.torproject.org/rs.html#details/C49A177510CAA653DA6727BF0E07FB7F56A0F09D)                        |            0.065 |      0    |       0.11 |         1 | 2014-12-22   |
|  292 | [F9674F45](https://metrics.torproject.org/rs.html#details/F9674F45A25CAA977E7B872807E0A070C121F5FA)                                                                   |            0.065 |      0    |       0.11 |         1 | 2019-03-08   |
|  293 | [fuzzduzter2008@yahoo.com](https://metrics.torproject.org/rs.html#search/family:061E0496931D23A81A2B685C9339D36857DD0FA1)                                             |            0.064 |      0    |       0.1  |         2 | 2020-03-05   |
|  294 | [samam &lt; at &gt; protonmail.com](https://metrics.torproject.org/rs.html#details/54DE63F4587058B79152A75A0238D7F7A0279215)                                          |            0.064 |      0    |       0.1  |         1 | 2016-03-28   |
|  295 | [Walter Heukels &lt;walter@badexample.net&gt;](https://metrics.torproject.org/rs.html#details/7DD29A65C370B86B5BE706EA3B1417745714C8AF)                               |            0.064 |      0.21 |       0    |         1 | 2015-05-04   |
|  296 | [&lt;Jannis&gt; jannisde85@eclipso.eu](https://metrics.torproject.org/rs.html#details/A1B7C1F83E5DA4376FD2E1DBA7AC28A71AB332AD)                                       |            0.064 |      0    |       0.1  |         1 | 2016-03-28   |
|  297 | [Random Person phillw@phillw.net](https://metrics.torproject.org/rs.html#details/AEF6C1FBA0FC16F4931638BF065085B974D3E90F)                                            |            0.064 |      0    |       0.1  |         1 | 2019-01-01   |
|  298 | [Guinness &lt;guinness AT crans dot org&gt;](https://metrics.torproject.org/rs.html#search/family:2B24C281AD12EA96F72C2808E1AF041CEBE345D0)                           |            0.063 |      0    |       0.1  |         2 | 2017-04-27   |
|  299 | [bund@posteo.de tor-relay.co](https://metrics.torproject.org/rs.html#details/A6E0F950CAC74AF867CA21976069529D6D4D3E30)                                                |            0.063 |      0    |       0.1  |         1 | 2019-01-27   |
|  300 | [0251FCFD](https://metrics.torproject.org/rs.html#search/family:0251FCFDBC281666A6D492785A2D289F5664C039)                                                             |            0.062 |      0    |       0.09 |         4 | 2020-06-03   |
|  301 | [Rotate-13 gbeznfgre@ubehf-vg.qr](https://metrics.torproject.org/rs.html#search/family:0C3D5E19E3C75B505C8ACD26F89DCA2DF970553E)                                      |            0.062 |      0.04 |       0.08 |         2 | 2016-08-04   |
|  302 | [tor att rw501 &lt;dott&gt; de](https://metrics.torproject.org/rs.html#details/1034775A01EA629979D0A601EC85FDF2F584CC45)                                              |            0.062 |      0    |       0.1  |         1 | 2020-07-26   |
|  303 | [nicondro AT disroot DOT org](https://metrics.torproject.org/rs.html#details/248D562E8BDB906967EB7E551759B52004A35575)                                                |            0.062 |      0    |       0    |         1 | 2020-06-25   |
|  304 | [email:comments worldofmatthew.com operatorurl:htt](https://metrics.torproject.org/rs.html#search/family:3212FA08FB2358B271606E21B1DFBD6717B94FA3)                    |            0.062 |      0    |       0.1  |         3 | 2020-05-26   |
|  305 | [35DBE434](https://metrics.torproject.org/rs.html#details/35DBE43445BB44D817084200BA05E8A0573EDFD4)                                                                   |            0.062 |      0    |       0.1  |         1 | 2020-07-17   |
|  306 | [72C2EB69](https://metrics.torproject.org/rs.html#details/72C2EB697C3CD4CE7408359B386DEE6B2888F714)                                                                   |            0.062 |      0    |       0.1  |         1 | 2020-07-11   |
|  307 | [A541C211](https://metrics.torproject.org/rs.html#details/A541C211909264081DC3A4F8E105F06139DDCD8B)                                                                   |            0.062 |      0    |       0.1  |         1 | 2020-07-22   |
|  308 | [E1302966](https://metrics.torproject.org/rs.html#details/E130296683B896A117CE5DA531A5645644178734)                                                                   |            0.062 |      0    |       0.1  |         1 | 2019-08-15   |
|  309 | [WCC &lt;webmaster.AT.wcc.dot.de&gt;](https://metrics.torproject.org/rs.html#details/61004152C709672EE739F2667B56EF5550A51332)                                        |            0.061 |      0    |       0.1  |         1 | 2019-01-13   |
|  310 | [keiferdodderblyyatgmaildoddercom tor-relay.co](https://metrics.torproject.org/rs.html#details/79E3B585803DE805CCBC00C1EF36B1E74372861D)                              |            0.061 |      0    |       0.1  |         1 | 2020-05-11   |
|  311 | [tor@fashionmedia.se](https://metrics.torproject.org/rs.html#details/980B28A19B0A66948035A3FE143E5CF613C84122)                                                        |            0.061 |      0    |       0.1  |         1 | 2019-03-26   |
|  312 | [B56B9FE9](https://metrics.torproject.org/rs.html#details/B56B9FE93F83B4FA69234B17A060E8A8E7446D19)                                                                   |            0.061 |      0    |       0.1  |         1 | 2020-07-18   |
|  313 | [C3D92B06](https://metrics.torproject.org/rs.html#details/C3D92B0696196558E784EF7252A5370192720BE5)                                                                   |            0.061 |      0    |       0.1  |         1 | 2020-07-19   |
|  314 | [SysCom &lt;syscom =at= snt.utwente.nl&gt;](https://metrics.torproject.org/rs.html#details/D08660B6D70B6249A57D89BB7A8F2EA2C952BD35)                                  |            0.061 |      0    |       0.1  |         1 | 2019-01-18   |
|  315 | [Theo Thomann - t thomann1974@gmx.de](https://metrics.torproject.org/rs.html#details/0D99F89BBB92BF5557F8D3F895DB218A72871089)                                        |            0.06  |      0    |       0.1  |         1 | 2020-01-13   |
|  316 | [reverse dserrano5.es at tor](https://metrics.torproject.org/rs.html#search/family:334DF2164322B98FCC567BC444947B74AC92DAEA)                                          |            0.06  |      0    |       0.1  |         2 | 2014-04-08   |
|  317 | [3D9CE803](https://metrics.torproject.org/rs.html#details/3D9CE80399B68C01377FEC42395E399B9ED16E18)                                                                   |            0.06  |      0    |       0.1  |         1 | 2018-12-12   |
|  318 | [Anders Burmeister &lt;anders.burmeister AT protonmail](https://metrics.torproject.org/rs.html#search/family:484A10BA2B8D48A5F0216674C8DD50EF27BC32F3)                |            0.06  |      0    |       0.1  |         3 | 2017-02-11   |
|  319 | [7674C383](https://metrics.torproject.org/rs.html#details/7674C383F7F551E065E3E95BBCFC067157546A17)                                                                   |            0.06  |      0    |       0.1  |         1 | 2019-11-08   |
|  320 | [Contact at SilSte on Twitter tor-relay.co](https://metrics.torproject.org/rs.html#details/856B7EFB7E09D02A29DD2FF024B7E1EFE21FE9EB)                                  |            0.06  |      0    |       0.1  |         1 | 2019-12-09   |
|  321 | [91DDE492](https://metrics.torproject.org/rs.html#details/91DDE492833DA13509B2ABEF3E8F6D5161153385)                                                                   |            0.06  |      0    |       0.1  |         1 | 2020-07-19   |
|  322 | [0x85F75728 Sandtler &lt;sandtler at sandtler dot](https://metrics.torproject.org/rs.html#details/9738F8F5C386CDAF5707D0DCED428F2813CA285F)                           |            0.06  |      0    |       0.1  |         1 | 2019-04-11   |
|  323 | [A2F7674E](https://metrics.torproject.org/rs.html#details/A2F7674E837C4131D70A840262AFC269801F14BA)                                                                   |            0.06  |      0    |       0.1  |         1 | 2020-07-22   |
|  324 | [fgrdsw @ torbox3uiot6wchz . onion](https://metrics.torproject.org/rs.html#search/family:B0B26AEDB0D1E21EA8E06530CAAD953B464286FB)                                    |            0.06  |      0    |       0.1  |         2 | 2020-05-15   |
|  325 | [Fred CORNU &lt;tor-admin AT wardsback DOT org&gt; - 16Dw](https://metrics.torproject.org/rs.html#details/B143D439B72D239A419F8DCE07B8A8EB1B486FA7)                   |            0.06  |      0    |       0.1  |         1 | 2015-01-05   |
|  326 | [bitcoin:1C3rd2BDprvz9ikAQBQ1Hz2HjbASZxVy8b - mail@](https://metrics.torproject.org/rs.html#details/18B160CD5E22BFC345AEE7BA84B7EA45BF457FCA)                         |            0.059 |      0    |       0.1  |         1 | 2014-04-12   |
|  327 | [staff@dotsrc.org](https://metrics.torproject.org/rs.html#search/family:356B94BAD3096790E409790898144A4030AC225C)                                                     |            0.059 |      0    |       0.1  |         2 | 2016-09-08   |
|  328 | [4758509F](https://metrics.torproject.org/rs.html#details/4758509FBE6473202AB0CC161238372BF636612D)                                                                   |            0.059 |      0.19 |       0    |         1 | 2020-07-21   |
|  329 | [Rhys RE &lt;me at sign rhysre dot net&gt; - GPG: 242](https://metrics.torproject.org/rs.html#details/484F666C491BCDE22B45E0E19D1CEA5ACC5A9611)                       |            0.059 |      0    |       0.1  |         1 | 2018-03-18   |
|  330 | [49791A9C](https://metrics.torproject.org/rs.html#details/49791A9C1CD16463868F407C3968A3DCF1E9DC49)                                                                   |            0.059 |      0    |       0.1  |         1 | 2020-07-17   |
|  331 | [7D31D511](https://metrics.torproject.org/rs.html#details/7D31D5118D47BF86C550ABB79EDDE865EC31B67F)                                                                   |            0.059 |      0    |       0.1  |         1 | 2017-09-12   |
|  332 | [BAE58EF7](https://metrics.torproject.org/rs.html#details/BAE58EF7F58C11DAFD81C9EDD10EB74150AF3CFE)                                                                   |            0.059 |      0    |       0.1  |         1 | 2020-07-11   |
|  333 | [40762990022](https://metrics.torproject.org/rs.html#search/family:05360E955C4C4C51CBA140DFDDFC8BDE2ACF6244)                                                          |            0.058 |      0.19 |       0    |         4 | 2018-02-12   |
|  334 | [tor@dnet.ovh](https://metrics.torproject.org/rs.html#search/family:21EB2176DFD7364A8E3705ABF518E880362425FC)                                                         |            0.058 |      0    |       0.09 |         2 | 2016-03-12   |
|  335 | [Who &lt;yyx AT gmx dot de&gt;](https://metrics.torproject.org/rs.html#search/family:26220AEA188B8D0E47BB541E1A616EB3AD70295F)                                        |            0.058 |      0    |       0.09 |         2 | 2012-09-06   |
|  336 | [Kenan Sulayman &lt;kenan@sly.mn&gt;](https://metrics.torproject.org/rs.html#details/45E9240AD4ECE01793A1977C1260503B2C2C861F)                                        |            0.058 |      0.19 |       0    |         1 | 2020-07-18   |
|  337 | [eint0pf@pm.me](https://metrics.torproject.org/rs.html#search/family:47A83EC4D144FB8094A57DC5AEB39E9F6F174036)                                                        |            0.058 |      0    |       0    |         2 | 2019-12-22   |
|  338 | [52D5FB20](https://metrics.torproject.org/rs.html#details/52D5FB2004C67127C73B71478238FA66122BD443)                                                                   |            0.058 |      0    |       0.09 |         1 | 2019-04-18   |
|  339 | [scurra&lt;scurra@posteo.de&gt;](https://metrics.torproject.org/rs.html#details/56781CCC9F6D29FEA148799AB588429C893A473C)                                             |            0.058 |      0    |       0.09 |         1 | 2016-11-01   |
|  340 | [6C251FA7](https://metrics.torproject.org/rs.html#details/6C251FA7F45E9DEDF5F69BA3D167F6BA736F49CD)                                                                   |            0.058 |      0    |       0.09 |         1 | 2019-09-25   |
|  341 | [oliver2425 AT protonmail DOT com tor-relay.co](https://metrics.torproject.org/rs.html#details/994FB6A842C0CEE1F1C4CBA9A7604C5FF6014CFC)                              |            0.058 |      0    |       0.09 |         1 | 2020-05-12   |
|  342 | [&lt;Jannis&gt; jannisde85@eclipso.eu](https://metrics.torproject.org/rs.html#details/F6CD4DBF5850AC4386DD9A424918AD3C6BA2716F)                                       |            0.058 |      0    |       0.09 |         1 | 2016-09-07   |
|  343 | [tor@cxx.rocks - 1JXekGAz1Yniej4ewKAkfRVnhpLJj2GdnP](https://metrics.torproject.org/rs.html#search/family:361D33C96D0F161275EE67E2C91EE10B276E778B)                   |            0.057 |      0    |       0.09 |         2 | 2015-01-01   |
|  344 | [Kevin &lt;tor AT kberanek dot com&gt;](https://metrics.torproject.org/rs.html#search/family:66C102FA5DDF48C9EEEB048C1630933B66C50ECC)                                |            0.057 |      0    |       0    |         3 | 2016-12-25   |
|  345 | [andweb-noc@mailbox.org](https://metrics.torproject.org/rs.html#details/DA4B488C2826DFBBD04D635DA1E71A2BA5B20747)                                                     |            0.057 |      0    |       0.09 |         1 | 2018-01-29   |
|  346 | [tor at kempe dot user dot lysator dot liu dot se](https://metrics.torproject.org/rs.html#search/family:43E187B8C7361F47EA968ED5389435865D7F4FE7)                     |            0.056 |      0.08 |       0.05 |         2 | 2018-02-07   |
|  347 | [rememberremember at gmx dot com](https://metrics.torproject.org/rs.html#details/74B8B22AF950B0BE11D8A228FB09D2F5279FB757)                                            |            0.056 |      0    |       0.09 |         1 | 2016-09-27   |
|  348 | [BDDF8187](https://metrics.torproject.org/rs.html#details/BDDF8187EA4419951CFD0A54088B634564F63AF3)                                                                   |            0.056 |      0    |       0.09 |         1 | 2020-07-22   |
|  349 | [email: dabossman@tutanota.com donationBTC: 1Lv11mP](https://metrics.torproject.org/rs.html#details/C239952D0C8E4EABC3E6B0A8E0B623689174E3C6)                         |            0.056 |      0    |       0.09 |         1 | 2020-01-10   |
|  350 | [spam@angarod.net](https://metrics.torproject.org/rs.html#details/C545ED3BE029B226D74B3F798235951D2FEEE3E1)                                                           |            0.056 |      0.18 |       0    |         1 | 2020-01-25   |
|  351 | [CACD9D63](https://metrics.torproject.org/rs.html#details/CACD9D63B759B35555D8C965A3E01071E9DFB44C)                                                                   |            0.056 |      0    |       0.09 |         1 | 2020-01-11   |
|  352 | [D1B1A550](https://metrics.torproject.org/rs.html#details/D1B1A550FEE3A05E71CA9080D14CCA3B746C0C17)                                                                   |            0.056 |      0    |       0.09 |         1 | 2019-05-03   |
|  353 | [Artikel10 &lt;info@artikel10.org&gt;](https://metrics.torproject.org/rs.html#details/DB6ADA8153DF6B148B1A8843B486E20354499650)                                       |            0.056 |      0.18 |       0    |         1 | 2019-09-09   |
|  354 | [0x0D3130F5 Clu00E9ment Fu00E9vrier &lt;clement AT f](https://metrics.torproject.org/rs.html#details/33D88F331408141F2A2CC563239E54E48F7A211B)                        |            0.055 |      0    |       0    |         1 | 2016-08-16   |
|  355 | [tor at 0x3d dot lu - 1x3dG3utS7FDrTtJutnR3zuCo4Z8f](https://metrics.torproject.org/rs.html#search/family:912A7C57E05606AF602EC63D1D06BBD5C7AAE516)                   |            0.055 |      0    |       0.09 |         2 | 2018-11-24   |
|  356 | [C5A1D5B7](https://metrics.torproject.org/rs.html#details/C5A1D5B7CB0D12A7B7334F2915134E6DA8F5C46D)                                                                   |            0.055 |      0    |       0.09 |         1 | 2020-07-11   |
|  357 | [info@riccardomasutti.com](https://metrics.torproject.org/rs.html#details/C5F214F7F9CCBF09324C9AA032760150243A196C)                                                   |            0.055 |      0    |       0.09 |         1 | 2020-04-30   |
|  358 | [https://www.torservers.net/donate.html &lt;support .A](https://metrics.torproject.org/rs.html#details/D729C688382CC2A576089716BE10490D2D66FCE4)                      |            0.055 |      0.18 |       0    |         1 | 2019-02-06   |
|  359 | [tor@base.com](https://metrics.torproject.org/rs.html#details/F75E570446D8E14E1FAECB64CB2467A1CA804A0E)                                                               |            0.055 |      0.18 |       0    |         1 | 2020-05-08   |
|  360 | [Neel Chauhan &lt;neel AT neelc DOT org&gt;](https://metrics.torproject.org/rs.html#search/family:02AB0923AFF5A47DD011C343F79864C45E9FFB34)                           |            0.054 |      0.16 |       0    |         6 | 2020-05-30   |
|  361 | [tor@undefinedporcupine.dev](https://metrics.torproject.org/rs.html#search/family:08409909F46473942F733E126B78F29D388D60F5)                                           |            0.054 |      0.18 |       0    |         2 | 2020-02-27   |
|  362 | [tor@nicdex.com](https://metrics.torproject.org/rs.html#details/1C0D0AF3FF05CCBBA4B6ED262196A4C5A76102E6)                                                             |            0.054 |      0.18 |       0    |         1 | 2018-07-18   |
|  363 | [sorry-but-i@do.not.like.spam](https://metrics.torproject.org/rs.html#search/family:33AA6CFE161A698169B548C9D973DAE6DED6BF0E)                                         |            0.054 |      0    |       0.05 |         3 | 2020-04-05   |
|  364 | [tor-operator@your-emailaddress-domain](https://metrics.torproject.org/rs.html#details/3927B0448B2F188C2B10CAD19842B7E035DE6BDC)                                      |            0.054 |      0    |       0.09 |         1 | 2020-07-11   |
|  365 | [77B45629](https://metrics.torproject.org/rs.html#details/77B4562974F5D715626EB78460C79A2D13FB7006)                                                                   |            0.054 |      0    |       0.09 |         1 | 2019-01-02   |
|  366 | [B32B93C9](https://metrics.torproject.org/rs.html#details/B32B93C90DCAF0012328A8D55D621D26B186E11A)                                                                   |            0.054 |      0    |       0.09 |         1 | 2019-07-29   |
|  367 | [zwiebelring at mailbox dot org](https://metrics.torproject.org/rs.html#search/family:B6495EB04241A8D95996F7C8ACAF790B62E8111B)                                       |            0.054 |      0    |       0.09 |         3 | 2019-09-11   |
|  368 | [BF37445E](https://metrics.torproject.org/rs.html#details/BF37445EA2A9F3D04F4B87DFAC624AEF21B559D5)                                                                   |            0.054 |      0    |       0    |         1 | 2019-03-05   |
|  369 | [Scott Maxwell tor-contact-2020-netcup-medium at](https://metrics.torproject.org/rs.html#details/DC40A59D4D744F2C3C7A655EC6BF3A59AFA1C66C)                            |            0.054 |      0    |       0.09 |         1 | 2020-05-29   |
|  370 | [servicetor@nexticom.net](https://metrics.torproject.org/rs.html#details/00B57BF614F7ED3051073B5D4526FF0B23AF217B)                                                    |            0.053 |      0    |       0.09 |         1 | 2019-11-22   |
|  371 | [Peter Jensen &lt;torrelay AT zlang dot dk&gt;](https://metrics.torproject.org/rs.html#details/1B90395827F7499A37C73F09BC5AA0225808F6FC)                              |            0.053 |      0    |       0.09 |         1 | 2017-07-24   |
|  372 | [37C1D665](https://metrics.torproject.org/rs.html#search/family:37C1D66559D0C7884E3D21F7DEB58C75D79B98A8)                                                             |            0.053 |      0    |       0.09 |         2 | 2014-02-07   |
|  373 | [tor-relays@coldhak.ca](https://metrics.torproject.org/rs.html#search/family:547DA56F6B88B6C596B3E3086803CDA4F0EF8F21)                                                |            0.053 |      0.17 |       0    |         6 | 2016-04-02   |
|  374 | [nodeMailAddy at gmail.com](https://metrics.torproject.org/rs.html#details/968CB7DA0C56E66F22B78CBA0562FE132939D8BF)                                                  |            0.053 |      0    |       0    |         1 | 2018-08-12   |
|  375 | [94944d7b-673d-46ee-848c-148a25f0fe29@protonmail.co](https://metrics.torproject.org/rs.html#details/AA8B7237B4D2C76ED4AF24B3B47B375812AACC83)                         |            0.053 |      0    |       0.09 |         1 | 2020-01-22   |
|  376 | [Niklas &lt;nicke AT mdfnet DOT se&gt;](https://metrics.torproject.org/rs.html#search/family:D65DB84BF1EB4DD225B9A1CD9CEFD87B595A30F5)                                |            0.053 |      0    |       0.09 |         2 | 2017-07-04   |
|  377 | [E81D56AE](https://metrics.torproject.org/rs.html#details/E81D56AE3FE9919F3A42AB11100901E6BAEC4FCB)                                                                   |            0.053 |      0    |       0.09 |         1 | 2020-02-29   |
|  378 | [support AT vsif dot ca](https://metrics.torproject.org/rs.html#search/family:003D78825E0B9609EECFF5E4E0529717772E53C7)                                               |            0.052 |      0.08 |       0.04 |         6 | 2017-06-23   |
|  379 | [Mr Robot &lt;freespeechrelay@protonmail.ch&gt;](https://metrics.torproject.org/rs.html#search/family:383CFCF03B225B3EDCA519197BAA310A58CEAABC)                       |            0.052 |      0    |       0.08 |         2 | 2020-07-28   |
|  380 | [tor-operator at infosecproject dot org](https://metrics.torproject.org/rs.html#details/A0DFB31231C718829FA18EAB4D0CD51DEDBAE08C)                                     |            0.052 |      0    |       0.08 |         1 | 2017-12-09   |
|  381 | [angristan at pm dot me](https://metrics.torproject.org/rs.html#details/0E2EEC125A6AC8D5EBF5DB36B776A3DA5510E7A0)                                                     |            0.051 |      0    |       0.08 |         1 | 2016-05-08   |
|  382 | [freeasinbeer@techie.com](https://metrics.torproject.org/rs.html#details/3CE90527D5712296B58E7EB7CD57F7D388D25FBB)                                                    |            0.051 |      0    |       0.08 |         1 | 2015-10-29   |
|  383 | [46F9FB94](https://metrics.torproject.org/rs.html#details/46F9FB943917858F618F2648595DEACD931D4400)                                                                   |            0.051 |      0.17 |       0    |         1 | 2019-05-03   |
|  384 | [0xDD7831FC Matthias Kretschmann &lt;m AT kretschmann](https://metrics.torproject.org/rs.html#search/family:580C51E028513A15CAC370FBEB40BE09D9488613)                 |            0.051 |      0.17 |       0    |         2 | 2016-05-09   |
|  385 | [59BC32EA](https://metrics.torproject.org/rs.html#details/59BC32EA48ED1D06A373856434C0C5C4D2D86603)                                                                   |            0.051 |      0    |       0.08 |         1 | 2020-07-17   |
|  386 | [Yosef &lt;artur.grudzinski mail ru&gt;](https://metrics.torproject.org/rs.html#details/6245DC873D6F613C795D48663D65BD8A2266CAF6)                                     |            0.051 |      0    |       0.08 |         1 | 2020-07-20   |
|  387 | [tor at ack512 dot net](https://metrics.torproject.org/rs.html#details/6940247E04C839D268543E7F62566A91E40567E3)                                                      |            0.051 |      0    |       0.08 |         1 | 2019-07-27   |
|  388 | [82D1DACD](https://metrics.torproject.org/rs.html#details/82D1DACDCF9ACEA4E507DE88EE8E1F17ECB59FE8)                                                                   |            0.051 |      0.17 |       0    |         1 | 2020-07-12   |
|  389 | [Alec &lt;tor DASH operator AT alec DOT ninja&gt;](https://metrics.torproject.org/rs.html#details/89094DFA4158C7A1583EC3A332CDCBC74A28CC0E)                           |            0.051 |      0.17 |       0    |         1 | 2019-06-12   |
|  390 | [miratytor@antopie.&lt;TLD of wikipedia&gt; or https://a](https://metrics.torproject.org/rs.html#details/BE8737597F2E6B4F805893202C935125829A902E)                    |            0.051 |      0    |       0.08 |         1 | 2020-03-06   |
|  391 | [0CDCFB0B](https://metrics.torproject.org/rs.html#search/family:0CDCFB0B6E1500E57BDD7F240543EBAEF81C11CA)                                                             |            0.05  |      0    |       0.02 |         2 | 2015-04-12   |
|  392 | [391D289D](https://metrics.torproject.org/rs.html#details/391D289DFAFB673B362646A51973447EB706DFC4)                                                                   |            0.05  |      0    |       0    |         1 | 2018-12-03   |
|  393 | [3B60AEB1](https://metrics.torproject.org/rs.html#details/3B60AEB127F4A8CDE7F3798B799EBDC3463FB9C7)                                                                   |            0.05  |      0    |       0.08 |         1 | 2020-07-11   |
|  394 | [9ACD9D52](https://metrics.torproject.org/rs.html#details/9ACD9D526D1F82D7A00225742F1BDB374D7D17D4)                                                                   |            0.05  |      0    |       0.08 |         1 | 2020-06-29   |
|  395 | [9C66AB3B](https://metrics.torproject.org/rs.html#details/9C66AB3B7D9DDA2EA81AAF51BABA6D4331DF9592)                                                                   |            0.05  |      0.17 |       0    |         1 | 2019-12-05   |
|  396 | [&lt;smelltheonions at protonmail dot ch&gt;](https://metrics.torproject.org/rs.html#search/family:B1E43B11A955CBA31F5261A22CBFCE204C95D5DE)                          |            0.05  |      0    |       0.08 |         2 | 2019-08-25   |
|  397 | [BFA905EA](https://metrics.torproject.org/rs.html#details/BFA905EA10DFD54A38A0C119FAE00182DE4C173B)                                                                   |            0.05  |      0    |       0.08 |         1 | 2017-10-25   |
|  398 | [CD24E771](https://metrics.torproject.org/rs.html#details/CD24E771368244431E1DA30603FF11A317DB215F)                                                                   |            0.05  |      0.17 |       0    |         1 | 2019-10-18   |
|  399 | [fnowicki@pm.me](https://metrics.torproject.org/rs.html#search/family:1424000B86DF67D1FBFF685B204073BB9591CEFD)                                                       |            0.049 |      0    |       0.08 |         3 | 2019-05-03   |
|  400 | [438F3EA4](https://metrics.torproject.org/rs.html#details/438F3EA4C9FB0DB63F5377A3271AB5435FAD7E04)                                                                   |            0.049 |      0    |       0.08 |         1 | 2018-12-14   |
|  401 | [hiwi &lt;hiwi AT nurfuerspam dot de&gt;](https://metrics.torproject.org/rs.html#search/family:4CA8D07878F86ED5B64B4B89030FF4616067210F)                              |            0.049 |      0    |       0.08 |         3 | 2017-05-25   |
|  402 | [abuse@myracloud.com](https://metrics.torproject.org/rs.html#details/61AF790EF78C2D73C8E3D8E2596D42A1AACE1359)                                                        |            0.049 |      0.16 |       0    |         1 | 2019-02-16   |
|  403 | [98AEF7B8](https://metrics.torproject.org/rs.html#details/98AEF7B834D688773CE2BCC5A32761A4943CF623)                                                                   |            0.049 |      0    |       0.08 |         1 | 2020-07-22   |
|  404 | [no-abuse@nomail.com](https://metrics.torproject.org/rs.html#details/9B047A91AC809AA020A1F42E3E785DBCEBF3652F)                                                        |            0.049 |      0    |       0.08 |         1 | 2020-07-20   |
|  405 | [9E6093B2](https://metrics.torproject.org/rs.html#details/9E6093B255FB67A9E2D604F48E75C93512D7F566)                                                                   |            0.049 |      0    |       0.08 |         1 | 2020-08-04   |
|  406 | [AEF0EADA](https://metrics.torproject.org/rs.html#details/AEF0EADA8C92A4DF1500FAE303ECD8E1EBD56670)                                                                   |            0.049 |      0    |       0.08 |         1 | 2020-07-19   |
|  407 | [tor@neptunenetworks.org](https://metrics.torproject.org/rs.html#search/family:053C847373A2F82106370DBB016B5E8A14DA9101)                                              |            0.048 |      0    |       0.04 |         4 | 2019-09-12   |
|  408 | [1804C06A](https://metrics.torproject.org/rs.html#details/1804C06A266F0DA26DF58CD559E01C2F7C3FC42A)                                                                   |            0.048 |      0    |       0    |         1 | 2020-04-10   |
|  409 | [Qzp3z061oP@protonmail.com](https://metrics.torproject.org/rs.html#details/3033FD18BBD658C5ECE926FB17D2269BFE337358)                                                  |            0.048 |      0    |       0.08 |         1 | 2019-09-03   |
|  410 | [55A92BE2](https://metrics.torproject.org/rs.html#details/55A92BE2A76C64A5A0DB0D4F61D5DCA37B55EE52)                                                                   |            0.048 |      0    |       0.08 |         1 | 2019-01-31   |
|  411 | [573051CA](https://metrics.torproject.org/rs.html#details/573051CAA3EEEE2B75EBD096BB1F70D3FDAC5F3A)                                                                   |            0.048 |      0    |       0.08 |         1 | 2020-07-17   |
|  412 | [tor@servify.se](https://metrics.torproject.org/rs.html#details/6D163F649ECBE9DC20F016236EF36D7E1559E98E)                                                             |            0.048 |      0    |       0    |         1 | 2020-05-12   |
|  413 | [bill@microsoft.com](https://metrics.torproject.org/rs.html#details/93F97B76A7D0F0947C4C75AC62017E45BBFE6C08)                                                         |            0.048 |      0    |       0.08 |         1 | 2020-06-25   |
|  414 | [0xFFFFFFFF Random Person &lt;nobody AT example dot co](https://metrics.torproject.org/rs.html#details/9A7417BA401B8C7EFDE24945E18145A1EDA730E7)                      |            0.048 |      0    |       0.08 |         1 | 2017-12-10   |
|  415 | [9C34EAD9](https://metrics.torproject.org/rs.html#details/9C34EAD957DF77978BCF356F3F96B9A79E3961CB)                                                                   |            0.048 |      0    |       0.08 |         1 | 2020-07-11   |
|  416 | [drremmiz tor AT protonmail dot com](https://metrics.torproject.org/rs.html#search/family:05D85F0B5C7253C5EF596EAF6910EB8B316F73CE)                                   |            0.047 |      0.15 |       0    |        12 | 2019-02-18   |
|  417 | [0BC31428](https://metrics.torproject.org/rs.html#search/family:0BC314281C83167F24C7CFCD68DE069B02A92345)                                                             |            0.047 |      0    |       0.08 |         3 | 2016-05-03   |
|  418 | [104DC15A](https://metrics.torproject.org/rs.html#details/104DC15ACFA69CF94F89E8ED0F6CDB2D298234D2)                                                                   |            0.047 |      0    |       0.08 |         1 | 2019-05-31   |
|  419 | [tor-relays@lists.torproject.org](https://metrics.torproject.org/rs.html#search/family:1CD17CB202063C51C7DAD3BACEF87ECE81C2350F)                                      |            0.047 |      0    |       0.08 |        10 | 2018-07-17   |
|  420 | [nekromateion@nekro-works.de](https://metrics.torproject.org/rs.html#details/28AA7AFE8B1EDD7D4278D2A02027E09A75B528D0)                                                |            0.047 |      0    |       0    |         1 | 2020-07-20   |
|  421 | [4E81EA35](https://metrics.torproject.org/rs.html#details/4E81EA3528D6FB79B10B0F11C6FC96CE1C060021)                                                                   |            0.047 |      0    |       0.08 |         1 | 2020-07-25   |
|  422 | [876C7CE4](https://metrics.torproject.org/rs.html#details/876C7CE43774366250D3E768E690DAB9D4B5D5A3)                                                                   |            0.047 |      0    |       0    |         1 | 2018-02-09   |
|  423 | [&lt;hvi at safe dash mail dot net&gt;](https://metrics.torproject.org/rs.html#details/8A00CE9638BDB4686B91F1F0B229DB3F8C9B8415)                                      |            0.047 |      0    |       0    |         1 | 2017-09-04   |
|  424 | [torpids AT yahoo dot com - 1JYHfzVFVD7n2Sezz3DEHDF](https://metrics.torproject.org/rs.html#details/8DCB526722FBE2B3F4C0CE9D020B0589170F8BDA)                         |            0.047 |      0    |       0.08 |         1 | 2019-07-12   |
|  425 | [Vasil Kolev &lt;tor@ludost.net&gt;](https://metrics.torproject.org/rs.html#details/9E4CC64C4F94C359D43C5BA09094323FDBEFD975)                                         |            0.047 |      0    |       0.07 |         1 | 2016-03-14   |
|  426 | [Random Person &lt;gbe@v--o pbz rot13 &gt;](https://metrics.torproject.org/rs.html#details/C5B622E52654B570ADFD656AC61B74CC84BBEE95)                                  |            0.047 |      0    |       0    |         1 | 2018-06-03   |
|  427 | [DC47F0CB](https://metrics.torproject.org/rs.html#search/family:DC47F0CBA28E19662021525396AFB4B669C0B11B)                                                             |            0.047 |      0    |       0.08 |         2 | 2019-07-17   |
|  428 | [2DA5ECDA](https://metrics.torproject.org/rs.html#details/2DA5ECDA6E51E5BDC24A91DFBAA424649117C3EA)                                                                   |            0.046 |      0.15 |       0    |         1 | 2020-07-14   |
|  429 | [ghac@riseup.net](https://metrics.torproject.org/rs.html#details/30D457317789E20449CBC12E02F5658FA23E0BEE)                                                            |            0.046 |      0    |       0.07 |         1 | 2019-10-23   |
|  430 | [50C7B836](https://metrics.torproject.org/rs.html#search/family:50C7B836942F14BDF1541B017CF21FD03F354E13)                                                             |            0.046 |      0    |       0    |         2 | 2020-02-06   |
|  431 | [0x1A47FAF4](https://metrics.torproject.org/rs.html#details/74AC10CA94E400BA4D69E397562597CA04FC5352)                                                                 |            0.046 |      0    |       0.07 |         1 | 2020-01-22   |
|  432 | [anavrin dot gmail.com](https://metrics.torproject.org/rs.html#details/856DAB2FDC9EED88A27BE2265FA6BD5489EF178E)                                                      |            0.046 |      0    |       0    |         1 | 2020-01-10   |
|  433 | [A6C983C2](https://metrics.torproject.org/rs.html#details/A6C983C2F7EEADD55CE9169E540EBD95423FC260)                                                                   |            0.046 |      0    |       0.07 |         1 | 2020-07-17   |
|  434 | [CDA9361C](https://metrics.torproject.org/rs.html#details/CDA9361C072A86719AA3D5A283F5BFBCBF82133B)                                                                   |            0.046 |      0    |       0    |         1 | 2020-07-01   |
|  435 | [algameon1 at hotmail dot com tor-relay.co](https://metrics.torproject.org/rs.html#details/E4F7869E2E9AF579EC93F5CCB823ECFCB297DA4E)                                  |            0.046 |      0    |       0.07 |         1 | 2019-03-29   |
|  436 | [0122A605](https://metrics.torproject.org/rs.html#details/0122A605B7C170D6086143448273D9A9844B69E2)                                                                   |            0.045 |      0    |       0.07 |         1 | 2020-07-19   |
|  437 | [0EFEAA8E](https://metrics.torproject.org/rs.html#details/0EFEAA8E74F9D9024A019702D31380C7B5CBDEEA)                                                                   |            0.045 |      0    |       0.07 |         1 | 2020-06-19   |
|  438 | [Random Person &lt;nobody AT example dot com&gt;](https://metrics.torproject.org/rs.html#details/12CF6DB4DAE106206D6C6B09988E865C0509843B)                            |            0.045 |      0    |       0.07 |         1 | 2018-08-19   |
|  439 | [none@none.com](https://metrics.torproject.org/rs.html#details/16FD7E5D67B7054EE4E7FDDF04AFB48216CA640A)                                                              |            0.045 |      0    |       0.07 |         1 | 2020-04-14   |
|  440 | [Viktor &lt;vnikolov AT vnikolov dot cz&gt;](https://metrics.torproject.org/rs.html#details/3D5D6178C44537E3692853B344385F6572A55767)                                 |            0.045 |      0    |       0.07 |         1 | 2019-05-16   |
|  441 | [Alex Xu &lt;tor dot alxu at ca&gt; 1GUfsp99EQrWVpaWSHY5u](https://metrics.torproject.org/rs.html#search/family:587B1EAF1E22E148EFB010DAA337ACDCD4DB5CBA)             |            0.045 |      0    |       0.07 |         3 | 2017-04-12   |
|  442 | [Joubbi &lt;joubbi AT kth dot se&gt;](https://metrics.torproject.org/rs.html#details/875F74A3DC14737BECA06F8B500022154D1A29D1)                                        |            0.045 |      0    |       0.07 |         1 | 2015-08-29   |
|  443 | [paul@gw90.de](https://metrics.torproject.org/rs.html#details/912B7597346A74A44AD4B6068C645772B758DCB7)                                                               |            0.045 |      0    |       0.07 |         1 | 2017-06-18   |
|  444 | [B00B6BA9](https://metrics.torproject.org/rs.html#details/B00B6BA943600447CF72D58DB7A35B16754E43C8)                                                                   |            0.045 |      0    |       0.07 |         1 | 2019-01-05   |
|  445 | [misha@nuland.io](https://metrics.torproject.org/rs.html#details/CC35A0069EAD4DB32C21AA6BFE2F872FE30742FD)                                                            |            0.045 |      0    |       0.07 |         1 | 2020-07-19   |
|  446 | [E1571684](https://metrics.torproject.org/rs.html#details/E1571684FB37D13DE9BB18DAAF06BCB65BD187AA)                                                                   |            0.045 |      0.15 |       0    |         1 | 2020-07-17   |
|  447 | [admin at lunarmerlin.net](https://metrics.torproject.org/rs.html#details/0CC18E42E5ECADFE76862CE2EB7189EFA17A11FD)                                                   |            0.044 |      0    |       0.07 |         1 | 2019-04-15   |
|  448 | [19D353B8](https://metrics.torproject.org/rs.html#details/19D353B8AA0927DF82CB26E0396C57BE27C0ACC5)                                                                   |            0.044 |      0    |       0.07 |         1 | 2020-05-10   |
|  449 | [murb@oftc - 1HQYNhy34VBR958RQivHY88kdaPfyreR9Z](https://metrics.torproject.org/rs.html#search/family:22BCD0DFD148209C9860C7F89907AB4DEE974A08)                       |            0.044 |      0    |       0.07 |         2 | 2014-04-08   |
|  450 | [2EB3C230](https://metrics.torproject.org/rs.html#details/2EB3C230180694A1E848001E20F36F76A2287039)                                                                   |            0.044 |      0    |       0.07 |         1 | 2016-03-01   |
|  451 | [41E041EC](https://metrics.torproject.org/rs.html#details/41E041EC676622FFEE59F56BC75B99CD0D47F653)                                                                   |            0.044 |      0    |       0.07 |         1 | 2018-12-17   |
|  452 | [0xFFFFFFFF Alexey &lt;alexey AT katalevich dot cz&gt;](https://metrics.torproject.org/rs.html#search/family:46A4E56C9CA59A3B07FD1DFE9891194E0C8FD6F0)                |            0.044 |      0    |       0.07 |         5 | 2017-05-31   |
|  453 | [itay @t huri d0t biz](https://metrics.torproject.org/rs.html#search/family:7355A4A20BA4C083C921464302108C121BAC7EF2)                                                 |            0.044 |      0    |       0    |         2 | 2018-12-25   |
|  454 | [0x3632046A Dmitry &lt;dbaryshkov AT gmail dot com&gt;](https://metrics.torproject.org/rs.html#search/family:842B1F6C4B9E41FC9059DF675C5DF5BDA9F0FC73)                |            0.044 |      0    |       0.07 |         2 | 2014-06-20   |
|  455 | [Random Person &lt;tor AT myserver dot me&gt;](https://metrics.torproject.org/rs.html#details/AFF320BA96E4338B61A008D2CA250FFE0E23B09C)                               |            0.044 |      0    |       0.07 |         1 | 2018-03-22   |
|  456 | [4096R/701269C611CA9526 OpenNetworX Tor Operator &lt;t](https://metrics.torproject.org/rs.html#search/family:BD020D8EDB355C537199420AAF2649FA04536C9A)                |            0.044 |      0    |       0.07 |         2 | 2014-07-22   |
|  457 | [DD6CDD90](https://metrics.torproject.org/rs.html#details/DD6CDD906001B8EA0A167DCD45F6040FEAC48E79)                                                                   |            0.044 |      0    |       0    |         1 | 2020-01-12   |
|  458 | [E1DE607E](https://metrics.torproject.org/rs.html#details/E1DE607E31C2C0FB6F8FC959BF7B58CE35D95990)                                                                   |            0.044 |      0    |       0.07 |         1 | 2020-07-25   |
|  459 | [IT &lt;tor AT informatik dot uni-bremen dot de&gt;](https://metrics.torproject.org/rs.html#details/FEDE31337E4E19E06B97D282F08B0A0E8B9C5526)                         |            0.044 |      0    |       0.07 |         1 | 2014-06-25   |
|  460 | [0x8BDC87FB7215E189 gus at riseup](https://metrics.torproject.org/rs.html#search/family:00E89DDEF944B42FD652F80C2480D5E20DF13194)                                     |            0.043 |      0    |       0.07 |         5 | 2018-08-03   |
|  461 | [04C3468B](https://metrics.torproject.org/rs.html#details/04C3468BE24740347CBCC00534C940DBCBCABC82)                                                                   |            0.043 |      0    |       0.07 |         1 | 2019-11-01   |
|  462 | [132BC609](https://metrics.torproject.org/rs.html#details/132BC609106D4F7361FC9F863B5D9DA15E5F2492)                                                                   |            0.043 |      0.14 |       0    |         1 | 2020-07-17   |
|  463 | [1AAD015F](https://metrics.torproject.org/rs.html#search/family:1AAD015F4D885413A2BCE0E58159116901236C49)                                                             |            0.043 |      0    |       0.07 |         2 | 2018-10-18   |
|  464 | [22E6FBDB](https://metrics.torproject.org/rs.html#details/22E6FBDB8D77B4C0FA017D6C5F9B45BECDCBCFF8)                                                                   |            0.043 |      0    |       0.07 |         1 | 2019-05-13   |
|  465 | [ury.tor.abuse@yandex.ru](https://metrics.torproject.org/rs.html#search/family:5EF0AAAEEE7B1282DA0DBAB94669B73E39DD51B6)                                              |            0.043 |      0.01 |       0.06 |         4 | 2018-02-11   |
|  466 | [61FA7E7C](https://metrics.torproject.org/rs.html#details/61FA7E7C766577D76EBABF19330993DEFA8AF3C3)                                                                   |            0.043 |      0    |       0.07 |         1 | 2018-12-11   |
|  467 | [769A2970](https://metrics.torproject.org/rs.html#details/769A297017BB5E92A9A5A3D76725CA12D694AA30)                                                                   |            0.043 |      0    |       0.07 |         1 | 2019-03-14   |
|  468 | [81F59E89](https://metrics.torproject.org/rs.html#details/81F59E8936D0B2105182E4B8200AC07D9274961F)                                                                   |            0.043 |      0    |       0.07 |         1 | 2020-02-05   |
|  469 | [837D5EA5](https://metrics.torproject.org/rs.html#details/837D5EA513DF7FDDA36BE569C646151CDA4B9935)                                                                   |            0.043 |      0    |       0.07 |         1 | 2018-07-26   |
|  470 | [email:tor sebastian-elisa-pfeifer.eu abuse:tor s](https://metrics.torproject.org/rs.html#search/family:8A7742ADFF91823A1A35FA11D18C4E3A50FA12A7)                     |            0.043 |      0    |       0.06 |         5 | 2020-05-07   |
|  471 | [D5C01B85](https://metrics.torproject.org/rs.html#details/D5C01B85FB3A48D55698CA660A2DE8935388816E)                                                                   |            0.043 |      0    |       0.07 |         1 | 2020-07-22   |
|  472 | [tech-at-vable-dot-ch](https://metrics.torproject.org/rs.html#details/F0A3054C76604DC75D3F57F55C27F1BFB643F107)                                                       |            0.043 |      0    |       0    |         1 | 2020-05-03   |
|  473 | [zahiir at protonmail dot ch](https://metrics.torproject.org/rs.html#search/family:2DCEA7E830BB77C9B332EEB7C1501A5EE2BA0001)                                          |            0.042 |      0    |       0.06 |        10 | 2018-05-22   |
|  474 | [mattsaviour@tutanota.com](https://metrics.torproject.org/rs.html#details/6962377722C4AA5E56540F4F9693DFA525449974)                                                   |            0.042 |      0    |       0.07 |         1 | 2020-03-02   |
|  475 | [&lt;tor-ops AT kel DOT pe&gt;](https://metrics.torproject.org/rs.html#details/71D15B4A7DD9FB70B0E1439F7D350B8FACCFC306)                                              |            0.042 |      0    |       0    |         1 | 2018-12-31   |
|  476 | [admin &lt;admin@reality-software.ml](https://metrics.torproject.org/rs.html#details/79C0F01C729B1FBFF12BCC39A32381D76BE75280)                                        |            0.042 |      0    |       0.07 |         1 | 2020-05-24   |
|  477 | [98BCA63D](https://metrics.torproject.org/rs.html#details/98BCA63DD82E13A637FF8D0EC28135663DB08CA1)                                                                   |            0.042 |      0    |       0.07 |         1 | 2019-12-28   |
|  478 | [sorcier at tutanota dot com tor-relay.co](https://metrics.torproject.org/rs.html#search/family:A0C59410B9030AC1385C4CA44C8DBFE13AF4BC9B)                             |            0.042 |      0    |       0.07 |         2 | 2020-01-12   |
|  479 | [irish](https://metrics.torproject.org/rs.html#details/A6AAFAEABBBACC74CEB15BE9CE69F3B3A4087841)                                                                      |            0.042 |      0.14 |       0    |         1 | 2020-04-06   |
|  480 | [jdhezfndhe98727attutanota.com](https://metrics.torproject.org/rs.html#details/A79F94117D73D4AFA4BCE340A3CB6E345C817594)                                              |            0.042 |      0    |       0.07 |         1 | 2020-03-30   |
|  481 | [tor at alo dot is tor-relay.co](https://metrics.torproject.org/rs.html#details/B13C2C569F3FD0C530B7D96E5FF7933DF7A0E834)                                             |            0.042 |      0    |       0.07 |         1 | 2019-12-18   |
|  482 | [F7B024DB](https://metrics.torproject.org/rs.html#details/F7B024DB02C601185C202E26DFFD2AD525C16A36)                                                                   |            0.042 |      0    |       0.07 |         1 | 2017-04-04   |
|  483 | [admin at tor dot meinecloud dot me](https://metrics.torproject.org/rs.html#details/0D7C69551F9186DB589BDF00858314AC136A33DA)                                         |            0.041 |      0    |       0.06 |         1 | 2018-12-06   |
|  484 | [331452F3](https://metrics.torproject.org/rs.html#details/331452F317390D3C78BCD759170699E55C5570C9)                                                                   |            0.041 |      0    |       0.06 |         1 | 2020-07-25   |
|  485 | [38DC7830](https://metrics.torproject.org/rs.html#details/38DC78302D5CB107B6D5CCC02EE4D8773AA910DE)                                                                   |            0.041 |      0    |       0.06 |         1 | 2018-12-08   |
|  486 | [4CFE65E1](https://metrics.torproject.org/rs.html#details/4CFE65E16DBE9D9ED0CFFBD9BEEEE4EAE50CD33F)                                                                   |            0.041 |      0    |       0.07 |         1 | 2016-03-28   |
|  487 | [609BCF45](https://metrics.torproject.org/rs.html#details/609BCF4500B9AE3898D9189977347287191F4D8E)                                                                   |            0.041 |      0.14 |       0    |         1 | 2020-07-18   |
|  488 | [torpids AT yahoo dot com - 1JYHfzVFVD7n2Sezz3DEHDF](https://metrics.torproject.org/rs.html#details/6B7ABD237CF25E5F787F365AF5FC4C86F0213A9F)                         |            0.041 |      0    |       0.06 |         1 | 2018-01-26   |
|  489 | [7992F172](https://metrics.torproject.org/rs.html#details/7992F172EDBE69B99F0190651BAC14DD0FD9E5C8)                                                                   |            0.041 |      0    |       0.06 |         1 | 2020-07-22   |
|  490 | [8056080E](https://metrics.torproject.org/rs.html#details/8056080EE822B5CA1A8FFF52B7242A82C5E42FBB)                                                                   |            0.041 |      0    |       0.06 |         1 | 2020-01-06   |
|  491 | [8AE7DE9B](https://metrics.torproject.org/rs.html#details/8AE7DE9B3E76B5C2298A89604ED75E3B9EBAC031)                                                                   |            0.041 |      0    |       0    |         1 | 2020-06-23   |
|  492 | [noname @ placeholder.com](https://metrics.torproject.org/rs.html#search/family:8EA58F28DCA60F56C6F2131BDFE9BF5FAF2233CE)                                             |            0.041 |      0    |       0    |         2 | 2019-08-04   |
|  493 | [Anton Gervase &lt;gervase.anton@hmamail.com&gt;](https://metrics.torproject.org/rs.html#details/A4E120350425BAD920307FFA74440F95D0172302)                            |            0.041 |      0    |       0.06 |         1 | 2017-02-20   |
|  494 | [torpids AT yahoo dot com - 1JYHfzVFVD7n2Sezz3DEHDF](https://metrics.torproject.org/rs.html#details/AC66FFA4AB35A59EBBF5BF4C70008BF24D8A7A5C)                         |            0.041 |      0    |       0.07 |         1 | 2015-03-30   |
|  495 | [maxwerner9 at web dot de tor-relay.co](https://metrics.torproject.org/rs.html#search/family:BABBE7B67010279491A1A0B5CF201B85EDB3D8DA)                                |            0.041 |      0    |       0    |         2 | 2019-11-11   |
|  496 | [Privex Inc. https://www.privex.io](https://metrics.torproject.org/rs.html#search/family:C3ACB0492A644E27A549BC3CDF3B7A129186E3BF)                                    |            0.041 |      0.07 |       0.03 |         2 | 2018-09-27   |
|  497 | [Farhaz Hofman &lt;farhaz AT gmail dot com&gt;](https://metrics.torproject.org/rs.html#details/DC9E3C6576CC9A04AAE1C465210A972A722571A0)                              |            0.041 |      0    |       0.06 |         1 | 2019-12-28   |
|  498 | [E4A23FEA](https://metrics.torproject.org/rs.html#details/E4A23FEACFA0D7064C6694BE91BF94805E3CE487)                                                                   |            0.041 |      0    |       0.06 |         1 | 2020-02-29   |
|  499 | [F4351525](https://metrics.torproject.org/rs.html#details/F43515257C548CCB741CB24453A81105E4EC5526)                                                                   |            0.041 |      0.14 |       0    |         1 | 2020-07-14   |
|  500 | [F5DB8E33](https://metrics.torproject.org/rs.html#details/F5DB8E33F8D351B600932251EFE67357485405F2)                                                                   |            0.041 |      0    |       0.06 |         1 | 2018-01-11   |
|  501 | [003BFA1B](https://metrics.torproject.org/rs.html#details/003BFA1B6CC5CBEFD5D0082F8FC9AF2A8868A8FB)                                                                   |            0.04  |      0    |       0.06 |         1 | 2018-12-11   |
|  502 | [Niccolo &lt;master@royalcourt.it&gt;](https://metrics.torproject.org/rs.html#search/family:114FB145113A8D53818F0BA9363DFBC81DC8447F)                                 |            0.04  |      0    |       0.06 |         2 | 2019-06-09   |
|  503 | [tor a web7seas dot com](https://metrics.torproject.org/rs.html#search/family:20974D28EB668E689D4256046E0E32034375A0A2)                                               |            0.04  |      0    |       0.06 |         3 | 2019-09-27   |
|  504 | [4096R/5819E33F Zhongfu Li &lt;tor at zhongfu dot li&gt;](https://metrics.torproject.org/rs.html#details/2E72EEABE4EE19183BEFAA10D88B3C16829C9F99)                    |            0.04  |      0    |       0.06 |         1 | 2016-08-02   |
|  505 | [6A35EE13](https://metrics.torproject.org/rs.html#details/6A35EE13D4354FF0A03374C063B10290614BB6A9)                                                                   |            0.04  |      0    |       0.06 |         1 | 2020-02-28   |
|  506 | [6B5A63BF](https://metrics.torproject.org/rs.html#details/6B5A63BFEEA8EF58DA812F4F05BE98C869809DFB)                                                                   |            0.04  |      0    |       0.06 |         1 | 2019-04-30   |
|  507 | [6DE7E3CC](https://metrics.torproject.org/rs.html#details/6DE7E3CC79ED6AA0F3F5E61D4D12D3EE018C18F8)                                                                   |            0.04  |      0    |       0.06 |         1 | 2020-07-25   |
|  508 | [PrivacyNowEU &lt;tor-relay AT privacynow DOT eu&gt;](https://metrics.torproject.org/rs.html#search/family:733CB01BFBABADA6AC5C363C4449D7D563C794C1)                  |            0.04  |      0    |       0.03 |         2 | 2020-01-05   |
|  509 | [7C1BEFB5](https://metrics.torproject.org/rs.html#details/7C1BEFB5D6897981ECE52817A2D3B702A9EB30D9)                                                                   |            0.04  |      0    |       0.06 |         1 | 2020-07-09   |
|  510 | [Random person &lt;toradmin@niekel.net&gt;](https://metrics.torproject.org/rs.html#details/AECF1E78CB116AD7105C88B1F08DBFD783E584B2)                                  |            0.04  |      0    |       0.06 |         1 | 2019-10-04   |
|  511 | [operator@somenice.relay](https://metrics.torproject.org/rs.html#details/B576A394DFC12B7E900D643C900484765D58C30F)                                                    |            0.04  |      0    |       0.06 |         1 | 2020-04-15   |
|  512 | [BEBA52AC](https://metrics.torproject.org/rs.html#details/BEBA52AC89045D6EAD68E977DF3F98BCF8330AAF)                                                                   |            0.04  |      0    |       0.06 |         1 | 2019-08-28   |
|  513 | [admin &lt;tor AT nazarick dot se&gt;](https://metrics.torproject.org/rs.html#details/BF50E09EED25B82861CF95E1AAA42DCFEF53E5D1)                                       |            0.04  |      0    |       0.06 |         1 | 2014-04-09   |
|  514 | [vysec@getnada.com](https://metrics.torproject.org/rs.html#search/family:1684B30AE2ADD371E5D3A8B3F28ACA4CE9CA2E00)                                                    |            0.039 |      0    |       0.06 |         2 | 2019-08-29   |
|  515 | [butary-tor@gmx.net](https://metrics.torproject.org/rs.html#details/1D361A2F1CAE4FDD5A85E13C168BE7075A100524)                                                         |            0.039 |      0    |       0.06 |         1 | 2018-11-11   |
|  516 | [31D270A3](https://metrics.torproject.org/rs.html#details/31D270A38505D4BFBBCABF717E9FB4BCA6DDF2FF)                                                                   |            0.039 |      0    |       0.06 |         1 | 2019-10-31   |
|  517 | [0xBDE438068A2BD353 postmaster@shh.sh](https://metrics.torproject.org/rs.html#search/family:39F096961ED2576975C866D450373A9913AFDC92)                                 |            0.039 |      0.1  |       0.01 |         2 | 2014-07-28   |
|  518 | [email:tor offtopica.uk operatorurl:http://56zvhl4](https://metrics.torproject.org/rs.html#details/4E5C4ED5CC70E5A32B48392FF72CC4BE24937EDA)                          |            0.039 |      0    |       0.06 |         1 | 2020-05-05   |
|  519 | [toruser819@pm.me](https://metrics.torproject.org/rs.html#details/6C9F1A9CA87546159E5D4C33C78128C26DF3CECD)                                                           |            0.039 |      0    |       0.06 |         1 | 2020-05-19   |
|  520 | [7600899E](https://metrics.torproject.org/rs.html#details/7600899E54FA28AABB1764548ED28CDEC96673B1)                                                                   |            0.039 |      0    |       0.06 |         1 | 2019-08-29   |
|  521 | [email:abuse luensmann.it abuse:abuse luensmann.i](https://metrics.torproject.org/rs.html#details/79509683AB4C8DDAF90A120C69A4179C6CD5A387)                           |            0.039 |      0    |       0.06 |         1 | 2018-10-13   |
|  522 | [See WHOIS](https://metrics.torproject.org/rs.html#details/7E44E0D39CE8666A98EA5DEBCBB8E12B3906410F)                                                                  |            0.039 |      0    |       0.06 |         1 | 2013-12-29   |
|  523 | [2048R/B640BF1A Tor Relay &lt;tor AT sec dot nl&gt;](https://metrics.torproject.org/rs.html#details/844AE9CAD04325E955E2BE1521563B79FE7094B7)                         |            0.039 |      0    |       0.06 |         1 | 2014-07-06   |
|  524 | [C1335B1D](https://metrics.torproject.org/rs.html#details/C1335B1DB938644FCD54EE744D91354F94EDD1BC)                                                                   |            0.039 |      0    |       0.06 |         1 | 2020-07-25   |
|  525 | [CB1EC403](https://metrics.torproject.org/rs.html#details/CB1EC403A7331FE26F218D178DF8908014CC4F65)                                                                   |            0.039 |      0    |       0.06 |         1 | 2018-08-17   |
|  526 | [tor@rkn.life](https://metrics.torproject.org/rs.html#details/F4A4D78F16E9A0353AD5BBEF4632C7022E20FB20)                                                               |            0.039 |      0    |       0.06 |         1 | 2018-03-14   |
|  527 | [Effi.org &lt;tor AT effi dot org&gt;](https://metrics.torproject.org/rs.html#search/family:00CCE6A84E6D63A1A42E105839BC8ED5D4B16669)                                 |            0.038 |      0.12 |       0    |         3 | 2018-11-13   |
|  528 | [0xFFFFFFFF Random Person &lt;nobody AT example dot co](https://metrics.torproject.org/rs.html#details/06E72526BBE040C51C5ADFBAA07ADD9AEB5E1FA1)                      |            0.038 |      0    |       0.06 |         1 | 2016-02-03   |
|  529 | [108D2042](https://metrics.torproject.org/rs.html#details/108D2042E505B85ECC0FB229EEA2327B8EC79E07)                                                                   |            0.038 |      0.12 |       0    |         1 | 2020-08-03   |
|  530 | [anavrin dot gmail.com](https://metrics.torproject.org/rs.html#details/17ABA734572DBB1050CF3800F0DD145BAE7ED9A7)                                                      |            0.038 |      0    |       0.06 |         1 | 2019-12-30   |
|  531 | [198F12E2](https://metrics.torproject.org/rs.html#details/198F12E2DEFBE6BEEBC38B2FEDD615AECB38DA7A)                                                                   |            0.038 |      0    |       0.06 |         1 | 2019-01-21   |
|  532 | [https://drkhsh.at](https://metrics.torproject.org/rs.html#details/1CDCB48F64E21D5ACAFE2471912E2E76F600EDFA)                                                          |            0.038 |      0    |       0.06 |         1 | 2019-01-24   |
|  533 | [1DC17C4A](https://metrics.torproject.org/rs.html#details/1DC17C4A52A458B5C8B1E79157F8665696210E10)                                                                   |            0.038 |      0    |       0.06 |         1 | 2017-07-26   |
|  534 | [tor at nasivt dot com](https://metrics.torproject.org/rs.html#details/224C3DD1DFF6F11219604870D48953249EE3C26F)                                                      |            0.038 |      0    |       0.06 |         1 | 2020-01-26   |
|  535 | [tor@pbz.im](https://metrics.torproject.org/rs.html#details/2BAF092E8667C00CA3D9686C76D8EC3CC6BC7C5B)                                                                 |            0.038 |      0    |       0    |         1 | 2019-10-09   |
|  536 | [potlatch protonmail com](https://metrics.torproject.org/rs.html#search/family:373BF7A2CD16E86D4C5BEC591A41945C9AED392D)                                              |            0.038 |      0.12 |       0    |         7 | 2015-12-31   |
|  537 | [damienjamesh at yahoo dot com](https://metrics.torproject.org/rs.html#details/3B953203AF332D8FE1452E1CE7CB50A3B5297DB2)                                              |            0.038 |      0    |       0.06 |         1 | 2020-07-11   |
|  538 | [4561FC08](https://metrics.torproject.org/rs.html#details/4561FC085C3F3A7271FE960317F02DCD1E9C1188)                                                                   |            0.038 |      0    |       0.06 |         1 | 2019-01-26   |
|  539 | [513753D2](https://metrics.torproject.org/rs.html#details/513753D2C4A1246DCC21241C5BE5022CCBD2645C)                                                                   |            0.038 |      0    |       0.06 |         1 | 2018-12-11   |
|  540 | [761A60D0](https://metrics.torproject.org/rs.html#details/761A60D0364D9AA03114F72550483287ED060B2D)                                                                   |            0.038 |      0    |       0.06 |         1 | 2020-07-19   |
|  541 | [7FF1A673](https://metrics.torproject.org/rs.html#details/7FF1A673A5E1F7E9D2495A36C185B890DBD96553)                                                                   |            0.038 |      0    |       0    |         1 | 2019-11-27   |
|  542 | [EF201A39 &lt;nat@makarevitch.org&gt;](https://metrics.torproject.org/rs.html#details/9456BBB3FB923DD1CDEC5C8B45D9615BC937DC42)                                       |            0.038 |      0    |       0.06 |         1 | 2015-12-25   |
|  543 | [nomailplx at no dot com](https://metrics.torproject.org/rs.html#details/9ECEC047BA0596C51EDD098616C8A86697A12824)                                                    |            0.038 |      0.12 |       0    |         1 | 2020-02-20   |
|  544 | [mytormailjustfortor@gmail.com](https://metrics.torproject.org/rs.html#details/B058FBDEA69774C28EAC1111E167BC0AD4A904E0)                                              |            0.038 |      0    |       0.06 |         1 | 2020-04-23   |
|  545 | [B70629C2](https://metrics.torproject.org/rs.html#details/B70629C29A032979E5AD00CC51D2330845AAFD6A)                                                                   |            0.038 |      0    |       0.06 |         1 | 2016-07-27   |
|  546 | [vaultboy admin &lt;vaultoby AT psy-bunker dot de&gt;](https://metrics.torproject.org/rs.html#details/BF6DDC1689990D2AF82E7300D7CC632845D6F14C)                       |            0.038 |      0    |       0.06 |         1 | 2019-04-17   |
|  547 | [D9E05ACC](https://metrics.torproject.org/rs.html#details/D9E05ACC33D780264D8968816CAC4346D97AC63C)                                                                   |            0.038 |      0.12 |       0    |         1 | 2020-06-28   |
|  548 | [WonderWoman42@xs4all.nl](https://metrics.torproject.org/rs.html#details/E5AA85FA69CDC31900C86E6427C7E5DE11DE9E2D)                                                    |            0.038 |      0    |       0.06 |         1 | 2019-11-03   |
|  549 | [marc@tronic-studio.com](https://metrics.torproject.org/rs.html#details/FB691D6E3FEE35C6979EE72AF03A53DD861B4CBB)                                                     |            0.038 |      0    |       0    |         1 | 2019-10-10   |
|  550 | [201A38EB](https://metrics.torproject.org/rs.html#details/201A38EB5484A1407436125753A316C81EF50678)                                                                   |            0.037 |      0    |       0.06 |         1 | 2018-12-16   |
|  551 | [tor at dereferenced net](https://metrics.torproject.org/rs.html#details/2BA2C8E96B2590E1072AECE2BDB5C48921BF8510)                                                    |            0.037 |      0    |       0.06 |         1 | 2014-03-01   |
|  552 | [3076FB1C](https://metrics.torproject.org/rs.html#details/3076FB1CCEB8341322019AD26F69BFC0AA845334)                                                                   |            0.037 |      0    |       0.06 |         1 | 2020-07-17   |
|  553 | [33925888](https://metrics.torproject.org/rs.html#search/family:33925888F5DB4CD014E5718CB3B1FC82BFE1AD37)                                                             |            0.037 |      0    |       0.06 |         3 | 2018-01-23   |
|  554 | [3EEEB702](https://metrics.torproject.org/rs.html#details/3EEEB7021D974D38B6D97BEFB55E5E48551A8FEA)                                                                   |            0.037 |      0    |       0.06 |         1 | 2020-02-28   |
|  555 | [tor-operator@maxwellfarrior.tech](https://metrics.torproject.org/rs.html#details/4B483F57D9660EBF33FA3CCA670FFD1BBB0F315A)                                           |            0.037 |      0    |       0.06 |         1 | 2020-08-03   |
|  556 | [Katharina@gmx.org](https://metrics.torproject.org/rs.html#details/5856DB884578915E7C7A0B7B11E4145B1D2A4E2B)                                                          |            0.037 |      0    |       0    |         1 | 2020-02-05   |
|  557 | [tor@public-files.de - BTC: 36gSVWiqAsuCyoRPoVgiCFM](https://metrics.torproject.org/rs.html#details/6118DDB580EEDD6FE5F8D3CC0DF1EE17D8A2A4C6)                         |            0.037 |      0    |       0.06 |         1 | 2018-02-02   |
|  558 | [0xAAF5E25904F58A0F52BE1DA5BECFF25F495915B7 Absturz](https://metrics.torproject.org/rs.html#details/72A33E374DE5AD1E617394896F0FD8B092D3E7C4)                         |            0.037 |      0    |       0.06 |         1 | 2018-09-30   |
|  559 | [901A95E8](https://metrics.torproject.org/rs.html#details/901A95E871F13D9B6DB6A3A03A1F40C912DA6853)                                                                   |            0.037 |      0    |       0    |         1 | 2020-08-05   |
|  560 | [94318CC2](https://metrics.torproject.org/rs.html#details/94318CC2299A3826D81899EB23C25A2B7D6B1FFE)                                                                   |            0.037 |      0    |       0.06 |         1 | 2019-01-11   |
|  561 | [tor &lt;notelonmusk@tutonia.com&gt;](https://metrics.torproject.org/rs.html#details/963879BB424D9A637A63105D5C26A2453C2C2272)                                        |            0.037 |      0    |       0.06 |         1 | 2020-01-31   |
|  562 | [torpids AT yahoo dot com - 1JYHfzVFVD7n2Sezz3DEHDF](https://metrics.torproject.org/rs.html#details/9E1E4F5B5F94812D02C4D18CB4086CE71CA5C614)                         |            0.037 |      0    |       0.06 |         1 | 2018-01-26   |
|  563 | [A3432E9F](https://metrics.torproject.org/rs.html#details/A3432E9FDEB8CBD1BED2DBEC1EDDE627DD8803E4)                                                                   |            0.037 |      0.12 |       0    |         1 | 2020-07-23   |
|  564 | [A779E0C9](https://metrics.torproject.org/rs.html#details/A779E0C961715B0C33B35DD39803464B581FBF73)                                                                   |            0.037 |      0.12 |       0    |         1 | 2020-08-03   |
|  565 | [BD6FFF1A](https://metrics.torproject.org/rs.html#details/BD6FFF1AD5A88A8D43870D43EC4450081B4B2BBA)                                                                   |            0.037 |      0    |       0.06 |         1 | 2017-10-27   |
|  566 | [contact at SilSte on Twitter tor-relay.co](https://metrics.torproject.org/rs.html#details/CC6910CF21D17C1BD68FE224CE7685BEB42558A8)                                  |            0.037 |      0    |       0    |         1 | 2018-11-11   |
|  567 | [Gijs Rijnders tor AT ip-eend DOT nl](https://metrics.torproject.org/rs.html#details/DB5A100152FB7937F02F00B5DDFFFD012789C242)                                        |            0.037 |      0    |       0    |         1 | 2017-08-14   |
|  568 | [lost-ark-tor AT protonmail dot com](https://metrics.torproject.org/rs.html#details/F3936F97C14EFCFD18154DF4443B91FEDD071F47)                                         |            0.037 |      0    |       0.06 |         1 | 2020-07-26   |
|  569 | [Tor Operator &lt;tor@hezmatt.org&gt;](https://metrics.torproject.org/rs.html#details/F83A64E0FA85BC224807919772FE14E1BA07CEF5)                                       |            0.037 |      0    |       0    |         1 | 2013-01-03   |
|  570 | [026E53D9](https://metrics.torproject.org/rs.html#search/family:026E53D9AA2FF22217B215B57E4C4B4EF196FCD5)                                                             |            0.036 |      0.09 |       0    |         4 | 2020-03-01   |
|  571 | [head@bulletproof.ml-47dhf2sh4xcdvq1](https://metrics.torproject.org/rs.html#details/0B97514C2C0D07593600281626073571D7071749)                                        |            0.036 |      0    |       0.06 |         1 | 2020-05-21   |
|  572 | [neyam@pm.me](https://metrics.torproject.org/rs.html#details/64A0B5722613DDFC2EB84897C550FBF4A096DE0D)                                                                |            0.036 |      0    |       0.06 |         1 | 2018-11-08   |
|  573 | [67CDF7A4](https://metrics.torproject.org/rs.html#details/67CDF7A4D06E98E55AAE595BBEBF38E64C4CCBF3)                                                                   |            0.036 |      0    |       0.06 |         1 | 2017-05-31   |
|  574 | [69534B8B](https://metrics.torproject.org/rs.html#details/69534B8B5FCCD0BF1124945B1D0F5A35FB0A3542)                                                                   |            0.036 |      0    |       0.06 |         1 | 2020-07-25   |
|  575 | [Nate Mathews &lt;nate DOT mathews AT mail DOT rit DOT](https://metrics.torproject.org/rs.html#details/73DCA56424912F69F1478D6630DF27CFE8F41439)                      |            0.036 |      0    |       0.06 |         1 | 2019-10-14   |
|  576 | [iamathletesbyathletes@gmail.com](https://metrics.torproject.org/rs.html#details/75FE5236E67FFA4A44C1152C35EAB36360E4D7DF)                                            |            0.036 |      0    |       0.06 |         1 | 2019-06-01   |
|  577 | [76543749](https://metrics.torproject.org/rs.html#details/76543749510CD00CB16E1DD4940CAA8FAC727F58)                                                                   |            0.036 |      0    |       0.06 |         1 | 2019-09-02   |
|  578 | [hanssarpei2012@gmail.com](https://metrics.torproject.org/rs.html#details/883F49ECDF48809308C0E5409E5A264B94050140)                                                   |            0.036 |      0    |       0.06 |         1 | 2020-05-16   |
|  579 | [relay at luke j dot me](https://metrics.torproject.org/rs.html#details/AC2275831607A95CD8B939C3B8DC466CCF48E2B9)                                                     |            0.036 |      0    |       0.06 |         1 | 2019-09-05   |
|  580 | [DaPorkchop &lt;fredbobson7@gmail.com&gt;](https://metrics.torproject.org/rs.html#details/AC5CECEF6AF649F2A7F047D102FE9B461DA9234E)                                   |            0.036 |      0    |       0.06 |         1 | 2019-07-01   |
|  581 | [scotch](https://metrics.torproject.org/rs.html#details/B7A115C65ED1AA30C15E11A19A68EB5AAE7ED0C4)                                                                     |            0.036 |      0.12 |       0    |         1 | 2020-04-06   |
|  582 | [fak3@tuta.io](https://metrics.torproject.org/rs.html#details/D7829A21726220AF77401BE5B2B132963A0BE82B)                                                               |            0.036 |      0    |       0    |         1 | 2019-06-13   |
|  583 | [William Gauthier &lt;tor AT wjg dot dk&gt;](https://metrics.torproject.org/rs.html#details/D965855F77A59FBBC5D1224DFB9C12A992355079)                                 |            0.036 |      0    |       0.06 |         1 | 2018-09-16   |
|  584 | [Florian Tschorsch &lt;tor@dsi.tu-berlin.de&gt;](https://metrics.torproject.org/rs.html#details/E91905CFEB230B1BEA6B0309816F9EE9C1A1A83A)                             |            0.036 |      0.12 |       0    |         1 | 2018-08-17   |
|  585 | [F8E81467](https://metrics.torproject.org/rs.html#details/F8E8146710DB20F440DB481A68168B831DFEC8EA)                                                                   |            0.036 |      0.12 |       0    |         1 | 2020-08-03   |
|  586 | [MrDetonia &lt;mrdetonia AT protonmail DOT com&gt;](https://metrics.torproject.org/rs.html#details/02928855BFAD787F8B363F21860D1E7D156E0655)                          |            0.035 |      0    |       0.06 |         1 | 2016-09-02   |
|  587 | [0xEFF5B2E180F294CE - &lt;caioau underscore tor at ris](https://metrics.torproject.org/rs.html#search/family:0338F9F55111FE8E3570E7DE117EF3AF999CC1D7)                |            0.035 |      0    |       0.05 |         2 | 2017-11-06   |
|  588 | [tor-relay@akarl.eu](https://metrics.torproject.org/rs.html#details/04A28A62F27D9C4A60F9ED0C4264E98B988C65A3)                                                         |            0.035 |      0    |       0.06 |         1 | 2017-07-20   |
|  589 | [Random Person &lt;gbe@v--o pbz rot13 &gt;](https://metrics.torproject.org/rs.html#details/0C8A49FE62B7C7DED64B7C6A941EF5240E4F3F74)                                  |            0.035 |      0    |       0    |         1 | 2019-06-15   |
|  590 | [jjaytehjetplane@gmail.com](https://metrics.torproject.org/rs.html#details/3BB035514F8246AC367B5370F4FE120BB11D8C6D)                                                  |            0.035 |      0    |       0.05 |         1 | 2015-12-02   |
|  591 | [575F15A0](https://metrics.torproject.org/rs.html#details/575F15A0A41B951BEE03E25B2A0A3FC3E8D7C7D1)                                                                   |            0.035 |      0    |       0.06 |         1 | 2020-07-24   |
|  592 | [tor at k-ten dot de](https://metrics.torproject.org/rs.html#details/5CF342DBBD6170BEE00CD52ACB4076D551085E7F)                                                        |            0.035 |      0    |       0.06 |         1 | 2019-06-15   |
|  593 | [peter at fnord dot org tor-relay.co](https://metrics.torproject.org/rs.html#details/79D110419709C4B3D1F92FC3CE121B5317DBE8B3)                                        |            0.035 |      0    |       0.05 |         1 | 2019-06-23   |
|  594 | [A8FEC75C](https://metrics.torproject.org/rs.html#details/A8FEC75C75C24997467B15603DBDE43D108DEE75)                                                                   |            0.035 |      0    |       0.05 |         1 | 2020-03-25   |
|  595 | [malt](https://metrics.torproject.org/rs.html#details/A9860C42EF532379E846087802646B5D4BCB17BE)                                                                       |            0.035 |      0.11 |       0    |         1 | 2020-04-06   |
|  596 | [See WHOIS](https://metrics.torproject.org/rs.html#details/B2D03CDF45EB4D74A65FAC4F00EBA785C9663A5F)                                                                  |            0.035 |      0    |       0.06 |         1 | 2020-01-24   |
|  597 | [BFB14B9A](https://metrics.torproject.org/rs.html#details/BFB14B9ADF1F19E59258CAE7FCDBAAC9937B7B10)                                                                   |            0.035 |      0    |       0.06 |         1 | 2019-11-01   |
|  598 | [C81B6B1A](https://metrics.torproject.org/rs.html#details/C81B6B1A13CC474700D0F3FCAE9533E2BAFAC3DD)                                                                   |            0.035 |      0    |       0.05 |         1 | 2019-10-12   |
|  599 | [Tor Operator &lt;relay-project AT protonmail DOT com&gt;](https://metrics.torproject.org/rs.html#search/family:CB56CBA82FADE2DE7C0CBD19ECF776C7FF0586BE)             |            0.035 |      0    |       0.06 |         2 | 2019-11-08   |
|  600 | [timo at kox dot email tor-relay.co](https://metrics.torproject.org/rs.html#details/ECFBD2E11F751FF803740CFA0D012EEC0C678446)                                         |            0.035 |      0.12 |       0    |         1 | 2020-07-22   |
|  601 | [contact at SilSte on Twitter tor-relay.co](https://metrics.torproject.org/rs.html#details/163303F0583A1917326214379BD1AB2D286046EA)                                  |            0.034 |      0    |       0.05 |         1 | 2019-04-05   |
|  602 | [345E03CE](https://metrics.torproject.org/rs.html#details/345E03CEFB7BF04613FCA14532F38D1BB9EDBD47)                                                                   |            0.034 |      0.11 |       0    |         1 | 2019-10-31   |
|  603 | [BitcoinTo.Me](https://metrics.torproject.org/rs.html#details/7D8EBB86CF2EB560F938BEF018E1D8FD6B36B327)                                                               |            0.034 |      0    |       0.05 |         1 | 2019-11-05   |
|  604 | [8A6F5A21](https://metrics.torproject.org/rs.html#details/8A6F5A21493685B50F1B46A87A2099D6C410F237)                                                                   |            0.034 |      0    |       0.05 |         1 | 2020-06-27   |
|  605 | [none](https://metrics.torproject.org/rs.html#details/9B5ED3370E002AEBB2A9B25E3213C1817CCD2D88)                                                                       |            0.034 |      0    |       0.05 |         1 | 2017-12-13   |
|  606 | [Strelnikov a t bahnhof at se](https://metrics.torproject.org/rs.html#search/family:A0BD104E35D36F5630B01EB5370597EB09204C99)                                         |            0.034 |      0    |       0.02 |         2 | 2020-07-08   |
|  607 | [rye](https://metrics.torproject.org/rs.html#details/D762D707FC56ED169D74C7844516B46213E19DE2)                                                                        |            0.034 |      0.11 |       0    |         1 | 2020-04-06   |
|  608 | [03E0F4EE](https://metrics.torproject.org/rs.html#details/03E0F4EE272731601773F48E64240D3A8896A5E3)                                                                   |            0.033 |      0    |       0.05 |         1 | 2020-02-13   |
|  609 | [alkyl-tor@riseup.net](https://metrics.torproject.org/rs.html#search/family:064D3C4CC1B854839B0979FE1C2F05ABAB7F9D68)                                                 |            0.033 |      0.11 |       0    |         2 | 2017-12-03   |
|  610 | [0A76B6B0](https://metrics.torproject.org/rs.html#details/0A76B6B0977C782BF804CB0830F8DBFD0E141EAD)                                                                   |            0.033 |      0    |       0.05 |         1 | 2020-06-02   |
|  611 | [13B2354C](https://metrics.torproject.org/rs.html#details/13B2354C74CCE29815B4E1F692F2F0E86C7F13DD)                                                                   |            0.033 |      0    |       0.05 |         1 | 2016-08-24   |
|  612 | [Dmitrii Tcvetkov email:demfloro demfloro.ru keyba](https://metrics.torproject.org/rs.html#search/family:19109FAE0E9EE366FF94EC6A477C3B33E798D181)                    |            0.033 |      0.06 |       0.02 |         4 | 2019-06-02   |
|  613 | [2F9AFDE4](https://metrics.torproject.org/rs.html#details/2F9AFDE43DC8E3F05803304C01BD3DBF329169AC)                                                                   |            0.033 |      0    |       0.05 |         1 | 2018-01-04   |
|  614 | [Tor Admin &lt;toradmin AT veilsoftheonion DOT eu&gt;](https://metrics.torproject.org/rs.html#search/family:55580D71B317A072F4A4DCF6EA4EDB015734AEE7)                 |            0.033 |      0    |       0.01 |         2 | 2018-08-27   |
|  615 | [contact at SilSte on Twitter tor-relay.co](https://metrics.torproject.org/rs.html#details/60A9E1FE4D020383A4A0FE58E5950983D08D65E7)                                  |            0.033 |      0    |       0    |         1 | 2018-11-11   |
|  616 | [torrelay@brave.com](https://metrics.torproject.org/rs.html#search/family:6E8E5CA9B6F567416ADA21E990E7746BC223B0C0)                                                   |            0.033 |      0    |       0.05 |         6 | 2018-03-01   |
|  617 | [ludibriun at protonmail dot ch tor-relay.co](https://metrics.torproject.org/rs.html#details/7B0D94D348D9F98C50B6674C5CB17AF35EA2605F)                                |            0.033 |      0    |       0.05 |         1 | 2020-05-24   |
|  618 | [Brad Koehn &lt;tor@koehn.com&gt;](https://metrics.torproject.org/rs.html#search/family:7ECF294C43DB959BDC0E7EFC913C3AC231DE7442)                                     |            0.033 |      0    |       0.05 |         2 | 2017-01-25   |
|  619 | [Kai &lt;anon AT kai dot sx&gt;](https://metrics.torproject.org/rs.html#search/family:8646226690C1D4F2DDC3021F89909A26A8C32A27)                                       |            0.033 |      0    |       0.05 |         2 | 2015-05-01   |
|  620 | [8A57DA2F](https://metrics.torproject.org/rs.html#details/8A57DA2FFB5BA49C041EDE1A095E33E86EA756CC)                                                                   |            0.033 |      0    |       0.05 |         1 | 2020-01-10   |
|  621 | [fast.me323@mail.com](https://metrics.torproject.org/rs.html#details/8C601BFCF56E25120C18A18B9856010A8BD659BD)                                                        |            0.033 |      0.11 |       0    |         1 | 2020-07-21   |
|  622 | [x at y dot z tor-relay.co](https://metrics.torproject.org/rs.html#details/9171E15EBF665768F8EFAE2271D47D922C4EED46)                                                  |            0.033 |      0    |       0.05 |         1 | 2018-02-09   |
|  623 | [ACAE2A70](https://metrics.torproject.org/rs.html#details/ACAE2A7000B2BEB08704AAA0A2DDCADD68E58A63)                                                                   |            0.033 |      0    |       0.05 |         1 | 2018-03-20   |
|  624 | [tor-operator@TooM.Fr](https://metrics.torproject.org/rs.html#details/ADD35A22BF77D56AFC18CF58E5D8E2604B8985CF)                                                       |            0.033 |      0    |       0.05 |         1 | 2020-01-09   |
|  625 | [BA79B1B8](https://metrics.torproject.org/rs.html#details/BA79B1B8CE8F253C5CD6601A5005C268A7D7F561)                                                                   |            0.033 |      0.11 |       0    |         1 | 2020-08-03   |
|  626 | [2fjsaf2ja4da@protonmail.com](https://metrics.torproject.org/rs.html#details/CDA2C336AD87E22DF02983887A3F74B21070D02D)                                                |            0.033 |      0    |       0    |         1 | 2020-04-06   |
|  627 | [&lt;nobody AT example dot com&gt;](https://metrics.torproject.org/rs.html#details/D53AE170BF6650A2C6640484FE1B5DD1C0AB895B)                                          |            0.033 |      0    |       0.05 |         1 | 2019-12-14   |
|  628 | [4096R/0x4cf76925833e2e24 Knight &lt;knight AT germanc](https://metrics.torproject.org/rs.html#details/DB2682153AC0CCAECD2BD1E9EBE99C6815807A1E)                      |            0.033 |      0    |       0.05 |         1 | 2017-11-19   |
|  629 | [EC4D5621](https://metrics.torproject.org/rs.html#details/EC4D5621785D34EA1AD61BF1810C20F38C3B9C23)                                                                   |            0.033 |      0.11 |       0    |         1 | 2020-08-03   |
|  630 | [FE1B74C7](https://metrics.torproject.org/rs.html#details/FE1B74C7CEE0493613929A92F9A1D890E58DC649)                                                                   |            0.033 |      0    |       0.05 |         1 | 2018-10-02   |
|  631 | [04DFE047](https://metrics.torproject.org/rs.html#details/04DFE047ACDF7A6620ACA782FAFC5EF1AE7F4754)                                                                   |            0.032 |      0    |       0.05 |         1 | 2019-04-17   |
|  632 | [0x77C3D4B4F6A3D33F nullpointer](https://metrics.torproject.org/rs.html#search/family:13F7EAE731CA4600951986921E08ECAB9B1D2AF6)                                       |            0.032 |      0    |       0.05 |         3 | 2018-03-20   |
|  633 | [ruhtra.mar@gmail.com](https://metrics.torproject.org/rs.html#details/25E078CD1E537A7418318168F7E1990EF2A160C8)                                                       |            0.032 |      0    |       0.05 |         1 | 2017-11-20   |
|  634 | [Beet@protonmail.com](https://metrics.torproject.org/rs.html#details/287E1041DFC3A03E1650A61ADF580EA1C6BF3649)                                                        |            0.032 |      0.1  |       0    |         1 | 2020-04-06   |
|  635 | [tor@wormhole.eu](https://metrics.torproject.org/rs.html#details/2DF58694C18525A4892F514D01039BCF44A05433)                                                            |            0.032 |      0    |       0.05 |         1 | 2019-11-16   |
|  636 | [DexterAdmin &lt;dexter@prj.hu&gt;](https://metrics.torproject.org/rs.html#details/3BADB3EFFB87534736BFAC9A2024AB78401BDBC3)                                          |            0.032 |      0    |       0    |         1 | 2012-11-18   |
|  637 | [tor-atomsk@protonmail.com](https://metrics.torproject.org/rs.html#details/44354E35E9F7F97AF27686D03B0D591686E35394)                                                  |            0.032 |      0    |       0.05 |         1 | 2020-04-04   |
|  638 | [noshit@pollekeg.com](https://metrics.torproject.org/rs.html#search/family:6532EB51C1EA8B674F4AEFCFA31323AE4C4212E4)                                                  |            0.032 |      0    |       0.05 |         4 | 2019-12-22   |
|  639 | [8404E8B8](https://metrics.torproject.org/rs.html#details/8404E8B8AAB98208FAEFB1727B637133AD9C6FAF)                                                                   |            0.032 |      0    |       0.05 |         1 | 2019-02-10   |
|  640 | [8F22AFDD](https://metrics.torproject.org/rs.html#details/8F22AFDD06AA4238ADD93A8EA6FBC2BB9C652711)                                                                   |            0.032 |      0    |       0.05 |         1 | 2017-03-01   |
|  641 | [hfj at ru dot de](https://metrics.torproject.org/rs.html#details/8FDEAE759A90C648863BED85D07113D3FA2AA6FF)                                                           |            0.032 |      0.1  |       0    |         1 | 2020-02-20   |
|  642 | [97767B43](https://metrics.torproject.org/rs.html#details/97767B43E78119A613B46CEAF81A788F45CC05D9)                                                                   |            0.032 |      0    |       0.05 |         1 | 2019-06-17   |
|  643 | [9B1BE5D2](https://metrics.torproject.org/rs.html#details/9B1BE5D20FB9069523EF4889027325CE89B42460)                                                                   |            0.032 |      0    |       0.05 |         1 | 2020-05-20   |
|  644 | [BF7BFCB3](https://metrics.torproject.org/rs.html#details/BF7BFCB3096FC81FBD0B7ADA66164431EC7FD117)                                                                   |            0.032 |      0    |       0.05 |         1 | 2015-11-30   |
|  645 | [1024D/0x49360B3B1DFBA164 Bernhard M. Wiedemann &lt;to](https://metrics.torproject.org/rs.html#details/D123C0F8F562804693C47D68C61786023B295E98)                      |            0.032 |      0    |       0    |         1 | 2013-09-03   |
|  646 | [Vasil Kolev &lt;tor@ludost.net&gt;](https://metrics.torproject.org/rs.html#details/D8EA105E79803FB0040A8C2A676D93DAEA2CFFF0)                                         |            0.032 |      0    |       0.05 |         1 | 2019-06-08   |
|  647 | [0x1EB0818D &lt;tor@puenter.org&gt;](https://metrics.torproject.org/rs.html#details/F3DF2415A5ECFB57835CF7E629C3AD0E1DA6732B)                                         |            0.032 |      0    |       0    |         1 | 2019-11-23   |
|  648 | [&lt;tor -at- interfesse.net&gt;](https://metrics.torproject.org/rs.html#details/F6D600CF13B3BBE2A91A0653F1EC9D00E7CB3A6B)                                            |            0.032 |      0    |       0.05 |         1 | 2020-01-03   |
|  649 | [namedrelay@protonmail.com](https://metrics.torproject.org/rs.html#details/F966CC62522A4F9C482CB555D43249A9874413D8)                                                  |            0.032 |      0    |       0.05 |         1 | 2020-03-18   |
|  650 | [FlashTor at e.mail.de](https://metrics.torproject.org/rs.html#search/family:0A5000E5FF2977E0D236B9F5B47590D8888494DF)                                                |            0.031 |      0    |       0.03 |         7 | 2017-11-25   |
|  651 | [0C6CA581](https://metrics.torproject.org/rs.html#details/0C6CA58153400FA077EABB14773E36FD61BF0D75)                                                                   |            0.031 |      0    |       0.05 |         1 | 2020-01-10   |
|  652 | [316DE45E](https://metrics.torproject.org/rs.html#search/family:316DE45EFFB53671C9FD53CE0992952846709A29)                                                             |            0.031 |      0    |       0.05 |         4 | 2018-12-27   |
|  653 | [4C9C83E7](https://metrics.torproject.org/rs.html#details/4C9C83E72EAAB5AE889FFBF726658AA996D6B013)                                                                   |            0.031 |      0.1  |       0    |         1 | 2020-08-03   |
|  654 | [4F06398B](https://metrics.torproject.org/rs.html#details/4F06398BD45754A46EE79B49421E0211ADB5B139)                                                                   |            0.031 |      0.1  |       0    |         1 | 2020-08-03   |
|  655 | [55E890DB](https://metrics.torproject.org/rs.html#details/55E890DB4F58495A0F6CB379A2EADD047DF2E86B)                                                                   |            0.031 |      0    |       0.05 |         1 | 2020-06-09   |
|  656 | [5F397DA9](https://metrics.torproject.org/rs.html#details/5F397DA94086F2481FD91441B16D29F858372FFE)                                                                   |            0.031 |      0.1  |       0    |         1 | 2020-08-03   |
|  657 | [Carrot@protonmail.com](https://metrics.torproject.org/rs.html#details/62A6C055FD46328B4BAFDB9D2D4E0F912CE70C49)                                                      |            0.031 |      0.1  |       0    |         1 | 2020-04-06   |
|  658 | [903A2A79](https://metrics.torproject.org/rs.html#details/903A2A7991C838E70FF5A586CD387749B3589669)                                                                   |            0.031 |      0    |       0.05 |         1 | 2018-04-20   |
|  659 | [Crasoke crasoke@gmail.com](https://metrics.torproject.org/rs.html#details/9A51C5D79C30B9F3B527EC77EF901DDAB76C3AB5)                                                  |            0.031 |      0    |       0.05 |         1 | 2020-06-02   |
|  660 | [acab.io &lt;1312 AT acab dot io&gt;](https://metrics.torproject.org/rs.html#details/B86BE002D4D6F3E2999E8EEAC9B72CAA796944BE)                                        |            0.031 |      0    |       0.05 |         1 | 2020-04-25   |
|  661 | [alienpup@gmail.com](https://metrics.torproject.org/rs.html#details/BF735F669481EE1CCC348F0731551C933D1E2278)                                                         |            0.031 |      0    |       0.05 |         1 | 2017-08-12   |
|  662 | [C37F87C0](https://metrics.torproject.org/rs.html#details/C37F87C0125E26E6ACF54366FA2198209E856ABE)                                                                   |            0.031 |      0    |       0.05 |         1 | 2016-02-03   |
|  663 | [D24FB714](https://metrics.torproject.org/rs.html#search/family:D24FB714345D4B9061CEA89ACBAD343081F14928)                                                             |            0.031 |      0    |       0.05 |         2 | 2019-09-06   |
|  664 | [Contact at SilSte on Twitter tor-relay.co](https://metrics.torproject.org/rs.html#details/D907BCD0B9510C462EEB0688FD5421CD2E172B77)                                  |            0.031 |      0    |       0.05 |         1 | 2018-04-12   |
|  665 | [DEF35CE8](https://metrics.torproject.org/rs.html#details/DEF35CE8FCC5B5ED35DEC379A9EDF420FF419677)                                                                   |            0.031 |      0    |       0.05 |         1 | 2020-05-17   |
|  666 | [abuse at yggdrasil dot ws](https://metrics.torproject.org/rs.html#details/02930FFEB87968D518101EB79202F1C3766078DA)                                                  |            0.03  |      0.1  |       0    |         1 | 2020-02-11   |
|  667 | [root AT bungee DOT systems](https://metrics.torproject.org/rs.html#search/family:06B308F54B4A779D74B30536964182A09C08AB8F)                                           |            0.03  |      0.05 |       0.02 |         2 | 2020-01-22   |
|  668 | [Jordan &lt;jordan@yui.cat&gt;](https://metrics.torproject.org/rs.html#search/family:199A94608654D2C8AB6807EA8CAA9C783C78B70A)                                        |            0.03  |      0.06 |       0.01 |         3 | 2017-12-29   |
|  669 | [sqrrm@tutanota.com](https://metrics.torproject.org/rs.html#search/family:1B9C26C1DAB190EAD3EBADB70914E0949ADC2588)                                                   |            0.03  |      0    |       0.05 |         4 | 2018-04-10   |
|  670 | [210001EE](https://metrics.torproject.org/rs.html#search/family:210001EE8A8E086983A3BD48F0D936996451C9CB)                                                             |            0.03  |      0.04 |       0.02 |         2 | 2018-09-05   |
|  671 | [3419CC27](https://metrics.torproject.org/rs.html#details/3419CC27CE8BB4070F2C6DF4E34770614C38A199)                                                                   |            0.03  |      0.1  |       0    |         1 | 2020-08-03   |
|  672 | [Random Person &lt;neuneu AT neuninou DOT ovh&gt;](https://metrics.torproject.org/rs.html#search/family:3FF88CAE0BCE85191D8DBBD0BE0E62156AB631AB)                     |            0.03  |      0    |       0.05 |         2 | 2020-06-22   |
|  673 | [Info &lt;mainst.anytown AT yahoo dot com&gt;](https://metrics.torproject.org/rs.html#search/family:45FCDC4CDF7A7F7D9A7BEA65A63D6AD02AB5D63F)                         |            0.03  |      0.1  |       0    |         3 | 2019-02-19   |
|  674 | [4EBE3B18](https://metrics.torproject.org/rs.html#details/4EBE3B18F7D38D0A2FDD67B47A55CB9069368723)                                                                   |            0.03  |      0    |       0.05 |         1 | 2018-07-07   |
|  675 | [i=e: DutchTorRilay -AT- posteo -DOT- nl](https://metrics.torproject.org/rs.html#search/family:4EC0550FFC37D883892E4CACA49F9C29BB1E6ECD)                              |            0.03  |      0    |       0.05 |         2 | 2018-02-06   |
|  676 | [60CA2957](https://metrics.torproject.org/rs.html#details/60CA295745930AFA59DB73F877834B4100C7B712)                                                                   |            0.03  |      0    |       0.05 |         1 | 2020-03-20   |
|  677 | [6FB41ED1](https://metrics.torproject.org/rs.html#details/6FB41ED1D68FCC399DCE81600CE30360DCFFE263)                                                                   |            0.03  |      0.1  |       0    |         1 | 2014-08-27   |
|  678 | [Contact at SilSte on Twitter tor-relay.co](https://metrics.torproject.org/rs.html#details/7260949459C2D4D4A5ABC3AC10C1AD6939E6525C)                                  |            0.03  |      0    |       0.05 |         1 | 2020-05-22   |
|  679 | [92E807AC](https://metrics.torproject.org/rs.html#details/92E807AC5E23CCD9FE623EA4DC020B1627A0D09B)                                                                   |            0.03  |      0    |       0.05 |         1 | 2020-03-26   |
|  680 | [Jon Proulx &lt;jon AT csail dot mit dot edu&gt; GPG Key](https://metrics.torproject.org/rs.html#search/family:9715C81BA8C5B0C698882035F75C67D6D643DBE3)              |            0.03  |      0.04 |       0.02 |         2 | 2013-09-28   |
|  681 | [tor at ewigschlau dot de tor-relay.co](https://metrics.torproject.org/rs.html#search/family:A59AD84F92B2E5A76EBFE3BE62D3B28AF9BFD127)                                |            0.03  |      0.04 |       0.02 |         2 | 2020-06-27   |
|  682 | [A96DA63E](https://metrics.torproject.org/rs.html#details/A96DA63E4415E776FBFCCF3DA7154C804534B6E7)                                                                   |            0.03  |      0    |       0.05 |         1 | 2019-11-29   |
|  683 | [noc =at= schokomil.ch](https://metrics.torproject.org/rs.html#search/family:AC2BEDD0BAC72838EA7E6F113F856C4E8018ACDB)                                                |            0.03  |      0.08 |       0    |         2 | 2014-11-29   |
|  684 | [0xF1ADC390 Random Tor Node Operator &lt;tor at unterd](https://metrics.torproject.org/rs.html#search/family:B198C0B4B8C551F174FBB841A172616E3DB3124D)                |            0.03  |      0    |       0.05 |         2 | 2014-04-08   |
|  685 | [vacuum@protonmail.ch](https://metrics.torproject.org/rs.html#details/BE40A5C8EB81704DBC1586190159AA7EDC1DA11D)                                                       |            0.03  |      0    |       0.05 |         1 | 2020-07-23   |
|  686 | [Garlic@protonmail.com](https://metrics.torproject.org/rs.html#details/CF0916A824BC68659DA31E4016B5FC0CA6A9E298)                                                      |            0.03  |      0.1  |       0    |         1 | 2020-04-06   |
|  687 | [daskapital &lt;mydisco .AT. s y s t e m l i DOT o r g](https://metrics.torproject.org/rs.html#details/01FE2137C42E4802507A1FD97B0158116FD78A8C)                      |            0.029 |      0    |       0.04 |         1 | 2016-11-27   |
|  688 | [045AC203](https://metrics.torproject.org/rs.html#details/045AC203CA3FEA7162AECA5B3D84C81859AF1047)                                                                   |            0.029 |      0.09 |       0    |         1 | 2020-08-04   |
|  689 | [0FF7D03A](https://metrics.torproject.org/rs.html#details/0FF7D03AC5F31F93E3AE11ABF74313D071E11ED3)                                                                   |            0.029 |      0    |       0.05 |         1 | 2020-07-27   |
|  690 | [Svea Hosting &lt;info@svea.net&gt;](https://metrics.torproject.org/rs.html#details/10B689D11CDCB8EB74BF394880508C975058C608)                                         |            0.029 |      0.09 |       0    |         1 | 2020-07-28   |
|  691 | [12BBD122](https://metrics.torproject.org/rs.html#details/12BBD122A385CD0D8FE0FF3456C788185965F9AC)                                                                   |            0.029 |      0.09 |       0    |         1 | 2020-08-03   |
|  692 | [221F035A](https://metrics.torproject.org/rs.html#details/221F035A330AC4231A2E3D901F1CB11483C19F66)                                                                   |            0.029 |      0    |       0.05 |         1 | 2018-06-28   |
|  693 | [Random Person &lt;tor0102.10.swsnyder AT spamgourmet](https://metrics.torproject.org/rs.html#search/family:231C00CD373C5DA8E5BA89883300506BC95881D9)                 |            0.029 |      0.09 |       0    |         5 | 2014-04-11   |
|  694 | [270934A4](https://metrics.torproject.org/rs.html#details/270934A4F7B669AA387F2D475FBE793D03694547)                                                                   |            0.029 |      0    |       0.04 |         1 | 2016-05-03   |
|  695 | [3294F2FB](https://metrics.torproject.org/rs.html#details/3294F2FBA76B7CFBA2F2DA6F71440862448C8487)                                                                   |            0.029 |      0.09 |       0    |         1 | 2020-08-03   |
|  696 | [http://45tbhx5prlejzjgn36nqaxqb6qnm73pbohuvqkpxz2z](https://metrics.torproject.org/rs.html#search/family:38F0B34A86E19A2C65B20F95BFB0CBE40E3165C9)                   |            0.029 |      0    |       0.04 |         3 | 2019-06-02   |
|  697 | [39BD825F](https://metrics.torproject.org/rs.html#details/39BD825F627DDF78E322EB4378C17615506AD3A1)                                                                   |            0.029 |      0    |       0.04 |         1 | 2020-05-28   |
|  698 | [torpids AT yahoo dot com - 1JYHfzVFVD7n2Sezz3DEHDF](https://metrics.torproject.org/rs.html#details/3A27CC4147062E4EFDF46F848FEA7FF032A04E5F)                         |            0.029 |      0    |       0.05 |         1 | 2018-05-22   |
|  699 | [tor-contact@kher.nl](https://metrics.torproject.org/rs.html#search/family:4837A6DFFC8E3681D70AD9E8D057C029093DA2F7)                                                  |            0.029 |      0    |       0.05 |         2 | 2019-06-05   |
|  700 | [bourbon](https://metrics.torproject.org/rs.html#details/4B2E97CA3BAC3A2B14879F109E9965A0C20316C2)                                                                    |            0.029 |      0.09 |       0    |         1 | 2020-04-06   |
|  701 | [kk2020 AT tuta dot io](https://metrics.torproject.org/rs.html#details/5475E1C23C16B6FEFC2C56FA20FF674726D7FE26)                                                      |            0.029 |      0.09 |       0    |         1 | 2020-08-03   |
|  702 | [6E25BF4A](https://metrics.torproject.org/rs.html#details/6E25BF4AD7C146E2439A968DD4C29CE0F569AAB5)                                                                   |            0.029 |      0.1  |       0    |         1 | 2018-03-06   |
|  703 | [71EBB31B](https://metrics.torproject.org/rs.html#details/71EBB31BA9F37CB7BE3E33028DC95F4B0D8192A3)                                                                   |            0.029 |      0.09 |       0    |         1 | 2020-08-03   |
|  704 | [keybase.io/moso](https://metrics.torproject.org/rs.html#search/family:7262B9D2EDE0B6A266C4B43D6202209BF6BBA888)                                                      |            0.029 |      0    |       0.04 |         2 | 2018-02-04   |
|  705 | [74A19D86](https://metrics.torproject.org/rs.html#details/74A19D86DDF63F1133B414B81F36E1F44640811F)                                                                   |            0.029 |      0.09 |       0    |         1 | 2015-05-27   |
|  706 | [78256B1B](https://metrics.torproject.org/rs.html#details/78256B1B6AB1D9E277BC5356F6D146BE3BF01A79)                                                                   |            0.029 |      0.09 |       0    |         1 | 2020-08-03   |
|  707 | [apollon@meister.wtf &lt;BTC:38LHtmUMZYz3c3mBciCecGPXr](https://metrics.torproject.org/rs.html#search/family:8C030E1C25552F97C591A921DF51CF5EE15E594C)                |            0.029 |      0    |       0.05 |         2 | 2020-05-17   |
|  708 | [Contact at SilSte on Twitter tor-relay.co](https://metrics.torproject.org/rs.html#details/98867F5242505A2DD581C85B1CE256090B87F138)                                  |            0.029 |      0    |       0.05 |         1 | 2019-12-09   |
|  709 | [tor at cybercyber dot wtf](https://metrics.torproject.org/rs.html#search/family:AE08D159352237844C60E0153AC8578320922FB8)                                            |            0.029 |      0    |       0.05 |         3 | 2019-12-24   |
|  710 | [E5D55485](https://metrics.torproject.org/rs.html#details/E5D55485AC2E5734BE42CFF8A1BF938AF6AFE08C)                                                                   |            0.029 |      0.09 |       0    |         1 | 2020-08-03   |
|  711 | [E8E4EC18](https://metrics.torproject.org/rs.html#details/E8E4EC189ADDEDCF40697350B18232C12BA88815)                                                                   |            0.029 |      0.09 |       0    |         1 | 2020-08-03   |
|  712 | [tor dot voqel at pm dot me](https://metrics.torproject.org/rs.html#details/F37374DB9FA6EF14CED64FD294E8D8683F032EC8)                                                 |            0.029 |      0    |       0    |         1 | 2020-05-10   |
|  713 | [notify@jonossaseuraava.eu](https://metrics.torproject.org/rs.html#details/F58DB7D175AE3192411CBE3EA9E92632ECEFBC85)                                                  |            0.029 |      0    |       0    |         1 | 2019-12-14   |
|  714 | [Cheena &lt;cheena @ cheena . net&gt;](https://metrics.torproject.org/rs.html#search/family:01729F10A81DDD8A92D770B2133082EB56C75E26)                                 |            0.028 |      0.06 |       0.01 |         6 | 2018-11-26   |
|  715 | [email:anonymity c3w.at abuse:abuse c3w.at operat](https://metrics.torproject.org/rs.html#search/family:18EA6AFA3609A0B24752FBF411A2DAADE27DE129)                     |            0.028 |      0    |       0.03 |         3 | 2019-07-21   |
|  716 | [1EBA56C7](https://metrics.torproject.org/rs.html#search/family:1EBA56C764B1C56BE25B405C84C82C58F126B1B6)                                                             |            0.028 |      0    |       0.04 |         2 | 2019-01-09   |
|  717 | [Scott Maxwell tor-contact-2020-netcup-small at s](https://metrics.torproject.org/rs.html#details/2D418A89F79DB4A8E658BA549FBB974D1D22DD1A)                           |            0.028 |      0    |       0.04 |         1 | 2020-05-29   |
|  718 | [Spinach@protonmail.com](https://metrics.torproject.org/rs.html#details/6A50621E0976044854C0DF372558757A5FBEDAEE)                                                     |            0.028 |      0.09 |       0    |         1 | 2020-04-06   |
|  719 | [0xf1281a932571a87314c5ebe21ee291d2482aba4e OnionKi](https://metrics.torproject.org/rs.html#details/7272FA27A7F99E88D59BE2018E3F14FB88BF9786)                         |            0.028 |      0    |       0    |         1 | 2019-09-28   |
|  720 | [7B237E6E](https://metrics.torproject.org/rs.html#details/7B237E6EB5383C8D0852097B6633BAC3FAB5EA39)                                                                   |            0.028 |      0.09 |       0    |         1 | 2019-06-04   |
|  721 | [encro](https://metrics.torproject.org/rs.html#details/8A91128C84415B64F3DB85B49EB88342EAE31249)                                                                      |            0.028 |      0.09 |       0    |         1 | 2020-07-18   |
|  722 | [C1107C72](https://metrics.torproject.org/rs.html#details/C1107C7280924D76A0A59FFAC7EAF624BB84CE17)                                                                   |            0.028 |      0.09 |       0    |         1 | 2020-08-03   |
|  723 | [JX tor at pxa dot dk](https://metrics.torproject.org/rs.html#details/E384748293FC4429E2B427360DB4F9D4C3D619D1)                                                       |            0.028 |      0    |       0.04 |         1 | 2018-02-13   |
|  724 | [tor-operator@your-emailaddress-domain](https://metrics.torproject.org/rs.html#details/E7C1FAFB7525149A0E911512F511D942BA5EEAAF)                                      |            0.028 |      0    |       0.04 |         1 | 2019-05-29   |
|  725 | [F06392BC](https://metrics.torproject.org/rs.html#details/F06392BC87DB067C8BA490450C2DC152BFA0E8BB)                                                                   |            0.028 |      0    |       0    |         1 | 2020-08-05   |
|  726 | [Kale@protonmail.com](https://metrics.torproject.org/rs.html#details/F4A376F2DCF40A4E14417C07A3EC5F9AA83E40A0)                                                        |            0.028 |      0.09 |       0    |         1 | 2020-04-06   |
|  727 | [zwiebelmett at 0815 dot ru](https://metrics.torproject.org/rs.html#details/046F2D59A85FAE693676A87533717C57436261C2)                                                 |            0.027 |      0    |       0    |         1 | 2019-09-29   |
|  728 | [081C9DF6](https://metrics.torproject.org/rs.html#details/081C9DF6A615A300B382C004DFE2CC37B561C9A0)                                                                   |            0.027 |      0    |       0.04 |         1 | 2020-07-19   |
|  729 | [slalix@hotmail.com](https://metrics.torproject.org/rs.html#details/1B5C9AA2DF96A8E6603D4EFA238AFE454A83CCCF)                                                         |            0.027 |      0    |       0    |         1 | 2019-05-28   |
|  730 | [2651DB80](https://metrics.torproject.org/rs.html#details/2651DB80B287DF49965E180A148185EF8DE9E173)                                                                   |            0.027 |      0.09 |       0    |         1 | 2020-08-03   |
|  731 | [tor@as208196.net](https://metrics.torproject.org/rs.html#details/2D70583AFDE90C7C3D9CFF9F0C076F0C022CC29C)                                                           |            0.027 |      0    |       0    |         1 | 2020-03-25   |
|  732 | [3581CC85](https://metrics.torproject.org/rs.html#details/3581CC850544CEA2A2032485E158831C7082027F)                                                                   |            0.027 |      0.09 |       0    |         1 | 2020-08-03   |
|  733 | [tortorrot01@tzu.io](https://metrics.torproject.org/rs.html#details/58BC63142C881F88D08E071DEB63DBA09DE62141)                                                         |            0.027 |      0    |       0.04 |         1 | 2019-06-07   |
|  734 | [59EA7470](https://metrics.torproject.org/rs.html#details/59EA74708A9C1A24D2EB1A2F150C27119A5FC2A6)                                                                   |            0.027 |      0    |       0.04 |         1 | 2020-07-27   |
|  735 | [787403EB](https://metrics.torproject.org/rs.html#details/787403EB1E2F7C9BA1B38D0389AA6719463F0F7E)                                                                   |            0.027 |      0    |       0    |         1 | 2019-07-24   |
|  736 | [fortupac at hotmail d0t com tor-relay.co](https://metrics.torproject.org/rs.html#details/7A2A6F39F485C4FC95FB885FFF37C436FD2BB7E5)                                   |            0.027 |      0    |       0    |         1 | 2019-06-21   |
|  737 | [tor@0x800.cz](https://metrics.torproject.org/rs.html#details/8737307DE84C2621E6399E99123967A9590297F2)                                                               |            0.027 |      0    |       0.04 |         1 | 2020-02-19   |
|  738 | [89FD4FB2](https://metrics.torproject.org/rs.html#details/89FD4FB2A5FD73B50F2E5D85C4707883F8CD5130)                                                                   |            0.027 |      0    |       0.04 |         1 | 2019-11-25   |
|  739 | [eyron@posteo.de](https://metrics.torproject.org/rs.html#details/91799AD097018FD5F83B70B978068FB83F72934F)                                                            |            0.027 |      0    |       0.04 |         1 | 2020-04-06   |
|  740 | [Contact at SilSte on Twitter tor-relay.co](https://metrics.torproject.org/rs.html#details/9C1E47FF205F349D69D569AE7ED15366A5554A46)                                  |            0.027 |      0    |       0.04 |         1 | 2019-12-09   |
|  741 | [0xB0514B31 Medo &lt;smaxein over at that there gmail](https://metrics.torproject.org/rs.html#details/A09D20D85D0AA29C47C90ABEAFDB6B7A4BF7FD07)                       |            0.027 |      0    |       0    |         1 | 2013-09-07   |
|  742 | [AD1FC4AE](https://metrics.torproject.org/rs.html#details/AD1FC4AE877B2FFEB3C84F1A6B76E9B057AAEF4E)                                                                   |            0.027 |      0    |       0.04 |         1 | 2019-12-05   |
|  743 | [B8F6E68B](https://metrics.torproject.org/rs.html#details/B8F6E68B36BEE2BF548750BDCCC3C2A7DB56A623)                                                                   |            0.027 |      0    |       0.04 |         1 | 2019-12-24   |
|  744 | [Random Person &lt;matluak709 IN gmail punt com&gt; - 1wz](https://metrics.torproject.org/rs.html#details/B9E7A637B00BBB77853A639CC33245A2FEB8F033)                   |            0.027 |      0    |       0.04 |         1 | 2016-06-10   |
|  745 | [145tXZyQEfdmpYhmbFtYe84kjghB5ymPA4 swraysford at g](https://metrics.torproject.org/rs.html#details/E51620B90DCB310138ED89EDEDD0A5C361AAE24E)                         |            0.027 |      0.09 |       0    |         1 | 2017-10-03   |
|  746 | [expert.informatique@gmail.com](https://metrics.torproject.org/rs.html#details/E546C96AEB2258BD0733949027E8F96156F6B290)                                              |            0.027 |      0    |       0.04 |         1 | 2019-04-16   |
|  747 | [icanhaz](https://metrics.torproject.org/rs.html#details/FE4A7F1610111DF2F18A564F74F695D0964EC58E)                                                                    |            0.027 |      0.09 |       0    |         1 | 2020-07-18   |
|  748 | [00AC74D5](https://metrics.torproject.org/rs.html#details/00AC74D5FDF3F23679EB454593FBD5DF41C2DD72)                                                                   |            0.026 |      0.08 |       0    |         1 | 2020-08-03   |
|  749 | [1AKfiFWajSckVrArTVh21KkdPuegordE3E](https://metrics.torproject.org/rs.html#search/family:0409605E8343562A790FFE846CB3BD7C04429F70)                                   |            0.026 |      0    |       0.04 |         4 | 2016-10-24   |
|  750 | [do not contact](https://metrics.torproject.org/rs.html#details/0F52E9652F96AD1D500AC062350A149902C128B9)                                                             |            0.026 |      0    |       0.04 |         1 | 2016-05-03   |
|  751 | [1188DC54](https://metrics.torproject.org/rs.html#details/1188DC549FDF5E8054E1FE8C789A632CD1872F7E)                                                                   |            0.026 |      0    |       0.04 |         1 | 2018-10-19   |
|  752 | [131FBC8A](https://metrics.torproject.org/rs.html#details/131FBC8A3D4B44DE9B258ADC58674082B1E06D2C)                                                                   |            0.026 |      0    |       0.04 |         1 | 2018-10-04   |
|  753 | [metateknose@mail.ru](https://metrics.torproject.org/rs.html#details/1A2B77AD0A742CD804B9DD747E2DD8E38D06C915)                                                        |            0.026 |      0    |       0.04 |         1 | 2020-05-26   |
|  754 | [204ECC4F](https://metrics.torproject.org/rs.html#details/204ECC4FF8F93862E82FA19C53B5BC98B1AF6046)                                                                   |            0.026 |      0    |       0.04 |         1 | 2020-01-03   |
|  755 | [none](https://metrics.torproject.org/rs.html#details/20B87C42018D088D1A377125B5E9B638E6AD0566)                                                                       |            0.026 |      0    |       0    |         1 | 2020-07-23   |
|  756 | [riinagalvani at protonmail dot com](https://metrics.torproject.org/rs.html#details/364B9207753AC054BDC646AF6AAC7168C967C5A0)                                         |            0.026 |      0.08 |       0    |         1 | 2020-07-07   |
|  757 | [3A921806](https://metrics.torproject.org/rs.html#details/3A9218063E69224265D250D7EE35AA888692FA05)                                                                   |            0.026 |      0    |       0    |         1 | 2020-03-13   |
|  758 | [Tor-Admins &lt;toooor AT all DOT de&gt;](https://metrics.torproject.org/rs.html#details/4B170476D09459328438F3E68ED19516C9F75A80)                                    |            0.026 |      0.08 |       0    |         1 | 2014-05-17   |
|  759 | [me.2000me@yandex.com](https://metrics.torproject.org/rs.html#details/510F14B2EFFA8CA4131F09081CD6982C614EA508)                                                       |            0.026 |      0.08 |       0    |         1 | 2018-07-30   |
|  760 | [1AKfiFWajSckVrArTVh21KkdPuegordE3E](https://metrics.torproject.org/rs.html#search/family:51F733EAC4DFD128CF957A14D5F2DC023803D1A2)                                   |            0.026 |      0    |       0.04 |         3 | 2019-08-04   |
|  761 | [john at unsc dot org](https://metrics.torproject.org/rs.html#details/6C71AC0B8FB6E0255C100DCAE0C283FB3F2F1CC2)                                                       |            0.026 |      0    |       0.04 |         1 | 2020-05-04   |
|  762 | [75A93140](https://metrics.torproject.org/rs.html#details/75A931404453030821C547A4FAA9094A06C48C7A)                                                                   |            0.026 |      0    |       0.04 |         1 | 2015-06-19   |
|  763 | [59FDAC19FBC4E692652F3EB0C7B7552BDF21283B Smith &lt;qt](https://metrics.torproject.org/rs.html#details/767E444E1FA1DA75F3B77479DB5AE2FA3FFF75CC)                      |            0.026 |      0    |       0.04 |         1 | 2017-04-13   |
|  764 | [80C113BC](https://metrics.torproject.org/rs.html#details/80C113BCE9356B4DECF94E7CF4A8C0BD315EE8E8)                                                                   |            0.026 |      0    |       0.04 |         1 | 2019-02-27   |
|  765 | [8F6AA58D](https://metrics.torproject.org/rs.html#details/8F6AA58DD86C810EE169124BB245F0C5D96F734A)                                                                   |            0.026 |      0.08 |       0    |         1 | 2020-08-04   |
|  766 | [torserver at koljasagorski dot de tor-relay.co](https://metrics.torproject.org/rs.html#details/A4771CB90024F1870D622960519945A3E49B40FE)                             |            0.026 |      0    |       0    |         1 | 2019-10-14   |
|  767 | [A722963E](https://metrics.torproject.org/rs.html#details/A722963E4F776037DE972AE5F6F99E40A6FB2445)                                                                   |            0.026 |      0.08 |       0    |         1 | 2020-08-03   |
|  768 | [Digineo GmbH &lt;tor AT digineo dot de&gt;](https://metrics.torproject.org/rs.html#details/B21211A1A2C68F2D9E57E3C7AEAF4F04AFC10E7F)                                 |            0.026 |      0.08 |       0    |         1 | 2017-02-16   |
|  769 | [dthpulse &lt;dthpulse@podciarou.sk&gt;](https://metrics.torproject.org/rs.html#details/CBB5AE37E2927A915D70FA71572D2EA203F03E83)                                     |            0.026 |      0    |       0.04 |         1 | 2017-06-28   |
|  770 | [DEA98B7F](https://metrics.torproject.org/rs.html#details/DEA98B7F9BA8B7F8A098D3939A6FE446084B48E7)                                                                   |            0.026 |      0    |       0.04 |         1 | 2018-09-17   |
|  771 | [tor-relay@datahoarder.dev](https://metrics.torproject.org/rs.html#details/E5507444DAC04539B8DC624299616141B0DB64D5)                                                  |            0.026 |      0    |       0.04 |         1 | 2020-07-03   |
|  772 | [FE9CB0E0](https://metrics.torproject.org/rs.html#details/FE9CB0E0629636EBD8D0C71F46E387B944C01BCF)                                                                   |            0.026 |      0    |       0.04 |         1 | 2019-06-13   |
|  773 | [0EFF1855](https://metrics.torproject.org/rs.html#details/0EFF185569EC180F7027C060C5CB71272B5F8C44)                                                                   |            0.025 |      0    |       0.04 |         1 | 2020-04-03   |
|  774 | [Nick Sheppard &lt;nicksheppard03@gmail.com&gt;](https://metrics.torproject.org/rs.html#search/family:16DB78459B845F4E728405EB694E32929E2B318A)                       |            0.025 |      0    |       0.02 |         2 | 2014-09-29   |
|  775 | [4096R/0x4cf76925833e2e24 Knight &lt;knight AT germanc](https://metrics.torproject.org/rs.html#details/18CA9EA099BB9861E354D2A6FF49337A7E81C2F3)                      |            0.025 |      0    |       0    |         1 | 2016-04-23   |
|  776 | [18F34AE6](https://metrics.torproject.org/rs.html#details/18F34AE6567F5FB081C4353D5EDA5CEE155810C4)                                                                   |            0.025 |      0    |       0.04 |         1 | 2019-09-02   |
|  777 | [1D86E759](https://metrics.torproject.org/rs.html#details/1D86E75980B107536C7802592360577619BA8BFC)                                                                   |            0.025 |      0.08 |       0    |         1 | 2020-08-04   |
|  778 | [378E474A](https://metrics.torproject.org/rs.html#details/378E474A4805587228ED56900DC7D69B18259AAC)                                                                   |            0.025 |      0    |       0    |         1 | 2020-03-27   |
|  779 | [email:gnu1170 tuta.io operatorurl:http://4pan6dte](https://metrics.torproject.org/rs.html#details/4071417389E4D1CE127F155CF8BE7E85088E37D0)                          |            0.025 |      0.08 |       0    |         1 | 2020-07-18   |
|  780 | [4482F3DF](https://metrics.torproject.org/rs.html#details/4482F3DF4CEB2EB3BB8B60404C6283A2B70A3FDC)                                                                   |            0.025 |      0.08 |       0    |         1 | 2020-08-03   |
|  781 | [tor-operator-sahara-it@protonmail.com](https://metrics.torproject.org/rs.html#search/family:55E1E19071A6DD27F7C16AC3BE494C5891E1E414)                                |            0.025 |      0    |       0.02 |         2 | 2020-08-03   |
|  782 | [63A0D1B0](https://metrics.torproject.org/rs.html#search/family:63A0D1B0E499ACC5510697384DBCAC16A18B0B5E)                                                             |            0.025 |      0    |       0.04 |         2 | 2020-04-11   |
|  783 | [eth](https://metrics.torproject.org/rs.html#details/69F41C1A051A6DDD659F19D9A01920ECB1E6C202)                                                                        |            0.025 |      0.08 |       0    |         1 | 2020-07-18   |
|  784 | [Leo E. Royer &lt;alt.rq-1n11rah@yopmail.com&gt;](https://metrics.torproject.org/rs.html#details/6DA7DEB037BB163991B3DBA74B1AEC48BB497C7A)                            |            0.025 |      0    |       0.04 |         1 | 2020-04-09   |
|  785 | [0x7A32210DCE258941 &lt;maxtor@maxderdepp.de&gt;](https://metrics.torproject.org/rs.html#details/78B98D12997EDD630F6A674CBF42F20711DEAC11)                            |            0.025 |      0    |       0.04 |         1 | 2019-04-30   |
|  786 | [patrol](https://metrics.torproject.org/rs.html#details/892178B2FAEDC66CAC4091F343264B58064D5B26)                                                                     |            0.025 |      0.08 |       0    |         1 | 2020-07-18   |
|  787 | [8AA364F4](https://metrics.torproject.org/rs.html#details/8AA364F432A7CA2A0F74B57BCA2593293E450F97)                                                                   |            0.025 |      0.08 |       0    |         1 | 2020-08-03   |
|  788 | [98DBFA6D](https://metrics.torproject.org/rs.html#details/98DBFA6DC7F4013566D09E3DDC6F6CAF510E7FD6)                                                                   |            0.025 |      0    |       0.04 |         1 | 2019-05-29   |
|  789 | [Igor &lt;torops 4ck dot me&gt;](https://metrics.torproject.org/rs.html#search/family:9F29D0DD4AEB62E742BDAEEF2DFD3BDD76953403)                                       |            0.025 |      0    |       0.04 |         2 | 2018-02-06   |
|  790 | [A9F71854](https://metrics.torproject.org/rs.html#details/A9F7185499C5784E35B5C25744ED4AB75437CE5D)                                                                   |            0.025 |      0    |       0.04 |         1 | 2016-09-21   |
|  791 | [4096R/1567BC0F Jesus Cea &lt;jcea@jcea.es&gt;](https://metrics.torproject.org/rs.html#details/AAFF4A997543DB0D881F4F11638485B7D471FECE)                              |            0.025 |      0    |       0.04 |         1 | 2020-01-22   |
|  792 | [stevencampbell23tor at protonmail dot ch tor-rel](https://metrics.torproject.org/rs.html#details/ACD8C7107031AF4ACF9A2DBC69AB8903943EEA5D)                           |            0.025 |      0.08 |       0    |         1 | 2020-08-03   |
|  793 | [Helikopter &lt;tor AT hackernet dot se&gt;](https://metrics.torproject.org/rs.html#details/ACF165754601059ED2E472F893AD0FA4CAF1142D)                                 |            0.025 |      0    |       0    |         1 | 2019-03-12   |
|  794 | [tor-operators@labitat.dk](https://metrics.torproject.org/rs.html#search/family:B2380704C53947B1D72E7CBCD361E73901EF7444)                                             |            0.025 |      0.08 |       0    |         2 | 2019-08-03   |
|  795 | [B9F7415B](https://metrics.torproject.org/rs.html#details/B9F7415B3BC8F5B84DCCA4E6BB48169D3129E2D5)                                                                   |            0.025 |      0.08 |       0    |         1 | 2020-08-03   |
|  796 | [wigitnok at gmail dot com](https://metrics.torproject.org/rs.html#details/C0CBBD17F848C8F9A49104A96DB498013B30F14F)                                                  |            0.025 |      0    |       0.04 |         1 | 2019-10-18   |
|  797 | [C94110E9](https://metrics.torproject.org/rs.html#details/C94110E9170E1C9FDC53BA9919D5CD8685550078)                                                                   |            0.025 |      0.08 |       0    |         1 | 2020-08-04   |
|  798 | [none](https://metrics.torproject.org/rs.html#details/CAC1EEB324F8CEDAE9C432E99CE8F42DDF4CB490)                                                                       |            0.025 |      0    |       0.04 |         1 | 2020-02-22   |
|  799 | [Jugger Relay jugger-relay@protonmail.com](https://metrics.torproject.org/rs.html#details/D1C60F9BCF2DBA07A775978F66C9927D3A9490BB)                                   |            0.025 |      0    |       0.04 |         1 | 2019-12-30   |
|  800 | [contact@blockchainsociety.ch](https://metrics.torproject.org/rs.html#details/D3B72ADA2F3EEDA2BA98F645D620CA1C4060AAF4)                                               |            0.025 |      0    |       0.04 |         1 | 2019-04-09   |
|  801 | [D439FC3B](https://metrics.torproject.org/rs.html#search/family:D439FC3B5F0A81796F4622320197A90032CAE4DB)                                                             |            0.025 |      0    |       0.04 |         2 | 2017-10-03   |
|  802 | [D4AED253](https://metrics.torproject.org/rs.html#details/D4AED2536B5725B46A39F38EDAC127A98204DD0E)                                                                   |            0.025 |      0.08 |       0    |         1 | 2020-08-03   |
|  803 | [Arthur Fabre &lt;https://arthurfabre.com/contact&gt;](https://metrics.torproject.org/rs.html#details/DD823AFB415380A802DCAEB9461AE637604107FB)                       |            0.025 |      0    |       0.04 |         1 | 2015-05-05   |
|  804 | [notor](https://metrics.torproject.org/rs.html#details/EB44DEFA821E3672B955ED9B14E28C36F80C5FA8)                                                                      |            0.025 |      0.08 |       0    |         1 | 2020-07-18   |
|  805 | [ofofo2000-tor at yahoo fr](https://metrics.torproject.org/rs.html#details/FC30F566E7B50D9C6ED6BB86DA4BF4B07AD52DE5)                                                  |            0.025 |      0    |       0    |         1 | 2016-10-21   |
|  806 | [08F4692B](https://metrics.torproject.org/rs.html#details/08F4692B60862640F688B86826B66F30DEA7AB73)                                                                   |            0.024 |      0    |       0.04 |         1 | 2019-11-14   |
|  807 | [4096R/5EDACFC82A710D95 Dave Pifke &lt;dave@pifke.org&gt;](https://metrics.torproject.org/rs.html#search/family:0C039F35C2E40DCB71CD8A07E97C7FD7787D42D6)             |            0.024 |      0    |       0.04 |         2 | 2016-10-19   |
|  808 | [212B9FEB](https://metrics.torproject.org/rs.html#details/212B9FEB92C049931521FA73E2EA86CB96C38F02)                                                                   |            0.024 |      0.08 |       0    |         1 | 2020-08-03   |
|  809 | [Thingy McThingFace &lt;simon dot detheridge thingy g](https://metrics.torproject.org/rs.html#details/2F26D43258285FEB39E4320888DFAFA8A0D20E11)                       |            0.024 |      0    |       0.04 |         1 | 2015-11-22   |
|  810 | [35513B1D](https://metrics.torproject.org/rs.html#details/35513B1D2EA70649346C3C6D34F63D6982E3948A)                                                                   |            0.024 |      0    |       0.04 |         1 | 2019-03-27   |
|  811 | [AE157E0B29F0BEF2 Casper &lt;cAsper at caSperlefaNtom](https://metrics.torproject.org/rs.html#search/family:36045C1900EC3FDF1DDA9BEC72DDF7DE50DAF021)                 |            0.024 |      0    |       0.04 |         2 | 2015-10-12   |
|  812 | [396650D2](https://metrics.torproject.org/rs.html#details/396650D22D382D59B5048A462DE9B690092452EA)                                                                   |            0.024 |      0.08 |       0    |         1 | 2020-06-29   |
|  813 | [Random Person &lt;thorndike AT tutanota dot com&gt;](https://metrics.torproject.org/rs.html#details/3E3CBA3F2870CE76A41D3E97A8D838AA703586E3)                        |            0.024 |      0    |       0.04 |         1 | 2020-08-01   |
|  814 | [40DD356E](https://metrics.torproject.org/rs.html#details/40DD356E8F3C53FA9251B561CF956302791AAFF5)                                                                   |            0.024 |      0    |       0.04 |         1 | 2017-01-19   |
|  815 | [54955220](https://metrics.torproject.org/rs.html#details/549552206C2B4A0233C68EB33E98392660CA5692)                                                                   |            0.024 |      0    |       0.04 |         1 | 2020-06-09   |
|  816 | [57B5D14A](https://metrics.torproject.org/rs.html#details/57B5D14ABCF8D7D7F3FCB2C5192C239A86071375)                                                                   |            0.024 |      0.08 |       0    |         1 | 2020-08-03   |
|  817 | [5DC945CE](https://metrics.torproject.org/rs.html#details/5DC945CE8FB2A37E6E2795ECD2709BB21F8714B0)                                                                   |            0.024 |      0.08 |       0    |         1 | 2015-08-28   |
|  818 | [Gaspard Peduzzi &lt;peduzzi.gaspard@protonmail.ch&gt;](https://metrics.torproject.org/rs.html#details/62CF4982747BFDE3C0395A3894554BD8DC3C5D92)                      |            0.024 |      0    |       0.04 |         1 | 2019-12-25   |
|  819 | [67549C74](https://metrics.torproject.org/rs.html#details/67549C743EB7A9D06A75E37BEB82417EBB22E97F)                                                                   |            0.024 |      0    |       0.04 |         1 | 2018-09-28   |
|  820 | [abuse at yggdrasil dot ws](https://metrics.torproject.org/rs.html#details/6AD2D73B1A0A931AD792117D58A6C65EF411EBC2)                                                  |            0.024 |      0.08 |       0    |         1 | 2020-07-25   |
|  821 | [0xFD7DF541 Elude.in TorOperator &lt;tor@elude.in&gt;](https://metrics.torproject.org/rs.html#search/family:768B488AE2C61B6FA837E3AB8DB7601E1A0B8492)                 |            0.024 |      0    |       0    |         3 | 2017-12-05   |
|  822 | [Random Person &lt;nobody AT example dot com&gt;](https://metrics.torproject.org/rs.html#details/787768FEF9FBFE2D9B8E0214019A7F9960D39206)                            |            0.024 |      0    |       0.04 |         1 | 2020-07-06   |
|  823 | [7BE47528](https://metrics.torproject.org/rs.html#details/7BE4752877553A96CD4035D0C526BCD09E81CC64)                                                                   |            0.024 |      0    |       0.04 |         1 | 2019-12-26   |
|  824 | [A7E5 80DE E42C 3C8A Jordan Martel &lt;jordan AT jorda](https://metrics.torproject.org/rs.html#details/7E7D257777019B80771C5F6FF63DB6D89AE5B067)                      |            0.024 |      0    |       0.04 |         1 | 2020-04-27   |
|  825 | [840ED78A](https://metrics.torproject.org/rs.html#details/840ED78A802ED8C647F6CB5F2DE409FFCB36B7AC)                                                                   |            0.024 |      0    |       0    |         1 | 2020-07-07   |
|  826 | [87C08DDF](https://metrics.torproject.org/rs.html#details/87C08DDFD32C62F3C56D371F9774D27BFDBB807B)                                                                   |            0.024 |      0    |       0.04 |         1 | 2017-01-19   |
|  827 | [8B0D8D35](https://metrics.torproject.org/rs.html#details/8B0D8D35EC9BE90675E1D054DD7F52F555C80085)                                                                   |            0.024 |      0    |       0.04 |         1 | 2019-10-20   |
|  828 | [Mr.X &lt;tor@scenics.se&gt;](https://metrics.torproject.org/rs.html#details/8F02FE5E233730A6AB4C982E18A2136E662A0B59)                                                |            0.024 |      0    |       0.04 |         1 | 2016-02-13   |
|  829 | [95489977](https://metrics.torproject.org/rs.html#details/954899771A172E85E478026DCFF908B0CF5410B2)                                                                   |            0.024 |      0.08 |       0    |         1 | 2020-08-03   |
|  830 | [98F78820](https://metrics.torproject.org/rs.html#details/98F788200CC64060695B07555F09A8FE47679AC8)                                                                   |            0.024 |      0    |       0    |         1 | 2020-04-06   |
|  831 | [tornodee at protonmail dot com](https://metrics.torproject.org/rs.html#details/9BFD38EB9461689DB899E4410D4562C4E3BA0473)                                             |            0.024 |      0.08 |       0    |         1 | 2020-07-25   |
|  832 | [tor at virtual-machine dot org](https://metrics.torproject.org/rs.html#details/B22C4BF9747DBBC843F1BBBA272FDB7B6045EB01)                                             |            0.024 |      0    |       0.04 |         1 | 2020-06-26   |
|  833 | [disk dot ninetieth255 at 4wrd dot cc](https://metrics.torproject.org/rs.html#details/B5D11485CE7613F8734D040BF9166F6AAFB30F46)                                       |            0.024 |      0    |       0.04 |         1 | 2020-07-27   |
|  834 | [B610BE4A](https://metrics.torproject.org/rs.html#details/B610BE4A8410A29B785864EDFC8E667513EF59C6)                                                                   |            0.024 |      0.08 |       0    |         1 | 2020-08-03   |
|  835 | [BC238DA1](https://metrics.torproject.org/rs.html#details/BC238DA10F427C21685F766317F7E0946954B88F)                                                                   |            0.024 |      0    |       0.04 |         1 | 2020-01-01   |
|  836 | [C0E94053](https://metrics.torproject.org/rs.html#details/C0E94053197F71EC2832BAAE15791A1AFA09972E)                                                                   |            0.024 |      0.08 |       0    |         1 | 2014-11-18   |
|  837 | [&lt;Jannis&gt; jannisde85@eclipso.eu](https://metrics.torproject.org/rs.html#details/C2C2B839F4CFFA5F7B7A40CB0BE84F7D948CB510)                                       |            0.024 |      0    |       0.04 |         1 | 2016-04-08   |
|  838 | [0x46F77E6B5E170F8C beteigeuze1908 at mailbox.org](https://metrics.torproject.org/rs.html#details/C5F713E503B9F251642C49A998B0498DDD802B72)                           |            0.024 |      0    |       0.04 |         1 | 2020-05-17   |
|  839 | [E3E75603](https://metrics.torproject.org/rs.html#details/E3E75603998661EA67C6767493FC606830DDC345)                                                                   |            0.024 |      0    |       0.04 |         1 | 2020-03-10   |
|  840 | [0xA85FF376759C994A8A1168D8D8219C8C43F6C5E1 &lt;mail@k](https://metrics.torproject.org/rs.html#details/E947C029087FA1C3499BEF5D4372947C51223D8F)                      |            0.024 |      0    |       0.04 |         1 | 2018-01-31   |
|  841 | [outerspacetor@23-5.eu](https://metrics.torproject.org/rs.html#details/EA43347E0DA7CEDD595029B511066628C7C8A653)                                                      |            0.024 |      0    |       0.04 |         1 | 2019-02-19   |
|  842 | [StayStrongServer &lt;staystrongserver AT yandex dot](https://metrics.torproject.org/rs.html#details/ED9A731373456FA071C12A3E63E2C8BEF0A6E721)                        |            0.024 |      0    |       0.04 |         1 | 2020-06-12   |
|  843 | [F01AAA64](https://metrics.torproject.org/rs.html#details/F01AAA640FF4EA025DB8449BD61C055273B4A328)                                                                   |            0.024 |      0    |       0.04 |         1 | 2019-12-22   |
|  844 | [utah-tor AT stronzi DOT org - PGP 0x4F4ED372 -](https://metrics.torproject.org/rs.html#search/family:0CDD60E4015EBF2C3B5D32A2B9CC8FE6C98A5C33)                       |            0.023 |      0    |       0.04 |         4 | 2019-07-27   |
|  845 | [torpids AT yahoo dot com - 1JYHfzVFVD7n2Sezz3DEHDF](https://metrics.torproject.org/rs.html#details/0CF8F3E6590F45D50B70F2F7DA6605ECA6CD408F)                         |            0.023 |      0    |       0.04 |         1 | 2016-03-23   |
|  846 | [11F2C7D7](https://metrics.torproject.org/rs.html#details/11F2C7D7C84566F4AF6CDC8272A1B9406CFCA10B)                                                                   |            0.023 |      0.07 |       0    |         1 | 2020-08-03   |
|  847 | [msngod at gmail dot com tor-relay.co](https://metrics.torproject.org/rs.html#details/120F89D102F96647D2258166B3BB50CBFCEF20E3)                                       |            0.023 |      0.07 |       0    |         1 | 2019-03-30   |
|  848 | [marcus at marcusj dot tech tor-relay.co](https://metrics.torproject.org/rs.html#details/1A96B729AD2EF59AD269751E6BDED6F9ECE2D428)                                    |            0.023 |      0    |       0    |         1 | 2020-08-04   |
|  849 | [plsnoemail at localhost tor-relay.co](https://metrics.torproject.org/rs.html#details/1B91B86B67317A63636FE38ABE6C4E701A2B1A99)                                       |            0.023 |      0    |       0.04 |         1 | 2019-02-23   |
|  850 | [1F4105C6](https://metrics.torproject.org/rs.html#details/1F4105C688E835A56AF3D66C787677B57240FFA2)                                                                   |            0.023 |      0    |       0.03 |         1 | 2016-08-07   |
|  851 | [ContactInfo email:friendlyexitnode protonmail.com](https://metrics.torproject.org/rs.html#search/family:23F74D581DE92AC59D3527DE4D448E036139D81E)                    |            0.023 |      0.07 |       0    |         4 | 2018-11-12   |
|  852 | [marco.lomberti88tor@gmail.com](https://metrics.torproject.org/rs.html#details/2B31FB827D4CEA734B9F78C16137CFD6F8AEBB7B)                                              |            0.023 |      0.07 |       0    |         1 | 2017-08-18   |
|  853 | [2E6EE0D6](https://metrics.torproject.org/rs.html#details/2E6EE0D63EEAA9FF044AA92F951E5767106FF738)                                                                   |            0.023 |      0.07 |       0    |         1 | 2019-06-07   |
|  854 | [Elias Pap &lt;eliaspapATtolabaki-D0T-gr&gt;](https://metrics.torproject.org/rs.html#search/family:3970FA79EC2752446D668ECD575354101C5E29AA)                          |            0.023 |      0    |       0    |         2 | 2018-08-03   |
|  855 | [julian@0x4a42.net - GPG: ADC52C2BFEA6DA4459045D702](https://metrics.torproject.org/rs.html#details/3D6C776E8BE9E8AE5D0591594117999E3C5498C8)                         |            0.023 |      0    |       0.04 |         1 | 2015-05-30   |
|  856 | [4452EEE6](https://metrics.torproject.org/rs.html#details/4452EEE635A29539EE0C120B1A417D1E2C812F12)                                                                   |            0.023 |      0    |       0    |         1 | 2020-03-20   |
|  857 | [4B68D0E5](https://metrics.torproject.org/rs.html#details/4B68D0E5392ED6F3469A37880631353A96558631)                                                                   |            0.023 |      0    |       0.04 |         1 | 2017-10-24   |
|  858 | [tor ed georgeorwell todd de](https://metrics.torproject.org/rs.html#search/family:4BC874C290A1438E9FF3C684F1CAC2AC351A12EB)                                          |            0.023 |      0    |       0.04 |         4 | 2017-12-30   |
|  859 | [5A224EFA](https://metrics.torproject.org/rs.html#details/5A224EFAC453F7EF2D0435E336890DECDC5CEBFD)                                                                   |            0.023 |      0    |       0.04 |         1 | 2019-09-30   |
|  860 | [60F2139E](https://metrics.torproject.org/rs.html#details/60F2139EA3E06410A05CBD6E8254E60A9063AD9D)                                                                   |            0.023 |      0    |       0.04 |         1 | 2019-02-13   |
|  861 | [Nona Admin &lt;admin AT nonanet dot net&gt;](https://metrics.torproject.org/rs.html#details/7335A5A83067AE1BDB073F2E00A3E3982FFFE23D)                                |            0.023 |      0.07 |       0    |         1 | 2019-09-22   |
|  862 | [42e7b73f33ff22cfc9c at gmail.com](https://metrics.torproject.org/rs.html#details/885CFB6921E6E7716BB64783348DDB06E17E5B5A)                                           |            0.023 |      0    |       0.04 |         1 | 2018-08-16   |
|  863 | [unl8604r83p AT temp dot mailbox dot org](https://metrics.torproject.org/rs.html#details/88DF5D708E931C431902AAABEA981E7951E00085)                                    |            0.023 |      0    |       0.04 |         1 | 2020-07-06   |
|  864 | [Iruhaku &lt;terrytorserver@gmail.com&gt;](https://metrics.torproject.org/rs.html#details/8EFA93C0109D5AAFBBF3FE47CE4DE66B659F1840)                                   |            0.023 |      0.07 |       0    |         1 | 2020-07-14   |
|  865 | [99774357](https://metrics.torproject.org/rs.html#details/99774357E7FD1F113F242C469D1D399D444AA51A)                                                                   |            0.023 |      0    |       0.04 |         1 | 2018-03-20   |
|  866 | [B9B41798](https://metrics.torproject.org/rs.html#details/B9B4179840D4397197F6418595DB80CB7DBD0D7A)                                                                   |            0.023 |      0    |       0    |         1 | 2020-04-04   |
|  867 | [BAF223E9](https://metrics.torproject.org/rs.html#details/BAF223E9DF62D3261F1675C6CFC4E5D50F15FA57)                                                                   |            0.023 |      0    |       0.03 |         1 | 2020-02-07   |
|  868 | [0x46731044 Rick van der Zwet &lt;info@rickvanderzwet.](https://metrics.torproject.org/rs.html#details/C22BA9ED6DEE071D2B37B9718DCCFB6A53EAD5E6)                      |            0.023 |      0    |       0.04 |         1 | 2018-02-05   |
|  869 | [leonard- d 0t -henger aet h web d0t de](https://metrics.torproject.org/rs.html#details/C92F69EE5756200F160CCFAFE9C3C984D3E6D561)                                     |            0.023 |      0    |       0.03 |         1 | 2018-02-06   |
|  870 | [Contact @SilSte on Twitter](https://metrics.torproject.org/rs.html#details/D1C5F5F8FAFA2F98A84753416BF83B83F1282137)                                                 |            0.023 |      0    |       0    |         1 | 2018-04-04   |
|  871 | [Decio &lt;decio@decio.eu&gt;](https://metrics.torproject.org/rs.html#details/E459E02374D0385D2E2515CBBE707EA208966BCF)                                               |            0.023 |      0    |       0.04 |         1 | 2014-06-09   |
|  872 | [F08A525A](https://metrics.torproject.org/rs.html#details/F08A525ACA965CF6A55F0587BF4B7373D98B954E)                                                                   |            0.023 |      0    |       0.03 |         1 | 2018-02-03   |
|  873 | [F83FC21E](https://metrics.torproject.org/rs.html#details/F83FC21E244E2ECD28CFEB60D20A23DE7A51543C)                                                                   |            0.023 |      0.07 |       0    |         1 | 2020-08-03   |
|  874 | [01FF9C85](https://metrics.torproject.org/rs.html#details/01FF9C8571D1C09FA8D2ACCE727D5530FEC10038)                                                                   |            0.022 |      0    |       0.03 |         1 | 2020-01-05   |
|  875 | [065E6B20](https://metrics.torproject.org/rs.html#details/065E6B20BF87AE6F0E27063BB8AE002ECC3736E9)                                                                   |            0.022 |      0    |       0.03 |         1 | 2020-07-10   |
|  876 | [tor@taxinachtegel.de C279FB32](https://metrics.torproject.org/rs.html#details/0C8433B6B92E2F1C744F3CFBE49ADA7CBEFEEBFA)                                              |            0.022 |      0    |       0.03 |         1 | 2018-11-15   |
|  877 | [emerson tor@nodevine.net bitcoin:126gyYcBjirRmDh2G](https://metrics.torproject.org/rs.html#search/family:10EF2F97C8D4CC9F77693C92CA88E2115C46DB70)                   |            0.022 |      0    |       0.01 |         7 | 2020-06-27   |
|  878 | [148487C6](https://metrics.torproject.org/rs.html#details/148487C6EBE04EB22496080C20796C51B060F611)                                                                   |            0.022 |      0    |       0.03 |         1 | 2018-03-20   |
|  879 | [toroperator1776@protonmail.com](https://metrics.torproject.org/rs.html#details/1C7D71A2581DE79C5CFC4ED1FF75D5BE30F01BB7)                                             |            0.022 |      0    |       0.03 |         1 | 2019-03-13   |
|  880 | [208D900D](https://metrics.torproject.org/rs.html#details/208D900D0E19338C290CAE206CD7BC14FE6982AF)                                                                   |            0.022 |      0    |       0.03 |         1 | 2020-02-22   |
|  881 | [torix aT=== protonmail&lt;dOT &gt;com](https://metrics.torproject.org/rs.html#search/family:53C9F4954E7A7332BB0C610C5B8E04CA065AF29B)                                |            0.022 |      0.04 |       0.01 |         4 | 2019-05-13   |
|  882 | [5790B62A](https://metrics.torproject.org/rs.html#details/5790B62AD6C79A1092B30993A8F0F7F23A969FD6)                                                                   |            0.022 |      0    |       0.03 |         1 | 2020-04-21   |
|  883 | [Email &lt;photonproton07@protonmail.com&gt;](https://metrics.torproject.org/rs.html#details/57CF8F509D32BB78A9FF0CC42ADA7B75986C3CCC)                                |            0.022 |      0.07 |       0    |         1 | 2020-07-17   |
|  884 | [email778760052@danwin1210.me](https://metrics.torproject.org/rs.html#details/58E89A05564E6844FACC5D78A73EF593222561A2)                                               |            0.022 |      0    |       0.03 |         1 | 2019-11-22   |
|  885 | [Robin Lopane &lt;tor@mail139028.mx2e60.netcup.net&gt;](https://metrics.torproject.org/rs.html#details/59A755782C1F977D6DCD76C0EC450FFCC7C29E56)                      |            0.022 |      0    |       0.03 |         1 | 2020-04-13   |
|  886 | [always.sunny@in.uppsala.se](https://metrics.torproject.org/rs.html#details/5DBAFEE3BF786896947F805EE3B3BD5C986506B0)                                                 |            0.022 |      0    |       0    |         1 | 2020-06-16   |
|  887 | [68773D3F](https://metrics.torproject.org/rs.html#details/68773D3FF7B8CEFCEEFCA32AE72015E2D38C62C1)                                                                   |            0.022 |      0    |       0.03 |         1 | 2020-01-05   |
|  888 | [tomas dot vanagas at knf dot vu dot lt tor-relay.](https://metrics.torproject.org/rs.html#details/6E66D978514FF86CDEF01FE30C23A1002925AA02)                          |            0.022 |      0.07 |       0    |         1 | 2020-03-21   |
|  889 | [79891C17](https://metrics.torproject.org/rs.html#details/79891C17AD8A3C9DD26CC6E003EF48EFDCBD7A1B)                                                                   |            0.022 |      0    |       0    |         1 | 2020-06-24   |
|  890 | [gorlock@gmx.net](https://metrics.torproject.org/rs.html#details/79C674E6C1AC90687CCCF644D24C17AC1E535A3C)                                                            |            0.022 |      0    |       0.03 |         1 | 2017-12-11   |
|  891 | [7B57933E](https://metrics.torproject.org/rs.html#details/7B57933E29D520471D7E67AB48B06B62832828F9)                                                                   |            0.022 |      0    |       0.03 |         1 | 2020-01-01   |
|  892 | [88417FC2](https://metrics.torproject.org/rs.html#details/88417FC2BCDB67BA0142ABF186386FF903123333)                                                                   |            0.022 |      0    |       0    |         1 | 2020-06-23   |
|  893 | [36um1skm0kc5w82](https://metrics.torproject.org/rs.html#details/8D8E090832FCAFEA083BA150DA6D154E365A590C)                                                            |            0.022 |      0    |       0.03 |         1 | 2019-11-02   |
|  894 | [8F8D793F](https://metrics.torproject.org/rs.html#details/8F8D793F4CA40CD0C2B2B9097B699D4037041F58)                                                                   |            0.022 |      0    |       0    |         1 | 2020-05-07   |
|  895 | [945AA2F6](https://metrics.torproject.org/rs.html#details/945AA2F6C2EC644B533D048C79E035A6CF092C4F)                                                                   |            0.022 |      0    |       0.03 |         1 | 2016-12-10   |
|  896 | [no](https://metrics.torproject.org/rs.html#details/9684C4D6C71131EEEF2E5C23C3EA234A684CD501)                                                                         |            0.022 |      0    |       0.03 |         1 | 2018-01-16   |
|  897 | [97560BEB](https://metrics.torproject.org/rs.html#details/97560BEB6EEE630A41604FA1D16D6A42856D818C)                                                                   |            0.022 |      0.07 |       0    |         1 | 2020-08-04   |
|  898 | [51183341@gmx.at](https://metrics.torproject.org/rs.html#details/9DB400402B545DC41DE342E14644F74B7DA4F789)                                                            |            0.022 |      0    |       0.03 |         1 | 2020-01-09   |
|  899 | [9DC0E701](https://metrics.torproject.org/rs.html#details/9DC0E701163C95E6AEAAEB21EB473FEF880BB153)                                                                   |            0.022 |      0.07 |       0    |         1 | 2020-08-04   |
|  900 | [tnr@privacy.no](https://metrics.torproject.org/rs.html#details/A23A7219B1EA9D583E66DFF26D62573DE64A9C29)                                                             |            0.022 |      0    |       0.03 |         1 | 2020-03-27   |
|  901 | [AA2E1A3F](https://metrics.torproject.org/rs.html#details/AA2E1A3F6A31F9815758BF7F25A6C0EA4688BE59)                                                                   |            0.022 |      0.07 |       0    |         1 | 2020-08-03   |
|  902 | [B04EA2B4](https://metrics.torproject.org/rs.html#details/B04EA2B400D9679E72284E12FB81E68756670A3A)                                                                   |            0.022 |      0    |       0.03 |         1 | 2018-02-28   |
|  903 | [relay-tor@posteo.de](https://metrics.torproject.org/rs.html#details/B923D15EDF4E7B1261876860D51FAB907ED18347)                                                        |            0.022 |      0    |       0.03 |         1 | 2017-11-14   |
|  904 | [BA38C568](https://metrics.torproject.org/rs.html#details/BA38C5688E103AE11F50D7188C8E5FDB4B0E5553)                                                                   |            0.022 |      0    |       0.03 |         1 | 2020-01-03   |
|  905 | [https://www.youtube.com/watch?v=AIFzR48ABqE](https://metrics.torproject.org/rs.html#details/C25E5C62897BACBA309571C2548084B45050FEDF)                                |            0.022 |      0    |       0.03 |         1 | 2019-05-09   |
|  906 | [alleghbi at tutanota dot com](https://metrics.torproject.org/rs.html#details/CD9BFE309010778D64ED5E55D5EEAA92B2020DE8)                                               |            0.022 |      0    |       0.03 |         1 | 2019-12-14   |
|  907 | [spam at abuse dot com tor-relay.co](https://metrics.torproject.org/rs.html#details/CE34F2DA5B7B419D9D126530DCE86EA87D6D13EE)                                         |            0.022 |      0    |       0.03 |         1 | 2019-03-15   |
|  908 | [DD5DA21C](https://metrics.torproject.org/rs.html#details/DD5DA21CC5036533AE2010DE2C7E72BE2CDF9C5E)                                                                   |            0.022 |      0    |       0.03 |         1 | 2017-01-19   |
|  909 | [torrelay at vonkuenheim dot de](https://metrics.torproject.org/rs.html#details/E14B30A83FF80C576B2EC0F2C8A5F29D41B8DC8E)                                             |            0.022 |      0    |       0.03 |         1 | 2019-03-15   |
|  910 | [E5A3CA10](https://metrics.torproject.org/rs.html#details/E5A3CA10182C35F691BCF678F193D10F4B0F972F)                                                                   |            0.022 |      0    |       0.03 |         1 | 2020-06-19   |
|  911 | [E5F1B499](https://metrics.torproject.org/rs.html#details/E5F1B4995E939C13D4DEE7B13112A9B10FDB61A0)                                                                   |            0.022 |      0    |       0    |         1 | 2020-06-20   |
|  912 | [E97D7545](https://metrics.torproject.org/rs.html#details/E97D754577161C2BEF19042F6E1931D8F3E57DFE)                                                                   |            0.022 |      0    |       0.03 |         1 | 2020-04-14   |
|  913 | [F07671D9](https://metrics.torproject.org/rs.html#details/F07671D992DA28551DF18C6CA616007208D5D078)                                                                   |            0.022 |      0    |       0    |         1 | 2020-06-23   |
|  914 | [F26B1F81](https://metrics.torproject.org/rs.html#details/F26B1F81CB15201A955326D23B35243AA18A7D52)                                                                   |            0.022 |      0.07 |       0    |         1 | 2020-08-04   |
|  915 | [admin AT ubermen DOT net](https://metrics.torproject.org/rs.html#details/01F73DBD9B56C31E3D3AAEB95F8CF1DEB7D9A72F)                                                   |            0.021 |      0.07 |       0    |         1 | 2020-04-13   |
|  916 | [paladin](https://metrics.torproject.org/rs.html#details/0325B91D3C32D3A24C863D5DFBED00564FAD5C64)                                                                    |            0.021 |      0.07 |       0    |         1 | 2020-04-07   |
|  917 | [0849FFD2](https://metrics.torproject.org/rs.html#details/0849FFD2946597D8A31084489C0EEE36842BAE7A)                                                                   |            0.021 |      0    |       0    |         1 | 2020-05-05   |
|  918 | [8D20AB41D54E8DBB6959CB279FFA184FB0DE0270 latopeku](https://metrics.torproject.org/rs.html#search/family:0D13FEFB150903100AF2F9E52A5852EC105A817E)                    |            0.021 |      0    |       0.03 |         2 | 2018-02-12   |
|  919 | [echo gbe@tbbqsryybj.vg rot13](https://metrics.torproject.org/rs.html#details/138ED47EE2156E6492FDE0B61338D973C9717F32)                                               |            0.021 |      0    |       0.03 |         1 | 2017-01-23   |
|  920 | [tor-exit@vrij-heid.nl](https://metrics.torproject.org/rs.html#search/family:1C4147BDE31ED65715FE1CF088570E145BF46AA1)                                                |            0.021 |      0.07 |       0    |         4 | 2020-02-15   |
|  921 | [Random Person &lt;tor@shelldog.de&gt;](https://metrics.torproject.org/rs.html#details/1C7215BC0123DDA23BDED0F9D2849D3AD80183CB)                                      |            0.021 |      0    |       0.03 |         1 | 2019-12-13   |
|  922 | [abuse@cyanpencil.xyz](https://metrics.torproject.org/rs.html#details/229D865D7AC084D30E5F5016CE5A8C21740F74F4)                                                       |            0.021 |      0.07 |       0    |         1 | 2019-09-13   |
|  923 | [2659ACAA](https://metrics.torproject.org/rs.html#details/2659ACAA140B6845E38F189B4080817B9819EB9A)                                                                   |            0.021 |      0    |       0.03 |         1 | 2018-02-06   |
|  924 | [toratweill-duflos.fr](https://metrics.torproject.org/rs.html#details/288DA2F27E30BC73FC8A84367696C9DF6B4C1B90)                                                       |            0.021 |      0    |       0.03 |         1 | 2018-03-14   |
|  925 | [2AD82F39](https://metrics.torproject.org/rs.html#details/2AD82F3964D325B3FE2FF74E980FB006374EF190)                                                                   |            0.021 |      0    |       0.03 |         1 | 2016-11-26   |
|  926 | [pKD9jZ19N1LiTvsjOF3Y at tutanota com](https://metrics.torproject.org/rs.html#details/37DDF1906EE3DB96130A717EA54667C64DAC78DF)                                       |            0.021 |      0    |       0.03 |         1 | 2019-03-29   |
|  927 | [3A51E32A](https://metrics.torproject.org/rs.html#details/3A51E32A303A0E0A3AB8AA1CCBE98FF8791E2341)                                                                   |            0.021 |      0    |       0    |         1 | 2020-03-22   |
|  928 | [3C9DFAB1](https://metrics.torproject.org/rs.html#details/3C9DFAB14D02F792B81782C2BB5B3C43E38E6254)                                                                   |            0.021 |      0    |       0.03 |         1 | 2020-05-05   |
|  929 | [jackyes89@protonmail.com](https://metrics.torproject.org/rs.html#details/3D636FB9D24EA781C3C2766C051064C6CA1C0D96)                                                   |            0.021 |      0    |       0.03 |         1 | 2020-04-17   |
|  930 | [3F158155](https://metrics.torproject.org/rs.html#details/3F1581559522B27BD1342F2A3A0022F273FA93D6)                                                                   |            0.021 |      0    |       0.03 |         1 | 2019-03-23   |
|  931 | [dumbletor at protonmail DOT com tor-relay.co](https://metrics.torproject.org/rs.html#details/454BE75256A4A5EC2B7FE2EB2E1C62F2736AB175)                               |            0.021 |      0    |       0.03 |         1 | 2019-03-07   |
|  932 | [ohello@tuta.io](https://metrics.torproject.org/rs.html#details/462ECB5FF94C6AB6971E451710B748BE20F7CC8B)                                                             |            0.021 |      0    |       0.03 |         1 | 2019-06-30   |
|  933 | [466D5100](https://metrics.torproject.org/rs.html#details/466D5100A7BFB152A7630447010BDC1B971FB034)                                                                   |            0.021 |      0.07 |       0    |         1 | 2020-08-03   |
|  934 | [4EBF4D27](https://metrics.torproject.org/rs.html#details/4EBF4D27DD632BEB90ACC32ECEA824069444BFE8)                                                                   |            0.021 |      0.07 |       0    |         1 | 2020-07-15   |
|  935 | [tor-operator@emailfucker.club](https://metrics.torproject.org/rs.html#details/5127A719E495710CEBB0A446CD69207BA6E0D6D6)                                              |            0.021 |      0    |       0.03 |         1 | 2020-07-21   |
|  936 | [Tsen &lt;tsenchi.ng AT yandex dot com&gt;](https://metrics.torproject.org/rs.html#search/family:51AE5656C81CD417479253A6363A123A007A2233)                            |            0.021 |      0.07 |       0    |         2 | 2017-08-13   |
|  937 | [Brian Penrose &lt;penr0se@openmail.cc&gt; - 8397 C079 68](https://metrics.torproject.org/rs.html#details/5262556D44A7F2434990FDE1AE7973C67DF49E58)                   |            0.021 |      0    |       0.03 |         1 | 2019-06-26   |
|  938 | [4096R/0x4cf76925833e2e24 Knight &lt;knight AT germanc](https://metrics.torproject.org/rs.html#details/5665A3904C89E22E971305EE8C1997BCA4123C69)                      |            0.021 |      0    |       0    |         1 | 2014-10-05   |
|  939 | [&lt;node-tor@ipoac.nl&gt; reverse tor and node](https://metrics.torproject.org/rs.html#details/59C0D88A5B3C65541CF63D0DD88EF15A379D378E)                             |            0.021 |      0    |       0    |         1 | 2020-02-07   |
|  940 | [none](https://metrics.torproject.org/rs.html#details/5BB51E650366D14C95027DB2F1D7A69BC5B00676)                                                                       |            0.021 |      0    |       0.03 |         1 | 2014-07-11   |
|  941 | [5F0BFF8B](https://metrics.torproject.org/rs.html#details/5F0BFF8BF2C7528E41DB149245F4736C75CC7779)                                                                   |            0.021 |      0    |       0.03 |         1 | 2019-07-01   |
|  942 | [65E40F7E](https://metrics.torproject.org/rs.html#details/65E40F7EDD28E2CF28684E30E0BAB7706819CFC3)                                                                   |            0.021 |      0    |       0    |         1 | 2019-08-27   |
|  943 | [maltimore &lt;tor AT maltimore dot info&gt;](https://metrics.torproject.org/rs.html#details/7158D1E0D9F90F7999ACB3B073DA762C9B2C3275)                                |            0.021 |      0    |       0.03 |         1 | 2019-08-19   |
|  944 | [79AEF5CE](https://metrics.torproject.org/rs.html#details/79AEF5CEA5EC01C0B4D6B9DE21B86EE7D2DA4CDC)                                                                   |            0.021 |      0.07 |       0    |         1 | 2020-08-04   |
|  945 | [tor at sglorch dot me tor-relay.co](https://metrics.torproject.org/rs.html#details/7E47D28F07443B57F8262E1412936B3E258694A3)                                         |            0.021 |      0    |       0.03 |         1 | 2019-07-07   |
|  946 | [825213FB](https://metrics.torproject.org/rs.html#details/825213FB6551BA81EBA6594E31121370E3DB8488)                                                                   |            0.021 |      0.07 |       0    |         1 | 2020-08-04   |
|  947 | [8AAD0B09](https://metrics.torproject.org/rs.html#details/8AAD0B090311B7A43D44FD353F32D21628C85D52)                                                                   |            0.021 |      0    |       0.03 |         1 | 2020-05-16   |
|  948 | [tor-operator@your-emailaddress-domain](https://metrics.torproject.org/rs.html#details/97B7BA747B62A9962DEDCE404FF33106D4032F91)                                      |            0.021 |      0    |       0.03 |         1 | 2020-05-05   |
|  949 | [John Marshall &lt;johnmarshall AT seznam dot cz&gt;](https://metrics.torproject.org/rs.html#search/family:9A9BC34468AC1677782E4E56B27D947A9C991E2E)                  |            0.021 |      0    |       0.03 |         3 | 2016-04-05   |
|  950 | [9B8BC7AB](https://metrics.torproject.org/rs.html#details/9B8BC7AB8792ED42DD9C5D7E8D02C38E60FBA381)                                                                   |            0.021 |      0    |       0.03 |         1 | 2020-06-22   |
|  951 | [tomtor at tomforb dot es tor-relay.co](https://metrics.torproject.org/rs.html#details/A7E6640FEC85C9B04FB778A51CB999E35A29531E)                                      |            0.021 |      0    |       0.03 |         1 | 2018-02-04   |
|  952 | [samam &lt; at &gt; protonmail.com](https://metrics.torproject.org/rs.html#details/A9F5135AE18C7E25C7C79117CD8C7619BFEB85ED)                                          |            0.021 |      0    |       0.03 |         1 | 2016-02-03   |
|  953 | [Fyodor Ustinov ufm@ufm.su](https://metrics.torproject.org/rs.html#details/AF77AA5BD924319510F99B30CD0932D32B01B5C5)                                                  |            0.021 |      0    |       0.03 |         1 | 2014-09-21   |
|  954 | [B0A63BC3](https://metrics.torproject.org/rs.html#details/B0A63BC3FDA67A7ADD1BE08BAA8309C4B204D29B)                                                                   |            0.021 |      0    |       0.03 |         1 | 2019-12-24   |
|  955 | [B1080EA6](https://metrics.torproject.org/rs.html#details/B1080EA61CAF5763139E7B596F37FE9830311C8F)                                                                   |            0.021 |      0    |       0.03 |         1 | 2019-10-16   |
|  956 | [Jack &lt;jack reacher@riseup.net an3svpj5bpwfzskhs7tk](https://metrics.torproject.org/rs.html#details/BA0A023DF7D0A03E2CB5A180E1DD54B0950AA5C1)                      |            0.021 |      0    |       0.03 |         1 | 2020-06-25   |
|  957 | [&lt;salator AT protonmail dot com&gt;](https://metrics.torproject.org/rs.html#details/BA39D0333CF0F2026F58D8A493168F92A016CAA1)                                      |            0.021 |      0    |       0.03 |         1 | 2020-05-01   |
|  958 | [tor-operator@maildomain.com](https://metrics.torproject.org/rs.html#details/BC123DB7F61E9DB31F23B37BF62A16DAA1010FC9)                                                |            0.021 |      0    |       0.03 |         1 | 2020-03-28   |
|  959 | [Hostmaster RMF FM &lt;hostmaster AT rmf dot pl&gt;](https://metrics.torproject.org/rs.html#details/C9D02B1644BD47C136E379FDFAF4973D1A1CE07C)                         |            0.021 |      0    |       0.03 |         1 | 2016-11-17   |
|  960 | [D6288320](https://metrics.torproject.org/rs.html#details/D628832091562BD6F28E94DCB56EC3E5B10DC1C6)                                                                   |            0.021 |      0    |       0.03 |         1 | 2019-07-25   |
|  961 | [neowutran &lt;tor@neowutran.ovh&gt;](https://metrics.torproject.org/rs.html#details/D6AC8B8513372F6474344C93B8A5A8AE3E3C962C)                                        |            0.021 |      0.07 |       0    |         1 | 2020-01-26   |
|  962 | [slashcrypto-tor@protonmail.com](https://metrics.torproject.org/rs.html#details/D777D31F95081D0F7223AAD5F8A74977D524145D)                                             |            0.021 |      0    |       0.03 |         1 | 2018-11-13   |
|  963 | [D96DD727](https://metrics.torproject.org/rs.html#details/D96DD7272DFF712E6C939BCE69FBF4DD7AA0ECAC)                                                                   |            0.021 |      0    |       0    |         1 | 2020-06-20   |
|  964 | [Tor &lt;tor@plutex.de&gt;](https://metrics.torproject.org/rs.html#details/EF9C4611FAA7C21155A8BA2A721DDC3D27816035)                                                  |            0.021 |      0.07 |       0    |         1 | 2017-06-05   |
|  965 | [F7ACB367](https://metrics.torproject.org/rs.html#details/F7ACB36752F2D27A03800E505D1599F26C981B53)                                                                   |            0.021 |      0    |       0.03 |         1 | 2020-06-24   |
|  966 | [Random Mike &lt;nobody AT example dot com&gt;](https://metrics.torproject.org/rs.html#details/FD7ED9F4871E2EC46035FC602960EACC32E08FF8)                              |            0.021 |      0    |       0.03 |         1 | 2017-10-17   |
|  967 | [ricksybusiness@riseup.net](https://metrics.torproject.org/rs.html#details/01AE2DE314276C82FCCC3603A1C2F3238E6544C9)                                                  |            0.02  |      0    |       0.03 |         1 | 2016-08-10   |
|  968 | [diccwett@secmail dot pro](https://metrics.torproject.org/rs.html#details/1690976085F0DD5F08226722DDE01F8606EA7C48)                                                   |            0.02  |      0    |       0    |         1 | 2019-11-07   |
|  969 | [tor@yksflip.de](https://metrics.torproject.org/rs.html#details/174D93DF6242BD4ABE2C09E6607892C3A3905675)                                                             |            0.02  |      0    |       0.03 |         1 | 2020-06-25   |
|  970 | [358npyhXKrv834iyqtjHthudXRc5NjQcvm xmtx tor](https://metrics.torproject.org/rs.html#details/1850585BE9BCA1F80D0A051909C94E49D1C49ED3)                                |            0.02  |      0    |       0.03 |         1 | 2018-12-08   |
|  971 | [fr33tux &lt;tor AT fr33tux dot org&gt;](https://metrics.torproject.org/rs.html#details/225A8EA367DF3073433E0A845DDDA26D2357E4C6)                                     |            0.02  |      0    |       0.03 |         1 | 2019-01-26   |
|  972 | [2984E431](https://metrics.torproject.org/rs.html#details/2984E4317B844899E1CE143828CC1600F7CE072E)                                                                   |            0.02  |      0    |       0    |         1 | 2020-01-16   |
|  973 | [2ACE8ED8](https://metrics.torproject.org/rs.html#search/family:2ACE8ED85C29716EAD73520837CA8F4D9ED4BF12)                                                             |            0.02  |      0    |       0.03 |         3 | 2014-05-01   |
|  974 | [Matthias Fassl &lt;matthias dot fassl AT cispa dot sa](https://metrics.torproject.org/rs.html#details/2AFF47D161619E32C21B90AE7C65DC2057150294)                      |            0.02  |      0    |       0.03 |         1 | 2020-04-28   |
|  975 | [rotor aT schmeling-ol doT-- de](https://metrics.torproject.org/rs.html#search/family:2B8E642811FF6F610600F2703AB59E42FB9A00CB)                                       |            0.02  |      0    |       0    |         2 | 2019-09-15   |
|  976 | [luciole &lt;luciolesauronkingofmortor@yopmail.com&gt;](https://metrics.torproject.org/rs.html#details/2D8AFA912E2B8623BB2CDACD19332209D524D1A3)                      |            0.02  |      0    |       0.03 |         1 | 2016-08-24   |
|  977 | [Another net subway &lt;harden0i AT riseup dot net&gt;](https://metrics.torproject.org/rs.html#details/32A1ED707343CDEFFC105EC8DF068A0E154DF6CE)                      |            0.02  |      0    |       0.03 |         1 | 2019-11-18   |
|  978 | [toradmin AT armyr dot se](https://metrics.torproject.org/rs.html#details/39379E4177FFFB0ED90C2013D97668BD284A1798)                                                   |            0.02  |      0    |       0.03 |         1 | 2016-11-12   |
|  979 | [tor AT renz DOT cloud](https://metrics.torproject.org/rs.html#details/5043E5D2E9CE99066DF1FBF0B18E065B08131863)                                                      |            0.02  |      0    |       0.03 |         1 | 2018-12-28   |
|  980 | [https://nino.link/gpg Nino TREYSSAT-VINCENT &lt;nino](https://metrics.torproject.org/rs.html#details/58FAB58A7DC8E99B9313F6E488E2140D4BE28416)                       |            0.02  |      0    |       0.03 |         1 | 2018-03-02   |
|  981 | [devfalseatpmdtme](https://metrics.torproject.org/rs.html#search/family:59CF9A030CC61A4432564738F46E30DB06893494)                                                     |            0.02  |      0    |       0    |         2 | 2020-06-24   |
|  982 | [0xEC5E413B Trolli Schmittlauch &lt;spiollilock@google](https://metrics.torproject.org/rs.html#details/5B4D6B845AC3CC97EB3169D0C774469364322948)                      |            0.02  |      0    |       0    |         1 | 2014-10-29   |
|  983 | [Evolyn &lt;toradmin@evolyn.de&gt; 17HZHq2tGtUjzns3oFDev3](https://metrics.torproject.org/rs.html#details/6406B69F95D06F6A94CFDD83E85EE9C410A05D47)                   |            0.02  |      0    |       0.03 |         1 | 2017-06-05   |
|  984 | [gx386pkt7xj@temp.mailbox.org](https://metrics.torproject.org/rs.html#details/6C282D35C674A036B79B5F30E90D19B363D3DAB2)                                               |            0.02  |      0    |       0.03 |         1 | 2020-03-11   |
|  985 | [scruffyscruffington at mail dot com](https://metrics.torproject.org/rs.html#details/73E2046A1E7F0E95D36C3F979CE5FAC3609AC610)                                        |            0.02  |      0    |       0.03 |         1 | 2020-04-02   |
|  986 | [torATrcptDOTat](https://metrics.torproject.org/rs.html#details/7961C9991F022C8A363FD440CA395D47DB5D44D5)                                                             |            0.02  |      0    |       0.03 |         1 | 2016-03-12   |
|  987 | [798A57B4](https://metrics.torproject.org/rs.html#details/798A57B4E129699A521A03E7F72BC0FDEC31F4D6)                                                                   |            0.02  |      0    |       0    |         1 | 2019-11-24   |
|  988 | [79E48A32](https://metrics.torproject.org/rs.html#details/79E48A3242DB3515700F8925FA8E6323F8D51D7D)                                                                   |            0.02  |      0    |       0.03 |         1 | 2018-03-20   |
|  989 | [pitfall](https://metrics.torproject.org/rs.html#details/7E77CC94D94C08609D70B517FF938CC61C9F8232)                                                                    |            0.02  |      0.06 |       0    |         1 | 2020-04-03   |
|  990 | [7E8BC43A](https://metrics.torproject.org/rs.html#details/7E8BC43AE75EAE16D7EC4676F4A5C355F454B809)                                                                   |            0.02  |      0    |       0.03 |         1 | 2018-03-19   |
|  991 | [8B73A0FE](https://metrics.torproject.org/rs.html#details/8B73A0FE9754E7CE3BE74F8571B1FE07A9B333E6)                                                                   |            0.02  |      0    |       0    |         1 | 2020-07-07   |
|  992 | [8D4B2E7B](https://metrics.torproject.org/rs.html#details/8D4B2E7B65BF61532369F6F3808549831B8A0FEB)                                                                   |            0.02  |      0    |       0    |         1 | 2020-06-04   |
|  993 | [relay.alpha@protonmail.com](https://metrics.torproject.org/rs.html#details/90633012A1A752D8D02FEC8374A4BF98941A1900)                                                 |            0.02  |      0    |       0.03 |         1 | 2019-05-04   |
|  994 | [torrelay &lt;at&gt; tnonline.net](https://metrics.torproject.org/rs.html#details/98350B16551452ABC7F3457D06032CD30F7280CE)                                           |            0.02  |      0    |       0.03 |         1 | 2018-03-26   |
|  995 | [9EFF16EA](https://metrics.torproject.org/rs.html#details/9EFF16EA25FF27BC438A3FBF23C5315E576467AF)                                                                   |            0.02  |      0    |       0.03 |         1 | 2019-08-12   |
|  996 | [TorAdmin &lt;toradmin AT tanascius dot com&gt;](https://metrics.torproject.org/rs.html#details/A36D13036750E477E0C5628A5BE4FECB63286D80)                             |            0.02  |      0    |       0.03 |         1 | 2019-12-07   |
|  997 | [email:gnu1170 tuta.io operatorurl:http://4pan6dte](https://metrics.torproject.org/rs.html#details/A7A3D155579D8D5FBD28AB77B40F71037872F934)                          |            0.02  |      0.06 |       0    |         1 | 2020-06-16   |
|  998 | [apunkt at mailbox dot org](https://metrics.torproject.org/rs.html#details/ABA31795BAD2AB8097F3AD0FE1A920E518D3D3F3)                                                  |            0.02  |      0    |       0.03 |         1 | 2020-04-02   |
|  999 | [B2741D35](https://metrics.torproject.org/rs.html#details/B2741D35F0FDACE03350DBECD8BE8A84FEFB33DC)                                                                   |            0.02  |      0.06 |       0    |         1 | 2020-02-09   |
| 1000 | [j4c4l4 at protonmail dot com dot remove dot](https://metrics.torproject.org/rs.html#details/B568135C5E345BAFB080C11FDDF348E545A722E5)                                |            0.02  |      0    |       0    |         1 | 2019-06-19   |
| 1001 | [honeybee3827ATtutanotaDOTcom](https://metrics.torproject.org/rs.html#details/B940AAC942E9929E673C3533F510C5261B50790C)                                               |            0.02  |      0    |       0.03 |         1 | 2019-12-27   |
| 1002 | [I haz Tor at llit dot eu](https://metrics.torproject.org/rs.html#details/C203A1CE39268E9E8CDF5E63A9C39181092006D9)                                                   |            0.02  |      0    |       0.03 |         1 | 2020-06-20   |
| 1003 | [C2F653A5](https://metrics.torproject.org/rs.html#details/C2F653A5CEE30C8D5713FA4AE7F75E992A479196)                                                                   |            0.02  |      0    |       0.03 |         1 | 2018-04-26   |
| 1004 | [mikael.murf.se](https://metrics.torproject.org/rs.html#details/C9857DF26C27473F7338D613832C9C299ABF77BE)                                                             |            0.02  |      0.06 |       0    |         1 | 2018-10-02   |
| 1005 | [CC100DC0](https://metrics.torproject.org/rs.html#details/CC100DC017A25E244C35C964BB518E4308415ACC)                                                                   |            0.02  |      0    |       0.03 |         1 | 2019-03-20   |
| 1006 | [D39328D2](https://metrics.torproject.org/rs.html#details/D39328D2EAE3816F9C5D5D1BB19D1C14E2E79482)                                                                   |            0.02  |      0    |       0.03 |         1 | 2019-12-21   |
| 1007 | [subtype@protonmail.com](https://metrics.torproject.org/rs.html#search/family:D4991BF14BF7D4BB684E56AB02A44A6CA6391606)                                               |            0.02  |      0.06 |       0    |         2 | 2019-10-17   |
| 1008 | [D5A2B3AE](https://metrics.torproject.org/rs.html#details/D5A2B3AE1E8047017A0BBC7209FD624DB84D47CE)                                                                   |            0.02  |      0    |       0.03 |         1 | 2019-04-25   |
| 1009 | [puia at posteo dot eu](https://metrics.torproject.org/rs.html#details/D6F03EFBE511417D77DCFC1A3F1EB5D4BF509F81)                                                      |            0.02  |      0    |       0.03 |         1 | 2020-01-06   |
| 1010 | [bakingoven175@protonmail.com](https://metrics.torproject.org/rs.html#details/DC0E94BC65DB2C5AA752A30234E2723DF704A1A9)                                               |            0.02  |      0    |       0.03 |         1 | 2020-07-27   |
| 1011 | [E608A39C](https://metrics.torproject.org/rs.html#details/E608A39C91D9E051365633FD0BC90DF828495476)                                                                   |            0.02  |      0    |       0.03 |         1 | 2020-07-21   |
| 1012 | [E75ABF29](https://metrics.torproject.org/rs.html#details/E75ABF29D4B417D3D3565AEDAF89E4F9D16E736F)                                                                   |            0.02  |      0    |       0.03 |         1 | 2017-07-13   |
| 1013 | [ED2BF11C](https://metrics.torproject.org/rs.html#details/ED2BF11CB3C0205CADC94596DC688A5153FCAB35)                                                                   |            0.02  |      0    |       0.03 |         1 | 2019-08-14   |
| 1014 | [aditaa@pm.me - btc 3JXBE2tDpxR1whEcY3MU9RtijyR6xJT](https://metrics.torproject.org/rs.html#details/EE3AC155F03CDA6BDD8877179A91F3CEEB0FDE05)                         |            0.02  |      0.06 |       0    |         1 | 2018-12-28   |
| 1015 | [EEDC92C8](https://metrics.torproject.org/rs.html#details/EEDC92C8E4F14EFB6200FB4C92D4F957B98652B4)                                                                   |            0.02  |      0    |       0.03 |         1 | 2015-09-11   |
| 1016 | [2B2F 63E5 0DC3 201D BC77 2005 159B 448D 0BD8 FD0F](https://metrics.torproject.org/rs.html#details/F4F605AA21C4633CCB5B8DBBC1CEEE5C590C6DCE)                          |            0.02  |      0    |       0.03 |         1 | 2010-01-03   |
| 1017 | [&lt;tor@nullvoid.me&gt; - 19uSqvGnqgyGgRe5HGJjjiSu5RkQfC](https://metrics.torproject.org/rs.html#search/family:019FEB22CE04CBD0489B7F24BE038518B64FA223)             |            0.019 |      0    |       0.03 |         2 | 2016-03-16   |
| 1018 | [secretcontact@protonmail dot com](https://metrics.torproject.org/rs.html#details/0AD3B16ADF3EED3E5962FA944CD501352E790814)                                           |            0.019 |      0    |       0.03 |         1 | 2016-05-17   |
| 1019 | [Random Person &lt;bridges AT onenetbeyond dot net&gt;](https://metrics.torproject.org/rs.html#search/family:0D6E25BD8C540178C309EE2A84C7A74496360D6E)                |            0.019 |      0    |       0.03 |         2 | 2020-04-08   |
| 1020 | [100195E0](https://metrics.torproject.org/rs.html#details/100195E079A761751587E31A091D2E2206F35C3A)                                                                   |            0.019 |      0    |       0    |         1 | 2019-03-20   |
| 1021 | [tor AT heteigenwijsje DOT nl](https://metrics.torproject.org/rs.html#details/1283EBDEEC2B9D745F1E7FBE83407655B984FD66)                                               |            0.019 |      0.06 |       0    |         1 | 2017-10-12   |
| 1022 | [tomas.vanagas@knf.vu.lt tor-relay.co](https://metrics.torproject.org/rs.html#details/1939CC1B41298A49C0684878813DED5CD1A9EE98)                                       |            0.019 |      0.06 |       0    |         1 | 2019-03-29   |
| 1023 | [mmxtor a marx.wtf](https://metrics.torproject.org/rs.html#search/family:1C24A2669C7E0D62B2157B95F56ED00EE307C85C)                                                    |            0.019 |      0.02 |       0.02 |         2 | 2019-07-17   |
| 1024 | [28912DC1](https://metrics.torproject.org/rs.html#details/28912DC1BB58E60F9F5A142B99B8EAEBBCF0F6C1)                                                                   |            0.019 |      0    |       0    |         1 | 2020-08-06   |
| 1025 | [31419A64](https://metrics.torproject.org/rs.html#details/31419A64188BC8070EE89F3CEE6AA98EAAC7E8E8)                                                                   |            0.019 |      0    |       0.03 |         1 | 2016-02-15   |
| 1026 | [bc1qxzjwvzqe54cn8v2zd7hy4tl97dkswtcwsqf48g](https://metrics.torproject.org/rs.html#details/34133CC3192CF7538089B14511400DF21BA5A077)                                 |            0.019 |      0    |       0.03 |         1 | 2016-12-19   |
| 1027 | [bitcoin:31tCBhET25mU2ViLa2CPbU5SqmHaUNpA6E](https://metrics.torproject.org/rs.html#details/3994E734DCD794479D1A60F4ABD3FC91CAA395EE)                                 |            0.019 |      0.06 |       0    |         1 | 2017-04-28   |
| 1028 | [@FuckTrump](https://metrics.torproject.org/rs.html#details/3CC2F6162A3E278F77FE4B413A2B67A7F07F28D1)                                                                 |            0.019 |      0    |       0    |         1 | 2020-08-07   |
| 1029 | [b3f73616-3681-4ba1-b2f0-615f8b0002e3 at anonaddy d](https://metrics.torproject.org/rs.html#details/405F35A10556611FB81CA3E5C01BF1A54F11BD4C)                         |            0.019 |      0.06 |       0    |         1 | 2020-03-12   |
| 1030 | [4089AFC6](https://metrics.torproject.org/rs.html#search/family:4089AFC68F3CBEA8D135F5D7110DAA8A14F3928B)                                                             |            0.019 |      0    |       0.03 |         2 | 2019-09-22   |
| 1031 | [tor AT w0lff DOT de](https://metrics.torproject.org/rs.html#details/410118E874D2263F1CDCD567F81875A8E38B2B3C)                                                        |            0.019 |      0    |       0.03 |         1 | 2019-01-12   |
| 1032 | [shebangs@yopmail.fr](https://metrics.torproject.org/rs.html#details/453E51CBAA4C2169EBCB05583247DD6201E87FAD)                                                        |            0.019 |      0    |       0.03 |         1 | 2020-06-05   |
| 1033 | [45639F6B](https://metrics.torproject.org/rs.html#details/45639F6B88747598422507717E5FA066B184406C)                                                                   |            0.019 |      0.06 |       0    |         1 | 2020-08-03   |
| 1034 | [476CD2DD](https://metrics.torproject.org/rs.html#details/476CD2DDF42DE135636F3944C4CC89A22E8FC9E4)                                                                   |            0.019 |      0.06 |       0    |         1 | 2020-08-03   |
| 1035 | [anders.io](https://metrics.torproject.org/rs.html#search/family:483CE40BAD189F840EB2222A558F96C11C2B79B0)                                                            |            0.019 |      0.02 |       0    |         5 | 2020-08-11   |
| 1036 | [4D568479](https://metrics.torproject.org/rs.html#details/4D568479B37A688769F410E9A914909E8CC2A5B8)                                                                   |            0.019 |      0    |       0.03 |         1 | 2019-07-24   |
| 1037 | [tor at sigstop dot org](https://metrics.torproject.org/rs.html#search/family:4FA1F401F8C3E8326031E7994045BE67F36033A6)                                               |            0.019 |      0.04 |       0    |         3 | 2014-04-08   |
| 1038 | [root@cicolina.org](https://metrics.torproject.org/rs.html#details/4FE3FD67F2F06D8AD929217A357F623FC7C692D9)                                                          |            0.019 |      0    |       0.03 |         1 | 2011-06-03   |
| 1039 | [hans.erl @ tutanota.com](https://metrics.torproject.org/rs.html#details/5047962E97AFDC89C9B9EE98322F3E4CB7BEB639)                                                    |            0.019 |      0    |       0.03 |         1 | 2020-03-30   |
| 1040 | [58332DDD](https://metrics.torproject.org/rs.html#details/58332DDDA15415CB3D13F5ECA3D54BE961B8C458)                                                                   |            0.019 |      0    |       0.03 |         1 | 2015-12-04   |
| 1041 | [594193E5](https://metrics.torproject.org/rs.html#details/594193E51F382E34080D76B5ECAF5C7B67CF05EF)                                                                   |            0.019 |      0    |       0.03 |         1 | 2018-02-04   |
| 1042 | [kenrushATprotonmail.com](https://metrics.torproject.org/rs.html#details/5C5D61F279AA0816F506FD5CE86C30F256291DDE)                                                    |            0.019 |      0    |       0.03 |         1 | 2020-01-26   |
| 1043 | [John Doe &lt;webmaster aT krypta d0t net&gt;](https://metrics.torproject.org/rs.html#details/5D2A8CAA119D0528722C2438350FAB0C8DE01AB7)                               |            0.019 |      0    |       0.03 |         1 | 2015-11-07   |
| 1044 | [ohello@tuta.io](https://metrics.torproject.org/rs.html#details/614094CAF0701EB568106E60EC12A785E704AE0F)                                                             |            0.019 |      0    |       0.03 |         1 | 2019-02-19   |
| 1045 | [secretcontact@protonmail dot com](https://metrics.torproject.org/rs.html#details/699388030AFC5C110822C85DE97A51545B192987)                                           |            0.019 |      0    |       0.03 |         1 | 2015-12-09   |
| 1046 | [eucyp07lcdxBqIrICfjnGAfczbEkvB at dont-break dot i](https://metrics.torproject.org/rs.html#details/73713518E8BD7110D0C6D84F0682C1E0B7541F79)                         |            0.019 |      0    |       0    |         1 | 2019-10-20   |
| 1047 | [74B41DED](https://metrics.torproject.org/rs.html#details/74B41DED505CFABC7A8D439362FC9B6589DE4591)                                                                   |            0.019 |      0    |       0.03 |         1 | 2019-04-10   |
| 1048 | [dragon](https://metrics.torproject.org/rs.html#details/79349A6F74AC0D4EF2939894B122702E57786F5A)                                                                     |            0.019 |      0.06 |       0    |         1 | 2020-04-07   |
| 1049 | [7A6873B8](https://metrics.torproject.org/rs.html#details/7A6873B86D82BC8B4F0E790828626107820F7B9E)                                                                   |            0.019 |      0    |       0.03 |         1 | 2016-06-01   |
| 1050 | [832A5C79 Faustin &lt;faustin AT fala dot red&gt;](https://metrics.torproject.org/rs.html#details/7EB91FDB68EAD3A13808D9356DA82605773215F5)                           |            0.019 |      0    |       0.03 |         1 | 2016-08-25   |
| 1051 | [7F04E089](https://metrics.torproject.org/rs.html#details/7F04E089C6BED83E04FB2AE196BDE34B808094F5)                                                                   |            0.019 |      0    |       0.03 |         1 | 2020-01-06   |
| 1052 | [81A1D777](https://metrics.torproject.org/rs.html#details/81A1D777C023EBB1DEE9E7FA8735629BA8F7497C)                                                                   |            0.019 |      0    |       0.03 |         1 | 2019-02-25   |
| 1053 | [823183CE](https://metrics.torproject.org/rs.html#details/823183CEB754CDE8E76A3722D783CA031E7E160A)                                                                   |            0.019 |      0    |       0.03 |         1 | 2020-01-06   |
| 1054 | [IRC: 'Maxell@freenode'](https://metrics.torproject.org/rs.html#details/84CB0782C8CA81A7263EE86F321EDFECC611369A)                                                     |            0.019 |      0    |       0.03 |         1 | 2020-03-18   |
| 1055 | [898AA9A1](https://metrics.torproject.org/rs.html#details/898AA9A17ECBB05FEA4FE7418BD1C64F45D9A614)                                                                   |            0.019 |      0    |       0.03 |         1 | 2018-12-23   |
| 1056 | [psYchotic](https://metrics.torproject.org/rs.html#details/8D41994D1D18E94403C3F67D0699E4C9D2248D4A)                                                                  |            0.019 |      0    |       0.03 |         1 | 2017-06-10   |
| 1057 | [jimmy at bulanik dot nl](https://metrics.torproject.org/rs.html#details/8E76F1F6E8499CCE975C451560586A5F8BF0BFDB)                                                    |            0.019 |      0    |       0.03 |         1 | 2018-02-20   |
| 1058 | [91BA193F](https://metrics.torproject.org/rs.html#details/91BA193FB362FB7B6679A7A83A3050F3C44A5468)                                                                   |            0.019 |      0    |       0.03 |         1 | 2018-12-24   |
| 1059 | [riisseli4 gmail com](https://metrics.torproject.org/rs.html#search/family:91C6AE74A3520AE890F051E992F5C7F6D391E61F)                                                  |            0.019 |      0    |       0.03 |         2 | 2019-09-22   |
| 1060 | [aze &lt;tor AT aze dot wtf&gt;](https://metrics.torproject.org/rs.html#search/family:95F22A129FD1EE5BFF95218DDBA838BF6DBBDA7E)                                       |            0.019 |      0    |       0.03 |         2 | 2015-11-14   |
| 1061 | [t.o.r d.s.t c.a](https://metrics.torproject.org/rs.html#details/964B4E8A75263A69769541F2764563DABDD995D2)                                                            |            0.019 |      0    |       0.03 |         1 | 2018-08-13   |
| 1062 | [9BA1289C](https://metrics.torproject.org/rs.html#details/9BA1289CDCFD907B8D40A8AB12F36BE620DD4085)                                                                   |            0.019 |      0    |       0.03 |         1 | 2018-10-08   |
| 1063 | [martastarta@web.de](https://metrics.torproject.org/rs.html#details/A1D8BE264B369180006CDA03998879B49CFAE93B)                                                         |            0.019 |      0    |       0    |         1 | 2020-02-06   |
| 1064 | [Trinity &lt;trinity.pointardrelayu24B6gmail.com&gt;](https://metrics.torproject.org/rs.html#details/A8503903F97FF27F5D1C3CA38817329F581925E6)                        |            0.019 |      0    |       0    |         1 | 2020-06-06   |
| 1065 | [B1490646](https://metrics.torproject.org/rs.html#details/B149064611DC466405E1825956F36B202DCE6E4A)                                                                   |            0.019 |      0    |       0.03 |         1 | 2018-11-18   |
| 1066 | [shebangs@yopmail.fr](https://metrics.torproject.org/rs.html#details/BA8546AE9B27F0C81F98A6C12D96B7DAB0814991)                                                        |            0.019 |      0    |       0.03 |         1 | 2020-06-06   |
| 1067 | [tor 68vLrekt8iJQfvJ@gmx.de](https://metrics.torproject.org/rs.html#details/BFD3FC19AD1F691C01B5392DE90D3510B8D1B886)                                                 |            0.019 |      0    |       0.03 |         1 | 2020-06-09   |
| 1068 | [tor at d-ku dot de - 0x86d7bbcc54cbb356 tor-rela](https://metrics.torproject.org/rs.html#details/C4B21A66B27E82FEF6AC97CEAEFE42DFF5C7511C)                           |            0.019 |      0    |       0.03 |         1 | 2020-02-20   |
| 1069 | [admin &lt;AT&gt; samsan .DOT .de](https://metrics.torproject.org/rs.html#details/C55AC4238C66CE8D00838572D563A284DBEF0228)                                           |            0.019 |      0    |       0.03 |         1 | 2018-07-10   |
| 1070 | [C75CDD81](https://metrics.torproject.org/rs.html#details/C75CDD818316ABBC839F9F0DDAEC873FCF60C370)                                                                   |            0.019 |      0    |       0.03 |         1 | 2019-01-11   |
| 1071 | [CB6D9B6B](https://metrics.torproject.org/rs.html#details/CB6D9B6B1ED3E0186E3019EFA8AA34E7E57913C0)                                                                   |            0.019 |      0    |       0.03 |         1 | 2019-11-08   |
| 1072 | [TRFI&gt; torrelayfi gmail](https://metrics.torproject.org/rs.html#details/CD6E8C548704F4CE544CD71365D46F110518FBED)                                                  |            0.019 |      0    |       0    |         1 | 2019-07-22   |
| 1073 | [shebangs@yopmail.fr](https://metrics.torproject.org/rs.html#details/CEA2E066A7F8EC0F235F5190E25DD3C9F86F084B)                                                        |            0.019 |      0    |       0.03 |         1 | 2020-06-06   |
| 1074 | [D60C2D85](https://metrics.torproject.org/rs.html#details/D60C2D85EAD93D23F1C00874D334BBF8A96CD529)                                                                   |            0.019 |      0    |       0.03 |         1 | 2019-12-26   |
| 1075 | [DA9E02BB](https://metrics.torproject.org/rs.html#details/DA9E02BB8080E473157052F70439B7886AA8569D)                                                                   |            0.019 |      0    |       0    |         1 | 2020-01-11   |
| 1076 | [mandalorian.outpost.222@yandex DOT com](https://metrics.torproject.org/rs.html#details/DAC825BBF05D678ABDEA1C3086E8D99CF0BBF112)                                     |            0.019 |      0    |       0.03 |         1 | 2016-07-19   |
| 1077 | [nyxwolf@protonmail.com](https://metrics.torproject.org/rs.html#details/DAEF8B8B799C711A86350FDC4337B2B3A75B97C9)                                                     |            0.019 |      0    |       0.03 |         1 | 2020-01-23   |
| 1078 | [DF7AA16E](https://metrics.torproject.org/rs.html#details/DF7AA16E1A6037C5FCBB4DED4F3A6CD262CA3799)                                                                   |            0.019 |      0    |       0.03 |         1 | 2018-03-19   |
| 1079 | [Random Person - 157z4qvT6FdZoDNPrRpKJaayjSWxsHmduc](https://metrics.torproject.org/rs.html#details/E17745C64255D2920D9B9FCF9EF930C426EE4A91)                         |            0.019 |      0    |       0.03 |         1 | 2019-05-01   |
| 1080 | [NotProvided](https://metrics.torproject.org/rs.html#details/E91E77CBD13217F9429309474FA33D98B943E246)                                                                |            0.019 |      0    |       0    |         1 | 2019-12-08   |
| 1081 | [FF08C3FB](https://metrics.torproject.org/rs.html#details/FF08C3FBB6026AC96C9E51E4DB6D120436450B5D)                                                                   |            0.019 |      0    |       0    |         1 | 2020-06-24   |
| 1082 | [03CFF900](https://metrics.torproject.org/rs.html#details/03CFF90060461087D34FFB7B485C3AD30143775C)                                                                   |            0.018 |      0    |       0.03 |         1 | 2020-02-09   |
| 1083 | [0BCD2A99](https://metrics.torproject.org/rs.html#details/0BCD2A99AA76C0985FC28140CE710549C70AC0FD)                                                                   |            0.018 |      0    |       0    |         1 | 2020-05-06   |
| 1084 | [0F8C945A](https://metrics.torproject.org/rs.html#details/0F8C945AC2D754125630AF74617E3FFE690BB966)                                                                   |            0.018 |      0    |       0.03 |         1 | 2020-07-02   |
| 1085 | [1D04FF92](https://metrics.torproject.org/rs.html#details/1D04FF920CE804CE357FE62C665901C578BC26D6)                                                                   |            0.018 |      0    |       0.03 |         1 | 2019-09-02   |
| 1086 | [contact@mail.taau.xyz](https://metrics.torproject.org/rs.html#details/1D5A20A47771B80995711E20195A21ECB173E1C2)                                                      |            0.018 |      0    |       0    |         1 | 2019-11-10   |
| 1087 | [1F7EAF14](https://metrics.torproject.org/rs.html#details/1F7EAF14071F8975AFCF219FD62E8451B40E70BB)                                                                   |            0.018 |      0.06 |       0    |         1 | 2020-06-01   |
| 1088 | [torstat AT posteo.fi](https://metrics.torproject.org/rs.html#details/1FDF4D0660A7497222C3BA24FEEA316244093CD7)                                                       |            0.018 |      0    |       0.03 |         1 | 2020-04-22   |
| 1089 | [26B09A4C](https://metrics.torproject.org/rs.html#details/26B09A4C9F6A9D4815DB46EBA3626A0ED8D71E8F)                                                                   |            0.018 |      0    |       0.03 |         1 | 2019-09-08   |
| 1090 | [preecher at preecher d o t co](https://metrics.torproject.org/rs.html#details/2779DB3B7A0EEC32F39792E393CAA134847BBF6C)                                              |            0.018 |      0    |       0.03 |         1 | 2020-02-05   |
| 1091 | [2F271015](https://metrics.torproject.org/rs.html#details/2F2710152A2344B1DE3EF619E85CB1B298643D27)                                                                   |            0.018 |      0    |       0.03 |         1 | 2018-12-20   |
| 1092 | [2F644DDE](https://metrics.torproject.org/rs.html#details/2F644DDEF8BAA31BA0240E6C6D36665D90DA57C9)                                                                   |            0.018 |      0    |       0.03 |         1 | 2019-10-31   |
| 1093 | [user at hein1.de](https://metrics.torproject.org/rs.html#search/family:31FC0066DA78D1464A2542E8D9EBF6FD6F99AE1E)                                                     |            0.018 |      0    |       0    |         3 | 2020-01-16   |
| 1094 | [citadel.exit@gmail.com](https://metrics.torproject.org/rs.html#details/331FC9E123EC20877486845343B2D300B8F9E45A)                                                     |            0.018 |      0.06 |       0    |         1 | 2020-04-07   |
| 1095 | [3EE6BA53](https://metrics.torproject.org/rs.html#details/3EE6BA5394B18AEF14E0D3B959D733B7A1EC3AD5)                                                                   |            0.018 |      0    |       0.03 |         1 | 2020-06-26   |
| 1096 | [3FEBFB6A](https://metrics.torproject.org/rs.html#details/3FEBFB6A491D30CACC2C2995EDB41717A6F94E95)                                                                   |            0.018 |      0    |       0.03 |         1 | 2015-06-06   |
| 1097 | [tor at txwx.de](https://metrics.torproject.org/rs.html#search/family:412BAA4DE44DA7D14583DE63CEB3DF89835E6AC8)                                                       |            0.018 |      0    |       0    |         2 | 2016-09-08   |
| 1098 | [some student &lt;ufrbc AT student dot kit dot edu&gt;](https://metrics.torproject.org/rs.html#details/489606DA64FD4B68A76C49386298695E6C30B5E2)                      |            0.018 |      0    |       0.03 |         1 | 2019-09-26   |
| 1099 | [49828C96](https://metrics.torproject.org/rs.html#details/49828C962C7B04FA28CFEC839F224F406F8F36D8)                                                                   |            0.018 |      0.06 |       0    |         1 | 2020-07-27   |
| 1100 | [Lyberta &lt;lyberta AT lyberta dot net&gt;](https://metrics.torproject.org/rs.html#details/4B16758168D4F334BE11872F7B6BAE2E44664E5B)                                 |            0.018 |      0    |       0.03 |         1 | 2017-03-28   |
| 1101 | [Tor &lt;Tor AT wojak dot xyz&gt;](https://metrics.torproject.org/rs.html#search/family:4B919C783B1145060DF518940252FE2B5B128F67)                                     |            0.018 |      0    |       0    |         2 | 2020-07-22   |
| 1102 | [516034FF](https://metrics.torproject.org/rs.html#details/516034FF15C96CE841ECCD876EF604802AA5C650)                                                                   |            0.018 |      0    |       0.03 |         1 | 2017-01-19   |
| 1103 | [daniel .at. fnutt .dot. net](https://metrics.torproject.org/rs.html#details/529CA3EB08AD6EC1791B5110AA3540A4CFA1197F)                                                |            0.018 |      0    |       0.03 |         1 | 2019-01-05   |
| 1104 | [52A774C4](https://metrics.torproject.org/rs.html#details/52A774C4472FC10186BDBDC4374C0F9A601300B7)                                                                   |            0.018 |      0.06 |       0    |         1 | 2020-07-10   |
| 1105 | [54F5D800](https://metrics.torproject.org/rs.html#details/54F5D800DD9783FCF2200E80EF3D1A867A3F6D6B)                                                                   |            0.018 |      0    |       0.03 |         1 | 2018-09-28   |
| 1106 | [557B3914](https://metrics.torproject.org/rs.html#details/557B39146EB121C8CFA22C48AD78BDBDBC8FF3A1)                                                                   |            0.018 |      0    |       0.03 |         1 | 2017-12-19   |
| 1107 | [Tor node&lt;t0r-n0d3@protonmail.com&gt;](https://metrics.torproject.org/rs.html#details/5582BBEC12380E34D7DFB8C237939A0B317B205E)                                    |            0.018 |      0    |       0    |         1 | 2016-10-29   |
| 1108 | [foobarshizzle at gmail dot com](https://metrics.torproject.org/rs.html#details/5B701D5C806F91D8A3C6B3E92624727EC43E26C2)                                             |            0.018 |      0    |       0.03 |         1 | 2019-12-03   |
| 1109 | [fabian AT hufenreuter dot info](https://metrics.torproject.org/rs.html#details/5D995EC983ED3DF9DAABD32B9BF1540AFF42A457)                                             |            0.018 |      0    |       0.03 |         1 | 2018-11-15   |
| 1110 | [5E4D1E6D](https://metrics.torproject.org/rs.html#details/5E4D1E6D31413DCCC148A8050224578CBBF12883)                                                                   |            0.018 |      0    |       0.03 |         1 | 2018-02-03   |
| 1111 | [68ED2295](https://metrics.torproject.org/rs.html#details/68ED229545B43091366714D65F475A4238402964)                                                                   |            0.018 |      0    |       0    |         1 | 2020-07-09   |
| 1112 | [68FBE72B](https://metrics.torproject.org/rs.html#details/68FBE72B0D411C314EC7F272CB5B3F14C2429246)                                                                   |            0.018 |      0    |       0.03 |         1 | 2018-10-02   |
| 1113 | [6B5508FD](https://metrics.torproject.org/rs.html#details/6B5508FD5E31F98A1E74DB6B2087A93F1E0658F1)                                                                   |            0.018 |      0    |       0    |         1 | 2020-05-04   |
| 1114 | [71B9A25F](https://metrics.torproject.org/rs.html#details/71B9A25F48E53A5C2C85DDCB5C193B4F4D5D19C6)                                                                   |            0.018 |      0    |       0    |         1 | 2020-07-09   |
| 1115 | [746B3C4B](https://metrics.torproject.org/rs.html#details/746B3C4BADCCA09003DD091AF028560A61E0A48E)                                                                   |            0.018 |      0    |       0.03 |         1 | 2019-06-19   |
| 1116 | [Nervous Energy &lt;nrvsDOTnrg@pmDOTme&gt;](https://metrics.torproject.org/rs.html#details/75FB9A4469199F251581061391214ACFDC682EF4)                                  |            0.018 |      0    |       0.03 |         1 | 2020-01-26   |
| 1117 | [76D3CC1A](https://metrics.torproject.org/rs.html#details/76D3CC1A906732C8B7F90E9B5A0FF3BE4A4A52DF)                                                                   |            0.018 |      0    |       0.03 |         1 | 2019-02-28   |
| 1118 | [8118F4C0](https://metrics.torproject.org/rs.html#details/8118F4C0E60C84A453ACCD1641F3A7328CBE6280)                                                                   |            0.018 |      0    |       0.03 |         1 | 2019-12-09   |
| 1119 | [tor-admin &lt;tor@mnesys.org&gt;](https://metrics.torproject.org/rs.html#details/86D924EDE1498B4E1DD08D2260F3E9FE454012E1)                                           |            0.018 |      0    |       0.03 |         1 | 2018-09-23   |
| 1120 | [888E9C8A](https://metrics.torproject.org/rs.html#details/888E9C8ABDE13F7177939D40810F5EA0BEDA9346)                                                                   |            0.018 |      0    |       0    |         1 | 2020-07-06   |
| 1121 | [0x79E29476C64DA2B2B3C5505BB9240F8411EFD678 ; admin](https://metrics.torproject.org/rs.html#details/8A5E7C2D09835974B4D58252BAD51FD8AD54F9CE)                         |            0.018 |      0    |       0.03 |         1 | 2020-01-16   |
| 1122 | [gnu1170 AT tuta DOT io / BTC: BC1Q8W6WYH3ZKPYWXEPA](https://metrics.torproject.org/rs.html#details/8D62E8BEE96F6C6818C715CD64C8B719E523E497)                         |            0.018 |      0.06 |       0    |         1 | 2020-06-18   |
| 1123 | [901C2689](https://metrics.torproject.org/rs.html#details/901C2689FDABE7165AB7AC4E8231F12A2674916E)                                                                   |            0.018 |      0    |       0.03 |         1 | 2020-07-11   |
| 1124 | [9149A87E](https://metrics.torproject.org/rs.html#search/family:9149A87E1C8AD684494580FBB3F65AD131A77C56)                                                             |            0.018 |      0    |       0    |         2 | 2020-07-08   |
| 1125 | [harmony](https://metrics.torproject.org/rs.html#details/9446EE28342A8B4502B4DA24DA18851BC9E516E0)                                                                    |            0.018 |      0.06 |       0    |         1 | 2020-04-03   |
| 1126 | [paul at coffswifi.net](https://metrics.torproject.org/rs.html#details/9C5AFD49AAE4E0272BAD780C6DD71CE1A36012A6)                                                      |            0.018 |      0.06 |       0    |         1 | 2018-06-07   |
| 1127 | [A1DEB529](https://metrics.torproject.org/rs.html#details/A1DEB529DE86E7CABC3212778374933D68FB7F2F)                                                                   |            0.018 |      0    |       0.03 |         1 | 2020-01-02   |
| 1128 | [0x641814BB9C9F44AE tor@nicolasmueller.eu](https://metrics.torproject.org/rs.html#details/AAFFA68AB61238F9044B6ECBA62E25264113EB88)                                   |            0.018 |      0    |       0.03 |         1 | 2020-04-18   |
| 1129 | [shebangs@yopmail.fr](https://metrics.torproject.org/rs.html#details/AC990FD1FF5058EFA43A809E948B23EF998D021B)                                                        |            0.018 |      0    |       0.03 |         1 | 2020-06-05   |
| 1130 | [Ali Gatorr &lt;Ali DOT Gatorr AT free DOT fr&gt;](https://metrics.torproject.org/rs.html#details/ACBF3D504CFF3D74D1991AFDF6AC070606232B10)                           |            0.018 |      0    |       0.03 |         1 | 2020-04-30   |
| 1131 | [B3C6B4D2](https://metrics.torproject.org/rs.html#details/B3C6B4D26A20151F568D39ACFA63E15DBC01CD5D)                                                                   |            0.018 |      0    |       0.03 |         1 | 2020-07-22   |
| 1132 | [mattsaviour@tutanota.com](https://metrics.torproject.org/rs.html#details/BA27D43AC00F014945DC32D036056F13FE1D5243)                                                   |            0.018 |      0    |       0    |         1 | 2020-03-02   |
| 1133 | [James Taylor &lt;tor AT fornoreason dot net dot au&gt;](https://metrics.torproject.org/rs.html#search/family:BCEF908195805E03E92CCFE669C48738E556B9C5)               |            0.018 |      0    |       0.02 |         3 | 2014-11-11   |
| 1134 | [CA6A1295](https://metrics.torproject.org/rs.html#details/CA6A1295456D14F8C78CE623EB779EF2C1CCC7F0)                                                                   |            0.018 |      0    |       0.03 |         1 | 2020-07-17   |
| 1135 | [apunkt at mailbox dot org](https://metrics.torproject.org/rs.html#details/CB2DBDB2D9422D57AD85148EF9511AF4CE4D6052)                                                  |            0.018 |      0    |       0.03 |         1 | 2020-04-04   |
| 1136 | [nobody-tor &lt;nobody-tor AT noc37.gesindel.org&gt;](https://metrics.torproject.org/rs.html#details/D7EB93B50A4D1EEDBC5354C312428680F3AA9025)                        |            0.018 |      0    |       0    |         1 | 2020-01-05   |
| 1137 | [E05EAB58](https://metrics.torproject.org/rs.html#details/E05EAB588285C01E8807F00A07CDBBC4662A58D9)                                                                   |            0.018 |      0    |       0.03 |         1 | 2015-10-29   |
| 1138 | [desert](https://metrics.torproject.org/rs.html#details/EB6A879331A20D3D39874960E1076A8421F5A44C)                                                                     |            0.018 |      0.06 |       0    |         1 | 2020-04-03   |
| 1139 | [ED361245](https://metrics.torproject.org/rs.html#details/ED36124515F71E2E2401D70D9EFC3CAEB08D611B)                                                                   |            0.018 |      0    |       0.03 |         1 | 2019-03-20   |
| 1140 | [EF1A9BE2](https://metrics.torproject.org/rs.html#details/EF1A9BE231A6C3AC94B9E2BFC86990B16C923A45)                                                                   |            0.018 |      0    |       0.03 |         1 | 2016-01-14   |
| 1141 | [F059C76B](https://metrics.torproject.org/rs.html#details/F059C76B861B25D8F1BBDA4AD37D1B69035423EC)                                                                   |            0.018 |      0    |       0.03 |         1 | 2020-05-11   |
| 1142 | [shebangs@yopmail.fr](https://metrics.torproject.org/rs.html#details/F3A3461889BF97250F50A7BAAAE4A2B92062F6D7)                                                        |            0.018 |      0    |       0.03 |         1 | 2020-07-03   |
| 1143 | [FA32998A](https://metrics.torproject.org/rs.html#details/FA32998AF5628483D8E7B7BB0A4641D33A206A28)                                                                   |            0.018 |      0    |       0.03 |         1 | 2020-01-25   |
| 1144 | [FE927480](https://metrics.torproject.org/rs.html#details/FE9274800E2A2241E42FBE60CEB1DB89103575E6)                                                                   |            0.018 |      0.06 |       0    |         1 | 2020-07-16   |
| 1145 | [Admin &lt;mnlph74 AT protonmail dot com&gt;](https://metrics.torproject.org/rs.html#search/family:05402AEC738554C5308FB07CA68961D5326D5D4A)                          |            0.017 |      0    |       0.02 |         3 | 2019-11-01   |
| 1146 | [998ff4256e18c5cb AT yopmail dot com](https://metrics.torproject.org/rs.html#details/0CB40D12177CBABAB87652BBFC00A7E6F4434D3E)                                        |            0.017 |      0    |       0.03 |         1 | 2019-03-11   |
| 1147 | [0DD04EF0](https://metrics.torproject.org/rs.html#details/0DD04EF0B081BBFDE3082D4ECC8A63FD0022FCAF)                                                                   |            0.017 |      0    |       0.02 |         1 | 2015-10-22   |
| 1148 | [11C3D14A](https://metrics.torproject.org/rs.html#details/11C3D14A1166AEDED6D247A32DE6451F6C95223A)                                                                   |            0.017 |      0    |       0.02 |         1 | 2019-12-29   |
| 1149 | [&lt;fake34857 AT sofort-start dot de&gt;](https://metrics.torproject.org/rs.html#search/family:188673CF3937442517301800F383BE53D4A17732)                             |            0.017 |      0    |       0.02 |         3 | 2015-10-04   |
| 1150 | [1BC78DF3](https://metrics.torproject.org/rs.html#details/1BC78DF308807DDD6F3C06488BD88AF2B04BA9C7)                                                                   |            0.017 |      0    |       0    |         1 | 2020-06-20   |
| 1151 | [1C70C2AA](https://metrics.torproject.org/rs.html#details/1C70C2AA7F3772CE07C4EF6B18A6E330150372EE)                                                                   |            0.017 |      0    |       0.03 |         1 | 2018-10-20   |
| 1152 | [tor at milkywan dot fr](https://metrics.torproject.org/rs.html#search/family:22D2314BC5146890A8E5C19C884D96C0CBFEAA24)                                               |            0.017 |      0    |       0.02 |         2 | 2019-01-18   |
| 1153 | [23AD6B16](https://metrics.torproject.org/rs.html#search/family:23AD6B165137D957C09AA0F7A3EE7B05CEC4A8F2)                                                             |            0.017 |      0    |       0.03 |         2 | 2017-02-08   |
| 1154 | [puma](https://metrics.torproject.org/rs.html#details/2785C4A65FE9ADC5C75E79F0B034ECDE3700F820)                                                                       |            0.017 |      0.05 |       0    |         1 | 2020-04-03   |
| 1155 | [31072312](https://metrics.torproject.org/rs.html#details/310723122778237508274A36E9557B060A531BDD)                                                                   |            0.017 |      0    |       0.02 |         1 | 2020-07-25   |
| 1156 | [owlnetwork2@secmail.pro](https://metrics.torproject.org/rs.html#details/4586DF1934953F38206B5117237F79C1C8797FC4)                                                    |            0.017 |      0    |       0.02 |         1 | 2020-07-09   |
| 1157 | [4D52A12D](https://metrics.torproject.org/rs.html#details/4D52A12D9AD22A7E1BE5B564953A7CA9C31DA675)                                                                   |            0.017 |      0    |       0.02 |         1 | 2019-10-11   |
| 1158 | [daniel.tor@protonmail.com](https://metrics.torproject.org/rs.html#details/4F1B6DDF9A8D7747BF5DD562B895A700008EC906)                                                  |            0.017 |      0    |       0.02 |         1 | 2020-06-01   |
| 1159 | [5368AB8D](https://metrics.torproject.org/rs.html#details/5368AB8D9033A357729D3578617A6493AB5DA3A8)                                                                   |            0.017 |      0    |       0.02 |         1 | 2019-01-19   |
| 1160 | [deeznodes@protonmail.com](https://metrics.torproject.org/rs.html#details/55804F9D37F7B27BD0426B3CB06C64B4D0F95546)                                                   |            0.017 |      0    |       0.03 |         1 | 2020-02-18   |
| 1161 | [67A4CFB9](https://metrics.torproject.org/rs.html#details/67A4CFB98708FF2B4A72D6A8EFB0B6D0A930F73C)                                                                   |            0.017 |      0.05 |       0    |         1 | 2019-08-15   |
| 1162 | [tor plus argus at albus dot xyz](https://metrics.torproject.org/rs.html#details/6D72E970EB5218702C854BE250EC0663CC14D9BD)                                            |            0.017 |      0    |       0.02 |         1 | 2018-11-02   |
| 1163 | [82B94663](https://metrics.torproject.org/rs.html#details/82B94663F141978FB2252A166A7FCFF0BA3A1701)                                                                   |            0.017 |      0    |       0.03 |         1 | 2014-09-09   |
| 1164 | [87A2EABE](https://metrics.torproject.org/rs.html#details/87A2EABEAB0D7E4EB002A42D26000F5CB8D5B937)                                                                   |            0.017 |      0    |       0.03 |         1 | 2020-01-03   |
| 1165 | [Alexander &lt;stolknovenie@gmail.com&gt;](https://metrics.torproject.org/rs.html#details/890530C5B510A506F5CF206EFEC1595F96E727A5)                                   |            0.017 |      0    |       0.02 |         1 | 2018-05-18   |
| 1166 | [AAA03044](https://metrics.torproject.org/rs.html#details/AAA03044B42AD37D5C5592D6604A6D1B72F4B3BE)                                                                   |            0.017 |      0    |       0.03 |         1 | 2019-09-26   |
| 1167 | [AEDFB1F1](https://metrics.torproject.org/rs.html#details/AEDFB1F1F69DC74A90BCF87B587252334D7D180E)                                                                   |            0.017 |      0    |       0.03 |         1 | 2020-07-11   |
| 1168 | [LunaR](https://metrics.torproject.org/rs.html#details/B187399E2708155968A8375B83042767F69F21F0)                                                                      |            0.017 |      0.05 |       0    |         1 | 2020-04-07   |
| 1169 | [0xE4ACD8BA Lars Kumbier &lt;lars@kumbier.it&gt;](https://metrics.torproject.org/rs.html#details/B291D30517D23299AD7CEE3E60DFE60D0E3A4664)                            |            0.017 |      0    |       0.02 |         1 | 2015-05-14   |
| 1170 | [B728832F](https://metrics.torproject.org/rs.html#details/B728832F0AB11E5450EC320230E2B7D33EC08F49)                                                                   |            0.017 |      0    |       0.02 |         1 | 2020-05-28   |
| 1171 | [C0F508AD](https://metrics.torproject.org/rs.html#details/C0F508ADA14AE7EA9F8F6650AF149B8DFC35B598)                                                                   |            0.017 |      0    |       0.03 |         1 | 2016-05-03   |
| 1172 | [C3799054](https://metrics.torproject.org/rs.html#details/C3799054BC7F0D201FB7C0F9DE31BF1F3D868A37)                                                                   |            0.017 |      0    |       0.02 |         1 | 2020-01-03   |
| 1173 | [t0rexitnode dot pm dot me tor-relay.co](https://metrics.torproject.org/rs.html#details/CB72A74E8197DF3B33EE6A0895E5BB871D10CF92)                                     |            0.017 |      0    |       0.02 |         1 | 2019-01-13   |
| 1174 | [titanium](https://metrics.torproject.org/rs.html#details/CD9549ED5A655BA47427A77835C55FF00EC1DA23)                                                                   |            0.017 |      0.05 |       0    |         1 | 2020-04-20   |
| 1175 | [sparky2749@gmail.com](https://metrics.torproject.org/rs.html#details/DF445006932A7BA942F3EBB4457D7ABF2E4006E0)                                                       |            0.017 |      0    |       0.02 |         1 | 2016-02-03   |
| 1176 | [tor AT epipe.com](https://metrics.torproject.org/rs.html#details/E13F7EE1535ED8AEAB92A5EEAEE9A0C782ED33E2)                                                           |            0.017 |      0    |       0.02 |         1 | 2018-03-13   |
| 1177 | [E39A758B](https://metrics.torproject.org/rs.html#details/E39A758BD81DD27E8AA27998688E816D0A13DC82)                                                                   |            0.017 |      0    |       0.02 |         1 | 2019-12-11   |
| 1178 | [E7723680](https://metrics.torproject.org/rs.html#details/E7723680EA1F78E015DF312411990D5F5E815C27)                                                                   |            0.017 |      0    |       0    |         1 | 2020-08-01   |
| 1179 | [&lt;definitelyNotLE AT protonmail dot com&gt;](https://metrics.torproject.org/rs.html#details/ECAA097324262B60394FE6F3CD446A66A331956E)                              |            0.017 |      0    |       0.02 |         1 | 2018-10-21   |
| 1180 | [F878E3AD](https://metrics.torproject.org/rs.html#details/F878E3AD594F013195A051CD1072BF33D543A235)                                                                   |            0.017 |      0    |       0    |         1 | 2020-02-25   |
| 1181 | [0330D582](https://metrics.torproject.org/rs.html#details/0330D5827F3253A98AE6AF30D56A0F8BED1CA586)                                                                   |            0.016 |      0    |       0    |         1 | 2019-12-21   |
| 1182 | [03DC081E](https://metrics.torproject.org/rs.html#details/03DC081E4409631006EFCD3AF13AFAAF2B553FFC)                                                                   |            0.016 |      0    |       0.02 |         1 | 2017-04-12   |
| 1183 | [05349C0F](https://metrics.torproject.org/rs.html#details/05349C0F35C5635A708888004F8B022931E8BEE6)                                                                   |            0.016 |      0    |       0.02 |         1 | 2020-03-12   |
| 1184 | [Inbox: tor/sevenlayers/org](https://metrics.torproject.org/rs.html#details/0935BA9178F9E3B50C99DD53F723865FC224CFA8)                                                 |            0.016 |      0    |       0.02 |         1 | 2018-10-18   |
| 1185 | [0AF90285](https://metrics.torproject.org/rs.html#details/0AF90285D6B3ECC52ABFA3CB31404DF6FAF93134)                                                                   |            0.016 |      0    |       0.02 |         1 | 2019-03-20   |
| 1186 | [me &lt;jan &amp;Auml;T afoo d&amp;ouml;t de&gt;](https://metrics.torproject.org/rs.html#details/1145A39EC0CE18834E67D2799E3C5D87453C5EF2)                            |            0.016 |      0    |       0.02 |         1 | 2018-11-18   |
| 1187 | [t o r p r o j e c t m a i l b o x dot o r g](https://metrics.torproject.org/rs.html#search/family:12FD624EE73CEF37137C90D38B2406A66F68FAA2)                          |            0.016 |      0    |       0.02 |         2 | 2015-05-14   |
| 1188 | [rortor@rorvick.com](https://metrics.torproject.org/rs.html#search/family:1408DA5C310FEECE76E7CF88FB68ECB28B22D4DC)                                                   |            0.016 |      0    |       0.02 |         6 | 2018-08-27   |
| 1189 | [bw-tor-relay@protonmail.com](https://metrics.torproject.org/rs.html#details/1733D57AA16D2E9E5A448DA607FCA5FA989E4F4D)                                                |            0.016 |      0    |       0.02 |         1 | 2019-05-07   |
| 1190 | [Neutrino &lt;neutrino AT mnd dot de&gt;](https://metrics.torproject.org/rs.html#details/1A002B6E163D502F23381391718E11A568976403)                                    |            0.016 |      0    |       0.02 |         1 | 2017-03-08   |
| 1191 | [1C79D5A4](https://metrics.torproject.org/rs.html#details/1C79D5A473214714A761C0A40DD2D5B031F7E980)                                                                   |            0.016 |      0    |       0.02 |         1 | 2019-03-20   |
| 1192 | [1D4F3F07](https://metrics.torproject.org/rs.html#details/1D4F3F077009207D5D41FD99F7638894ABC1AB93)                                                                   |            0.016 |      0    |       0    |         1 | 2020-05-19   |
| 1193 | [1D812722](https://metrics.torproject.org/rs.html#details/1D81272219B679D511930499AD8286BCD8F6C445)                                                                   |            0.016 |      0    |       0.02 |         1 | 2018-11-23   |
| 1194 | [0xFFFFFFFF Random Person &lt;admin&lt;at&gt;ninjaipservers.](https://metrics.torproject.org/rs.html#details/1F5D00297D1B9FCC09CCDE62CA1043E3621FA973)                |            0.016 |      0    |       0.02 |         1 | 2018-04-02   |
| 1195 | [your name &lt;admin@uk.net&gt;](https://metrics.torproject.org/rs.html#details/1F768F39EDFA445C14E18E915B0CED7E14E450CF)                                             |            0.016 |      0    |       0.02 |         1 | 2018-10-25   |
| 1196 | [208F39CC](https://metrics.torproject.org/rs.html#details/208F39CCF602D9549E57D6A386259C1129B8D244)                                                                   |            0.016 |      0    |       0.02 |         1 | 2020-07-19   |
| 1197 | [1024D/0x49360B3B1DFBA164 Bernhard M. Wiedemann &lt;to](https://metrics.torproject.org/rs.html#details/211310CD09EC290505C1F24018AE5330076412A0)                      |            0.016 |      0    |       0    |         1 | 2018-02-08   |
| 1198 | [257342F2](https://metrics.torproject.org/rs.html#details/257342F27502A108EECA766F3B125441B3DD4F4E)                                                                   |            0.016 |      0    |       0.02 |         1 | 2020-07-17   |
| 1199 | [272AC842](https://metrics.torproject.org/rs.html#details/272AC842521666E3D1B0E5EAFAC79EF73EC88972)                                                                   |            0.016 |      0    |       0.02 |         1 | 2020-06-10   |
| 1200 | [276AE7A0](https://metrics.torproject.org/rs.html#details/276AE7A0E974FC96B0933F1DA8FD51FD3BA59944)                                                                   |            0.016 |      0    |       0.02 |         1 | 2020-07-17   |
| 1201 | [28B86FF1](https://metrics.torproject.org/rs.html#details/28B86FF1F7876647A2ECFC0B1F0F640B6DD4AEF2)                                                                   |            0.016 |      0    |       0    |         1 | 2020-02-17   |
| 1202 | [Robert.Lewis@linuxmail.com](https://metrics.torproject.org/rs.html#details/29FA511E67A31A1A874AABFB2B624AD122AE4ED4)                                                 |            0.016 |      0    |       0.02 |         1 | 2016-05-03   |
| 1203 | [tor@vient.re](https://metrics.torproject.org/rs.html#details/2ABA928945F7EC1E9DD105A628D5C05609DB5B6D)                                                               |            0.016 |      0    |       0.02 |         1 | 2018-07-13   |
| 1204 | [tontu at nisse dot xyz tor-relay.co](https://metrics.torproject.org/rs.html#search/family:2AEC1BD634BCD3A4251DC004558B3E9C5D1C05A2)                                  |            0.016 |      0    |       0.01 |         2 | 2020-03-28   |
| 1205 | [torette@horsefucker.org](https://metrics.torproject.org/rs.html#details/304B631B1BC51705DAE7BAF566487AFE25807380)                                                    |            0.016 |      0    |       0.02 |         1 | 2019-10-22   |
| 1206 | [Nein](https://metrics.torproject.org/rs.html#details/32C1100B5EF19A5BFBB431E8D42781C2D09D31C3)                                                                       |            0.016 |      0    |       0.02 |         1 | 2020-03-27   |
| 1207 | [36EBA005](https://metrics.torproject.org/rs.html#details/36EBA005CE1BBD9B164600A4666D9EA37082D838)                                                                   |            0.016 |      0    |       0    |         1 | 2018-11-04   |
| 1208 | [noc at louifox dot house](https://metrics.torproject.org/rs.html#search/family:383882E740FC9214A21A60E8D4B10A220272113B)                                             |            0.016 |      0    |       0.02 |         6 | 2019-11-28   |
| 1209 | [Xavier Bettel](https://metrics.torproject.org/rs.html#details/3BBF9D98C7D058D7C2E60F6BA5BD574CB4F3FE26)                                                              |            0.016 |      0    |       0.02 |         1 | 2017-12-19   |
| 1210 | [abuse.kryptosoftwares@pm.me](https://metrics.torproject.org/rs.html#details/3BF2133239FD21D97C3E944FA0757CD2AC1E198B)                                                |            0.016 |      0.05 |       0    |         1 | 2020-07-13   |
| 1211 | [44496B18](https://metrics.torproject.org/rs.html#details/44496B18C68356AF3A58ACAD835429C37B9432ED)                                                                   |            0.016 |      0    |       0.02 |         1 | 2019-05-02   |
| 1212 | [Martin Kroell &lt;martin at kroell dot net&gt;](https://metrics.torproject.org/rs.html#details/44DF1007B545B4D8057F279025EBB33CF99BE227)                             |            0.016 |      0    |       0.02 |         1 | 2018-11-28   |
| 1213 | [joe45 at firemail dot cc](https://metrics.torproject.org/rs.html#details/459310E0C3A72CAACAE10BEEBB7484D724C9C8C0)                                                   |            0.016 |      0    |       0.02 |         1 | 2019-10-14   |
| 1214 | [4A0E54E6](https://metrics.torproject.org/rs.html#details/4A0E54E69343B7CF6138C118843CE860E8511F78)                                                                   |            0.016 |      0    |       0.02 |         1 | 2016-01-14   |
| 1215 | [giorgio dot 46 at tim dot it](https://metrics.torproject.org/rs.html#details/598EA0E595C541EA91B4434BC643F01110862AC5)                                               |            0.016 |      0.05 |       0    |         1 | 2019-06-20   |
| 1216 | [5D7A932D](https://metrics.torproject.org/rs.html#details/5D7A932DF156B4AAE4C3080775AFE9C006207E17)                                                                   |            0.016 |      0    |       0    |         1 | 2020-06-28   |
| 1217 | [pupokin at gmx de](https://metrics.torproject.org/rs.html#details/68D2ABD936233A569E2B46D6228816149A16B4FA)                                                          |            0.016 |      0    |       0.02 |         1 | 2016-11-25   |
| 1218 | [ricochet:ynp6ws6ih2xz5k65](https://metrics.torproject.org/rs.html#details/6A7551EEE18F78A9813096E82BF84F740D32B911)                                                  |            0.016 |      0    |       0.02 |         1 | 2014-04-11   |
| 1219 | [0xEB40518A d-sier &lt;d-sier@protonmail.com&gt;](https://metrics.torproject.org/rs.html#details/6F06E35586E88EF78BDA698C62AC781EA8D80C4A)                            |            0.016 |      0    |       0.02 |         1 | 2019-10-04   |
| 1220 | [7B10E2D8](https://metrics.torproject.org/rs.html#details/7B10E2D82A60EFC4E97CE5A9F4E8C9A79C59DFC5)                                                                   |            0.016 |      0    |       0    |         1 | 2020-05-20   |
| 1221 | [Cedric &lt;chutney dot tor AT gmx dot com&gt;](https://metrics.torproject.org/rs.html#details/81A59766272894D27FE8375C4F83A6BA453671EF)                              |            0.016 |      0    |       0.02 |         1 | 2016-01-25   |
| 1222 | [8C612213](https://metrics.torproject.org/rs.html#details/8C612213C4B5C154FA90847F36FBF36DB78AB1AC)                                                                   |            0.016 |      0    |       0.02 |         1 | 2019-02-22   |
| 1223 | [8E308CC5](https://metrics.torproject.org/rs.html#details/8E308CC5AD17064E56F1FA60ACACAEBADB79BF3E)                                                                   |            0.016 |      0    |       0    |         1 | 2020-07-29   |
| 1224 | [8E398814](https://metrics.torproject.org/rs.html#details/8E39881472946D5BBE41765470D9E3099A0EB4C7)                                                                   |            0.016 |      0    |       0.02 |         1 | 2019-12-30   |
| 1225 | [GPG:0xda1884d squiddog@squiddog.org](https://metrics.torproject.org/rs.html#details/90A40EAF6090BD260237BDFE9391A2EFF35E8733)                                        |            0.016 |      0    |       0.02 |         1 | 2019-04-20   |
| 1226 | [9127D95D](https://metrics.torproject.org/rs.html#details/9127D95DAA81291F26BE45B1A73E2F1145887B94)                                                                   |            0.016 |      0    |       0.02 |         1 | 2020-07-19   |
| 1227 | [Relay Admin &lt;tor AT jrrzz dot net&gt;](https://metrics.torproject.org/rs.html#details/A1699AF5D7E0294E45D42FFA697F762BA26340E9)                                   |            0.016 |      0    |       0.02 |         1 | 2015-05-21   |
| 1228 | [sparta](https://metrics.torproject.org/rs.html#details/A87D19DD1A89327B8DB878DC2793426752799B5C)                                                                     |            0.016 |      0.05 |       0    |         1 | 2020-04-03   |
| 1229 | [Tor Relay &lt;t.relay AT i2work dot com&gt;](https://metrics.torproject.org/rs.html#details/A98ADD972045D3CCAEE65C788C3F175BAEA3E324)                                |            0.016 |      0    |       0.02 |         1 | 2017-03-19   |
| 1230 | [12345 at 12345 dot co](https://metrics.torproject.org/rs.html#details/AB12BFBDAC07DFF1A1BD10BDE23A66C506262F6C)                                                      |            0.016 |      0    |       0    |         1 | 2020-06-06   |
| 1231 | [&lt;toradmin at rlogin.net&gt; - help fund tails by bi](https://metrics.torproject.org/rs.html#search/family:AE4FAE2EB5DC5D078458F0FCBF2B37F5D73F0868)               |            0.016 |      0    |       0.02 |         2 | 2014-04-08   |
| 1232 | [fightmaxime at protonmail dot com](https://metrics.torproject.org/rs.html#details/B6E40167BE842F279B11B2A0F594718387AA75E5)                                          |            0.016 |      0    |       0.02 |         1 | 2020-03-31   |
| 1233 | [xanxiab at noxanxoan dot com tor-relay.co](https://metrics.torproject.org/rs.html#details/B778066DAD76D6EEA7D0D31A82F168A84C0D7955)                                  |            0.016 |      0    |       0.02 |         1 | 2020-06-12   |
| 1234 | [lper19888@gmail.com](https://metrics.torproject.org/rs.html#details/BDEC565B8B5E3DCCB57E4E7C4C245EDA717D2087)                                                        |            0.016 |      0    |       0.02 |         1 | 2020-03-07   |
| 1235 | [t@3.vu](https://metrics.torproject.org/rs.html#details/BFBAB22CA31F6C2344C69E05DAE55B1782AD7A36)                                                                     |            0.016 |      0    |       0.02 |         1 | 2020-02-07   |
| 1236 | [iron](https://metrics.torproject.org/rs.html#details/C000D47186ADC5C2B9D90A2FFAC7551C5A5F8D0A)                                                                       |            0.016 |      0.05 |       0    |         1 | 2020-04-20   |
| 1237 | [visualbasic033@gmail.com](https://metrics.torproject.org/rs.html#details/CB4EBE9C475A60A5F2CDA92C83CE093BD945D940)                                                   |            0.016 |      0    |       0    |         1 | 2015-12-04   |
| 1238 | [CCD65B84](https://metrics.torproject.org/rs.html#search/family:CCD65B846B9D5CB275BD18D67F47C7F62C116F79)                                                             |            0.016 |      0    |       0.02 |         2 | 2018-11-09   |
| 1239 | [jjaytehjetplane@gmail.com](https://metrics.torproject.org/rs.html#details/D2F4DAC5918BB082A5CFAC5275B29FAC9B399B2B)                                                  |            0.016 |      0    |       0.02 |         1 | 2017-08-08   |
| 1240 | [D5607ADD](https://metrics.torproject.org/rs.html#details/D5607ADD1FDDB657482E23F09AB173310C802590)                                                                   |            0.016 |      0    |       0.02 |         1 | 2015-09-17   |
| 1241 | [E03E581A](https://metrics.torproject.org/rs.html#details/E03E581AA42A211F69DC63608B1980F10AE52C26)                                                                   |            0.016 |      0    |       0.02 |         1 | 2018-02-04   |
| 1242 | [E9A90B9F](https://metrics.torproject.org/rs.html#details/E9A90B9FF0574410695BA5F5C8354368221A7114)                                                                   |            0.016 |      0    |       0.02 |         1 | 2018-12-08   |
| 1243 | [F29A5D7E](https://metrics.torproject.org/rs.html#details/F29A5D7E317934CDFFFA3DD9B26AC9AB48CB1C6C)                                                                   |            0.016 |      0    |       0.02 |         1 | 2020-07-29   |
| 1244 | [&lt;1ea7deadbeef AT posteo dot net&gt;](https://metrics.torproject.org/rs.html#details/F475E5987E44A2B7B143A2BEE3F8128EEFD7E5A3)                                     |            0.016 |      0    |       0.02 |         1 | 2018-09-28   |
| 1245 | [014BD096](https://metrics.torproject.org/rs.html#details/014BD09636373B78CC28BA70E36C7190E3DE236A)                                                                   |            0.015 |      0    |       0    |         1 | 2019-07-22   |
| 1246 | [0A178D30](https://metrics.torproject.org/rs.html#details/0A178D302936F209AF3DA77CCC4E3C4D5DBE11E9)                                                                   |            0.015 |      0    |       0.02 |         1 | 2019-04-29   |
| 1247 | [Philipp &lt;tor AT streikt D0T net&gt;](https://metrics.torproject.org/rs.html#details/0C93559D6D7E95B41561424345B0B176FBE66F00)                                     |            0.015 |      0    |       0.02 |         1 | 2017-11-03   |
| 1248 | [kladuin at protonmail dot com](https://metrics.torproject.org/rs.html#details/0E8DB49D5BF5FCAFFA433A78FEE34179419D1C4E)                                              |            0.015 |      0    |       0.02 |         1 | 2019-12-28   |
| 1249 | [0FFA1246](https://metrics.torproject.org/rs.html#details/0FFA1246DD0C441D9A43A54C9D1BD46BB528A063)                                                                   |            0.015 |      0    |       0    |         1 | 2020-05-10   |
| 1250 | [138B95F9](https://metrics.torproject.org/rs.html#details/138B95F9A10E8BEBA6B142ADAC7331765C61ACE4)                                                                   |            0.015 |      0    |       0.02 |         1 | 2018-09-05   |
| 1251 | [volker &lt;volker.mink AT protonmail.ch&gt;](https://metrics.torproject.org/rs.html#search/family:1A2EEE464A7DA500A869ABA7A5BC772CFE198534)                          |            0.015 |      0.05 |       0    |         2 | 2019-03-07   |
| 1252 | [1D54F7CC](https://metrics.torproject.org/rs.html#details/1D54F7CCB7C7A185EE8AA5616C079DD923EB57F2)                                                                   |            0.015 |      0    |       0.02 |         1 | 2018-09-09   |
| 1253 | [0xA90AFCF81406CC27 &lt;sjk@dredel.com&gt;](https://metrics.torproject.org/rs.html#details/2037A6568C5771A5D8FF5C64FC1819247E6FEE7B)                                  |            0.015 |      0.05 |       0    |         1 | 2018-08-04   |
| 1254 | [Random Person &lt;nobody AT example dot com&gt;](https://metrics.torproject.org/rs.html#details/20465F3DFD77F7AC95F31A4D35726FB6D82F0E67)                            |            0.015 |      0    |       0.02 |         1 | 2017-02-03   |
| 1255 | [k0nsl &lt;tor-operator@k0nsl.org&gt;](https://metrics.torproject.org/rs.html#details/239E373B108E04912B3AF8C32E99FF0EDC492A68)                                       |            0.015 |      0.05 |       0    |         1 | 2019-12-14   |
| 1256 | [23A2D8DD](https://metrics.torproject.org/rs.html#details/23A2D8DDF761F35CC63BDF65E604B76A7E2F6971)                                                                   |            0.015 |      0    |       0.02 |         1 | 2019-11-23   |
| 1257 | [Remove underscores change capitals: tor admin AT s](https://metrics.torproject.org/rs.html#details/25A84EFEE28E443EB9D3130138243452586F8BAA)                         |            0.015 |      0    |       0.02 |         1 | 2017-01-28   |
| 1258 | [25B694EA](https://metrics.torproject.org/rs.html#details/25B694EA95F825F156C5DAE5607B3375E86C0C4E)                                                                   |            0.015 |      0    |       0.02 |         1 | 2016-05-03   |
| 1259 | [Sal &lt;admin AT salazzo DOT net&gt;](https://metrics.torproject.org/rs.html#details/2BCDDD2006A6000B8D5F6D63C7D6D200E43F8B1B)                                       |            0.015 |      0    |       0.02 |         1 | 2019-01-24   |
| 1260 | [&lt;mknoszlig AT zeroton dot in&gt;](https://metrics.torproject.org/rs.html#details/2FD0BA57A34DC2792AF470398F72F37F9E51DC2D)                                        |            0.015 |      0    |       0.02 |         1 | 2014-04-08   |
| 1261 | [30C0B4DE](https://metrics.torproject.org/rs.html#details/30C0B4DE58CFBB350485B326A0D67352E0138CCF)                                                                   |            0.015 |      0    |       0.02 |         1 | 2016-12-18   |
| 1262 | [3262670C](https://metrics.torproject.org/rs.html#details/3262670CB066348F6A766822EEC4AB93619E5A11)                                                                   |            0.015 |      0    |       0    |         1 | 2020-04-30   |
| 1263 | [34B84952](https://metrics.torproject.org/rs.html#details/34B84952AFCDB00444F27805A5EDEF5F7DD549C7)                                                                   |            0.015 |      0    |       0.02 |         1 | 2016-08-15   |
| 1264 | [35514049](https://metrics.torproject.org/rs.html#details/355140498339A8FEBBA1453E93A3FAE8F7973968)                                                                   |            0.015 |      0    |       0.02 |         1 | 2019-11-26   |
| 1265 | [3B5C6ED2](https://metrics.torproject.org/rs.html#details/3B5C6ED2C1DECEB32BF1AD9B7B272F4CE9CE0656)                                                                   |            0.015 |      0    |       0.02 |         1 | 2018-01-24   |
| 1266 | [3CEA56B8](https://metrics.torproject.org/rs.html#details/3CEA56B817455E13C4B063E7D3E7726C286F7C9B)                                                                   |            0.015 |      0    |       0.02 |         1 | 2016-09-16   |
| 1267 | [Tobias Fonsmark &lt;tor@semaphor.dk&gt;](https://metrics.torproject.org/rs.html#details/3FE1AA163445DC0E0677B5227F507907C4872A30)                                    |            0.015 |      0    |       0    |         1 | 2019-11-27   |
| 1268 | [3FFDFB5A](https://metrics.torproject.org/rs.html#details/3FFDFB5A9A278C7C303745606DB5B68FC5B9FADF)                                                                   |            0.015 |      0    |       0.02 |         1 | 2019-03-20   |
| 1269 | [4150EDB3](https://metrics.torproject.org/rs.html#details/4150EDB300692A1839962D71E28E0746892A5FFB)                                                                   |            0.015 |      0    |       0.02 |         1 | 2020-07-24   |
| 1270 | [madnight madnight &lt;danon@gmx.de&gt;](https://metrics.torproject.org/rs.html#details/42E440E573CAA2C309041B448BDB8FC5D066E535)                                     |            0.015 |      0    |       0.02 |         1 | 2020-06-07   |
| 1271 | [4E91B665](https://metrics.torproject.org/rs.html#details/4E91B66561EE01B1653E1803FE53B5C400D967DB)                                                                   |            0.015 |      0    |       0.02 |         1 | 2015-09-11   |
| 1272 | [Anon mattsaviour@tutanota.com](https://metrics.torproject.org/rs.html#details/4F7A7A61D20234B2C453FB8CD3014C100F1E0DE3)                                              |            0.015 |      0.05 |       0    |         1 | 2020-03-02   |
| 1273 | [dexter@d3xt3r01.tk](https://metrics.torproject.org/rs.html#details/506763994792208999529D03C016774C814386A8)                                                         |            0.015 |      0    |       0.02 |         1 | 2014-09-19   |
| 1274 | [torpids AT yahoo dot com - 1JYHfzVFVD7n2Sezz3DEHDF](https://metrics.torproject.org/rs.html#details/510176C07005D47B23E6796F02C93241A29AA0E9)                         |            0.015 |      0    |       0.02 |         1 | 2015-08-29   |
| 1275 | [51800AF3](https://metrics.torproject.org/rs.html#details/51800AF38B30ED1454DD74CB412BADCED5F60593)                                                                   |            0.015 |      0    |       0.02 |         1 | 2017-01-07   |
| 1276 | [546E66AD](https://metrics.torproject.org/rs.html#details/546E66AD3F358F5632C691A50E34CA614A6ADA32)                                                                   |            0.015 |      0.05 |       0    |         1 | 2020-08-06   |
| 1277 | [0xC443B5A5AD274F30 Simon Fischer &lt;tor AT simonfisc](https://metrics.torproject.org/rs.html#details/56784608242CB15B70ED6CBB8F40EEA3B62AF69E)                      |            0.015 |      0    |       0.02 |         1 | 2016-12-31   |
| 1278 | [Random Person &lt;determine AT riseup dot net&gt;](https://metrics.torproject.org/rs.html#details/58224E8E5344ECB0E6FFBB470C53F2C71DBE6341)                          |            0.015 |      0.05 |       0    |         1 | 2019-11-05   |
| 1279 | [donald92741@protonmail.com](https://metrics.torproject.org/rs.html#details/5E2134CE8D3A3B7AA5E597B8EFE3E659B03C02B3)                                                 |            0.015 |      0    |       0.02 |         1 | 2018-10-20   |
| 1280 | [6315278A](https://metrics.torproject.org/rs.html#search/family:6315278A91710062D90B288199EFA06E4AAA9E8F)                                                             |            0.015 |      0    |       0.02 |         2 | 2013-11-07   |
| 1281 | [tor at rbuc dot de](https://metrics.torproject.org/rs.html#details/6A365870758A1E3E7A9EE0E82BCC0D6226A9EAAA)                                                         |            0.015 |      0    |       0    |         1 | 2020-01-04   |
| 1282 | [6CC25EF1](https://metrics.torproject.org/rs.html#details/6CC25EF1B7BA8E6AB5B4F62B3D7D1B6C2E5DB6F3)                                                                   |            0.015 |      0    |       0.02 |         1 | 2020-04-09   |
| 1283 | [6F0E91FA](https://metrics.torproject.org/rs.html#details/6F0E91FAD58E002BC700C2EC693C7F269973533E)                                                                   |            0.015 |      0    |       0    |         1 | 2020-07-07   |
| 1284 | [basilexit @ airmail.cc or holla at a koala](https://metrics.torproject.org/rs.html#details/7088D485934E8A403B81531F8C90BDC75FA43C98)                                 |            0.015 |      0.05 |       0    |         1 | 2016-10-23   |
| 1285 | [782936C1](https://metrics.torproject.org/rs.html#details/782936C16BF876F5F59A1793ADB1C5B251DB65E7)                                                                   |            0.015 |      0    |       0.02 |         1 | 2016-09-16   |
| 1286 | [maddy schultz @ keemail.me](https://metrics.torproject.org/rs.html#details/82405679E1F2AE258FBA8DD45BB2A52735EEED91)                                                 |            0.015 |      0    |       0.02 |         1 | 2020-04-02   |
| 1287 | [matej@divecky.com](https://metrics.torproject.org/rs.html#details/84126C0974B2169B886B71B0531BEEBE2231F0B7)                                                          |            0.015 |      0    |       0.02 |         1 | 2020-06-22   |
| 1288 | [900777F6](https://metrics.torproject.org/rs.html#details/900777F6E1307328D5C39826356925FDECB0790B)                                                                   |            0.015 |      0    |       0.02 |         1 | 2020-04-06   |
| 1289 | [96DAFDCE](https://metrics.torproject.org/rs.html#details/96DAFDCE92BA94E4CC95F8314AE48E272A702FDC)                                                                   |            0.015 |      0    |       0.02 |         1 | 2014-07-07   |
| 1290 | [Kevin &lt;tor AT kberanek dot com&gt;](https://metrics.torproject.org/rs.html#details/98A1D0BCCC5D45C7E096D7634C8ED3FFBF1908C6)                                      |            0.015 |      0    |       0    |         1 | 2016-12-21   |
| 1291 | [99AC7766](https://metrics.torproject.org/rs.html#details/99AC77667D8D606251B749DFDA473B2C781F78D0)                                                                   |            0.015 |      0    |       0.02 |         1 | 2015-11-13   |
| 1292 | [9F466C50](https://metrics.torproject.org/rs.html#details/9F466C50FE96B145D8A18BDB9260C5D9C2EA8AA8)                                                                   |            0.015 |      0    |       0    |         1 | 2020-07-04   |
| 1293 | [A312CC0B](https://metrics.torproject.org/rs.html#details/A312CC0B069677E50F8A1FAE5F579E3F294D9BEC)                                                                   |            0.015 |      0    |       0    |         1 | 2020-07-08   |
| 1294 | [tor at nx42 dot de](https://metrics.torproject.org/rs.html#details/AA26B97B6CA757BF63328EE96705120609CF4AAD)                                                         |            0.015 |      0    |       0.02 |         1 | 2019-01-06   |
| 1295 | [tor at wittmann minus it minus security dot](https://metrics.torproject.org/rs.html#details/AC6A78BAE7BBCAC798C7AD17460147214F9EA0CD)                                |            0.015 |      0    |       0.02 |         1 | 2019-01-01   |
| 1296 | [pmayolove@juno.com](https://metrics.torproject.org/rs.html#details/B15C0071EAF508AAEE29DB9D07607C84AA2DDEB3)                                                         |            0.015 |      0    |       0.02 |         1 | 2017-08-24   |
| 1297 | [nickel](https://metrics.torproject.org/rs.html#details/B672B7BB5E5B9F778330738A4684DF946B938A3F)                                                                     |            0.015 |      0.05 |       0    |         1 | 2020-04-20   |
| 1298 | [B79B3DFF](https://metrics.torproject.org/rs.html#details/B79B3DFF16815702D224C54C16174694F70FBB46)                                                                   |            0.015 |      0    |       0    |         1 | 2020-05-01   |
| 1299 | [B8BF2948](https://metrics.torproject.org/rs.html#details/B8BF2948E7830586F64EE92CCEABFB202E2FBF85)                                                                   |            0.015 |      0    |       0.02 |         1 | 2019-10-25   |
| 1300 | [BA1628E3](https://metrics.torproject.org/rs.html#details/BA1628E321EDC35A75BD92ACB57D202DA03F120B)                                                                   |            0.015 |      0    |       0    |         1 | 2020-06-22   |
| 1301 | [BB004C7F](https://metrics.torproject.org/rs.html#details/BB004C7F4C5C9FAE5E001864537F89388444F572)                                                                   |            0.015 |      0    |       0.02 |         1 | 2019-01-11   |
| 1302 | [BE6CF268](https://metrics.torproject.org/rs.html#details/BE6CF26814BD1F35B76FE576702DBA9627EE8237)                                                                   |            0.015 |      0    |       0.02 |         1 | 2015-10-22   |
| 1303 | [C69BE3F0](https://metrics.torproject.org/rs.html#details/C69BE3F0326A7328556501BE237408F32748247D)                                                                   |            0.015 |      0    |       0.02 |         1 | 2020-07-22   |
| 1304 | [CA0E72B3](https://metrics.torproject.org/rs.html#details/CA0E72B38D97D7CC687F88DAE136A60509CFB6DE)                                                                   |            0.015 |      0.05 |       0    |         1 | 2019-06-26   |
| 1305 | [CB1061AA](https://metrics.torproject.org/rs.html#details/CB1061AAD5B5995A3E3460D411D4AF24614AF01C)                                                                   |            0.015 |      0    |       0.02 |         1 | 2020-07-23   |
| 1306 | [admin &lt;at&gt; bin &lt;dot&gt; ovh bitcoin donations t](https://metrics.torproject.org/rs.html#search/family:CB7DB681576DCB437E23B4589B216F13AB6A5503)             |            0.015 |      0.05 |       0    |         2 | 2016-09-02   |
| 1307 | [CCF28BC8](https://metrics.torproject.org/rs.html#details/CCF28BC8FB26C8C172DEE741702056914D2849BD)                                                                   |            0.015 |      0    |       0.02 |         1 | 2019-01-10   |
| 1308 | [2048R/B640BF1A Tor Relay &lt;tor AT sec dot nl&gt;](https://metrics.torproject.org/rs.html#details/D7DB8E82604F806766FC3F80213CF719A0481D0B)                         |            0.015 |      0    |       0.02 |         1 | 2014-04-13   |
| 1309 | [DA60C85D](https://metrics.torproject.org/rs.html#details/DA60C85D526374C1DC8A8796E93F12F7CA3019F2)                                                                   |            0.015 |      0    |       0.02 |         1 | 2018-10-29   |
| 1310 | [EE4B332F](https://metrics.torproject.org/rs.html#details/EE4B332F13C3F8CCD9DCD86961B47F4AECA02CE6)                                                                   |            0.015 |      0    |       0    |         1 | 2020-07-05   |
| 1311 | [0x95E111B2 Mariusz Klinikowski &lt;mariusz.klinikowsk](https://metrics.torproject.org/rs.html#details/EECADDB0CBB5725D4DDFE3D7E734E8261E0E9D09)                      |            0.015 |      0    |       0.02 |         1 | 2019-10-26   |
| 1312 | [bc1q7g4vqm42khf4v7au6wwq2h5k6xxxq7zghs2ht4 stomach](https://metrics.torproject.org/rs.html#details/EEFFC0D532AB63BB3E9CAEADA822971F6D3AE8D6)                         |            0.015 |      0    |       0.02 |         1 | 2020-06-12   |
| 1313 | [anonymare@bahnhof.se](https://metrics.torproject.org/rs.html#details/F27B47CED45724CBCE3B42926DD52F2091F395AC)                                                       |            0.015 |      0.05 |       0    |         1 | 2018-02-07   |
| 1314 | [loraxcontact@mailbox.org 7909 9751 37C8 768E 9708](https://metrics.torproject.org/rs.html#details/02A29A2F958211F9BB5821153296EFFED900ECC6)                          |            0.014 |      0    |       0.02 |         1 | 2019-12-06   |
| 1315 | [torrelay@faultyco.de](https://metrics.torproject.org/rs.html#details/0A58B05D403A2663EB56124F8C7AAB0CABFAA115)                                                       |            0.014 |      0    |       0.02 |         1 | 2020-04-17   |
| 1316 | [0D35A457](https://metrics.torproject.org/rs.html#details/0D35A457BE0304F2656310C90C774695A3773A6B)                                                                   |            0.014 |      0.04 |       0    |         1 | 2020-02-06   |
| 1317 | [1322D90E](https://metrics.torproject.org/rs.html#details/1322D90EA6EDA85B3A8566F2C04F2D8C5C7C1EF1)                                                                   |            0.014 |      0    |       0.02 |         1 | 2015-07-22   |
| 1318 | [16AE2704](https://metrics.torproject.org/rs.html#details/16AE2704B794C6C0013C7E47AF11DCABA808A0B9)                                                                   |            0.014 |      0    |       0.02 |         1 | 2019-03-23   |
| 1319 | [tor-relay-001@schulte.org](https://metrics.torproject.org/rs.html#details/1841CB960128806151B61FC6D87AFBE9A98B99D7)                                                  |            0.014 |      0    |       0.02 |         1 | 2015-12-31   |
| 1320 | [1852D84B](https://metrics.torproject.org/rs.html#details/1852D84B0341845F2BDC2CCBC673E9D42307A111)                                                                   |            0.014 |      0    |       0.02 |         1 | 2018-04-11   |
| 1321 | [1AFF59F9](https://metrics.torproject.org/rs.html#details/1AFF59F9B2579D78284EF7173A183F34086D4B56)                                                                   |            0.014 |      0    |       0.02 |         1 | 2018-09-24   |
| 1322 | [1B112696](https://metrics.torproject.org/rs.html#details/1B112696C3B42410E7F141B49B5C6259EF867EF2)                                                                   |            0.014 |      0    |       0    |         1 | 2020-07-02   |
| 1323 | [1DBC55FA](https://metrics.torproject.org/rs.html#details/1DBC55FA202FCD00B844D6E4FA7862A110714985)                                                                   |            0.014 |      0    |       0    |         1 | 2020-04-01   |
| 1324 | [D5BACC8B1873BE240578026A278C70D69142FC5B Torexit W](https://metrics.torproject.org/rs.html#details/1ECD73B936CB6E6B3CD647CC204F108D9DF2C9F7)                         |            0.014 |      0    |       0.02 |         1 | 2013-07-10   |
| 1325 | [2096BCFE](https://metrics.torproject.org/rs.html#details/2096BCFEBB95A1134F39FCF8CEB076FF41A2B48B)                                                                   |            0.014 |      0    |       0.02 |         1 | 2017-11-28   |
| 1326 | [fallout](https://metrics.torproject.org/rs.html#details/2114FA9A053A4290CC76CB3C20117AF1B24415BF)                                                                    |            0.014 |      0.05 |       0    |         1 | 2020-04-07   |
| 1327 | [&lt;tamanegi AT rainside dot sk&gt;](https://metrics.torproject.org/rs.html#details/21310F48066A4CAADEB2BFD324F0B38F8E1448D6)                                        |            0.014 |      0    |       0    |         1 | 2016-06-17   |
| 1328 | [27D3ED72](https://metrics.torproject.org/rs.html#details/27D3ED72F263E665C13DA7CCF276FEDF1E495E19)                                                                   |            0.014 |      0    |       0    |         1 | 2020-07-04   |
| 1329 | [2935E0F0](https://metrics.torproject.org/rs.html#details/2935E0F03B71BE44F6F265FEF976E810BAAD6F4E)                                                                   |            0.014 |      0    |       0    |         1 | 2019-11-22   |
| 1330 | [31135CFF](https://metrics.torproject.org/rs.html#details/31135CFF07050C0048508FC9D736818E848F8687)                                                                   |            0.014 |      0    |       0    |         1 | 2020-07-03   |
| 1331 | [MatrixOperator &lt;matrixoperator AT protonmail dot c](https://metrics.torproject.org/rs.html#details/3275589A15682CB7D3701B71999336674D86EE3E)                      |            0.014 |      0.04 |       0    |         1 | 2020-02-08   |
| 1332 | [3548129E](https://metrics.torproject.org/rs.html#details/3548129E3B54BF4B833BBCBAE214DB05CA46AE6B)                                                                   |            0.014 |      0    |       0.02 |         1 | 2019-11-30   |
| 1333 | [aditaa@pm.me - btc 3JXBE2tDpxR1whEcY3MU9RtijyR6xJT](https://metrics.torproject.org/rs.html#details/36EFABA1FFE1D0246B36C141F9226F4F09B8951C)                         |            0.014 |      0    |       0.02 |         1 | 2019-04-08   |
| 1334 | [Markus Peuhkuri &lt;markus.peuhkuri@aalto.fi&gt;](https://metrics.torproject.org/rs.html#details/41D2F6D866E7638138CF9F282A280F96BD020D25)                           |            0.014 |      0    |       0.02 |         1 | 2015-01-19   |
| 1335 | [43DF5979](https://metrics.torproject.org/rs.html#details/43DF5979E1FD37986EFAEB6B9DDCAE42D3FF81D7)                                                                   |            0.014 |      0    |       0    |         1 | 2019-10-12   |
| 1336 | [riinagalvani at protonmail dot com](https://metrics.torproject.org/rs.html#details/4456DEA64AC6ABED4C500D681365AB135DD6AEFD)                                         |            0.014 |      0.04 |       0    |         1 | 2020-07-22   |
| 1337 | [ttallink@googlemail.com](https://metrics.torproject.org/rs.html#details/47E1157F7DA6DF80EC00D745D73ACD7B0A380BCF)                                                    |            0.014 |      0    |       0.02 |         1 | 2019-09-08   |
| 1338 | [49877399](https://metrics.torproject.org/rs.html#details/49877399DD0E82FE123148361038823368F77193)                                                                   |            0.014 |      0    |       0.02 |         1 | 2018-03-04   |
| 1339 | [49CA9262](https://metrics.torproject.org/rs.html#details/49CA9262801E9DC9B414A143A58A68255149367A)                                                                   |            0.014 |      0    |       0.02 |         1 | 2019-12-31   |
| 1340 | [4CF05E75](https://metrics.torproject.org/rs.html#search/family:4CF05E75DD23A18E6E5681C4011E5254784A3EE0)                                                             |            0.014 |      0.04 |       0    |         2 | 2018-01-04   |
| 1341 | [starlight dot YYYYqQ at binnacle dot cx](https://metrics.torproject.org/rs.html#details/4F0DB7E687FC7C0AE55C8F243DA8B0EB27FBF1F2)                                    |            0.014 |      0    |       0.02 |         1 | 2014-06-14   |
| 1342 | [538087BE](https://metrics.torproject.org/rs.html#details/538087BEAAE5169448E030A4D059E866BB4C3493)                                                                   |            0.014 |      0.04 |       0    |         1 | 2019-10-18   |
| 1343 | [sonic relay at protonmail dot com](https://metrics.torproject.org/rs.html#details/6610C977840BA8B53C18DF9DCB27B1123AF86A37)                                          |            0.014 |      0    |       0.02 |         1 | 2019-12-07   |
| 1344 | [tor-contact@butts.ovh](https://metrics.torproject.org/rs.html#details/6974910EF995EF8B45D46285FD15FCF84347BB84)                                                      |            0.014 |      0    |       0.02 |         1 | 2017-11-16   |
| 1345 | [6A1B4F8A](https://metrics.torproject.org/rs.html#details/6A1B4F8A87E327F4E115A385206C0880DB051B3B)                                                                   |            0.014 |      0    |       0.02 |         1 | 2020-05-13   |
| 1346 | [dash &gt;david dot sheely at tuta dot io&lt;](https://metrics.torproject.org/rs.html#search/family:6EDBE20897BD02A2D8D654D0440FDB2A3B0643E1)                         |            0.014 |      0    |       0.02 |         2 | 2020-03-17   |
| 1347 | [6FDA24CF](https://metrics.torproject.org/rs.html#details/6FDA24CFDD2512EEE2333D586DE3EA3CAB0ADB7F)                                                                   |            0.014 |      0.04 |       0    |         1 | 2020-05-22   |
| 1348 | [70F09E98](https://metrics.torproject.org/rs.html#details/70F09E981D6D4A34A35F248F0C873CBA356A0612)                                                                   |            0.014 |      0    |       0.02 |         1 | 2017-06-05   |
| 1349 | [73791109](https://metrics.torproject.org/rs.html#details/73791109F595BA4A78167F6350EEC0057F7A50D9)                                                                   |            0.014 |      0    |       0    |         1 | 2020-06-28   |
| 1350 | [73CC6521](https://metrics.torproject.org/rs.html#details/73CC65219889443C06E06A0B6D427B1FE1C37379)                                                                   |            0.014 |      0    |       0.02 |         1 | 2015-09-17   |
| 1351 | [75784DD2](https://metrics.torproject.org/rs.html#details/75784DD2BCB70CE13CEC93CFE24CD69C66E2C67B)                                                                   |            0.014 |      0    |       0.02 |         1 | 2017-01-19   |
| 1352 | [tor at alo dot is tor-relay.co](https://metrics.torproject.org/rs.html#details/7A1E55BF6301C8F9FF9677F6B07D04C0A6327667)                                             |            0.014 |      0    |       0.02 |         1 | 2019-07-28   |
| 1353 | [7B87EF57](https://metrics.torproject.org/rs.html#details/7B87EF57DAC332D7016C04AE82063E93B5162C44)                                                                   |            0.014 |      0.04 |       0    |         1 | 2019-12-05   |
| 1354 | [7D426185](https://metrics.torproject.org/rs.html#details/7D4261853A5CC5E96C8886391919FF2DA02A5801)                                                                   |            0.014 |      0    |       0.02 |         1 | 2020-07-11   |
| 1355 | [Nuno tugaonion@tuta.io](https://metrics.torproject.org/rs.html#details/8111FEB45EF2950EB8F84BFD8FF070AB07AEE9DD)                                                     |            0.014 |      0    |       0.02 |         1 | 2020-02-10   |
| 1356 | [8657358D](https://metrics.torproject.org/rs.html#details/8657358DD3076664A5989028CEB1A92F5F93C02A)                                                                   |            0.014 |      0    |       0.02 |         1 | 2017-09-06   |
| 1357 | [8FA2185C](https://metrics.torproject.org/rs.html#details/8FA2185CFF631773E20F0E2F9A743E16E12DCBB1)                                                                   |            0.014 |      0    |       0    |         1 | 2020-08-07   |
| 1358 | [909656EA](https://metrics.torproject.org/rs.html#details/909656EA1BC5F45F6BA69FC6D11A8563D74F90B8)                                                                   |            0.014 |      0    |       0.02 |         1 | 2020-07-21   |
| 1359 | [Marc Landolt jun. LAN-/FAIL-/BRAINDEF &lt;2009 AT mar](https://metrics.torproject.org/rs.html#details/91258F0EDB1FF92CF76E6DC38BFE98055A74DBF8)                      |            0.014 |      0    |       0.02 |         1 | 2019-09-19   |
| 1360 | [950134F4](https://metrics.torproject.org/rs.html#details/950134F4ABA3291EEE4E7A2F26546DB7070776A4)                                                                   |            0.014 |      0    |       0.02 |         1 | 2018-05-14   |
| 1361 | [tor at dourneau dot me](https://metrics.torproject.org/rs.html#details/A0F39D32028CEC7F35419E9570401DE15B1B4564)                                                     |            0.014 |      0    |       0.02 |         1 | 2016-03-16   |
| 1362 | [Admin &lt;admin AT tor-relay dot io&gt;](https://metrics.torproject.org/rs.html#details/A13281DBD8F8E484E95DD273B3EE7FC14C1B0A7A)                                    |            0.014 |      0    |       0.02 |         1 | 2016-08-04   |
| 1363 | [tor at pbb dot lc](https://metrics.torproject.org/rs.html#details/A2C6C931D8627C6605288970889DDB88C7BA2142)                                                          |            0.014 |      0    |       0.02 |         1 | 2020-06-19   |
| 1364 | [2qwas3a at gmail dot com tor-relay.co](https://metrics.torproject.org/rs.html#details/A372C1CAA41C091A98EE35E51E36DCBB981000AB)                                      |            0.014 |      0.04 |       0    |         1 | 2020-07-26   |
| 1365 | [A4CC83BC](https://metrics.torproject.org/rs.html#details/A4CC83BC0259D1E8BA05667DF7FF5648F725CF3E)                                                                   |            0.014 |      0    |       0    |         1 | 2020-07-10   |
| 1366 | [A56A0120](https://metrics.torproject.org/rs.html#details/A56A0120A21557832000D5C68FCD7DE08E82A3B0)                                                                   |            0.014 |      0    |       0.02 |         1 | 2019-03-20   |
| 1367 | [dgoulet &lt;dgoulet AT torproject DOT org &gt; - 1LBTDKw](https://metrics.torproject.org/rs.html#details/A69221A7EC7498D2F88A0FB795261013FA36CAAE)                   |            0.014 |      0    |       0.02 |         1 | 2014-05-07   |
| 1368 | [copper](https://metrics.torproject.org/rs.html#details/B1041423779CDBE805CACBD8E72EFA37AA47BBAD)                                                                     |            0.014 |      0.04 |       0    |         1 | 2020-04-20   |
| 1369 | [Stephen Smith &lt;stephen304@gmail.com&gt;](https://metrics.torproject.org/rs.html#details/B5053ABFF845C96B1DD8F45DCF32E6BE1E63F127)                                 |            0.014 |      0    |       0.02 |         1 | 2018-04-27   |
| 1370 | [B6F03C34](https://metrics.torproject.org/rs.html#details/B6F03C344830AD50DF28EA7848C216801CF9AD8D)                                                                   |            0.014 |      0    |       0.02 |         1 | 2018-01-16   |
| 1371 | [B7826E5C](https://metrics.torproject.org/rs.html#details/B7826E5C7C22D696E42AE96B696F66C5E9D86984)                                                                   |            0.014 |      0    |       0.02 |         1 | 2020-07-25   |
| 1372 | [Ministry of International Relaytions &lt;int dot rela](https://metrics.torproject.org/rs.html#details/BB12ECF3DCF12B187CFD735DAC68F98A3E13DEE2)                      |            0.014 |      0    |       0.02 |         1 | 2020-05-30   |
| 1373 | [BBD8F4DF](https://metrics.torproject.org/rs.html#details/BBD8F4DF8FF5C69A6A989DB8C1EE2CA7ADFE0755)                                                                   |            0.014 |      0    |       0.02 |         1 | 2018-11-26   |
| 1374 | [0xDEAD NoSp@m tor-relay @T peptan3t uselesstraile](https://metrics.torproject.org/rs.html#details/BCD2F039FC8B8F1D33742E72E15D710F777F664E)                          |            0.014 |      0    |       0.02 |         1 | 2020-03-04   |
| 1375 | [C0E6A667](https://metrics.torproject.org/rs.html#details/C0E6A667064385B9CB5A685CEB06B85EDDA6AA00)                                                                   |            0.014 |      0    |       0.02 |         1 | 2019-11-22   |
| 1376 | [C1B8C688](https://metrics.torproject.org/rs.html#details/C1B8C6887867CED2564454058F9082311FAF1AC7)                                                                   |            0.014 |      0    |       0.02 |         1 | 2017-10-27   |
| 1377 | [C2481FAA](https://metrics.torproject.org/rs.html#details/C2481FAAA5508F6C2A64873972281220E9778476)                                                                   |            0.014 |      0    |       0.02 |         1 | 2020-06-22   |
| 1378 | [C25E583A](https://metrics.torproject.org/rs.html#details/C25E583A63191C6CEF57F503F38A4C6815321A85)                                                                   |            0.014 |      0    |       0    |         1 | 2020-06-27   |
| 1379 | [D0DB858D](https://metrics.torproject.org/rs.html#details/D0DB858DC3CCE98F9F28FA8689C4FFA7B9882AF1)                                                                   |            0.014 |      0    |       0    |         1 | 2020-07-06   |
| 1380 | [justshutup@protonmail.com](https://metrics.torproject.org/rs.html#details/D3115C209E320F3F77C83538683C47410A10D227)                                                  |            0.014 |      0    |       0.02 |         1 | 2020-02-24   |
| 1381 | [tor contact &lt;tor0218@linuxw.info&gt;](https://metrics.torproject.org/rs.html#details/E11FC7C83F417808A4CDD84A5ABFC112844C477A)                                    |            0.014 |      0    |       0.02 |         1 | 2020-06-21   |
| 1382 | [E46777C6](https://metrics.torproject.org/rs.html#details/E46777C6EFB6036190EFAAD9B13EE9D0E75C5510)                                                                   |            0.014 |      0    |       0    |         1 | 2019-05-31   |
| 1383 | [MatrixOperator &lt;matrixoperator AT protonmail dot c](https://metrics.torproject.org/rs.html#details/EA1AF22E93AC7B8A00DB3197913EE5CAE11FC2F7)                      |            0.014 |      0.04 |       0    |         1 | 2020-02-08   |
| 1384 | [F2899981](https://metrics.torproject.org/rs.html#details/F2899981E3A601A7B2DDC7DDE02C248069704D9F)                                                                   |            0.014 |      0    |       0.02 |         1 | 2019-11-18   |
| 1385 | [0x48DFF574 Patrick Pankotsch &lt;patrick-pankotsch@t-](https://metrics.torproject.org/rs.html#details/F37997F89070869A34C456A2F54577A3276AACB2)                      |            0.014 |      0    |       0    |         1 | 2019-04-30   |
| 1386 | [tor-operator@your-emailaddress-domain](https://metrics.torproject.org/rs.html#details/F6691E3EB7CAB3C876AAA885E6801B63DC998C39)                                      |            0.014 |      0    |       0.02 |         1 | 2018-10-29   |
| 1387 | [F8F11BD6](https://metrics.torproject.org/rs.html#details/F8F11BD639372EDA0101167D814CD8F235B494B3)                                                                   |            0.014 |      0    |       0    |         1 | 2020-06-26   |
| 1388 | [MatrixOperator &lt;matrixoperator AT protonmail dot c](https://metrics.torproject.org/rs.html#details/F9E97AAC7ACB6B48CA17FA55554FD6CB1651ED33)                      |            0.014 |      0.04 |       0    |         1 | 2020-02-08   |
| 1389 | [owlnetwork2@secmail.pro](https://metrics.torproject.org/rs.html#details/FB13B3060516E4C50E5E178227A036977103E4AD)                                                    |            0.014 |      0    |       0.02 |         1 | 2020-07-09   |
| 1390 | [draco59@protonmail.com](https://metrics.torproject.org/rs.html#details/FB43FC51B932F6A8FD75AFBBB45FDD19955889DB)                                                     |            0.014 |      0    |       0.02 |         1 | 2020-06-18   |
| 1391 | [Alexander Zaitsev &lt;zamazan4ik@tut.by&gt;](https://metrics.torproject.org/rs.html#details/027DCCAAA0AAC0B3F79238E60DBCBE7B5B2E4BAC)                                |            0.013 |      0    |       0    |         1 | 2019-11-07   |
| 1392 | [Finn &lt;finn@janky.solutions&gt; - 1JankypvVB65ntXp6EvY](https://metrics.torproject.org/rs.html#search/family:03F26766F14B0B7B5D22461083807D313429A34F)             |            0.013 |      0    |       0.02 |         2 | 2015-10-22   |
| 1393 | [tor a as203038 d net](https://metrics.torproject.org/rs.html#details/10CA859C429A17EFF704CC53D0080940148D59DA)                                                       |            0.013 |      0    |       0.02 |         1 | 2018-12-06   |
| 1394 | [Markus &lt;markus AT mdfnet dot se&gt;](https://metrics.torproject.org/rs.html#search/family:12AD30E5D25AA67F519780E2111E611A455FDC89)                               |            0.013 |      0    |       0.02 |         3 | 2014-06-16   |
| 1395 | [hannesexner91tor@googlemail.com](https://metrics.torproject.org/rs.html#details/1BB98B6F6EBCB616D0BD9485EA4B6FA7A7501D74)                                            |            0.013 |      0    |       0.02 |         1 | 2019-10-22   |
| 1396 | [0x10C5B42FC7715134 Gordon Freeman &lt;dark.relay@pm.m](https://metrics.torproject.org/rs.html#details/200473B7974E8D78B75B28DBD6C218DA3A0B8059)                      |            0.013 |      0    |       0.02 |         1 | 2020-04-18   |
| 1397 | [A7E5 80DE E42C 3C8A Jordan Martel &lt;jordan AT jorda](https://metrics.torproject.org/rs.html#details/217B9BE70DC602F6D929132EA2A9DF60BAED8CE0)                      |            0.013 |      0    |       0.02 |         1 | 2020-04-09   |
| 1398 | [22B64DD0](https://metrics.torproject.org/rs.html#details/22B64DD090129E2E413689E245443E2799087B5A)                                                                   |            0.013 |      0    |       0    |         1 | 2020-05-18   |
| 1399 | [abuse at dataideas dot com tor-relay.co](https://metrics.torproject.org/rs.html#details/22E8C4F4EEBC161977F760E39ECDA6DFE3FC3955)                                    |            0.013 |      0.04 |       0    |         1 | 2020-06-13   |
| 1400 | [28DF1CE4](https://metrics.torproject.org/rs.html#details/28DF1CE408D2E0BA556188E81EC7499DF90B583A)                                                                   |            0.013 |      0    |       0    |         1 | 2020-04-17   |
| 1401 | [356ACBA2](https://metrics.torproject.org/rs.html#details/356ACBA2D112CA4D1457F27D2EA0759BF82EE898)                                                                   |            0.013 |      0    |       0.02 |         1 | 2019-12-09   |
| 1402 | [3910C5CA](https://metrics.torproject.org/rs.html#details/3910C5CA0CC5AFE22C709DF471A2B5B6B4AEDC98)                                                                   |            0.013 |      0.04 |       0    |         1 | 2019-01-20   |
| 1403 | [&lt;treetor AT protonmail DOT com&gt;](https://metrics.torproject.org/rs.html#details/3AB334331819AC0BA1A8AFE002D4321672109CAC)                                      |            0.013 |      0    |       0.02 |         1 | 2019-08-26   |
| 1404 | [46736616](https://metrics.torproject.org/rs.html#details/46736616C5A895D636C93EF9F8A289C3BC93EE53)                                                                   |            0.013 |      0    |       0.02 |         1 | 2018-01-09   |
| 1405 | [oxygen](https://metrics.torproject.org/rs.html#details/488C94BA00DC38397BE3EA051AB3BF8FE660A062)                                                                     |            0.013 |      0.04 |       0    |         1 | 2020-04-20   |
| 1406 | [@FuckTrump](https://metrics.torproject.org/rs.html#details/4C79714A9BDDB6CF8F4C42AF0AFA6E2F12151FDE)                                                                 |            0.013 |      0    |       0    |         1 | 2020-08-07   |
| 1407 | [maintainer &lt;nobody AT tartaneagle dot ORG &lt;dot&gt; uk](https://metrics.torproject.org/rs.html#details/4D2FCB3C654AD6AFCA4AF87E87AE72735F643D8B)                |            0.013 |      0    |       0.02 |         1 | 2017-07-07   |
| 1408 | [torpids AT yahoo dot com - 1JYHfzVFVD7n2Sezz3DEHDF](https://metrics.torproject.org/rs.html#details/4EB55679FA91363B97372554F8DC7C63F4E5B101)                         |            0.013 |      0    |       0.02 |         1 | 2018-08-24   |
| 1409 | [503FCA00](https://metrics.torproject.org/rs.html#details/503FCA0040D4701CED8078F0A38C3BFD4DB33CCE)                                                                   |            0.013 |      0    |       0    |         1 | 2020-01-12   |
| 1410 | [torpids AT yahoo dot com - 1JYHfzVFVD7n2Sezz3DEHDF](https://metrics.torproject.org/rs.html#details/51E1CF613FD6F9F11FE24743C91D6F9981807D82)                         |            0.013 |      0    |       0.02 |         1 | 2016-01-31   |
| 1411 | [abuse a nao.sh](https://metrics.torproject.org/rs.html#search/family:52AB8767E130C3519920C77072E72F347979AAE9)                                                       |            0.013 |      0    |       0    |         4 | 2019-12-06   |
| 1412 | [54371D64](https://metrics.torproject.org/rs.html#details/54371D64F4AED8CD1EF8ED1B58C725C4063BDE42)                                                                   |            0.013 |      0    |       0.02 |         1 | 2019-07-09   |
| 1413 | [torrelay@5h4d0w.nospam .net](https://metrics.torproject.org/rs.html#details/5645739E8EF72CA7D9EE1E12678B51A6FF8711C1)                                                |            0.013 |      0    |       0.02 |         1 | 2020-05-06   |
| 1414 | [0xFFFFFFFF Playstar Network &lt;info AT playstar](https://metrics.torproject.org/rs.html#details/5975858B6A1F37CCC96026B946EACF08E1772D0E)                           |            0.013 |      0    |       0.02 |         1 | 2020-05-19   |
| 1415 | [5F3AD48D](https://metrics.torproject.org/rs.html#details/5F3AD48D0FC1BC7F70CCA3008C5307EFBC6F8307)                                                                   |            0.013 |      0    |       0    |         1 | 2020-06-30   |
| 1416 | [Aqua Ray Tor Operators &lt;tor-operators-fr at aqua](https://metrics.torproject.org/rs.html#details/616081EC829593AF4232550DE6FFAA1D75B37A90)                        |            0.013 |      0.04 |       0    |         1 | 2014-04-12   |
| 1417 | [lweingart@protonmail.com](https://metrics.torproject.org/rs.html#details/61F24EBAEC4290FAC31CF34F0FFCDA765A2D9705)                                                   |            0.013 |      0    |       0.02 |         1 | 2020-04-13   |
| 1418 | [x1005 AT protonmail.com - 19WuqebhqrywBXy9J7EGU8qo](https://metrics.torproject.org/rs.html#details/63C81BCA835570069A7FCD48312DEA707F6CBAA2)                         |            0.013 |      0    |       0.02 |         1 | 2016-11-30   |
| 1419 | [hunterwolf a t riseup dot n3t](https://metrics.torproject.org/rs.html#details/6B13A2C3331FB5F8B37F0AEE9341D5CF1C21F3AD)                                              |            0.013 |      0    |       0.02 |         1 | 2020-01-28   |
| 1420 | [venus42@posteo.de](https://metrics.torproject.org/rs.html#details/72FF4C64E28396446B58892C356B61A8018C5C95)                                                          |            0.013 |      0    |       0.02 |         1 | 2020-06-10   |
| 1421 | [7838566C](https://metrics.torproject.org/rs.html#details/7838566C0514699504A13775BA98FE7A301F353F)                                                                   |            0.013 |      0    |       0    |         1 | 2019-10-25   |
| 1422 | [7D9C03F8](https://metrics.torproject.org/rs.html#details/7D9C03F812241DB08ADA96635E727A2EF7879384)                                                                   |            0.013 |      0    |       0.02 |         1 | 2019-10-31   |
| 1423 | [torjockel at mailbox dot org tor-relay.co](https://metrics.torproject.org/rs.html#details/7E7461F8B4C41AE617240463E5CC839055E98107)                                  |            0.013 |      0.04 |       0    |         1 | 2019-05-22   |
| 1424 | [808B94C6](https://metrics.torproject.org/rs.html#details/808B94C6EFE21F48DB737A6A61522073FF4E18AF)                                                                   |            0.013 |      0    |       0.02 |         1 | 2020-07-21   |
| 1425 | [863CD660](https://metrics.torproject.org/rs.html#details/863CD660DE6A4F72D014011BCC66E4A6A195B66F)                                                                   |            0.013 |      0    |       0    |         1 | 2020-05-14   |
| 1426 | [MatrixOperator &lt;matrixoperator AT protonmail dot c](https://metrics.torproject.org/rs.html#details/8992338A03DF92C5318B992439E7BF959C96D6F6)                      |            0.013 |      0.04 |       0    |         1 | 2020-02-08   |
| 1427 | [8D912126](https://metrics.torproject.org/rs.html#details/8D912126FA40BD67EE7D5759BD19459450AEBEA1)                                                                   |            0.013 |      0    |       0.02 |         1 | 2019-10-10   |
| 1428 | [8DC832AB](https://metrics.torproject.org/rs.html#details/8DC832ABDC9C97B8B71F74AB041D3CB3FA9578AA)                                                                   |            0.013 |      0    |       0.02 |         1 | 2019-10-31   |
| 1429 | [Bysmyyr, google my name and use firtsname@lastname](https://metrics.torproject.org/rs.html#details/8EF748FCCF1A9E2B9651DC6ABD921F8EEB24FA73)                         |            0.013 |      0    |       0.02 |         1 | 2017-02-21   |
| 1430 | [906933A3](https://metrics.torproject.org/rs.html#details/906933A309F15D7CF379127078A6791DF9B0C763)                                                                   |            0.013 |      0    |       0.02 |         1 | 2013-03-11   |
| 1431 | [92429BB4](https://metrics.torproject.org/rs.html#details/92429BB4B6FE1B166AE0347D03B3DC3ACF578BCC)                                                                   |            0.013 |      0    |       0.02 |         1 | 2019-11-05   |
| 1432 | [A123F404](https://metrics.torproject.org/rs.html#details/A123F404BD9A15D96CC7930C2BE28103341AC68B)                                                                   |            0.013 |      0    |       0.02 |         1 | 2019-10-23   |
| 1433 | [A3F374EB](https://metrics.torproject.org/rs.html#details/A3F374EBE1B897580D81FEB30C6B8A6A5F48F4C2)                                                                   |            0.013 |      0    |       0    |         1 | 2020-05-26   |
| 1434 | [0x210FE3E069ED67A8 Andreas Olsson &lt;andreas@arrakis](https://metrics.torproject.org/rs.html#details/A3FCD36B8D3047D6FC174D5F6E92F052E46839A0)                      |            0.013 |      0    |       0.02 |         1 | 2020-07-04   |
| 1435 | [noinfo@noinfo.com](https://metrics.torproject.org/rs.html#details/AF1FC704A5243CC0F08A335343D18A7D9FD871DE)                                                          |            0.013 |      0    |       0.02 |         1 | 2020-03-07   |
| 1436 | [AFE05115](https://metrics.torproject.org/rs.html#details/AFE05115595A1D028E91AD41F6A07239DB04CEBC)                                                                   |            0.013 |      0    |       0.02 |         1 | 2020-07-25   |
| 1437 | [BA694B8B](https://metrics.torproject.org/rs.html#details/BA694B8BDADA0A52D00E2FAE8A002CFD394A9A0C)                                                                   |            0.013 |      0    |       0    |         1 | 2020-01-22   |
| 1438 | [tremor](https://metrics.torproject.org/rs.html#details/BFC4734342209C8D172AACC283750116F74359C6)                                                                     |            0.013 |      0.04 |       0    |         1 | 2020-04-03   |
| 1439 | [MatrixOperator &lt;matrixoperator AT protonmail dot c](https://metrics.torproject.org/rs.html#details/C780D918C83A63C8AE5D378E32C94BFCE0DE9550)                      |            0.013 |      0.04 |       0    |         1 | 2020-02-08   |
| 1440 | [CB49DE00](https://metrics.torproject.org/rs.html#details/CB49DE00D24521F428664FF7CF06AD3912E2100B)                                                                   |            0.013 |      0    |       0    |         1 | 2020-07-05   |
| 1441 | [private@private](https://metrics.torproject.org/rs.html#details/CBD85D49F9C8BC2FCAB1255C7D196524FE926659)                                                            |            0.013 |      0    |       0.02 |         1 | 2019-12-30   |
| 1442 | [CE035C79](https://metrics.torproject.org/rs.html#details/CE035C7946CEE68425CD2358E620E408A9C823FD)                                                                   |            0.013 |      0    |       0.02 |         1 | 2019-08-15   |
| 1443 | [D248B96B](https://metrics.torproject.org/rs.html#details/D248B96B33DA5083D7771B791CB46A1214B59446)                                                                   |            0.013 |      0    |       0.02 |         1 | 2020-07-02   |
| 1444 | [D6670FB5](https://metrics.torproject.org/rs.html#details/D6670FB54B21818CE7C13524AA003258B8E35D38)                                                                   |            0.013 |      0    |       0.02 |         1 | 2019-08-27   |
| 1445 | [Pacso Tamas pt@r-it.hu](https://metrics.torproject.org/rs.html#details/DAAFB36CF46E1F6A7D135D5B86BD3334E420A7CB)                                                     |            0.013 |      0.04 |       0    |         1 | 2020-04-18   |
| 1446 | [DAD19570](https://metrics.torproject.org/rs.html#details/DAD19570682F47FB775B263330BD62B7BF0DEEA8)                                                                   |            0.013 |      0    |       0.02 |         1 | 2020-07-22   |
| 1447 | [Steve &lt;abuse AT now-dns dot com&gt;](https://metrics.torproject.org/rs.html#details/DADCAD37DE5E22E7E1F323927260155EAB3689C2)                                     |            0.013 |      0.04 |       0    |         1 | 2017-10-15   |
| 1448 | [Something Something &lt;nobody AT example dot com&gt;](https://metrics.torproject.org/rs.html#details/DB639EC18FD29A9BA765F38E089A36CAC44E5FCD)                      |            0.013 |      0    |       0.02 |         1 | 2020-08-03   |
| 1449 | [DCEA2A6D](https://metrics.torproject.org/rs.html#details/DCEA2A6D8034E164A4FFDD8AFF997E2F6FB2ECF8)                                                                   |            0.013 |      0    |       0.02 |         1 | 2015-09-10   |
| 1450 | [E185A006](https://metrics.torproject.org/rs.html#details/E185A006CD1ED8BBCC80193E891E9B392BF0A8EC)                                                                   |            0.013 |      0    |       0    |         1 | 2020-08-07   |
| 1451 | [E3500E2C](https://metrics.torproject.org/rs.html#details/E3500E2C9F6B87085056893C4279AEA0B3F37782)                                                                   |            0.013 |      0    |       0.02 |         1 | 2019-04-29   |
| 1452 | [EE94030D](https://metrics.torproject.org/rs.html#details/EE94030D02AF5A788C62EA56D483540C38460E10)                                                                   |            0.013 |      0    |       0.02 |         1 | 2020-03-07   |
| 1453 | [F7D3EF88](https://metrics.torproject.org/rs.html#details/F7D3EF888541DDE246D36F4E7C8E90F24618910E)                                                                   |            0.013 |      0    |       0.02 |         1 | 2016-11-24   |
| 1454 | [nyancat5454@aol.com](https://metrics.torproject.org/rs.html#details/FAE19F64F4C3B5351D95D1794CDC6A6AD0C8CB83)                                                        |            0.013 |      0    |       0.02 |         1 | 2016-12-07   |
| 1455 | [FD5ECDE6](https://metrics.torproject.org/rs.html#details/FD5ECDE6BE8CA947E7C7E3257A51CF1F27F90B75)                                                                   |            0.013 |      0    |       0.02 |         1 | 2020-07-13   |
| 1456 | [037B6C60](https://metrics.torproject.org/rs.html#details/037B6C60DAD4DF32FDA29BF458D5C8C816AA8F3E)                                                                   |            0.012 |      0    |       0.02 |         1 | 2019-08-22   |
| 1457 | [104D9F6C](https://metrics.torproject.org/rs.html#details/104D9F6CE16EF525B994FA6595E0023F8C6A4E08)                                                                   |            0.012 |      0    |       0    |         1 | 2020-05-13   |
| 1458 | [10B5F0B2](https://metrics.torproject.org/rs.html#details/10B5F0B28B42B02BEC40ADAAD775BF934A3931EC)                                                                   |            0.012 |      0    |       0    |         1 | 2020-08-04   |
| 1459 | [GPG:CE152D3899DCBB61](https://metrics.torproject.org/rs.html#details/128D16508676598DC8C7465CC5A87A338208466C)                                                       |            0.012 |      0    |       0    |         1 | 2019-02-05   |
| 1460 | [admin@awaken.systems](https://metrics.torproject.org/rs.html#details/1D61A89F10F8218660E4958EB5482B1768A085F1)                                                       |            0.012 |      0.04 |       0    |         1 | 2020-03-16   |
| 1461 | [1E176936](https://metrics.torproject.org/rs.html#details/1E176936547346993584514EB52AE2CC2E1FF4FC)                                                                   |            0.012 |      0    |       0    |         1 | 2020-06-20   |
| 1462 | [1E30069E](https://metrics.torproject.org/rs.html#details/1E30069E4E55AF9AC4F288CD17B10BE72552B939)                                                                   |            0.012 |      0    |       0    |         1 | 2020-05-14   |
| 1463 | [1FA58F4E](https://metrics.torproject.org/rs.html#details/1FA58F4E722AB35E27E2FF601122627B01103642)                                                                   |            0.012 |      0    |       0    |         1 | 2020-08-07   |
| 1464 | [22204A65](https://metrics.torproject.org/rs.html#details/22204A65735CC47DF0376A9A7C7B79EA4B77F215)                                                                   |            0.012 |      0    |       0.02 |         1 | 2020-07-06   |
| 1465 | [Leslie &lt;leslie@leslie.is&gt;](https://metrics.torproject.org/rs.html#search/family:2507E6A97AC52DC09FA519D31340156EEC626A5B)                                      |            0.012 |      0    |       0    |         4 | 2020-02-01   |
| 1466 | [tor-operator@your-emailaddress-domain](https://metrics.torproject.org/rs.html#details/2715B8C9FA7789751FA506EF5EA3D8BD61AA7D24)                                      |            0.012 |      0    |       0    |         1 | 2019-10-28   |
| 1467 | [275EA425](https://metrics.torproject.org/rs.html#details/275EA42562624713B8B89A8F1557796C5F2AA24B)                                                                   |            0.012 |      0.04 |       0    |         1 | 2019-10-18   |
| 1468 | [peach at peachers dot io](https://metrics.torproject.org/rs.html#details/27D668BFB3839D8C6E36193FFC3DF4DD6D79B513)                                                   |            0.012 |      0    |       0.02 |         1 | 2020-01-31   |
| 1469 | [ntells@protonmail.com](https://metrics.torproject.org/rs.html#details/2B7076065C8177F2DA97CBC84307CEBB213406FD)                                                      |            0.012 |      0    |       0.02 |         1 | 2020-01-08   |
| 1470 | [Random Person &lt;nodeemail at protonmail dot com&gt;](https://metrics.torproject.org/rs.html#details/2CD5474E33D12629156B92FBD61FAAB22D07B0F7)                      |            0.012 |      0    |       0.02 |         1 | 2019-12-15   |
| 1471 | [2F4C603C](https://metrics.torproject.org/rs.html#details/2F4C603CCBBCA287B04ECAB0EB0EEC9DFCA9CED9)                                                                   |            0.012 |      0    |       0.02 |         1 | 2019-08-21   |
| 1472 | [tordom at protonmail dot com](https://metrics.torproject.org/rs.html#details/32A43B0C153C2298FDBD24A3B298DA9368DC73B8)                                               |            0.012 |      0    |       0    |         1 | 2019-09-23   |
| 1473 | [tor-operat0r@protonmail.com](https://metrics.torproject.org/rs.html#details/36414078C521BA19168260F6DF23C97995976289)                                                |            0.012 |      0    |       0.02 |         1 | 2018-09-22   |
| 1474 | [tor ta diznay tod org](https://metrics.torproject.org/rs.html#details/36BABBBC06E2BF9D2C992371324B95B812E10A40)                                                      |            0.012 |      0    |       0.02 |         1 | 2019-06-28   |
| 1475 | [karl AT karl morin dot com tor-relay.co](https://metrics.torproject.org/rs.html#details/38F74AD4503689A3FD5DCADC11783F8D8255F839)                                    |            0.012 |      0    |       0.02 |         1 | 2020-06-14   |
| 1476 | [Grga &lt;grga.byx AT GMAIL&gt;](https://metrics.torproject.org/rs.html#details/3AE9B85D5945000C2A65F4E054171928D5BDE91E)                                             |            0.012 |      0    |       0    |         1 | 2020-06-04   |
| 1477 | [3CD5F776](https://metrics.torproject.org/rs.html#details/3CD5F7766CF8E96FE315678B0CAC6A5B999FC47D)                                                                   |            0.012 |      0    |       0.02 |         1 | 2017-05-31   |
| 1478 | [3EDD0024](https://metrics.torproject.org/rs.html#details/3EDD00245D93664A33A724BA377150E5531ED033)                                                                   |            0.012 |      0    |       0.02 |         1 | 2016-03-28   |
| 1479 | [Miricello Marmeredo &lt;7gy0hn5hnrwaetyo7f5b@mail.ru&gt;](https://metrics.torproject.org/rs.html#search/family:419C3FC74B87C36EEE3AD9140ED3ECE429825CF5)             |            0.012 |      0    |       0.02 |         3 | 2019-12-19   |
| 1480 | [4495DEA0](https://metrics.torproject.org/rs.html#details/4495DEA0FE1200E8675065F0DA58E21C93A616CA)                                                                   |            0.012 |      0    |       0.02 |         1 | 2018-01-30   |
| 1481 | [4B4D7C72](https://metrics.torproject.org/rs.html#details/4B4D7C727B603EF6777DC0BC3D169179CA977140)                                                                   |            0.012 |      0    |       0.02 |         1 | 2018-02-21   |
| 1482 | [tor-operator@your-emailaddress-domain](https://metrics.torproject.org/rs.html#details/4B550F757A5904939280CB85DE61F125A08AE5DE)                                      |            0.012 |      0    |       0.02 |         1 | 2020-06-08   |
| 1483 | [no dot thanks at example dot com](https://metrics.torproject.org/rs.html#details/520952098AEC08A9FAF2802482A61AB1BF2EAC2A)                                           |            0.012 |      0    |       0.02 |         1 | 2018-12-04   |
| 1484 | [tor 1 AT online DOT de](https://metrics.torproject.org/rs.html#details/525EE34C1A7B89AB9DF585246DE30E32702913F5)                                                     |            0.012 |      0.04 |       0    |         1 | 2020-01-14   |
| 1485 | [568583D9](https://metrics.torproject.org/rs.html#details/568583D9E46C68045E2131CF403E48F21DF11F0A)                                                                   |            0.012 |      0    |       0.02 |         1 | 2019-12-11   |
| 1486 | [6565F31D](https://metrics.torproject.org/rs.html#details/6565F31D9EC0C7DFFEA1920BE3BA4C73EF35B5C4)                                                                   |            0.012 |      0    |       0.02 |         1 | 2016-01-02   |
| 1487 | [6D0324E4](https://metrics.torproject.org/rs.html#details/6D0324E48F435E19F077307BB686D118C6DAF124)                                                                   |            0.012 |      0    |       0    |         1 | 2020-07-25   |
| 1488 | [6EE789A0](https://metrics.torproject.org/rs.html#details/6EE789A0892DDB8928D41F439F639E49405F5BB5)                                                                   |            0.012 |      0.04 |       0    |         1 | 2020-02-06   |
| 1489 | [6F435F38](https://metrics.torproject.org/rs.html#details/6F435F389BC05A34708E99F2B222F580D9065362)                                                                   |            0.012 |      0    |       0.02 |         1 | 2020-06-23   |
| 1490 | [gutbesserwasser &lt;gutbesserwasser at gmail dot com&gt;](https://metrics.torproject.org/rs.html#search/family:75879A607DB661AE2EE8E270FBCBCA66ADF74E73)             |            0.012 |      0    |       0.02 |         2 | 2016-05-09   |
| 1491 | [Random Person sexyhexi at outlook dot at](https://metrics.torproject.org/rs.html#details/79B207AD51842FA215D956B9307B3D01CD347368)                                   |            0.012 |      0    |       0.02 |         1 | 2018-09-17   |
| 1492 | [7A7388DC](https://metrics.torproject.org/rs.html#details/7A7388DC59677C5E0915F7C3AFD3557834339CF1)                                                                   |            0.012 |      0    |       0    |         1 | 2020-06-26   |
| 1493 | [UristMcDerp@protonmail.com](https://metrics.torproject.org/rs.html#details/835D88AE990CA3A33A49F800F64ACE580F4C21FE)                                                 |            0.012 |      0    |       0.02 |         1 | 2018-04-23   |
| 1494 | [Xidorn Quan &lt;tor-relay at upsuper org&gt;](https://metrics.torproject.org/rs.html#details/96070698714DC07AE2B377864625B7EF64E33BF5)                               |            0.012 |      0    |       0.02 |         1 | 2019-02-26   |
| 1495 | [freeflo@protonmail.com 3EEt9wZYf9Wa74ksEsrCX6gN4vD](https://metrics.torproject.org/rs.html#details/96E0D19D735D47039844EA83372183BB606F87B4)                         |            0.012 |      0    |       0.02 |         1 | 2019-05-13   |
| 1496 | [bW9lcmRhcnZhbGVuQGdtYWlsLmNvbQ==](https://metrics.torproject.org/rs.html#details/9DA5284A51021A711ECAA677C81E5408222B9F2A)                                           |            0.012 |      0    |       0.02 |         1 | 2020-02-08   |
| 1497 | [anonymous](https://metrics.torproject.org/rs.html#details/9DA7A978928C48B4DD50E397FE2F3C4110EA3576)                                                                  |            0.012 |      0    |       0    |         1 | 2018-07-04   |
| 1498 | [9DB9209D](https://metrics.torproject.org/rs.html#details/9DB9209D01BE9E92FAB1665F016471C821233238)                                                                   |            0.012 |      0    |       0    |         1 | 2020-06-27   |
| 1499 | [immy@420blaze.it](https://metrics.torproject.org/rs.html#details/9E866F30B791ACB79ED280D3197D999CBA85A6EF)                                                           |            0.012 |      0    |       0.02 |         1 | 2019-09-30   |
| 1500 | [9E9BEC42](https://metrics.torproject.org/rs.html#details/9E9BEC429AC8FB99795ACDCEE09BC56049348ECB)                                                                   |            0.012 |      0    |       0.02 |         1 | 2019-12-05   |
| 1501 | [Henrik &lt;tor AT donotuse dot de&gt;](https://metrics.torproject.org/rs.html#details/A1FEE8537C847D330F1F7F592BE24360C5D6051F)                                      |            0.012 |      0    |       0    |         1 | 2019-01-22   |
| 1502 | [A70848B0](https://metrics.torproject.org/rs.html#details/A70848B08F1064B44501037D40CB7C39F6039D4A)                                                                   |            0.012 |      0    |       0    |         1 | 2020-05-01   |
| 1503 | [AB73816E](https://metrics.torproject.org/rs.html#search/family:AB73816E5D7BC52664CBB9D005FF579BAFEAFE87)                                                             |            0.012 |      0    |       0.02 |         2 | 2014-07-23   |
| 1504 | [MatrixOperator &lt;matrixoperator AT protonmail dot c](https://metrics.torproject.org/rs.html#details/AC66347EB02E4C67A9BE46D90176D7BA029D6E1B)                      |            0.012 |      0.04 |       0    |         1 | 2020-02-08   |
| 1505 | [AE85D0A8](https://metrics.torproject.org/rs.html#details/AE85D0A826E4674CA85698520EB14275B78E9006)                                                                   |            0.012 |      0    |       0    |         1 | 2020-07-19   |
| 1506 | [AFF499AF](https://metrics.torproject.org/rs.html#details/AFF499AF071A2DE2EADC22B67B48ACC91EEEF394)                                                                   |            0.012 |      0    |       0.02 |         1 | 2019-04-10   |
| 1507 | [AFFD147D](https://metrics.torproject.org/rs.html#details/AFFD147DBCC065A5CEF7258BC1367CC35855A431)                                                                   |            0.012 |      0    |       0.02 |         1 | 2013-08-01   |
| 1508 | [mailaddress: tor-relay tutanota](https://metrics.torproject.org/rs.html#details/B1B8EE3BD207009B0CBA4346BBBA559EECFC0175)                                            |            0.012 |      0    |       0    |         1 | 2020-06-17   |
| 1509 | [Yaga &lt;tor SPAMfree at yaga spamtrap dot eu&gt;](https://metrics.torproject.org/rs.html#details/BC7ACFAC04854C77167C7D66B7E471314ED8C410)                          |            0.012 |      0    |       0.02 |         1 | 2016-01-03   |
| 1510 | [C6BA2CDA](https://metrics.torproject.org/rs.html#details/C6BA2CDA402B668FB146F7BAEBC09D06EBEFB873)                                                                   |            0.012 |      0.04 |       0    |         1 | 2020-02-06   |
| 1511 | [CD5CF125](https://metrics.torproject.org/rs.html#details/CD5CF125FED4BE5DA5F259F75AF3D4DD182C54D0)                                                                   |            0.012 |      0    |       0.02 |         1 | 2019-06-26   |
| 1512 | [0x31384448 Ole Rydahl Had a cat named Dobbo &lt;ole](https://metrics.torproject.org/rs.html#details/CE1FD7659F2DFE92B883083C0C6C974616D17F3D)                        |            0.012 |      0    |       0    |         1 | 2014-07-02   |
| 1513 | [info@dfiusec.com](https://metrics.torproject.org/rs.html#details/D8BD437B3165203E890D0DB57DF2AC128C95B3B4)                                                           |            0.012 |      0.04 |       0    |         1 | 2019-12-15   |
| 1514 | [operator &lt;linrx AT danwin1210 dot me&gt;](https://metrics.torproject.org/rs.html#details/E2D9035061E3D133B2CA4DA3383AEAACCC0733E1)                                |            0.012 |      0    |       0.02 |         1 | 2020-07-21   |
| 1515 | [4096R/0xC1FD909980E93558 L29Ah &lt;zl29ah@gmail.com&gt;](https://metrics.torproject.org/rs.html#details/E4BE02471657C3A17C667D7C079498E4B314049F)                    |            0.012 |      0    |       0.02 |         1 | 2010-01-31   |
| 1516 | [EA032AFA](https://metrics.torproject.org/rs.html#details/EA032AFA2FE95A590759ED2CDD21BD4DA43EA259)                                                                   |            0.012 |      0    |       0    |         1 | 2020-06-11   |
| 1517 | [jfghjgsdjghdsjgf@jabber.ccc.de](https://metrics.torproject.org/rs.html#details/EBB76D096FF5787A303B2C81E21BFF9816C6FA0D)                                             |            0.012 |      0    |       0.02 |         1 | 2019-10-15   |
| 1518 | [JennyBreder2003@protonmail.com](https://metrics.torproject.org/rs.html#details/F00C8B7589FEE52BE84387CDB422C1F1386979C0)                                             |            0.012 |      0    |       0    |         1 | 2019-10-19   |
| 1519 | [F142793F](https://metrics.torproject.org/rs.html#details/F142793FBD6F8E9EC1FC972BCCD8A06009E3DAFC)                                                                   |            0.012 |      0    |       0.02 |         1 | 2020-07-13   |
| 1520 | [torbob &lt; torbob anAT riseup aDOT net &gt;](https://metrics.torproject.org/rs.html#details/F5B58FEE44573C3BFD7D176D918BA5B4057519D7)                               |            0.012 |      0    |       0.02 |         1 | 2016-04-09   |
| 1521 | [Daniel K &lt;tor AT recodex dot at&gt;](https://metrics.torproject.org/rs.html#details/F9910CE2A3E9D467FCDD9D5228695BA1827B010D)                                     |            0.012 |      0    |       0.02 |         1 | 2017-03-20   |
| 1522 | [FA32E93A](https://metrics.torproject.org/rs.html#details/FA32E93AA76D5B2E8FB598761353F67267A02902)                                                                   |            0.012 |      0    |       0    |         1 | 2020-07-08   |
| 1523 | [Nona Admin &lt;admin AT nonanet dot net&gt;](https://metrics.torproject.org/rs.html#details/FACAE9DD19315898E1B61FA9B3F786B03040BE75)                                |            0.012 |      0.04 |       0    |         1 | 2019-09-24   |
| 1524 | [tormaster &lt;tormaster AT sebastian-graf dot at&gt;](https://metrics.torproject.org/rs.html#details/FDCCAF8E5F3F8D33B633238CFCB7113FB9B7AA78)                       |            0.012 |      0    |       0    |         1 | 2020-06-21   |
| 1525 | [0356BEF9](https://metrics.torproject.org/rs.html#details/0356BEF9BBE0E14AF1C97112175F5E20FB80E6CF)                                                                   |            0.011 |      0    |       0    |         1 | 2020-06-26   |
| 1526 | [069E732E](https://metrics.torproject.org/rs.html#details/069E732EC96774ED5609D4803D7B1130E338B0EB)                                                                   |            0.011 |      0    |       0.01 |         1 | 2017-05-10   |
| 1527 | [098B3457](https://metrics.torproject.org/rs.html#details/098B3457ABA31AD65A3AF47F61B623E35B3FAB2D)                                                                   |            0.011 |      0    |       0.01 |         1 | 2016-11-01   |
| 1528 | [Random Person &lt;tor-trouble AT boldandbusted dot co](https://metrics.torproject.org/rs.html#details/09F64E00F34C88F604163F24D37BEAF9245702EA)                      |            0.011 |      0    |       0.01 |         1 | 2008-10-06   |
| 1529 | [&lt;tor-operator -at- tec.link38.eu&gt;](https://metrics.torproject.org/rs.html#search/family:0AC4C4D8BCA8DA7BAE6BE3FEA87442E724353CBF)                              |            0.011 |      0    |       0    |         4 | 2018-06-16   |
| 1530 | [rufo &lt;tor at rufoa dotcom&gt;](https://metrics.torproject.org/rs.html#details/0E92BF02B3C11B0DD18301A0DE1B164A0546E36F)                                           |            0.011 |      0.03 |       0    |         1 | 2015-05-27   |
| 1531 | [&lt;admin AT wiomoc DOT de&gt;](https://metrics.torproject.org/rs.html#details/13B1322230E9D10C29F8AE631DA658AE5C3C7BA6)                                             |            0.011 |      0    |       0.01 |         1 | 2019-11-29   |
| 1532 | [hp &lt; tor1panhuxyz aT cock d0t li &gt;](https://metrics.torproject.org/rs.html#search/family:14CF04009FFE81448391F3FA626E9D2F114BDE54)                             |            0.011 |      0.03 |       0    |         2 | 2020-02-14   |
| 1533 | [18A0BF30](https://metrics.torproject.org/rs.html#details/18A0BF3052374A7111EF4B8FC8EB7B9B30C95308)                                                                   |            0.011 |      0    |       0    |         1 | 2020-06-26   |
| 1534 | [lostmc1@mail.ru](https://metrics.torproject.org/rs.html#details/1A020A414D8AB25F54415C8C1E75A5562A9DD9A6)                                                            |            0.011 |      0    |       0.01 |         1 | 2018-09-12   |
| 1535 | [1AA506B4](https://metrics.torproject.org/rs.html#details/1AA506B41F33970359C4136CB3ACDC4D23EAA22F)                                                                   |            0.011 |      0    |       0    |         1 | 2020-07-15   |
| 1536 | [1C2F0929](https://metrics.torproject.org/rs.html#details/1C2F0929A4A8D9661D83E70FDE96B61040ECA14D)                                                                   |            0.011 |      0    |       0.01 |         1 | 2019-01-05   |
| 1537 | [Tor Person &lt;daotorrelay X gmail.com&gt;](https://metrics.torproject.org/rs.html#details/1F6ABD086F40B890A33C93CC4606EE68B31C9556)                                 |            0.011 |      0    |       0.01 |         1 | 2007-11-23   |
| 1538 | [network at aisec dot fraunhofer dot de](https://metrics.torproject.org/rs.html#details/20386D9A32BECBE602375E015FC70117955653F1)                                     |            0.011 |      0    |       0.01 |         1 | 2014-01-03   |
| 1539 | [matt at x86txt dot com tor-relay.co](https://metrics.torproject.org/rs.html#details/222D1EBED7ED0344A66F544F5CA0C496FE608D6C)                                        |            0.011 |      0.03 |       0    |         1 | 2020-06-29   |
| 1540 | [Uni Corn &lt;unishizzle/at/gmail/dot/com&gt;](https://metrics.torproject.org/rs.html#details/231C6F4B22A0BA18D71B882AEF85994311A3722B)                               |            0.011 |      0    |       0.01 |         1 | 2020-05-14   |
| 1541 | [24AF1603](https://metrics.torproject.org/rs.html#details/24AF1603CDF4D118E1F7AEBF680C18BDA5E8F793)                                                                   |            0.011 |      0    |       0.02 |         1 | 2019-10-10   |
| 1542 | [24D426BC](https://metrics.torproject.org/rs.html#details/24D426BC072D6D6090B23B6829D8B32682034C01)                                                                   |            0.011 |      0    |       0    |         1 | 2020-07-09   |
| 1543 | [26198AAE](https://metrics.torproject.org/rs.html#details/26198AAE02986B4D9172637DD7872A1EDF41BD40)                                                                   |            0.011 |      0    |       0    |         1 | 2020-05-15   |
| 1544 | [27B90919](https://metrics.torproject.org/rs.html#details/27B90919AADA44C9B6C74E2A437F37730129E0C3)                                                                   |            0.011 |      0    |       0    |         1 | 2020-07-20   |
| 1545 | [Vladimir Ivanov &lt;ivlad@nxadi.com&gt;](https://metrics.torproject.org/rs.html#details/28C52CDBB78DA46124DA62EC1D6796689E719210)                                    |            0.011 |      0    |       0.01 |         1 | 2014-07-29   |
| 1546 | [2AB9FFCC](https://metrics.torproject.org/rs.html#details/2AB9FFCC6618FBBC973C457FC6BE5E8620A60FDC)                                                                   |            0.011 |      0    |       0.01 |         1 | 2019-12-05   |
| 1547 | [1Bitcoin6Z4sHNtj3n8hRXhzzB22Kh45EG &lt;tor AT grey do](https://metrics.torproject.org/rs.html#details/2F77315CAE477550E47773BA5B1323F7FFBE3A3E)                      |            0.011 |      0    |       0.02 |         1 | 2019-01-20   |
| 1548 | [larka@nordberg.se](https://metrics.torproject.org/rs.html#details/32EB288C0EFB52964CCF8EF28BE6BC7FF592BB58)                                                          |            0.011 |      0    |       0.01 |         1 | 2019-01-22   |
| 1549 | [33E06A90](https://metrics.torproject.org/rs.html#details/33E06A9063B024EA890E7215C09303708D11A5F8)                                                                   |            0.011 |      0    |       0    |         1 | 2020-06-14   |
| 1550 | [hallo at projektspeicher.org](https://metrics.torproject.org/rs.html#details/3547FAF7D6526BBE81CC07FACAD612A99BDD9876)                                               |            0.011 |      0    |       0.01 |         1 | 2016-11-09   |
| 1551 | [3660D91C](https://metrics.torproject.org/rs.html#details/3660D91C4DC0F7009B63539666AD09EE4F474427)                                                                   |            0.011 |      0    |       0    |         1 | 2020-05-13   |
| 1552 | [3C72CBCB](https://metrics.torproject.org/rs.html#details/3C72CBCBA7A3102D2D6F39D2D319C51BAF9CF07A)                                                                   |            0.011 |      0    |       0    |         1 | 2020-06-15   |
| 1553 | [3E13E2EB](https://metrics.torproject.org/rs.html#details/3E13E2EB87CCF5690564EE33E9F9F9F80B229FBB)                                                                   |            0.011 |      0    |       0.01 |         1 | 2015-11-05   |
| 1554 | [rememberremember at gmx dot com](https://metrics.torproject.org/rs.html#details/425E358E94FB53E7F11AF2D9AB60DE25F534BA1A)                                            |            0.011 |      0    |       0.01 |         1 | 2017-02-28   |
| 1555 | [tor-relay-01 at dannewitz dot ninja](https://metrics.torproject.org/rs.html#details/438E8C214576AF13480A550D45C116F43333C319)                                        |            0.011 |      0    |       0    |         1 | 2019-12-22   |
| 1556 | [Der weltgrosskommunist und Weltkulturerbebesitzer](https://metrics.torproject.org/rs.html#details/456EDF12CF4691E6292490D8D41764B3E0A76FC9)                          |            0.011 |      0.03 |       0    |         1 | 2020-08-09   |
| 1557 | [4BF77DBD](https://metrics.torproject.org/rs.html#details/4BF77DBD6796628EC6AC29F5651CEE1969EC7315)                                                                   |            0.011 |      0    |       0    |         1 | 2019-12-23   |
| 1558 | [secretcontact@protonmail dot com](https://metrics.torproject.org/rs.html#details/4E737BBFCCBE45A923CE82577E99DCFFABC5BFF4)                                           |            0.011 |      0    |       0.01 |         1 | 2015-09-17   |
| 1559 | [52B99138](https://metrics.torproject.org/rs.html#details/52B99138A72EF9925508C0BF70547D120B568E50)                                                                   |            0.011 |      0    |       0    |         1 | 2020-06-26   |
| 1560 | [knuth &lt;tor AT ethergeist dot de&gt;](https://metrics.torproject.org/rs.html#details/53412DCC555335B400DB72750ED0BE08D034D779)                                     |            0.011 |      0    |       0.01 |         1 | 2016-12-03   |
| 1561 | [no at thanks dot com tor-relay.co](https://metrics.torproject.org/rs.html#details/57CB4D6FB898E8B7CA9A01018AB6BCB727BF20A9)                                          |            0.011 |      0.03 |       0    |         1 | 2020-04-23   |
| 1562 | [0xFD7DF541 Elude.in TorOperator &lt;tor@elude.in&gt;](https://metrics.torproject.org/rs.html#details/58245CD810DE4B7BFB419E2B694E9844B77B1FF7)                       |            0.011 |      0    |       0.02 |         1 | 2020-07-31   |
| 1563 | [email:info sebastianboegl.de operatorurl:https://](https://metrics.torproject.org/rs.html#details/58ED9C9C35E433EE58764D62892B4FFD518A3CD0)                          |            0.011 |      0    |       0.02 |         1 | 2014-04-09   |
| 1564 | [tor-admin@umich.edu](https://metrics.torproject.org/rs.html#details/5AFAC3D00E97D6733112CC9CA2A788691FA87125)                                                        |            0.011 |      0.03 |       0    |         1 | 2018-05-21   |
| 1565 | [5CA1D065](https://metrics.torproject.org/rs.html#details/5CA1D0651A3B49AD483A9046F2658DC6A3EB5880)                                                                   |            0.011 |      0.03 |       0    |         1 | 2020-05-06   |
| 1566 | [5F914142](https://metrics.torproject.org/rs.html#details/5F9141428BF5EAE485F0E2F7912DEDED4F4D17A7)                                                                   |            0.011 |      0    |       0    |         1 | 2020-07-23   |
| 1567 | [6062A0D4](https://metrics.torproject.org/rs.html#details/6062A0D4F5BD1C1FF2D7BD5998663E0FA7E21450)                                                                   |            0.011 |      0    |       0    |         1 | 2020-02-11   |
| 1568 | [abuse at yggdrasil dot ws](https://metrics.torproject.org/rs.html#details/6318A90A2E0B05CB23DFD7BD0BB4FE8549F64D3E)                                                  |            0.011 |      0.03 |       0    |         1 | 2020-08-05   |
| 1569 | [4xoc@protonmail.com](https://metrics.torproject.org/rs.html#details/67073A512A5C20C65416259FD40C434A7D01C4C2)                                                        |            0.011 |      0    |       0    |         1 | 2020-06-14   |
| 1570 | [6B88E20F](https://metrics.torproject.org/rs.html#details/6B88E20FEE8EB47F1A8E30207F327005C61A013D)                                                                   |            0.011 |      0    |       0    |         1 | 2015-11-02   |
| 1571 | [sysop -at- openinternet . io](https://metrics.torproject.org/rs.html#search/family:6BF68981D1AFAE7C9F1D575E2D9ECE24AF21DA8A)                                         |            0.011 |      0    |       0.01 |         3 | 2018-08-03   |
| 1572 | [7242D131](https://metrics.torproject.org/rs.html#details/7242D131DF0217C38EE945A0F3887B0BF431F71F)                                                                   |            0.011 |      0.03 |       0    |         1 | 2020-05-20   |
| 1573 | [&lt;jeff@mulb.us&gt;](https://metrics.torproject.org/rs.html#details/73A62B590CC4F290D068FA20A12D6408A0D8B60C)                                                       |            0.011 |      0    |       0.01 |         1 | 2016-11-23   |
| 1574 | [g00dplain@tuta.io](https://metrics.torproject.org/rs.html#details/74312EF576DE1E7710D5420791E6BDB41808439E)                                                          |            0.011 |      0    |       0.01 |         1 | 2019-02-01   |
| 1575 | [770F6F16](https://metrics.torproject.org/rs.html#details/770F6F160A05369FF79FA0E8A8F3B2AF335EFFD2)                                                                   |            0.011 |      0    |       0    |         1 | 2020-05-18   |
| 1576 | [Random Person &lt;DefiantDave AT protonmail dot com&gt;](https://metrics.torproject.org/rs.html#search/family:7C499ACD60FB651DD486B6D802290A3EBBECCD84)              |            0.011 |      0    |       0.02 |         2 | 2017-10-02   |
| 1577 | [7D928720](https://metrics.torproject.org/rs.html#details/7D928720EC0CB5C2AFE04DF0EBC37BD59B00EAB4)                                                                   |            0.011 |      0    |       0    |         1 | 2020-08-09   |
| 1578 | [87EA8B42](https://metrics.torproject.org/rs.html#details/87EA8B42136D1F9014BE377B2B985459D19E6E70)                                                                   |            0.011 |      0    |       0.02 |         1 | 2018-12-27   |
| 1579 | [8885EA6F](https://metrics.torproject.org/rs.html#details/8885EA6F74A694825B13B8A7080F6CF164DF74FB)                                                                   |            0.011 |      0    |       0.01 |         1 | 2017-06-13   |
| 1580 | [Something Something &lt;nobody AT example dot com&gt;](https://metrics.torproject.org/rs.html#details/88B0C4485BA11C6F02D2966C32A7B34063991820)                      |            0.011 |      0    |       0.01 |         1 | 2020-08-03   |
| 1581 | [8A41E7DE](https://metrics.torproject.org/rs.html#details/8A41E7DE5113D0877FD335EE84670DFC0A9C3FA2)                                                                   |            0.011 |      0    |       0    |         1 | 2020-07-06   |
| 1582 | [ronald.dunno@mail.ru](https://metrics.torproject.org/rs.html#details/8E1EFE623F0BF0622F2A6F135E13EA6E3AE5826E)                                                       |            0.011 |      0.03 |       0    |         1 | 2020-07-26   |
| 1583 | [8F99DCF2](https://metrics.torproject.org/rs.html#details/8F99DCF27BC33D235D20B945AF647AA3DBFCEC59)                                                                   |            0.011 |      0    |       0    |         1 | 2020-06-27   |
| 1584 | [938ACAB8](https://metrics.torproject.org/rs.html#details/938ACAB816A334BF467E41EE3A6F1E4F916155F0)                                                                   |            0.011 |      0    |       0    |         1 | 2019-12-23   |
| 1585 | [wojackpoopoo at gmail dot com](https://metrics.torproject.org/rs.html#details/96DCD1D17C1F0FA4DED207C148E54C0A55553076)                                              |            0.011 |      0    |       0.02 |         1 | 2019-04-12   |
| 1586 | [982A1034](https://metrics.torproject.org/rs.html#details/982A103489DF8410585B8077B7FD813217093EB4)                                                                   |            0.011 |      0    |       0.01 |         1 | 2016-03-07   |
| 1587 | [9886C383](https://metrics.torproject.org/rs.html#details/9886C383FC0E6A408DE33E79B0F26695360511A9)                                                                   |            0.011 |      0    |       0    |         1 | 2020-05-22   |
| 1588 | [nyancat5454@aol.com](https://metrics.torproject.org/rs.html#details/9BB6624A2DE95FC73CCC46C034A83494172EE4D3)                                                        |            0.011 |      0    |       0.01 |         1 | 2018-12-14   |
| 1589 | [kim at disconnected dot tech tor-relay.co](https://metrics.torproject.org/rs.html#details/A0B05E1D852D874EFAF3603C83246E00AD65AF20)                                  |            0.011 |      0    |       0    |         1 | 2019-11-04   |
| 1590 | [A44062AE](https://metrics.torproject.org/rs.html#details/A44062AE3484310CE728BBD7769E9CD44C09FBB0)                                                                   |            0.011 |      0    |       0.02 |         1 | 2020-07-12   |
| 1591 | [death@privacyrequired.com - 1B6Rh8jgNMYysUqV8EfLeC](https://metrics.torproject.org/rs.html#details/A8C1AED4343C2CA514C9CA125488FD2764353F1B)                         |            0.011 |      0    |       0    |         1 | 2019-08-30   |
| 1592 | [scottgilbertson1@protonmail.com](https://metrics.torproject.org/rs.html#details/A9CC6C0B5B002C6D902827584A336CB15B5C9DC7)                                            |            0.011 |      0    |       0.01 |         1 | 2020-05-13   |
| 1593 | [AB0120A9](https://metrics.torproject.org/rs.html#details/AB0120A92CC6C2BC3A01CC9347720D743AF0BD21)                                                                   |            0.011 |      0    |       0    |         1 | 2020-07-20   |
| 1594 | [citizen17 at tutamail dot com](https://metrics.torproject.org/rs.html#details/ACCBBBC575434F3A716EF648822618056F151468)                                              |            0.011 |      0.04 |       0    |         1 | 2020-02-26   |
| 1595 | [AE9B4F3B](https://metrics.torproject.org/rs.html#details/AE9B4F3B133CF4FC75BD0685F047EA4253C49B09)                                                                   |            0.011 |      0    |       0.01 |         1 | 2018-01-05   |
| 1596 | [torrelay@fh-biergarten.de - 1QCHdyhPHLrKq2d2iAip9o](https://metrics.torproject.org/rs.html#details/B07FCCFAC6131953FE8523787B4A190D16DF6681)                         |            0.011 |      0    |       0.01 |         1 | 2014-11-08   |
| 1597 | [B0F17A56](https://metrics.torproject.org/rs.html#details/B0F17A56FA8686CCB33D3F302FC40F06F463B4AE)                                                                   |            0.011 |      0    |       0.01 |         1 | 2018-12-21   |
| 1598 | [solinor@arcor.de](https://metrics.torproject.org/rs.html#details/B71DE54802E73B86F0798FB2ED2AFB0BB6B1F7C9)                                                           |            0.011 |      0    |       0.02 |         1 | 2020-07-15   |
| 1599 | [SalmonServer at Protonmail dot com](https://metrics.torproject.org/rs.html#details/B97CF770ECD2D4298A505E84A8C8A5ABFCA08887)                                         |            0.011 |      0    |       0    |         1 | 2020-08-07   |
| 1600 | [BF5C0C5D](https://metrics.torproject.org/rs.html#details/BF5C0C5D3A1C6654FEBA5FF66B00734DF073DB50)                                                                   |            0.011 |      0    |       0.01 |         1 | 2019-03-31   |
| 1601 | [C005F0CB](https://metrics.torproject.org/rs.html#details/C005F0CB30CD54CB45FF08ED151511A286B1B7CE)                                                                   |            0.011 |      0    |       0    |         1 | 2019-05-10   |
| 1602 | [C1DCC470](https://metrics.torproject.org/rs.html#details/C1DCC470C80F6D702C5ED11515936444BD3A0255)                                                                   |            0.011 |      0    |       0.01 |         1 | 2020-04-19   |
| 1603 | [C215211F](https://metrics.torproject.org/rs.html#details/C215211F88FFCF8C6E70CC34C76DA0948E3DD24A)                                                                   |            0.011 |      0    |       0    |         1 | 2020-08-05   |
| 1604 | [C2C1DD3C](https://metrics.torproject.org/rs.html#details/C2C1DD3C0E1F370A53784792E4293A84483AEBBD)                                                                   |            0.011 |      0    |       0    |         1 | 2020-08-09   |
| 1605 | [Yuri Zabolotniy zabolotniy@gmail.com](https://metrics.torproject.org/rs.html#details/C38460B0B5AE443940827FF308602E5F4A12B5C4)                                       |            0.011 |      0    |       0.01 |         1 | 2019-08-09   |
| 1606 | [tor@haltmayer.com](https://metrics.torproject.org/rs.html#details/C414F28FD2BEC1553024299B31D4E726BEB8E788)                                                          |            0.011 |      0    |       0.02 |         1 | 2014-10-11   |
| 1607 | [C564B65B](https://metrics.torproject.org/rs.html#details/C564B65BC897FC0ACCE8C29D3520BAE13C5A210E)                                                                   |            0.011 |      0    |       0.01 |         1 | 2020-03-26   |
| 1608 | [C577C56E](https://metrics.torproject.org/rs.html#details/C577C56EAD654C829D1FF2F86133F89A1A59AA89)                                                                   |            0.011 |      0    |       0.01 |         1 | 2018-01-26   |
| 1609 | [tor AT gambaru DOT de](https://metrics.torproject.org/rs.html#details/C8BEF3DF07AF38B68DD0DA91B23B19EBD2C7667F)                                                      |            0.011 |      0    |       0    |         1 | 2020-06-25   |
| 1610 | [CAB28BC7](https://metrics.torproject.org/rs.html#details/CAB28BC71970D7F9F4419AEA1043014BF1521E65)                                                                   |            0.011 |      0    |       0.01 |         1 | 2020-05-13   |
| 1611 | [CC721B29](https://metrics.torproject.org/rs.html#details/CC721B29F31B157C4D3A1B341D6D3ADC30BB8570)                                                                   |            0.011 |      0    |       0    |         1 | 2020-05-19   |
| 1612 | [0x3FFB0198 nikomo &lt;nikomo AT nikomo dot fi&gt;](https://metrics.torproject.org/rs.html#details/D002C061F56CB6FE6FF7A27747EC2A7369ABBA9A)                          |            0.011 |      0    |       0.01 |         1 | 2018-07-10   |
| 1613 | [bobull@protonmail.com](https://metrics.torproject.org/rs.html#details/D9B91878B46BB80E6D752E876BF9D481EFEAC5BF)                                                      |            0.011 |      0    |       0.01 |         1 | 2020-07-02   |
| 1614 | [DEA84F08](https://metrics.torproject.org/rs.html#details/DEA84F08432800346BADB35F1EAC1B2A4D5B165D)                                                                   |            0.011 |      0    |       0.01 |         1 | 2015-10-08   |
| 1615 | [torforwarding@yandex.ru](https://metrics.torproject.org/rs.html#details/E263B860EFA177F0DDE30C381F893F2805C140DC)                                                    |            0.011 |      0    |       0    |         1 | 2018-12-24   |
| 1616 | [E3732275](https://metrics.torproject.org/rs.html#details/E37322752F135A344FA33E17F4AFA74C27A687E6)                                                                   |            0.011 |      0    |       0.02 |         1 | 2017-09-04   |
| 1617 | [E40C7360](https://metrics.torproject.org/rs.html#details/E40C73604308C261D7E7D14D8B45C3DC4EBB52F6)                                                                   |            0.011 |      0    |       0    |         1 | 2020-05-18   |
| 1618 | [shebangs@yopmail.fr](https://metrics.torproject.org/rs.html#details/E65BA17239C454A82082B0B4F3DDD8D83E4FD893)                                                        |            0.011 |      0    |       0.01 |         1 | 2020-06-05   |
| 1619 | [FAFF33D5](https://metrics.torproject.org/rs.html#details/FAFF33D5273691F537E4657C91A8DF58182EB561)                                                                   |            0.011 |      0    |       0    |         1 | 2020-05-25   |
| 1620 | [FDB0BF52](https://metrics.torproject.org/rs.html#details/FDB0BF52D4ED84E639ADA8882FF6CDF04C4D352D)                                                                   |            0.011 |      0.03 |       0    |         1 | 2019-10-28   |
| 1621 | [Onion VFU TOR &lt;onionVFUcz AT mailinator DOT com&gt;](https://metrics.torproject.org/rs.html#details/FE547E7D1D2B3797EA07BECD5E75C85AA94A5E4A)                     |            0.011 |      0    |       0.02 |         1 | 2017-02-20   |
| 1622 | [felboroosterpony6@mail.ru](https://metrics.torproject.org/rs.html#details/FEC41DD1E5F994DEB8E267721A406C8C5365DB92)                                                  |            0.011 |      0    |       0    |         1 | 2020-07-27   |
| 1623 | [023EBBC5](https://metrics.torproject.org/rs.html#details/023EBBC57BEB7F45473B3DC2AA811FB3AABA4466)                                                                   |            0.01  |      0    |       0.01 |         1 | 2018-05-07   |
| 1624 | [DuckSounds31@aol.com](https://metrics.torproject.org/rs.html#search/family:061370AE41C1084B2910EB0522C8B2DB1C2CB96E)                                                 |            0.01  |      0.02 |       0    |         4 | 2018-01-31   |
| 1625 | [Random Person &lt;nobody AT example dot com&gt;](https://metrics.torproject.org/rs.html#details/09DEA9A672FDEF38CE01E3F453E7D7CD0707E7C6)                            |            0.01  |      0    |       0    |         1 | 2019-11-29   |
| 1626 | [0B9BD710](https://metrics.torproject.org/rs.html#details/0B9BD7107A528F70A2DA115406C7A89B1C5E483F)                                                                   |            0.01  |      0    |       0    |         1 | 2020-07-05   |
| 1627 | [vlad at vlads dot me](https://metrics.torproject.org/rs.html#search/family:0BF606DE836D4C794CAFF7CA78720F8C87660998)                                                 |            0.01  |      0    |       0.01 |         2 | 2018-09-01   |
| 1628 | [borisich76@pm.me](https://metrics.torproject.org/rs.html#search/family:0C0388BC552D7AC903F49390A40244FD3FFF44A2)                                                     |            0.01  |      0    |       0    |         2 | 2018-03-22   |
| 1629 | [torrelay182365 torrelay182365@protonmail.ch](https://metrics.torproject.org/rs.html#details/0C2781011D61CCB009459B51158DA6328BA3DB3B)                                |            0.01  |      0    |       0    |         1 | 2020-01-21   |
| 1630 | [0D9A1C95](https://metrics.torproject.org/rs.html#details/0D9A1C95DA5D9FF223DF14EF36CB1FC72DEF3925)                                                                   |            0.01  |      0    |       0    |         1 | 2020-06-15   |
| 1631 | [halloanjedendenichkenne@gmail.com](https://metrics.torproject.org/rs.html#details/10231E08F19C03D5A2FE3AAD03D863ABDE2081BC)                                          |            0.01  |      0    |       0.01 |         1 | 2017-10-12   |
| 1632 | [11D3EB91](https://metrics.torproject.org/rs.html#details/11D3EB91761414F94F3C6BDF8E4875D5E6B783AF)                                                                   |            0.01  |      0    |       0    |         1 | 2020-05-20   |
| 1633 | [Ignitus Cryptonanus &lt;cryptonanus AT protonmail dot](https://metrics.torproject.org/rs.html#search/family:1380B3AF22852CCDA1CAEB118A218212F4090B9F)                |            0.01  |      0    |       0    |         2 | 2018-11-09   |
| 1634 | [Michael Garson &lt;tor relay against censorship@tutan](https://metrics.torproject.org/rs.html#details/16F50F2728581FE5CA7AC31F5066DCE8653F996C)                      |            0.01  |      0    |       0.01 |         1 | 2018-05-18   |
| 1635 | [1B3E48D7](https://metrics.torproject.org/rs.html#details/1B3E48D75E7F7E61D1B9BBE24BA15A38B454380D)                                                                   |            0.01  |      0    |       0.01 |         1 | 2018-06-02   |
| 1636 | [tor-operator@your-emailaddress-domain](https://metrics.torproject.org/rs.html#details/1DE8E81240D20D9755B29A8AEA131BE2CD537FB8)                                      |            0.01  |      0    |       0.01 |         1 | 2020-01-01   |
| 1637 | [248E3120](https://metrics.torproject.org/rs.html#details/248E31204B10CBD90B023076ABE7A0F03EE1A781)                                                                   |            0.01  |      0    |       0    |         1 | 2020-02-11   |
| 1638 | [2A2D0831](https://metrics.torproject.org/rs.html#details/2A2D0831DE1A7209C36BF405B1914F6954A5E100)                                                                   |            0.01  |      0    |       0    |         1 | 2020-05-20   |
| 1639 | [Jean Bonbeurre &lt;tor-hiboo AT 0x010c DOT fr&gt;](https://metrics.torproject.org/rs.html#details/2D6C93A2336368D9A5778416FD4DDDD97FF37D40)                          |            0.01  |      0    |       0.01 |         1 | 2016-10-21   |
| 1640 | [we-love-tor-fseE37Cgd@protonmail.com](https://metrics.torproject.org/rs.html#details/2E8E7262E39EF1661CC1173AA0F4731C921975A1)                                       |            0.01  |      0    |       0.01 |         1 | 2019-10-13   |
| 1641 | [0x4C1A3F3AD66CDB09422ACA88F57DCEA645A2428E Julia G](https://metrics.torproject.org/rs.html#search/family:32FE059640DC5442FA510262A87B26D91D873F10)                   |            0.01  |      0    |       0.01 |         2 | 2020-02-19   |
| 1642 | [34DF8443](https://metrics.torproject.org/rs.html#details/34DF8443F6ACD1A543AAA10A7621A389E31A4422)                                                                   |            0.01  |      0    |       0.01 |         1 | 2016-04-08   |
| 1643 | [tor-relay@runbox.com](https://metrics.torproject.org/rs.html#details/35DA04A92634AF2392CBA6AF158E00B5589A1CFA)                                                       |            0.01  |      0    |       0.01 |         1 | 2019-07-05   |
| 1644 | [36E23D7F](https://metrics.torproject.org/rs.html#details/36E23D7FED4DC2B0E2B32F8919A089EB92126262)                                                                   |            0.01  |      0    |       0    |         1 | 2020-01-13   |
| 1645 | [torjoohorg at protonmail.com](https://metrics.torproject.org/rs.html#details/372A38794527887333B52ED1D707609D808C0659)                                               |            0.01  |      0    |       0.01 |         1 | 2018-12-01   |
| 1646 | [c0by at 127001 dot ovh](https://metrics.torproject.org/rs.html#search/family:3782F48481045AA7247913637EACE9E7225CF14D)                                               |            0.01  |      0    |       0.01 |         2 | 2019-12-13   |
| 1647 | [390142CB](https://metrics.torproject.org/rs.html#details/390142CBD75401F37E8A77353004A05EB35B8801)                                                                   |            0.01  |      0    |       0    |         1 | 2020-08-07   |
| 1648 | [Privacy Services &lt;abuse at privacy svcs . net&gt; BTC](https://metrics.torproject.org/rs.html#search/family:3FA04DAFB39C8C2D3BB3568C4B7F84194691D9CB)             |            0.01  |      0.03 |       0    |         2 | 2019-08-09   |
| 1649 | [40319366](https://metrics.torproject.org/rs.html#details/403193660D0B53E0F505B160DF58D94D5BC53EAA)                                                                   |            0.01  |      0    |       0    |         1 | 2020-07-06   |
| 1650 | [44DC65D8](https://metrics.torproject.org/rs.html#details/44DC65D8E8D70553214F19FB2DF988845F12508D)                                                                   |            0.01  |      0    |       0.01 |         1 | 2020-07-05   |
| 1651 | [az3bucjrak5z9of](https://metrics.torproject.org/rs.html#details/474648D2DFC1C060A5CA74C8A5976807B7FB5FE0)                                                            |            0.01  |      0    |       0.01 |         1 | 2019-10-08   |
| 1652 | [4B05F4D6](https://metrics.torproject.org/rs.html#details/4B05F4D62E83662D0AAB6C2B35338130326B71A2)                                                                   |            0.01  |      0    |       0.01 |         1 | 2019-12-26   |
| 1653 | [Nicholas Weaver &lt;nweaver@icsi.berkeley.edu&gt;](https://metrics.torproject.org/rs.html#details/4ECBF37E4953F48AA02CA30AE929789218B07C80)                          |            0.01  |      0    |       0    |         1 | 2018-01-09   |
| 1654 | [508773E7](https://metrics.torproject.org/rs.html#details/508773E7A34F3BE17DD0372446798FACB8BF1EAA)                                                                   |            0.01  |      0    |       0    |         1 | 2020-05-06   |
| 1655 | [FreeMirror.org](https://metrics.torproject.org/rs.html#details/622842AE5ECFF0809B4C986D52CA75C349ED11E8)                                                             |            0.01  |      0    |       0.01 |         1 | 2018-10-04   |
| 1656 | [dmitri @bk.ru](https://metrics.torproject.org/rs.html#search/family:62CD9D19F8DD8F058131F90EFA99C55DB6F1BDB8)                                                        |            0.01  |      0    |       0.01 |         3 | 2018-07-09   |
| 1657 | [nobody@domain.com](https://metrics.torproject.org/rs.html#details/64E1231D87844BB5861A9D3ED4FDDF93B4A76704)                                                          |            0.01  |      0    |       0.01 |         1 | 2019-11-30   |
| 1658 | [Hasan Berkay Cagir &lt;domainmanager.tr AT gmail dot](https://metrics.torproject.org/rs.html#details/651A05E6651DDA283B85223303A01066B1FFAEF8)                       |            0.01  |      0    |       0.01 |         1 | 2020-04-29   |
| 1659 | [67216AFB](https://metrics.torproject.org/rs.html#details/67216AFBC0CE043F2D19B6BA6BE9E448D2A91F6D)                                                                   |            0.01  |      0    |       0    |         1 | 2020-07-02   |
| 1660 | [carlo.cs@web.de](https://metrics.torproject.org/rs.html#details/6E3B4821305D96F167C392DBE5A13240D6CCE024)                                                            |            0.01  |      0    |       0    |         1 | 2020-06-24   |
| 1661 | [Jeff Teitel &lt;jeff@teitel.net&gt;](https://metrics.torproject.org/rs.html#details/76959901386E8C908F50235D9894007886B67C2E)                                        |            0.01  |      0.03 |       0    |         1 | 2019-12-23   |
| 1662 | [7997C3FC](https://metrics.torproject.org/rs.html#details/7997C3FC88B02A2C6FEF96C5F5B5C50DD7DA2E2C)                                                                   |            0.01  |      0    |       0.01 |         1 | 2020-07-31   |
| 1663 | [0xCECED044 Mark Grocock &lt;mark AT grocock dot me do](https://metrics.torproject.org/rs.html#details/79B39F8D53DACC9A63975FBC346301D8D0D36034)                      |            0.01  |      0    |       0.01 |         1 | 2015-09-12   |
| 1664 | [7B2904FE](https://metrics.torproject.org/rs.html#details/7B2904FE8AA12E45EA3D65658ED8CECA4A51F7F8)                                                                   |            0.01  |      0    |       0.01 |         1 | 2020-01-24   |
| 1665 | [Random Person &lt;nobody AT pkholm com&gt;](https://metrics.torproject.org/rs.html#details/7B6B2AA9E319A1883774A418E6F51E641E4B434A)                                 |            0.01  |      0.03 |       0    |         1 | 2015-04-24   |
| 1666 | [Tor Manager &lt;tor@ibiblio.org&gt;](https://metrics.torproject.org/rs.html#search/family:7C0AA4E3B73E407E9F5FEB1912F8BE26D8AA124D)                                  |            0.01  |      0.03 |       0    |         2 | 2014-04-08   |
| 1667 | [853E2DF3](https://metrics.torproject.org/rs.html#details/853E2DF3997D6215ACBB86D53E5630669961A39A)                                                                   |            0.01  |      0    |       0.01 |         1 | 2020-06-24   |
| 1668 | [878D48A6](https://metrics.torproject.org/rs.html#details/878D48A6536DF28BC0F13B730DC6A957931D645D)                                                                   |            0.01  |      0.03 |       0    |         1 | 2020-06-24   |
| 1669 | [admin at faentadeg dot net tor-relay.co](https://metrics.torproject.org/rs.html#details/88A6BA024C1B7016CF993095DAA0B0659A9173D4)                                    |            0.01  |      0    |       0    |         1 | 2020-05-08   |
| 1670 | [916BE57F](https://metrics.torproject.org/rs.html#details/916BE57F7F1C4171E5F3D8957B8189FF11B4B45F)                                                                   |            0.01  |      0    |       0    |         1 | 2020-05-22   |
| 1671 | [93CD4696](https://metrics.torproject.org/rs.html#details/93CD469673F772CBF4DC3550580D3D48C8D08E8A)                                                                   |            0.01  |      0    |       0    |         1 | 2020-06-28   |
| 1672 | [0xCAE674B711CC9C78 You must &lt;Found Key at first&gt;](https://metrics.torproject.org/rs.html#details/9772EFB535397C942C3AB8804FB35CFFAD012438)                     |            0.01  |      0    |       0    |         1 | 2014-08-29   |
| 1673 | [9849137C](https://metrics.torproject.org/rs.html#details/9849137C5596CE64F09D7710ACE8175F59DEA914)                                                                   |            0.01  |      0    |       0    |         1 | 2020-05-14   |
| 1674 | [0xEDF962D7 Init6 Consulting &lt;admin AT init6 DOT eu](https://metrics.torproject.org/rs.html#details/A22B1C2EF2255987F8AB8AA0B1A8E23F5023EEB8)                      |            0.01  |      0    |       0.01 |         1 | 2017-06-16   |
| 1675 | [A231513B](https://metrics.torproject.org/rs.html#details/A231513B758330E6E6DB18F5B6EC6DAAA406C31D)                                                                   |            0.01  |      0    |       0.01 |         1 | 2020-07-10   |
| 1676 | [A25F6BDE](https://metrics.torproject.org/rs.html#details/A25F6BDE6E5E45555E2FCCC4F50460A65544D61F)                                                                   |            0.01  |      0    |       0.01 |         1 | 2017-02-05   |
| 1677 | [A64BD6DA](https://metrics.torproject.org/rs.html#details/A64BD6DA33D870F3807C5775DEA23F6EE32289B3)                                                                   |            0.01  |      0    |       0.01 |         1 | 2020-02-13   |
| 1678 | [George Shammas &lt;tor@shamm.as&gt;](https://metrics.torproject.org/rs.html#details/ABF3D28988AE83BE5B967FACB370E909215F68D7)                                        |            0.01  |      0    |       0.01 |         1 | 2015-08-26   |
| 1679 | [aqualol@protonmail.com](https://metrics.torproject.org/rs.html#details/AC75BB0CC3E5CACA5A61972EC294B9F5C6A7EE61)                                                     |            0.01  |      0    |       0.01 |         1 | 2019-11-12   |
| 1680 | [B6E33C39](https://metrics.torproject.org/rs.html#details/B6E33C39C1C94E582CBB8C24CCE351F2129807C6)                                                                   |            0.01  |      0    |       0.01 |         1 | 2017-01-27   |
| 1681 | [B7B5FC9C](https://metrics.torproject.org/rs.html#details/B7B5FC9C533A3D08A2888E5226D11C7D0506B572)                                                                   |            0.01  |      0    |       0    |         1 | 2020-06-16   |
| 1682 | [Anon g774i12a2@protonmail.com](https://metrics.torproject.org/rs.html#details/BCE2851120595E76E31645633F5FF4771D2097BD)                                              |            0.01  |      0.03 |       0    |         1 | 2019-06-30   |
| 1683 | [andiziegler at hotmail dot com](https://metrics.torproject.org/rs.html#details/BDD94BBC7D41447144816E2DD3150C3BF9D6D941)                                             |            0.01  |      0    |       0.01 |         1 | 2019-11-04   |
| 1684 | [avanix &lt;seguro AT avanix DOT es&gt; avanix &lt;info AT a](https://metrics.torproject.org/rs.html#details/C422F88699C18A4F299D834391B15F07DBE60625)                |            0.01  |      0    |       0    |         1 | 2016-03-13   |
| 1685 | [C6B32B0D](https://metrics.torproject.org/rs.html#details/C6B32B0DFA81344973265E08D3C352B5C16AAEAA)                                                                   |            0.01  |      0    |       0    |         1 | 2020-05-26   |
| 1686 | [CBFE5D82](https://metrics.torproject.org/rs.html#details/CBFE5D82189D932F62346729CD4C6F66D4B44EE6)                                                                   |            0.01  |      0    |       0    |         1 | 2020-07-08   |
| 1687 | [CC1BDE73](https://metrics.torproject.org/rs.html#details/CC1BDE73D48DEF3202C688A158D0718C885360D4)                                                                   |            0.01  |      0    |       0.01 |         1 | 2019-06-23   |
| 1688 | [CD249CC1](https://metrics.torproject.org/rs.html#details/CD249CC13B6ADD3426D603B9ED5B51FC71B8D728)                                                                   |            0.01  |      0    |       0.01 |         1 | 2017-12-19   |
| 1689 | [CE58CF66](https://metrics.torproject.org/rs.html#details/CE58CF666F209857502FCEAF1CB52F638AFFBD63)                                                                   |            0.01  |      0    |       0.01 |         1 | 2016-10-25   |
| 1690 | [&lt;0x1337f AT pm dot me&gt;](https://metrics.torproject.org/rs.html#details/CFA45A4739FBE477D8C6500834B59F41A749A294)                                               |            0.01  |      0    |       0.01 |         1 | 2018-08-04   |
| 1691 | [CLTrustGlobal &lt;SystemsAfrica@Airmail.cc&gt;](https://metrics.torproject.org/rs.html#details/D1295B78CA5D767BEADE57206AE629CC7D62F2DD)                             |            0.01  |      0.03 |       0    |         1 | 2020-06-29   |
| 1692 | [hsalc00 at protonmail dot com](https://metrics.torproject.org/rs.html#details/D6ADA048980EB4314990D7F2BB40B848D605F985)                                              |            0.01  |      0    |       0.01 |         1 | 2020-05-20   |
| 1693 | [Tor-Team &lt;tor at xcv d0t vc&gt;](https://metrics.torproject.org/rs.html#details/DE74E8C4F3CF0FBBCB7E761BB3072050D1D4DD88)                                         |            0.01  |      0    |       0.01 |         1 | 2016-11-22   |
| 1694 | [E9249059](https://metrics.torproject.org/rs.html#details/E924905923862AA65C5C3EBA53100C54AAFD63AE)                                                                   |            0.01  |      0    |       0    |         1 | 2020-05-25   |
| 1695 | [EAD55050](https://metrics.torproject.org/rs.html#details/EAD55050858426172B16017918BB21349ACEA913)                                                                   |            0.01  |      0    |       0.01 |         1 | 2020-07-28   |
| 1696 | [BTC Donations: 3R1DzBE9oB7QrefEjt5fNPkhSRovJ2yKTm](https://metrics.torproject.org/rs.html#details/EBB799FADD615E93CA97BE5583E5EB97DD21E10F)                          |            0.01  |      0    |       0.01 |         1 | 2019-01-14   |
| 1697 | [abuse-tor@lists.kau.se](https://metrics.torproject.org/rs.html#details/EDAF30C58D6CCF359EA062C668C7180A17076440)                                                     |            0.01  |      0    |       0.01 |         1 | 2019-08-12   |
| 1698 | [EDB9C65B](https://metrics.torproject.org/rs.html#details/EDB9C65B939940EC5E9DA800EE1574F1D68042B4)                                                                   |            0.01  |      0    |       0.01 |         1 | 2019-01-17   |
| 1699 | [none](https://metrics.torproject.org/rs.html#details/EDC9D832FBEAF949F610D3F6A55537291B4E8F26)                                                                       |            0.01  |      0    |       0.01 |         1 | 2020-03-03   |
| 1700 | [EF09163E](https://metrics.torproject.org/rs.html#details/EF09163EC3F03C2F63A865BBBF1CE5642C6595A3)                                                                   |            0.01  |      0    |       0.01 |         1 | 2018-01-04   |
| 1701 | [oyvinds@everdot.org](https://metrics.torproject.org/rs.html#details/F0EF52BEE400B27430DCA9D144FA0C3DE0099FEC)                                                        |            0.01  |      0    |       0    |         1 | 2016-09-16   |
| 1702 | [TorNode &lt;tornode AT parkbenchindustries dot com&gt; -](https://metrics.torproject.org/rs.html#details/F10BDE279AE71515DDCCCC61DC19AC8765F8A3CC)                   |            0.01  |      0    |       0.01 |         1 | 2014-07-03   |
| 1703 | [F4B855BC](https://metrics.torproject.org/rs.html#details/F4B855BCDC8E29075B0A0D7324488BA7D7A04629)                                                                   |            0.01  |      0    |       0    |         1 | 2019-12-19   |
| 1704 | [F4FB9A80](https://metrics.torproject.org/rs.html#details/F4FB9A80308AE71CA8057F4158DD6B3C8EE375F9)                                                                   |            0.01  |      0    |       0.01 |         1 | 2017-01-23   |
| 1705 | [F8703BCB](https://metrics.torproject.org/rs.html#details/F8703BCB4FD2BBD1E4F93538B802A09AA3392E6B)                                                                   |            0.01  |      0    |       0    |         1 | 2020-06-07   |
| 1706 | [FACC9EB2](https://metrics.torproject.org/rs.html#details/FACC9EB242F4FDA0BD6508CCB86DABCE9E84677F)                                                                   |            0.01  |      0    |       0.01 |         1 | 2019-02-25   |
| 1707 | [FC4D0340](https://metrics.torproject.org/rs.html#details/FC4D03403ECD90463198B9F2F81E0B37ED7AFE1D)                                                                   |            0.01  |      0    |       0.01 |         1 | 2020-05-29   |
| 1708 | [FD127D10](https://metrics.torproject.org/rs.html#details/FD127D1014ED3D36AFE50558A88BD5E8DB34A645)                                                                   |            0.01  |      0    |       0.01 |         1 | 2020-05-28   |
| 1709 | [FF345A8E](https://metrics.torproject.org/rs.html#details/FF345A8E37E7359ACFA3ECCCEFD94A34F2AA999F)                                                                   |            0.01  |      0    |       0    |         1 | 2020-07-31   |
| 1710 | [MirrorVenom13@yandex.ru](https://metrics.torproject.org/rs.html#details/035396269F6D00503D1765DF36ED1B203A028D74)                                                    |            0.009 |      0    |       0.01 |         1 | 2020-03-16   |
| 1711 | [038C30D2](https://metrics.torproject.org/rs.html#details/038C30D2AD053147C91EFB1291527ED621D7D1B1)                                                                   |            0.009 |      0.03 |       0    |         1 | 2019-03-04   |
| 1712 | [03F24BAF](https://metrics.torproject.org/rs.html#details/03F24BAFD1C1E1BD4786801635E41A28A41390B7)                                                                   |            0.009 |      0    |       0.01 |         1 | 2020-05-26   |
| 1713 | [0xE8AC87A89B24A670 Kiril Vladimiroff &lt;kiril@vladim](https://metrics.torproject.org/rs.html#details/07B8FC5B66719C355FABF84B4F5E0131E127DF01)                      |            0.009 |      0    |       0.01 |         1 | 2016-03-25   |
| 1714 | [07C3EBBE](https://metrics.torproject.org/rs.html#details/07C3EBBE41DF9FE8551DF69642FEBA70E954DC0F)                                                                   |            0.009 |      0    |       0.01 |         1 | 2019-07-03   |
| 1715 | [Random Person &lt;sexample@example.net&gt;](https://metrics.torproject.org/rs.html#details/0ABB63CC809DE89A0A71A9BA8751C4AB5C2DC3C3)                                 |            0.009 |      0    |       0.01 |         1 | 2020-02-21   |
| 1716 | [0C7FB0E5](https://metrics.torproject.org/rs.html#details/0C7FB0E5E424A6BF8FC579747D1FF3E44F3760EB)                                                                   |            0.009 |      0    |       0    |         1 | 2020-05-13   |
| 1717 | [Marek Suppa &lt;andrej at-this-domain xlc-team and-do](https://metrics.torproject.org/rs.html#details/0F85E6DB0E4A3B6FDDF7C9452C9B5D089B11979D)                      |            0.009 |      0    |       0.01 |         1 | 2015-08-21   |
| 1718 | [jens &lt;jens@chaox.net&gt; - 11XxuJRkNp3CrxwP6DGdHwEa6U](https://metrics.torproject.org/rs.html#details/1099983E2C5C3ECDAD0B7D5AABD2AC6BF2CBBF70)                   |            0.009 |      0    |       0.01 |         1 | 2014-02-26   |
| 1719 | [comments at worldofmatthew dot com](https://metrics.torproject.org/rs.html#details/10CB8AE07547A341A6CE7331EDC11518D6184DF7)                                         |            0.009 |      0    |       0.01 |         1 | 2020-08-01   |
| 1720 | [11B8E678](https://metrics.torproject.org/rs.html#details/11B8E67878A025AC659A42091604E5DFD2D73E0B)                                                                   |            0.009 |      0    |       0    |         1 | 2020-07-18   |
| 1721 | [amuse &lt;tor-amuse AT foofus dot com&gt;](https://metrics.torproject.org/rs.html#details/18C4914DC93A448498B42069CBC9AE821C7B8F5E)                                  |            0.009 |      0.03 |       0    |         1 | 2019-01-25   |
| 1722 | [1D2FAA71](https://metrics.torproject.org/rs.html#details/1D2FAA71AFBB0AE58B47DF9C4570668D3EB61A9F)                                                                   |            0.009 |      0.03 |       0    |         1 | 2020-05-14   |
| 1723 | [ERSS-Enabled:&lt;https://bitmessage.ch/TOR/&gt;](https://metrics.torproject.org/rs.html#details/1D4B555184EC12F758BC8BBB4C0983AFBC25D6F5)                            |            0.009 |      0    |       0.01 |         1 | 2020-08-04   |
| 1724 | [1E5618C0](https://metrics.torproject.org/rs.html#details/1E5618C079D74CF9AE0C5370DE4C6E1AFD5C0B39)                                                                   |            0.009 |      0    |       0.01 |         1 | 2015-12-08   |
| 1725 | [florentin aatt rochet ddoott be; LTC: LhRqJZu6U87B](https://metrics.torproject.org/rs.html#details/255CF8CC68137449DEBD443797AB3D851E3065B2)                         |            0.009 |      0.03 |       0    |         1 | 2019-05-05   |
| 1726 | [2564E23A](https://metrics.torproject.org/rs.html#details/2564E23A8053281DF683AD3D77AE28F11C420E9A)                                                                   |            0.009 |      0    |       0    |         1 | 2020-06-16   |
| 1727 | [283F225B](https://metrics.torproject.org/rs.html#details/283F225B4241DD7F0E2BB85FC7A95868D69AFEC5)                                                                   |            0.009 |      0    |       0    |         1 | 2020-08-09   |
| 1728 | [BlueDucks@protonmail.com](https://metrics.torproject.org/rs.html#details/296DD68C9017BF7FC7CEC9ACB43A6FAA942408FF)                                                   |            0.009 |      0    |       0.01 |         1 | 2020-05-18   |
| 1729 | [stephan dot schmidt at skynet-london dot co dot uk](https://metrics.torproject.org/rs.html#details/2AF23516A65C6FF674D33D81480253902388FDBC)                         |            0.009 |      0    |       0.01 |         1 | 2020-07-11   |
| 1730 | [2F2E6C30](https://metrics.torproject.org/rs.html#details/2F2E6C30B8A30DCB0C541E931F00BCF0023DF146)                                                                   |            0.009 |      0    |       0    |         1 | 2020-07-01   |
| 1731 | [310056E3](https://metrics.torproject.org/rs.html#details/310056E3539B2EE9F227B0D230B0835554051475)                                                                   |            0.009 |      0    |       0.01 |         1 | 2017-06-02   |
| 1732 | [chapolin10 at hotmail com tor-relay.co](https://metrics.torproject.org/rs.html#search/family:316F5BF8EC15CC961E54CC30781A63345D054DF8)                               |            0.009 |      0    |       0    |         2 | 2020-08-06   |
| 1733 | [320DB7BE](https://metrics.torproject.org/rs.html#details/320DB7BEA72C058BA2EEF098BF1AEFBA29371BE0)                                                                   |            0.009 |      0    |       0.01 |         1 | 2020-05-26   |
| 1734 | [NixNet Tor Admin &lt;tor-admin AT nixnet dot services](https://metrics.torproject.org/rs.html#search/family:324E13FD795713BDD6E8B4DF02438742CA1FDBF1)                |            0.009 |      0.03 |       0    |         2 | 2019-07-13   |
| 1735 | [3A4F8A20](https://metrics.torproject.org/rs.html#details/3A4F8A201036D3F57A0453CA440E20793775EDB9)                                                                   |            0.009 |      0    |       0    |         1 | 2020-06-20   |
| 1736 | [2048R/B8B5E809 Krishna E. Bera &lt;keb at cyblings do](https://metrics.torproject.org/rs.html#details/3A94EFBF4A220B35A92D0A5B4A80D6324C3C306A)                      |            0.009 |      0    |       0.01 |         1 | 2019-07-02   |
| 1737 | [4352D58B](https://metrics.torproject.org/rs.html#details/4352D58B2641E8C1787750EFD3A07A88224967AC)                                                                   |            0.009 |      0    |       0.01 |         1 | 2019-04-18   |
| 1738 | [44785E74](https://metrics.torproject.org/rs.html#details/44785E74F67FCABDCAF054486950B35140B9EE6E)                                                                   |            0.009 |      0    |       0    |         1 | 2020-07-09   |
| 1739 | [450AB46A](https://metrics.torproject.org/rs.html#details/450AB46ADFD541B3905A5C6140BC53EB8C68C9A5)                                                                   |            0.009 |      0    |       0.01 |         1 | 2019-11-01   |
| 1740 | [tor manager@autistici.org](https://metrics.torproject.org/rs.html#details/4825FABA5D4A44E6DFC307544EF15F15FB37FA49)                                                  |            0.009 |      0    |       0.01 |         1 | 2020-05-20   |
| 1741 | [49C74AB9](https://metrics.torproject.org/rs.html#details/49C74AB9AD0357F39D268BAB3B5B20FD4765F226)                                                                   |            0.009 |      0    |       0    |         1 | 2020-06-12   |
| 1742 | [4BAAC40F](https://metrics.torproject.org/rs.html#details/4BAAC40FEDF56894FB4704846E858E2F20BA6898)                                                                   |            0.009 |      0.03 |       0    |         1 | 2020-03-27   |
| 1743 | [Reimu Hakurei &lt;purjosipuli AT airmail dot cc&gt;](https://metrics.torproject.org/rs.html#details/5FD0ECB853CF3E97F6F77787C3B6D7ED31F591FF)                        |            0.009 |      0    |       0.01 |         1 | 2019-09-03   |
| 1744 | [6040CA91](https://metrics.torproject.org/rs.html#details/6040CA9121ABD727035E3E3ACD97CE0C7BFD449B)                                                                   |            0.009 |      0    |       0.01 |         1 | 2020-07-25   |
| 1745 | [0xB83A02ED Randy Bush &lt;randy AT psg dot com&gt;](https://metrics.torproject.org/rs.html#details/60E4C5E306D2DB22890EE24A09F9B6C30AF396A8)                         |            0.009 |      0    |       0.01 |         1 | 2013-08-01   |
| 1746 | [bg271828@yahoo.com](https://metrics.torproject.org/rs.html#details/6111C6005AB56498BE5E35666B2522CEBE17D14E)                                                         |            0.009 |      0    |       0.01 |         1 | 2020-07-30   |
| 1747 | [63E094A5](https://metrics.torproject.org/rs.html#details/63E094A5447799673C1141134058F948074EAA63)                                                                   |            0.009 |      0.03 |       0    |         1 | 2020-03-26   |
| 1748 | [64FC9B38](https://metrics.torproject.org/rs.html#details/64FC9B3852BA7EC74E79BD4099D850C338009E77)                                                                   |            0.009 |      0    |       0.01 |         1 | 2019-07-02   |
| 1749 | [hwds &lt;hwds AT example dot com&gt;](https://metrics.torproject.org/rs.html#details/656347EBA74F6320B85192EE22F805CF50098711)                                       |            0.009 |      0    |       0    |         1 | 2017-01-25   |
| 1750 | [6600C560](https://metrics.torproject.org/rs.html#details/6600C560E7E2A7601F6F4B019942C9E4D47872CE)                                                                   |            0.009 |      0    |       0.01 |         1 | 2020-07-10   |
| 1751 | [0xFFFFFFFF ghostbuster &lt;torserver AT xs4all dot nl](https://metrics.torproject.org/rs.html#search/family:6B9D965C6149D09DF970C1D086AC8F575643F587)                |            0.009 |      0    |       0    |         2 | 2020-02-14   |
| 1752 | [6D0D610D](https://metrics.torproject.org/rs.html#details/6D0D610D63D33584308CA672484DA699FF26A2A3)                                                                   |            0.009 |      0    |       0.01 |         1 | 2020-04-30   |
| 1753 | [ABUSE CONTACT &lt;abuse at sabotage dot org&gt;](https://metrics.torproject.org/rs.html#search/family:74C0C2705DB1192C03F19F7CD1BB234843B1A81F)                      |            0.009 |      0.03 |       0    |         2 | 2007-10-27   |
| 1754 | [774A2C5A](https://metrics.torproject.org/rs.html#details/774A2C5AC5D005236C7F90062406C06F4D67666F)                                                                   |            0.009 |      0    |       0    |         1 | 2020-07-16   |
| 1755 | [kennethdevel@gmail.com](https://metrics.torproject.org/rs.html#details/776FCB8F73F8D84407F5AF2460A75F9EEC982EB3)                                                     |            0.009 |      0    |       0.01 |         1 | 2019-07-23   |
| 1756 | [77B29067](https://metrics.torproject.org/rs.html#details/77B29067C081C57F939D4A5D79D54A25B9D430F4)                                                                   |            0.009 |      0    |       0    |         1 | 2020-05-13   |
| 1757 | [793FB3AA](https://metrics.torproject.org/rs.html#details/793FB3AA63B5EFA9E86E33D6E3D460D2961E1752)                                                                   |            0.009 |      0    |       0    |         1 | 2019-10-17   |
| 1758 | [7B28971D](https://metrics.torproject.org/rs.html#details/7B28971D4A29995784E3066B9D87E42E9C685F3A)                                                                   |            0.009 |      0    |       0.01 |         1 | 2014-04-09   |
| 1759 | [0xFFFFFFFF Random Person &lt;nobody AT example dot co](https://metrics.torproject.org/rs.html#details/7CA53C34D8C70376A1638EE7A934A7CB03996BE2)                      |            0.009 |      0    |       0    |         1 | 2018-08-10   |
| 1760 | [&lt;douke AT vfemail dot net&gt;](https://metrics.torproject.org/rs.html#details/7D41FED58481A0E594C642E74176C811778D91A6)                                           |            0.009 |      0    |       0.01 |         1 | 2015-01-02   |
| 1761 | [80F89CB4](https://metrics.torproject.org/rs.html#details/80F89CB42A1257A6145C1B1D6463C795CB99A6A4)                                                                   |            0.009 |      0    |       0.01 |         1 | 2020-03-30   |
| 1762 | [836F57D4](https://metrics.torproject.org/rs.html#details/836F57D4443C32F5C41179B7522680FD859E45F1)                                                                   |            0.009 |      0    |       0    |         1 | 2020-06-29   |
| 1763 | [841DE1E0](https://metrics.torproject.org/rs.html#details/841DE1E065BCA8C1EBDC4A7140646F47A6257BD8)                                                                   |            0.009 |      0    |       0.01 |         1 | 2018-08-19   |
| 1764 | [84D164A9](https://metrics.torproject.org/rs.html#details/84D164A906CD165C77F6A49C97E2F4CA17C3AB3F)                                                                   |            0.009 |      0    |       0    |         1 | 2020-03-22   |
| 1765 | [me@koshaq.net](https://metrics.torproject.org/rs.html#details/88A18960AF7735FD4489374AC411FBBFE9743A20)                                                              |            0.009 |      0    |       0    |         1 | 2017-09-06   |
| 1766 | [shebangs@yopmail.fr](https://metrics.torproject.org/rs.html#details/8A136F5D0DACBBB6D8537DA4A806C44EF7E9037B)                                                        |            0.009 |      0    |       0.01 |         1 | 2020-06-05   |
| 1767 | [209B8043FA216E9D0AC6A92B7C831049DAC7268C zwiebelku](https://metrics.torproject.org/rs.html#details/8A4C8FC6D63365E04ECB4B18EF61A9A52936E8AE)                         |            0.009 |      0    |       0.01 |         1 | 2019-01-07   |
| 1768 | [8B1CC76D](https://metrics.torproject.org/rs.html#details/8B1CC76D6D1370A67263628D4CBC01B62903D0BF)                                                                   |            0.009 |      0    |       0.01 |         1 | 2018-02-06   |
| 1769 | [8F16229D](https://metrics.torproject.org/rs.html#details/8F16229D5425774DCA566D7737596178153DB838)                                                                   |            0.009 |      0.03 |       0    |         1 | 2020-03-30   |
| 1770 | [928C991C](https://metrics.torproject.org/rs.html#details/928C991C655BF10189FF084C79A41772AE6155C6)                                                                   |            0.009 |      0    |       0    |         1 | 2020-06-17   |
| 1771 | [0x103751DCCCA74E6432805BBDEDAF57CA46025B35 Dmitry](https://metrics.torproject.org/rs.html#details/93C1E14CD600CF51B117DE736741E7400A069AFC)                          |            0.009 |      0    |       0.01 |         1 | 2017-06-27   |
| 1772 | [971C3998](https://metrics.torproject.org/rs.html#details/971C399838EAAD3B5E0D5278C1FF7BC5508C6485)                                                                   |            0.009 |      0    |       0    |         1 | 2020-06-30   |
| 1773 | [Something Something &lt;nobody AT example dot com&gt;](https://metrics.torproject.org/rs.html#details/9781A79A0F156D08302FB8EB8B5A1BB08B60F156)                      |            0.009 |      0    |       0.01 |         1 | 2020-08-03   |
| 1774 | [987D0706](https://metrics.torproject.org/rs.html#details/987D0706D42070F1E2142A9FCCB56B3887808D34)                                                                   |            0.009 |      0    |       0.01 |         1 | 2018-01-04   |
| 1775 | [Anon g774i12a2@protonmail.com](https://metrics.torproject.org/rs.html#details/98BC846FB83D1D4AED4FDF0F5B85163263711D9F)                                              |            0.009 |      0.03 |       0    |         1 | 2020-02-26   |
| 1776 | [rendelllocke@protonmail.com](https://metrics.torproject.org/rs.html#details/9B7906C1F5963F9EA57EC6A8C9DE724C4928AF73)                                                |            0.009 |      0    |       0.01 |         1 | 2020-07-29   |
| 1777 | [9E0BF3D6](https://metrics.torproject.org/rs.html#details/9E0BF3D684F2F74A87733C52FC130AB810899170)                                                                   |            0.009 |      0    |       0    |         1 | 2020-06-15   |
| 1778 | [webmeister &lt;tor4.20.webmeisterATspamgourmet.com&gt;](https://metrics.torproject.org/rs.html#search/family:9F7D6E6420183C2B76D3CE99624EBC98A21A967E)               |            0.009 |      0    |       0.01 |         2 | 2012-12-14   |
| 1779 | [A1339868](https://metrics.torproject.org/rs.html#details/A1339868DBA5D6B9794A3110D148D69888E9071D)                                                                   |            0.009 |      0    |       0    |         1 | 2020-05-15   |
| 1780 | [omue@posteo.net](https://metrics.torproject.org/rs.html#search/family:A1B2E32E426F700D37DFF14228E1B957A22CF0A4)                                                      |            0.009 |      0    |       0    |         2 | 2016-07-31   |
| 1781 | [giannoug AT-gmail DOt- com](https://metrics.torproject.org/rs.html#search/family:A68097FE97D3065B1A6F4CE7187D753F8B8513F5)                                           |            0.009 |      0    |       0.01 |         2 | 2015-09-20   |
| 1782 | [AB011ACD](https://metrics.torproject.org/rs.html#details/AB011ACDDE6D79F81A88CD9EB63E707D48AE8454)                                                                   |            0.009 |      0    |       0    |         1 | 2020-08-07   |
| 1783 | [relay@stateofduality.de](https://metrics.torproject.org/rs.html#details/AC633C90E126E0BCA96F14ECE5D222B586FA0D56)                                                    |            0.009 |      0    |       0.01 |         1 | 2019-10-05   |
| 1784 | [Tech &lt;c3rax@chaos-system.de&gt;](https://metrics.torproject.org/rs.html#details/AF7B4AA147DD4A42903B8078EB4C34A704D54114)                                         |            0.009 |      0    |       0.01 |         1 | 2020-05-01   |
| 1785 | [Tor Operator &lt;tor at jot23 dot org&gt;](https://metrics.torproject.org/rs.html#search/family:B05B4BB64FFE5373E293D2C008798FBA9C908BB1)                            |            0.009 |      0    |       0    |         2 | 2018-10-29   |
| 1786 | [B1B7C23D](https://metrics.torproject.org/rs.html#details/B1B7C23D771F91C582F8B099602649A363C3091D)                                                                   |            0.009 |      0    |       0    |         1 | 2020-07-17   |
| 1787 | [JX tor at pxa dot dk](https://metrics.torproject.org/rs.html#details/B6D4916A98D99027DA25D42D70D686F0B3663F35)                                                       |            0.009 |      0    |       0.01 |         1 | 2019-05-17   |
| 1788 | [0xA5CBA13E &lt;tor AT d0p1 dot eu&gt; - 19wzjCe4m6YiiAh](https://metrics.torproject.org/rs.html#details/B81B38902BF026BF2591CA2D73B99CEEB03F0869)                    |            0.009 |      0    |       0.01 |         1 | 2016-12-27   |
| 1789 | [afffplex@gmail.com](https://metrics.torproject.org/rs.html#search/family:B86AD9BFF6701DA6D85469C4B7F73381374F98B0)                                                   |            0.009 |      0    |       0.01 |         2 | 2019-12-31   |
| 1790 | [B8F7B162](https://metrics.torproject.org/rs.html#details/B8F7B162963287D2199D075BBAB2C4FB941BB390)                                                                   |            0.009 |      0    |       0.01 |         1 | 2019-05-06   |
| 1791 | [BF29077D](https://metrics.torproject.org/rs.html#details/BF29077D90DD65D8B15B2DFC876D25C76E5057FB)                                                                   |            0.009 |      0    |       0.01 |         1 | 2015-09-10   |
| 1792 | [C130DD91](https://metrics.torproject.org/rs.html#details/C130DD914A8D0E484E68DCC681B434A0BA044D9D)                                                                   |            0.009 |      0    |       0.01 |         1 | 2015-10-30   |
| 1793 | [mydickinabox@trash.com](https://metrics.torproject.org/rs.html#details/C9FAA93525ACE580BDB03ABC662ED2045262BD89)                                                     |            0.009 |      0    |       0.01 |         1 | 2020-05-20   |
| 1794 | [yi.yimail214 AT gmail dot com](https://metrics.torproject.org/rs.html#details/CC651A7620A8129209BF865CA6ECC1F09023DD28)                                              |            0.009 |      0    |       0.01 |         1 | 2018-02-22   |
| 1795 | [Zighinetto &lt;tor -a t- zi ghi netto dot org&gt;](https://metrics.torproject.org/rs.html#details/CDD296D8C38EAA6A94242FCF03293E0D6EC4A0D0)                          |            0.009 |      0    |       0.01 |         1 | 2019-02-22   |
| 1796 | [CEECFBB8](https://metrics.torproject.org/rs.html#details/CEECFBB82FC484051E89719C49DC803F65AABC72)                                                                   |            0.009 |      0    |       0.01 |         1 | 2016-03-07   |
| 1797 | [D1AE7E83](https://metrics.torproject.org/rs.html#details/D1AE7E838DF635EB1367F202B84946D73142CDAD)                                                                   |            0.009 |      0    |       0.01 |         1 | 2019-12-25   |
| 1798 | [D24F1851](https://metrics.torproject.org/rs.html#details/D24F1851779BFE3C982C40ECC9C1EFD344EFDA9B)                                                                   |            0.009 |      0    |       0.01 |         1 | 2020-07-14   |
| 1799 | [riinagalvani at protonmail dot com](https://metrics.torproject.org/rs.html#details/D36ECD4E04E2721D179505E368078233FCECC54B)                                         |            0.009 |      0.03 |       0    |         1 | 2020-08-04   |
| 1800 | [tor@km33235-04.keymachine.de](https://metrics.torproject.org/rs.html#details/D39F2CD90A236F94A61B76616B4873329DA77888)                                               |            0.009 |      0    |       0.01 |         1 | 2017-06-30   |
| 1801 | [D5228FA5](https://metrics.torproject.org/rs.html#details/D5228FA5AA9FDB3825E6F199AFA9F9E6F9526A17)                                                                   |            0.009 |      0.03 |       0    |         1 | 2019-02-27   |
| 1802 | [D87A947A](https://metrics.torproject.org/rs.html#details/D87A947A2405C41208C57D32ED1D0CA2EBE93AF6)                                                                   |            0.009 |      0    |       0    |         1 | 2019-09-01   |
| 1803 | [thetestrelay at protonmail dot com](https://metrics.torproject.org/rs.html#details/D8E8B73CEE4849D6956CF4D4F64A806AC2258FB1)                                         |            0.009 |      0    |       0    |         1 | 2020-08-08   |
| 1804 | [Igor Novgorodov &lt;igor AT novg DOT net&gt;](https://metrics.torproject.org/rs.html#details/D947623B30C9D6E142E7D90FC7368B1A2A4F5045)                               |            0.009 |      0.03 |       0    |         1 | 2019-10-25   |
| 1805 | [s t e v e a t i t e r r o r d o t c o](https://metrics.torproject.org/rs.html#details/DA84D41783BBB6058CB9DF8C90697E8D5EA647C3)                                      |            0.009 |      0    |       0.01 |         1 | 2016-05-30   |
| 1806 | [benoit AT friry DOT net](https://metrics.torproject.org/rs.html#details/DAF0A29144F02A4089A291FC697972A4CB03C8E0)                                                    |            0.009 |      0    |       0.01 |         1 | 2020-06-22   |
| 1807 | [tor@ravion.org](https://metrics.torproject.org/rs.html#details/E05CAC929E391787077066C29461A9D22ECF0809)                                                             |            0.009 |      0    |       0.01 |         1 | 2019-08-06   |
| 1808 | [E16C80C7](https://metrics.torproject.org/rs.html#details/E16C80C7061692FD68846AA922710691F19DBEA9)                                                                   |            0.009 |      0    |       0.01 |         1 | 2019-11-26   |
| 1809 | [E23126C9](https://metrics.torproject.org/rs.html#details/E23126C928D2DED8CC0C0E7BEC578D7C3DAA3145)                                                                   |            0.009 |      0    |       0    |         1 | 2020-05-19   |
| 1810 | [&lt;1a6ee26 a t acknexster. de&gt;](https://metrics.torproject.org/rs.html#details/E5CC82DF823F15F9EEF99F22BFB1F3CC5F5076EF)                                         |            0.009 |      0    |       0.01 |         1 | 2020-07-19   |
| 1811 | [E96C071A](https://metrics.torproject.org/rs.html#details/E96C071A67833C2C93D74F7C84C99148E15181F8)                                                                   |            0.009 |      0    |       0.01 |         1 | 2019-02-27   |
| 1812 | [torpids AT yahoo dot com - 1JYHfzVFVD7n2Sezz3DEHDF](https://metrics.torproject.org/rs.html#details/ECC17C0BA74113FB7A4F58DAF2FF1EE23CE5DF06)                         |            0.009 |      0    |       0.01 |         1 | 2014-05-09   |
| 1813 | [uthinkabuse@gmail.com](https://metrics.torproject.org/rs.html#details/ECE90C4159D916921F7C8DDF4D088AC3808C521D)                                                      |            0.009 |      0.03 |       0    |         1 | 2020-01-23   |
| 1814 | [ED543557](https://metrics.torproject.org/rs.html#details/ED543557E8FEAB6D7F6599DCC9487DE26B851B75)                                                                   |            0.009 |      0    |       0    |         1 | 2020-06-26   |
| 1815 | [tor-node at dont-know-me dot at tor-relay.co](https://metrics.torproject.org/rs.html#details/F090D06DD908C91487F0A65DFFDFB1E4CD664288)                               |            0.009 |      0    |       0.01 |         1 | 2020-01-30   |
| 1816 | [Athoxx &lt;athoxx protonmail com&gt;](https://metrics.torproject.org/rs.html#details/FA5647DE9745BA239C9F34E262512C99605472C9)                                       |            0.009 |      0    |       0.01 |         1 | 2019-08-15   |
| 1817 | [0x2A977668 Joel Purra &lt;mig AT joelpurra dot se&gt;](https://metrics.torproject.org/rs.html#details/FA5F1AB3468F808B2FB05F2155C0481A3532C787)                      |            0.009 |      0    |       0.01 |         1 | 2016-12-20   |
| 1818 | [FA676D74](https://metrics.torproject.org/rs.html#details/FA676D742D3A439157BAA0DD1CB3C54967041043)                                                                   |            0.009 |      0    |       0    |         1 | 2020-08-09   |
| 1819 | [0289A021](https://metrics.torproject.org/rs.html#details/0289A02185EE16A12E8701563F72EAD3EE225B93)                                                                   |            0.008 |      0    |       0    |         1 | 2020-08-07   |
| 1820 | [0298F5D2](https://metrics.torproject.org/rs.html#details/0298F5D2EBBBFCCB17FEF58C2231B4A656A528E5)                                                                   |            0.008 |      0    |       0    |         1 | 2020-05-19   |
| 1821 | [mo.waileis@gmail.com](https://metrics.torproject.org/rs.html#details/03B1B21D72373510E1DEFE2E193932576B157368)                                                       |            0.008 |      0.02 |       0    |         1 | 2020-02-24   |
| 1822 | [03C8B603](https://metrics.torproject.org/rs.html#details/03C8B603AEBEC0AC4C1F73E3B0CC96A02A04D83D)                                                                   |            0.008 |      0    |       0.01 |         1 | 2016-05-18   |
| 1823 | [063276EE](https://metrics.torproject.org/rs.html#details/063276EEBDC004981711A68806EFC6BC335A1D2E)                                                                   |            0.008 |      0.02 |       0    |         1 | 2020-08-02   |
| 1824 | [&lt;megalosreles at protonmail dot com&gt;](https://metrics.torproject.org/rs.html#search/family:067ECF198238BD14B0CFE24899475A53A94E14EC)                           |            0.008 |      0    |       0.01 |         2 | 2019-06-26   |
| 1825 | [0xABCDEF Jeff Backly](https://metrics.torproject.org/rs.html#details/0824D7C7FB117D5C6AC01581FD798E670C37C804)                                                       |            0.008 |      0    |       0.01 |         1 | 2015-02-23   |
| 1826 | [operatorurl:ooni.io pgp:4C15DDA996C6C0CF48BD33096B](https://metrics.torproject.org/rs.html#search/family:09C2AA312AE0DDDF4C5E57CB1BE24158A5408590)                   |            0.008 |      0    |       0.01 |         3 | 2018-07-22   |
| 1827 | [0AB05FC6](https://metrics.torproject.org/rs.html#details/0AB05FC63CF9AC7070C1D89BB1A1189C319E1A92)                                                                   |            0.008 |      0    |       0.01 |         1 | 2017-12-05   |
| 1828 | [Steven S &lt;katsalmovies@gmail.com&gt;](https://metrics.torproject.org/rs.html#details/0BCCF364C4EE7338B6E920E63E951922C85F91F7)                                    |            0.008 |      0    |       0.01 |         1 | 2019-07-15   |
| 1829 | [0CD62346](https://metrics.torproject.org/rs.html#details/0CD62346D1B5CB1648DDA907F818B0DFEA752E88)                                                                   |            0.008 |      0    |       0.01 |         1 | 2020-02-21   |
| 1830 | [0CDCB20F](https://metrics.torproject.org/rs.html#details/0CDCB20FF6800D8AFC90504B85C0551305F2FFE8)                                                                   |            0.008 |      0    |       0    |         1 | 2020-07-20   |
| 1831 | [k0nsl &lt;tor-operator@k0nsl.org&gt;](https://metrics.torproject.org/rs.html#search/family:0E8FD4368083BD7817A42F3ECEDE86DFE3C35958)                                 |            0.008 |      0.02 |       0    |         2 | 2019-12-12   |
| 1832 | [tor@divided-by-zero.eu](https://metrics.torproject.org/rs.html#details/1119A89E729DB65839FB232A1E0F8669B0AE84DF)                                                     |            0.008 |      0    |       0.01 |         1 | 2017-09-18   |
| 1833 | [&lt;nobody AT example dot com&gt;](https://metrics.torproject.org/rs.html#details/1137AB1F84EC2D52DFB1915717F14FF1A10EB392)                                          |            0.008 |      0    |       0.01 |         1 | 2018-11-22   |
| 1834 | [16672A88](https://metrics.torproject.org/rs.html#details/16672A88338BD011B1CAAD8940FBCB09BD20A88E)                                                                   |            0.008 |      0    |       0.01 |         1 | 2018-01-13   |
| 1835 | [18EF6BB5](https://metrics.torproject.org/rs.html#details/18EF6BB5C8C79FD8AF1B9B0DDDCD024C2217A620)                                                                   |            0.008 |      0    |       0    |         1 | 2018-06-24   |
| 1836 | [1AEED3F9](https://metrics.torproject.org/rs.html#details/1AEED3F99DD95D0726AC6CDC6F5E6B20C60FC34D)                                                                   |            0.008 |      0    |       0    |         1 | 2020-06-26   |
| 1837 | [1BB9C60F](https://metrics.torproject.org/rs.html#details/1BB9C60F87A31158D55C2143FC4C4EBCB1682761)                                                                   |            0.008 |      0    |       0    |         1 | 2020-07-06   |
| 1838 | [1FDA0EC4](https://metrics.torproject.org/rs.html#details/1FDA0EC4053C0B9D0DD6640EFF3174747A0EED9D)                                                                   |            0.008 |      0    |       0    |         1 | 2020-05-13   |
| 1839 | [AJderGute &lt;ajdergute at gmail dot com&gt;](https://metrics.torproject.org/rs.html#details/20CE7E9C49A748661E66C747C6E2109CEEAA5705)                               |            0.008 |      0    |       0.01 |         1 | 2019-04-27   |
| 1840 | [21239CC3](https://metrics.torproject.org/rs.html#details/21239CC313A28B3E6CEE48D949BF7787471B1519)                                                                   |            0.008 |      0    |       0.01 |         1 | 2018-01-26   |
| 1841 | [Random Guy gingersnap1270gm@il.net](https://metrics.torproject.org/rs.html#search/family:217E13F9C67379A3D1E0BD664FB9BFB4C47028F4)                                   |            0.008 |      0    |       0    |         2 | 2020-07-03   |
| 1842 | [tor-relay.fastquake@com swap characters](https://metrics.torproject.org/rs.html#details/22E975935BA77EA59A28EA1AA8387F906034FCBE)                                    |            0.008 |      0    |       0.01 |         1 | 2017-10-17   |
| 1843 | [Allanon Tor &lt;tor AT hispa-net dot com&gt;](https://metrics.torproject.org/rs.html#details/274A1DC6210E91827CDF40DC0E95E4A3CA929A08)                               |            0.008 |      0    |       0.01 |         1 | 2020-06-28   |
| 1844 | [listadoiug@horsefucker.org](https://metrics.torproject.org/rs.html#details/27C61AE08EBDD8B26B78992C7647D890269E9E03)                                                 |            0.008 |      0    |       0    |         1 | 2018-11-12   |
| 1845 | [286F22F5](https://metrics.torproject.org/rs.html#details/286F22F5D198AB20C50C65B94A03B52CAE588946)                                                                   |            0.008 |      0    |       0.01 |         1 | 2015-12-22   |
| 1846 | [oopsdidnotchange@config.com](https://metrics.torproject.org/rs.html#details/307B57894BB7F7CFAA516D7A3D64B4722A96465A)                                                |            0.008 |      0    |       0    |         1 | 2020-06-16   |
| 1847 | [3585FD0E](https://metrics.torproject.org/rs.html#details/3585FD0E06C32A8C5C29E15ECE4FB49796133CFA)                                                                   |            0.008 |      0    |       0    |         1 | 2020-07-10   |
| 1848 | [0x5099926F22B853384965D05999F8A72836339390 Nikita](https://metrics.torproject.org/rs.html#details/372082F3E01DE6A6333D30329C6903A19D0E8E87)                          |            0.008 |      0    |       0.01 |         1 | 2014-02-15   |
| 1849 | [Random Person &lt;rasptorpipi AT members dot fsf dot](https://metrics.torproject.org/rs.html#details/37535409102DFFE92F3DAC809E470E62BC27F1DF)                       |            0.008 |      0    |       0.01 |         1 | 2015-06-28   |
| 1850 | [0xE360782B Ludovic &lt;Ludovic@hirlimann.net&gt;](https://metrics.torproject.org/rs.html#details/383EBB4A99479DF9CD8BE5724E09B964F098E1BD)                           |            0.008 |      0    |       0.01 |         1 | 2016-11-30   |
| 1851 | [Random Person &lt;kossunster AT gmail dot com&gt;](https://metrics.torproject.org/rs.html#details/437143A8E2D86B3BEB77B9ECD49AC77CD360FBDA)                          |            0.008 |      0    |       0.01 |         1 | 2019-01-11   |
| 1852 | [Steven Murdoch &lt;tor-admin at cs.ucl.ac.uk&gt; 8iylbse](https://metrics.torproject.org/rs.html#search/family:462C4C97170DE94F251A46F4C741032864AD1BFB)             |            0.008 |      0    |       0.01 |         2 | 2018-01-26   |
| 1853 | [495B4968](https://metrics.torproject.org/rs.html#details/495B496867C84BBC92338301D924850F226E75DA)                                                                   |            0.008 |      0    |       0.01 |         1 | 2015-09-23   |
| 1854 | [4FCF975D](https://metrics.torproject.org/rs.html#details/4FCF975D71A8663E8066BD1431D8E9459DBE2EAB)                                                                   |            0.008 |      0    |       0.01 |         1 | 2020-05-23   |
| 1855 | [kffagency at protonmail dot com tor-relay.co](https://metrics.torproject.org/rs.html#details/52026565263963A4DA7C0A737E43850951405CDB)                               |            0.008 |      0    |       0.01 |         1 | 2020-03-31   |
| 1856 | [5380653A](https://metrics.torproject.org/rs.html#details/5380653A53FAFFFF0599B69F9AC302CB4B6AAE0B)                                                                   |            0.008 |      0    |       0    |         1 | 2020-02-23   |
| 1857 | [55125574](https://metrics.torproject.org/rs.html#details/5512557491F87D888FC485FF6484265A754ABF53)                                                                   |            0.008 |      0.02 |       0    |         1 | 2019-02-26   |
| 1858 | [5589E69E](https://metrics.torproject.org/rs.html#details/5589E69E8092D21712CC9F96D6F20ABCC9EF3F2A)                                                                   |            0.008 |      0    |       0    |         1 | 2020-05-15   |
| 1859 | [ron@risley.net](https://metrics.torproject.org/rs.html#search/family:56DCA89A6B41ADA30E891EF65FDCC071DC05079B)                                                       |            0.008 |      0    |       0.01 |         2 | 2014-06-06   |
| 1860 | [5CD97BB6](https://metrics.torproject.org/rs.html#details/5CD97BB62F97F7AF0457D550306DD761E590DD2A)                                                                   |            0.008 |      0    |       0    |         1 | 2020-05-20   |
| 1861 | [5CF2BC57](https://metrics.torproject.org/rs.html#details/5CF2BC575B3537AEE1E531021E2DB682B591C5A4)                                                                   |            0.008 |      0    |       0    |         1 | 2020-08-03   |
| 1862 | [psylonet@gmail.com](https://metrics.torproject.org/rs.html#details/5F5A59E3ECB0987407D916ABBDE60613F83EA1E9)                                                         |            0.008 |      0    |       0.01 |         1 | 2016-06-19   |
| 1863 | [jim dot r at outlook dot com](https://metrics.torproject.org/rs.html#details/61F3A840F61EEFFF682C6243534ECEB09ADFE3B3)                                               |            0.008 |      0    |       0.01 |         1 | 2016-08-12   |
| 1864 | [vincent@degat.bzh](https://metrics.torproject.org/rs.html#details/625743FAF41B791AAFC2D4BF859DA4AAA2E81FE7)                                                          |            0.008 |      0    |       0.01 |         1 | 2015-03-28   |
| 1865 | [Devuno &lt;devuno.ittor AT gmail dot com&gt;](https://metrics.torproject.org/rs.html#details/63CD37872814AD1623C239CB7A0CB9C4E3CEB923)                               |            0.008 |      0    |       0.01 |         1 | 2019-07-19   |
| 1866 | [usr@skrep.in](https://metrics.torproject.org/rs.html#details/645BE639E8D490A992B41F04B78B6104F8A1EE86)                                                               |            0.008 |      0    |       0.01 |         1 | 2020-07-23   |
| 1867 | [PGK &lt;tor at the-goober.net&gt;](https://metrics.torproject.org/rs.html#search/family:64A8837A97AF71775C84DE0EDA94552AAEDC424F)                                    |            0.008 |      0    |       0.01 |         4 | 2014-06-08   |
| 1868 | [Random Person &lt;nobody AT example dot com&gt;](https://metrics.torproject.org/rs.html#details/661E08534FABDBE09BA505F7A73848371C6EF732)                            |            0.008 |      0    |       0.01 |         1 | 2018-07-06   |
| 1869 | [Marcos Del Sol Vives &lt;marcos@orca.pet&gt;](https://metrics.torproject.org/rs.html#details/6903FF1FFD6A710C7D9FE9EF7B5E23EF0465094B)                               |            0.008 |      0    |       0    |         1 | 2019-10-17   |
| 1870 | [Tobias Meggendorfer Mail:&lt;tobias .AT. meggendorfer](https://metrics.torproject.org/rs.html#details/6919A8656F85830ED5778FE3FDD522F3F18FFF6F)                      |            0.008 |      0    |       0.01 |         1 | 2017-05-12   |
| 1871 | [72270EB5](https://metrics.torproject.org/rs.html#details/72270EB58EDEBE727AA29E67417628DBCE889FAE)                                                                   |            0.008 |      0    |       0.01 |         1 | 2015-04-22   |
| 1872 | [tor at leenux dot de](https://metrics.torproject.org/rs.html#details/72657B20DF49BDB0ECA80840E67F40CF63ACFCFA)                                                       |            0.008 |      0    |       0    |         1 | 2020-07-30   |
| 1873 | [7494CB6B](https://metrics.torproject.org/rs.html#details/7494CB6B5C82725BAFB6C1084DC0A1BE76591B51)                                                                   |            0.008 |      0    |       0.01 |         1 | 2019-09-21   |
| 1874 | [74F44514](https://metrics.torproject.org/rs.html#details/74F44514E060866912DFFE1554D0D135C9DC5148)                                                                   |            0.008 |      0    |       0.01 |         1 | 2020-07-19   |
| 1875 | [PGP-Fingerprint:627f65fa4529991d393b53294803753808](https://metrics.torproject.org/rs.html#details/75EE3430CEF7744EA1E35607881B27581EB15880)                         |            0.008 |      0    |       0.01 |         1 | 2019-05-06   |
| 1876 | [7E9BC457](https://metrics.torproject.org/rs.html#details/7E9BC4574FA488C701BB3F399A426C8390351A22)                                                                   |            0.008 |      0    |       0    |         1 | 2020-07-29   |
| 1877 | [806670BB](https://metrics.torproject.org/rs.html#details/806670BB3A78C22C28C3212F8245FD0F2C7E7F44)                                                                   |            0.008 |      0    |       0    |         1 | 2020-05-20   |
| 1878 | [Admin &lt;stinkyfeetexit@gmail.com&gt;](https://metrics.torproject.org/rs.html#details/81E0F62FF2687A96A1E9C4C91E0F0676276338DB)                                     |            0.008 |      0.02 |       0    |         1 | 2018-04-02   |
| 1879 | [Vm9ydCA8dnZvcnRAeWFuZGV4LnJ1Pg==](https://metrics.torproject.org/rs.html#details/835FFE642EFA3BB7936663D2365A15D319FB6226)                                           |            0.008 |      0    |       0.01 |         1 | 2017-06-08   |
| 1880 | [85041E7C](https://metrics.torproject.org/rs.html#details/85041E7C5DF043B03F2C19421998F1751C002E49)                                                                   |            0.008 |      0    |       0.01 |         1 | 2019-10-12   |
| 1881 | [8566E02B](https://metrics.torproject.org/rs.html#details/8566E02B56F1C000012DED3D530728C5B8BD7845)                                                                   |            0.008 |      0    |       0.01 |         1 | 2020-05-26   |
| 1882 | [abuse at yggdrasil dot ws](https://metrics.torproject.org/rs.html#details/85ED839A03D10C46219609625D7FEAE59EDCCFDD)                                                  |            0.008 |      0.02 |       0    |         1 | 2020-05-27   |
| 1883 | [88E2D25A](https://metrics.torproject.org/rs.html#details/88E2D25A66ED63030F25819F4ADB7D1AF0E5BD77)                                                                   |            0.008 |      0    |       0.01 |         1 | 2017-04-11   |
| 1884 | [ss aT xcoin d0t ro BTC: bc1q49wsl94gdwpphngpp7](https://metrics.torproject.org/rs.html#details/896364B7996F5DFBA0E15D1A2E06D0B98B555DD6)                             |            0.008 |      0    |       0    |         1 | 2014-04-28   |
| 1885 | [8C94FAB7](https://metrics.torproject.org/rs.html#details/8C94FAB733C8F1E6C1828946DB77699DD9AC63D7)                                                                   |            0.008 |      0    |       0.01 |         1 | 2017-01-24   |
| 1886 | [tor@vaeden.net](https://metrics.torproject.org/rs.html#details/8D89D606CC7057124916A6616C4C1936ABEE9E88)                                                             |            0.008 |      0    |       0.01 |         1 | 2020-05-07   |
| 1887 | [tor@continuum.com](https://metrics.torproject.org/rs.html#details/8DBEF8D824437770261B4C7453F2815DB7FC9165)                                                          |            0.008 |      0    |       0    |         1 | 2019-09-26   |
| 1888 | [9026A9CD](https://metrics.torproject.org/rs.html#details/9026A9CD3E0685A4D4627DA319EC8BB4FB7F6A7B)                                                                   |            0.008 |      0    |       0    |         1 | 2020-06-12   |
| 1889 | [mario.costa AT icloud DOT com PGP: 6C3B 0069 30C4](https://metrics.torproject.org/rs.html#details/912709C7F560CC3E9FE9604B58D598B1BFAED8C7)                          |            0.008 |      0    |       0.01 |         1 | 2019-10-15   |
| 1890 | [tor@nsandd.com 0x92E43A8A9EF85EB4](https://metrics.torproject.org/rs.html#details/924B24AFA7F075D059E8EEB284CC400B33D3D036)                                          |            0.008 |      0    |       0.01 |         1 | 2017-02-07   |
| 1891 | [John &lt;quadrople@example.com&gt;](https://metrics.torproject.org/rs.html#details/9A1B4E6D96C9321657FA31036A54C4216EE978A2)                                         |            0.008 |      0    |       0.01 |         1 | 2020-04-27   |
| 1892 | [9BAAA9CB](https://metrics.torproject.org/rs.html#details/9BAAA9CBA3109C2C807F2E84D5C9C0C8C147DCE6)                                                                   |            0.008 |      0    |       0.01 |         1 | 2020-03-22   |
| 1893 | [1187 EF45 9760 66ED 5AB5 5D50 9755 3391 D0BF 49BA](https://metrics.torproject.org/rs.html#search/family:9C2BF9B1E30EBB1A3836FA04BEEE8CC192CC1E5B)                    |            0.008 |      0    |       0.01 |         2 | 2017-01-21   |
| 1894 | [luminoso @ freenode irc](https://metrics.torproject.org/rs.html#details/9EA65D1BB607ADA4B9A6B2A58BAA2C960DF8BDEA)                                                    |            0.008 |      0    |       0    |         1 | 2019-12-30   |
| 1895 | [9ECFD672](https://metrics.torproject.org/rs.html#details/9ECFD67230D09E5E8F3431BDC4FD8E52428AFC09)                                                                   |            0.008 |      0    |       0.01 |         1 | 2018-06-05   |
| 1896 | [9EEAA02E](https://metrics.torproject.org/rs.html#details/9EEAA02E338CDF5919F983F3245AA95A790B9B6C)                                                                   |            0.008 |      0    |       0.01 |         1 | 2015-10-22   |
| 1897 | [Random Person &lt;jpconrad AT mail2world dot com&gt;](https://metrics.torproject.org/rs.html#details/A09DAAAD16E3F77C2ED1A012BD8A18FFCBFEB422)                       |            0.008 |      0    |       0    |         1 | 2019-12-31   |
| 1898 | [aaa@bb.com](https://metrics.torproject.org/rs.html#details/A1BBCBEC113DAAC7F17E7A7E698AAA7B147D691A)                                                                 |            0.008 |      0    |       0.01 |         1 | 2020-01-20   |
| 1899 | [Admin tor AT np-si DOT net](https://metrics.torproject.org/rs.html#details/A6C7821BE00C9A951181296EE12EB5AD8B7CFA17)                                                 |            0.008 |      0    |       0.01 |         1 | 2019-01-01   |
| 1900 | [A9D89B91](https://metrics.torproject.org/rs.html#details/A9D89B917949768C0AE20CD008F2F70898BF79A3)                                                                   |            0.008 |      0    |       0    |         1 | 2020-05-20   |
| 1901 | [ADC4E832](https://metrics.torproject.org/rs.html#details/ADC4E832DC8A3D9242FFA6424A99BD55EBA1403B)                                                                   |            0.008 |      0    |       0.01 |         1 | 2020-04-18   |
| 1902 | [B09E23C2](https://metrics.torproject.org/rs.html#details/B09E23C2597234F6EB494B6EDD7334DB64221FA1)                                                                   |            0.008 |      0    |       0.01 |         1 | 2018-02-13   |
| 1903 | [zee-en-cue three single letters at tuta dot ey](https://metrics.torproject.org/rs.html#details/B2B69E6534F0FD213F324FCDBD0E32796185B034)                             |            0.008 |      0    |       0.01 |         1 | 2020-05-04   |
| 1904 | [B63410CD](https://metrics.torproject.org/rs.html#details/B63410CD48185ED34E9C6AE62D048D8A6854A5CA)                                                                   |            0.008 |      0.02 |       0    |         1 | 2019-08-06   |
| 1905 | [B644F1C0](https://metrics.torproject.org/rs.html#details/B644F1C0FB7992E653060308326540EC9BEB8BE8)                                                                   |            0.008 |      0    |       0    |         1 | 2020-07-03   |
| 1906 | [B7EF647E](https://metrics.torproject.org/rs.html#details/B7EF647EF659726C716243A82877D20AA7978EBC)                                                                   |            0.008 |      0    |       0.01 |         1 | 2017-12-04   |
| 1907 | [B854211F](https://metrics.torproject.org/rs.html#details/B854211F2524B4B7C44FA775B053FF62F029A5E1)                                                                   |            0.008 |      0    |       0    |         1 | 2020-05-26   |
| 1908 | [BBD1B1A2](https://metrics.torproject.org/rs.html#details/BBD1B1A22695396C75DFF338A8FF7A12804A607A)                                                                   |            0.008 |      0    |       0.01 |         1 | 2014-11-13   |
| 1909 | [BDF3F765](https://metrics.torproject.org/rs.html#details/BDF3F765BEBC50AA559DE55655896F275A2C67AD)                                                                   |            0.008 |      0    |       0    |         1 | 2020-07-22   |
| 1910 | [amans.aequi@protonmail.com](https://metrics.torproject.org/rs.html#details/BEA7C058ECD27BE8E73A76CBE13A917A83192685)                                                 |            0.008 |      0    |       0    |         1 | 2019-11-02   |
| 1911 | [C0279317](https://metrics.torproject.org/rs.html#details/C0279317438EAA2458BB43A281E91ED7F6560A36)                                                                   |            0.008 |      0    |       0    |         1 | 2020-06-23   |
| 1912 | [C92ECAF7](https://metrics.torproject.org/rs.html#details/C92ECAF73512E2CCB15827A192B7AF3E9DBC896E)                                                                   |            0.008 |      0    |       0.01 |         1 | 2020-06-02   |
| 1913 | [&lt;tor-op AT innolan dot net&gt;](https://metrics.torproject.org/rs.html#details/CB19AC6FFAC13B4C1A143B423884EDEA4381ED2F)                                          |            0.008 |      0    |       0.01 |         1 | 2018-03-08   |
| 1914 | [CCAA620D](https://metrics.torproject.org/rs.html#details/CCAA620D5CAB34CE95FE3C863D9E6520C07451D8)                                                                   |            0.008 |      0    |       0.01 |         1 | 2017-01-24   |
| 1915 | [Admin &lt;mirror-admin AT nycbug DOT org&gt;](https://metrics.torproject.org/rs.html#details/D317C7889162E9EC4A1DA1A1095C2A0F377536D9)                               |            0.008 |      0    |       0.01 |         1 | 2019-05-16   |
| 1916 | [D49D0071](https://metrics.torproject.org/rs.html#details/D49D0071D9236EFC6AC527292894A5A2143F815D)                                                                   |            0.008 |      0    |       0.01 |         1 | 2019-06-30   |
| 1917 | [Anonymous Coward &lt;anonymous AT nullhost dot net&gt;](https://metrics.torproject.org/rs.html#details/D5C33F3E203728EDF8361EA868B2939CCC43FAFB)                     |            0.008 |      0    |       0.01 |         1 | 2014-05-08   |
| 1918 | [Elise Randolph &lt;imgay@pandemiclegion.com&gt;](https://metrics.torproject.org/rs.html#details/D7316BF7FD633DD7474B18C33E1D5FDEB04D26A7)                            |            0.008 |      0    |       0.01 |         1 | 2015-10-15   |
| 1919 | [DARKDATA &lt;spam@darkdata.to&gt;](https://metrics.torproject.org/rs.html#details/E0E6DEEFAD77051EDF4719134C199AC4C9ED5756)                                          |            0.008 |      0.02 |       0    |         1 | 2020-08-08   |
| 1920 | [bootcharoo at protonmail dot com tor-relay.co](https://metrics.torproject.org/rs.html#details/E14D10669DD6E472235F8F0161544B4E7B7CB3C7)                              |            0.008 |      0    |       0.01 |         1 | 2019-02-24   |
| 1921 | [https://www.torservers.net/donate.html &lt;support .A](https://metrics.torproject.org/rs.html#details/E379A6CACEFAFE1B8EA68503BFCFF1215BF1EE7F)                      |            0.008 |      0.02 |       0    |         1 | 2015-12-02   |
| 1922 | [support@xmission.com](https://metrics.torproject.org/rs.html#details/E41B16F7DDF52EBB1DB4268AB2FE340B37AD8904)                                                       |            0.008 |      0.02 |       0    |         1 | 2016-08-30   |
| 1923 | [i@fht.im](https://metrics.torproject.org/rs.html#details/E48E73FDFACFA94CA9B75AA1719EB1E6B89C4EA9)                                                                   |            0.008 |      0    |       0    |         1 | 2019-08-30   |
| 1924 | [tor AT libreops DOT cc](https://metrics.torproject.org/rs.html#details/E8D114B3C78D8E6E7FEB1004650DD632C2143C9E)                                                     |            0.008 |      0    |       0.01 |         1 | 2019-02-04   |
| 1925 | [0xFFFFFFFF Random Person &lt;abctoro01@gmail.com&gt;](https://metrics.torproject.org/rs.html#details/E9A6E1549300C3551071B71AC547E2568D9F7CEE)                       |            0.008 |      0    |       0.01 |         1 | 2020-04-30   |
| 1926 | [MirrorVenom13@yandex.ru](https://metrics.torproject.org/rs.html#details/EBB50442D1D826DBE9C61A9EE5E0A2CE44DD989A)                                                    |            0.008 |      0    |       0.01 |         1 | 2019-05-16   |
| 1927 | [EF7F0E41](https://metrics.torproject.org/rs.html#details/EF7F0E41B2748F893B8F6E49A07D7199CDFB2AC4)                                                                   |            0.008 |      0    |       0    |         1 | 2020-05-22   |
| 1928 | [F025EF03](https://metrics.torproject.org/rs.html#details/F025EF03C1C48D31E98416DC91B2F2D2E8AF7523)                                                                   |            0.008 |      0    |       0.01 |         1 | 2020-02-23   |
| 1929 | [F0364DBC](https://metrics.torproject.org/rs.html#details/F0364DBC2E4221405354433B65503E816D887C01)                                                                   |            0.008 |      0    |       0    |         1 | 2020-06-09   |
| 1930 | [F17B5CE0](https://metrics.torproject.org/rs.html#details/F17B5CE022C164202A00B3669EFCAB72CF80B93C)                                                                   |            0.008 |      0    |       0.01 |         1 | 2015-05-19   |
| 1931 | [abuse at jacobwall dot com tor-relay.co](https://metrics.torproject.org/rs.html#details/F263F4F57A20D8C19E9F9C84150C60F7A49F2DB5)                                    |            0.008 |      0    |       0.01 |         1 | 2017-02-16   |
| 1932 | [evilmoe at bossmail dot de](https://metrics.torproject.org/rs.html#details/F4263275CF54A6836EE7BD527B1328836A6F06E1)                                                 |            0.008 |      0    |       0.01 |         1 | 2013-10-05   |
| 1933 | [FB879E9F](https://metrics.torproject.org/rs.html#details/FB879E9F83F885D35594F85C5E42EC9CADD8461F)                                                                   |            0.008 |      0    |       0.01 |         1 | 2020-07-27   |
| 1934 | [FF03BFEB](https://metrics.torproject.org/rs.html#details/FF03BFEBD35222D99F842906565504EBC3ABA87B)                                                                   |            0.008 |      0    |       0    |         1 | 2020-05-19   |
| 1935 | [0367E1FF](https://metrics.torproject.org/rs.html#details/0367E1FFAB716AC3F418CFB7CBB3BDB9403CD9CB)                                                                   |            0.007 |      0    |       0.01 |         1 | 2019-09-21   |
| 1936 | [070D3872](https://metrics.torproject.org/rs.html#details/070D387230C1B95A05811C5B722FBD21A1076BDB)                                                                   |            0.007 |      0    |       0    |         1 | 2020-06-02   |
| 1937 | [V &lt;nobody AT example dot com&gt;](https://metrics.torproject.org/rs.html#details/08E9530B399F7A71936066586B31A66877066458)                                        |            0.007 |      0    |       0.01 |         1 | 2017-02-02   |
| 1938 | [09FF1008](https://metrics.torproject.org/rs.html#details/09FF100802827A5B3D78EA1DF8234DFEEF71F6AC)                                                                   |            0.007 |      0    |       0    |         1 | 2020-08-09   |
| 1939 | [0B343CDB](https://metrics.torproject.org/rs.html#details/0B343CDB8934729DC91B1CAD7BD2D05F705E90E0)                                                                   |            0.007 |      0    |       0.01 |         1 | 2017-10-26   |
| 1940 | [Ranlvor &lt;tor AT starletp9 dot de&gt;](https://metrics.torproject.org/rs.html#details/0B45375A2CE8065E8A649D52CC35F39D128745A8)                                    |            0.007 |      0    |       0.01 |         1 | 2013-11-06   |
| 1941 | [117E80E8](https://metrics.torproject.org/rs.html#details/117E80E8E2EDF93C45DB55358CA0FA21EA26AC40)                                                                   |            0.007 |      0    |       0    |         1 | 2020-07-18   |
| 1942 | [parkerroman at pm dot me tor-relay.co](https://metrics.torproject.org/rs.html#details/1259F4C66D5D7A4145D6165680D7770161888F2B)                                      |            0.007 |      0    |       0    |         1 | 2020-08-05   |
| 1943 | [129C9F6F](https://metrics.torproject.org/rs.html#details/129C9F6FDF8FBA4597E0E63F604E26EFBAF3A850)                                                                   |            0.007 |      0    |       0    |         1 | 2020-08-09   |
| 1944 | [4096R/67D1A1AD](https://metrics.torproject.org/rs.html#search/family:13FCE0F6E33CBCE242F7A9286123D94D778D7F40)                                                       |            0.007 |      0    |       0    |         8 | 2018-08-24   |
| 1945 | [144CCCE4](https://metrics.torproject.org/rs.html#details/144CCCE4EFE85215BC0866E797BEA8F85929CFED)                                                                   |            0.007 |      0    |       0.01 |         1 | 2020-04-21   |
| 1946 | [tormaster &lt;tormaster AT sebastian-graf dot at&gt;](https://metrics.torproject.org/rs.html#details/1525A0AF806EF85953CF83EBB02944B92C0E81E2)                       |            0.007 |      0    |       0.01 |         1 | 2020-05-25   |
| 1947 | [null &lt;admin AT 44xx dot net&gt;](https://metrics.torproject.org/rs.html#search/family:17B1E5314EE6D6C418134C80A9BBBC025096AD76)                                   |            0.007 |      0.02 |       0    |         4 | 2020-06-10   |
| 1948 | [1A1328EF](https://metrics.torproject.org/rs.html#details/1A1328EF7BD067D984D01E8CA41A78A894357C03)                                                                   |            0.007 |      0    |       0    |         1 | 2020-06-21   |
| 1949 | [1A7B6D86](https://metrics.torproject.org/rs.html#details/1A7B6D86612CDE160E69215138F59E066BA552BF)                                                                   |            0.007 |      0    |       0    |         1 | 2020-07-17   |
| 1950 | [X &lt;abuse.freeopeninternet AT gmail dot com&gt;](https://metrics.torproject.org/rs.html#details/1CE9AB21F6A077CFD5588DC0868AC56AED5EA504)                          |            0.007 |      0    |       0.01 |         1 | 2020-05-21   |
| 1951 | [1E9E17F0](https://metrics.torproject.org/rs.html#details/1E9E17F01FD0F4A40BBEDF9B282EBE2F1811DD3E)                                                                   |            0.007 |      0    |       0    |         1 | 2020-06-27   |
| 1952 | [privacyforwinn@web.de](https://metrics.torproject.org/rs.html#details/216D8778B43123805F3FE3D7157223F34EF74A40)                                                      |            0.007 |      0    |       0    |         1 | 2020-08-05   |
| 1953 | [Mika Mu00E4ki agenttix$kapsi.fi](https://metrics.torproject.org/rs.html#details/21A183AB1F0B207B50A1E08687685A8D940C5F80)                                            |            0.007 |      0    |       0.01 |         1 | 2020-04-25   |
| 1954 | [21E91629](https://metrics.torproject.org/rs.html#details/21E9162916687FDC3CD966D11F34766F51902B45)                                                                   |            0.007 |      0    |       0    |         1 | 2020-07-31   |
| 1955 | [p4r7154n p4r7154n@protonmail.com BTC: 1BuNWCJw](https://metrics.torproject.org/rs.html#details/23A022058948867659E69A5282AC4E367B2ACFBD)                             |            0.007 |      0    |       0.01 |         1 | 2020-03-08   |
| 1956 | [tor .at. decimatechnologies .dot. eu](https://metrics.torproject.org/rs.html#details/27EE4854D03F81FAEA3884A44303BE00DEEEE555)                                       |            0.007 |      0    |       0.01 |         1 | 2018-08-26   |
| 1957 | [2BD1936E](https://metrics.torproject.org/rs.html#details/2BD1936E0B4D5BB615CF99B0CFF74EAF19426888)                                                                   |            0.007 |      0.02 |       0    |         1 | 2019-08-15   |
| 1958 | [Rogemedic &lt;admin@waltersnet.noip.us&gt;](https://metrics.torproject.org/rs.html#details/2D82EF77EB07AF2B3B1BC140AAB5278E3963D64E)                                 |            0.007 |      0    |       0    |         1 | 2018-12-23   |
| 1959 | [someones-relays riseup net](https://metrics.torproject.org/rs.html#details/2E74F4A6EB5ED3C0182A54900E3A671C5C8DB2D8)                                                 |            0.007 |      0    |       0    |         1 | 2019-06-30   |
| 1960 | [operator1000@telegrama.com](https://metrics.torproject.org/rs.html#details/32437FADA2B55E6F446870203311860AD8588569)                                                 |            0.007 |      0    |       0.01 |         1 | 2020-06-13   |
| 1961 | [35E98FB0](https://metrics.torproject.org/rs.html#details/35E98FB0B591DF3B357FFEDD3DADB10DAD027D7D)                                                                   |            0.007 |      0    |       0.01 |         1 | 2016-05-18   |
| 1962 | [365F3930](https://metrics.torproject.org/rs.html#details/365F393040AA2979DC01D102F5052CAD048F42F7)                                                                   |            0.007 |      0    |       0.01 |         1 | 2017-12-19   |
| 1963 | [3A56936C](https://metrics.torproject.org/rs.html#details/3A56936CC69F13737872697DBC8415444F499FFC)                                                                   |            0.007 |      0    |       0    |         1 | 2019-07-24   |
| 1964 | [3BB34CCD](https://metrics.torproject.org/rs.html#details/3BB34CCD8EA9C804C5C5361B21F33767F220801D)                                                                   |            0.007 |      0    |       0.01 |         1 | 2016-05-26   |
| 1965 | [Schlawiner &lt;schlawiner AT cock dot li&gt;](https://metrics.torproject.org/rs.html#details/3C4B5F67E092261DD87626CCA76C7402A4A1CCC3)                               |            0.007 |      0    |       0.01 |         1 | 2019-01-28   |
| 1966 | [3E374F99](https://metrics.torproject.org/rs.html#details/3E374F99ACA96A5179153914B722CE8449534A63)                                                                   |            0.007 |      0    |       0    |         1 | 2020-07-22   |
| 1967 | [3E493247](https://metrics.torproject.org/rs.html#details/3E4932477308B5C209296D3647A41C4D3F325039)                                                                   |            0.007 |      0    |       0    |         1 | 2019-12-15   |
| 1968 | [&lt;rainloop@tutanota.de&gt;](https://metrics.torproject.org/rs.html#details/3F5689B1ED8217540F0F6C46390AA18370765827)                                               |            0.007 |      0    |       0.01 |         1 | 2020-05-05   |
| 1969 | [Nona Admin &lt;admin AT nonanet dot net&gt;](https://metrics.torproject.org/rs.html#details/414385E0BA88B6F7870C389A60819BB06308E8D0)                                |            0.007 |      0.02 |       0    |         1 | 2019-09-23   |
| 1970 | [ReplaceIwithY &lt;tor AT cIberkommando d0t de&gt;](https://metrics.torproject.org/rs.html#details/447A24F3402C4774D89E7AAD2D876D0BF64E3267)                          |            0.007 |      0    |       0.01 |         1 | 2020-03-30   |
| 1971 | [&lt;tor AT tjw DOT moe&gt;](https://metrics.torproject.org/rs.html#details/45582F4CCEE4BBF79B44A4853FDD82908B08D4A8)                                                 |            0.007 |      0    |       0.01 |         1 | 2018-02-21   |
| 1972 | [pieter.brueghel@affenmail.com](https://metrics.torproject.org/rs.html#details/46053D5D5916F20C333406F16911711AB55164C0)                                              |            0.007 |      0    |       0.01 |         1 | 2020-04-26   |
| 1973 | [4A367740](https://metrics.torproject.org/rs.html#details/4A36774094E3C92C57D22E589063E39481A17EDC)                                                                   |            0.007 |      0    |       0    |         1 | 2020-05-26   |
| 1974 | [51CD9DB0](https://metrics.torproject.org/rs.html#details/51CD9DB00357405FC41AF0FA513688D02BDA0C0E)                                                                   |            0.007 |      0    |       0.01 |         1 | 2019-08-26   |
| 1975 | [contact&lt;at&gt;highsecurity dot systems](https://metrics.torproject.org/rs.html#details/563C8868165186D2F7BA1FCF982EB20DEB82B350)                                  |            0.007 |      0.02 |       0    |         1 | 2020-05-01   |
| 1976 | [iblech@quasicoherent.io](https://metrics.torproject.org/rs.html#details/58A9921DD0A1389356634625C5B14ACC1194A95C)                                                    |            0.007 |      0    |       0    |         1 | 2019-02-02   |
| 1977 | [1024D/CF154167 Eirik Oeverby &lt;ltning dash tor AT a](https://metrics.torproject.org/rs.html#details/5D263037FC175596B3A344132B0B755EB8FB1D1C)                      |            0.007 |      0.02 |       0    |         1 | 2013-06-27   |
| 1978 | [Dennis Emory Hannon / BackplaneDNS - abuse at Back](https://metrics.torproject.org/rs.html#details/5E56738E7F97AA81DEEF59AF28494293DFBFCCDF)                         |            0.007 |      0.02 |       0    |         1 | 2017-07-22   |
| 1979 | [5F03F8EC](https://metrics.torproject.org/rs.html#details/5F03F8EC1868926A30505A7D12C1265418E2EBEF)                                                                   |            0.007 |      0    |       0    |         1 | 2020-08-09   |
| 1980 | [tor@base32.eu](https://metrics.torproject.org/rs.html#details/5FF02D4113F0A6888D0A2EE6C57C61A158B7550C)                                                              |            0.007 |      0    |       0.01 |         1 | 2018-02-23   |
| 1981 | [6014F7E9](https://metrics.torproject.org/rs.html#details/6014F7E9CF3AF9D8719A7FF751488633FC9C3FFA)                                                                   |            0.007 |      0    |       0    |         1 | 2020-08-03   |
| 1982 | [user at localhost tor-relay.co](https://metrics.torproject.org/rs.html#details/634DCB4A23477F0235348C724599227BFDF41EAF)                                             |            0.007 |      0    |       0.01 |         1 | 2020-07-15   |
| 1983 | [6530C1F5](https://metrics.torproject.org/rs.html#details/6530C1F5E453CC08EBB1A1D4B5836C921060473B)                                                                   |            0.007 |      0    |       0.01 |         1 | 2016-05-03   |
| 1984 | [67738D28](https://metrics.torproject.org/rs.html#details/67738D287FBB686B0F6BF1221505BE17781D50DC)                                                                   |            0.007 |      0    |       0    |         1 | 2020-07-11   |
| 1985 | [fiinix00 AT gmail dot com tor-relay.co](https://metrics.torproject.org/rs.html#details/68EBC7615E7DE318C6B9AA530EFD6E20FDE8DF9A)                                     |            0.007 |      0    |       0.01 |         1 | 2020-07-12   |
| 1986 | [6A6E168C](https://metrics.torproject.org/rs.html#details/6A6E168C7FB2909DBEBCA7BF43B818583C37F3EA)                                                                   |            0.007 |      0    |       0.01 |         1 | 2016-12-16   |
| 1987 | [0x1A734959D16F1EFC2152837FC172889D875D6BCE Nicolai](https://metrics.torproject.org/rs.html#details/6CDE3363F9F9AD5A6EA484DEFB58217CC9685E31)                         |            0.007 |      0    |       0.01 |         1 | 2020-05-13   |
| 1988 | [6EEADF83](https://metrics.torproject.org/rs.html#details/6EEADF83B927422B8DC37EBD5EF5B89FCA402943)                                                                   |            0.007 |      0    |       0    |         1 | 2020-06-22   |
| 1989 | [0xDE54A0BA TOR Admin &lt;jandrese@vt.edu&gt;](https://metrics.torproject.org/rs.html#details/6FC8D3B152054906417CB1EE0642265747C7F689)                               |            0.007 |      0    |       0.01 |         1 | 2015-09-16   |
| 1990 | [72A14F21](https://metrics.torproject.org/rs.html#details/72A14F21ABD2CF78D0C55A370A8A57E604E300EE)                                                                   |            0.007 |      0    |       0    |         1 | 2020-06-07   |
| 1991 | [7AB8B08D](https://metrics.torproject.org/rs.html#details/7AB8B08DF8B90D108EFC37D74CA90A7B939A023D)                                                                   |            0.007 |      0    |       0.01 |         1 | 2017-04-11   |
| 1992 | [tor@grunix.de](https://metrics.torproject.org/rs.html#details/7B2FD4FFD565993CB4C4334AC0A0C42985EBEADB)                                                              |            0.007 |      0    |       0.01 |         1 | 2018-11-29   |
| 1993 | [7FF94320](https://metrics.torproject.org/rs.html#details/7FF94320963B5CDAF9A072CE9BEE9B4F1F2B383C)                                                                   |            0.007 |      0    |       0.01 |         1 | 2016-05-17   |
| 1994 | [bambam@t-online.de](https://metrics.torproject.org/rs.html#details/80B8F5AD79F5616EFF8166B4E2128924F90DE8F0)                                                         |            0.007 |      0    |       0.01 |         1 | 2017-06-08   |
| 1995 | [parcenode@riseup.net](https://metrics.torproject.org/rs.html#details/84001E8A376A3B0B645EE6F807D072CC8D63EA09)                                                       |            0.007 |      0    |       0.01 |         1 | 2020-01-28   |
| 1996 | [86127A12](https://metrics.torproject.org/rs.html#details/86127A1279E55E667F9452B1AA4239E1F7661085)                                                                   |            0.007 |      0    |       0    |         1 | 2020-05-20   |
| 1997 | [867F1AAD](https://metrics.torproject.org/rs.html#details/867F1AAD62C3E5D58B13163106D02E0E9357012C)                                                                   |            0.007 |      0    |       0    |         1 | 2020-05-22   |
| 1998 | [hunterwolf a t riseup dot n3t](https://metrics.torproject.org/rs.html#details/879FAE7932DF44AAFB3366DE405C4680F74E9284)                                              |            0.007 |      0    |       0.01 |         1 | 2020-07-25   |
| 1999 | [venom96669@gmail.com](https://metrics.torproject.org/rs.html#details/893BAE43EAC1507C5FBD046C325343D58FC04588)                                                       |            0.007 |      0    |       0.01 |         1 | 2019-05-17   |
| 2000 | [8C993A76](https://metrics.torproject.org/rs.html#details/8C993A76F7F647E44256958CBCF1FB712139B3AF)                                                                   |            0.007 |      0    |       0    |         1 | 2020-06-15   |
| 2001 | [931355AE](https://metrics.torproject.org/rs.html#details/931355AE5529292283DED62B0A8FB85B74AC3B1C)                                                                   |            0.007 |      0.02 |       0    |         1 | 2020-07-16   |
| 2002 | [Tor Relay &lt;info@driessen.net&gt;](https://metrics.torproject.org/rs.html#details/9492CC046A0BB01638C2332073AA0600B3F31252)                                        |            0.007 |      0    |       0.01 |         1 | 2019-12-01   |
| 2003 | [A1DAA9D3](https://metrics.torproject.org/rs.html#details/A1DAA9D3975D1EBB231277ECDEF68720D3F00C8F)                                                                   |            0.007 |      0    |       0    |         1 | 2020-06-28   |
| 2004 | [A29413FC](https://metrics.torproject.org/rs.html#details/A29413FC01DCFB3F97F5EC01E6DD628D2126B241)                                                                   |            0.007 |      0    |       0    |         1 | 2020-05-21   |
| 2005 | [frei.raum Technikkollektiv roland.k at disroot do](https://metrics.torproject.org/rs.html#search/family:A3D264895F685D16FC834D0685A094AE622F2206)                    |            0.007 |      0.02 |       0    |         4 | 2019-09-17   |
| 2006 | [0x5c3732f4942cffc4 Roland van Ipenburg &lt;ipenburg@x](https://metrics.torproject.org/rs.html#details/A480D8C9F9B1112E47C24E33DAC0419CAF1A821A)                      |            0.007 |      0    |       0.01 |         1 | 2019-12-07   |
| 2007 | [A65E1523](https://metrics.torproject.org/rs.html#details/A65E1523F313405BB60E4AA136A69EFA504C4F60)                                                                   |            0.007 |      0    |       0.01 |         1 | 2015-09-24   |
| 2008 | [A785BB07](https://metrics.torproject.org/rs.html#details/A785BB0757BE625BD938BD2D1DD015DBC3AF46F6)                                                                   |            0.007 |      0    |       0    |         1 | 2020-07-23   |
| 2009 | [A835BE6A](https://metrics.torproject.org/rs.html#details/A835BE6AAFF5A71D8699737588530FDE141B209E)                                                                   |            0.007 |      0    |       0.01 |         1 | 2018-07-08   |
| 2010 | [tor manager@autistici.org](https://metrics.torproject.org/rs.html#details/A9EDB4EBF9EF5F3A129A58AE28EF92DB4B5078A3)                                                  |            0.007 |      0    |       0.01 |         1 | 2016-04-30   |
| 2011 | [A9F545AE](https://metrics.torproject.org/rs.html#details/A9F545AE03B731AD32F9A93D698EA20C4FA6D0D9)                                                                   |            0.007 |      0    |       0.01 |         1 | 2019-01-28   |
| 2012 | [AA5B4BF2](https://metrics.torproject.org/rs.html#details/AA5B4BF2E7A42356EDE8E6E6F97FD364A413B82F)                                                                   |            0.007 |      0    |       0    |         1 | 2020-06-12   |
| 2013 | [ABCD041C](https://metrics.torproject.org/rs.html#details/ABCD041C95994C8F82DE4DB464C9A778736A9BF6)                                                                   |            0.007 |      0    |       0    |         1 | 2020-08-07   |
| 2014 | [AD16D98A](https://metrics.torproject.org/rs.html#details/AD16D98AEB95B8548A0F8101AC25E6643B2A899A)                                                                   |            0.007 |      0    |       0    |         1 | 2020-07-05   |
| 2015 | [Steven S &lt;katsalmovies@gmail.com&gt;](https://metrics.torproject.org/rs.html#details/AE236568ED01527850FA0D5BEFBBF6C6BDA47AF0)                                    |            0.007 |      0    |       0.01 |         1 | 2019-07-28   |
| 2016 | [AFA9E5B8](https://metrics.torproject.org/rs.html#details/AFA9E5B8D77B736CCA77704B465F9FA4B9566924)                                                                   |            0.007 |      0    |       0.01 |         1 | 2017-02-20   |
| 2017 | [B27115A2](https://metrics.torproject.org/rs.html#details/B27115A20B05D40730A4020145EFA63381D9D51B)                                                                   |            0.007 |      0    |       0.01 |         1 | 2018-12-10   |
| 2018 | [sysop at monocul dot us tor-relay.co](https://metrics.torproject.org/rs.html#details/B5CCA5A4521F60DDB596C1A6404D8DEECDD85BFB)                                       |            0.007 |      0    |       0.01 |         1 | 2020-05-26   |
| 2019 | [B71E68A8](https://metrics.torproject.org/rs.html#details/B71E68A80C5156745DDE7741F6DE5E3202ABD092)                                                                   |            0.007 |      0    |       0.01 |         1 | 2019-02-28   |
| 2020 | [0x213baeba4cb335b5303b7a5f7c76a6d66d6dfa27 Shalom](https://metrics.torproject.org/rs.html#details/B8E514ADDC653D61DE1FCB67821BB0303778782F)                          |            0.007 |      0    |       0.01 |         1 | 2018-07-01   |
| 2021 | [B939A8A6](https://metrics.torproject.org/rs.html#details/B939A8A614869CDFB240F5EFB78BA3753B50E973)                                                                   |            0.007 |      0    |       0    |         1 | 2020-05-20   |
| 2022 | [B96F74F5](https://metrics.torproject.org/rs.html#details/B96F74F557DC93DB41C72DBA77DEC0B41462709C)                                                                   |            0.007 |      0    |       0    |         1 | 2020-05-26   |
| 2023 | [BBB3F312](https://metrics.torproject.org/rs.html#details/BBB3F31215D0156D70D27B165BF8FFC4BCD9E0E4)                                                                   |            0.007 |      0    |       0    |         1 | 2020-06-16   |
| 2024 | [BCB08FD8](https://metrics.torproject.org/rs.html#details/BCB08FD84AC3B13D2D62FC3CDDA005F02F5C6BAA)                                                                   |            0.007 |      0    |       0    |         1 | 2020-07-22   |
| 2025 | [Me &lt;itsmyownaddress AT gmail dot com&gt;](https://metrics.torproject.org/rs.html#details/BD552C165E2ED2887D3F1CCE9CFF155DDA2D86E6)                                |            0.007 |      0    |       0.01 |         1 | 2016-02-27   |
| 2026 | [Mr Miyagi](https://metrics.torproject.org/rs.html#details/BD56A1C36196EE968B2A3463CCD64019B4E526D8)                                                                  |            0.007 |      0    |       0.01 |         1 | 2014-06-17   |
| 2027 | [Relay Administrator &lt;loadbalancer6464@gmail.com&gt;](https://metrics.torproject.org/rs.html#details/BF14EC4ED46C8AD56FBBF58694D88F018F316A6F)                     |            0.007 |      0.02 |       0    |         1 | 2019-06-06   |
| 2028 | [Contact at SilSte on Twitter tor-relay.co](https://metrics.torproject.org/rs.html#details/BFCE771635906C6C9D76ACEA6757DE6FF3445160)                                  |            0.007 |      0    |       0    |         1 | 2020-06-30   |
| 2029 | [C699F40B](https://metrics.torproject.org/rs.html#details/C699F40B3344D34D3C596791A7EBC67E41C62A0B)                                                                   |            0.007 |      0    |       0.01 |         1 | 2016-01-15   |
| 2030 | [C7B6A1B7](https://metrics.torproject.org/rs.html#details/C7B6A1B76B6476DB3DA8C960E262CC7425B5C5F8)                                                                   |            0.007 |      0    |       0.01 |         1 | 2015-12-04   |
| 2031 | [torpids AT yahoo dot com - 1JYHfzVFVD7n2Sezz3DEHDF](https://metrics.torproject.org/rs.html#details/C91102131E6B9CECFC56C4A29ADA4E638D7872F7)                         |            0.007 |      0    |       0.01 |         1 | 2018-03-18   |
| 2032 | [Klim Dokachin &lt;dokachin AT drwmeier dot de&gt;](https://metrics.torproject.org/rs.html#details/CCBB2D86A63075F4A2B799A36EF0338F488B0F14)                          |            0.007 |      0    |       0    |         1 | 2017-10-17   |
| 2033 | [CD052DE2](https://metrics.torproject.org/rs.html#details/CD052DE28C5C790D043C96571A5E66B3C2ACDBEF)                                                                   |            0.007 |      0    |       0.01 |         1 | 2019-06-20   |
| 2034 | [&lt;robinkjeld AT protonmail DOT ch&gt;](https://metrics.torproject.org/rs.html#search/family:CDE4C5DC9D639E915B99B461EE243044FCA264B6)                              |            0.007 |      0    |       0.01 |         2 | 2016-10-13   |
| 2035 | [D007C5B3](https://metrics.torproject.org/rs.html#details/D007C5B3FC015AD4F708CA2DBB443F9FB5915987)                                                                   |            0.007 |      0    |       0.01 |         1 | 2017-01-19   |
| 2036 | [D0E9CA01](https://metrics.torproject.org/rs.html#details/D0E9CA0156E25E14E18CB1567A607F191E919BB1)                                                                   |            0.007 |      0    |       0.01 |         1 | 2015-12-03   |
| 2037 | [D0EAB6A2](https://metrics.torproject.org/rs.html#details/D0EAB6A2581F1B105F841B96B48A6246CDE6CEB1)                                                                   |            0.007 |      0    |       0    |         1 | 2020-05-13   |
| 2038 | [heinrich5991 &lt;heinrich5991@gmail.com&gt;](https://metrics.torproject.org/rs.html#details/D30E9D4D639068611D6D96861C95C2099140B805)                                |            0.007 |      0    |       0.01 |         1 | 2016-04-04   |
| 2039 | [D503FBB1](https://metrics.torproject.org/rs.html#details/D503FBB19BE69F63D7ACAA9B67CAA2AC7B448B11)                                                                   |            0.007 |      0    |       0.01 |         1 | 2015-09-24   |
| 2040 | [D8E832DD](https://metrics.torproject.org/rs.html#details/D8E832DD333476940DD083E80230E17BC2C16F5F)                                                                   |            0.007 |      0    |       0.01 |         1 | 2019-12-06   |
| 2041 | [none](https://metrics.torproject.org/rs.html#details/D9EB99B58EBB31681324DFBD15BA0C8C7238B526)                                                                       |            0.007 |      0    |       0.01 |         1 | 2019-05-18   |
| 2042 | [Kraang at protonmail dot com tor-relay.co](https://metrics.torproject.org/rs.html#details/E1A649E1974EAA78D4DBA51153F5F3EF30269318)                                  |            0.007 |      0    |       0    |         1 | 2019-12-22   |
| 2043 | [E3B0739E](https://metrics.torproject.org/rs.html#details/E3B0739EEFFF0DE4203BBE8563F2A1C89D410347)                                                                   |            0.007 |      0    |       0.01 |         1 | 2020-02-21   |
| 2044 | [ZeroMeaning.com &lt;tor-operator@zeromeaning.com&gt;](https://metrics.torproject.org/rs.html#details/E4012D3B0DFB5CB743A21C2CA41231BBA29786BB)                       |            0.007 |      0    |       0.01 |         1 | 2018-07-08   |
| 2045 | [E4CB7449](https://metrics.torproject.org/rs.html#details/E4CB7449182806088DCD6A707F45809F0694A50A)                                                                   |            0.007 |      0    |       0.01 |         1 | 2020-07-19   |
| 2046 | [torsumsum gmail com](https://metrics.torproject.org/rs.html#details/E5D13B726489E91A260F70B95B7AD9949BB6A95F)                                                        |            0.007 |      0    |       0.01 |         1 | 2019-10-06   |
| 2047 | [Person &lt;torATzoneDno&gt;](https://metrics.torproject.org/rs.html#details/E64625ED5B01A1F0E97BCF0B5D431A432A24F408)                                                |            0.007 |      0    |       0.01 |         1 | 2014-09-29   |
| 2048 | [dsauer@gmail.com](https://metrics.torproject.org/rs.html#details/E8562C7CFBEB6501F2E02DA00203F958E8B1685C)                                                           |            0.007 |      0.02 |       0    |         1 | 2020-04-02   |
| 2049 | [blackdruid@mail.ee](https://metrics.torproject.org/rs.html#details/EB7551CC1130A01BB3B19128B6E2791BC2AA3052)                                                         |            0.007 |      0.02 |       0    |         1 | 2020-07-26   |
| 2050 | [dtracy@inbox.ch](https://metrics.torproject.org/rs.html#details/EB902DF84069187F7F879744C60C14FD3AE249A2)                                                            |            0.007 |      0.02 |       0    |         1 | 2020-02-24   |
| 2051 | [youmustcontactme@free.fr](https://metrics.torproject.org/rs.html#details/EBDD9A8BC45D0543D0FDC93940EE06E56E749A99)                                                   |            0.007 |      0    |       0.01 |         1 | 2019-10-22   |
| 2052 | [ECD00566](https://metrics.torproject.org/rs.html#details/ECD0056646689244CF2BC52FE158A24E037ED227)                                                                   |            0.007 |      0    |       0    |         1 | 2020-08-09   |
| 2053 | [F1855E09](https://metrics.torproject.org/rs.html#details/F1855E09E867ECD00A4CB7D36D58170A7574C0FF)                                                                   |            0.007 |      0    |       0.01 |         1 | 2018-11-19   |
| 2054 | [F27D5D7D](https://metrics.torproject.org/rs.html#details/F27D5D7D2A1FE4DF7D826FF32174C62FF1394CA2)                                                                   |            0.007 |      0    |       0.01 |         1 | 2019-12-13   |
| 2055 | [F3ED101B](https://metrics.torproject.org/rs.html#details/F3ED101B3F249DF64C270DE85931BFE3FB482C20)                                                                   |            0.007 |      0    |       0    |         1 | 2020-02-22   |
| 2056 | [0x7E892417 Felix Breidenstein &lt;tor AT felixbreiden](https://metrics.torproject.org/rs.html#details/F4C0EDAA0BF0F7EC138746F8FEF1CE26C7860265)                      |            0.007 |      0    |       0.01 |         1 | 2014-04-21   |
| 2057 | [F4D3FBD1](https://metrics.torproject.org/rs.html#details/F4D3FBD1E4918978D1D13604798CECB5EE5C9188)                                                                   |            0.007 |      0    |       0.01 |         1 | 2015-12-04   |
| 2058 | [F52B8C77](https://metrics.torproject.org/rs.html#details/F52B8C77AC5885566C06E5ADB33A5A09C5E8B534)                                                                   |            0.007 |      0    |       0.01 |         1 | 2019-12-26   |
| 2059 | [F604131D](https://metrics.torproject.org/rs.html#details/F604131DCC4303E51DB876A017A3DC9684FD626B)                                                                   |            0.007 |      0    |       0.01 |         1 | 2016-04-19   |
| 2060 | [F6FA13D4](https://metrics.torproject.org/rs.html#details/F6FA13D4B4087BA25D1E01EB46176A79E39425E5)                                                                   |            0.007 |      0    |       0    |         1 | 2020-05-21   |
| 2061 | [operator at ipxo dot eu](https://metrics.torproject.org/rs.html#details/F81F63FDF6B566D63D3A1112FC9D3EA1D3A285D1)                                                    |            0.007 |      0    |       0.01 |         1 | 2019-09-27   |
| 2062 | [tor@vintz.fr](https://metrics.torproject.org/rs.html#details/FF154E0265ADC24FDB1D8BBA34455E324C9FE407)                                                               |            0.007 |      0    |       0.01 |         1 | 2017-11-02   |
| 2063 | [0173A7A8](https://metrics.torproject.org/rs.html#details/0173A7A8BA9D32043641B69726D32A9ADFE26D16)                                                                   |            0.006 |      0    |       0.01 |         1 | 2015-12-01   |
| 2064 | [0x6F5BC20801248B85 pascal &lt;pascal a t freifunk min](https://metrics.torproject.org/rs.html#details/066735D43FB476FA64578C5D829E176DF53E5A00)                      |            0.006 |      0    |       0    |         1 | 2018-08-02   |
| 2065 | [07226079](https://metrics.torproject.org/rs.html#details/07226079499C8C6538A37A15EA1BBD35357AC63A)                                                                   |            0.006 |      0    |       0    |         1 | 2020-07-17   |
| 2066 | [arighttosurf &lt;arighttosurf tor -AT- melvex.xs4all.](https://metrics.torproject.org/rs.html#search/family:0A6001B1E3A9F5365BD3C2988BD69BB8EAD71289)                |            0.006 |      0    |       0    |         2 | 2016-12-29   |
| 2067 | [0B88C0F5](https://metrics.torproject.org/rs.html#details/0B88C0F5B40BA3507AB8962478E1DA6704A09E83)                                                                   |            0.006 |      0    |       0    |         1 | 2020-06-16   |
| 2068 | [0CE3B73D](https://metrics.torproject.org/rs.html#details/0CE3B73DDFF92FF6653A9C7F9003A32BB6C2364D)                                                                   |            0.006 |      0    |       0.01 |         1 | 2015-10-25   |
| 2069 | [freeasinbeer@techie.com](https://metrics.torproject.org/rs.html#details/0FADA801B150261109DD1F492BB10CE39C83A782)                                                    |            0.006 |      0    |       0.01 |         1 | 2015-11-05   |
| 2070 | [173EBA1F](https://metrics.torproject.org/rs.html#details/173EBA1FACA59718499AE8023187E5F95E8BF1C7)                                                                   |            0.006 |      0    |       0.01 |         1 | 2018-04-29   |
| 2071 | [Simon Hova &lt;simon AT hova dot net&gt;](https://metrics.torproject.org/rs.html#details/195A26A390C42A1CE9FA77D2FDC25FB65AE27D45)                                   |            0.006 |      0    |       0.01 |         1 | 2017-10-08   |
| 2072 | [1C792615](https://metrics.torproject.org/rs.html#details/1C79261551E0F938A0D3959E1F2D74A4B48263FA)                                                                   |            0.006 |      0    |       0    |         1 | 2020-06-24   |
| 2073 | [1D702DA4](https://metrics.torproject.org/rs.html#details/1D702DA43D588FE9D308D3879A6F5E61BB2ECCFA)                                                                   |            0.006 |      0    |       0    |         1 | 2020-08-10   |
| 2074 | [1D88F5D8](https://metrics.torproject.org/rs.html#details/1D88F5D86AE108640C347C36326DE2EA81A78040)                                                                   |            0.006 |      0    |       0    |         1 | 2019-12-15   |
| 2075 | [1EDE608C](https://metrics.torproject.org/rs.html#details/1EDE608C5E190C8682A2F827664E758416104670)                                                                   |            0.006 |      0    |       0.01 |         1 | 2016-10-30   |
| 2076 | [Admin &lt;tor@preussen.email&gt;](https://metrics.torproject.org/rs.html#details/1F9BE9467BCA4D7502CDCCEE79BA3E666868EC1C)                                           |            0.006 |      0    |       0.01 |         1 | 2020-05-31   |
| 2077 | [20629BBF](https://metrics.torproject.org/rs.html#details/20629BBF77EC896F2B3EFB01459B1BA773D89E67)                                                                   |            0.006 |      0    |       0    |         1 | 2020-04-23   |
| 2078 | [2076359F](https://metrics.torproject.org/rs.html#details/2076359FC3BEB6AB4D0F26C5419712A30CDE85D0)                                                                   |            0.006 |      0    |       0.01 |         1 | 2018-02-27   |
| 2079 | [214B459C](https://metrics.torproject.org/rs.html#details/214B459C69500C2CF07D14B00567353C52A885B7)                                                                   |            0.006 |      0    |       0    |         1 | 2020-08-07   |
| 2080 | [eyeman@posteo.ae](https://metrics.torproject.org/rs.html#details/221E976B546E60048A01950250399B8534D4E4B7)                                                           |            0.006 |      0    |       0.01 |         1 | 2018-07-13   |
| 2081 | [22B92BCC](https://metrics.torproject.org/rs.html#details/22B92BCCF5DE2C8CDCFFFD2D41B395D116A87BB3)                                                                   |            0.006 |      0    |       0    |         1 | 2020-08-10   |
| 2082 | [&lt;abuse at flokinet dot is&gt;](https://metrics.torproject.org/rs.html#details/24592DB1CDA066CDCA41F6403CED661839CDE223)                                           |            0.006 |      0.02 |       0    |         1 | 2018-01-07   |
| 2083 | [25E87454](https://metrics.torproject.org/rs.html#details/25E87454241CA8BDA9649114D28B5B1229B4EA7B)                                                                   |            0.006 |      0    |       0    |         1 | 2020-05-27   |
| 2084 | [th00ht &lt;kingma at bluewin.ch&gt;](https://metrics.torproject.org/rs.html#details/28B39D67BD18D13694DE03679EA4A864EB6977E9)                                        |            0.006 |      0    |       0    |         1 | 2017-02-02   |
| 2085 | [Tor Admin &lt;toradmin A@T esponde D0T net&gt;](https://metrics.torproject.org/rs.html#details/2A24E0B7F7D64B808D70FBE92E641C9D6FD99B3D)                             |            0.006 |      0.02 |       0    |         1 | 2017-11-10   |
| 2086 | [2B34099E](https://metrics.torproject.org/rs.html#search/family:2B34099ED2BC598C4745C96C873FD73A445646BD)                                                             |            0.006 |      0.02 |       0    |         3 | 2017-01-16   |
| 2087 | [2C1D30D1](https://metrics.torproject.org/rs.html#details/2C1D30D16B29FC6D1CC929C2DD947017C8F7ED04)                                                                   |            0.006 |      0.02 |       0    |         1 | 2020-08-05   |
| 2088 | [accvio &lt;accvio@gmx.net&gt;](https://metrics.torproject.org/rs.html#details/2ED8654AD1B8C25F3EB83156B07EA35BE6132F0C)                                              |            0.006 |      0    |       0    |         1 | 2020-07-01   |
| 2089 | [2FFBAEBC](https://metrics.torproject.org/rs.html#details/2FFBAEBC4D4A88CA96BD5F6B0D3A1D1A7A00D5F2)                                                                   |            0.006 |      0    |       0.01 |         1 | 2019-12-11   |
| 2090 | [Loiu92 contact@loiu92.com](https://metrics.torproject.org/rs.html#details/32E6CC6C6B428B2043F0B3E78F7332F1016D73E1)                                                  |            0.006 |      0    |       0.01 |         1 | 2018-09-24   |
| 2091 | [Team Tardis &lt;drwho@posteo.is&gt;](https://metrics.torproject.org/rs.html#details/330CD3DB6AD266DC70CDB512B036957D03D9BC59)                                        |            0.006 |      0    |       0    |         1 | 2014-07-09   |
| 2092 | [34AC6170](https://metrics.torproject.org/rs.html#details/34AC6170825ADD59DDD6042C9E5B6A9015B10CF0)                                                                   |            0.006 |      0    |       0    |         1 | 2020-07-28   |
| 2093 | [354F9C59](https://metrics.torproject.org/rs.html#details/354F9C59F2C2636E77F857C668FCDA1700E35384)                                                                   |            0.006 |      0    |       0    |         1 | 2020-06-22   |
| 2094 | [3847862C](https://metrics.torproject.org/rs.html#details/3847862C0A4926ACCB9B5ADCD6F62B6278D88812)                                                                   |            0.006 |      0    |       0.01 |         1 | 2020-03-19   |
| 2095 | [394BABB9](https://metrics.torproject.org/rs.html#details/394BABB9AAD8E66DA7F50891889B099C14BDE076)                                                                   |            0.006 |      0    |       0    |         1 | 2020-05-13   |
| 2096 | [tor-relay.co](https://metrics.torproject.org/rs.html#details/3968C52AD4459646D90EA40AFD2823DECD204085)                                                               |            0.006 |      0    |       0.01 |         1 | 2020-07-31   |
| 2097 | [abuse@support.tools noc@support.tools tor@su](https://metrics.torproject.org/rs.html#details/399B6E76080F8677D08B626CFFA7AB7ACB974D3E)                               |            0.006 |      0.02 |       0    |         1 | 2020-05-22   |
| 2098 | [39E785F7](https://metrics.torproject.org/rs.html#details/39E785F73A62FDE38C4797E61ABE512328E5C26C)                                                                   |            0.006 |      0    |       0    |         1 | 2020-06-30   |
| 2099 | [3E1FC622](https://metrics.torproject.org/rs.html#details/3E1FC6220A79BE7FB74CC9EFDC2B285FC02D56C7)                                                                   |            0.006 |      0    |       0    |         1 | 2020-06-22   |
| 2100 | [TorresDesNodes AT gmail dot com](https://metrics.torproject.org/rs.html#details/3F3E911D64F8DED71208D614782ABED41F4D7A0D)                                            |            0.006 |      0    |       0    |         1 | 2019-12-02   |
| 2101 | [436A18F1](https://metrics.torproject.org/rs.html#details/436A18F19C1212D6142BFD4894BDC9C5024F76F4)                                                                   |            0.006 |      0    |       0    |         1 | 2019-12-25   |
| 2102 | [Feidhlim &lt;feidhlim AT web DOT de&gt;](https://metrics.torproject.org/rs.html#search/family:445D891CE6C7AC3D80E1EDCA61F921D3A6E91CC5)                              |            0.006 |      0    |       0    |         2 | 2017-07-11   |
| 2103 | [Random Person &lt;abl.spam AT gmail d0t com&gt;](https://metrics.torproject.org/rs.html#details/457D6035A953805B82D2A9933EDE3A0EA4B675FE)                            |            0.006 |      0    |       0.01 |         1 | 2015-10-06   |
| 2104 | [45FD4012](https://metrics.torproject.org/rs.html#details/45FD401243854294783CD83673613FF565D9A662)                                                                   |            0.006 |      0    |       0.01 |         1 | 2018-08-23   |
| 2105 | [lln-contact at protonmail dot com](https://metrics.torproject.org/rs.html#details/46EC7BB31BFEC251B89E0C0715DEC4AA8208A1BA)                                          |            0.006 |      0    |       0.01 |         1 | 2020-06-22   |
| 2106 | [postmaster@km30701-02.keymachine.de](https://metrics.torproject.org/rs.html#details/4A3B874F0187F2CF0DA3C8F76063B070F9F7A14F)                                        |            0.006 |      0.02 |       0    |         1 | 2017-01-09   |
| 2107 | [4CDCC833](https://metrics.torproject.org/rs.html#details/4CDCC833FB70B9F3915522FDC90E52C531FEEC49)                                                                   |            0.006 |      0    |       0.01 |         1 | 2017-01-27   |
| 2108 | [Mitar &lt;mitar dot tor AT tnode dot com&gt;](https://metrics.torproject.org/rs.html#search/family:4CF9BAEB0DE6D7230D6B7DA0FF420C7CFD863885)                         |            0.006 |      0    |       0.01 |         2 | 2019-08-05   |
| 2109 | [4D524D24](https://metrics.torproject.org/rs.html#details/4D524D243B3D756C566484EB54B14AC43C7CE928)                                                                   |            0.006 |      0    |       0    |         1 | 2020-06-03   |
| 2110 | [Pianist G3 &lt;pianist g3@protonmail.com&gt;](https://metrics.torproject.org/rs.html#details/50E3CEA0D7EB9644B89B965743797279196775D5)                               |            0.006 |      0    |       0.01 |         1 | 2020-01-04   |
| 2111 | [vaa.red@protonmail.com](https://metrics.torproject.org/rs.html#details/5598C4CE251DD848C2C743DEF457EDEFAF3105C4)                                                     |            0.006 |      0    |       0.01 |         1 | 2020-06-22   |
| 2112 | [56222E9A](https://metrics.torproject.org/rs.html#details/56222E9AD751C806C0053A05C27711AC4FD7506B)                                                                   |            0.006 |      0    |       0    |         1 | 2020-08-07   |
| 2113 | [Random Person &lt;tor this too@aol.com&gt;](https://metrics.torproject.org/rs.html#details/564A7F1D0314125AF60096CDE0A887F286608240)                                 |            0.006 |      0    |       0.01 |         1 | 2016-10-06   |
| 2114 | [torrelay@tutanota.de](https://metrics.torproject.org/rs.html#details/57FC927F1CDADEC93380E247EE949A3787A0DB7E)                                                       |            0.006 |      0    |       0    |         1 | 2016-01-15   |
| 2115 | [59CA96E7](https://metrics.torproject.org/rs.html#details/59CA96E7CDA30AB36C597B499C848BD845745EA0)                                                                   |            0.006 |      0    |       0.01 |         1 | 2017-10-23   |
| 2116 | [5B01C6CD](https://metrics.torproject.org/rs.html#details/5B01C6CDB3C889ABB310865FA34693F3C39D7DF4)                                                                   |            0.006 |      0    |       0    |         1 | 2020-07-28   |
| 2117 | [&lt;onions at mit dot edu&gt;](https://metrics.torproject.org/rs.html#details/5C96895227E42FD74B4B1445A9AE59BD9FF42879)                                              |            0.006 |      0.02 |       0    |         1 | 2017-04-04   |
| 2118 | [Tor &lt;tor AT rymdis dot comm&gt;](https://metrics.torproject.org/rs.html#details/5CB30C264BB9EB17CF2FC6AEB611593B54C371C2)                                         |            0.006 |      0    |       0.01 |         1 | 2017-06-30   |
| 2119 | [Ivan &lt;ivan@prokudin.org&gt;](https://metrics.torproject.org/rs.html#details/5D9622326D1AE40F2F4D570BE1C7FC7505F3528C)                                             |            0.006 |      0    |       0.01 |         1 | 2015-10-24   |
| 2120 | [5DA69B08](https://metrics.torproject.org/rs.html#details/5DA69B086B833FC1DFCF2D9C8B9C3B03137C7EFD)                                                                   |            0.006 |      0    |       0    |         1 | 2017-05-13   |
| 2121 | [redshoerider &lt;redshoerider@gmail.com&gt;](https://metrics.torproject.org/rs.html#details/5DDCF0831430EA966917E6266A352F4F84A755D6)                                |            0.006 |      0    |       0    |         1 | 2018-08-19   |
| 2122 | [petrarca at protonmail.com](https://metrics.torproject.org/rs.html#details/605EE4375EE4C38215C8949F5808863749FD4F4A)                                                 |            0.006 |      0    |       0.01 |         1 | 2018-11-20   |
| 2123 | [63C61142](https://metrics.torproject.org/rs.html#details/63C611427D06B2342876B95F1F98CE70869354B9)                                                                   |            0.006 |      0    |       0    |         1 | 2020-08-04   |
| 2124 | [63E83D64](https://metrics.torproject.org/rs.html#details/63E83D6402652032A0034CD2BD50736436F5511F)                                                                   |            0.006 |      0    |       0    |         1 | 2020-06-28   |
| 2125 | [default8080@protonmail.com](https://metrics.torproject.org/rs.html#details/65888719E2F619E6198F1045A93AF0176C05354D)                                                 |            0.006 |      0    |       0.01 |         1 | 2020-05-23   |
| 2126 | [65C36259](https://metrics.torproject.org/rs.html#details/65C362597C3AB32C18442D45C061B08167E5F401)                                                                   |            0.006 |      0    |       0    |         1 | 2020-05-13   |
| 2127 | [1AKfiFWajSckVrArTVh21KkdPuegordE3E](https://metrics.torproject.org/rs.html#details/66905A83A4858A4DD075AEA0514377A9F59E110D)                                         |            0.006 |      0    |       0.01 |         1 | 2017-01-30   |
| 2128 | [&lt;tor AT reichster dot de&gt; BTC 1EVjr4PCB721B6j2yb](https://metrics.torproject.org/rs.html#search/family:669E5034B6DE2E2C7CFBCF9EAC8D9F5A47757996)               |            0.006 |      0    |       0    |         2 | 2014-04-10   |
| 2129 | [6CFC47B4](https://metrics.torproject.org/rs.html#details/6CFC47B46E42A9D76D47B911FB719E65308014EE)                                                                   |            0.006 |      0    |       0.01 |         1 | 2018-11-19   |
| 2130 | [6DFB4AC8](https://metrics.torproject.org/rs.html#details/6DFB4AC8B5E7B1AD0B3F5F465F774A421C66CBBA)                                                                   |            0.006 |      0    |       0.01 |         1 | 2020-03-21   |
| 2131 | [tor AT leenux dot de](https://metrics.torproject.org/rs.html#details/6E9642DDB353D044931029C036D1CAD832F3DFD7)                                                       |            0.006 |      0    |       0.01 |         1 | 2019-09-21   |
| 2132 | [6ED00DB1](https://metrics.torproject.org/rs.html#details/6ED00DB18B4516A9097FC005BE1679BFC9A4C752)                                                                   |            0.006 |      0    |       0    |         1 | 2020-08-07   |
| 2133 | [70090E9F](https://metrics.torproject.org/rs.html#details/70090E9F85FBE004EEBF58461FD6EDD5BF8A523E)                                                                   |            0.006 |      0    |       0.01 |         1 | 2019-01-10   |
| 2134 | [B54711E3 ben wilber &lt;ben@desync.com&gt;](https://metrics.torproject.org/rs.html#details/721E494B0E06554D8F9A169BDBF17282C07B2588)                                 |            0.006 |      0.02 |       0    |         1 | 2008-01-09   |
| 2135 | [dorin dot cretu at pm dot me](https://metrics.torproject.org/rs.html#search/family:7281E68A005357F57F183AF5B6937711D92C556B)                                         |            0.006 |      0    |       0    |         2 | 2020-05-21   |
| 2136 | [74DA18F4](https://metrics.torproject.org/rs.html#details/74DA18F45DE195D9E920B0EC10BF6958E44B0CEB)                                                                   |            0.006 |      0    |       0.01 |         1 | 2019-11-10   |
| 2137 | [gpg 0x30B2EA48D4602BD7 08FC958AD759FBBA1CB8D42F30B](https://metrics.torproject.org/rs.html#details/76DD184BC258220BA4657E88255972D27B84BA10)                         |            0.006 |      0    |       0.01 |         1 | 2015-01-02   |
| 2138 | [pub@420blaze.it](https://metrics.torproject.org/rs.html#details/76F3558CB26F41F89DEC685BAE666018B6AB808B)                                                            |            0.006 |      0    |       0.01 |         1 | 2018-10-24   |
| 2139 | [77177B29](https://metrics.torproject.org/rs.html#details/77177B29BF57C8E3256298F9243E2CB317A9D5B5)                                                                   |            0.006 |      0    |       0    |         1 | 2020-05-26   |
| 2140 | [0x52FC8E7BEDB7FCA2 Kunal Mehta &lt;legoktm AT riseup](https://metrics.torproject.org/rs.html#details/7B190463E733CC292AA4010D194D1798CD8EB9A0)                       |            0.006 |      0    |       0    |         1 | 2015-11-14   |
| 2141 | [tor-operator@jkl5group.com](https://metrics.torproject.org/rs.html#details/80AB167E463DC977F0B02D6880E63DC298029875)                                                 |            0.006 |      0    |       0    |         1 | 2020-01-08   |
| 2142 | [torabuse@cock.li](https://metrics.torproject.org/rs.html#details/81E7D5AEA47DA21030118297475DC59A01C291E1)                                                           |            0.006 |      0.02 |       0    |         1 | 2020-02-22   |
| 2143 | [8685144A](https://metrics.torproject.org/rs.html#details/8685144AB7D8587718973AD1C3C33F957081B70B)                                                                   |            0.006 |      0    |       0    |         1 | 2020-06-28   |
| 2144 | [870E97E5](https://metrics.torproject.org/rs.html#details/870E97E5846D8308EA469A5BB5A50D2838503DBE)                                                                   |            0.006 |      0    |       0.01 |         1 | 2018-09-07   |
| 2145 | [creideikitor@ferretporn.se](https://metrics.torproject.org/rs.html#details/88D5F0BD87F9BC1A96FCBFDCEDB1C0E6BAB1D14E)                                                 |            0.006 |      0    |       0.01 |         1 | 2011-06-11   |
| 2146 | [0x0w3n@gmail.com](https://metrics.torproject.org/rs.html#details/89AE5F96CB97919EF13B172E0E4E2CB50CC33F1A)                                                           |            0.006 |      0    |       0.01 |         1 | 2018-11-03   |
| 2147 | [nanea2000-tor@yahoo.com](https://metrics.torproject.org/rs.html#details/8ADA1AB31B9B49CFFF5A450816053BF4CB72E4AC)                                                    |            0.006 |      0    |       0    |         1 | 2020-07-05   |
| 2148 | [k0nsl &lt;tor-operator@k0nsl.org&gt;](https://metrics.torproject.org/rs.html#details/8C5155E33148B13CEF02197037D870A22B61BD05)                                       |            0.006 |      0.02 |       0    |         1 | 2020-06-26   |
| 2149 | [8F8911CE](https://metrics.torproject.org/rs.html#details/8F8911CEB5CAA353735DE1EF566B132AB649EF4C)                                                                   |            0.006 |      0    |       0.01 |         1 | 2020-06-11   |
| 2150 | [90CBC3F3](https://metrics.torproject.org/rs.html#details/90CBC3F3F13D5E0D5BFF3B1137A4AC64D389CF09)                                                                   |            0.006 |      0    |       0.01 |         1 | 2020-04-18   |
| 2151 | [91CF2158](https://metrics.torproject.org/rs.html#details/91CF21586AEDEA24D5D4177FC8E90B68A5DDE2E6)                                                                   |            0.006 |      0    |       0    |         1 | 2020-06-04   |
| 2152 | [tor@loves.pizza](https://metrics.torproject.org/rs.html#details/92E7BD70682F392900E4E2CDAE8B48635E9C9BE0)                                                            |            0.006 |      0    |       0.01 |         1 | 2020-06-10   |
| 2153 | [963074F6](https://metrics.torproject.org/rs.html#details/963074F6481D3F98C76D2F1A7B1FD9E1CBB4EC56)                                                                   |            0.006 |      0    |       0.01 |         1 | 2020-07-23   |
| 2154 | [admin@inktank.fi](https://metrics.torproject.org/rs.html#details/9638D8A46D8CBA79F8122D77E038ED99EBFDAEAD)                                                           |            0.006 |      0    |       0.01 |         1 | 2015-12-18   |
| 2155 | [Johann Bauer &lt;torrelay AT bauerj dot eu&gt;](https://metrics.torproject.org/rs.html#details/970F0966DAA7EBDEE44E3772045527A6854E997B)                             |            0.006 |      0    |       0    |         1 | 2020-02-09   |
| 2156 | [9DC8B028](https://metrics.torproject.org/rs.html#details/9DC8B0282A8D3C45212167C454B503243BC93957)                                                                   |            0.006 |      0    |       0.01 |         1 | 2016-05-04   |
| 2157 | [A0783296](https://metrics.torproject.org/rs.html#details/A07832966655991EB58B33FB602F817B83DBC771)                                                                   |            0.006 |      0    |       0    |         1 | 2020-08-09   |
| 2158 | [A1915DFA](https://metrics.torproject.org/rs.html#details/A1915DFA36B3EF33DCC9021ACF1A955C51BF0979)                                                                   |            0.006 |      0    |       0.01 |         1 | 2020-07-19   |
| 2159 | [A200D847](https://metrics.torproject.org/rs.html#details/A200D847B1C818F93AF3243B3D5DDA6FE0F6D871)                                                                   |            0.006 |      0    |       0    |         1 | 2020-05-21   |
| 2160 | [A3407CC4](https://metrics.torproject.org/rs.html#details/A3407CC403CF39DFA40ED9E1D14A8B54431F6104)                                                                   |            0.006 |      0    |       0.01 |         1 | 2014-05-31   |
| 2161 | [noc@kpfa.org](https://metrics.torproject.org/rs.html#details/A50CFA07258E3CEA7B06FC9B6248A257565287F5)                                                               |            0.006 |      0    |       0    |         1 | 2020-05-01   |
| 2162 | [A5AF5D19](https://metrics.torproject.org/rs.html#details/A5AF5D1904550DD27B1C50872D9496C73D916AEE)                                                                   |            0.006 |      0    |       0.01 |         1 | 2019-05-14   |
| 2163 | [A6279DA3](https://metrics.torproject.org/rs.html#details/A6279DA3323160956E3B465B159F5A061420A118)                                                                   |            0.006 |      0    |       0    |         1 | 2020-06-09   |
| 2164 | [A66E9F0E](https://metrics.torproject.org/rs.html#details/A66E9F0E5646A16379D716431388EB64661D10D5)                                                                   |            0.006 |      0    |       0    |         1 | 2020-05-21   |
| 2165 | [A7D17597](https://metrics.torproject.org/rs.html#details/A7D17597A67F0AD64EE1F3A414A0ADCA00801747)                                                                   |            0.006 |      0    |       0.01 |         1 | 2014-04-24   |
| 2166 | [Nona Admin &lt;admin AT nonanet dot net&gt;](https://metrics.torproject.org/rs.html#details/A8FCDB8C12CDBA4978864613A70B396DCAD4CED5)                                |            0.006 |      0.02 |       0    |         1 | 2019-09-24   |
| 2167 | [John Doe &lt;tZbU8n3W7Y AT protonmail dot ch&gt;](https://metrics.torproject.org/rs.html#details/ACF71422AF4174B8F12751BCDF6B13BD22D8E01F)                           |            0.006 |      0    |       0    |         1 | 2019-10-21   |
| 2168 | [e5bd61de-e40c-432e-8bbe-543843074571@tordiversity.](https://metrics.torproject.org/rs.html#details/ACF8FC6C14032A045B44F6B98525EE5C0472DD50)                         |            0.006 |      0    |       0.01 |         1 | 2020-01-18   |
| 2169 | [4096R/1EE96C8A375D94EC46E1F93F12CD89085C726CB4 Jan](https://metrics.torproject.org/rs.html#details/AD19490C7DBB26D3A68EFC824F67E69B0A96E601)                         |            0.006 |      0    |       0.01 |         1 | 2011-08-28   |
| 2170 | [AD76F68E](https://metrics.torproject.org/rs.html#details/AD76F68E461FAF90D9A93221A994A0F6F84DD6A3)                                                                   |            0.006 |      0    |       0.01 |         1 | 2020-05-27   |
| 2171 | [&lt;tor-master -at- pseudonetworks.eu&gt;](https://metrics.torproject.org/rs.html#details/AFA0C24F635C3E198A151D09A796430F0778BA65)                                  |            0.006 |      0    |       0.01 |         1 | 2020-04-13   |
| 2172 | [0xFD7DF541 Elude.in TorOperator &lt;tor@elude.in&gt;](https://metrics.torproject.org/rs.html#details/B05B3AB0159238FB7AEB1BF08A406D6F31A45ADF)                       |            0.006 |      0    |       0    |         1 | 2020-08-05   |
| 2173 | [B214C768](https://metrics.torproject.org/rs.html#details/B214C768C88BB08F017BE30CBB603939F3DDA661)                                                                   |            0.006 |      0    |       0.01 |         1 | 2019-12-05   |
| 2174 | [Anonymous](https://metrics.torproject.org/rs.html#details/B26E8B962FB76404C169634571B4C5687AC6230F)                                                                  |            0.006 |      0    |       0.01 |         1 | 2020-06-29   |
| 2175 | [B5831845](https://metrics.torproject.org/rs.html#details/B5831845F631C3E053B12D4714332E930219A014)                                                                   |            0.006 |      0    |       0.01 |         1 | 2014-11-24   |
| 2176 | [mistralis A T protonmail c &amp; o $ m](https://metrics.torproject.org/rs.html#details/B87343240E9DE48ECBAA4E064F8B8F21650F74A5)                                     |            0.006 |      0    |       0    |         1 | 2017-12-20   |
| 2177 | [B9609107](https://metrics.torproject.org/rs.html#details/B9609107E25BCA7803F7A2D205CE8FAE3F5086CE)                                                                   |            0.006 |      0    |       0.01 |         1 | 2015-12-09   |
| 2178 | [B9877C7A](https://metrics.torproject.org/rs.html#details/B9877C7A9EAD7439C186B6B4C2885612BA379874)                                                                   |            0.006 |      0    |       0.01 |         1 | 2019-03-25   |
| 2179 | [B9C1484B](https://metrics.torproject.org/rs.html#details/B9C1484B549CFE20B4147C819DC510D83B1EA513)                                                                   |            0.006 |      0    |       0    |         1 | 2020-05-25   |
| 2180 | [http://smkxbwwmlrfiwifw2twzijuwolzutwwwlucc2wcgl6p](https://metrics.torproject.org/rs.html#details/B9FC8DFA8939C129BE76CD65EBBACA7DDAEF84F5)                         |            0.006 |      0    |       0    |         1 | 2020-06-30   |
| 2181 | [BB0C636D](https://metrics.torproject.org/rs.html#details/BB0C636DE89CAC6C995CB380AAC8C4AAAB731BA8)                                                                   |            0.006 |      0    |       0.01 |         1 | 2016-05-22   |
| 2182 | [mo@tor.nonze.ro](https://metrics.torproject.org/rs.html#details/BBBBBAD453263D786EC34AB68A06214288910345)                                                            |            0.006 |      0    |       0.01 |         1 | 2015-07-10   |
| 2183 | [C05CE5DB](https://metrics.torproject.org/rs.html#details/C05CE5DB16F4921BAFFAF58585BE90D0A3980FEB)                                                                   |            0.006 |      0    |       0    |         1 | 2020-07-22   |
| 2184 | [C3189F00](https://metrics.torproject.org/rs.html#details/C3189F000C3A681CED1E892C71736F4A5DF55763)                                                                   |            0.006 |      0    |       0    |         1 | 2020-06-29   |
| 2185 | [tor@jerail.ca](https://metrics.torproject.org/rs.html#details/C442318188873D941B19C2626EC6E651912B46DB)                                                              |            0.006 |      0    |       0.01 |         1 | 2020-01-13   |
| 2186 | [All your concerns are sent to /dev/null thx](https://metrics.torproject.org/rs.html#details/C4D43EC18179F7B2E8187D7E284D6D547217B39E)                                |            0.006 |      0    |       0.01 |         1 | 2020-04-08   |
| 2187 | [6723338514695513 at gmail dot com tor-relay.co](https://metrics.torproject.org/rs.html#details/C67C33C76CDC33DD72FAA77535B48D7E96C006D2)                             |            0.006 |      0.02 |       0    |         1 | 2019-12-02   |
| 2188 | [C680718A](https://metrics.torproject.org/rs.html#details/C680718A6F51A8F7C5D4E68269ED5B2C07FE531B)                                                                   |            0.006 |      0    |       0.01 |         1 | 2019-12-03   |
| 2189 | [AngelFreak &lt;angelfreak@tsrv.pw&gt;](https://metrics.torproject.org/rs.html#details/C74E2C7FB511861A489C60F7503A6FD74C12723E)                                      |            0.006 |      0    |       0.01 |         1 | 2018-12-01   |
| 2190 | [gmyzlfua3@relay.firefox.com](https://metrics.torproject.org/rs.html#details/C78D4AB34C920D156160C811C39B1BB92A6BED7D)                                                |            0.006 |      0    |       0.01 |         1 | 2020-08-04   |
| 2191 | [0x1C2B59D135303F2420A34C79916277102C448DE2 Operato](https://metrics.torproject.org/rs.html#details/C79B6CDDC423E662E33370E57CBBAF7BC1CC1A4A)                         |            0.006 |      0    |       0.01 |         1 | 2020-06-09   |
| 2192 | [postmaster@tcp.direct](https://metrics.torproject.org/rs.html#details/C8CA058096CE7C335CABEAD465A4C7B0071F53E2)                                                      |            0.006 |      0.02 |       0    |         1 | 2020-06-23   |
| 2193 | [0x7135A006B28E1285 ProstoVPN &lt;admin AT prostovpn d](https://metrics.torproject.org/rs.html#details/C9A821C76CA072D7D4D368E04CDDDA195B1F5C4F)                      |            0.006 |      0    |       0.01 |         1 | 2017-06-05   |
| 2194 | [tor@remus.be](https://metrics.torproject.org/rs.html#details/CA0F5916F21477EAD36E53FD7A3D0EEA5FDA2FA6)                                                               |            0.006 |      0    |       0    |         1 | 2019-11-08   |
| 2195 | [saper on IRC](https://metrics.torproject.org/rs.html#details/CB3FF8574F429CFADEF0B103EB84390A68385E76)                                                               |            0.006 |      0    |       0.01 |         1 | 2018-05-06   |
| 2196 | [CC27183E](https://metrics.torproject.org/rs.html#details/CC27183EF95AAA7E8BACF8326615D701C500C42C)                                                                   |            0.006 |      0    |       0    |         1 | 2020-06-23   |
| 2197 | [jim yt &lt;jimyt AT protonmail dod com&gt;](https://metrics.torproject.org/rs.html#details/CCF2FD0048FCC9A842BE881472CEC148BB4EF458)                                 |            0.006 |      0    |       0.01 |         1 | 2019-08-19   |
| 2198 | [CCFEE64F](https://metrics.torproject.org/rs.html#details/CCFEE64FBA43BA51F499877172B2D8E4588E4D81)                                                                   |            0.006 |      0    |       0    |         1 | 2020-07-02   |
| 2199 | [https://it-syndikat.org](https://metrics.torproject.org/rs.html#details/CE6813FEA256EE63BCD2A178E453202BFAA64FA7)                                                    |            0.006 |      0    |       0    |         1 | 2018-03-17   |
| 2200 | [CED424DF](https://metrics.torproject.org/rs.html#details/CED424DF844971572655A1351D159ED79B6C1511)                                                                   |            0.006 |      0    |       0    |         1 | 2020-07-17   |
| 2201 | [CFA7447C](https://metrics.torproject.org/rs.html#details/CFA7447C66A709932F038FEE6B028B84A6E676E8)                                                                   |            0.006 |      0    |       0.01 |         1 | 2015-05-05   |
| 2202 | [0x374FD7E48B4A5331DDB854593715E08D021ED4D6 John Do](https://metrics.torproject.org/rs.html#details/D0F09FA43F68E134B9E56743797D040F647174D1)                         |            0.006 |      0    |       0.01 |         1 | 2018-04-04   |
| 2203 | [tor@hexaly.se](https://metrics.torproject.org/rs.html#details/D1640589B1C0CC8BC657E07F9F739C267C08A768)                                                              |            0.006 |      0    |       0.01 |         1 | 2016-06-05   |
| 2204 | [D27D4841](https://metrics.torproject.org/rs.html#details/D27D4841C13B87A140F09246D5321E99C6824BB2)                                                                   |            0.006 |      0.02 |       0    |         1 | 2019-03-25   |
| 2205 | [D4C16732](https://metrics.torproject.org/rs.html#details/D4C16732E765EB52EB0B749DB35DC14C8E0DF996)                                                                   |            0.006 |      0    |       0.01 |         1 | 2018-06-17   |
| 2206 | [zouzounella AT riseup dot net](https://metrics.torproject.org/rs.html#details/DDBB2A38252ADDA53E4492DDF982CA6CC6E10EC0)                                              |            0.006 |      0    |       0.01 |         1 | 2015-08-12   |
| 2207 | [Toma Marini &lt;toma.marini at gmail&gt;](https://metrics.torproject.org/rs.html#details/DFF9E741D00F74998FE83CD6260EE4D9E0B0DBFA)                                   |            0.006 |      0    |       0    |         1 | 2019-08-31   |
| 2208 | [jackyes89 at protonmail dot com](https://metrics.torproject.org/rs.html#details/E37EE4F0A46D63AA6081A8C4D8C584885D1EAD0A)                                            |            0.006 |      0.02 |       0    |         1 | 2020-07-01   |
| 2209 | [0x68742E2C Finn Herzfeld &lt;finn@seattlemesh.net&gt; -](https://metrics.torproject.org/rs.html#details/E4E27D80236B421FAEA25797495B57E36FF9F7C2)                    |            0.006 |      0    |       0.01 |         1 | 2014-09-15   |
| 2210 | [SQUAREFLOW &lt;torproject@squareflow.net&gt;](https://metrics.torproject.org/rs.html#details/E501166B9D93277E7CD83A97A31A38167F8207E9)                               |            0.006 |      0.02 |       0    |         1 | 2020-08-08   |
| 2211 | [E6E2DA3A](https://metrics.torproject.org/rs.html#details/E6E2DA3A7F67886997C40F98EE1F3058FFBDBEDE)                                                                   |            0.006 |      0    |       0    |         1 | 2020-05-19   |
| 2212 | [tor at leenux dot de](https://metrics.torproject.org/rs.html#details/E834DB28D15508AC04BAE32F795B7781691DFAB4)                                                       |            0.006 |      0    |       0    |         1 | 2019-10-23   |
| 2213 | [EA74330D](https://metrics.torproject.org/rs.html#details/EA74330DE9BCAE0AA83388F8BA844A31DD20D7C4)                                                                   |            0.006 |      0    |       0    |         1 | 2020-06-24   |
| 2214 | [support @ TORdashRELAYdotUS](https://metrics.torproject.org/rs.html#details/EA8CEAA8939F20108D4388B6EAE867A5AC6442C1)                                                |            0.006 |      0    |       0    |         1 | 2017-08-29   |
| 2215 | [scott AT ashcraft DOT com](https://metrics.torproject.org/rs.html#details/EC0ABA811E4EB33DAD8BC8B7037D862BF4F3AA28)                                                  |            0.006 |      0    |       0.01 |         1 | 2017-06-03   |
| 2216 | [EC8D71DA](https://metrics.torproject.org/rs.html#details/EC8D71DA87C4A98B910170E3C42A2CE329223398)                                                                   |            0.006 |      0    |       0    |         1 | 2020-06-22   |
| 2217 | [EE76A076](https://metrics.torproject.org/rs.html#details/EE76A07632C5081AC1F3BF7EA3B9D40C6F24E180)                                                                   |            0.006 |      0    |       0    |         1 | 2019-09-14   |
| 2218 | [EFF7FB34](https://metrics.torproject.org/rs.html#details/EFF7FB34C593A9D347DDC7A53F20DAC9FB8E9AD3)                                                                   |            0.006 |      0    |       0    |         1 | 2020-07-11   |
| 2219 | [uwusystem@protonmail.com](https://metrics.torproject.org/rs.html#details/F10FD777DF1CD03FA4B6FD51663EC30CC654F08B)                                                   |            0.006 |      0    |       0.01 |         1 | 2019-12-08   |
| 2220 | [F1A18D7B](https://metrics.torproject.org/rs.html#details/F1A18D7B42B896DE9D89604C610026A3B01A8A00)                                                                   |            0.006 |      0    |       0    |         1 | 2020-05-26   |
| 2221 | [Peter Rodge &lt;peter.rodge20 AT protonmail dot com&gt;](https://metrics.torproject.org/rs.html#details/F2ED5032B52021E7BADBBB82E6594F1A872FFD09)                    |            0.006 |      0    |       0.01 |         1 | 2015-04-26   |
| 2222 | [F32B9018](https://metrics.torproject.org/rs.html#details/F32B9018EE30154998BEE698941BAC093894008C)                                                                   |            0.006 |      0    |       0    |         1 | 2020-05-21   |
| 2223 | [mailuser11 at web dot de](https://metrics.torproject.org/rs.html#details/F43188DAE9A3F22C643CD7B8B3C8FEDB93AA8E12)                                                   |            0.006 |      0    |       0    |         1 | 2019-12-11   |
| 2224 | [Igel &lt;car@bonne.se&gt;](https://metrics.torproject.org/rs.html#details/F98141F6513DAB0BC4B70C1CE78D087004B14EF1)                                                  |            0.006 |      0    |       0    |         1 | 2020-01-09   |
| 2225 | [F9BDA399](https://metrics.torproject.org/rs.html#details/F9BDA3990E2C84DFBF57C8D0B77E1E21109C210D)                                                                   |            0.006 |      0    |       0    |         1 | 2020-07-22   |
| 2226 | [2jvi79pev6sygv0 Random Person &lt;nobody AT example d](https://metrics.torproject.org/rs.html#details/FD2F9B881AC640100C428DF47DC9A863DC2F2536)                      |            0.006 |      0    |       0.01 |         1 | 2015-12-05   |
| 2227 | [FE98F49C](https://metrics.torproject.org/rs.html#details/FE98F49C07684C6F6E03C40C8F7DE57098688468)                                                                   |            0.006 |      0    |       0    |         1 | 2020-06-23   |
| 2228 | [FF3059E7](https://metrics.torproject.org/rs.html#details/FF3059E77E5D22F1C3B20CCBE125691AD27588DD)                                                                   |            0.006 |      0    |       0.01 |         1 | 2018-01-26   |
| 2229 | [0042B9F5](https://metrics.torproject.org/rs.html#details/0042B9F5B608D06DBFF5C075C84F2BBB9B294A5B)                                                                   |            0.005 |      0    |       0    |         1 | 2020-06-22   |
| 2230 | [0xFFFFFFFF Random Person &lt;nobody AT example dot co](https://metrics.torproject.org/rs.html#details/02ED4F8DB11F1303BA21B16AA1CF2A0A48547ACA)                      |            0.005 |      0    |       0    |         1 | 2017-09-16   |
| 2231 | [0x3C68C8DBCBA783EF Joel R. Voss &lt;jvoss at altsci d](https://metrics.torproject.org/rs.html#details/040A7442349A2AC92233C2470D6C4F2BD02EDF15)                      |            0.005 |      0.01 |       0    |         1 | 2013-02-14   |
| 2232 | [torrelay AT tuta DOT io](https://metrics.torproject.org/rs.html#details/050528A16CCB9B1DB5AED6F3F886F0D3B244CE60)                                                    |            0.005 |      0    |       0    |         1 | 2018-11-29   |
| 2233 | [05AD6F49](https://metrics.torproject.org/rs.html#details/05AD6F4906142276C606558C9C3B8876B43CD90F)                                                                   |            0.005 |      0.01 |       0    |         1 | 2020-04-22   |
| 2234 | [06C0E28F](https://metrics.torproject.org/rs.html#details/06C0E28FB10CF9AA22CECAB8D144FC9CD33F494B)                                                                   |            0.005 |      0    |       0    |         1 | 2020-05-18   |
| 2235 | [Gka7WiR8HiDuwxvcGvK@protonmail.com](https://metrics.torproject.org/rs.html#details/08030D75D691B04FEFCBADCD9B512DCC8DD7FC0F)                                         |            0.005 |      0    |       0    |         1 | 2020-07-26   |
| 2236 | [Anon &lt;exit@cryptoisnotacrime.org&gt;](https://metrics.torproject.org/rs.html#search/family:08394C4873C8A71BE9F53593F9B4AD694BFCDB90)                              |            0.005 |      0.01 |       0    |         3 | 2018-12-17   |
| 2237 | [psn61@hotmail.com](https://metrics.torproject.org/rs.html#search/family:0869EA503377C702669BC75DD7A59094658DFA08)                                                    |            0.005 |      0    |       0    |         2 | 2018-10-07   |
| 2238 | [09F30674](https://metrics.torproject.org/rs.html#details/09F3067452D8D1DAFD33D0524A41DBF5295D3472)                                                                   |            0.005 |      0    |       0    |         1 | 2020-03-03   |
| 2239 | [1108mario at gmail dot com - mariox2yqtn6h4bm6nqyr](https://metrics.torproject.org/rs.html#details/0ACD9B1271E95AC1743B9EC1299BB294BD3EBD90)                         |            0.005 |      0    |       0    |         1 | 2020-07-25   |
| 2240 | [0AD5DC3C](https://metrics.torproject.org/rs.html#details/0AD5DC3C47CAD362E5682F7FBD5E2E28B2D49899)                                                                   |            0.005 |      0    |       0    |         1 | 2016-01-31   |
| 2241 | [0x5eead6e4206b0ae9 James Kruth &lt;james@kruth.org&gt;](https://metrics.torproject.org/rs.html#details/0E5D730466E5BB675BC9704C374DBE7E19F06165)                     |            0.005 |      0    |       0    |         1 | 2016-10-02   |
| 2242 | [postmaster@bougeret.fr](https://metrics.torproject.org/rs.html#details/0FAED0B7D3D009CA13A57A8849CFEAC1456FAF47)                                                     |            0.005 |      0    |       0    |         1 | 2018-09-23   |
| 2243 | [1170C726](https://metrics.torproject.org/rs.html#search/family:1170C7261B5A68ADA5CA260879F48722D697EB74)                                                             |            0.005 |      0.01 |       0    |         2 | 2020-08-02   |
| 2244 | [1227BD65](https://metrics.torproject.org/rs.html#details/1227BD658FA6DF5CA4D1E5E148330FB007C827A2)                                                                   |            0.005 |      0    |       0    |         1 | 2020-06-21   |
| 2245 | [12B6C5B3](https://metrics.torproject.org/rs.html#details/12B6C5B34B03988D86A48B88F7922157AAD8FFD7)                                                                   |            0.005 |      0    |       0    |         1 | 2016-05-03   |
| 2246 | [tor@as208196.net](https://metrics.torproject.org/rs.html#details/13A34AD03EE2DF8B7193851DD8E795ADDE280A3D)                                                           |            0.005 |      0.01 |       0    |         1 | 2020-08-11   |
| 2247 | [0xBE6B3636 walafc0 &lt;tor AT walafc0 dot orgy minus](https://metrics.torproject.org/rs.html#details/15571673BCE30678EC5F895C9F59EB1C01CBBC56)                       |            0.005 |      0    |       0    |         1 | 2014-12-29   |
| 2248 | [15FEE423](https://metrics.torproject.org/rs.html#details/15FEE423DFF8AF9E2E081959B0C6326072C60DA1)                                                                   |            0.005 |      0    |       0.01 |         1 | 2020-02-21   |
| 2249 | [black-dura@pm.me tor-relay.co](https://metrics.torproject.org/rs.html#details/17FCC0ADFD2ACE711C881B2016778A11E5967DCB)                                              |            0.005 |      0.01 |       0    |         1 | 2020-08-02   |
| 2250 | [CE1782624600EE98764C6D9CCB8FC772D1AA1D30](https://metrics.torproject.org/rs.html#details/18EEE9D8553BA0171A7967CEB96366864EF0E552)                                   |            0.005 |      0    |       0    |         1 | 2018-12-15   |
| 2251 | [1A43588B](https://metrics.torproject.org/rs.html#details/1A43588BBE1239EA896DD06C22DAB20C0C5E68EF)                                                                   |            0.005 |      0    |       0    |         1 | 2019-12-19   |
| 2252 | [1B818817](https://metrics.torproject.org/rs.html#details/1B8188170F0AD7998A7D04BD5CE9F6128B032C8E)                                                                   |            0.005 |      0    |       0    |         1 | 2016-09-21   |
| 2253 | [1C84C891](https://metrics.torproject.org/rs.html#details/1C84C89198911D0C8962AA65C3E4E6530075396E)                                                                   |            0.005 |      0    |       0    |         1 | 2019-11-03   |
| 2254 | [1DE70504](https://metrics.torproject.org/rs.html#details/1DE70504C6E9BB223E2EC4FAD45C68C07A6AE9FB)                                                                   |            0.005 |      0    |       0    |         1 | 2017-12-07   |
| 2255 | [1EDE3619](https://metrics.torproject.org/rs.html#details/1EDE36198865B97C22D94D94E4097C8BE963C33F)                                                                   |            0.005 |      0    |       0    |         1 | 2018-01-09   |
| 2256 | [&lt;tor AT skeps dot ch&gt; Bitcoin:1HHffS7mV3sCgGVn6RH3](https://metrics.torproject.org/rs.html#details/1FBAE723F8186847E30EA1C03CCA3D4081D4E2F9)                   |            0.005 |      0    |       0    |         1 | 2016-05-16   |
| 2257 | [20524B5F](https://metrics.torproject.org/rs.html#details/20524B5FE774360FA325CECB2109C42BD00BD8D2)                                                                   |            0.005 |      0    |       0    |         1 | 2020-06-23   |
| 2258 | [229A21B9](https://metrics.torproject.org/rs.html#details/229A21B9912BD92D696841F77BDEC95A23B67594)                                                                   |            0.005 |      0    |       0    |         1 | 2020-06-04   |
| 2259 | [241BC5CA](https://metrics.torproject.org/rs.html#details/241BC5CA1085B12D48574129F4ACED77A7A65377)                                                                   |            0.005 |      0    |       0    |         1 | 2020-05-20   |
| 2260 | [sysadmin &lt;postmaster at siblings dotnet&gt;](https://metrics.torproject.org/rs.html#details/2464456C287E71583A6EADFCF82959722B6E96FF)                             |            0.005 |      0    |       0    |         1 | 2014-04-10   |
| 2261 | [mindesbunister@protonmail.com](https://metrics.torproject.org/rs.html#details/2802B96E4BE4FDBFB0F5D5DFBF7E5AB541A18DF0)                                              |            0.005 |      0    |       0    |         1 | 2020-08-09   |
| 2262 | [9732518249149918 at gmail dot com tor-relay.co](https://metrics.torproject.org/rs.html#details/285B3195256DEA66C7F58C0596B17D923788056C)                             |            0.005 |      0.01 |       0    |         1 | 2020-02-18   |
| 2263 | [2D416970](https://metrics.torproject.org/rs.html#details/2D41697016C0070174BF079BADA7207604086A15)                                                                   |            0.005 |      0    |       0    |         1 | 2020-03-10   |
| 2264 | [2DD35007](https://metrics.torproject.org/rs.html#details/2DD3500784350803F0040C6556B02F38A0B5F3FA)                                                                   |            0.005 |      0    |       0    |         1 | 2020-07-06   |
| 2265 | [0x60C0742D1F357D42 Sergey Popov &lt;admintor AT pink](https://metrics.torproject.org/rs.html#details/2E72CDAFA12AE1547795F9BAFF402FC16B653CE0)                       |            0.005 |      0    |       0    |         1 | 2017-03-14   |
| 2266 | [Nona Admin &lt;admin AT nonanet dot net&gt;](https://metrics.torproject.org/rs.html#details/2E7D76BBBD22B813F9E3C8DA1715C3B919D8CEF2)                                |            0.005 |      0.01 |       0    |         1 | 2019-09-24   |
| 2267 | [jeff@mulb.us](https://metrics.torproject.org/rs.html#details/31DDF87B0464C8AA3715F9AC93E8A619E60E5031)                                                               |            0.005 |      0    |       0    |         1 | 2017-05-28   |
| 2268 | [F5B41164-011F-4D30-93C2-CB8472E9CE4E@tutanota.com](https://metrics.torproject.org/rs.html#details/3351BC69807F3C9BACF7C317263D917252160462)                          |            0.005 |      0    |       0    |         1 | 2020-07-14   |
| 2269 | [34C53284](https://metrics.torproject.org/rs.html#details/34C532849438CF58DAE90FFA43ABF6D793DF2C3E)                                                                   |            0.005 |      0    |       0    |         1 | 2020-08-09   |
| 2270 | [6201219709093186 at gmail dot com tor-relay.co](https://metrics.torproject.org/rs.html#details/350AB72B8744CC40ED8699E6D3298CB14215F568)                             |            0.005 |      0.01 |       0    |         1 | 2019-12-02   |
| 2271 | [BMTY90VKYRQPUJZOTH @ Safe-mail.net](https://metrics.torproject.org/rs.html#details/37A8BA9E3F05417EFE93DF626641EFF271E0A3C2)                                         |            0.005 |      0    |       0    |         1 | 2020-07-28   |
| 2272 | [Random Person &lt;4349jbk1gi33@mail.ru&gt;](https://metrics.torproject.org/rs.html#details/38EF2FCFE72C49C634FE082D6CAB5D8F423B4626)                                 |            0.005 |      0    |       0    |         1 | 2020-01-24   |
| 2273 | [3A144BCB](https://metrics.torproject.org/rs.html#details/3A144BCB2681ABA103B83D553BEFC3EB99A11801)                                                                   |            0.005 |      0    |       0    |         1 | 2020-02-15   |
| 2274 | [3A752843](https://metrics.torproject.org/rs.html#details/3A7528436E0DD9675FB12750F3EDE23CF74F4ACB)                                                                   |            0.005 |      0    |       0    |         1 | 2016-12-01   |
| 2275 | [https://www.atagar.com/contact/](https://metrics.torproject.org/rs.html#details/3BB34C63072D9D10E836EE42968713F7B9325F66)                                            |            0.005 |      0    |       0    |         1 | 2018-04-16   |
| 2276 | [3C79702B](https://metrics.torproject.org/rs.html#details/3C79702BCC4AA498CB8E9FEC8A51A72AE89169EA)                                                                   |            0.005 |      0    |       0    |         1 | 2019-12-27   |
| 2277 | [3CBC541F](https://metrics.torproject.org/rs.html#details/3CBC541F2A763ADD7BF742919229251E2C065E4E)                                                                   |            0.005 |      0    |       0    |         1 | 2018-11-20   |
| 2278 | [3D3A99DF](https://metrics.torproject.org/rs.html#details/3D3A99DF54D6AEC5190CFB4C0B8D26172A8A2E59)                                                                   |            0.005 |      0    |       0    |         1 | 2019-11-22   |
| 2279 | [435397A3](https://metrics.torproject.org/rs.html#details/435397A34B281D8F31ED3EC388FC692C8D06CEA0)                                                                   |            0.005 |      0    |       0    |         1 | 2020-08-09   |
| 2280 | [478B0E18](https://metrics.torproject.org/rs.html#details/478B0E18930CA4117369679AF329FC49D9110966)                                                                   |            0.005 |      0    |       0    |         1 | 2017-02-24   |
| 2281 | [husky rulez@mail.com](https://metrics.torproject.org/rs.html#details/4A5147952EE35534F7B69387FF3D408C8EE66D68)                                                       |            0.005 |      0.01 |       0    |         1 | 2020-03-08   |
| 2282 | [4D7495E2](https://metrics.torproject.org/rs.html#details/4D7495E2EC2BC0CA6D2B4028C0131E68E8DFCED9)                                                                   |            0.005 |      0    |       0    |         1 | 2020-07-08   |
| 2283 | [kork on IRC - 1MW6HaqB3tMrCmjMTrBLvdMDGLDtKGDdGK](https://metrics.torproject.org/rs.html#details/4EACB1DF4BD42524AEA6A1B8026617B1BF59045C)                           |            0.005 |      0    |       0    |         1 | 2019-09-15   |
| 2284 | [ctci@fastimap.com](https://metrics.torproject.org/rs.html#details/51142A1DF64451C7750ECB85788364A68A07CEC2)                                                          |            0.005 |      0    |       0.01 |         1 | 2019-07-26   |
| 2285 | [5184B773](https://metrics.torproject.org/rs.html#details/5184B773C183CBDE68B70E0F36FF4BA076ECA798)                                                                   |            0.005 |      0    |       0    |         1 | 2020-06-15   |
| 2286 | [Kaarli Tor &lt;tor AT bertho dot fr&gt;](https://metrics.torproject.org/rs.html#details/537DFC2019C77FF60A0A29BEF358F7F6D6C68688)                                    |            0.005 |      0    |       0.01 |         1 | 2016-09-14   |
| 2287 | [53B8B5C2](https://metrics.torproject.org/rs.html#details/53B8B5C2A33C489B54300D558BFEE2C3B12F3875)                                                                   |            0.005 |      0    |       0    |         1 | 2018-08-12   |
| 2288 | [5414BCD1](https://metrics.torproject.org/rs.html#details/5414BCD1B6E8A050DFDF832993E237792F8021D2)                                                                   |            0.005 |      0    |       0    |         1 | 2020-06-30   |
| 2289 | [55F7F56D](https://metrics.torproject.org/rs.html#details/55F7F56D58C8C40A9A9DF3D508C1F26A04DE360C)                                                                   |            0.005 |      0    |       0    |         1 | 2020-04-16   |
| 2290 | [6539327831720688 at gmail dot com tor-relay.co](https://metrics.torproject.org/rs.html#details/5847D5A01C47166143F738C7703344517B39EB10)                             |            0.005 |      0.01 |       0    |         1 | 2019-12-02   |
| 2291 | [58D4BC98](https://metrics.torproject.org/rs.html#details/58D4BC985B8B620EED0AB54DA7AE46E1C100BC0C)                                                                   |            0.005 |      0    |       0    |         1 | 2020-05-19   |
| 2292 | [599A56FA](https://metrics.torproject.org/rs.html#details/599A56FAB8E8AA8BB467AB730ADA1F123827E407)                                                                   |            0.005 |      0    |       0.01 |         1 | 2019-11-12   |
| 2293 | [Manuel Giraud &lt;manueltor AT ledu-giraud DOT fr&gt;](https://metrics.torproject.org/rs.html#details/5E184FEA02B7C54172BBC757636F501047CF9691)                      |            0.005 |      0    |       0    |         1 | 2014-07-24   |
| 2294 | [5FE83AD1](https://metrics.torproject.org/rs.html#details/5FE83AD106B498D5A3EA7A48FB73749AF2897E5B)                                                                   |            0.005 |      0    |       0    |         1 | 2017-12-14   |
| 2295 | [tor@ptdb.info](https://metrics.torproject.org/rs.html#details/6395B4A0EE1968966F82E7FA6A9D122DBA30139D)                                                              |            0.005 |      0    |       0    |         1 | 2020-03-18   |
| 2296 | [63DE422C](https://metrics.torproject.org/rs.html#details/63DE422C88DF677F50C2E20EF709E2465BF743A7)                                                                   |            0.005 |      0    |       0    |         1 | 2020-06-25   |
| 2297 | [65379EED](https://metrics.torproject.org/rs.html#details/65379EED488599B0A1512E80D4743BC9125CB306)                                                                   |            0.005 |      0    |       0    |         1 | 2020-02-21   |
| 2298 | [66983A6D](https://metrics.torproject.org/rs.html#details/66983A6D2B17AF134C28FC1A950A22AC88546593)                                                                   |            0.005 |      0    |       0    |         1 | 2020-06-19   |
| 2299 | [maxomeister AT haimatsu.org tor-exit-abuse AT](https://metrics.torproject.org/rs.html#details/6A412A09EEFD191ADE4EE4AF0B98611E10A15409)                              |            0.005 |      0.01 |       0    |         1 | 2020-02-26   |
| 2300 | [6B8F0CE8](https://metrics.torproject.org/rs.html#details/6B8F0CE8383E409C83C657D336D00B86C816A5F5)                                                                   |            0.005 |      0    |       0    |         1 | 2020-05-18   |
| 2301 | [l29ah@cock.li - 17PqnAzXuBx7teM1fRwHTxKroKE97dopAR](https://metrics.torproject.org/rs.html#details/7044955A4D7B04CF70011D73B467B13CE5E69D41)                         |            0.005 |      0    |       0    |         1 | 2016-11-24   |
| 2302 | [NotProvided](https://metrics.torproject.org/rs.html#details/713505E567FC013D286CA1072110CAAF348C9A65)                                                                |            0.005 |      0    |       0    |         1 | 2020-08-10   |
| 2303 | [717FB5BF](https://metrics.torproject.org/rs.html#details/717FB5BF020D0204A5EEB2D271A3123C64F7008A)                                                                   |            0.005 |      0    |       0    |         1 | 2020-07-19   |
| 2304 | [7332A06B](https://metrics.torproject.org/rs.html#details/7332A06B00D6AF54AA804F03C624DFBBC9E66172)                                                                   |            0.005 |      0    |       0    |         1 | 2018-10-15   |
| 2305 | [74D9EAEC](https://metrics.torproject.org/rs.html#details/74D9EAEC62D8F4280D50B08C5F369D16A04080E5)                                                                   |            0.005 |      0    |       0    |         1 | 2020-07-24   |
| 2306 | [tor.pi.es1@gmail.com](https://metrics.torproject.org/rs.html#search/family:75FCFA1225B5B4B35E25DA53C8BA7545463B679E)                                                 |            0.005 |      0    |       0    |         2 | 2015-06-04   |
| 2307 | [7737A403](https://metrics.torproject.org/rs.html#details/7737A40305131AD8B5E60CFB9126E4BBE1ED7F76)                                                                   |            0.005 |      0    |       0    |         1 | 2018-01-04   |
| 2308 | [77E01A5D](https://metrics.torproject.org/rs.html#details/77E01A5D31748474C4F5F086C2461E04A26B34F1)                                                                   |            0.005 |      0    |       0    |         1 | 2019-01-05   |
| 2309 | [spotyor@gmail.com](https://metrics.torproject.org/rs.html#details/7836A38880A0FE3F4335B8BF3D9E0839B3969EA6)                                                          |            0.005 |      0.01 |       0    |         1 | 2020-04-15   |
| 2310 | [7A135569](https://metrics.torproject.org/rs.html#details/7A13556984F6DA1EA920077D0903711AEAE58EF9)                                                                   |            0.005 |      0    |       0    |         1 | 2020-06-20   |
| 2311 | [7D6FAE91](https://metrics.torproject.org/rs.html#details/7D6FAE9198BBBC1FDE46B2842F2161AB6328918D)                                                                   |            0.005 |      0    |       0    |         1 | 2020-08-10   |
| 2312 | [7F4F46E4](https://metrics.torproject.org/rs.html#details/7F4F46E4E856F345A1B21F32BC48ADC6DC0D267A)                                                                   |            0.005 |      0    |       0    |         1 | 2019-11-26   |
| 2313 | [0x4610FE5BE7FC0DE5399A674FD1D59C739F962456 Lucas G](https://metrics.torproject.org/rs.html#details/800267725AF0B34265FB6A2795AB3F743A63DD96)                         |            0.005 |      0    |       0    |         1 | 2020-03-07   |
| 2314 | [801FC546](https://metrics.torproject.org/rs.html#details/801FC54687E380C226D35CD7DBBF73FCD442EA6B)                                                                   |            0.005 |      0    |       0    |         1 | 2019-04-25   |
| 2315 | [email:tor anna.sly.io operatorurl:https://anna.sl](https://metrics.torproject.org/rs.html#details/821931D448E25B4D040AB7745F93AF669BA323DB)                          |            0.005 |      0    |       0    |         1 | 2020-05-28   |
| 2316 | [See page at Dir address](https://metrics.torproject.org/rs.html#details/8310506FEB8DA98EAE0C30F65413B4E20B6BE3E0)                                                    |            0.005 |      0    |       0    |         1 | 2020-05-25   |
| 2317 | [Random Person &lt;nobody AT example dot com&gt;](https://metrics.torproject.org/rs.html#details/83C81FF619BE11C46F0E98B27B437154779ED6CC)                            |            0.005 |      0    |       0    |         1 | 2020-05-20   |
| 2318 | [8525BF04](https://metrics.torproject.org/rs.html#details/8525BF049B9744352819D1E354DF69331B67FC5A)                                                                   |            0.005 |      0    |       0    |         1 | 2020-06-23   |
| 2319 | [torrelays A-T cyb3rwr3ck D-O-T net](https://metrics.torproject.org/rs.html#details/85A885433E50B1874F11CEC9BE98451E24660976)                                         |            0.005 |      0    |       0    |         1 | 2017-06-15   |
| 2320 | [86CDD0D9](https://metrics.torproject.org/rs.html#details/86CDD0D92AB972538416A382D99666736CDDF141)                                                                   |            0.005 |      0    |       0    |         1 | 2018-10-12   |
| 2321 | [3C59605A12D2104CCEC719662550231CF6975D05 anbarocra](https://metrics.torproject.org/rs.html#details/8838B9E8F70E10B5895427D370A65B5554C3F25D)                         |            0.005 |      0    |       0    |         1 | 2019-01-29   |
| 2322 | [0x0BA5D044 Random Person &lt;tormaster at deritter](https://metrics.torproject.org/rs.html#search/family:89FF4A0818D8BE9F8B71338D96A6B854F77F9FEC)                   |            0.005 |      0    |       0    |         2 | 2014-04-24   |
| 2323 | [8A2CCF9A](https://metrics.torproject.org/rs.html#details/8A2CCF9A354EF89C08CB0AE2DD7F7E8418ADF713)                                                                   |            0.005 |      0    |       0    |         1 | 2020-02-12   |
| 2324 | [8CA16E87](https://metrics.torproject.org/rs.html#details/8CA16E878293D11F0E0803E5FC09F93A5C666889)                                                                   |            0.005 |      0.01 |       0    |         1 | 2017-09-13   |
| 2325 | [engee &lt;myeraser AT gmail dot com&gt;](https://metrics.torproject.org/rs.html#details/903044B185D293317A0CB4E7EB7FF898B076E3CB)                                    |            0.005 |      0    |       0    |         1 | 2019-07-05   |
| 2326 | [angrydance AT protonmail dot ch](https://metrics.torproject.org/rs.html#details/92D193A559D0B7CA5553928F079C12BCFC371DB8)                                            |            0.005 |      0    |       0    |         1 | 2019-10-09   |
| 2327 | [93C4C20D](https://metrics.torproject.org/rs.html#details/93C4C20DD1A6797200A60FBE714523FD9D41B5B3)                                                                   |            0.005 |      0    |       0    |         1 | 2020-06-19   |
| 2328 | [946BB395](https://metrics.torproject.org/rs.html#details/946BB39545FCB4D4A4929DC9B84EAA28725EDF6F)                                                                   |            0.005 |      0    |       0    |         1 | 2020-06-23   |
| 2329 | [jontor AT langevin DOT me](https://metrics.torproject.org/rs.html#details/9D462FB499BA316E485ED80E0073802D2283FAAB)                                                  |            0.005 |      0    |       0    |         1 | 2020-02-19   |
| 2330 | [A0F59999](https://metrics.torproject.org/rs.html#details/A0F59999AC612315805D50A3E49FC47B601B8D30)                                                                   |            0.005 |      0    |       0    |         1 | 2017-12-13   |
| 2331 | [Jon Doe &lt;not@exists.com&gt;](https://metrics.torproject.org/rs.html#details/A333975460B45BB109CC6E54106B5B2A625721FA)                                             |            0.005 |      0    |       0    |         1 | 2020-02-02   |
| 2332 | [gaugor at gmail dot com](https://metrics.torproject.org/rs.html#details/A3A6D9D7DBED00F7E6508B55D3449FF6B6C5DF90)                                                    |            0.005 |      0    |       0    |         1 | 2018-03-13   |
| 2333 | [A5198F91](https://metrics.torproject.org/rs.html#details/A5198F913C836DB1A1D19C8D97DFCBA7EEE221F8)                                                                   |            0.005 |      0    |       0    |         1 | 2020-07-11   |
| 2334 | [A550D5FA](https://metrics.torproject.org/rs.html#details/A550D5FA8081101BB4CCA17DBCD5D6ABABBE6BD0)                                                                   |            0.005 |      0    |       0    |         1 | 2020-02-29   |
| 2335 | [A67FA4EC](https://metrics.torproject.org/rs.html#details/A67FA4ECDB8F35E6FFA0D1415605C42157A2125E)                                                                   |            0.005 |      0    |       0    |         1 | 2020-08-05   |
| 2336 | [A810FF1E](https://metrics.torproject.org/rs.html#details/A810FF1E5C7983D43B3517506479274B5DA5AC73)                                                                   |            0.005 |      0    |       0    |         1 | 2017-12-11   |
| 2337 | [A8EC0E51](https://metrics.torproject.org/rs.html#details/A8EC0E51DCC8F4D7A8F6620C253459D68E74560B)                                                                   |            0.005 |      0    |       0    |         1 | 2020-06-20   |
| 2338 | [TOR Administrator &lt;tor AT glittershy dot net&gt;](https://metrics.torproject.org/rs.html#details/A99CAD51C978692006C210AD7EF0ED1A9AE1A47A)                        |            0.005 |      0.01 |       0    |         1 | 2020-07-29   |
| 2339 | [AA1B026E](https://metrics.torproject.org/rs.html#details/AA1B026EE0C8A958E29C67C7D8885FF27572269D)                                                                   |            0.005 |      0    |       0    |         1 | 2014-07-22   |
| 2340 | [Admin &lt;verejnyzaujem AT protonmail dot com&gt;](https://metrics.torproject.org/rs.html#details/AD187C19DC15552A109BDD3343B1242661DF5702)                          |            0.005 |      0    |       0    |         1 | 2017-10-08   |
| 2341 | [mr.game@t-online.de](https://metrics.torproject.org/rs.html#details/AD29C3DB166A5CB1E3F9CE9DABCCA4DCC09F7CD6)                                                        |            0.005 |      0    |       0    |         1 | 2018-11-18   |
| 2342 | [pancake at helptor dot net tor-relay.co](https://metrics.torproject.org/rs.html#details/AD588A99212D86393246E7F360AD3F15C8541EBC)                                    |            0.005 |      0.01 |       0    |         1 | 2020-08-07   |
| 2343 | [University of Washington tor-ops@cs.washington.ed](https://metrics.torproject.org/rs.html#details/AE31E0FBF0D3E1B39F1DD8F55BC070D11AF524B0)                          |            0.005 |      0    |       0    |         1 | 2014-04-08   |
| 2344 | [AED4A698](https://metrics.torproject.org/rs.html#details/AED4A69836630A3375845006B5AAD03BFA3F96DC)                                                                   |            0.005 |      0    |       0    |         1 | 2019-09-12   |
| 2345 | [B02F0126](https://metrics.torproject.org/rs.html#details/B02F0126ABB2BA22371DD96BCBAFA91AD3EB4DDF)                                                                   |            0.005 |      0    |       0    |         1 | 2020-05-19   |
| 2346 | [B50A9826](https://metrics.torproject.org/rs.html#details/B50A98267A63713F37319D895EA1151C4B27BE4D)                                                                   |            0.005 |      0    |       0    |         1 | 2018-09-17   |
| 2347 | [Tor Admin &lt;tor AT nomadlogic dot org&gt;](https://metrics.torproject.org/rs.html#details/B6352D774A912764B0B0FE6297666CF09DFE3007)                                |            0.005 |      0    |       0    |         1 | 2018-08-29   |
| 2348 | [0xDAC4CCB6722FF7E5 Alexander Bu00F6hm &lt;alexander.](https://metrics.torproject.org/rs.html#details/B79589355A41880DFF82F5225F2940437CEDE925)                       |            0.005 |      0    |       0    |         1 | 2015-12-29   |
| 2349 | [B9324F1B](https://metrics.torproject.org/rs.html#details/B9324F1BEDB1DF62AEE219B0CC41507CE710BA3C)                                                                   |            0.005 |      0    |       0    |         1 | 2020-01-13   |
| 2350 | [B9DE5777](https://metrics.torproject.org/rs.html#details/B9DE57771D72238A0D8C8D3269A255BA448413B0)                                                                   |            0.005 |      0.01 |       0    |         1 | 2019-12-06   |
| 2351 | [B9E72BCD](https://metrics.torproject.org/rs.html#details/B9E72BCD9BF7B1EF5706A852B0378702664E2569)                                                                   |            0.005 |      0    |       0    |         1 | 2020-08-06   |
| 2352 | [BAD218F0](https://metrics.torproject.org/rs.html#details/BAD218F0E77F31B5EC6EEF264756ABF1D8B7810A)                                                                   |            0.005 |      0    |       0    |         1 | 2020-06-22   |
| 2353 | [BADDC942](https://metrics.torproject.org/rs.html#details/BADDC94299A1D8D4F4F22B200EAD9ED2E20CA31D)                                                                   |            0.005 |      0    |       0    |         1 | 2020-08-09   |
| 2354 | [none](https://metrics.torproject.org/rs.html#details/BC206665803DB7C730C25A1316889A4D7E7BFF03)                                                                       |            0.005 |      0    |       0    |         1 | 2018-01-23   |
| 2355 | [BF2CD90C](https://metrics.torproject.org/rs.html#details/BF2CD90CECCB5C77B093B64C4B0D19EBFB462858)                                                                   |            0.005 |      0    |       0    |         1 | 2020-07-09   |
| 2356 | [Auguste &lt;auguste@corl3ss.com&gt;](https://metrics.torproject.org/rs.html#details/C2D85BC549361717FDEFAE89607F4A9DF2D4C0E4)                                        |            0.005 |      0    |       0    |         1 | 2016-03-13   |
| 2357 | [C4C134E2](https://metrics.torproject.org/rs.html#details/C4C134E23A2D7FE1D4E2F1AE82786B36ABBCAD8B)                                                                   |            0.005 |      0    |       0    |         1 | 2020-06-12   |
| 2358 | [Any Body &lt;info@vif.com&gt;](https://metrics.torproject.org/rs.html#details/C65D3E1BA27F0F39C2F84CE31D20559BF2A36A4F)                                              |            0.005 |      0.01 |       0    |         1 | 2016-06-04   |
| 2359 | [C76113D5](https://metrics.torproject.org/rs.html#details/C76113D5AB3FC731D678A408EB75BC06F4465F4E)                                                                   |            0.005 |      0    |       0    |         1 | 2018-01-08   |
| 2360 | [CA4DF2B6](https://metrics.torproject.org/rs.html#details/CA4DF2B63A43080C57CF9A561D4A155F97EC5A4F)                                                                   |            0.005 |      0    |       0    |         1 | 2020-07-06   |
| 2361 | [nycmeshtor@fastmail.com](https://metrics.torproject.org/rs.html#details/CA52E423ECBF7D07BB8E1139A39B4D8668CFE2A4)                                                    |            0.005 |      0    |       0    |         1 | 2020-07-06   |
| 2362 | [human@...](https://metrics.torproject.org/rs.html#details/CAF57EB30FD17389954C9F2B43026734F80E39C0)                                                                  |            0.005 |      0    |       0.01 |         1 | 2016-04-28   |
| 2363 | [koen@ns395839.ip-176-31-103.eu](https://metrics.torproject.org/rs.html#details/CBD0D1BD110EC52963082D839AC6A89D0AE243E7)                                             |            0.005 |      0    |       0.01 |         1 | 2014-02-02   |
| 2364 | [CBDB4CD7](https://metrics.torproject.org/rs.html#details/CBDB4CD72EA808119D3723F7CDA44AEAD683FCDA)                                                                   |            0.005 |      0    |       0    |         1 | 2020-05-20   |
| 2365 | [femtejuli &lt;info@5july.org&gt;](https://metrics.torproject.org/rs.html#details/CC605FEC74F20D49995D8FAAFF7365954233B85D)                                           |            0.005 |      0    |       0    |         1 | 2020-06-02   |
| 2366 | [dtwst2@comcast.net](https://metrics.torproject.org/rs.html#details/CCF38C8682E5936852F6F33A0A333AFF30CA453F)                                                         |            0.005 |      0    |       0    |         1 | 2020-05-07   |
| 2367 | [Iain R. Learmonth email:irl fsfe.org pgp:A8F7BA50](https://metrics.torproject.org/rs.html#search/family:CF0CC69DE1E7E75A2D995FD8D9FA7D20983531DA)                    |            0.005 |      0    |       0    |         2 | 2017-12-27   |
| 2368 | [&lt;x at xrooters dot ro&gt;](https://metrics.torproject.org/rs.html#details/D0CD9D92442C38AAC72FF64D4F978E7A09210F0D)                                               |            0.005 |      0.01 |       0    |         1 | 2018-05-03   |
| 2369 | [&lt;admin AT my-mail dot rocks&gt;](https://metrics.torproject.org/rs.html#details/D1B853ED27E4DFDCA3A54D3F2E269C4D94677F66)                                         |            0.005 |      0    |       0    |         1 | 2018-04-16   |
| 2370 | [slarti81 at tutanota dot com](https://metrics.torproject.org/rs.html#details/D1D4BA21EA2B195826656E237FDEC669CABA4D5C)                                               |            0.005 |      0    |       0.01 |         1 | 2020-01-05   |
| 2371 | [D4662423](https://metrics.torproject.org/rs.html#details/D466242349A0E6E154B2A528949B0C8200C0897D)                                                                   |            0.005 |      0    |       0    |         1 | 2020-07-02   |
| 2372 | [D4A79F00](https://metrics.torproject.org/rs.html#details/D4A79F00D92D975AB8F3C0E3617E89A551B8F461)                                                                   |            0.005 |      0    |       0    |         1 | 2020-07-09   |
| 2373 | [D6B74699](https://metrics.torproject.org/rs.html#details/D6B74699E4BD65F8FF7BE0F293E04F237ED8DD67)                                                                   |            0.005 |      0    |       0    |         1 | 2020-07-15   |
| 2374 | [D6E4F361](https://metrics.torproject.org/rs.html#details/D6E4F36157A6795FC8E3515A595A4BFC80F150E4)                                                                   |            0.005 |      0    |       0    |         1 | 2020-06-23   |
| 2375 | [D8120A90](https://metrics.torproject.org/rs.html#details/D8120A907FAFD23A0CD15CD8DFB35B5B6DB583FF)                                                                   |            0.005 |      0    |       0    |         1 | 2020-08-10   |
| 2376 | [tor &lt;tor AT boothlabs dot me&gt;](https://metrics.torproject.org/rs.html#details/D952BAC96C3FCFB37B7EFF49E615582CD63FF62E)                                        |            0.005 |      0    |       0    |         1 | 2020-07-02   |
| 2377 | [isntall.us@gmail.com](https://metrics.torproject.org/rs.html#details/DA91C260D6A78F748BDF17131A1F1D18443BE1EB)                                                       |            0.005 |      0    |       0    |         1 | 2016-04-07   |
| 2378 | [DA96AC30](https://metrics.torproject.org/rs.html#details/DA96AC308288FBFD4641F25F1FA44DDD62FFE42B)                                                                   |            0.005 |      0    |       0    |         1 | 2020-07-03   |
| 2379 | [admin@underworld.fr BTC=bc1qy5ujd0vvmvsd8h28fa8c87](https://metrics.torproject.org/rs.html#details/DC163DDEF4B6F0C6BC226F9F6656A5A30C5C5686)                         |            0.005 |      0    |       0.01 |         1 | 2015-07-15   |
| 2380 | [DCE5AA5B](https://metrics.torproject.org/rs.html#details/DCE5AA5B2287663BE7DBE9C87635FA846138D9A6)                                                                   |            0.005 |      0    |       0    |         1 | 2019-11-18   |
| 2381 | [DEF3365F](https://metrics.torproject.org/rs.html#details/DEF3365F1C012F80E56877B5EF05CE72BDEB0CCC)                                                                   |            0.005 |      0    |       0    |         1 | 2019-01-08   |
| 2382 | [DF060551](https://metrics.torproject.org/rs.html#details/DF0605518567D637ABA846CAE2EDE50E8A2BD57D)                                                                   |            0.005 |      0    |       0    |         1 | 2018-09-02   |
| 2383 | [1187 EF45 9760 66ED 5AB5 5D50 9755 3391 D0BF 49BA](https://metrics.torproject.org/rs.html#details/E0023AC14180112A2FFF00A84C6049862BB3E6C3)                          |            0.005 |      0    |       0.01 |         1 | 2019-11-27   |
| 2384 | [E0EFD66F](https://metrics.torproject.org/rs.html#details/E0EFD66FE7C11EAADF43965AD5D53CB466753E93)                                                                   |            0.005 |      0    |       0    |         1 | 2020-07-11   |
| 2385 | [E38CCCE2](https://metrics.torproject.org/rs.html#details/E38CCCE275ADC46DF35FB764AA28D4EF722CFA54)                                                                   |            0.005 |      0    |       0    |         1 | 2018-03-14   |
| 2386 | [Morgan Roderick &lt;morgan@roderick.dk&gt;](https://metrics.torproject.org/rs.html#details/E3BE523603E9CB038A289FA38066E01A4FE7BD98)                                 |            0.005 |      0    |       0    |         1 | 2019-12-04   |
| 2387 | [E5DB1162](https://metrics.torproject.org/rs.html#details/E5DB116226E752C218D1A2B184674D3BA23C4D31)                                                                   |            0.005 |      0    |       0    |         1 | 2020-01-16   |
| 2388 | [stephan thomann@bluewin.ch](https://metrics.torproject.org/rs.html#details/E605E70E86A7777A22DF2259DFA9C5360B54346A)                                                 |            0.005 |      0    |       0    |         1 | 2020-01-19   |
| 2389 | [E76E2BC2](https://metrics.torproject.org/rs.html#details/E76E2BC2FC9273BFBA38947EB5572076270D49D5)                                                                   |            0.005 |      0    |       0    |         1 | 2019-12-05   |
| 2390 | [zentai at pm dot me tor-relay.co](https://metrics.torproject.org/rs.html#details/E8E6A95CF0170FF9DED9145CCC74EB4288B34613)                                           |            0.005 |      0    |       0    |         1 | 2019-11-23   |
| 2391 | [ECE1797C](https://metrics.torproject.org/rs.html#details/ECE1797CC778161FD7B1A4052155829E31A2250F)                                                                   |            0.005 |      0    |       0    |         1 | 2020-06-26   |
| 2392 | [bryantorrelay@stitthappens.com](https://metrics.torproject.org/rs.html#details/ED8D4E97453D7510A934B4FECFDAB35104FD7CAE)                                             |            0.005 |      0    |       0    |         1 | 2018-03-31   |
| 2393 | [F117B31D](https://metrics.torproject.org/rs.html#details/F117B31DF6A73D6F015BCEE4E6AB13474B18A16F)                                                                   |            0.005 |      0    |       0    |         1 | 2020-04-26   |
| 2394 | [F192BD51](https://metrics.torproject.org/rs.html#details/F192BD51EF2C9CA553646F28668D28A7AF1CAB0D)                                                                   |            0.005 |      0    |       0    |         1 | 2016-06-02   |
| 2395 | [F1B1E126](https://metrics.torproject.org/rs.html#details/F1B1E1267A9301244120EF7D47CD4174FD94FD60)                                                                   |            0.005 |      0    |       0    |         1 | 2019-07-04   |
| 2396 | [torexit@semipvt.com](https://metrics.torproject.org/rs.html#details/F3482E046B5E611FDF279AF59B70A88A804D1470)                                                        |            0.005 |      0.01 |       0    |         1 | 2020-02-18   |
| 2397 | [hacksenkessel@gmail.com](https://metrics.torproject.org/rs.html#details/F43C497039F836FE32DE416F4CBD97892C3F6E9E)                                                    |            0.005 |      0    |       0    |         1 | 2014-04-18   |
| 2398 | [golTorNode1 info@goldingerit.ch](https://metrics.torproject.org/rs.html#details/F5BF2C835E86DF291DC7D86DD1E1542F4887E3A7)                                            |            0.005 |      0    |       0    |         1 | 2019-05-08   |
| 2399 | [F68E7A04](https://metrics.torproject.org/rs.html#details/F68E7A04A2E0375B57BBC0D2794FCD95DDEBCA32)                                                                   |            0.005 |      0    |       0.01 |         1 | 2017-11-08   |
| 2400 | [FAA935B0](https://metrics.torproject.org/rs.html#details/FAA935B0BC3B4348CCBD3EBA95681AB51730977D)                                                                   |            0.005 |      0    |       0    |         1 | 2017-01-19   |
| 2401 | [samizdats@riseup.net](https://metrics.torproject.org/rs.html#details/FAE6D2A4EB58470AABCE692A5F32104520E1C8FE)                                                       |            0.005 |      0    |       0    |         1 | 2020-08-02   |
| 2402 | [FBE04186](https://metrics.torproject.org/rs.html#details/FBE04186F49DB2B1EDEF3CE06DB16F29690AFD69)                                                                   |            0.005 |      0    |       0    |         1 | 2016-03-19   |
| 2403 | [donald92741@protonmail.com](https://metrics.torproject.org/rs.html#details/FC27B667CEDF304E355B753C13C6B1130A1A165C)                                                 |            0.005 |      0    |       0    |         1 | 2018-10-07   |
| 2404 | [FC5C3E59](https://metrics.torproject.org/rs.html#details/FC5C3E5985563E49467924165A8D4280FB7834E7)                                                                   |            0.005 |      0    |       0    |         1 | 2020-08-07   |
| 2405 | [fd0b7f4bb1282c54e9ce394b128f6669 AT protonmail.com](https://metrics.torproject.org/rs.html#details/FD69ED3580CF199BD2F7F6ED96B710FA50E15208)                         |            0.005 |      0    |       0    |         1 | 2020-07-27   |
| 2406 | [Random Person &lt;determine AT riseup dot net&gt;](https://metrics.torproject.org/rs.html#details/FE1D9698A324BD3C2847920436E89786F16C5CAC)                          |            0.005 |      0.01 |       0    |         1 | 2020-07-21   |
| 2407 | [FE857C30](https://metrics.torproject.org/rs.html#details/FE857C3043412FD5454ED5FEF55C4C572E5B70CF)                                                                   |            0.005 |      0    |       0    |         1 | 2019-04-05   |
| 2408 | [FF09929A](https://metrics.torproject.org/rs.html#details/FF09929A568B6941CE9B084F3A92CBBAE05D1942)                                                                   |            0.005 |      0    |       0    |         1 | 2020-08-07   |