---
layout: default
---


# Relays running end-of-life Tor releases

Tor network data as of: **2020-08-12 17:00 UTC**

Relays are sorted by their consensus weight.
If you find your relay on this page you should upgrade it to a supported tor release.

| Nickname                                                                                                       | Tor Version       |   Consensus Weight |
|:---------------------------------------------------------------------------------------------------------------|:------------------|-------------------:|
| [Unnamed](https://metrics.torproject.org/rs.html#details/EAA823552F959DFD038E9AC8FA89345A738B6C00)             | 0.4.1.6           |             169000 |
| [Unnamed](https://metrics.torproject.org/rs.html#details/99339F3E68BCCC1391BF14C821D80766FE0C5956)             | 0.4.1.6           |             160000 |
| [Unnamed](https://metrics.torproject.org/rs.html#details/63540827C4832D214984EA47B7A68C593F9F862F)             | 0.4.1.6           |             130000 |
| [sonofgodness](https://metrics.torproject.org/rs.html#details/B74DABBE248B935CDC1038CD5C9280878C8C94E7)        | 0.4.1.6           |             100000 |
| [Nisos](https://metrics.torproject.org/rs.html#details/7FA3FA525901A91A1310B817943668BC2C16289E)               | 0.4.1.6           |              96800 |
| [drizzle](https://metrics.torproject.org/rs.html#details/A597AC866E40CAB5A67759ADE4942192E99DE684)             | 0.4.1.6           |              84800 |
| [lpf2](https://metrics.torproject.org/rs.html#details/1C8B3C3D8BC705883B7799C915B2FE1E0FEB006F)                | 0.4.1.6           |              84000 |
| [fakename](https://metrics.torproject.org/rs.html#details/795790C25BDE834B836EA54DD96DB2610829573B)            | 0.4.1.6           |              83800 |
| [Unkn0wn](https://metrics.torproject.org/rs.html#details/2FFE5FAF70D20E76B0474AE9E40C2A0B53F8D9F0)             | 0.4.1.6           |              83600 |
| [lpf1](https://metrics.torproject.org/rs.html#details/D228AE265C966CA4E9A8C4B746A30A9737060A32)                | 0.4.1.6           |              61100 |
| [apx2](https://metrics.torproject.org/rs.html#details/A6B0521C4C1FB91FB66398AAD523AD773E82E77E)                | 0.4.5.0-alpha-dev |              60900 |
| [megatot](https://metrics.torproject.org/rs.html#details/3D9CE80399B68C01377FEC42395E399B9ED16E18)             | 0.4.1.6           |              50000 |
| [apx1](https://metrics.torproject.org/rs.html#details/45E9240AD4ECE01793A1977C1260503B2C2C861F)                | 0.4.5.0-alpha-dev |              48000 |
| [fastlane](https://metrics.torproject.org/rs.html#details/5B1F0DAF378A1FAFCFD5FA9CDC66D1023DC0276E)            | 0.4.1.6           |              46000 |
| [apx3](https://metrics.torproject.org/rs.html#details/38A42B8D7C0E6346F4A4821617740AEE86EA885B)                | 0.4.5.0-alpha-dev |              42600 |
| [vr241tor](https://metrics.torproject.org/rs.html#details/CD24E771368244431E1DA30603FF11A317DB215F)            | 0.4.1.6           |              42000 |
| [tOr](https://metrics.torproject.org/rs.html#details/9A7417BA401B8C7EFDE24945E18145A1EDA730E7)                 | 0.4.1.6           |              40000 |
| [cCc](https://metrics.torproject.org/rs.html#details/98BCA63DD82E13A637FF8D0EC28135663DB08CA1)                 | 0.4.1.6           |              35200 |
| [torexit42](https://metrics.torproject.org/rs.html#details/7E44E0D39CE8666A98EA5DEBCBB8E12B3906410F)           | 0.4.1.6           |              33000 |
| [drkhsh](https://metrics.torproject.org/rs.html#details/1CDCB48F64E21D5ACAFE2471912E2E76F600EDFA)              | 0.4.1.9           |              32100 |
| [tron99Relay](https://metrics.torproject.org/rs.html#details/FB691D6E3FEE35C6979EE72AF03A53DD861B4CBB)         | 0.4.1.6           |              31500 |
| [notem2](https://metrics.torproject.org/rs.html#details/73DCA56424912F69F1478D6630DF27CFE8F41439)              | 0.4.1.6           |              29800 |
| [Unnamed](https://metrics.torproject.org/rs.html#details/B2D03CDF45EB4D74A65FAC4F00EBA785C9663A5F)             | 0.4.1.6           |              29300 |
| [DagnyTaggart](https://metrics.torproject.org/rs.html#details/ECB0A13C33B9C0BB101104E08738C19048222393)        | 0.4.5.0-alpha-dev |              28100 |
| [rayonx](https://metrics.torproject.org/rs.html#details/97767B43E78119A613B46CEAF81A788F45CC05D9)              | 0.4.5.0-alpha-dev |              26600 |
| [ForJusticeDammit](https://metrics.torproject.org/rs.html#details/4EBE3B18F7D38D0A2FDD67B47A55CB9069368723)    | 0.4.1.6           |              25000 |
| [Unnamed](https://metrics.torproject.org/rs.html#details/B8F6E68B36BEE2BF548750BDCCC3C2A7DB56A623)             | 0.4.1.6           |              22600 |
| [qtornado](https://metrics.torproject.org/rs.html#details/767E444E1FA1DA75F3B77479DB5AE2FA3FFF75CC)            | 0.4.1.9           |              22100 |
| [ccc2](https://metrics.torproject.org/rs.html#details/204ECC4FF8F93862E82FA19C53B5BC98B1AF6046)                | 0.4.1.6           |              21900 |
| [donald](https://metrics.torproject.org/rs.html#details/F01AAA640FF4EA025DB8449BD61C055273B4A328)              | 0.4.1.6           |              20400 |
| [ephemera](https://metrics.torproject.org/rs.html#details/2F26D43258285FEB39E4320888DFAFA8A0D20E11)            | 0.4.1.6           |              20000 |
| [heartbeet](https://metrics.torproject.org/rs.html#details/7BE4752877553A96CD4035D0C526BCD09E81CC64)           | 0.4.1.6           |              20000 |
| [sandman1](https://metrics.torproject.org/rs.html#details/7B57933E29D520471D7E67AB48B06B62832828F9)            | 0.4.1.6           |              19000 |
| [geek](https://metrics.torproject.org/rs.html#details/BA38C5688E103AE11F50D7188C8E5FDB4B0E5553)                | 0.4.1.6           |              19000 |
| [mcKitty](https://metrics.torproject.org/rs.html#details/CD9BFE309010778D64ED5E55D5EEAA92B2020DE8)             | 0.4.1.6           |              18700 |
| [unnamed](https://metrics.torproject.org/rs.html#details/68773D3FF7B8CEFCEEFCA32AE72015E2D38C62C1)             | 0.4.1.6           |              18500 |
| [brotherhood](https://metrics.torproject.org/rs.html#details/B0A63BC3FDA67A7ADD1BE08BAA8309C4B204D29B)         | 0.4.1.6           |              18000 |
| [jersey](https://metrics.torproject.org/rs.html#details/D39328D2EAE3816F9C5D5D1BB19D1C14E2E79482)              | 0.4.1.6           |              17300 |
| [EvolynTorRelay1](https://metrics.torproject.org/rs.html#details/6406B69F95D06F6A94CFDD83E85EE9C410A05D47)     | 0.4.1.6           |              17100 |
| [UrquinaonaL5](https://metrics.torproject.org/rs.html#details/32A1ED707343CDEFFC105EC8DF068A0E154DF6CE)        | 0.4.1.6           |              17000 |
| [Unnamed](https://metrics.torproject.org/rs.html#details/798A57B4E129699A521A03E7F72BC0FDEC31F4D6)             | 0.4.1.6           |              17000 |
| [Torild](https://metrics.torproject.org/rs.html#details/73E2046A1E7F0E95D36C3F979CE5FAC3609AC610)              | 0.4.1.5           |              16800 |
| [0xFE31x00](https://metrics.torproject.org/rs.html#details/D60C2D85EAD93D23F1C00874D334BBF8A96CD529)           | 0.4.1.6           |              15900 |
| [Unnamed](https://metrics.torproject.org/rs.html#details/1F7EAF14071F8975AFCF219FD62E8451B40E70BB)             | 0.4.1.6           |              15400 |
| [Unnamed](https://metrics.torproject.org/rs.html#details/A1DEB529DE86E7CABC3212778374933D68FB7F2F)             | 0.4.1.6           |              15000 |
| [cp1](https://metrics.torproject.org/rs.html#details/87A2EABEAB0D7E4EB002A42D26000F5CB8D5B937)                 | 0.4.1.6           |              14800 |
| [Unnamed](https://metrics.torproject.org/rs.html#details/11C3D14A1166AEDED6D247A32DE6451F6C95223A)             | 0.4.1.6           |              14300 |
| [unnamed](https://metrics.torproject.org/rs.html#details/C3799054BC7F0D201FB7C0F9DE31BF1F3D868A37)             | 0.4.1.6           |              14200 |
| [don](https://metrics.torproject.org/rs.html#details/8E39881472946D5BBE41765470D9E3099A0EB4C7)                 | 0.4.1.6           |              14000 |
| [serotonin](https://metrics.torproject.org/rs.html#details/2FD0BA57A34DC2792AF470398F72F37F9E51DC2D)           | 0.4.1.5           |              13200 |
| [madnight](https://metrics.torproject.org/rs.html#details/42E440E573CAA2C309041B448BDB8FC5D066E535)            | 0.4.1.7           |              13000 |
| [r00tzone](https://metrics.torproject.org/rs.html#details/49CA9262801E9DC9B414A143A58A68255149367A)            | 0.4.1.6           |              12300 |
| [Truie](https://metrics.torproject.org/rs.html#details/A69221A7EC7498D2F88A0FB795261013FA36CAAE)               | 0.4.5.0-alpha-dev |              12100 |
| [FreedomForParrots2](https://metrics.torproject.org/rs.html#details/C0E6A667064385B9CB5A685CEB06B85EDDA6AA00)  | 0.4.1.6           |              12100 |
| [Unnamed](https://metrics.torproject.org/rs.html#details/7B87EF57DAC332D7016C04AE82063E93B5162C44)             | 0.4.1.6           |              12000 |
| [MediumSlesmn](https://metrics.torproject.org/rs.html#details/2935E0F03B71BE44F6F265FEF976E810BAAD6F4E)        | 0.4.1.6           |              11900 |
| [dontpanic](https://metrics.torproject.org/rs.html#details/63C81BCA835570069A7FCD48312DEA707F6CBAA2)           | 0.4.1.6           |              11000 |
| [UristMcDerpsNode](https://metrics.torproject.org/rs.html#details/835D88AE990CA3A33A49F800F64ACE580F4C21FE)    | 0.4.1.5           |              10700 |
| [dfiusec](https://metrics.torproject.org/rs.html#details/D8BD437B3165203E890D0DB57DF2AC128C95B3B4)             | 0.4.1.6           |              10600 |
| [ankerman](https://metrics.torproject.org/rs.html#details/568583D9E46C68045E2131CF403E48F21DF11F0A)            | 0.4.1.6           |              10300 |
| [FreeFlow](https://metrics.torproject.org/rs.html#details/96E0D19D735D47039844EA83372183BB606F87B4)            | 0.4.1.5           |              10100 |
| [Zwiebl0r](https://metrics.torproject.org/rs.html#details/A1FEE8537C847D330F1F7F592BE24360C5D6051F)            | 0.4.1.6           |              10000 |
| [disconnectedtech1](https://metrics.torproject.org/rs.html#details/A0B05E1D852D874EFAF3603C83246E00AD65AF20)   | 0.4.1.6           |               9800 |
| [0x64657573](https://metrics.torproject.org/rs.html#details/2F77315CAE477550E47773BA5B1323F7FFBE3A3E)          | 0.4.1.6           |               9790 |
| [kellogs](https://metrics.torproject.org/rs.html#details/2AB9FFCC6618FBBC973C457FC6BE5E8620A60FDC)             | 0.4.1.6           |               9400 |
| [Karlstad1](https://metrics.torproject.org/rs.html#details/EDAF30C58D6CCF359EA062C668C7180A17076440)           | 0.4.1.5           |               8400 |
| [TonTliquid](https://metrics.torproject.org/rs.html#details/D87A947A2405C41208C57D32ED1D0CA2EBE93AF6)          | 0.4.1.5           |               7900 |
| [ratatata](https://metrics.torproject.org/rs.html#details/286F22F5D198AB20C50C65B94A03B52CAE588946)            | 0.4.1.6           |               7330 |
| [blackmamba](https://metrics.torproject.org/rs.html#details/896364B7996F5DFBA0E15D1A2E06D0B98B555DD6)          | 0.4.5.0-alpha-dev |               7100 |
| [bigdaddyny](https://metrics.torproject.org/rs.html#details/0BCCF364C4EE7338B6E920E63E951922C85F91F7)          | 0.4.1.6           |               6740 |
| [unrestrictedONE](https://metrics.torproject.org/rs.html#details/03B1B21D72373510E1DEFE2E193932576B157368)     | 0.4.1.9           |               6720 |
| [bigdaddyny3](https://metrics.torproject.org/rs.html#details/AE236568ED01527850FA0D5BEFBBF6C6BDA47AF0)         | 0.4.1.6           |               6550 |
| [foucault](https://metrics.torproject.org/rs.html#details/A9F545AE03B731AD32F9A93D698EA20C4FA6D0D9)            | 0.4.1.9           |               6400 |
| [myRelayFromTroyes](https://metrics.torproject.org/rs.html#details/EBDD9A8BC45D0543D0FDC93940EE06E56E749A99)   | 0.4.1.6           |               6400 |
| [gollum](https://metrics.torproject.org/rs.html#details/EB902DF84069187F7F879744C60C14FD3AE249A2)              | 0.4.1.9           |               6200 |
| [cGbu7BKzxg7hB2m](https://metrics.torproject.org/rs.html#details/AFA9E5B8D77B736CCA77704B465F9FA4B9566924)     | 0.4.1.6           |               6000 |
| [mine](https://metrics.torproject.org/rs.html#details/D30E9D4D639068611D6D96861C95C2099140B805)                | 0.4.1.6           |               5900 |
| [julianSMN](https://metrics.torproject.org/rs.html#details/E4E27D80236B421FAEA25797495B57E36FF9F7C2)           | 0.4.1.6           |               5700 |
| [lifeisabitch](https://metrics.torproject.org/rs.html#details/2FFBAEBC4D4A88CA96BD5F6B0D3A1D1A7A00D5F2)        | 0.4.1.6           |               5570 |
| [daddycool](https://metrics.torproject.org/rs.html#details/B214C768C88BB08F017BE30CBB603939F3DDA661)           | 0.4.1.6           |               5540 |
| [Machiavelli](https://metrics.torproject.org/rs.html#details/114FB145113A8D53818F0BA9363DFBC81DC8447F)         | 0.4.1.5           |               5420 |
| [spaghetti](https://metrics.torproject.org/rs.html#details/59CA96E7CDA30AB36C597B499C848BD845745EA0)           | 0.4.1.6           |               5100 |
| [966745152189918](https://metrics.torproject.org/rs.html#details/C67C33C76CDC33DD72FAA77535B48D7E96C006D2)     | 0.4.1.6           |               4980 |
| [Metis](https://metrics.torproject.org/rs.html#details/15571673BCE30678EC5F895C9F59EB1C01CBBC56)               | 0.4.1.6           |               4850 |
| [poseidon](https://metrics.torproject.org/rs.html#details/B79589355A41880DFF82F5225F2940437CEDE925)            | 0.4.1.6           |               4730 |
| [LeslieRelay3](https://metrics.torproject.org/rs.html#details/66875F45C94AC807C774243E325A99CB0398314D)        | 0.4.1.9           |               4720 |
| [5855987448232923](https://metrics.torproject.org/rs.html#details/5847D5A01C47166143F738C7703344517B39EB10)    | 0.4.1.6           |               4700 |
| [huskytail](https://metrics.torproject.org/rs.html#details/4A5147952EE35534F7B69387FF3D408C8EE66D68)           | 0.4.1.7           |               4670 |
| [morgtor](https://metrics.torproject.org/rs.html#details/E3BE523603E9CB038A289FA38066E01A4FE7BD98)             | 0.4.1.6           |               4360 |
| [snapfeli](https://metrics.torproject.org/rs.html#details/4EACB1DF4BD42524AEA6A1B8026617B1BF59045C)            | 0.4.1.5           |               4300 |
| [spotyor](https://metrics.torproject.org/rs.html#details/7836A38880A0FE3F4335B8BF3D9E0839B3969EA6)             | 0.4.1.9           |               4200 |
| [1054584527813185](https://metrics.torproject.org/rs.html#details/350AB72B8744CC40ED8699E6D3298CB14215F568)    | 0.4.1.6           |               4170 |
| [ctr0003](https://metrics.torproject.org/rs.html#details/E27B11E7CAAEAF7B2BD09DD440DD5ADE2BE45461)             | 0.4.1.6           |               4040 |
| [TheAvenger](https://metrics.torproject.org/rs.html#details/8DAA8003876C89F2E4C2AAF770B772E09B1D9F36)          | 0.4.1.7           |               3980 |
| [DaddyCool](https://metrics.torproject.org/rs.html#details/2F612CDD8362B007B3341395016501FD9A761B1E)           | 0.4.1.7           |               3910 |
| [NervousSpikey](https://metrics.torproject.org/rs.html#details/A7B2BD56EE7D3AD45BE2FF91741568DB768D138E)       | 0.4.1.9           |               3550 |
| [HrmonyNutrient](https://metrics.torproject.org/rs.html#details/97151BC6EB9D63C26A672D955EB6D66E3CCB9B9C)      | 0.4.1.6           |               3370 |
| [MarkTwain](https://metrics.torproject.org/rs.html#details/8CCED391D2E1B6ED1E78769FBDCFB70E5C91849D)           | 0.4.1.6           |               2940 |
| [ExportShuttle](https://metrics.torproject.org/rs.html#details/2D78D1CBCCF8219822119BFA0346FF23316F1913)       | 0.4.1.6           |               2900 |
| [FR1sevpsNET](https://metrics.torproject.org/rs.html#details/23E7EEF9D1A0FD80799216B970EE7627EF050BB7)         | 0.4.1.6           |               2800 |
| [Q](https://metrics.torproject.org/rs.html#details/26220AEA188B8D0E47BB541E1A616EB3AD70295F)                   | 0.4.1.6           |               2530 |
| [hacktheplanet](https://metrics.torproject.org/rs.html#details/A567FF5DC72A21A6B7120609E51E76C49517EF41)       | 0.4.1.6           |               2500 |
| [aldabrachelys](https://metrics.torproject.org/rs.html#details/838749E0065B79086D12B5C1D7869B99EEFE1DB0)       | 0.4.1.9           |               2480 |
| [rinderwahnRelay2L](https://metrics.torproject.org/rs.html#details/3B07C500AC17E7B5A1EE616613E104A094AB87F3)   | 0.4.5.0-alpha-dev |               2470 |
| [SwordHogwrts](https://metrics.torproject.org/rs.html#details/E1B54925C59ECE813269B9A3309B7A5EB57E9B98)        | 0.4.1.6           |               2460 |
| [iSOcHTorRelay](https://metrics.torproject.org/rs.html#details/5008E49954AC0CA0565FE8AF61D61617212ACBC7)       | 0.4.1.5           |               2370 |
| [vm242tornode](https://metrics.torproject.org/rs.html#details/F0B580798BB303BA36ED1268568E2AD935B6C486)        | 0.4.1.6           |               2350 |
| [InstitueForgive](https://metrics.torproject.org/rs.html#details/F0149CBAE8953B7157CC54BFC414DBAF859E0B33)     | 0.4.1.6           |               2300 |
| [LeslieRelay5](https://metrics.torproject.org/rs.html#details/38E059EEACD86E4D47FCD35F0A1FBD26A34BAB83)        | 0.4.1.6           |               2200 |
| [aergia](https://metrics.torproject.org/rs.html#details/342A1AC764D89248E66458C077CFF668D05FFF34)              | 0.4.1.5           |               2160 |
| [FictionEndevour](https://metrics.torproject.org/rs.html#details/7639877E13E8BA4EA8FC23A3824B9A02BC3ED4E0)     | 0.4.1.6           |               2130 |
| [HappyNode11](https://metrics.torproject.org/rs.html#details/8C35B15C1F138BDE4D50A975129E4773B44A503D)         | 0.4.1.6           |               2010 |
| [LeslieRelay1](https://metrics.torproject.org/rs.html#details/2507E6A97AC52DC09FA519D31340156EEC626A5B)        | 0.4.1.6           |               2000 |
| [neurans](https://metrics.torproject.org/rs.html#details/CD46CDD4643FA30AC10D17A3872B560B4E17F048)             | 0.4.1.9           |               1980 |
| [default](https://metrics.torproject.org/rs.html#details/DAEEC0CDD214EDAB2C1D2186B202DC79ECCB1655)             | 0.4.1.5           |               1960 |
| [PrepreUseless](https://metrics.torproject.org/rs.html#details/60685893A57D66562A0754BEE3B6A6E68082C8BE)       | 0.4.1.6           |               1840 |
| [fondueplausch](https://metrics.torproject.org/rs.html#details/590136C13CC2747B8C48BF73D815454279F60C5D)       | 0.4.1.6           |               1820 |
| [TrickDepression](https://metrics.torproject.org/rs.html#details/C6604D457AC319E53DC314B81F0EF9D16CB937A0)     | 0.4.1.6           |               1710 |
| [halah](https://metrics.torproject.org/rs.html#details/30690AC40FCD074AF918A28BD754757C28076755)               | 0.4.1.6           |               1630 |
| [xe4](https://metrics.torproject.org/rs.html#details/1F7CFBF866D369DD2D9B1E54DCAAAB15D1FD80A7)                 | 0.4.5.0-alpha-dev |               1610 |
| [OdyX](https://metrics.torproject.org/rs.html#details/ABF940561A8E528559747D2237847E1BD823CDB8)                | 0.4.1.6           |               1600 |
| [BiochemistryClothi](https://metrics.torproject.org/rs.html#details/D2A609578BBE69A4CD7C1DEC104B3CD704023534)  | 0.4.1.6           |               1600 |
| [ECANTorTOKA](https://metrics.torproject.org/rs.html#details/4E559E30279092315BF907DABDF00720473F8320)         | 0.4.1.6           |               1590 |
| [helga](https://metrics.torproject.org/rs.html#details/0059D92942DB3B84E52EB4D87E9F7B195CF4D005)               | 0.4.1.6           |               1540 |
| [alternativlos](https://metrics.torproject.org/rs.html#details/28090710ABE433A47021F22208B3EC245A912900)       | 0.4.1.6           |               1540 |
| [tastyd2m4](https://metrics.torproject.org/rs.html#details/679FBD9C1FCEEA276898087589C5FAC061F4B5BC)           | 0.4.1.9           |               1400 |
| [PolishWingedHussars](https://metrics.torproject.org/rs.html#details/8EC7FE7F2A1189EB79A07C02FB3F1FD57132E42D) | 0.4.1.6           |               1400 |
| [stalkr](https://metrics.torproject.org/rs.html#details/76F3A81A0784DCF536F6DE19F98EAEB1F89DECCF)              | 0.4.1.6           |               1380 |
| [Unnamed](https://metrics.torproject.org/rs.html#details/2AD22DDE34790BBE19FB4D11DDCBBFDC45EF16A6)             | 0.4.1.6           |               1370 |
| [LeslieRelay2](https://metrics.torproject.org/rs.html#details/60769652C04712912E6E21CED1F08DC797789A75)        | 0.4.1.6           |               1340 |
| [HexFromHEMEuropa](https://metrics.torproject.org/rs.html#details/DCAA1CED7183B561D18CF580BE9933BD9168D101)    | 0.4.1.5           |               1330 |
| [Unnamed](https://metrics.torproject.org/rs.html#details/6F901069356A789F02294F18A4D5FE1368239702)             | 0.4.1.6           |               1300 |
| [castellum](https://metrics.torproject.org/rs.html#details/96211F57FA0A399EC48D1972BA3F8EE6E4D6978C)           | 0.4.1.9           |               1300 |
| [endurcissent](https://metrics.torproject.org/rs.html#details/21014C8A0D9806B853203EF1137BD2E20E69D5D7)        | 0.4.1.6           |               1120 |
| [redonionring](https://metrics.torproject.org/rs.html#details/318CB7FC0EAEB92311EB51B5B78E3CAD45EBCF21)        | 0.4.1.6           |               1100 |
| [glenda1](https://metrics.torproject.org/rs.html#details/3C638F95F36671FC71690C7BBE252E21920044D5)             | 0.4.1.6           |               1000 |
| [glenda2](https://metrics.torproject.org/rs.html#details/98FB7574932DBD6FE9E75169982EDFBA50F86175)             | 0.4.1.6           |               1000 |
| [frickySpeed](https://metrics.torproject.org/rs.html#details/867663D188FDA58EEB82850E6F4C4F82D2B667BD)         | 0.4.1.7           |                991 |
| [lumipGoesOnion](https://metrics.torproject.org/rs.html#details/2FC9C98197456811E1B81C88848C722AF250582C)      | 0.4.1.9           |                943 |
| [tortellini](https://metrics.torproject.org/rs.html#details/BB0749D594660284D14092A16D0F6EEC90D4AB13)          | 0.4.1.6           |                940 |
| [Unnamed](https://metrics.torproject.org/rs.html#details/1D25C7B2DD3C0BD55526DCF95B175EA3E95D9286)             | 0.4.1.6           |                913 |
| [ModernisePollutnt](https://metrics.torproject.org/rs.html#details/210C0F11CDE4ADA5F83D088C5A89710E31BDC9DD)   | 0.4.1.6           |                837 |
| [Unnamed](https://metrics.torproject.org/rs.html#details/469305AE56D9F446468E8BE8780219EED54EEF25)             | 0.4.1.6           |                813 |
| [Unnamed](https://metrics.torproject.org/rs.html#details/C793A33F28826D1F184504312C668EA8157AEF28)             | 0.4.1.6           |                804 |
| [Supergrundrecht](https://metrics.torproject.org/rs.html#details/41F07731207742860D43AC426FBAE2F3947BD1CA)     | 0.4.5.0-alpha-dev |                791 |
| [LiCi01](https://metrics.torproject.org/rs.html#details/07F9F13BCB3E1F6117FB211905127AF41E72E087)              | 0.4.1.6           |                770 |
| [SpaceJam](https://metrics.torproject.org/rs.html#details/4D02D27C88E1BEE726D3C44C7BD7843C0E92ADB2)            | 0.4.1.6           |                770 |
| [Unnamed](https://metrics.torproject.org/rs.html#details/01981F09AF08EB1EC69F91B31D89B6C76757620A)             | 0.4.1.6           |                764 |
| [Unnamed](https://metrics.torproject.org/rs.html#details/C7E7D8C4850D6A4EFA848F7C3922F4CA3442E4C1)             | 0.4.1.6           |                762 |
| [Unnamed](https://metrics.torproject.org/rs.html#details/9A9D48F3D5C572C87DE79236A3FA9353E08E3FF2)             | 0.4.1.6           |                730 |
| [Unnamed](https://metrics.torproject.org/rs.html#details/06D77E461C9814243DA2C6145544D5BB3B46B52E)             | 0.4.1.6           |                674 |
| [hrck](https://metrics.torproject.org/rs.html#details/75CF0F66FE18C3116AAB7B678899151DB762B795)                | 0.4.1.6           |                667 |
| [IHNIWID](https://metrics.torproject.org/rs.html#details/65FBA426CE8126771C5EEB52634F3BB5E6E93B08)             | 0.4.1.6           |                664 |
| [Unnamed](https://metrics.torproject.org/rs.html#details/37B97F98AA1A51FF282660D3E440DAD9687BA814)             | 0.4.1.6           |                659 |
| [Unnamed](https://metrics.torproject.org/rs.html#details/1096D71C2EA45A68E4D3A375CAE590FBF349DEAB)             | 0.4.1.6           |                637 |
| [Potatoe](https://metrics.torproject.org/rs.html#details/86FBA753C8D25653E086B98FFF8AA084F862DB67)             | 0.4.1.6           |                609 |
| [Unnamed](https://metrics.torproject.org/rs.html#details/4FAB66DD36CF53A4D1F8D933037FA509ADE063BA)             | 0.4.1.6           |                590 |
| [Unnamed](https://metrics.torproject.org/rs.html#details/F8957D61E29A626400029A03A6348400E7502604)             | 0.4.1.6           |                589 |
| [tubealloys](https://metrics.torproject.org/rs.html#details/4B582F3F4BB4DE56D7728DEB22AA255350870F98)          | 0.4.1.9           |                588 |
| [bynumlaw](https://metrics.torproject.org/rs.html#details/78E2BE744A53631B4AAB781468E94C52AB73968B)            | 0.4.5.0-alpha-dev |                587 |
| [Unnamed](https://metrics.torproject.org/rs.html#details/176FD686D08348E9FC5E014BD0B66899CEF34F13)             | 0.4.1.7           |                585 |
| [FallingoutofFour](https://metrics.torproject.org/rs.html#details/3D76AB27AC2F4318E2FC0490AF9E68F44C5D5876)    | 0.4.1.5           |                570 |
| [Asakusa](https://metrics.torproject.org/rs.html#details/657D2F4DD76D1BA7877EB2F1742ED9898EB04629)             | 0.4.1.6           |                570 |
| [inculpe](https://metrics.torproject.org/rs.html#details/2DEF1C5F4529665BB08A593C65BAF6917E9D2081)             | 0.4.1.6           |                565 |
| [ripde](https://metrics.torproject.org/rs.html#details/DB8D1454CE078844DDA447C8ACBEE440B267258D)               | 0.4.1.6           |                557 |
| [shekhinah00](https://metrics.torproject.org/rs.html#details/F14CD501D414CEA4595CF40ECF6E109332D6E0D7)         | 0.4.1.6           |                549 |
| [Unnamed](https://metrics.torproject.org/rs.html#details/75258E755064AA2412BC6BAB885756A3201F8C73)             | 0.4.1.6           |                548 |
| [UniGodPowerz](https://metrics.torproject.org/rs.html#details/1099A7ECE387A9B52F3AFDCF2BA9D28CDB8E3972)        | 0.4.1.7           |                530 |
| [Anon20200411](https://metrics.torproject.org/rs.html#details/355CCF19DFFFBE6A5D0B8E4CC956A4D9FF76A922)        | 0.4.1.9           |                507 |
| [ECHELON](https://metrics.torproject.org/rs.html#details/8D232B71FCC35537CF515255751C97297D51C1D4)             | 0.4.1.6           |                503 |
| [948794crazy](https://metrics.torproject.org/rs.html#details/1ACB2D005191B6B8BE2E26C021EB0BA1647A5AB3)         | 0.4.1.9           |                486 |
| [BigMacTorJuan](https://metrics.torproject.org/rs.html#details/D426B3F7FF144AAE24AECD72ED96820DDB338055)       | 0.4.1.5           |                481 |
| [effilochures](https://metrics.torproject.org/rs.html#details/949545960655C17A26F6525F67C554233CFE163F)        | 0.4.1.6           |                468 |
| [ry4an](https://metrics.torproject.org/rs.html#details/039003C320D9980E0A740F107A1A9C13C99C5FE3)               | 0.4.1.6           |                463 |
| [Unnamed](https://metrics.torproject.org/rs.html#details/5FB17DE2E897625CDCAE99A9FA7689ADE2F4A699)             | 0.4.1.6           |                430 |
| [SIGINT](https://metrics.torproject.org/rs.html#details/AE2AC9BCEF573A31B2055560BD92BBE4EF9223E3)              | 0.4.1.6           |                423 |
| [torfan](https://metrics.torproject.org/rs.html#details/7968BB694D05C0337227862CCA2207D66D7AAF10)              | 0.4.1.6           |                420 |
| [MarinAsagi](https://metrics.torproject.org/rs.html#details/F98A70E5427BFF111640011F7AE31E537ECF1DD2)          | 0.4.1.6           |                412 |
| [jamst](https://metrics.torproject.org/rs.html#details/EFF9E0B5B813E7269C910A3BBB2286957533CBA2)               | 0.4.1.6           |                400 |
| [Unnamed](https://metrics.torproject.org/rs.html#details/E48AD02C54FD3F8C3A4EA37452CE3281A0D246A4)             | 0.4.1.7           |                390 |
| [soltor0](https://metrics.torproject.org/rs.html#details/296B2178FD742AB35AB20C9ADF04D5DFD3D407EB)             | 0.4.1.5           |                370 |
| [Cir0X](https://metrics.torproject.org/rs.html#details/C33B36DBD576D4DE141443D28122575DA159D1B3)               | 0.4.1.6           |                359 |
| [ScholrshipRemote](https://metrics.torproject.org/rs.html#details/5A2C2BF25864F185AA91D2915943525609AC7F13)    | 0.4.1.6           |                338 |
| [EuropenSheil](https://metrics.torproject.org/rs.html#details/CE16FCC68A8EFB0D1D3E0F3E7BA2A4E1950266E9)        | 0.4.1.6           |                322 |
| [CriticDelighted](https://metrics.torproject.org/rs.html#details/84AFAE19244541A404F763BA0E2F0CAD8A3FACF0)     | 0.4.1.6           |                309 |
| [FreeSnowden](https://metrics.torproject.org/rs.html#details/87EA37CC2F1570EB500C46A691E505A70326BD36)         | 0.4.1.6           |                304 |
| [fleischkaesesemmel](https://metrics.torproject.org/rs.html#details/CF556653E704F7B619E1BBC0AE86A8E2E185A17F)  | 0.4.1.5           |                291 |
| [soltor1](https://metrics.torproject.org/rs.html#details/B8D8E07448E0405F4275E52884ED9CEF63FEE4A3)             | 0.4.1.5           |                280 |
| [Unnamed](https://metrics.torproject.org/rs.html#details/88E9D93B5D6FE4B150BF721D8E36DB1C2FF92F29)             | 0.4.1.6           |                276 |
| [mayNiecesReloc](https://metrics.torproject.org/rs.html#details/E020B8464182C7E46C697D2590848547E8F0C883)      | 0.4.5.0-alpha-dev |                272 |
| [rubricatus](https://metrics.torproject.org/rs.html#details/413317EDE5FA882318F47B8752531A726D7BEF08)          | 0.4.1.6           |                254 |
| [LongsideOutbck](https://metrics.torproject.org/rs.html#details/1C265471CAAB20F1D3EFBBB6D6648E060E7F75C4)      | 0.4.1.6           |                249 |
| [FscinteReconstruct](https://metrics.torproject.org/rs.html#details/33B07D509C6D67006C9AE29ECD4F8EAD1B1112CB)  | 0.4.1.6           |                242 |
| [BlueVenera](https://metrics.torproject.org/rs.html#details/F1E2D7E20717FE4CF71AAF39593126C9C1BACDB7)          | 0.4.1.6           |                228 |
| [FlexibleSdness](https://metrics.torproject.org/rs.html#details/3CEF68373ADB77D70C2B17E808D5B01A4E1567A7)      | 0.4.1.6           |                220 |
| [LastResort](https://metrics.torproject.org/rs.html#details/01722A60DC0EAA64D7905AD60A3242C6091E73D1)          | 0.4.1.6           |                210 |
| [SkyLights](https://metrics.torproject.org/rs.html#details/23917BB3F3994BC61F0C9D7AD19B069F9E150D26)           | 0.4.1.5           |                204 |
| [Puhuri](https://metrics.torproject.org/rs.html#details/98B2C98C05652E42E3FEB62185993C8E87E42173)              | 0.4.1.6           |                198 |
| [OpenBSDRelay](https://metrics.torproject.org/rs.html#details/05DC5DBEFB651BC02946DB3286F85DB1B5D2C3D6)        | 0.4.1.6           |                191 |
| [FormerJewel](https://metrics.torproject.org/rs.html#details/636794E0F8F1067E550FA51BF457163FFE2AC335)         | 0.4.1.6           |                189 |
| [GrvityImmune](https://metrics.torproject.org/rs.html#details/989D1D15EB4C28F11FC620B622FED221DFAF2BA6)        | 0.4.1.6           |                170 |
| [torexitrendrag](https://metrics.torproject.org/rs.html#details/72657B96BF99B28FBD9F2B036A590AA8A4535422)      | 0.4.1.6           |                169 |
| [VccineEffort](https://metrics.torproject.org/rs.html#details/99D56885FD9160FBA33A6468BA1134B60837DC21)        | 0.4.1.6           |                166 |
| [OrgnicCcount](https://metrics.torproject.org/rs.html#details/BC170D6C79EB09EF17193466097D1C7788031A3D)        | 0.4.1.6           |                166 |
| [OughtEcology](https://metrics.torproject.org/rs.html#details/EDC89E2825E4A08392C6DF1F18B3B0D6DB148597)        | 0.4.1.6           |                165 |
| [telebube](https://metrics.torproject.org/rs.html#details/DD8F5A74DD375F1D6A798A1AB50116339FEBED01)            | 0.4.1.6           |                157 |
| [AIgeneratedPostcard](https://metrics.torproject.org/rs.html#details/FAC70E0E2B41FF5DB186708D13C06985CCC116E3) | 0.4.1.9           |                150 |
| [rinderwahnRelay16L](https://metrics.torproject.org/rs.html#details/6DC6CDC6DDA99915EB0232071C6DD2C8784A191F)  | 0.4.5.0-alpha-dev |                146 |
| [TtitudePhysicin](https://metrics.torproject.org/rs.html#details/E5ABD9509709B004D3F797331EB2312EA5782962)     | 0.4.1.6           |                146 |
| [heraklon](https://metrics.torproject.org/rs.html#details/38B9443D2FF0BA1807A598CF64AC7709787A337C)            | 0.4.1.6           |                135 |
| [justinian](https://metrics.torproject.org/rs.html#details/83DBFD03B9DA4767BF5B320818AA8031829D9177)           | 0.4.1.6           |                117 |
| [WodRelay](https://metrics.torproject.org/rs.html#details/BF3E9B97D3CE4099F73AA4BD70CA14B635FA3CEA)            | 0.4.1.5           |                114 |
| [loxodonta](https://metrics.torproject.org/rs.html#details/427DEDAA28D39672F3D9B7714170C724634671F3)           | 0.4.1.5           |                 96 |
| [Boedi9Berlin](https://metrics.torproject.org/rs.html#details/F5F27F26E90667828D03DF6AA03FBE9CEA561E76)        | 0.4.5.0-alpha-dev |                 78 |
| [beefyboi](https://metrics.torproject.org/rs.html#details/A9857E51FA95633A5981F40701D4C9480B3A055C)            | 0.4.1.9           |                 62 |
| [avarnerdotorg](https://metrics.torproject.org/rs.html#details/F919A0CB490DA12BB8C34C273FD765FA32C69E55)       | 0.4.1.6           |                 62 |
| [fogbank](https://metrics.torproject.org/rs.html#details/3539F96FCCDC645C7801006F92864CBAFD4A8EB2)             | 0.4.1.9           |                 57 |
| [itvara](https://metrics.torproject.org/rs.html#details/D03ECC92786B42005F57014F3C94439607FBC86B)              | 0.4.1.6           |                 50 |
| [GoingNowhere](https://metrics.torproject.org/rs.html#details/B055C17F799045A561CB2B0A81AA91727158D4B9)        | 0.4.5.0-alpha-dev |                 34 |
| [Vreeken](https://metrics.torproject.org/rs.html#details/6F5E5E6C654415761A2535489CC5D50B01B6CA62)             | 0.4.1.5           |                 30 |
| [StarbucksBathroom](https://metrics.torproject.org/rs.html#details/3D7B9FAF96AD603D5A9C38E5434D9130682120B0)   | 0.4.1.5           |                 26 |
| [Unnamed](https://metrics.torproject.org/rs.html#details/8B2EB2BB539D0B87A7BA4BE1677A6501A04B889B)             | 0.4.1.6           |                 25 |
| [Mewau](https://metrics.torproject.org/rs.html#details/6A3C46F34152E84E62460889C306AA878900E60F)               | 0.4.1.5           |                 22 |
| [moria1](https://metrics.torproject.org/rs.html#details/9695DFC35FFEB861329B9F1AB04C46397020CE31)              | 0.4.5.0-alpha-dev |                 20 |
| [Blockwart](https://metrics.torproject.org/rs.html#details/78ED845D502DFFA4666EEA909983DE81DE1A3F9E)           | 0.4.1.6           |                 18 |
| [seabreeze](https://metrics.torproject.org/rs.html#details/35E93A587C3B65B0686569EE373E8BC0507F7E0D)           | 0.4.1.9           |                 14 |
| [demoncore](https://metrics.torproject.org/rs.html#details/EC72881A1128EB1B283EE53F54907477119A6FE4)           | 0.4.1.9           |                 13 |
| [rex](https://metrics.torproject.org/rs.html#details/15A2EAE0681491A5EF2D54540A6878307E7596B7)                 | 0.4.1.6           |                  9 |
| [pangosecure](https://metrics.torproject.org/rs.html#details/71E0CED145BF94077032088DFF03C82FA3E5147F)         | 0.4.1.9           |                  9 |
| [PepeCollusion](https://metrics.torproject.org/rs.html#details/DEF1E9207279E8792AE114D54FAC110CFE5E20A3)       | 0.4.1.6           |                  9 |
| [Sandcat](https://metrics.torproject.org/rs.html#details/B517198536D5532937FD8926428DE744BAC14C11)             | 0.4.1.9           |                  8 |
| [newnet5555](https://metrics.torproject.org/rs.html#details/1A66AD5F7CBDE34C0BDD849D28809CF981893B2C)          | 0.4.1.6           |                  6 |
| [22c7676e678bb03519](https://metrics.torproject.org/rs.html#details/8EF77FD0091B4221AB59C62630C5D54F66E4C7CE)  | 0.4.1.6           |                  4 |