//
//  offsets.swift
//  Chimera13
//
//  Created by CoolStar on 3/1/20.
//  Copyright © 2020 coolstar. All rights reserved.
//

import Foundation

struct Consts {
    static let shared = Consts()
    
    let TF_PLATFORM = UInt32(0x00000400)
    
    let CS_VALID = UInt32(0x00000001)
    let CS_GET_TASK_ALLOW = UInt32(0x00000004)
    let CS_INSTALLER = UInt32(0x00000008)
    
    let CS_HARD = UInt32(0x00000100)
    let CS_KILL = UInt32(0x00000200)
    let CS_RESTRICT = UInt32(0x00000800)
    
    let CS_PLATFORM_BINARY = UInt32(0x04000000)
    let CS_DEBUGGED = UInt32(0x10000000)
}

struct Offsets {
    static let shared = Offsets()
    public struct ProcOffsets {
        let pid = UInt64(0x68)
        let task = UInt64(0x10)
        let ucred = UInt64(0x100)
        let fd = UInt64(0x108)
        
        let textvp = UInt64(0x238)
        let textoff = UInt64(0x240)
        
        let name = UInt64(0x258)
        let csflags = UInt64(0x298)
    }
    let proc = ProcOffsets()
    
    public struct UcredOffsets {
        let cr_svuid = UInt64(0x20)
        let cr_label = UInt64(0x78)
    }
    let ucred = UcredOffsets()
    
    public struct FiledescOffsets {
        let ofiles = UInt64(0x0)
    }
    let filedesc = FiledescOffsets()
    
    public struct FileProcOffsets {
        let fglob = UInt64(0x10)
    }
    let fileproc = FileProcOffsets()
    
    public struct FileGlobOffsets {
        let data = UInt64(0x38)
    }
    let fileglob = FileGlobOffsets()
    
    public struct TaskOffsets {
        let lck = UInt64(0x0)
        let lck_mtx_type = UInt64(0xb)
        let active = UInt64(0x14)
        let ref_count = UInt64(0x10)
        let vm_map = UInt64(0x28)
        
        let itk_lck = UInt64(0xE8) //itk_self - 0x10
        let itk_lck_mtx_type = UInt64(0xF3) //itk_self - 0x10 + 0xb
        
        let itk_self = UInt64(0xF8)
        let itk_sself = UInt64(0x108)
        let itk_bootstrap = UInt64(0x2A8)
        let itk_space = UInt64(0x320)
        
        let bsd_info = isArm64e() ? UInt64(0x388) : UInt64(0x380)
        let flags =  isArm64e() ? UInt64(0x3C0) : UInt64(0x3B8)
        
        let all_image_info_addr = isArm64e() ? UInt64(0x3d0) : UInt64(0x3c8)
        let all_image_info_size = isArm64e() ? UInt64(0x3d8) : UInt64(0x3d0)
        
        let prev = UInt64(0x38)
    }
    let task = TaskOffsets()
    
    public struct IpcPortOffsets {
        let io_bits = UInt64(0x00)
        let io_references = UInt64(0x04)
        let ip_mscount = UInt64(0x9C)
        let ip_receiver = UInt64(0x60)
        let ip_srights = UInt64(0xa0)
        let ip_kobject = UInt64(0x68)
    }
    let ipc_port = IpcPortOffsets()
    
    public struct IpcSpaceOffsets {
        let is_table = UInt64(0x20)
    }
    let ipc_space = IpcSpaceOffsets()
    
    public struct HostOffsets {
        let special = UInt64(0x10)
    }
    let host = HostOffsets()
    
    public struct ApfsDataOffsets {
        let flag = UInt64(0x31)
    }
    let apfsData = ApfsDataOffsets()
    
    public struct VnodeOffsets {
        let ncchildren = UInt64(0x30)
        let flag = UInt64(0x54)
        let type = UInt64(0x70)
        let id = UInt64(0x74)
        let ubcinfo = UInt64(0x78)
        let specinfo = UInt64(0x78)
        let name = UInt64(0xb8)
        let parent = UInt64(0xc0)
        let mount = UInt64(0xd8)
        let data = UInt64(0xe0)
    }
    let vnode = VnodeOffsets()
    
    public struct CSBlobOffsets {
        let csb_cputype = UInt64(0x8)
        let csb_flags = UInt64(0xc)
        let csb_base_offset = UInt64(0x10)
        let csb_cdhash = UInt64(0x40)
        let csb_entitlements_offset = UInt64(0x90)
        let csb_signer_type = UInt64(0x40)
        let csb_entitlements = UInt64(0x98)
    }
    let csblob = CSBlobOffsets()
    
    public struct UbcinfoOffsets {
        let csblobs = UInt64(0x50)
    }
    let ucbinfo = UbcinfoOffsets()
    
    public struct SpecinfoOffsets {
        let flags = UInt64(0x10)
    }
    let specinfo = SpecinfoOffsets()
    
    public struct MountOffsets {
        let mnt_next = UInt64(0x0)
        let vnodelist = UInt64(0x40)
        let flag = UInt64(0x70)
        let data = UInt64(0x8f8)
        let devvp = UInt64(0x980)
    }
    let mount = MountOffsets()
    
    public struct NamecacheOffsets {
        let nc_child = UInt64(0x10)
        let name = UInt64(0x58)
        let dvp = UInt64(0x40)
        let vp = UInt64(0x48)
    }
    let namecache = NamecacheOffsets()
    
    public struct OsObjOffsets {
        let os_object_retaincount = UInt64(0x8)
        let os_string_string = UInt64(0x10)
        let os_dict_count = UInt64(0x14)
        let os_dict_dict_entry = UInt64(0x20)
    }
    let osobject = OsObjOffsets()
    
    public struct NvramOffsets {
        let sha384_digest_length = 48
        
        let ap_nonce_generate_nonce_sel = UInt32(0xC8)
        let ap_nonce_boot_nonce_os_symbol = UInt64(0xC0)
        
        let io_dt_nvram_of_dict = UInt64(0xC0)
    }
    let nvram = NvramOffsets()
}
