//
//  kernSlide.swift
//  Chimera13
//
//  Created by CoolStar on 4/3/20.
//  Copyright © 2020 coolstar. All rights reserved.
//

import Foundation

func getKernSlide(our_proc: UInt64) -> UInt64 {
    let offsets = Offsets.shared
    
    let our_ucred = rk64(our_proc + offsets.proc.ucred)
    let our_entitlements = rk64(rk64(our_ucred + offsets.ucred.cr_label) + 0x8)
    
    var vtable = rk64(our_entitlements)
    print(String(format: "vtable: 0x%llx", vtable))
    
    vtable |= UInt64(0xffffff8000000000) //strip pac
    
    var funct = rk64(vtable + (8 * 0x1f)) //osdictionary set object
    print(String(format: "func: 0x%llx", funct))
    
    funct |= UInt64(0xffffff8000000000) //strip pac
    
    var kernel_page = funct & ~UInt64(0xfff)
    while true {
        let hdr = rk32(kernel_page)
        if hdr == 0xfeedfacf {
            print(String(format: "Found kernel base 0x%llx", kernel_page))
            return kernel_page - UInt64(0xFFFFFFF007004000)
        }
        kernel_page -= 0x1000
    }
}
