# Script to automatically identify WDF function pointers
# Inspired by http://redplait.blogspot.ru/2012/12/wdffunctionsidc.html
# Originally by Nicolas Guigo, modified by Braden Hollembaek and Adam Pond

from idautils import *
from idaapi import *
from idc import *

# Architecture dependent globals
FF_PTR = FF_QWRD # FF_DWRD
get_ptr = get_64bit # get_32bit
ptr_size = 8 # 4

def log(string):
	print '[+]: ' + string

def add_struct(version):
	id = -1
	offset = 0
	# check for existing
	id = get_struc_id('WDFFUNCTIONS')
	if id != -1:
		# delete old struc
		del_struc(get_struc(id))
	log('Creating struct for WDF Functions version 1.%d' % version)
	id = add_struc(-1, 'WDFFUNCTIONS', 0)
	struc = get_struc(id)
	if id != -1:
		add_struc_member(struc, "pfnWdfChildListCreate", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfChildListGetDevice", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfChildListRetrievePdo", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfChildListRetrieveAddressDescription", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfChildListBeginScan", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfChildListEndScan", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfChildListBeginIteration", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfChildListRetrieveNextDevice", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfChildListEndIteration", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfChildListAddOrUpdateChildDescriptionAsPresent", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfChildListUpdateChildDescriptionAsMissing", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfChildListUpdateAllChildDescriptionsAsPresent", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfChildListRequestChildEject", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfCollectionCreate", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfCollectionGetCount", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfCollectionAdd", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfCollectionRemove", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfCollectionRemoveItem", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfCollectionGetItem", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfCollectionGetFirstItem", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfCollectionGetLastItem", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfCommonBufferCreate", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfCommonBufferGetAlignedVirtualAddress", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfCommonBufferGetAlignedLogicalAddress", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfCommonBufferGetLength", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfControlDeviceInitAllocate", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfControlDeviceInitSetShutdownNotification", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfControlFinishInitializing", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceGetDeviceState", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceSetDeviceState", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfWdmDeviceGetWdfDeviceHandle", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceWdmGetDeviceObject", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceWdmGetAttachedDevice", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceWdmGetPhysicalDevice", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceWdmDispatchPreprocessedIrp", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceAddDependentUsageDeviceObject", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceAddRemovalRelationsPhysicalDevice", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceRemoveRemovalRelationsPhysicalDevice", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceClearRemovalRelationsDevices", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceGetDriver", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceRetrieveDeviceName", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceAssignMofResourceName", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceGetIoTarget", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceGetDevicePnpState", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceGetDevicePowerState", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceGetDevicePowerPolicyState", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceAssignS0IdleSettings", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceAssignSxWakeSettings", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceOpenRegistryKey", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceSetSpecialFileSupport", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceSetCharacteristics", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceGetCharacteristics", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceGetAlignmentRequirement", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceSetAlignmentRequirement", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceInitFree", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceInitSetPnpPowerEventCallbacks", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceInitSetPowerPolicyEventCallbacks", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceInitSetPowerPolicyOwnership", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceInitRegisterPnpStateChangeCallback", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceInitRegisterPowerStateChangeCallback", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceInitRegisterPowerPolicyStateChangeCallback", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceInitSetIoType", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceInitSetExclusive", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceInitSetPowerNotPageable", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceInitSetPowerPageable", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceInitSetPowerInrush", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceInitSetDeviceType", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceInitAssignName", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceInitAssignSDDLString", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceInitSetDeviceClass", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceInitSetCharacteristics", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceInitSetFileObjectConfig", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceInitSetRequestAttributes", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceInitAssignWdmIrpPreprocessCallback", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceInitSetIoInCallerContextCallback", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceCreate", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceSetStaticStopRemove", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceCreateDeviceInterface", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceSetDeviceInterfaceState", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceRetrieveDeviceInterfaceString", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceCreateSymbolicLink", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceQueryProperty", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceAllocAndQueryProperty", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceSetPnpCapabilities", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceSetPowerCapabilities", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceSetBusInformationForChildren", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceIndicateWakeStatus", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceSetFailed", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceStopIdle", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceResumeIdle", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceGetFileObject", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceEnqueueRequest", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceGetDefaultQueue", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceConfigureRequestDispatching", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDmaEnablerCreate", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDmaEnablerGetMaximumLength", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDmaEnablerGetMaximumScatterGatherElements", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDmaEnablerSetMaximumScatterGatherElements", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDmaTransactionCreate", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDmaTransactionInitialize", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDmaTransactionInitializeUsingRequest", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDmaTransactionExecute", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDmaTransactionRelease", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDmaTransactionDmaCompleted", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDmaTransactionDmaCompletedWithLength", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDmaTransactionDmaCompletedFinal", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDmaTransactionGetBytesTransferred", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDmaTransactionSetMaximumLength", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDmaTransactionGetRequest", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDmaTransactionGetCurrentDmaTransferLength", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDmaTransactionGetDevice", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDpcCreate", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDpcEnqueue", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDpcCancel", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDpcGetParentObject", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDpcWdmGetDpc", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDriverCreate", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDriverGetRegistryPath", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDriverWdmGetDriverObject", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDriverOpenParametersRegistryKey", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfWdmDriverGetWdfDriverHandle", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDriverRegisterTraceInfo", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDriverRetrieveVersionString", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDriverIsVersionAvailable", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfFdoInitWdmGetPhysicalDevice", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfFdoInitOpenRegistryKey", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfFdoInitQueryProperty", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfFdoInitAllocAndQueryProperty", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfFdoInitSetEventCallbacks", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfFdoInitSetFilter", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfFdoInitSetDefaultChildListConfig", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfFdoQueryForInterface", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfFdoGetDefaultChildList", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfFdoAddStaticChild", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfFdoLockStaticChildListForIteration", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfFdoRetrieveNextStaticChild", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfFdoUnlockStaticChildListFromIteration", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfFileObjectGetFileName", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfFileObjectGetFlags", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfFileObjectGetDevice", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfFileObjectWdmGetFileObject", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfInterruptCreate", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfInterruptQueueDpcForIsr", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfInterruptSynchronize", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfInterruptAcquireLock", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfInterruptReleaseLock", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfInterruptEnable", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfInterruptDisable", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfInterruptWdmGetInterrupt", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfInterruptGetInfo", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfInterruptSetPolicy", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfInterruptGetDevice", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfIoQueueCreate", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfIoQueueGetState", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfIoQueueStart", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfIoQueueStop", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfIoQueueStopSynchronously", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfIoQueueGetDevice", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfIoQueueRetrieveNextRequest", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfIoQueueRetrieveRequestByFileObject", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfIoQueueFindRequest", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfIoQueueRetrieveFoundRequest", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfIoQueueDrainSynchronously", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfIoQueueDrain", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfIoQueuePurgeSynchronously", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfIoQueuePurge", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfIoQueueReadyNotify", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfIoTargetCreate", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfIoTargetOpen", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfIoTargetCloseForQueryRemove", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfIoTargetClose", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfIoTargetStart", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfIoTargetStop", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfIoTargetGetState", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfIoTargetGetDevice", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfIoTargetQueryTargetProperty", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfIoTargetAllocAndQueryTargetProperty", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfIoTargetQueryForInterface", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfIoTargetWdmGetTargetDeviceObject", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfIoTargetWdmGetTargetPhysicalDevice", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfIoTargetWdmGetTargetFileObject", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfIoTargetWdmGetTargetFileHandle", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfIoTargetSendReadSynchronously", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfIoTargetFormatRequestForRead", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfIoTargetSendWriteSynchronously", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfIoTargetFormatRequestForWrite", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfIoTargetSendIoctlSynchronously", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfIoTargetFormatRequestForIoctl", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfIoTargetSendInternalIoctlSynchronously", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfIoTargetFormatRequestForInternalIoctl", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfIoTargetSendInternalIoctlOthersSynchronously", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfIoTargetFormatRequestForInternalIoctlOthers", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfMemoryCreate", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfMemoryCreatePreallocated", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfMemoryGetBuffer", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfMemoryAssignBuffer", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfMemoryCopyToBuffer", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfMemoryCopyFromBuffer", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfLookasideListCreate", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfMemoryCreateFromLookaside", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceMiniportCreate", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDriverMiniportUnload", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfObjectGetTypedContextWorker", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfObjectAllocateContext", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfObjectContextGetObject", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfObjectReferenceActual", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfObjectDereferenceActual", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfObjectCreate", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfObjectDelete", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfObjectQuery", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfPdoInitAllocate", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfPdoInitSetEventCallbacks", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfPdoInitAssignDeviceID", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfPdoInitAssignInstanceID", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfPdoInitAddHardwareID", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfPdoInitAddCompatibleID", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfPdoInitAddDeviceText", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfPdoInitSetDefaultLocale", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfPdoInitAssignRawDevice", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfPdoMarkMissing", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfPdoRequestEject", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfPdoGetParent", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfPdoRetrieveIdentificationDescription", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfPdoRetrieveAddressDescription", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfPdoUpdateAddressDescription", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfPdoAddEjectionRelationsPhysicalDevice", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfPdoRemoveEjectionRelationsPhysicalDevice", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfPdoClearEjectionRelationsDevices", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDeviceAddQueryInterface", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfRegistryOpenKey", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfRegistryCreateKey", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfRegistryClose", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfRegistryWdmGetHandle", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfRegistryRemoveKey", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfRegistryRemoveValue", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfRegistryQueryValue", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfRegistryQueryMemory", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfRegistryQueryMultiString", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfRegistryQueryUnicodeString", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfRegistryQueryString", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfRegistryQueryULong", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfRegistryAssignValue", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfRegistryAssignMemory", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfRegistryAssignMultiString", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfRegistryAssignUnicodeString", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfRegistryAssignString", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfRegistryAssignULong", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfRequestCreate", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfRequestCreateFromIrp", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfRequestReuse", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfRequestChangeTarget", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfRequestFormatRequestUsingCurrentType", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfRequestWdmFormatUsingStackLocation", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfRequestSend", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfRequestGetStatus", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfRequestMarkCancelable", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfRequestUnmarkCancelable", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfRequestIsCanceled", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfRequestCancelSentRequest", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfRequestIsFrom32BitProcess", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfRequestSetCompletionRoutine", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfRequestGetCompletionParams", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfRequestAllocateTimer", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfRequestComplete", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfRequestCompleteWithPriorityBoost", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfRequestCompleteWithInformation", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfRequestGetParameters", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfRequestRetrieveInputMemory", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfRequestRetrieveOutputMemory", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfRequestRetrieveInputBuffer", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfRequestRetrieveOutputBuffer", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfRequestRetrieveInputWdmMdl", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfRequestRetrieveOutputWdmMdl", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfRequestRetrieveUnsafeUserInputBuffer", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfRequestRetrieveUnsafeUserOutputBuffer", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfRequestSetInformation", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfRequestGetInformation", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfRequestGetFileObject", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfRequestProbeAndLockUserBufferForRead", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfRequestProbeAndLockUserBufferForWrite", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfRequestGetRequestorMode", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfRequestForwardToIoQueue", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfRequestGetIoQueue", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfRequestRequeue", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfRequestStopAcknowledge", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfRequestWdmGetIrp", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfIoResourceRequirementsListSetSlotNumber", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfIoResourceRequirementsListSetInterfaceType", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfIoResourceRequirementsListAppendIoResList", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfIoResourceRequirementsListInsertIoResList", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfIoResourceRequirementsListGetCount", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfIoResourceRequirementsListGetIoResList", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfIoResourceRequirementsListRemove", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfIoResourceRequirementsListRemoveByIoResList", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfIoResourceListCreate", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfIoResourceListAppendDescriptor", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfIoResourceListInsertDescriptor", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfIoResourceListUpdateDescriptor", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfIoResourceListGetCount", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfIoResourceListGetDescriptor", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfIoResourceListRemove", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfIoResourceListRemoveByDescriptor", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfCmResourceListAppendDescriptor", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfCmResourceListInsertDescriptor", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfCmResourceListGetCount", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfCmResourceListGetDescriptor", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfCmResourceListRemove", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfCmResourceListRemoveByDescriptor", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfStringCreate", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfStringGetUnicodeString", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfObjectAcquireLock", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfObjectReleaseLock", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfWaitLockCreate", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfWaitLockAcquire", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfWaitLockRelease", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfSpinLockCreate", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfSpinLockAcquire", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfSpinLockRelease", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfTimerCreate", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfTimerStart", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfTimerStop", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfTimerGetParentObject", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfUsbTargetDeviceCreate", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfUsbTargetDeviceRetrieveInformation", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfUsbTargetDeviceGetDeviceDescriptor", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfUsbTargetDeviceRetrieveConfigDescriptor", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfUsbTargetDeviceQueryString", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfUsbTargetDeviceAllocAndQueryString", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfUsbTargetDeviceFormatRequestForString", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfUsbTargetDeviceGetNumInterfaces", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfUsbTargetDeviceSelectConfig", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfUsbTargetDeviceWdmGetConfigurationHandle", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfUsbTargetDeviceRetrieveCurrentFrameNumber", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfUsbTargetDeviceSendControlTransferSynchronously", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfUsbTargetDeviceFormatRequestForControlTransfer", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfUsbTargetDeviceIsConnectedSynchronous", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfUsbTargetDeviceResetPortSynchronously", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfUsbTargetDeviceCyclePortSynchronously", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfUsbTargetDeviceFormatRequestForCyclePort", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfUsbTargetDeviceSendUrbSynchronously", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfUsbTargetDeviceFormatRequestForUrb", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfUsbTargetPipeGetInformation", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfUsbTargetPipeIsInEndpoint", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfUsbTargetPipeIsOutEndpoint", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfUsbTargetPipeGetType", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfUsbTargetPipeSetNoMaximumPacketSizeCheck", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfUsbTargetPipeWriteSynchronously", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfUsbTargetPipeFormatRequestForWrite", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfUsbTargetPipeReadSynchronously", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfUsbTargetPipeFormatRequestForRead", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfUsbTargetPipeConfigContinuousReader", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfUsbTargetPipeAbortSynchronously", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfUsbTargetPipeFormatRequestForAbort", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfUsbTargetPipeResetSynchronously", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfUsbTargetPipeFormatRequestForReset", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfUsbTargetPipeSendUrbSynchronously", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfUsbTargetPipeFormatRequestForUrb", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfUsbInterfaceGetInterfaceNumber", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfUsbInterfaceGetNumEndpoints", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfUsbInterfaceGetDescriptor", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfUsbInterfaceSelectSetting", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfUsbInterfaceGetEndpointInformation", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfUsbTargetDeviceGetInterface", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfUsbInterfaceGetConfiguredSettingIndex", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfUsbInterfaceGetNumConfiguredPipes", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfUsbInterfaceGetConfiguredPipe", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfUsbTargetPipeWdmGetPipeHandle", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfVerifierDbgBreakPoint", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfVerifierKeBugCheck", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfWmiProviderCreate", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfWmiProviderGetDevice", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfWmiProviderIsEnabled", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfWmiProviderGetTracingHandle", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfWmiInstanceCreate", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfWmiInstanceRegister", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfWmiInstanceDeregister", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfWmiInstanceGetDevice", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfWmiInstanceGetProvider", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfWmiInstanceFireEvent", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfWorkItemCreate", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfWorkItemEnqueue", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfWorkItemGetParentObject", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfWorkItemFlush", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfCommonBufferCreateWithConfig", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDmaEnablerGetFragmentLength", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfDmaEnablerWdmGetDmaAdapter", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		add_struc_member(struc, "pfnWdfUsbInterfaceGetNumSettings", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
		if version >= 5:
			add_struc_member(struc, "pfnWdfDeviceRemoveDependentUsageDeviceObject", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
			add_struc_member(struc, "pfnWdfDeviceGetSystemPowerAction", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
			add_struc_member(struc, "pfnWdfInterruptSetExtendedPolicy", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
			add_struc_member(struc, "pfnWdfIoQueueAssignForwardProgressPolicy", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
			add_struc_member(struc, "pfnWdfPdoInitAssignContainerID", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
			add_struc_member(struc, "pfnWdfPdoInitAllowForwardingRequestToParent", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
			add_struc_member(struc, "pfnWdfRequestMarkCancelableEx", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
			add_struc_member(struc, "pfnWdfRequestIsReserved", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
			add_struc_member(struc, "pfnWdfRequestForwardToParentDeviceIoQueue", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
			if version >= 9:
				add_struc_member(struc, "pfnWdfCxDeviceInitAllocate", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
				add_struc_member(struc, "pfnWdfCxDeviceInitAssignWdmIrpPreprocessCallback", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
				add_struc_member(struc, "pfnWdfCxDeviceInitSetIoInCallerContextCallback", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
				add_struc_member(struc, "pfnWdfCxDeviceInitSetRequestAttributes", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
				add_struc_member(struc, "pfnWdfCxDeviceInitSetFileObjectConfig", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
				add_struc_member(struc, "pfnWdfDeviceWdmDispatchIrp", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
				add_struc_member(struc, "pfnWdfDeviceWdmDispatchIrpToIoQueue", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
				add_struc_member(struc, "pfnWdfDeviceInitSetRemoveLockOptions", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
				add_struc_member(struc, "pfnWdfDeviceConfigureWdmIrpDispatchCallback", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
				add_struc_member(struc, "pfnWdfDmaEnablerConfigureSystemProfile", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
				add_struc_member(struc, "pfnWdfDmaTransactionInitializeUsingOffset", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
				add_struc_member(struc, "pfnWdfDmaTransactionGetTransferInfo", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
				add_struc_member(struc, "pfnWdfDmaTransactionSetChannelConfigurationCallback", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
				add_struc_member(struc, "pfnWdfDmaTransactionSetTransferCompleteCallback", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
				add_struc_member(struc, "pfnWdfDmaTransactionSetImmediateExecution", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
				add_struc_member(struc, "pfnWdfDmaTransactionAllocateResources", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
				add_struc_member(struc, "pfnWdfDmaTransactionSetDeviceAddressOffset", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
				add_struc_member(struc, "pfnWdfDmaTransactionFreeResources", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
				add_struc_member(struc, "pfnWdfDmaTransactionCancel", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
				add_struc_member(struc, "pfnWdfDmaTransactionWdmGetTransferContext", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
				add_struc_member(struc, "pfnWdfInterruptQueueWorkItemForIsr", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
				add_struc_member(struc, "pfnWdfInterruptTryToAcquireLock", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
				add_struc_member(struc, "pfnWdfIoQueueStopAndPurge", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
				add_struc_member(struc, "pfnWdfIoQueueStopAndPurgeSynchronously", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
				add_struc_member(struc, "pfnWdfIoTargetPurge", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
				add_struc_member(struc, "pfnWdfUsbTargetDeviceCreateWithParameters", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
				add_struc_member(struc, "pfnWdfUsbTargetDeviceQueryUsbCapability", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
				add_struc_member(struc, "pfnWdfUsbTargetDeviceCreateUrb", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
				add_struc_member(struc, "pfnWdfUsbTargetDeviceCreateIsochUrb", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
				add_struc_member(struc, "pfnWdfDeviceWdmAssignPowerFrameworkSettings", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
				add_struc_member(struc, "pfnWdfDmaTransactionStopSystemTransfer", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
				add_struc_member(struc, "pfnWdfCxVerifierKeBugCheck", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
				add_struc_member(struc, "pfnWdfInterruptReportActive", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
				add_struc_member(struc, "pfnWdfInterruptReportInactive", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
				add_struc_member(struc, "pfnWdfDeviceInitSetReleaseHardwareOrderOnFailure", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
				add_struc_member(struc, "pfnWdfGetTriageInfo", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
				if version >= 11:
					 add_struc_member(struc,"pfnWdfDeviceInitSetIoTypeEx", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
					 add_struc_member(struc,"pfnWdfDeviceQueryPropertyEx", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
					 add_struc_member(struc,"pfnWdfDeviceAllocAndQueryPropertyEx", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
					 add_struc_member(struc,"pfnWdfDeviceAssignProperty", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
					 add_struc_member(struc,"pfnWdfFdoInitQueryPropertyEx", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
					 add_struc_member(struc,"pfnWdfFdoInitAllocAndQueryPropertyEx", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
					 if version >= 13:
					 	add_struc_member(struc,"pfnWdfDeviceStopIdleActual", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
					 	add_struc_member(struc,"pfnWdfDeviceResumeIdleActual", BADADDR, FF_DATA|FF_PTR, None, ptr_size)
	return id

def populate_wdf():
	# find data sections
	segment_starts = [get_segm_by_name('.data').startEA, get_segm_by_name('.rdata').startEA]
	for ea in segment_starts:
		if ea != BADADDR:
			# find "KmdfLibrary" unicode string in .rdata section
			idx = find_binary(ea, BADADDR, '"KmdfLibrary"', 0, SEARCH_UNICODE)
			if idx != BADADDR:
				log('Found "KmdfLibrary" unicode string at ' + hex(idx))
				addr = get_first_dref_to(idx)
				# hacky logic fix , consider only the minor portion
				version = int(str(Dword(addr+ptr_size+0x4)))
				id = add_struct(version)
				if id != -1:
					log('Success')
					wdf_func = get_ptr(addr+ptr_size+0x10)
					size = GetStrucSize(id)
					log('doStruct (size=' + hex(size) + ') at ' +  hex(wdf_func))
					do_unknown_range(wdf_func, size, 0)
					if doStruct(wdf_func, size, id) and set_name(wdf_func, 'WdfFunctions', 0):
						log('Success')
					else:
						log('Failure')
