# Contributing to UIKit-cross-platform

Please read this guide if you're interested in contributing to UIKit-cross-platform.

**We welcome any form of contribution, especially from new members of our community** 🙌

## Discussions

We invite you to actively participate in discussions in our [Github Issues](https://github.com/flowkey/UIKit-cross-platform/issues) and [Slack](https://uikit-cross-platform.slack.com).

[Click here for an invite to our Slack channel](http://bit.ly/uikit-cross-platform)

### Code of Conduct
This project and everyone participating in it is governed by our [Code of Conduct](CODE_OF_CONDUCT.md). By participating, you are expected to uphold this code. Please report unacceptable behavior to uikit@flowkey.com.

## Issues

To report a bug [click here](https://github.com/flowkey/UIKit-cross-platform/issues/new?template=bug.md).

When you're starting to look into fixing a bug, create a WIP PR that you mention in the original issue. This way, we ensure that everyone interested can share their thoughts, and duplicate work is prevented.

Adding tests is a great way to help preventing future bugs.

## Features

To request a new feature [click here](https://github.com/flowkey/UIKit-cross-platform/issues/new?template=feature.md).

To contribute features or API changes, it's best to start a discussion in an issue first, ideally with a proposal. This allows everyone to participate and ensures that no potential implementation work is in vain.

## Submitting Changes

After getting some feedback, push to your fork and submit a pull request. We
may suggest some changes or improvements or alternatives, but for small changes
your pull request should be accepted quickly.

### Practical steps

Below are a series of steps to help you from a more "practical" perspective. If you need additional help concerning Git, Github has some great guides that you may want to check out! Check them out [here](https://guides.github.com/)

**Fork the repo and then clone your fork**

SSH:
```sh
git clone git@github.com:YOUR_USERNAME/UIKit-cross-platform.git
```

HTTPS:
```sh
git clone https://github.com:YOUR_USERNAME/UIKit-cross-platform.git
```

**Add the remote upstream**

```sh
git remote add upstream git://github.com:flowkey/UIKit-cross-platform.git
```

**Fetch changes from upstream**

```sh
git fetch upstream
```

**Pull changes locally**

```sh
git pull upstream master
```

**Push changes up**

```sh
git push
```
