// 42f6113daff3eebf06d809a073c99651867c42ea
// Generated by the value-object.rb  DO NOT EDIT!!

#import "SCManagedVideoCapturerOutputSettings.h"

#import <SCFoundation/SCValueObjectHelpers.h>

#import <FastCoding/FastCoder.h>

@implementation SCManagedVideoCapturerOutputSettings

static ptrdiff_t sSCManagedVideoCapturerOutputSettingsOffsets[0];
static BOOL sSCManagedVideoCapturerOutputSettingsHasOffsets;

- (instancetype)initWithWidth:(CGFloat)width
                       height:(CGFloat)height
                 videoBitRate:(CGFloat)videoBitRate
                 audioBitRate:(CGFloat)audioBitRate
             keyFrameInterval:(NSUInteger)keyFrameInterval
                   outputType:(SCManagedVideoCapturerOutputType)outputType
{
    self = [super init];
    if (self) {
        _width = width;
        _height = height;
        _videoBitRate = videoBitRate;
        _audioBitRate = audioBitRate;
        _keyFrameInterval = keyFrameInterval;
        _outputType = outputType;
    }
    return self;
}

#pragma mark - NSCopying

- (instancetype)copyWithZone:(NSZone *)zone
{
    // Immutable object, bypass copy
    return self;
}

#pragma mark - NSCoding

- (instancetype)initWithCoder:(NSCoder *)aDecoder
{
    self = [super init];
    if (self) {
        _width = [aDecoder decodeFloatForKey:@"width"];
        _height = [aDecoder decodeFloatForKey:@"height"];
        _videoBitRate = [aDecoder decodeFloatForKey:@"videoBitRate"];
        _audioBitRate = [aDecoder decodeFloatForKey:@"audioBitRate"];
        _keyFrameInterval = [[aDecoder decodeObjectForKey:@"keyFrameInterval"] unsignedIntegerValue];
        _outputType = (SCManagedVideoCapturerOutputType)[aDecoder decodeIntegerForKey:@"outputType"];
    }
    return self;
}

- (void)encodeWithCoder:(NSCoder *)aCoder
{
    [aCoder encodeFloat:_width forKey:@"width"];
    [aCoder encodeFloat:_height forKey:@"height"];
    [aCoder encodeFloat:_videoBitRate forKey:@"videoBitRate"];
    [aCoder encodeFloat:_audioBitRate forKey:@"audioBitRate"];
    [aCoder encodeObject:@(_keyFrameInterval) forKey:@"keyFrameInterval"];
    [aCoder encodeInteger:(NSInteger)_outputType forKey:@"outputType"];
}

#pragma mark - FasterCoding

- (BOOL)preferFasterCoding
{
    return YES;
}

- (void)encodeWithFasterCoder:(id<FCFasterCoder>)fasterCoder
{
    [fasterCoder encodeFloat64:_audioBitRate];
    [fasterCoder encodeFloat64:_height];
    [fasterCoder encodeUInt64:_keyFrameInterval];
    [fasterCoder encodeSInt32:_outputType];
    [fasterCoder encodeFloat64:_videoBitRate];
    [fasterCoder encodeFloat64:_width];
}

- (void)decodeWithFasterDecoder:(id<FCFasterDecoder>)fasterDecoder
{
    _audioBitRate = (CGFloat)[fasterDecoder decodeFloat64];
    _height = (CGFloat)[fasterDecoder decodeFloat64];
    _keyFrameInterval = (NSUInteger)[fasterDecoder decodeUInt64];
    _outputType = (SCManagedVideoCapturerOutputType)[fasterDecoder decodeSInt32];
    _videoBitRate = (CGFloat)[fasterDecoder decodeFloat64];
    _width = (CGFloat)[fasterDecoder decodeFloat64];
}

- (void)setSInt32:(int32_t)val forUInt64Key:(uint64_t)key
{
    switch (key) {
    case 54425104364133881ULL:
        _outputType = (SCManagedVideoCapturerOutputType)val;
        break;
    }
}

- (void)setUInt64:(uint64_t)val forUInt64Key:(uint64_t)key
{
    switch (key) {
    case 47327990652274883ULL:
        _keyFrameInterval = (NSUInteger)val;
        break;
    }
}

- (void)setFloat64:(double)val forUInt64Key:(uint64_t)key
{
    switch (key) {
    case 50995534680662654ULL:
        _audioBitRate = (CGFloat)val;
        break;
    case 11656660716170763ULL:
        _height = (CGFloat)val;
        break;
    case 29034524155663716ULL:
        _videoBitRate = (CGFloat)val;
        break;
    case 30689178641753681ULL:
        _width = (CGFloat)val;
        break;
    }
}

+ (uint64_t)fasterCodingVersion
{
    return 14709152111692666517ULL;
}

+ (uint64_t *)fasterCodingKeys
{
    static uint64_t keys[] = {
        6 /* Total */,
        FC_ENCODE_KEY_TYPE(50995534680662654, FCEncodeTypeFloat64),
        FC_ENCODE_KEY_TYPE(11656660716170763, FCEncodeTypeFloat64),
        FC_ENCODE_KEY_TYPE(47327990652274883, FCEncodeTypeUInt64),
        FC_ENCODE_KEY_TYPE(54425104364133881, FCEncodeTypeSInt32),
        FC_ENCODE_KEY_TYPE(29034524155663716, FCEncodeTypeFloat64),
        FC_ENCODE_KEY_TYPE(30689178641753681, FCEncodeTypeFloat64),
    };
    return keys;
}

#pragma mark - isEqual

- (BOOL)isEqual:(id)object
{
    if (!SCObjectsIsEqual(self, object, &sSCManagedVideoCapturerOutputSettingsHasOffsets,
                          sSCManagedVideoCapturerOutputSettingsOffsets, 6, 0)) {
        return NO;
    }
    SCManagedVideoCapturerOutputSettings *other = (SCManagedVideoCapturerOutputSettings *)object;
    if (other->_width != _width) {
        return NO;
    }

    if (other->_height != _height) {
        return NO;
    }

    if (other->_videoBitRate != _videoBitRate) {
        return NO;
    }

    if (other->_audioBitRate != _audioBitRate) {
        return NO;
    }

    if (other->_keyFrameInterval != _keyFrameInterval) {
        return NO;
    }

    if (other->_outputType != _outputType) {
        return NO;
    }

    return YES;
}

- (NSUInteger)hash
{
    NSUInteger subhashes[] = {(NSUInteger)_width,        (NSUInteger)_height,           (NSUInteger)_videoBitRate,
                              (NSUInteger)_audioBitRate, (NSUInteger)_keyFrameInterval, (NSUInteger)_outputType};
    NSUInteger result = subhashes[0];
    for (int i = 1; i < 6; i++) {
        unsigned long long base = (((unsigned long long)result) << 32 | subhashes[i]);
        base = (~base) + (base << 18);
        base ^= (base >> 31);
        base *= 21;
        base ^= (base >> 11);
        base += (base << 6);
        base ^= (base >> 22);
        result = (NSUInteger)base;
    }
    return result;
}

#pragma mark - Print description in console: lldb> po #{variable name}

- (NSString *)description
{
    NSMutableString *desc = [NSMutableString string];
    [desc appendString:@"{\n"];
    [desc appendFormat:@"\twidth:%@\n", [@(_width) description]];
    [desc appendFormat:@"\theight:%@\n", [@(_height) description]];
    [desc appendFormat:@"\tvideoBitRate:%@\n", [@(_videoBitRate) description]];
    [desc appendFormat:@"\taudioBitRate:%@\n", [@(_audioBitRate) description]];
    [desc appendFormat:@"\tkeyFrameInterval:%@\n", [@(_keyFrameInterval) description]];
    [desc appendFormat:@"\toutputType:%@\n", [@(_outputType) description]];
    [desc appendString:@"}\n"];

    return [desc copy];
}

@end
