/**
 * Framework7 3.6.3
 * Full featured mobile HTML framework for building iOS & Android apps
 * http://framework7.io/
 *
 * Copyright 2014-2018 Vladimir Kharlampidi
 *
 * Released under the MIT License
 *
 * Released on: December 27, 2018
 */
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?module.exports=t():"function"==typeof define&&define.amd?define(t):e.Framework7=t()}("undefined"!=typeof self?self:this,function(){"use strict";var t7ctx;t7ctx="undefined"!=typeof window?window:"undefined"!=typeof global?global:void 0;var Template7Context=t7ctx,Template7Utils={quoteSingleRexExp:new RegExp("'","g"),quoteDoubleRexExp:new RegExp('"',"g"),isFunction:function(e){return"function"==typeof e},escape:function(e){return void 0!==Template7Context&&Template7Context.escape?Template7Context.escape(e):e.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;")},helperToSlices:function(e){var t,r,a,n=Template7Utils.quoteDoubleRexExp,o=Template7Utils.quoteSingleRexExp,i=e.replace(/[{}#}]/g,"").trim().split(" "),s=[];for(r=0;r<i.length;r+=1){var l=i[r],c=void 0,u=void 0;if(0===r)s.push(l);else if(0===l.indexOf('"')||0===l.indexOf("'"))if(c=0===l.indexOf('"')?n:o,u=0===l.indexOf('"')?'"':"'",2===l.match(c).length)s.push(l);else{for(t=0,a=r+1;a<i.length;a+=1)if(l+=" "+i[a],0<=i[a].indexOf(u)){t=a,s.push(l);break}t&&(r=t)}else if(0<l.indexOf("=")){var p=l.split("="),d=p[0],f=p[1];if(c||(c=0===f.indexOf('"')?n:o,u=0===f.indexOf('"')?'"':"'"),2!==f.match(c).length){for(t=0,a=r+1;a<i.length;a+=1)if(f+=" "+i[a],0<=i[a].indexOf(u)){t=a;break}t&&(r=t)}var h=[d,f.replace(c,"")];s.push(h)}else s.push(l)}return s},stringToBlocks:function(e){var t,r,a=[];if(!e)return[];var n=e.split(/({{[^{^}]*}})/);for(t=0;t<n.length;t+=1){var o=n[t];if(""!==o)if(o.indexOf("{{")<0)a.push({type:"plain",content:o});else{if(0<=o.indexOf("{/"))continue;if((o=o.replace(/{{([#/])*([ ])*/,"{{$1").replace(/([ ])*}}/,"}}")).indexOf("{#")<0&&o.indexOf(" ")<0&&o.indexOf("else")<0){a.push({type:"variable",contextName:o.replace(/[{}]/g,"")});continue}var i=Template7Utils.helperToSlices(o),s=i[0],l=">"===s,c=[],u={};for(r=1;r<i.length;r+=1){var p=i[r];Array.isArray(p)?u[p[0]]="false"!==p[1]&&p[1]:c.push(p)}if(0<=o.indexOf("{#")){var d="",f="",h=0,v=void 0,m=!1,g=!1,b=0;for(r=t+1;r<n.length;r+=1)if(0<=n[r].indexOf("{{#")&&(b+=1),0<=n[r].indexOf("{{/")&&(b-=1),0<=n[r].indexOf("{{#"+s))d+=n[r],g&&(f+=n[r]),h+=1;else if(0<=n[r].indexOf("{{/"+s)){if(!(0<h)){v=r,m=!0;break}h-=1,d+=n[r],g&&(f+=n[r])}else 0<=n[r].indexOf("else")&&0===b?g=!0:(g||(d+=n[r]),g&&(f+=n[r]));m&&(v&&(t=v),"raw"===s?a.push({type:"plain",content:d}):a.push({type:"helper",helperName:s,contextName:c,content:d,inverseContent:f,hash:u}))}else 0<o.indexOf(" ")&&(l&&(s="_partial",c[0]&&(0===c[0].indexOf("[")?c[0]=c[0].replace(/[[\]]/g,""):c[0]='"'+c[0].replace(/"|'/g,"")+'"')),a.push({type:"helper",helperName:s,contextName:c,hash:u}))}}return a},parseJsVariable:function(e,r,a){return e.split(/([+ \-*/^])/g).map(function(e){if(e.indexOf(r)<0)return e;if(!a)return JSON.stringify("");var t=a;return 0<=e.indexOf(r+".")&&e.split(r+".")[1].split(".").forEach(function(e){t=e in t?t[e]:void 0}),"string"==typeof t&&(t=JSON.stringify(t)),void 0===t&&(t="undefined"),t}).join("")},parseJsParents:function(e,a){return e.split(/([+ \-*^])/g).map(function(e){if(e.indexOf("../")<0)return e;if(!a||0===a.length)return JSON.stringify("");var t=e.split("../").length-1,r=t>a.length?a[a.length-1]:a[t-1];return e.replace(/..\//g,"").split(".").forEach(function(e){r=r[e]?r[e]:"undefined"}),JSON.stringify(r)}).join("")},getCompileVar:function(e,t,r){void 0===r&&(r="data_1");var a,n,o=t,i=0;a=0===e.indexOf("../")?(i=e.split("../").length-1,o="ctx_"+(1<=(n=o.split("_")[1]-i)?n:1),e.split("../")[i].split(".")):0===e.indexOf("@global")?(o="Template7.global",e.split("@global.")[1].split(".")):0===e.indexOf("@root")?(o="root",e.split("@root.")[1].split(".")):e.split(".");for(var s=0;s<a.length;s+=1){var l=a[s];if(0===l.indexOf("@")){var c=r.split("_")[1];0<i&&(c=n),0<s?o+="[(data_"+c+" && data_"+c+"."+l.replace("@","")+")]":o="(data_"+c+" && data_"+c+"."+l.replace("@","")+")"}else(Number.isFinite?Number.isFinite(l):Template7Context.isFinite(l))?o+="["+l+"]":"this"===l||0<=l.indexOf("this.")||0<=l.indexOf("this[")||0<=l.indexOf("this(")?o=l.replace("this",t):o+="."+l}return o},getCompiledArguments:function(e,t,r){for(var a=[],n=0;n<e.length;n+=1)/^['"]/.test(e[n])?a.push(e[n]):/^(true|false|\d+)$/.test(e[n])?a.push(e[n]):a.push(Template7Utils.getCompileVar(e[n],t,r));return a.join(", ")}},Template7Helpers={_partial:function(e,t){var r=this,a=Template7Class.partials[e];return!a||a&&!a.template?"":(a.compiled||(a.compiled=new Template7Class(a.template).compile()),Object.keys(t.hash).forEach(function(e){r[e]=t.hash[e]}),a.compiled(r,t.data,t.root))},escape:function(e){if("string"!=typeof e)throw new Error('Template7: Passed context to "escape" helper should be a string');return Template7Utils.escape(e)},if:function(e,t){var r=e;return Template7Utils.isFunction(r)&&(r=r.call(this)),r?t.fn(this,t.data):t.inverse(this,t.data)},unless:function(e,t){var r=e;return Template7Utils.isFunction(r)&&(r=r.call(this)),r?t.inverse(this,t.data):t.fn(this,t.data)},each:function(e,t){var r=e,a="",n=0;if(Template7Utils.isFunction(r)&&(r=r.call(this)),Array.isArray(r)){for(t.hash.reverse&&(r=r.reverse()),n=0;n<r.length;n+=1)a+=t.fn(r[n],{first:0===n,last:n===r.length-1,index:n});t.hash.reverse&&(r=r.reverse())}else for(var o in r)n+=1,a+=t.fn(r[o],{key:o});return 0<n?a:t.inverse(this)},with:function(e,t){var r=e;return Template7Utils.isFunction(r)&&(r=e.call(this)),t.fn(r)},join:function(e,t){var r=e;return Template7Utils.isFunction(r)&&(r=r.call(this)),r.join(t.hash.delimiter||t.hash.delimeter)},js:function js(expression,options){var data=options.data,func,execute=expression;return"index first last key".split(" ").forEach(function(e){if(void 0!==data[e]){var t=new RegExp("this.@"+e,"g"),r=new RegExp("@"+e,"g");execute=execute.replace(t,JSON.stringify(data[e])).replace(r,JSON.stringify(data[e]))}}),options.root&&0<=execute.indexOf("@root")&&(execute=Template7Utils.parseJsVariable(execute,"@root",options.root)),0<=execute.indexOf("@global")&&(execute=Template7Utils.parseJsVariable(execute,"@global",Template7Context.Template7.global)),0<=execute.indexOf("../")&&(execute=Template7Utils.parseJsParents(execute,options.parents)),func=0<=execute.indexOf("return")?"(function(){"+execute+"})":"(function(){return ("+execute+")})",eval(func).call(this)},js_if:function js_if(expression,options){var data=options.data,func,execute=expression;"index first last key".split(" ").forEach(function(e){if(void 0!==data[e]){var t=new RegExp("this.@"+e,"g"),r=new RegExp("@"+e,"g");execute=execute.replace(t,JSON.stringify(data[e])).replace(r,JSON.stringify(data[e]))}}),options.root&&0<=execute.indexOf("@root")&&(execute=Template7Utils.parseJsVariable(execute,"@root",options.root)),0<=execute.indexOf("@global")&&(execute=Template7Utils.parseJsVariable(execute,"@global",Template7Context.Template7.global)),0<=execute.indexOf("../")&&(execute=Template7Utils.parseJsParents(execute,options.parents)),func=0<=execute.indexOf("return")?"(function(){"+execute+"})":"(function(){return ("+execute+")})";var condition=eval(func).call(this);return condition?options.fn(this,options.data):options.inverse(this,options.data)}};Template7Helpers.js_compare=Template7Helpers.js_if;var Template7Options={},Template7Partials={},Template7Class=function(e){this.template=e},staticAccessors={options:{configurable:!0},partials:{configurable:!0},helpers:{configurable:!0}};function Template7(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];var r=e[0],a=e[1];if(2!==e.length)return new Template7Class(r);var n=new Template7Class(r),o=n.compile()(a);return n=null,o}Template7Class.prototype.compile=function compile(template,depth){void 0===template&&(template=this.template),void 0===depth&&(depth=1);var t=this;if(t.compiled)return t.compiled;if("string"!=typeof template)throw new Error("Template7: Template must be a string");var stringToBlocks=Template7Utils.stringToBlocks,getCompileVar=Template7Utils.getCompileVar,getCompiledArguments=Template7Utils.getCompiledArguments,blocks=stringToBlocks(template),ctx="ctx_"+depth,data="data_"+depth;if(0===blocks.length)return function(){return""};function getCompileFn(e,r){return e.content?t.compile(e.content,r):function(){return""}}function getCompileInverse(e,r){return e.inverseContent?t.compile(e.inverseContent,r):function(){return""}}var resultString="",i;for(resultString+=1===depth?"(function ("+ctx+", "+data+", root) {\n":"(function ("+ctx+", "+data+") {\n",1===depth&&(resultString+="function isArray(arr){return Array.isArray(arr);}\n",resultString+="function isFunction(func){return (typeof func === 'function');}\n",resultString+='function c(val, ctx) {if (typeof val !== "undefined" && val !== null) {if (isFunction(val)) {return val.call(ctx);} else return val;} else return "";}\n',resultString+="root = root || ctx_1 || {};\n"),resultString+="var r = '';\n",i=0;i<blocks.length;i+=1){var block=blocks[i];if("plain"!==block.type){var variable=void 0,compiledArguments=void 0;if("variable"===block.type&&(variable=getCompileVar(block.contextName,ctx,data),resultString+="r += c("+variable+", "+ctx+");"),"helper"===block.type){var parents=void 0;if("ctx_1"!==ctx){for(var level=ctx.split("_")[1],parentsString="ctx_"+(level-1),j=level-2;1<=j;j-=1)parentsString+=", ctx_"+j;parents="["+parentsString+"]"}else parents="["+ctx+"]";var dynamicHelper=void 0;if(0===block.helperName.indexOf("[")&&(block.helperName=getCompileVar(block.helperName.replace(/[[\]]/g,""),ctx,data),dynamicHelper=!0),dynamicHelper||block.helperName in Template7Helpers)compiledArguments=getCompiledArguments(block.contextName,ctx,data),resultString+="r += (Template7Helpers"+(dynamicHelper?"["+block.helperName+"]":"."+block.helperName)+").call("+ctx+", "+(compiledArguments&&compiledArguments+", ")+"{hash:"+JSON.stringify(block.hash)+", data: "+data+" || {}, fn: "+getCompileFn(block,depth+1)+", inverse: "+getCompileInverse(block,depth+1)+", root: root, parents: "+parents+"});";else{if(0<block.contextName.length)throw new Error('Template7: Missing helper: "'+block.helperName+'"');variable=getCompileVar(block.helperName,ctx,data),resultString+="if ("+variable+") {",resultString+="if (isArray("+variable+")) {",resultString+="r += (Template7Helpers.each).call("+ctx+", "+variable+", {hash:"+JSON.stringify(block.hash)+", data: "+data+" || {}, fn: "+getCompileFn(block,depth+1)+", inverse: "+getCompileInverse(block,depth+1)+", root: root, parents: "+parents+"});",resultString+="}else {",resultString+="r += (Template7Helpers.with).call("+ctx+", "+variable+", {hash:"+JSON.stringify(block.hash)+", data: "+data+" || {}, fn: "+getCompileFn(block,depth+1)+", inverse: "+getCompileInverse(block,depth+1)+", root: root, parents: "+parents+"});",resultString+="}}"}}}else resultString+="r +='"+block.content.replace(/\r/g,"\\r").replace(/\n/g,"\\n").replace(/'/g,"\\'")+"';"}return resultString+="\nreturn r;})",1===depth?(t.compiled=eval(resultString),t.compiled):resultString},staticAccessors.options.get=function(){return Template7Options},staticAccessors.partials.get=function(){return Template7Partials},staticAccessors.helpers.get=function(){return Template7Helpers},Object.defineProperties(Template7Class,staticAccessors),Template7.registerHelper=function(e,t){Template7Class.helpers[e]=t},Template7.unregisterHelper=function(e){Template7Class.helpers[e]=void 0,delete Template7Class.helpers[e]},Template7.registerPartial=function(e,t){Template7Class.partials[e]={template:t}},Template7.unregisterPartial=function(e){Template7Class.partials[e]&&(Template7Class.partials[e]=void 0,delete Template7Class.partials[e])},Template7.compile=function(e,t){return new Template7Class(e,t).compile()},Template7.options=Template7Class.options,Template7.helpers=Template7Class.helpers,Template7.partials=Template7Class.partials;var doc="undefined"==typeof document?{body:{},addEventListener:function(){},removeEventListener:function(){},activeElement:{blur:function(){},nodeName:""},querySelector:function(){return null},querySelectorAll:function(){return[]},getElementById:function(){return null},createEvent:function(){return{initEvent:function(){}}},createElement:function(){return{children:[],childNodes:[],style:{},setAttribute:function(){},getElementsByTagName:function(){return[]}}},location:{hash:""}}:document,win="undefined"==typeof window?{document:doc,navigator:{userAgent:""},location:{},history:{},CustomEvent:function(){return this},addEventListener:function(){},removeEventListener:function(){},getComputedStyle:function(){return{getPropertyValue:function(){return""}}},Image:function(){},Date:function(){},screen:{},setTimeout:function(){},clearTimeout:function(){}}:window,Dom7=function(e){for(var t=0;t<e.length;t+=1)this[t]=e[t];return this.length=e.length,this};function $(e,t){var r=[],a=0;if(e&&!t&&e instanceof Dom7)return e;if(e)if("string"==typeof e){var n,o,i=e.trim();if(0<=i.indexOf("<")&&0<=i.indexOf(">")){var s="div";for(0===i.indexOf("<li")&&(s="ul"),0===i.indexOf("<tr")&&(s="tbody"),0!==i.indexOf("<td")&&0!==i.indexOf("<th")||(s="tr"),0===i.indexOf("<tbody")&&(s="table"),0===i.indexOf("<option")&&(s="select"),(o=doc.createElement(s)).innerHTML=i,a=0;a<o.childNodes.length;a+=1)r.push(o.childNodes[a])}else for(n=t||"#"!==e[0]||e.match(/[ .<>:~]/)?(t||doc).querySelectorAll(e.trim()):[doc.getElementById(e.trim().split("#")[1])],a=0;a<n.length;a+=1)n[a]&&r.push(n[a])}else if(e.nodeType||e===win||e===doc)r.push(e);else if(0<e.length&&e[0].nodeType)for(a=0;a<e.length;a+=1)r.push(e[a]);return new Dom7(r)}function unique(e){for(var t=[],r=0;r<e.length;r+=1)-1===t.indexOf(e[r])&&t.push(e[r]);return t}function toCamelCase(e){return e.toLowerCase().replace(/-(.)/g,function(e,t){return t.toUpperCase()})}function requestAnimationFrame(e){return win.requestAnimationFrame?win.requestAnimationFrame(e):win.webkitRequestAnimationFrame?win.webkitRequestAnimationFrame(e):win.setTimeout(e,1e3/60)}function cancelAnimationFrame(e){return win.cancelAnimationFrame?win.cancelAnimationFrame(e):win.webkitCancelAnimationFrame?win.webkitCancelAnimationFrame(e):win.clearTimeout(e)}function addClass(e){if(void 0===e)return this;for(var t=e.split(" "),r=0;r<t.length;r+=1)for(var a=0;a<this.length;a+=1)void 0!==this[a]&&void 0!==this[a].classList&&this[a].classList.add(t[r]);return this}function removeClass(e){for(var t=e.split(" "),r=0;r<t.length;r+=1)for(var a=0;a<this.length;a+=1)void 0!==this[a]&&void 0!==this[a].classList&&this[a].classList.remove(t[r]);return this}function hasClass(e){return!!this[0]&&this[0].classList.contains(e)}function toggleClass(e){for(var t=e.split(" "),r=0;r<t.length;r+=1)for(var a=0;a<this.length;a+=1)void 0!==this[a]&&void 0!==this[a].classList&&this[a].classList.toggle(t[r]);return this}function attr(e,t){var r=arguments;if(1===arguments.length&&"string"==typeof e)return this[0]?this[0].getAttribute(e):void 0;for(var a=0;a<this.length;a+=1)if(2===r.length)this[a].setAttribute(e,t);else for(var n in e)this[a][n]=e[n],this[a].setAttribute(n,e[n]);return this}function removeAttr(e){for(var t=0;t<this.length;t+=1)this[t].removeAttribute(e);return this}function prop(e,t){var r=arguments;if(1!==arguments.length||"string"!=typeof e){for(var a=0;a<this.length;a+=1)if(2===r.length)this[a][e]=t;else for(var n in e)this[a][n]=e[n];return this}if(this[0])return this[0][e]}function data(e,t){var r;if(void 0!==t){for(var a=0;a<this.length;a+=1)(r=this[a]).dom7ElementDataStorage||(r.dom7ElementDataStorage={}),r.dom7ElementDataStorage[e]=t;return this}if(r=this[0]){if(r.dom7ElementDataStorage&&e in r.dom7ElementDataStorage)return r.dom7ElementDataStorage[e];var n=r.getAttribute("data-"+e);return n||void 0}}function removeData(e){for(var t=0;t<this.length;t+=1){var r=this[t];r.dom7ElementDataStorage&&r.dom7ElementDataStorage[e]&&(r.dom7ElementDataStorage[e]=null,delete r.dom7ElementDataStorage[e])}}function dataset(){var e=this[0];if(e){var t={};if(e.dataset)for(var r in e.dataset)t[r]=e.dataset[r];else for(var a=0;a<e.attributes.length;a+=1){var n=e.attributes[a];0<=n.name.indexOf("data-")&&(t[toCamelCase(n.name.split("data-")[1])]=n.value)}for(var o in t)"false"===t[o]?t[o]=!1:"true"===t[o]?t[o]=!0:parseFloat(t[o])===1*t[o]&&(t[o]*=1);return t}}function val(e){var t=this;if(void 0!==e){for(var r=0;r<t.length;r+=1){var a=t[r];if(Array.isArray(e)&&a.multiple&&"select"===a.nodeName.toLowerCase())for(var n=0;n<a.options.length;n+=1)a.options[n].selected=0<=e.indexOf(a.options[n].value);else a.value=e}return t}if(t[0]){if(t[0].multiple&&"select"===t[0].nodeName.toLowerCase()){for(var o=[],i=0;i<t[0].selectedOptions.length;i+=1)o.push(t[0].selectedOptions[i].value);return o}return t[0].value}}function transform(e){for(var t=0;t<this.length;t+=1){var r=this[t].style;r.webkitTransform=e,r.transform=e}return this}function transition(e){"string"!=typeof e&&(e+="ms");for(var t=0;t<this.length;t+=1){var r=this[t].style;r.webkitTransitionDuration=e,r.transitionDuration=e}return this}function on(){for(var e,t=[],r=arguments.length;r--;)t[r]=arguments[r];var a=t[0],o=t[1],i=t[2],n=t[3];function s(e){var t=e.target;if(t){var r=e.target.dom7EventData||[];if(r.indexOf(e)<0&&r.unshift(e),$(t).is(o))i.apply(t,r);else for(var a=$(t).parents(),n=0;n<a.length;n+=1)$(a[n]).is(o)&&i.apply(a[n],r)}}function l(e){var t=e&&e.target&&e.target.dom7EventData||[];t.indexOf(e)<0&&t.unshift(e),i.apply(this,t)}"function"==typeof t[1]&&(a=(e=t)[0],i=e[1],n=e[2],o=void 0),n||(n=!1);for(var c,u=a.split(" "),p=0;p<this.length;p+=1){var d=this[p];if(o)for(c=0;c<u.length;c+=1){var f=u[c];d.dom7LiveListeners||(d.dom7LiveListeners={}),d.dom7LiveListeners[f]||(d.dom7LiveListeners[f]=[]),d.dom7LiveListeners[f].push({listener:i,proxyListener:s}),d.addEventListener(f,s,n)}else for(c=0;c<u.length;c+=1){var h=u[c];d.dom7Listeners||(d.dom7Listeners={}),d.dom7Listeners[h]||(d.dom7Listeners[h]=[]),d.dom7Listeners[h].push({listener:i,proxyListener:l}),d.addEventListener(h,l,n)}}return this}function off(){for(var e,t=[],r=arguments.length;r--;)t[r]=arguments[r];var a=t[0],n=t[1],o=t[2],i=t[3];"function"==typeof t[1]&&(a=(e=t)[0],o=e[1],i=e[2],n=void 0),i||(i=!1);for(var s=a.split(" "),l=0;l<s.length;l+=1)for(var c=s[l],u=0;u<this.length;u+=1){var p=this[u],d=void 0;if(!n&&p.dom7Listeners?d=p.dom7Listeners[c]:n&&p.dom7LiveListeners&&(d=p.dom7LiveListeners[c]),d&&d.length)for(var f=d.length-1;0<=f;f-=1){var h=d[f];o&&h.listener===o?(p.removeEventListener(c,h.proxyListener,i),d.splice(f,1)):o||(p.removeEventListener(c,h.proxyListener,i),d.splice(f,1))}}return this}function once(){for(var e,t=[],r=arguments.length;r--;)t[r]=arguments[r];var a=this,n=t[0],o=t[1],i=t[2],s=t[3];return"function"==typeof t[1]&&(n=(e=t)[0],i=e[1],s=e[2],o=void 0),a.on(n,o,function e(){for(var t=[],r=arguments.length;r--;)t[r]=arguments[r];i.apply(this,t),a.off(n,o,e,s)},s)}function trigger(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];for(var r=e[0].split(" "),a=e[1],n=0;n<r.length;n+=1)for(var o=r[n],i=0;i<this.length;i+=1){var s=this[i],l=void 0;try{l=new win.CustomEvent(o,{detail:a,bubbles:!0,cancelable:!0})}catch(e){(l=doc.createEvent("Event")).initEvent(o,!0,!0),l.detail=a}s.dom7EventData=e.filter(function(e,t){return 0<t}),s.dispatchEvent(l),s.dom7EventData=[],delete s.dom7EventData}return this}function transitionEnd(t){var r,a=["webkitTransitionEnd","transitionend"],n=this;function o(e){if(e.target===this)for(t.call(this,e),r=0;r<a.length;r+=1)n.off(a[r],o)}if(t)for(r=0;r<a.length;r+=1)n.on(a[r],o);return this}function animationEnd(t){var r,a=["webkitAnimationEnd","animationend"],n=this;function o(e){if(e.target===this)for(t.call(this,e),r=0;r<a.length;r+=1)n.off(a[r],o)}if(t)for(r=0;r<a.length;r+=1)n.on(a[r],o);return this}function width(){return this[0]===win?win.innerWidth:0<this.length?parseFloat(this.css("width")):null}function outerWidth(e){if(0<this.length){if(e){var t=this.styles();return this[0].offsetWidth+parseFloat(t.getPropertyValue("margin-right"))+parseFloat(t.getPropertyValue("margin-left"))}return this[0].offsetWidth}return null}function height(){return this[0]===win?win.innerHeight:0<this.length?parseFloat(this.css("height")):null}function outerHeight(e){if(0<this.length){if(e){var t=this.styles();return this[0].offsetHeight+parseFloat(t.getPropertyValue("margin-top"))+parseFloat(t.getPropertyValue("margin-bottom"))}return this[0].offsetHeight}return null}function offset(){if(0<this.length){var e=this[0],t=e.getBoundingClientRect(),r=doc.body,a=e.clientTop||r.clientTop||0,n=e.clientLeft||r.clientLeft||0,o=e===win?win.scrollY:e.scrollTop,i=e===win?win.scrollX:e.scrollLeft;return{top:t.top+o-a,left:t.left+i-n}}return null}function hide(){for(var e=0;e<this.length;e+=1)this[e].style.display="none";return this}function show(){for(var e=0;e<this.length;e+=1){var t=this[e];"none"===t.style.display&&(t.style.display=""),"none"===win.getComputedStyle(t,null).getPropertyValue("display")&&(t.style.display="block")}return this}function styles(){return this[0]?win.getComputedStyle(this[0],null):{}}function css(e,t){var r;if(1===arguments.length){if("string"!=typeof e){for(r=0;r<this.length;r+=1)for(var a in e)this[r].style[a]=e[a];return this}if(this[0])return win.getComputedStyle(this[0],null).getPropertyValue(e)}if(2!==arguments.length||"string"!=typeof e)return this;for(r=0;r<this.length;r+=1)this[r].style[e]=t;return this}function toArray(){for(var e=[],t=0;t<this.length;t+=1)e.push(this[t]);return e}function each(e){if(!e)return this;for(var t=0;t<this.length;t+=1)if(!1===e.call(this[t],t,this[t]))return this;return this}function forEach(e){if(!e)return this;for(var t=0;t<this.length;t+=1)if(!1===e.call(this[t],this[t],t))return this;return this}function filter(e){for(var t=[],r=0;r<this.length;r+=1)e.call(this[r],r,this[r])&&t.push(this[r]);return new Dom7(t)}function map(e){for(var t=[],r=0;r<this.length;r+=1)t.push(e.call(this[r],r,this[r]));return new Dom7(t)}function html(e){if(void 0===e)return this[0]?this[0].innerHTML:void 0;for(var t=0;t<this.length;t+=1)this[t].innerHTML=e;return this}function text(e){if(void 0===e)return this[0]?this[0].textContent.trim():null;for(var t=0;t<this.length;t+=1)this[t].textContent=e;return this}function is(e){var t,r,a=this[0];if(!a||void 0===e)return!1;if("string"==typeof e){if(a.matches)return a.matches(e);if(a.webkitMatchesSelector)return a.webkitMatchesSelector(e);if(a.msMatchesSelector)return a.msMatchesSelector(e);for(t=$(e),r=0;r<t.length;r+=1)if(t[r]===a)return!0;return!1}if(e===doc)return a===doc;if(e===win)return a===win;if(e.nodeType||e instanceof Dom7){for(t=e.nodeType?[e]:e,r=0;r<t.length;r+=1)if(t[r]===a)return!0;return!1}return!1}function indexOf(e){for(var t=0;t<this.length;t+=1)if(this[t]===e)return t;return-1}function index(){var e,t=this[0];if(t){for(e=0;null!==(t=t.previousSibling);)1===t.nodeType&&(e+=1);return e}}function eq(e){if(void 0===e)return this;var t,r=this.length;return new Dom7(r-1<e?[]:e<0?(t=r+e)<0?[]:[this[t]]:[this[e]])}function append(){for(var e,t=[],r=arguments.length;r--;)t[r]=arguments[r];for(var a=0;a<t.length;a+=1){e=t[a];for(var n=0;n<this.length;n+=1)if("string"==typeof e){var o=doc.createElement("div");for(o.innerHTML=e;o.firstChild;)this[n].appendChild(o.firstChild)}else if(e instanceof Dom7)for(var i=0;i<e.length;i+=1)this[n].appendChild(e[i]);else this[n].appendChild(e)}return this}function appendTo(e){return $(e).append(this),this}function prepend(e){var t,r;for(t=0;t<this.length;t+=1)if("string"==typeof e){var a=doc.createElement("div");for(a.innerHTML=e,r=a.childNodes.length-1;0<=r;r-=1)this[t].insertBefore(a.childNodes[r],this[t].childNodes[0])}else if(e instanceof Dom7)for(r=0;r<e.length;r+=1)this[t].insertBefore(e[r],this[t].childNodes[0]);else this[t].insertBefore(e,this[t].childNodes[0]);return this}function prependTo(e){return $(e).prepend(this),this}function insertBefore(e){for(var t=$(e),r=0;r<this.length;r+=1)if(1===t.length)t[0].parentNode.insertBefore(this[r],t[0]);else if(1<t.length)for(var a=0;a<t.length;a+=1)t[a].parentNode.insertBefore(this[r].cloneNode(!0),t[a])}function insertAfter(e){for(var t=$(e),r=0;r<this.length;r+=1)if(1===t.length)t[0].parentNode.insertBefore(this[r],t[0].nextSibling);else if(1<t.length)for(var a=0;a<t.length;a+=1)t[a].parentNode.insertBefore(this[r].cloneNode(!0),t[a].nextSibling)}function next(e){return 0<this.length?e?this[0].nextElementSibling&&$(this[0].nextElementSibling).is(e)?new Dom7([this[0].nextElementSibling]):new Dom7([]):this[0].nextElementSibling?new Dom7([this[0].nextElementSibling]):new Dom7([]):new Dom7([])}function nextAll(e){var t=[],r=this[0];if(!r)return new Dom7([]);for(;r.nextElementSibling;){var a=r.nextElementSibling;e?$(a).is(e)&&t.push(a):t.push(a),r=a}return new Dom7(t)}function prev(e){if(0<this.length){var t=this[0];return e?t.previousElementSibling&&$(t.previousElementSibling).is(e)?new Dom7([t.previousElementSibling]):new Dom7([]):t.previousElementSibling?new Dom7([t.previousElementSibling]):new Dom7([])}return new Dom7([])}function prevAll(e){var t=[],r=this[0];if(!r)return new Dom7([]);for(;r.previousElementSibling;){var a=r.previousElementSibling;e?$(a).is(e)&&t.push(a):t.push(a),r=a}return new Dom7(t)}function siblings(e){return this.nextAll(e).add(this.prevAll(e))}function parent(e){for(var t=[],r=0;r<this.length;r+=1)null!==this[r].parentNode&&(e?$(this[r].parentNode).is(e)&&t.push(this[r].parentNode):t.push(this[r].parentNode));return $(unique(t))}function parents(e){for(var t=[],r=0;r<this.length;r+=1)for(var a=this[r].parentNode;a;)e?$(a).is(e)&&t.push(a):t.push(a),a=a.parentNode;return $(unique(t))}function closest(e){var t=this;return void 0===e?new Dom7([]):(t.is(e)||(t=t.parents(e).eq(0)),t)}function find(e){for(var t=[],r=0;r<this.length;r+=1)for(var a=this[r].querySelectorAll(e),n=0;n<a.length;n+=1)t.push(a[n]);return new Dom7(t)}function children(e){for(var t=[],r=0;r<this.length;r+=1)for(var a=this[r].childNodes,n=0;n<a.length;n+=1)e?1===a[n].nodeType&&$(a[n]).is(e)&&t.push(a[n]):1===a[n].nodeType&&t.push(a[n]);return new Dom7(unique(t))}function remove(){for(var e=0;e<this.length;e+=1)this[e].parentNode&&this[e].parentNode.removeChild(this[e]);return this}function detach(){return this.remove()}function add(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];var r,a;for(r=0;r<e.length;r+=1){var n=$(e[r]);for(a=0;a<n.length;a+=1)this[this.length]=n[a],this.length+=1}return this}function empty(){for(var e=0;e<this.length;e+=1){var t=this[e];if(1===t.nodeType){for(var r=0;r<t.childNodes.length;r+=1)t.childNodes[r].parentNode&&t.childNodes[r].parentNode.removeChild(t.childNodes[r]);t.textContent=""}}return this}$.fn=Dom7.prototype,$.Class=Dom7,$.Dom7=Dom7;var Methods=Object.freeze({addClass:addClass,removeClass:removeClass,hasClass:hasClass,toggleClass:toggleClass,attr:attr,removeAttr:removeAttr,prop:prop,data:data,removeData:removeData,dataset:dataset,val:val,transform:transform,transition:transition,on:on,off:off,once:once,trigger:trigger,transitionEnd:transitionEnd,animationEnd:animationEnd,width:width,outerWidth:outerWidth,height:height,outerHeight:outerHeight,offset:offset,hide:hide,show:show,styles:styles,css:css,toArray:toArray,each:each,forEach:forEach,filter:filter,map:map,html:html,text:text,is:is,indexOf:indexOf,index:index,eq:eq,append:append,appendTo:appendTo,prepend:prepend,prependTo:prependTo,insertBefore:insertBefore,insertAfter:insertAfter,next:next,nextAll:nextAll,prev:prev,prevAll:prevAll,siblings:siblings,parent:parent,parents:parents,closest:closest,find:find,children:children,remove:remove,detach:detach,add:add,empty:empty});function scrollTo(){for(var e,t=[],r=arguments.length;r--;)t[r]=arguments[r];var a=t[0],n=t[1],v=t[2],m=t[3],g=t[4];return 4===t.length&&"function"==typeof m&&(g=m,a=(e=t)[0],n=e[1],v=e[2],g=e[3],m=e[4]),void 0===m&&(m="swing"),this.each(function(){var o,i,e,t,s,l,c,u,p=this,d=0<n||0===n,f=0<a||0===a;if(void 0===m&&(m="swing"),d&&(o=p.scrollTop,v||(p.scrollTop=n)),f&&(i=p.scrollLeft,v||(p.scrollLeft=a)),v){d&&(e=p.scrollHeight-p.offsetHeight,s=Math.max(Math.min(n,e),0)),f&&(t=p.scrollWidth-p.offsetWidth,l=Math.max(Math.min(a,t),0));var h=null;d&&s===o&&(d=!1),f&&l===i&&(f=!1),requestAnimationFrame(function e(t){void 0===t&&(t=(new Date).getTime()),null===h&&(h=t);var r,a=Math.max(Math.min((t-h)/v,1),0),n="linear"===m?a:.5-Math.cos(a*Math.PI)/2;d&&(c=o+n*(s-o)),f&&(u=i+n*(l-i)),d&&o<s&&s<=c&&(p.scrollTop=s,r=!0),d&&s<o&&c<=s&&(p.scrollTop=s,r=!0),f&&i<l&&l<=u&&(p.scrollLeft=l,r=!0),f&&l<i&&u<=l&&(p.scrollLeft=l,r=!0),r?g&&g():(d&&(p.scrollTop=c),f&&(p.scrollLeft=u),requestAnimationFrame(e))})}})}function scrollTop(){for(var e,t=[],r=arguments.length;r--;)t[r]=arguments[r];var a=t[0],n=t[1],o=t[2],i=t[3];3===t.length&&"function"==typeof o&&(a=(e=t)[0],n=e[1],i=e[2],o=e[3]);return void 0===a?0<this.length?this[0].scrollTop:null:this.scrollTo(void 0,a,n,o,i)}function scrollLeft(){for(var e,t=[],r=arguments.length;r--;)t[r]=arguments[r];var a=t[0],n=t[1],o=t[2],i=t[3];3===t.length&&"function"==typeof o&&(a=(e=t)[0],n=e[1],i=e[2],o=e[3]);return void 0===a?0<this.length?this[0].scrollLeft:null:this.scrollTo(a,void 0,n,o,i)}var Scroll=Object.freeze({scrollTo:scrollTo,scrollTop:scrollTop,scrollLeft:scrollLeft});function animate(e,t){var r,a=this,g={props:Object.assign({},e),params:Object.assign({duration:300,easing:"swing"},t),elements:a,animating:!1,que:[],easingProgress:function(e,t){return"swing"===e?.5-Math.cos(t*Math.PI)/2:"function"==typeof e?e(t):t},stop:function(){g.frameId&&cancelAnimationFrame(g.frameId),g.animating=!1,g.elements.each(function(e,t){delete t.dom7AnimateInstance}),g.que=[]},done:function(e){if(g.animating=!1,g.elements.each(function(e,t){delete t.dom7AnimateInstance}),e&&e(a),0<g.que.length){var t=g.que.shift();g.animate(t[0],t[1])}},animate:function(c,u){if(g.animating)return g.que.push([c,u]),g;var p=[];g.elements.each(function(t,r){var a,n,o,i,s;r.dom7AnimateInstance||(g.elements[t].dom7AnimateInstance=g),p[t]={container:r},Object.keys(c).forEach(function(e){a=win.getComputedStyle(r,null).getPropertyValue(e).replace(",","."),n=parseFloat(a),o=a.replace(n,""),i=parseFloat(c[e]),s=c[e]+o,p[t][e]={initialFullValue:a,initialValue:n,unit:o,finalValue:i,finalFullValue:s,currentValue:n}})});var d,f,h=null,v=0,m=0,t=!1;return g.animating=!0,g.frameId=requestAnimationFrame(function e(){var s,l;d=(new Date).getTime(),t||(t=!0,u.begin&&u.begin(a)),null===h&&(h=d),u.progress&&u.progress(a,Math.max(Math.min((d-h)/u.duration,1),0),h+u.duration-d<0?0:h+u.duration-d,h),p.forEach(function(e){var i=e;f||i.done||Object.keys(c).forEach(function(e){if(!f&&!i.done){s=Math.max(Math.min((d-h)/u.duration,1),0),l=g.easingProgress(u.easing,s);var t=i[e],r=t.initialValue,a=t.finalValue,n=t.unit;i[e].currentValue=r+l*(a-r);var o=i[e].currentValue;(r<a&&a<=o||a<r&&o<=a)&&(i.container.style[e]=a+n,(m+=1)===Object.keys(c).length&&(i.done=!0,v+=1),v===p.length&&(f=!0)),f?g.done(u.complete):i.container.style[e]=o+n}})}),f||(g.frameId=requestAnimationFrame(e))}),g}};if(0===g.elements.length)return a;for(var n=0;n<g.elements.length;n+=1)g.elements[n].dom7AnimateInstance?r=g.elements[n].dom7AnimateInstance:g.elements[n].dom7AnimateInstance=g;return r||(r=g),"stop"===e?r.stop():r.animate(g.props,g.params),a}function stop(){for(var e=0;e<this.length;e+=1)this[e].dom7AnimateInstance&&this[e].dom7AnimateInstance.stop()}var Animate=Object.freeze({animate:animate,stop:stop}),noTrigger="resize scroll".split(" ");function eventShortcut(e){for(var t,r=[],a=arguments.length-1;0<a--;)r[a]=arguments[a+1];if(void 0!==r[0])return(t=this).on.apply(t,[e].concat(r));for(var n=0;n<this.length;n+=1)noTrigger.indexOf(e)<0&&(e in this[n]?this[n][e]():$(this[n]).trigger(e));return this}function click(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["click"].concat(e))}function blur(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["blur"].concat(e))}function focus(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["focus"].concat(e))}function focusin(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["focusin"].concat(e))}function focusout(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["focusout"].concat(e))}function keyup(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["keyup"].concat(e))}function keydown(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["keydown"].concat(e))}function keypress(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["keypress"].concat(e))}function submit(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["submit"].concat(e))}function change(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["change"].concat(e))}function mousedown(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["mousedown"].concat(e))}function mousemove(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["mousemove"].concat(e))}function mouseup(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["mouseup"].concat(e))}function mouseenter(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["mouseenter"].concat(e))}function mouseleave(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["mouseleave"].concat(e))}function mouseout(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["mouseout"].concat(e))}function mouseover(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["mouseover"].concat(e))}function touchstart(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["touchstart"].concat(e))}function touchend(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["touchend"].concat(e))}function touchmove(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["touchmove"].concat(e))}function resize(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["resize"].concat(e))}function scroll(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["scroll"].concat(e))}var eventShortcuts=Object.freeze({click:click,blur:blur,focus:focus,focusin:focusin,focusout:focusout,keyup:keyup,keydown:keydown,keypress:keypress,submit:submit,change:change,mousedown:mousedown,mousemove:mousemove,mouseup:mouseup,mouseenter:mouseenter,mouseleave:mouseleave,mouseout:mouseout,mouseover:mouseover,touchstart:touchstart,touchend:touchend,touchmove:touchmove,resize:resize,scroll:scroll});[Methods,Scroll,Animate,eventShortcuts].forEach(function(t){Object.keys(t).forEach(function(e){$.fn[e]=t[e]})});var NEWTON_ITERATIONS=4,NEWTON_MIN_SLOPE=.001,SUBDIVISION_PRECISION=1e-7,SUBDIVISION_MAX_ITERATIONS=10,kSplineTableSize=11,kSampleStepSize=1/(kSplineTableSize-1),float32ArraySupported="function"==typeof Float32Array;function A(e,t){return 1-3*t+3*e}function B(e,t){return 3*t-6*e}function C(e){return 3*e}function calcBezier(e,t,r){return((A(t,r)*e+B(t,r))*e+C(t))*e}function getSlope(e,t,r){return 3*A(t,r)*e*e+2*B(t,r)*e+C(t)}function binarySubdivide(e,t,r,a,n){for(var o,i,s=0;0<(o=calcBezier(i=t+(r-t)/2,a,n)-e)?r=i:t=i,Math.abs(o)>SUBDIVISION_PRECISION&&++s<SUBDIVISION_MAX_ITERATIONS;);return i}function newtonRaphsonIterate(e,t,r,a){for(var n=0;n<NEWTON_ITERATIONS;++n){var o=getSlope(t,r,a);if(0===o)return t;t-=(calcBezier(t,r,a)-e)/o}return t}function bezier(i,t,s,r){if(!(0<=i&&i<=1&&0<=s&&s<=1))throw new Error("bezier x values must be in [0, 1] range");var l=float32ArraySupported?new Float32Array(kSplineTableSize):new Array(kSplineTableSize);if(i!==t||s!==r)for(var e=0;e<kSplineTableSize;++e)l[e]=calcBezier(e*kSampleStepSize,i,s);return function(e){return i===t&&s===r?e:0===e?0:1===e?1:calcBezier(function(e){for(var t=0,r=1,a=kSplineTableSize-1;r!==a&&l[r]<=e;++r)t+=kSampleStepSize;var n=t+(e-l[--r])/(l[r+1]-l[r])*kSampleStepSize,o=getSlope(n,i,s);return NEWTON_MIN_SLOPE<=o?newtonRaphsonIterate(e,n,i,s):0===o?n:binarySubdivide(e,t,t+kSampleStepSize,i,s)}(e),t,r)}}for(var defaultDiacriticsRemovalap=[{base:"A",letters:"AⒶＡÀÁÂẦẤẪẨÃĀĂẰẮẴẲȦǠÄǞẢÅǺǍȀȂẠẬẶḀĄȺⱯ"},{base:"AA",letters:"Ꜳ"},{base:"AE",letters:"ÆǼǢ"},{base:"AO",letters:"Ꜵ"},{base:"AU",letters:"Ꜷ"},{base:"AV",letters:"ꜸꜺ"},{base:"AY",letters:"Ꜽ"},{base:"B",letters:"BⒷＢḂḄḆɃƂƁ"},{base:"C",letters:"CⒸＣĆĈĊČÇḈƇȻꜾ"},{base:"D",letters:"DⒹＤḊĎḌḐḒḎĐƋƊƉꝹ"},{base:"DZ",letters:"ǱǄ"},{base:"Dz",letters:"ǲǅ"},{base:"E",letters:"EⒺＥÈÉÊỀẾỄỂẼĒḔḖĔĖËẺĚȄȆẸỆȨḜĘḘḚƐƎ"},{base:"F",letters:"FⒻＦḞƑꝻ"},{base:"G",letters:"GⒼＧǴĜḠĞĠǦĢǤƓꞠꝽꝾ"},{base:"H",letters:"HⒽＨĤḢḦȞḤḨḪĦⱧⱵꞍ"},{base:"I",letters:"IⒾＩÌÍÎĨĪĬİÏḮỈǏȈȊỊĮḬƗ"},{base:"J",letters:"JⒿＪĴɈ"},{base:"K",letters:"KⓀＫḰǨḲĶḴƘⱩꝀꝂꝄꞢ"},{base:"L",letters:"LⓁＬĿĹĽḶḸĻḼḺŁȽⱢⱠꝈꝆꞀ"},{base:"LJ",letters:"Ǉ"},{base:"Lj",letters:"ǈ"},{base:"M",letters:"MⓂＭḾṀṂⱮƜ"},{base:"N",letters:"NⓃＮǸŃÑṄŇṆŅṊṈȠƝꞐꞤ"},{base:"NJ",letters:"Ǌ"},{base:"Nj",letters:"ǋ"},{base:"O",letters:"OⓄＯÒÓÔỒỐỖỔÕṌȬṎŌṐṒŎȮȰÖȪỎŐǑȌȎƠỜỚỠỞỢỌỘǪǬØǾƆƟꝊꝌ"},{base:"OI",letters:"Ƣ"},{base:"OO",letters:"Ꝏ"},{base:"OU",letters:"Ȣ"},{base:"OE",letters:"Œ"},{base:"oe",letters:"œ"},{base:"P",letters:"PⓅＰṔṖƤⱣꝐꝒꝔ"},{base:"Q",letters:"QⓆＱꝖꝘɊ"},{base:"R",letters:"RⓇＲŔṘŘȐȒṚṜŖṞɌⱤꝚꞦꞂ"},{base:"S",letters:"SⓈＳẞŚṤŜṠŠṦṢṨȘŞⱾꞨꞄ"},{base:"T",letters:"TⓉＴṪŤṬȚŢṰṮŦƬƮȾꞆ"},{base:"TZ",letters:"Ꜩ"},{base:"U",letters:"UⓊＵÙÚÛŨṸŪṺŬÜǛǗǕǙỦŮŰǓȔȖƯỪỨỮỬỰỤṲŲṶṴɄ"},{base:"V",letters:"VⓋＶṼṾƲꝞɅ"},{base:"VY",letters:"Ꝡ"},{base:"W",letters:"WⓌＷẀẂŴẆẄẈⱲ"},{base:"X",letters:"XⓍＸẊẌ"},{base:"Y",letters:"YⓎＹỲÝŶỸȲẎŸỶỴƳɎỾ"},{base:"Z",letters:"ZⓏＺŹẐŻŽẒẔƵȤⱿⱫꝢ"},{base:"a",letters:"aⓐａẚàáâầấẫẩãāăằắẵẳȧǡäǟảåǻǎȁȃạậặḁąⱥɐ"},{base:"aa",letters:"ꜳ"},{base:"ae",letters:"æǽǣ"},{base:"ao",letters:"ꜵ"},{base:"au",letters:"ꜷ"},{base:"av",letters:"ꜹꜻ"},{base:"ay",letters:"ꜽ"},{base:"b",letters:"bⓑｂḃḅḇƀƃɓ"},{base:"c",letters:"cⓒｃćĉċčçḉƈȼꜿↄ"},{base:"d",letters:"dⓓｄḋďḍḑḓḏđƌɖɗꝺ"},{base:"dz",letters:"ǳǆ"},{base:"e",letters:"eⓔｅèéêềếễểẽēḕḗĕėëẻěȅȇẹệȩḝęḙḛɇɛǝ"},{base:"f",letters:"fⓕｆḟƒꝼ"},{base:"g",letters:"gⓖｇǵĝḡğġǧģǥɠꞡᵹꝿ"},{base:"h",letters:"hⓗｈĥḣḧȟḥḩḫẖħⱨⱶɥ"},{base:"hv",letters:"ƕ"},{base:"i",letters:"iⓘｉìíîĩīĭïḯỉǐȉȋịįḭɨı"},{base:"j",letters:"jⓙｊĵǰɉ"},{base:"k",letters:"kⓚｋḱǩḳķḵƙⱪꝁꝃꝅꞣ"},{base:"l",letters:"lⓛｌŀĺľḷḹļḽḻſłƚɫⱡꝉꞁꝇ"},{base:"lj",letters:"ǉ"},{base:"m",letters:"mⓜｍḿṁṃɱɯ"},{base:"n",letters:"nⓝｎǹńñṅňṇņṋṉƞɲŉꞑꞥ"},{base:"nj",letters:"ǌ"},{base:"o",letters:"oⓞｏòóôồốỗổõṍȭṏōṑṓŏȯȱöȫỏőǒȍȏơờớỡởợọộǫǭøǿɔꝋꝍɵ"},{base:"oi",letters:"ƣ"},{base:"ou",letters:"ȣ"},{base:"oo",letters:"ꝏ"},{base:"p",letters:"pⓟｐṕṗƥᵽꝑꝓꝕ"},{base:"q",letters:"qⓠｑɋꝗꝙ"},{base:"r",letters:"rⓡｒŕṙřȑȓṛṝŗṟɍɽꝛꞧꞃ"},{base:"s",letters:"sⓢｓßśṥŝṡšṧṣṩșşȿꞩꞅẛ"},{base:"t",letters:"tⓣｔṫẗťṭțţṱṯŧƭʈⱦꞇ"},{base:"tz",letters:"ꜩ"},{base:"u",letters:"uⓤｕùúûũṹūṻŭüǜǘǖǚủůűǔȕȗưừứữửựụṳųṷṵʉ"},{base:"v",letters:"vⓥｖṽṿʋꝟʌ"},{base:"vy",letters:"ꝡ"},{base:"w",letters:"wⓦｗẁẃŵẇẅẘẉⱳ"},{base:"x",letters:"xⓧｘẋẍ"},{base:"y",letters:"yⓨｙỳýŷỹȳẏÿỷẙỵƴɏỿ"},{base:"z",letters:"zⓩｚźẑżžẓẕƶȥɀⱬꝣ"}],diacriticsMap={},i=0;i<defaultDiacriticsRemovalap.length;i+=1)for(var letters=defaultDiacriticsRemovalap[i].letters,j=0;j<letters.length;j+=1)diacriticsMap[letters[j]]=defaultDiacriticsRemovalap[i].base;var createPromise=function(e){var r,a,n=!1,o=!1,i={then:void 0,catch:void 0},t={then:function(e){return n?e.apply(void 0,r):i.then=e,t},catch:function(e){return o?e.apply(void 0,a):i.catch=e,t}};return e(function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];n=!0,i.then?i.then.apply(i,e):r=e},function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];o=!0,i.catch?i.catch.apply(i,e):a=e}),t},uniqueNumber=1,Utils={uniqueNumber:function(){return uniqueNumber+=1},id:function(e,t){void 0===e&&(e="xxxxxxxxxx"),void 0===t&&(t="0123456789abcdef");var r=t.length;return e.replace(/x/g,function(){return t[Math.floor(Math.random()*r)]})},mdPreloaderContent:'\n    <span class="preloader-inner">\n      <span class="preloader-inner-gap"></span>\n      <span class="preloader-inner-left">\n          <span class="preloader-inner-half-circle"></span>\n      </span>\n      <span class="preloader-inner-right">\n          <span class="preloader-inner-half-circle"></span>\n      </span>\n    </span>\n  '.trim(),eventNameToColonCase:function(e){var r;return e.split("").map(function(e,t){return e.match(/[A-Z]/)&&0!==t&&!r?(r=!0,":"+e.toLowerCase()):e.toLowerCase()}).join("")},deleteProps:function(e){var t=e;Object.keys(t).forEach(function(e){try{t[e]=null}catch(e){}try{delete t[e]}catch(e){}})},bezier:function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return bezier.apply(void 0,e)},nextTick:function(e,t){return void 0===t&&(t=0),setTimeout(e,t)},nextFrame:function(e){return Utils.requestAnimationFrame(function(){Utils.requestAnimationFrame(e)})},now:function(){return Date.now()},promise:function(e){return win.Promise?new Promise(e):createPromise(e)},requestAnimationFrame:function(e){return win.requestAnimationFrame?win.requestAnimationFrame(e):win.webkitRequestAnimationFrame?win.webkitRequestAnimationFrame(e):win.setTimeout(e,1e3/60)},cancelAnimationFrame:function(e){return win.cancelAnimationFrame?win.cancelAnimationFrame(e):win.webkitCancelAnimationFrame?win.webkitCancelAnimationFrame(e):win.clearTimeout(e)},removeDiacritics:function(e){return e.replace(/[^\u0000-\u007E]/g,function(e){return diacriticsMap[e]||e})},parseUrlQuery:function(e){var t,r,a,n,o={},i=e||win.location.href;if("string"==typeof i&&i.length)for(n=(r=(i=-1<i.indexOf("?")?i.replace(/\S*\?/,""):"").split("&").filter(function(e){return""!==e})).length,t=0;t<n;t+=1)a=r[t].replace(/#\S+/g,"").split("="),o[decodeURIComponent(a[0])]=void 0===a[1]?void 0:decodeURIComponent(a.slice(1).join("="))||"";return o},getTranslate:function(e,t){var r,a,n;void 0===t&&(t="x");var o=win.getComputedStyle(e,null);return win.WebKitCSSMatrix?(6<(a=o.transform||o.webkitTransform).split(",").length&&(a=a.split(", ").map(function(e){return e.replace(",",".")}).join(", ")),n=new win.WebKitCSSMatrix("none"===a?"":a)):r=(n=o.MozTransform||o.OTransform||o.MsTransform||o.msTransform||o.transform||o.getPropertyValue("transform").replace("translate(","matrix(1, 0, 0, 1,")).toString().split(","),"x"===t&&(a=win.WebKitCSSMatrix?n.m41:16===r.length?parseFloat(r[12]):parseFloat(r[4])),"y"===t&&(a=win.WebKitCSSMatrix?n.m42:16===r.length?parseFloat(r[13]):parseFloat(r[5])),a||0},serializeObject:function(a,n){if(void 0===n&&(n=[]),"string"==typeof a)return a;var o,i=[];function s(e){if(0<n.length){for(var t="",r=0;r<n.length;r+=1)t+=0===r?n[r]:"["+encodeURIComponent(n[r])+"]";return t+"["+encodeURIComponent(e)+"]"}return encodeURIComponent(e)}function l(e){return encodeURIComponent(e)}return Object.keys(a).forEach(function(e){var t;if(Array.isArray(a[e])){t=[];for(var r=0;r<a[e].length;r+=1)Array.isArray(a[e][r])||"object"!=typeof a[e][r]?t.push(s(e)+"[]="+l(a[e][r])):((o=n.slice()).push(e),o.push(String(r)),t.push(Utils.serializeObject(a[e][r],o)));0<t.length&&i.push(t.join("&"))}else null===a[e]||""===a[e]?i.push(s(e)+"="):"object"==typeof a[e]?((o=n.slice()).push(e),""!==(t=Utils.serializeObject(a[e],o))&&i.push(t)):void 0!==a[e]&&""!==a[e]?i.push(s(e)+"="+l(a[e])):""===a[e]&&i.push(s(e))}),i.join("&")},isObject:function(e){return"object"==typeof e&&null!==e&&e.constructor&&e.constructor===Object},merge:function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];var r=e[0];e.splice(0,1);for(var a=e,n=0;n<a.length;n+=1){var o=e[n];if(null!=o)for(var i=Object.keys(Object(o)),s=0,l=i.length;s<l;s+=1){var c=i[s],u=Object.getOwnPropertyDescriptor(o,c);void 0!==u&&u.enumerable&&(r[c]=o[c])}}return r},extend:function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];var r,a,n=!0;a=("boolean"==typeof e[0]?(n=e[0],r=e[1],e.splice(0,2)):(r=e[0],e.splice(0,1)),e);for(var o=0;o<a.length;o+=1){var i=e[o];if(null!=i)for(var s=Object.keys(Object(i)),l=0,c=s.length;l<c;l+=1){var u=s[l],p=Object.getOwnPropertyDescriptor(i,u);void 0!==p&&p.enumerable&&(n?Utils.isObject(r[u])&&Utils.isObject(i[u])?Utils.extend(r[u],i[u]):!Utils.isObject(r[u])&&Utils.isObject(i[u])?(r[u]={},Utils.extend(r[u],i[u])):r[u]=i[u]:r[u]=i[u])}}return r}},Device=function(){var e=win.navigator.platform,t=win.navigator.userAgent,r={ios:!1,android:!1,androidChrome:!1,desktop:!1,windowsPhone:!1,iphone:!1,iphoneX:!1,ipod:!1,ipad:!1,edge:!1,ie:!1,firefox:!1,macos:!1,windows:!1,cordova:!(!win.cordova&&!win.phonegap),phonegap:!(!win.cordova&&!win.phonegap)},a=win.screen.width,n=win.screen.height,o=t.match(/(Windows Phone);?[\s\/]+([\d.]+)?/),i=t.match(/(Android);?[\s\/]+([\d.]+)?/),s=t.match(/(iPad).*OS\s([\d_]+)/),l=t.match(/(iPod)(.*OS\s([\d_]+))?/),c=!s&&t.match(/(iPhone\sOS|iOS)\s([\d_]+)/),u=c&&(375===a&&812===n||414===a&&896===n),p=0<=t.indexOf("MSIE ")||0<=t.indexOf("Trident/"),d=0<=t.indexOf("Edge/"),f=0<=t.indexOf("Gecko/")&&0<=t.indexOf("Firefox/"),h="MacIntel"===e,v="Win32"===e;if(r.ie=p,r.edge=d,r.firefox=f,o&&(r.os="windows",r.osVersion=o[2],r.windowsPhone=!0),i&&!v&&(r.os="android",r.osVersion=i[2],r.android=!0,r.androidChrome=0<=t.toLowerCase().indexOf("chrome")),(s||c||l)&&(r.os="ios",r.ios=!0),c&&!l&&(r.osVersion=c[2].replace(/_/g,"."),r.iphone=!0,r.iphoneX=u),s&&(r.osVersion=s[2].replace(/_/g,"."),r.ipad=!0),l&&(r.osVersion=l[3]?l[3].replace(/_/g,"."):null,r.iphone=!0),r.ios&&r.osVersion&&0<=t.indexOf("Version/")&&"10"===r.osVersion.split(".")[0]&&(r.osVersion=t.toLowerCase().split("version/")[1].split(" ")[0]),r.webView=!(!(c||s||l)||!t.match(/.*AppleWebKit(?!.*Safari)/i)&&!win.navigator.standalone)||win.matchMedia&&win.matchMedia("(display-mode: standalone)").matches,r.webview=r.webView,r.standalone=r.webView,r.desktop=!(r.os||r.android||r.webView),r.desktop&&(r.macos=h,r.windows=v),r.os&&"ios"===r.os){var m=r.osVersion.split("."),g=doc.querySelector('meta[name="viewport"]');r.minimalUi=!r.webView&&(l||c)&&(1*m[0]==7?1<=1*m[1]:7<1*m[0])&&g&&0<=g.getAttribute("content").indexOf("minimal-ui")}return r.needsStatusbarOverlay=function(){return!(!(r.webView||r.android&&r.cordova)||win.innerWidth*win.innerHeight!=win.screen.width*win.screen.height)&&(!r.iphoneX||90!==win.orientation&&-90!==win.orientation)},r.statusbar=r.needsStatusbarOverlay(),r.pixelRatio=win.devicePixelRatio||1,r}(),Framework7Class=function(e,t){void 0===e&&(e={}),void 0===t&&(t=[]);var r=this;r.params=e,r.eventsParents=t,r.eventsListeners={},r.params&&r.params.on&&Object.keys(r.params.on).forEach(function(e){r.on(e,r.params.on[e])})},staticAccessors$1={components:{configurable:!0}};function ConstructorMethods(e){void 0===e&&(e={});var o=e.defaultSelector,r=e.constructor,a=e.domProp,n=e.app,t=e.addMethods,i={create:function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return n?new(Function.prototype.bind.apply(r,[null].concat([n],e))):new(Function.prototype.bind.apply(r,[null].concat(e)))},get:function(e){if(void 0===e&&(e=o),e instanceof r)return e;var t=$(e);return 0!==t.length?t[0][a]:void 0},destroy:function(e){var t=i.get(e);if(t&&t.destroy)return t.destroy()}};return t&&Array.isArray(t)&&t.forEach(function(n){i[n]=function(e){void 0===e&&(e=o);for(var t=[],r=arguments.length-1;0<r--;)t[r]=arguments[r+1];var a=i.get(e);if(a&&a[n])return a[n].apply(a,t)}}),i}function ModalMethods(e){void 0===e&&(e={});var n=e.defaultSelector,o=e.constructor,i=e.app;return Utils.extend(ConstructorMethods({defaultSelector:n,constructor:o,app:i,domProp:"f7Modal"}),{open:function(e,t){var r=$(e),a=r[0].f7Modal;return a||(a=new o(i,{el:r})),a.open(t)},close:function(e,t){void 0===e&&(e=n);var r=$(e);if(0!==r.length){var a=r[0].f7Modal;return a||(a=new o(i,{el:r})),a.close(t)}}})}Framework7Class.prototype.on=function(e,t,r){var a=this;if("function"!=typeof t)return a;var n=r?"unshift":"push";return e.split(" ").forEach(function(e){a.eventsListeners[e]||(a.eventsListeners[e]=[]),a.eventsListeners[e][n](t)}),a},Framework7Class.prototype.once=function(a,n,e){var o=this;if("function"!=typeof n)return o;return o.on(a,function e(){for(var t=[],r=arguments.length;r--;)t[r]=arguments[r];n.apply(o,t),o.off(a,e)},e)},Framework7Class.prototype.off=function(e,a){var n=this;return n.eventsListeners&&e.split(" ").forEach(function(r){void 0===a?n.eventsListeners[r]=[]:n.eventsListeners[r]&&n.eventsListeners[r].forEach(function(e,t){e===a&&n.eventsListeners[r].splice(t,1)})}),n},Framework7Class.prototype.emit=function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];var r,a,n,o,i=this;if(!i.eventsListeners)return i;o="string"==typeof e[0]||Array.isArray(e[0])?(r=e[0],a=e.slice(1,e.length),(n=i).eventsParents):(r=e[0].events,a=e[0].data,n=e[0].context||i,e[0].local?[]:e[0].parents||i.eventsParents);var s=Array.isArray(r)?r:r.split(" "),l=s.map(function(e){return e.replace("local::","")}),c=s.filter(function(e){return e.indexOf("local::")<0});return l.forEach(function(e){if(i.eventsListeners&&i.eventsListeners[e]){var t=[];i.eventsListeners[e].forEach(function(e){t.push(e)}),t.forEach(function(e){e.apply(n,a)})}}),o&&0<o.length&&o.forEach(function(e){e.emit.apply(e,[c].concat(a))}),i},Framework7Class.prototype.useModuleParams=function(e,t){if(e.params){var r={};Object.keys(e.params).forEach(function(e){void 0!==t[e]&&(r[e]=Utils.extend({},t[e]))}),Utils.extend(t,e.params),Object.keys(r).forEach(function(e){Utils.extend(t[e],r[e])})}},Framework7Class.prototype.useModulesParams=function(r){var a=this;a.modules&&Object.keys(a.modules).forEach(function(e){var t=a.modules[e];t.params&&Utils.extend(r,t.params)})},Framework7Class.prototype.useModule=function(e,t){void 0===e&&(e=""),void 0===t&&(t={});var a=this;if(a.modules){var n="string"==typeof e?a.modules[e]:e;n&&(n.instance&&Object.keys(n.instance).forEach(function(e){var t=n.instance[e];a[e]="function"==typeof t?t.bind(a):t}),n.on&&a.on&&Object.keys(n.on).forEach(function(e){a.on(e,n.on[e])}),n.vnode&&(a.vnodeHooks||(a.vnodeHooks={}),Object.keys(n.vnode).forEach(function(r){Object.keys(n.vnode[r]).forEach(function(e){var t=n.vnode[r][e];a.vnodeHooks[e]||(a.vnodeHooks[e]={}),a.vnodeHooks[e][r]||(a.vnodeHooks[e][r]=[]),a.vnodeHooks[e][r].push(t.bind(a))})})),n.create&&n.create.bind(a)(t))}},Framework7Class.prototype.useModules=function(r){void 0===r&&(r={});var a=this;a.modules&&Object.keys(a.modules).forEach(function(e){var t=r[e]||{};a.useModule(e,t)})},staticAccessors$1.components.set=function(e){this.use&&this.use(e)},Framework7Class.installModule=function(t){for(var e=[],r=arguments.length-1;0<r--;)e[r]=arguments[r+1];var a=this;a.prototype.modules||(a.prototype.modules={});var n=t.name||Object.keys(a.prototype.modules).length+"_"+Utils.now();return(a.prototype.modules[n]=t).proto&&Object.keys(t.proto).forEach(function(e){a.prototype[e]=t.proto[e]}),t.static&&Object.keys(t.static).forEach(function(e){a[e]=t.static[e]}),t.install&&t.install.apply(a,e),a},Framework7Class.use=function(e){for(var t=[],r=arguments.length-1;0<r--;)t[r]=arguments[r+1];var a=this;return Array.isArray(e)?(e.forEach(function(e){return a.installModule(e)}),a):a.installModule.apply(a,[e].concat(t))},Object.defineProperties(Framework7Class,staticAccessors$1);var fetchedModules=[];function loadModule(d){var f=this;return new Promise(function(e,t){var s,r,a,n=f.instance;if(d){if("string"==typeof d){var o=d.match(/([a-z0-9-]*)/i);if(d.indexOf(".")<0&&o&&o[0].length===d.length){if(!n||n&&!n.params.lazyModulesPath)return void t(new Error('Framework7: "lazyModulesPath" app parameter must be specified to fetch module by name'));s=n.params.lazyModulesPath+"/"+d+".js"}else s=d}else"function"==typeof d?a=d:r=d;if(a){var i=a(f,!1);if(!i)return void t(new Error("Framework7: Can't find Framework7 component in specified component function"));if(f.prototype.modules&&f.prototype.modules[i.name])return void e();p(i),e()}if(r){var l=r;if(!l)return void t(new Error("Framework7: Can't find Framework7 component in specified component"));if(f.prototype.modules&&f.prototype.modules[l.name])return void e();p(l),e()}if(s){if(0<=fetchedModules.indexOf(s))return void e();fetchedModules.push(s);var c=new Promise(function(o,i){f.request.get(s,function(e){var t="f7_component_loader_callback_"+Utils.id(),r=document.createElement("script");r.innerHTML="window."+t+" = function (Framework7, Framework7AutoInstallComponent) {return "+e.trim()+"}",$("head").append(r);var a=window[t];delete window[t],$(r).remove();var n=a(f,!1);n?(f.prototype.modules&&f.prototype.modules[n.name]||p(n),o()):i(new Error("Framework7: Can't find Framework7 component in "+s+" file"))},function(e,t){i(e,t)})}),u=new Promise(function(r){f.request.get(s.replace(".js",n.rtl?".rtl.css":".css"),function(e){var t=document.createElement("style");t.innerHTML=e,$("head").append(t),r()},function(){r()})});Promise.all([c,u]).then(function(){e()}).catch(function(e){t(e)})}}else t(new Error("Framework7: Lazy module must be specified"));function p(e){f.use(e),n&&(n.useModuleParams(e,n.params),n.useModule(e))}})}var Framework7=function(o){function i(e){o.call(this,e);var t=Utils.extend({},e),r=this;i.instance=r;var a={version:"1.0.0",id:"io.framework7.testapp",root:"body",theme:"auto",language:win.navigator.language,routes:[],name:"Framework7",lazyModulesPath:null,initOnDeviceReady:!0,init:!0};r.useModulesParams(a),r.params=Utils.extend(a,e);var n=$(r.params.root);return Utils.extend(r,{id:r.params.id,name:r.params.name,version:r.params.version,routes:r.params.routes,language:r.params.language,root:n,rtl:"rtl"===n.css("direction"),theme:"auto"===r.params.theme?Device.ios?"ios":"md":r.params.theme,passedParams:t}),r.root&&r.root[0]&&(r.root[0].f7=r),r.useModules(),r.params.init&&(Device.cordova&&r.params.initOnDeviceReady?$(doc).on("deviceready",function(){r.init()}):r.init()),r}o&&(i.__proto__=o);var e={$:{configurable:!0},t7:{configurable:!0}},t={Dom7:{configurable:!0},$:{configurable:!0},Template7:{configurable:!0},Class:{configurable:!0}};return((i.prototype=Object.create(o&&o.prototype)).constructor=i).prototype.init=function(){var t=this;return t.initialized||(t.root.addClass("framework7-initializing"),t.rtl&&$("html").attr("dir","rtl"),t.root.addClass("framework7-root"),$("html").removeClass("ios md").addClass(t.theme),t.data={},t.params.data&&"function"==typeof t.params.data?Utils.extend(t.data,t.params.data.bind(t)()):t.params.data&&Utils.extend(t.data,t.params.data),t.methods={},t.params.methods&&Object.keys(t.params.methods).forEach(function(e){"function"==typeof t.params.methods[e]?t.methods[e]=t.params.methods[e].bind(t):t.methods[e]=t.params.methods[e]}),Utils.nextFrame(function(){t.root.removeClass("framework7-initializing")}),t.initialized=!0,t.emit("init")),t},i.prototype.loadModule=function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return i.loadModule.apply(i,e)},i.prototype.loadModules=function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return i.loadModules.apply(i,e)},i.prototype.getVnodeHooks=function(e,t){return this.vnodeHooks&&this.vnodeHooks[e]&&this.vnodeHooks[e][t]||[]},e.$.get=function(){return $},e.t7.get=function(){return Template7},t.Dom7.get=function(){return $},t.$.get=function(){return $},t.Template7.get=function(){return Template7},t.Class.get=function(){return o},Object.defineProperties(i.prototype,e),Object.defineProperties(i,t),i}(Framework7Class);Framework7.ModalMethods=ModalMethods,Framework7.ConstructorMethods=ConstructorMethods,Framework7.loadModule=loadModule,Framework7.loadModules=function(e){return Promise.all(e.map(function(e){return Framework7.loadModule(e)}))};var DeviceModule={name:"device",proto:{device:Device},static:{device:Device},on:{init:function(){var e=[],t=doc.querySelector("html");if(t){if(e.push("device-pixel-ratio-"+Math.floor(Device.pixelRatio)),2<=Device.pixelRatio&&e.push("device-retina"),Device.os){if(e.push("device-"+Device.os,"device-"+Device.os+"-"+Device.osVersion.split(".")[0],"device-"+Device.os+"-"+Device.osVersion.replace(/\./g,"-")),"ios"===Device.os){for(var r=parseInt(Device.osVersion.split(".")[0],10)-1;6<=r;r-=1)e.push("device-ios-gt-"+r);Device.iphoneX&&e.push("device-iphone-x")}}else Device.desktop&&(e.push("device-desktop"),Device.macos?e.push("device-macos"):Device.windows&&e.push("device-windows"));(Device.cordova||Device.phonegap)&&e.push("device-cordova"),e.forEach(function(e){t.classList.add(e)})}}}},Support=(pq=!1,qq=doc.createElement("div"),"sticky -webkit-sticky -moz-sticky".split(" ").forEach(function(e){pq||(qq.style.position=e,qq.style.position===e&&(pq=!0))}),mq=pq,nq=doc.createElement("div"),{positionSticky:mq,touch:!!(0<win.navigator.maxTouchPoints||"ontouchstart"in win||win.DocumentTouch&&doc instanceof win.DocumentTouch),pointerEvents:!!(win.navigator.pointerEnabled||win.PointerEvent||"maxTouchPoints"in win.navigator),prefixedPointerEvents:!!win.navigator.msPointerEnabled,transition:(uq=nq.style,"transition"in uq||"webkitTransition"in uq||"MozTransition"in uq),transforms3d:win.Modernizr&&!0===win.Modernizr.csstransforms3d||(wq=nq.style,"webkitPerspective"in wq||"MozPerspective"in wq||"OPerspective"in wq||"MsPerspective"in wq||"perspective"in wq),flexbox:function(){for(var e=doc.createElement("div").style,t="alignItems webkitAlignItems webkitBoxAlign msFlexAlign mozBoxAlign webkitFlexDirection msFlexDirection mozBoxDirection mozBoxOrient webkitBoxDirection webkitBoxOrient".split(" "),r=0;r<t.length;r+=1)if(t[r]in e)return!0;return!1}(),observer:"MutationObserver"in win||"WebkitMutationObserver"in win,passiveListener:function(){var e=!1;try{var t=Object.defineProperty({},"passive",{get:function(){e=!0}});win.addEventListener("testPassiveListener",null,t)}catch(e){}return e}(),gestures:"ongesturestart"in win}),pq,qq,wq,uq,mq,nq,SupportModule={name:"support",proto:{support:Support},static:{support:Support},on:{init:function(){var t=doc.querySelector("html");if(t){var e=[];Support.positionSticky&&e.push("support-position-sticky"),e.forEach(function(e){t.classList.add(e)})}}}},UtilsModule={name:"utils",proto:{utils:Utils},static:{utils:Utils}},ResizeModule={name:"resize",instance:{getSize:function(){var e=this;if(!e.root[0])return{width:0,height:0,left:0,top:0};var t=e.root.offset(),r=[e.root[0].offsetWidth,e.root[0].offsetHeight,t.left,t.top],a=r[0],n=r[1],o=r[2],i=r[3];return{width:e.width=a,height:e.height=n,left:e.left=o,top:e.top=i}}},on:{init:function(){var e=this;e.getSize(),win.addEventListener("resize",function(){e.emit("resize")},!1),win.addEventListener("orientationchange",function(){e.emit("orientationchange")})},orientationchange:function(){this.device&&this.device.minimalUi&&(90!==win.orientation&&-90!==win.orientation||(doc.body.scrollTop=0)),this.device.ipad&&(doc.body.scrollLeft=0,setTimeout(function(){doc.body.scrollLeft=0},0))},resize:function(){this.getSize()}}},globals={},jsonpRequests=0;function Request(e){var t=Utils.extend({},globals);"beforeCreate beforeOpen beforeSend error complete success statusCode".split(" ").forEach(function(e){delete t[e]});var r=Utils.extend({url:win.location.toString(),method:"GET",data:!1,async:!0,cache:!0,user:"",password:"",headers:{},xhrFields:{},statusCode:{},processData:!0,dataType:"text",contentType:"application/x-www-form-urlencoded",timeout:0},t),o=Utils.extend({},r,e);function a(e){for(var t,r,a=[],n=arguments.length-1;0<n--;)a[n]=arguments[n+1];return globals[e]&&(t=globals[e].apply(globals,a)),o[e]&&(r=o[e].apply(o,a)),"boolean"!=typeof t&&(t=!0),"boolean"!=typeof r&&(r=!0),t&&r}if(!1!==a("beforeCreate",o)){o.type&&(o.method=o.type);var n,i=0<=o.url.indexOf("?")?"&":"?",s=o.method.toUpperCase();if(("GET"===s||"HEAD"===s||"OPTIONS"===s||"DELETE"===s)&&o.data)(n="string"==typeof o.data?0<=o.data.indexOf("?")?o.data.split("?")[1]:o.data:Utils.serializeObject(o.data)).length&&(o.url+=i+n,"?"===i&&(i="&"));if("json"===o.dataType&&0<=o.url.indexOf("callback=")){var l,c="f7jsonp_"+(Date.now()+(jsonpRequests+=1)),u=o.url.split("callback="),p=u[0]+"callback="+c;if(0<=u[1].indexOf("&")){var d=u[1].split("&").filter(function(e){return 0<e.indexOf("=")}).join("&");0<d.length&&(p+="&"+d)}var f=doc.createElement("script");return f.type="text/javascript",f.onerror=function(){clearTimeout(l),a("error",null,"scripterror"),a("complete",null,"scripterror")},f.src=p,win[c]=function(e){clearTimeout(l),a("success",e),f.parentNode.removeChild(f),f=null,delete win[c]},doc.querySelector("head").appendChild(f),void(0<o.timeout&&(l=setTimeout(function(){f.parentNode.removeChild(f),a("error",f=null,"timeout")},o.timeout)))}"GET"!==s&&"HEAD"!==s&&"OPTIONS"!==s&&"DELETE"!==s||!1===o.cache&&(o.url+=i+"_nocache"+Date.now());var h=new XMLHttpRequest;if(h.requestUrl=o.url,h.requestParameters=o,!1===a("beforeOpen",h,o))return h;h.open(s,o.url,o.async,o.user,o.password);var v,m=null;if(("POST"===s||"PUT"===s||"PATCH"===s)&&o.data)if(o.processData)if(0<=[ArrayBuffer,Blob,Document,FormData].indexOf(o.data.constructor))m=o.data;else{var g="---------------------------"+Date.now().toString(16);"multipart/form-data"===o.contentType?h.setRequestHeader("Content-Type","multipart/form-data; boundary="+g):h.setRequestHeader("Content-Type",o.contentType),m="";var b=Utils.serializeObject(o.data);if("multipart/form-data"===o.contentType){b=b.split("&");for(var y=[],w=0;w<b.length;w+=1)y.push('Content-Disposition: form-data; name="'+b[w].split("=")[0]+'"\r\n\r\n'+b[w].split("=")[1]+"\r\n");m="--"+g+"\r\n"+y.join("--"+g+"\r\n")+"--"+g+"--\r\n"}else m="application/json"===o.contentType?JSON.stringify(o.data):b}else m=o.data,h.setRequestHeader("Content-Type",o.contentType);return o.headers&&Object.keys(o.headers).forEach(function(e){h.setRequestHeader(e,o.headers[e])}),void 0===o.crossDomain&&(o.crossDomain=/^([\w-]+:)?\/\/([^\/]+)/.test(o.url)&&RegExp.$2!==win.location.host),o.crossDomain||h.setRequestHeader("X-Requested-With","XMLHttpRequest"),o.xhrFields&&Utils.extend(h,o.xhrFields),h.onload=function(){var e;if(v&&clearTimeout(v),200<=h.status&&h.status<300||0===h.status)if("json"===o.dataType){var t;try{e=JSON.parse(h.responseText)}catch(e){t=!0}t?a("error",h,"parseerror"):a("success",e,h.status,h)}else a("success",e="text"===h.responseType||""===h.responseType?h.responseText:h.response,h.status,h);else a("error",h,h.status);o.statusCode&&(globals.statusCode&&globals.statusCode[h.status]&&globals.statusCode[h.status](h),o.statusCode[h.status]&&o.statusCode[h.status](h)),a("complete",h,h.status)},h.onerror=function(){v&&clearTimeout(v),a("error",h,h.status),a("complete",h,"error")},0<o.timeout&&(h.onabort=function(){v&&clearTimeout(v)},v=setTimeout(function(){h.abort(),a("error",h,"timeout"),a("complete",h,"timeout")},o.timeout)),!1===a("beforeSend",h,o)?h:(h.send(m),h)}}function RequestShortcut(e){for(var t,r,a=[],n=arguments.length-1;0<n--;)a[n]=arguments[n+1];var o=[],i=o[0],s=o[1],l=o[2],c=o[3],u=o[4];u="function"==typeof a[1]?(i=(t=a)[0],l=t[1],c=t[2],t[3]):(i=(r=a)[0],s=r[1],l=r[2],c=r[3],r[4]),[l,c].forEach(function(e){"string"==typeof e&&((u=e)===l?l=void 0:c=void 0)});var p={url:i,method:"post"===e||"postJSON"===e?"POST":"GET",data:s,success:l,error:c,dataType:u=u||("json"===e||"postJSON"===e?"json":void 0)};return"postJSON"===e&&Utils.extend(p,{contentType:"application/json",processData:!1,crossDomain:!0,data:"string"==typeof s?s:JSON.stringify(s)}),Request(p)}Request.get=function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return RequestShortcut.apply(void 0,["get"].concat(e))},Request.post=function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return RequestShortcut.apply(void 0,["post"].concat(e))},Request.json=function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return RequestShortcut.apply(void 0,["json"].concat(e))},Request.getJSON=Request.json,Request.postJSON=function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return RequestShortcut.apply(void 0,["postJSON"].concat(e))},Request.setup=function(e){e.type&&!e.method&&Utils.extend(e,{method:e.type}),Utils.extend(globals,e)};var RequestModule={name:"request",proto:{request:Request},static:{request:Request}};function initTouch(){var s,l,c,u,p,d,f,h,v,m,g,b,y,w,C,a,t,r,i=this,x=i.params.touch,k="md"===i.theme&&x.materialRipple;function E(e){var t,r=$(e),a=r.parents(x.activeStateElements);return r.is(x.activeStateElements)&&(t=r),0<a.length&&(t=t?t.add(a):a),t||r}function S(e){var t=e.parents(".page-content, .panel");return 0!==t.length&&("yes"!==t.prop("scrollHandlerSet")&&(t.on("scroll",function(){clearTimeout(y),clearTimeout(r)}),t.prop("scrollHandlerSet","yes")),!0)}function T(){b&&b.addClass("active-state")}function O(){b&&(b.removeClass("active-state"),b=null)}function n(e,t,r){e&&(a=i.touchRipple.create(e,t,r))}function e(){a&&(a.remove(),t=a=void 0)}function P(e){(t=function(e){var t=x.materialRippleElements,r=$(e);if(r.is(t))return!r.hasClass("no-ripple")&&r;if(0<r.parents(t).length){var a=r.parents(t).eq(0);return!a.hasClass("no-ripple")&&a}return!1}(e))&&0!==t.length?S(t)?r=setTimeout(function(){n(t,s,l)},80):n(t,s,l):t=void 0}function o(){clearTimeout(r),e()}function R(){a?e():t&&!v?(clearTimeout(r),n(t,s,l),setTimeout(e,0)):e()}function D(e,t){i.emit({events:e,data:[t]})}function N(e){D("touchstart touchstart:active",e)}function A(e){D("touchmove touchmove:active",e)}function L(e){D("touchend touchend:active",e)}function U(e){D("touchstart:passive",e)}function M(e){D("touchmove:passive",e)}function B(e){D("touchend:passive",e)}Device.ios&&Device.webView&&win.addEventListener("touchstart",function(){});var H=!!Support.passiveListener&&{passive:!0},q=!!Support.passiveListener&&{passive:!1};doc.addEventListener("click",function(e){D("click",e)},!0),Support.passiveListener?(doc.addEventListener(i.touchEvents.start,N,q),doc.addEventListener(i.touchEvents.move,A,q),doc.addEventListener(i.touchEvents.end,L,q),doc.addEventListener(i.touchEvents.start,U,H),doc.addEventListener(i.touchEvents.move,M,H),doc.addEventListener(i.touchEvents.end,B,H)):(doc.addEventListener(i.touchEvents.start,function(e){N(e),U(e)},!1),doc.addEventListener(i.touchEvents.move,function(e){A(e),M(e)},!1),doc.addEventListener(i.touchEvents.end,function(e){L(e),B(e)},!1)),Support.touch?(i.on("click",function(e){var t,r,a,n,o=!1;return p?(u=null,!(p=!1)):"submit"===e.target.type&&0===e.detail||"file"===e.target.type||(u||(t=e.target,r="input select textarea label".split(" "),t.nodeName&&0<=r.indexOf(t.nodeName.toLowerCase())||(o=!0)),w||(o=!0),doc.activeElement===u&&(o=!0),e.forwardedTouchEvent&&(o=!0),e.cancelable||(o=!0),x.tapHold&&x.tapHoldPreventClicks&&m&&(o=!1),o||(e.stopImmediatePropagation(),e.stopPropagation(),u?(a=$(u),n=!0,(a.is("label")||0<a.parents("label").length)&&(n=!Device.android&&!(!Device.ios||!a.is("input"))),(n||v)&&e.preventDefault()):e.preventDefault(),u=null),C=setTimeout(function(){w=!1},Device.ios||Device.androidChrome?100:400),x.tapHold&&(g=setTimeout(function(){m=!1},Device.ios||Device.androidChrome?100:400)),o)}),i.on("touchstart",function(e){var t,r,a,n,o=this;if(m=v=!1,1<e.targetTouches.length)return b&&O(),!0;if(1<e.touches.length&&b&&O(),x.tapHold&&(g&&clearTimeout(g),g=setTimeout(function(){e&&e.touches&&1<e.touches.length||(m=!0,e.preventDefault(),$(e.target).trigger("taphold"))},x.tapHoldDelay)),C&&clearTimeout(C),t=e.target,r=$(t),!(w=!("input"===t.nodeName.toLowerCase()&&("file"===t.type||"range"===t.type)||"select"===t.nodeName.toLowerCase()&&Device.android||r.hasClass("no-fastclick")||0<r.parents(".no-fastclick").length||x.fastClicksExclude&&0<r.closest(x.fastClicksExclude).length)))return!(p=!1);if(Device.ios||Device.android&&"getSelection"in win){var i=win.getSelection();if(i.rangeCount&&i.focusNode!==doc.body&&(!i.isCollapsed||doc.activeElement===i.focusNode))return d=!0;d=!1}return Device.android&&(a=e.target,n="button input textarea select".split(" "),!doc.activeElement||a===doc.activeElement||doc.activeElement===doc.body||0<=n.indexOf(a.nodeName.toLowerCase())||doc.activeElement.blur()),p=!0,u=e.target,c=(new Date).getTime(),s=e.targetTouches[0].pageX,l=e.targetTouches[0].pageY,Device.ios&&(f=void 0,$(u).parents().each(function(){var e=o;e.scrollHeight>e.offsetHeight&&!f&&((f=e).f7ScrollTop=f.scrollTop)})),c-h<x.fastClicksDelayBetweenClicks&&e.preventDefault(),x.activeState&&(S(b=E(u))?y=setTimeout(T,80):T()),k&&P(u),!0}),i.on("touchmove",function(e){if(p){var t=x.fastClicksDistanceThreshold;if(t){var r=e.targetTouches[0].pageX,a=e.targetTouches[0].pageY;(Math.abs(r-s)>t||Math.abs(a-l)>t)&&(v=!0)}else v=!0;v&&(p=!1,v=!(u=null),x.tapHold&&clearTimeout(g),x.activeState&&(clearTimeout(y),O()),k&&o())}}),i.on("touchend",function(e){clearTimeout(y),clearTimeout(g);var t,r,a,n,o=(new Date).getTime();if(!p)return!d&&w&&(Device.android&&!e.cancelable||!e.cancelable||e.preventDefault()),x.activeState&&O(),k&&R(),!0;if(doc.activeElement===e.target)return x.activeState&&O(),k&&R(),!0;if(d||e.preventDefault(),o-h<x.fastClicksDelayBetweenClicks)return setTimeout(O,0),k&&R(),!0;if(h=o,p=!1,Device.ios&&f&&f.scrollTop!==f.f7ScrollTop)return!1;if(x.activeState&&(T(),setTimeout(O,0)),k&&R(),function(e){if(doc.activeElement===e)return!1;var t=e.nodeName.toLowerCase(),r="button checkbox file image radio submit".split(" ");return!e.disabled&&!e.readOnly&&("textarea"===t||("select"===t?!Device.android:"input"===t&&r.indexOf(e.type)<0))}(u)){if(Device.ios&&Device.webView)return u.focus(),!1;u.focus()}return doc.activeElement&&u!==doc.activeElement&&doc.activeElement!==doc.body&&"label"!==u.nodeName.toLowerCase()&&doc.activeElement.blur(),e.preventDefault(),x.tapHoldPreventClicks&&m||(r=(t=e).changedTouches[0],a=doc.createEvent("MouseEvents"),n="click",Device.android&&"select"===u.nodeName.toLowerCase()&&(n="mousedown"),a.initMouseEvent(n,!0,!0,win,1,r.screenX,r.screenY,r.clientX,r.clientY,!1,!1,!1,!1,0,null),a.forwardedTouchEvent=!0,i.device.ios&&win.navigator.standalone?setTimeout(function(){(u=doc.elementFromPoint(t.changedTouches[0].clientX,t.changedTouches[0].clientY)).dispatchEvent(a)},10):u.dispatchEvent(a)),!1}),doc.addEventListener("touchcancel",function(){p=!1,u=null,clearTimeout(y),clearTimeout(g),x.activeState&&O(),k&&R()},{passive:!0})):x.activeState&&(i.on("touchstart",function(e){E(e.target).addClass("active-state"),"which"in e&&3===e.which&&setTimeout(function(){$(".active-state").removeClass("active-state")},0),k&&(s=e.pageX,l=e.pageY,P(e.target,e.pageX,e.pageY))}),i.on("touchmove",function(){$(".active-state").removeClass("active-state"),k&&o()}),i.on("touchend",function(){$(".active-state").removeClass("active-state"),k&&R()})),doc.addEventListener("contextmenu",function(e){x.disableContextMenu&&(Device.ios||Device.android||Device.cordova)&&e.preventDefault(),k&&(b&&O(),R())})}var TouchModule={name:"touch",params:{touch:{fastClicks:!0,fastClicksDistanceThreshold:10,fastClicksDelayBetweenClicks:50,fastClicksExclude:"",disableContextMenu:!0,tapHold:!1,tapHoldDelay:750,tapHoldPreventClicks:!0,activeState:!0,activeStateElements:"a, button, label, span, .actions-button, .stepper-button, .stepper-button-plus, .stepper-button-minus",materialRipple:!0,materialRippleElements:".ripple, .link, .item-link, .links-list a, .button, button, .input-clear-button, .dialog-button, .tab-link, .item-radio, .item-checkbox, .actions-button, .searchbar-disable-button, .fab a, .checkbox, .radio, .data-table .sortable-cell:not(.input-cell), .notification-close-button, .stepper-button, .stepper-button-minus, .stepper-button-plus"}},instance:{touchEvents:{start:Support.touch?"touchstart":"mousedown",move:Support.touch?"touchmove":"mousemove",end:Support.touch?"touchend":"mouseup"}},on:{init:initTouch}},pathToRegexp_1=pathToRegexp,parse_1=parse,compile_1=compile,tokensToFunction_1=tokensToFunction,tokensToRegExp_1=tokensToRegExp,DEFAULT_DELIMITER="/",DEFAULT_DELIMITERS="./",PATH_REGEXP=new RegExp(["(\\\\.)","(?:\\:(\\w+)(?:\\(((?:\\\\.|[^\\\\()])+)\\))?|\\(((?:\\\\.|[^\\\\()])+)\\))([+*?])?"].join("|"),"g");function parse(e,t){for(var r,a=[],n=0,o=0,i="",s=t&&t.delimiter||DEFAULT_DELIMITER,l=t&&t.delimiters||DEFAULT_DELIMITERS,c=!1;null!==(r=PATH_REGEXP.exec(e));){var u=r[0],p=r[1],d=r.index;if(i+=e.slice(o,d),o=d+u.length,p)i+=p[1],c=!0;else{var f="",h=e[o],v=r[2],m=r[3],g=r[4],b=r[5];if(!c&&i.length){var y=i.length-1;-1<l.indexOf(i[y])&&(f=i[y],i=i.slice(0,y))}i&&(a.push(i),i="",c=!1);var w=""!==f&&void 0!==h&&h!==f,C="+"===b||"*"===b,x="?"===b||"*"===b,k=f||s,E=m||g;a.push({name:v||n++,prefix:f,delimiter:k,optional:x,repeat:C,partial:w,pattern:E?escapeGroup(E):"[^"+escapeString(k)+"]+?"})}}return(i||o<e.length)&&a.push(i+e.substr(o)),a}function compile(e,t){return tokensToFunction(parse(e,t))}function tokensToFunction(c){for(var u=new Array(c.length),e=0;e<c.length;e++)"object"==typeof c[e]&&(u[e]=new RegExp("^(?:"+c[e].pattern+")$"));return function(e,t){for(var r="",a=t&&t.encode||encodeURIComponent,n=0;n<c.length;n++){var o=c[n];if("string"!=typeof o){var i,s=e?e[o.name]:void 0;if(Array.isArray(s)){if(!o.repeat)throw new TypeError('Expected "'+o.name+'" to not repeat, but got array');if(0===s.length){if(o.optional)continue;throw new TypeError('Expected "'+o.name+'" to not be empty')}for(var l=0;l<s.length;l++){if(i=a(s[l],o),!u[n].test(i))throw new TypeError('Expected all "'+o.name+'" to match "'+o.pattern+'"');r+=(0===l?o.prefix:o.delimiter)+i}}else if("string"!=typeof s&&"number"!=typeof s&&"boolean"!=typeof s){if(!o.optional)throw new TypeError('Expected "'+o.name+'" to be '+(o.repeat?"an array":"a string"));o.partial&&(r+=o.prefix)}else{if(i=a(String(s),o),!u[n].test(i))throw new TypeError('Expected "'+o.name+'" to match "'+o.pattern+'", but got "'+i+'"');r+=o.prefix+i}}else r+=o}return r}}function escapeString(e){return e.replace(/([.+*?=^!:${}()[\]|/\\])/g,"\\$1")}function escapeGroup(e){return e.replace(/([=!:$/()])/g,"\\$1")}function flags(e){return e&&e.sensitive?"":"i"}function regexpToRegexp(e,t){if(!t)return e;var r=e.source.match(/\((?!\?)/g);if(r)for(var a=0;a<r.length;a++)t.push({name:a,prefix:null,delimiter:null,optional:!1,repeat:!1,partial:!1,pattern:null});return e}function arrayToRegexp(e,t,r){for(var a=[],n=0;n<e.length;n++)a.push(pathToRegexp(e[n],t,r).source);return new RegExp("(?:"+a.join("|")+")",flags(r))}function stringToRegexp(e,t,r){return tokensToRegExp(parse(e,r),t,r)}function tokensToRegExp(e,t,r){for(var a=(r=r||{}).strict,n=!1!==r.start,o=!1!==r.end,i=escapeString(r.delimiter||DEFAULT_DELIMITER),s=r.delimiters||DEFAULT_DELIMITERS,l=[].concat(r.endsWith||[]).map(escapeString).concat("$").join("|"),c=n?"^":"",u=0===e.length,p=0;p<e.length;p++){var d=e[p];if("string"==typeof d)c+=escapeString(d),u=p===e.length-1&&-1<s.indexOf(d[d.length-1]);else{var f=d.repeat?"(?:"+d.pattern+")(?:"+escapeString(d.delimiter)+"(?:"+d.pattern+"))*":d.pattern;t&&t.push(d),d.optional?d.partial?c+=escapeString(d.prefix)+"("+f+")?":c+="(?:"+escapeString(d.prefix)+"("+f+"))?":c+=escapeString(d.prefix)+"("+f+")"}}return o?(a||(c+="(?:"+i+")?"),c+="$"===l?"$":"(?="+l+")"):(a||(c+="(?:"+i+"(?="+l+"))?"),u||(c+="(?="+i+"|"+l+")")),new RegExp(c,flags(r))}function pathToRegexp(e,t,r){return e instanceof RegExp?regexpToRegexp(e,t):Array.isArray(e)?arrayToRegexp(e,t,r):stringToRegexp(e,t,r)}pathToRegexp_1.parse=parse_1,pathToRegexp_1.compile=compile_1,pathToRegexp_1.tokensToFunction=tokensToFunction_1,pathToRegexp_1.tokensToRegExp=tokensToRegExp_1;var History={queue:[],clearQueue:function(){0!==History.queue.length&&History.queue.shift()()},routerQueue:[],clearRouterQueue:function(){if(0!==History.routerQueue.length){var e=History.routerQueue.pop(),t=e.router,r=e.stateUrl,a=e.action,n=t.params.animate;!1===t.params.pushStateAnimate&&(n=!1),"back"===a&&t.back({animate:n,pushState:!1}),"load"===a&&t.navigate(r,{animate:n,pushState:!1})}},handle:function(e){if(!History.blockPopstate){var o=e.state;History.previousState=History.state,History.state=o,History.allowChange=!0,History.clearQueue(),(o=History.state)||(o={}),this.views.forEach(function(e){var t=e.router,r=o[e.id];if(!r&&e.params.pushState&&(r={url:e.router.history[0]}),r){var a=r.url||void 0,n=t.params.animate;!1===t.params.pushStateAnimate&&(n=!1),a!==t.url&&(0<=t.history.indexOf(a)?t.allowPageChange?t.back({animate:n,pushState:!1}):History.routerQueue.push({action:"back",router:t}):t.allowPageChange?t.navigate(a,{animate:n,pushState:!1}):History.routerQueue.unshift({action:"load",stateUrl:a,router:t}))}})}},initViewState:function(e,t){var r,a=Utils.extend({},History.state||{},((r={})[e]=t,r));History.state=a,win.history.replaceState(a,"")},push:function(e,t,r){var a;if(History.allowChange){History.previousState=History.state;var n=Utils.extend({},History.previousState||{},((a={})[e]=t,a));History.state=n,win.history.pushState(n,"",r)}else History.queue.push(function(){History.push(e,t,r)})},replace:function(e,t,r){var a;if(History.allowChange){History.previousState=History.state;var n=Utils.extend({},History.previousState||{},((a={})[e]=t,a));History.state=n,win.history.replaceState(n,"",r)}else History.queue.push(function(){History.replace(e,t,r)})},go:function(e){History.allowChange=!1,win.history.go(e)},back:function(){History.allowChange=!1,win.history.back()},allowChange:!0,previousState:{},state:win.history.state,blockPopstate:!0,init:function(e){$(win).on("load",function(){setTimeout(function(){History.blockPopstate=!1},0)}),doc.readyState&&"complete"===doc.readyState&&(History.blockPopstate=!1),$(win).on("popstate",History.handle.bind(e))}};function SwipeBack(e){var p,d,f,r,h,v,m,g,b,y,w,C,x,k,t,E=e,S=E.$el,T=E.$navbarEl,O=E.app,P=E.params,R=!1,D=!1,N={},A=[],L=[],a=!0,U=[],M=[],B=P[O.theme+"SwipeBackAnimateShadow"],H=P[O.theme+"SwipeBackAnimateOpacity"],q=P[O.theme+"SwipeBackActiveArea"],j=P[O.theme+"SwipeBackThreshold"];function n(e){var t=P[O.theme+"SwipeBack"];!a||!t||R||O.swipeout&&O.swipeout.el||!E.allowPageChange||0<$(e.target).closest(".range-slider, .calendar-months").length||(R=!(D=!1),p=void 0,N.x="touchstart"===e.type?e.targetTouches[0].pageX:e.pageX,N.y="touchstart"===e.type?e.targetTouches[0].pageY:e.pageY,r=Utils.now(),y=E.dynamicNavbar,w=E.separateNavbar)}function o(e){if(R){var t="touchmove"===e.type?e.targetTouches[0].pageX:e.pageX,r="touchmove"===e.type?e.targetTouches[0].pageY:e.pageY;if(void 0===p&&(p=!!(p||Math.abs(r-N.y)>Math.abs(t-N.x))||t<N.x&&!O.rtl||t>N.x&&O.rtl),p||e.f7PreventSwipeBack||O.preventSwipeBack)R=!1;else{if(!D){var a=!1,n=$(e.target),o=n.closest(".swipeout");0<o.length&&(!O.rtl&&0<o.find(".swipeout-actions-left").length&&(a=!0),O.rtl&&0<o.find(".swipeout-actions-right").length&&(a=!0)),((A=n.closest(".page")).hasClass("no-swipeback")||0<n.closest(".no-swipeback").length)&&(a=!0),L=S.find(".page-previous:not(.stacked)");N.x,S.offset().left;if(d=S.width(),(O.rtl?N.x<S.offset().left-S[0].scrollLeft+(d-q):N.x-S.offset().left>q)&&(a=!0),0!==L.length&&0!==A.length||(a=!0),a)return void(R=!1);B&&0===(C=A.find(".page-shadow-effect")).length&&(C=$('<div class="page-shadow-effect"></div>'),A.append(C)),H&&0===(x=L.find(".page-opacity-effect")).length&&(x=$('<div class="page-opacity-effect"></div>'),L.append(x)),y&&(M=w?(U=T.find(".navbar-current:not(.stacked)"),T.find(".navbar-previous:not(.stacked)")):(U=A.children(".navbar").children(".navbar-inner"),L.children(".navbar").children(".navbar-inner")),k=T[0].offsetWidth,h=U.children(".left, .title, .right, .subnavbar, .fading"),v=M.children(".left, .title, .right, .subnavbar, .fading"),P.iosAnimateNavbarBackIcon&&(g=U.hasClass("sliding")?(m=U.children(".left").find(".back .icon"),U.children(".left").find(".back span").eq(0)):(m=U.children(".left.sliding").find(".back .icon"),U.children(".left.sliding").find(".back span").eq(0)),b=M.hasClass("sliding")?M.children(".left").find(".back .icon"):M.children(".left.sliding").find(".back .icon"))),0<$(".sheet.modal-in").length&&O.sheet&&O.sheet.close($(".sheet.modal-in"))}e.f7PreventPanelSwipe=!0,D=!0,O.preventSwipePanelBySwipeBack=!0,e.preventDefault();var i=O.rtl?-1:1;(f=(t-N.x-j)*i)<0&&(f=0);var s=f/d,l={percentage:s,currentPageEl:A[0],previousPageEl:L[0],currentNavbarEl:U[0],previousNavbarEl:M[0]};S.trigger("swipeback:move",l),E.emit("swipebackMove",l);var c=f*i,u=(f/5-d/5)*i;1===Device.pixelRatio&&(c=Math.round(c),u=Math.round(u)),E.swipeBackActive=!0,$([A[0],L[0]]).addClass("page-swipeback-active"),A.transform("translate3d("+c+"px,0,0)"),B&&(C[0].style.opacity=1-1*s),"md"!==O.theme&&L.transform("translate3d("+u+"px,0,0)"),H&&(x[0].style.opacity=1-1*s),y&&(h.each(function(e,t){var r=$(t);if(r.is(".subnavbar")||(r[0].style.opacity=1-Math.pow(s,.33)),0<=r[0].className.indexOf("sliding")||U.hasClass("sliding")){var a=s*r[0].f7NavbarRightOffset;if(1===Device.pixelRatio&&(a=Math.round(a)),r.transform("translate3d("+a+"px,0,0)"),P.iosAnimateNavbarBackIcon&&0<=r[0].className.indexOf("left")&&0<m.length){var n=-a;w||(n-=k*s),m.transform("translate3d("+n+"px,0,0)")}}}),v.each(function(e,t){var r=$(t);if(r.is(".subnavbar")||(r[0].style.opacity=Math.pow(s,3)),0<=r[0].className.indexOf("sliding")||M.hasClass("sliding")){var a=r[0].f7NavbarLeftOffset*(1-s);if(a=0<=r[0].className.indexOf("title")&&m&&m.length&&g.length?(r[0].f7NavbarLeftOffset+g[0].offsetLeft)*(1-s):r[0].f7NavbarLeftOffset*(1-s),1===Device.pixelRatio&&(a=Math.round(a)),r.transform("translate3d("+a+"px,0,0)"),P.iosAnimateNavbarBackIcon&&0<=r[0].className.indexOf("left")&&0<b.length){var n=-a;w||(n+=k/5*(1-s)),b.transform("translate3d("+n+"px,0,0)")}}}))}}}function i(){if(O.preventSwipePanelBySwipeBack=!1,R&&D){if(D=R=!1,E.swipeBackActive=!1,$([A[0],L[0]]).removeClass("page-swipeback-active"),0===f)return $([A[0],L[0]]).transform(""),C&&0<C.length&&C.remove(),x&&0<x.length&&x.remove(),void(y&&(h.transform("").css({opacity:""}),v.transform("").css({opacity:""}),m&&0<m.length&&m.transform(""),b&&0<m.length&&b.transform("")));var e=Utils.now()-r,o=!1;(e<300&&10<f||300<=e&&d/2<f)&&(A.removeClass("page-current").addClass("page-next"+("md"===O.theme?" page-next-on-right":"")),L.removeClass("page-previous").addClass("page-current").removeAttr("aria-hidden"),C&&(C[0].style.opacity=""),x&&(x[0].style.opacity=""),y&&(U.removeClass("navbar-current").addClass("navbar-next"),M.removeClass("navbar-previous").addClass("navbar-current").removeAttr("aria-hidden")),o=!0),$([A[0],L[0]]).addClass("page-transitioning page-transitioning-swipeback").transform(""),y&&(h.css({opacity:""}).each(function(e,t){var r=o?t.f7NavbarRightOffset:0,a=$(t),n=o?-r:0;!w&&o&&(n-=k),a.transform("translate3d("+r+"px,0,0)"),P.iosAnimateNavbarBackIcon&&a.hasClass("left")&&0<m.length&&m.addClass("navbar-transitioning").transform("translate3d("+n+"px,0,0)")}).addClass("navbar-transitioning"),v.transform("").css({opacity:""}).each(function(e,t){var r=o?0:t.f7NavbarLeftOffset,a=$(t),n=o?0:-r;w||o||(n+=k/5),a.transform("translate3d("+r+"px,0,0)"),P.iosAnimateNavbarBackIcon&&a.hasClass("left")&&0<b.length&&b.addClass("navbar-transitioning").transform("translate3d("+n+"px,0,0)")}).addClass("navbar-transitioning")),a=!1,E.allowPageChange=!1;var t={currentPageEl:A[0],previousPageEl:L[0],currentNavbarEl:U[0],previousNavbarEl:M[0]};o?(E.currentRoute=L[0].f7Page.route,E.currentPage=L[0],E.pageCallback("beforeOut",A,U,"current","next",{route:A[0].f7Page.route,swipeBack:!0}),E.pageCallback("beforeIn",L,M,"previous","current",{route:L[0].f7Page.route,swipeBack:!0}),S.trigger("swipeback:beforechange",t),E.emit("swipebackBeforeChange",t)):(S.trigger("swipeback:beforereset",t),E.emit("swipebackBeforeReset",t)),A.transitionEnd(function(){$([A[0],L[0]]).removeClass("page-transitioning page-transitioning-swipeback"),y&&(h.removeClass("navbar-transitioning").css({opacity:""}).transform(""),v.removeClass("navbar-transitioning").css({opacity:""}).transform(""),m&&0<m.length&&m.removeClass("navbar-transitioning"),b&&0<b.length&&b.removeClass("navbar-transitioning")),a=!0,E.allowPageChange=!0,o?(1===E.history.length&&E.history.unshift(E.url),E.history.pop(),E.saveHistory(),P.pushState&&History.back(),E.pageCallback("afterOut",A,U,"current","next",{route:A[0].f7Page.route,swipeBack:!0}),E.pageCallback("afterIn",L,M,"previous","current",{route:L[0].f7Page.route,swipeBack:!0}),P.stackPages&&0<=E.initialPages.indexOf(A[0])?(A.addClass("stacked"),w&&U.addClass("stacked")):(E.pageCallback("beforeRemove",A,U,"next",{swipeBack:!0}),E.removePage(A),w&&E.removeNavbar(U)),S.trigger("swipeback:afterchange",t),E.emit("swipebackAfterChange",t),E.emit("routeChanged",E.currentRoute,E.previousRoute,E),P.preloadPreviousPage&&E.back(E.history[E.history.length-2],{preload:!0})):(S.trigger("swipeback:afterreset",t),E.emit("swipebackAfterReset",t)),C&&0<C.length&&C.remove(),x&&0<x.length&&x.remove()})}else D=R=!1}t=!("touchstart"!==O.touchEvents.start||!Support.passiveListener)&&{passive:!0,capture:!1},S.on(O.touchEvents.start,n,t),O.on("touchmove:active",o),O.on("touchend:passive",i),E.on("routerDestroy",function(){var e=!("touchstart"!==O.touchEvents.start||!Support.passiveListener)&&{passive:!0,capture:!1};S.off(O.touchEvents.start,n,e),O.off("touchmove:active",o),O.off("touchend:passive",i)})}function redirect(r,e,a){var n=this,t=e.route.redirect;if(a.initial&&n.params.pushState&&(a.replaceState=!0,a.history=!0),"function"!=typeof t)return n[r](t,a);n.allowPageChange=!1;var o=t.call(n,e,function(e,t){void 0===t&&(t={}),n.allowPageChange=!0,n[r](e,Utils.extend({},a,t))},function(){n.allowPageChange=!0});return o&&"string"==typeof o?(n.allowPageChange=!0,n[r](o,a)):n}function processQueue(t,e,r,a,n,o,i){var s=[];Array.isArray(r)?s.push.apply(s,r):r&&"function"==typeof r&&s.push(r),e&&(Array.isArray(e)?s.push.apply(s,e):s.push(e)),function e(){0!==s.length?s.shift().call(t,a,n,function(){e()},function(){i()}):o()}()}function processRouteQueue(e,t,r,a){var n=this;function o(){e&&e.route&&(n.params.routesBeforeEnter||e.route.beforeEnter)?(n.allowPageChange=!1,processQueue(n,n.params.routesBeforeEnter,e.route.beforeEnter,e,t,function(){n.allowPageChange=!0,r()},function(){a()})):r()}t&&t.route&&(n.params.routesBeforeLeave||t.route.beforeLeave)?(n.allowPageChange=!1,processQueue(n,n.params.routesBeforeLeave,t.route.beforeLeave,e,t,function(){n.allowPageChange=!0,o()},function(){a()})):o()}function refreshPage(){return this.navigate(this.currentRoute.url,{ignoreCache:!0,reloadCurrent:!0})}function forward(e,t){void 0===t&&(t={});var r,n=this,a=$(e),o=n.app,i=n.view,s=Utils.extend(!1,{animate:n.params.animate,pushState:!0,replaceState:!1,history:!0,reloadCurrent:n.params.reloadPages,reloadPrevious:!1,reloadAll:!1,clearPreviousHistory:!1,on:{}},t),l=n.currentRoute.modal;if(l||"popup popover sheet loginScreen actions customModal panel".split(" ").forEach(function(e){n.currentRoute&&n.currentRoute.route&&n.currentRoute.route[e]&&(l=!0,r=e)}),l){var c=n.currentRoute.modal||n.currentRoute.route.modalInstance||o[r].get(),u=n.history[n.history.length-2],p=n.findMatchingRoute(u);!p&&u&&(p={url:u,path:u.split("?")[0],query:Utils.parseUrlQuery(u),route:{path:u.split("?")[0],url:u}}),n.modalRemove(c)}var d,f,h,v,m=n.dynamicNavbar,g=n.separateNavbar,b=n.$el,y=a,w=s.reloadPrevious||s.reloadCurrent||s.reloadAll;if(n.allowPageChange=!1,0===y.length)return n.allowPageChange=!0,n;y.length&&n.removeThemeElements(y),m&&(h=y.children(".navbar").children(".navbar-inner"),g&&(f=n.$navbarEl,0<h.length&&y.children(".navbar").remove(),0===h.length&&y[0]&&y[0].f7Page&&(h=y[0].f7Page.$navbarEl))),s.route&&s.route.route&&s.route.route.keepAlive&&!s.route.route.keepAliveData&&(s.route.route.keepAliveData={pageEl:a[0]});var C,x=b.children(".page:not(.stacked)").filter(function(e,t){return t!==y[0]});if(g&&(C=f.children(".navbar-inner:not(.stacked)").filter(function(e,t){return t!==h[0]})),s.reloadPrevious&&x.length<2)return n.allowPageChange=!0,n;var k="next";if(s.reloadCurrent||s.reloadAll?k="current":s.reloadPrevious&&(k="previous"),y.addClass("page-"+k).removeClass("stacked").trigger("page:unstack").trigger("page:position",{position:k}),m&&h.length&&h.addClass("navbar-"+k).removeClass("stacked"),s.reloadCurrent)d=x.eq(x.length-1),g&&(v=$(o.navbar.getElByPage(d)));else if(s.reloadPrevious)d=x.eq(x.length-2),g&&(v=$(o.navbar.getElByPage(d)));else if(s.reloadAll)d=x.filter(function(e,t){return t!==y[0]}),g&&(v=C.filter(function(e,t){return t!==h[0]}));else{if(1<x.length){var E=0;for(E=0;E<x.length-1;E+=1){var S=o.navbar.getElByPage(x.eq(E));n.params.stackPages?(x.eq(E).addClass("stacked"),x.eq(E).trigger("page:stack"),g&&$(S).addClass("stacked")):(n.pageCallback("beforeRemove",x[E],C&&C[E],"previous",void 0,s),n.removePage(x[E]),g&&S&&n.removeNavbar(S))}}d=b.children(".page:not(.stacked)").filter(function(e,t){return t!==y[0]}),g&&(v=f.children(".navbar-inner:not(.stacked)").filter(function(e,t){return t!==h[0]}))}if(m&&!g&&(v=d.children(".navbar").children(".navbar-inner")),n.params.pushState&&(s.pushState||s.replaceState)&&!s.reloadPrevious){var T=n.params.pushStateRoot||"";History[s.reloadCurrent||s.reloadAll||s.replaceState?"replace":"push"](i.id,{url:s.route.url},T+n.params.pushStateSeparator+s.route.url)}s.reloadPrevious||(n.currentPageEl=y[0],m&&h.length?n.currentNavbarEl=h[0]:delete n.currentNavbarEl,n.currentRoute=s.route);var O=s.route.url;s.history&&(0<(s.reloadCurrent&&n.history.length)||s.replaceState?n.history[n.history.length-(s.reloadPrevious?2:1)]=O:s.reloadPrevious?n.history[n.history.length-2]=O:s.reloadAll?n.history=[O]:n.history.push(O)),n.saveHistory();var P=0<y.parents(doc).length,R=y[0].f7Component;if(s.reloadPrevious?(R&&!P?R.$mount(function(e){$(e).insertBefore(d)}):y.insertBefore(d),g&&h.length&&(v.length?h.insertBefore(v):(n.$navbarEl.parents(doc).length||n.$el.prepend(n.$navbarEl),f.append(h)))):(d.next(".page")[0]!==y[0]&&(R&&!P?R.$mount(function(e){b.append(e)}):b.append(y[0])),g&&h.length&&(n.$navbarEl.parents(doc).length||n.$el.prepend(n.$navbarEl),f.append(h[0]))),P?s.route&&s.route.route&&s.route.route.keepAlive&&!y[0].f7PageMounted&&(y[0].f7PageMounted=!0,n.pageCallback("mounted",y,h,k,w?k:"current",s,d)):n.pageCallback("mounted",y,h,k,w?k:"current",s,d),s.reloadCurrent&&0<d.length?n.params.stackPages&&0<=n.initialPages.indexOf(d[0])?(d.addClass("stacked"),d.trigger("page:stack"),g&&v.addClass("stacked")):(n.pageCallback("beforeRemove",d,v,"previous",void 0,s),n.removePage(d),g&&v&&v.length&&n.removeNavbar(v)):s.reloadAll?d.each(function(e,t){var r=$(t),a=$(o.navbar.getElByPage(r));n.params.stackPages&&0<=n.initialPages.indexOf(r[0])?(r.addClass("stacked"),r.trigger("page:stack"),g&&a.addClass("stacked")):(n.pageCallback("beforeRemove",r,v&&v.eq(e),"previous",void 0,s),n.removePage(r),g&&a.length&&n.removeNavbar(a))}):s.reloadPrevious&&(n.params.stackPages&&0<=n.initialPages.indexOf(d[0])?(d.addClass("stacked"),d.trigger("page:stack"),g&&v.addClass("stacked")):(n.pageCallback("beforeRemove",d,v,"previous",void 0,s),n.removePage(d),g&&v&&v.length&&n.removeNavbar(v))),s.route.route.tab&&n.tabLoad(s.route.route.tab,Utils.extend({},s,{history:!1,pushState:!1})),n.pageCallback("init",y,h,k,w?k:"current",s,d),s.reloadCurrent||s.reloadAll)return n.allowPageChange=!0,n.pageCallback("beforeIn",y,h,k,"current",s),n.pageCallback("afterIn",y,h,k,"current",s),s.reloadCurrent&&s.clearPreviousHistory&&n.clearPreviousHistory(),n;if(s.reloadPrevious)return n.allowPageChange=!0,n;function D(){var e="page-previous page-current page-next",t="navbar-previous navbar-current navbar-next";y.removeClass(e).addClass("page-current").removeAttr("aria-hidden"),d.removeClass(e).addClass("page-previous").attr("aria-hidden","true"),m&&(h.removeClass(t).addClass("navbar-current").removeAttr("aria-hidden"),v.removeClass(t).addClass("navbar-previous").attr("aria-hidden","true")),n.allowPageChange=!0,n.pageCallback("afterIn",y,h,"next","current",s),n.pageCallback("afterOut",d,v,"current","previous",s);var r="ios"===o.theme?n.params.preloadPreviousPage||n.params.iosSwipeBack:n.params.preloadPreviousPage;r||(y.hasClass("smart-select-page")||y.hasClass("photo-browser-page")||y.hasClass("autocomplete-page"))&&(r=!0),r||(n.params.stackPages?(d.addClass("stacked"),d.trigger("page:stack"),g&&v.addClass("stacked")):y.attr("data-name")&&"smart-select-page"===y.attr("data-name")||(n.pageCallback("beforeRemove",d,v,"previous",void 0,s),n.removePage(d),g&&v.length&&n.removeNavbar(v))),s.clearPreviousHistory&&n.clearPreviousHistory(),n.emit("routeChanged",n.currentRoute,n.previousRoute,n),n.params.pushState&&History.clearRouterQueue()}function N(){var e="page-previous page-current page-next",t="navbar-previous navbar-current navbar-next";d.removeClass(e).addClass("page-current").removeAttr("aria-hidden"),y.removeClass(e).addClass("page-next").removeAttr("aria-hidden"),m&&(v.removeClass(t).addClass("navbar-current").removeAttr("aria-hidden"),h.removeClass(t).addClass("navbar-next").removeAttr("aria-hidden"))}if(n.pageCallback("beforeIn",y,h,"next","current",s),n.pageCallback("beforeOut",d,v,"current","previous",s),s.animate){var A="md"===n.app.theme?n.params.materialPageLoadDelay:n.params.iosPageLoadDelay;A?setTimeout(function(){N(),n.animate(d,y,v,h,"forward",function(){D()})},A):(N(),n.animate(d,y,v,h,"forward",function(){D()}))}else D();return n}function load(e,t,r){void 0===e&&(e={}),void 0===t&&(t={});var a=this;if(!a.allowPageChange&&!r)return a;var n=e,o=t,i=n.url,s=n.content,l=n.el,c=n.pageName,u=n.template,p=n.templateUrl,d=n.component,f=n.componentUrl;if(!o.reloadCurrent&&o.route&&o.route.route&&o.route.route.parentPath&&a.currentRoute.route&&a.currentRoute.route.parentPath===o.route.route.parentPath){if(o.route.url===a.url)return!(a.allowPageChange=!0);var h=Object.keys(o.route.params).length===Object.keys(a.currentRoute.params).length;if(h&&Object.keys(o.route.params).forEach(function(e){e in a.currentRoute.params&&a.currentRoute.params[e]===o.route.params[e]||(h=!1)}),h)return!!o.route.route.tab&&a.tabLoad(o.route.route.tab,o)}if(o.route&&o.route.url&&a.url===o.route.url&&!o.reloadCurrent&&!o.reloadPrevious&&!a.params.allowDuplicateUrls)return!(a.allowPageChange=!0);function v(e,t){return a.forward(e,Utils.extend(o,t))}function m(){return a.allowPageChange=!0,a}if(!o.route&&i&&(o.route=a.parseRouteUrl(i),Utils.extend(o.route,{route:{url:i,path:i}})),(i||p||f)&&(a.allowPageChange=!1),s)a.forward(a.getPageEl(s),o);else if(u||p)try{a.pageTemplateLoader(u,p,o,v,m)}catch(e){throw a.allowPageChange=!0,e}else if(l)a.forward(a.getPageEl(l),o);else if(c)a.forward(a.$el.children('.page[data-name="'+c+'"]').eq(0),o);else if(d||f)try{a.pageComponentLoader(a.el,d,f,o,v,m)}catch(e){throw a.allowPageChange=!0,e}else i&&(a.xhr&&(a.xhr.abort(),a.xhr=!1),a.xhrRequest(i,o).then(function(e){a.forward(a.getPageEl(e),o)}).catch(function(){a.allowPageChange=!0}));return a}function navigate(e,t){void 0===t&&(t={});var r,a,n,o,i,s,l=this;if(l.swipeBackActive)return l;if("string"==typeof e?r=e:(r=e.url,a=e.route,n=e.name,o=e.query,i=e.params),n){if(!(s=l.findRouteByKey("name",n)))throw new Error('Framework7: route with name "'+n+'" not found');if(r=l.constructRouteUrl(s,{params:i,query:o}))return l.navigate(r,t);throw new Error("Framework7: can't construct URL for route with name \""+n+'"')}var c=l.app;if(!l.view)return c.views.main&&c.views.main.router.navigate(r,t),l;if("#"===r||""===r)return l;var u=r.replace("./","");if("/"!==u[0]&&0!==u.indexOf("#")){var p=l.currentRoute.parentPath||l.currentRoute.path;u=((p?p+"/":"/")+u).replace("///","/").replace("//","/")}if(!(s=a?Utils.extend(l.parseRouteUrl(u),{route:Utils.extend({},a)}):l.findMatchingRoute(u)))return l;if(s.route.redirect)return redirect.call(l,"navigate",s,t);var d={};function f(){var r=!1;"popup popover sheet loginScreen actions customModal panel".split(" ").forEach(function(e){s.route[e]&&!r&&(r=!0,l.modalLoad(e,s,d))}),s.route.keepAlive&&s.route.keepAliveData&&(l.load({el:s.route.keepAliveData.pageEl},d,!1),r=!0),"url content component pageName el componentUrl template templateUrl".split(" ").forEach(function(e){var t;s.route[e]&&!r&&(r=!0,l.load(((t={})[e]=s.route[e],t),d,!1))}),r||s.route.async&&(l.allowPageChange=!1,s.route.async.call(l,d.route,l.currentRoute,function(r,a){var n=l.allowPageChange=!1;a&&a.context&&(s.context?s.context=Utils.extend({},s.context,a.context):s.context=a.context,d.route.context=s.context),"popup popover sheet loginScreen actions customModal panel".split(" ").forEach(function(e){if(r[e]){n=!0;var t=Utils.extend({},s,{route:r});l.allowPageChange=!0,l.modalLoad(e,t,Utils.extend(d,a))}}),n||l.load(r,Utils.extend(d,a),!0)},function(){l.allowPageChange=!0}))}function h(){l.allowPageChange=!0}return s.route.options?Utils.extend(d,s.route.options,t):Utils.extend(d,t),d.route=s,d&&d.context&&(s.context=d.context,d.route.context=d.context),processRouteQueue.call(l,s,l.currentRoute,function(){s.route.modules?c.loadModules(Array.isArray(s.route.modules)?s.route.modules:[s.route.modules]).then(function(){f()}).catch(function(){h()}):f()},function(){h()}),l}function tabLoad(p,e){void 0===e&&(e={});var t,r,d=this,a=Utils.extend({animate:d.params.animate,pushState:!0,history:!0,parentPageEl:null,preload:!1,on:{}},e);a.route&&(a.preload||a.route===d.currentRoute||(r=d.previousRoute,d.currentRoute=a.route),a.preload?(t=a.route,r=d.currentRoute):(t=d.currentRoute,r||(r=d.previousRoute)),d.params.pushState&&a.pushState&&!a.reloadPrevious&&History.replace(d.view.id,{url:a.route.url},(d.params.pushStateRoot||"")+d.params.pushStateSeparator+a.route.url),a.history&&(d.history[Math.max(d.history.length-1,0)]=a.route.url,d.saveHistory()));var n,o=$(a.parentPageEl||d.currentPageEl);n=o.length&&o.find("#"+p.id).length?o.find("#"+p.id).eq(0):d.view.selector?d.view.selector+" #"+p.id:"#"+p.id;var i,s=d.app.tab.show({tabEl:n,animate:a.animate,tabRoute:a.route}),f=s.$newTabEl,h=s.$oldTabEl,v=s.animated,m=s.onTabsChanged;if(f&&0<f.parents(".page").length&&a.route){var l=f.parents(".page")[0].f7Page;l&&a.route&&(l.route=a.route)}if(f[0].f7RouterTabLoaded)return h&&h.length&&(v?m(function(){d.emit("routeChanged",d.currentRoute,d.previousRoute,d)}):d.emit("routeChanged",d.currentRoute,d.previousRoute,d)),d;function c(e,t){var r=e.url,a=e.content,n=e.el,o=e.template,i=e.templateUrl,s=e.component,l=e.componentUrl;function c(e){d.allowPageChange=!0,e&&("string"==typeof e?f.html(e):(f.html(""),e.f7Component?e.f7Component.$mount(function(e){f.append(e)}):f.append(e)),f[0].f7RouterTabLoaded=!0,function(e){d.removeThemeElements(f);var t=f;"string"!=typeof e&&(t=$(e)),t.trigger("tab:init tab:mounted",p),d.emit("tabInit tabMounted",f[0],p),h&&h.length&&(v?m(function(){d.emit("routeChanged",d.currentRoute,d.previousRoute,d),d.params.unloadTabContent&&d.tabRemove(h,f,p)}):(d.emit("routeChanged",d.currentRoute,d.previousRoute,d),d.params.unloadTabContent&&d.tabRemove(h,f,p)))}(e))}function u(){return d.allowPageChange=!0,d}if(a)c(a);else if(o||i)try{d.tabTemplateLoader(o,i,t,c,u)}catch(e){throw d.allowPageChange=!0,e}else if(n)c(n);else if(s||l)try{d.tabComponentLoader(f[0],s,l,t,c,u)}catch(e){throw d.allowPageChange=!0,e}else r&&(d.xhr&&(d.xhr.abort(),d.xhr=!1),d.xhrRequest(r,t).then(function(e){c(e)}).catch(function(){d.allowPageChange=!0}))}return"url content component el componentUrl template templateUrl".split(" ").forEach(function(e){var t;p[e]&&(i=!0,c(((t={})[e]=p[e],t),a))}),p.async?p.async.call(d,t,r,function(e,t){c(e,Utils.extend(a,t))},function(){d.allowPageChange=!0}):i||(d.allowPageChange=!0),d}function tabRemove(e,t,r){var a;e[0]&&(e[0].f7RouterTabLoaded=!1,delete e[0].f7RouterTabLoaded),e.children().each(function(e,t){t.f7Component&&(a=!0,$(t).trigger("tab:beforeremove",r),t.f7Component.$destroy())}),a||e.trigger("tab:beforeremove",r),this.emit("tabBeforeRemove",e[0],t[0],r),this.removeTabContent(e[0],r)}function modalLoad(a,n,e){void 0===e&&(e={});var r,u=this,p=u.app,o="panel"===a,i=o?"panel":"modal",s=Utils.extend({animate:u.params.animate,pushState:!0,history:!0,on:{}},e),d=Utils.extend({},n.route[a]),l=n.route;function f(){var t=p[a].create(d),e=(l.modalInstance=t).el;function r(){t.close()}t.on(i+"Open",function(){e||(u.removeThemeElements(t.el),t.$el.trigger(a.toLowerCase()+":init "+a.toLowerCase()+":mounted",n,t),u.emit((o?"":"modalInit")+" "+a+"Init "+a+"Mounted",t.el,n,t)),u.once("swipeBackMove",r)}),t.on(i+"Close",function(){u.off("swipeBackMove",r),t.closeByRouter||u.back()}),t.on(i+"Closed",function(){t.$el.trigger(a.toLowerCase()+":beforeremove",n,t),t.emit((o?"":"modalBeforeRemove ")+a+"BeforeRemove",t.el,n,t);var e=t.el.f7Component;e&&e.$destroy(),Utils.nextTick(function(){(e||d.component)&&u.removeModal(t.el),t.destroy(),delete t.route,delete l.modalInstance})}),s.route&&(u.params.pushState&&s.pushState&&History.push(u.view.id,{url:s.route.url,modal:a},(u.params.pushStateRoot||"")+u.params.pushStateSeparator+s.route.url),s.route!==u.currentRoute&&(t.route=Utils.extend(s.route,{modal:t}),u.currentRoute=t.route),s.history&&(u.history.push(s.route.url),u.saveHistory())),e&&(u.removeThemeElements(t.el),t.$el.trigger(a.toLowerCase()+":init "+a.toLowerCase()+":mounted",n,t),u.emit(i+"Init "+a+"Init "+a+"Mounted",t.el,n,t)),t.open()}function c(e,t){var r=e.url,a=e.content,n=e.template,o=e.templateUrl,i=e.component,s=e.componentUrl;function l(e){e&&("string"==typeof e?d.content=e:e.f7Component?e.f7Component.$mount(function(e){d.el=e,p.root.append(e)}):d.el=e,f())}function c(){return u.allowPageChange=!0,u}if(a)l(a);else if(n||o)try{u.modalTemplateLoader(n,o,t,l,c)}catch(e){throw u.allowPageChange=!0,e}else if(i||s)try{u.modalComponentLoader(p.root[0],i,s,t,l,c)}catch(e){throw u.allowPageChange=!0,e}else r?(u.xhr&&(u.xhr.abort(),u.xhr=!1),u.xhrRequest(r,t).then(function(e){d.content=e,f()}).catch(function(){u.allowPageChange=!0})):f()}return"url content component el componentUrl template templateUrl".split(" ").forEach(function(e){var t;d[e]&&!r&&(r=!0,c(((t={})[e]=d[e],t),s))}),r||"actions"!==a||f(),d.async&&d.async.call(u,s.route,u.currentRoute,function(e,t){c(e,Utils.extend(s,t))},function(){u.allowPageChange=!0}),u}function modalRemove(e){Utils.extend(e,{closeByRouter:!0}),e.close()}function backward(e,t){var r,a,n,o,i=this,s=$(e),l=i.app,c=i.view,u=Utils.extend({animate:i.params.animate,pushState:!0},t),p=i.dynamicNavbar,d=i.separateNavbar,f=s,h=i.$el.children(".page-current");if(f.length&&i.removeThemeElements(f),p&&(a=f.children(".navbar").children(".navbar-inner"),n=d?(r=i.$navbarEl,0<a.length&&f.children(".navbar").remove(),0===a.length&&f[0]&&f[0].f7Page&&(a=f[0].f7Page.$navbarEl),r.find(".navbar-current")):h.children(".navbar").children(".navbar-inner")),i.allowPageChange=!1,0===f.length||0===h.length)return i.allowPageChange=!0,i;if(i.removeThemeElements(f),u.route&&u.route.route&&u.route.route.keepAlive&&!u.route.route.keepAliveData&&(u.route.route.keepAliveData={pageEl:s[0]}),f.addClass("page-previous").removeClass("stacked").removeAttr("aria-hidden").trigger("page:unstack").trigger("page:position",{position:"previous"}),p&&0<a.length&&a.addClass("navbar-previous").removeClass("stacked").removeAttr("aria-hidden"),u.force&&(0<h.prev(".page-previous:not(.stacked)").length||0===h.prev(".page-previous").length))if(0<=i.history.indexOf(u.route.url)?(o=i.history.length-i.history.indexOf(u.route.url)-1,i.history=i.history.slice(0,i.history.indexOf(u.route.url)+2),c.history=i.history):i.history[[i.history.length-2]]?i.history[i.history.length-2]=u.route.url:i.history.unshift(i.url),o&&i.params.stackPages)h.prevAll(".page-previous").each(function(e,t){var r,a=$(t);d&&(r=$(l.navbar.getElByPage(a))),a[0]!==f[0]&&a.index()>f.index()&&(0<=i.initialPages.indexOf(a[0])?(a.addClass("stacked"),a.trigger("page:stack"),d&&r.addClass("stacked")):(i.pageCallback("beforeRemove",a,r,"previous",void 0,u),i.removePage(a),d&&0<r.length&&i.removeNavbar(r)))});else{var v,m=h.prev(".page-previous:not(.stacked)");d&&(v=$(l.navbar.getElByPage(m))),i.params.stackPages&&0<=i.initialPages.indexOf(m[0])?(m.addClass("stacked"),m.trigger("page:stack"),v.addClass("stacked")):0<m.length&&(i.pageCallback("beforeRemove",m,v,"previous",void 0,u),i.removePage(m),d&&v.length&&i.removeNavbar(v))}var g,b,y=0<f.parents(doc).length,w=f[0].f7Component;function C(){0===f.next(h).length&&(!y&&w?w.$mount(function(e){$(e).insertBefore(h)}):f.insertBefore(h)),d&&a.length&&(a.insertBefore(n),0<n.length?a.insertBefore(n):(i.$navbarEl.parents(doc).length||i.$el.prepend(i.$navbarEl),r.append(a))),y?u.route&&u.route.route&&u.route.route.keepAlive&&!f[0].f7PageMounted&&(f[0].f7PageMounted=!0,i.pageCallback("mounted",f,a,"previous","current",u,h)):i.pageCallback("mounted",f,a,"previous","current",u,h)}if(u.preload)return C(),u.route.route.tab&&i.tabLoad(u.route.route.tab,Utils.extend({},u,{history:!1,pushState:!1,preload:!0})),i.pageCallback("init",f,a,"previous","current",u,h),0<f.prevAll(".page-previous:not(.stacked)").length&&f.prevAll(".page-previous:not(.stacked)").each(function(e,t){var r,a=$(t);d&&(r=$(l.navbar.getElByPage(a))),i.params.stackPages&&0<=i.initialPages.indexOf(t)?(a.addClass("stacked"),a.trigger("page:stack"),d&&r.addClass("stacked")):(i.pageCallback("beforeRemove",a,r,"previous",void 0),i.removePage(a),d&&r.length&&i.removeNavbar(r))}),i.allowPageChange=!0,i;function x(){var e="page-previous page-current page-next",t="navbar-previous navbar-current navbar-next";f.removeClass(e).addClass("page-current").removeAttr("aria-hidden"),h.removeClass(e).addClass("page-next").attr("aria-hidden","true"),p&&(a.removeClass(t).addClass("navbar-current").removeAttr("aria-hidden"),n.removeClass(t).addClass("navbar-next").attr("aria-hidden","true")),i.pageCallback("afterIn",f,a,"previous","current",u),i.pageCallback("afterOut",h,n,"current","next",u),i.params.stackPages&&0<=i.initialPages.indexOf(h[0])?(h.addClass("stacked"),h.trigger("page:stack"),d&&n.addClass("stacked")):(i.pageCallback("beforeRemove",h,n,"next",void 0,u),i.removePage(h),d&&n.length&&i.removeNavbar(n)),i.allowPageChange=!0,i.emit("routeChanged",i.currentRoute,i.previousRoute,i),("ios"===l.theme?i.params.preloadPreviousPage||i.params.iosSwipeBack:i.params.preloadPreviousPage)&&i.history[i.history.length-2]&&i.back(i.history[i.history.length-2],{preload:!0}),i.params.pushState&&History.clearRouterQueue()}return Device.ie||Device.edge||Device.firefox&&!Device.ios||i.params.pushState&&u.pushState&&(o?History.go(-o):History.back()),1===i.history.length&&i.history.unshift(i.url),i.history.pop(),i.saveHistory(),i.currentPageEl=f[0],p&&a.length?i.currentNavbarEl=a[0]:delete i.currentNavbarEl,i.currentRoute=u.route,(Device.ie||Device.edge||Device.firefox&&!Device.ios)&&i.params.pushState&&u.pushState&&(o?History.go(-o):History.back()),C(),u.route.route.tab&&i.tabLoad(u.route.route.tab,Utils.extend({},u,{history:!1,pushState:!1})),i.pageCallback("init",f,a,"previous","current",u,h),i.pageCallback("beforeIn",f,a,"previous","current",u),i.pageCallback("beforeOut",h,n,"current","next",u),u.animate?(g="page-previous page-current page-next",b="navbar-previous navbar-current navbar-next",h.removeClass(g).addClass("page-current"),f.removeClass(g).addClass("page-previous").removeAttr("aria-hidden"),p&&(n.removeClass(b).addClass("navbar-current"),a.removeClass(b).addClass("navbar-previous").removeAttr("aria-hidden")),i.animate(h,f,n,a,"backward",function(){x()})):x(),i}function loadBack(e,t,r){var a=this;if(!a.allowPageChange&&!r)return a;var n=e,o=t,i=n.url,s=n.content,l=n.el,c=n.pageName,u=n.template,p=n.templateUrl,d=n.component,f=n.componentUrl;if(o.route.url&&a.url===o.route.url&&!o.reloadCurrent&&!o.reloadPrevious&&!a.params.allowDuplicateUrls)return!1;function h(e,t){return a.backward(e,Utils.extend(o,t))}function v(){return a.allowPageChange=!0,a}if(!o.route&&i&&(o.route=a.parseRouteUrl(i)),(i||p||f)&&(a.allowPageChange=!1),s)a.backward(a.getPageEl(s),o);else if(u||p)try{a.pageTemplateLoader(u,p,o,h,v)}catch(e){throw a.allowPageChange=!0,e}else if(l)a.backward(a.getPageEl(l),o);else if(c)a.backward(a.$el.children('.page[data-name="'+c+'"]').eq(0),o);else if(d||f)try{a.pageComponentLoader(a.el,d,f,o,h,v)}catch(e){throw a.allowPageChange=!0,e}else i&&(a.xhr&&(a.xhr.abort(),a.xhr=!1),a.xhrRequest(i,o).then(function(e){a.backward(a.getPageEl(e),o)}).catch(function(){a.allowPageChange=!0}));return a}function back(){for(var e,t=[],r=arguments.length;r--;)t[r]=arguments[r];var a,n,o,i=this;if(i.swipeBackActive)return i;var s=(n="object"==typeof t[0]?t[0]||{}:(a=t[0],t[1]||{})).name,l=n.params,c=n.query;if(s){if(!(o=i.findRouteByKey("name",s)))throw new Error('Framework7: route with name "'+s+'" not found');if(a=i.constructRouteUrl(o,{params:l,query:c}))return i.back(a,Utils.extend({},n,{name:null,params:null,query:null}));throw new Error("Framework7: can't construct URL for route with name \""+s+'"')}var u=i.app;if(!i.view)return(e=u.views.main.router).back.apply(e,t),i;var p,d=i.currentRoute.modal;if(d||"popup popover sheet loginScreen actions customModal panel".split(" ").forEach(function(e){i.currentRoute.route[e]&&(d=!0,p=e)}),d){var f,h=i.currentRoute.modal||i.currentRoute.route.modalInstance||u[p].get(),v=i.history[i.history.length-2];if(h&&h.$el){var m=h.$el.prevAll(".modal-in");m.length&&m[0].f7Modal&&(f=m[0].f7Modal.route)}return f||(f=i.findMatchingRoute(v)),!f&&v&&(f={url:v,path:v.split("?")[0],query:Utils.parseUrlQuery(v),route:{path:v.split("?")[0],url:v}}),f&&h?(i.params.pushState&&!1!==n.pushState&&History.back(),i.currentRoute=f,i.history.pop(),i.saveHistory(),i.modalRemove(h),i):i}var g=i.$el.children(".page-current").prevAll(".page-previous").eq(0);if(!n.force&&0<g.length){if(i.params.pushState&&g[0].f7Page&&i.history[i.history.length-2]!==g[0].f7Page.route.url)return i.back(i.history[i.history.length-2],Utils.extend(n,{force:!0})),i;var b=g[0].f7Page.route;return processRouteQueue.call(i,b,i.currentRoute,function(){i.loadBack({el:g},Utils.extend(n,{route:b}))},function(){}),i}if("#"===a&&(a=void 0),a&&"/"!==a[0]&&0!==a.indexOf("#")&&(a=((i.path||"/")+a).replace("//","/")),!a&&1<i.history.length&&(a=i.history[i.history.length-2]),(o=i.findMatchingRoute(a))||a&&(o={url:a,path:a.split("?")[0],query:Utils.parseUrlQuery(a),route:{path:a.split("?")[0],url:a}}),!o)return i;if(o.route.redirect)return redirect.call(i,"back",o,n);var y,w={};if(o.route.options?Utils.extend(w,o.route.options,n):Utils.extend(w,n),w.route=o,w&&w.context&&(o.context=w.context,w.route.context=w.context),w.force&&i.params.stackPages&&(i.$el.children(".page-previous.stacked").each(function(e,t){t.f7Page&&t.f7Page.route&&t.f7Page.route.url===o.url&&(y=!0,i.loadBack({el:t},w))}),y))return i;function C(){var r=!1;o.route.keepAlive&&o.route.keepAliveData&&(i.loadBack({el:o.route.keepAliveData.pageEl},w),r=!0),"url content component pageName el componentUrl template templateUrl".split(" ").forEach(function(e){var t;o.route[e]&&!r&&(r=!0,i.loadBack(((t={})[e]=o.route[e],t),w))}),r||o.route.async&&(i.allowPageChange=!1,o.route.async.call(i,o,i.currentRoute,function(e,t){i.allowPageChange=!1,t&&t.context&&(o.context?o.context=Utils.extend({},o.context,t.context):o.context=t.context,w.route.context=o.context),i.loadBack(e,Utils.extend(w,t),!0)},function(){i.allowPageChange=!0}))}function x(){i.allowPageChange=!0}return w.preload?C():processRouteQueue.call(i,o,i.currentRoute,function(){o.route.modules?u.loadModules(Array.isArray(o.route.modules)?o.route.modules:[o.route.modules]).then(function(){C()}).catch(function(){x()}):C()},function(){x()}),i}function clearPreviousPages(){var n=this,o=n.app,i=n.separateNavbar,r=$(n.currentPageEl);n.$el.children(".page").filter(function(e,t){return t!==r[0]}).each(function(e,t){var r=$(t),a=$(o.navbar.getElByPage(r));n.params.stackPages&&0<=n.initialPages.indexOf(r[0])?(r.addClass("stacked"),i&&a.addClass("stacked")):(n.pageCallback("beforeRemove",r,a,"previous",void 0,{}),n.removePage(r),i&&a.length&&n.removeNavbar(a))})}function clearPreviousHistory(){var e=this,t=e.history[e.history.length-1];e.clearPreviousPages(),e.history=[t],e.view.history=[t],e.saveHistory()}var Router=function(o){function e(e,t){o.call(this,{},[void 0===t?e:t]);var r=this;r.isAppRouter=void 0===t,r.isAppRouter?Utils.extend(!1,r,{app:e,params:e.params.view,routes:e.routes||[],cache:e.cache}):Utils.extend(!1,r,{app:e,view:t,viewId:t.id,params:t.params,routes:t.routes,$el:t.$el,el:t.el,$navbarEl:t.$navbarEl,navbarEl:t.navbarEl,history:t.history,scrollHistory:t.scrollHistory,cache:e.cache,dynamicNavbar:"ios"===e.theme&&t.params.iosDynamicNavbar,separateNavbar:"ios"===e.theme&&t.params.iosDynamicNavbar&&t.params.iosSeparateDynamicNavbar,initialPages:[],initialNavbars:[]}),r.useModules(),r.tempDom=doc.createElement("div"),r.allowPageChange=!0;var a={},n={};return Object.defineProperty(r,"currentRoute",{enumerable:!0,configurable:!0,set:function(e){void 0===e&&(e={}),n=Utils.extend({},a),(a=e)&&(r.url=a.url,r.emit("routeChange",e,n,r))},get:function(){return a}}),Object.defineProperty(r,"previousRoute",{enumerable:!0,configurable:!0,get:function(){return n},set:function(e){n=e}}),r}return o&&(e.__proto__=o),((e.prototype=Object.create(o&&o.prototype)).constructor=e).prototype.animatableNavElements=function(r,a){var i,s,e=this.dynamicNavbar,l=this.params.iosAnimateNavbarBackIcon;function n(e,t){var r,a=$(e),n=a.hasClass("sliding")||t.hasClass("sliding"),o=a.hasClass("subnavbar"),i=!n||!o,s=n&&l&&a.hasClass("left")&&0<a.find(".back .icon").length;return s&&(r=a.find(".back .icon")),{$el:a,$iconEl:r,hasIcon:s,leftOffset:a[0].f7NavbarLeftOffset,rightOffset:a[0].f7NavbarRightOffset,isSliding:n,isSubnavbar:o,needsOpacityTransition:i}}return e&&(i=[],s=[],r.children(".left, .right, .title, .subnavbar").each(function(e,t){i.push(n(t,r))}),a.children(".left, .right, .title, .subnavbar").each(function(e,t){s.push(n(t,a))}),[s,i].forEach(function(o){o.forEach(function(e){var r=e,t=e.isSliding,a=e.$el,n=o===s?i:s;t&&a.hasClass("title")&&n&&n.forEach(function(e){if(e.$el.hasClass("left")&&e.hasIcon){var t=e.$el.find(".back span")[0];r.leftOffset+=t?t.offsetLeft:0}})})})),{newNavEls:i,oldNavEls:s}},e.prototype.animateWithCSS=function(e,t,r,a,n,o){var i,s,l=this,c=l.dynamicNavbar,u=l.separateNavbar,p="ios"===l.app.theme,d="router-transition-"+n+" router-transition-css-"+n,f=0;if(p&&c){u||(f=a[0].offsetWidth);var h=l.animatableNavElements(a,r);i=h.newNavEls,s=h.oldNavEls}function v(a){p&&c&&(i.forEach(function(e){var t=e.$el,r="forward"===n?e.rightOffset:e.leftOffset;e.isSliding&&t.transform("translate3d("+r*(1-a)+"px,0,0)"),e.hasIcon&&("forward"===n?e.$iconEl.transform("translate3d("+(-r-f)*(1-a)+"px,0,0)"):e.$iconEl.transform("translate3d("+(f/5-r)*(1-a)+"px,0,0)"))}),s.forEach(function(e){var t=e.$el,r="forward"===n?e.leftOffset:e.rightOffset;e.isSliding&&t.transform("translate3d("+r*a+"px,0,0)"),e.hasIcon&&("forward"===n?e.$iconEl.transform("translate3d("+(f/5-r)*a+"px,0,0)"):e.$iconEl.transform("translate3d("+(-r-f)*a+"px,0,0)"))}))}("forward"===n?t:e).animationEnd(function(){l.dynamicNavbar&&(a.hasClass("sliding")?a.find(".title, .left, .right, .left .icon, .subnavbar").transform(""):a.find(".sliding").transform(""),r.hasClass("sliding")?r.find(".title, .left, .right, .left .icon, .subnavbar").transform(""):r.find(".sliding").transform("")),l.$el.removeClass(d),o&&o()}),c?(v(0),Utils.nextFrame(function(){v(1),l.$el.addClass(d)})):l.$el.addClass(d)},e.prototype.animateWithJS=function(o,i,e,t,s,l){var c,u,p,d,f=this,h=f.dynamicNavbar,r=f.separateNavbar,v="ios"===f.app.theme,m=v?400:250,g="router-transition-"+s+" router-transition-js-"+s,b=null,y=!1,w=0;if(v&&h){r||(w=t[0].offsetWidth);var a=f.animatableNavElements(t,e);c=a.newNavEls,u=a.oldNavEls}v&&(p=$('<div class="page-shadow-effect"></div>'),d=$('<div class="page-opacity-effect"></div>'),"forward"===s?(i.append(p),o.append(d)):(i.append(d),o.append(p)));var C=Utils.bezier(.25,.1,.25,1);f.$el.addClass(g),Utils.requestAnimationFrame(function e(){var t=Utils.now();b||(b=t);var r=Math.max(Math.min((t-b)/m,1),0),a=C(r);1<=r&&(y=!0);var n=f.app.rtl?-1:1;if(v?(d[0].style.opacity="forward"===s?(i.transform("translate3d("+100*(1-a)*n+"%,0,0)"),o.transform("translate3d("+20*-a*n+"%,0,0)"),p[0].style.opacity=a):(i.transform("translate3d("+20*-(1-a)*n+"%,0,0)"),o.transform("translate3d("+100*a*n+"%,0,0)"),p[0].style.opacity=1-a,1-a),h&&(c.forEach(function(e){var t=e.$el,r="forward"===s?e.rightOffset:e.leftOffset;e.needsOpacityTransition&&(t[0].style.opacity=a),e.isSliding&&t.transform("translate3d("+r*(1-a)+"px,0,0)"),e.hasIcon&&("forward"===s?e.$iconEl.transform("translate3d("+(-r-w)*(1-a)+"px,0,0)"):e.$iconEl.transform("translate3d("+(w/5-r)*(1-a)+"px,0,0)"))}),u.forEach(function(e){var t=e.$el,r="forward"===s?e.leftOffset:e.rightOffset;e.needsOpacityTransition&&(t[0].style.opacity=1-a),e.isSliding&&t.transform("translate3d("+r*a+"px,0,0)"),e.hasIcon&&("forward"===s?e.$iconEl.transform("translate3d("+(w/5-r)*a+"px,0,0)"):e.$iconEl.transform("translate3d("+(-r-w)*a+"px,0,0)"))}))):"forward"===s?(i.transform("translate3d(0, "+56*(1-a)+"px,0)"),i.css("opacity",a)):(o.transform("translate3d(0, "+56*a+"px,0)"),o.css("opacity",1-a)),y)return i.transform("").css("opacity",""),o.transform("").css("opacity",""),v&&(p.remove(),d.remove(),h&&(c.forEach(function(e){e.$el.transform(""),e.$el.css("opacity","")}),u.forEach(function(e){e.$el.transform(""),e.$el.css("opacity","")}),c=[],u=[])),f.$el.removeClass(g),void(l&&l());Utils.requestAnimationFrame(e)})},e.prototype.animate=function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];var r=this;r.params.animateCustom?r.params.animateCustom.apply(r,e):r.params.animateWithJS?r.animateWithJS.apply(r,e):r.animateWithCSS.apply(r,e)},e.prototype.removeModal=function(e){this.removeEl(e)},e.prototype.removeTabContent=function(e){$(e).html("")},e.prototype.removeNavbar=function(e){this.removeEl(e)},e.prototype.removePage=function(e){var t=$(e),r=t&&t[0]&&t[0].f7Page;r&&r.route&&r.route.route&&r.route.route.keepAlive?t.remove():this.removeEl(e)},e.prototype.removeEl=function(e){if(e){var t=$(e);0!==t.length&&(t.find(".tab").each(function(e,t){$(t).children().each(function(e,t){t.f7Component&&($(t).trigger("tab:beforeremove"),t.f7Component.$destroy())})}),t[0].f7Component&&t[0].f7Component.$destroy&&t[0].f7Component.$destroy(),this.params.removeElements&&(this.params.removeElementsWithTimeout?setTimeout(function(){t.remove()},this.params.removeElementsTimeout):t.remove()))}},e.prototype.getPageEl=function(e){var t=this;if("string"==typeof e)t.tempDom.innerHTML=e;else{if($(e).hasClass("page"))return e;t.tempDom.innerHTML="",$(t.tempDom).append(e)}return t.findElement(".page",t.tempDom)},e.prototype.findElement=function(e,t,r){var a=this.view,n=this.app,o=$(t),i=e;r&&(i+=":not(.stacked)");var s=o.find(i).filter(function(e,t){return 0===$(t).parents(".popup, .dialog, .popover, .actions-modal, .sheet-modal, .login-screen, .page").length});return 1<s.length&&("string"==typeof a.selector&&(s=o.find(a.selector+" "+i)),1<s.length&&(s=o.find("."+n.params.viewMainClass+" "+i))),1===s.length?s:(r||(s=this.findElement(i,o,!0)),s&&1===s.length?s:s&&1<s.length?$(s[0]):void 0)},e.prototype.flattenRoutes=function(e){var n=this;void 0===e&&(e=this.routes);var o=[];return e.forEach(function(r){var e=!1;if("tabs"in r&&r.tabs){var t=r.tabs.map(function(e){var t=Utils.extend({},r,{path:(r.path+"/"+e.path).replace("///","/").replace("//","/"),parentPath:r.path,tab:e});return delete t.tabs,delete t.routes,t});e=!0,o=o.concat(n.flattenRoutes(t))}if("routes"in r){var a=r.routes.map(function(e){var t=Utils.extend({},e);return t.path=(r.path+"/"+t.path).replace("///","/").replace("//","/"),t});o=e?o.concat(n.flattenRoutes(a)):o.concat(r,n.flattenRoutes(a))}"routes"in r||"tabs"in r&&r.tabs||o.push(r)}),o},e.prototype.parseRouteUrl=function(e){if(!e)return{};var t=Utils.parseUrlQuery(e),r=e.split("#")[1],a=e.split("#")[0].split("?")[0];return{query:t,hash:r,params:{},url:e,path:a}},e.prototype.constructRouteUrl=function(e,t){void 0===t&&(t={});var r,a=t.params,n=t.query,o=e.path,i=pathToRegexp_1.compile(o);try{r=i(a||{})}catch(e){throw new Error("Framework7: error constructing route URL from passed params:\nRoute: "+o+"\n"+e.toString())}return n&&(r+="string"==typeof n?"?"+n:"?"+Utils.serializeObject(n)),r},e.prototype.findTabRoute=function(e){var t,r=$(e),a=this.currentRoute.route.parentPath,n=r.attr("id");return this.flattenRoutes(this.routes).forEach(function(e){e.parentPath===a&&e.tab&&e.tab.id===n&&(t=e)}),t},e.prototype.findRouteByKey=function(t,r){var a,e=this.routes;return this.flattenRoutes(e).forEach(function(e){a||e[t]===r&&(a=e)}),a},e.prototype.findMatchingRoute=function(o){if(o){var i,e=this.routes,t=this.flattenRoutes(e),r=this.parseRouteUrl(o),s=r.path,l=r.query,c=r.hash,u=r.params;return t.forEach(function(e){if(!i){var a,t,r=[],n=[e.path];if(e.alias&&("string"==typeof e.alias?n.push(e.alias):Array.isArray(e.alias)&&e.alias.forEach(function(e){n.push(e)})),n.forEach(function(e){a||(a=pathToRegexp_1(e,r).exec(s))}),a)r.forEach(function(e,t){if("number"!=typeof e.name){var r=a[t+1];u[e.name]=r}}),e.parentPath&&(t=s.split("/").slice(0,e.parentPath.split("/").length-1).join("/")),i={query:l,hash:c,params:u,url:o,path:s,parentPath:t,route:e,name:e.name}}}),i}},e.prototype.replaceRequestUrlParams=function(e,r){void 0===e&&(e=""),void 0===r&&(r={});var a=e;return"string"==typeof a&&0<=a.indexOf("{{")&&r&&r.route&&r.route.params&&Object.keys(r.route.params).length&&Object.keys(r.route.params).forEach(function(e){var t=new RegExp("{{"+e+"}}","g");a=a.replace(t,r.route.params[e]||"")}),a},e.prototype.removeFromXhrCache=function(e){for(var t=this.cache.xhr,r=!1,a=0;a<t.length;a+=1)t[a].url===e&&(r=a);!1!==r&&t.splice(r,1)},e.prototype.xhrRequest=function(e,n){var o=this,i=o.params,s=n.ignoreCache,l=e,t=0<=l.indexOf("?");return i.passRouteQueryToRequest&&n&&n.route&&n.route.query&&Object.keys(n.route.query).length&&(l+=(t?"&":"?")+Utils.serializeObject(n.route.query),t=!0),i.passRouteParamsToRequest&&n&&n.route&&n.route.params&&Object.keys(n.route.params).length&&(l+=(t?"&":"?")+Utils.serializeObject(n.route.params),t=!0),0<=l.indexOf("{{")&&(l=o.replaceRequestUrlParams(l,n)),i.xhrCacheIgnoreGetParameters&&0<=l.indexOf("?")&&(l=l.split("?")[0]),Utils.promise(function(r,a){if(i.xhrCache&&!s&&l.indexOf("nocache")<0&&i.xhrCacheIgnore.indexOf(l)<0)for(var e=0;e<o.cache.xhr.length;e+=1){var t=o.cache.xhr[e];if(t.url===l&&Utils.now()-t.time<i.xhrCacheDuration)return void r(t.content)}o.xhr=o.app.request({url:l,method:"GET",beforeSend:function(e){o.emit("routerAjaxStart",e,n)},complete:function(e,t){o.emit("routerAjaxComplete",e),"error"!==t&&"timeout"!==t&&200<=e.status&&e.status<300||0===e.status?(i.xhrCache&&""!==e.responseText&&(o.removeFromXhrCache(l),o.cache.xhr.push({url:l,time:Utils.now(),content:e.responseText})),o.emit("routerAjaxSuccess",e,n),r(e.responseText)):(o.emit("routerAjaxError",e,n),a(e))},error:function(e){o.emit("routerAjaxError",e,n),a(e)}})})},e.prototype.removeThemeElements=function(e){var t=this.app.theme;$(e).find("."+("md"===t?"ios":"md")+"-only, .if-"+("md"===t?"ios":"md")).remove()},e.prototype.templateLoader=function(e,t,a,n,o){var i=this;function r(e){var t,r;try{if("function"==typeof(r=a.context||{}))r=r.call(i);else if("string"==typeof r)try{r=JSON.parse(r)}catch(e){throw o(),e}t="function"==typeof e?e(r):Template7.compile(e)(Utils.extend({},r||{},{$app:i.app,$root:Utils.extend({},i.app.data,i.app.methods),$route:a.route,$router:i,$theme:{ios:"ios"===i.app.theme,md:"md"===i.app.theme}}))}catch(e){throw o(),e}n(t,{context:r})}t?(i.xhr&&(i.xhr.abort(),i.xhr=!1),i.xhrRequest(t,a).then(function(e){r(e)}).catch(function(){o()})):r(e)},e.prototype.modalTemplateLoader=function(e,t,r,a,n){return this.templateLoader(e,t,r,function(e){a(e)},n)},e.prototype.tabTemplateLoader=function(e,t,r,a,n){return this.templateLoader(e,t,r,function(e){a(e)},n)},e.prototype.pageTemplateLoader=function(e,t,r,a,n){var o=this;return o.templateLoader(e,t,r,function(e,t){void 0===t&&(t={}),a(o.getPageEl(e),t)},n)},e.prototype.componentLoader=function(e,t,n,o,i){void 0===n&&(n={});var r,s=this,l=s.app,a="string"==typeof e?e:t,c=s.replaceRequestUrlParams(a,n);function u(e){var t=n.context||{};if("function"==typeof t)t=t.call(s);else if("string"==typeof t)try{t=JSON.parse(t)}catch(e){throw i(),e}var r=Utils.merge({},t,{$route:n.route,$router:s,$theme:{ios:"ios"===l.theme,md:"md"===l.theme}}),a=l.component.create(e,r);o(a.el)}c&&s.cache.components.forEach(function(e){e.url===c&&(r=e.component)}),c&&r?u(r):c&&!r?(s.xhr&&(s.xhr.abort(),s.xhr=!1),s.xhrRequest(a,n).then(function(e){var t=l.component.parse(e);s.cache.components.push({url:c,component:t}),u(t)}).catch(function(e){throw i(),e})):u(e)},e.prototype.modalComponentLoader=function(e,t,r,a,n,o){this.componentLoader(t,r,a,function(e){n(e)},o)},e.prototype.tabComponentLoader=function(e,t,r,a,n,o){this.componentLoader(t,r,a,function(e){n(e)},o)},e.prototype.pageComponentLoader=function(e,t,r,a,n,o){this.componentLoader(t,r,a,function(e,t){void 0===t&&(t={}),n(e,t)},o)},e.prototype.getPageData=function(e,t,r,a,n,o){void 0===n&&(n={});var i,s,l=$(e),c=$(t),u=l[0].f7Page||{};if(("next"===r&&"current"===a||"current"===r&&"previous"===a)&&(i="forward"),("current"===r&&"next"===a||"previous"===r&&"current"===a)&&(i="backward"),u&&!u.fromPage){var p=$(o);p.length&&(s=p[0].f7Page)}(s=u.pageFrom||s)&&s.pageFrom&&(s.pageFrom=null);var d={app:this.app,view:this.view,router:this,$el:l,el:l[0],$pageEl:l,pageEl:l[0],$navbarEl:c,navbarEl:c[0],name:l.attr("data-name"),position:r,from:r,to:a,direction:i,route:u.route?u.route:n,pageFrom:s};return l[0].f7Page=d},e.prototype.pageCallback=function(e,t,r,a,n,o,i){if(void 0===o&&(o={}),t){var s=this,l=$(t);if(l.length){var c=o.route,u=s.params.restoreScrollTopOnBack,p=l[0].f7Page&&l[0].f7Page.route&&l[0].f7Page.route.route&&l[0].f7Page.route.route.keepAlive;"beforeRemove"===e&&p&&(e="beforeUnmount");var d="page"+(e[0].toUpperCase()+e.slice(1,e.length)),f="page:"+e.toLowerCase(),h={};(h="beforeRemove"===e&&l[0].f7Page?Utils.extend(l[0].f7Page,{from:a,to:n,position:a}):s.getPageData(t,r,a,n,c,i)).swipeBack=!!o.swipeBack;var v=o.route?o.route.route:{},m=v.on;void 0===m&&(m={});var g=v.once;if(void 0===g&&(g={}),o.on&&Utils.extend(m,o.on),o.once&&Utils.extend(g,o.once),"mounted"===e&&w(),"init"===e){if(u&&("previous"===a||!a)&&"current"===n&&s.scrollHistory[h.route.url]&&!l.hasClass("no-restore-scroll")){var b=l.find(".page-content");0<b.length&&(b=b.filter(function(e,t){return 0===$(t).parents(".tab:not(.tab-active)").length&&!$(t).is(".tab:not(.tab-active)")})),b.scrollTop(s.scrollHistory[h.route.url])}if(w(),l[0].f7PageInitialized)return l.trigger("page:reinit",h),void s.emit("pageReinit",h);l[0].f7PageInitialized=!0}if(u&&"beforeOut"===e&&"current"===a&&"previous"===n){var y=l.find(".page-content");0<y.length&&(y=y.filter(function(e,t){return 0===$(t).parents(".tab:not(.tab-active)").length&&!$(t).is(".tab:not(.tab-active)")})),s.scrollHistory[h.route.url]=y.scrollTop()}u&&"beforeOut"===e&&"current"===a&&"next"===n&&delete s.scrollHistory[h.route.url],l.trigger(f,h),s.emit(d,h),"beforeRemove"!==e&&"beforeUnmount"!==e||(l[0].f7RouteEventsAttached&&(l[0].f7RouteEventsOn&&Object.keys(l[0].f7RouteEventsOn).forEach(function(e){l.off(Utils.eventNameToColonCase(e),l[0].f7RouteEventsOn[e])}),l[0].f7RouteEventsOnce&&Object.keys(l[0].f7RouteEventsOnce).forEach(function(e){l.off(Utils.eventNameToColonCase(e),l[0].f7RouteEventsOnce[e])}),l[0].f7RouteEventsAttached=null,l[0].f7RouteEventsOn=null,l[0].f7RouteEventsOnce=null,delete l[0].f7RouteEventsAttached,delete l[0].f7RouteEventsOn,delete l[0].f7RouteEventsOnce),p||(l[0].f7Page&&l[0].f7Page.navbarEl&&delete l[0].f7Page.navbarEl.f7Page,l[0].f7Page=null))}}function w(){l[0].f7RouteEventsAttached||(l[0].f7RouteEventsAttached=!0,m&&0<Object.keys(m).length&&(l[0].f7RouteEventsOn=m,Object.keys(m).forEach(function(e){m[e]=m[e].bind(s),l.on(Utils.eventNameToColonCase(e),m[e])})),g&&0<Object.keys(g).length&&(l[0].f7RouteEventsOnce=g,Object.keys(g).forEach(function(e){g[e]=g[e].bind(s),l.once(Utils.eventNameToColonCase(e),g[e])})))}},e.prototype.saveHistory=function(){var e=this;e.view.history=e.history,e.params.pushState&&(win.localStorage["f7router-"+e.view.id+"-history"]=JSON.stringify(e.history))},e.prototype.restoreHistory=function(){var e=this;e.params.pushState&&win.localStorage["f7router-"+e.view.id+"-history"]&&(e.history=JSON.parse(win.localStorage["f7router-"+e.view.id+"-history"]),e.view.history=e.history)},e.prototype.clearHistory=function(){this.history=[],this.view&&(this.view.history=[]),this.saveHistory()},e.prototype.updateCurrentUrl=function(e){var t=this;t.history.length?t.history[t.history.length-1]=e:t.history.push(e);var r=t.parseRouteUrl(e),a=r.query,n=r.hash,o=r.params,i=r.url,s=r.path;if(t.currentRoute&&Utils.extend(t.currentRoute,{query:a,hash:n,params:o,url:i,path:s}),t.params.pushState){var l=t.params.pushStateRoot||"";History.replace(t.view.id,{url:e},l+t.params.pushStateSeparator+e)}t.saveHistory(),t.emit("routeUrlUpdate",t.currentRoute,t)},e.prototype.init=function(){var o=this,e=o.app,t=o.view;(t&&o.params.iosSwipeBack&&"ios"===e.theme||t&&o.params.mdSwipeBack&&"md"===e.theme)&&SwipeBack(o),o.dynamicNavbar&&!o.separateNavbar&&o.$el.addClass("router-dynamic-navbar-inside");var r,a,i,n=o.params.url,s=doc.location.href.split(doc.location.origin)[1],l=o.params,c=l.pushState,u=l.pushStateOnLoad,p=l.pushStateSeparator,d=l.pushStateAnimateOnLoad,f=o.params.pushStateRoot;(win.cordova&&c&&!p&&!f&&doc.location.pathname.indexOf("index.html")&&(console.warn("Framework7: wrong or not complete pushState configuration, trying to guess pushStateRoot"),f=doc.location.pathname.split("index.html")[0]),c&&u?(f&&0<=s.indexOf(f)&&""===(s=s.split(f)[1])&&(s="/"),n=0<p.length&&0<=s.indexOf(p)?s.split(p)[1]:s,o.restoreHistory(),0<=o.history.indexOf(n)?o.history=o.history.slice(0,o.history.indexOf(n)+1):o.params.url===n?o.history=[n]:History.state&&History.state[t.id]&&History.state[t.id].url===o.history[o.history.length-1]?n=o.history[o.history.length-1]:o.history=[s.split(p)[0]||"/",n],1<o.history.length?r=!0:o.history=[],o.saveHistory()):(n||(n=s),doc.location.search&&n.indexOf("?")<0&&(n+=doc.location.search),doc.location.hash&&n.indexOf("#")<0&&(n+=doc.location.hash)),1<o.history.length?(a=o.findMatchingRoute(o.history[0]))||(a=Utils.extend(o.parseRouteUrl(o.history[0]),{route:{url:o.history[0],path:o.history[0].split("?")[0]}})):(a=o.findMatchingRoute(n))||(a=Utils.extend(o.parseRouteUrl(n),{route:{url:n,path:n.split("?")[0]}})),o.params.stackPages&&o.$el.children(".page").each(function(e,t){var r=$(t);o.initialPages.push(r[0]),o.separateNavbar&&0<r.children(".navbar").length&&o.initialNavbars.push(r.children(".navbar").find(".navbar-inner")[0])}),0===o.$el.children(".page:not(.stacked)").length&&n)?o.navigate(n,{initial:!0,reloadCurrent:!0,pushState:!1}):(o.currentRoute=a,o.$el.children(".page:not(.stacked)").each(function(e,t){var r,a=$(t);a.addClass("page-current"),o.separateNavbar&&(0<(r=a.children(".navbar").children(".navbar-inner")).length?(o.$navbarEl.parents(doc).length||o.$el.prepend(o.$navbarEl),o.$navbarEl.append(r),a.children(".navbar").remove()):o.$navbarEl.addClass("navbar-hidden"));var n={route:o.currentRoute};o.currentRoute&&o.currentRoute.route&&o.currentRoute.route.options&&Utils.extend(n,o.currentRoute.route.options),o.currentPageEl=a[0],o.dynamicNavbar&&r.length&&(o.currentNavbarEl=r[0]),o.removeThemeElements(a),o.dynamicNavbar&&r.length&&o.removeThemeElements(r),n.route.route.tab&&(i=!0,o.tabLoad(n.route.route.tab,Utils.extend({},n))),o.pageCallback("init",a,r,"current",void 0,n)}),r&&o.navigate(n,{initial:!0,pushState:!1,history:!1,animate:d,once:{pageAfterIn:function(){2<o.history.length&&o.back({preload:!0})}}}),r||i||(o.history.push(n),o.saveHistory()));!(n&&c&&u)||History.state&&History.state[t.id]||History.initViewState(t.id,{url:n}),o.emit("local::init routerInit",o)},e.prototype.destroy=function(){var t=this;t.emit("local::destroy routerDestroy",t),Object.keys(t).forEach(function(e){t[e]=null,delete t[e]}),t=null},e}(Framework7Class);Router.prototype.forward=forward,Router.prototype.load=load,Router.prototype.navigate=navigate,Router.prototype.refreshPage=refreshPage,Router.prototype.tabLoad=tabLoad,Router.prototype.tabRemove=tabRemove,Router.prototype.modalLoad=modalLoad,Router.prototype.modalRemove=modalRemove,Router.prototype.backward=backward,Router.prototype.loadBack=loadBack,Router.prototype.back=back,Router.prototype.clearPreviousPages=clearPreviousPages,Router.prototype.clearPreviousHistory=clearPreviousHistory;var Router$1={name:"router",static:{Router:Router},instance:{cache:{xhr:[],templates:[],components:[]}},create:function(){var e=this;e.app?e.params.router&&(e.router=new Router(e.app,e)):e.router=new Router(e)}},View=function(c){function e(e,t,r){void 0===r&&(r={}),c.call(this,r,[e]);var a,n,o,i=e,s=$(t),l=this;return l.params=Utils.extend({routes:[],routesAdd:[]},i.params.view,r),0<l.params.routes.length?l.routes=l.params.routes:l.routes=[].concat(i.routes,l.params.routesAdd),a="string"==typeof t?t:(s.attr("id")?"#"+s.attr("id"):"")+(s.attr("class")?"."+s.attr("class").replace(/ /g,".").replace(".active",""):""),"ios"===i.theme&&l.params.iosDynamicNavbar&&l.params.iosSeparateDynamicNavbar&&0===(n=s.children(".navbar").eq(0)).length&&(n=$('<div class="navbar"></div>')),Utils.extend(!1,l,{app:i,$el:s,el:s[0],name:l.params.name,main:l.params.main||s.hasClass("view-main"),$navbarEl:n,navbarEl:n?n[0]:void 0,selector:a,history:[],scrollHistory:{}}),(s[0].f7View=l).useModules(),i.views.push(l),l.main&&(i.views.main=l),l.name&&(i.views[l.name]=l),l.index=i.views.indexOf(l),o=l.name?"view_"+l.name:l.main?"view_main":"view_"+l.index,l.id=o,i.initialized?l.init():i.on("init",function(){l.init()}),l}return c&&(e.__proto__=c),((e.prototype=Object.create(c&&c.prototype)).constructor=e).prototype.destroy=function(){var t=this,e=t.app;t.$el.trigger("view:beforedestroy",t),t.emit("local::beforeDestroy viewBeforeDestroy",t),t.main?(e.views.main=null,delete e.views.main):t.name&&(e.views[t.name]=null,delete e.views[t.name]),t.$el[0].f7View=null,delete t.$el[0].f7View,e.views.splice(e.views.indexOf(t),1),t.params.router&&t.router&&t.router.destroy(),t.emit("local::destroy viewDestroy",t),Object.keys(t).forEach(function(e){t[e]=null,delete t[e]}),t=null},e.prototype.init=function(){var e=this;e.params.router&&(e.router.init(),e.$el.trigger("view:init",e),e.emit("local::init viewInit",e))},e}(Framework7Class);function initClicks(c){if(c.on("click",function(e){var a=$(e.target),t=a.closest("a"),r=0<t.length,n=r&&t.attr("href"),o=r&&t.hasClass("tab-link")&&(t.attr("data-tab")||n&&0===n.indexOf("#"));if(r&&(t.is(c.params.clicks.externalLinks)||n&&0<=n.indexOf("javascript:"))){var i=t.attr("target");n&&win.cordova&&win.cordova.InAppBrowser&&("_system"===i||"_blank"===i)&&(e.preventDefault(),win.cordova.InAppBrowser.open(n,i))}else{Object.keys(c.modules).forEach(function(e){var r=c.modules[e].clicks;r&&Object.keys(r).forEach(function(e){var t=a.closest(e).eq(0);0<t.length&&r[e].call(c,t,t.dataset())})});var s={};if(r&&(e.preventDefault(),s=t.dataset()),n&&0<n.length&&"#"!==n&&!o||t.hasClass("back")){var l;if(s.view?l=$(s.view)[0].f7View:(l=a.parents(".view")[0]&&a.parents(".view")[0].f7View,!t.hasClass("back")&&l&&l.params.linksView&&("string"==typeof l.params.linksView?l=$(l.params.linksView)[0].f7View:l.params.linksView instanceof View&&(l=l.params.linksView))),l||c.views.main&&(l=c.views.main),!l||!l.router)return;if(s.context&&"string"==typeof s.context)try{s.context=JSON.parse(s.context)}catch(e){}t[0].f7RouteProps&&(s.props=t[0].f7RouteProps),t.hasClass("back")?l.router.back(n,s):l.router.navigate(n,s)}}}),Support.touch&&!Device.android){var e=!!Support.passiveListener&&{passive:!1,capture:!1};$(doc).on(c.params.touch.fastClicks?"touchstart":"touchmove",".panel-backdrop, .dialog-backdrop, .preloader-backdrop, .popup-backdrop, .searchbar-backdrop",function(e){e.preventDefault()},e)}}View.use(Router$1);var ClicksModule={name:"clicks",params:{clicks:{externalLinks:".external"}},on:{init:function(){initClicks(this)}}},HistoryModule={name:"history",static:{history:History},on:{init:function(){History.init(this)}}},keyPrefix="f7storage-",Storage={get:function(r){return Utils.promise(function(e,t){try{e(JSON.parse(win.localStorage.getItem(""+keyPrefix+r)))}catch(e){t(e)}})},set:function(r,a){return Utils.promise(function(e,t){try{win.localStorage.setItem(""+keyPrefix+r,JSON.stringify(a)),e()}catch(e){t(e)}})},remove:function(r){return Utils.promise(function(e,t){try{win.localStorage.removeItem(""+keyPrefix+r),e()}catch(e){t(e)}})},clear:function(){},length:function(){},keys:function(){return Utils.promise(function(e,t){try{e(Object.keys(win.localStorage).filter(function(e){return 0===e.indexOf(keyPrefix)}).map(function(e){return e.replace(keyPrefix,"")}))}catch(e){t(e)}})},forEach:function(a){return Utils.promise(function(e,t){try{Object.keys(win.localStorage).filter(function(e){return 0===e.indexOf(keyPrefix)}).forEach(function(e,t){var r=e.replace(keyPrefix,"");Storage.get(r).then(function(e){a(r,e,t)})}),e()}catch(e){t(e)}})}},StorageModule={name:"storage",static:{Storage:Storage,storage:Storage}};function vnode(e,t,r,a,n){return{sel:e,data:t,children:r,text:a,elm:n,key:void 0===t?void 0:t.key}}var array=Array.isArray;function primitive(e){return"string"==typeof e||"number"==typeof e}function addNS(e,t,r){if(e.ns="http://www.w3.org/2000/svg","foreignObject"!==r&&void 0!==t)for(var a=0;a<t.length;++a){var n=t[a].data;void 0!==n&&addNS(n,t[a].children,t[a].sel)}}function h(e,t,r){var a,n,o,i={};if(void 0!==r?(i=t,array(r)?a=r:primitive(r)?n=r:r&&r.sel&&(a=[r])):void 0!==t&&(array(t)?a=t:primitive(t)?n=t:t&&t.sel?a=[t]:i=t),array(a))for(o=0;o<a.length;++o)primitive(a[o])&&(a[o]=vnode(void 0,void 0,void 0,a[o],void 0));return"s"!==e[0]||"v"!==e[1]||"g"!==e[2]||3!==e.length&&"."!==e[3]&&"#"!==e[3]||addNS(i,a,e),vnode(e,i,a,n,void 0)}var selfClosing="area base br col command embed hr img input keygen link menuitem meta param source track wbr".split(" "),propsAttrs="hidden checked disabled readonly selected autocomplete autofocus autoplay required multiple value".split(" "),booleanProps="hidden checked disabled readonly selected autocomplete autofocus autoplay required multiple readOnly".split(" "),tempDom=doc.createElement("div");function getHooks(e,t,r,a){var n={};if(!e||!e.attrs||!e.attrs.class)return n;var o=e.attrs.class,i=[],s=[],l=[],c=[];return o.split(" ").forEach(function(e){r||i.push.apply(i,t.getVnodeHooks("insert",e)),s.push.apply(s,t.getVnodeHooks("destroy",e)),l.push.apply(l,t.getVnodeHooks("update",e)),c.push.apply(c,t.getVnodeHooks("postpatch",e))}),a&&!r&&c.push(function(e,t){var r=t||e;r&&r.data&&r.data.context&&r.data.context.$options.updated&&r.data.context.$options.updated()}),0===i.length&&0===s.length&&0===l.length&&0===c.length||(i.length&&(n.insert=function(t){i.forEach(function(e){return e(t)})}),s.length&&(n.destroy=function(t){s.forEach(function(e){return e(t)})}),l.length&&(n.update=function(t,r){l.forEach(function(e){return e(t,r)})}),c.length&&(n.postpatch=function(t,r){c.forEach(function(e){return e(t,r)})})),n}function getEventHandler(a,n,e){void 0===e&&(e={});var r,o,i=e.stop,s=e.prevent,l=e.once,c=!1,u=[],p=!0;if(0<=(r=a.indexOf("(")<0?a:a.split("(")[0]).indexOf("."))r.split(".").forEach(function(e,t){if(0!==t||"this"!==e){if(0===t&&"window"===e)return o=win,void(p=!1);if(o||(o=n),!o[e])throw new Error("Framework7: Component doesn't have method \""+r.split(".").slice(0,t+1).join(".")+'"');o=o[e]}});else{if(!n[r])throw new Error("Framework7: Component doesn't have method \""+r+'"');o=n[r]}return p&&(o=o.bind(n)),function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];var r=e[0];l&&c||(i&&r.stopPropagation(),s&&r.preventDefault(),c=!0,a.indexOf("(")<0?u=e:a.split("(")[1].split(")")[0].split(",").forEach(function(e){var t=e.trim();if(isNaN(t))if("true"===t)t=!0;else if("false"===t)t=!1;else if("null"===t)t=null;else if("undefined"===t)t=void 0;else if('"'===t[0])t=t.replace(/"/g,"");else if("'"===t[0])t=t.replace(/'/g,"");else if(0<t.indexOf(".")){var r;t.split(".").forEach(function(e){r||(r=n),r=r[e]}),t=r}else t=n[t];else t=parseFloat(t);u.push(t)}),o.apply(void 0,u))}}function getData(e,s,t,r,l){var c={context:s},a=e.attributes;Array.prototype.forEach.call(a,function(e){var t=e.name,r=e.value;if(0<=propsAttrs.indexOf(t))c.props||(c.props={}),"readonly"===t&&(t="readOnly"),0<=booleanProps.indexOf(t)?c.props[t]=!1!==r:c.props[t]=r;else if("key"===t)c.key=r;else if(0===t.indexOf("@")){c.on||(c.on={});var a=t.substr(1),n=!1,o=!1,i=!1;0<=a.indexOf(".")&&a.split(".").forEach(function(e,t){0===t?a=e:("stop"===e&&(n=!0),"prevent"===e&&(o=!0),"once"===e&&(i=!0))}),c.on[a]=getEventHandler(r,s,{stop:n,prevent:o,once:i})}else if("style"===t)if(0<=r.indexOf("{")&&0<=r.indexOf("}"))try{c.style=JSON.parse(r)}catch(e){c.attrs||(c.attrs={}),c.attrs.style=r}else c.attrs||(c.attrs={}),c.attrs.style=r;else c.attrs||(c.attrs={}),c.attrs[t]=r,"id"!==t||c.key||l||(c.key=r)});var n=getHooks(c,t,r,l);return n.prepatch=function(t,r){t&&r&&t&&t.data&&t.data.props&&Object.keys(t.data.props).forEach(function(e){booleanProps.indexOf(e)<0||(r.data||(r.data={}),r.data.props||(r.data.props={}),!0!==t.data.props[e]||e in r.data.props||(r.data.props[e]=!1))})},n&&(c.hook=n),c}function getChildren(e,t,r,a){for(var n=[],o=e.childNodes,i=0;i<o.length;i+=1){var s=elementToVNode(o[i],t,r,a);s&&n.push(s)}return n}function elementToVNode(e,t,r,a,n){if(1!==e.nodeType)return 3===e.nodeType?e.textContent:null;var o=e.nodeName.toLowerCase();return h(o,getData(e,t,r,a,n),0<=selfClosing.indexOf(o)?[]:getChildren(e,t,r,a))}function vdom(e,t,r,a){var n;void 0===e&&(e=""),tempDom.innerHTML=e.trim();for(var o=0;o<tempDom.childNodes.length;o+=1)n||1!==tempDom.childNodes[o].nodeType||(n=tempDom.childNodes[o]);var i=elementToVNode(n,t,r,a,!0);return tempDom.innerHTML="",i}function createElement(e){return document.createElement(e)}function createElementNS(e,t){return document.createElementNS(e,t)}function createTextNode(e){return document.createTextNode(e)}function createComment(e){return document.createComment(e)}function insertBefore$1(e,t,r){e.insertBefore(t,r)}function removeChild(e,t){e&&e.removeChild(t)}function appendChild(e,t){e.appendChild(t)}function parentNode(e){return e.parentNode}function nextSibling(e){return e.nextSibling}function tagName(e){return e.tagName}function setTextContent(e,t){e.textContent=t}function getTextContent(e){return e.textContent}function isElement(e){return 1===e.nodeType}function isText(e){return 3===e.nodeType}function isComment(e){return 8===e.nodeType}var htmlDomApi={createElement:createElement,createElementNS:createElementNS,createTextNode:createTextNode,createComment:createComment,insertBefore:insertBefore$1,removeChild:removeChild,appendChild:appendChild,parentNode:parentNode,nextSibling:nextSibling,tagName:tagName,setTextContent:setTextContent,getTextContent:getTextContent,isElement:isElement,isText:isText,isComment:isComment};function isUndef(e){return void 0===e}function isDef(e){return void 0!==e}var emptyNode=vnode("",{},[],void 0,void 0);function sameVnode(e,t){return e.key===t.key&&e.sel===t.sel}function isVnode(e){return void 0!==e.sel}function createKeyToOldIdx(e,t,r){var a,n,o,i={};for(a=t;a<=r;++a)null!=(o=e[a])&&void 0!==(n=o.key)&&(i[n]=a);return i}var hooks=["create","update","remove","destroy","pre","post"];function init$1(e,t){var r,a,f={},v=void 0!==t?t:htmlDomApi;for(r=0;r<hooks.length;++r)for(f[hooks[r]]=[],a=0;a<e.length;++a){var n=e[a][hooks[r]];void 0!==n&&f[hooks[r]].push(n)}function l(t,r){return function(){if(0==--r){var e=v.parentNode(t);v.removeChild(e,t)}}}function m(e,t){var r,a=e.data;void 0!==a&&isDef(r=a.hook)&&isDef(r=r.init)&&(r(e),a=e.data);var n=e.children,o=e.sel;if("!"===o)isUndef(e.text)&&(e.text=""),e.elm=v.createComment(e.text);else if(void 0!==o){var i=o.indexOf("#"),s=o.indexOf(".",i),l=0<i?i:o.length,c=0<s?s:o.length,u=-1!==i||-1!==s?o.slice(0,Math.min(l,c)):o,p=e.elm=isDef(a)&&isDef(r=a.ns)?v.createElementNS(r,u):v.createElement(u);for(l<c&&p.setAttribute("id",o.slice(l+1,c)),0<s&&p.setAttribute("class",o.slice(c+1).replace(/\./g," ")),r=0;r<f.create.length;++r)f.create[r](emptyNode,e);if(array(n))for(r=0;r<n.length;++r){var d=n[r];null!=d&&v.appendChild(p,m(d,t))}else primitive(e.text)&&v.appendChild(p,v.createTextNode(e.text));isDef(r=e.data.hook)&&(r.create&&r.create(emptyNode,e),r.insert&&t.push(e))}else e.elm=v.createTextNode(e.text);return e.elm}function g(e,t,r,a,n,o){for(;a<=n;++a){var i=r[a];null!=i&&v.insertBefore(e,m(i,o),t)}}function c(e){var t,r,a=e.data;if(void 0!==a){for(isDef(t=a.hook)&&isDef(t=t.destroy)&&t(e),t=0;t<f.destroy.length;++t)f.destroy[t](e);if(void 0!==e.children)for(r=0;r<e.children.length;++r)null!=(t=e.children[r])&&"string"!=typeof t&&c(t)}}function b(e,t,r,a){for(;r<=a;++r){var n=void 0,o=void 0,i=void 0,s=t[r];if(null!=s)if(isDef(s.sel)){for(c(s),o=f.remove.length+1,i=l(s.elm,o),n=0;n<f.remove.length;++n)f.remove[n](s,i);isDef(n=s.data)&&isDef(n=n.hook)&&isDef(n=n.remove)?n(s,i):i()}else v.removeChild(e,s.elm)}}function y(e,t,r){var a,n;isDef(a=t.data)&&isDef(n=a.hook)&&isDef(a=n.prepatch)&&a(e,t);var o=t.elm=e.elm,i=e.children,s=t.children;if(e!==t){if(void 0!==t.data){for(a=0;a<f.update.length;++a)f.update[a](e,t);isDef(a=t.data.hook)&&isDef(a=a.update)&&a(e,t)}isUndef(t.text)?isDef(i)&&isDef(s)?i!==s&&function(e,t,r,a){for(var n,o,i,s=0,l=0,c=t.length-1,u=t[0],p=t[c],d=r.length-1,f=r[0],h=r[d];s<=c&&l<=d;)null==u?u=t[++s]:null==p?p=t[--c]:null==f?f=r[++l]:null==h?h=r[--d]:sameVnode(u,f)?(y(u,f,a),u=t[++s],f=r[++l]):sameVnode(p,h)?(y(p,h,a),p=t[--c],h=r[--d]):sameVnode(u,h)?(y(u,h,a),v.insertBefore(e,u.elm,v.nextSibling(p.elm)),u=t[++s],h=r[--d]):(sameVnode(p,f)?(y(p,f,a),v.insertBefore(e,p.elm,u.elm),p=t[--c]):(void 0===n&&(n=createKeyToOldIdx(t,s,c)),isUndef(o=n[f.key])?v.insertBefore(e,m(f,a),u.elm):(i=t[o]).sel!==f.sel?v.insertBefore(e,m(f,a),u.elm):(y(i,f,a),t[o]=void 0,v.insertBefore(e,i.elm,u.elm))),f=r[++l]);(s<=c||l<=d)&&(c<s?g(e,null==r[d+1]?null:r[d+1].elm,r,l,d,a):b(e,t,s,c))}(o,i,s,r):isDef(s)?(isDef(e.text)&&v.setTextContent(o,""),g(o,null,s,0,s.length-1,r)):isDef(i)?b(o,i,0,i.length-1):isDef(e.text)&&v.setTextContent(o,""):e.text!==t.text&&v.setTextContent(o,t.text),isDef(n)&&isDef(a=n.postpatch)&&a(e,t)}}return function(e,t){var r,a,n,o,i,s,l=[];for(r=0;r<f.pre.length;++r)f.pre[r]();for(isVnode(e)||(i=(o=e).id?"#"+o.id:"",s=o.className?"."+o.className.split(" ").join("."):"",e=vnode(v.tagName(o).toLowerCase()+i+s,{},[],void 0,o)),sameVnode(e,t)?y(e,t,l):(a=e.elm,n=v.parentNode(a),m(t,l),null!==n&&(v.insertBefore(n,t.elm,v.nextSibling(a)),b(n,[e],0,0))),r=0;r<l.length;++r)l[r].data.hook.insert(l[r]);for(r=0;r<f.post.length;++r)f.post[r]();return t}}var xlinkNS="http://www.w3.org/1999/xlink",xmlNS="http://www.w3.org/XML/1998/namespace",colonChar=58,xChar=120;function updateAttrs(e,t){var r,a=t.elm,n=e.data.attrs,o=t.data.attrs;if((n||o)&&n!==o){for(r in n=n||{},o=o||{}){var i=o[r];n[r]!==i&&(!0===i?a.setAttribute(r,""):!1===i?a.removeAttribute(r):r.charCodeAt(0)!==xChar?a.setAttribute(r,i):r.charCodeAt(3)===colonChar?a.setAttributeNS(xmlNS,r,i):r.charCodeAt(5)===colonChar?a.setAttributeNS(xlinkNS,r,i):a.setAttribute(r,i))}for(r in n)r in o||a.removeAttribute(r)}}var attributesModule={create:updateAttrs,update:updateAttrs};function updateProps(e,t){var r,a,n=t.elm,o=e.data.props,i=t.data.props;if((o||i)&&o!==i){for(r in i=i||{},o=o||{})i[r]||delete n[r];for(r in i)a=i[r],o[r]===a||"value"===r&&n[r]===a||(n[r]=a)}}var propsModule={create:updateProps,update:updateProps},raf="undefined"!=typeof window&&window.requestAnimationFrame||setTimeout,nextFrame=function(e){raf(function(){raf(e)})};function setNextFrame(e,t,r){nextFrame(function(){e[t]=r})}function updateStyle(e,t){var r,a,n=t.elm,o=e.data.style,i=t.data.style;if((o||i)&&o!==i){i=i||{};var s="delayed"in(o=o||{});for(a in o)i[a]||("-"===a[0]&&"-"===a[1]?n.style.removeProperty(a):n.style[a]="");for(a in i)if(r=i[a],"delayed"===a&&i.delayed)for(var l in i.delayed)r=i.delayed[l],s&&r===o.delayed[l]||setNextFrame(n.style,l,r);else"remove"!==a&&r!==o[a]&&("-"===a[0]&&"-"===a[1]?n.style.setProperty(a,r):n.style[a]=r)}}function applyDestroyStyle(e){var t,r,a=e.elm,n=e.data.style;if(n&&(t=n.destroy))for(r in t)a.style[r]=t[r]}function applyRemoveStyle(e,t){var r=e.data.style;if(r&&r.remove){var a,n=e.elm,o=0,i=r.remove,s=0,l=[];for(a in i)l.push(a),n.style[a]=i[a];for(var c=getComputedStyle(n)["transition-property"].split(", ");o<c.length;++o)-1!==l.indexOf(c[o])&&s++;n.addEventListener("transitionend",function(e){e.target===n&&--s,0===s&&t()})}else t()}var styleModule={create:updateStyle,update:updateStyle,destroy:applyDestroyStyle,remove:applyRemoveStyle};function invokeHandler(e,t,r){"function"==typeof e&&e.apply(void 0,[t].concat(r))}function handleEvent(e,t,r){var a=e.type,n=r.data.on;n&&n[a]&&invokeHandler(n[a],e,t,r)}function createListener(){return function e(t){for(var r=[],a=arguments.length-1;0<a--;)r[a]=arguments[a+1];handleEvent(t,r,e.vnode)}}function updateEvents(e,t){var r=e.data.on,a=e.listener,n=e.elm,o=t&&t.data.on,i=t&&t.elm;if(r!==o&&(r&&a&&(o?Object.keys(r).forEach(function(e){o[e]||$(n).off(e,a)}):Object.keys(r).forEach(function(e){$(n).off(e,a)})),o)){var s=e.listener||createListener();(t.listener=s).vnode=t,r?Object.keys(o).forEach(function(e){r[e]||$(i).on(e,s)}):Object.keys(o).forEach(function(e){$(i).on(e,s)})}}var eventListenersModule={create:updateEvents,update:updateEvents,destroy:updateEvents},patch=init$1([attributesModule,propsModule,styleModule,eventListenersModule]),Framework7Component=function(a,e,t){void 0===t&&(t={});var r=Utils.id(),n=Utils.merge(this,t,{$:$,$$:$,$dom7:$,$app:a,$options:Utils.extend({id:r},e)}),o=n.$options;Object.defineProperty(n,"$root",{enumerable:!0,configurable:!0,get:function(){var e=Utils.merge({},a.data,a.methods);return win&&win.Proxy&&(e=new win.Proxy(e,{set:function(e,t,r){a.data[t]=r},deleteProperty:function(e,t){delete a.data[t],delete a.methods[t]},has:function(e,t){return t in a.data||t in a.methods}})),e},set:function(){}}),"beforeCreate created beforeMount mounted beforeDestroy destroyed updated".split(" ").forEach(function(e){o[e]&&(o[e]=o[e].bind(n))}),o.data&&(o.data=o.data.bind(n),Utils.extend(n,o.data())),o.render&&(o.render=o.render.bind(n)),o.methods&&Object.keys(o.methods).forEach(function(e){n[e]=o.methods[e].bind(n)}),o.on&&Object.keys(o.on).forEach(function(e){o.on[e]=o.on[e].bind(n)}),o.once&&Object.keys(o.once).forEach(function(e){o.once[e]=o.once[e].bind(n)}),o.beforeCreate&&o.beforeCreate();var i=n.$render();return i&&"string"==typeof i?(i=i.trim(),n.$vnode=vdom(i,n,a,!0),n.el=doc.createElement("div"),patch(n.el,n.$vnode)):i&&(n.el=i),n.$el=$(n.el),o.style&&(n.$styleEl=doc.createElement("style"),n.$styleEl.innerHTML=o.style,o.styleScoped&&n.el.setAttribute("data-f7-"+o.id,"")),n.$attachEvents(),o.created&&o.created(),n.el.f7Component=n};function parseComponent(e){var t,r=Utils.id(),a="f7_component_create_callback_"+r,n="f7_component_render_callback_"+r,o=e.match(/<template([ ]?)([a-z0-9-]*)>/),i=o[2]||"t7";o&&(t=e.split(/<template[ ]?[a-z0-9-]*>/).filter(function(e,t){return 0<t}).join("<template>").split("</template>").filter(function(e,t,r){return t<r.length-1}).join("</template>").replace(/{{#raw}}([ \n]*)<template/g,"{{#raw}}<template").replace(/\/template>([ \n]*){{\/raw}}/g,"/template>{{/raw}}").replace(/([ \n])<template/g,"$1{{#raw}}<template").replace(/\/template>([ \n])/g,"/template>{{/raw}}$1"));var s,l,c=null,u=!1;if(0<=e.indexOf("<style>")?c=e.split("<style>")[1].split("</style>")[0]:0<=e.indexOf("<style scoped>")&&(u=!0,c=(c=e.split("<style scoped>")[1].split("</style>")[0]).split("\n").map(function(e){return 0===e.trim().indexOf("@")?e:0<=e.indexOf("{")?0<=e.indexOf("{{this}}")?e.replace("{{this}}","[data-f7-"+r+"]"):"[data-f7-"+r+"] "+e.trim():e}).join("\n")),0<=e.indexOf("<script>")){var p=e.split("<script>");s=p[p.length-1].split("<\/script>")[0].trim()}else s="return {}";s&&s.trim()||(s="return {}"),s="window."+a+" = function () {"+s+"}",(l=doc.createElement("script")).innerHTML=s,$("head").append(l);var d=win[a]();if($(l).remove(),win[a]=null,delete win[a],d.template||d.render||(d.template=t,d.templateType=i),d.template&&("t7"===d.templateType&&(d.template=Template7.compile(d.template)),"es"===d.templateType)){var f="window."+n+" = function () {\n        return function render() {\n          return `"+d.template+"`;\n        }\n      }";(l=doc.createElement("script")).innerHTML=f,$("head").append(l),d.render=win[n](),$(l).remove(),win[n]=null,delete win[n]}return c&&(d.style=c,d.styleScoped=u),d.id=r,d}Framework7Component.prototype.$attachEvents=function(){var t=this.$options,r=this.$el;t.on&&Object.keys(t.on).forEach(function(e){r.on(Utils.eventNameToColonCase(e),t.on[e])}),t.once&&Object.keys(t.once).forEach(function(e){r.once(Utils.eventNameToColonCase(e),t.once[e])})},Framework7Component.prototype.$detachEvents=function(){var t=this.$options,r=this.$el;t.on&&Object.keys(t.on).forEach(function(e){r.off(Utils.eventNameToColonCase(e),t.on[e])}),t.once&&Object.keys(t.once).forEach(function(e){r.off(Utils.eventNameToColonCase(e),t.once[e])})},Framework7Component.prototype.$render=function(){var e=this.$options,t="";if(e.render)t=e.render();else if(e.template)if("string"==typeof e.template)try{t=Template7.compile(e.template)(this)}catch(e){throw e}else t=e.template(this);return t},Framework7Component.prototype.$forceUpdate=function(){var e=this,t=e.$render();if(t&&"string"==typeof t){var r=vdom(t=t.trim(),e,e.$app);e.$vnode=patch(e.$vnode,r)}},Framework7Component.prototype.$setState=function(e){Utils.merge(this,e),this.$forceUpdate()},Framework7Component.prototype.$mount=function(e){var t=this;t.$options.beforeMount&&t.$options.beforeMount(),t.$styleEl&&$("head").append(t.$styleEl),e&&e(t.el),t.$options.mounted&&t.$options.mounted()},Framework7Component.prototype.$destroy=function(){var e=this;e.$options.beforeDestroy&&e.$options.beforeDestroy(),e.$styleEl&&$(e.$styleEl).remove(),e.$detachEvents(),e.$options.destroyed&&e.$options.destroyed(),e.el&&e.el.f7Component&&(e.el.f7Component=null,delete e.el.f7Component),e.$vnode&&(e.$vnode=patch(e.$vnode,{sel:e.$vnode.sel,data:{}})),Utils.deleteProps(e)};var ComponentModule={name:"component",create:function(){var r=this;r.component={parse:function(e){return parseComponent(e)},create:function(e,t){return new Framework7Component(r,e,t)}}}},Statusbar={hide:function(){$("html").removeClass("with-statusbar"),Device.cordova&&win.StatusBar&&win.StatusBar.hide()},show:function(){if(Device.cordova&&win.StatusBar)return win.StatusBar.show(),void Utils.nextTick(function(){Device.needsStatusbarOverlay()&&$("html").addClass("with-statusbar")});$("html").addClass("with-statusbar")},onClick:function(){var e;(e=0<$(".popup.modal-in").length?$(".popup.modal-in").find(".page:not(.page-previous):not(.page-next):not(.cached)").find(".page-content"):0<$(".panel.panel-active").length?$(".panel.panel-active").find(".page:not(.page-previous):not(.page-next):not(.cached)").find(".page-content"):0<$(".views > .view.tab-active").length?$(".views > .view.tab-active").find(".page:not(.page-previous):not(.page-next):not(.cached)").find(".page-content"):0<$(".views").length?$(".views").find(".page:not(.page-previous):not(.page-next):not(.cached)").find(".page-content"):this.root.children(".view").find(".page:not(.page-previous):not(.page-next):not(.cached)").find(".page-content"))&&0<e.length&&(e.hasClass("tab")&&(e=e.parent(".tabs").children(".page-content.tab-active")),0<e.length&&e.scrollTop(0,300))},setTextColor:function(e){Device.cordova&&win.StatusBar&&("white"===e?win.StatusBar.styleLightContent():win.StatusBar.styleDefault())},setIosTextColor:function(e){Device.ios&&Statusbar.setTextColor(e)},setBackgroundColor:function(e){$(".statusbar").css("background-color",e),Device.cordova&&win.StatusBar&&win.StatusBar.backgroundColorByHexString(e)},isVisible:function(){return!(!Device.cordova||!win.StatusBar)&&win.StatusBar.isVisible},overlaysWebView:function(e){void 0===e&&(e=!0),Device.cordova&&win.StatusBar&&(win.StatusBar.overlaysWebView(e),e?$("html").addClass("with-statusbar"):$("html").removeClass("with-statusbar"))},iosOverlaysWebView:function(e){Device.ios&&Statusbar.overlaysWebView(e)},checkOverlay:function(){Device.needsStatusbarOverlay()?$("html").addClass("with-statusbar"):$("html").removeClass("with-statusbar")},init:function(){var e=this.params.statusbar;e.enabled&&("auto"===e.overlay?(Device.needsStatusbarOverlay()?$("html").addClass("with-statusbar"):$("html").removeClass("with-statusbar"),Device.ios&&(Device.cordova||Device.webView)&&(0===win.orientation&&this.once("resize",function(){Statusbar.checkOverlay()}),$(doc).on("resume",function(){Statusbar.checkOverlay()},!1),this.on(Device.ios?"orientationchange":"orientationchange resize",function(){Statusbar.checkOverlay()}))):!0===e.overlay?$("html").addClass("with-statusbar"):!1===e.overlay&&$("html").removeClass("with-statusbar"),Device.cordova&&win.StatusBar&&(e.scrollTopOnClick&&$(win).on("statusTap",Statusbar.onClick.bind(this)),Device.ios&&(e.iosOverlaysWebView?win.StatusBar.overlaysWebView(!0):win.StatusBar.overlaysWebView(!1),"white"===e.iosTextColor?win.StatusBar.styleLightContent():win.StatusBar.styleDefault()),Device.android&&(e.androidOverlaysWebView?win.StatusBar.overlaysWebView(!0):win.StatusBar.overlaysWebView(!1),"white"===e.androidTextColor?win.StatusBar.styleLightContent():win.StatusBar.styleDefault())),e.iosBackgroundColor&&Device.ios&&Statusbar.setBackgroundColor(e.iosBackgroundColor),(e.materialBackgroundColor||e.androidBackgroundColor)&&Device.android&&Statusbar.setBackgroundColor(e.materialBackgroundColor||e.androidBackgroundColor))}},Statusbar$1={name:"statusbar",params:{statusbar:{enabled:!0,overlay:"auto",scrollTopOnClick:!0,iosOverlaysWebView:!0,iosTextColor:"black",iosBackgroundColor:null,androidOverlaysWebView:!1,androidTextColor:"black",androidBackgroundColor:null}},create:function(){Utils.extend(this,{statusbar:{checkOverlay:Statusbar.checkOverlay,hide:Statusbar.hide,show:Statusbar.show,overlaysWebView:Statusbar.overlaysWebView,setTextColor:Statusbar.setTextColor,setBackgroundColor:Statusbar.setBackgroundColor,isVisible:Statusbar.isVisible,init:Statusbar.init.bind(this),iosOverlaysWebView:Statusbar.iosOverlaysWebView,setIosTextColor:Statusbar.iosSetTextColor}})},on:{init:function(){Statusbar.init.call(this)}},clicks:{".statusbar":function(){this.params.statusbar.enabled&&this.params.statusbar.scrollTopOnClick&&Statusbar.onClick.call(this)}}};function getCurrentView(e){var t=$(".popover.modal-in .view"),r=$(".popup.modal-in .view"),a=$(".panel.panel-active .view"),n=$(".views");0===n.length&&(n=e.root);var o=n.children(".view");if(1<o.length&&o.hasClass("tab")&&(o=n.children(".view.tab-active")),0<t.length&&t[0].f7View)return t[0].f7View;if(0<r.length&&r[0].f7View)return r[0].f7View;if(0<a.length&&a[0].f7View)return a[0].f7View;if(0<o.length){if(1===o.length&&o[0].f7View)return o[0].f7View;if(1<o.length)return e.views.main}}var View$1={name:"view",params:{view:{name:void 0,main:!1,router:!0,linksView:null,stackPages:!1,xhrCache:!0,xhrCacheIgnore:[],xhrCacheIgnoreGetParameters:!1,xhrCacheDuration:6e5,preloadPreviousPage:!0,allowDuplicateUrls:!1,reloadPages:!1,removeElements:!0,removeElementsWithTimeout:!1,removeElementsTimeout:0,restoreScrollTopOnBack:!0,unloadTabContent:!0,passRouteQueryToRequest:!0,passRouteParamsToRequest:!1,iosSwipeBack:!0,iosSwipeBackAnimateShadow:!0,iosSwipeBackAnimateOpacity:!0,iosSwipeBackActiveArea:30,iosSwipeBackThreshold:0,mdSwipeBack:!1,mdSwipeBackAnimateShadow:!0,mdSwipeBackAnimateOpacity:!1,mdSwipeBackActiveArea:30,mdSwipeBackThreshold:0,pushState:!1,pushStateRoot:void 0,pushStateAnimate:!0,pushStateAnimateOnLoad:!1,pushStateSeparator:"#!",pushStateOnLoad:!0,animate:!0,animateWithJS:!1,iosDynamicNavbar:!0,iosSeparateDynamicNavbar:!0,iosAnimateNavbarBackIcon:!0,iosPageLoadDelay:0,materialPageLoadDelay:0,routesBeforeEnter:null,routesBeforeLeave:null}},static:{View:View},create:function(){var r=this;Utils.extend(r,{views:Utils.extend([],{create:function(e,t){return new View(r,e,t)},get:function(e){var t=$(e);if(t.length&&t[0].f7View)return t[0].f7View}})}),Object.defineProperty(r.views,"current",{enumerable:!0,configurable:!0,get:function(){return getCurrentView(r)}}),r.view=r.views},on:{init:function(){var a=this;$(".view-init").each(function(e,t){if(!t.f7View){var r=$(t).dataset();a.views.create(t,r)}})},modalOpen:function(e){var a=this;e.$el.find(".view-init").each(function(e,t){if(!t.f7View){var r=$(t).dataset();a.views.create(t,r)}})},modalBeforeDestroy:function(e){e&&e.$el&&e.$el.find(".view-init").each(function(e,t){var r=t.f7View;r&&r.destroy()})}}},Navbar={size:function(e){var r=this;if("ios"===r.theme){var t=$(e);if(t.hasClass("navbar"))t=t.children(".navbar-inner").each(function(e,t){r.navbar.size(t)});else if(!(t.hasClass("stacked")||0<t.parents(".stacked").length||0<t.parents(".tab:not(.tab-active)").length||0<t.parents(".popup:not(.modal-in)").length)){var a,n,o,i,s=t.parents(".view").eq(0),l=r.rtl?t.children(".right"):t.children(".left"),c=r.rtl?t.children(".left"):t.children(".right"),u=t.children(".title"),p=t.children(".subnavbar"),d=0===l.length,f=0===c.length,h=d?0:l.outerWidth(!0),v=f?0:c.outerWidth(!0),m=u.outerWidth(!0),g=t.styles(),b=t[0].offsetWidth,y=b-parseInt(g.paddingLeft,10)-parseInt(g.paddingRight,10),w=t.hasClass("navbar-previous"),C=t.hasClass("sliding"),x=0,k=0;0<s.length&&s[0].f7View&&(n=(a=s[0].f7View.router)&&a.dynamicNavbar,a&&a.separateNavbar||(k=(x=b)/5)),f&&(o=y-m),d&&(o=0),d||f||(o=(y-v-m+h)/2);var E=(y-m)/2;i=m<y-h-v?(E<h&&(E=h),y-v<E+m&&(E=y-v-m),E-o):0;var S=r.rtl?-1:1;if(n){if(u.hasClass("sliding")||0<u.length&&C){var T=-(o+i)*S+k,O=(y-o-i-m)*S-x;if(w&&a&&a.params.iosAnimateNavbarBackIcon){var P=t.parent().find(".navbar-current").children(".left.sliding").find(".back .icon ~ span");0<P.length&&(T+=P[0].offsetLeft)}u[0].f7NavbarLeftOffset=T,u[0].f7NavbarRightOffset=O}d||!l.hasClass("sliding")&&!C||(r.rtl?(l[0].f7NavbarLeftOffset=-(y-l[0].offsetWidth)/2*S,l[0].f7NavbarRightOffset=h*S):(l[0].f7NavbarLeftOffset=-h+k,l[0].f7NavbarRightOffset=(y-l[0].offsetWidth)/2-x,a&&a.params.iosAnimateNavbarBackIcon&&0<l.find(".back .icon").length&&(l[0].f7NavbarRightOffset-=l.find(".back .icon")[0].offsetWidth))),f||!c.hasClass("sliding")&&!C||(r.rtl?(c[0].f7NavbarLeftOffset=-v*S,c[0].f7NavbarRightOffset=(y-c[0].offsetWidth)/2*S):(c[0].f7NavbarLeftOffset=-(y-c[0].offsetWidth)/2+k,c[0].f7NavbarRightOffset=v-x)),p.length&&(p.hasClass("sliding")||C)&&(p[0].f7NavbarLeftOffset=r.rtl?p[0].offsetWidth:-p[0].offsetWidth+k,p[0].f7NavbarRightOffset=-p[0].f7NavbarLeftOffset-x+k)}if(r.params.navbar.iosCenterTitle){var R=i;r.rtl&&d&&f&&0<u.length&&(R=-R),u.css({left:R+"px"})}}}},hide:function(e,t){void 0===t&&(t=!0);var r=$(e);if(r.hasClass("navbar-inner")&&(r=r.parents(".navbar")),r.length&&!r.hasClass("navbar-hidden")){var a="navbar-hidden"+(t?" navbar-transitioning":"");r.transitionEnd(function(){r.removeClass("navbar-transitioning")}),r.addClass(a)}},show:function(e,t){void 0===e&&(e=".navbar-hidden"),void 0===t&&(t=!0);var r=$(e);r.hasClass("navbar-inner")&&(r=r.parents(".navbar")),r.length&&r.hasClass("navbar-hidden")&&(t&&(r.addClass("navbar-transitioning"),r.transitionEnd(function(){r.removeClass("navbar-transitioning")})),r.removeClass("navbar-hidden"))},getElByPage:function(e){var t,r,a;if(e.$navbarEl||e.$el?t=(a=e).$el:0<(t=$(e)).length&&(a=t[0].f7Page),a&&a.$navbarEl&&0<a.$navbarEl.length?r=a.$navbarEl:t&&(r=t.children(".navbar").children(".navbar-inner")),r&&(!r||0!==r.length))return r[0]},getPageByEl:function(e){var r,a=$(e);if(!(a.hasClass("navbar")&&1<(a=a.find(".navbar-inner")).length))return a.parents(".page").length?a.parents(".page")[0]:(a.parents(".view").find(".page").each(function(e,t){t&&t.f7Page&&t.f7Page.navbarEl&&a[0]===t.f7Page.navbarEl&&(r=t)}),r)},initHideNavbarOnScroll:function(e,t){var r,a,n,o,i,s,l,c=this,u=$(e),p=$(t||c.navbar.getElByPage(e)).closest(".navbar");function d(){u.hasClass("page-previous")||(a=this.scrollTop,n=this.scrollHeight,o=this.offsetHeight,i=n<=a+o,l=p.hasClass("navbar-hidden"),i?c.params.navbar.showOnPageScrollEnd&&(s="show"):s=a<r?c.params.navbar.showOnPageScrollTop||a<=44?"show":"hide":44<a?"hide":"show","show"===s&&l?(c.navbar.show(p),l=!1):"hide"!==s||l||(c.navbar.hide(p),l=!0),r=a)}u.on("scroll",".page-content",d,!0),u[0].f7ScrollNavbarHandler=d}},Navbar$1={name:"navbar",create:function(){var e=this;Utils.extend(e,{navbar:{size:Navbar.size.bind(e),hide:Navbar.hide.bind(e),show:Navbar.show.bind(e),getElByPage:Navbar.getElByPage.bind(e),getPageByEl:Navbar.getPageByEl.bind(e),initHideNavbarOnScroll:Navbar.initHideNavbarOnScroll.bind(e)}})},params:{navbar:{scrollTopOnTitleClick:!0,iosCenterTitle:!0,hideOnPageScroll:!1,showOnPageScrollEnd:!0,showOnPageScrollTop:!0}},on:{"panelBreakpoint resize":function(){var r=this;"ios"===r.theme&&$(".navbar").each(function(e,t){r.navbar.size(t)})},pageBeforeRemove:function(e){e.$el[0].f7ScrollNavbarHandler&&e.$el.off("scroll",".page-content",e.$el[0].f7ScrollNavbarHandler,!0)},pageBeforeIn:function(e){if("ios"===this.theme){var t,r=e.$el.parents(".view")[0].f7View,a=this.navbar.getElByPage(e);if(t=a?$(a).parents(".navbar"):e.$el.parents(".view").children(".navbar"),e.$el.hasClass("no-navbar")||r.router.dynamicNavbar&&!a){var n=!!(e.pageFrom&&0<e.router.history.length);this.navbar.hide(t,n)}else this.navbar.show(t)}},pageReinit:function(e){if("ios"===this.theme){var t=$(this.navbar.getElByPage(e));t&&0!==t.length&&this.navbar.size(t)}},pageInit:function(e){var t=this,r=$(t.navbar.getElByPage(e));if(r&&0!==r.length&&("ios"===t.theme&&t.navbar.size(r),t.params.navbar.hideOnPageScroll||e.$el.find(".hide-navbar-on-scroll").length||e.$el.hasClass("hide-navbar-on-scroll")||e.$el.find(".hide-bars-on-scroll").length||e.$el.hasClass("hide-bars-on-scroll"))){if(e.$el.find(".keep-navbar-on-scroll").length||e.$el.hasClass("keep-navbar-on-scroll")||e.$el.find(".keep-bars-on-scroll").length||e.$el.hasClass("keep-bars-on-scroll"))return;t.navbar.initHideNavbarOnScroll(e.el,r[0])}},modalOpen:function(e){var r=this;"ios"===r.theme&&e.$el.find(".navbar:not(.navbar-previous):not(.stacked)").each(function(e,t){r.navbar.size(t)})},panelOpen:function(e){var r=this;"ios"===r.theme&&e.$el.find(".navbar:not(.navbar-previous):not(.stacked)").each(function(e,t){r.navbar.size(t)})},panelSwipeOpen:function(e){var r=this;"ios"===r.theme&&e.$el.find(".navbar:not(.navbar-previous):not(.stacked)").each(function(e,t){r.navbar.size(t)})},tabShow:function(e){var r=this;$(e).find(".navbar:not(.navbar-previous):not(.stacked)").each(function(e,t){r.navbar.size(t)})}},clicks:{".navbar .title":function(e){if(this.params.navbar.scrollTopOnTitleClick&&!(0<e.closest("a").length)){var t,r=e.parents(".navbar");0===(t=r.parents(".page-content")).length&&(0<r.parents(".page").length&&(t=r.parents(".page").find(".page-content")),0===t.length&&0<r.nextAll(".page-current:not(.stacked)").length&&(t=r.nextAll(".page-current:not(.stacked)").find(".page-content"))),t&&0<t.length&&(t.hasClass("tab")&&(t=t.parent(".tabs").children(".page-content.tab-active")),0<t.length&&t.scrollTop(0,300))}}},vnode:{"navbar-inner":{postpatch:function(e){"ios"===this.theme&&this.navbar.size(e.elm)}}}},Toolbar={setHighlight:function(e){if("md"===this.theme){var t=$(e);if(0!==t.length&&(t.hasClass("tabbar")||t.hasClass("tabbar-labels"))){var r=t.find(".tab-link-highlight"),a=t.find(".tab-link").length;if(0!==a){0===r.length?(t.children(".toolbar-inner").append('<span class="tab-link-highlight"></span>'),r=t.find(".tab-link-highlight")):r.next().length&&t.children(".toolbar-inner").append(r);var n,o,i=t.find(".tab-link-active");if(t.hasClass("tabbar-scrollable")&&i&&i[0])n=i[0].offsetWidth+"px",o=i[0].offsetLeft+"px";else{var s=i.index();n=100/a+"%",o=100*(this.rtl?-s:s)+"%"}Utils.nextFrame(function(){r.css("width",n).transform("translate3d("+o+",0,0)")})}else r.remove()}}},init:function(e){this.toolbar.setHighlight(e)},hide:function(e,t){void 0===t&&(t=!0);var r=$(e);if(!r.hasClass("toolbar-hidden")){var a="toolbar-hidden"+(t?" toolbar-transitioning":"");r.transitionEnd(function(){r.removeClass("toolbar-transitioning")}),r.addClass(a)}},show:function(e,t){void 0===t&&(t=!0);var r=$(e);r.hasClass("toolbar-hidden")&&(t&&(r.addClass("toolbar-transitioning"),r.transitionEnd(function(){r.removeClass("toolbar-transitioning")})),r.removeClass("toolbar-hidden"))},initHideToolbarOnScroll:function(e){var t,r,a,n,o,i,s,l=this,c=$(e),u=c.parents(".view").children(".toolbar");(0===u.length&&(u=c.find(".toolbar")),0===u.length&&(u=c.parents(".views").children(".tabbar, .tabbar-labels")),0!==u.length)&&(c.on("scroll",".page-content",p,!0),c[0].f7ScrollToolbarHandler=p);function p(){c.hasClass("page-previous")||(r=this.scrollTop,a=this.scrollHeight,n=this.offsetHeight,o=a<=r+n,s=u.hasClass("toolbar-hidden"),o?l.params.toolbar.showOnPageScrollEnd&&(i="show"):i=r<t?l.params.toolbar.showOnPageScrollTop||r<=44?"show":"hide":44<r?"hide":"show","show"===i&&s?(l.toolbar.show(u),s=!1):"hide"!==i||s||(l.toolbar.hide(u),s=!0),t=r)}}},Toolbar$1={name:"toolbar",create:function(){var e=this;Utils.extend(e,{toolbar:{hide:Toolbar.hide.bind(e),show:Toolbar.show.bind(e),setHighlight:Toolbar.setHighlight.bind(e),initHideToolbarOnScroll:Toolbar.initHideToolbarOnScroll.bind(e),init:Toolbar.init.bind(e)}})},params:{toolbar:{hideOnPageScroll:!1,showOnPageScrollEnd:!0,showOnPageScrollTop:!0}},on:{pageBeforeRemove:function(e){e.$el[0].f7ScrollToolbarHandler&&e.$el.off("scroll",".page-content",e.$el[0].f7ScrollToolbarHandler,!0)},pageBeforeIn:function(e){var t=e.$el.parents(".view").children(".toolbar");0===t.length&&(t=e.$el.parents(".views").children(".tabbar, .tabbar-labels")),0===t.length&&(t=e.$el.find(".toolbar")),0!==t.length&&(e.$el.hasClass("no-toolbar")?this.toolbar.hide(t):this.toolbar.show(t))},pageInit:function(e){var r=this;if(e.$el.find(".tabbar, .tabbar-labels").each(function(e,t){r.toolbar.init(t)}),r.params.toolbar.hideOnPageScroll||e.$el.find(".hide-toolbar-on-scroll").length||e.$el.hasClass("hide-toolbar-on-scroll")||e.$el.find(".hide-bars-on-scroll").length||e.$el.hasClass("hide-bars-on-scroll")){if(e.$el.find(".keep-toolbar-on-scroll").length||e.$el.hasClass("keep-toolbar-on-scroll")||e.$el.find(".keep-bars-on-scroll").length||e.$el.hasClass("keep-bars-on-scroll"))return;r.toolbar.initHideToolbarOnScroll(e.el)}},init:function(){var r=this;r.root.find(".tabbar, .tabbar-labels").each(function(e,t){r.toolbar.init(t)})}}},Subnavbar={name:"subnavbar",on:{pageInit:function(e){e.$navbarEl&&e.$navbarEl.length&&e.$navbarEl.find(".subnavbar").length&&e.$el.addClass("page-with-subnavbar"),e.$el.find(".subnavbar").length&&e.$el.addClass("page-with-subnavbar")}}},TouchRipple=function(e,t,r){var a=this;if(e){var n=e[0].getBoundingClientRect(),o=t-n.left,i=r-n.top,s=n.width,l=n.height,c=Math.max(Math.pow(Math.pow(l,2)+Math.pow(s,2),.5),48);return a.$rippleWaveEl=$('<div class="ripple-wave" style="width: '+c+"px; height: "+c+"px; margin-top:-"+c/2+"px; margin-left:-"+c/2+"px; left:"+o+"px; top:"+i+'px;"></div>'),e.prepend(a.$rippleWaveEl),a.rippleTransform="translate3d("+(s/2-o)+"px, "+(l/2-i)+"px, 0) scale(1)",Utils.nextFrame(function(){a&&a.$rippleWaveEl&&a.$rippleWaveEl.transform(a.rippleTransform)}),a}};TouchRipple.prototype.onRemove=function(){var t=this;t.$rippleWaveEl&&t.$rippleWaveEl.remove(),Object.keys(t).forEach(function(e){t[e]=null,delete t[e]}),t=null},TouchRipple.prototype.remove=function(){var e=this;if(!e.removing){var t=this.$rippleWaveEl,r=this.rippleTransform,a=Utils.nextTick(function(){e.onRemove()},400);e.removing=!0,t.addClass("ripple-wave-fill").transform(r.replace("scale(1)","scale(1.01)")).transitionEnd(function(){clearTimeout(a),Utils.nextFrame(function(){t.addClass("ripple-wave-out").transform(r.replace("scale(1)","scale(1.01)")),a=Utils.nextTick(function(){e.onRemove()},700),t.transitionEnd(function(){clearTimeout(a),e.onRemove()})})})}};var TouchRipple$1={name:"touch-ripple",static:{TouchRipple:TouchRipple},create:function(){this.touchRipple={create:function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return new(Function.prototype.bind.apply(TouchRipple,[null].concat(e)))}}}},openedModals=[],dialogsQueue=[];function clearDialogsQueue(){0!==dialogsQueue.length&&dialogsQueue.shift().open()}var Modal=function(a){function e(e,t){a.call(this,t,[e]);var r={};return this.useModulesParams(r),this.params=Utils.extend(r,t),this.opened=!1,this.useModules(),this}return a&&(e.__proto__=a),((e.prototype=Object.create(a&&a.prototype)).constructor=e).prototype.onOpen=function(){var e=this;e.opened=!0,openedModals.push(e),$("html").addClass("with-modal-"+e.type.toLowerCase()),e.$el.trigger("modal:open "+e.type.toLowerCase()+":open",e),e.emit("local::open modalOpen "+e.type+"Open",e)},e.prototype.onOpened=function(){var e=this;e.$el.trigger("modal:opened "+e.type.toLowerCase()+":opened",e),e.emit("local::opened modalOpened "+e.type+"Opened",e)},e.prototype.onClose=function(){var e=this;e.opened=!1,e.type&&e.$el&&(openedModals.splice(openedModals.indexOf(e),1),$("html").removeClass("with-modal-"+e.type.toLowerCase()),e.$el.trigger("modal:close "+e.type.toLowerCase()+":close",e),e.emit("local::close modalClose "+e.type+"Close",e))},e.prototype.onClosed=function(){var e=this;e.type&&e.$el&&(e.$el.removeClass("modal-out"),e.$el.hide(),e.$el.trigger("modal:closed "+e.type.toLowerCase()+":closed",e),e.emit("local::closed modalClosed "+e.type+"Closed",e))},e.prototype.open=function(e){var t,r=this,a=r.app,n=r.$el,o=r.$backdropEl,i=r.type,s=!0;if(void 0!==e?s=e:void 0!==r.params.animate&&(s=r.params.animate),!n||n.hasClass("modal-in"))return r;if("dialog"===i&&a.params.modal.queueDialogs&&(0<$(".dialog.modal-in").length?t=!0:0<openedModals.length&&openedModals.forEach(function(e){"dialog"===e.type&&(t=!0)}),t))return dialogsQueue.push(r),r;var l=n.parent(),c=0<n.parents(doc).length;function u(){n.hasClass("modal-out")?r.onClosed():n.hasClass("modal-in")&&r.onOpened()}return a.params.modal.moveToRoot&&!l.is(a.root)&&(a.root.append(n),r.once(i+"Closed",function(){c?l.append(n):n.remove()})),n.show(),"dialog"===i&&n.css({marginTop:-Math.round(n.outerHeight()/2)+"px"}),r._clientLeft=n[0].clientLeft,s?(o&&(o.removeClass("not-animated"),o.addClass("backdrop-in")),n.animationEnd(function(){u()}),n.transitionEnd(function(){u()}),n.removeClass("modal-out not-animated").addClass("modal-in"),r.onOpen()):(o&&o.addClass("backdrop-in not-animated"),n.removeClass("modal-out").addClass("modal-in not-animated"),r.onOpen(),r.onOpened()),r},e.prototype.close=function(e){var a=this,t=a.$el,r=a.$backdropEl,n=!0;if(void 0!==e?n=e:void 0!==a.params.animate&&(n=a.params.animate),!t||!t.hasClass("modal-in"))return a;if(r){var o=!0;"popup"===a.type&&a.$el.prevAll(".popup.modal-in").each(function(e,t){var r=t.f7Modal;r&&r.params.closeByBackdropClick&&r.params.backdrop&&r.backdropEl===a.backdropEl&&(o=!1)}),o&&(r[n?"removeClass":"addClass"]("not-animated"),r.removeClass("backdrop-in"))}function i(){t.hasClass("modal-out")?a.onClosed():t.hasClass("modal-in")&&a.onOpened()}return t[n?"removeClass":"addClass"]("not-animated"),n?(t.animationEnd(function(){i()}),t.transitionEnd(function(){i()}),t.removeClass("modal-in").addClass("modal-out"),a.onClose()):(t.addClass("not-animated").removeClass("modal-in").addClass("modal-out"),a.onClose(),a.onClosed()),"dialog"===a.type&&clearDialogsQueue(),a},e.prototype.destroy=function(){var e=this;e.destroyed||(e.emit("local::beforeDestroy modalBeforeDestroy "+e.type+"BeforeDestroy",e),e.$el&&(e.$el.trigger("modal:beforedestroy "+e.type.toLowerCase()+":beforedestroy",e),e.$el.length&&e.$el[0].f7Modal&&delete e.$el[0].f7Modal),Utils.deleteProps(e),e.destroyed=!0)},e}(Framework7Class),CustomModal=function(s){function e(e,t){var r=Utils.extend({backdrop:!0,closeByBackdropClick:!0,on:{}},t);s.call(this,e,r);var a,n,o=this;if(o.params=r,(a=o.params.el?$(o.params.el):$(o.params.content))&&0<a.length&&a[0].f7Modal)return a[0].f7Modal;if(0===a.length)return o.destroy();function i(e){o&&!o.destroyed&&n&&e.target===n[0]&&o.close()}return o.params.backdrop&&0===(n=e.root.children(".custom-modal-backdrop")).length&&(n=$('<div class="custom-modal-backdrop"></div>'),e.root.append(n)),o.on("customModalOpened",function(){o.params.closeByBackdropClick&&o.params.backdrop&&e.on("click",i)}),o.on("customModalClose",function(){o.params.closeByBackdropClick&&o.params.backdrop&&e.off("click",i)}),Utils.extend(o,{app:e,$el:a,el:a[0],$backdropEl:n,backdropEl:n&&n[0],type:"customModal"}),a[0].f7Modal=o}return s&&(e.__proto__=s),(e.prototype=Object.create(s&&s.prototype)).constructor=e}(Modal),Modal$1={name:"modal",static:{Modal:Modal,CustomModal:CustomModal},create:function(){var t=this;t.customModal={create:function(e){return new CustomModal(t,e)}}},params:{modal:{moveToRoot:!0,queueDialogs:!0}}};return"undefined"!=typeof window&&(window.Template7||(window.Template7=Template7),window.Dom7||(window.Dom7=$)),Framework7.use([DeviceModule,SupportModule,UtilsModule,ResizeModule,RequestModule,TouchModule,ClicksModule,Router$1,HistoryModule,StorageModule,ComponentModule,Statusbar$1,View$1,Navbar$1,Toolbar$1,Subnavbar,TouchRipple$1,Modal$1]),Framework7});
//# sourceMappingURL=framework7-lazy.min.js.map
