# Contributions to Zeus

## Bugs!!

Bug reports are welcome! Please report all bugs to the [Issue Tracker](https://github.com/Ekultek/Zeus-Scanner/issues) by clicking the link and hitting `New Issue`. Zeus will prompt you to automatically create a issue if it hits an unexpected exception. To do it manually please follow the details below.

### Bug report guidelines

 - Before you create a bug report, make sure that the bug has not already been reported by checking the [open](https://github.com/Ekultek/Zeus-Scanner/issues?q=is%3Aopen+is%3Aissue) and [closed](https://github.com/Ekultek/Zeus-Scanner/issues?q=is%3Aissue+is%3Aclosed) issues.
 - You can also check if you can answer your own question by looking at the [user manual](https://github.com/Ekultek/Zeus-Scanner/wiki/User-Guide)
 - Do a `python zeus.py --update` and try to reproduce the bug with the latest version
 - You will need to make sure that your report has detailed information, this includes (but not limited to):
   - The dork you used when you tried you received the error
   - Your running context (`clone`, `zip`, etc..)
   - Your operating system
   - The commands passed
   - Log file information that is relevant
   - Full stacktrace error

# Pull requests and code changes

All pull requests will be fully evaluated and taken seriously, no matter how small the change. To open a pull request you will need to do the following:
  - Clone the repository with `git clone https://github.com/ekultek/zeus-scanner.git`
  - Read the [user manual](https://github.com/Ekultek/Zeus-Scanner/wiki/User-Guide) carefully and make sure you understand what's going on
  - Do your code changes with your favorite editor
  - Send a pull request via Github

### Pull request guidelines

 - Each pull request should have at least one logical change
 - Porting to compatibility with `python 3` is allowed and welcomed
 - Use spaces not tabs please

If I consistently see that you are creating clean and great functional pull requests, we can discuss the possibility of getting push access to the repository.

# Licensing

By submitting code contributions to Zeus or via Git pull request, checking them into the Zeus's source code repository, it is understood (unless you specify otherwise) that you are offering the Zeus copyright holders the unlimited, non-exclusive right to reuse, modify, and relicense the code. This is important because the inability to relicense code has caused devastating problems for other software projects (such as KDE and NASM). If you wish to specify special license conditions of your contributions, just say so when you send them.