// MemLoadDll.cpp: implementation of the CMemLoadDll class.
//
//////////////////////////////////////////////////////////////////////
#include "StdAfx.h"
#include "MemLoadDll.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////
CMemLoadDll::CMemLoadDll()
{
	m_bIsLoadOk = FALSE;
	m_pImageBase = NULL;
	m_pDllMain = NULL;
}

CMemLoadDll::~CMemLoadDll()
{
	if(m_bIsLoadOk)
	{
	//	ASSERT(m_pImageBase != NULL);
	//	ASSERT(m_pDllMain   != NULL);
		//ѹ׼жdll
		m_pDllMain((HINSTANCE)m_pImageBase, DLL_PROCESS_DETACH, 0);
		VirtualFree(m_pImageBase, 0, MEM_RELEASE);
	}
}

//MemLoadLibraryڴ滺мһdllǰ̵ĵַռ䣬ȱʡλ0x10000000
//ֵ ɹTRUE , ʧܷFALSE
//lpFileData: dllļݵĻ
//nDataLength: ݵܳ
BOOL CMemLoadDll::MemLoadLibrary(void* lpFileData, int nDataLength)
{
	if (m_pImageBase != NULL)
	{
		return FALSE;  //Ѿһdllûͷţܼµdll
	}
	//Чԣʼ
	if (!CheckDataValide(lpFileData, nDataLength))
	{
		return FALSE;
	}
	//ļؿռ
	int nImageSize = CalcTotalImageSize();

	if (nImageSize == 0)
	{
		return FALSE;
	}
	// ڴ
	void *pMemoryAddress = VirtualAlloc(NULL, nImageSize, MEM_COMMIT|MEM_RESERVE, PAGE_EXECUTE_READWRITE);

	if (pMemoryAddress == NULL)
	{
		return FALSE;
	}
	else
	{
		CopyDllDatas(pMemoryAddress, lpFileData); //dllݣÿ
		//ضλϢ
		if (m_pNTHeader->OptionalHeader.DataDirectory[IMAGE_DIRECTORY_ENTRY_BASERELOC].VirtualAddress > 0
			&& m_pNTHeader->OptionalHeader.DataDirectory[IMAGE_DIRECTORY_ENTRY_BASERELOC].Size > 0)
		{
			DoRelocation(pMemoryAddress);
		}
		//ַ
		if (!FillRavAddress(pMemoryAddress)) //ַʧ
		{
			VirtualFree(pMemoryAddress, 0, MEM_RELEASE);
			return FALSE;
		}
		//޸ҳԡӦøÿҳԵӦڴҳԡһ¡
		//ͳһóһPAGE_EXECUTE_READWRITE
		unsigned long unOld;

		VirtualProtect(pMemoryAddress, nImageSize, PAGE_EXECUTE_READWRITE, &unOld);
	}
	//ַ
#ifdef WIN32
	m_pNTHeader->OptionalHeader.ImageBase = (DWORD)pMemoryAddress;
#else
	m_pNTHeader->OptionalHeader.ImageBase = (ULONGULONG)pMemoryAddress;
#endif
	//Ҫһdllںʼ
	m_pDllMain = (ProcDllMain)(m_pNTHeader->OptionalHeader.AddressOfEntryPoint + (PBYTE)pMemoryAddress);

	BOOL InitResult = m_pDllMain((HINSTANCE)pMemoryAddress, DLL_PROCESS_ATTACH, 0);

	if (!InitResult) //ʼʧ
	{
		m_pDllMain((HINSTANCE)pMemoryAddress, DLL_PROCESS_DETACH, 0);
		VirtualFree(pMemoryAddress, 0, MEM_RELEASE);
		m_pDllMain = NULL;
		return FALSE;
	}
	
	m_bIsLoadOk = TRUE;
	m_pImageBase = pMemoryAddress;
	return TRUE;
}

BOOL CMemLoadDll::IsLoadOk()
{
	return m_bIsLoadOk;
}

//MemGetProcAddressdllлȡָĵַ
//ֵ ɹغַ , ʧܷNULL
//lpProcName: ҪҺֻ
FARPROC CMemLoadDll::MemGetProcAddress(LPCSTR lpProcName)
{
	if (m_pNTHeader->OptionalHeader.DataDirectory[IMAGE_DIRECTORY_ENTRY_EXPORT].VirtualAddress == 0 ||
		m_pNTHeader->OptionalHeader.DataDirectory[IMAGE_DIRECTORY_ENTRY_EXPORT].Size == 0)
	{
		return NULL;
	}
	if (!m_bIsLoadOk)
	{
		return NULL;
	}
	
	DWORD dwOffsetStart = m_pNTHeader->OptionalHeader.DataDirectory[IMAGE_DIRECTORY_ENTRY_EXPORT].VirtualAddress;
	DWORD dwSize = m_pNTHeader->OptionalHeader.DataDirectory[IMAGE_DIRECTORY_ENTRY_EXPORT].Size;
	
	PIMAGE_EXPORT_DIRECTORY pExport = (PIMAGE_EXPORT_DIRECTORY)((PBYTE)m_pImageBase + m_pNTHeader->OptionalHeader.DataDirectory[IMAGE_DIRECTORY_ENTRY_EXPORT].VirtualAddress);
	int iBase = pExport->Base;
	int iNumberOfFunctions = pExport->NumberOfFunctions;
	int iNumberOfNames = pExport->NumberOfNames; //<= iNumberOfFunctions
	LPDWORD pAddressOfFunctions = (LPDWORD)(pExport->AddressOfFunctions + (PBYTE)m_pImageBase);
	LPWORD  pAddressOfOrdinals = (LPWORD)(pExport->AddressOfNameOrdinals + (PBYTE)m_pImageBase);
	LPDWORD pAddressOfNames  = (LPDWORD)(pExport->AddressOfNames + (PBYTE)m_pImageBase);
	
	int iOrdinal = -1;
	
	if (((DWORD)lpProcName & 0xFFFF0000) == 0) //IT IS A ORDINAL!
	{
		iOrdinal = (DWORD)lpProcName & 0x0000FFFF - iBase;
	}
	else  //use name
	{
		int iFound = -1;
		
		for (int i=0; i<iNumberOfNames; i++)
		{
			char* pName= (char* )(pAddressOfNames[i] + (PBYTE)m_pImageBase);
			if (strcmp(pName, lpProcName) == 0)
			{
				iFound = i;
				break;
			}
		}
		if (iFound >= 0)
		{
			iOrdinal = (int)(pAddressOfOrdinals[iFound]);
		}
	}
	
	if (iOrdinal < 0 || iOrdinal >= iNumberOfFunctions )
	{
		return NULL;
	}
	else
	{
		DWORD pFunctionOffset = pAddressOfFunctions[iOrdinal];

		if (pFunctionOffset > dwOffsetStart && pFunctionOffset < (dwOffsetStart + dwSize))//maybe Export Forwarding
		{
			return NULL;
		}
		else
		{
			return (FARPROC)(pFunctionOffset + (PBYTE)m_pImageBase);
		}
	}
	
}

// ضPEõĵַ
void CMemLoadDll::DoRelocation( void *pNewBase)
{
/* ضλĽṹ
// DWORD sectionAddress, DWORD size (Ҫضλ)
//  1000Ҫ5ضλݵĻضλ
// 00 10 00 00   14 00 00 00      xxxx xxxx xxxx xxxx xxxx 0000
// -----------   -----------      ----
// ڵƫ  ܳߴ=8+6*2     Ҫĵַ           ڶ4ֽ
// ضλɸaddress  size0 ʾ
// Ҫĵַ12λģ4λ̬֣intel cpu3
	*/
	//NewBase0x600000,ļõȱʡImageBase0x400000,ƫ0x200000
	
	//עضλλÿܺӲļеƫƵַͬӦʹüغĵַ
	PIMAGE_BASE_RELOCATION pLoc = (PIMAGE_BASE_RELOCATION)((unsigned long)pNewBase 
		+ m_pNTHeader->OptionalHeader.DataDirectory[IMAGE_DIRECTORY_ENTRY_BASERELOC].VirtualAddress);

	while ((pLoc->VirtualAddress + pLoc->SizeOfBlock) != 0) //ʼɨضλ
	{
		WORD *pLocData = (WORD *)((PBYTE)pLoc + sizeof(IMAGE_BASE_RELOCATION));
		//㱾ҪضλַĿ
		int nNumberOfReloc = (pLoc->SizeOfBlock - sizeof(IMAGE_BASE_RELOCATION))/sizeof(WORD);

		for ( int i=0 ; i < nNumberOfReloc; i++)
		{
			// ÿWORDɡ4λָضλͣWINNT.HеһϵIMAGE_REL_BASED_xxxضλ͵ȡֵ
			// 12λVirtualAddressƫƣָ˱ضλλá
			if ((DWORD)(pLocData[i] & 0x0000F000) == 0x0000A000)
			{
				// 64λdllضλIMAGE_REL_BASED_DIR64
				// IA-64ĿִļضλƺIMAGE_REL_BASED_DIR64͵ġ
#ifdef _WIN64
				ULONGLONG* pAddress = (ULONGLONG *)((PBYTE)pNewBase + pLoc->VirtualAddress + (pLocData[i] & 0x0FFF));
				ULONGLONG ullDelta = (ULONGLONG)pNewBase - m_pNTHeader->OptionalHeader.ImageBase;
				*pAddress += ullDelta;
#endif
			}
			else if ((DWORD)(pLocData[i] & 0x0000F000) == 0x00003000) //һҪĵַ
			{
				// 32λdllضλIMAGE_REL_BASED_HIGHLOW
				// x86ĿִļеĻַضλIMAGE_REL_BASED_HIGHLOW͵ġ
#ifndef _WIN64
				DWORD* pAddress = (DWORD *)((PBYTE)pNewBase + pLoc->VirtualAddress + (pLocData[i] & 0x0FFF));
				DWORD dwDelta = (DWORD)pNewBase - m_pNTHeader->OptionalHeader.ImageBase;
				*pAddress += dwDelta;
#endif
			}
		}
		//תƵһڽд
		pLoc = (PIMAGE_BASE_RELOCATION)((PBYTE)pLoc + pLoc->SizeOfBlock);
	}
}

//ַ
BOOL CMemLoadDll::FillRavAddress(void *pImageBase)
{
	// ʵһ IMAGE_IMPORT_DESCRIPTOR ṹ飬ȫ0ʾ
	// 鶨£
	// 
    // DWORD   OriginalFirstThunk;         // 0ʾָδ󶨵IATṹ
    // DWORD   TimeDateStamp; 
    // DWORD   ForwarderChain;             // -1 if no forwarders
    // DWORD   Name;                       // dll
    // DWORD   FirstThunk;                 // ָIATṹĵַ(󶨺ЩIATʵʵĺַ)
	unsigned long nOffset = m_pNTHeader->OptionalHeader.DataDirectory[IMAGE_DIRECTORY_ENTRY_IMPORT].VirtualAddress ;

	if (nOffset == 0)
	{
		return TRUE; //No Import Table
	}

	PIMAGE_IMPORT_DESCRIPTOR pID = (PIMAGE_IMPORT_DESCRIPTOR)((PBYTE)pImageBase + nOffset);

	while (pID->Characteristics != 0)
	{
		PIMAGE_THUNK_DATA pRealIAT = (PIMAGE_THUNK_DATA)((PBYTE)pImageBase + pID->FirstThunk);
		PIMAGE_THUNK_DATA pOriginalIAT = (PIMAGE_THUNK_DATA)((PBYTE)pImageBase + pID->OriginalFirstThunk);
		//ȡdll
		#define NAME_BUF_SIZE 256

		char szBuf[NAME_BUF_SIZE] = ""; //dll name;
		BYTE* pName = (BYTE*)((PBYTE)pImageBase + pID->Name);
		int i=0;

		for (i=0; i<NAME_BUF_SIZE; i++)
		{
			if (pName[i] == 0)
			{
				break;
			}
			szBuf[i] = pName[i];
		}
		if (i >= NAME_BUF_SIZE)
		{
			return FALSE;  // bad dll name
		}
		else
		{
			szBuf[i] = 0;
		}

		HMODULE hDll = GetModuleHandleA(szBuf);

		if (hDll == NULL)
		{
			hDll = LoadLibraryA(szBuf);
			if (hDll == NULL) return FALSE;
			//return FALSE; //NOT FOUND DLL
		}
		//ȡDLLÿĵַIAT
		//ÿIATṹ 
		// union { PBYTE  ForwarderString;
        //   PDWORD Function;
        //   DWORD Ordinal;
        //   PIMAGE_IMPORT_BY_NAME  AddressOfData;
		// } u1;
		// һDWORD һַ
		for (i=0; ; i++)
		{
			if (pOriginalIAT[i].u1.Function == 0)
			{
				break;
			}

			FARPROC lpFunction = NULL;

			if (pOriginalIAT[i].u1.Ordinal & IMAGE_ORDINAL_FLAG) //ֵǵ
			{
				lpFunction = GetProcAddress(hDll, (LPCSTR)(pOriginalIAT[i].u1.Ordinal & 0x0000FFFF));
			}
			else //ֵ
			{
				//ȡIATĺ
				PIMAGE_IMPORT_BY_NAME pByName = (PIMAGE_IMPORT_BY_NAME)((PBYTE)pImageBase + (pOriginalIAT[i].u1.AddressOfData));

				lpFunction = GetProcAddress(hDll, (char *)pByName->Name);
			}
			if (lpFunction != NULL)   //ҵˣ
			{
#ifdef _WIN64
				pRealIAT[i].u1.Function = (ULONGLONG)lpFunction;
#else
				pRealIAT[i].u1.Function = (DWORD)lpFunction;
#endif
			}
			else
			{
				return FALSE;
			}
		}
		
		//move to next 
		pID = (PIMAGE_IMPORT_DESCRIPTOR)((PBYTE)pID + sizeof(IMAGE_IMPORT_DESCRIPTOR));
	}

	return TRUE;
}

//CheckDataValideڼ黺еǷЧdllļ
//ֵ һִеdll򷵻TRUE򷵻FALSE
//lpFileData: dllݵڴ滺
//nDataLength: dllļĳ
BOOL CMemLoadDll::CheckDataValide(void* lpFileData, int nDataLength)
{
	//鳤
	if (nDataLength < sizeof(IMAGE_DOS_HEADER))
	{
		return FALSE;
	}
	m_pDosHeader = (PIMAGE_DOS_HEADER)lpFileData;  // DOSͷ
	//dosͷı
	if (m_pDosHeader->e_magic != IMAGE_DOS_SIGNATURE)
	{
		return FALSE;  //0x5A4D : MZ
	}
	
	//鳤
	if ((DWORD)nDataLength < (m_pDosHeader->e_lfanew + sizeof(IMAGE_NT_HEADERS)))
	{
		return FALSE;
	}
	//ȡpeͷ
	m_pNTHeader = (PIMAGE_NT_HEADERS)((PBYTE)lpFileData + m_pDosHeader->e_lfanew); // PEͷ
	//peͷĺϷ
	if (m_pNTHeader->Signature != IMAGE_NT_SIGNATURE)
	{
		return FALSE;  //0x00004550 : PE00
	}
	if ((m_pNTHeader->FileHeader.Characteristics & IMAGE_FILE_DLL) == 0) //0x2000  : File is a DLL
	{
		return FALSE;  
	}
	if ((m_pNTHeader->FileHeader.Characteristics & IMAGE_FILE_EXECUTABLE_IMAGE) == 0) //0x0002 : ָļ
	{
		return FALSE;
	}
	if (m_pNTHeader->FileHeader.SizeOfOptionalHeader != sizeof(IMAGE_OPTIONAL_HEADER))
	{
		return FALSE;
	}	
	
	//ȡýڱα
	m_pSectionHeader = (PIMAGE_SECTION_HEADER)((PBYTE)m_pNTHeader + sizeof(IMAGE_NT_HEADERS));
	//֤ÿڱĿռ
	for (int i=0; i< m_pNTHeader->FileHeader.NumberOfSections; i++)
	{
		if ((m_pSectionHeader[i].PointerToRawData + m_pSectionHeader[i].SizeOfRawData) > (DWORD)nDataLength)
		{
			return FALSE;
		}
	}

	return TRUE;
}

//߽
int CMemLoadDll::GetAlignedSize(int nOrigin, int nAlignment)
{
	return (nOrigin + nAlignment - 1) / nAlignment * nAlignment;
}

//dllӳļĳߴ
int CMemLoadDll::CalcTotalImageSize()
{
	int nSize = 0;

	if (m_pNTHeader == NULL)
	{
		return 0;
	}

	int nAlign = m_pNTHeader->OptionalHeader.SectionAlignment; //ζֽ
	
	// ͷĳߴ硣dos, coff, peͷ  αĴС
	nSize = GetAlignedSize(m_pNTHeader->OptionalHeader.SizeOfHeaders, nAlign);
	// нڵĴС
	for (int i=0; i < m_pNTHeader->FileHeader.NumberOfSections; ++i)
	{
		//õýڵĴС
		int nCodeSize = m_pSectionHeader[i].Misc.VirtualSize ;
		int nLoadSize = m_pSectionHeader[i].SizeOfRawData;
		int nMaxSize = (nLoadSize > nCodeSize) ? (nLoadSize) : (nCodeSize);
		int nSectionSize = GetAlignedSize(m_pSectionHeader[i].VirtualAddress + nMaxSize, nAlign);

		if (nSize < nSectionSize)
		{
			nSize = nSectionSize;  //Use the Max;
		}
	}

	return nSize;
}

//CopyDllDatasdllݸƵָڴ򣬲н
//pSrc: dllݵԭʼ
//pDest:Ŀڴַ
void CMemLoadDll::CopyDllDatas(void* pDest, void* pSrc)
{
	// ҪƵPEͷ+αֽ
	int  nHeaderSize = m_pNTHeader->OptionalHeader.SizeOfHeaders;
	int  nSectionSize = m_pNTHeader->FileHeader.NumberOfSections * sizeof(IMAGE_SECTION_HEADER);
	int  nMoveSize = nHeaderSize + nSectionSize;
	//ͷͶϢ
	memcpy(pDest, pSrc, nMoveSize);
	
	//ÿ
	for (int i=0; i < m_pNTHeader->FileHeader.NumberOfSections; ++i)
	{
		if (m_pSectionHeader[i].VirtualAddress == 0 || m_pSectionHeader[i].SizeOfRawData == 0)
		{
			continue;
		}
		// λýڴеλ
		void *pSectionAddress = (void *)((PBYTE)pDest + m_pSectionHeader[i].VirtualAddress);
		// ƶݵڴ
		memcpy((void *)pSectionAddress, (void *)((PBYTE)pSrc + m_pSectionHeader[i].PointerToRawData),
			m_pSectionHeader[i].SizeOfRawData);
	}
	
	//ָ룬ָ·ڴ
	//µdosͷ
	m_pDosHeader = (PIMAGE_DOS_HEADER)pDest;
	//µpeͷַ
	m_pNTHeader = (PIMAGE_NT_HEADERS)((PBYTE)pDest + (m_pDosHeader->e_lfanew));
	//µĽڱַ
	m_pSectionHeader = (PIMAGE_SECTION_HEADER)((PBYTE)m_pNTHeader + sizeof(IMAGE_NT_HEADERS));
}
