// Copyright (c) 2013 Marshall A. Greenblatt. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
//    * Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
//    * Redistributions in binary form must reproduce the above
// copyright notice, this list of conditions and the following disclaimer
// in the documentation and/or other materials provided with the
// distribution.
//    * Neither the name of Google Inc. nor the name Chromium Embedded
// Framework nor the names of its contributors may be used to endorse
// or promote products derived from this software without specific prior
// written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// ---------------------------------------------------------------------------
//
// This file was generated by the CEF translator tool and should not edited
// by hand. See the translator.README.txt file in the tools directory for
// more information.
//

#ifndef CEF_INCLUDE_CAPI_CEF_WEB_PLUGIN_CAPI_H_
#define CEF_INCLUDE_CAPI_CEF_WEB_PLUGIN_CAPI_H_
#pragma once

#ifdef __cplusplus
extern "C" {
#endif

#include "include/capi/cef_base_capi.h"


///
// Returns the number of installed web plugins. This function must be called on
// the UI thread.
///
CEF_EXPORT size_t cef_get_web_plugin_count();

///
// Returns information for web plugin at the specified zero-based index. This
// function must be called on the UI thread.
///
CEF_EXPORT struct _cef_web_plugin_info_t* cef_get_web_plugin_info(int index);

///
// Returns information for web plugin with the specified name. This function
// must be called on the UI thread.
///
CEF_EXPORT struct _cef_web_plugin_info_t* cef_get_web_plugin_info_byname(
    const cef_string_t* name);

///
// Information about a specific web plugin.
///
typedef struct _cef_web_plugin_info_t {
  ///
  // Base structure.
  ///
  cef_base_t base;

  ///
  // Returns the plugin name (i.e. Flash).
  ///
  // The resulting string must be freed by calling cef_string_userfree_free().
  cef_string_userfree_t (CEF_CALLBACK *get_name)(
      struct _cef_web_plugin_info_t* self);

  ///
  // Returns the plugin file path (DLL/bundle/library).
  ///
  // The resulting string must be freed by calling cef_string_userfree_free().
  cef_string_userfree_t (CEF_CALLBACK *get_path)(
      struct _cef_web_plugin_info_t* self);

  ///
  // Returns the version of the plugin (may be OS-specific).
  ///
  // The resulting string must be freed by calling cef_string_userfree_free().
  cef_string_userfree_t (CEF_CALLBACK *get_version)(
      struct _cef_web_plugin_info_t* self);

  ///
  // Returns a description of the plugin from the version information.
  ///
  // The resulting string must be freed by calling cef_string_userfree_free().
  cef_string_userfree_t (CEF_CALLBACK *get_description)(
      struct _cef_web_plugin_info_t* self);
} cef_web_plugin_info_t;


#ifdef __cplusplus
}
#endif

#endif  // CEF_INCLUDE_CAPI_CEF_WEB_PLUGIN_CAPI_H_
