// Copyright (c) 2013 Marshall A. Greenblatt. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
//    * Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
//    * Redistributions in binary form must reproduce the above
// copyright notice, this list of conditions and the following disclaimer
// in the documentation and/or other materials provided with the
// distribution.
//    * Neither the name of Google Inc. nor the name Chromium Embedded
// Framework nor the names of its contributors may be used to endorse
// or promote products derived from this software without specific prior
// written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// ---------------------------------------------------------------------------
//
// This file was generated by the CEF translator tool and should not edited
// by hand. See the translator.README.txt file in the tools directory for
// more information.
//

#ifndef CEF_INCLUDE_CAPI_CEF_MENU_HANDLER_CAPI_H_
#define CEF_INCLUDE_CAPI_CEF_MENU_HANDLER_CAPI_H_
#pragma once

#ifdef __cplusplus
extern "C" {
#endif

#include "include/capi/cef_base_capi.h"


///
// Implement this structure to handle events related to browser context menus.
// The functions of this structure will be called on the UI thread.
///
typedef struct _cef_menu_handler_t {
  ///
  // Base structure.
  ///
  cef_base_t base;

  ///
  // Called before a context menu is displayed. Return false (0) to display the
  // default context menu or true (1) to cancel the display.
  ///
  int (CEF_CALLBACK *on_before_menu)(struct _cef_menu_handler_t* self,
      struct _cef_browser_t* browser,
      const struct _cef_menu_info_t* menuInfo);

  ///
  // Called to optionally override the default text for a context menu item.
  // |label| contains the default text and may be modified to substitute
  // alternate text.
  ///
  void (CEF_CALLBACK *get_menu_label)(struct _cef_menu_handler_t* self,
      struct _cef_browser_t* browser, enum cef_menu_id_t menuId,
      cef_string_t* label);

  ///
  // Called when an option is selected from the default context menu. Return
  // false (0) to execute the default action or true (1) to cancel the action.
  ///
  int (CEF_CALLBACK *on_menu_action)(struct _cef_menu_handler_t* self,
      struct _cef_browser_t* browser, enum cef_menu_id_t menuId);
} cef_menu_handler_t;


#ifdef __cplusplus
}
#endif

#endif  // CEF_INCLUDE_CAPI_CEF_MENU_HANDLER_CAPI_H_
