// Copyright (c) 2013 Marshall A. Greenblatt. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
//    * Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
//    * Redistributions in binary form must reproduce the above
// copyright notice, this list of conditions and the following disclaimer
// in the documentation and/or other materials provided with the
// distribution.
//    * Neither the name of Google Inc. nor the name Chromium Embedded
// Framework nor the names of its contributors may be used to endorse
// or promote products derived from this software without specific prior
// written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// ---------------------------------------------------------------------------
//
// This file was generated by the CEF translator tool and should not edited
// by hand. See the translator.README.txt file in the tools directory for
// more information.
//

#ifndef CEF_INCLUDE_CAPI_CEF_SCHEME_CAPI_H_
#define CEF_INCLUDE_CAPI_CEF_SCHEME_CAPI_H_
#pragma once

#ifdef __cplusplus
extern "C" {
#endif

#include "include/capi/cef_base_capi.h"


///
// Register a scheme handler factory for the specified |scheme_name| and
// optional |domain_name|. An NULL |domain_name| value for a standard scheme
// will cause the factory to match all domain names. The |domain_name| value
// will be ignored for non-standard schemes. If |scheme_name| is a built-in
// scheme and no handler is returned by |factory| then the built-in scheme
// handler factory will be called. If |scheme_name| is a custom scheme the
// CefRegisterCustomScheme() function should be called for that scheme. This
// function may be called multiple times to change or remove the factory that
// matches the specified |scheme_name| and optional |domain_name|. Returns false
// (0) if an error occurs. This function may be called on any thread.
///
CEF_EXPORT int cef_register_scheme_handler_factory(
    const cef_string_t* scheme_name, const cef_string_t* domain_name,
    struct _cef_scheme_handler_factory_t* factory);

///
// Clear all registered scheme handler factories. Returns false (0) on error.
// This function may be called on any thread.
///
CEF_EXPORT int cef_clear_scheme_handler_factories();

///
// Structure that manages custom scheme registrations.
///
typedef struct _cef_scheme_registrar_t {
  ///
  // Base structure.
  ///
  cef_base_t base;

  ///
  // Register a custom scheme. This function should not be called for the built-
  // in HTTP, HTTPS, FILE, FTP, ABOUT and DATA schemes.
  //
  // If |is_standard| is true (1) the scheme will be treated as a standard
  // scheme. Standard schemes are subject to URL canonicalization and parsing
  // rules as defined in the Common Internet Scheme Syntax RFC 1738 Section 3.1
  // available at http://www.ietf.org/rfc/rfc1738.txt
  //
  // In particular, the syntax for standard scheme URLs must be of the form:
  // <pre>
  //  [scheme]://[username]:[password]@[host]:[port]/[url-path]
  // </pre> Standard scheme URLs must have a host component that is a fully
  // qualified domain name as defined in Section 3.5 of RFC 1034 [13] and
  // Section 2.1 of RFC 1123. These URLs will be canonicalized to
  // "scheme://host/path" in the simplest case and
  // "scheme://username:password@host:port/path" in the most explicit case. For
  // example, "scheme:host/path" and "scheme:///host/path" will both be
  // canonicalized to "scheme://host/path". The origin of a standard scheme URL
  // is the combination of scheme, host and port (i.e., "scheme://host:port" in
  // the most explicit case).
  //
  // For non-standard scheme URLs only the "scheme:" component is parsed and
  // canonicalized. The remainder of the URL will be passed to the handler as-
  // is. For example, "scheme:///some%20text" will remain the same. Non-standard
  // scheme URLs cannot be used as a target for form submission.
  //
  // If |is_local| is true (1) the scheme will be treated as local (i.e., with
  // the same security rules as those applied to "file" URLs). Normal pages
  // cannot link to or access local URLs. Also, by default, local URLs can only
  // perform XMLHttpRequest calls to the same URL (origin + path) that
  // originated the request. To allow XMLHttpRequest calls from a local URL to
  // other URLs with the same origin set the
  // CefSettings.file_access_from_file_urls_allowed value to true (1). To allow
  // XMLHttpRequest calls from a local URL to all origins set the
  // CefSettings.universal_access_from_file_urls_allowed value to true (1).
  //
  // If |is_display_isolated| is true (1) the scheme will be treated as display-
  // isolated. This means that pages cannot display these URLs unless they are
  // from the same scheme. For example, pages in another origin cannot create
  // iframes or hyperlinks to URLs with this scheme.
  //
  // This function may be called on any thread. It should only be called once
  // per unique |scheme_name| value. If |scheme_name| is already registered or
  // if an error occurs this function will return false (0).
  ///
  int (CEF_CALLBACK *add_custom_scheme)(struct _cef_scheme_registrar_t* self,
      const cef_string_t* scheme_name, int is_standard, int is_local,
      int is_display_isolated);
} cef_scheme_registrar_t;


///
// Structure that creates cef_scheme_handler_t instances. The functions of this
// structure will always be called on the IO thread.
///
typedef struct _cef_scheme_handler_factory_t {
  ///
  // Base structure.
  ///
  cef_base_t base;

  ///
  // Return a new scheme handler instance to handle the request. |browser| will
  // be the browser window that initiated the request. If the request was
  // initiated using the cef_web_urlrequest_t API |browser| will be NULL. The
  // |request| object passed to this function will not contain cookie data.
  ///
  struct _cef_scheme_handler_t* (CEF_CALLBACK *create)(
      struct _cef_scheme_handler_factory_t* self,
      struct _cef_browser_t* browser, const cef_string_t* scheme_name,
      struct _cef_request_t* request);
} cef_scheme_handler_factory_t;


///
// Structure used to facilitate asynchronous responses to custom scheme handler
// requests. The functions of this structure may be called on any thread.
///
typedef struct _cef_scheme_handler_callback_t {
  ///
  // Base structure.
  ///
  cef_base_t base;

  ///
  // Notify that header information is now available for retrieval.
  ///
  void (CEF_CALLBACK *headers_available)(
      struct _cef_scheme_handler_callback_t* self);

  ///
  // Notify that response data is now available for reading.
  ///
  void (CEF_CALLBACK *bytes_available)(
      struct _cef_scheme_handler_callback_t* self);

  ///
  // Cancel processing of the request.
  ///
  void (CEF_CALLBACK *cancel)(struct _cef_scheme_handler_callback_t* self);
} cef_scheme_handler_callback_t;


///
// Structure used to implement a custom scheme handler structure. The functions
// of this structure will always be called on the IO thread.
///
typedef struct _cef_scheme_handler_t {
  ///
  // Base structure.
  ///
  cef_base_t base;

  ///
  // Begin processing the request. To handle the request return true (1) and
  // call headers_available() once the response header information is available
  // (headers_available() can also be called from inside this function if header
  // information is available immediately). To cancel the request return false
  // (0).
  ///
  int (CEF_CALLBACK *process_request)(struct _cef_scheme_handler_t* self,
      struct _cef_request_t* request,
      struct _cef_scheme_handler_callback_t* callback);

  ///
  // Retrieve response header information. If the response length is not known
  // set |response_length| to -1 and read_response() will be called until it
  // returns false (0). If the response length is known set |response_length| to
  // a positive value and read_response() will be called until it returns false
  // (0) or the specified number of bytes have been read. Use the |response|
  // object to set the mime type, http status code and other optional header
  // values. To redirect the request to a new URL set |redirectUrl| to the new
  // URL.
  ///
  void (CEF_CALLBACK *get_response_headers)(struct _cef_scheme_handler_t* self,
      struct _cef_response_t* response, int64* response_length,
      cef_string_t* redirectUrl);

  ///
  // Read response data. If data is available immediately copy up to
  // |bytes_to_read| bytes into |data_out|, set |bytes_read| to the number of
  // bytes copied, and return true (1). To read the data at a later time set
  // |bytes_read| to 0, return true (1) and call bytes_available() when the data
  // is available. To indicate response completion return false (0).
  ///
  int (CEF_CALLBACK *read_response)(struct _cef_scheme_handler_t* self,
      void* data_out, int bytes_to_read, int* bytes_read,
      struct _cef_scheme_handler_callback_t* callback);

  ///
  // Request processing has been canceled.
  ///
  void (CEF_CALLBACK *cancel)(struct _cef_scheme_handler_t* self);
} cef_scheme_handler_t;


#ifdef __cplusplus
}
#endif

#endif  // CEF_INCLUDE_CAPI_CEF_SCHEME_CAPI_H_
