// Copyright (c) 2013 Marshall A. Greenblatt. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
//    * Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
//    * Redistributions in binary form must reproduce the above
// copyright notice, this list of conditions and the following disclaimer
// in the documentation and/or other materials provided with the
// distribution.
//    * Neither the name of Google Inc. nor the name Chromium Embedded
// Framework nor the names of its contributors may be used to endorse
// or promote products derived from this software without specific prior
// written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// ---------------------------------------------------------------------------
//
// This file was generated by the CEF translator tool and should not edited
// by hand. See the translator.README.txt file in the tools directory for
// more information.
//

#ifndef CEF_INCLUDE_CAPI_CEF_WEB_URLREQUEST_CAPI_H_
#define CEF_INCLUDE_CAPI_CEF_WEB_URLREQUEST_CAPI_H_
#pragma once

#ifdef __cplusplus
extern "C" {
#endif

#include "include/capi/cef_base_capi.h"


///
// Structure used to make a Web URL request. Web URL requests are not associated
// with a browser instance so no cef_client_t callbacks will be executed. The
// functions of this structure may be called on any thread.
///
typedef struct _cef_web_urlrequest_t {
  ///
  // Base structure.
  ///
  cef_base_t base;

  ///
  // Cancels the request.
  ///
  void (CEF_CALLBACK *cancel)(struct _cef_web_urlrequest_t* self);

  ///
  // Returns the current ready state of the request.
  ///
  enum cef_weburlrequest_state_t (CEF_CALLBACK *get_state)(
      struct _cef_web_urlrequest_t* self);
} cef_web_urlrequest_t;


///
// Create a new CefWebUrlRequest object.
///
CEF_EXPORT cef_web_urlrequest_t* cef_web_urlrequest_create(
    struct _cef_request_t* request,
    struct _cef_web_urlrequest_client_t* client);


///
// Structure that should be implemented by the cef_web_urlrequest_t client. The
// functions of this structure will always be called on the UI thread.
///
typedef struct _cef_web_urlrequest_client_t {
  ///
  // Base structure.
  ///
  cef_base_t base;

  ///
  // Notifies the client that the request state has changed. State change
  // notifications will always be sent before the below notification functions
  // are called.
  ///
  void (CEF_CALLBACK *on_state_change)(
      struct _cef_web_urlrequest_client_t* self,
      struct _cef_web_urlrequest_t* requester,
      enum cef_weburlrequest_state_t state);

  ///
  // Notifies the client that the request has been redirected and  provides a
  // chance to change the request parameters.
  ///
  void (CEF_CALLBACK *on_redirect)(struct _cef_web_urlrequest_client_t* self,
      struct _cef_web_urlrequest_t* requester, struct _cef_request_t* request,
      struct _cef_response_t* response);

  ///
  // Notifies the client of the response data.
  ///
  void (CEF_CALLBACK *on_headers_received)(
      struct _cef_web_urlrequest_client_t* self,
      struct _cef_web_urlrequest_t* requester,
      struct _cef_response_t* response);

  ///
  // Notifies the client of the upload progress.
  ///
  void (CEF_CALLBACK *on_progress)(struct _cef_web_urlrequest_client_t* self,
      struct _cef_web_urlrequest_t* requester, uint64 bytesSent,
      uint64 totalBytesToBeSent);

  ///
  // Notifies the client that content has been received.
  ///
  void (CEF_CALLBACK *on_data)(struct _cef_web_urlrequest_client_t* self,
      struct _cef_web_urlrequest_t* requester, const void* data,
      int dataLength);

  ///
  // Notifies the client that the request ended with an error.
  ///
  void (CEF_CALLBACK *on_error)(struct _cef_web_urlrequest_client_t* self,
      struct _cef_web_urlrequest_t* requester,
      enum cef_handler_errorcode_t errorCode);
} cef_web_urlrequest_client_t;


#ifdef __cplusplus
}
#endif

#endif  // CEF_INCLUDE_CAPI_CEF_WEB_URLREQUEST_CAPI_H_
