# Copyright 1999-2020 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=7

PYTHON_COMPAT=( python3_{6,7} )

inherit distutils-r1

MY_PV="acora-${PV}"

if [[ ${PV} = *9999* ]]; then
	inherit git-r3
	EGIT_REPO_URI="https://github.com/scoder/acora.git"
else
	HASH_COMMIT="${MY_PV}"
	SRC_URI="https://github.com/scoder/acora/archive/${HASH_COMMIT}.tar.gz -> ${P}.tar.gz"
fi

DESCRIPTION="Fast multi-keyword search engine for text strings"
HOMEPAGE="https://github.com/scoder/acora"

LICENSE="public-domain"
SLOT="0"
#KEYWORDS="~amd64 ~x86"

# Commented out KEYWORDS because this dep doesn't install yet due to compile
# errors:
#
# Traceback (most recent call last):
#   File "setup.py", line 28, in <module>
#     sys.argv.remove('--no-compile')
# ValueError: list.remove(x): x not in list

S="${WORKDIR}/${PN}-${MY_PV}"
