# Copyright 1999-2019 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=7

AVC=( $(ver_rs 1- ' ') )
MY_PV_YYYY="${AVC[0]}"
MY_PV_YY="${AVC[0]:2:4}"
MY_PV_MM="${AVC[1]}"

DESCRIPTION="Archive of packetstorm exploits"
HOMEPAGE="https://packetstormsecurity.com/"

if [[ ${MY_PV_MM} == "12" ]]; then
	#Use yearly archives
	SRC_URI="https://dl.packetstormsecurity.net/${MY_PV_YY}${MY_PV_MM}-exploits/${MY_PV_YYYY}-exploits.tgz"
else
	#Use monthly archives
	for MY_M in $(eval echo "{01..$MY_PV_MM}"); do
		SRC_URI="${SRC_URI}  https://dl.packetstormsecurity.net/${MY_PV_YY}${MY_M}-exploits/${MY_PV_YY}${MY_M}-exploits.tgz"
	done
fi

KEYWORDS="amd64 arm x86"
LICENSE="HPND"
SLOT="${MY_PV_YYYY}"

S="${WORKDIR}"

src_install() {
	insinto /usr/share/exploits/${PN}/
	doins -r *
}
