# Copyright 1999-2020 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=7

PYTHON_COMPAT=( python3_{6,7} )
PYTHON_REQ_USE="sqlite(+)"

inherit distutils-r1

DESCRIPTION="Command line utility for searching and downloading exploits"
HOMEPAGE="https://github.com/vulnersCom/getsploit"

if [[ ${PV} == *9999 ]]; then
	inherit git-r3
	EGIT_REPO_URI="https://github.com/vulnersCom/getsploit"
else
	# snapshot: 20190530
	HASH_COMMIT="5993293fc22d98d8e9a7a2bd205fcd9824e332f1"

	SRC_URI="https://github.com/vulnersCom/getsploit/archive/${HASH_COMMIT}.tar.gz -> ${P}.tar.gz"
	KEYWORDS="amd64 ~x86"
	S="${WORKDIR}/${PN}-${HASH_COMMIT}"
fi

LICENSE="LGPL-3"
SLOT="0"

DEPEND="${PYTHON_DEPS}"
RDEPEND="${DEPEND}
	dev-python/clint[${PYTHON_USEDEP}]
	dev-python/six[${PYTHON_USEDEP}]
	dev-python/texttable[${PYTHON_USEDEP}]
	dev-python/urllib3[${PYTHON_USEDEP}]
	dev-python/vulners[${PYTHON_USEDEP}]"

pkg_postinst() {
	elog "\nSee documentation: https://github.com/vulnersCom/getsploit#how-to-use\n"
}
