# Copyright 1999-2020 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=7

EGO_PN="github.com/future-architect/vuls"

# Autogenerated by: pentoo/scripts/ego_vendor_generator.sh
EGO_VENDOR=(
	"github.com/Azure/azure-sdk-for-go v33.1.0"
	"github.com/Azure/go-ansiterm d6e3b33"
	"github.com/Azure/go-autorest autorest%2Fadal%2Fv0.5.0"
	"github.com/Azure/go-autorest autorest%2Fdate%2Fv0.1.0"
	"github.com/Azure/go-autorest autorest%2Fmocks%2Fv0.2.0"
	"github.com/Azure/go-autorest autorest%2Fto%2Fv0.3.0"
	"github.com/Azure/go-autorest autorest%2Fv0.9.1"
	"github.com/Azure/go-autorest logger%2Fv0.1.0"
	"github.com/Azure/go-autorest tracing%2Fv0.5.0"
	"github.com/BurntSushi/toml v0.3.1"
	"github.com/GoogleCloudPlatform/docker-credential-gcr v1.5.0"
	"github.com/Microsoft/go-winio v0.4.12"
	"github.com/Nvveen/Gotty cd52737"
	"github.com/OneOfOne/xxhash v1.2.2"
	"github.com/RackSec/srslog a4725f0"
	"github.com/Shopify/sarama v1.19.0"
	"github.com/Shopify/toxiproxy v2.1.4"
	"github.com/alcortesm/tgz 9c5fe88"
	"github.com/alecthomas/template a0175ee"
	"github.com/alecthomas/units 2efee85"
	"github.com/anmitsu/go-shlex 648efa6"
	"github.com/apache/thrift v0.12.0"
	"github.com/aquasecurity/fanal f04452b"
	"github.com/aquasecurity/go-dep-parser ea223f0"
	"github.com/aquasecurity/trivy v0.1.6"
	"github.com/armon/consul-api eb2c6b5"
	"github.com/asaskevich/govalidator f61b66f"
	"github.com/aws/aws-sdk-go v1.23.17"
	"github.com/beorn7/perks v1.0.0"
	"github.com/boltdb/bolt v1.3.1"
	"github.com/briandowns/spinner ac46072"
	"github.com/caarlos0/env v6.0.0"
	"github.com/caarlos0/env/v6 v6.0.0 github.com/caarlos0/env"
	"github.com/cenkalti/backoff v2.2.1"
	"github.com/cespare/xxhash v1.1.0"
	"github.com/cheggaaa/pb v2.0.7"
	"github.com/client9/misspell v0.3.4"
	"github.com/containerd/continuity aaeac12"
	"github.com/coreos/bbolt v1.3.2"
	"github.com/coreos/etcd v3.3.10"
	"github.com/coreos/go-etcd v2.0.0"
	"github.com/coreos/go-semver v0.2.0"
	"github.com/coreos/go-systemd 95778df"
	"github.com/coreos/pkg 399ea9e"
	"github.com/cpuguy83/go-md2man v1.0.10"
	"github.com/davecgh/go-spew v1.1.1"
	"github.com/deckarep/golang-set v1.7.1"
	"github.com/denisenkom/go-mssqldb eb9f6a1"
	"github.com/dgrijalva/jwt-go v3.2.0"
	"github.com/dgryski/go-sip13 e10d5fe"
	"github.com/dnaeon/go-vcr v1.0.1"
	"github.com/eapache/go-resiliency v1.1.0"
	"github.com/eapache/go-xerial-snappy 776d571"
	"github.com/eapache/queue v1.1.0"
	"github.com/elazarl/goproxy 473e67f"
	"github.com/emirpasic/gods v1.12.0"
	"github.com/erikstmartin/go-testdb 8d10e4a"
	"github.com/etcd-io/bbolt v1.3.2"
	"github.com/fatih/color v1.7.0"
	"github.com/flynn/go-shlex 3f9db97"
	"github.com/fsnotify/fsnotify v1.4.7"
	"github.com/genuinetools/pkg 2fcf164"
	"github.com/genuinetools/reg 2a2250f"
	"github.com/ghodss/yaml v1.0.0"
	"github.com/gliderlabs/ssh v0.1.3"
	"github.com/go-kit/kit v0.8.0"
	"github.com/go-logfmt/logfmt v0.4.0"
	"github.com/go-redis/redis v6.15.2"
	"github.com/go-sql-driver/mysql v1.4.1"
	"github.com/go-stack/stack v1.8.0"
	"github.com/gogo/protobuf v1.2.1"
	"github.com/golang/glog 23def4e"
	"github.com/golang/groupcache 5b532d6"
	"github.com/golang/mock v1.2.0"
	"github.com/golang/protobuf v1.3.1"
	"github.com/golang/snappy 2e65f85"
	"github.com/google/btree v1.0.0"
	"github.com/google/go-cmp v0.3.0"
	"github.com/google/martian v2.1.0"
	"github.com/google/pprof 3ea8567"
	"github.com/google/subcommands v1.0.1"
	"github.com/googleapis/gax-go v2.0.4"
	"github.com/gopherjs/gopherjs 0766667"
	"github.com/gorilla/context v1.1.1"
	"github.com/gorilla/mux v1.7.1"
	"github.com/gorilla/websocket v1.4.0"
	"github.com/gosuri/uitable v0.0.3"
	"github.com/grokify/html-strip-tags-go 025bd76"
	"github.com/grpc-ecosystem/go-grpc-middleware v1.0.0"
	"github.com/grpc-ecosystem/go-grpc-prometheus v1.2.0"
	"github.com/grpc-ecosystem/grpc-gateway v1.9.0"
	"github.com/hashicorp/go-version v1.2.0"
	"github.com/hashicorp/golang-lru v0.5.0"
	"github.com/hashicorp/hcl v1.0.0"
	"github.com/hashicorp/uuid ebb0a03"
	"github.com/howeyc/gopass bf9dde6"
	"github.com/hpcloud/tail v1.0.0"
	"github.com/htcat/htcat v1.0.2"
	"github.com/inconshreveable/log15 67afb5e"
	"github.com/inconshreveable/mousetrap v1.0.0"
	"github.com/jbenet/go-context d14ea06"
	"github.com/jessevdk/go-flags v1.4.0"
	"github.com/jinzhu/gorm v1.9.10"
	"github.com/jinzhu/inflection v1.0.0"
	"github.com/jinzhu/now v1.0.1"
	"github.com/jmespath/go-jmespath c2b33e8"
	"github.com/jonboulle/clockwork v0.1.0"
	"github.com/jroimartin/gocui v0.4.0"
	"github.com/jstemmer/go-junit-report af01ea7"
	"github.com/jtolds/gls v4.20.0"
	"github.com/julienschmidt/httprouter v1.2.0"
	"github.com/k0kubun/colorstring 9440f19"
	"github.com/k0kubun/pp v3.0.1"
	"github.com/kevinburke/ssh_config 81db2a7"
	"github.com/kisielk/errcheck v1.1.0"
	"github.com/kisielk/gotool v1.0.0"
	"github.com/knqyf263/berkeleydb fafe01f"
	"github.com/knqyf263/go-cpe 659663f"
	"github.com/knqyf263/go-deb-version 09fca49"
	"github.com/knqyf263/go-rpm-version 74609b8"
	"github.com/knqyf263/go-rpmdb 10a1c42"
	"github.com/knqyf263/go-version v1.1.1"
	"github.com/knqyf263/gost v0.1.2"
	"github.com/knqyf263/nested v0.0.1"
	"github.com/konsorten/go-windows-terminal-sequences v1.0.2"
	"github.com/kotakanbe/go-cve-dictionary v0.4.0"
	"github.com/kotakanbe/go-pingscanner v0.1.0"
	"github.com/kotakanbe/goval-dictionary v0.2.2"
	"github.com/kotakanbe/logrus-prefixed-formatter 928f735"
	"github.com/kr/logfmt b84e30a"
	"github.com/kr/pretty v0.1.0"
	"github.com/kr/pty v1.1.1"
	"github.com/kr/text v0.1.0"
	"github.com/kylelemons/godebug d65d576"
	"github.com/labstack/echo v3.3.10"
	"github.com/labstack/gommon v0.2.9"
	"github.com/lib/pq v1.1.1"
	"github.com/magiconair/properties v1.8.0"
	"github.com/mattn/go-colorable v0.1.2"
	"github.com/mattn/go-isatty v0.0.8"
	"github.com/mattn/go-runewidth v0.0.4"
	"github.com/mattn/go-sqlite3 v1.11.0"
	"github.com/matttproud/golang_protobuf_extensions v1.0.1"
	"github.com/mgutz/ansi 9520e82"
	"github.com/mitchellh/go-homedir v1.1.0"
	"github.com/mitchellh/go-wordwrap v1.0.0"
	"github.com/mitchellh/mapstructure v1.1.2"
	"github.com/moul/http2curl v1.0.0"
	"github.com/mozqnet/go-exploitdb a055cc2"
	"github.com/mwitkow/go-conntrack cc309e4"
	"github.com/nlopes/slack v0.6.0"
	"github.com/nsf/termbox-go 93860e1"
	"github.com/oklog/ulid v1.3.1"
	"github.com/olekukonko/tablewriter cc27d85"
	"github.com/onsi/ginkgo v1.7.0"
	"github.com/onsi/gomega v1.4.3"
	"github.com/openzipkin/zipkin-go v0.1.6"
	"github.com/parnurzeal/gorequest v0.2.15"
	"github.com/pelletier/go-buffruneio v0.2.0"
	"github.com/pelletier/go-toml v1.2.0"
	"github.com/peterhellberg/link v1.0.0"
	"github.com/pierrec/lz4 v2.0.5"
	"github.com/pkg/errors v0.8.1"
	"github.com/pmezard/go-difflib v1.0.0"
	"github.com/prometheus/client_golang v0.9.3"
	"github.com/prometheus/client_model fd36f42"
	"github.com/prometheus/common v0.4.0"
	"github.com/prometheus/procfs 5867b95"
	"github.com/prometheus/tsdb v0.7.1"
	"github.com/rcrowley/go-metrics 3113b84"
	"github.com/rifflock/lfshook b9218ef"
	"github.com/rogpeppe/fastuuid 6724a57"
	"github.com/rogpeppe/go-charset 2471d30"
	"github.com/russross/blackfriday v1.5.2"
	"github.com/satori/go.uuid v1.2.0"
	"github.com/sergi/go-diff v1.0.0"
	"github.com/shurcooL/httpfs 74dc933"
	"github.com/sirupsen/logrus v1.4.2"
	"github.com/smartystreets/assertions b2de0cb"
	"github.com/smartystreets/goconvey 505e419"
	"github.com/soheilhy/cmux v0.1.4"
	"github.com/spaolacci/murmur3 f09979e"
	"github.com/spf13/afero v1.1.2"
	"github.com/spf13/cast v1.3.0"
	"github.com/spf13/cobra v0.0.5"
	"github.com/spf13/jwalterweatherman v1.0.0"
	"github.com/spf13/pflag v1.0.3"
	"github.com/spf13/viper v1.4.0"
	"github.com/src-d/gcfg v1.4.0"
	"github.com/stretchr/objx v0.2.0"
	"github.com/stretchr/testify v1.3.0"
	"github.com/tealeg/xlsx v1.0.3"
	"github.com/tmc/grpc-websocket-proxy 0ad062e"
	"github.com/ugorji/go v1.1.4"
	"github.com/urfave/cli v1.20.0"
	"github.com/valyala/bytebufferpool v1.0.0"
	"github.com/valyala/fasttemplate v1.0.1"
	"github.com/xanzy/ssh-agent v0.2.1"
	"github.com/xiang90/probing 43a291a"
	"github.com/xordataexchange/crypt b2862e3"
	"github.com/ymomoi/goval-parser 0a0be1d"
	"go.etcd.io/bbolt v1.3.2 github.com/etcd-io/bbolt"
	"go.opencensus.io v0.20.1 github.com/census-instrumentation/opencensus-go"
	"go.uber.org/atomic v1.4.0 github.com/uber-go/atomic"
	"go.uber.org/multierr v1.1.0 github.com/uber-go/multierr"
	"go.uber.org/zap v1.10.0 github.com/uber-go/zap"
	"golang.org/x/crypto 20be4c3c3ed5 github.com/golang/crypto"
	"golang.org/x/net 1617124 github.com/golang/net"
	"golang.org/x/oauth2 0f29369 github.com/golang/oauth2"
	"golang.org/x/sys fde4db37ae7a github.com/golang/sys"
	"golang.org/x/xerrors a985d34 github.com/golang/xerrors"
	"gopkg.in/VividCortex/ewma.v1 v1.1.1 github.com/VividCortex/ewma"
	"gopkg.in/alecthomas/kingpin.v2 v2.2.6 github.com/alecthomas/kingpin"
	"gopkg.in/check.v1 41f04d3 github.com/go-check/check"
	"gopkg.in/cheggaaa/pb.v1 v1.0.28 github.com/cheggaaa/pb"
	"gopkg.in/cheggaaa/pb.v2 v2.0.7 github.com/cheggaaa/pb"
	"gopkg.in/fatih/color.v1 v1.7.0 github.com/fatih/color"
	"gopkg.in/fsnotify.v1 v1.4.7 github.com/fsnotify/fsnotify"
	"gopkg.in/mattn/go-colorable.v0 v0.1.2 github.com/mattn/go-colorable"
	"gopkg.in/mattn/go-isatty.v0 v0.0.8 github.com/mattn/go-isatty"
	"gopkg.in/mattn/go-runewidth.v0 v0.0.4 github.com/mattn/go-runewidth"
	"gopkg.in/resty.v1 v1.12.0 github.com/go-resty/resty"
	"gopkg.in/src-d/go-billy.v4 v4.3.0 github.com/src-d/go-billy"
	"gopkg.in/src-d/go-git-fixtures.v3 v3.4.0 github.com/src-d/go-git-fixtures"
	"gopkg.in/src-d/go-git.v4 v4.10.0 github.com/src-d/go-git"
	"gopkg.in/tomb.v1 dd63297 github.com/go-tomb/tomb"
	"gopkg.in/warnings.v0 v0.1.2 github.com/go-warnings/warnings"
	"gopkg.in/yaml.v2 v2.2.2 github.com/go-yaml/yaml"
	"gotest.tools v2.2.0 github.com/gotestyourself/gotest.tools"
	"honnef.co/go/tools 3f1c825 github.com/dominikh/go-tools"
)

inherit eutils golang-vcs-snapshot systemd

DESCRIPTION="Vulnerability scanner for Linux, agentless, written in Golang"
HOMEPAGE="https://vuls.io https://github.com/future-architect/vuls"

SRC_URI="https://github.com/future-architect/vuls/archive/v${PV}.tar.gz -> ${P}.tar.gz
	${EGO_VENDOR_URI}"

KEYWORDS="~amd64"
LICENSE="GPL-2"
IUSE="policykit systemd"
RESTRICT="mirror"
SLOT=0

DEPEND="
	dev-go/go-text:=
	>=dev-lang/go-1.12"

RDEPEND="
	dev-go/go-cve-dictionary[policykit=]
	dev-go/goval-dictionary[policykit=]
	dev-go/gost[policykit=]
	dev-go/go-exploitdb[policykit=]
	policykit? (
		acct-group/vuls
		acct-user/vuls
		sys-auth/polkit
	)
	virtual/ssh"

src_unpack() {
	local my_ego_pn="github.com/genuinetools/reg"
	local my_ego_vendor=(
		"github.com/docker/cli"
		"github.com/docker/distribution"
		"github.com/docker/docker"
		"github.com/docker/docker-ce"
		"github.com/docker/docker-credential-helpers"
		"github.com/docker/go-connections"
		"github.com/docker/go-metrics"
		"github.com/docker/go-units"
		"github.com/docker/libtrust"
		"github.com/opencontainers/go-digest"
		"github.com/opencontainers/image-spec"
		"github.com/opencontainers/runc"
	)

	golang-vcs-snapshot_src_unpack

	# Using forked version by genuinetools instead of github.com/docker/{cli,docker,etc}
	# FIX: wrong type for References method
	#   have References() []"../github.com/docker/distribution".Descriptor
	#   want References() []"../github.com/genuinetools/reg/vendor/github.com/docker/distribution".Descriptor
	cd "${S}/src/${EGO_PN}" || die
	for x in ${my_ego_vendor[@]}; do
		einfo "Vendoring ${x} (forked version)"
		mkdir -p "vendor/${x}/" \
			&& mv "vendor/${my_ego_pn}/vendor/${x}"/* "vendor/${x}/" || die
	done
}

src_prepare() {
	# FIXME:
	# -ldflags="-X config/config.Version=${PV}" — is does't work for me
	sed -e "s/var Version = \"\(.*\)\"/var Version = \"${PV}\"/" \
		-i "src/${EGO_PN}/config/config.go" || die

	cp "${FILESDIR}"/vuls-server.{initd,service} "${T}" || die

	if ! use policykit; then
		sed -e "s/^USER=\"vuls\"/USER=\"root\"/" \
			-e "s/^GROUP=\"vuls\"/GROUP=\"root\"/" \
			-i "${T}"/vuls-server.initd || die
		if use systemd; then
			sed -e "s/^User = vuls//;s/^Group = vuls//" \
				-i "${T}"/vuls-server.service || die
		fi
	fi

	default
}

src_compile() {
	# You may get some errors using distcc
	GOPATH="${S}:$(get_golibdir_gopath)" \
		GOCACHE="${T}/go-cache" \
		go build -v -work -x -ldflags="-s -w" ./... "${EGO_PN}" || die
}

src_install() {
	GOPATH="${S}:$(get_golibdir_gopath)" \
		GOCACHE="${T}/go-cache" \
		go install -v -work -x -ldflags="-s -w" ./... "${EGO_PN}" || die

	rm -rf "${S}/src/${EGO_PN}/vendor" || die
	golang_install_pkgs

	exeinto "$(get_golibdir_gopath)"/bin
	doexe bin/${PN}

	insinto "/etc/${PN}"
	doins "${FILESDIR}"/server-config.toml

	fowners -R ${PN}:${PN} "/etc/${PN}"
	fperms 0750 "/etc/${PN}"

	use systemd && systemd_dounit "${T}"/vuls-server.service
	newinitd "${T}"/vuls-server.initd vuls-server
	newconfd "${FILESDIR}"/vuls-server.confd vuls-server

	if use policykit; then
		insinto "/usr/share/polkit-1/rules.d"
		doins "${FILESDIR}"/polkit/10-${PN}.rules

		insinto "/usr/share/polkit-1/actions"
		doins "${FILESDIR}"/polkit/io.vuls.pkexec.${PN}.policy

		dodir "/usr/bin"
		cat > "${D}/usr/bin/${PN}" <<-_EOF_ || die
			#!/bin/sh
			pkexec --user ${PN} "$(get_golibdir_gopath)/bin/${PN}" "\$@"
		_EOF_

		fperms 0755 "/usr/bin/${PN}"
	else
		dosym "$(get_golibdir_gopath)/bin/${PN}" "/usr/bin/${PN}"
	fi

	keepdir "/var/log/${PN}" "/var/lib/${PN}"

	dodoc \
		src/"${EGO_PN}"/{README.md,Dockerfile} \
		"${FILESDIR}"/config.toml.sample
}

pkg_postinst() {
	if use policykit; then
		chown -R ${PN}:${PN} \
			"${EROOT%/}/var/log/vuls" || die

		chmod 0770 \
			"${EROOT%/}/var/log/vuls" || die

		ewarn "\n1) Add youself to \"vuls\" group and re-login:"
		ewarn "    ~# gpasswd -a <username> vuls\n"
		ewarn "2) If you want to use remote scan via SSH you need to generate a ssh key using:"
		ewarn "    ~$ pkexec --user ${PN} \"ssh-keygen\""
		ewarn "    ~$ pkexec --user ${PN} \"ssh-copy-id\" \"user@192.168.10.23\"\n"
		ewarn "3) Create a config.toml file in /var/lib/${PN}/:"
		ewarn "    ~$ bzip2 -dc /usr/share/doc/vuls-${PV}/config.toml.sample.bz2 > /var/lib/${PN}/config.toml\n"
	fi

	ewarn "\nWARNING!"
	ewarn "You need to rm /var/lib/${PN}/cve.sqlite3 and re-fetch NVD (and JVN) database\n"
}
