# Copyright 2017-2018 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2

EAPI=7

CRATES="
adler32-1.0.3
aho-corasick-0.6.9
arrayvec-0.4.9
base64-0.9.3
bitflags-1.0.4
build_const-0.2.1
byteorder-1.2.7
bytes-0.4.11
bzip2-0.3.3
bzip2-sys-0.1.7
cc-1.0.27
cfg-if-0.1.6
chrono-0.4.6
clap-2.32.0
cloudabi-0.0.3
cookie-0.11.0
crc-1.8.1
crc32fast-1.1.2
crossbeam-deque-0.6.3
crossbeam-epoch-0.7.0
crossbeam-utils-0.6.3
flate2-1.0.6
fnv-1.0.6
fuchsia-zircon-0.3.3
fuchsia-zircon-sys-0.3.3
futures-0.1.25
futures-cpupool-0.1.8
h2-0.1.14
http-0.1.14
httparse-1.3.3
hyper-0.12.19
idna-0.1.5
indexmap-1.0.2
iovec-0.1.2
itoa-0.4.3
kernel32-sys-0.2.2
lazy_static-1.2.0
lazycell-1.2.1
libc-0.2.45
lock_api-0.1.5
log-0.4.6
matches-0.1.8
memchr-2.1.2
memoffset-0.2.1
miniz_oxide-0.2.0
miniz_oxide_c_api-0.2.0
mio-0.6.16
mio-uds-0.6.7
miow-0.2.1
mozprofile-0.4.0
mozrunner-0.8.0
mozversion-0.1.3
msdos_time-0.1.6
net2-0.2.33
nodrop-0.1.13
num-integer-0.1.39
num-traits-0.2.6
num_cpus-1.9.0
owning_ref-0.4.0
parking_lot-0.6.4
parking_lot_core-0.3.1
percent-encoding-1.0.1
podio-0.1.6
proc-macro2-0.4.24
quote-0.6.10
rand-0.3.22
rand-0.4.3
rand-0.5.5
rand-0.6.1
rand_chacha-0.1.0
rand_core-0.2.2
rand_core-0.3.0
rand_hc-0.1.0
rand_isaac-0.1.1
rand_pcg-0.1.1
rand_xorshift-0.1.0
redox_syscall-0.1.44
regex-0.2.11
regex-1.1.0
regex-syntax-0.5.6
regex-syntax-0.6.4
remove_dir_all-0.5.1
rust-ini-0.10.3
rustc_version-0.2.3
ryu-0.2.7
safemem-0.3.0
scopeguard-0.3.3
semver-0.6.0
semver-0.9.0
semver-parser-0.7.0
serde-1.0.82
serde_derive-1.0.82
serde_json-1.0.33
slab-0.4.1
smallvec-0.6.7
stable_deref_trait-1.1.1
string-0.1.2
strsim-0.7.0
syn-0.15.23
tempdir-0.3.7
term_size-0.3.1
textwrap-0.10.0
thread_local-0.3.6
time-0.1.41
tokio-0.1.13
tokio-codec-0.1.1
tokio-current-thread-0.1.4
tokio-executor-0.1.5
tokio-fs-0.1.4
tokio-io-0.1.10
tokio-reactor-0.1.7
tokio-tcp-0.1.2
tokio-threadpool-0.1.9
tokio-timer-0.2.8
tokio-udp-0.1.3
tokio-uds-0.2.4
try-lock-0.2.2
ucd-util-0.1.3
unicode-bidi-0.3.4
unicode-normalization-0.1.7
unicode-segmentation-1.2.1
unicode-width-0.1.5
unicode-xid-0.1.0
unreachable-1.0.0
url-1.7.2
utf8-ranges-1.0.2
uuid-0.5.1
version_check-0.1.5
void-1.0.2
want-0.0.6
webdriver-0.38.0
winapi-0.2.8
winapi-0.3.6
winapi-build-0.1.1
winapi-i686-pc-windows-gnu-0.4.0
winapi-x86_64-pc-windows-gnu-0.4.0
winreg-0.5.1
ws2_32-sys-0.2.1
zip-0.4.2
"

inherit cargo

DESCRIPTION="Proxy for using WebDriver clients to interact with Gecko-based browsers."
HOMEPAGE="https://hg.mozilla.org/mozilla-central/file/tip/testing/geckodriver"
SRC_URI="https://github.com/mozilla/${PN}/archive/v${PV}.tar.gz -> ${P}.tar.gz
	$(cargo_crate_uris ${CRATES})"
RESTRICT="mirror"
LICENSE="MPL-2.0"
SLOT="0"
KEYWORDS="~amd64"
IUSE=""

DEPEND=""
RDEPEND=""
DOCS=(
	"README.md"
	"CHANGES.md"
	"CONTRIBUTING.md"
	"doc/TraceLogs.md"
)

src_install() {
	cargo_src_install
	einstalldocs
}
