# Copyright 1999-2020 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=7

EGO_PN="github.com/knqyf263/gost"

# Autogenerated by: pentoo/scripts/ego_vendor_generator.sh
EGO_VENDOR=(
	"github.com/BurntSushi/toml v0.3.1"
	"github.com/OneOfOne/xxhash v1.2.2"
	"github.com/Shopify/sarama v1.19.0"
	"github.com/Shopify/toxiproxy v2.1.4"
	"github.com/alecthomas/template a0175ee"
	"github.com/alecthomas/units 2efee85"
	"github.com/apache/thrift v0.12.0"
	"github.com/armon/consul-api eb2c6b5"
	"github.com/beorn7/perks v1.0.0"
	"github.com/cenkalti/backoff v2.1.1"
	"github.com/cespare/xxhash v1.1.0"
	"github.com/cheggaaa/pb v2.0.7"
	"github.com/client9/misspell v0.3.4"
	"github.com/coreos/bbolt v1.3.2"
	"github.com/coreos/etcd v3.3.10"
	"github.com/coreos/go-etcd v2.0.0"
	"github.com/coreos/go-semver v0.2.0"
	"github.com/coreos/go-systemd 95778df"
	"github.com/coreos/pkg 399ea9e"
	"github.com/cpuguy83/go-md2man v1.0.10"
	"github.com/davecgh/go-spew v1.1.1"
	"github.com/denisenkom/go-mssqldb eb9f6a1"
	"github.com/dgrijalva/jwt-go v3.2.0"
	"github.com/dgryski/go-sip13 e10d5fe"
	"github.com/eapache/go-resiliency v1.1.0"
	"github.com/eapache/go-xerial-snappy 776d571"
	"github.com/eapache/queue v1.1.0"
	"github.com/erikstmartin/go-testdb 8d10e4a"
	"github.com/fsnotify/fsnotify v1.4.7"
	"github.com/ghodss/yaml v1.0.0"
	"github.com/go-kit/kit v0.8.0"
	"github.com/go-logfmt/logfmt v0.4.0"
	"github.com/go-redis/redis v6.15.2"
	"github.com/go-sql-driver/mysql v1.4.1"
	"github.com/go-stack/stack v1.8.0"
	"github.com/gogo/protobuf v1.2.1"
	"github.com/golang/glog 23def4e"
	"github.com/golang/groupcache 5b532d6"
	"github.com/golang/mock v1.2.0"
	"github.com/golang/protobuf v1.3.1"
	"github.com/golang/snappy 2e65f85"
	"github.com/google/btree v1.0.0"
	"github.com/google/go-cmp v0.2.0"
	"github.com/google/martian v2.1.0"
	"github.com/google/pprof 3ea8567"
	"github.com/googleapis/gax-go v2.0.4"
	"github.com/gorilla/context v1.1.1"
	"github.com/gorilla/mux v1.6.2"
	"github.com/gorilla/websocket v1.4.0"
	"github.com/grokify/html-strip-tags-go 025bd76"
	"github.com/grpc-ecosystem/go-grpc-middleware v1.0.0"
	"github.com/grpc-ecosystem/go-grpc-prometheus v1.2.0"
	"github.com/grpc-ecosystem/grpc-gateway v1.9.0"
	"github.com/hashicorp/golang-lru v0.5.0"
	"github.com/hashicorp/hcl v1.0.0"
	"github.com/hpcloud/tail v1.0.0"
	"github.com/inconshreveable/log15 67afb5e"
	"github.com/inconshreveable/mousetrap v1.0.0"
	"github.com/jinzhu/gorm v1.9.10"
	"github.com/jinzhu/inflection v1.0.0"
	"github.com/jinzhu/now v1.0.1"
	"github.com/jonboulle/clockwork v0.1.0"
	"github.com/jstemmer/go-junit-report af01ea7"
	"github.com/julienschmidt/httprouter v1.2.0"
	"github.com/kisielk/errcheck v1.1.0"
	"github.com/kisielk/gotool v1.0.0"
	"github.com/konsorten/go-windows-terminal-sequences v1.0.1"
	"github.com/kr/logfmt b84e30a"
	"github.com/kr/pretty v0.1.0"
	"github.com/kr/pty v1.1.1"
	"github.com/kr/text v0.1.0"
	"github.com/labstack/echo v3.3.10"
	"github.com/labstack/gommon v0.2.9"
	"github.com/lib/pq v1.1.1"
	"github.com/magiconair/properties v1.8.0"
	"github.com/mattn/go-colorable v0.1.2"
	"github.com/mattn/go-isatty v0.0.8"
	"github.com/mattn/go-runewidth v0.0.4"
	"github.com/mattn/go-sqlite3 v1.10.0"
	"github.com/matttproud/golang_protobuf_extensions v1.0.1"
	"github.com/mitchellh/go-homedir v1.1.0"
	"github.com/mitchellh/mapstructure v1.1.2"
	"github.com/moul/http2curl v1.0.0"
	"github.com/mwitkow/go-conntrack cc309e4"
	"github.com/oklog/ulid v1.3.1"
	"github.com/onsi/ginkgo v1.7.0"
	"github.com/onsi/gomega v1.4.3"
	"github.com/openzipkin/zipkin-go v0.1.6"
	"github.com/parnurzeal/gorequest v0.2.15"
	"github.com/pelletier/go-toml v1.2.0"
	"github.com/pierrec/lz4 v2.0.5"
	"github.com/pkg/errors v0.8.1"
	"github.com/pmezard/go-difflib v1.0.0"
	"github.com/prometheus/client_golang v0.9.3"
	"github.com/prometheus/client_model fd36f42"
	"github.com/prometheus/common v0.4.0"
	"github.com/prometheus/procfs 5867b95"
	"github.com/prometheus/tsdb v0.7.1"
	"github.com/rcrowley/go-metrics 3113b84"
	"github.com/rogpeppe/fastuuid 6724a57"
	"github.com/russross/blackfriday v1.5.2"
	"github.com/sirupsen/logrus v1.2.0"
	"github.com/soheilhy/cmux v0.1.4"
	"github.com/spaolacci/murmur3 f09979e"
	"github.com/spf13/afero v1.1.2"
	"github.com/spf13/cast v1.3.0"
	"github.com/spf13/cobra v0.0.5"
	"github.com/spf13/jwalterweatherman v1.0.0"
	"github.com/spf13/pflag v1.0.3"
	"github.com/spf13/viper v1.4.0"
	"github.com/stretchr/objx v0.2.0"
	"github.com/stretchr/testify v1.3.0"
	"github.com/tealeg/xlsx v1.0.3"
	"github.com/tmc/grpc-websocket-proxy 0ad062e"
	"github.com/ugorji/go v1.1.4"
	"github.com/valyala/bytebufferpool v1.0.0"
	"github.com/valyala/fasttemplate v1.0.1"
	"github.com/xiang90/probing 43a291a"
	"github.com/xordataexchange/crypt v0.0.2"
	"go.etcd.io/bbolt v1.3.2 github.com/etcd-io/bbolt"
	"go.opencensus.io v0.20.1 github.com/census-instrumentation/opencensus-go"
	"go.uber.org/atomic v1.4.0 github.com/uber-go/atomic"
	"go.uber.org/multierr v1.1.0 github.com/uber-go/multierr"
	"go.uber.org/zap v1.10.0 github.com/uber-go/zap"
	"golang.org/x/crypto 20be4c3c3ed5 github.com/golang/crypto"
	"golang.org/x/net 1617124 github.com/golang/net"
	"golang.org/x/oauth2 0f29369 github.com/golang/oauth2"
	"golang.org/x/sys fde4db37ae7a github.com/golang/sys"
	"gopkg.in/VividCortex/ewma.v1 v1.1.1 github.com/VividCortex/ewma"
	"gopkg.in/alecthomas/kingpin.v2 v2.2.6 github.com/alecthomas/kingpin"
	"gopkg.in/check.v1 788fd78 github.com/go-check/check"
	"gopkg.in/cheggaaa/pb.v1 v1.0.28 github.com/cheggaaa/pb"
	"gopkg.in/cheggaaa/pb.v2 v2.0.7 github.com/cheggaaa/pb"
	"gopkg.in/fatih/color.v1 v1.7.0 github.com/fatih/color"
	"gopkg.in/fsnotify.v1 v1.4.7 github.com/fsnotify/fsnotify"
	"gopkg.in/mattn/go-colorable.v0 v0.1.0 github.com/mattn/go-colorable"
	"gopkg.in/mattn/go-isatty.v0 v0.0.6 github.com/mattn/go-isatty"
	"gopkg.in/mattn/go-runewidth.v0 v0.0.4  github.com/mattn/go-runewidth"
	"gopkg.in/resty.v1 v1.12.0 github.com/go-resty/resty"
	"gopkg.in/tomb.v1 dd63297 github.com/go-tomb/tomb"
	"gopkg.in/yaml.v2 v2.2.2 github.com/go-yaml/yaml"
	"honnef.co/go/tools 3f1c825 github.com/dominikh/go-tools"
)

inherit golang-vcs-snapshot

DESCRIPTION="Build a local copy of Security Tracker. Notify via Email if there is an update"
HOMEPAGE="https://vuls.io https://github.com/knqyf263/gost"

SRC_URI="https://github.com/knqyf263/gost/archive/v${PV}.tar.gz -> ${P}.tar.gz
	${EGO_VENDOR_URI}"

KEYWORDS="~amd64"
LICENSE="Apache-2.0"
IUSE="policykit"
RESTRICT="mirror"
SLOT=0

RDEPEND="
	policykit? (
		acct-group/vuls
		acct-user/vuls
		sys-auth/polkit
	)"
DEPEND="
	dev-go/go-text:=
	dev-go/go-tools:=
	>=dev-lang/go-1.12"

src_prepare() {
	cp "${FILESDIR}"/gost-daemon.initd "${T}" || die

	if ! use policykit; then
		sed -e "s/^USER=\"vuls\"/USER=\"root\"/" \
			-e "s/^GROUP=\"vuls\"/GROUP=\"root\"/" \
			-i "${T}"/gost-daemon.initd || die
	fi

	eapply "${FILESDIR}"/${P}_change_default_log_dir.patch

	default
}

src_compile() {
	GOPATH="${S}:$(get_golibdir_gopath)" \
		GOCACHE="${T}/go-cache" \
		go build -v -work -x -ldflags="-X main.revision=${PV} -s -w" ./... "${EGO_PN}" || die
}

src_install() {
	GOPATH="${S}:$(get_golibdir_gopath)" \
		GOCACHE="${T}/go-cache" \
		go install -v -work -x -ldflags="-X main.revision=${PV} -s -w" ./... "${EGO_PN}" || die

	rm -rf "${S}/src/${EGO_PN}/vendor" || die
	golang_install_pkgs

	exeinto "$(get_golibdir_gopath)"/bin
	doexe bin/${PN}

	newinitd "${T}"/gost-daemon.initd gost-daemon
	newconfd "${FILESDIR}"/gost-daemon.confd gost-daemon

	if use policykit; then
		insinto "/usr/share/polkit-1/rules.d"
		doins "${FILESDIR}"/polkit/10-${PN}.rules

		insinto "/usr/share/polkit-1/actions"
		doins "${FILESDIR}"/polkit/io.vuls.pkexec.${PN}.policy

		dodir "/usr/bin"
		cat > "${D}/usr/bin/${PN}" <<-_EOF_ || die
			#!/bin/sh
			pkexec --user vuls "$(get_golibdir_gopath)/bin/${PN}" "\$@"
		_EOF_

		fperms 0755 "/usr/bin/${PN}"
	else
		dosym "$(get_golibdir_gopath)/bin/${PN}" "/usr/bin/${PN}"
	fi

	keepdir "/var/log/vuls" "/var/lib/vuls"

	dodoc src/"${EGO_PN}"/{README.md,Dockerfile}
}

pkg_postinst() {
	if use policykit; then
		chown -R vuls:vuls \
			"${EROOT%/}/var/log/vuls" || die

		chmod 0750 \
			"${EROOT%/}/var/log/vuls" || die
	fi
}
