# Copyright 1999-2020 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=7

# TODO: drop py2
PYTHON_COMPAT=( python2_7 )

inherit eutils python-single-r1

DESCRIPTION="BDF allows to patch executable binaries with user desired shellcode"
HOMEPAGE="https://github.com/secretsquirrel/the-backdoor-factory"
SRC_URI="https://github.com/secretsquirrel/the-backdoor-factory/archive/${PV}.tar.gz -> ${P}.tar.gz"

KEYWORDS="~amd64 ~x86"
LICENSE="BSD-4"
SLOT="0"

DEPEND="${PYTHON_DEPS}"
RDEPEND="${DEPEND}
	app-crypt/osslsigncode
	$(python_gen_cond_dep '
		dev-libs/capstone[python,${PYTHON_MULTI_USEDEP}]
		dev-python/pefile[${PYTHON_MULTI_USEDEP}]
	')"

pkg_setup() {
	python-single-r1_pkg_setup
}

src_prepare(){
	eapply "${FILESDIR}"/pebin.patch

	# cleanup
	rm -r osslsigncode || die
	rm {update.sh,install.sh} || die

	# use built-in certs
	cp "${FILESDIR}"/certs/* ./certs/

	python_fix_shebang "${S}"

	default
}

src_compile() {
	pushd aPLib/example >/dev/null || die
	$(tc-getCC) -c -I../lib/elf -m32 -Wall -o appack.o appack.c -v || die
	$(tc-getCC) -m32 -Wall -o appack appack.o ../lib/elf/aplib.a -v || die
	popd >/dev/null || die
}

src_install() {
	insinto "/usr/share/${PN}"
	doins -r *

	python_optimize "${D}/usr/share/${PN}"

	dobin aPLib/example/appack
	make_wrapper $PN \
		"${PYTHON} /usr/share/${PN}/backdoor.py"

	dodoc README.md
}
