# Copyright 1999-2019 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=7

PYTHON_COMPAT=( python3_{5,6,7} )

inherit python-r1

DESCRIPTION="A tool to gain Domain Admin rights with a push of a button"
HOMEPAGE="https://github.com/byt3bl33d3r/DeathStar"

HASH_COMMIT="04356101ec8e9466bc72f8846fd7d83ccac98ba8"
SRC_URI="https://github.com/byt3bl33d3r/DeathStar/archive/${HASH_COMMIT}.tar.gz -> ${P}.tar.gz"

KEYWORDS="~amd64 ~x86"
LICENSE="GPL-3"
SLOT="0"

RDEPEND="${PYTHON_DEPS}
	app-exploits/empire
	dev-python/requests[${PYTHON_USEDEP}]
	dev-python/termcolor[${PYTHON_USEDEP}]
	dev-python/pyopenssl[${PYTHON_USEDEP}]"

S="${WORKDIR}/DeathStar-${HASH_COMMIT}"

src_prepare() {
	sed -i \
		-e "s/__version__ = '\(.*\)'/__version__ = '${PV}'/" \
		DeathStar.py || die

	default
}

src_install() {
	python_foreach_impl python_newscript DeathStar.py $PN
	dodoc README.md
}

pkg_postinst() {
	einfo "\nSee the following URL:"
	einfo " * https://byt3bl33d3r.github.io/automating-the-empire-with-the-death-star-getting-domain-admin-with-a-push-of-a-button.html\n"
}
